﻿using PhpVH.LexicalAnalysis;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace LexerTestGenerator
{
    public static class Tokens
    {
        public static Tuple<PhpTokenType, string>[] GetTokens()
        {
            return new[]
            {
Tuple.Create(PhpTokenType.Ampersand,"&"),
Tuple.Create(PhpTokenType.Comma,","),
Tuple.Create(PhpTokenType.ColonOperator,":"),
Tuple.Create(PhpTokenType.ScopeResolutionOperator,"::"),
Tuple.Create(PhpTokenType.ObjectOperator,"->"),
Tuple.Create(PhpTokenType.KeyValueOperator,"=>"),
Tuple.Create(PhpTokenType.Namespace,"\\"),
Tuple.Create(PhpTokenType.ErrorSuppressor,"@"),
Tuple.Create(PhpTokenType.LeftParenthesis,"("),
Tuple.Create(PhpTokenType.RightParenthesis,")"),
Tuple.Create(PhpTokenType.LeftBracket,"["),
Tuple.Create(PhpTokenType.RightBracket,"]"),
Tuple.Create(PhpTokenType.LeftBrace,"{"),
Tuple.Create(PhpTokenType.RightBrace,"}"),
Tuple.Create(PhpTokenType.MinusOperator,"-"),
Tuple.Create(PhpTokenType.AssignmentOperator,"="),
Tuple.Create(PhpTokenType.PlusEqualOperator,"+="),
Tuple.Create(PhpTokenType.MinusEqualOperator,"-="),
Tuple.Create(PhpTokenType.MultiplicationEqualOperator,"*="),
Tuple.Create(PhpTokenType.DivisionEqualOperator,"/="),
Tuple.Create(PhpTokenType.ModulusEqualOperator,"%="),
Tuple.Create(PhpTokenType.ConcatEqualOperator,".="),
Tuple.Create(PhpTokenType.OrEqualOperator,"|="),
Tuple.Create(PhpTokenType.XorEqualOperator,"^="),
Tuple.Create(PhpTokenType.AdditionOperator,"+"),
Tuple.Create(PhpTokenType.MultiplicationOperator,"*"),
Tuple.Create(PhpTokenType.DivisionOperator,"/"),
Tuple.Create(PhpTokenType.ModulusOperator,"%"),
Tuple.Create(PhpTokenType.IncrementOperator,"++"),
Tuple.Create(PhpTokenType.DecrementOperator,"--"),
Tuple.Create(PhpTokenType.OrOperator,"|"),
Tuple.Create(PhpTokenType.XorOperator,"^"),
Tuple.Create(PhpTokenType.ComplementOperator,"~"),
Tuple.Create(PhpTokenType.ShiftLeft,"<<"),
Tuple.Create(PhpTokenType.ShiftRight,">>"),
Tuple.Create(PhpTokenType.StringConcatOperator,"."),
Tuple.Create(PhpTokenType.NotOperator,"!"),
Tuple.Create(PhpTokenType.AndOperator,"&&"),
Tuple.Create(PhpTokenType.OrOperator,"||"),
Tuple.Create(PhpTokenType.EqualityOperator,"=="),
Tuple.Create(PhpTokenType.IdenticalOperator,"==="),
Tuple.Create(PhpTokenType.NotEqualOperator,"!="),
Tuple.Create(PhpTokenType.NotEqualOperator,"<>"),
Tuple.Create(PhpTokenType.NotIdenticalOperator,"!=="),
Tuple.Create(PhpTokenType.LessThanOperator,"<"),
Tuple.Create(PhpTokenType.GreaterThanOperator,">"),
Tuple.Create(PhpTokenType.LessThanOrEqualOperator,"<="),
Tuple.Create(PhpTokenType.GreaterThanOrEqualOperator,">="),
Tuple.Create(PhpTokenType.TernaryOperator,"?"),
Tuple.Create(PhpTokenType.EndOfStatement,";"),
Tuple.Create(PhpTokenType.WhiteSpace,"\x0D"),
Tuple.Create(PhpTokenType.WhiteSpace,"\x0A"),
Tuple.Create(PhpTokenType.WhiteSpace,"\x09"),
Tuple.Create(PhpTokenType.WhiteSpace,"\x0B"),
Tuple.Create(PhpTokenType.WhiteSpace,"\x20"),
Tuple.Create(PhpTokenType.abstractKeyword,"abstract"),
Tuple.Create(PhpTokenType.andKeyword,"and"),
Tuple.Create(PhpTokenType.arrayKeyword,"array"),
Tuple.Create(PhpTokenType.asKeyword,"as"),
Tuple.Create(PhpTokenType.breakKeyword,"break"),
Tuple.Create(PhpTokenType.caseKeyword,"case"),
Tuple.Create(PhpTokenType.catchKeyword,"catch"),
Tuple.Create(PhpTokenType.cfunctionKeyword,"cfunction"),
Tuple.Create(PhpTokenType.classKeyword,"class"),
Tuple.Create(PhpTokenType.cloneKeyword,"clone"),
Tuple.Create(PhpTokenType.constKeyword,"const"),
Tuple.Create(PhpTokenType.continueKeyword,"continue"),
Tuple.Create(PhpTokenType.declareKeyword,"declare"),
Tuple.Create(PhpTokenType.defaultKeyword,"default"),
Tuple.Create(PhpTokenType.doKeyword,"do"),
Tuple.Create(PhpTokenType.elseKeyword,"else"),
Tuple.Create(PhpTokenType.elseifKeyword,"elseif"),
Tuple.Create(PhpTokenType.enddeclareKeyword,"enddeclare"),
Tuple.Create(PhpTokenType.endforKeyword,"endfor"),
Tuple.Create(PhpTokenType.endforeachKeyword,"endforeach"),
Tuple.Create(PhpTokenType.endifKeyword,"endif"),
Tuple.Create(PhpTokenType.endswitchKeyword,"endswitch"),
Tuple.Create(PhpTokenType.endwhileKeyword,"endwhile"),
Tuple.Create(PhpTokenType.extendsKeyword,"extends"),
Tuple.Create(PhpTokenType.finalKeyword,"final"),
Tuple.Create(PhpTokenType.forKeyword,"for"),
Tuple.Create(PhpTokenType.foreachKeyword,"foreach"),
Tuple.Create(PhpTokenType.functionKeyword,"function"),
Tuple.Create(PhpTokenType.globalKeyword,"global"),
Tuple.Create(PhpTokenType.gotoKeyword,"goto"),
Tuple.Create(PhpTokenType.ifKeyword,"if"),
Tuple.Create(PhpTokenType.implementsKeyword,"implements"),
Tuple.Create(PhpTokenType.interfaceKeyword,"interface"),
Tuple.Create(PhpTokenType.instanceofKeyword,"instanceof"),
Tuple.Create(PhpTokenType.namespaceKeyword,"namespace"),
Tuple.Create(PhpTokenType.newKeyword,"new"),
Tuple.Create(PhpTokenType.old_functionKeyword,"old_function"),
Tuple.Create(PhpTokenType.orKeyword,"or"),
Tuple.Create(PhpTokenType.privateKeyword,"private"),
Tuple.Create(PhpTokenType.protectedKeyword,"protected"),
Tuple.Create(PhpTokenType.publicKeyword,"public"),
Tuple.Create(PhpTokenType.staticKeyword,"static"),
Tuple.Create(PhpTokenType.switchKeyword,"switch"),
Tuple.Create(PhpTokenType.throwKeyword,"throw"),
Tuple.Create(PhpTokenType.tryKeyword,"try"),
Tuple.Create(PhpTokenType.useKeyword,"use"),
Tuple.Create(PhpTokenType.varKeyword,"var"),
Tuple.Create(PhpTokenType.whileKeyword,"while"),
Tuple.Create(PhpTokenType.xorKeyword,"xor"),
            };
        }
    }
}
