from datetime import datetime
from typing import Union

from prowler.config.config import prowler_version
from prowler.lib.check.models import CheckMetadata, Code, Recommendation, Remediation
from prowler.lib.outputs.finding import Finding
from tests.providers.aws.utils import AWS_ACCOUNT_NUMBER, AWS_REGION_EU_WEST_1


def generate_finding_output(
    status: str = "PASS",
    status_extended: str = "",
    severity: str = "high",
    muted: bool = False,
    account_uid: str = AWS_ACCOUNT_NUMBER,
    account_name: str = AWS_ACCOUNT_NUMBER,
    region: str = AWS_REGION_EU_WEST_1,
    resource_details: str = "",
    resource_uid: str = "",
    resource_name: str = "",
    resource_tags: dict = {},
    compliance: dict = {"test-compliance": "test-compliance"},
    timestamp: Union[int, datetime] = None,
    provider: str = "aws",
    partition: str = "aws",
    description: str = "check description",
    risk: str = "test-risk",
    related_url: str = "test-url",
    remediation_recommendation_text: str = "",
    remediation_recommendation_url: str = "",
    remediation_code_nativeiac: str = "",
    remediation_code_terraform: str = "",
    remediation_code_cli: str = "",
    remediation_code_other: str = "",
    categories: list[str] = ["test-category"],
    depends_on: list[str] = ["test-dependency"],
    related_to: list[str] = ["test-related-to"],
    notes: str = "test-notes",
    additional_urls: list[str] = [
        "https://docs.aws.amazon.com/prescriptive-guidance/latest/migration-operations-integration/best-practices.html",
        "https://docs.aws.amazon.com/prescriptive-guidance/latest/migration-operations-integration/introduction.html",
    ],
    service_name: str = "service",
    check_id: str = "service_test_check_id",
    check_title: str = "service_test_check_id",
    check_type: list[str] = ["test-type"],
) -> Finding:
    return Finding(
        auth_method="profile: default",
        timestamp=timestamp if timestamp else datetime.now(),
        account_uid=account_uid,
        account_name=account_name,
        account_email="",
        account_organization_uid="test-organization-id",
        account_organization_name="test-organization",
        account_tags={"test-tag": "test-value"},
        uid="test-unique-finding",
        status=status,
        status_extended=status_extended,
        muted=muted,
        resource_uid=resource_uid,
        resource_name=resource_name,
        resource_details=resource_details,
        resource_tags=resource_tags,
        partition=partition,
        region=region,
        compliance=compliance,
        metadata=CheckMetadata(
            Provider=provider,
            CheckID=check_id,
            CheckTitle=check_title,
            CheckType=check_type,
            ResourceType="test-resource",
            ServiceName=service_name,
            SubServiceName="",
            ResourceIdTemplate="",
            Severity=severity,
            Description=description,
            Risk=risk,
            RelatedUrl=related_url,
            Remediation=Remediation(
                Recommendation=Recommendation(
                    Text=remediation_recommendation_text,
                    Url=remediation_recommendation_url,
                ),
                Code=Code(
                    NativeIaC=remediation_code_nativeiac,
                    Terraform=remediation_code_terraform,
                    Other=remediation_code_other,
                    CLI=remediation_code_cli,
                ),
            ),
            DependsOn=depends_on,
            RelatedTo=related_to,
            Categories=categories,
            Notes=notes,
            AdditionalURLs=additional_urls,
        ),
        prowler_version=prowler_version,
    )
