# The PEP 484 type hints stub file for the QtGui module.
#
# Generated by SIP 4.19.25
#
# Copyright (c) 2018 Riverbank Computing Limited <info@riverbankcomputing.com>
# 
# This file is part of PyQt4.
# 
# This file may be used under the terms of the GNU General Public License
# version 3.0 as published by the Free Software Foundation and appearing in
# the file LICENSE included in the packaging of this file.  Please review the
# following information to ensure the GNU General Public License version 3.0
# requirements will be met: http://www.gnu.org/copyleft/gpl.html.
# 
# If you do not wish to use this file under the terms of the GPL version 3.0
# then you may purchase a commercial license.  For more information contact
# info@riverbankcomputing.com.
# 
# This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
# WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.


import typing
import sip

from PyQt4 import QtCore

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[typing.Callable[..., None], QtCore.pyqtBoundSignal]

# Support for old-style signals and slots.
QT_SIGNAL = str
QT_SLOT = str


class QPaintDevice(sip.simplewrapper):

    class PaintDeviceMetric(int): ...
    PdmWidth = ... # type: 'QPaintDevice.PaintDeviceMetric'
    PdmHeight = ... # type: 'QPaintDevice.PaintDeviceMetric'
    PdmWidthMM = ... # type: 'QPaintDevice.PaintDeviceMetric'
    PdmHeightMM = ... # type: 'QPaintDevice.PaintDeviceMetric'
    PdmNumColors = ... # type: 'QPaintDevice.PaintDeviceMetric'
    PdmDepth = ... # type: 'QPaintDevice.PaintDeviceMetric'
    PdmDpiX = ... # type: 'QPaintDevice.PaintDeviceMetric'
    PdmDpiY = ... # type: 'QPaintDevice.PaintDeviceMetric'
    PdmPhysicalDpiX = ... # type: 'QPaintDevice.PaintDeviceMetric'
    PdmPhysicalDpiY = ... # type: 'QPaintDevice.PaintDeviceMetric'

    def __init__(self) -> None: ...

    def metric(self, metric: 'QPaintDevice.PaintDeviceMetric') -> int: ...
    def colorCount(self) -> int: ...
    def paintingActive(self) -> bool: ...
    def depth(self) -> int: ...
    def numColors(self) -> int: ...
    def physicalDpiY(self) -> int: ...
    def physicalDpiX(self) -> int: ...
    def logicalDpiY(self) -> int: ...
    def logicalDpiX(self) -> int: ...
    def heightMM(self) -> int: ...
    def widthMM(self) -> int: ...
    def height(self) -> int: ...
    def width(self) -> int: ...
    def paintEngine(self) -> 'QPaintEngine': ...


class QWidget(QtCore.QObject, QPaintDevice):

    class RenderFlag(int): ...
    DrawWindowBackground = ... # type: 'QWidget.RenderFlag'
    DrawChildren = ... # type: 'QWidget.RenderFlag'
    IgnoreMask = ... # type: 'QWidget.RenderFlag'

    class RenderFlags(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QWidget.RenderFlags', 'QWidget.RenderFlag']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QWidget.RenderFlags') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QWidget.RenderFlags': ...
        def __int__(self) -> int: ...

    def __init__(self, parent: typing.Optional['QWidget'] = ..., flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def setInputMethodHints(self, hints: typing.Union[QtCore.Qt.InputMethodHints, QtCore.Qt.InputMethodHint]) -> None: ...
    def inputMethodHints(self) -> QtCore.Qt.InputMethodHints: ...
    def previousInFocusChain(self) -> 'QWidget': ...
    def contentsMargins(self) -> QtCore.QMargins: ...
    def ungrabGesture(self, type: QtCore.Qt.GestureType) -> None: ...
    def grabGesture(self, type: QtCore.Qt.GestureType, flags: typing.Union[QtCore.Qt.GestureFlags, QtCore.Qt.GestureFlag] = ...) -> None: ...
    def setGraphicsEffect(self, effect: 'QGraphicsEffect') -> None: ...
    def graphicsEffect(self) -> 'QGraphicsEffect': ...
    def graphicsProxyWidget(self) -> 'QGraphicsProxyWidget': ...
    def windowFilePath(self) -> str: ...
    def setWindowFilePath(self, filePath: str) -> None: ...
    def nativeParentWidget(self) -> 'QWidget': ...
    def effectiveWinId(self) -> int: ...
    def unsetLocale(self) -> None: ...
    def locale(self) -> QtCore.QLocale: ...
    def setLocale(self, locale: QtCore.QLocale) -> None: ...
    @typing.overload
    def render(self, target: QPaintDevice, targetOffset: QtCore.QPoint = ..., sourceRegion: 'QRegion' = ..., flags: 'QWidget.RenderFlags' = ...) -> None: ...
    @typing.overload
    def render(self, painter: 'QPainter', targetOffset: QtCore.QPoint = ..., sourceRegion: 'QRegion' = ..., flags: 'QWidget.RenderFlags' = ...) -> None: ...
    def restoreGeometry(self, geometry: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> bool: ...
    def saveGeometry(self) -> QtCore.QByteArray: ...
    def setShortcutAutoRepeat(self, id: int, enabled: bool = ...) -> None: ...
    def styleSheet(self) -> str: ...
    def setStyleSheet(self, styleSheet: str) -> None: ...
    def setAutoFillBackground(self, enabled: bool) -> None: ...
    def autoFillBackground(self) -> bool: ...
    def setWindowModality(self, windowModality: QtCore.Qt.WindowModality) -> None: ...
    def windowModality(self) -> QtCore.Qt.WindowModality: ...
    def testAttribute(self, attribute: QtCore.Qt.WidgetAttribute) -> bool: ...
    def parentWidget(self) -> 'QWidget': ...
    def height(self) -> int: ...
    def width(self) -> int: ...
    def size(self) -> QtCore.QSize: ...
    def geometry(self) -> QtCore.QRect: ...
    def rect(self) -> QtCore.QRect: ...
    def isHidden(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def updatesEnabled(self) -> bool: ...
    def underMouse(self) -> bool: ...
    def hasMouseTracking(self) -> bool: ...
    def setMouseTracking(self, enable: bool) -> None: ...
    def fontInfo(self) -> 'QFontInfo': ...
    def fontMetrics(self) -> 'QFontMetrics': ...
    def font(self) -> 'QFont': ...
    def maximumHeight(self) -> int: ...
    def maximumWidth(self) -> int: ...
    def minimumHeight(self) -> int: ...
    def minimumWidth(self) -> int: ...
    def isEnabledToTLW(self) -> bool: ...
    def isModal(self) -> bool: ...
    def isEnabled(self) -> bool: ...
    def isWindow(self) -> bool: ...
    def isTopLevel(self) -> bool: ...
    def winId(self) -> int: ...
    def windowFlags(self) -> QtCore.Qt.WindowFlags: ...
    def windowType(self) -> QtCore.Qt.WindowType: ...
    def languageChange(self) -> None: ...
    def windowActivationChange(self, a0: bool) -> None: ...
    def fontChange(self, a0: 'QFont') -> None: ...
    def paletteChange(self, a0: 'QPalette') -> None: ...
    def enabledChange(self, a0: bool) -> None: ...
    def focusPreviousChild(self) -> bool: ...
    def focusNextChild(self) -> bool: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def destroy(self, destroyWindow: bool = ..., destroySubWindows: bool = ...) -> None: ...
    def create(self, window: int = ..., initializeWindow: bool = ..., destroyOldWindow: bool = ...) -> None: ...
    def updateMicroFocus(self) -> None: ...
    def resetInputContext(self) -> None: ...
    def inputMethodQuery(self, a0: QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def inputMethodEvent(self, a0: 'QInputMethodEvent') -> None: ...
    def metric(self, a0: QPaintDevice.PaintDeviceMetric) -> int: ...
    def changeEvent(self, a0: QtCore.QEvent) -> None: ...
    def hideEvent(self, a0: 'QHideEvent') -> None: ...
    def showEvent(self, a0: 'QShowEvent') -> None: ...
    def dropEvent(self, a0: 'QDropEvent') -> None: ...
    def dragLeaveEvent(self, a0: 'QDragLeaveEvent') -> None: ...
    def dragMoveEvent(self, a0: 'QDragMoveEvent') -> None: ...
    def dragEnterEvent(self, a0: 'QDragEnterEvent') -> None: ...
    def actionEvent(self, a0: 'QActionEvent') -> None: ...
    def tabletEvent(self, a0: 'QTabletEvent') -> None: ...
    def contextMenuEvent(self, a0: 'QContextMenuEvent') -> None: ...
    def closeEvent(self, a0: 'QCloseEvent') -> None: ...
    def resizeEvent(self, a0: 'QResizeEvent') -> None: ...
    def moveEvent(self, a0: 'QMoveEvent') -> None: ...
    def paintEvent(self, a0: 'QPaintEvent') -> None: ...
    def leaveEvent(self, a0: QtCore.QEvent) -> None: ...
    def enterEvent(self, a0: QtCore.QEvent) -> None: ...
    def focusOutEvent(self, a0: 'QFocusEvent') -> None: ...
    def focusInEvent(self, a0: 'QFocusEvent') -> None: ...
    def keyReleaseEvent(self, a0: 'QKeyEvent') -> None: ...
    def keyPressEvent(self, a0: 'QKeyEvent') -> None: ...
    def wheelEvent(self, a0: 'QWheelEvent') -> None: ...
    def mouseMoveEvent(self, a0: 'QMouseEvent') -> None: ...
    def mouseDoubleClickEvent(self, a0: 'QMouseEvent') -> None: ...
    def mouseReleaseEvent(self, a0: 'QMouseEvent') -> None: ...
    def mousePressEvent(self, a0: 'QMouseEvent') -> None: ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    def customContextMenuRequested(self, pos: QtCore.QPoint) -> None: ...
    def isAncestorOf(self, child: 'QWidget') -> bool: ...
    def setInputContext(self, a0: 'QInputContext') -> None: ...
    def inputContext(self) -> 'QInputContext': ...
    def ensurePolished(self) -> None: ...
    def paintEngine(self) -> 'QPaintEngine': ...
    def setAttribute(self, attribute: QtCore.Qt.WidgetAttribute, on: bool = ...) -> None: ...
    def handle(self) -> int: ...
    def x11PictureHandle(self) -> int: ...
    def x11Info(self) -> 'QX11Info': ...
    @typing.overload
    def childAt(self, p: QtCore.QPoint) -> 'QWidget': ...
    @typing.overload
    def childAt(self, ax: int, ay: int) -> 'QWidget': ...
    @staticmethod
    def find(a0: int) -> 'QWidget': ...
    def overrideWindowFlags(self, type: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType]) -> None: ...
    def setWindowFlags(self, type: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType]) -> None: ...
    def actions(self) -> typing.List['QAction']: ...
    def removeAction(self, action: 'QAction') -> None: ...
    def insertActions(self, before: 'QAction', actions: typing.Sequence['QAction']) -> None: ...
    def insertAction(self, before: 'QAction', action: 'QAction') -> None: ...
    def addActions(self, actions: typing.Sequence['QAction']) -> None: ...
    def addAction(self, action: 'QAction') -> None: ...
    def setAcceptDrops(self, on: bool) -> None: ...
    def acceptDrops(self) -> bool: ...
    def nextInFocusChain(self) -> 'QWidget': ...
    def focusWidget(self) -> 'QWidget': ...
    @typing.overload
    def scroll(self, dx: int, dy: int) -> None: ...
    @typing.overload
    def scroll(self, dx: int, dy: int, a2: QtCore.QRect) -> None: ...
    @typing.overload
    def setParent(self, parent: 'QWidget') -> None: ...
    @typing.overload
    def setParent(self, parent: 'QWidget', f: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType]) -> None: ...
    def updateGeometry(self) -> None: ...
    def setLayout(self, a0: 'QLayout') -> None: ...
    def layout(self) -> 'QLayout': ...
    def contentsRect(self) -> QtCore.QRect: ...
    def getContentsMargins(self) -> typing.Tuple[int, int, int, int]: ...
    @typing.overload
    def setContentsMargins(self, left: int, top: int, right: int, bottom: int) -> None: ...
    @typing.overload
    def setContentsMargins(self, margins: QtCore.QMargins) -> None: ...
    def visibleRegion(self) -> 'QRegion': ...
    def heightForWidth(self, a0: int) -> int: ...
    @typing.overload
    def setSizePolicy(self, a0: 'QSizePolicy') -> None: ...
    @typing.overload
    def setSizePolicy(self, hor: 'QSizePolicy.Policy', ver: 'QSizePolicy.Policy') -> None: ...
    def sizePolicy(self) -> 'QSizePolicy': ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def overrideWindowState(self, state: typing.Union[QtCore.Qt.WindowStates, QtCore.Qt.WindowState]) -> None: ...
    def setWindowState(self, state: typing.Union[QtCore.Qt.WindowStates, QtCore.Qt.WindowState]) -> None: ...
    def windowState(self) -> QtCore.Qt.WindowStates: ...
    def isFullScreen(self) -> bool: ...
    def isMaximized(self) -> bool: ...
    def isMinimized(self) -> bool: ...
    def isVisibleTo(self, a0: 'QWidget') -> bool: ...
    def adjustSize(self) -> None: ...
    @typing.overload
    def setGeometry(self, a0: QtCore.QRect) -> None: ...
    @typing.overload
    def setGeometry(self, ax: int, ay: int, aw: int, ah: int) -> None: ...
    @typing.overload
    def resize(self, a0: QtCore.QSize) -> None: ...
    @typing.overload
    def resize(self, w: int, h: int) -> None: ...
    @typing.overload
    def move(self, a0: QtCore.QPoint) -> None: ...
    @typing.overload
    def move(self, ax: int, ay: int) -> None: ...
    def stackUnder(self, a0: 'QWidget') -> None: ...
    def lower(self) -> None: ...
    def raise_(self) -> None: ...
    def close(self) -> bool: ...
    def showNormal(self) -> None: ...
    def showFullScreen(self) -> None: ...
    def showMaximized(self) -> None: ...
    def showMinimized(self) -> None: ...
    def setShown(self, shown: bool) -> None: ...
    def hide(self) -> None: ...
    def show(self) -> None: ...
    def setHidden(self, hidden: bool) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    @typing.overload
    def repaint(self) -> None: ...
    @typing.overload
    def repaint(self, x: int, y: int, w: int, h: int) -> None: ...
    @typing.overload
    def repaint(self, a0: QtCore.QRect) -> None: ...
    @typing.overload
    def repaint(self, a0: 'QRegion') -> None: ...
    @typing.overload
    def update(self) -> None: ...
    @typing.overload
    def update(self, a0: QtCore.QRect) -> None: ...
    @typing.overload
    def update(self, a0: 'QRegion') -> None: ...
    @typing.overload
    def update(self, ax: int, ay: int, aw: int, ah: int) -> None: ...
    def setUpdatesEnabled(self, enable: bool) -> None: ...
    @staticmethod
    def keyboardGrabber() -> 'QWidget': ...
    @staticmethod
    def mouseGrabber() -> 'QWidget': ...
    def setShortcutEnabled(self, id: int, enabled: bool = ...) -> None: ...
    def releaseShortcut(self, id: int) -> None: ...
    def grabShortcut(self, key: typing.Union['QKeySequence', 'QKeySequence.StandardKey', str, int], context: QtCore.Qt.ShortcutContext = ...) -> int: ...
    def releaseKeyboard(self) -> None: ...
    def grabKeyboard(self) -> None: ...
    def releaseMouse(self) -> None: ...
    @typing.overload
    def grabMouse(self) -> None: ...
    @typing.overload
    def grabMouse(self, a0: typing.Union['QCursor', QtCore.Qt.CursorShape]) -> None: ...
    def setContextMenuPolicy(self, policy: QtCore.Qt.ContextMenuPolicy) -> None: ...
    def contextMenuPolicy(self) -> QtCore.Qt.ContextMenuPolicy: ...
    def focusProxy(self) -> 'QWidget': ...
    def setFocusProxy(self, a0: 'QWidget') -> None: ...
    @staticmethod
    def setTabOrder(a0: 'QWidget', a1: 'QWidget') -> None: ...
    def hasFocus(self) -> bool: ...
    def setFocusPolicy(self, policy: QtCore.Qt.FocusPolicy) -> None: ...
    def focusPolicy(self) -> QtCore.Qt.FocusPolicy: ...
    def clearFocus(self) -> None: ...
    def activateWindow(self) -> None: ...
    def isActiveWindow(self) -> bool: ...
    @typing.overload
    def setFocus(self) -> None: ...
    @typing.overload
    def setFocus(self, reason: QtCore.Qt.FocusReason) -> None: ...
    def isLeftToRight(self) -> bool: ...
    def isRightToLeft(self) -> bool: ...
    def unsetLayoutDirection(self) -> None: ...
    def layoutDirection(self) -> QtCore.Qt.LayoutDirection: ...
    def setLayoutDirection(self, direction: QtCore.Qt.LayoutDirection) -> None: ...
    def setAccessibleDescription(self, description: str) -> None: ...
    def accessibleDescription(self) -> str: ...
    def setAccessibleName(self, name: str) -> None: ...
    def accessibleName(self) -> str: ...
    def whatsThis(self) -> str: ...
    def setWhatsThis(self, a0: str) -> None: ...
    def statusTip(self) -> str: ...
    def setStatusTip(self, a0: str) -> None: ...
    def toolTip(self) -> str: ...
    def setToolTip(self, a0: str) -> None: ...
    def isWindowModified(self) -> bool: ...
    def windowOpacity(self) -> float: ...
    def setWindowOpacity(self, level: float) -> None: ...
    def windowRole(self) -> str: ...
    def setWindowRole(self, a0: str) -> None: ...
    def windowIconText(self) -> str: ...
    def setWindowIconText(self, a0: str) -> None: ...
    def windowIcon(self) -> 'QIcon': ...
    def setWindowIcon(self, icon: 'QIcon') -> None: ...
    def windowTitle(self) -> str: ...
    def setWindowTitle(self, a0: str) -> None: ...
    def clearMask(self) -> None: ...
    def mask(self) -> 'QRegion': ...
    @typing.overload
    def setMask(self, a0: 'QBitmap') -> None: ...
    @typing.overload
    def setMask(self, a0: 'QRegion') -> None: ...
    def unsetCursor(self) -> None: ...
    def setCursor(self, a0: typing.Union['QCursor', QtCore.Qt.CursorShape]) -> None: ...
    def cursor(self) -> 'QCursor': ...
    def setFont(self, a0: 'QFont') -> None: ...
    def foregroundRole(self) -> 'QPalette.ColorRole': ...
    def setForegroundRole(self, a0: 'QPalette.ColorRole') -> None: ...
    def backgroundRole(self) -> 'QPalette.ColorRole': ...
    def setBackgroundRole(self, a0: 'QPalette.ColorRole') -> None: ...
    def setPalette(self, a0: 'QPalette') -> None: ...
    def palette(self) -> 'QPalette': ...
    def topLevelWidget(self) -> 'QWidget': ...
    def window(self) -> 'QWidget': ...
    def mapFrom(self, a0: 'QWidget', a1: QtCore.QPoint) -> QtCore.QPoint: ...
    def mapTo(self, a0: 'QWidget', a1: QtCore.QPoint) -> QtCore.QPoint: ...
    def mapFromParent(self, a0: QtCore.QPoint) -> QtCore.QPoint: ...
    def mapToParent(self, a0: QtCore.QPoint) -> QtCore.QPoint: ...
    def mapFromGlobal(self, a0: QtCore.QPoint) -> QtCore.QPoint: ...
    def mapToGlobal(self, a0: QtCore.QPoint) -> QtCore.QPoint: ...
    def setFixedHeight(self, h: int) -> None: ...
    def setFixedWidth(self, w: int) -> None: ...
    @typing.overload
    def setFixedSize(self, a0: QtCore.QSize) -> None: ...
    @typing.overload
    def setFixedSize(self, w: int, h: int) -> None: ...
    @typing.overload
    def setBaseSize(self, basew: int, baseh: int) -> None: ...
    @typing.overload
    def setBaseSize(self, s: QtCore.QSize) -> None: ...
    def baseSize(self) -> QtCore.QSize: ...
    @typing.overload
    def setSizeIncrement(self, w: int, h: int) -> None: ...
    @typing.overload
    def setSizeIncrement(self, s: QtCore.QSize) -> None: ...
    def sizeIncrement(self) -> QtCore.QSize: ...
    def setMaximumHeight(self, maxh: int) -> None: ...
    def setMaximumWidth(self, maxw: int) -> None: ...
    def setMinimumHeight(self, minh: int) -> None: ...
    def setMinimumWidth(self, minw: int) -> None: ...
    @typing.overload
    def setMaximumSize(self, maxw: int, maxh: int) -> None: ...
    @typing.overload
    def setMaximumSize(self, s: QtCore.QSize) -> None: ...
    @typing.overload
    def setMinimumSize(self, minw: int, minh: int) -> None: ...
    @typing.overload
    def setMinimumSize(self, s: QtCore.QSize) -> None: ...
    def maximumSize(self) -> QtCore.QSize: ...
    def minimumSize(self) -> QtCore.QSize: ...
    def childrenRegion(self) -> 'QRegion': ...
    def childrenRect(self) -> QtCore.QRect: ...
    def frameSize(self) -> QtCore.QSize: ...
    def pos(self) -> QtCore.QPoint: ...
    def y(self) -> int: ...
    def x(self) -> int: ...
    def normalGeometry(self) -> QtCore.QRect: ...
    def frameGeometry(self) -> QtCore.QRect: ...
    def setWindowModified(self, a0: bool) -> None: ...
    def setDisabled(self, a0: bool) -> None: ...
    def setEnabled(self, a0: bool) -> None: ...
    def isEnabledTo(self, a0: 'QWidget') -> bool: ...
    def setStyle(self, a0: 'QStyle') -> None: ...
    def style(self) -> 'QStyle': ...
    def devType(self) -> int: ...


class QAbstractButton(QWidget):

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...

    def timerEvent(self, e: QtCore.QTimerEvent) -> None: ...
    def changeEvent(self, e: QtCore.QEvent) -> None: ...
    def focusOutEvent(self, e: 'QFocusEvent') -> None: ...
    def focusInEvent(self, e: 'QFocusEvent') -> None: ...
    def mouseMoveEvent(self, e: 'QMouseEvent') -> None: ...
    def mouseReleaseEvent(self, e: 'QMouseEvent') -> None: ...
    def mousePressEvent(self, e: 'QMouseEvent') -> None: ...
    def keyReleaseEvent(self, e: 'QKeyEvent') -> None: ...
    def keyPressEvent(self, e: 'QKeyEvent') -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def nextCheckState(self) -> None: ...
    def checkStateSet(self) -> None: ...
    def hitButton(self, pos: QtCore.QPoint) -> bool: ...
    def paintEvent(self, e: 'QPaintEvent') -> None: ...
    def toggled(self, checked: bool) -> None: ...
    def clicked(self, checked: bool = ...) -> None: ...
    def released(self) -> None: ...
    def pressed(self) -> None: ...
    def setChecked(self, a0: bool) -> None: ...
    def toggle(self) -> None: ...
    def click(self) -> None: ...
    def animateClick(self, msecs: int = ...) -> None: ...
    def setIconSize(self, size: QtCore.QSize) -> None: ...
    def group(self) -> 'QButtonGroup': ...
    def autoExclusive(self) -> bool: ...
    def setAutoExclusive(self, a0: bool) -> None: ...
    def autoRepeat(self) -> bool: ...
    def setAutoRepeat(self, a0: bool) -> None: ...
    def isDown(self) -> bool: ...
    def setDown(self, a0: bool) -> None: ...
    def isChecked(self) -> bool: ...
    def isCheckable(self) -> bool: ...
    def setCheckable(self, a0: bool) -> None: ...
    def shortcut(self) -> 'QKeySequence': ...
    def setShortcut(self, key: typing.Union['QKeySequence', 'QKeySequence.StandardKey', str, int]) -> None: ...
    def iconSize(self) -> QtCore.QSize: ...
    def icon(self) -> 'QIcon': ...
    def setIcon(self, icon: 'QIcon') -> None: ...
    def text(self) -> str: ...
    def setText(self, text: str) -> None: ...
    def autoRepeatInterval(self) -> int: ...
    def setAutoRepeatInterval(self, a0: int) -> None: ...
    def autoRepeatDelay(self) -> int: ...
    def setAutoRepeatDelay(self, a0: int) -> None: ...


class QAbstractItemDelegate(QtCore.QObject):

    class EndEditHint(int): ...
    NoHint = ... # type: 'QAbstractItemDelegate.EndEditHint'
    EditNextItem = ... # type: 'QAbstractItemDelegate.EndEditHint'
    EditPreviousItem = ... # type: 'QAbstractItemDelegate.EndEditHint'
    SubmitModelCache = ... # type: 'QAbstractItemDelegate.EndEditHint'
    RevertModelCache = ... # type: 'QAbstractItemDelegate.EndEditHint'

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def sizeHintChanged(self, a0: QtCore.QModelIndex) -> None: ...
    def closeEditor(self, editor: QWidget, hint: 'QAbstractItemDelegate.EndEditHint' = ...) -> None: ...
    def commitData(self, editor: QWidget) -> None: ...
    def helpEvent(self, event: 'QHelpEvent', view: 'QAbstractItemView', option: 'QStyleOptionViewItem', index: QtCore.QModelIndex) -> bool: ...
    @staticmethod
    def elidedText(fontMetrics: 'QFontMetrics', width: int, mode: QtCore.Qt.TextElideMode, text: str) -> str: ...
    def editorEvent(self, event: QtCore.QEvent, model: QtCore.QAbstractItemModel, option: 'QStyleOptionViewItem', index: QtCore.QModelIndex) -> bool: ...
    def updateEditorGeometry(self, editor: QWidget, option: 'QStyleOptionViewItem', index: QtCore.QModelIndex) -> None: ...
    def setModelData(self, editor: QWidget, model: QtCore.QAbstractItemModel, index: QtCore.QModelIndex) -> None: ...
    def setEditorData(self, editor: QWidget, index: QtCore.QModelIndex) -> None: ...
    def createEditor(self, parent: QWidget, option: 'QStyleOptionViewItem', index: QtCore.QModelIndex) -> QWidget: ...
    def sizeHint(self, option: 'QStyleOptionViewItem', index: QtCore.QModelIndex) -> QtCore.QSize: ...
    def paint(self, painter: 'QPainter', option: 'QStyleOptionViewItem', index: QtCore.QModelIndex) -> None: ...


class QFrame(QWidget):

    class StyleMask(int): ...
    Shadow_Mask = ... # type: 'QFrame.StyleMask'
    Shape_Mask = ... # type: 'QFrame.StyleMask'

    class Shape(int): ...
    NoFrame = ... # type: 'QFrame.Shape'
    Box = ... # type: 'QFrame.Shape'
    Panel = ... # type: 'QFrame.Shape'
    WinPanel = ... # type: 'QFrame.Shape'
    HLine = ... # type: 'QFrame.Shape'
    VLine = ... # type: 'QFrame.Shape'
    StyledPanel = ... # type: 'QFrame.Shape'

    class Shadow(int): ...
    Plain = ... # type: 'QFrame.Shadow'
    Raised = ... # type: 'QFrame.Shadow'
    Sunken = ... # type: 'QFrame.Shadow'

    def __init__(self, parent: typing.Optional[QWidget] = ..., flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def drawFrame(self, a0: 'QPainter') -> None: ...
    def changeEvent(self, a0: QtCore.QEvent) -> None: ...
    def paintEvent(self, a0: 'QPaintEvent') -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def setFrameRect(self, a0: QtCore.QRect) -> None: ...
    def frameRect(self) -> QtCore.QRect: ...
    def setMidLineWidth(self, a0: int) -> None: ...
    def midLineWidth(self) -> int: ...
    def setLineWidth(self, a0: int) -> None: ...
    def lineWidth(self) -> int: ...
    def setFrameShadow(self, a0: 'QFrame.Shadow') -> None: ...
    def frameShadow(self) -> 'QFrame.Shadow': ...
    def setFrameShape(self, a0: 'QFrame.Shape') -> None: ...
    def frameShape(self) -> 'QFrame.Shape': ...
    def sizeHint(self) -> QtCore.QSize: ...
    def frameWidth(self) -> int: ...
    def setFrameStyle(self, a0: int) -> None: ...
    def frameStyle(self) -> int: ...


class QAbstractScrollArea(QFrame):

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...

    def setupViewport(self, viewport: QWidget) -> None: ...
    def setViewport(self, widget: QWidget) -> None: ...
    def scrollBarWidgets(self, alignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> typing.List[QWidget]: ...
    def addScrollBarWidget(self, widget: QWidget, alignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> None: ...
    def setCornerWidget(self, widget: QWidget) -> None: ...
    def cornerWidget(self) -> QWidget: ...
    def setHorizontalScrollBar(self, scrollbar: 'QScrollBar') -> None: ...
    def setVerticalScrollBar(self, scrollbar: 'QScrollBar') -> None: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def keyPressEvent(self, a0: 'QKeyEvent') -> None: ...
    def dropEvent(self, a0: 'QDropEvent') -> None: ...
    def dragLeaveEvent(self, a0: 'QDragLeaveEvent') -> None: ...
    def dragMoveEvent(self, a0: 'QDragMoveEvent') -> None: ...
    def dragEnterEvent(self, a0: 'QDragEnterEvent') -> None: ...
    def contextMenuEvent(self, a0: 'QContextMenuEvent') -> None: ...
    def wheelEvent(self, a0: 'QWheelEvent') -> None: ...
    def mouseMoveEvent(self, a0: 'QMouseEvent') -> None: ...
    def mouseDoubleClickEvent(self, a0: 'QMouseEvent') -> None: ...
    def mouseReleaseEvent(self, a0: 'QMouseEvent') -> None: ...
    def mousePressEvent(self, a0: 'QMouseEvent') -> None: ...
    def paintEvent(self, a0: 'QPaintEvent') -> None: ...
    def resizeEvent(self, a0: 'QResizeEvent') -> None: ...
    def viewportEvent(self, a0: QtCore.QEvent) -> bool: ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    @typing.overload
    def setViewportMargins(self, left: int, top: int, right: int, bottom: int) -> None: ...
    @typing.overload
    def setViewportMargins(self, margins: QtCore.QMargins) -> None: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def maximumViewportSize(self) -> QtCore.QSize: ...
    def viewport(self) -> QWidget: ...
    def horizontalScrollBar(self) -> 'QScrollBar': ...
    def setHorizontalScrollBarPolicy(self, a0: QtCore.Qt.ScrollBarPolicy) -> None: ...
    def horizontalScrollBarPolicy(self) -> QtCore.Qt.ScrollBarPolicy: ...
    def verticalScrollBar(self) -> 'QScrollBar': ...
    def setVerticalScrollBarPolicy(self, a0: QtCore.Qt.ScrollBarPolicy) -> None: ...
    def verticalScrollBarPolicy(self) -> QtCore.Qt.ScrollBarPolicy: ...


class QAbstractItemView(QAbstractScrollArea):

    class DropIndicatorPosition(int): ...
    OnItem = ... # type: 'QAbstractItemView.DropIndicatorPosition'
    AboveItem = ... # type: 'QAbstractItemView.DropIndicatorPosition'
    BelowItem = ... # type: 'QAbstractItemView.DropIndicatorPosition'
    OnViewport = ... # type: 'QAbstractItemView.DropIndicatorPosition'

    class State(int): ...
    NoState = ... # type: 'QAbstractItemView.State'
    DraggingState = ... # type: 'QAbstractItemView.State'
    DragSelectingState = ... # type: 'QAbstractItemView.State'
    EditingState = ... # type: 'QAbstractItemView.State'
    ExpandingState = ... # type: 'QAbstractItemView.State'
    CollapsingState = ... # type: 'QAbstractItemView.State'
    AnimatingState = ... # type: 'QAbstractItemView.State'

    class CursorAction(int): ...
    MoveUp = ... # type: 'QAbstractItemView.CursorAction'
    MoveDown = ... # type: 'QAbstractItemView.CursorAction'
    MoveLeft = ... # type: 'QAbstractItemView.CursorAction'
    MoveRight = ... # type: 'QAbstractItemView.CursorAction'
    MoveHome = ... # type: 'QAbstractItemView.CursorAction'
    MoveEnd = ... # type: 'QAbstractItemView.CursorAction'
    MovePageUp = ... # type: 'QAbstractItemView.CursorAction'
    MovePageDown = ... # type: 'QAbstractItemView.CursorAction'
    MoveNext = ... # type: 'QAbstractItemView.CursorAction'
    MovePrevious = ... # type: 'QAbstractItemView.CursorAction'

    class SelectionMode(int): ...
    NoSelection = ... # type: 'QAbstractItemView.SelectionMode'
    SingleSelection = ... # type: 'QAbstractItemView.SelectionMode'
    MultiSelection = ... # type: 'QAbstractItemView.SelectionMode'
    ExtendedSelection = ... # type: 'QAbstractItemView.SelectionMode'
    ContiguousSelection = ... # type: 'QAbstractItemView.SelectionMode'

    class SelectionBehavior(int): ...
    SelectItems = ... # type: 'QAbstractItemView.SelectionBehavior'
    SelectRows = ... # type: 'QAbstractItemView.SelectionBehavior'
    SelectColumns = ... # type: 'QAbstractItemView.SelectionBehavior'

    class ScrollMode(int): ...
    ScrollPerItem = ... # type: 'QAbstractItemView.ScrollMode'
    ScrollPerPixel = ... # type: 'QAbstractItemView.ScrollMode'

    class ScrollHint(int): ...
    EnsureVisible = ... # type: 'QAbstractItemView.ScrollHint'
    PositionAtTop = ... # type: 'QAbstractItemView.ScrollHint'
    PositionAtBottom = ... # type: 'QAbstractItemView.ScrollHint'
    PositionAtCenter = ... # type: 'QAbstractItemView.ScrollHint'

    class EditTrigger(int): ...
    NoEditTriggers = ... # type: 'QAbstractItemView.EditTrigger'
    CurrentChanged = ... # type: 'QAbstractItemView.EditTrigger'
    DoubleClicked = ... # type: 'QAbstractItemView.EditTrigger'
    SelectedClicked = ... # type: 'QAbstractItemView.EditTrigger'
    EditKeyPressed = ... # type: 'QAbstractItemView.EditTrigger'
    AnyKeyPressed = ... # type: 'QAbstractItemView.EditTrigger'
    AllEditTriggers = ... # type: 'QAbstractItemView.EditTrigger'

    class DragDropMode(int): ...
    NoDragDrop = ... # type: 'QAbstractItemView.DragDropMode'
    DragOnly = ... # type: 'QAbstractItemView.DragDropMode'
    DropOnly = ... # type: 'QAbstractItemView.DragDropMode'
    DragDrop = ... # type: 'QAbstractItemView.DragDropMode'
    InternalMove = ... # type: 'QAbstractItemView.DragDropMode'

    class EditTriggers(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QAbstractItemView.EditTriggers', 'QAbstractItemView.EditTrigger']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QAbstractItemView.EditTriggers') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QAbstractItemView.EditTriggers': ...
        def __int__(self) -> int: ...

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...

    def defaultDropAction(self) -> QtCore.Qt.DropAction: ...
    def setDefaultDropAction(self, dropAction: QtCore.Qt.DropAction) -> None: ...
    def inputMethodEvent(self, event: 'QInputMethodEvent') -> None: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def autoScrollMargin(self) -> int: ...
    def setAutoScrollMargin(self, margin: int) -> None: ...
    def inputMethodQuery(self, query: QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def itemDelegateForColumn(self, column: int) -> QAbstractItemDelegate: ...
    def setItemDelegateForColumn(self, column: int, delegate: QAbstractItemDelegate) -> None: ...
    def itemDelegateForRow(self, row: int) -> QAbstractItemDelegate: ...
    def setItemDelegateForRow(self, row: int, delegate: QAbstractItemDelegate) -> None: ...
    def dragDropMode(self) -> 'QAbstractItemView.DragDropMode': ...
    def setDragDropMode(self, behavior: 'QAbstractItemView.DragDropMode') -> None: ...
    def dragDropOverwriteMode(self) -> bool: ...
    def setDragDropOverwriteMode(self, overwrite: bool) -> None: ...
    def horizontalScrollMode(self) -> 'QAbstractItemView.ScrollMode': ...
    def setHorizontalScrollMode(self, mode: 'QAbstractItemView.ScrollMode') -> None: ...
    def verticalScrollMode(self) -> 'QAbstractItemView.ScrollMode': ...
    def setVerticalScrollMode(self, mode: 'QAbstractItemView.ScrollMode') -> None: ...
    def dropIndicatorPosition(self) -> 'QAbstractItemView.DropIndicatorPosition': ...
    def timerEvent(self, e: QtCore.QTimerEvent) -> None: ...
    def resizeEvent(self, e: 'QResizeEvent') -> None: ...
    def keyPressEvent(self, e: 'QKeyEvent') -> None: ...
    def focusOutEvent(self, e: 'QFocusEvent') -> None: ...
    def focusInEvent(self, e: 'QFocusEvent') -> None: ...
    def dropEvent(self, e: 'QDropEvent') -> None: ...
    def dragLeaveEvent(self, e: 'QDragLeaveEvent') -> None: ...
    def dragMoveEvent(self, e: 'QDragMoveEvent') -> None: ...
    def dragEnterEvent(self, e: 'QDragEnterEvent') -> None: ...
    def mouseDoubleClickEvent(self, e: 'QMouseEvent') -> None: ...
    def mouseReleaseEvent(self, e: 'QMouseEvent') -> None: ...
    def mouseMoveEvent(self, e: 'QMouseEvent') -> None: ...
    def mousePressEvent(self, e: 'QMouseEvent') -> None: ...
    def viewportEvent(self, e: QtCore.QEvent) -> bool: ...
    def event(self, event: QtCore.QEvent) -> bool: ...
    def dirtyRegionOffset(self) -> QtCore.QPoint: ...
    def setDirtyRegion(self, region: 'QRegion') -> None: ...
    def scrollDirtyRegion(self, dx: int, dy: int) -> None: ...
    def executeDelayedItemsLayout(self) -> None: ...
    def scheduleDelayedItemsLayout(self) -> None: ...
    def setState(self, state: 'QAbstractItemView.State') -> None: ...
    def state(self) -> 'QAbstractItemView.State': ...
    def viewOptions(self) -> 'QStyleOptionViewItem': ...
    def startDrag(self, supportedActions: typing.Union[QtCore.Qt.DropActions, QtCore.Qt.DropAction]) -> None: ...
    def selectionCommand(self, index: QtCore.QModelIndex, event: typing.Optional[QtCore.QEvent] = ...) -> 'QItemSelectionModel.SelectionFlags': ...
    def selectedIndexes(self) -> typing.List[QtCore.QModelIndex]: ...
    def visualRegionForSelection(self, selection: 'QItemSelection') -> 'QRegion': ...
    def setSelection(self, rect: QtCore.QRect, command: 'QItemSelectionModel.SelectionFlags') -> None: ...
    def isIndexHidden(self, index: QtCore.QModelIndex) -> bool: ...
    def verticalOffset(self) -> int: ...
    def horizontalOffset(self) -> int: ...
    def moveCursor(self, cursorAction: 'QAbstractItemView.CursorAction', modifiers: typing.Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier]) -> QtCore.QModelIndex: ...
    def verticalStepsPerItem(self) -> int: ...
    def setVerticalStepsPerItem(self, steps: int) -> None: ...
    def horizontalStepsPerItem(self) -> int: ...
    def setHorizontalStepsPerItem(self, steps: int) -> None: ...
    def viewportEntered(self) -> None: ...
    def entered(self, index: QtCore.QModelIndex) -> None: ...
    def activated(self, index: QtCore.QModelIndex) -> None: ...
    def doubleClicked(self, index: QtCore.QModelIndex) -> None: ...
    def clicked(self, index: QtCore.QModelIndex) -> None: ...
    def pressed(self, index: QtCore.QModelIndex) -> None: ...
    def editorDestroyed(self, editor: QtCore.QObject) -> None: ...
    def commitData(self, editor: QWidget) -> None: ...
    def closeEditor(self, editor: QWidget, hint: QAbstractItemDelegate.EndEditHint) -> None: ...
    def horizontalScrollbarValueChanged(self, value: int) -> None: ...
    def verticalScrollbarValueChanged(self, value: int) -> None: ...
    def horizontalScrollbarAction(self, action: int) -> None: ...
    def verticalScrollbarAction(self, action: int) -> None: ...
    def updateGeometries(self) -> None: ...
    def updateEditorGeometries(self) -> None: ...
    def updateEditorData(self) -> None: ...
    def currentChanged(self, current: QtCore.QModelIndex, previous: QtCore.QModelIndex) -> None: ...
    def selectionChanged(self, selected: 'QItemSelection', deselected: 'QItemSelection') -> None: ...
    def rowsAboutToBeRemoved(self, parent: QtCore.QModelIndex, start: int, end: int) -> None: ...
    def rowsInserted(self, parent: QtCore.QModelIndex, start: int, end: int) -> None: ...
    def dataChanged(self, topLeft: QtCore.QModelIndex, bottomRight: QtCore.QModelIndex) -> None: ...
    @typing.overload
    def update(self) -> None: ...
    @typing.overload
    def update(self, index: QtCore.QModelIndex) -> None: ...
    def scrollToBottom(self) -> None: ...
    def scrollToTop(self) -> None: ...
    def setCurrentIndex(self, index: QtCore.QModelIndex) -> None: ...
    def clearSelection(self) -> None: ...
    @typing.overload
    def edit(self, index: QtCore.QModelIndex) -> None: ...
    @typing.overload
    def edit(self, index: QtCore.QModelIndex, trigger: 'QAbstractItemView.EditTrigger', event: QtCore.QEvent) -> bool: ...
    def selectAll(self) -> None: ...
    def setRootIndex(self, index: QtCore.QModelIndex) -> None: ...
    def reset(self) -> None: ...
    def indexWidget(self, index: QtCore.QModelIndex) -> QWidget: ...
    def setIndexWidget(self, index: QtCore.QModelIndex, widget: QWidget) -> None: ...
    def closePersistentEditor(self, index: QtCore.QModelIndex) -> None: ...
    def openPersistentEditor(self, index: QtCore.QModelIndex) -> None: ...
    def sizeHintForColumn(self, column: int) -> int: ...
    def sizeHintForRow(self, row: int) -> int: ...
    def sizeHintForIndex(self, index: QtCore.QModelIndex) -> QtCore.QSize: ...
    def indexAt(self, p: QtCore.QPoint) -> QtCore.QModelIndex: ...
    def scrollTo(self, index: QtCore.QModelIndex, hint: 'QAbstractItemView.ScrollHint' = ...) -> None: ...
    def visualRect(self, index: QtCore.QModelIndex) -> QtCore.QRect: ...
    def keyboardSearch(self, search: str) -> None: ...
    def textElideMode(self) -> QtCore.Qt.TextElideMode: ...
    def setTextElideMode(self, mode: QtCore.Qt.TextElideMode) -> None: ...
    def iconSize(self) -> QtCore.QSize: ...
    def setIconSize(self, size: QtCore.QSize) -> None: ...
    def alternatingRowColors(self) -> bool: ...
    def setAlternatingRowColors(self, enable: bool) -> None: ...
    def dragEnabled(self) -> bool: ...
    def setDragEnabled(self, enable: bool) -> None: ...
    def showDropIndicator(self) -> bool: ...
    def setDropIndicatorShown(self, enable: bool) -> None: ...
    def tabKeyNavigation(self) -> bool: ...
    def setTabKeyNavigation(self, enable: bool) -> None: ...
    def hasAutoScroll(self) -> bool: ...
    def setAutoScroll(self, enable: bool) -> None: ...
    def editTriggers(self) -> 'QAbstractItemView.EditTriggers': ...
    def setEditTriggers(self, triggers: 'QAbstractItemView.EditTriggers') -> None: ...
    def rootIndex(self) -> QtCore.QModelIndex: ...
    def currentIndex(self) -> QtCore.QModelIndex: ...
    def selectionBehavior(self) -> 'QAbstractItemView.SelectionBehavior': ...
    def setSelectionBehavior(self, behavior: 'QAbstractItemView.SelectionBehavior') -> None: ...
    def selectionMode(self) -> 'QAbstractItemView.SelectionMode': ...
    def setSelectionMode(self, mode: 'QAbstractItemView.SelectionMode') -> None: ...
    @typing.overload
    def itemDelegate(self) -> QAbstractItemDelegate: ...
    @typing.overload
    def itemDelegate(self, index: QtCore.QModelIndex) -> QAbstractItemDelegate: ...
    def setItemDelegate(self, delegate: QAbstractItemDelegate) -> None: ...
    def selectionModel(self) -> 'QItemSelectionModel': ...
    def setSelectionModel(self, selectionModel: 'QItemSelectionModel') -> None: ...
    def model(self) -> QtCore.QAbstractItemModel: ...
    def setModel(self, model: QtCore.QAbstractItemModel) -> None: ...


class QDialog(QWidget):

    class DialogCode(int): ...
    Rejected = ... # type: 'QDialog.DialogCode'
    Accepted = ... # type: 'QDialog.DialogCode'

    def __init__(self, parent: typing.Optional[QWidget] = ..., flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def eventFilter(self, a0: QtCore.QObject, a1: QtCore.QEvent) -> bool: ...
    def contextMenuEvent(self, a0: 'QContextMenuEvent') -> None: ...
    def resizeEvent(self, a0: 'QResizeEvent') -> None: ...
    def showEvent(self, a0: 'QShowEvent') -> None: ...
    def closeEvent(self, a0: 'QCloseEvent') -> None: ...
    def keyPressEvent(self, a0: 'QKeyEvent') -> None: ...
    def rejected(self) -> None: ...
    def finished(self, result: int) -> None: ...
    def accepted(self) -> None: ...
    def open(self) -> None: ...
    def showExtension(self, a0: bool) -> None: ...
    def reject(self) -> None: ...
    def accept(self) -> None: ...
    def done(self, a0: int) -> None: ...
    def exec(self) -> int: ...
    def exec_(self) -> int: ...
    def setResult(self, r: int) -> None: ...
    def setModal(self, modal: bool) -> None: ...
    def isSizeGripEnabled(self) -> bool: ...
    def setSizeGripEnabled(self, a0: bool) -> None: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def extension(self) -> QWidget: ...
    def setExtension(self, extension: QWidget) -> None: ...
    def orientation(self) -> QtCore.Qt.Orientation: ...
    def setOrientation(self, orientation: QtCore.Qt.Orientation) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def result(self) -> int: ...


class QAbstractPrintDialog(QDialog):

    class PrintDialogOption(int): ...
    None_ = ... # type: 'QAbstractPrintDialog.PrintDialogOption'
    PrintToFile = ... # type: 'QAbstractPrintDialog.PrintDialogOption'
    PrintSelection = ... # type: 'QAbstractPrintDialog.PrintDialogOption'
    PrintPageRange = ... # type: 'QAbstractPrintDialog.PrintDialogOption'
    PrintCollateCopies = ... # type: 'QAbstractPrintDialog.PrintDialogOption'
    PrintShowPageSize = ... # type: 'QAbstractPrintDialog.PrintDialogOption'
    DontUseSheet = ... # type: 'QAbstractPrintDialog.PrintDialogOption'
    PrintCurrentPage = ... # type: 'QAbstractPrintDialog.PrintDialogOption'

    class PrintRange(int): ...
    AllPages = ... # type: 'QAbstractPrintDialog.PrintRange'
    Selection = ... # type: 'QAbstractPrintDialog.PrintRange'
    PageRange = ... # type: 'QAbstractPrintDialog.PrintRange'
    CurrentPage = ... # type: 'QAbstractPrintDialog.PrintRange'

    class PrintDialogOptions(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QAbstractPrintDialog.PrintDialogOptions', 'QAbstractPrintDialog.PrintDialogOption']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QAbstractPrintDialog.PrintDialogOptions') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QAbstractPrintDialog.PrintDialogOptions': ...
        def __int__(self) -> int: ...

    def __init__(self, printer: 'QPrinter', parent: typing.Optional[QWidget] = ...) -> None: ...

    def setOptionTabs(self, tabs: typing.Sequence[QWidget]) -> None: ...
    def printer(self) -> 'QPrinter': ...
    def toPage(self) -> int: ...
    def fromPage(self) -> int: ...
    def setFromTo(self, fromPage: int, toPage: int) -> None: ...
    def maxPage(self) -> int: ...
    def minPage(self) -> int: ...
    def setMinMax(self, min: int, max: int) -> None: ...
    def printRange(self) -> 'QAbstractPrintDialog.PrintRange': ...
    def setPrintRange(self, range: 'QAbstractPrintDialog.PrintRange') -> None: ...
    def isOptionEnabled(self, option: 'QAbstractPrintDialog.PrintDialogOption') -> bool: ...
    def enabledOptions(self) -> 'QAbstractPrintDialog.PrintDialogOptions': ...
    def setEnabledOptions(self, options: 'QAbstractPrintDialog.PrintDialogOptions') -> None: ...
    def addEnabledOption(self, option: 'QAbstractPrintDialog.PrintDialogOption') -> None: ...
    def exec(self) -> int: ...
    def exec_(self) -> int: ...


class QAbstractProxyModel(QtCore.QAbstractItemModel):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def supportedDropActions(self) -> QtCore.Qt.DropActions: ...
    def mimeTypes(self) -> typing.List[str]: ...
    def mimeData(self, indexes: typing.Sequence[QtCore.QModelIndex]) -> QtCore.QMimeData: ...
    def hasChildren(self, parent: QtCore.QModelIndex = ...) -> bool: ...
    def span(self, index: QtCore.QModelIndex) -> QtCore.QSize: ...
    def sort(self, column: int, order: QtCore.Qt.SortOrder = ...) -> None: ...
    def fetchMore(self, parent: QtCore.QModelIndex) -> None: ...
    def canFetchMore(self, parent: QtCore.QModelIndex) -> bool: ...
    def buddy(self, index: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def setItemData(self, index: QtCore.QModelIndex, roles: typing.Dict[int, typing.Any]) -> bool: ...
    def flags(self, index: QtCore.QModelIndex) -> QtCore.Qt.ItemFlags: ...
    def itemData(self, index: QtCore.QModelIndex) -> typing.Dict[int, typing.Any]: ...
    def setHeaderData(self, section: int, orientation: QtCore.Qt.Orientation, value: typing.Any, role: int = ...) -> bool: ...
    def headerData(self, section: int, orientation: QtCore.Qt.Orientation, role: int) -> typing.Any: ...
    def setData(self, index: QtCore.QModelIndex, value: typing.Any, role: int = ...) -> bool: ...
    def data(self, proxyIndex: QtCore.QModelIndex, role: int = ...) -> typing.Any: ...
    def revert(self) -> None: ...
    def submit(self) -> bool: ...
    def mapSelectionFromSource(self, selection: 'QItemSelection') -> 'QItemSelection': ...
    def mapSelectionToSource(self, selection: 'QItemSelection') -> 'QItemSelection': ...
    def mapFromSource(self, sourceIndex: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def mapToSource(self, proxyIndex: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def sourceModel(self) -> QtCore.QAbstractItemModel: ...
    def setSourceModel(self, sourceModel: QtCore.QAbstractItemModel) -> None: ...


class QAbstractSlider(QWidget):

    class SliderChange(int): ...
    SliderRangeChange = ... # type: 'QAbstractSlider.SliderChange'
    SliderOrientationChange = ... # type: 'QAbstractSlider.SliderChange'
    SliderStepsChange = ... # type: 'QAbstractSlider.SliderChange'
    SliderValueChange = ... # type: 'QAbstractSlider.SliderChange'

    class SliderAction(int): ...
    SliderNoAction = ... # type: 'QAbstractSlider.SliderAction'
    SliderSingleStepAdd = ... # type: 'QAbstractSlider.SliderAction'
    SliderSingleStepSub = ... # type: 'QAbstractSlider.SliderAction'
    SliderPageStepAdd = ... # type: 'QAbstractSlider.SliderAction'
    SliderPageStepSub = ... # type: 'QAbstractSlider.SliderAction'
    SliderToMinimum = ... # type: 'QAbstractSlider.SliderAction'
    SliderToMaximum = ... # type: 'QAbstractSlider.SliderAction'
    SliderMove = ... # type: 'QAbstractSlider.SliderAction'

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...

    def changeEvent(self, e: QtCore.QEvent) -> None: ...
    def wheelEvent(self, e: 'QWheelEvent') -> None: ...
    def timerEvent(self, a0: QtCore.QTimerEvent) -> None: ...
    def keyPressEvent(self, ev: 'QKeyEvent') -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def sliderChange(self, change: 'QAbstractSlider.SliderChange') -> None: ...
    def repeatAction(self) -> 'QAbstractSlider.SliderAction': ...
    def setRepeatAction(self, action: 'QAbstractSlider.SliderAction', thresholdTime: int = ..., repeatTime: int = ...) -> None: ...
    def actionTriggered(self, action: int) -> None: ...
    def rangeChanged(self, min: int, max: int) -> None: ...
    def sliderReleased(self) -> None: ...
    def sliderMoved(self, position: int) -> None: ...
    def sliderPressed(self) -> None: ...
    def valueChanged(self, value: int) -> None: ...
    def setOrientation(self, a0: QtCore.Qt.Orientation) -> None: ...
    def setValue(self, a0: int) -> None: ...
    def triggerAction(self, action: 'QAbstractSlider.SliderAction') -> None: ...
    def value(self) -> int: ...
    def invertedControls(self) -> bool: ...
    def setInvertedControls(self, a0: bool) -> None: ...
    def invertedAppearance(self) -> bool: ...
    def setInvertedAppearance(self, a0: bool) -> None: ...
    def sliderPosition(self) -> int: ...
    def setSliderPosition(self, a0: int) -> None: ...
    def isSliderDown(self) -> bool: ...
    def setSliderDown(self, a0: bool) -> None: ...
    def hasTracking(self) -> bool: ...
    def setTracking(self, enable: bool) -> None: ...
    def pageStep(self) -> int: ...
    def setPageStep(self, a0: int) -> None: ...
    def singleStep(self) -> int: ...
    def setSingleStep(self, a0: int) -> None: ...
    def setRange(self, min: int, max: int) -> None: ...
    def maximum(self) -> int: ...
    def setMaximum(self, a0: int) -> None: ...
    def minimum(self) -> int: ...
    def setMinimum(self, a0: int) -> None: ...
    def orientation(self) -> QtCore.Qt.Orientation: ...


class QAbstractSpinBox(QWidget):

    class CorrectionMode(int): ...
    CorrectToPreviousValue = ... # type: 'QAbstractSpinBox.CorrectionMode'
    CorrectToNearestValue = ... # type: 'QAbstractSpinBox.CorrectionMode'

    class ButtonSymbols(int): ...
    UpDownArrows = ... # type: 'QAbstractSpinBox.ButtonSymbols'
    PlusMinus = ... # type: 'QAbstractSpinBox.ButtonSymbols'
    NoButtons = ... # type: 'QAbstractSpinBox.ButtonSymbols'

    class StepEnabledFlag(int): ...
    StepNone = ... # type: 'QAbstractSpinBox.StepEnabledFlag'
    StepUpEnabled = ... # type: 'QAbstractSpinBox.StepEnabledFlag'
    StepDownEnabled = ... # type: 'QAbstractSpinBox.StepEnabledFlag'

    class StepEnabled(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QAbstractSpinBox.StepEnabled', 'QAbstractSpinBox.StepEnabledFlag']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QAbstractSpinBox.StepEnabled') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QAbstractSpinBox.StepEnabled': ...
        def __int__(self) -> int: ...

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...

    def inputMethodQuery(self, a0: QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def initStyleOption(self, option: 'QStyleOptionSpinBox') -> None: ...
    def keyboardTracking(self) -> bool: ...
    def setKeyboardTracking(self, kt: bool) -> None: ...
    def isAccelerated(self) -> bool: ...
    def setAccelerated(self, on: bool) -> None: ...
    def hasAcceptableInput(self) -> bool: ...
    def correctionMode(self) -> 'QAbstractSpinBox.CorrectionMode': ...
    def setCorrectionMode(self, cm: 'QAbstractSpinBox.CorrectionMode') -> None: ...
    def stepEnabled(self) -> 'QAbstractSpinBox.StepEnabled': ...
    def setLineEdit(self, e: 'QLineEdit') -> None: ...
    def lineEdit(self) -> 'QLineEdit': ...
    def showEvent(self, e: 'QShowEvent') -> None: ...
    def paintEvent(self, e: 'QPaintEvent') -> None: ...
    def timerEvent(self, e: QtCore.QTimerEvent) -> None: ...
    def mouseMoveEvent(self, e: 'QMouseEvent') -> None: ...
    def mouseReleaseEvent(self, e: 'QMouseEvent') -> None: ...
    def mousePressEvent(self, e: 'QMouseEvent') -> None: ...
    def hideEvent(self, e: 'QHideEvent') -> None: ...
    def closeEvent(self, e: 'QCloseEvent') -> None: ...
    def changeEvent(self, e: QtCore.QEvent) -> None: ...
    def contextMenuEvent(self, e: 'QContextMenuEvent') -> None: ...
    def focusOutEvent(self, e: 'QFocusEvent') -> None: ...
    def focusInEvent(self, e: 'QFocusEvent') -> None: ...
    def wheelEvent(self, e: 'QWheelEvent') -> None: ...
    def keyReleaseEvent(self, e: 'QKeyEvent') -> None: ...
    def keyPressEvent(self, e: 'QKeyEvent') -> None: ...
    def resizeEvent(self, e: 'QResizeEvent') -> None: ...
    def editingFinished(self) -> None: ...
    def clear(self) -> None: ...
    def selectAll(self) -> None: ...
    def stepDown(self) -> None: ...
    def stepUp(self) -> None: ...
    def stepBy(self, steps: int) -> None: ...
    def fixup(self, input: str) -> str: ...
    def validate(self, input: str, pos: int) -> typing.Tuple['QValidator.State', str, int]: ...
    def event(self, event: QtCore.QEvent) -> bool: ...
    def interpretText(self) -> None: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def hasFrame(self) -> bool: ...
    def setFrame(self, a0: bool) -> None: ...
    def alignment(self) -> QtCore.Qt.Alignment: ...
    def setAlignment(self, flag: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> None: ...
    def isReadOnly(self) -> bool: ...
    def setReadOnly(self, r: bool) -> None: ...
    def setWrapping(self, w: bool) -> None: ...
    def wrapping(self) -> bool: ...
    def setSpecialValueText(self, s: str) -> None: ...
    def specialValueText(self) -> str: ...
    def text(self) -> str: ...
    def setButtonSymbols(self, bs: 'QAbstractSpinBox.ButtonSymbols') -> None: ...
    def buttonSymbols(self) -> 'QAbstractSpinBox.ButtonSymbols': ...


class QAbstractTextDocumentLayout(QtCore.QObject):

    class Selection(sip.simplewrapper):

        cursor = ... # type: 'QTextCursor'
        format = ... # type: 'QTextCharFormat'

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QAbstractTextDocumentLayout.Selection') -> None: ...

    class PaintContext(sip.simplewrapper):

        clip = ... # type: QtCore.QRectF
        cursorPosition = ... # type: int
        palette = ... # type: 'QPalette'
        selections = ... # type: typing.List['QAbstractTextDocumentLayout.Selection']

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QAbstractTextDocumentLayout.PaintContext') -> None: ...

    def __init__(self, doc: 'QTextDocument') -> None: ...

    def format(self, pos: int) -> 'QTextCharFormat': ...
    def drawInlineObject(self, painter: 'QPainter', rect: QtCore.QRectF, object: 'QTextInlineObject', posInDocument: int, format: 'QTextFormat') -> None: ...
    def positionInlineObject(self, item: 'QTextInlineObject', posInDocument: int, format: 'QTextFormat') -> None: ...
    def resizeInlineObject(self, item: 'QTextInlineObject', posInDocument: int, format: 'QTextFormat') -> None: ...
    def documentChanged(self, from_: int, charsRemoved: int, charsAdded: int) -> None: ...
    def updateBlock(self, block: 'QTextBlock') -> None: ...
    def pageCountChanged(self, newPages: int) -> None: ...
    def documentSizeChanged(self, newSize: QtCore.QSizeF) -> None: ...
    def update(self, rect: QtCore.QRectF = ...) -> None: ...
    def handlerForObject(self, objectType: int) -> 'QTextObjectInterface': ...
    def registerHandler(self, objectType: int, component: QtCore.QObject) -> None: ...
    def document(self) -> 'QTextDocument': ...
    def paintDevice(self) -> QPaintDevice: ...
    def setPaintDevice(self, device: QPaintDevice) -> None: ...
    def blockBoundingRect(self, block: 'QTextBlock') -> QtCore.QRectF: ...
    def frameBoundingRect(self, frame: 'QTextFrame') -> QtCore.QRectF: ...
    def documentSize(self) -> QtCore.QSizeF: ...
    def pageCount(self) -> int: ...
    def anchorAt(self, pos: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> str: ...
    def hitTest(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint], accuracy: 'Qt.HitTestAccuracy') -> int: ...
    def draw(self, painter: 'QPainter', context: 'QAbstractTextDocumentLayout.PaintContext') -> None: ...


class QTextObjectInterface(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QTextObjectInterface') -> None: ...

    def drawObject(self, painter: 'QPainter', rect: QtCore.QRectF, doc: 'QTextDocument', posInDocument: int, format: 'QTextFormat') -> None: ...
    def intrinsicSize(self, doc: 'QTextDocument', posInDocument: int, format: 'QTextFormat') -> QtCore.QSizeF: ...


class QAction(QtCore.QObject):

    class Priority(int): ...
    LowPriority = ... # type: 'QAction.Priority'
    NormalPriority = ... # type: 'QAction.Priority'
    HighPriority = ... # type: 'QAction.Priority'

    class SoftKeyRole(int): ...
    NoSoftKey = ... # type: 'QAction.SoftKeyRole'
    PositiveSoftKey = ... # type: 'QAction.SoftKeyRole'
    NegativeSoftKey = ... # type: 'QAction.SoftKeyRole'
    SelectSoftKey = ... # type: 'QAction.SoftKeyRole'

    class MenuRole(int): ...
    NoRole = ... # type: 'QAction.MenuRole'
    TextHeuristicRole = ... # type: 'QAction.MenuRole'
    ApplicationSpecificRole = ... # type: 'QAction.MenuRole'
    AboutQtRole = ... # type: 'QAction.MenuRole'
    AboutRole = ... # type: 'QAction.MenuRole'
    PreferencesRole = ... # type: 'QAction.MenuRole'
    QuitRole = ... # type: 'QAction.MenuRole'

    class ActionEvent(int): ...
    Trigger = ... # type: 'QAction.ActionEvent'
    Hover = ... # type: 'QAction.ActionEvent'

    @typing.overload
    def __init__(self, parent: QtCore.QObject) -> None: ...
    @typing.overload
    def __init__(self, text: str, parent: QtCore.QObject) -> None: ...
    @typing.overload
    def __init__(self, icon: 'QIcon', text: str, parent: QtCore.QObject) -> None: ...

    def softKeyRole(self) -> 'QAction.SoftKeyRole': ...
    def setSoftKeyRole(self, softKeyRole: 'QAction.SoftKeyRole') -> None: ...
    def priority(self) -> 'QAction.Priority': ...
    def setPriority(self, priority: 'QAction.Priority') -> None: ...
    def isIconVisibleInMenu(self) -> bool: ...
    def setIconVisibleInMenu(self, visible: bool) -> None: ...
    def associatedGraphicsWidgets(self) -> typing.List['QGraphicsWidget']: ...
    def associatedWidgets(self) -> typing.List[QWidget]: ...
    def menuRole(self) -> 'QAction.MenuRole': ...
    def setMenuRole(self, menuRole: 'QAction.MenuRole') -> None: ...
    def autoRepeat(self) -> bool: ...
    def setAutoRepeat(self, a0: bool) -> None: ...
    def shortcuts(self) -> typing.List['QKeySequence']: ...
    @typing.overload
    def setShortcuts(self, shortcuts: typing.Sequence[typing.Union['QKeySequence', 'QKeySequence.StandardKey', str, int]]) -> None: ...
    @typing.overload
    def setShortcuts(self, a0: 'QKeySequence.StandardKey') -> None: ...
    def toggled(self, a0: bool) -> None: ...
    def hovered(self) -> None: ...
    def triggered(self, checked: bool = ...) -> None: ...
    def changed(self) -> None: ...
    def setVisible(self, a0: bool) -> None: ...
    def setDisabled(self, b: bool) -> None: ...
    def setEnabled(self, a0: bool) -> None: ...
    def toggle(self) -> None: ...
    def setChecked(self, a0: bool) -> None: ...
    def hover(self) -> None: ...
    def trigger(self) -> None: ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    def parentWidget(self) -> QWidget: ...
    def showStatusText(self, widget: typing.Optional[QWidget] = ...) -> bool: ...
    def activate(self, event: 'QAction.ActionEvent') -> None: ...
    def isVisible(self) -> bool: ...
    def isEnabled(self) -> bool: ...
    def isChecked(self) -> bool: ...
    def setData(self, var: typing.Any) -> None: ...
    def data(self) -> typing.Any: ...
    def isCheckable(self) -> bool: ...
    def setCheckable(self, a0: bool) -> None: ...
    def font(self) -> 'QFont': ...
    def setFont(self, font: 'QFont') -> None: ...
    def shortcutContext(self) -> QtCore.Qt.ShortcutContext: ...
    def setShortcutContext(self, context: QtCore.Qt.ShortcutContext) -> None: ...
    def shortcut(self) -> 'QKeySequence': ...
    def setShortcut(self, shortcut: typing.Union['QKeySequence', 'QKeySequence.StandardKey', str, int]) -> None: ...
    def isSeparator(self) -> bool: ...
    def setSeparator(self, b: bool) -> None: ...
    def setMenu(self, menu: 'QMenu') -> None: ...
    def menu(self) -> 'QMenu': ...
    def whatsThis(self) -> str: ...
    def setWhatsThis(self, what: str) -> None: ...
    def statusTip(self) -> str: ...
    def setStatusTip(self, statusTip: str) -> None: ...
    def toolTip(self) -> str: ...
    def setToolTip(self, tip: str) -> None: ...
    def iconText(self) -> str: ...
    def setIconText(self, text: str) -> None: ...
    def text(self) -> str: ...
    def setText(self, text: str) -> None: ...
    def icon(self) -> 'QIcon': ...
    def setIcon(self, icon: 'QIcon') -> None: ...
    def actionGroup(self) -> 'QActionGroup': ...
    def setActionGroup(self, group: 'QActionGroup') -> None: ...


class QActionGroup(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject) -> None: ...

    def hovered(self, a0: QAction) -> None: ...
    def selected(self, a0: QAction) -> None: ...
    def triggered(self, a0: QAction) -> None: ...
    def setExclusive(self, a0: bool) -> None: ...
    def setVisible(self, a0: bool) -> None: ...
    def setDisabled(self, b: bool) -> None: ...
    def setEnabled(self, a0: bool) -> None: ...
    def isVisible(self) -> bool: ...
    def isEnabled(self) -> bool: ...
    def isExclusive(self) -> bool: ...
    def checkedAction(self) -> QAction: ...
    def actions(self) -> typing.List[QAction]: ...
    def removeAction(self, a: QAction) -> None: ...
    @typing.overload
    def addAction(self, a: QAction) -> QAction: ...
    @typing.overload
    def addAction(self, text: str) -> QAction: ...
    @typing.overload
    def addAction(self, icon: 'QIcon', text: str) -> QAction: ...


class QApplication(QtCore.QCoreApplication):

    class ColorSpec(int): ...
    NormalColor = ... # type: 'QApplication.ColorSpec'
    CustomColor = ... # type: 'QApplication.ColorSpec'
    ManyColor = ... # type: 'QApplication.ColorSpec'

    class Type(int): ...
    Tty = ... # type: 'QApplication.Type'
    GuiClient = ... # type: 'QApplication.Type'
    GuiServer = ... # type: 'QApplication.Type'

    @typing.overload
    def __init__(self, argv: typing.List[str]) -> None: ...
    @typing.overload
    def __init__(self, argv: typing.List[str], GUIenabled: bool) -> None: ...
    @typing.overload
    def __init__(self, argv: typing.List[str], a1: 'QApplication.Type') -> None: ...
    @typing.overload
    def __init__(self, display: 'Display', visual: int = ..., colormap: int = ...) -> None: ...
    @typing.overload
    def __init__(self, dpy: 'Display', argv: typing.List[str], visual: int = ..., cmap: int = ...) -> None: ...

    @staticmethod
    def queryKeyboardModifiers() -> QtCore.Qt.KeyboardModifiers: ...
    def autoSipEnabled(self) -> bool: ...
    def setAutoSipEnabled(self, enabled: bool) -> None: ...
    @staticmethod
    def setGraphicsSystem(a0: str) -> None: ...
    @staticmethod
    def alert(widget: QWidget, msecs: int = ...) -> None: ...
    def styleSheet(self) -> str: ...
    @staticmethod
    def keyboardInputDirection() -> QtCore.Qt.LayoutDirection: ...
    @staticmethod
    def keyboardInputLocale() -> QtCore.QLocale: ...
    @typing.overload
    @staticmethod
    def font() -> 'QFont': ...
    @typing.overload
    @staticmethod
    def font(a0: QWidget) -> 'QFont': ...
    @typing.overload
    @staticmethod
    def font(className: str) -> 'QFont': ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    def setStyleSheet(self, sheet: str) -> None: ...
    @staticmethod
    def closeAllWindows() -> None: ...
    @staticmethod
    def aboutQt() -> None: ...
    def fontDatabaseChanged(self) -> None: ...
    def saveStateRequest(self, sessionManager: 'QSessionManager') -> None: ...
    def lastWindowClosed(self) -> None: ...
    def focusChanged(self, old: QWidget, now: QWidget) -> None: ...
    def commitDataRequest(self, sessionManager: 'QSessionManager') -> None: ...
    @staticmethod
    def quitOnLastWindowClosed() -> bool: ...
    @staticmethod
    def setQuitOnLastWindowClosed(quit: bool) -> None: ...
    def notify(self, a0: QtCore.QObject, a1: QtCore.QEvent) -> bool: ...
    @staticmethod
    def exec() -> int: ...
    @staticmethod
    def exec_() -> int: ...
    def inputContext(self) -> 'QInputContext': ...
    def setInputContext(self, a0: 'QInputContext') -> None: ...
    def saveState(self, sm: 'QSessionManager') -> None: ...
    def commitData(self, sm: 'QSessionManager') -> None: ...
    def sessionKey(self) -> str: ...
    def sessionId(self) -> str: ...
    def isSessionRestored(self) -> bool: ...
    def x11ProcessEvent(self, a0: sip.voidptr) -> int: ...
    def x11EventFilter(self, a0: sip.voidptr) -> bool: ...
    @staticmethod
    def setEffectEnabled(effect: QtCore.Qt.UIEffect, enabled: bool = ...) -> None: ...
    @staticmethod
    def isEffectEnabled(a0: QtCore.Qt.UIEffect) -> bool: ...
    @staticmethod
    def isLeftToRight() -> bool: ...
    @staticmethod
    def isRightToLeft() -> bool: ...
    @staticmethod
    def layoutDirection() -> QtCore.Qt.LayoutDirection: ...
    @staticmethod
    def setLayoutDirection(direction: QtCore.Qt.LayoutDirection) -> None: ...
    @staticmethod
    def startDragDistance() -> int: ...
    @staticmethod
    def setStartDragDistance(l: int) -> None: ...
    @staticmethod
    def startDragTime() -> int: ...
    @staticmethod
    def setStartDragTime(ms: int) -> None: ...
    @staticmethod
    def globalStrut() -> QtCore.QSize: ...
    @staticmethod
    def setGlobalStrut(a0: QtCore.QSize) -> None: ...
    @staticmethod
    def wheelScrollLines() -> int: ...
    @staticmethod
    def setWheelScrollLines(a0: int) -> None: ...
    @staticmethod
    def keyboardInputInterval() -> int: ...
    @staticmethod
    def setKeyboardInputInterval(a0: int) -> None: ...
    @staticmethod
    def doubleClickInterval() -> int: ...
    @staticmethod
    def setDoubleClickInterval(a0: int) -> None: ...
    @staticmethod
    def cursorFlashTime() -> int: ...
    @staticmethod
    def setCursorFlashTime(a0: int) -> None: ...
    @staticmethod
    def desktopSettingsAware() -> bool: ...
    @staticmethod
    def setDesktopSettingsAware(a0: bool) -> None: ...
    @staticmethod
    def mouseButtons() -> QtCore.Qt.MouseButtons: ...
    @staticmethod
    def keyboardModifiers() -> QtCore.Qt.KeyboardModifiers: ...
    @staticmethod
    def beep() -> None: ...
    @staticmethod
    def syncX() -> None: ...
    @typing.overload
    @staticmethod
    def topLevelAt(p: QtCore.QPoint) -> QWidget: ...
    @typing.overload
    @staticmethod
    def topLevelAt(x: int, y: int) -> QWidget: ...
    @typing.overload
    @staticmethod
    def widgetAt(p: QtCore.QPoint) -> QWidget: ...
    @typing.overload
    @staticmethod
    def widgetAt(x: int, y: int) -> QWidget: ...
    @staticmethod
    def setActiveWindow(act: QWidget) -> None: ...
    @staticmethod
    def activeWindow() -> QWidget: ...
    @staticmethod
    def focusWidget() -> QWidget: ...
    @staticmethod
    def clipboard() -> 'QClipboard': ...
    @staticmethod
    def activeModalWidget() -> QWidget: ...
    @staticmethod
    def activePopupWidget() -> QWidget: ...
    @staticmethod
    def desktop() -> 'QDesktopWidget': ...
    @staticmethod
    def topLevelWidgets() -> typing.List[QWidget]: ...
    @staticmethod
    def allWidgets() -> typing.List[QWidget]: ...
    @staticmethod
    def windowIcon() -> 'QIcon': ...
    @staticmethod
    def setWindowIcon(icon: 'QIcon') -> None: ...
    @staticmethod
    def fontMetrics() -> 'QFontMetrics': ...
    @staticmethod
    def setFont(font: 'QFont', className: typing.Optional[str] = ...) -> None: ...
    @staticmethod
    def setPalette(palette: 'QPalette', className: typing.Optional[str] = ...) -> None: ...
    @typing.overload
    @staticmethod
    def palette() -> 'QPalette': ...
    @typing.overload
    @staticmethod
    def palette(a0: QWidget) -> 'QPalette': ...
    @typing.overload
    @staticmethod
    def palette(className: str) -> 'QPalette': ...
    @staticmethod
    def restoreOverrideCursor() -> None: ...
    @staticmethod
    def changeOverrideCursor(a0: typing.Union['QCursor', QtCore.Qt.CursorShape]) -> None: ...
    @staticmethod
    def setOverrideCursor(a0: typing.Union['QCursor', QtCore.Qt.CursorShape]) -> None: ...
    @staticmethod
    def overrideCursor() -> 'QCursor': ...
    @staticmethod
    def setColorSpec(a0: int) -> None: ...
    @staticmethod
    def colorSpec() -> int: ...
    @typing.overload
    @staticmethod
    def setStyle(a0: 'QStyle') -> None: ...
    @typing.overload
    @staticmethod
    def setStyle(a0: str) -> 'QStyle': ...
    @staticmethod
    def style() -> 'QStyle': ...
    @staticmethod
    def type() -> 'QApplication.Type': ...


class QPixmap(QPaintDevice):

    class ShareMode(int): ...
    ImplicitlyShared = ... # type: 'QPixmap.ShareMode'
    ExplicitlyShared = ... # type: 'QPixmap.ShareMode'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, w: int, h: int) -> None: ...
    @typing.overload
    def __init__(self, a0: QtCore.QSize) -> None: ...
    @typing.overload
    def __init__(self, fileName: str, format: typing.Optional[str] = ..., flags: typing.Union[QtCore.Qt.ImageConversionFlags, QtCore.Qt.ImageConversionFlag] = ...) -> None: ...
    @typing.overload
    def __init__(self, xpm: typing.List[str]) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QPixmap') -> None: ...
    @typing.overload
    def __init__(self, variant: typing.Any) -> None: ...

    def swap(self, other: 'QPixmap') -> None: ...
    @typing.overload
    def scroll(self, dx: int, dy: int, rect: QtCore.QRect) -> 'QRegion': ...
    @typing.overload
    def scroll(self, dx: int, dy: int, x: int, y: int, width: int, height: int) -> 'QRegion': ...
    @staticmethod
    def fromX11Pixmap(pixmap: int, mode: 'QPixmap.ShareMode' = ...) -> 'QPixmap': ...
    def cacheKey(self) -> int: ...
    def metric(self, a0: QPaintDevice.PaintDeviceMetric) -> int: ...
    def paintEngine(self) -> 'QPaintEngine': ...
    def handle(self) -> int: ...
    def x11Info(self) -> 'QX11Info': ...
    def isQBitmap(self) -> bool: ...
    def x11PictureHandle(self) -> int: ...
    def detach(self) -> None: ...
    def serialNumber(self) -> int: ...
    @typing.overload
    def copy(self, rect: QtCore.QRect = ...) -> 'QPixmap': ...
    @typing.overload
    def copy(self, ax: int, ay: int, awidth: int, aheight: int) -> 'QPixmap': ...
    @typing.overload
    def save(self, fileName: str, format: typing.Optional[str] = ..., quality: int = ...) -> bool: ...
    @typing.overload
    def save(self, device: QtCore.QIODevice, format: typing.Optional[str] = ..., quality: int = ...) -> bool: ...
    @typing.overload
    def loadFromData(self, buf: bytes, format: typing.Optional[str] = ..., flags: typing.Union[QtCore.Qt.ImageConversionFlags, QtCore.Qt.ImageConversionFlag] = ...) -> bool: ...
    @typing.overload
    def loadFromData(self, buf: typing.Union[QtCore.QByteArray, bytes, bytearray], format: typing.Optional[str] = ..., flags: typing.Union[QtCore.Qt.ImageConversionFlags, QtCore.Qt.ImageConversionFlag] = ...) -> bool: ...
    def load(self, fileName: str, format: typing.Optional[str] = ..., flags: typing.Union[QtCore.Qt.ImageConversionFlags, QtCore.Qt.ImageConversionFlag] = ...) -> bool: ...
    def convertFromImage(self, img: 'QImage', flags: typing.Union[QtCore.Qt.ImageConversionFlags, QtCore.Qt.ImageConversionFlag] = ...) -> bool: ...
    @staticmethod
    def fromImageReader(imageReader: 'QImageReader', flags: typing.Union[QtCore.Qt.ImageConversionFlags, QtCore.Qt.ImageConversionFlag] = ...) -> 'QPixmap': ...
    @staticmethod
    def fromImage(image: 'QImage', flags: typing.Union[QtCore.Qt.ImageConversionFlags, QtCore.Qt.ImageConversionFlag] = ...) -> 'QPixmap': ...
    def toImage(self) -> 'QImage': ...
    @typing.overload
    @staticmethod
    def trueMatrix(m: 'QMatrix', w: int, h: int) -> 'QMatrix': ...
    @typing.overload
    @staticmethod
    def trueMatrix(m: 'QTransform', w: int, h: int) -> 'QTransform': ...
    @typing.overload
    def transformed(self, matrix: 'QMatrix', mode: QtCore.Qt.TransformationMode = ...) -> 'QPixmap': ...
    @typing.overload
    def transformed(self, transform: 'QTransform', mode: QtCore.Qt.TransformationMode = ...) -> 'QPixmap': ...
    def scaledToHeight(self, height: int, mode: QtCore.Qt.TransformationMode = ...) -> 'QPixmap': ...
    def scaledToWidth(self, width: int, mode: QtCore.Qt.TransformationMode = ...) -> 'QPixmap': ...
    @typing.overload
    def scaled(self, width: int, height: int, aspectRatioMode: QtCore.Qt.AspectRatioMode = ..., transformMode: QtCore.Qt.TransformationMode = ...) -> 'QPixmap': ...
    @typing.overload
    def scaled(self, size: QtCore.QSize, aspectRatioMode: QtCore.Qt.AspectRatioMode = ..., transformMode: QtCore.Qt.TransformationMode = ...) -> 'QPixmap': ...
    @typing.overload
    @staticmethod
    def grabWidget(widget: QWidget, rect: QtCore.QRect) -> 'QPixmap': ...
    @typing.overload
    @staticmethod
    def grabWidget(widget: QWidget, x: int = ..., y: int = ..., width: int = ..., height: int = ...) -> 'QPixmap': ...
    @staticmethod
    def grabWindow(window: int, x: int = ..., y: int = ..., width: int = ..., height: int = ...) -> 'QPixmap': ...
    @typing.overload
    def createMaskFromColor(self, maskColor: typing.Union['QColor', QtCore.Qt.GlobalColor, 'QGradient'], mode: QtCore.Qt.MaskMode) -> 'QBitmap': ...
    @typing.overload
    def createMaskFromColor(self, maskColor: typing.Union['QColor', QtCore.Qt.GlobalColor, 'QGradient']) -> 'QBitmap': ...
    def createHeuristicMask(self, clipTight: bool = ...) -> 'QBitmap': ...
    def hasAlphaChannel(self) -> bool: ...
    def hasAlpha(self) -> bool: ...
    def setAlphaChannel(self, a0: 'QPixmap') -> None: ...
    def alphaChannel(self) -> 'QPixmap': ...
    def setMask(self, a0: 'QBitmap') -> None: ...
    def mask(self) -> 'QBitmap': ...
    @typing.overload
    def fill(self, color: typing.Union['QColor', QtCore.Qt.GlobalColor, 'QGradient'] = ...) -> None: ...
    @typing.overload
    def fill(self, widget: QWidget, ofs: QtCore.QPoint) -> None: ...
    @typing.overload
    def fill(self, widget: QWidget, xofs: int, yofs: int) -> None: ...
    @staticmethod
    def defaultDepth() -> int: ...
    def depth(self) -> int: ...
    def rect(self) -> QtCore.QRect: ...
    def size(self) -> QtCore.QSize: ...
    def height(self) -> int: ...
    def width(self) -> int: ...
    def devType(self) -> int: ...
    def isNull(self) -> bool: ...


class QBitmap(QPixmap):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: QPixmap) -> None: ...
    @typing.overload
    def __init__(self, w: int, h: int) -> None: ...
    @typing.overload
    def __init__(self, a0: QtCore.QSize) -> None: ...
    @typing.overload
    def __init__(self, fileName: str, format: typing.Optional[str] = ...) -> None: ...
    @typing.overload
    def __init__(self, variant: typing.Any) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QBitmap') -> None: ...

    def swap(self, other: 'QBitmap') -> None: ...
    @typing.overload
    def transformed(self, a0: 'QMatrix') -> 'QBitmap': ...
    @typing.overload
    def transformed(self, matrix: 'QTransform') -> 'QBitmap': ...
    @staticmethod
    def fromData(size: QtCore.QSize, bits: bytes, format: 'QImage.Format' = ...) -> 'QBitmap': ...
    @staticmethod
    def fromImage(image: 'QImage', flags: typing.Union[QtCore.Qt.ImageConversionFlags, QtCore.Qt.ImageConversionFlag] = ...) -> 'QBitmap': ...
    def clear(self) -> None: ...


class QLayoutItem(sip.wrapper):

    @typing.overload
    def __init__(self, alignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag] = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QLayoutItem') -> None: ...

    def controlTypes(self) -> 'QSizePolicy.ControlTypes': ...
    def setAlignment(self, a: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> None: ...
    def alignment(self) -> QtCore.Qt.Alignment: ...
    def spacerItem(self) -> 'QSpacerItem': ...
    def layout(self) -> 'QLayout': ...
    def widget(self) -> QWidget: ...
    def invalidate(self) -> None: ...
    def minimumHeightForWidth(self, a0: int) -> int: ...
    def heightForWidth(self, a0: int) -> int: ...
    def hasHeightForWidth(self) -> bool: ...
    def isEmpty(self) -> bool: ...
    def geometry(self) -> QtCore.QRect: ...
    def setGeometry(self, a0: QtCore.QRect) -> None: ...
    def expandingDirections(self) -> QtCore.Qt.Orientations: ...
    def maximumSize(self) -> QtCore.QSize: ...
    def minimumSize(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...


class QLayout(QtCore.QObject, QLayoutItem):

    class SizeConstraint(int): ...
    SetDefaultConstraint = ... # type: 'QLayout.SizeConstraint'
    SetNoConstraint = ... # type: 'QLayout.SizeConstraint'
    SetMinimumSize = ... # type: 'QLayout.SizeConstraint'
    SetFixedSize = ... # type: 'QLayout.SizeConstraint'
    SetMaximumSize = ... # type: 'QLayout.SizeConstraint'
    SetMinAndMaxSize = ... # type: 'QLayout.SizeConstraint'

    @typing.overload
    def __init__(self, parent: QWidget) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...

    def contentsMargins(self) -> QtCore.QMargins: ...
    def contentsRect(self) -> QtCore.QRect: ...
    def getContentsMargins(self) -> typing.Tuple[int, int, int, int]: ...
    @typing.overload
    def setContentsMargins(self, left: int, top: int, right: int, bottom: int) -> None: ...
    @typing.overload
    def setContentsMargins(self, margins: QtCore.QMargins) -> None: ...
    def alignmentRect(self, a0: QtCore.QRect) -> QtCore.QRect: ...
    def addChildWidget(self, w: QWidget) -> None: ...
    def addChildLayout(self, l: 'QLayout') -> None: ...
    def childEvent(self, e: QtCore.QChildEvent) -> None: ...
    def widgetEvent(self, a0: QtCore.QEvent) -> None: ...
    @staticmethod
    def closestAcceptableSize(w: QWidget, s: QtCore.QSize) -> QtCore.QSize: ...
    def isEnabled(self) -> bool: ...
    def setEnabled(self, a0: bool) -> None: ...
    def layout(self) -> 'QLayout': ...
    def totalSizeHint(self) -> QtCore.QSize: ...
    def totalMaximumSize(self) -> QtCore.QSize: ...
    def totalMinimumSize(self) -> QtCore.QSize: ...
    def totalHeightForWidth(self, w: int) -> int: ...
    def isEmpty(self) -> bool: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def indexOf(self, a0: QWidget) -> int: ...
    def takeAt(self, index: int) -> QLayoutItem: ...
    def itemAt(self, index: int) -> QLayoutItem: ...
    def setGeometry(self, a0: QtCore.QRect) -> None: ...
    def maximumSize(self) -> QtCore.QSize: ...
    def minimumSize(self) -> QtCore.QSize: ...
    def expandingDirections(self) -> QtCore.Qt.Orientations: ...
    def removeItem(self, a0: QLayoutItem) -> None: ...
    def removeWidget(self, w: QWidget) -> None: ...
    def addItem(self, a0: QLayoutItem) -> None: ...
    def addWidget(self, w: QWidget) -> None: ...
    def update(self) -> None: ...
    def activate(self) -> bool: ...
    def geometry(self) -> QtCore.QRect: ...
    def invalidate(self) -> None: ...
    def parentWidget(self) -> QWidget: ...
    def menuBar(self) -> QWidget: ...
    def setMenuBar(self, w: QWidget) -> None: ...
    def sizeConstraint(self) -> 'QLayout.SizeConstraint': ...
    def setSizeConstraint(self, a0: 'QLayout.SizeConstraint') -> None: ...
    @typing.overload
    def setAlignment(self, w: QWidget, alignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> bool: ...
    @typing.overload
    def setAlignment(self, l: 'QLayout', alignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> bool: ...
    @typing.overload
    def setAlignment(self, alignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> None: ...
    def setSpacing(self, a0: int) -> None: ...
    def setMargin(self, a0: int) -> None: ...
    def spacing(self) -> int: ...
    def margin(self) -> int: ...


class QBoxLayout(QLayout):

    class Direction(int): ...
    LeftToRight = ... # type: 'QBoxLayout.Direction'
    RightToLeft = ... # type: 'QBoxLayout.Direction'
    TopToBottom = ... # type: 'QBoxLayout.Direction'
    BottomToTop = ... # type: 'QBoxLayout.Direction'
    Down = ... # type: 'QBoxLayout.Direction'
    Up = ... # type: 'QBoxLayout.Direction'

    def __init__(self, direction: 'QBoxLayout.Direction', parent: typing.Optional[QWidget] = ...) -> None: ...

    def insertItem(self, index: int, a1: QLayoutItem) -> None: ...
    def stretch(self, index: int) -> int: ...
    def setStretch(self, index: int, stretch: int) -> None: ...
    def insertSpacerItem(self, index: int, spacerItem: 'QSpacerItem') -> None: ...
    def addSpacerItem(self, spacerItem: 'QSpacerItem') -> None: ...
    def setSpacing(self, spacing: int) -> None: ...
    def spacing(self) -> int: ...
    def setGeometry(self, a0: QtCore.QRect) -> None: ...
    def count(self) -> int: ...
    def takeAt(self, a0: int) -> QLayoutItem: ...
    def itemAt(self, a0: int) -> QLayoutItem: ...
    def invalidate(self) -> None: ...
    def expandingDirections(self) -> QtCore.Qt.Orientations: ...
    def minimumHeightForWidth(self, a0: int) -> int: ...
    def heightForWidth(self, a0: int) -> int: ...
    def hasHeightForWidth(self) -> bool: ...
    def maximumSize(self) -> QtCore.QSize: ...
    def minimumSize(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...
    @typing.overload
    def setStretchFactor(self, w: QWidget, stretch: int) -> bool: ...
    @typing.overload
    def setStretchFactor(self, l: QLayout, stretch: int) -> bool: ...
    def insertLayout(self, index: int, layout: QLayout, stretch: int = ...) -> None: ...
    def insertWidget(self, index: int, widget: QWidget, stretch: int = ..., alignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag] = ...) -> None: ...
    def insertStretch(self, index: int, stretch: int = ...) -> None: ...
    def insertSpacing(self, index: int, size: int) -> None: ...
    def addItem(self, a0: QLayoutItem) -> None: ...
    def addStrut(self, a0: int) -> None: ...
    def addLayout(self, layout: QLayout, stretch: int = ...) -> None: ...
    def addWidget(self, a0: QWidget, stretch: int = ..., alignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag] = ...) -> None: ...
    def addStretch(self, stretch: int = ...) -> None: ...
    def addSpacing(self, size: int) -> None: ...
    def setDirection(self, a0: 'QBoxLayout.Direction') -> None: ...
    def direction(self) -> 'QBoxLayout.Direction': ...


class QHBoxLayout(QBoxLayout):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, parent: QWidget) -> None: ...


class QVBoxLayout(QBoxLayout):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, parent: QWidget) -> None: ...


class QColor(sip.simplewrapper):

    class Spec(int): ...
    Invalid = ... # type: 'QColor.Spec'
    Rgb = ... # type: 'QColor.Spec'
    Hsv = ... # type: 'QColor.Spec'
    Cmyk = ... # type: 'QColor.Spec'
    Hsl = ... # type: 'QColor.Spec'

    @typing.overload
    def __init__(self, color: QtCore.Qt.GlobalColor) -> None: ...
    @typing.overload
    def __init__(self, rgb: int) -> None: ...
    @typing.overload
    def __init__(self, variant: typing.Any) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, r: int, g: int, b: int, alpha: int = ...) -> None: ...
    @typing.overload
    def __init__(self, aname: str) -> None: ...
    @typing.overload
    def __init__(self, acolor: typing.Union['QColor', QtCore.Qt.GlobalColor, 'QGradient']) -> None: ...

    @staticmethod
    def isValidColor(name: str) -> bool: ...
    @staticmethod
    def fromHslF(h: float, s: float, l: float, alpha: float = ...) -> 'QColor': ...
    @staticmethod
    def fromHsl(h: int, s: int, l: int, alpha: int = ...) -> 'QColor': ...
    def toHsl(self) -> 'QColor': ...
    def setHslF(self, h: float, s: float, l: float, alpha: float = ...) -> None: ...
    def getHslF(self) -> typing.Tuple[float, float, float, float]: ...
    def setHsl(self, h: int, s: int, l: int, alpha: int = ...) -> None: ...
    def getHsl(self) -> typing.Tuple[int, int, int, int]: ...
    def lightnessF(self) -> float: ...
    def hslSaturationF(self) -> float: ...
    def hslHueF(self) -> float: ...
    def lightness(self) -> int: ...
    def hslSaturation(self) -> int: ...
    def hslHue(self) -> int: ...
    def hsvSaturationF(self) -> float: ...
    def hsvHueF(self) -> float: ...
    def hsvSaturation(self) -> int: ...
    def hsvHue(self) -> int: ...
    def darker(self, factor: int = ...) -> 'QColor': ...
    def lighter(self, factor: int = ...) -> 'QColor': ...
    @staticmethod
    def setAllowX11ColorNames(enabled: bool) -> None: ...
    @staticmethod
    def allowX11ColorNames() -> bool: ...
    def isValid(self) -> bool: ...
    def dark(self, factor: int = ...) -> 'QColor': ...
    def light(self, factor: int = ...) -> 'QColor': ...
    @staticmethod
    def fromCmykF(c: float, m: float, y: float, k: float, alpha: float = ...) -> 'QColor': ...
    @staticmethod
    def fromCmyk(c: int, m: int, y: int, k: int, alpha: int = ...) -> 'QColor': ...
    @staticmethod
    def fromHsvF(h: float, s: float, v: float, alpha: float = ...) -> 'QColor': ...
    @staticmethod
    def fromHsv(h: int, s: int, v: int, alpha: int = ...) -> 'QColor': ...
    @staticmethod
    def fromRgbF(r: float, g: float, b: float, alpha: float = ...) -> 'QColor': ...
    @staticmethod
    def fromRgba(rgba: int) -> 'QColor': ...
    @typing.overload
    @staticmethod
    def fromRgb(rgb: int) -> 'QColor': ...
    @typing.overload
    @staticmethod
    def fromRgb(r: int, g: int, b: int, alpha: int = ...) -> 'QColor': ...
    def convertTo(self, colorSpec: 'QColor.Spec') -> 'QColor': ...
    def toCmyk(self) -> 'QColor': ...
    def toHsv(self) -> 'QColor': ...
    def toRgb(self) -> 'QColor': ...
    def setCmykF(self, c: float, m: float, y: float, k: float, alpha: float = ...) -> None: ...
    def getCmykF(self) -> typing.Tuple[float, float, float, float, float]: ...
    def setCmyk(self, c: int, m: int, y: int, k: int, alpha: int = ...) -> None: ...
    def getCmyk(self) -> typing.Tuple[int, int, int, int, int]: ...
    def blackF(self) -> float: ...
    def yellowF(self) -> float: ...
    def magentaF(self) -> float: ...
    def cyanF(self) -> float: ...
    def black(self) -> int: ...
    def yellow(self) -> int: ...
    def magenta(self) -> int: ...
    def cyan(self) -> int: ...
    def setHsvF(self, h: float, s: float, v: float, alpha: float = ...) -> None: ...
    def getHsvF(self) -> typing.Tuple[float, float, float, float]: ...
    def setHsv(self, h: int, s: int, v: int, alpha: int = ...) -> None: ...
    def getHsv(self) -> typing.Tuple[int, int, int, int]: ...
    def valueF(self) -> float: ...
    def saturationF(self) -> float: ...
    def hueF(self) -> float: ...
    def value(self) -> int: ...
    def saturation(self) -> int: ...
    def hue(self) -> int: ...
    def rgb(self) -> int: ...
    def setRgba(self, rgba: int) -> None: ...
    def rgba(self) -> int: ...
    def setRgbF(self, r: float, g: float, b: float, alpha: float = ...) -> None: ...
    def getRgbF(self) -> typing.Tuple[float, float, float, float]: ...
    @typing.overload
    def setRgb(self, r: int, g: int, b: int, alpha: int = ...) -> None: ...
    @typing.overload
    def setRgb(self, rgb: int) -> None: ...
    def getRgb(self) -> typing.Tuple[int, int, int, int]: ...
    def setBlueF(self, blue: float) -> None: ...
    def setGreenF(self, green: float) -> None: ...
    def setRedF(self, red: float) -> None: ...
    def blueF(self) -> float: ...
    def greenF(self) -> float: ...
    def redF(self) -> float: ...
    def setBlue(self, blue: int) -> None: ...
    def setGreen(self, green: int) -> None: ...
    def setRed(self, red: int) -> None: ...
    def blue(self) -> int: ...
    def green(self) -> int: ...
    def red(self) -> int: ...
    def setAlphaF(self, alpha: float) -> None: ...
    def alphaF(self) -> float: ...
    def setAlpha(self, alpha: int) -> None: ...
    def alpha(self) -> int: ...
    def spec(self) -> 'QColor.Spec': ...
    @staticmethod
    def colorNames() -> typing.List[str]: ...
    def setNamedColor(self, name: str) -> None: ...
    def name(self) -> str: ...


class QPushButton(QAbstractButton):

    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str, parent: typing.Optional[QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, icon: 'QIcon', text: str, parent: typing.Optional[QWidget] = ...) -> None: ...

    def focusOutEvent(self, a0: 'QFocusEvent') -> None: ...
    def focusInEvent(self, a0: 'QFocusEvent') -> None: ...
    def keyPressEvent(self, a0: 'QKeyEvent') -> None: ...
    def paintEvent(self, a0: 'QPaintEvent') -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def initStyleOption(self, option: 'QStyleOptionButton') -> None: ...
    def showMenu(self) -> None: ...
    def isFlat(self) -> bool: ...
    def setFlat(self, a0: bool) -> None: ...
    def menu(self) -> 'QMenu': ...
    def setMenu(self, menu: 'QMenu') -> None: ...
    def setDefault(self, a0: bool) -> None: ...
    def isDefault(self) -> bool: ...
    def setAutoDefault(self, a0: bool) -> None: ...
    def autoDefault(self) -> bool: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...


class QCommandLinkButton(QPushButton):

    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str, parent: typing.Optional[QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str, description: str, parent: typing.Optional[QWidget] = ...) -> None: ...

    def paintEvent(self, a0: 'QPaintEvent') -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def heightForWidth(self, a0: int) -> int: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def setDescription(self, description: str) -> None: ...
    def description(self) -> str: ...


class QBrush(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, bs: QtCore.Qt.BrushStyle) -> None: ...
    @typing.overload
    def __init__(self, color: typing.Union[QColor, QtCore.Qt.GlobalColor, 'QGradient'], style: QtCore.Qt.BrushStyle = ...) -> None: ...
    @typing.overload
    def __init__(self, color: typing.Union[QColor, QtCore.Qt.GlobalColor, 'QGradient'], pixmap: QPixmap) -> None: ...
    @typing.overload
    def __init__(self, pixmap: QPixmap) -> None: ...
    @typing.overload
    def __init__(self, image: 'QImage') -> None: ...
    @typing.overload
    def __init__(self, gradient: 'QGradient') -> None: ...
    @typing.overload
    def __init__(self, brush: typing.Union['QBrush', QColor, QtCore.Qt.GlobalColor, 'QGradient']) -> None: ...
    @typing.overload
    def __init__(self, variant: typing.Any) -> None: ...

    def swap(self, other: typing.Union['QBrush', QColor, QtCore.Qt.GlobalColor, 'QGradient']) -> None: ...
    def transform(self) -> 'QTransform': ...
    def setTransform(self, a0: 'QTransform') -> None: ...
    def textureImage(self) -> 'QImage': ...
    def setTextureImage(self, image: 'QImage') -> None: ...
    def matrix(self) -> 'QMatrix': ...
    def setMatrix(self, mat: 'QMatrix') -> None: ...
    def color(self) -> QColor: ...
    def style(self) -> QtCore.Qt.BrushStyle: ...
    def isOpaque(self) -> bool: ...
    def gradient(self) -> 'QGradient': ...
    @typing.overload
    def setColor(self, color: typing.Union[QColor, QtCore.Qt.GlobalColor, 'QGradient']) -> None: ...
    @typing.overload
    def setColor(self, acolor: QtCore.Qt.GlobalColor) -> None: ...
    def setTexture(self, pixmap: QPixmap) -> None: ...
    def texture(self) -> QPixmap: ...
    def setStyle(self, a0: QtCore.Qt.BrushStyle) -> None: ...


class QGradient(sip.simplewrapper):

    class Spread(int): ...
    PadSpread = ... # type: 'QGradient.Spread'
    ReflectSpread = ... # type: 'QGradient.Spread'
    RepeatSpread = ... # type: 'QGradient.Spread'

    class Type(int): ...
    LinearGradient = ... # type: 'QGradient.Type'
    RadialGradient = ... # type: 'QGradient.Type'
    ConicalGradient = ... # type: 'QGradient.Type'
    NoGradient = ... # type: 'QGradient.Type'

    class CoordinateMode(int): ...
    LogicalMode = ... # type: 'QGradient.CoordinateMode'
    StretchToDeviceMode = ... # type: 'QGradient.CoordinateMode'
    ObjectBoundingMode = ... # type: 'QGradient.CoordinateMode'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QGradient') -> None: ...

    def setCoordinateMode(self, mode: 'QGradient.CoordinateMode') -> None: ...
    def coordinateMode(self) -> 'QGradient.CoordinateMode': ...
    def setSpread(self, aspread: 'QGradient.Spread') -> None: ...
    def stops(self) -> typing.List[typing.Tuple[float, QColor]]: ...
    def setStops(self, stops: typing.List[typing.Tuple[float, typing.Union[QColor, QtCore.Qt.GlobalColor, 'QGradient']]]) -> None: ...
    def setColorAt(self, pos: float, color: typing.Union[QColor, QtCore.Qt.GlobalColor, 'QGradient']) -> None: ...
    def spread(self) -> 'QGradient.Spread': ...
    def type(self) -> 'QGradient.Type': ...


class QLinearGradient(QGradient):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, start: typing.Union[QtCore.QPointF, QtCore.QPoint], finalStop: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @typing.overload
    def __init__(self, xStart: float, yStart: float, xFinalStop: float, yFinalStop: float) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QLinearGradient') -> None: ...

    @typing.overload
    def setFinalStop(self, stop: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @typing.overload
    def setFinalStop(self, x: float, y: float) -> None: ...
    @typing.overload
    def setStart(self, start: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @typing.overload
    def setStart(self, x: float, y: float) -> None: ...
    def finalStop(self) -> QtCore.QPointF: ...
    def start(self) -> QtCore.QPointF: ...


class QRadialGradient(QGradient):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, center: typing.Union[QtCore.QPointF, QtCore.QPoint], radius: float, focalPoint: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @typing.overload
    def __init__(self, center: typing.Union[QtCore.QPointF, QtCore.QPoint], centerRadius: float, focalPoint: typing.Union[QtCore.QPointF, QtCore.QPoint], focalRadius: float) -> None: ...
    @typing.overload
    def __init__(self, center: typing.Union[QtCore.QPointF, QtCore.QPoint], radius: float) -> None: ...
    @typing.overload
    def __init__(self, cx: float, cy: float, radius: float, fx: float, fy: float) -> None: ...
    @typing.overload
    def __init__(self, cx: float, cy: float, centerRadius: float, fx: float, fy: float, focalRadius: float) -> None: ...
    @typing.overload
    def __init__(self, cx: float, cy: float, radius: float) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QRadialGradient') -> None: ...

    def setFocalRadius(self, radius: float) -> None: ...
    def focalRadius(self) -> float: ...
    def setCenterRadius(self, radius: float) -> None: ...
    def centerRadius(self) -> float: ...
    def setRadius(self, radius: float) -> None: ...
    @typing.overload
    def setFocalPoint(self, focalPoint: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @typing.overload
    def setFocalPoint(self, x: float, y: float) -> None: ...
    @typing.overload
    def setCenter(self, center: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @typing.overload
    def setCenter(self, x: float, y: float) -> None: ...
    def radius(self) -> float: ...
    def focalPoint(self) -> QtCore.QPointF: ...
    def center(self) -> QtCore.QPointF: ...


class QConicalGradient(QGradient):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, center: typing.Union[QtCore.QPointF, QtCore.QPoint], startAngle: float) -> None: ...
    @typing.overload
    def __init__(self, cx: float, cy: float, startAngle: float) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QConicalGradient') -> None: ...

    def setAngle(self, angle: float) -> None: ...
    @typing.overload
    def setCenter(self, center: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @typing.overload
    def setCenter(self, x: float, y: float) -> None: ...
    def angle(self) -> float: ...
    def center(self) -> QtCore.QPointF: ...


class QButtonGroup(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    @typing.overload
    def buttonReleased(self, a0: QAbstractButton) -> None: ...
    @typing.overload
    def buttonReleased(self, a0: int) -> None: ...
    @typing.overload
    def buttonPressed(self, a0: QAbstractButton) -> None: ...
    @typing.overload
    def buttonPressed(self, a0: int) -> None: ...
    @typing.overload
    def buttonClicked(self, a0: QAbstractButton) -> None: ...
    @typing.overload
    def buttonClicked(self, a0: int) -> None: ...
    def checkedId(self) -> int: ...
    def id(self, button: QAbstractButton) -> int: ...
    def setId(self, button: QAbstractButton, id: int) -> None: ...
    def checkedButton(self) -> QAbstractButton: ...
    def button(self, id: int) -> QAbstractButton: ...
    def buttons(self) -> typing.List[QAbstractButton]: ...
    def removeButton(self, a0: QAbstractButton) -> None: ...
    @typing.overload
    def addButton(self, a0: QAbstractButton) -> None: ...
    @typing.overload
    def addButton(self, a0: QAbstractButton, id: int) -> None: ...
    def exclusive(self) -> bool: ...
    def setExclusive(self, a0: bool) -> None: ...


class QCalendarWidget(QWidget):

    class SelectionMode(int): ...
    NoSelection = ... # type: 'QCalendarWidget.SelectionMode'
    SingleSelection = ... # type: 'QCalendarWidget.SelectionMode'

    class VerticalHeaderFormat(int): ...
    NoVerticalHeader = ... # type: 'QCalendarWidget.VerticalHeaderFormat'
    ISOWeekNumbers = ... # type: 'QCalendarWidget.VerticalHeaderFormat'

    class HorizontalHeaderFormat(int): ...
    NoHorizontalHeader = ... # type: 'QCalendarWidget.HorizontalHeaderFormat'
    SingleLetterDayNames = ... # type: 'QCalendarWidget.HorizontalHeaderFormat'
    ShortDayNames = ... # type: 'QCalendarWidget.HorizontalHeaderFormat'
    LongDayNames = ... # type: 'QCalendarWidget.HorizontalHeaderFormat'

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...

    def setNavigationBarVisible(self, visible: bool) -> None: ...
    def setDateEditAcceptDelay(self, delay: int) -> None: ...
    def dateEditAcceptDelay(self) -> int: ...
    def setDateEditEnabled(self, enable: bool) -> None: ...
    def isDateEditEnabled(self) -> bool: ...
    def isNavigationBarVisible(self) -> bool: ...
    def selectionChanged(self) -> None: ...
    def currentPageChanged(self, year: int, month: int) -> None: ...
    def clicked(self, date: typing.Union[QtCore.QDate, datetime.date]) -> None: ...
    def activated(self, date: typing.Union[QtCore.QDate, datetime.date]) -> None: ...
    def showToday(self) -> None: ...
    def showSelectedDate(self) -> None: ...
    def showPreviousYear(self) -> None: ...
    def showPreviousMonth(self) -> None: ...
    def showNextYear(self) -> None: ...
    def showNextMonth(self) -> None: ...
    def setSelectedDate(self, date: typing.Union[QtCore.QDate, datetime.date]) -> None: ...
    def setDateRange(self, min: typing.Union[QtCore.QDate, datetime.date], max: typing.Union[QtCore.QDate, datetime.date]) -> None: ...
    def setCurrentPage(self, year: int, month: int) -> None: ...
    def paintCell(self, painter: 'QPainter', rect: QtCore.QRect, date: typing.Union[QtCore.QDate, datetime.date]) -> None: ...
    def keyPressEvent(self, event: 'QKeyEvent') -> None: ...
    def resizeEvent(self, event: 'QResizeEvent') -> None: ...
    def mousePressEvent(self, event: 'QMouseEvent') -> None: ...
    def eventFilter(self, watched: QtCore.QObject, event: QtCore.QEvent) -> bool: ...
    def event(self, event: QtCore.QEvent) -> bool: ...
    def updateCells(self) -> None: ...
    def updateCell(self, date: typing.Union[QtCore.QDate, datetime.date]) -> None: ...
    def setDateTextFormat(self, date: typing.Union[QtCore.QDate, datetime.date], color: 'QTextCharFormat') -> None: ...
    @typing.overload
    def dateTextFormat(self) -> typing.Dict[QtCore.QDate, 'QTextCharFormat']: ...
    @typing.overload
    def dateTextFormat(self, date: typing.Union[QtCore.QDate, datetime.date]) -> 'QTextCharFormat': ...
    def setWeekdayTextFormat(self, dayOfWeek: QtCore.Qt.DayOfWeek, format: 'QTextCharFormat') -> None: ...
    def weekdayTextFormat(self, dayOfWeek: QtCore.Qt.DayOfWeek) -> 'QTextCharFormat': ...
    def setHeaderTextFormat(self, format: 'QTextCharFormat') -> None: ...
    def headerTextFormat(self) -> 'QTextCharFormat': ...
    def setVerticalHeaderFormat(self, format: 'QCalendarWidget.VerticalHeaderFormat') -> None: ...
    def verticalHeaderFormat(self) -> 'QCalendarWidget.VerticalHeaderFormat': ...
    def setHorizontalHeaderFormat(self, format: 'QCalendarWidget.HorizontalHeaderFormat') -> None: ...
    def horizontalHeaderFormat(self) -> 'QCalendarWidget.HorizontalHeaderFormat': ...
    def setSelectionMode(self, mode: 'QCalendarWidget.SelectionMode') -> None: ...
    def selectionMode(self) -> 'QCalendarWidget.SelectionMode': ...
    def setGridVisible(self, show: bool) -> None: ...
    def isGridVisible(self) -> bool: ...
    def setHeaderVisible(self, show: bool) -> None: ...
    def isHeaderVisible(self) -> bool: ...
    def setFirstDayOfWeek(self, dayOfWeek: QtCore.Qt.DayOfWeek) -> None: ...
    def firstDayOfWeek(self) -> QtCore.Qt.DayOfWeek: ...
    def setMaximumDate(self, date: typing.Union[QtCore.QDate, datetime.date]) -> None: ...
    def maximumDate(self) -> QtCore.QDate: ...
    def setMinimumDate(self, date: typing.Union[QtCore.QDate, datetime.date]) -> None: ...
    def minimumDate(self) -> QtCore.QDate: ...
    def monthShown(self) -> int: ...
    def yearShown(self) -> int: ...
    def selectedDate(self) -> QtCore.QDate: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...


class QCheckBox(QAbstractButton):

    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str, parent: typing.Optional[QWidget] = ...) -> None: ...

    def initStyleOption(self, option: 'QStyleOptionButton') -> None: ...
    def mouseMoveEvent(self, a0: 'QMouseEvent') -> None: ...
    def paintEvent(self, a0: 'QPaintEvent') -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def nextCheckState(self) -> None: ...
    def checkStateSet(self) -> None: ...
    def hitButton(self, pos: QtCore.QPoint) -> bool: ...
    def stateChanged(self, a0: int) -> None: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def setCheckState(self, state: QtCore.Qt.CheckState) -> None: ...
    def checkState(self) -> QtCore.Qt.CheckState: ...
    def isTristate(self) -> bool: ...
    def setTristate(self, on: bool = ...) -> None: ...
    def sizeHint(self) -> QtCore.QSize: ...


class QClipboard(QtCore.QObject):

    class Mode(int): ...
    Clipboard = ... # type: 'QClipboard.Mode'
    Selection = ... # type: 'QClipboard.Mode'
    FindBuffer = ... # type: 'QClipboard.Mode'

    def event(self, a0: QtCore.QEvent) -> bool: ...
    def connectNotify(self, a0: QT_SIGNAL) -> None: ...
    def selectionChanged(self) -> None: ...
    def findBufferChanged(self) -> None: ...
    def dataChanged(self) -> None: ...
    def changed(self, mode: 'QClipboard.Mode') -> None: ...
    def setPixmap(self, a0: QPixmap, mode: 'QClipboard.Mode' = ...) -> None: ...
    def setImage(self, a0: 'QImage', mode: 'QClipboard.Mode' = ...) -> None: ...
    def pixmap(self, mode: 'QClipboard.Mode' = ...) -> QPixmap: ...
    def image(self, mode: 'QClipboard.Mode' = ...) -> 'QImage': ...
    def setMimeData(self, data: QtCore.QMimeData, mode: 'QClipboard.Mode' = ...) -> None: ...
    def mimeData(self, mode: 'QClipboard.Mode' = ...) -> QtCore.QMimeData: ...
    def setText(self, a0: str, mode: 'QClipboard.Mode' = ...) -> None: ...
    @typing.overload
    def text(self, mode: 'QClipboard.Mode' = ...) -> str: ...
    @typing.overload
    def text(self, subtype: str, mode: 'QClipboard.Mode' = ...) -> typing.Tuple[str, str]: ...
    def ownsSelection(self) -> bool: ...
    def ownsFindBuffer(self) -> bool: ...
    def ownsClipboard(self) -> bool: ...
    def supportsSelection(self) -> bool: ...
    def supportsFindBuffer(self) -> bool: ...
    def clear(self, mode: 'QClipboard.Mode' = ...) -> None: ...


class QColumnView(QAbstractItemView):

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...

    def currentChanged(self, current: QtCore.QModelIndex, previous: QtCore.QModelIndex) -> None: ...
    def rowsInserted(self, parent: QtCore.QModelIndex, start: int, end: int) -> None: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def verticalOffset(self) -> int: ...
    def horizontalOffset(self) -> int: ...
    def visualRegionForSelection(self, selection: 'QItemSelection') -> 'QRegion': ...
    def setSelection(self, rect: QtCore.QRect, command: 'QItemSelectionModel.SelectionFlags') -> None: ...
    def resizeEvent(self, event: 'QResizeEvent') -> None: ...
    def moveCursor(self, cursorAction: QAbstractItemView.CursorAction, modifiers: typing.Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier]) -> QtCore.QModelIndex: ...
    def isIndexHidden(self, index: QtCore.QModelIndex) -> bool: ...
    def initializeColumn(self, column: QAbstractItemView) -> None: ...
    def createColumn(self, rootIndex: QtCore.QModelIndex) -> QAbstractItemView: ...
    def updatePreviewWidget(self, index: QtCore.QModelIndex) -> None: ...
    def selectAll(self) -> None: ...
    def setRootIndex(self, index: QtCore.QModelIndex) -> None: ...
    def setSelectionModel(self, selectionModel: 'QItemSelectionModel') -> None: ...
    def setModel(self, model: QtCore.QAbstractItemModel) -> None: ...
    def visualRect(self, index: QtCore.QModelIndex) -> QtCore.QRect: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def scrollTo(self, index: QtCore.QModelIndex, hint: QAbstractItemView.ScrollHint = ...) -> None: ...
    def indexAt(self, point: QtCore.QPoint) -> QtCore.QModelIndex: ...
    def setResizeGripsVisible(self, visible: bool) -> None: ...
    def setPreviewWidget(self, widget: QWidget) -> None: ...
    def setColumnWidths(self, list: typing.Sequence[int]) -> None: ...
    def resizeGripsVisible(self) -> bool: ...
    def previewWidget(self) -> QWidget: ...
    def columnWidths(self) -> typing.List[int]: ...


class QColorDialog(QDialog):

    class ColorDialogOption(int): ...
    ShowAlphaChannel = ... # type: 'QColorDialog.ColorDialogOption'
    NoButtons = ... # type: 'QColorDialog.ColorDialogOption'
    DontUseNativeDialog = ... # type: 'QColorDialog.ColorDialogOption'

    class ColorDialogOptions(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QColorDialog.ColorDialogOptions', 'QColorDialog.ColorDialogOption']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QColorDialog.ColorDialogOptions') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QColorDialog.ColorDialogOptions': ...
        def __int__(self) -> int: ...

    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, initial: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient], parent: typing.Optional[QWidget] = ...) -> None: ...

    def setVisible(self, visible: bool) -> None: ...
    @typing.overload
    def open(self) -> None: ...
    @typing.overload
    def open(self, receiver: QtCore.QObject, member: QT_SLOT) -> None: ...
    @typing.overload
    def open(self, slot: PYQT_SLOT) -> None: ...
    def options(self) -> 'QColorDialog.ColorDialogOptions': ...
    def setOptions(self, options: 'QColorDialog.ColorDialogOptions') -> None: ...
    def testOption(self, option: 'QColorDialog.ColorDialogOption') -> bool: ...
    def setOption(self, option: 'QColorDialog.ColorDialogOption', on: bool = ...) -> None: ...
    def selectedColor(self) -> QColor: ...
    def currentColor(self) -> QColor: ...
    def setCurrentColor(self, color: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def done(self, result: int) -> None: ...
    def changeEvent(self, e: QtCore.QEvent) -> None: ...
    def currentColorChanged(self, color: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def colorSelected(self, color: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    @staticmethod
    def setStandardColor(a0: int, a1: int) -> None: ...
    @staticmethod
    def setCustomColor(a0: int, a1: int) -> None: ...
    @staticmethod
    def customColor(a0: int) -> int: ...
    @staticmethod
    def customCount() -> int: ...
    @staticmethod
    def getRgba(initial: int = ..., parent: typing.Optional[QWidget] = ...) -> typing.Tuple[int, bool]: ...
    @typing.overload
    @staticmethod
    def getColor(initial: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient] = ..., parent: typing.Optional[QWidget] = ...) -> QColor: ...
    @typing.overload
    @staticmethod
    def getColor(initial: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient], parent: QWidget, title: str, options: 'QColorDialog.ColorDialogOptions' = ...) -> QColor: ...


class QComboBox(QWidget):

    class SizeAdjustPolicy(int): ...
    AdjustToContents = ... # type: 'QComboBox.SizeAdjustPolicy'
    AdjustToContentsOnFirstShow = ... # type: 'QComboBox.SizeAdjustPolicy'
    AdjustToMinimumContentsLength = ... # type: 'QComboBox.SizeAdjustPolicy'
    AdjustToMinimumContentsLengthWithIcon = ... # type: 'QComboBox.SizeAdjustPolicy'

    class InsertPolicy(int): ...
    NoInsert = ... # type: 'QComboBox.InsertPolicy'
    InsertAtTop = ... # type: 'QComboBox.InsertPolicy'
    InsertAtCurrent = ... # type: 'QComboBox.InsertPolicy'
    InsertAtBottom = ... # type: 'QComboBox.InsertPolicy'
    InsertAfterCurrent = ... # type: 'QComboBox.InsertPolicy'
    InsertBeforeCurrent = ... # type: 'QComboBox.InsertPolicy'
    InsertAlphabetically = ... # type: 'QComboBox.InsertPolicy'

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...

    def inputMethodQuery(self, a0: QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def inputMethodEvent(self, a0: 'QInputMethodEvent') -> None: ...
    def contextMenuEvent(self, e: 'QContextMenuEvent') -> None: ...
    def wheelEvent(self, e: 'QWheelEvent') -> None: ...
    def keyReleaseEvent(self, e: 'QKeyEvent') -> None: ...
    def keyPressEvent(self, e: 'QKeyEvent') -> None: ...
    def mouseReleaseEvent(self, e: 'QMouseEvent') -> None: ...
    def mousePressEvent(self, e: 'QMouseEvent') -> None: ...
    def hideEvent(self, e: 'QHideEvent') -> None: ...
    def showEvent(self, e: 'QShowEvent') -> None: ...
    def paintEvent(self, e: 'QPaintEvent') -> None: ...
    def resizeEvent(self, e: 'QResizeEvent') -> None: ...
    def changeEvent(self, e: QtCore.QEvent) -> None: ...
    def focusOutEvent(self, e: 'QFocusEvent') -> None: ...
    def focusInEvent(self, e: 'QFocusEvent') -> None: ...
    def initStyleOption(self, option: 'QStyleOptionComboBox') -> None: ...
    @typing.overload
    def highlighted(self, index: int) -> None: ...
    @typing.overload
    def highlighted(self, a0: str) -> None: ...
    @typing.overload
    def currentIndexChanged(self, index: int) -> None: ...
    @typing.overload
    def currentIndexChanged(self, a0: str) -> None: ...
    @typing.overload
    def activated(self, index: int) -> None: ...
    @typing.overload
    def activated(self, a0: str) -> None: ...
    def editTextChanged(self, a0: str) -> None: ...
    def setEditText(self, text: str) -> None: ...
    def clearEditText(self) -> None: ...
    def clear(self) -> None: ...
    def insertSeparator(self, index: int) -> None: ...
    def completer(self) -> 'QCompleter': ...
    def setCompleter(self, c: 'QCompleter') -> None: ...
    def event(self, event: QtCore.QEvent) -> bool: ...
    def hidePopup(self) -> None: ...
    def showPopup(self) -> None: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def setView(self, itemView: QAbstractItemView) -> None: ...
    def view(self) -> QAbstractItemView: ...
    def setItemData(self, index: int, value: typing.Any, role: int = ...) -> None: ...
    def setItemIcon(self, index: int, icon: 'QIcon') -> None: ...
    def setItemText(self, index: int, text: str) -> None: ...
    def removeItem(self, index: int) -> None: ...
    def insertItems(self, index: int, texts: typing.Sequence[str]) -> None: ...
    @typing.overload
    def insertItem(self, index: int, text: str, userData: typing.Any = ...) -> None: ...
    @typing.overload
    def insertItem(self, index: int, icon: 'QIcon', text: str, userData: typing.Any = ...) -> None: ...
    @typing.overload
    def addItem(self, text: str, userData: typing.Any = ...) -> None: ...
    @typing.overload
    def addItem(self, icon: 'QIcon', text: str, userData: typing.Any = ...) -> None: ...
    def addItems(self, texts: typing.Sequence[str]) -> None: ...
    def itemData(self, index: int, role: int = ...) -> typing.Any: ...
    def itemIcon(self, index: int) -> 'QIcon': ...
    def itemText(self, index: int) -> str: ...
    def currentText(self) -> str: ...
    def setCurrentIndex(self, index: int) -> None: ...
    def currentIndex(self) -> int: ...
    def setModelColumn(self, visibleColumn: int) -> None: ...
    def modelColumn(self) -> int: ...
    def setRootModelIndex(self, index: QtCore.QModelIndex) -> None: ...
    def rootModelIndex(self) -> QtCore.QModelIndex: ...
    def setModel(self, model: QtCore.QAbstractItemModel) -> None: ...
    def model(self) -> QtCore.QAbstractItemModel: ...
    def setItemDelegate(self, delegate: QAbstractItemDelegate) -> None: ...
    def itemDelegate(self) -> QAbstractItemDelegate: ...
    def validator(self) -> 'QValidator': ...
    def setValidator(self, v: 'QValidator') -> None: ...
    def lineEdit(self) -> 'QLineEdit': ...
    def setLineEdit(self, edit: 'QLineEdit') -> None: ...
    def setEditable(self, editable: bool) -> None: ...
    def isEditable(self) -> bool: ...
    def setIconSize(self, size: QtCore.QSize) -> None: ...
    def iconSize(self) -> QtCore.QSize: ...
    def setMinimumContentsLength(self, characters: int) -> None: ...
    def minimumContentsLength(self) -> int: ...
    def setSizeAdjustPolicy(self, policy: 'QComboBox.SizeAdjustPolicy') -> None: ...
    def sizeAdjustPolicy(self) -> 'QComboBox.SizeAdjustPolicy': ...
    def setInsertPolicy(self, policy: 'QComboBox.InsertPolicy') -> None: ...
    def insertPolicy(self) -> 'QComboBox.InsertPolicy': ...
    def findData(self, data: typing.Any, role: int = ..., flags: typing.Union[QtCore.Qt.MatchFlags, QtCore.Qt.MatchFlag] = ...) -> int: ...
    def findText(self, text: str, flags: typing.Union[QtCore.Qt.MatchFlags, QtCore.Qt.MatchFlag] = ...) -> int: ...
    def hasFrame(self) -> bool: ...
    def setFrame(self, a0: bool) -> None: ...
    def setDuplicatesEnabled(self, enable: bool) -> None: ...
    def duplicatesEnabled(self) -> bool: ...
    def setAutoCompletionCaseSensitivity(self, sensitivity: QtCore.Qt.CaseSensitivity) -> None: ...
    def autoCompletionCaseSensitivity(self) -> QtCore.Qt.CaseSensitivity: ...
    def setAutoCompletion(self, enable: bool) -> None: ...
    def autoCompletion(self) -> bool: ...
    def maxCount(self) -> int: ...
    def setMaxCount(self, max: int) -> None: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def setMaxVisibleItems(self, maxItems: int) -> None: ...
    def maxVisibleItems(self) -> int: ...


class QStyle(QtCore.QObject):

    class RequestSoftwareInputPanel(int): ...
    RSIP_OnMouseClickAndAlreadyFocused = ... # type: 'QStyle.RequestSoftwareInputPanel'
    RSIP_OnMouseClick = ... # type: 'QStyle.RequestSoftwareInputPanel'

    class StandardPixmap(int): ...
    SP_TitleBarMenuButton = ... # type: 'QStyle.StandardPixmap'
    SP_TitleBarMinButton = ... # type: 'QStyle.StandardPixmap'
    SP_TitleBarMaxButton = ... # type: 'QStyle.StandardPixmap'
    SP_TitleBarCloseButton = ... # type: 'QStyle.StandardPixmap'
    SP_TitleBarNormalButton = ... # type: 'QStyle.StandardPixmap'
    SP_TitleBarShadeButton = ... # type: 'QStyle.StandardPixmap'
    SP_TitleBarUnshadeButton = ... # type: 'QStyle.StandardPixmap'
    SP_TitleBarContextHelpButton = ... # type: 'QStyle.StandardPixmap'
    SP_DockWidgetCloseButton = ... # type: 'QStyle.StandardPixmap'
    SP_MessageBoxInformation = ... # type: 'QStyle.StandardPixmap'
    SP_MessageBoxWarning = ... # type: 'QStyle.StandardPixmap'
    SP_MessageBoxCritical = ... # type: 'QStyle.StandardPixmap'
    SP_MessageBoxQuestion = ... # type: 'QStyle.StandardPixmap'
    SP_DesktopIcon = ... # type: 'QStyle.StandardPixmap'
    SP_TrashIcon = ... # type: 'QStyle.StandardPixmap'
    SP_ComputerIcon = ... # type: 'QStyle.StandardPixmap'
    SP_DriveFDIcon = ... # type: 'QStyle.StandardPixmap'
    SP_DriveHDIcon = ... # type: 'QStyle.StandardPixmap'
    SP_DriveCDIcon = ... # type: 'QStyle.StandardPixmap'
    SP_DriveDVDIcon = ... # type: 'QStyle.StandardPixmap'
    SP_DriveNetIcon = ... # type: 'QStyle.StandardPixmap'
    SP_DirOpenIcon = ... # type: 'QStyle.StandardPixmap'
    SP_DirClosedIcon = ... # type: 'QStyle.StandardPixmap'
    SP_DirLinkIcon = ... # type: 'QStyle.StandardPixmap'
    SP_FileIcon = ... # type: 'QStyle.StandardPixmap'
    SP_FileLinkIcon = ... # type: 'QStyle.StandardPixmap'
    SP_ToolBarHorizontalExtensionButton = ... # type: 'QStyle.StandardPixmap'
    SP_ToolBarVerticalExtensionButton = ... # type: 'QStyle.StandardPixmap'
    SP_FileDialogStart = ... # type: 'QStyle.StandardPixmap'
    SP_FileDialogEnd = ... # type: 'QStyle.StandardPixmap'
    SP_FileDialogToParent = ... # type: 'QStyle.StandardPixmap'
    SP_FileDialogNewFolder = ... # type: 'QStyle.StandardPixmap'
    SP_FileDialogDetailedView = ... # type: 'QStyle.StandardPixmap'
    SP_FileDialogInfoView = ... # type: 'QStyle.StandardPixmap'
    SP_FileDialogContentsView = ... # type: 'QStyle.StandardPixmap'
    SP_FileDialogListView = ... # type: 'QStyle.StandardPixmap'
    SP_FileDialogBack = ... # type: 'QStyle.StandardPixmap'
    SP_DirIcon = ... # type: 'QStyle.StandardPixmap'
    SP_DialogOkButton = ... # type: 'QStyle.StandardPixmap'
    SP_DialogCancelButton = ... # type: 'QStyle.StandardPixmap'
    SP_DialogHelpButton = ... # type: 'QStyle.StandardPixmap'
    SP_DialogOpenButton = ... # type: 'QStyle.StandardPixmap'
    SP_DialogSaveButton = ... # type: 'QStyle.StandardPixmap'
    SP_DialogCloseButton = ... # type: 'QStyle.StandardPixmap'
    SP_DialogApplyButton = ... # type: 'QStyle.StandardPixmap'
    SP_DialogResetButton = ... # type: 'QStyle.StandardPixmap'
    SP_DialogDiscardButton = ... # type: 'QStyle.StandardPixmap'
    SP_DialogYesButton = ... # type: 'QStyle.StandardPixmap'
    SP_DialogNoButton = ... # type: 'QStyle.StandardPixmap'
    SP_ArrowUp = ... # type: 'QStyle.StandardPixmap'
    SP_ArrowDown = ... # type: 'QStyle.StandardPixmap'
    SP_ArrowLeft = ... # type: 'QStyle.StandardPixmap'
    SP_ArrowRight = ... # type: 'QStyle.StandardPixmap'
    SP_ArrowBack = ... # type: 'QStyle.StandardPixmap'
    SP_ArrowForward = ... # type: 'QStyle.StandardPixmap'
    SP_DirHomeIcon = ... # type: 'QStyle.StandardPixmap'
    SP_CommandLink = ... # type: 'QStyle.StandardPixmap'
    SP_VistaShield = ... # type: 'QStyle.StandardPixmap'
    SP_BrowserReload = ... # type: 'QStyle.StandardPixmap'
    SP_BrowserStop = ... # type: 'QStyle.StandardPixmap'
    SP_MediaPlay = ... # type: 'QStyle.StandardPixmap'
    SP_MediaStop = ... # type: 'QStyle.StandardPixmap'
    SP_MediaPause = ... # type: 'QStyle.StandardPixmap'
    SP_MediaSkipForward = ... # type: 'QStyle.StandardPixmap'
    SP_MediaSkipBackward = ... # type: 'QStyle.StandardPixmap'
    SP_MediaSeekForward = ... # type: 'QStyle.StandardPixmap'
    SP_MediaSeekBackward = ... # type: 'QStyle.StandardPixmap'
    SP_MediaVolume = ... # type: 'QStyle.StandardPixmap'
    SP_MediaVolumeMuted = ... # type: 'QStyle.StandardPixmap'
    SP_CustomBase = ... # type: 'QStyle.StandardPixmap'

    class StyleHint(int): ...
    SH_EtchDisabledText = ... # type: 'QStyle.StyleHint'
    SH_DitherDisabledText = ... # type: 'QStyle.StyleHint'
    SH_ScrollBar_MiddleClickAbsolutePosition = ... # type: 'QStyle.StyleHint'
    SH_ScrollBar_ScrollWhenPointerLeavesControl = ... # type: 'QStyle.StyleHint'
    SH_TabBar_SelectMouseType = ... # type: 'QStyle.StyleHint'
    SH_TabBar_Alignment = ... # type: 'QStyle.StyleHint'
    SH_Header_ArrowAlignment = ... # type: 'QStyle.StyleHint'
    SH_Slider_SnapToValue = ... # type: 'QStyle.StyleHint'
    SH_Slider_SloppyKeyEvents = ... # type: 'QStyle.StyleHint'
    SH_ProgressDialog_CenterCancelButton = ... # type: 'QStyle.StyleHint'
    SH_ProgressDialog_TextLabelAlignment = ... # type: 'QStyle.StyleHint'
    SH_PrintDialog_RightAlignButtons = ... # type: 'QStyle.StyleHint'
    SH_MainWindow_SpaceBelowMenuBar = ... # type: 'QStyle.StyleHint'
    SH_FontDialog_SelectAssociatedText = ... # type: 'QStyle.StyleHint'
    SH_Menu_AllowActiveAndDisabled = ... # type: 'QStyle.StyleHint'
    SH_Menu_SpaceActivatesItem = ... # type: 'QStyle.StyleHint'
    SH_Menu_SubMenuPopupDelay = ... # type: 'QStyle.StyleHint'
    SH_ScrollView_FrameOnlyAroundContents = ... # type: 'QStyle.StyleHint'
    SH_MenuBar_AltKeyNavigation = ... # type: 'QStyle.StyleHint'
    SH_ComboBox_ListMouseTracking = ... # type: 'QStyle.StyleHint'
    SH_Menu_MouseTracking = ... # type: 'QStyle.StyleHint'
    SH_MenuBar_MouseTracking = ... # type: 'QStyle.StyleHint'
    SH_ItemView_ChangeHighlightOnFocus = ... # type: 'QStyle.StyleHint'
    SH_Widget_ShareActivation = ... # type: 'QStyle.StyleHint'
    SH_Workspace_FillSpaceOnMaximize = ... # type: 'QStyle.StyleHint'
    SH_ComboBox_Popup = ... # type: 'QStyle.StyleHint'
    SH_TitleBar_NoBorder = ... # type: 'QStyle.StyleHint'
    SH_ScrollBar_StopMouseOverSlider = ... # type: 'QStyle.StyleHint'
    SH_BlinkCursorWhenTextSelected = ... # type: 'QStyle.StyleHint'
    SH_RichText_FullWidthSelection = ... # type: 'QStyle.StyleHint'
    SH_Menu_Scrollable = ... # type: 'QStyle.StyleHint'
    SH_GroupBox_TextLabelVerticalAlignment = ... # type: 'QStyle.StyleHint'
    SH_GroupBox_TextLabelColor = ... # type: 'QStyle.StyleHint'
    SH_Menu_SloppySubMenus = ... # type: 'QStyle.StyleHint'
    SH_Table_GridLineColor = ... # type: 'QStyle.StyleHint'
    SH_LineEdit_PasswordCharacter = ... # type: 'QStyle.StyleHint'
    SH_DialogButtons_DefaultButton = ... # type: 'QStyle.StyleHint'
    SH_ToolBox_SelectedPageTitleBold = ... # type: 'QStyle.StyleHint'
    SH_TabBar_PreferNoArrows = ... # type: 'QStyle.StyleHint'
    SH_ScrollBar_LeftClickAbsolutePosition = ... # type: 'QStyle.StyleHint'
    SH_Q3ListViewExpand_SelectMouseType = ... # type: 'QStyle.StyleHint'
    SH_UnderlineShortcut = ... # type: 'QStyle.StyleHint'
    SH_SpinBox_AnimateButton = ... # type: 'QStyle.StyleHint'
    SH_SpinBox_KeyPressAutoRepeatRate = ... # type: 'QStyle.StyleHint'
    SH_SpinBox_ClickAutoRepeatRate = ... # type: 'QStyle.StyleHint'
    SH_Menu_FillScreenWithScroll = ... # type: 'QStyle.StyleHint'
    SH_ToolTipLabel_Opacity = ... # type: 'QStyle.StyleHint'
    SH_DrawMenuBarSeparator = ... # type: 'QStyle.StyleHint'
    SH_TitleBar_ModifyNotification = ... # type: 'QStyle.StyleHint'
    SH_Button_FocusPolicy = ... # type: 'QStyle.StyleHint'
    SH_MenuBar_DismissOnSecondClick = ... # type: 'QStyle.StyleHint'
    SH_MessageBox_UseBorderForButtonSpacing = ... # type: 'QStyle.StyleHint'
    SH_TitleBar_AutoRaise = ... # type: 'QStyle.StyleHint'
    SH_ToolButton_PopupDelay = ... # type: 'QStyle.StyleHint'
    SH_FocusFrame_Mask = ... # type: 'QStyle.StyleHint'
    SH_RubberBand_Mask = ... # type: 'QStyle.StyleHint'
    SH_WindowFrame_Mask = ... # type: 'QStyle.StyleHint'
    SH_SpinControls_DisableOnBounds = ... # type: 'QStyle.StyleHint'
    SH_Dial_BackgroundRole = ... # type: 'QStyle.StyleHint'
    SH_ComboBox_LayoutDirection = ... # type: 'QStyle.StyleHint'
    SH_ItemView_EllipsisLocation = ... # type: 'QStyle.StyleHint'
    SH_ItemView_ShowDecorationSelected = ... # type: 'QStyle.StyleHint'
    SH_ItemView_ActivateItemOnSingleClick = ... # type: 'QStyle.StyleHint'
    SH_ScrollBar_ContextMenu = ... # type: 'QStyle.StyleHint'
    SH_ScrollBar_RollBetweenButtons = ... # type: 'QStyle.StyleHint'
    SH_Slider_StopMouseOverSlider = ... # type: 'QStyle.StyleHint'
    SH_Slider_AbsoluteSetButtons = ... # type: 'QStyle.StyleHint'
    SH_Slider_PageSetButtons = ... # type: 'QStyle.StyleHint'
    SH_Menu_KeyboardSearch = ... # type: 'QStyle.StyleHint'
    SH_TabBar_ElideMode = ... # type: 'QStyle.StyleHint'
    SH_DialogButtonLayout = ... # type: 'QStyle.StyleHint'
    SH_ComboBox_PopupFrameStyle = ... # type: 'QStyle.StyleHint'
    SH_MessageBox_TextInteractionFlags = ... # type: 'QStyle.StyleHint'
    SH_DialogButtonBox_ButtonsHaveIcons = ... # type: 'QStyle.StyleHint'
    SH_SpellCheckUnderlineStyle = ... # type: 'QStyle.StyleHint'
    SH_MessageBox_CenterButtons = ... # type: 'QStyle.StyleHint'
    SH_Menu_SelectionWrap = ... # type: 'QStyle.StyleHint'
    SH_ItemView_MovementWithoutUpdatingSelection = ... # type: 'QStyle.StyleHint'
    SH_ToolTip_Mask = ... # type: 'QStyle.StyleHint'
    SH_FocusFrame_AboveWidget = ... # type: 'QStyle.StyleHint'
    SH_TextControl_FocusIndicatorTextCharFormat = ... # type: 'QStyle.StyleHint'
    SH_WizardStyle = ... # type: 'QStyle.StyleHint'
    SH_ItemView_ArrowKeysNavigateIntoChildren = ... # type: 'QStyle.StyleHint'
    SH_Menu_Mask = ... # type: 'QStyle.StyleHint'
    SH_Menu_FlashTriggeredItem = ... # type: 'QStyle.StyleHint'
    SH_Menu_FadeOutOnHide = ... # type: 'QStyle.StyleHint'
    SH_SpinBox_ClickAutoRepeatThreshold = ... # type: 'QStyle.StyleHint'
    SH_ItemView_PaintAlternatingRowColorsForEmptyArea = ... # type: 'QStyle.StyleHint'
    SH_FormLayoutWrapPolicy = ... # type: 'QStyle.StyleHint'
    SH_TabWidget_DefaultTabPosition = ... # type: 'QStyle.StyleHint'
    SH_ToolBar_Movable = ... # type: 'QStyle.StyleHint'
    SH_FormLayoutFieldGrowthPolicy = ... # type: 'QStyle.StyleHint'
    SH_FormLayoutFormAlignment = ... # type: 'QStyle.StyleHint'
    SH_FormLayoutLabelAlignment = ... # type: 'QStyle.StyleHint'
    SH_ItemView_DrawDelegateFrame = ... # type: 'QStyle.StyleHint'
    SH_TabBar_CloseButtonPosition = ... # type: 'QStyle.StyleHint'
    SH_DockWidget_ButtonsHaveFrame = ... # type: 'QStyle.StyleHint'
    SH_ToolButtonStyle = ... # type: 'QStyle.StyleHint'
    SH_RequestSoftwareInputPanel = ... # type: 'QStyle.StyleHint'
    SH_CustomBase = ... # type: 'QStyle.StyleHint'

    class ContentsType(int): ...
    CT_PushButton = ... # type: 'QStyle.ContentsType'
    CT_CheckBox = ... # type: 'QStyle.ContentsType'
    CT_RadioButton = ... # type: 'QStyle.ContentsType'
    CT_ToolButton = ... # type: 'QStyle.ContentsType'
    CT_ComboBox = ... # type: 'QStyle.ContentsType'
    CT_Splitter = ... # type: 'QStyle.ContentsType'
    CT_Q3DockWindow = ... # type: 'QStyle.ContentsType'
    CT_ProgressBar = ... # type: 'QStyle.ContentsType'
    CT_MenuItem = ... # type: 'QStyle.ContentsType'
    CT_MenuBarItem = ... # type: 'QStyle.ContentsType'
    CT_MenuBar = ... # type: 'QStyle.ContentsType'
    CT_Menu = ... # type: 'QStyle.ContentsType'
    CT_TabBarTab = ... # type: 'QStyle.ContentsType'
    CT_Slider = ... # type: 'QStyle.ContentsType'
    CT_ScrollBar = ... # type: 'QStyle.ContentsType'
    CT_Q3Header = ... # type: 'QStyle.ContentsType'
    CT_LineEdit = ... # type: 'QStyle.ContentsType'
    CT_SpinBox = ... # type: 'QStyle.ContentsType'
    CT_SizeGrip = ... # type: 'QStyle.ContentsType'
    CT_TabWidget = ... # type: 'QStyle.ContentsType'
    CT_DialogButtons = ... # type: 'QStyle.ContentsType'
    CT_HeaderSection = ... # type: 'QStyle.ContentsType'
    CT_GroupBox = ... # type: 'QStyle.ContentsType'
    CT_MdiControls = ... # type: 'QStyle.ContentsType'
    CT_ItemViewItem = ... # type: 'QStyle.ContentsType'
    CT_CustomBase = ... # type: 'QStyle.ContentsType'

    class PixelMetric(int): ...
    PM_ButtonMargin = ... # type: 'QStyle.PixelMetric'
    PM_ButtonDefaultIndicator = ... # type: 'QStyle.PixelMetric'
    PM_MenuButtonIndicator = ... # type: 'QStyle.PixelMetric'
    PM_ButtonShiftHorizontal = ... # type: 'QStyle.PixelMetric'
    PM_ButtonShiftVertical = ... # type: 'QStyle.PixelMetric'
    PM_DefaultFrameWidth = ... # type: 'QStyle.PixelMetric'
    PM_SpinBoxFrameWidth = ... # type: 'QStyle.PixelMetric'
    PM_ComboBoxFrameWidth = ... # type: 'QStyle.PixelMetric'
    PM_MaximumDragDistance = ... # type: 'QStyle.PixelMetric'
    PM_ScrollBarExtent = ... # type: 'QStyle.PixelMetric'
    PM_ScrollBarSliderMin = ... # type: 'QStyle.PixelMetric'
    PM_SliderThickness = ... # type: 'QStyle.PixelMetric'
    PM_SliderControlThickness = ... # type: 'QStyle.PixelMetric'
    PM_SliderLength = ... # type: 'QStyle.PixelMetric'
    PM_SliderTickmarkOffset = ... # type: 'QStyle.PixelMetric'
    PM_SliderSpaceAvailable = ... # type: 'QStyle.PixelMetric'
    PM_DockWidgetSeparatorExtent = ... # type: 'QStyle.PixelMetric'
    PM_DockWidgetHandleExtent = ... # type: 'QStyle.PixelMetric'
    PM_DockWidgetFrameWidth = ... # type: 'QStyle.PixelMetric'
    PM_TabBarTabOverlap = ... # type: 'QStyle.PixelMetric'
    PM_TabBarTabHSpace = ... # type: 'QStyle.PixelMetric'
    PM_TabBarTabVSpace = ... # type: 'QStyle.PixelMetric'
    PM_TabBarBaseHeight = ... # type: 'QStyle.PixelMetric'
    PM_TabBarBaseOverlap = ... # type: 'QStyle.PixelMetric'
    PM_ProgressBarChunkWidth = ... # type: 'QStyle.PixelMetric'
    PM_SplitterWidth = ... # type: 'QStyle.PixelMetric'
    PM_TitleBarHeight = ... # type: 'QStyle.PixelMetric'
    PM_MenuScrollerHeight = ... # type: 'QStyle.PixelMetric'
    PM_MenuHMargin = ... # type: 'QStyle.PixelMetric'
    PM_MenuVMargin = ... # type: 'QStyle.PixelMetric'
    PM_MenuPanelWidth = ... # type: 'QStyle.PixelMetric'
    PM_MenuTearoffHeight = ... # type: 'QStyle.PixelMetric'
    PM_MenuDesktopFrameWidth = ... # type: 'QStyle.PixelMetric'
    PM_MenuBarPanelWidth = ... # type: 'QStyle.PixelMetric'
    PM_MenuBarItemSpacing = ... # type: 'QStyle.PixelMetric'
    PM_MenuBarVMargin = ... # type: 'QStyle.PixelMetric'
    PM_MenuBarHMargin = ... # type: 'QStyle.PixelMetric'
    PM_IndicatorWidth = ... # type: 'QStyle.PixelMetric'
    PM_IndicatorHeight = ... # type: 'QStyle.PixelMetric'
    PM_ExclusiveIndicatorWidth = ... # type: 'QStyle.PixelMetric'
    PM_ExclusiveIndicatorHeight = ... # type: 'QStyle.PixelMetric'
    PM_CheckListButtonSize = ... # type: 'QStyle.PixelMetric'
    PM_CheckListControllerSize = ... # type: 'QStyle.PixelMetric'
    PM_DialogButtonsSeparator = ... # type: 'QStyle.PixelMetric'
    PM_DialogButtonsButtonWidth = ... # type: 'QStyle.PixelMetric'
    PM_DialogButtonsButtonHeight = ... # type: 'QStyle.PixelMetric'
    PM_MdiSubWindowFrameWidth = ... # type: 'QStyle.PixelMetric'
    PM_MDIFrameWidth = ... # type: 'QStyle.PixelMetric'
    PM_MdiSubWindowMinimizedWidth = ... # type: 'QStyle.PixelMetric'
    PM_MDIMinimizedWidth = ... # type: 'QStyle.PixelMetric'
    PM_HeaderMargin = ... # type: 'QStyle.PixelMetric'
    PM_HeaderMarkSize = ... # type: 'QStyle.PixelMetric'
    PM_HeaderGripMargin = ... # type: 'QStyle.PixelMetric'
    PM_TabBarTabShiftHorizontal = ... # type: 'QStyle.PixelMetric'
    PM_TabBarTabShiftVertical = ... # type: 'QStyle.PixelMetric'
    PM_TabBarScrollButtonWidth = ... # type: 'QStyle.PixelMetric'
    PM_ToolBarFrameWidth = ... # type: 'QStyle.PixelMetric'
    PM_ToolBarHandleExtent = ... # type: 'QStyle.PixelMetric'
    PM_ToolBarItemSpacing = ... # type: 'QStyle.PixelMetric'
    PM_ToolBarItemMargin = ... # type: 'QStyle.PixelMetric'
    PM_ToolBarSeparatorExtent = ... # type: 'QStyle.PixelMetric'
    PM_ToolBarExtensionExtent = ... # type: 'QStyle.PixelMetric'
    PM_SpinBoxSliderHeight = ... # type: 'QStyle.PixelMetric'
    PM_DefaultTopLevelMargin = ... # type: 'QStyle.PixelMetric'
    PM_DefaultChildMargin = ... # type: 'QStyle.PixelMetric'
    PM_DefaultLayoutSpacing = ... # type: 'QStyle.PixelMetric'
    PM_ToolBarIconSize = ... # type: 'QStyle.PixelMetric'
    PM_ListViewIconSize = ... # type: 'QStyle.PixelMetric'
    PM_IconViewIconSize = ... # type: 'QStyle.PixelMetric'
    PM_SmallIconSize = ... # type: 'QStyle.PixelMetric'
    PM_LargeIconSize = ... # type: 'QStyle.PixelMetric'
    PM_FocusFrameVMargin = ... # type: 'QStyle.PixelMetric'
    PM_FocusFrameHMargin = ... # type: 'QStyle.PixelMetric'
    PM_ToolTipLabelFrameWidth = ... # type: 'QStyle.PixelMetric'
    PM_CheckBoxLabelSpacing = ... # type: 'QStyle.PixelMetric'
    PM_TabBarIconSize = ... # type: 'QStyle.PixelMetric'
    PM_SizeGripSize = ... # type: 'QStyle.PixelMetric'
    PM_DockWidgetTitleMargin = ... # type: 'QStyle.PixelMetric'
    PM_MessageBoxIconSize = ... # type: 'QStyle.PixelMetric'
    PM_ButtonIconSize = ... # type: 'QStyle.PixelMetric'
    PM_DockWidgetTitleBarButtonMargin = ... # type: 'QStyle.PixelMetric'
    PM_RadioButtonLabelSpacing = ... # type: 'QStyle.PixelMetric'
    PM_LayoutLeftMargin = ... # type: 'QStyle.PixelMetric'
    PM_LayoutTopMargin = ... # type: 'QStyle.PixelMetric'
    PM_LayoutRightMargin = ... # type: 'QStyle.PixelMetric'
    PM_LayoutBottomMargin = ... # type: 'QStyle.PixelMetric'
    PM_LayoutHorizontalSpacing = ... # type: 'QStyle.PixelMetric'
    PM_LayoutVerticalSpacing = ... # type: 'QStyle.PixelMetric'
    PM_TabBar_ScrollButtonOverlap = ... # type: 'QStyle.PixelMetric'
    PM_TextCursorWidth = ... # type: 'QStyle.PixelMetric'
    PM_TabCloseIndicatorWidth = ... # type: 'QStyle.PixelMetric'
    PM_TabCloseIndicatorHeight = ... # type: 'QStyle.PixelMetric'
    PM_ScrollView_ScrollBarSpacing = ... # type: 'QStyle.PixelMetric'
    PM_SubMenuOverlap = ... # type: 'QStyle.PixelMetric'
    PM_CustomBase = ... # type: 'QStyle.PixelMetric'

    class SubControl(int): ...
    SC_None = ... # type: 'QStyle.SubControl'
    SC_ScrollBarAddLine = ... # type: 'QStyle.SubControl'
    SC_ScrollBarSubLine = ... # type: 'QStyle.SubControl'
    SC_ScrollBarAddPage = ... # type: 'QStyle.SubControl'
    SC_ScrollBarSubPage = ... # type: 'QStyle.SubControl'
    SC_ScrollBarFirst = ... # type: 'QStyle.SubControl'
    SC_ScrollBarLast = ... # type: 'QStyle.SubControl'
    SC_ScrollBarSlider = ... # type: 'QStyle.SubControl'
    SC_ScrollBarGroove = ... # type: 'QStyle.SubControl'
    SC_SpinBoxUp = ... # type: 'QStyle.SubControl'
    SC_SpinBoxDown = ... # type: 'QStyle.SubControl'
    SC_SpinBoxFrame = ... # type: 'QStyle.SubControl'
    SC_SpinBoxEditField = ... # type: 'QStyle.SubControl'
    SC_ComboBoxFrame = ... # type: 'QStyle.SubControl'
    SC_ComboBoxEditField = ... # type: 'QStyle.SubControl'
    SC_ComboBoxArrow = ... # type: 'QStyle.SubControl'
    SC_ComboBoxListBoxPopup = ... # type: 'QStyle.SubControl'
    SC_SliderGroove = ... # type: 'QStyle.SubControl'
    SC_SliderHandle = ... # type: 'QStyle.SubControl'
    SC_SliderTickmarks = ... # type: 'QStyle.SubControl'
    SC_ToolButton = ... # type: 'QStyle.SubControl'
    SC_ToolButtonMenu = ... # type: 'QStyle.SubControl'
    SC_TitleBarSysMenu = ... # type: 'QStyle.SubControl'
    SC_TitleBarMinButton = ... # type: 'QStyle.SubControl'
    SC_TitleBarMaxButton = ... # type: 'QStyle.SubControl'
    SC_TitleBarCloseButton = ... # type: 'QStyle.SubControl'
    SC_TitleBarNormalButton = ... # type: 'QStyle.SubControl'
    SC_TitleBarShadeButton = ... # type: 'QStyle.SubControl'
    SC_TitleBarUnshadeButton = ... # type: 'QStyle.SubControl'
    SC_TitleBarContextHelpButton = ... # type: 'QStyle.SubControl'
    SC_TitleBarLabel = ... # type: 'QStyle.SubControl'
    SC_Q3ListView = ... # type: 'QStyle.SubControl'
    SC_Q3ListViewBranch = ... # type: 'QStyle.SubControl'
    SC_Q3ListViewExpand = ... # type: 'QStyle.SubControl'
    SC_DialGroove = ... # type: 'QStyle.SubControl'
    SC_DialHandle = ... # type: 'QStyle.SubControl'
    SC_DialTickmarks = ... # type: 'QStyle.SubControl'
    SC_GroupBoxCheckBox = ... # type: 'QStyle.SubControl'
    SC_GroupBoxLabel = ... # type: 'QStyle.SubControl'
    SC_GroupBoxContents = ... # type: 'QStyle.SubControl'
    SC_GroupBoxFrame = ... # type: 'QStyle.SubControl'
    SC_MdiMinButton = ... # type: 'QStyle.SubControl'
    SC_MdiNormalButton = ... # type: 'QStyle.SubControl'
    SC_MdiCloseButton = ... # type: 'QStyle.SubControl'
    SC_CustomBase = ... # type: 'QStyle.SubControl'
    SC_All = ... # type: 'QStyle.SubControl'

    class ComplexControl(int): ...
    CC_SpinBox = ... # type: 'QStyle.ComplexControl'
    CC_ComboBox = ... # type: 'QStyle.ComplexControl'
    CC_ScrollBar = ... # type: 'QStyle.ComplexControl'
    CC_Slider = ... # type: 'QStyle.ComplexControl'
    CC_ToolButton = ... # type: 'QStyle.ComplexControl'
    CC_TitleBar = ... # type: 'QStyle.ComplexControl'
    CC_Q3ListView = ... # type: 'QStyle.ComplexControl'
    CC_Dial = ... # type: 'QStyle.ComplexControl'
    CC_GroupBox = ... # type: 'QStyle.ComplexControl'
    CC_MdiControls = ... # type: 'QStyle.ComplexControl'
    CC_CustomBase = ... # type: 'QStyle.ComplexControl'

    class SubElement(int): ...
    SE_PushButtonContents = ... # type: 'QStyle.SubElement'
    SE_PushButtonFocusRect = ... # type: 'QStyle.SubElement'
    SE_CheckBoxIndicator = ... # type: 'QStyle.SubElement'
    SE_CheckBoxContents = ... # type: 'QStyle.SubElement'
    SE_CheckBoxFocusRect = ... # type: 'QStyle.SubElement'
    SE_CheckBoxClickRect = ... # type: 'QStyle.SubElement'
    SE_RadioButtonIndicator = ... # type: 'QStyle.SubElement'
    SE_RadioButtonContents = ... # type: 'QStyle.SubElement'
    SE_RadioButtonFocusRect = ... # type: 'QStyle.SubElement'
    SE_RadioButtonClickRect = ... # type: 'QStyle.SubElement'
    SE_ComboBoxFocusRect = ... # type: 'QStyle.SubElement'
    SE_SliderFocusRect = ... # type: 'QStyle.SubElement'
    SE_Q3DockWindowHandleRect = ... # type: 'QStyle.SubElement'
    SE_ProgressBarGroove = ... # type: 'QStyle.SubElement'
    SE_ProgressBarContents = ... # type: 'QStyle.SubElement'
    SE_ProgressBarLabel = ... # type: 'QStyle.SubElement'
    SE_DialogButtonAccept = ... # type: 'QStyle.SubElement'
    SE_DialogButtonReject = ... # type: 'QStyle.SubElement'
    SE_DialogButtonApply = ... # type: 'QStyle.SubElement'
    SE_DialogButtonHelp = ... # type: 'QStyle.SubElement'
    SE_DialogButtonAll = ... # type: 'QStyle.SubElement'
    SE_DialogButtonAbort = ... # type: 'QStyle.SubElement'
    SE_DialogButtonIgnore = ... # type: 'QStyle.SubElement'
    SE_DialogButtonRetry = ... # type: 'QStyle.SubElement'
    SE_DialogButtonCustom = ... # type: 'QStyle.SubElement'
    SE_ToolBoxTabContents = ... # type: 'QStyle.SubElement'
    SE_HeaderLabel = ... # type: 'QStyle.SubElement'
    SE_HeaderArrow = ... # type: 'QStyle.SubElement'
    SE_TabWidgetTabBar = ... # type: 'QStyle.SubElement'
    SE_TabWidgetTabPane = ... # type: 'QStyle.SubElement'
    SE_TabWidgetTabContents = ... # type: 'QStyle.SubElement'
    SE_TabWidgetLeftCorner = ... # type: 'QStyle.SubElement'
    SE_TabWidgetRightCorner = ... # type: 'QStyle.SubElement'
    SE_ViewItemCheckIndicator = ... # type: 'QStyle.SubElement'
    SE_TabBarTearIndicator = ... # type: 'QStyle.SubElement'
    SE_TreeViewDisclosureItem = ... # type: 'QStyle.SubElement'
    SE_LineEditContents = ... # type: 'QStyle.SubElement'
    SE_FrameContents = ... # type: 'QStyle.SubElement'
    SE_DockWidgetCloseButton = ... # type: 'QStyle.SubElement'
    SE_DockWidgetFloatButton = ... # type: 'QStyle.SubElement'
    SE_DockWidgetTitleBarText = ... # type: 'QStyle.SubElement'
    SE_DockWidgetIcon = ... # type: 'QStyle.SubElement'
    SE_CheckBoxLayoutItem = ... # type: 'QStyle.SubElement'
    SE_ComboBoxLayoutItem = ... # type: 'QStyle.SubElement'
    SE_DateTimeEditLayoutItem = ... # type: 'QStyle.SubElement'
    SE_DialogButtonBoxLayoutItem = ... # type: 'QStyle.SubElement'
    SE_LabelLayoutItem = ... # type: 'QStyle.SubElement'
    SE_ProgressBarLayoutItem = ... # type: 'QStyle.SubElement'
    SE_PushButtonLayoutItem = ... # type: 'QStyle.SubElement'
    SE_RadioButtonLayoutItem = ... # type: 'QStyle.SubElement'
    SE_SliderLayoutItem = ... # type: 'QStyle.SubElement'
    SE_SpinBoxLayoutItem = ... # type: 'QStyle.SubElement'
    SE_ToolButtonLayoutItem = ... # type: 'QStyle.SubElement'
    SE_FrameLayoutItem = ... # type: 'QStyle.SubElement'
    SE_GroupBoxLayoutItem = ... # type: 'QStyle.SubElement'
    SE_TabWidgetLayoutItem = ... # type: 'QStyle.SubElement'
    SE_ItemViewItemCheckIndicator = ... # type: 'QStyle.SubElement'
    SE_ItemViewItemDecoration = ... # type: 'QStyle.SubElement'
    SE_ItemViewItemText = ... # type: 'QStyle.SubElement'
    SE_ItemViewItemFocusRect = ... # type: 'QStyle.SubElement'
    SE_TabBarTabLeftButton = ... # type: 'QStyle.SubElement'
    SE_TabBarTabRightButton = ... # type: 'QStyle.SubElement'
    SE_TabBarTabText = ... # type: 'QStyle.SubElement'
    SE_ShapedFrameContents = ... # type: 'QStyle.SubElement'
    SE_ToolBarHandle = ... # type: 'QStyle.SubElement'
    SE_CustomBase = ... # type: 'QStyle.SubElement'

    class ControlElement(int): ...
    CE_PushButton = ... # type: 'QStyle.ControlElement'
    CE_PushButtonBevel = ... # type: 'QStyle.ControlElement'
    CE_PushButtonLabel = ... # type: 'QStyle.ControlElement'
    CE_CheckBox = ... # type: 'QStyle.ControlElement'
    CE_CheckBoxLabel = ... # type: 'QStyle.ControlElement'
    CE_RadioButton = ... # type: 'QStyle.ControlElement'
    CE_RadioButtonLabel = ... # type: 'QStyle.ControlElement'
    CE_TabBarTab = ... # type: 'QStyle.ControlElement'
    CE_TabBarTabShape = ... # type: 'QStyle.ControlElement'
    CE_TabBarTabLabel = ... # type: 'QStyle.ControlElement'
    CE_ProgressBar = ... # type: 'QStyle.ControlElement'
    CE_ProgressBarGroove = ... # type: 'QStyle.ControlElement'
    CE_ProgressBarContents = ... # type: 'QStyle.ControlElement'
    CE_ProgressBarLabel = ... # type: 'QStyle.ControlElement'
    CE_MenuItem = ... # type: 'QStyle.ControlElement'
    CE_MenuScroller = ... # type: 'QStyle.ControlElement'
    CE_MenuVMargin = ... # type: 'QStyle.ControlElement'
    CE_MenuHMargin = ... # type: 'QStyle.ControlElement'
    CE_MenuTearoff = ... # type: 'QStyle.ControlElement'
    CE_MenuEmptyArea = ... # type: 'QStyle.ControlElement'
    CE_MenuBarItem = ... # type: 'QStyle.ControlElement'
    CE_MenuBarEmptyArea = ... # type: 'QStyle.ControlElement'
    CE_ToolButtonLabel = ... # type: 'QStyle.ControlElement'
    CE_Header = ... # type: 'QStyle.ControlElement'
    CE_HeaderSection = ... # type: 'QStyle.ControlElement'
    CE_HeaderLabel = ... # type: 'QStyle.ControlElement'
    CE_Q3DockWindowEmptyArea = ... # type: 'QStyle.ControlElement'
    CE_ToolBoxTab = ... # type: 'QStyle.ControlElement'
    CE_SizeGrip = ... # type: 'QStyle.ControlElement'
    CE_Splitter = ... # type: 'QStyle.ControlElement'
    CE_RubberBand = ... # type: 'QStyle.ControlElement'
    CE_DockWidgetTitle = ... # type: 'QStyle.ControlElement'
    CE_ScrollBarAddLine = ... # type: 'QStyle.ControlElement'
    CE_ScrollBarSubLine = ... # type: 'QStyle.ControlElement'
    CE_ScrollBarAddPage = ... # type: 'QStyle.ControlElement'
    CE_ScrollBarSubPage = ... # type: 'QStyle.ControlElement'
    CE_ScrollBarSlider = ... # type: 'QStyle.ControlElement'
    CE_ScrollBarFirst = ... # type: 'QStyle.ControlElement'
    CE_ScrollBarLast = ... # type: 'QStyle.ControlElement'
    CE_FocusFrame = ... # type: 'QStyle.ControlElement'
    CE_ComboBoxLabel = ... # type: 'QStyle.ControlElement'
    CE_ToolBar = ... # type: 'QStyle.ControlElement'
    CE_ToolBoxTabShape = ... # type: 'QStyle.ControlElement'
    CE_ToolBoxTabLabel = ... # type: 'QStyle.ControlElement'
    CE_HeaderEmptyArea = ... # type: 'QStyle.ControlElement'
    CE_ColumnViewGrip = ... # type: 'QStyle.ControlElement'
    CE_ItemViewItem = ... # type: 'QStyle.ControlElement'
    CE_ShapedFrame = ... # type: 'QStyle.ControlElement'
    CE_CustomBase = ... # type: 'QStyle.ControlElement'

    class PrimitiveElement(int): ...
    PE_Q3CheckListController = ... # type: 'QStyle.PrimitiveElement'
    PE_Q3CheckListExclusiveIndicator = ... # type: 'QStyle.PrimitiveElement'
    PE_Q3CheckListIndicator = ... # type: 'QStyle.PrimitiveElement'
    PE_Q3DockWindowSeparator = ... # type: 'QStyle.PrimitiveElement'
    PE_Q3Separator = ... # type: 'QStyle.PrimitiveElement'
    PE_Frame = ... # type: 'QStyle.PrimitiveElement'
    PE_FrameDefaultButton = ... # type: 'QStyle.PrimitiveElement'
    PE_FrameDockWidget = ... # type: 'QStyle.PrimitiveElement'
    PE_FrameFocusRect = ... # type: 'QStyle.PrimitiveElement'
    PE_FrameGroupBox = ... # type: 'QStyle.PrimitiveElement'
    PE_FrameLineEdit = ... # type: 'QStyle.PrimitiveElement'
    PE_FrameMenu = ... # type: 'QStyle.PrimitiveElement'
    PE_FrameStatusBar = ... # type: 'QStyle.PrimitiveElement'
    PE_FrameTabWidget = ... # type: 'QStyle.PrimitiveElement'
    PE_FrameWindow = ... # type: 'QStyle.PrimitiveElement'
    PE_FrameButtonBevel = ... # type: 'QStyle.PrimitiveElement'
    PE_FrameButtonTool = ... # type: 'QStyle.PrimitiveElement'
    PE_FrameTabBarBase = ... # type: 'QStyle.PrimitiveElement'
    PE_PanelButtonCommand = ... # type: 'QStyle.PrimitiveElement'
    PE_PanelButtonBevel = ... # type: 'QStyle.PrimitiveElement'
    PE_PanelButtonTool = ... # type: 'QStyle.PrimitiveElement'
    PE_PanelMenuBar = ... # type: 'QStyle.PrimitiveElement'
    PE_PanelToolBar = ... # type: 'QStyle.PrimitiveElement'
    PE_PanelLineEdit = ... # type: 'QStyle.PrimitiveElement'
    PE_IndicatorArrowDown = ... # type: 'QStyle.PrimitiveElement'
    PE_IndicatorArrowLeft = ... # type: 'QStyle.PrimitiveElement'
    PE_IndicatorArrowRight = ... # type: 'QStyle.PrimitiveElement'
    PE_IndicatorArrowUp = ... # type: 'QStyle.PrimitiveElement'
    PE_IndicatorBranch = ... # type: 'QStyle.PrimitiveElement'
    PE_IndicatorButtonDropDown = ... # type: 'QStyle.PrimitiveElement'
    PE_IndicatorViewItemCheck = ... # type: 'QStyle.PrimitiveElement'
    PE_IndicatorCheckBox = ... # type: 'QStyle.PrimitiveElement'
    PE_IndicatorDockWidgetResizeHandle = ... # type: 'QStyle.PrimitiveElement'
    PE_IndicatorHeaderArrow = ... # type: 'QStyle.PrimitiveElement'
    PE_IndicatorMenuCheckMark = ... # type: 'QStyle.PrimitiveElement'
    PE_IndicatorProgressChunk = ... # type: 'QStyle.PrimitiveElement'
    PE_IndicatorRadioButton = ... # type: 'QStyle.PrimitiveElement'
    PE_IndicatorSpinDown = ... # type: 'QStyle.PrimitiveElement'
    PE_IndicatorSpinMinus = ... # type: 'QStyle.PrimitiveElement'
    PE_IndicatorSpinPlus = ... # type: 'QStyle.PrimitiveElement'
    PE_IndicatorSpinUp = ... # type: 'QStyle.PrimitiveElement'
    PE_IndicatorToolBarHandle = ... # type: 'QStyle.PrimitiveElement'
    PE_IndicatorToolBarSeparator = ... # type: 'QStyle.PrimitiveElement'
    PE_PanelTipLabel = ... # type: 'QStyle.PrimitiveElement'
    PE_IndicatorTabTear = ... # type: 'QStyle.PrimitiveElement'
    PE_PanelScrollAreaCorner = ... # type: 'QStyle.PrimitiveElement'
    PE_Widget = ... # type: 'QStyle.PrimitiveElement'
    PE_IndicatorColumnViewArrow = ... # type: 'QStyle.PrimitiveElement'
    PE_FrameStatusBarItem = ... # type: 'QStyle.PrimitiveElement'
    PE_IndicatorItemViewItemCheck = ... # type: 'QStyle.PrimitiveElement'
    PE_IndicatorItemViewItemDrop = ... # type: 'QStyle.PrimitiveElement'
    PE_PanelItemViewItem = ... # type: 'QStyle.PrimitiveElement'
    PE_PanelItemViewRow = ... # type: 'QStyle.PrimitiveElement'
    PE_PanelStatusBar = ... # type: 'QStyle.PrimitiveElement'
    PE_IndicatorTabClose = ... # type: 'QStyle.PrimitiveElement'
    PE_PanelMenu = ... # type: 'QStyle.PrimitiveElement'
    PE_CustomBase = ... # type: 'QStyle.PrimitiveElement'

    class StateFlag(int): ...
    State_None = ... # type: 'QStyle.StateFlag'
    State_Enabled = ... # type: 'QStyle.StateFlag'
    State_Raised = ... # type: 'QStyle.StateFlag'
    State_Sunken = ... # type: 'QStyle.StateFlag'
    State_Off = ... # type: 'QStyle.StateFlag'
    State_NoChange = ... # type: 'QStyle.StateFlag'
    State_On = ... # type: 'QStyle.StateFlag'
    State_DownArrow = ... # type: 'QStyle.StateFlag'
    State_Horizontal = ... # type: 'QStyle.StateFlag'
    State_HasFocus = ... # type: 'QStyle.StateFlag'
    State_Top = ... # type: 'QStyle.StateFlag'
    State_Bottom = ... # type: 'QStyle.StateFlag'
    State_FocusAtBorder = ... # type: 'QStyle.StateFlag'
    State_AutoRaise = ... # type: 'QStyle.StateFlag'
    State_MouseOver = ... # type: 'QStyle.StateFlag'
    State_UpArrow = ... # type: 'QStyle.StateFlag'
    State_Selected = ... # type: 'QStyle.StateFlag'
    State_Active = ... # type: 'QStyle.StateFlag'
    State_Open = ... # type: 'QStyle.StateFlag'
    State_Children = ... # type: 'QStyle.StateFlag'
    State_Item = ... # type: 'QStyle.StateFlag'
    State_Sibling = ... # type: 'QStyle.StateFlag'
    State_Editing = ... # type: 'QStyle.StateFlag'
    State_KeyboardFocusChange = ... # type: 'QStyle.StateFlag'
    State_ReadOnly = ... # type: 'QStyle.StateFlag'
    State_Window = ... # type: 'QStyle.StateFlag'
    State_Small = ... # type: 'QStyle.StateFlag'
    State_Mini = ... # type: 'QStyle.StateFlag'

    class State(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QStyle.State', 'QStyle.StateFlag']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QStyle.State') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QStyle.State': ...
        def __int__(self) -> int: ...

    class SubControls(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QStyle.SubControls', 'QStyle.SubControl']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QStyle.SubControls') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QStyle.SubControls': ...
        def __int__(self) -> int: ...

    def __init__(self) -> None: ...

    def proxy(self) -> 'QStyle': ...
    def layoutSpacingImplementation(self, control1: 'QSizePolicy.ControlType', control2: 'QSizePolicy.ControlType', orientation: QtCore.Qt.Orientation, option: typing.Optional['QStyleOption'] = ..., widget: typing.Optional[QWidget] = ...) -> int: ...
    def standardIconImplementation(self, standardIcon: 'QStyle.StandardPixmap', option: typing.Optional['QStyleOption'] = ..., widget: typing.Optional[QWidget] = ...) -> 'QIcon': ...
    def combinedLayoutSpacing(self, controls1: 'QSizePolicy.ControlTypes', controls2: 'QSizePolicy.ControlTypes', orientation: QtCore.Qt.Orientation, option: typing.Optional['QStyleOption'] = ..., widget: typing.Optional[QWidget] = ...) -> int: ...
    def layoutSpacing(self, control1: 'QSizePolicy.ControlType', control2: 'QSizePolicy.ControlType', orientation: QtCore.Qt.Orientation, option: typing.Optional['QStyleOption'] = ..., widget: typing.Optional[QWidget] = ...) -> int: ...
    @staticmethod
    def alignedRect(direction: QtCore.Qt.LayoutDirection, alignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag], size: QtCore.QSize, rectangle: QtCore.QRect) -> QtCore.QRect: ...
    @staticmethod
    def visualAlignment(direction: QtCore.Qt.LayoutDirection, alignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> QtCore.Qt.Alignment: ...
    @staticmethod
    def sliderValueFromPosition(min: int, max: int, position: int, span: int, upsideDown: bool = ...) -> int: ...
    @staticmethod
    def sliderPositionFromValue(min: int, max: int, logicalValue: int, span: int, upsideDown: bool = ...) -> int: ...
    @staticmethod
    def visualPos(direction: QtCore.Qt.LayoutDirection, boundingRect: QtCore.QRect, logicalPos: QtCore.QPoint) -> QtCore.QPoint: ...
    @staticmethod
    def visualRect(direction: QtCore.Qt.LayoutDirection, boundingRect: QtCore.QRect, logicalRect: QtCore.QRect) -> QtCore.QRect: ...
    def generatedIconPixmap(self, iconMode: 'QIcon.Mode', pixmap: QPixmap, opt: 'QStyleOption') -> QPixmap: ...
    def standardIcon(self, standardIcon: 'QStyle.StandardPixmap', option: typing.Optional['QStyleOption'] = ..., widget: typing.Optional[QWidget] = ...) -> 'QIcon': ...
    def standardPixmap(self, standardPixmap: 'QStyle.StandardPixmap', option: typing.Optional['QStyleOption'] = ..., widget: typing.Optional[QWidget] = ...) -> QPixmap: ...
    def styleHint(self, stylehint: 'QStyle.StyleHint', option: typing.Optional['QStyleOption'] = ..., widget: typing.Optional[QWidget] = ..., returnData: typing.Optional['QStyleHintReturn'] = ...) -> int: ...
    def sizeFromContents(self, ct: 'QStyle.ContentsType', opt: 'QStyleOption', contentsSize: QtCore.QSize, widget: typing.Optional[QWidget] = ...) -> QtCore.QSize: ...
    def pixelMetric(self, metric: 'QStyle.PixelMetric', option: typing.Optional['QStyleOption'] = ..., widget: typing.Optional[QWidget] = ...) -> int: ...
    def subControlRect(self, cc: 'QStyle.ComplexControl', opt: 'QStyleOptionComplex', sc: 'QStyle.SubControl', widget: typing.Optional[QWidget] = ...) -> QtCore.QRect: ...
    def hitTestComplexControl(self, cc: 'QStyle.ComplexControl', opt: 'QStyleOptionComplex', pt: QtCore.QPoint, widget: typing.Optional[QWidget] = ...) -> 'QStyle.SubControl': ...
    def drawComplexControl(self, cc: 'QStyle.ComplexControl', opt: 'QStyleOptionComplex', p: 'QPainter', widget: typing.Optional[QWidget] = ...) -> None: ...
    def subElementRect(self, subElement: 'QStyle.SubElement', option: 'QStyleOption', widget: typing.Optional[QWidget] = ...) -> QtCore.QRect: ...
    def drawControl(self, element: 'QStyle.ControlElement', opt: 'QStyleOption', p: 'QPainter', widget: typing.Optional[QWidget] = ...) -> None: ...
    def drawPrimitive(self, pe: 'QStyle.PrimitiveElement', opt: 'QStyleOption', p: 'QPainter', widget: typing.Optional[QWidget] = ...) -> None: ...
    def standardPalette(self) -> 'QPalette': ...
    def drawItemPixmap(self, painter: 'QPainter', rect: QtCore.QRect, alignment: int, pixmap: QPixmap) -> None: ...
    def drawItemText(self, painter: 'QPainter', rectangle: QtCore.QRect, alignment: int, palette: 'QPalette', enabled: bool, text: str, textRole: 'QPalette.ColorRole' = ...) -> None: ...
    def itemPixmapRect(self, r: QtCore.QRect, flags: int, pixmap: QPixmap) -> QtCore.QRect: ...
    def itemTextRect(self, fm: 'QFontMetrics', r: QtCore.QRect, flags: int, enabled: bool, text: str) -> QtCore.QRect: ...
    @typing.overload
    def unpolish(self, a0: QWidget) -> None: ...
    @typing.overload
    def unpolish(self, a0: QApplication) -> None: ...
    @typing.overload
    def polish(self, a0: QWidget) -> None: ...
    @typing.overload
    def polish(self, a0: QApplication) -> None: ...
    @typing.overload
    def polish(self, a0: 'QPalette') -> 'QPalette': ...


class QCommonStyle(QStyle):

    def __init__(self) -> None: ...

    def standardIconImplementation(self, standardIcon: QStyle.StandardPixmap, option: typing.Optional['QStyleOption'] = ..., widget: typing.Optional[QWidget] = ...) -> 'QIcon': ...
    def generatedIconPixmap(self, iconMode: 'QIcon.Mode', pixmap: QPixmap, opt: 'QStyleOption') -> QPixmap: ...
    def standardPixmap(self, sp: QStyle.StandardPixmap, option: typing.Optional['QStyleOption'] = ..., widget: typing.Optional[QWidget] = ...) -> QPixmap: ...
    def styleHint(self, sh: QStyle.StyleHint, option: typing.Optional['QStyleOption'] = ..., widget: typing.Optional[QWidget] = ..., returnData: typing.Optional['QStyleHintReturn'] = ...) -> int: ...
    def pixelMetric(self, m: QStyle.PixelMetric, option: typing.Optional['QStyleOption'] = ..., widget: typing.Optional[QWidget] = ...) -> int: ...
    def sizeFromContents(self, ct: QStyle.ContentsType, opt: 'QStyleOption', contentsSize: QtCore.QSize, widget: typing.Optional[QWidget] = ...) -> QtCore.QSize: ...
    def subControlRect(self, cc: QStyle.ComplexControl, opt: 'QStyleOptionComplex', sc: QStyle.SubControl, widget: typing.Optional[QWidget] = ...) -> QtCore.QRect: ...
    def hitTestComplexControl(self, cc: QStyle.ComplexControl, opt: 'QStyleOptionComplex', pt: QtCore.QPoint, widget: typing.Optional[QWidget] = ...) -> QStyle.SubControl: ...
    def drawComplexControl(self, cc: QStyle.ComplexControl, opt: 'QStyleOptionComplex', p: 'QPainter', widget: typing.Optional[QWidget] = ...) -> None: ...
    def subElementRect(self, r: QStyle.SubElement, opt: 'QStyleOption', widget: typing.Optional[QWidget] = ...) -> QtCore.QRect: ...
    def drawControl(self, element: QStyle.ControlElement, opt: 'QStyleOption', p: 'QPainter', widget: typing.Optional[QWidget] = ...) -> None: ...
    def drawPrimitive(self, pe: QStyle.PrimitiveElement, opt: 'QStyleOption', p: 'QPainter', widget: typing.Optional[QWidget] = ...) -> None: ...
    @typing.overload
    def unpolish(self, widget: QWidget) -> None: ...
    @typing.overload
    def unpolish(self, application: QApplication) -> None: ...
    @typing.overload
    def polish(self, widget: QWidget) -> None: ...
    @typing.overload
    def polish(self, app: QApplication) -> None: ...
    @typing.overload
    def polish(self, a0: 'QPalette') -> 'QPalette': ...


class QCompleter(QtCore.QObject):

    class ModelSorting(int): ...
    UnsortedModel = ... # type: 'QCompleter.ModelSorting'
    CaseSensitivelySortedModel = ... # type: 'QCompleter.ModelSorting'
    CaseInsensitivelySortedModel = ... # type: 'QCompleter.ModelSorting'

    class CompletionMode(int): ...
    PopupCompletion = ... # type: 'QCompleter.CompletionMode'
    UnfilteredPopupCompletion = ... # type: 'QCompleter.CompletionMode'
    InlineCompletion = ... # type: 'QCompleter.CompletionMode'

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, model: QtCore.QAbstractItemModel, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, list: typing.Sequence[str], parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def setMaxVisibleItems(self, maxItems: int) -> None: ...
    def maxVisibleItems(self) -> int: ...
    @typing.overload
    def highlighted(self, text: str) -> None: ...
    @typing.overload
    def highlighted(self, index: QtCore.QModelIndex) -> None: ...
    @typing.overload
    def activated(self, text: str) -> None: ...
    @typing.overload
    def activated(self, index: QtCore.QModelIndex) -> None: ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    def eventFilter(self, o: QtCore.QObject, e: QtCore.QEvent) -> bool: ...
    def setWrapAround(self, wrap: bool) -> None: ...
    def setCompletionPrefix(self, prefix: str) -> None: ...
    def complete(self, rect: QtCore.QRect = ...) -> None: ...
    def wrapAround(self) -> bool: ...
    def splitPath(self, path: str) -> typing.List[str]: ...
    def pathFromIndex(self, index: QtCore.QModelIndex) -> str: ...
    def completionPrefix(self) -> str: ...
    def completionModel(self) -> QtCore.QAbstractItemModel: ...
    def currentCompletion(self) -> str: ...
    def currentIndex(self) -> QtCore.QModelIndex: ...
    def currentRow(self) -> int: ...
    def setCurrentRow(self, row: int) -> bool: ...
    def completionCount(self) -> int: ...
    def completionRole(self) -> int: ...
    def setCompletionRole(self, role: int) -> None: ...
    def completionColumn(self) -> int: ...
    def setCompletionColumn(self, column: int) -> None: ...
    def modelSorting(self) -> 'QCompleter.ModelSorting': ...
    def setModelSorting(self, sorting: 'QCompleter.ModelSorting') -> None: ...
    def caseSensitivity(self) -> QtCore.Qt.CaseSensitivity: ...
    def setCaseSensitivity(self, caseSensitivity: QtCore.Qt.CaseSensitivity) -> None: ...
    def setPopup(self, popup: QAbstractItemView) -> None: ...
    def popup(self) -> QAbstractItemView: ...
    def completionMode(self) -> 'QCompleter.CompletionMode': ...
    def setCompletionMode(self, mode: 'QCompleter.CompletionMode') -> None: ...
    def model(self) -> QtCore.QAbstractItemModel: ...
    def setModel(self, c: QtCore.QAbstractItemModel) -> None: ...
    def widget(self) -> QWidget: ...
    def setWidget(self, widget: QWidget) -> None: ...


class QCursor(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, bitmap: QBitmap, mask: QBitmap, hotX: int = ..., hotY: int = ...) -> None: ...
    @typing.overload
    def __init__(self, pixmap: QPixmap, hotX: int = ..., hotY: int = ...) -> None: ...
    @typing.overload
    def __init__(self, cursor: typing.Union['QCursor', QtCore.Qt.CursorShape]) -> None: ...
    @typing.overload
    def __init__(self, variant: typing.Any) -> None: ...

    @typing.overload
    @staticmethod
    def setPos(x: int, y: int) -> None: ...
    @typing.overload
    @staticmethod
    def setPos(p: QtCore.QPoint) -> None: ...
    @staticmethod
    def pos() -> QtCore.QPoint: ...
    def hotSpot(self) -> QtCore.QPoint: ...
    def pixmap(self) -> QPixmap: ...
    def mask(self) -> QBitmap: ...
    def bitmap(self) -> QBitmap: ...
    def setShape(self, newShape: QtCore.Qt.CursorShape) -> None: ...
    def shape(self) -> QtCore.Qt.CursorShape: ...


class QDataWidgetMapper(QtCore.QObject):

    class SubmitPolicy(int): ...
    AutoSubmit = ... # type: 'QDataWidgetMapper.SubmitPolicy'
    ManualSubmit = ... # type: 'QDataWidgetMapper.SubmitPolicy'

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def currentIndexChanged(self, index: int) -> None: ...
    def toPrevious(self) -> None: ...
    def toNext(self) -> None: ...
    def toLast(self) -> None: ...
    def toFirst(self) -> None: ...
    def submit(self) -> bool: ...
    def setCurrentModelIndex(self, index: QtCore.QModelIndex) -> None: ...
    def setCurrentIndex(self, index: int) -> None: ...
    def revert(self) -> None: ...
    def currentIndex(self) -> int: ...
    def clearMapping(self) -> None: ...
    def mappedWidgetAt(self, section: int) -> QWidget: ...
    def mappedSection(self, widget: QWidget) -> int: ...
    def mappedPropertyName(self, widget: QWidget) -> QtCore.QByteArray: ...
    def removeMapping(self, widget: QWidget) -> None: ...
    @typing.overload
    def addMapping(self, widget: QWidget, section: int) -> None: ...
    @typing.overload
    def addMapping(self, widget: QWidget, section: int, propertyName: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    def submitPolicy(self) -> 'QDataWidgetMapper.SubmitPolicy': ...
    def setSubmitPolicy(self, policy: 'QDataWidgetMapper.SubmitPolicy') -> None: ...
    def orientation(self) -> QtCore.Qt.Orientation: ...
    def setOrientation(self, aOrientation: QtCore.Qt.Orientation) -> None: ...
    def rootIndex(self) -> QtCore.QModelIndex: ...
    def setRootIndex(self, index: QtCore.QModelIndex) -> None: ...
    def itemDelegate(self) -> QAbstractItemDelegate: ...
    def setItemDelegate(self, delegate: QAbstractItemDelegate) -> None: ...
    def model(self) -> QtCore.QAbstractItemModel: ...
    def setModel(self, model: QtCore.QAbstractItemModel) -> None: ...


class QDateTimeEdit(QAbstractSpinBox):

    class Section(int): ...
    NoSection = ... # type: 'QDateTimeEdit.Section'
    AmPmSection = ... # type: 'QDateTimeEdit.Section'
    MSecSection = ... # type: 'QDateTimeEdit.Section'
    SecondSection = ... # type: 'QDateTimeEdit.Section'
    MinuteSection = ... # type: 'QDateTimeEdit.Section'
    HourSection = ... # type: 'QDateTimeEdit.Section'
    DaySection = ... # type: 'QDateTimeEdit.Section'
    MonthSection = ... # type: 'QDateTimeEdit.Section'
    YearSection = ... # type: 'QDateTimeEdit.Section'
    TimeSections_Mask = ... # type: 'QDateTimeEdit.Section'
    DateSections_Mask = ... # type: 'QDateTimeEdit.Section'

    class Sections(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QDateTimeEdit.Sections', 'QDateTimeEdit.Section']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QDateTimeEdit.Sections') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QDateTimeEdit.Sections': ...
        def __int__(self) -> int: ...

    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, datetime: typing.Union[QtCore.QDateTime, datetime.datetime], parent: typing.Optional[QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, date: typing.Union[QtCore.QDate, datetime.date], parent: typing.Optional[QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, time: typing.Union[QtCore.QTime, datetime.time], parent: typing.Optional[QWidget] = ...) -> None: ...

    def setTimeSpec(self, spec: QtCore.Qt.TimeSpec) -> None: ...
    def timeSpec(self) -> QtCore.Qt.TimeSpec: ...
    def setCalendarWidget(self, calendarWidget: QCalendarWidget) -> None: ...
    def calendarWidget(self) -> QCalendarWidget: ...
    def setDateTimeRange(self, min: typing.Union[QtCore.QDateTime, datetime.datetime], max: typing.Union[QtCore.QDateTime, datetime.datetime]) -> None: ...
    def setMaximumDateTime(self, dt: typing.Union[QtCore.QDateTime, datetime.datetime]) -> None: ...
    def clearMaximumDateTime(self) -> None: ...
    def maximumDateTime(self) -> QtCore.QDateTime: ...
    def setMinimumDateTime(self, dt: typing.Union[QtCore.QDateTime, datetime.datetime]) -> None: ...
    def clearMinimumDateTime(self) -> None: ...
    def minimumDateTime(self) -> QtCore.QDateTime: ...
    def stepEnabled(self) -> QAbstractSpinBox.StepEnabled: ...
    def textFromDateTime(self, dt: typing.Union[QtCore.QDateTime, datetime.datetime]) -> str: ...
    def dateTimeFromText(self, text: str) -> QtCore.QDateTime: ...
    def fixup(self, input: str) -> str: ...
    def validate(self, input: str, pos: int) -> typing.Tuple['QValidator.State', str, int]: ...
    def paintEvent(self, event: 'QPaintEvent') -> None: ...
    def mousePressEvent(self, event: 'QMouseEvent') -> None: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusInEvent(self, e: 'QFocusEvent') -> None: ...
    def wheelEvent(self, e: 'QWheelEvent') -> None: ...
    def keyPressEvent(self, e: 'QKeyEvent') -> None: ...
    def initStyleOption(self, option: 'QStyleOptionSpinBox') -> None: ...
    def setTime(self, time: typing.Union[QtCore.QTime, datetime.time]) -> None: ...
    def setDate(self, date: typing.Union[QtCore.QDate, datetime.date]) -> None: ...
    def setDateTime(self, dateTime: typing.Union[QtCore.QDateTime, datetime.datetime]) -> None: ...
    def dateChanged(self, date: typing.Union[QtCore.QDate, datetime.date]) -> None: ...
    def timeChanged(self, date: typing.Union[QtCore.QTime, datetime.time]) -> None: ...
    def dateTimeChanged(self, date: typing.Union[QtCore.QDateTime, datetime.datetime]) -> None: ...
    def sectionCount(self) -> int: ...
    def setCurrentSectionIndex(self, index: int) -> None: ...
    def currentSectionIndex(self) -> int: ...
    def sectionAt(self, index: int) -> 'QDateTimeEdit.Section': ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def stepBy(self, steps: int) -> None: ...
    def clear(self) -> None: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def setSelectedSection(self, section: 'QDateTimeEdit.Section') -> None: ...
    def setCalendarPopup(self, enable: bool) -> None: ...
    def calendarPopup(self) -> bool: ...
    def setDisplayFormat(self, format: str) -> None: ...
    def displayFormat(self) -> str: ...
    def sectionText(self, s: 'QDateTimeEdit.Section') -> str: ...
    def setCurrentSection(self, section: 'QDateTimeEdit.Section') -> None: ...
    def currentSection(self) -> 'QDateTimeEdit.Section': ...
    def displayedSections(self) -> 'QDateTimeEdit.Sections': ...
    def setTimeRange(self, min: typing.Union[QtCore.QTime, datetime.time], max: typing.Union[QtCore.QTime, datetime.time]) -> None: ...
    def clearMaximumTime(self) -> None: ...
    def setMaximumTime(self, max: typing.Union[QtCore.QTime, datetime.time]) -> None: ...
    def maximumTime(self) -> QtCore.QTime: ...
    def clearMinimumTime(self) -> None: ...
    def setMinimumTime(self, min: typing.Union[QtCore.QTime, datetime.time]) -> None: ...
    def minimumTime(self) -> QtCore.QTime: ...
    def setDateRange(self, min: typing.Union[QtCore.QDate, datetime.date], max: typing.Union[QtCore.QDate, datetime.date]) -> None: ...
    def clearMaximumDate(self) -> None: ...
    def setMaximumDate(self, max: typing.Union[QtCore.QDate, datetime.date]) -> None: ...
    def maximumDate(self) -> QtCore.QDate: ...
    def clearMinimumDate(self) -> None: ...
    def setMinimumDate(self, min: typing.Union[QtCore.QDate, datetime.date]) -> None: ...
    def minimumDate(self) -> QtCore.QDate: ...
    def time(self) -> QtCore.QTime: ...
    def date(self) -> QtCore.QDate: ...
    def dateTime(self) -> QtCore.QDateTime: ...


class QTimeEdit(QDateTimeEdit):

    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, time: typing.Union[QtCore.QTime, datetime.time], parent: typing.Optional[QWidget] = ...) -> None: ...


class QDateEdit(QDateTimeEdit):

    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, date: typing.Union[QtCore.QDate, datetime.date], parent: typing.Optional[QWidget] = ...) -> None: ...


class QDesktopServices(sip.simplewrapper):

    class StandardLocation(int): ...
    DesktopLocation = ... # type: 'QDesktopServices.StandardLocation'
    DocumentsLocation = ... # type: 'QDesktopServices.StandardLocation'
    FontsLocation = ... # type: 'QDesktopServices.StandardLocation'
    ApplicationsLocation = ... # type: 'QDesktopServices.StandardLocation'
    MusicLocation = ... # type: 'QDesktopServices.StandardLocation'
    MoviesLocation = ... # type: 'QDesktopServices.StandardLocation'
    PicturesLocation = ... # type: 'QDesktopServices.StandardLocation'
    TempLocation = ... # type: 'QDesktopServices.StandardLocation'
    HomeLocation = ... # type: 'QDesktopServices.StandardLocation'
    DataLocation = ... # type: 'QDesktopServices.StandardLocation'
    CacheLocation = ... # type: 'QDesktopServices.StandardLocation'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QDesktopServices') -> None: ...

    @staticmethod
    def displayName(type: 'QDesktopServices.StandardLocation') -> str: ...
    @staticmethod
    def storageLocation(type: 'QDesktopServices.StandardLocation') -> str: ...
    @staticmethod
    def unsetUrlHandler(scheme: str) -> None: ...
    @typing.overload
    @staticmethod
    def setUrlHandler(scheme: str, receiver: QtCore.QObject, method: str) -> None: ...
    @typing.overload
    @staticmethod
    def setUrlHandler(scheme: str, method: typing.Callable[[QtCore.QUrl], None]) -> None: ...
    @staticmethod
    def openUrl(url: QtCore.QUrl) -> bool: ...


class QDesktopWidget(QWidget):

    def __init__(self) -> None: ...

    def resizeEvent(self, e: 'QResizeEvent') -> None: ...
    def screenCountChanged(self, a0: int) -> None: ...
    def workAreaResized(self, a0: int) -> None: ...
    def resized(self, a0: int) -> None: ...
    @typing.overload
    def availableGeometry(self, screen: int = ...) -> QtCore.QRect: ...
    @typing.overload
    def availableGeometry(self, widget: QWidget) -> QtCore.QRect: ...
    @typing.overload
    def availableGeometry(self, point: QtCore.QPoint) -> QtCore.QRect: ...
    @typing.overload
    def screenGeometry(self, screen: int = ...) -> QtCore.QRect: ...
    @typing.overload
    def screenGeometry(self, widget: QWidget) -> QtCore.QRect: ...
    @typing.overload
    def screenGeometry(self, point: QtCore.QPoint) -> QtCore.QRect: ...
    def screenCount(self) -> int: ...
    def screen(self, screen: int = ...) -> QWidget: ...
    @typing.overload
    def screenNumber(self, widget: typing.Optional[QWidget] = ...) -> int: ...
    @typing.overload
    def screenNumber(self, a0: QtCore.QPoint) -> int: ...
    def primaryScreen(self) -> int: ...
    def numScreens(self) -> int: ...
    def isVirtualDesktop(self) -> bool: ...


class QDial(QAbstractSlider):

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...

    def sliderChange(self, change: QAbstractSlider.SliderChange) -> None: ...
    def mouseMoveEvent(self, me: 'QMouseEvent') -> None: ...
    def mouseReleaseEvent(self, me: 'QMouseEvent') -> None: ...
    def mousePressEvent(self, me: 'QMouseEvent') -> None: ...
    def paintEvent(self, pe: 'QPaintEvent') -> None: ...
    def resizeEvent(self, re: 'QResizeEvent') -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def initStyleOption(self, option: 'QStyleOptionSlider') -> None: ...
    def setWrapping(self, on: bool) -> None: ...
    def setNotchesVisible(self, visible: bool) -> None: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def notchesVisible(self) -> bool: ...
    def notchTarget(self) -> float: ...
    def setNotchTarget(self, target: float) -> None: ...
    def notchSize(self) -> int: ...
    def wrapping(self) -> bool: ...


class QDialogButtonBox(QWidget):

    class StandardButton(int): ...
    NoButton = ... # type: 'QDialogButtonBox.StandardButton'
    Ok = ... # type: 'QDialogButtonBox.StandardButton'
    Save = ... # type: 'QDialogButtonBox.StandardButton'
    SaveAll = ... # type: 'QDialogButtonBox.StandardButton'
    Open = ... # type: 'QDialogButtonBox.StandardButton'
    Yes = ... # type: 'QDialogButtonBox.StandardButton'
    YesToAll = ... # type: 'QDialogButtonBox.StandardButton'
    No = ... # type: 'QDialogButtonBox.StandardButton'
    NoToAll = ... # type: 'QDialogButtonBox.StandardButton'
    Abort = ... # type: 'QDialogButtonBox.StandardButton'
    Retry = ... # type: 'QDialogButtonBox.StandardButton'
    Ignore = ... # type: 'QDialogButtonBox.StandardButton'
    Close = ... # type: 'QDialogButtonBox.StandardButton'
    Cancel = ... # type: 'QDialogButtonBox.StandardButton'
    Discard = ... # type: 'QDialogButtonBox.StandardButton'
    Help = ... # type: 'QDialogButtonBox.StandardButton'
    Apply = ... # type: 'QDialogButtonBox.StandardButton'
    Reset = ... # type: 'QDialogButtonBox.StandardButton'
    RestoreDefaults = ... # type: 'QDialogButtonBox.StandardButton'

    class ButtonRole(int): ...
    InvalidRole = ... # type: 'QDialogButtonBox.ButtonRole'
    AcceptRole = ... # type: 'QDialogButtonBox.ButtonRole'
    RejectRole = ... # type: 'QDialogButtonBox.ButtonRole'
    DestructiveRole = ... # type: 'QDialogButtonBox.ButtonRole'
    ActionRole = ... # type: 'QDialogButtonBox.ButtonRole'
    HelpRole = ... # type: 'QDialogButtonBox.ButtonRole'
    YesRole = ... # type: 'QDialogButtonBox.ButtonRole'
    NoRole = ... # type: 'QDialogButtonBox.ButtonRole'
    ResetRole = ... # type: 'QDialogButtonBox.ButtonRole'
    ApplyRole = ... # type: 'QDialogButtonBox.ButtonRole'

    class ButtonLayout(int): ...
    WinLayout = ... # type: 'QDialogButtonBox.ButtonLayout'
    MacLayout = ... # type: 'QDialogButtonBox.ButtonLayout'
    KdeLayout = ... # type: 'QDialogButtonBox.ButtonLayout'
    GnomeLayout = ... # type: 'QDialogButtonBox.ButtonLayout'

    class StandardButtons(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QDialogButtonBox.StandardButtons', 'QDialogButtonBox.StandardButton']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QDialogButtonBox.StandardButtons') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QDialogButtonBox.StandardButtons': ...
        def __int__(self) -> int: ...

    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, orientation: QtCore.Qt.Orientation, parent: typing.Optional[QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, buttons: 'QDialogButtonBox.StandardButtons', orientation: QtCore.Qt.Orientation = ..., parent: typing.Optional[QWidget] = ...) -> None: ...

    def event(self, event: QtCore.QEvent) -> bool: ...
    def changeEvent(self, event: QtCore.QEvent) -> None: ...
    def rejected(self) -> None: ...
    def helpRequested(self) -> None: ...
    def clicked(self, button: QAbstractButton) -> None: ...
    def accepted(self) -> None: ...
    def centerButtons(self) -> bool: ...
    def setCenterButtons(self, center: bool) -> None: ...
    def button(self, which: 'QDialogButtonBox.StandardButton') -> QPushButton: ...
    def standardButton(self, button: QAbstractButton) -> 'QDialogButtonBox.StandardButton': ...
    def standardButtons(self) -> 'QDialogButtonBox.StandardButtons': ...
    def setStandardButtons(self, buttons: 'QDialogButtonBox.StandardButtons') -> None: ...
    def buttonRole(self, button: QAbstractButton) -> 'QDialogButtonBox.ButtonRole': ...
    def buttons(self) -> typing.List[QAbstractButton]: ...
    def clear(self) -> None: ...
    def removeButton(self, button: QAbstractButton) -> None: ...
    @typing.overload
    def addButton(self, button: QAbstractButton, role: 'QDialogButtonBox.ButtonRole') -> None: ...
    @typing.overload
    def addButton(self, text: str, role: 'QDialogButtonBox.ButtonRole') -> QPushButton: ...
    @typing.overload
    def addButton(self, button: 'QDialogButtonBox.StandardButton') -> QPushButton: ...
    def orientation(self) -> QtCore.Qt.Orientation: ...
    def setOrientation(self, orientation: QtCore.Qt.Orientation) -> None: ...


class QDirModel(QtCore.QAbstractItemModel):

    class Roles(int): ...
    FileIconRole = ... # type: 'QDirModel.Roles'
    FilePathRole = ... # type: 'QDirModel.Roles'
    FileNameRole = ... # type: 'QDirModel.Roles'

    @typing.overload
    def __init__(self, nameFilters: typing.Sequence[str], filters: QtCore.QDir.Filters, sort: QtCore.QDir.SortFlags, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def fileInfo(self, index: QtCore.QModelIndex) -> QtCore.QFileInfo: ...
    def fileIcon(self, index: QtCore.QModelIndex) -> 'QIcon': ...
    def fileName(self, index: QtCore.QModelIndex) -> str: ...
    def filePath(self, index: QtCore.QModelIndex) -> str: ...
    def remove(self, index: QtCore.QModelIndex) -> bool: ...
    def rmdir(self, index: QtCore.QModelIndex) -> bool: ...
    def mkdir(self, parent: QtCore.QModelIndex, name: str) -> QtCore.QModelIndex: ...
    def isDir(self, index: QtCore.QModelIndex) -> bool: ...
    def refresh(self, parent: QtCore.QModelIndex = ...) -> None: ...
    def lazyChildCount(self) -> bool: ...
    def setLazyChildCount(self, enable: bool) -> None: ...
    def isReadOnly(self) -> bool: ...
    def setReadOnly(self, enable: bool) -> None: ...
    def resolveSymlinks(self) -> bool: ...
    def setResolveSymlinks(self, enable: bool) -> None: ...
    def sorting(self) -> QtCore.QDir.SortFlags: ...
    def setSorting(self, sort: QtCore.QDir.SortFlags) -> None: ...
    def filter(self) -> QtCore.QDir.Filters: ...
    def setFilter(self, filters: QtCore.QDir.Filters) -> None: ...
    def nameFilters(self) -> typing.List[str]: ...
    def setNameFilters(self, filters: typing.Sequence[str]) -> None: ...
    def iconProvider(self) -> 'QFileIconProvider': ...
    def setIconProvider(self, provider: 'QFileIconProvider') -> None: ...
    def supportedDropActions(self) -> QtCore.Qt.DropActions: ...
    def dropMimeData(self, data: QtCore.QMimeData, action: QtCore.Qt.DropAction, row: int, column: int, parent: QtCore.QModelIndex) -> bool: ...
    def mimeData(self, indexes: typing.Sequence[QtCore.QModelIndex]) -> QtCore.QMimeData: ...
    def mimeTypes(self) -> typing.List[str]: ...
    def sort(self, column: int, order: QtCore.Qt.SortOrder = ...) -> None: ...
    def flags(self, index: QtCore.QModelIndex) -> QtCore.Qt.ItemFlags: ...
    def hasChildren(self, parent: QtCore.QModelIndex = ...) -> bool: ...
    def headerData(self, section: int, orientation: QtCore.Qt.Orientation, role: int = ...) -> typing.Any: ...
    def setData(self, index: QtCore.QModelIndex, value: typing.Any, role: int = ...) -> bool: ...
    def data(self, index: QtCore.QModelIndex, role: int = ...) -> typing.Any: ...
    def columnCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    @typing.overload
    def parent(self, child: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    @typing.overload
    def parent(self) -> QtCore.QObject: ...
    @typing.overload
    def index(self, row: int, column: int, parent: QtCore.QModelIndex = ...) -> QtCore.QModelIndex: ...
    @typing.overload
    def index(self, path: str, column: int = ...) -> QtCore.QModelIndex: ...


class QDockWidget(QWidget):

    class DockWidgetFeature(int): ...
    DockWidgetClosable = ... # type: 'QDockWidget.DockWidgetFeature'
    DockWidgetMovable = ... # type: 'QDockWidget.DockWidgetFeature'
    DockWidgetFloatable = ... # type: 'QDockWidget.DockWidgetFeature'
    DockWidgetVerticalTitleBar = ... # type: 'QDockWidget.DockWidgetFeature'
    AllDockWidgetFeatures = ... # type: 'QDockWidget.DockWidgetFeature'
    NoDockWidgetFeatures = ... # type: 'QDockWidget.DockWidgetFeature'

    class DockWidgetFeatures(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QDockWidget.DockWidgetFeatures', 'QDockWidget.DockWidgetFeature']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QDockWidget.DockWidgetFeatures') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QDockWidget.DockWidgetFeatures': ...
        def __int__(self) -> int: ...

    @typing.overload
    def __init__(self, title: str, parent: typing.Optional[QWidget] = ..., flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ..., flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def event(self, event: QtCore.QEvent) -> bool: ...
    def paintEvent(self, event: 'QPaintEvent') -> None: ...
    def closeEvent(self, event: 'QCloseEvent') -> None: ...
    def changeEvent(self, event: QtCore.QEvent) -> None: ...
    def initStyleOption(self, option: 'QStyleOptionDockWidget') -> None: ...
    def visibilityChanged(self, visible: bool) -> None: ...
    def dockLocationChanged(self, area: QtCore.Qt.DockWidgetArea) -> None: ...
    def allowedAreasChanged(self, allowedAreas: typing.Union[QtCore.Qt.DockWidgetAreas, QtCore.Qt.DockWidgetArea]) -> None: ...
    def topLevelChanged(self, topLevel: bool) -> None: ...
    def featuresChanged(self, features: 'QDockWidget.DockWidgetFeatures') -> None: ...
    def titleBarWidget(self) -> QWidget: ...
    def setTitleBarWidget(self, widget: QWidget) -> None: ...
    def toggleViewAction(self) -> QAction: ...
    def isAreaAllowed(self, area: QtCore.Qt.DockWidgetArea) -> bool: ...
    def allowedAreas(self) -> QtCore.Qt.DockWidgetAreas: ...
    def setAllowedAreas(self, areas: typing.Union[QtCore.Qt.DockWidgetAreas, QtCore.Qt.DockWidgetArea]) -> None: ...
    def isFloating(self) -> bool: ...
    def setFloating(self, floating: bool) -> None: ...
    def features(self) -> 'QDockWidget.DockWidgetFeatures': ...
    def setFeatures(self, features: 'QDockWidget.DockWidgetFeatures') -> None: ...
    def setWidget(self, widget: QWidget) -> None: ...
    def widget(self) -> QWidget: ...


class QDrag(QtCore.QObject):

    def __init__(self, dragSource: QWidget) -> None: ...

    def targetChanged(self, newTarget: QWidget) -> None: ...
    def actionChanged(self, action: QtCore.Qt.DropAction) -> None: ...
    def setDragCursor(self, cursor: QPixmap, action: QtCore.Qt.DropAction) -> None: ...
    def start(self, supportedActions: typing.Union[QtCore.Qt.DropActions, QtCore.Qt.DropAction] = ...) -> QtCore.Qt.DropAction: ...
    def target(self) -> QWidget: ...
    def source(self) -> QWidget: ...
    def hotSpot(self) -> QtCore.QPoint: ...
    def setHotSpot(self, hotspot: QtCore.QPoint) -> None: ...
    def pixmap(self) -> QPixmap: ...
    def setPixmap(self, a0: QPixmap) -> None: ...
    def mimeData(self) -> QtCore.QMimeData: ...
    def setMimeData(self, data: QtCore.QMimeData) -> None: ...
    @typing.overload
    def exec(self, supportedActions: typing.Union[QtCore.Qt.DropActions, QtCore.Qt.DropAction] = ...) -> QtCore.Qt.DropAction: ...
    @typing.overload
    def exec(self, supportedActions: typing.Union[QtCore.Qt.DropActions, QtCore.Qt.DropAction], defaultDropAction: QtCore.Qt.DropAction) -> QtCore.Qt.DropAction: ...
    @typing.overload
    def exec_(self, supportedActions: typing.Union[QtCore.Qt.DropActions, QtCore.Qt.DropAction] = ...) -> QtCore.Qt.DropAction: ...
    @typing.overload
    def exec_(self, supportedActions: typing.Union[QtCore.Qt.DropActions, QtCore.Qt.DropAction], defaultDropAction: QtCore.Qt.DropAction) -> QtCore.Qt.DropAction: ...


class QErrorMessage(QDialog):

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...

    def done(self, a0: int) -> None: ...
    def changeEvent(self, e: QtCore.QEvent) -> None: ...
    @typing.overload
    def showMessage(self, message: str) -> None: ...
    @typing.overload
    def showMessage(self, message: str, type: str) -> None: ...
    @staticmethod
    def qtHandler() -> 'QErrorMessage': ...


class QInputEvent(QtCore.QEvent):

    def modifiers(self) -> QtCore.Qt.KeyboardModifiers: ...


class QMouseEvent(QInputEvent):

    @typing.overload
    def __init__(self, type: QtCore.QEvent.Type, pos: QtCore.QPoint, button: QtCore.Qt.MouseButton, buttons: typing.Union[QtCore.Qt.MouseButtons, QtCore.Qt.MouseButton], modifiers: typing.Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier]) -> None: ...
    @typing.overload
    def __init__(self, type: QtCore.QEvent.Type, pos: QtCore.QPoint, globalPos: QtCore.QPoint, button: QtCore.Qt.MouseButton, buttons: typing.Union[QtCore.Qt.MouseButtons, QtCore.Qt.MouseButton], modifiers: typing.Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier]) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QMouseEvent') -> None: ...

    def posF(self) -> QtCore.QPointF: ...
    def hasExtendedInfo(self) -> bool: ...
    def buttons(self) -> QtCore.Qt.MouseButtons: ...
    def button(self) -> QtCore.Qt.MouseButton: ...
    def globalY(self) -> int: ...
    def globalX(self) -> int: ...
    def y(self) -> int: ...
    def x(self) -> int: ...
    def globalPos(self) -> QtCore.QPoint: ...
    def pos(self) -> QtCore.QPoint: ...


class QHoverEvent(QtCore.QEvent):

    @typing.overload
    def __init__(self, type: QtCore.QEvent.Type, pos: QtCore.QPoint, oldPos: QtCore.QPoint) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QHoverEvent') -> None: ...

    def oldPos(self) -> QtCore.QPoint: ...
    def pos(self) -> QtCore.QPoint: ...


class QWheelEvent(QInputEvent):

    @typing.overload
    def __init__(self, pos: QtCore.QPoint, delta: int, buttons: typing.Union[QtCore.Qt.MouseButtons, QtCore.Qt.MouseButton], modifiers: typing.Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier], orientation: QtCore.Qt.Orientation = ...) -> None: ...
    @typing.overload
    def __init__(self, pos: QtCore.QPoint, globalPos: QtCore.QPoint, delta: int, buttons: typing.Union[QtCore.Qt.MouseButtons, QtCore.Qt.MouseButton], modifiers: typing.Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier], orientation: QtCore.Qt.Orientation = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QWheelEvent') -> None: ...

    def orientation(self) -> QtCore.Qt.Orientation: ...
    def buttons(self) -> QtCore.Qt.MouseButtons: ...
    def globalY(self) -> int: ...
    def globalX(self) -> int: ...
    def y(self) -> int: ...
    def x(self) -> int: ...
    def globalPos(self) -> QtCore.QPoint: ...
    def pos(self) -> QtCore.QPoint: ...
    def delta(self) -> int: ...


class QTabletEvent(QInputEvent):

    class PointerType(int): ...
    UnknownPointer = ... # type: 'QTabletEvent.PointerType'
    Pen = ... # type: 'QTabletEvent.PointerType'
    Cursor = ... # type: 'QTabletEvent.PointerType'
    Eraser = ... # type: 'QTabletEvent.PointerType'

    class TabletDevice(int): ...
    NoDevice = ... # type: 'QTabletEvent.TabletDevice'
    Puck = ... # type: 'QTabletEvent.TabletDevice'
    Stylus = ... # type: 'QTabletEvent.TabletDevice'
    Airbrush = ... # type: 'QTabletEvent.TabletDevice'
    FourDMouse = ... # type: 'QTabletEvent.TabletDevice'
    XFreeEraser = ... # type: 'QTabletEvent.TabletDevice'
    RotationStylus = ... # type: 'QTabletEvent.TabletDevice'

    @typing.overload
    def __init__(self, t: QtCore.QEvent.Type, pos: QtCore.QPoint, globalPos: QtCore.QPoint, hiResGlobalPos: typing.Union[QtCore.QPointF, QtCore.QPoint], device: int, pointerType: int, pressure: float, xTilt: int, yTilt: int, tangentialPressure: float, rotation: float, z: int, keyState: typing.Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier], uniqueID: int) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QTabletEvent') -> None: ...

    def yTilt(self) -> int: ...
    def xTilt(self) -> int: ...
    def rotation(self) -> float: ...
    def tangentialPressure(self) -> float: ...
    def z(self) -> int: ...
    def pressure(self) -> float: ...
    def uniqueId(self) -> int: ...
    def pointerType(self) -> 'QTabletEvent.PointerType': ...
    def device(self) -> 'QTabletEvent.TabletDevice': ...
    def hiResGlobalY(self) -> float: ...
    def hiResGlobalX(self) -> float: ...
    def globalY(self) -> int: ...
    def globalX(self) -> int: ...
    def y(self) -> int: ...
    def x(self) -> int: ...
    def hiResGlobalPos(self) -> QtCore.QPointF: ...
    def globalPos(self) -> QtCore.QPoint: ...
    def pos(self) -> QtCore.QPoint: ...


class QKeyEvent(QInputEvent):

    @typing.overload
    def __init__(self, type: QtCore.QEvent.Type, key: int, modifiers: typing.Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier], text: str = ..., autorep: bool = ..., count: int = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QKeyEvent') -> None: ...

    def nativeVirtualKey(self) -> int: ...
    def nativeScanCode(self) -> int: ...
    def nativeModifiers(self) -> int: ...
    def matches(self, key: 'QKeySequence.StandardKey') -> bool: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def isAutoRepeat(self) -> bool: ...
    def text(self) -> str: ...
    def modifiers(self) -> QtCore.Qt.KeyboardModifiers: ...
    def key(self) -> int: ...


class QFocusEvent(QtCore.QEvent):

    @typing.overload
    def __init__(self, type: QtCore.QEvent.Type, reason: QtCore.Qt.FocusReason = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QFocusEvent') -> None: ...

    def reason(self) -> QtCore.Qt.FocusReason: ...
    def lostFocus(self) -> bool: ...
    def gotFocus(self) -> bool: ...


class QPaintEvent(QtCore.QEvent):

    @typing.overload
    def __init__(self, paintRegion: 'QRegion') -> None: ...
    @typing.overload
    def __init__(self, paintRect: QtCore.QRect) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QPaintEvent') -> None: ...

    def region(self) -> 'QRegion': ...
    def rect(self) -> QtCore.QRect: ...


class QMoveEvent(QtCore.QEvent):

    @typing.overload
    def __init__(self, pos: QtCore.QPoint, oldPos: QtCore.QPoint) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QMoveEvent') -> None: ...

    def oldPos(self) -> QtCore.QPoint: ...
    def pos(self) -> QtCore.QPoint: ...


class QResizeEvent(QtCore.QEvent):

    @typing.overload
    def __init__(self, size: QtCore.QSize, oldSize: QtCore.QSize) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QResizeEvent') -> None: ...

    def oldSize(self) -> QtCore.QSize: ...
    def size(self) -> QtCore.QSize: ...


class QCloseEvent(QtCore.QEvent):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QCloseEvent') -> None: ...


class QIconDragEvent(QtCore.QEvent):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QIconDragEvent') -> None: ...


class QShowEvent(QtCore.QEvent):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QShowEvent') -> None: ...


class QHideEvent(QtCore.QEvent):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QHideEvent') -> None: ...


class QContextMenuEvent(QInputEvent):

    class Reason(int): ...
    Mouse = ... # type: 'QContextMenuEvent.Reason'
    Keyboard = ... # type: 'QContextMenuEvent.Reason'
    Other = ... # type: 'QContextMenuEvent.Reason'

    @typing.overload
    def __init__(self, reason: 'QContextMenuEvent.Reason', pos: QtCore.QPoint, globalPos: QtCore.QPoint, modifiers: typing.Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier]) -> None: ...
    @typing.overload
    def __init__(self, reason: 'QContextMenuEvent.Reason', pos: QtCore.QPoint, globalPos: QtCore.QPoint) -> None: ...
    @typing.overload
    def __init__(self, reason: 'QContextMenuEvent.Reason', pos: QtCore.QPoint) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QContextMenuEvent') -> None: ...

    def reason(self) -> 'QContextMenuEvent.Reason': ...
    def globalPos(self) -> QtCore.QPoint: ...
    def pos(self) -> QtCore.QPoint: ...
    def globalY(self) -> int: ...
    def globalX(self) -> int: ...
    def y(self) -> int: ...
    def x(self) -> int: ...


class QInputMethodEvent(QtCore.QEvent):

    class AttributeType(int): ...
    TextFormat = ... # type: 'QInputMethodEvent.AttributeType'
    Cursor = ... # type: 'QInputMethodEvent.AttributeType'
    Language = ... # type: 'QInputMethodEvent.AttributeType'
    Ruby = ... # type: 'QInputMethodEvent.AttributeType'
    Selection = ... # type: 'QInputMethodEvent.AttributeType'

    class Attribute(sip.simplewrapper):

        length = ... # type: int
        start = ... # type: int
        type = ... # type: 'QInputMethodEvent.AttributeType'
        value = ... # type: typing.Any

        @typing.overload
        def __init__(self, t: 'QInputMethodEvent.AttributeType', s: int, l: int, val: typing.Any) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QInputMethodEvent.Attribute') -> None: ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, preeditText: str, attributes: typing.Sequence['QInputMethodEvent.Attribute']) -> None: ...
    @typing.overload
    def __init__(self, other: 'QInputMethodEvent') -> None: ...

    def replacementLength(self) -> int: ...
    def replacementStart(self) -> int: ...
    def commitString(self) -> str: ...
    def preeditString(self) -> str: ...
    def attributes(self) -> typing.List['QInputMethodEvent.Attribute']: ...
    def setCommitString(self, commitString: str, from_: int = ..., length: int = ...) -> None: ...


class QMimeSource(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QMimeSource') -> None: ...

    def encodedData(self, a0: str) -> QtCore.QByteArray: ...
    def provides(self, a0: str) -> bool: ...
    def format(self, i: int = ...) -> str: ...


class QDropEvent(QtCore.QEvent, QMimeSource):

    @typing.overload
    def __init__(self, pos: QtCore.QPoint, actions: typing.Union[QtCore.Qt.DropActions, QtCore.Qt.DropAction], data: QtCore.QMimeData, buttons: typing.Union[QtCore.Qt.MouseButtons, QtCore.Qt.MouseButton], modifiers: typing.Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier], type: QtCore.QEvent.Type = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QDropEvent') -> None: ...

    def provides(self, a0: str) -> bool: ...
    def encodedData(self, a0: str) -> QtCore.QByteArray: ...
    def format(self, n: int = ...) -> str: ...
    def mimeData(self) -> QtCore.QMimeData: ...
    def source(self) -> QWidget: ...
    def setDropAction(self, action: QtCore.Qt.DropAction) -> None: ...
    def dropAction(self) -> QtCore.Qt.DropAction: ...
    def acceptProposedAction(self) -> None: ...
    def proposedAction(self) -> QtCore.Qt.DropAction: ...
    def possibleActions(self) -> QtCore.Qt.DropActions: ...
    def keyboardModifiers(self) -> QtCore.Qt.KeyboardModifiers: ...
    def mouseButtons(self) -> QtCore.Qt.MouseButtons: ...
    def pos(self) -> QtCore.QPoint: ...


class QDragMoveEvent(QDropEvent):

    @typing.overload
    def __init__(self, pos: QtCore.QPoint, actions: typing.Union[QtCore.Qt.DropActions, QtCore.Qt.DropAction], data: QtCore.QMimeData, buttons: typing.Union[QtCore.Qt.MouseButtons, QtCore.Qt.MouseButton], modifiers: typing.Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier], type: QtCore.QEvent.Type = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QDragMoveEvent') -> None: ...

    @typing.overload
    def ignore(self) -> None: ...
    @typing.overload
    def ignore(self, r: QtCore.QRect) -> None: ...
    @typing.overload
    def accept(self) -> None: ...
    @typing.overload
    def accept(self, r: QtCore.QRect) -> None: ...
    def answerRect(self) -> QtCore.QRect: ...


class QDragEnterEvent(QDragMoveEvent):

    @typing.overload
    def __init__(self, pos: QtCore.QPoint, actions: typing.Union[QtCore.Qt.DropActions, QtCore.Qt.DropAction], data: QtCore.QMimeData, buttons: typing.Union[QtCore.Qt.MouseButtons, QtCore.Qt.MouseButton], modifiers: typing.Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier]) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QDragEnterEvent') -> None: ...


class QDragLeaveEvent(QtCore.QEvent):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QDragLeaveEvent') -> None: ...


class QHelpEvent(QtCore.QEvent):

    @typing.overload
    def __init__(self, type: QtCore.QEvent.Type, pos: QtCore.QPoint, globalPos: QtCore.QPoint) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QHelpEvent') -> None: ...

    def globalPos(self) -> QtCore.QPoint: ...
    def pos(self) -> QtCore.QPoint: ...
    def globalY(self) -> int: ...
    def globalX(self) -> int: ...
    def y(self) -> int: ...
    def x(self) -> int: ...


class QStatusTipEvent(QtCore.QEvent):

    @typing.overload
    def __init__(self, tip: str) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QStatusTipEvent') -> None: ...

    def tip(self) -> str: ...


class QWhatsThisClickedEvent(QtCore.QEvent):

    @typing.overload
    def __init__(self, href: str) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QWhatsThisClickedEvent') -> None: ...

    def href(self) -> str: ...


class QActionEvent(QtCore.QEvent):

    @typing.overload
    def __init__(self, type: int, action: QAction, before: typing.Optional[QAction] = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QActionEvent') -> None: ...

    def before(self) -> QAction: ...
    def action(self) -> QAction: ...


class QFileOpenEvent(QtCore.QEvent):

    def openFile(self, file: QtCore.QFile, flags: QtCore.QIODevice.OpenMode) -> bool: ...
    def url(self) -> QtCore.QUrl: ...
    def file(self) -> str: ...


class QShortcutEvent(QtCore.QEvent):

    @typing.overload
    def __init__(self, key: typing.Union['QKeySequence', 'QKeySequence.StandardKey', str, int], id: int, ambiguous: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QShortcutEvent') -> None: ...

    def shortcutId(self) -> int: ...
    def key(self) -> 'QKeySequence': ...
    def isAmbiguous(self) -> bool: ...


class QWindowStateChangeEvent(QtCore.QEvent):

    def oldState(self) -> QtCore.Qt.WindowStates: ...


class QTouchEvent(QInputEvent):

    class DeviceType(int): ...
    TouchScreen = ... # type: 'QTouchEvent.DeviceType'
    TouchPad = ... # type: 'QTouchEvent.DeviceType'

    class TouchPoint(sip.simplewrapper):

        def pressure(self) -> float: ...
        def screenRect(self) -> QtCore.QRectF: ...
        def sceneRect(self) -> QtCore.QRectF: ...
        def rect(self) -> QtCore.QRectF: ...
        def lastNormalizedPos(self) -> QtCore.QPointF: ...
        def startNormalizedPos(self) -> QtCore.QPointF: ...
        def normalizedPos(self) -> QtCore.QPointF: ...
        def lastScreenPos(self) -> QtCore.QPointF: ...
        def startScreenPos(self) -> QtCore.QPointF: ...
        def screenPos(self) -> QtCore.QPointF: ...
        def lastScenePos(self) -> QtCore.QPointF: ...
        def startScenePos(self) -> QtCore.QPointF: ...
        def scenePos(self) -> QtCore.QPointF: ...
        def lastPos(self) -> QtCore.QPointF: ...
        def startPos(self) -> QtCore.QPointF: ...
        def pos(self) -> QtCore.QPointF: ...
        def isPrimary(self) -> bool: ...
        def state(self) -> QtCore.Qt.TouchPointState: ...
        def id(self) -> int: ...

    @typing.overload
    def __init__(self, eventType: QtCore.QEvent.Type, deviceType: 'QTouchEvent.DeviceType' = ..., modifiers: typing.Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier] = ..., touchPointStates: typing.Union[QtCore.Qt.TouchPointStates, QtCore.Qt.TouchPointState] = ..., touchPoints: typing.Sequence['QTouchEvent.TouchPoint'] = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QTouchEvent') -> None: ...

    def touchPoints(self) -> typing.List['QTouchEvent.TouchPoint']: ...
    def touchPointStates(self) -> QtCore.Qt.TouchPointStates: ...
    def deviceType(self) -> 'QTouchEvent.DeviceType': ...
    def widget(self) -> QWidget: ...


class QGestureEvent(QtCore.QEvent):

    @typing.overload
    def __init__(self, gestures: typing.Sequence['QGesture']) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QGestureEvent') -> None: ...

    def mapToGraphicsScene(self, gesturePoint: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> QtCore.QPointF: ...
    def widget(self) -> QWidget: ...
    @typing.overload
    def ignore(self) -> None: ...
    @typing.overload
    def ignore(self, a0: 'QGesture') -> None: ...
    @typing.overload
    def ignore(self, a0: QtCore.Qt.GestureType) -> None: ...
    @typing.overload
    def accept(self) -> None: ...
    @typing.overload
    def accept(self, a0: 'QGesture') -> None: ...
    @typing.overload
    def accept(self, a0: QtCore.Qt.GestureType) -> None: ...
    @typing.overload
    def isAccepted(self) -> bool: ...
    @typing.overload
    def isAccepted(self, a0: 'QGesture') -> bool: ...
    @typing.overload
    def isAccepted(self, a0: QtCore.Qt.GestureType) -> bool: ...
    @typing.overload
    def setAccepted(self, accepted: bool) -> None: ...
    @typing.overload
    def setAccepted(self, a0: 'QGesture', a1: bool) -> None: ...
    @typing.overload
    def setAccepted(self, a0: QtCore.Qt.GestureType, a1: bool) -> None: ...
    def canceledGestures(self) -> typing.List['QGesture']: ...
    def activeGestures(self) -> typing.List['QGesture']: ...
    def gesture(self, type: QtCore.Qt.GestureType) -> 'QGesture': ...
    def gestures(self) -> typing.List['QGesture']: ...


class QFileDialog(QDialog):

    class Option(int): ...
    ShowDirsOnly = ... # type: 'QFileDialog.Option'
    DontResolveSymlinks = ... # type: 'QFileDialog.Option'
    DontConfirmOverwrite = ... # type: 'QFileDialog.Option'
    DontUseSheet = ... # type: 'QFileDialog.Option'
    DontUseNativeDialog = ... # type: 'QFileDialog.Option'
    ReadOnly = ... # type: 'QFileDialog.Option'
    HideNameFilterDetails = ... # type: 'QFileDialog.Option'
    DontUseCustomDirectoryIcons = ... # type: 'QFileDialog.Option'

    class DialogLabel(int): ...
    LookIn = ... # type: 'QFileDialog.DialogLabel'
    FileName = ... # type: 'QFileDialog.DialogLabel'
    FileType = ... # type: 'QFileDialog.DialogLabel'
    Accept = ... # type: 'QFileDialog.DialogLabel'
    Reject = ... # type: 'QFileDialog.DialogLabel'

    class AcceptMode(int): ...
    AcceptOpen = ... # type: 'QFileDialog.AcceptMode'
    AcceptSave = ... # type: 'QFileDialog.AcceptMode'

    class FileMode(int): ...
    AnyFile = ... # type: 'QFileDialog.FileMode'
    ExistingFile = ... # type: 'QFileDialog.FileMode'
    Directory = ... # type: 'QFileDialog.FileMode'
    ExistingFiles = ... # type: 'QFileDialog.FileMode'
    DirectoryOnly = ... # type: 'QFileDialog.FileMode'

    class ViewMode(int): ...
    Detail = ... # type: 'QFileDialog.ViewMode'
    List = ... # type: 'QFileDialog.ViewMode'

    class Options(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QFileDialog.Options', 'QFileDialog.Option']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QFileDialog.Options') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QFileDialog.Options': ...
        def __int__(self) -> int: ...

    @typing.overload
    def __init__(self, parent: QWidget, f: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType]) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ..., caption: str = ..., directory: str = ..., filter: str = ...) -> None: ...

    def setVisible(self, visible: bool) -> None: ...
    @typing.overload
    def open(self) -> None: ...
    @typing.overload
    def open(self, receiver: QtCore.QObject, member: QT_SLOT) -> None: ...
    @typing.overload
    def open(self, slot: PYQT_SLOT) -> None: ...
    def options(self) -> 'QFileDialog.Options': ...
    def setOptions(self, options: 'QFileDialog.Options') -> None: ...
    def testOption(self, option: 'QFileDialog.Option') -> bool: ...
    def setOption(self, option: 'QFileDialog.Option', on: bool = ...) -> None: ...
    def filter(self) -> QtCore.QDir.Filters: ...
    def selectedNameFilter(self) -> str: ...
    def selectNameFilter(self, filter: str) -> None: ...
    def nameFilters(self) -> typing.List[str]: ...
    def setNameFilters(self, filters: typing.Sequence[str]) -> None: ...
    def setNameFilter(self, filter: str) -> None: ...
    def isNameFilterDetailsVisible(self) -> bool: ...
    def setNameFilterDetailsVisible(self, enabled: bool) -> None: ...
    def proxyModel(self) -> QAbstractProxyModel: ...
    def setProxyModel(self, model: QAbstractProxyModel) -> None: ...
    def restoreState(self, state: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> bool: ...
    def saveState(self) -> QtCore.QByteArray: ...
    def sidebarUrls(self) -> typing.List[QtCore.QUrl]: ...
    def setSidebarUrls(self, urls: typing.Sequence[QtCore.QUrl]) -> None: ...
    def changeEvent(self, e: QtCore.QEvent) -> None: ...
    def accept(self) -> None: ...
    def done(self, result: int) -> None: ...
    @staticmethod
    def getSaveFileNameAndFilter(parent: typing.Optional[QWidget] = ..., caption: str = ..., directory: str = ..., filter: str = ..., initialFilter: str = ..., options: typing.Union['QFileDialog.Options', 'QFileDialog.Option'] = ...) -> typing.Tuple[str, str]: ...
    @staticmethod
    def getSaveFileName(parent: typing.Optional[QWidget] = ..., caption: str = ..., directory: str = ..., filter: str = ..., options: typing.Union['QFileDialog.Options', 'QFileDialog.Option'] = ...) -> str: ...
    @staticmethod
    def getOpenFileNamesAndFilter(parent: typing.Optional[QWidget] = ..., caption: str = ..., directory: str = ..., filter: str = ..., initialFilter: str = ..., options: typing.Union['QFileDialog.Options', 'QFileDialog.Option'] = ...) -> typing.Tuple[str, str]: ...
    @staticmethod
    def getOpenFileNames(parent: typing.Optional[QWidget] = ..., caption: str = ..., directory: str = ..., filter: str = ..., options: typing.Union['QFileDialog.Options', 'QFileDialog.Option'] = ...) -> typing.List[str]: ...
    @staticmethod
    def getOpenFileNameAndFilter(parent: typing.Optional[QWidget] = ..., caption: str = ..., directory: str = ..., filter: str = ..., initialFilter: str = ..., options: typing.Union['QFileDialog.Options', 'QFileDialog.Option'] = ...) -> typing.Tuple[str, str]: ...
    @staticmethod
    def getOpenFileName(parent: typing.Optional[QWidget] = ..., caption: str = ..., directory: str = ..., filter: str = ..., options: typing.Union['QFileDialog.Options', 'QFileDialog.Option'] = ...) -> str: ...
    @staticmethod
    def getExistingDirectory(parent: typing.Optional[QWidget] = ..., caption: str = ..., directory: str = ..., options: 'QFileDialog.Options' = ...) -> str: ...
    def fileSelected(self, file: str) -> None: ...
    def filterSelected(self, filter: str) -> None: ...
    def filesSelected(self, files: typing.Sequence[str]) -> None: ...
    def directoryEntered(self, directory: str) -> None: ...
    def currentChanged(self, path: str) -> None: ...
    def labelText(self, label: 'QFileDialog.DialogLabel') -> str: ...
    def setLabelText(self, label: 'QFileDialog.DialogLabel', text: str) -> None: ...
    def iconProvider(self) -> 'QFileIconProvider': ...
    def setIconProvider(self, provider: 'QFileIconProvider') -> None: ...
    def itemDelegate(self) -> QAbstractItemDelegate: ...
    def setItemDelegate(self, delegate: QAbstractItemDelegate) -> None: ...
    def history(self) -> typing.List[str]: ...
    def setHistory(self, paths: typing.Sequence[str]) -> None: ...
    def defaultSuffix(self) -> str: ...
    def setDefaultSuffix(self, suffix: str) -> None: ...
    def confirmOverwrite(self) -> bool: ...
    def setConfirmOverwrite(self, enabled: bool) -> None: ...
    def resolveSymlinks(self) -> bool: ...
    def setResolveSymlinks(self, enabled: bool) -> None: ...
    def isReadOnly(self) -> bool: ...
    def setReadOnly(self, enabled: bool) -> None: ...
    def acceptMode(self) -> 'QFileDialog.AcceptMode': ...
    def setAcceptMode(self, mode: 'QFileDialog.AcceptMode') -> None: ...
    def fileMode(self) -> 'QFileDialog.FileMode': ...
    def setFileMode(self, mode: 'QFileDialog.FileMode') -> None: ...
    def viewMode(self) -> 'QFileDialog.ViewMode': ...
    def setViewMode(self, mode: 'QFileDialog.ViewMode') -> None: ...
    def selectedFilter(self) -> str: ...
    def selectFilter(self, filter: str) -> None: ...
    def filters(self) -> typing.List[str]: ...
    def setFilters(self, filters: typing.Sequence[str]) -> None: ...
    @typing.overload
    def setFilter(self, filter: str) -> None: ...
    @typing.overload
    def setFilter(self, filters: QtCore.QDir.Filters) -> None: ...
    def selectedFiles(self) -> typing.List[str]: ...
    def selectFile(self, filename: str) -> None: ...
    def directory(self) -> QtCore.QDir: ...
    @typing.overload
    def setDirectory(self, directory: str) -> None: ...
    @typing.overload
    def setDirectory(self, adirectory: QtCore.QDir) -> None: ...


class QFileIconProvider(sip.simplewrapper):

    class IconType(int): ...
    Computer = ... # type: 'QFileIconProvider.IconType'
    Desktop = ... # type: 'QFileIconProvider.IconType'
    Trashcan = ... # type: 'QFileIconProvider.IconType'
    Network = ... # type: 'QFileIconProvider.IconType'
    Drive = ... # type: 'QFileIconProvider.IconType'
    Folder = ... # type: 'QFileIconProvider.IconType'
    File = ... # type: 'QFileIconProvider.IconType'

    def __init__(self) -> None: ...

    def type(self, info: QtCore.QFileInfo) -> str: ...
    @typing.overload
    def icon(self, type: 'QFileIconProvider.IconType') -> 'QIcon': ...
    @typing.overload
    def icon(self, info: QtCore.QFileInfo) -> 'QIcon': ...


class QFileSystemModel(QtCore.QAbstractItemModel):

    class Roles(int): ...
    FileIconRole = ... # type: 'QFileSystemModel.Roles'
    FilePathRole = ... # type: 'QFileSystemModel.Roles'
    FileNameRole = ... # type: 'QFileSystemModel.Roles'
    FilePermissions = ... # type: 'QFileSystemModel.Roles'

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def timerEvent(self, event: QtCore.QTimerEvent) -> None: ...
    def event(self, event: QtCore.QEvent) -> bool: ...
    def directoryLoaded(self, path: str) -> None: ...
    def rootPathChanged(self, newPath: str) -> None: ...
    def fileRenamed(self, path: str, oldName: str, newName: str) -> None: ...
    def remove(self, aindex: QtCore.QModelIndex) -> bool: ...
    def fileInfo(self, aindex: QtCore.QModelIndex) -> QtCore.QFileInfo: ...
    def fileIcon(self, aindex: QtCore.QModelIndex) -> 'QIcon': ...
    def fileName(self, aindex: QtCore.QModelIndex) -> str: ...
    def rmdir(self, aindex: QtCore.QModelIndex) -> bool: ...
    def permissions(self, index: QtCore.QModelIndex) -> QtCore.QFile.Permissions: ...
    def mkdir(self, parent: QtCore.QModelIndex, name: str) -> QtCore.QModelIndex: ...
    def lastModified(self, index: QtCore.QModelIndex) -> QtCore.QDateTime: ...
    def type(self, index: QtCore.QModelIndex) -> str: ...
    def size(self, index: QtCore.QModelIndex) -> int: ...
    def isDir(self, index: QtCore.QModelIndex) -> bool: ...
    def filePath(self, index: QtCore.QModelIndex) -> str: ...
    def nameFilters(self) -> typing.List[str]: ...
    def setNameFilters(self, filters: typing.Sequence[str]) -> None: ...
    def nameFilterDisables(self) -> bool: ...
    def setNameFilterDisables(self, enable: bool) -> None: ...
    def isReadOnly(self) -> bool: ...
    def setReadOnly(self, enable: bool) -> None: ...
    def resolveSymlinks(self) -> bool: ...
    def setResolveSymlinks(self, enable: bool) -> None: ...
    def filter(self) -> QtCore.QDir.Filters: ...
    def setFilter(self, filters: QtCore.QDir.Filters) -> None: ...
    def iconProvider(self) -> QFileIconProvider: ...
    def setIconProvider(self, provider: QFileIconProvider) -> None: ...
    def rootDirectory(self) -> QtCore.QDir: ...
    def rootPath(self) -> str: ...
    def setRootPath(self, path: str) -> QtCore.QModelIndex: ...
    def supportedDropActions(self) -> QtCore.Qt.DropActions: ...
    def dropMimeData(self, data: QtCore.QMimeData, action: QtCore.Qt.DropAction, row: int, column: int, parent: QtCore.QModelIndex) -> bool: ...
    def mimeData(self, indexes: typing.Sequence[QtCore.QModelIndex]) -> QtCore.QMimeData: ...
    def mimeTypes(self) -> typing.List[str]: ...
    def sort(self, column: int, order: QtCore.Qt.SortOrder = ...) -> None: ...
    def flags(self, index: QtCore.QModelIndex) -> QtCore.Qt.ItemFlags: ...
    def headerData(self, section: int, orientation: QtCore.Qt.Orientation, role: int = ...) -> typing.Any: ...
    def setData(self, idx: QtCore.QModelIndex, value: typing.Any, role: int = ...) -> bool: ...
    def data(self, index: QtCore.QModelIndex, role: int = ...) -> typing.Any: ...
    def myComputer(self, role: int = ...) -> typing.Any: ...
    def columnCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def fetchMore(self, parent: QtCore.QModelIndex) -> None: ...
    def canFetchMore(self, parent: QtCore.QModelIndex) -> bool: ...
    def hasChildren(self, parent: QtCore.QModelIndex = ...) -> bool: ...
    def parent(self, child: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    @typing.overload
    def index(self, row: int, column: int, parent: QtCore.QModelIndex = ...) -> QtCore.QModelIndex: ...
    @typing.overload
    def index(self, path: str, column: int = ...) -> QtCore.QModelIndex: ...


class QFocusFrame(QWidget):

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...

    def paintEvent(self, a0: QPaintEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def eventFilter(self, a0: QtCore.QObject, a1: QtCore.QEvent) -> bool: ...
    def initStyleOption(self, option: 'QStyleOption') -> None: ...
    def widget(self) -> QWidget: ...
    def setWidget(self, widget: QWidget) -> None: ...


class QFont(sip.simplewrapper):

    class HintingPreference(int): ...
    PreferDefaultHinting = ... # type: 'QFont.HintingPreference'
    PreferNoHinting = ... # type: 'QFont.HintingPreference'
    PreferVerticalHinting = ... # type: 'QFont.HintingPreference'
    PreferFullHinting = ... # type: 'QFont.HintingPreference'

    class SpacingType(int): ...
    PercentageSpacing = ... # type: 'QFont.SpacingType'
    AbsoluteSpacing = ... # type: 'QFont.SpacingType'

    class Capitalization(int): ...
    MixedCase = ... # type: 'QFont.Capitalization'
    AllUppercase = ... # type: 'QFont.Capitalization'
    AllLowercase = ... # type: 'QFont.Capitalization'
    SmallCaps = ... # type: 'QFont.Capitalization'
    Capitalize = ... # type: 'QFont.Capitalization'

    class Stretch(int): ...
    UltraCondensed = ... # type: 'QFont.Stretch'
    ExtraCondensed = ... # type: 'QFont.Stretch'
    Condensed = ... # type: 'QFont.Stretch'
    SemiCondensed = ... # type: 'QFont.Stretch'
    Unstretched = ... # type: 'QFont.Stretch'
    SemiExpanded = ... # type: 'QFont.Stretch'
    Expanded = ... # type: 'QFont.Stretch'
    ExtraExpanded = ... # type: 'QFont.Stretch'
    UltraExpanded = ... # type: 'QFont.Stretch'

    class Style(int): ...
    StyleNormal = ... # type: 'QFont.Style'
    StyleItalic = ... # type: 'QFont.Style'
    StyleOblique = ... # type: 'QFont.Style'

    class Weight(int): ...
    Light = ... # type: 'QFont.Weight'
    Normal = ... # type: 'QFont.Weight'
    DemiBold = ... # type: 'QFont.Weight'
    Bold = ... # type: 'QFont.Weight'
    Black = ... # type: 'QFont.Weight'

    class StyleStrategy(int): ...
    PreferDefault = ... # type: 'QFont.StyleStrategy'
    PreferBitmap = ... # type: 'QFont.StyleStrategy'
    PreferDevice = ... # type: 'QFont.StyleStrategy'
    PreferOutline = ... # type: 'QFont.StyleStrategy'
    ForceOutline = ... # type: 'QFont.StyleStrategy'
    PreferMatch = ... # type: 'QFont.StyleStrategy'
    PreferQuality = ... # type: 'QFont.StyleStrategy'
    PreferAntialias = ... # type: 'QFont.StyleStrategy'
    NoAntialias = ... # type: 'QFont.StyleStrategy'
    OpenGLCompatible = ... # type: 'QFont.StyleStrategy'
    NoFontMerging = ... # type: 'QFont.StyleStrategy'
    ForceIntegerMetrics = ... # type: 'QFont.StyleStrategy'

    class StyleHint(int): ...
    Helvetica = ... # type: 'QFont.StyleHint'
    SansSerif = ... # type: 'QFont.StyleHint'
    Times = ... # type: 'QFont.StyleHint'
    Serif = ... # type: 'QFont.StyleHint'
    Courier = ... # type: 'QFont.StyleHint'
    TypeWriter = ... # type: 'QFont.StyleHint'
    OldEnglish = ... # type: 'QFont.StyleHint'
    Decorative = ... # type: 'QFont.StyleHint'
    System = ... # type: 'QFont.StyleHint'
    AnyStyle = ... # type: 'QFont.StyleHint'
    Cursive = ... # type: 'QFont.StyleHint'
    Monospace = ... # type: 'QFont.StyleHint'
    Fantasy = ... # type: 'QFont.StyleHint'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, family: str, pointSize: int = ..., weight: int = ..., italic: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QFont', pd: QPaintDevice) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QFont') -> None: ...
    @typing.overload
    def __init__(self, variant: typing.Any) -> None: ...

    def hintingPreference(self) -> 'QFont.HintingPreference': ...
    def setHintingPreference(self, hintingPreference: 'QFont.HintingPreference') -> None: ...
    def setStyleName(self, styleName: str) -> None: ...
    def styleName(self) -> str: ...
    def capitalization(self) -> 'QFont.Capitalization': ...
    def setCapitalization(self, a0: 'QFont.Capitalization') -> None: ...
    def setWordSpacing(self, spacing: float) -> None: ...
    def wordSpacing(self) -> float: ...
    def setLetterSpacing(self, type: 'QFont.SpacingType', spacing: float) -> None: ...
    def letterSpacingType(self) -> 'QFont.SpacingType': ...
    def letterSpacing(self) -> float: ...
    def setItalic(self, b: bool) -> None: ...
    def italic(self) -> bool: ...
    def setBold(self, enable: bool) -> None: ...
    def bold(self) -> bool: ...
    def resolve(self, a0: 'QFont') -> 'QFont': ...
    def lastResortFont(self) -> str: ...
    def lastResortFamily(self) -> str: ...
    def defaultFamily(self) -> str: ...
    @staticmethod
    def cacheStatistics() -> None: ...
    @staticmethod
    def cleanup() -> None: ...
    @staticmethod
    def initialize() -> None: ...
    @staticmethod
    def removeSubstitution(a0: str) -> None: ...
    @staticmethod
    def insertSubstitutions(a0: str, a1: typing.Sequence[str]) -> None: ...
    @staticmethod
    def insertSubstitution(a0: str, a1: str) -> None: ...
    @staticmethod
    def substitutions() -> typing.List[str]: ...
    @staticmethod
    def substitutes(a0: str) -> typing.List[str]: ...
    @staticmethod
    def substitute(a0: str) -> str: ...
    def fromString(self, a0: str) -> bool: ...
    def toString(self) -> str: ...
    def key(self) -> str: ...
    def rawName(self) -> str: ...
    def setRawName(self, a0: str) -> None: ...
    def handle(self) -> int: ...
    def isCopyOf(self, a0: 'QFont') -> bool: ...
    def exactMatch(self) -> bool: ...
    def setRawMode(self, a0: bool) -> None: ...
    def rawMode(self) -> bool: ...
    def setStretch(self, a0: int) -> None: ...
    def stretch(self) -> int: ...
    def setStyleStrategy(self, s: 'QFont.StyleStrategy') -> None: ...
    def setStyleHint(self, hint: 'QFont.StyleHint', strategy: 'QFont.StyleStrategy' = ...) -> None: ...
    def styleStrategy(self) -> 'QFont.StyleStrategy': ...
    def styleHint(self) -> 'QFont.StyleHint': ...
    def setKerning(self, a0: bool) -> None: ...
    def kerning(self) -> bool: ...
    def setFixedPitch(self, a0: bool) -> None: ...
    def fixedPitch(self) -> bool: ...
    def setStrikeOut(self, a0: bool) -> None: ...
    def strikeOut(self) -> bool: ...
    def setOverline(self, a0: bool) -> None: ...
    def overline(self) -> bool: ...
    def setUnderline(self, a0: bool) -> None: ...
    def underline(self) -> bool: ...
    def style(self) -> 'QFont.Style': ...
    def setStyle(self, style: 'QFont.Style') -> None: ...
    def setWeight(self, a0: int) -> None: ...
    def weight(self) -> int: ...
    def setPixelSize(self, a0: int) -> None: ...
    def pixelSize(self) -> int: ...
    def setPointSizeF(self, a0: float) -> None: ...
    def pointSizeF(self) -> float: ...
    def setPointSize(self, a0: int) -> None: ...
    def pointSize(self) -> int: ...
    def setFamily(self, a0: str) -> None: ...
    def family(self) -> str: ...


class QFontComboBox(QComboBox):

    class FontFilter(int): ...
    AllFonts = ... # type: 'QFontComboBox.FontFilter'
    ScalableFonts = ... # type: 'QFontComboBox.FontFilter'
    NonScalableFonts = ... # type: 'QFontComboBox.FontFilter'
    MonospacedFonts = ... # type: 'QFontComboBox.FontFilter'
    ProportionalFonts = ... # type: 'QFontComboBox.FontFilter'

    class FontFilters(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QFontComboBox.FontFilters', 'QFontComboBox.FontFilter']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QFontComboBox.FontFilters') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QFontComboBox.FontFilters': ...
        def __int__(self) -> int: ...

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...

    def event(self, e: QtCore.QEvent) -> bool: ...
    def currentFontChanged(self, f: QFont) -> None: ...
    def setCurrentFont(self, f: QFont) -> None: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def currentFont(self) -> QFont: ...
    def setFontFilters(self, filters: 'QFontComboBox.FontFilters') -> None: ...
    def writingSystem(self) -> 'QFontDatabase.WritingSystem': ...
    def setWritingSystem(self, a0: 'QFontDatabase.WritingSystem') -> None: ...
    def fontFilters(self) -> 'QFontComboBox.FontFilters': ...


class QFontDatabase(sip.simplewrapper):

    class WritingSystem(int): ...
    Any = ... # type: 'QFontDatabase.WritingSystem'
    Latin = ... # type: 'QFontDatabase.WritingSystem'
    Greek = ... # type: 'QFontDatabase.WritingSystem'
    Cyrillic = ... # type: 'QFontDatabase.WritingSystem'
    Armenian = ... # type: 'QFontDatabase.WritingSystem'
    Hebrew = ... # type: 'QFontDatabase.WritingSystem'
    Arabic = ... # type: 'QFontDatabase.WritingSystem'
    Syriac = ... # type: 'QFontDatabase.WritingSystem'
    Thaana = ... # type: 'QFontDatabase.WritingSystem'
    Devanagari = ... # type: 'QFontDatabase.WritingSystem'
    Bengali = ... # type: 'QFontDatabase.WritingSystem'
    Gurmukhi = ... # type: 'QFontDatabase.WritingSystem'
    Gujarati = ... # type: 'QFontDatabase.WritingSystem'
    Oriya = ... # type: 'QFontDatabase.WritingSystem'
    Tamil = ... # type: 'QFontDatabase.WritingSystem'
    Telugu = ... # type: 'QFontDatabase.WritingSystem'
    Kannada = ... # type: 'QFontDatabase.WritingSystem'
    Malayalam = ... # type: 'QFontDatabase.WritingSystem'
    Sinhala = ... # type: 'QFontDatabase.WritingSystem'
    Thai = ... # type: 'QFontDatabase.WritingSystem'
    Lao = ... # type: 'QFontDatabase.WritingSystem'
    Tibetan = ... # type: 'QFontDatabase.WritingSystem'
    Myanmar = ... # type: 'QFontDatabase.WritingSystem'
    Georgian = ... # type: 'QFontDatabase.WritingSystem'
    Khmer = ... # type: 'QFontDatabase.WritingSystem'
    SimplifiedChinese = ... # type: 'QFontDatabase.WritingSystem'
    TraditionalChinese = ... # type: 'QFontDatabase.WritingSystem'
    Japanese = ... # type: 'QFontDatabase.WritingSystem'
    Korean = ... # type: 'QFontDatabase.WritingSystem'
    Vietnamese = ... # type: 'QFontDatabase.WritingSystem'
    Other = ... # type: 'QFontDatabase.WritingSystem'
    Symbol = ... # type: 'QFontDatabase.WritingSystem'
    Ogham = ... # type: 'QFontDatabase.WritingSystem'
    Runic = ... # type: 'QFontDatabase.WritingSystem'
    Nko = ... # type: 'QFontDatabase.WritingSystem'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QFontDatabase') -> None: ...

    @staticmethod
    def supportsThreadedFontRendering() -> bool: ...
    @staticmethod
    def removeAllApplicationFonts() -> bool: ...
    @staticmethod
    def removeApplicationFont(id: int) -> bool: ...
    @staticmethod
    def applicationFontFamilies(id: int) -> typing.List[str]: ...
    @staticmethod
    def addApplicationFontFromData(fontData: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> int: ...
    @staticmethod
    def addApplicationFont(fileName: str) -> int: ...
    @staticmethod
    def writingSystemSample(writingSystem: 'QFontDatabase.WritingSystem') -> str: ...
    @staticmethod
    def writingSystemName(writingSystem: 'QFontDatabase.WritingSystem') -> str: ...
    def weight(self, family: str, style: str) -> int: ...
    def bold(self, family: str, style: str) -> bool: ...
    def italic(self, family: str, style: str) -> bool: ...
    def isFixedPitch(self, family: str, style: str = ...) -> bool: ...
    def isScalable(self, family: str, style: str = ...) -> bool: ...
    def isSmoothlyScalable(self, family: str, style: str = ...) -> bool: ...
    def isBitmapScalable(self, family: str, style: str = ...) -> bool: ...
    def font(self, family: str, style: str, pointSize: int) -> QFont: ...
    @typing.overload
    def styleString(self, font: QFont) -> str: ...
    @typing.overload
    def styleString(self, fontInfo: 'QFontInfo') -> str: ...
    def smoothSizes(self, family: str, style: str) -> typing.List[int]: ...
    def pointSizes(self, family: str, style: str = ...) -> typing.List[int]: ...
    def styles(self, family: str) -> typing.List[str]: ...
    def families(self, writingSystem: 'QFontDatabase.WritingSystem' = ...) -> typing.List[str]: ...
    @typing.overload
    def writingSystems(self) -> typing.List['QFontDatabase.WritingSystem']: ...
    @typing.overload
    def writingSystems(self, family: str) -> typing.List['QFontDatabase.WritingSystem']: ...
    @staticmethod
    def standardSizes() -> typing.List[int]: ...


class QFontDialog(QDialog):

    class FontDialogOption(int): ...
    NoButtons = ... # type: 'QFontDialog.FontDialogOption'
    DontUseNativeDialog = ... # type: 'QFontDialog.FontDialogOption'

    class FontDialogOptions(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QFontDialog.FontDialogOptions', 'QFontDialog.FontDialogOption']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QFontDialog.FontDialogOptions') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QFontDialog.FontDialogOptions': ...
        def __int__(self) -> int: ...

    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, initial: QFont, parent: typing.Optional[QWidget] = ...) -> None: ...

    def fontSelected(self, font: QFont) -> None: ...
    def currentFontChanged(self, font: QFont) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    @typing.overload
    def open(self) -> None: ...
    @typing.overload
    def open(self, receiver: QtCore.QObject, member: QT_SLOT) -> None: ...
    @typing.overload
    def open(self, slot: PYQT_SLOT) -> None: ...
    def options(self) -> 'QFontDialog.FontDialogOptions': ...
    def setOptions(self, options: 'QFontDialog.FontDialogOptions') -> None: ...
    def testOption(self, option: 'QFontDialog.FontDialogOption') -> bool: ...
    def setOption(self, option: 'QFontDialog.FontDialogOption', on: bool = ...) -> None: ...
    def selectedFont(self) -> QFont: ...
    def currentFont(self) -> QFont: ...
    def setCurrentFont(self, font: QFont) -> None: ...
    def done(self, result: int) -> None: ...
    def changeEvent(self, e: QtCore.QEvent) -> None: ...
    @typing.overload
    @staticmethod
    def getFont(initial: QFont, parent: QWidget, title: str, options: 'QFontDialog.FontDialogOptions') -> typing.Tuple[QFont, bool]: ...
    @typing.overload
    @staticmethod
    def getFont(def_: QFont, parent: QWidget, caption: str) -> typing.Tuple[QFont, bool]: ...
    @typing.overload
    @staticmethod
    def getFont(initial: QFont, parent: typing.Optional[QWidget] = ...) -> typing.Tuple[QFont, bool]: ...
    @typing.overload
    @staticmethod
    def getFont(parent: typing.Optional[QWidget] = ...) -> typing.Tuple[QFont, bool]: ...


class QFontInfo(sip.simplewrapper):

    @typing.overload
    def __init__(self, a0: QFont) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QFontInfo') -> None: ...

    def styleName(self) -> str: ...
    def exactMatch(self) -> bool: ...
    def rawMode(self) -> bool: ...
    def styleHint(self) -> QFont.StyleHint: ...
    def fixedPitch(self) -> bool: ...
    def bold(self) -> bool: ...
    def weight(self) -> int: ...
    def style(self) -> QFont.Style: ...
    def italic(self) -> bool: ...
    def pointSizeF(self) -> float: ...
    def pointSize(self) -> int: ...
    def pixelSize(self) -> int: ...
    def family(self) -> str: ...


class QFontMetrics(sip.simplewrapper):

    @typing.overload
    def __init__(self, a0: QFont) -> None: ...
    @typing.overload
    def __init__(self, a0: QFont, pd: QPaintDevice) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QFontMetrics') -> None: ...

    def inFontUcs4(self, character: int) -> bool: ...
    def tightBoundingRect(self, text: str) -> QtCore.QRect: ...
    def elidedText(self, text: str, mode: QtCore.Qt.TextElideMode, width: int, flags: int = ...) -> str: ...
    def averageCharWidth(self) -> int: ...
    def lineWidth(self) -> int: ...
    def strikeOutPos(self) -> int: ...
    def overlinePos(self) -> int: ...
    def underlinePos(self) -> int: ...
    def size(self, flags: int, text: str, tabStops: int = ..., tabArray: typing.Optional[typing.Optional[typing.List[int]]] = ...) -> QtCore.QSize: ...
    @typing.overload
    def boundingRect(self, text: str) -> QtCore.QRect: ...
    @typing.overload
    def boundingRect(self, rect: QtCore.QRect, flags: int, text: str, tabStops: int = ..., tabArray: typing.Optional[typing.Optional[typing.List[int]]] = ...) -> QtCore.QRect: ...
    @typing.overload
    def boundingRect(self, x: int, y: int, width: int, height: int, flags: int, text: str, tabStops: int = ..., tabArray: typing.Optional[typing.Optional[typing.List[int]]] = ...) -> QtCore.QRect: ...
    def boundingRectChar(self, a0: str) -> QtCore.QRect: ...
    def charWidth(self, str: str, pos: int) -> int: ...
    def width(self, text: str, length: int = ...) -> int: ...
    def widthChar(self, a0: str) -> int: ...
    def rightBearing(self, a0: str) -> int: ...
    def leftBearing(self, a0: str) -> int: ...
    def inFont(self, a0: str) -> bool: ...
    def xHeight(self) -> int: ...
    def maxWidth(self) -> int: ...
    def minRightBearing(self) -> int: ...
    def minLeftBearing(self) -> int: ...
    def lineSpacing(self) -> int: ...
    def leading(self) -> int: ...
    def height(self) -> int: ...
    def descent(self) -> int: ...
    def ascent(self) -> int: ...


class QFontMetricsF(sip.simplewrapper):

    @typing.overload
    def __init__(self, a0: QFont) -> None: ...
    @typing.overload
    def __init__(self, a0: QFont, pd: QPaintDevice) -> None: ...
    @typing.overload
    def __init__(self, a0: QFontMetrics) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QFontMetricsF') -> None: ...

    def inFontUcs4(self, character: int) -> bool: ...
    def tightBoundingRect(self, text: str) -> QtCore.QRectF: ...
    def elidedText(self, text: str, mode: QtCore.Qt.TextElideMode, width: float, flags: int = ...) -> str: ...
    def averageCharWidth(self) -> float: ...
    def lineWidth(self) -> float: ...
    def strikeOutPos(self) -> float: ...
    def overlinePos(self) -> float: ...
    def underlinePos(self) -> float: ...
    def size(self, flags: int, text: str, tabStops: int = ..., tabArray: typing.Optional[typing.Optional[typing.List[int]]] = ...) -> QtCore.QSizeF: ...
    @typing.overload
    def boundingRect(self, string: str) -> QtCore.QRectF: ...
    @typing.overload
    def boundingRect(self, rect: QtCore.QRectF, flags: int, text: str, tabStops: int = ..., tabArray: typing.Optional[typing.Optional[typing.List[int]]] = ...) -> QtCore.QRectF: ...
    def boundingRectChar(self, a0: str) -> QtCore.QRectF: ...
    def width(self, string: str) -> float: ...
    def widthChar(self, a0: str) -> float: ...
    def rightBearing(self, a0: str) -> float: ...
    def leftBearing(self, a0: str) -> float: ...
    def inFont(self, a0: str) -> bool: ...
    def xHeight(self) -> float: ...
    def maxWidth(self) -> float: ...
    def minRightBearing(self) -> float: ...
    def minLeftBearing(self) -> float: ...
    def lineSpacing(self) -> float: ...
    def leading(self) -> float: ...
    def height(self) -> float: ...
    def descent(self) -> float: ...
    def ascent(self) -> float: ...


class QFormLayout(QLayout):

    class ItemRole(int): ...
    LabelRole = ... # type: 'QFormLayout.ItemRole'
    FieldRole = ... # type: 'QFormLayout.ItemRole'
    SpanningRole = ... # type: 'QFormLayout.ItemRole'

    class RowWrapPolicy(int): ...
    DontWrapRows = ... # type: 'QFormLayout.RowWrapPolicy'
    WrapLongRows = ... # type: 'QFormLayout.RowWrapPolicy'
    WrapAllRows = ... # type: 'QFormLayout.RowWrapPolicy'

    class FieldGrowthPolicy(int): ...
    FieldsStayAtSizeHint = ... # type: 'QFormLayout.FieldGrowthPolicy'
    ExpandingFieldsGrow = ... # type: 'QFormLayout.FieldGrowthPolicy'
    AllNonFixedFieldsGrow = ... # type: 'QFormLayout.FieldGrowthPolicy'

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...

    def rowCount(self) -> int: ...
    def count(self) -> int: ...
    def expandingDirections(self) -> QtCore.Qt.Orientations: ...
    def heightForWidth(self, width: int) -> int: ...
    def hasHeightForWidth(self) -> bool: ...
    def invalidate(self) -> None: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def minimumSize(self) -> QtCore.QSize: ...
    def setGeometry(self, rect: QtCore.QRect) -> None: ...
    def takeAt(self, index: int) -> QLayoutItem: ...
    def addItem(self, item: QLayoutItem) -> None: ...
    @typing.overload
    def labelForField(self, field: QWidget) -> QWidget: ...
    @typing.overload
    def labelForField(self, field: QLayout) -> QWidget: ...
    def getLayoutPosition(self, layout: QLayout) -> typing.Tuple[int, 'QFormLayout.ItemRole']: ...
    def getWidgetPosition(self, widget: QWidget) -> typing.Tuple[int, 'QFormLayout.ItemRole']: ...
    def getItemPosition(self, index: int) -> typing.Tuple[int, 'QFormLayout.ItemRole']: ...
    @typing.overload
    def itemAt(self, row: int, role: 'QFormLayout.ItemRole') -> QLayoutItem: ...
    @typing.overload
    def itemAt(self, index: int) -> QLayoutItem: ...
    def setLayout(self, row: int, role: 'QFormLayout.ItemRole', layout: QLayout) -> None: ...
    def setWidget(self, row: int, role: 'QFormLayout.ItemRole', widget: QWidget) -> None: ...
    def setItem(self, row: int, role: 'QFormLayout.ItemRole', item: QLayoutItem) -> None: ...
    @typing.overload
    def insertRow(self, row: int, label: QWidget, field: QWidget) -> None: ...
    @typing.overload
    def insertRow(self, row: int, label: QWidget, field: QLayout) -> None: ...
    @typing.overload
    def insertRow(self, row: int, labelText: str, field: QWidget) -> None: ...
    @typing.overload
    def insertRow(self, row: int, labelText: str, field: QLayout) -> None: ...
    @typing.overload
    def insertRow(self, row: int, widget: QWidget) -> None: ...
    @typing.overload
    def insertRow(self, row: int, layout: QLayout) -> None: ...
    @typing.overload
    def addRow(self, label: QWidget, field: QWidget) -> None: ...
    @typing.overload
    def addRow(self, label: QWidget, field: QLayout) -> None: ...
    @typing.overload
    def addRow(self, labelText: str, field: QWidget) -> None: ...
    @typing.overload
    def addRow(self, labelText: str, field: QLayout) -> None: ...
    @typing.overload
    def addRow(self, widget: QWidget) -> None: ...
    @typing.overload
    def addRow(self, layout: QLayout) -> None: ...
    def setSpacing(self, a0: int) -> None: ...
    def spacing(self) -> int: ...
    def verticalSpacing(self) -> int: ...
    def setVerticalSpacing(self, spacing: int) -> None: ...
    def horizontalSpacing(self) -> int: ...
    def setHorizontalSpacing(self, spacing: int) -> None: ...
    def formAlignment(self) -> QtCore.Qt.Alignment: ...
    def setFormAlignment(self, alignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> None: ...
    def labelAlignment(self) -> QtCore.Qt.Alignment: ...
    def setLabelAlignment(self, alignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> None: ...
    def rowWrapPolicy(self) -> 'QFormLayout.RowWrapPolicy': ...
    def setRowWrapPolicy(self, policy: 'QFormLayout.RowWrapPolicy') -> None: ...
    def fieldGrowthPolicy(self) -> 'QFormLayout.FieldGrowthPolicy': ...
    def setFieldGrowthPolicy(self, policy: 'QFormLayout.FieldGrowthPolicy') -> None: ...


class QMatrix4x3(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QMatrix4x3') -> None: ...
    @typing.overload
    def __init__(self, values: typing.Sequence[float]) -> None: ...

    def transposed(self) -> 'QMatrix3x4': ...
    def fill(self, value: float) -> None: ...
    def setToIdentity(self) -> None: ...
    def isIdentity(self) -> bool: ...
    def __setitem__(self, a0: typing.Any, a1: float) -> None: ...
    def __getitem__(self, a0: typing.Any) -> typing.Any: ...
    def copyDataTo(self) -> typing.List[float]: ...
    def data(self) -> typing.List[float]: ...
    def __repr__(self) -> str: ...


class QMatrix4x2(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QMatrix4x2') -> None: ...
    @typing.overload
    def __init__(self, values: typing.Sequence[float]) -> None: ...

    def transposed(self) -> 'QMatrix2x4': ...
    def fill(self, value: float) -> None: ...
    def setToIdentity(self) -> None: ...
    def isIdentity(self) -> bool: ...
    def __setitem__(self, a0: typing.Any, a1: float) -> None: ...
    def __getitem__(self, a0: typing.Any) -> typing.Any: ...
    def copyDataTo(self) -> typing.List[float]: ...
    def data(self) -> typing.List[float]: ...
    def __repr__(self) -> str: ...


class QMatrix3x4(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QMatrix3x4') -> None: ...
    @typing.overload
    def __init__(self, values: typing.Sequence[float]) -> None: ...

    def transposed(self) -> QMatrix4x3: ...
    def fill(self, value: float) -> None: ...
    def setToIdentity(self) -> None: ...
    def isIdentity(self) -> bool: ...
    def __setitem__(self, a0: typing.Any, a1: float) -> None: ...
    def __getitem__(self, a0: typing.Any) -> typing.Any: ...
    def copyDataTo(self) -> typing.List[float]: ...
    def data(self) -> typing.List[float]: ...
    def __repr__(self) -> str: ...


class QMatrix3x3(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QMatrix3x3') -> None: ...
    @typing.overload
    def __init__(self, values: typing.Sequence[float]) -> None: ...

    def transposed(self) -> 'QMatrix3x3': ...
    def fill(self, value: float) -> None: ...
    def setToIdentity(self) -> None: ...
    def isIdentity(self) -> bool: ...
    def __setitem__(self, a0: typing.Any, a1: float) -> None: ...
    def __getitem__(self, a0: typing.Any) -> typing.Any: ...
    def copyDataTo(self) -> typing.List[float]: ...
    def data(self) -> typing.List[float]: ...
    def __repr__(self) -> str: ...


class QMatrix3x2(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QMatrix3x2') -> None: ...
    @typing.overload
    def __init__(self, values: typing.Sequence[float]) -> None: ...

    def transposed(self) -> 'QMatrix2x3': ...
    def fill(self, value: float) -> None: ...
    def setToIdentity(self) -> None: ...
    def isIdentity(self) -> bool: ...
    def __setitem__(self, a0: typing.Any, a1: float) -> None: ...
    def __getitem__(self, a0: typing.Any) -> typing.Any: ...
    def copyDataTo(self) -> typing.List[float]: ...
    def data(self) -> typing.List[float]: ...
    def __repr__(self) -> str: ...


class QMatrix2x4(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QMatrix2x4') -> None: ...
    @typing.overload
    def __init__(self, values: typing.Sequence[float]) -> None: ...

    def transposed(self) -> QMatrix4x2: ...
    def fill(self, value: float) -> None: ...
    def setToIdentity(self) -> None: ...
    def isIdentity(self) -> bool: ...
    def __setitem__(self, a0: typing.Any, a1: float) -> None: ...
    def __getitem__(self, a0: typing.Any) -> typing.Any: ...
    def copyDataTo(self) -> typing.List[float]: ...
    def data(self) -> typing.List[float]: ...
    def __repr__(self) -> str: ...


class QMatrix2x3(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QMatrix2x3') -> None: ...
    @typing.overload
    def __init__(self, values: typing.Sequence[float]) -> None: ...

    def transposed(self) -> QMatrix3x2: ...
    def fill(self, value: float) -> None: ...
    def setToIdentity(self) -> None: ...
    def isIdentity(self) -> bool: ...
    def __setitem__(self, a0: typing.Any, a1: float) -> None: ...
    def __getitem__(self, a0: typing.Any) -> typing.Any: ...
    def copyDataTo(self) -> typing.List[float]: ...
    def data(self) -> typing.List[float]: ...
    def __repr__(self) -> str: ...


class QMatrix2x2(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QMatrix2x2') -> None: ...
    @typing.overload
    def __init__(self, values: typing.Sequence[float]) -> None: ...

    def transposed(self) -> 'QMatrix2x2': ...
    def fill(self, value: float) -> None: ...
    def setToIdentity(self) -> None: ...
    def isIdentity(self) -> bool: ...
    def __setitem__(self, a0: typing.Any, a1: float) -> None: ...
    def __getitem__(self, a0: typing.Any) -> typing.Any: ...
    def copyDataTo(self) -> typing.List[float]: ...
    def data(self) -> typing.List[float]: ...
    def __repr__(self) -> str: ...


class QGesture(QtCore.QObject):

    class GestureCancelPolicy(int): ...
    CancelNone = ... # type: 'QGesture.GestureCancelPolicy'
    CancelAllInContext = ... # type: 'QGesture.GestureCancelPolicy'

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def gestureCancelPolicy(self) -> 'QGesture.GestureCancelPolicy': ...
    def setGestureCancelPolicy(self, policy: 'QGesture.GestureCancelPolicy') -> None: ...
    def unsetHotSpot(self) -> None: ...
    def hasHotSpot(self) -> bool: ...
    def setHotSpot(self, value: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def hotSpot(self) -> QtCore.QPointF: ...
    def state(self) -> QtCore.Qt.GestureState: ...
    def gestureType(self) -> QtCore.Qt.GestureType: ...


class QPanGesture(QGesture):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def setAcceleration(self, value: float) -> None: ...
    def setOffset(self, value: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def setLastOffset(self, value: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def acceleration(self) -> float: ...
    def delta(self) -> QtCore.QPointF: ...
    def offset(self) -> QtCore.QPointF: ...
    def lastOffset(self) -> QtCore.QPointF: ...


class QPinchGesture(QGesture):

    class ChangeFlag(int): ...
    ScaleFactorChanged = ... # type: 'QPinchGesture.ChangeFlag'
    RotationAngleChanged = ... # type: 'QPinchGesture.ChangeFlag'
    CenterPointChanged = ... # type: 'QPinchGesture.ChangeFlag'

    class ChangeFlags(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QPinchGesture.ChangeFlags', 'QPinchGesture.ChangeFlag']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QPinchGesture.ChangeFlags') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QPinchGesture.ChangeFlags': ...
        def __int__(self) -> int: ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def setRotationAngle(self, value: float) -> None: ...
    def setLastRotationAngle(self, value: float) -> None: ...
    def setTotalRotationAngle(self, value: float) -> None: ...
    def rotationAngle(self) -> float: ...
    def lastRotationAngle(self) -> float: ...
    def totalRotationAngle(self) -> float: ...
    def setScaleFactor(self, value: float) -> None: ...
    def setLastScaleFactor(self, value: float) -> None: ...
    def setTotalScaleFactor(self, value: float) -> None: ...
    def scaleFactor(self) -> float: ...
    def lastScaleFactor(self) -> float: ...
    def totalScaleFactor(self) -> float: ...
    def setCenterPoint(self, value: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def setLastCenterPoint(self, value: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def setStartCenterPoint(self, value: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def centerPoint(self) -> QtCore.QPointF: ...
    def lastCenterPoint(self) -> QtCore.QPointF: ...
    def startCenterPoint(self) -> QtCore.QPointF: ...
    def setChangeFlags(self, value: 'QPinchGesture.ChangeFlags') -> None: ...
    def changeFlags(self) -> 'QPinchGesture.ChangeFlags': ...
    def setTotalChangeFlags(self, value: 'QPinchGesture.ChangeFlags') -> None: ...
    def totalChangeFlags(self) -> 'QPinchGesture.ChangeFlags': ...


class QSwipeGesture(QGesture):

    class SwipeDirection(int): ...
    NoDirection = ... # type: 'QSwipeGesture.SwipeDirection'
    Left = ... # type: 'QSwipeGesture.SwipeDirection'
    Right = ... # type: 'QSwipeGesture.SwipeDirection'
    Up = ... # type: 'QSwipeGesture.SwipeDirection'
    Down = ... # type: 'QSwipeGesture.SwipeDirection'

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def setSwipeAngle(self, value: float) -> None: ...
    def swipeAngle(self) -> float: ...
    def verticalDirection(self) -> 'QSwipeGesture.SwipeDirection': ...
    def horizontalDirection(self) -> 'QSwipeGesture.SwipeDirection': ...


class QTapGesture(QGesture):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def setPosition(self, pos: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def position(self) -> QtCore.QPointF: ...


class QTapAndHoldGesture(QGesture):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    @staticmethod
    def timeout() -> int: ...
    @staticmethod
    def setTimeout(msecs: int) -> None: ...
    def setPosition(self, pos: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def position(self) -> QtCore.QPointF: ...


class QGestureRecognizer(sip.wrapper):

    class ResultFlag(int): ...
    Ignore = ... # type: 'QGestureRecognizer.ResultFlag'
    MayBeGesture = ... # type: 'QGestureRecognizer.ResultFlag'
    TriggerGesture = ... # type: 'QGestureRecognizer.ResultFlag'
    FinishGesture = ... # type: 'QGestureRecognizer.ResultFlag'
    CancelGesture = ... # type: 'QGestureRecognizer.ResultFlag'
    ConsumeEventHint = ... # type: 'QGestureRecognizer.ResultFlag'

    class Result(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QGestureRecognizer.Result', 'QGestureRecognizer.ResultFlag']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QGestureRecognizer.Result') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QGestureRecognizer.Result': ...
        def __int__(self) -> int: ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QGestureRecognizer') -> None: ...

    @staticmethod
    def unregisterRecognizer(type: QtCore.Qt.GestureType) -> None: ...
    @staticmethod
    def registerRecognizer(recognizer: 'QGestureRecognizer') -> QtCore.Qt.GestureType: ...
    def reset(self, state: QGesture) -> None: ...
    def recognize(self, state: QGesture, watched: QtCore.QObject, event: QtCore.QEvent) -> 'QGestureRecognizer.Result': ...
    def create(self, target: QtCore.QObject) -> QGesture: ...


class QGlyphRun(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QGlyphRun') -> None: ...

    def strikeOut(self) -> bool: ...
    def setStrikeOut(self, strikeOut: bool) -> None: ...
    def underline(self) -> bool: ...
    def setUnderline(self, underline: bool) -> None: ...
    def overline(self) -> bool: ...
    def setOverline(self, overline: bool) -> None: ...
    def clear(self) -> None: ...
    def setPositions(self, positions: typing.List[typing.Union[QtCore.QPointF, QtCore.QPoint]]) -> None: ...
    def positions(self) -> typing.List[QtCore.QPointF]: ...
    def setGlyphIndexes(self, glyphIndexes: typing.List[int]) -> None: ...
    def glyphIndexes(self) -> typing.List[int]: ...
    def setRawFont(self, rawFont: 'QRawFont') -> None: ...
    def rawFont(self) -> 'QRawFont': ...


class QGraphicsAnchor(QtCore.QObject):

    def sizePolicy(self) -> 'QSizePolicy.Policy': ...
    def setSizePolicy(self, policy: 'QSizePolicy.Policy') -> None: ...
    def spacing(self) -> float: ...
    def unsetSpacing(self) -> None: ...
    def setSpacing(self, spacing: float) -> None: ...


class QGraphicsLayoutItem(sip.wrapper):

    def __init__(self, parent: typing.Optional['QGraphicsLayoutItem'] = ..., isLayout: bool = ...) -> None: ...

    def setOwnedByLayout(self, ownedByLayout: bool) -> None: ...
    def setGraphicsItem(self, item: 'QGraphicsItem') -> None: ...
    def sizeHint(self, which: QtCore.Qt.SizeHint, constraint: QtCore.QSizeF = ...) -> QtCore.QSizeF: ...
    def ownedByLayout(self) -> bool: ...
    def graphicsItem(self) -> 'QGraphicsItem': ...
    def maximumHeight(self) -> float: ...
    def maximumWidth(self) -> float: ...
    def preferredHeight(self) -> float: ...
    def preferredWidth(self) -> float: ...
    def minimumHeight(self) -> float: ...
    def minimumWidth(self) -> float: ...
    def isLayout(self) -> bool: ...
    def setParentLayoutItem(self, parent: 'QGraphicsLayoutItem') -> None: ...
    def parentLayoutItem(self) -> 'QGraphicsLayoutItem': ...
    def updateGeometry(self) -> None: ...
    def effectiveSizeHint(self, which: QtCore.Qt.SizeHint, constraint: QtCore.QSizeF = ...) -> QtCore.QSizeF: ...
    def contentsRect(self) -> QtCore.QRectF: ...
    def getContentsMargins(self) -> typing.Tuple[float, float, float, float]: ...
    def geometry(self) -> QtCore.QRectF: ...
    def setGeometry(self, rect: QtCore.QRectF) -> None: ...
    def setMaximumHeight(self, height: float) -> None: ...
    def setMaximumWidth(self, width: float) -> None: ...
    def maximumSize(self) -> QtCore.QSizeF: ...
    @typing.overload
    def setMaximumSize(self, size: QtCore.QSizeF) -> None: ...
    @typing.overload
    def setMaximumSize(self, aw: float, ah: float) -> None: ...
    def setPreferredHeight(self, height: float) -> None: ...
    def setPreferredWidth(self, width: float) -> None: ...
    def preferredSize(self) -> QtCore.QSizeF: ...
    @typing.overload
    def setPreferredSize(self, size: QtCore.QSizeF) -> None: ...
    @typing.overload
    def setPreferredSize(self, aw: float, ah: float) -> None: ...
    def setMinimumHeight(self, height: float) -> None: ...
    def setMinimumWidth(self, width: float) -> None: ...
    def minimumSize(self) -> QtCore.QSizeF: ...
    @typing.overload
    def setMinimumSize(self, size: QtCore.QSizeF) -> None: ...
    @typing.overload
    def setMinimumSize(self, aw: float, ah: float) -> None: ...
    def sizePolicy(self) -> 'QSizePolicy': ...
    @typing.overload
    def setSizePolicy(self, policy: 'QSizePolicy') -> None: ...
    @typing.overload
    def setSizePolicy(self, hPolicy: 'QSizePolicy.Policy', vPolicy: 'QSizePolicy.Policy', controlType: 'QSizePolicy.ControlType' = ...) -> None: ...


class QGraphicsLayout(QGraphicsLayoutItem):

    def __init__(self, parent: typing.Optional[QGraphicsLayoutItem] = ...) -> None: ...

    def addChildLayoutItem(self, layoutItem: QGraphicsLayoutItem) -> None: ...
    def updateGeometry(self) -> None: ...
    def removeAt(self, index: int) -> None: ...
    def itemAt(self, i: int) -> QGraphicsLayoutItem: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def widgetEvent(self, e: QtCore.QEvent) -> None: ...
    def invalidate(self) -> None: ...
    def isActivated(self) -> bool: ...
    def activate(self) -> None: ...
    def getContentsMargins(self) -> typing.Tuple[float, float, float, float]: ...
    def setContentsMargins(self, left: float, top: float, right: float, bottom: float) -> None: ...


class QGraphicsAnchorLayout(QGraphicsLayout):

    def __init__(self, parent: typing.Optional[QGraphicsLayoutItem] = ...) -> None: ...

    def sizeHint(self, which: QtCore.Qt.SizeHint, constraint: QtCore.QSizeF = ...) -> QtCore.QSizeF: ...
    def invalidate(self) -> None: ...
    def itemAt(self, index: int) -> QGraphicsLayoutItem: ...
    def count(self) -> int: ...
    def setGeometry(self, rect: QtCore.QRectF) -> None: ...
    def removeAt(self, index: int) -> None: ...
    def verticalSpacing(self) -> float: ...
    def horizontalSpacing(self) -> float: ...
    def setSpacing(self, spacing: float) -> None: ...
    def setVerticalSpacing(self, spacing: float) -> None: ...
    def setHorizontalSpacing(self, spacing: float) -> None: ...
    def addAnchors(self, firstItem: QGraphicsLayoutItem, secondItem: QGraphicsLayoutItem, orientations: typing.Union[QtCore.Qt.Orientations, QtCore.Qt.Orientation] = ...) -> None: ...
    def addCornerAnchors(self, firstItem: QGraphicsLayoutItem, firstCorner: QtCore.Qt.Corner, secondItem: QGraphicsLayoutItem, secondCorner: QtCore.Qt.Corner) -> None: ...
    def anchor(self, firstItem: QGraphicsLayoutItem, firstEdge: QtCore.Qt.AnchorPoint, secondItem: QGraphicsLayoutItem, secondEdge: QtCore.Qt.AnchorPoint) -> QGraphicsAnchor: ...
    def addAnchor(self, firstItem: QGraphicsLayoutItem, firstEdge: QtCore.Qt.AnchorPoint, secondItem: QGraphicsLayoutItem, secondEdge: QtCore.Qt.AnchorPoint) -> QGraphicsAnchor: ...


class QGraphicsEffect(QtCore.QObject):

    class PixmapPadMode(int): ...
    NoPad = ... # type: 'QGraphicsEffect.PixmapPadMode'
    PadToTransparentBorder = ... # type: 'QGraphicsEffect.PixmapPadMode'
    PadToEffectiveBoundingRect = ... # type: 'QGraphicsEffect.PixmapPadMode'

    class ChangeFlag(int): ...
    SourceAttached = ... # type: 'QGraphicsEffect.ChangeFlag'
    SourceDetached = ... # type: 'QGraphicsEffect.ChangeFlag'
    SourceBoundingRectChanged = ... # type: 'QGraphicsEffect.ChangeFlag'
    SourceInvalidated = ... # type: 'QGraphicsEffect.ChangeFlag'

    class ChangeFlags(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QGraphicsEffect.ChangeFlags', 'QGraphicsEffect.ChangeFlag']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QGraphicsEffect.ChangeFlags') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QGraphicsEffect.ChangeFlags': ...
        def __int__(self) -> int: ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def sourcePixmap(self, system: QtCore.Qt.CoordinateSystem = ..., mode: 'QGraphicsEffect.PixmapPadMode' = ...) -> typing.Tuple[QPixmap, QtCore.QPoint]: ...
    def drawSource(self, painter: 'QPainter') -> None: ...
    def sourceBoundingRect(self, system: QtCore.Qt.CoordinateSystem = ...) -> QtCore.QRectF: ...
    def sourceIsPixmap(self) -> bool: ...
    def updateBoundingRect(self) -> None: ...
    def sourceChanged(self, flags: 'QGraphicsEffect.ChangeFlags') -> None: ...
    def draw(self, painter: 'QPainter') -> None: ...
    def enabledChanged(self, enabled: bool) -> None: ...
    def update(self) -> None: ...
    def setEnabled(self, enable: bool) -> None: ...
    def isEnabled(self) -> bool: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def boundingRectFor(self, sourceRect: QtCore.QRectF) -> QtCore.QRectF: ...


class QGraphicsColorizeEffect(QGraphicsEffect):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def draw(self, painter: 'QPainter') -> None: ...
    def strengthChanged(self, strength: float) -> None: ...
    def colorChanged(self, color: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def setStrength(self, strength: float) -> None: ...
    def setColor(self, c: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def strength(self) -> float: ...
    def color(self) -> QColor: ...


class QGraphicsBlurEffect(QGraphicsEffect):

    class BlurHint(int): ...
    PerformanceHint = ... # type: 'QGraphicsBlurEffect.BlurHint'
    QualityHint = ... # type: 'QGraphicsBlurEffect.BlurHint'
    AnimationHint = ... # type: 'QGraphicsBlurEffect.BlurHint'

    class BlurHints(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QGraphicsBlurEffect.BlurHints', 'QGraphicsBlurEffect.BlurHint']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QGraphicsBlurEffect.BlurHints') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QGraphicsBlurEffect.BlurHints': ...
        def __int__(self) -> int: ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def draw(self, painter: 'QPainter') -> None: ...
    def blurHintsChanged(self, hints: 'QGraphicsBlurEffect.BlurHints') -> None: ...
    def blurRadiusChanged(self, blurRadius: float) -> None: ...
    def setBlurHints(self, hints: 'QGraphicsBlurEffect.BlurHints') -> None: ...
    def setBlurRadius(self, blurRadius: float) -> None: ...
    def blurHints(self) -> 'QGraphicsBlurEffect.BlurHints': ...
    def blurRadius(self) -> float: ...
    def boundingRectFor(self, rect: QtCore.QRectF) -> QtCore.QRectF: ...


class QGraphicsDropShadowEffect(QGraphicsEffect):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def draw(self, painter: 'QPainter') -> None: ...
    def colorChanged(self, color: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def blurRadiusChanged(self, blurRadius: float) -> None: ...
    def offsetChanged(self, offset: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def setColor(self, color: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def setBlurRadius(self, blurRadius: float) -> None: ...
    def setYOffset(self, dy: float) -> None: ...
    def setXOffset(self, dx: float) -> None: ...
    @typing.overload
    def setOffset(self, ofs: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @typing.overload
    def setOffset(self, dx: float, dy: float) -> None: ...
    @typing.overload
    def setOffset(self, d: float) -> None: ...
    def color(self) -> QColor: ...
    def blurRadius(self) -> float: ...
    def yOffset(self) -> float: ...
    def xOffset(self) -> float: ...
    def offset(self) -> QtCore.QPointF: ...
    def boundingRectFor(self, rect: QtCore.QRectF) -> QtCore.QRectF: ...


class QGraphicsOpacityEffect(QGraphicsEffect):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def draw(self, painter: 'QPainter') -> None: ...
    def opacityMaskChanged(self, mask: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def opacityChanged(self, opacity: float) -> None: ...
    def setOpacityMask(self, mask: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def setOpacity(self, opacity: float) -> None: ...
    def opacityMask(self) -> QBrush: ...
    def opacity(self) -> float: ...


class QGraphicsGridLayout(QGraphicsLayout):

    def __init__(self, parent: typing.Optional[QGraphicsLayoutItem] = ...) -> None: ...

    def removeItem(self, item: QGraphicsLayoutItem) -> None: ...
    def sizeHint(self, which: QtCore.Qt.SizeHint, constraint: QtCore.QSizeF = ...) -> QtCore.QSizeF: ...
    def setGeometry(self, rect: QtCore.QRectF) -> None: ...
    def invalidate(self) -> None: ...
    def removeAt(self, index: int) -> None: ...
    def count(self) -> int: ...
    @typing.overload
    def itemAt(self, row: int, column: int) -> QGraphicsLayoutItem: ...
    @typing.overload
    def itemAt(self, index: int) -> QGraphicsLayoutItem: ...
    def columnCount(self) -> int: ...
    def rowCount(self) -> int: ...
    def alignment(self, item: QGraphicsLayoutItem) -> QtCore.Qt.Alignment: ...
    def setAlignment(self, item: QGraphicsLayoutItem, alignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> None: ...
    def columnAlignment(self, column: int) -> QtCore.Qt.Alignment: ...
    def setColumnAlignment(self, column: int, alignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> None: ...
    def rowAlignment(self, row: int) -> QtCore.Qt.Alignment: ...
    def setRowAlignment(self, row: int, alignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> None: ...
    def setColumnFixedWidth(self, column: int, width: float) -> None: ...
    def columnMaximumWidth(self, column: int) -> float: ...
    def setColumnMaximumWidth(self, column: int, width: float) -> None: ...
    def columnPreferredWidth(self, column: int) -> float: ...
    def setColumnPreferredWidth(self, column: int, width: float) -> None: ...
    def columnMinimumWidth(self, column: int) -> float: ...
    def setColumnMinimumWidth(self, column: int, width: float) -> None: ...
    def setRowFixedHeight(self, row: int, height: float) -> None: ...
    def rowMaximumHeight(self, row: int) -> float: ...
    def setRowMaximumHeight(self, row: int, height: float) -> None: ...
    def rowPreferredHeight(self, row: int) -> float: ...
    def setRowPreferredHeight(self, row: int, height: float) -> None: ...
    def rowMinimumHeight(self, row: int) -> float: ...
    def setRowMinimumHeight(self, row: int, height: float) -> None: ...
    def columnStretchFactor(self, column: int) -> int: ...
    def setColumnStretchFactor(self, column: int, stretch: int) -> None: ...
    def rowStretchFactor(self, row: int) -> int: ...
    def setRowStretchFactor(self, row: int, stretch: int) -> None: ...
    def columnSpacing(self, column: int) -> float: ...
    def setColumnSpacing(self, column: int, spacing: float) -> None: ...
    def rowSpacing(self, row: int) -> float: ...
    def setRowSpacing(self, row: int, spacing: float) -> None: ...
    def setSpacing(self, spacing: float) -> None: ...
    def verticalSpacing(self) -> float: ...
    def setVerticalSpacing(self, spacing: float) -> None: ...
    def horizontalSpacing(self) -> float: ...
    def setHorizontalSpacing(self, spacing: float) -> None: ...
    @typing.overload
    def addItem(self, item: QGraphicsLayoutItem, row: int, column: int, rowSpan: int, columnSpan: int, alignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag] = ...) -> None: ...
    @typing.overload
    def addItem(self, aitem: QGraphicsLayoutItem, arow: int, acolumn: int, alignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag] = ...) -> None: ...


class QGraphicsItem(sip.wrapper):

    class PanelModality(int): ...
    NonModal = ... # type: 'QGraphicsItem.PanelModality'
    PanelModal = ... # type: 'QGraphicsItem.PanelModality'
    SceneModal = ... # type: 'QGraphicsItem.PanelModality'

    UserType = ... # type: int

    class GraphicsItemFlag(int): ...
    ItemIsMovable = ... # type: 'QGraphicsItem.GraphicsItemFlag'
    ItemIsSelectable = ... # type: 'QGraphicsItem.GraphicsItemFlag'
    ItemIsFocusable = ... # type: 'QGraphicsItem.GraphicsItemFlag'
    ItemClipsToShape = ... # type: 'QGraphicsItem.GraphicsItemFlag'
    ItemClipsChildrenToShape = ... # type: 'QGraphicsItem.GraphicsItemFlag'
    ItemIgnoresTransformations = ... # type: 'QGraphicsItem.GraphicsItemFlag'
    ItemIgnoresParentOpacity = ... # type: 'QGraphicsItem.GraphicsItemFlag'
    ItemDoesntPropagateOpacityToChildren = ... # type: 'QGraphicsItem.GraphicsItemFlag'
    ItemStacksBehindParent = ... # type: 'QGraphicsItem.GraphicsItemFlag'
    ItemUsesExtendedStyleOption = ... # type: 'QGraphicsItem.GraphicsItemFlag'
    ItemHasNoContents = ... # type: 'QGraphicsItem.GraphicsItemFlag'
    ItemSendsGeometryChanges = ... # type: 'QGraphicsItem.GraphicsItemFlag'
    ItemAcceptsInputMethod = ... # type: 'QGraphicsItem.GraphicsItemFlag'
    ItemNegativeZStacksBehindParent = ... # type: 'QGraphicsItem.GraphicsItemFlag'
    ItemIsPanel = ... # type: 'QGraphicsItem.GraphicsItemFlag'
    ItemSendsScenePositionChanges = ... # type: 'QGraphicsItem.GraphicsItemFlag'

    class GraphicsItemChange(int): ...
    ItemPositionChange = ... # type: 'QGraphicsItem.GraphicsItemChange'
    ItemMatrixChange = ... # type: 'QGraphicsItem.GraphicsItemChange'
    ItemVisibleChange = ... # type: 'QGraphicsItem.GraphicsItemChange'
    ItemEnabledChange = ... # type: 'QGraphicsItem.GraphicsItemChange'
    ItemSelectedChange = ... # type: 'QGraphicsItem.GraphicsItemChange'
    ItemParentChange = ... # type: 'QGraphicsItem.GraphicsItemChange'
    ItemChildAddedChange = ... # type: 'QGraphicsItem.GraphicsItemChange'
    ItemChildRemovedChange = ... # type: 'QGraphicsItem.GraphicsItemChange'
    ItemTransformChange = ... # type: 'QGraphicsItem.GraphicsItemChange'
    ItemPositionHasChanged = ... # type: 'QGraphicsItem.GraphicsItemChange'
    ItemTransformHasChanged = ... # type: 'QGraphicsItem.GraphicsItemChange'
    ItemSceneChange = ... # type: 'QGraphicsItem.GraphicsItemChange'
    ItemVisibleHasChanged = ... # type: 'QGraphicsItem.GraphicsItemChange'
    ItemEnabledHasChanged = ... # type: 'QGraphicsItem.GraphicsItemChange'
    ItemSelectedHasChanged = ... # type: 'QGraphicsItem.GraphicsItemChange'
    ItemParentHasChanged = ... # type: 'QGraphicsItem.GraphicsItemChange'
    ItemSceneHasChanged = ... # type: 'QGraphicsItem.GraphicsItemChange'
    ItemCursorChange = ... # type: 'QGraphicsItem.GraphicsItemChange'
    ItemCursorHasChanged = ... # type: 'QGraphicsItem.GraphicsItemChange'
    ItemToolTipChange = ... # type: 'QGraphicsItem.GraphicsItemChange'
    ItemToolTipHasChanged = ... # type: 'QGraphicsItem.GraphicsItemChange'
    ItemFlagsChange = ... # type: 'QGraphicsItem.GraphicsItemChange'
    ItemFlagsHaveChanged = ... # type: 'QGraphicsItem.GraphicsItemChange'
    ItemZValueChange = ... # type: 'QGraphicsItem.GraphicsItemChange'
    ItemZValueHasChanged = ... # type: 'QGraphicsItem.GraphicsItemChange'
    ItemOpacityChange = ... # type: 'QGraphicsItem.GraphicsItemChange'
    ItemOpacityHasChanged = ... # type: 'QGraphicsItem.GraphicsItemChange'
    ItemScenePositionHasChanged = ... # type: 'QGraphicsItem.GraphicsItemChange'
    ItemRotationChange = ... # type: 'QGraphicsItem.GraphicsItemChange'
    ItemRotationHasChanged = ... # type: 'QGraphicsItem.GraphicsItemChange'
    ItemScaleChange = ... # type: 'QGraphicsItem.GraphicsItemChange'
    ItemScaleHasChanged = ... # type: 'QGraphicsItem.GraphicsItemChange'
    ItemTransformOriginPointChange = ... # type: 'QGraphicsItem.GraphicsItemChange'
    ItemTransformOriginPointHasChanged = ... # type: 'QGraphicsItem.GraphicsItemChange'

    class CacheMode(int): ...
    NoCache = ... # type: 'QGraphicsItem.CacheMode'
    ItemCoordinateCache = ... # type: 'QGraphicsItem.CacheMode'
    DeviceCoordinateCache = ... # type: 'QGraphicsItem.CacheMode'

    class GraphicsItemFlags(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QGraphicsItem.GraphicsItemFlags', 'QGraphicsItem.GraphicsItemFlag']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QGraphicsItem.GraphicsItemFlags') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QGraphicsItem.GraphicsItemFlags': ...
        def __int__(self) -> int: ...

    def __init__(self, parent: typing.Optional['QGraphicsItem'] = ..., scene: typing.Optional['QGraphicsScene'] = ...) -> None: ...

    def updateMicroFocus(self) -> None: ...
    def setInputMethodHints(self, hints: typing.Union[QtCore.Qt.InputMethodHints, QtCore.Qt.InputMethodHint]) -> None: ...
    def inputMethodHints(self) -> QtCore.Qt.InputMethodHints: ...
    def stackBefore(self, sibling: 'QGraphicsItem') -> None: ...
    @typing.overload
    def setTransformOriginPoint(self, origin: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @typing.overload
    def setTransformOriginPoint(self, ax: float, ay: float) -> None: ...
    def transformOriginPoint(self) -> QtCore.QPointF: ...
    def setTransformations(self, transformations: typing.Sequence['QGraphicsTransform']) -> None: ...
    def transformations(self) -> typing.List['QGraphicsTransform']: ...
    def setScale(self, scale: float) -> None: ...
    def rotation(self) -> float: ...
    def setRotation(self, angle: float) -> None: ...
    def setY(self, y: float) -> None: ...
    def setX(self, x: float) -> None: ...
    def focusItem(self) -> 'QGraphicsItem': ...
    def setFocusProxy(self, item: 'QGraphicsItem') -> None: ...
    def focusProxy(self) -> 'QGraphicsItem': ...
    def setActive(self, active: bool) -> None: ...
    def isActive(self) -> bool: ...
    def setFiltersChildEvents(self, enabled: bool) -> None: ...
    def filtersChildEvents(self) -> bool: ...
    def setAcceptTouchEvents(self, enabled: bool) -> None: ...
    def acceptTouchEvents(self) -> bool: ...
    def setGraphicsEffect(self, effect: QGraphicsEffect) -> None: ...
    def graphicsEffect(self) -> QGraphicsEffect: ...
    def isBlockedByModalPanel(self) -> typing.Tuple[bool, 'QGraphicsItem']: ...
    def setPanelModality(self, panelModality: 'QGraphicsItem.PanelModality') -> None: ...
    def panelModality(self) -> 'QGraphicsItem.PanelModality': ...
    def toGraphicsObject(self) -> 'QGraphicsObject': ...
    def isPanel(self) -> bool: ...
    def panel(self) -> 'QGraphicsItem': ...
    def parentObject(self) -> 'QGraphicsObject': ...
    @typing.overload
    def mapRectFromScene(self, rect: QtCore.QRectF) -> QtCore.QRectF: ...
    @typing.overload
    def mapRectFromScene(self, ax: float, ay: float, w: float, h: float) -> QtCore.QRectF: ...
    @typing.overload
    def mapRectFromParent(self, rect: QtCore.QRectF) -> QtCore.QRectF: ...
    @typing.overload
    def mapRectFromParent(self, ax: float, ay: float, w: float, h: float) -> QtCore.QRectF: ...
    @typing.overload
    def mapRectFromItem(self, item: 'QGraphicsItem', rect: QtCore.QRectF) -> QtCore.QRectF: ...
    @typing.overload
    def mapRectFromItem(self, item: 'QGraphicsItem', ax: float, ay: float, w: float, h: float) -> QtCore.QRectF: ...
    @typing.overload
    def mapRectToScene(self, rect: QtCore.QRectF) -> QtCore.QRectF: ...
    @typing.overload
    def mapRectToScene(self, ax: float, ay: float, w: float, h: float) -> QtCore.QRectF: ...
    @typing.overload
    def mapRectToParent(self, rect: QtCore.QRectF) -> QtCore.QRectF: ...
    @typing.overload
    def mapRectToParent(self, ax: float, ay: float, w: float, h: float) -> QtCore.QRectF: ...
    @typing.overload
    def mapRectToItem(self, item: 'QGraphicsItem', rect: QtCore.QRectF) -> QtCore.QRectF: ...
    @typing.overload
    def mapRectToItem(self, item: 'QGraphicsItem', ax: float, ay: float, w: float, h: float) -> QtCore.QRectF: ...
    def clipPath(self) -> 'QPainterPath': ...
    def isClipped(self) -> bool: ...
    def itemTransform(self, other: 'QGraphicsItem') -> typing.Tuple['QTransform', bool]: ...
    def setOpacity(self, opacity: float) -> None: ...
    def effectiveOpacity(self) -> float: ...
    def opacity(self) -> float: ...
    def isUnderMouse(self) -> bool: ...
    def commonAncestorItem(self, other: 'QGraphicsItem') -> 'QGraphicsItem': ...
    def scroll(self, dx: float, dy: float, rect: QtCore.QRectF = ...) -> None: ...
    def setBoundingRegionGranularity(self, granularity: float) -> None: ...
    def boundingRegionGranularity(self) -> float: ...
    def boundingRegion(self, itemToDeviceTransform: 'QTransform') -> 'QRegion': ...
    def ungrabKeyboard(self) -> None: ...
    def grabKeyboard(self) -> None: ...
    def ungrabMouse(self) -> None: ...
    def grabMouse(self) -> None: ...
    def setAcceptHoverEvents(self, enabled: bool) -> None: ...
    def acceptHoverEvents(self) -> bool: ...
    def isVisibleTo(self, parent: 'QGraphicsItem') -> bool: ...
    def setCacheMode(self, mode: 'QGraphicsItem.CacheMode', logicalCacheSize: QtCore.QSize = ...) -> None: ...
    def cacheMode(self) -> 'QGraphicsItem.CacheMode': ...
    def isWindow(self) -> bool: ...
    def isWidget(self) -> bool: ...
    def childItems(self) -> typing.List['QGraphicsItem']: ...
    def window(self) -> 'QGraphicsWidget': ...
    def topLevelWidget(self) -> 'QGraphicsWidget': ...
    def parentWidget(self) -> 'QGraphicsWidget': ...
    @typing.overload
    def isObscured(self) -> bool: ...
    @typing.overload
    def isObscured(self, rect: QtCore.QRectF) -> bool: ...
    @typing.overload
    def isObscured(self, ax: float, ay: float, w: float, h: float) -> bool: ...
    def resetTransform(self) -> None: ...
    def setTransform(self, matrix: 'QTransform', combine: bool = ...) -> None: ...
    def deviceTransform(self, viewportTransform: 'QTransform') -> 'QTransform': ...
    def sceneTransform(self) -> 'QTransform': ...
    def transform(self) -> 'QTransform': ...
    def wheelEvent(self, event: 'QGraphicsSceneWheelEvent') -> None: ...
    def sceneEventFilter(self, watched: 'QGraphicsItem', event: QtCore.QEvent) -> bool: ...
    def sceneEvent(self, event: QtCore.QEvent) -> bool: ...
    def prepareGeometryChange(self) -> None: ...
    def mouseReleaseEvent(self, event: 'QGraphicsSceneMouseEvent') -> None: ...
    def mousePressEvent(self, event: 'QGraphicsSceneMouseEvent') -> None: ...
    def mouseMoveEvent(self, event: 'QGraphicsSceneMouseEvent') -> None: ...
    def mouseDoubleClickEvent(self, event: 'QGraphicsSceneMouseEvent') -> None: ...
    def keyReleaseEvent(self, event: QKeyEvent) -> None: ...
    def keyPressEvent(self, event: QKeyEvent) -> None: ...
    def itemChange(self, change: 'QGraphicsItem.GraphicsItemChange', value: typing.Any) -> typing.Any: ...
    def inputMethodQuery(self, query: QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def inputMethodEvent(self, event: QInputMethodEvent) -> None: ...
    def hoverMoveEvent(self, event: 'QGraphicsSceneHoverEvent') -> None: ...
    def hoverLeaveEvent(self, event: 'QGraphicsSceneHoverEvent') -> None: ...
    def hoverEnterEvent(self, event: 'QGraphicsSceneHoverEvent') -> None: ...
    def focusOutEvent(self, event: QFocusEvent) -> None: ...
    def focusInEvent(self, event: QFocusEvent) -> None: ...
    def dropEvent(self, event: 'QGraphicsSceneDragDropEvent') -> None: ...
    def dragMoveEvent(self, event: 'QGraphicsSceneDragDropEvent') -> None: ...
    def dragLeaveEvent(self, event: 'QGraphicsSceneDragDropEvent') -> None: ...
    def dragEnterEvent(self, event: 'QGraphicsSceneDragDropEvent') -> None: ...
    def contextMenuEvent(self, event: 'QGraphicsSceneContextMenuEvent') -> None: ...
    def removeSceneEventFilter(self, filterItem: 'QGraphicsItem') -> None: ...
    def installSceneEventFilter(self, filterItem: 'QGraphicsItem') -> None: ...
    def type(self) -> int: ...
    def setData(self, key: int, value: typing.Any) -> None: ...
    def data(self, key: int) -> typing.Any: ...
    def isAncestorOf(self, child: 'QGraphicsItem') -> bool: ...
    @typing.overload
    def mapFromScene(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> QtCore.QPointF: ...
    @typing.overload
    def mapFromScene(self, rect: QtCore.QRectF) -> 'QPolygonF': ...
    @typing.overload
    def mapFromScene(self, polygon: 'QPolygonF') -> 'QPolygonF': ...
    @typing.overload
    def mapFromScene(self, path: 'QPainterPath') -> 'QPainterPath': ...
    @typing.overload
    def mapFromScene(self, ax: float, ay: float) -> QtCore.QPointF: ...
    @typing.overload
    def mapFromScene(self, ax: float, ay: float, w: float, h: float) -> 'QPolygonF': ...
    @typing.overload
    def mapFromParent(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> QtCore.QPointF: ...
    @typing.overload
    def mapFromParent(self, rect: QtCore.QRectF) -> 'QPolygonF': ...
    @typing.overload
    def mapFromParent(self, polygon: 'QPolygonF') -> 'QPolygonF': ...
    @typing.overload
    def mapFromParent(self, path: 'QPainterPath') -> 'QPainterPath': ...
    @typing.overload
    def mapFromParent(self, ax: float, ay: float) -> QtCore.QPointF: ...
    @typing.overload
    def mapFromParent(self, ax: float, ay: float, w: float, h: float) -> 'QPolygonF': ...
    @typing.overload
    def mapFromItem(self, item: 'QGraphicsItem', point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> QtCore.QPointF: ...
    @typing.overload
    def mapFromItem(self, item: 'QGraphicsItem', rect: QtCore.QRectF) -> 'QPolygonF': ...
    @typing.overload
    def mapFromItem(self, item: 'QGraphicsItem', polygon: 'QPolygonF') -> 'QPolygonF': ...
    @typing.overload
    def mapFromItem(self, item: 'QGraphicsItem', path: 'QPainterPath') -> 'QPainterPath': ...
    @typing.overload
    def mapFromItem(self, item: 'QGraphicsItem', ax: float, ay: float) -> QtCore.QPointF: ...
    @typing.overload
    def mapFromItem(self, item: 'QGraphicsItem', ax: float, ay: float, w: float, h: float) -> 'QPolygonF': ...
    @typing.overload
    def mapToScene(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> QtCore.QPointF: ...
    @typing.overload
    def mapToScene(self, rect: QtCore.QRectF) -> 'QPolygonF': ...
    @typing.overload
    def mapToScene(self, polygon: 'QPolygonF') -> 'QPolygonF': ...
    @typing.overload
    def mapToScene(self, path: 'QPainterPath') -> 'QPainterPath': ...
    @typing.overload
    def mapToScene(self, ax: float, ay: float) -> QtCore.QPointF: ...
    @typing.overload
    def mapToScene(self, ax: float, ay: float, w: float, h: float) -> 'QPolygonF': ...
    @typing.overload
    def mapToParent(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> QtCore.QPointF: ...
    @typing.overload
    def mapToParent(self, rect: QtCore.QRectF) -> 'QPolygonF': ...
    @typing.overload
    def mapToParent(self, polygon: 'QPolygonF') -> 'QPolygonF': ...
    @typing.overload
    def mapToParent(self, path: 'QPainterPath') -> 'QPainterPath': ...
    @typing.overload
    def mapToParent(self, ax: float, ay: float) -> QtCore.QPointF: ...
    @typing.overload
    def mapToParent(self, ax: float, ay: float, w: float, h: float) -> 'QPolygonF': ...
    @typing.overload
    def mapToItem(self, item: 'QGraphicsItem', point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> QtCore.QPointF: ...
    @typing.overload
    def mapToItem(self, item: 'QGraphicsItem', rect: QtCore.QRectF) -> 'QPolygonF': ...
    @typing.overload
    def mapToItem(self, item: 'QGraphicsItem', polygon: 'QPolygonF') -> 'QPolygonF': ...
    @typing.overload
    def mapToItem(self, item: 'QGraphicsItem', path: 'QPainterPath') -> 'QPainterPath': ...
    @typing.overload
    def mapToItem(self, item: 'QGraphicsItem', ax: float, ay: float) -> QtCore.QPointF: ...
    @typing.overload
    def mapToItem(self, item: 'QGraphicsItem', ax: float, ay: float, w: float, h: float) -> 'QPolygonF': ...
    @typing.overload
    def update(self, rect: QtCore.QRectF = ...) -> None: ...
    @typing.overload
    def update(self, ax: float, ay: float, width: float, height: float) -> None: ...
    def paint(self, painter: 'QPainter', option: 'QStyleOptionGraphicsItem', widget: typing.Optional[QWidget] = ...) -> None: ...
    def opaqueArea(self) -> 'QPainterPath': ...
    def isObscuredBy(self, item: 'QGraphicsItem') -> bool: ...
    def collidingItems(self, mode: QtCore.Qt.ItemSelectionMode = ...) -> typing.List['QGraphicsItem']: ...
    def collidesWithPath(self, path: 'QPainterPath', mode: QtCore.Qt.ItemSelectionMode = ...) -> bool: ...
    def collidesWithItem(self, other: 'QGraphicsItem', mode: QtCore.Qt.ItemSelectionMode = ...) -> bool: ...
    def contains(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> bool: ...
    def shape(self) -> 'QPainterPath': ...
    def sceneBoundingRect(self) -> QtCore.QRectF: ...
    def childrenBoundingRect(self) -> QtCore.QRectF: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def setZValue(self, z: float) -> None: ...
    def zValue(self) -> float: ...
    def advance(self, phase: int) -> None: ...
    def translate(self, dx: float, dy: float) -> None: ...
    def shear(self, sh: float, sv: float) -> None: ...
    @typing.overload
    def scale(self, sx: float, sy: float) -> None: ...
    @typing.overload
    def scale(self) -> float: ...
    def rotate(self, angle: float) -> None: ...
    def resetMatrix(self) -> None: ...
    def setMatrix(self, matrix: 'QMatrix', combine: bool = ...) -> None: ...
    def sceneMatrix(self) -> 'QMatrix': ...
    def matrix(self) -> 'QMatrix': ...
    @typing.overload
    def ensureVisible(self, rect: QtCore.QRectF = ..., xMargin: int = ..., yMargin: int = ...) -> None: ...
    @typing.overload
    def ensureVisible(self, x: float, y: float, w: float, h: float, xMargin: int = ..., yMargin: int = ...) -> None: ...
    def moveBy(self, dx: float, dy: float) -> None: ...
    @typing.overload
    def setPos(self, pos: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @typing.overload
    def setPos(self, ax: float, ay: float) -> None: ...
    def scenePos(self) -> QtCore.QPointF: ...
    def y(self) -> float: ...
    def x(self) -> float: ...
    def pos(self) -> QtCore.QPointF: ...
    def clearFocus(self) -> None: ...
    def setFocus(self, focusReason: QtCore.Qt.FocusReason = ...) -> None: ...
    def hasFocus(self) -> bool: ...
    def setHandlesChildEvents(self, enabled: bool) -> None: ...
    def handlesChildEvents(self) -> bool: ...
    def setAcceptsHoverEvents(self, enabled: bool) -> None: ...
    def acceptsHoverEvents(self) -> bool: ...
    def setAcceptedMouseButtons(self, buttons: typing.Union[QtCore.Qt.MouseButtons, QtCore.Qt.MouseButton]) -> None: ...
    def acceptedMouseButtons(self) -> QtCore.Qt.MouseButtons: ...
    def setAcceptDrops(self, on: bool) -> None: ...
    def acceptDrops(self) -> bool: ...
    def setSelected(self, selected: bool) -> None: ...
    def isSelected(self) -> bool: ...
    def setEnabled(self, enabled: bool) -> None: ...
    def isEnabled(self) -> bool: ...
    def show(self) -> None: ...
    def hide(self) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def isVisible(self) -> bool: ...
    def unsetCursor(self) -> None: ...
    def hasCursor(self) -> bool: ...
    def setCursor(self, cursor: typing.Union[QCursor, QtCore.Qt.CursorShape]) -> None: ...
    def cursor(self) -> QCursor: ...
    def setToolTip(self, toolTip: str) -> None: ...
    def toolTip(self) -> str: ...
    def setFlags(self, flags: 'QGraphicsItem.GraphicsItemFlags') -> None: ...
    def setFlag(self, flag: 'QGraphicsItem.GraphicsItemFlag', enabled: bool = ...) -> None: ...
    def flags(self) -> 'QGraphicsItem.GraphicsItemFlags': ...
    def setGroup(self, group: 'QGraphicsItemGroup') -> None: ...
    def group(self) -> 'QGraphicsItemGroup': ...
    def setParentItem(self, parent: 'QGraphicsItem') -> None: ...
    def topLevelItem(self) -> 'QGraphicsItem': ...
    def parentItem(self) -> 'QGraphicsItem': ...
    def scene(self) -> 'QGraphicsScene': ...


class QAbstractGraphicsShapeItem(QGraphicsItem):

    def __init__(self, parent: typing.Optional[QGraphicsItem] = ..., scene: typing.Optional['QGraphicsScene'] = ...) -> None: ...

    def opaqueArea(self) -> 'QPainterPath': ...
    def isObscuredBy(self, item: QGraphicsItem) -> bool: ...
    def setBrush(self, brush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def brush(self) -> QBrush: ...
    def setPen(self, pen: typing.Union['QPen', QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def pen(self) -> 'QPen': ...


class QGraphicsPathItem(QAbstractGraphicsShapeItem):

    @typing.overload
    def __init__(self, parent: typing.Optional[QGraphicsItem] = ..., scene: typing.Optional['QGraphicsScene'] = ...) -> None: ...
    @typing.overload
    def __init__(self, path: 'QPainterPath', parent: typing.Optional[QGraphicsItem] = ..., scene: typing.Optional['QGraphicsScene'] = ...) -> None: ...

    def type(self) -> int: ...
    def opaqueArea(self) -> 'QPainterPath': ...
    def isObscuredBy(self, item: QGraphicsItem) -> bool: ...
    def paint(self, painter: 'QPainter', option: 'QStyleOptionGraphicsItem', widget: typing.Optional[QWidget] = ...) -> None: ...
    def contains(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> bool: ...
    def shape(self) -> 'QPainterPath': ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def setPath(self, path: 'QPainterPath') -> None: ...
    def path(self) -> 'QPainterPath': ...


class QGraphicsRectItem(QAbstractGraphicsShapeItem):

    @typing.overload
    def __init__(self, parent: typing.Optional[QGraphicsItem] = ..., scene: typing.Optional['QGraphicsScene'] = ...) -> None: ...
    @typing.overload
    def __init__(self, rect: QtCore.QRectF, parent: typing.Optional[QGraphicsItem] = ..., scene: typing.Optional['QGraphicsScene'] = ...) -> None: ...
    @typing.overload
    def __init__(self, x: float, y: float, w: float, h: float, parent: typing.Optional[QGraphicsItem] = ..., scene: typing.Optional['QGraphicsScene'] = ...) -> None: ...

    def type(self) -> int: ...
    def opaqueArea(self) -> 'QPainterPath': ...
    def isObscuredBy(self, item: QGraphicsItem) -> bool: ...
    def paint(self, painter: 'QPainter', option: 'QStyleOptionGraphicsItem', widget: typing.Optional[QWidget] = ...) -> None: ...
    def contains(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> bool: ...
    def shape(self) -> 'QPainterPath': ...
    def boundingRect(self) -> QtCore.QRectF: ...
    @typing.overload
    def setRect(self, rect: QtCore.QRectF) -> None: ...
    @typing.overload
    def setRect(self, ax: float, ay: float, w: float, h: float) -> None: ...
    def rect(self) -> QtCore.QRectF: ...


class QGraphicsEllipseItem(QAbstractGraphicsShapeItem):

    @typing.overload
    def __init__(self, parent: typing.Optional[QGraphicsItem] = ..., scene: typing.Optional['QGraphicsScene'] = ...) -> None: ...
    @typing.overload
    def __init__(self, rect: QtCore.QRectF, parent: typing.Optional[QGraphicsItem] = ..., scene: typing.Optional['QGraphicsScene'] = ...) -> None: ...
    @typing.overload
    def __init__(self, x: float, y: float, w: float, h: float, parent: typing.Optional[QGraphicsItem] = ..., scene: typing.Optional['QGraphicsScene'] = ...) -> None: ...

    def type(self) -> int: ...
    def opaqueArea(self) -> 'QPainterPath': ...
    def isObscuredBy(self, item: QGraphicsItem) -> bool: ...
    def paint(self, painter: 'QPainter', option: 'QStyleOptionGraphicsItem', widget: typing.Optional[QWidget] = ...) -> None: ...
    def contains(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> bool: ...
    def shape(self) -> 'QPainterPath': ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def setSpanAngle(self, angle: int) -> None: ...
    def spanAngle(self) -> int: ...
    def setStartAngle(self, angle: int) -> None: ...
    def startAngle(self) -> int: ...
    @typing.overload
    def setRect(self, rect: QtCore.QRectF) -> None: ...
    @typing.overload
    def setRect(self, ax: float, ay: float, w: float, h: float) -> None: ...
    def rect(self) -> QtCore.QRectF: ...


class QGraphicsPolygonItem(QAbstractGraphicsShapeItem):

    @typing.overload
    def __init__(self, parent: typing.Optional[QGraphicsItem] = ..., scene: typing.Optional['QGraphicsScene'] = ...) -> None: ...
    @typing.overload
    def __init__(self, polygon: 'QPolygonF', parent: typing.Optional[QGraphicsItem] = ..., scene: typing.Optional['QGraphicsScene'] = ...) -> None: ...

    def type(self) -> int: ...
    def opaqueArea(self) -> 'QPainterPath': ...
    def isObscuredBy(self, item: QGraphicsItem) -> bool: ...
    def paint(self, painter: 'QPainter', option: 'QStyleOptionGraphicsItem', widget: typing.Optional[QWidget] = ...) -> None: ...
    def contains(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> bool: ...
    def shape(self) -> 'QPainterPath': ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def setFillRule(self, rule: QtCore.Qt.FillRule) -> None: ...
    def fillRule(self) -> QtCore.Qt.FillRule: ...
    def setPolygon(self, polygon: 'QPolygonF') -> None: ...
    def polygon(self) -> 'QPolygonF': ...


class QGraphicsLineItem(QGraphicsItem):

    @typing.overload
    def __init__(self, parent: typing.Optional[QGraphicsItem] = ..., scene: typing.Optional['QGraphicsScene'] = ...) -> None: ...
    @typing.overload
    def __init__(self, line: QtCore.QLineF, parent: typing.Optional[QGraphicsItem] = ..., scene: typing.Optional['QGraphicsScene'] = ...) -> None: ...
    @typing.overload
    def __init__(self, x1: float, y1: float, x2: float, y2: float, parent: typing.Optional[QGraphicsItem] = ..., scene: typing.Optional['QGraphicsScene'] = ...) -> None: ...

    def type(self) -> int: ...
    def opaqueArea(self) -> 'QPainterPath': ...
    def isObscuredBy(self, item: QGraphicsItem) -> bool: ...
    def paint(self, painter: 'QPainter', option: 'QStyleOptionGraphicsItem', widget: typing.Optional[QWidget] = ...) -> None: ...
    def contains(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> bool: ...
    def shape(self) -> 'QPainterPath': ...
    def boundingRect(self) -> QtCore.QRectF: ...
    @typing.overload
    def setLine(self, line: QtCore.QLineF) -> None: ...
    @typing.overload
    def setLine(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    def line(self) -> QtCore.QLineF: ...
    def setPen(self, pen: typing.Union['QPen', QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def pen(self) -> 'QPen': ...


class QGraphicsPixmapItem(QGraphicsItem):

    class ShapeMode(int): ...
    MaskShape = ... # type: 'QGraphicsPixmapItem.ShapeMode'
    BoundingRectShape = ... # type: 'QGraphicsPixmapItem.ShapeMode'
    HeuristicMaskShape = ... # type: 'QGraphicsPixmapItem.ShapeMode'

    @typing.overload
    def __init__(self, parent: typing.Optional[QGraphicsItem] = ..., scene: typing.Optional['QGraphicsScene'] = ...) -> None: ...
    @typing.overload
    def __init__(self, pixmap: QPixmap, parent: typing.Optional[QGraphicsItem] = ..., scene: typing.Optional['QGraphicsScene'] = ...) -> None: ...

    def setShapeMode(self, mode: 'QGraphicsPixmapItem.ShapeMode') -> None: ...
    def shapeMode(self) -> 'QGraphicsPixmapItem.ShapeMode': ...
    def type(self) -> int: ...
    def opaqueArea(self) -> 'QPainterPath': ...
    def isObscuredBy(self, item: QGraphicsItem) -> bool: ...
    def paint(self, painter: 'QPainter', option: 'QStyleOptionGraphicsItem', widget: QWidget) -> None: ...
    def contains(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> bool: ...
    def shape(self) -> 'QPainterPath': ...
    def boundingRect(self) -> QtCore.QRectF: ...
    @typing.overload
    def setOffset(self, offset: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @typing.overload
    def setOffset(self, ax: float, ay: float) -> None: ...
    def offset(self) -> QtCore.QPointF: ...
    def setTransformationMode(self, mode: QtCore.Qt.TransformationMode) -> None: ...
    def transformationMode(self) -> QtCore.Qt.TransformationMode: ...
    def setPixmap(self, pixmap: QPixmap) -> None: ...
    def pixmap(self) -> QPixmap: ...


class QGraphicsSimpleTextItem(QAbstractGraphicsShapeItem):

    @typing.overload
    def __init__(self, parent: typing.Optional[QGraphicsItem] = ..., scene: typing.Optional['QGraphicsScene'] = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str, parent: typing.Optional[QGraphicsItem] = ..., scene: typing.Optional['QGraphicsScene'] = ...) -> None: ...

    def type(self) -> int: ...
    def opaqueArea(self) -> 'QPainterPath': ...
    def isObscuredBy(self, item: QGraphicsItem) -> bool: ...
    def paint(self, painter: 'QPainter', option: 'QStyleOptionGraphicsItem', widget: QWidget) -> None: ...
    def contains(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> bool: ...
    def shape(self) -> 'QPainterPath': ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def font(self) -> QFont: ...
    def setFont(self, font: QFont) -> None: ...
    def text(self) -> str: ...
    def setText(self, text: str) -> None: ...


class QGraphicsItemGroup(QGraphicsItem):

    def __init__(self, parent: typing.Optional[QGraphicsItem] = ..., scene: typing.Optional['QGraphicsScene'] = ...) -> None: ...

    def type(self) -> int: ...
    def opaqueArea(self) -> 'QPainterPath': ...
    def isObscuredBy(self, item: QGraphicsItem) -> bool: ...
    def paint(self, painter: 'QPainter', option: 'QStyleOptionGraphicsItem', widget: typing.Optional[QWidget] = ...) -> None: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def removeFromGroup(self, item: QGraphicsItem) -> None: ...
    def addToGroup(self, item: QGraphicsItem) -> None: ...


class QGraphicsObject(QtCore.QObject, QGraphicsItem):

    def __init__(self, parent: typing.Optional[QGraphicsItem] = ...) -> None: ...

    def updateMicroFocus(self) -> None: ...
    def scaleChanged(self) -> None: ...
    def rotationChanged(self) -> None: ...
    def zChanged(self) -> None: ...
    def yChanged(self) -> None: ...
    def xChanged(self) -> None: ...
    def enabledChanged(self) -> None: ...
    def visibleChanged(self) -> None: ...
    def opacityChanged(self) -> None: ...
    def parentChanged(self) -> None: ...
    def ungrabGesture(self, type: QtCore.Qt.GestureType) -> None: ...
    def grabGesture(self, type: QtCore.Qt.GestureType, flags: typing.Union[QtCore.Qt.GestureFlags, QtCore.Qt.GestureFlag] = ...) -> None: ...


class QGraphicsTextItem(QGraphicsObject):

    @typing.overload
    def __init__(self, parent: typing.Optional[QGraphicsItem] = ..., scene: typing.Optional['QGraphicsScene'] = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str, parent: typing.Optional[QGraphicsItem] = ..., scene: typing.Optional['QGraphicsScene'] = ...) -> None: ...

    def inputMethodQuery(self, query: QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def hoverLeaveEvent(self, event: 'QGraphicsSceneHoverEvent') -> None: ...
    def hoverMoveEvent(self, event: 'QGraphicsSceneHoverEvent') -> None: ...
    def hoverEnterEvent(self, event: 'QGraphicsSceneHoverEvent') -> None: ...
    def inputMethodEvent(self, event: QInputMethodEvent) -> None: ...
    def dropEvent(self, event: 'QGraphicsSceneDragDropEvent') -> None: ...
    def dragMoveEvent(self, event: 'QGraphicsSceneDragDropEvent') -> None: ...
    def dragLeaveEvent(self, event: 'QGraphicsSceneDragDropEvent') -> None: ...
    def dragEnterEvent(self, event: 'QGraphicsSceneDragDropEvent') -> None: ...
    def focusOutEvent(self, event: QFocusEvent) -> None: ...
    def focusInEvent(self, event: QFocusEvent) -> None: ...
    def keyReleaseEvent(self, event: QKeyEvent) -> None: ...
    def keyPressEvent(self, event: QKeyEvent) -> None: ...
    def contextMenuEvent(self, event: 'QGraphicsSceneContextMenuEvent') -> None: ...
    def mouseDoubleClickEvent(self, event: 'QGraphicsSceneMouseEvent') -> None: ...
    def mouseReleaseEvent(self, event: 'QGraphicsSceneMouseEvent') -> None: ...
    def mouseMoveEvent(self, event: 'QGraphicsSceneMouseEvent') -> None: ...
    def mousePressEvent(self, event: 'QGraphicsSceneMouseEvent') -> None: ...
    def sceneEvent(self, event: QtCore.QEvent) -> bool: ...
    def linkHovered(self, a0: str) -> None: ...
    def linkActivated(self, a0: str) -> None: ...
    def textCursor(self) -> 'QTextCursor': ...
    def setTextCursor(self, cursor: 'QTextCursor') -> None: ...
    def openExternalLinks(self) -> bool: ...
    def setOpenExternalLinks(self, open: bool) -> None: ...
    def tabChangesFocus(self) -> bool: ...
    def setTabChangesFocus(self, b: bool) -> None: ...
    def textInteractionFlags(self) -> QtCore.Qt.TextInteractionFlags: ...
    def setTextInteractionFlags(self, flags: typing.Union[QtCore.Qt.TextInteractionFlags, QtCore.Qt.TextInteractionFlag]) -> None: ...
    def document(self) -> 'QTextDocument': ...
    def setDocument(self, document: 'QTextDocument') -> None: ...
    def adjustSize(self) -> None: ...
    def textWidth(self) -> float: ...
    def setTextWidth(self, width: float) -> None: ...
    def type(self) -> int: ...
    def opaqueArea(self) -> 'QPainterPath': ...
    def isObscuredBy(self, item: QGraphicsItem) -> bool: ...
    def paint(self, painter: 'QPainter', option: 'QStyleOptionGraphicsItem', widget: QWidget) -> None: ...
    def contains(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> bool: ...
    def shape(self) -> 'QPainterPath': ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def defaultTextColor(self) -> QColor: ...
    def setDefaultTextColor(self, c: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def setFont(self, font: QFont) -> None: ...
    def font(self) -> QFont: ...
    def setPlainText(self, text: str) -> None: ...
    def toPlainText(self) -> str: ...
    def setHtml(self, html: str) -> None: ...
    def toHtml(self) -> str: ...


class QGraphicsItemAnimation(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def shearList(self) -> typing.List[typing.Tuple[float, QtCore.QPointF]]: ...
    def scaleList(self) -> typing.List[typing.Tuple[float, QtCore.QPointF]]: ...
    def translationList(self) -> typing.List[typing.Tuple[float, QtCore.QPointF]]: ...
    def rotationList(self) -> typing.List[typing.Tuple[float, float]]: ...
    def posList(self) -> typing.List[typing.Tuple[float, QtCore.QPointF]]: ...
    def beforeAnimationStep(self, step: float) -> None: ...
    def afterAnimationStep(self, step: float) -> None: ...
    def setStep(self, x: float) -> None: ...
    def reset(self) -> None: ...
    def clear(self) -> None: ...
    def setShearAt(self, step: float, sh: float, sv: float) -> None: ...
    def horizontalShearAt(self, step: float) -> float: ...
    def verticalShearAt(self, step: float) -> float: ...
    def setScaleAt(self, step: float, sx: float, sy: float) -> None: ...
    def horizontalScaleAt(self, step: float) -> float: ...
    def verticalScaleAt(self, step: float) -> float: ...
    def setTranslationAt(self, step: float, dx: float, dy: float) -> None: ...
    def yTranslationAt(self, step: float) -> float: ...
    def xTranslationAt(self, step: float) -> float: ...
    def setRotationAt(self, step: float, angle: float) -> None: ...
    def rotationAt(self, step: float) -> float: ...
    def matrixAt(self, step: float) -> 'QMatrix': ...
    def setPosAt(self, step: float, pos: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def posAt(self, step: float) -> QtCore.QPointF: ...
    def setTimeLine(self, timeLine: QtCore.QTimeLine) -> None: ...
    def timeLine(self) -> QtCore.QTimeLine: ...
    def setItem(self, item: QGraphicsItem) -> None: ...
    def item(self) -> QGraphicsItem: ...


class QGraphicsLinearLayout(QGraphicsLayout):

    @typing.overload
    def __init__(self, parent: typing.Optional[QGraphicsLayoutItem] = ...) -> None: ...
    @typing.overload
    def __init__(self, orientation: QtCore.Qt.Orientation, parent: typing.Optional[QGraphicsLayoutItem] = ...) -> None: ...

    def sizeHint(self, which: QtCore.Qt.SizeHint, constraint: QtCore.QSizeF = ...) -> QtCore.QSizeF: ...
    def invalidate(self) -> None: ...
    def itemAt(self, index: int) -> QGraphicsLayoutItem: ...
    def count(self) -> int: ...
    def setGeometry(self, rect: QtCore.QRectF) -> None: ...
    def alignment(self, item: QGraphicsLayoutItem) -> QtCore.Qt.Alignment: ...
    def setAlignment(self, item: QGraphicsLayoutItem, alignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> None: ...
    def stretchFactor(self, item: QGraphicsLayoutItem) -> int: ...
    def setStretchFactor(self, item: QGraphicsLayoutItem, stretch: int) -> None: ...
    def itemSpacing(self, index: int) -> float: ...
    def setItemSpacing(self, index: int, spacing: float) -> None: ...
    def spacing(self) -> float: ...
    def setSpacing(self, spacing: float) -> None: ...
    def removeAt(self, index: int) -> None: ...
    def removeItem(self, item: QGraphicsLayoutItem) -> None: ...
    def insertStretch(self, index: int, stretch: int = ...) -> None: ...
    def insertItem(self, index: int, item: QGraphicsLayoutItem) -> None: ...
    def addStretch(self, stretch: int = ...) -> None: ...
    def addItem(self, item: QGraphicsLayoutItem) -> None: ...
    def orientation(self) -> QtCore.Qt.Orientation: ...
    def setOrientation(self, orientation: QtCore.Qt.Orientation) -> None: ...


class QGraphicsWidget(QGraphicsObject, QGraphicsLayoutItem):

    def __init__(self, parent: typing.Optional[QGraphicsItem] = ..., flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def geometryChanged(self) -> None: ...
    def setAutoFillBackground(self, enabled: bool) -> None: ...
    def autoFillBackground(self) -> bool: ...
    def ungrabKeyboardEvent(self, event: QtCore.QEvent) -> None: ...
    def grabKeyboardEvent(self, event: QtCore.QEvent) -> None: ...
    def ungrabMouseEvent(self, event: QtCore.QEvent) -> None: ...
    def grabMouseEvent(self, event: QtCore.QEvent) -> None: ...
    def hoverLeaveEvent(self, event: 'QGraphicsSceneHoverEvent') -> None: ...
    def hoverMoveEvent(self, event: 'QGraphicsSceneHoverEvent') -> None: ...
    def showEvent(self, event: QShowEvent) -> None: ...
    def resizeEvent(self, event: 'QGraphicsSceneResizeEvent') -> None: ...
    def polishEvent(self) -> None: ...
    def moveEvent(self, event: 'QGraphicsSceneMoveEvent') -> None: ...
    def hideEvent(self, event: QHideEvent) -> None: ...
    def focusOutEvent(self, event: QFocusEvent) -> None: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusInEvent(self, event: QFocusEvent) -> None: ...
    def closeEvent(self, event: QCloseEvent) -> None: ...
    def changeEvent(self, event: QtCore.QEvent) -> None: ...
    def event(self, event: QtCore.QEvent) -> bool: ...
    def windowFrameSectionAt(self, pos: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> QtCore.Qt.WindowFrameSection: ...
    def windowFrameEvent(self, e: QtCore.QEvent) -> bool: ...
    def sceneEvent(self, event: QtCore.QEvent) -> bool: ...
    def itemChange(self, change: QGraphicsItem.GraphicsItemChange, value: typing.Any) -> typing.Any: ...
    def updateGeometry(self) -> None: ...
    def sizeHint(self, which: QtCore.Qt.SizeHint, constraint: QtCore.QSizeF = ...) -> QtCore.QSizeF: ...
    def initStyleOption(self, option: 'QStyleOption') -> None: ...
    def close(self) -> bool: ...
    def shape(self) -> 'QPainterPath': ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def paintWindowFrame(self, painter: 'QPainter', option: 'QStyleOptionGraphicsItem', widget: typing.Optional[QWidget] = ...) -> None: ...
    def paint(self, painter: 'QPainter', option: 'QStyleOptionGraphicsItem', widget: typing.Optional[QWidget] = ...) -> None: ...
    def type(self) -> int: ...
    def testAttribute(self, attribute: QtCore.Qt.WidgetAttribute) -> bool: ...
    def setAttribute(self, attribute: QtCore.Qt.WidgetAttribute, on: bool = ...) -> None: ...
    def actions(self) -> typing.List[QAction]: ...
    def removeAction(self, action: QAction) -> None: ...
    def insertActions(self, before: QAction, actions: typing.Sequence[QAction]) -> None: ...
    def insertAction(self, before: QAction, action: QAction) -> None: ...
    def addActions(self, actions: typing.Sequence[QAction]) -> None: ...
    def addAction(self, action: QAction) -> None: ...
    def setShortcutAutoRepeat(self, id: int, enabled: bool = ...) -> None: ...
    def setShortcutEnabled(self, id: int, enabled: bool = ...) -> None: ...
    def releaseShortcut(self, id: int) -> None: ...
    def grabShortcut(self, sequence: typing.Union['QKeySequence', 'QKeySequence.StandardKey', str, int], context: QtCore.Qt.ShortcutContext = ...) -> int: ...
    def focusWidget(self) -> 'QGraphicsWidget': ...
    @staticmethod
    def setTabOrder(first: 'QGraphicsWidget', second: 'QGraphicsWidget') -> None: ...
    def setFocusPolicy(self, policy: QtCore.Qt.FocusPolicy) -> None: ...
    def focusPolicy(self) -> QtCore.Qt.FocusPolicy: ...
    def windowTitle(self) -> str: ...
    def setWindowTitle(self, title: str) -> None: ...
    def isActiveWindow(self) -> bool: ...
    def setWindowFlags(self, wFlags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType]) -> None: ...
    def windowType(self) -> QtCore.Qt.WindowType: ...
    def windowFlags(self) -> QtCore.Qt.WindowFlags: ...
    def windowFrameRect(self) -> QtCore.QRectF: ...
    def windowFrameGeometry(self) -> QtCore.QRectF: ...
    def unsetWindowFrameMargins(self) -> None: ...
    def getWindowFrameMargins(self) -> typing.Tuple[float, float, float, float]: ...
    def setWindowFrameMargins(self, left: float, top: float, right: float, bottom: float) -> None: ...
    def getContentsMargins(self) -> typing.Tuple[float, float, float, float]: ...
    def setContentsMargins(self, left: float, top: float, right: float, bottom: float) -> None: ...
    def rect(self) -> QtCore.QRectF: ...
    @typing.overload
    def setGeometry(self, rect: QtCore.QRectF) -> None: ...
    @typing.overload
    def setGeometry(self, ax: float, ay: float, aw: float, ah: float) -> None: ...
    def size(self) -> QtCore.QSizeF: ...
    @typing.overload
    def resize(self, size: QtCore.QSizeF) -> None: ...
    @typing.overload
    def resize(self, w: float, h: float) -> None: ...
    def setPalette(self, palette: 'QPalette') -> None: ...
    def palette(self) -> 'QPalette': ...
    def setFont(self, font: QFont) -> None: ...
    def font(self) -> QFont: ...
    def setStyle(self, style: QStyle) -> None: ...
    def style(self) -> QStyle: ...
    def unsetLayoutDirection(self) -> None: ...
    def setLayoutDirection(self, direction: QtCore.Qt.LayoutDirection) -> None: ...
    def layoutDirection(self) -> QtCore.Qt.LayoutDirection: ...
    def adjustSize(self) -> None: ...
    def setLayout(self, layout: QGraphicsLayout) -> None: ...
    def layout(self) -> QGraphicsLayout: ...


class QGraphicsProxyWidget(QGraphicsWidget):

    def __init__(self, parent: typing.Optional[QGraphicsItem] = ..., flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def newProxyWidget(self, a0: QWidget) -> 'QGraphicsProxyWidget': ...
    def dropEvent(self, event: 'QGraphicsSceneDragDropEvent') -> None: ...
    def dragMoveEvent(self, event: 'QGraphicsSceneDragDropEvent') -> None: ...
    def dragLeaveEvent(self, event: 'QGraphicsSceneDragDropEvent') -> None: ...
    def dragEnterEvent(self, event: 'QGraphicsSceneDragDropEvent') -> None: ...
    def resizeEvent(self, event: 'QGraphicsSceneResizeEvent') -> None: ...
    def sizeHint(self, which: QtCore.Qt.SizeHint, constraint: QtCore.QSizeF = ...) -> QtCore.QSizeF: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOutEvent(self, event: QFocusEvent) -> None: ...
    def focusInEvent(self, event: QFocusEvent) -> None: ...
    def keyReleaseEvent(self, event: QKeyEvent) -> None: ...
    def keyPressEvent(self, event: QKeyEvent) -> None: ...
    def wheelEvent(self, event: 'QGraphicsSceneWheelEvent') -> None: ...
    def mouseDoubleClickEvent(self, event: 'QGraphicsSceneMouseEvent') -> None: ...
    def mouseReleaseEvent(self, event: 'QGraphicsSceneMouseEvent') -> None: ...
    def mousePressEvent(self, event: 'QGraphicsSceneMouseEvent') -> None: ...
    def mouseMoveEvent(self, event: 'QGraphicsSceneMouseEvent') -> None: ...
    def ungrabMouseEvent(self, event: QtCore.QEvent) -> None: ...
    def grabMouseEvent(self, event: QtCore.QEvent) -> None: ...
    def hoverMoveEvent(self, event: 'QGraphicsSceneHoverEvent') -> None: ...
    def hoverLeaveEvent(self, event: 'QGraphicsSceneHoverEvent') -> None: ...
    def hoverEnterEvent(self, event: 'QGraphicsSceneHoverEvent') -> None: ...
    def contextMenuEvent(self, event: 'QGraphicsSceneContextMenuEvent') -> None: ...
    def hideEvent(self, event: QHideEvent) -> None: ...
    def showEvent(self, event: QShowEvent) -> None: ...
    def eventFilter(self, object: QtCore.QObject, event: QtCore.QEvent) -> bool: ...
    def event(self, event: QtCore.QEvent) -> bool: ...
    def itemChange(self, change: QGraphicsItem.GraphicsItemChange, value: typing.Any) -> typing.Any: ...
    def createProxyForChildWidget(self, child: QWidget) -> 'QGraphicsProxyWidget': ...
    def type(self) -> int: ...
    def paint(self, painter: 'QPainter', option: 'QStyleOptionGraphicsItem', widget: QWidget) -> None: ...
    def setGeometry(self, rect: QtCore.QRectF) -> None: ...
    def subWidgetRect(self, widget: QWidget) -> QtCore.QRectF: ...
    def widget(self) -> QWidget: ...
    def setWidget(self, widget: QWidget) -> None: ...


class QGraphicsScene(QtCore.QObject):

    class SceneLayer(int): ...
    ItemLayer = ... # type: 'QGraphicsScene.SceneLayer'
    BackgroundLayer = ... # type: 'QGraphicsScene.SceneLayer'
    ForegroundLayer = ... # type: 'QGraphicsScene.SceneLayer'
    AllLayers = ... # type: 'QGraphicsScene.SceneLayer'

    class ItemIndexMethod(int): ...
    BspTreeIndex = ... # type: 'QGraphicsScene.ItemIndexMethod'
    NoIndex = ... # type: 'QGraphicsScene.ItemIndexMethod'

    class SceneLayers(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QGraphicsScene.SceneLayers', 'QGraphicsScene.SceneLayer']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QGraphicsScene.SceneLayers') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QGraphicsScene.SceneLayers': ...
        def __int__(self) -> int: ...

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, sceneRect: QtCore.QRectF, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, x: float, y: float, width: float, height: float, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def sendEvent(self, item: QGraphicsItem, event: QtCore.QEvent) -> bool: ...
    def setActivePanel(self, item: QGraphicsItem) -> None: ...
    def activePanel(self) -> QGraphicsItem: ...
    def isActive(self) -> bool: ...
    def stickyFocus(self) -> bool: ...
    def setStickyFocus(self, enabled: bool) -> None: ...
    def setSortCacheEnabled(self, enabled: bool) -> None: ...
    def isSortCacheEnabled(self) -> bool: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def eventFilter(self, watched: QtCore.QObject, event: QtCore.QEvent) -> bool: ...
    def setActiveWindow(self, widget: QGraphicsWidget) -> None: ...
    def activeWindow(self) -> QGraphicsWidget: ...
    def setPalette(self, palette: 'QPalette') -> None: ...
    def palette(self) -> 'QPalette': ...
    def setFont(self, font: QFont) -> None: ...
    def font(self) -> QFont: ...
    def setStyle(self, style: QStyle) -> None: ...
    def style(self) -> QStyle: ...
    def addWidget(self, widget: QWidget, flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> QGraphicsProxyWidget: ...
    def selectionArea(self) -> 'QPainterPath': ...
    def setBspTreeDepth(self, depth: int) -> None: ...
    def bspTreeDepth(self) -> int: ...
    def drawItems(self, painter: 'QPainter', items: typing.List[QGraphicsItem], options: typing.List['QStyleOptionGraphicsItem'], widget: typing.Optional[QWidget] = ...) -> None: ...
    def drawForeground(self, painter: 'QPainter', rect: QtCore.QRectF) -> None: ...
    def drawBackground(self, painter: 'QPainter', rect: QtCore.QRectF) -> None: ...
    def inputMethodEvent(self, event: QInputMethodEvent) -> None: ...
    def wheelEvent(self, event: 'QGraphicsSceneWheelEvent') -> None: ...
    def mouseDoubleClickEvent(self, event: 'QGraphicsSceneMouseEvent') -> None: ...
    def mouseReleaseEvent(self, event: 'QGraphicsSceneMouseEvent') -> None: ...
    def mouseMoveEvent(self, event: 'QGraphicsSceneMouseEvent') -> None: ...
    def mousePressEvent(self, event: 'QGraphicsSceneMouseEvent') -> None: ...
    def keyReleaseEvent(self, event: QKeyEvent) -> None: ...
    def keyPressEvent(self, event: QKeyEvent) -> None: ...
    def helpEvent(self, event: 'QGraphicsSceneHelpEvent') -> None: ...
    def focusOutEvent(self, event: QFocusEvent) -> None: ...
    def focusInEvent(self, event: QFocusEvent) -> None: ...
    def dropEvent(self, event: 'QGraphicsSceneDragDropEvent') -> None: ...
    def dragLeaveEvent(self, event: 'QGraphicsSceneDragDropEvent') -> None: ...
    def dragMoveEvent(self, event: 'QGraphicsSceneDragDropEvent') -> None: ...
    def dragEnterEvent(self, event: 'QGraphicsSceneDragDropEvent') -> None: ...
    def contextMenuEvent(self, event: 'QGraphicsSceneContextMenuEvent') -> None: ...
    def event(self, event: QtCore.QEvent) -> bool: ...
    def selectionChanged(self) -> None: ...
    def sceneRectChanged(self, rect: QtCore.QRectF) -> None: ...
    def changed(self, region: typing.Sequence[QtCore.QRectF]) -> None: ...
    def clear(self) -> None: ...
    @typing.overload
    def invalidate(self, rect: QtCore.QRectF = ..., layers: 'QGraphicsScene.SceneLayers' = ...) -> None: ...
    @typing.overload
    def invalidate(self, x: float, y: float, w: float, h: float, layers: 'QGraphicsScene.SceneLayers' = ...) -> None: ...
    @typing.overload
    def update(self, rect: QtCore.QRectF = ...) -> None: ...
    @typing.overload
    def update(self, x: float, y: float, w: float, h: float) -> None: ...
    def advance(self) -> None: ...
    def views(self) -> typing.List['QGraphicsView']: ...
    def inputMethodQuery(self, query: QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def setForegroundBrush(self, brush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def foregroundBrush(self) -> QBrush: ...
    def setBackgroundBrush(self, brush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def backgroundBrush(self) -> QBrush: ...
    def mouseGrabberItem(self) -> QGraphicsItem: ...
    def clearFocus(self) -> None: ...
    def setFocus(self, focusReason: QtCore.Qt.FocusReason = ...) -> None: ...
    def hasFocus(self) -> bool: ...
    def setFocusItem(self, item: QGraphicsItem, focusReason: QtCore.Qt.FocusReason = ...) -> None: ...
    def focusItem(self) -> QGraphicsItem: ...
    def removeItem(self, item: QGraphicsItem) -> None: ...
    def addText(self, text: str, font: QFont = ...) -> QGraphicsTextItem: ...
    def addSimpleText(self, text: str, font: QFont = ...) -> QGraphicsSimpleTextItem: ...
    @typing.overload
    def addRect(self, rect: QtCore.QRectF, pen: typing.Union['QPen', QColor, QtCore.Qt.GlobalColor, QGradient] = ..., brush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient] = ...) -> QGraphicsRectItem: ...
    @typing.overload
    def addRect(self, x: float, y: float, w: float, h: float, pen: typing.Union['QPen', QColor, QtCore.Qt.GlobalColor, QGradient] = ..., brush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient] = ...) -> QGraphicsRectItem: ...
    def addPolygon(self, polygon: 'QPolygonF', pen: typing.Union['QPen', QColor, QtCore.Qt.GlobalColor, QGradient] = ..., brush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient] = ...) -> QGraphicsPolygonItem: ...
    def addPixmap(self, pixmap: QPixmap) -> QGraphicsPixmapItem: ...
    def addPath(self, path: 'QPainterPath', pen: typing.Union['QPen', QColor, QtCore.Qt.GlobalColor, QGradient] = ..., brush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient] = ...) -> QGraphicsPathItem: ...
    @typing.overload
    def addLine(self, line: QtCore.QLineF, pen: typing.Union['QPen', QColor, QtCore.Qt.GlobalColor, QGradient] = ...) -> QGraphicsLineItem: ...
    @typing.overload
    def addLine(self, x1: float, y1: float, x2: float, y2: float, pen: typing.Union['QPen', QColor, QtCore.Qt.GlobalColor, QGradient] = ...) -> QGraphicsLineItem: ...
    @typing.overload
    def addEllipse(self, rect: QtCore.QRectF, pen: typing.Union['QPen', QColor, QtCore.Qt.GlobalColor, QGradient] = ..., brush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient] = ...) -> QGraphicsEllipseItem: ...
    @typing.overload
    def addEllipse(self, x: float, y: float, w: float, h: float, pen: typing.Union['QPen', QColor, QtCore.Qt.GlobalColor, QGradient] = ..., brush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient] = ...) -> QGraphicsEllipseItem: ...
    def addItem(self, item: QGraphicsItem) -> None: ...
    def destroyItemGroup(self, group: QGraphicsItemGroup) -> None: ...
    def createItemGroup(self, items: typing.Sequence[QGraphicsItem]) -> QGraphicsItemGroup: ...
    def clearSelection(self) -> None: ...
    @typing.overload
    def setSelectionArea(self, path: 'QPainterPath', deviceTransform: 'QTransform') -> None: ...
    @typing.overload
    def setSelectionArea(self, path: 'QPainterPath') -> None: ...
    @typing.overload
    def setSelectionArea(self, path: 'QPainterPath', a1: QtCore.Qt.ItemSelectionMode) -> None: ...
    @typing.overload
    def setSelectionArea(self, path: 'QPainterPath', mode: QtCore.Qt.ItemSelectionMode, deviceTransform: 'QTransform') -> None: ...
    def selectedItems(self) -> typing.List[QGraphicsItem]: ...
    @typing.overload
    def itemAt(self, pos: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> QGraphicsItem: ...
    @typing.overload
    def itemAt(self, x: float, y: float) -> QGraphicsItem: ...
    @typing.overload
    def itemAt(self, pos: typing.Union[QtCore.QPointF, QtCore.QPoint], deviceTransform: 'QTransform') -> QGraphicsItem: ...
    @typing.overload
    def itemAt(self, x: float, y: float, deviceTransform: 'QTransform') -> QGraphicsItem: ...
    def collidingItems(self, item: QGraphicsItem, mode: QtCore.Qt.ItemSelectionMode = ...) -> typing.List[QGraphicsItem]: ...
    @typing.overload
    def items(self) -> typing.List[QGraphicsItem]: ...
    @typing.overload
    def items(self, order: QtCore.Qt.SortOrder) -> typing.List[QGraphicsItem]: ...
    @typing.overload
    def items(self, pos: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> typing.List[QGraphicsItem]: ...
    @typing.overload
    def items(self, pos: typing.Union[QtCore.QPointF, QtCore.QPoint], mode: QtCore.Qt.ItemSelectionMode, order: QtCore.Qt.SortOrder, deviceTransform: 'QTransform' = ...) -> typing.List[QGraphicsItem]: ...
    @typing.overload
    def items(self, rectangle: QtCore.QRectF, mode: QtCore.Qt.ItemSelectionMode = ...) -> typing.List[QGraphicsItem]: ...
    @typing.overload
    def items(self, rect: QtCore.QRectF, mode: QtCore.Qt.ItemSelectionMode, order: QtCore.Qt.SortOrder, deviceTransform: 'QTransform' = ...) -> typing.List[QGraphicsItem]: ...
    @typing.overload
    def items(self, polygon: 'QPolygonF', mode: QtCore.Qt.ItemSelectionMode = ...) -> typing.List[QGraphicsItem]: ...
    @typing.overload
    def items(self, polygon: 'QPolygonF', mode: QtCore.Qt.ItemSelectionMode, order: QtCore.Qt.SortOrder, deviceTransform: 'QTransform' = ...) -> typing.List[QGraphicsItem]: ...
    @typing.overload
    def items(self, path: 'QPainterPath', mode: QtCore.Qt.ItemSelectionMode = ...) -> typing.List[QGraphicsItem]: ...
    @typing.overload
    def items(self, path: 'QPainterPath', mode: QtCore.Qt.ItemSelectionMode, order: QtCore.Qt.SortOrder, deviceTransform: 'QTransform' = ...) -> typing.List[QGraphicsItem]: ...
    @typing.overload
    def items(self, x: float, y: float, w: float, h: float, mode: QtCore.Qt.ItemSelectionMode = ...) -> typing.List[QGraphicsItem]: ...
    @typing.overload
    def items(self, x: float, y: float, w: float, h: float, mode: QtCore.Qt.ItemSelectionMode, order: QtCore.Qt.SortOrder, deviceTransform: 'QTransform' = ...) -> typing.List[QGraphicsItem]: ...
    def itemsBoundingRect(self) -> QtCore.QRectF: ...
    def setItemIndexMethod(self, method: 'QGraphicsScene.ItemIndexMethod') -> None: ...
    def itemIndexMethod(self) -> 'QGraphicsScene.ItemIndexMethod': ...
    def render(self, painter: 'QPainter', target: QtCore.QRectF = ..., source: QtCore.QRectF = ..., mode: QtCore.Qt.AspectRatioMode = ...) -> None: ...
    @typing.overload
    def setSceneRect(self, rect: QtCore.QRectF) -> None: ...
    @typing.overload
    def setSceneRect(self, x: float, y: float, w: float, h: float) -> None: ...
    def height(self) -> float: ...
    def width(self) -> float: ...
    def sceneRect(self) -> QtCore.QRectF: ...


class QGraphicsSceneEvent(QtCore.QEvent):

    def setWidget(self, widget: QWidget) -> None: ...
    def widget(self) -> QWidget: ...


class QGraphicsSceneMouseEvent(QGraphicsSceneEvent):

    def modifiers(self) -> QtCore.Qt.KeyboardModifiers: ...
    def button(self) -> QtCore.Qt.MouseButton: ...
    def buttons(self) -> QtCore.Qt.MouseButtons: ...
    def lastScreenPos(self) -> QtCore.QPoint: ...
    def lastScenePos(self) -> QtCore.QPointF: ...
    def lastPos(self) -> QtCore.QPointF: ...
    def buttonDownScreenPos(self, button: QtCore.Qt.MouseButton) -> QtCore.QPoint: ...
    def buttonDownScenePos(self, button: QtCore.Qt.MouseButton) -> QtCore.QPointF: ...
    def buttonDownPos(self, button: QtCore.Qt.MouseButton) -> QtCore.QPointF: ...
    def screenPos(self) -> QtCore.QPoint: ...
    def scenePos(self) -> QtCore.QPointF: ...
    def pos(self) -> QtCore.QPointF: ...


class QGraphicsSceneWheelEvent(QGraphicsSceneEvent):

    def orientation(self) -> QtCore.Qt.Orientation: ...
    def delta(self) -> int: ...
    def modifiers(self) -> QtCore.Qt.KeyboardModifiers: ...
    def buttons(self) -> QtCore.Qt.MouseButtons: ...
    def screenPos(self) -> QtCore.QPoint: ...
    def scenePos(self) -> QtCore.QPointF: ...
    def pos(self) -> QtCore.QPointF: ...


class QGraphicsSceneContextMenuEvent(QGraphicsSceneEvent):

    class Reason(int): ...
    Mouse = ... # type: 'QGraphicsSceneContextMenuEvent.Reason'
    Keyboard = ... # type: 'QGraphicsSceneContextMenuEvent.Reason'
    Other = ... # type: 'QGraphicsSceneContextMenuEvent.Reason'

    def reason(self) -> 'QGraphicsSceneContextMenuEvent.Reason': ...
    def modifiers(self) -> QtCore.Qt.KeyboardModifiers: ...
    def screenPos(self) -> QtCore.QPoint: ...
    def scenePos(self) -> QtCore.QPointF: ...
    def pos(self) -> QtCore.QPointF: ...


class QGraphicsSceneHoverEvent(QGraphicsSceneEvent):

    def modifiers(self) -> QtCore.Qt.KeyboardModifiers: ...
    def lastScreenPos(self) -> QtCore.QPoint: ...
    def lastScenePos(self) -> QtCore.QPointF: ...
    def lastPos(self) -> QtCore.QPointF: ...
    def screenPos(self) -> QtCore.QPoint: ...
    def scenePos(self) -> QtCore.QPointF: ...
    def pos(self) -> QtCore.QPointF: ...


class QGraphicsSceneHelpEvent(QGraphicsSceneEvent):

    def screenPos(self) -> QtCore.QPoint: ...
    def scenePos(self) -> QtCore.QPointF: ...


class QGraphicsSceneDragDropEvent(QGraphicsSceneEvent):

    def mimeData(self) -> QtCore.QMimeData: ...
    def source(self) -> QWidget: ...
    def setDropAction(self, action: QtCore.Qt.DropAction) -> None: ...
    def dropAction(self) -> QtCore.Qt.DropAction: ...
    def acceptProposedAction(self) -> None: ...
    def proposedAction(self) -> QtCore.Qt.DropAction: ...
    def possibleActions(self) -> QtCore.Qt.DropActions: ...
    def modifiers(self) -> QtCore.Qt.KeyboardModifiers: ...
    def buttons(self) -> QtCore.Qt.MouseButtons: ...
    def screenPos(self) -> QtCore.QPoint: ...
    def scenePos(self) -> QtCore.QPointF: ...
    def pos(self) -> QtCore.QPointF: ...


class QGraphicsSceneResizeEvent(QGraphicsSceneEvent):

    def __init__(self) -> None: ...

    def newSize(self) -> QtCore.QSizeF: ...
    def oldSize(self) -> QtCore.QSizeF: ...


class QGraphicsSceneMoveEvent(QGraphicsSceneEvent):

    def __init__(self) -> None: ...

    def newPos(self) -> QtCore.QPointF: ...
    def oldPos(self) -> QtCore.QPointF: ...


class QGraphicsTransform(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def update(self) -> None: ...
    def applyTo(self, matrix: 'QMatrix4x4') -> None: ...


class QGraphicsScale(QGraphicsTransform):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def zScaleChanged(self) -> None: ...
    def yScaleChanged(self) -> None: ...
    def xScaleChanged(self) -> None: ...
    def scaleChanged(self) -> None: ...
    def originChanged(self) -> None: ...
    def applyTo(self, matrix: 'QMatrix4x4') -> None: ...
    def setZScale(self, a0: float) -> None: ...
    def zScale(self) -> float: ...
    def setYScale(self, a0: float) -> None: ...
    def yScale(self) -> float: ...
    def setXScale(self, a0: float) -> None: ...
    def xScale(self) -> float: ...
    def setOrigin(self, point: 'QVector3D') -> None: ...
    def origin(self) -> 'QVector3D': ...


class QGraphicsRotation(QGraphicsTransform):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def axisChanged(self) -> None: ...
    def angleChanged(self) -> None: ...
    def originChanged(self) -> None: ...
    def applyTo(self, matrix: 'QMatrix4x4') -> None: ...
    @typing.overload
    def setAxis(self, axis: 'QVector3D') -> None: ...
    @typing.overload
    def setAxis(self, axis: QtCore.Qt.Axis) -> None: ...
    def axis(self) -> 'QVector3D': ...
    def setAngle(self, a0: float) -> None: ...
    def angle(self) -> float: ...
    def setOrigin(self, point: 'QVector3D') -> None: ...
    def origin(self) -> 'QVector3D': ...


class QGraphicsView(QAbstractScrollArea):

    class OptimizationFlag(int): ...
    DontClipPainter = ... # type: 'QGraphicsView.OptimizationFlag'
    DontSavePainterState = ... # type: 'QGraphicsView.OptimizationFlag'
    DontAdjustForAntialiasing = ... # type: 'QGraphicsView.OptimizationFlag'

    class ViewportUpdateMode(int): ...
    FullViewportUpdate = ... # type: 'QGraphicsView.ViewportUpdateMode'
    MinimalViewportUpdate = ... # type: 'QGraphicsView.ViewportUpdateMode'
    SmartViewportUpdate = ... # type: 'QGraphicsView.ViewportUpdateMode'
    BoundingRectViewportUpdate = ... # type: 'QGraphicsView.ViewportUpdateMode'
    NoViewportUpdate = ... # type: 'QGraphicsView.ViewportUpdateMode'

    class ViewportAnchor(int): ...
    NoAnchor = ... # type: 'QGraphicsView.ViewportAnchor'
    AnchorViewCenter = ... # type: 'QGraphicsView.ViewportAnchor'
    AnchorUnderMouse = ... # type: 'QGraphicsView.ViewportAnchor'

    class DragMode(int): ...
    NoDrag = ... # type: 'QGraphicsView.DragMode'
    ScrollHandDrag = ... # type: 'QGraphicsView.DragMode'
    RubberBandDrag = ... # type: 'QGraphicsView.DragMode'

    class CacheModeFlag(int): ...
    CacheNone = ... # type: 'QGraphicsView.CacheModeFlag'
    CacheBackground = ... # type: 'QGraphicsView.CacheModeFlag'

    class CacheMode(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QGraphicsView.CacheMode', 'QGraphicsView.CacheModeFlag']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QGraphicsView.CacheMode') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QGraphicsView.CacheMode': ...
        def __int__(self) -> int: ...

    class OptimizationFlags(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QGraphicsView.OptimizationFlags', 'QGraphicsView.OptimizationFlag']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QGraphicsView.OptimizationFlags') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QGraphicsView.OptimizationFlags': ...
        def __int__(self) -> int: ...

    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, scene: QGraphicsScene, parent: typing.Optional[QWidget] = ...) -> None: ...

    def isTransformed(self) -> bool: ...
    def resetTransform(self) -> None: ...
    def setTransform(self, matrix: 'QTransform', combine: bool = ...) -> None: ...
    def viewportTransform(self) -> 'QTransform': ...
    def transform(self) -> 'QTransform': ...
    def setRubberBandSelectionMode(self, mode: QtCore.Qt.ItemSelectionMode) -> None: ...
    def rubberBandSelectionMode(self) -> QtCore.Qt.ItemSelectionMode: ...
    def setOptimizationFlags(self, flags: 'QGraphicsView.OptimizationFlags') -> None: ...
    def setOptimizationFlag(self, flag: 'QGraphicsView.OptimizationFlag', enabled: bool = ...) -> None: ...
    def optimizationFlags(self) -> 'QGraphicsView.OptimizationFlags': ...
    def setViewportUpdateMode(self, mode: 'QGraphicsView.ViewportUpdateMode') -> None: ...
    def viewportUpdateMode(self) -> 'QGraphicsView.ViewportUpdateMode': ...
    def drawItems(self, painter: 'QPainter', items: typing.List[QGraphicsItem], options: typing.List['QStyleOptionGraphicsItem']) -> None: ...
    def drawForeground(self, painter: 'QPainter', rect: QtCore.QRectF) -> None: ...
    def drawBackground(self, painter: 'QPainter', rect: QtCore.QRectF) -> None: ...
    def inputMethodEvent(self, event: QInputMethodEvent) -> None: ...
    def showEvent(self, event: QShowEvent) -> None: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def resizeEvent(self, event: QResizeEvent) -> None: ...
    def paintEvent(self, event: QPaintEvent) -> None: ...
    def wheelEvent(self, event: QWheelEvent) -> None: ...
    def mouseReleaseEvent(self, event: QMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: QMouseEvent) -> None: ...
    def mousePressEvent(self, event: QMouseEvent) -> None: ...
    def mouseDoubleClickEvent(self, event: QMouseEvent) -> None: ...
    def keyReleaseEvent(self, event: QKeyEvent) -> None: ...
    def keyPressEvent(self, event: QKeyEvent) -> None: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOutEvent(self, event: QFocusEvent) -> None: ...
    def focusInEvent(self, event: QFocusEvent) -> None: ...
    def dropEvent(self, event: QDropEvent) -> None: ...
    def dragMoveEvent(self, event: QDragMoveEvent) -> None: ...
    def dragLeaveEvent(self, event: QDragLeaveEvent) -> None: ...
    def dragEnterEvent(self, event: QDragEnterEvent) -> None: ...
    def contextMenuEvent(self, event: QContextMenuEvent) -> None: ...
    def viewportEvent(self, event: QtCore.QEvent) -> bool: ...
    def event(self, event: QtCore.QEvent) -> bool: ...
    def setupViewport(self, widget: QWidget) -> None: ...
    def updateSceneRect(self, rect: QtCore.QRectF) -> None: ...
    def updateScene(self, rects: typing.Sequence[QtCore.QRectF]) -> None: ...
    def invalidateScene(self, rect: QtCore.QRectF = ..., layers: QGraphicsScene.SceneLayers = ...) -> None: ...
    def setForegroundBrush(self, brush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def foregroundBrush(self) -> QBrush: ...
    def setBackgroundBrush(self, brush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def backgroundBrush(self) -> QBrush: ...
    def inputMethodQuery(self, query: QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    @typing.overload
    def mapFromScene(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> QtCore.QPoint: ...
    @typing.overload
    def mapFromScene(self, rect: QtCore.QRectF) -> 'QPolygon': ...
    @typing.overload
    def mapFromScene(self, polygon: 'QPolygonF') -> 'QPolygon': ...
    @typing.overload
    def mapFromScene(self, path: 'QPainterPath') -> 'QPainterPath': ...
    @typing.overload
    def mapFromScene(self, ax: float, ay: float) -> QtCore.QPoint: ...
    @typing.overload
    def mapFromScene(self, ax: float, ay: float, w: float, h: float) -> 'QPolygon': ...
    @typing.overload
    def mapToScene(self, point: QtCore.QPoint) -> QtCore.QPointF: ...
    @typing.overload
    def mapToScene(self, rect: QtCore.QRect) -> 'QPolygonF': ...
    @typing.overload
    def mapToScene(self, polygon: 'QPolygon') -> 'QPolygonF': ...
    @typing.overload
    def mapToScene(self, path: 'QPainterPath') -> 'QPainterPath': ...
    @typing.overload
    def mapToScene(self, ax: int, ay: int) -> QtCore.QPointF: ...
    @typing.overload
    def mapToScene(self, ax: int, ay: int, w: int, h: int) -> 'QPolygonF': ...
    @typing.overload
    def itemAt(self, pos: QtCore.QPoint) -> QGraphicsItem: ...
    @typing.overload
    def itemAt(self, ax: int, ay: int) -> QGraphicsItem: ...
    @typing.overload
    def items(self) -> typing.List[QGraphicsItem]: ...
    @typing.overload
    def items(self, pos: QtCore.QPoint) -> typing.List[QGraphicsItem]: ...
    @typing.overload
    def items(self, ax: int, ay: int) -> typing.List[QGraphicsItem]: ...
    @typing.overload
    def items(self, x: int, y: int, w: int, h: int, mode: QtCore.Qt.ItemSelectionMode = ...) -> typing.List[QGraphicsItem]: ...
    @typing.overload
    def items(self, rect: QtCore.QRect, mode: QtCore.Qt.ItemSelectionMode = ...) -> typing.List[QGraphicsItem]: ...
    @typing.overload
    def items(self, polygon: 'QPolygon', mode: QtCore.Qt.ItemSelectionMode = ...) -> typing.List[QGraphicsItem]: ...
    @typing.overload
    def items(self, path: 'QPainterPath', mode: QtCore.Qt.ItemSelectionMode = ...) -> typing.List[QGraphicsItem]: ...
    def render(self, painter: 'QPainter', target: QtCore.QRectF = ..., source: QtCore.QRect = ..., mode: QtCore.Qt.AspectRatioMode = ...) -> None: ...
    @typing.overload
    def fitInView(self, rect: QtCore.QRectF, mode: QtCore.Qt.AspectRatioMode = ...) -> None: ...
    @typing.overload
    def fitInView(self, item: QGraphicsItem, mode: QtCore.Qt.AspectRatioMode = ...) -> None: ...
    @typing.overload
    def fitInView(self, x: float, y: float, w: float, h: float, mode: QtCore.Qt.AspectRatioMode = ...) -> None: ...
    @typing.overload
    def ensureVisible(self, rect: QtCore.QRectF, xMargin: int = ..., yMargin: int = ...) -> None: ...
    @typing.overload
    def ensureVisible(self, item: QGraphicsItem, xMargin: int = ..., yMargin: int = ...) -> None: ...
    @typing.overload
    def ensureVisible(self, x: float, y: float, w: float, h: float, xMargin: int = ..., yMargin: int = ...) -> None: ...
    @typing.overload
    def centerOn(self, pos: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @typing.overload
    def centerOn(self, item: QGraphicsItem) -> None: ...
    @typing.overload
    def centerOn(self, ax: float, ay: float) -> None: ...
    def translate(self, dx: float, dy: float) -> None: ...
    def shear(self, sh: float, sv: float) -> None: ...
    def scale(self, sx: float, sy: float) -> None: ...
    def rotate(self, angle: float) -> None: ...
    def resetMatrix(self) -> None: ...
    def setMatrix(self, matrix: 'QMatrix', combine: bool = ...) -> None: ...
    def matrix(self) -> 'QMatrix': ...
    @typing.overload
    def setSceneRect(self, rect: QtCore.QRectF) -> None: ...
    @typing.overload
    def setSceneRect(self, ax: float, ay: float, aw: float, ah: float) -> None: ...
    def sceneRect(self) -> QtCore.QRectF: ...
    def setScene(self, scene: QGraphicsScene) -> None: ...
    def scene(self) -> QGraphicsScene: ...
    def setInteractive(self, allowed: bool) -> None: ...
    def isInteractive(self) -> bool: ...
    def resetCachedContent(self) -> None: ...
    def setCacheMode(self, mode: 'QGraphicsView.CacheMode') -> None: ...
    def cacheMode(self) -> 'QGraphicsView.CacheMode': ...
    def setDragMode(self, mode: 'QGraphicsView.DragMode') -> None: ...
    def dragMode(self) -> 'QGraphicsView.DragMode': ...
    def setResizeAnchor(self, anchor: 'QGraphicsView.ViewportAnchor') -> None: ...
    def resizeAnchor(self) -> 'QGraphicsView.ViewportAnchor': ...
    def setTransformationAnchor(self, anchor: 'QGraphicsView.ViewportAnchor') -> None: ...
    def transformationAnchor(self) -> 'QGraphicsView.ViewportAnchor': ...
    def setAlignment(self, alignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> None: ...
    def alignment(self) -> QtCore.Qt.Alignment: ...
    def setRenderHints(self, hints: 'QPainter.RenderHints') -> None: ...
    def setRenderHint(self, hint: 'QPainter.RenderHint', on: bool = ...) -> None: ...
    def renderHints(self) -> 'QPainter.RenderHints': ...
    def sizeHint(self) -> QtCore.QSize: ...


class QGridLayout(QLayout):

    @typing.overload
    def __init__(self, parent: QWidget) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...

    def itemAtPosition(self, row: int, column: int) -> QLayoutItem: ...
    def spacing(self) -> int: ...
    def setSpacing(self, spacing: int) -> None: ...
    def verticalSpacing(self) -> int: ...
    def setVerticalSpacing(self, spacing: int) -> None: ...
    def horizontalSpacing(self) -> int: ...
    def setHorizontalSpacing(self, spacing: int) -> None: ...
    def getItemPosition(self, idx: int) -> typing.Tuple[int, int, int, int]: ...
    def setDefaultPositioning(self, n: int, orient: QtCore.Qt.Orientation) -> None: ...
    @typing.overload
    def addItem(self, item: QLayoutItem, row: int, column: int, rowSpan: int = ..., columnSpan: int = ..., alignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag] = ...) -> None: ...
    @typing.overload
    def addItem(self, a0: QLayoutItem) -> None: ...
    def setGeometry(self, a0: QtCore.QRect) -> None: ...
    def count(self) -> int: ...
    def takeAt(self, a0: int) -> QLayoutItem: ...
    def itemAt(self, a0: int) -> QLayoutItem: ...
    def originCorner(self) -> QtCore.Qt.Corner: ...
    def setOriginCorner(self, a0: QtCore.Qt.Corner) -> None: ...
    @typing.overload
    def addLayout(self, a0: QLayout, row: int, column: int, alignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag] = ...) -> None: ...
    @typing.overload
    def addLayout(self, a0: QLayout, row: int, column: int, rowSpan: int, columnSpan: int, alignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag] = ...) -> None: ...
    @typing.overload
    def addWidget(self, w: QWidget) -> None: ...
    @typing.overload
    def addWidget(self, a0: QWidget, row: int, column: int, alignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag] = ...) -> None: ...
    @typing.overload
    def addWidget(self, a0: QWidget, row: int, column: int, rowSpan: int, columnSpan: int, alignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag] = ...) -> None: ...
    def invalidate(self) -> None: ...
    def expandingDirections(self) -> QtCore.Qt.Orientations: ...
    def minimumHeightForWidth(self, a0: int) -> int: ...
    def heightForWidth(self, a0: int) -> int: ...
    def hasHeightForWidth(self) -> bool: ...
    def cellRect(self, row: int, column: int) -> QtCore.QRect: ...
    def rowCount(self) -> int: ...
    def columnCount(self) -> int: ...
    def columnMinimumWidth(self, column: int) -> int: ...
    def rowMinimumHeight(self, row: int) -> int: ...
    def setColumnMinimumWidth(self, column: int, minSize: int) -> None: ...
    def setRowMinimumHeight(self, row: int, minSize: int) -> None: ...
    def columnStretch(self, column: int) -> int: ...
    def rowStretch(self, row: int) -> int: ...
    def setColumnStretch(self, column: int, stretch: int) -> None: ...
    def setRowStretch(self, row: int, stretch: int) -> None: ...
    def maximumSize(self) -> QtCore.QSize: ...
    def minimumSize(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...


class QGroupBox(QWidget):

    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, title: str, parent: typing.Optional[QWidget] = ...) -> None: ...

    def mouseReleaseEvent(self, event: QMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: QMouseEvent) -> None: ...
    def mousePressEvent(self, event: QMouseEvent) -> None: ...
    def changeEvent(self, a0: QtCore.QEvent) -> None: ...
    def focusInEvent(self, a0: QFocusEvent) -> None: ...
    def paintEvent(self, a0: QPaintEvent) -> None: ...
    def resizeEvent(self, a0: QResizeEvent) -> None: ...
    def childEvent(self, a0: QtCore.QChildEvent) -> None: ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    def initStyleOption(self, option: 'QStyleOptionGroupBox') -> None: ...
    def toggled(self, a0: bool) -> None: ...
    def clicked(self, checked: bool = ...) -> None: ...
    def setChecked(self, b: bool) -> None: ...
    def isChecked(self) -> bool: ...
    def setCheckable(self, b: bool) -> None: ...
    def isCheckable(self) -> bool: ...
    def setFlat(self, b: bool) -> None: ...
    def isFlat(self) -> bool: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def setAlignment(self, a0: int) -> None: ...
    def alignment(self) -> QtCore.Qt.Alignment: ...
    def setTitle(self, a0: str) -> None: ...
    def title(self) -> str: ...


class QHeaderView(QAbstractItemView):

    class ResizeMode(int): ...
    Interactive = ... # type: 'QHeaderView.ResizeMode'
    Fixed = ... # type: 'QHeaderView.ResizeMode'
    Stretch = ... # type: 'QHeaderView.ResizeMode'
    ResizeToContents = ... # type: 'QHeaderView.ResizeMode'
    Custom = ... # type: 'QHeaderView.ResizeMode'

    def __init__(self, orientation: QtCore.Qt.Orientation, parent: typing.Optional[QWidget] = ...) -> None: ...

    def initStyleOption(self, option: 'QStyleOptionHeader') -> None: ...
    def sortIndicatorChanged(self, logicalIndex: int, order: QtCore.Qt.SortOrder) -> None: ...
    def sectionEntered(self, logicalIndex: int) -> None: ...
    def setOffsetToLastSection(self) -> None: ...
    def reset(self) -> None: ...
    def restoreState(self, state: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> bool: ...
    def saveState(self) -> QtCore.QByteArray: ...
    def setMinimumSectionSize(self, size: int) -> None: ...
    def minimumSectionSize(self) -> int: ...
    def setCascadingSectionResizes(self, enable: bool) -> None: ...
    def cascadingSectionResizes(self) -> bool: ...
    def swapSections(self, first: int, second: int) -> None: ...
    def sectionsHidden(self) -> bool: ...
    def setDefaultAlignment(self, alignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> None: ...
    def defaultAlignment(self) -> QtCore.Qt.Alignment: ...
    def setDefaultSectionSize(self, size: int) -> None: ...
    def defaultSectionSize(self) -> int: ...
    def hiddenSectionCount(self) -> int: ...
    def showSection(self, alogicalIndex: int) -> None: ...
    def hideSection(self, alogicalIndex: int) -> None: ...
    def visualRegionForSelection(self, selection: 'QItemSelection') -> 'QRegion': ...
    def setSelection(self, a0: QtCore.QRect, a1: 'QItemSelectionModel.SelectionFlags') -> None: ...
    def moveCursor(self, a0: QAbstractItemView.CursorAction, a1: typing.Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier]) -> QtCore.QModelIndex: ...
    def isIndexHidden(self, index: QtCore.QModelIndex) -> bool: ...
    def indexAt(self, p: QtCore.QPoint) -> QtCore.QModelIndex: ...
    def scrollTo(self, index: QtCore.QModelIndex, hint: QAbstractItemView.ScrollHint) -> None: ...
    def visualRect(self, index: QtCore.QModelIndex) -> QtCore.QRect: ...
    def rowsInserted(self, parent: QtCore.QModelIndex, start: int, end: int) -> None: ...
    def dataChanged(self, topLeft: QtCore.QModelIndex, bottomRight: QtCore.QModelIndex) -> None: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def updateGeometries(self) -> None: ...
    def verticalOffset(self) -> int: ...
    def horizontalOffset(self) -> int: ...
    def sectionSizeFromContents(self, logicalIndex: int) -> QtCore.QSize: ...
    def paintSection(self, painter: 'QPainter', rect: QtCore.QRect, logicalIndex: int) -> None: ...
    def mouseDoubleClickEvent(self, e: QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, e: QMouseEvent) -> None: ...
    def mouseMoveEvent(self, e: QMouseEvent) -> None: ...
    def mousePressEvent(self, e: QMouseEvent) -> None: ...
    def paintEvent(self, e: QPaintEvent) -> None: ...
    def viewportEvent(self, e: QtCore.QEvent) -> bool: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def currentChanged(self, current: QtCore.QModelIndex, old: QtCore.QModelIndex) -> None: ...
    @typing.overload
    def initializeSections(self) -> None: ...
    @typing.overload
    def initializeSections(self, start: int, end: int) -> None: ...
    def initialize(self) -> None: ...
    def sectionsAboutToBeRemoved(self, parent: QtCore.QModelIndex, logicalFirst: int, logicalLast: int) -> None: ...
    def sectionsInserted(self, parent: QtCore.QModelIndex, logicalFirst: int, logicalLast: int) -> None: ...
    @typing.overload
    def resizeSections(self) -> None: ...
    @typing.overload
    def resizeSections(self, mode: 'QHeaderView.ResizeMode') -> None: ...
    def updateSection(self, logicalIndex: int) -> None: ...
    def sectionAutoResize(self, logicalIndex: int, mode: 'QHeaderView.ResizeMode') -> None: ...
    def sectionHandleDoubleClicked(self, logicalIndex: int) -> None: ...
    def sectionCountChanged(self, oldCount: int, newCount: int) -> None: ...
    def sectionDoubleClicked(self, logicalIndex: int) -> None: ...
    def sectionClicked(self, logicalIndex: int) -> None: ...
    def sectionPressed(self, logicalIndex: int) -> None: ...
    def sectionResized(self, logicalIndex: int, oldSize: int, newSize: int) -> None: ...
    def sectionMoved(self, logicalIndex: int, oldVisualIndex: int, newVisualIndex: int) -> None: ...
    def geometriesChanged(self) -> None: ...
    def setOffsetToSectionPosition(self, visualIndex: int) -> None: ...
    def headerDataChanged(self, orientation: QtCore.Qt.Orientation, logicalFirst: int, logicalLast: int) -> None: ...
    def setOffset(self, offset: int) -> None: ...
    def sectionsMoved(self) -> bool: ...
    def setStretchLastSection(self, stretch: bool) -> None: ...
    def stretchLastSection(self) -> bool: ...
    def sortIndicatorOrder(self) -> QtCore.Qt.SortOrder: ...
    def sortIndicatorSection(self) -> int: ...
    def setSortIndicator(self, logicalIndex: int, order: QtCore.Qt.SortOrder) -> None: ...
    def isSortIndicatorShown(self) -> bool: ...
    def setSortIndicatorShown(self, show: bool) -> None: ...
    def stretchSectionCount(self) -> int: ...
    def resizeMode(self, logicalIndex: int) -> 'QHeaderView.ResizeMode': ...
    @typing.overload
    def setResizeMode(self, mode: 'QHeaderView.ResizeMode') -> None: ...
    @typing.overload
    def setResizeMode(self, logicalIndex: int, mode: 'QHeaderView.ResizeMode') -> None: ...
    def highlightSections(self) -> bool: ...
    def setHighlightSections(self, highlight: bool) -> None: ...
    def isClickable(self) -> bool: ...
    def setClickable(self, clickable: bool) -> None: ...
    def isMovable(self) -> bool: ...
    def setMovable(self, movable: bool) -> None: ...
    def logicalIndex(self, visualIndex: int) -> int: ...
    def visualIndex(self, logicalIndex: int) -> int: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def setSectionHidden(self, logicalIndex: int, hide: bool) -> None: ...
    def isSectionHidden(self, logicalIndex: int) -> bool: ...
    def resizeSection(self, logicalIndex: int, size: int) -> None: ...
    def moveSection(self, from_: int, to: int) -> None: ...
    def sectionViewportPosition(self, logicalIndex: int) -> int: ...
    def sectionPosition(self, logicalIndex: int) -> int: ...
    def sectionSize(self, logicalIndex: int) -> int: ...
    @typing.overload
    def logicalIndexAt(self, position: int) -> int: ...
    @typing.overload
    def logicalIndexAt(self, ax: int, ay: int) -> int: ...
    @typing.overload
    def logicalIndexAt(self, apos: QtCore.QPoint) -> int: ...
    def visualIndexAt(self, position: int) -> int: ...
    def sectionSizeHint(self, logicalIndex: int) -> int: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def length(self) -> int: ...
    def offset(self) -> int: ...
    def orientation(self) -> QtCore.Qt.Orientation: ...
    def setModel(self, model: QtCore.QAbstractItemModel) -> None: ...


class QIcon(sip.wrapper):

    class State(int): ...
    On = ... # type: 'QIcon.State'
    Off = ... # type: 'QIcon.State'

    class Mode(int): ...
    Normal = ... # type: 'QIcon.Mode'
    Disabled = ... # type: 'QIcon.Mode'
    Active = ... # type: 'QIcon.Mode'
    Selected = ... # type: 'QIcon.Mode'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, pixmap: QPixmap) -> None: ...
    @typing.overload
    def __init__(self, other: 'QIcon') -> None: ...
    @typing.overload
    def __init__(self, fileName: str) -> None: ...
    @typing.overload
    def __init__(self, engine: 'QIconEngine') -> None: ...
    @typing.overload
    def __init__(self, engine: 'QIconEngineV2') -> None: ...
    @typing.overload
    def __init__(self, variant: typing.Any) -> None: ...

    def swap(self, other: 'QIcon') -> None: ...
    def name(self) -> str: ...
    @staticmethod
    def setThemeName(path: str) -> None: ...
    @staticmethod
    def themeName() -> str: ...
    @staticmethod
    def setThemeSearchPaths(searchpath: typing.Sequence[str]) -> None: ...
    @staticmethod
    def themeSearchPaths() -> typing.List[str]: ...
    @staticmethod
    def hasThemeIcon(name: str) -> bool: ...
    @staticmethod
    def fromTheme(name: str, fallback: 'QIcon' = ...) -> 'QIcon': ...
    def cacheKey(self) -> int: ...
    def addFile(self, fileName: str, size: QtCore.QSize = ..., mode: 'QIcon.Mode' = ..., state: 'QIcon.State' = ...) -> None: ...
    def addPixmap(self, pixmap: QPixmap, mode: 'QIcon.Mode' = ..., state: 'QIcon.State' = ...) -> None: ...
    def serialNumber(self) -> int: ...
    def isDetached(self) -> bool: ...
    def isNull(self) -> bool: ...
    @typing.overload
    def paint(self, painter: 'QPainter', rect: QtCore.QRect, alignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag] = ..., mode: 'QIcon.Mode' = ..., state: 'QIcon.State' = ...) -> None: ...
    @typing.overload
    def paint(self, painter: 'QPainter', x: int, y: int, w: int, h: int, alignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag] = ..., mode: 'QIcon.Mode' = ..., state: 'QIcon.State' = ...) -> None: ...
    def availableSizes(self, mode: 'QIcon.Mode' = ..., state: 'QIcon.State' = ...) -> typing.List[QtCore.QSize]: ...
    def actualSize(self, size: QtCore.QSize, mode: 'QIcon.Mode' = ..., state: 'QIcon.State' = ...) -> QtCore.QSize: ...
    @typing.overload
    def pixmap(self, size: QtCore.QSize, mode: 'QIcon.Mode' = ..., state: 'QIcon.State' = ...) -> QPixmap: ...
    @typing.overload
    def pixmap(self, w: int, h: int, mode: 'QIcon.Mode' = ..., state: 'QIcon.State' = ...) -> QPixmap: ...
    @typing.overload
    def pixmap(self, extent: int, mode: 'QIcon.Mode' = ..., state: 'QIcon.State' = ...) -> QPixmap: ...


class QIconEngine(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QIconEngine') -> None: ...

    def addFile(self, fileName: str, size: QtCore.QSize, mode: QIcon.Mode, state: QIcon.State) -> None: ...
    def addPixmap(self, pixmap: QPixmap, mode: QIcon.Mode, state: QIcon.State) -> None: ...
    def pixmap(self, size: QtCore.QSize, mode: QIcon.Mode, state: QIcon.State) -> QPixmap: ...
    def actualSize(self, size: QtCore.QSize, mode: QIcon.Mode, state: QIcon.State) -> QtCore.QSize: ...
    def paint(self, painter: 'QPainter', rect: QtCore.QRect, mode: QIcon.Mode, state: QIcon.State) -> None: ...


class QIconEngineV2(QIconEngine):

    class IconEngineHook(int): ...
    AvailableSizesHook = ... # type: 'QIconEngineV2.IconEngineHook'
    IconNameHook = ... # type: 'QIconEngineV2.IconEngineHook'

    class AvailableSizesArgument(sip.simplewrapper):

        mode = ... # type: QIcon.Mode
        sizes = ... # type: typing.Sequence[QtCore.QSize]
        state = ... # type: QIcon.State

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QIconEngineV2.AvailableSizesArgument') -> None: ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QIconEngineV2') -> None: ...

    def iconName(self) -> str: ...
    def availableSizes(self, mode: QIcon.Mode = ..., state: QIcon.State = ...) -> typing.List[QtCore.QSize]: ...
    def write(self, out: QtCore.QDataStream) -> bool: ...
    def read(self, in_: QtCore.QDataStream) -> bool: ...
    def clone(self) -> 'QIconEngineV2': ...
    def key(self) -> str: ...


class QIdentityProxyModel(QAbstractProxyModel):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def removeRows(self, row: int, count: int, parent: QtCore.QModelIndex = ...) -> bool: ...
    def removeColumns(self, column: int, count: int, parent: QtCore.QModelIndex = ...) -> bool: ...
    def insertRows(self, row: int, count: int, parent: QtCore.QModelIndex = ...) -> bool: ...
    def insertColumns(self, column: int, count: int, parent: QtCore.QModelIndex = ...) -> bool: ...
    def setSourceModel(self, sourceModel: QtCore.QAbstractItemModel) -> None: ...
    def match(self, start: QtCore.QModelIndex, role: int, value: typing.Any, hits: int = ..., flags: typing.Union[QtCore.Qt.MatchFlags, QtCore.Qt.MatchFlag] = ...) -> typing.List[QtCore.QModelIndex]: ...
    def mapSelectionToSource(self, selection: 'QItemSelection') -> 'QItemSelection': ...
    def mapSelectionFromSource(self, selection: 'QItemSelection') -> 'QItemSelection': ...
    def dropMimeData(self, data: QtCore.QMimeData, action: QtCore.Qt.DropAction, row: int, column: int, parent: QtCore.QModelIndex) -> bool: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def parent(self, child: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def mapToSource(self, proxyIndex: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def mapFromSource(self, sourceIndex: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def index(self, row: int, column: int, parent: QtCore.QModelIndex = ...) -> QtCore.QModelIndex: ...
    def columnCount(self, parent: QtCore.QModelIndex = ...) -> int: ...


class QImage(QPaintDevice):

    class Format(int): ...
    Format_Invalid = ... # type: 'QImage.Format'
    Format_Mono = ... # type: 'QImage.Format'
    Format_MonoLSB = ... # type: 'QImage.Format'
    Format_Indexed8 = ... # type: 'QImage.Format'
    Format_RGB32 = ... # type: 'QImage.Format'
    Format_ARGB32 = ... # type: 'QImage.Format'
    Format_ARGB32_Premultiplied = ... # type: 'QImage.Format'
    Format_RGB16 = ... # type: 'QImage.Format'
    Format_ARGB8565_Premultiplied = ... # type: 'QImage.Format'
    Format_RGB666 = ... # type: 'QImage.Format'
    Format_ARGB6666_Premultiplied = ... # type: 'QImage.Format'
    Format_RGB555 = ... # type: 'QImage.Format'
    Format_ARGB8555_Premultiplied = ... # type: 'QImage.Format'
    Format_RGB888 = ... # type: 'QImage.Format'
    Format_RGB444 = ... # type: 'QImage.Format'
    Format_ARGB4444_Premultiplied = ... # type: 'QImage.Format'

    class InvertMode(int): ...
    InvertRgb = ... # type: 'QImage.InvertMode'
    InvertRgba = ... # type: 'QImage.InvertMode'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, size: QtCore.QSize, format: 'QImage.Format') -> None: ...
    @typing.overload
    def __init__(self, width: int, height: int, format: 'QImage.Format') -> None: ...
    @typing.overload
    def __init__(self, data: bytes, width: int, height: int, format: 'QImage.Format') -> None: ...
    @typing.overload
    def __init__(self, data: sip.voidptr, width: int, height: int, format: 'QImage.Format') -> None: ...
    @typing.overload
    def __init__(self, data: bytes, width: int, height: int, bytesPerLine: int, format: 'QImage.Format') -> None: ...
    @typing.overload
    def __init__(self, data: sip.voidptr, width: int, height: int, bytesPerLine: int, format: 'QImage.Format') -> None: ...
    @typing.overload
    def __init__(self, xpm: typing.List[str]) -> None: ...
    @typing.overload
    def __init__(self, fileName: str, format: typing.Optional[str] = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QImage') -> None: ...
    @typing.overload
    def __init__(self, variant: typing.Any) -> None: ...

    def swap(self, other: 'QImage') -> None: ...
    def bitPlaneCount(self) -> int: ...
    def byteCount(self) -> int: ...
    def setColorCount(self, a0: int) -> None: ...
    def colorCount(self) -> int: ...
    def cacheKey(self) -> int: ...
    def createMaskFromColor(self, color: int, mode: QtCore.Qt.MaskMode = ...) -> 'QImage': ...
    def metric(self, metric: QPaintDevice.PaintDeviceMetric) -> int: ...
    def setText(self, key: str, value: str) -> None: ...
    def text(self, key: str = ...) -> str: ...
    def textKeys(self) -> typing.List[str]: ...
    def setOffset(self, a0: QtCore.QPoint) -> None: ...
    def offset(self) -> QtCore.QPoint: ...
    def setDotsPerMeterY(self, a0: int) -> None: ...
    def setDotsPerMeterX(self, a0: int) -> None: ...
    def dotsPerMeterY(self) -> int: ...
    def dotsPerMeterX(self) -> int: ...
    def paintEngine(self) -> 'QPaintEngine': ...
    def serialNumber(self) -> int: ...
    @typing.overload
    @staticmethod
    def fromData(data: bytes, format: typing.Optional[str] = ...) -> 'QImage': ...
    @typing.overload
    @staticmethod
    def fromData(data: typing.Union[QtCore.QByteArray, bytes, bytearray], format: typing.Optional[str] = ...) -> 'QImage': ...
    @typing.overload
    def save(self, fileName: str, format: typing.Optional[str] = ..., quality: int = ...) -> bool: ...
    @typing.overload
    def save(self, device: QtCore.QIODevice, format: typing.Optional[str] = ..., quality: int = ...) -> bool: ...
    @typing.overload
    def loadFromData(self, data: bytes, format: typing.Optional[str] = ...) -> bool: ...
    @typing.overload
    def loadFromData(self, data: typing.Union[QtCore.QByteArray, bytes, bytearray], format: typing.Optional[str] = ...) -> bool: ...
    @typing.overload
    def load(self, device: QtCore.QIODevice, format: str) -> bool: ...
    @typing.overload
    def load(self, fileName: str, format: typing.Optional[str] = ...) -> bool: ...
    def invertPixels(self, mode: 'QImage.InvertMode' = ...) -> None: ...
    def rgbSwapped(self) -> 'QImage': ...
    def mirrored(self, horizontal: bool = ..., vertical: bool = ...) -> 'QImage': ...
    @typing.overload
    @staticmethod
    def trueMatrix(a0: 'QMatrix', w: int, h: int) -> 'QMatrix': ...
    @typing.overload
    @staticmethod
    def trueMatrix(a0: 'QTransform', w: int, h: int) -> 'QTransform': ...
    @typing.overload
    def transformed(self, matrix: 'QMatrix', mode: QtCore.Qt.TransformationMode = ...) -> 'QImage': ...
    @typing.overload
    def transformed(self, matrix: 'QTransform', mode: QtCore.Qt.TransformationMode = ...) -> 'QImage': ...
    def scaledToHeight(self, height: int, mode: QtCore.Qt.TransformationMode = ...) -> 'QImage': ...
    def scaledToWidth(self, width: int, mode: QtCore.Qt.TransformationMode = ...) -> 'QImage': ...
    @typing.overload
    def scaled(self, width: int, height: int, aspectRatioMode: QtCore.Qt.AspectRatioMode = ..., transformMode: QtCore.Qt.TransformationMode = ...) -> 'QImage': ...
    @typing.overload
    def scaled(self, size: QtCore.QSize, aspectRatioMode: QtCore.Qt.AspectRatioMode = ..., transformMode: QtCore.Qt.TransformationMode = ...) -> 'QImage': ...
    def createHeuristicMask(self, clipTight: bool = ...) -> 'QImage': ...
    def createAlphaMask(self, flags: typing.Union[QtCore.Qt.ImageConversionFlags, QtCore.Qt.ImageConversionFlag] = ...) -> 'QImage': ...
    def alphaChannel(self) -> 'QImage': ...
    def setAlphaChannel(self, alphaChannel: 'QImage') -> None: ...
    def hasAlphaChannel(self) -> bool: ...
    @typing.overload
    def fill(self, color: QtCore.Qt.GlobalColor) -> None: ...
    @typing.overload
    def fill(self, color: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    @typing.overload
    def fill(self, pixel: int) -> None: ...
    def setColorTable(self, colors: typing.List[int]) -> None: ...
    def colorTable(self) -> typing.List[int]: ...
    @typing.overload
    def setPixel(self, pt: QtCore.QPoint, index_or_rgb: int) -> None: ...
    @typing.overload
    def setPixel(self, x: int, y: int, index_or_rgb: int) -> None: ...
    @typing.overload
    def pixel(self, pt: QtCore.QPoint) -> int: ...
    @typing.overload
    def pixel(self, x: int, y: int) -> int: ...
    @typing.overload
    def pixelIndex(self, pt: QtCore.QPoint) -> int: ...
    @typing.overload
    def pixelIndex(self, x: int, y: int) -> int: ...
    @typing.overload
    def valid(self, pt: QtCore.QPoint) -> bool: ...
    @typing.overload
    def valid(self, x: int, y: int) -> bool: ...
    def bytesPerLine(self) -> int: ...
    def constScanLine(self, a0: int) -> sip.voidptr: ...
    def scanLine(self, a0: int) -> sip.voidptr: ...
    def numBytes(self) -> int: ...
    def constBits(self) -> sip.voidptr: ...
    def bits(self) -> sip.voidptr: ...
    def isGrayscale(self) -> bool: ...
    def allGray(self) -> bool: ...
    def setNumColors(self, a0: int) -> None: ...
    def setColor(self, i: int, c: int) -> None: ...
    def color(self, i: int) -> int: ...
    def numColors(self) -> int: ...
    def depth(self) -> int: ...
    def rect(self) -> QtCore.QRect: ...
    def size(self) -> QtCore.QSize: ...
    def height(self) -> int: ...
    def width(self) -> int: ...
    @typing.overload
    def convertToFormat(self, format: 'QImage.Format', flags: typing.Union[QtCore.Qt.ImageConversionFlags, QtCore.Qt.ImageConversionFlag] = ...) -> 'QImage': ...
    @typing.overload
    def convertToFormat(self, format: 'QImage.Format', colorTable: typing.List[int], flags: typing.Union[QtCore.Qt.ImageConversionFlags, QtCore.Qt.ImageConversionFlag] = ...) -> 'QImage': ...
    def format(self) -> 'QImage.Format': ...
    @typing.overload
    def copy(self, rect: QtCore.QRect = ...) -> 'QImage': ...
    @typing.overload
    def copy(self, x: int, y: int, w: int, h: int) -> 'QImage': ...
    def isDetached(self) -> bool: ...
    def detach(self) -> None: ...
    def devType(self) -> int: ...
    def isNull(self) -> bool: ...


class QImageIOHandler(sip.simplewrapper):

    class ImageOption(int): ...
    Size = ... # type: 'QImageIOHandler.ImageOption'
    ClipRect = ... # type: 'QImageIOHandler.ImageOption'
    Description = ... # type: 'QImageIOHandler.ImageOption'
    ScaledClipRect = ... # type: 'QImageIOHandler.ImageOption'
    ScaledSize = ... # type: 'QImageIOHandler.ImageOption'
    CompressionRatio = ... # type: 'QImageIOHandler.ImageOption'
    Gamma = ... # type: 'QImageIOHandler.ImageOption'
    Quality = ... # type: 'QImageIOHandler.ImageOption'
    Name = ... # type: 'QImageIOHandler.ImageOption'
    SubType = ... # type: 'QImageIOHandler.ImageOption'
    IncrementalReading = ... # type: 'QImageIOHandler.ImageOption'
    Endianness = ... # type: 'QImageIOHandler.ImageOption'
    Animation = ... # type: 'QImageIOHandler.ImageOption'
    BackgroundColor = ... # type: 'QImageIOHandler.ImageOption'

    def __init__(self) -> None: ...

    def currentImageRect(self) -> QtCore.QRect: ...
    def currentImageNumber(self) -> int: ...
    def nextImageDelay(self) -> int: ...
    def imageCount(self) -> int: ...
    def loopCount(self) -> int: ...
    def jumpToImage(self, imageNumber: int) -> bool: ...
    def jumpToNextImage(self) -> bool: ...
    def supportsOption(self, option: 'QImageIOHandler.ImageOption') -> bool: ...
    def setOption(self, option: 'QImageIOHandler.ImageOption', value: typing.Any) -> None: ...
    def option(self, option: 'QImageIOHandler.ImageOption') -> typing.Any: ...
    def write(self, image: QImage) -> bool: ...
    def read(self, image: QImage) -> bool: ...
    def canRead(self) -> bool: ...
    def name(self) -> QtCore.QByteArray: ...
    def format(self) -> QtCore.QByteArray: ...
    def setFormat(self, format: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    def device(self) -> QtCore.QIODevice: ...
    def setDevice(self, device: QtCore.QIODevice) -> None: ...


class QImageReader(sip.simplewrapper):

    class ImageReaderError(int): ...
    UnknownError = ... # type: 'QImageReader.ImageReaderError'
    FileNotFoundError = ... # type: 'QImageReader.ImageReaderError'
    DeviceError = ... # type: 'QImageReader.ImageReaderError'
    UnsupportedFormatError = ... # type: 'QImageReader.ImageReaderError'
    InvalidDataError = ... # type: 'QImageReader.ImageReaderError'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, device: QtCore.QIODevice, format: typing.Union[QtCore.QByteArray, bytes, bytearray] = ...) -> None: ...
    @typing.overload
    def __init__(self, fileName: str, format: typing.Union[QtCore.QByteArray, bytes, bytearray] = ...) -> None: ...

    def decideFormatFromContent(self) -> bool: ...
    def setDecideFormatFromContent(self, ignored: bool) -> None: ...
    def autoDetectImageFormat(self) -> bool: ...
    def setAutoDetectImageFormat(self, enabled: bool) -> None: ...
    def supportsOption(self, option: QImageIOHandler.ImageOption) -> bool: ...
    def quality(self) -> int: ...
    def setQuality(self, quality: int) -> None: ...
    def supportsAnimation(self) -> bool: ...
    def backgroundColor(self) -> QColor: ...
    def setBackgroundColor(self, color: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def text(self, key: str) -> str: ...
    def textKeys(self) -> typing.List[str]: ...
    @staticmethod
    def supportedImageFormats() -> typing.List[QtCore.QByteArray]: ...
    @typing.overload
    @staticmethod
    def imageFormat(fileName: str) -> QtCore.QByteArray: ...
    @typing.overload
    @staticmethod
    def imageFormat(device: QtCore.QIODevice) -> QtCore.QByteArray: ...
    @typing.overload
    def imageFormat(self) -> QImage.Format: ...
    def errorString(self) -> str: ...
    def error(self) -> 'QImageReader.ImageReaderError': ...
    def currentImageRect(self) -> QtCore.QRect: ...
    def currentImageNumber(self) -> int: ...
    def nextImageDelay(self) -> int: ...
    def imageCount(self) -> int: ...
    def loopCount(self) -> int: ...
    def jumpToImage(self, imageNumber: int) -> bool: ...
    def jumpToNextImage(self) -> bool: ...
    @typing.overload
    def read(self) -> QImage: ...
    @typing.overload
    def read(self, image: QImage) -> bool: ...
    def canRead(self) -> bool: ...
    def scaledClipRect(self) -> QtCore.QRect: ...
    def setScaledClipRect(self, rect: QtCore.QRect) -> None: ...
    def scaledSize(self) -> QtCore.QSize: ...
    def setScaledSize(self, size: QtCore.QSize) -> None: ...
    def clipRect(self) -> QtCore.QRect: ...
    def setClipRect(self, rect: QtCore.QRect) -> None: ...
    def size(self) -> QtCore.QSize: ...
    def fileName(self) -> str: ...
    def setFileName(self, fileName: str) -> None: ...
    def device(self) -> QtCore.QIODevice: ...
    def setDevice(self, device: QtCore.QIODevice) -> None: ...
    def format(self) -> QtCore.QByteArray: ...
    def setFormat(self, format: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...


class QImageWriter(sip.simplewrapper):

    class ImageWriterError(int): ...
    UnknownError = ... # type: 'QImageWriter.ImageWriterError'
    DeviceError = ... # type: 'QImageWriter.ImageWriterError'
    UnsupportedFormatError = ... # type: 'QImageWriter.ImageWriterError'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, device: QtCore.QIODevice, format: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    @typing.overload
    def __init__(self, fileName: str, format: typing.Union[QtCore.QByteArray, bytes, bytearray] = ...) -> None: ...

    def compression(self) -> int: ...
    def setCompression(self, compression: int) -> None: ...
    def supportsOption(self, option: QImageIOHandler.ImageOption) -> bool: ...
    def setText(self, key: str, text: str) -> None: ...
    @staticmethod
    def supportedImageFormats() -> typing.List[QtCore.QByteArray]: ...
    def errorString(self) -> str: ...
    def error(self) -> 'QImageWriter.ImageWriterError': ...
    def write(self, image: QImage) -> bool: ...
    def canWrite(self) -> bool: ...
    def description(self) -> str: ...
    def setDescription(self, description: str) -> None: ...
    def gamma(self) -> float: ...
    def setGamma(self, gamma: float) -> None: ...
    def quality(self) -> int: ...
    def setQuality(self, quality: int) -> None: ...
    def fileName(self) -> str: ...
    def setFileName(self, fileName: str) -> None: ...
    def device(self) -> QtCore.QIODevice: ...
    def setDevice(self, device: QtCore.QIODevice) -> None: ...
    def format(self) -> QtCore.QByteArray: ...
    def setFormat(self, format: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...


class QInputContext(QtCore.QObject):

    class StandardFormat(int): ...
    PreeditFormat = ... # type: 'QInputContext.StandardFormat'
    SelectionFormat = ... # type: 'QInputContext.StandardFormat'

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def standardFormat(self, s: 'QInputContext.StandardFormat') -> 'QTextFormat': ...
    def sendEvent(self, event: QInputMethodEvent) -> None: ...
    def filterEvent(self, event: QtCore.QEvent) -> bool: ...
    def actions(self) -> typing.List[QAction]: ...
    def widgetDestroyed(self, w: QWidget) -> None: ...
    def setFocusWidget(self, w: QWidget) -> None: ...
    def focusWidget(self) -> QWidget: ...
    def isComposing(self) -> bool: ...
    def font(self) -> QFont: ...
    def mouseHandler(self, x: int, event: QMouseEvent) -> None: ...
    def update(self) -> None: ...
    def reset(self) -> None: ...
    def language(self) -> str: ...
    def identifierName(self) -> str: ...


class QInputContextFactory(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QInputContextFactory') -> None: ...

    @staticmethod
    def description(key: str) -> str: ...
    @staticmethod
    def displayName(key: str) -> str: ...
    @staticmethod
    def languages(key: str) -> typing.List[str]: ...
    @staticmethod
    def create(key: str, parent: QtCore.QObject) -> QInputContext: ...
    @staticmethod
    def keys() -> typing.List[str]: ...


class QInputDialog(QDialog):

    class InputMode(int): ...
    TextInput = ... # type: 'QInputDialog.InputMode'
    IntInput = ... # type: 'QInputDialog.InputMode'
    DoubleInput = ... # type: 'QInputDialog.InputMode'

    class InputDialogOption(int): ...
    NoButtons = ... # type: 'QInputDialog.InputDialogOption'
    UseListViewForComboBoxItems = ... # type: 'QInputDialog.InputDialogOption'

    class InputDialogOptions(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QInputDialog.InputDialogOptions', 'QInputDialog.InputDialogOption']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QInputDialog.InputDialogOptions') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QInputDialog.InputDialogOptions': ...
        def __int__(self) -> int: ...

    def __init__(self, parent: typing.Optional[QWidget] = ..., flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def doubleValueSelected(self, value: float) -> None: ...
    def doubleValueChanged(self, value: float) -> None: ...
    def intValueSelected(self, value: int) -> None: ...
    def intValueChanged(self, value: int) -> None: ...
    def textValueSelected(self, text: str) -> None: ...
    def textValueChanged(self, text: str) -> None: ...
    def done(self, result: int) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    @typing.overload
    def open(self) -> None: ...
    @typing.overload
    def open(self, receiver: QtCore.QObject, member: QT_SLOT) -> None: ...
    @typing.overload
    def open(self, slot: PYQT_SLOT) -> None: ...
    def cancelButtonText(self) -> str: ...
    def setCancelButtonText(self, text: str) -> None: ...
    def okButtonText(self) -> str: ...
    def setOkButtonText(self, text: str) -> None: ...
    def doubleDecimals(self) -> int: ...
    def setDoubleDecimals(self, decimals: int) -> None: ...
    def setDoubleRange(self, min: float, max: float) -> None: ...
    def doubleMaximum(self) -> float: ...
    def setDoubleMaximum(self, max: float) -> None: ...
    def doubleMinimum(self) -> float: ...
    def setDoubleMinimum(self, min: float) -> None: ...
    def doubleValue(self) -> float: ...
    def setDoubleValue(self, value: float) -> None: ...
    def intStep(self) -> int: ...
    def setIntStep(self, step: int) -> None: ...
    def setIntRange(self, min: int, max: int) -> None: ...
    def intMaximum(self) -> int: ...
    def setIntMaximum(self, max: int) -> None: ...
    def intMinimum(self) -> int: ...
    def setIntMinimum(self, min: int) -> None: ...
    def intValue(self) -> int: ...
    def setIntValue(self, value: int) -> None: ...
    def comboBoxItems(self) -> typing.List[str]: ...
    def setComboBoxItems(self, items: typing.Sequence[str]) -> None: ...
    def isComboBoxEditable(self) -> bool: ...
    def setComboBoxEditable(self, editable: bool) -> None: ...
    def textEchoMode(self) -> 'QLineEdit.EchoMode': ...
    def setTextEchoMode(self, mode: 'QLineEdit.EchoMode') -> None: ...
    def textValue(self) -> str: ...
    def setTextValue(self, text: str) -> None: ...
    def options(self) -> 'QInputDialog.InputDialogOptions': ...
    def setOptions(self, options: 'QInputDialog.InputDialogOptions') -> None: ...
    def testOption(self, option: 'QInputDialog.InputDialogOption') -> bool: ...
    def setOption(self, option: 'QInputDialog.InputDialogOption', on: bool = ...) -> None: ...
    def labelText(self) -> str: ...
    def setLabelText(self, text: str) -> None: ...
    def inputMode(self) -> 'QInputDialog.InputMode': ...
    def setInputMode(self, mode: 'QInputDialog.InputMode') -> None: ...
    @typing.overload
    @staticmethod
    def getItem(parent: QWidget, title: str, label: str, list: typing.Sequence[str], current: int = ..., editable: bool = ..., flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> typing.Tuple[str, bool]: ...
    @typing.overload
    @staticmethod
    def getItem(parent: QWidget, title: str, label: str, list: typing.Sequence[str], current: int, editable: bool, flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType], inputMethodHints: typing.Union[QtCore.Qt.InputMethodHints, QtCore.Qt.InputMethodHint]) -> typing.Tuple[str, bool]: ...
    @staticmethod
    def getDouble(parent: QWidget, title: str, label: str, value: float = ..., min: float = ..., max: float = ..., decimals: int = ..., flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> typing.Tuple[float, bool]: ...
    @staticmethod
    def getInteger(parent: QWidget, title: str, label: str, value: int = ..., min: int = ..., max: int = ..., step: int = ..., flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> typing.Tuple[int, bool]: ...
    @staticmethod
    def getInt(parent: QWidget, title: str, label: str, value: int = ..., min: int = ..., max: int = ..., step: int = ..., flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> typing.Tuple[int, bool]: ...
    @typing.overload
    @staticmethod
    def getText(parent: QWidget, title: str, label: str, mode: 'QLineEdit.EchoMode' = ..., text: str = ..., flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> typing.Tuple[str, bool]: ...
    @typing.overload
    @staticmethod
    def getText(parent: QWidget, title: str, label: str, mode: 'QLineEdit.EchoMode', text: str, flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType], inputMethodHints: typing.Union[QtCore.Qt.InputMethodHints, QtCore.Qt.InputMethodHint]) -> typing.Tuple[str, bool]: ...


class QItemDelegate(QAbstractItemDelegate):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def editorEvent(self, event: QtCore.QEvent, model: QtCore.QAbstractItemModel, option: 'QStyleOptionViewItem', index: QtCore.QModelIndex) -> bool: ...
    def eventFilter(self, object: QtCore.QObject, event: QtCore.QEvent) -> bool: ...
    def drawFocus(self, painter: 'QPainter', option: 'QStyleOptionViewItem', rect: QtCore.QRect) -> None: ...
    def drawDisplay(self, painter: 'QPainter', option: 'QStyleOptionViewItem', rect: QtCore.QRect, text: str) -> None: ...
    def drawDecoration(self, painter: 'QPainter', option: 'QStyleOptionViewItem', rect: QtCore.QRect, pixmap: QPixmap) -> None: ...
    def drawCheck(self, painter: 'QPainter', option: 'QStyleOptionViewItem', rect: QtCore.QRect, state: QtCore.Qt.CheckState) -> None: ...
    def drawBackground(self, painter: 'QPainter', option: 'QStyleOptionViewItem', index: QtCore.QModelIndex) -> None: ...
    def setClipping(self, clip: bool) -> None: ...
    def hasClipping(self) -> bool: ...
    def setItemEditorFactory(self, factory: 'QItemEditorFactory') -> None: ...
    def itemEditorFactory(self) -> 'QItemEditorFactory': ...
    def updateEditorGeometry(self, editor: QWidget, option: 'QStyleOptionViewItem', index: QtCore.QModelIndex) -> None: ...
    def setModelData(self, editor: QWidget, model: QtCore.QAbstractItemModel, index: QtCore.QModelIndex) -> None: ...
    def setEditorData(self, editor: QWidget, index: QtCore.QModelIndex) -> None: ...
    def createEditor(self, parent: QWidget, option: 'QStyleOptionViewItem', index: QtCore.QModelIndex) -> QWidget: ...
    def sizeHint(self, option: 'QStyleOptionViewItem', index: QtCore.QModelIndex) -> QtCore.QSize: ...
    def paint(self, painter: 'QPainter', option: 'QStyleOptionViewItem', index: QtCore.QModelIndex) -> None: ...


class QItemEditorCreatorBase(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QItemEditorCreatorBase') -> None: ...

    def valuePropertyName(self) -> QtCore.QByteArray: ...
    def createWidget(self, parent: QWidget) -> QWidget: ...


class QItemEditorFactory(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QItemEditorFactory') -> None: ...

    @staticmethod
    def setDefaultFactory(factory: 'QItemEditorFactory') -> None: ...
    @staticmethod
    def defaultFactory() -> 'QItemEditorFactory': ...
    def registerEditor(self, type: QtCore.QVariant.Type, creator: QItemEditorCreatorBase) -> None: ...
    def valuePropertyName(self, type: QtCore.QVariant.Type) -> QtCore.QByteArray: ...
    def createEditor(self, type: QtCore.QVariant.Type, parent: QWidget) -> QWidget: ...


class QItemSelectionRange(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QItemSelectionRange') -> None: ...
    @typing.overload
    def __init__(self, atopLeft: QtCore.QModelIndex, abottomRight: QtCore.QModelIndex) -> None: ...
    @typing.overload
    def __init__(self, index: QtCore.QModelIndex) -> None: ...

    def isEmpty(self) -> bool: ...
    def __hash__(self) -> int: ...
    def intersected(self, other: 'QItemSelectionRange') -> 'QItemSelectionRange': ...
    def indexes(self) -> typing.List[QtCore.QModelIndex]: ...
    def isValid(self) -> bool: ...
    def intersect(self, other: 'QItemSelectionRange') -> 'QItemSelectionRange': ...
    def intersects(self, other: 'QItemSelectionRange') -> bool: ...
    @typing.overload
    def contains(self, index: QtCore.QModelIndex) -> bool: ...
    @typing.overload
    def contains(self, row: int, column: int, parentIndex: QtCore.QModelIndex) -> bool: ...
    def model(self) -> QtCore.QAbstractItemModel: ...
    def parent(self) -> QtCore.QModelIndex: ...
    def bottomRight(self) -> QtCore.QModelIndex: ...
    def topLeft(self) -> QtCore.QModelIndex: ...
    def height(self) -> int: ...
    def width(self) -> int: ...
    def right(self) -> int: ...
    def bottom(self) -> int: ...
    def left(self) -> int: ...
    def top(self) -> int: ...


class QItemSelectionModel(QtCore.QObject):

    class SelectionFlag(int): ...
    NoUpdate = ... # type: 'QItemSelectionModel.SelectionFlag'
    Clear = ... # type: 'QItemSelectionModel.SelectionFlag'
    Select = ... # type: 'QItemSelectionModel.SelectionFlag'
    Deselect = ... # type: 'QItemSelectionModel.SelectionFlag'
    Toggle = ... # type: 'QItemSelectionModel.SelectionFlag'
    Current = ... # type: 'QItemSelectionModel.SelectionFlag'
    Rows = ... # type: 'QItemSelectionModel.SelectionFlag'
    Columns = ... # type: 'QItemSelectionModel.SelectionFlag'
    SelectCurrent = ... # type: 'QItemSelectionModel.SelectionFlag'
    ToggleCurrent = ... # type: 'QItemSelectionModel.SelectionFlag'
    ClearAndSelect = ... # type: 'QItemSelectionModel.SelectionFlag'

    class SelectionFlags(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QItemSelectionModel.SelectionFlags', 'QItemSelectionModel.SelectionFlag']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QItemSelectionModel.SelectionFlags') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QItemSelectionModel.SelectionFlags': ...
        def __int__(self) -> int: ...

    @typing.overload
    def __init__(self, model: QtCore.QAbstractItemModel) -> None: ...
    @typing.overload
    def __init__(self, model: QtCore.QAbstractItemModel, parent: QtCore.QObject) -> None: ...

    def selectedColumns(self, row: int = ...) -> typing.List[QtCore.QModelIndex]: ...
    def selectedRows(self, column: int = ...) -> typing.List[QtCore.QModelIndex]: ...
    def hasSelection(self) -> bool: ...
    def emitSelectionChanged(self, newSelection: 'QItemSelection', oldSelection: 'QItemSelection') -> None: ...
    def currentColumnChanged(self, current: QtCore.QModelIndex, previous: QtCore.QModelIndex) -> None: ...
    def currentRowChanged(self, current: QtCore.QModelIndex, previous: QtCore.QModelIndex) -> None: ...
    def currentChanged(self, current: QtCore.QModelIndex, previous: QtCore.QModelIndex) -> None: ...
    def selectionChanged(self, selected: 'QItemSelection', deselected: 'QItemSelection') -> None: ...
    def setCurrentIndex(self, index: QtCore.QModelIndex, command: 'QItemSelectionModel.SelectionFlags') -> None: ...
    @typing.overload
    def select(self, index: QtCore.QModelIndex, command: 'QItemSelectionModel.SelectionFlags') -> None: ...
    @typing.overload
    def select(self, selection: 'QItemSelection', command: 'QItemSelectionModel.SelectionFlags') -> None: ...
    def reset(self) -> None: ...
    def clearSelection(self) -> None: ...
    def clear(self) -> None: ...
    def model(self) -> QtCore.QAbstractItemModel: ...
    def selection(self) -> 'QItemSelection': ...
    def selectedIndexes(self) -> typing.List[QtCore.QModelIndex]: ...
    def columnIntersectsSelection(self, column: int, parent: QtCore.QModelIndex) -> bool: ...
    def rowIntersectsSelection(self, row: int, parent: QtCore.QModelIndex) -> bool: ...
    def isColumnSelected(self, column: int, parent: QtCore.QModelIndex) -> bool: ...
    def isRowSelected(self, row: int, parent: QtCore.QModelIndex) -> bool: ...
    def isSelected(self, index: QtCore.QModelIndex) -> bool: ...
    def currentIndex(self) -> QtCore.QModelIndex: ...


class QItemSelection(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, topLeft: QtCore.QModelIndex, bottomRight: QtCore.QModelIndex) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QItemSelection') -> None: ...

    def lastIndexOf(self, value: QItemSelectionRange, from_: int = ...) -> int: ...
    def indexOf(self, value: QItemSelectionRange, from_: int = ...) -> int: ...
    def last(self) -> QItemSelectionRange: ...
    def first(self) -> QItemSelectionRange: ...
    def __len__(self) -> int: ...
    @typing.overload
    def count(self, range: QItemSelectionRange) -> int: ...
    @typing.overload
    def count(self) -> int: ...
    def swap(self, i: int, j: int) -> None: ...
    def move(self, from_: int, to: int) -> None: ...
    def takeLast(self) -> QItemSelectionRange: ...
    def takeFirst(self) -> QItemSelectionRange: ...
    def takeAt(self, i: int) -> QItemSelectionRange: ...
    def removeAll(self, range: QItemSelectionRange) -> int: ...
    def removeAt(self, i: int) -> None: ...
    def replace(self, i: int, range: QItemSelectionRange) -> None: ...
    def insert(self, i: int, range: QItemSelectionRange) -> None: ...
    def prepend(self, range: QItemSelectionRange) -> None: ...
    def append(self, range: QItemSelectionRange) -> None: ...
    def isEmpty(self) -> bool: ...
    def clear(self) -> None: ...
    @typing.overload
    def __getitem__(self, i: int) -> QItemSelectionRange: ...
    @typing.overload
    def __getitem__(self, slice: slice) -> 'QItemSelection': ...
    @typing.overload
    def __delitem__(self, i: int) -> None: ...
    @typing.overload
    def __delitem__(self, slice: slice) -> None: ...
    @typing.overload
    def __setitem__(self, i: int, range: QItemSelectionRange) -> None: ...
    @typing.overload
    def __setitem__(self, slice: slice, list: 'QItemSelection') -> None: ...
    @staticmethod
    def split(range: QItemSelectionRange, other: QItemSelectionRange, result: 'QItemSelection') -> None: ...
    def merge(self, other: 'QItemSelection', command: QItemSelectionModel.SelectionFlags) -> None: ...
    def indexes(self) -> typing.List[QtCore.QModelIndex]: ...
    def __contains__(self, index: QtCore.QModelIndex) -> int: ...
    def contains(self, index: QtCore.QModelIndex) -> bool: ...
    def select(self, topLeft: QtCore.QModelIndex, bottomRight: QtCore.QModelIndex) -> None: ...


class QKeyEventTransition(QtCore.QEventTransition):

    @typing.overload
    def __init__(self, sourceState: typing.Optional[QtCore.QState] = ...) -> None: ...
    @typing.overload
    def __init__(self, object: QtCore.QObject, type: QtCore.QEvent.Type, key: int, sourceState: typing.Optional[QtCore.QState] = ...) -> None: ...

    def eventTest(self, event: QtCore.QEvent) -> bool: ...
    def onTransition(self, event: QtCore.QEvent) -> None: ...
    def setModifierMask(self, modifiers: typing.Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier]) -> None: ...
    def modifierMask(self) -> QtCore.Qt.KeyboardModifiers: ...
    def setKey(self, key: int) -> None: ...
    def key(self) -> int: ...


class QKeySequence(sip.simplewrapper):

    class StandardKey(int): ...
    UnknownKey = ... # type: 'QKeySequence.StandardKey'
    HelpContents = ... # type: 'QKeySequence.StandardKey'
    WhatsThis = ... # type: 'QKeySequence.StandardKey'
    Open = ... # type: 'QKeySequence.StandardKey'
    Close = ... # type: 'QKeySequence.StandardKey'
    Save = ... # type: 'QKeySequence.StandardKey'
    New = ... # type: 'QKeySequence.StandardKey'
    Delete = ... # type: 'QKeySequence.StandardKey'
    Cut = ... # type: 'QKeySequence.StandardKey'
    Copy = ... # type: 'QKeySequence.StandardKey'
    Paste = ... # type: 'QKeySequence.StandardKey'
    Undo = ... # type: 'QKeySequence.StandardKey'
    Redo = ... # type: 'QKeySequence.StandardKey'
    Back = ... # type: 'QKeySequence.StandardKey'
    Forward = ... # type: 'QKeySequence.StandardKey'
    Refresh = ... # type: 'QKeySequence.StandardKey'
    ZoomIn = ... # type: 'QKeySequence.StandardKey'
    ZoomOut = ... # type: 'QKeySequence.StandardKey'
    Print = ... # type: 'QKeySequence.StandardKey'
    AddTab = ... # type: 'QKeySequence.StandardKey'
    NextChild = ... # type: 'QKeySequence.StandardKey'
    PreviousChild = ... # type: 'QKeySequence.StandardKey'
    Find = ... # type: 'QKeySequence.StandardKey'
    FindNext = ... # type: 'QKeySequence.StandardKey'
    FindPrevious = ... # type: 'QKeySequence.StandardKey'
    Replace = ... # type: 'QKeySequence.StandardKey'
    SelectAll = ... # type: 'QKeySequence.StandardKey'
    Bold = ... # type: 'QKeySequence.StandardKey'
    Italic = ... # type: 'QKeySequence.StandardKey'
    Underline = ... # type: 'QKeySequence.StandardKey'
    MoveToNextChar = ... # type: 'QKeySequence.StandardKey'
    MoveToPreviousChar = ... # type: 'QKeySequence.StandardKey'
    MoveToNextWord = ... # type: 'QKeySequence.StandardKey'
    MoveToPreviousWord = ... # type: 'QKeySequence.StandardKey'
    MoveToNextLine = ... # type: 'QKeySequence.StandardKey'
    MoveToPreviousLine = ... # type: 'QKeySequence.StandardKey'
    MoveToNextPage = ... # type: 'QKeySequence.StandardKey'
    MoveToPreviousPage = ... # type: 'QKeySequence.StandardKey'
    MoveToStartOfLine = ... # type: 'QKeySequence.StandardKey'
    MoveToEndOfLine = ... # type: 'QKeySequence.StandardKey'
    MoveToStartOfBlock = ... # type: 'QKeySequence.StandardKey'
    MoveToEndOfBlock = ... # type: 'QKeySequence.StandardKey'
    MoveToStartOfDocument = ... # type: 'QKeySequence.StandardKey'
    MoveToEndOfDocument = ... # type: 'QKeySequence.StandardKey'
    SelectNextChar = ... # type: 'QKeySequence.StandardKey'
    SelectPreviousChar = ... # type: 'QKeySequence.StandardKey'
    SelectNextWord = ... # type: 'QKeySequence.StandardKey'
    SelectPreviousWord = ... # type: 'QKeySequence.StandardKey'
    SelectNextLine = ... # type: 'QKeySequence.StandardKey'
    SelectPreviousLine = ... # type: 'QKeySequence.StandardKey'
    SelectNextPage = ... # type: 'QKeySequence.StandardKey'
    SelectPreviousPage = ... # type: 'QKeySequence.StandardKey'
    SelectStartOfLine = ... # type: 'QKeySequence.StandardKey'
    SelectEndOfLine = ... # type: 'QKeySequence.StandardKey'
    SelectStartOfBlock = ... # type: 'QKeySequence.StandardKey'
    SelectEndOfBlock = ... # type: 'QKeySequence.StandardKey'
    SelectStartOfDocument = ... # type: 'QKeySequence.StandardKey'
    SelectEndOfDocument = ... # type: 'QKeySequence.StandardKey'
    DeleteStartOfWord = ... # type: 'QKeySequence.StandardKey'
    DeleteEndOfWord = ... # type: 'QKeySequence.StandardKey'
    DeleteEndOfLine = ... # type: 'QKeySequence.StandardKey'
    InsertParagraphSeparator = ... # type: 'QKeySequence.StandardKey'
    InsertLineSeparator = ... # type: 'QKeySequence.StandardKey'
    SaveAs = ... # type: 'QKeySequence.StandardKey'
    Preferences = ... # type: 'QKeySequence.StandardKey'
    Quit = ... # type: 'QKeySequence.StandardKey'

    class SequenceMatch(int): ...
    NoMatch = ... # type: 'QKeySequence.SequenceMatch'
    PartialMatch = ... # type: 'QKeySequence.SequenceMatch'
    ExactMatch = ... # type: 'QKeySequence.SequenceMatch'

    class SequenceFormat(int): ...
    NativeText = ... # type: 'QKeySequence.SequenceFormat'
    PortableText = ... # type: 'QKeySequence.SequenceFormat'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, ks: typing.Union['QKeySequence', 'QKeySequence.StandardKey', str, int]) -> None: ...
    @typing.overload
    def __init__(self, key: str, format: 'QKeySequence.SequenceFormat') -> None: ...
    @typing.overload
    def __init__(self, k1: int, key2: int = ..., key3: int = ..., key4: int = ...) -> None: ...
    @typing.overload
    def __init__(self, variant: typing.Any) -> None: ...

    def swap(self, other: typing.Union['QKeySequence', 'QKeySequence.StandardKey', str, int]) -> None: ...
    @staticmethod
    def keyBindings(key: 'QKeySequence.StandardKey') -> typing.List['QKeySequence']: ...
    @staticmethod
    def fromString(str: str, format: 'QKeySequence.SequenceFormat' = ...) -> 'QKeySequence': ...
    def toString(self, format: 'QKeySequence.SequenceFormat' = ...) -> str: ...
    def isDetached(self) -> bool: ...
    def __getitem__(self, i: int) -> int: ...
    def __int__(self) -> int: ...
    @staticmethod
    def mnemonic(text: str) -> 'QKeySequence': ...
    def matches(self, seq: typing.Union['QKeySequence', 'QKeySequence.StandardKey', str, int]) -> 'QKeySequence.SequenceMatch': ...
    def isEmpty(self) -> bool: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...


class QLabel(QFrame):

    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ..., flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str, parent: typing.Optional[QWidget] = ..., flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def selectionStart(self) -> int: ...
    def selectedText(self) -> str: ...
    def hasSelectedText(self) -> bool: ...
    def setSelection(self, a0: int, a1: int) -> None: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOutEvent(self, ev: QFocusEvent) -> None: ...
    def focusInEvent(self, ev: QFocusEvent) -> None: ...
    def contextMenuEvent(self, ev: QContextMenuEvent) -> None: ...
    def mouseReleaseEvent(self, ev: QMouseEvent) -> None: ...
    def mouseMoveEvent(self, ev: QMouseEvent) -> None: ...
    def mousePressEvent(self, ev: QMouseEvent) -> None: ...
    def keyPressEvent(self, ev: QKeyEvent) -> None: ...
    def changeEvent(self, a0: QtCore.QEvent) -> None: ...
    def paintEvent(self, a0: QPaintEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def linkHovered(self, link: str) -> None: ...
    def linkActivated(self, link: str) -> None: ...
    def setText(self, a0: str) -> None: ...
    def setPixmap(self, a0: QPixmap) -> None: ...
    def setPicture(self, a0: 'QPicture') -> None: ...
    @typing.overload
    def setNum(self, a0: float) -> None: ...
    @typing.overload
    def setNum(self, a0: int) -> None: ...
    def setMovie(self, movie: 'QMovie') -> None: ...
    def clear(self) -> None: ...
    def setOpenExternalLinks(self, open: bool) -> None: ...
    def textInteractionFlags(self) -> QtCore.Qt.TextInteractionFlags: ...
    def setTextInteractionFlags(self, flags: typing.Union[QtCore.Qt.TextInteractionFlags, QtCore.Qt.TextInteractionFlag]) -> None: ...
    def openExternalLinks(self) -> bool: ...
    def heightForWidth(self, a0: int) -> int: ...
    def buddy(self) -> QWidget: ...
    def setBuddy(self, a0: QWidget) -> None: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def setScaledContents(self, a0: bool) -> None: ...
    def hasScaledContents(self) -> bool: ...
    def setMargin(self, a0: int) -> None: ...
    def margin(self) -> int: ...
    def setIndent(self, a0: int) -> None: ...
    def indent(self) -> int: ...
    def wordWrap(self) -> bool: ...
    def setWordWrap(self, on: bool) -> None: ...
    def setAlignment(self, a0: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> None: ...
    def alignment(self) -> QtCore.Qt.Alignment: ...
    def setTextFormat(self, a0: QtCore.Qt.TextFormat) -> None: ...
    def textFormat(self) -> QtCore.Qt.TextFormat: ...
    def movie(self) -> 'QMovie': ...
    def picture(self) -> 'QPicture': ...
    def pixmap(self) -> QPixmap: ...
    def text(self) -> str: ...


class QSpacerItem(QLayoutItem):

    @typing.overload
    def __init__(self, w: int, h: int, hPolicy: 'QSizePolicy.Policy' = ..., vPolicy: 'QSizePolicy.Policy' = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QSpacerItem') -> None: ...

    def spacerItem(self) -> 'QSpacerItem': ...
    def geometry(self) -> QtCore.QRect: ...
    def setGeometry(self, a0: QtCore.QRect) -> None: ...
    def isEmpty(self) -> bool: ...
    def expandingDirections(self) -> QtCore.Qt.Orientations: ...
    def maximumSize(self) -> QtCore.QSize: ...
    def minimumSize(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def changeSize(self, w: int, h: int, hPolicy: 'QSizePolicy.Policy' = ..., vPolicy: 'QSizePolicy.Policy' = ...) -> None: ...


class QWidgetItem(QLayoutItem):

    def __init__(self, w: QWidget) -> None: ...

    def heightForWidth(self, a0: int) -> int: ...
    def hasHeightForWidth(self) -> bool: ...
    def widget(self) -> QWidget: ...
    def geometry(self) -> QtCore.QRect: ...
    def setGeometry(self, a0: QtCore.QRect) -> None: ...
    def isEmpty(self) -> bool: ...
    def expandingDirections(self) -> QtCore.Qt.Orientations: ...
    def maximumSize(self) -> QtCore.QSize: ...
    def minimumSize(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...


class QLCDNumber(QFrame):

    class SegmentStyle(int): ...
    Outline = ... # type: 'QLCDNumber.SegmentStyle'
    Filled = ... # type: 'QLCDNumber.SegmentStyle'
    Flat = ... # type: 'QLCDNumber.SegmentStyle'

    class Mode(int): ...
    Hex = ... # type: 'QLCDNumber.Mode'
    Dec = ... # type: 'QLCDNumber.Mode'
    Oct = ... # type: 'QLCDNumber.Mode'
    Bin = ... # type: 'QLCDNumber.Mode'

    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, numDigits: int, parent: typing.Optional[QWidget] = ...) -> None: ...

    def paintEvent(self, a0: QPaintEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def overflow(self) -> None: ...
    def setSmallDecimalPoint(self, a0: bool) -> None: ...
    def setBinMode(self) -> None: ...
    def setOctMode(self) -> None: ...
    def setDecMode(self) -> None: ...
    def setHexMode(self) -> None: ...
    @typing.overload
    def display(self, str: str) -> None: ...
    @typing.overload
    def display(self, num: float) -> None: ...
    @typing.overload
    def display(self, num: int) -> None: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def intValue(self) -> int: ...
    def value(self) -> float: ...
    def setSegmentStyle(self, a0: 'QLCDNumber.SegmentStyle') -> None: ...
    def segmentStyle(self) -> 'QLCDNumber.SegmentStyle': ...
    def setMode(self, a0: 'QLCDNumber.Mode') -> None: ...
    def mode(self) -> 'QLCDNumber.Mode': ...
    @typing.overload
    def checkOverflow(self, num: float) -> bool: ...
    @typing.overload
    def checkOverflow(self, num: int) -> bool: ...
    def setNumDigits(self, nDigits: int) -> None: ...
    def numDigits(self) -> int: ...
    def setDigitCount(self, nDigits: int) -> None: ...
    def digitCount(self) -> int: ...
    def smallDecimalPoint(self) -> bool: ...


class QLineEdit(QWidget):

    class EchoMode(int): ...
    Normal = ... # type: 'QLineEdit.EchoMode'
    NoEcho = ... # type: 'QLineEdit.EchoMode'
    Password = ... # type: 'QLineEdit.EchoMode'
    PasswordEchoOnEdit = ... # type: 'QLineEdit.EchoMode'

    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, contents: str, parent: typing.Optional[QWidget] = ...) -> None: ...

    def cursorMoveStyle(self) -> QtCore.Qt.CursorMoveStyle: ...
    def setCursorMoveStyle(self, style: QtCore.Qt.CursorMoveStyle) -> None: ...
    def setPlaceholderText(self, a0: str) -> None: ...
    def placeholderText(self) -> str: ...
    def textMargins(self) -> QtCore.QMargins: ...
    def getTextMargins(self) -> typing.Tuple[int, int, int, int]: ...
    @typing.overload
    def setTextMargins(self, left: int, top: int, right: int, bottom: int) -> None: ...
    @typing.overload
    def setTextMargins(self, margins: QtCore.QMargins) -> None: ...
    def completer(self) -> QCompleter: ...
    def setCompleter(self, completer: QCompleter) -> None: ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    def inputMethodQuery(self, a0: QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def cursorRect(self) -> QtCore.QRect: ...
    def inputMethodEvent(self, a0: QInputMethodEvent) -> None: ...
    def contextMenuEvent(self, a0: QContextMenuEvent) -> None: ...
    def changeEvent(self, a0: QtCore.QEvent) -> None: ...
    def dropEvent(self, a0: QDropEvent) -> None: ...
    def dragLeaveEvent(self, e: QDragLeaveEvent) -> None: ...
    def dragMoveEvent(self, e: QDragMoveEvent) -> None: ...
    def dragEnterEvent(self, a0: QDragEnterEvent) -> None: ...
    def paintEvent(self, a0: QPaintEvent) -> None: ...
    def focusOutEvent(self, a0: QFocusEvent) -> None: ...
    def focusInEvent(self, a0: QFocusEvent) -> None: ...
    def keyPressEvent(self, a0: QKeyEvent) -> None: ...
    def mouseDoubleClickEvent(self, a0: QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, a0: QMouseEvent) -> None: ...
    def mouseMoveEvent(self, a0: QMouseEvent) -> None: ...
    def mousePressEvent(self, a0: QMouseEvent) -> None: ...
    def initStyleOption(self, option: 'QStyleOptionFrame') -> None: ...
    def selectionChanged(self) -> None: ...
    def editingFinished(self) -> None: ...
    def returnPressed(self) -> None: ...
    def cursorPositionChanged(self, a0: int, a1: int) -> None: ...
    def textEdited(self, a0: str) -> None: ...
    def textChanged(self, a0: str) -> None: ...
    def createStandardContextMenu(self) -> 'QMenu': ...
    def insert(self, a0: str) -> None: ...
    def deselect(self) -> None: ...
    def paste(self) -> None: ...
    def copy(self) -> None: ...
    def cut(self) -> None: ...
    def redo(self) -> None: ...
    def undo(self) -> None: ...
    def selectAll(self) -> None: ...
    def clear(self) -> None: ...
    def setText(self, a0: str) -> None: ...
    def hasAcceptableInput(self) -> bool: ...
    def setInputMask(self, inputMask: str) -> None: ...
    def inputMask(self) -> str: ...
    def dragEnabled(self) -> bool: ...
    def setDragEnabled(self, b: bool) -> None: ...
    def isRedoAvailable(self) -> bool: ...
    def isUndoAvailable(self) -> bool: ...
    def selectionStart(self) -> int: ...
    def selectedText(self) -> str: ...
    def hasSelectedText(self) -> bool: ...
    def setSelection(self, a0: int, a1: int) -> None: ...
    def setModified(self, a0: bool) -> None: ...
    def isModified(self) -> bool: ...
    def end(self, mark: bool) -> None: ...
    def home(self, mark: bool) -> None: ...
    def del_(self) -> None: ...
    def backspace(self) -> None: ...
    def cursorWordBackward(self, mark: bool) -> None: ...
    def cursorWordForward(self, mark: bool) -> None: ...
    def cursorBackward(self, mark: bool, steps: int = ...) -> None: ...
    def cursorForward(self, mark: bool, steps: int = ...) -> None: ...
    def alignment(self) -> QtCore.Qt.Alignment: ...
    def setAlignment(self, flag: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> None: ...
    def cursorPositionAt(self, pos: QtCore.QPoint) -> int: ...
    def setCursorPosition(self, a0: int) -> None: ...
    def cursorPosition(self) -> int: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def validator(self) -> 'QValidator': ...
    def setValidator(self, a0: 'QValidator') -> None: ...
    def setReadOnly(self, a0: bool) -> None: ...
    def isReadOnly(self) -> bool: ...
    def setEchoMode(self, a0: 'QLineEdit.EchoMode') -> None: ...
    def echoMode(self) -> 'QLineEdit.EchoMode': ...
    def hasFrame(self) -> bool: ...
    def setFrame(self, a0: bool) -> None: ...
    def setMaxLength(self, a0: int) -> None: ...
    def maxLength(self) -> int: ...
    def displayText(self) -> str: ...
    def text(self) -> str: ...


class QListView(QAbstractItemView):

    class ViewMode(int): ...
    ListMode = ... # type: 'QListView.ViewMode'
    IconMode = ... # type: 'QListView.ViewMode'

    class LayoutMode(int): ...
    SinglePass = ... # type: 'QListView.LayoutMode'
    Batched = ... # type: 'QListView.LayoutMode'

    class ResizeMode(int): ...
    Fixed = ... # type: 'QListView.ResizeMode'
    Adjust = ... # type: 'QListView.ResizeMode'

    class Flow(int): ...
    LeftToRight = ... # type: 'QListView.Flow'
    TopToBottom = ... # type: 'QListView.Flow'

    class Movement(int): ...
    Static = ... # type: 'QListView.Movement'
    Free = ... # type: 'QListView.Movement'
    Snap = ... # type: 'QListView.Movement'

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...

    def currentChanged(self, current: QtCore.QModelIndex, previous: QtCore.QModelIndex) -> None: ...
    def selectionChanged(self, selected: QItemSelection, deselected: QItemSelection) -> None: ...
    def isSelectionRectVisible(self) -> bool: ...
    def setSelectionRectVisible(self, show: bool) -> None: ...
    def wordWrap(self) -> bool: ...
    def setWordWrap(self, on: bool) -> None: ...
    def batchSize(self) -> int: ...
    def setBatchSize(self, batchSize: int) -> None: ...
    def isIndexHidden(self, index: QtCore.QModelIndex) -> bool: ...
    def updateGeometries(self) -> None: ...
    def selectedIndexes(self) -> typing.List[QtCore.QModelIndex]: ...
    def visualRegionForSelection(self, selection: QItemSelection) -> 'QRegion': ...
    def setSelection(self, rect: QtCore.QRect, command: QItemSelectionModel.SelectionFlags) -> None: ...
    def setPositionForIndex(self, position: QtCore.QPoint, index: QtCore.QModelIndex) -> None: ...
    def rectForIndex(self, index: QtCore.QModelIndex) -> QtCore.QRect: ...
    def moveCursor(self, cursorAction: QAbstractItemView.CursorAction, modifiers: typing.Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier]) -> QtCore.QModelIndex: ...
    def verticalOffset(self) -> int: ...
    def horizontalOffset(self) -> int: ...
    def paintEvent(self, e: QPaintEvent) -> None: ...
    def viewOptions(self) -> 'QStyleOptionViewItem': ...
    def startDrag(self, supportedActions: typing.Union[QtCore.Qt.DropActions, QtCore.Qt.DropAction]) -> None: ...
    def dropEvent(self, e: QDropEvent) -> None: ...
    def dragLeaveEvent(self, e: QDragLeaveEvent) -> None: ...
    def dragMoveEvent(self, e: QDragMoveEvent) -> None: ...
    def resizeEvent(self, e: QResizeEvent) -> None: ...
    def timerEvent(self, e: QtCore.QTimerEvent) -> None: ...
    def mouseReleaseEvent(self, e: QMouseEvent) -> None: ...
    def mouseMoveEvent(self, e: QMouseEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def rowsAboutToBeRemoved(self, parent: QtCore.QModelIndex, start: int, end: int) -> None: ...
    def rowsInserted(self, parent: QtCore.QModelIndex, start: int, end: int) -> None: ...
    def dataChanged(self, topLeft: QtCore.QModelIndex, bottomRight: QtCore.QModelIndex) -> None: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def indexesMoved(self, indexes: typing.Sequence[QtCore.QModelIndex]) -> None: ...
    def setRootIndex(self, index: QtCore.QModelIndex) -> None: ...
    def reset(self) -> None: ...
    def indexAt(self, p: QtCore.QPoint) -> QtCore.QModelIndex: ...
    def scrollTo(self, index: QtCore.QModelIndex, hint: QAbstractItemView.ScrollHint = ...) -> None: ...
    def visualRect(self, index: QtCore.QModelIndex) -> QtCore.QRect: ...
    def uniformItemSizes(self) -> bool: ...
    def setUniformItemSizes(self, enable: bool) -> None: ...
    def modelColumn(self) -> int: ...
    def setModelColumn(self, column: int) -> None: ...
    def setRowHidden(self, row: int, hide: bool) -> None: ...
    def isRowHidden(self, row: int) -> bool: ...
    def clearPropertyFlags(self) -> None: ...
    def viewMode(self) -> 'QListView.ViewMode': ...
    def setViewMode(self, mode: 'QListView.ViewMode') -> None: ...
    def gridSize(self) -> QtCore.QSize: ...
    def setGridSize(self, size: QtCore.QSize) -> None: ...
    def spacing(self) -> int: ...
    def setSpacing(self, space: int) -> None: ...
    def layoutMode(self) -> 'QListView.LayoutMode': ...
    def setLayoutMode(self, mode: 'QListView.LayoutMode') -> None: ...
    def resizeMode(self) -> 'QListView.ResizeMode': ...
    def setResizeMode(self, mode: 'QListView.ResizeMode') -> None: ...
    def isWrapping(self) -> bool: ...
    def setWrapping(self, enable: bool) -> None: ...
    def flow(self) -> 'QListView.Flow': ...
    def setFlow(self, flow: 'QListView.Flow') -> None: ...
    def movement(self) -> 'QListView.Movement': ...
    def setMovement(self, movement: 'QListView.Movement') -> None: ...


class QListWidgetItem(sip.wrapper):

    class ItemType(int): ...
    Type = ... # type: 'QListWidgetItem.ItemType'
    UserType = ... # type: 'QListWidgetItem.ItemType'

    @typing.overload
    def __init__(self, parent: typing.Optional['QListWidget'] = ..., type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str, parent: typing.Optional['QListWidget'] = ..., type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, icon: QIcon, text: str, parent: typing.Optional['QListWidget'] = ..., type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, other: 'QListWidgetItem') -> None: ...

    def isHidden(self) -> bool: ...
    def setHidden(self, ahide: bool) -> None: ...
    def isSelected(self) -> bool: ...
    def setSelected(self, aselect: bool) -> None: ...
    def setForeground(self, brush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def foreground(self) -> QBrush: ...
    def setBackground(self, brush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def background(self) -> QBrush: ...
    def setFont(self, afont: QFont) -> None: ...
    def setWhatsThis(self, awhatsThis: str) -> None: ...
    def setToolTip(self, atoolTip: str) -> None: ...
    def setStatusTip(self, astatusTip: str) -> None: ...
    def setIcon(self, aicon: QIcon) -> None: ...
    def setText(self, atext: str) -> None: ...
    def setFlags(self, aflags: typing.Union[QtCore.Qt.ItemFlags, QtCore.Qt.ItemFlag]) -> None: ...
    def type(self) -> int: ...
    def write(self, out: QtCore.QDataStream) -> None: ...
    def read(self, in_: QtCore.QDataStream) -> None: ...
    def setData(self, role: int, value: typing.Any) -> None: ...
    def data(self, role: int) -> typing.Any: ...
    def setSizeHint(self, size: QtCore.QSize) -> None: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def setCheckState(self, state: QtCore.Qt.CheckState) -> None: ...
    def checkState(self) -> QtCore.Qt.CheckState: ...
    def setTextColor(self, color: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def textColor(self) -> QColor: ...
    def setBackgroundColor(self, color: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def backgroundColor(self) -> QColor: ...
    def setTextAlignment(self, alignment: int) -> None: ...
    def textAlignment(self) -> int: ...
    def font(self) -> QFont: ...
    def whatsThis(self) -> str: ...
    def toolTip(self) -> str: ...
    def statusTip(self) -> str: ...
    def icon(self) -> QIcon: ...
    def text(self) -> str: ...
    def flags(self) -> QtCore.Qt.ItemFlags: ...
    def listWidget(self) -> 'QListWidget': ...
    def clone(self) -> 'QListWidgetItem': ...


class QListWidget(QListView):

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...

    def removeItemWidget(self, aItem: QListWidgetItem) -> None: ...
    def dropEvent(self, event: QDropEvent) -> None: ...
    def isSortingEnabled(self) -> bool: ...
    def setSortingEnabled(self, enable: bool) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def itemFromIndex(self, index: QtCore.QModelIndex) -> QListWidgetItem: ...
    def indexFromItem(self, item: QListWidgetItem) -> QtCore.QModelIndex: ...
    def items(self, data: QtCore.QMimeData) -> typing.List[QListWidgetItem]: ...
    def supportedDropActions(self) -> QtCore.Qt.DropActions: ...
    def dropMimeData(self, index: int, data: QtCore.QMimeData, action: QtCore.Qt.DropAction) -> bool: ...
    def mimeData(self, items: typing.Sequence[QListWidgetItem]) -> QtCore.QMimeData: ...
    def mimeTypes(self) -> typing.List[str]: ...
    def itemSelectionChanged(self) -> None: ...
    def currentRowChanged(self, currentRow: int) -> None: ...
    def currentTextChanged(self, currentText: str) -> None: ...
    def currentItemChanged(self, current: QListWidgetItem, previous: QListWidgetItem) -> None: ...
    def itemChanged(self, item: QListWidgetItem) -> None: ...
    def itemEntered(self, item: QListWidgetItem) -> None: ...
    def itemActivated(self, item: QListWidgetItem) -> None: ...
    def itemDoubleClicked(self, item: QListWidgetItem) -> None: ...
    def itemClicked(self, item: QListWidgetItem) -> None: ...
    def itemPressed(self, item: QListWidgetItem) -> None: ...
    def scrollToItem(self, item: QListWidgetItem, hint: QAbstractItemView.ScrollHint = ...) -> None: ...
    def clear(self) -> None: ...
    def setItemHidden(self, item: QListWidgetItem, hide: bool) -> None: ...
    def isItemHidden(self, item: QListWidgetItem) -> bool: ...
    def findItems(self, text: str, flags: typing.Union[QtCore.Qt.MatchFlags, QtCore.Qt.MatchFlag]) -> typing.List[QListWidgetItem]: ...
    def selectedItems(self) -> typing.List[QListWidgetItem]: ...
    def setItemSelected(self, item: QListWidgetItem, select: bool) -> None: ...
    def isItemSelected(self, item: QListWidgetItem) -> bool: ...
    def closePersistentEditor(self, item: QListWidgetItem) -> None: ...
    def openPersistentEditor(self, item: QListWidgetItem) -> None: ...
    def editItem(self, item: QListWidgetItem) -> None: ...
    def sortItems(self, order: QtCore.Qt.SortOrder = ...) -> None: ...
    def visualItemRect(self, item: QListWidgetItem) -> QtCore.QRect: ...
    def setItemWidget(self, item: QListWidgetItem, widget: QWidget) -> None: ...
    def itemWidget(self, item: QListWidgetItem) -> QWidget: ...
    @typing.overload
    def itemAt(self, p: QtCore.QPoint) -> QListWidgetItem: ...
    @typing.overload
    def itemAt(self, ax: int, ay: int) -> QListWidgetItem: ...
    @typing.overload
    def setCurrentRow(self, row: int) -> None: ...
    @typing.overload
    def setCurrentRow(self, row: int, command: QItemSelectionModel.SelectionFlags) -> None: ...
    def currentRow(self) -> int: ...
    @typing.overload
    def setCurrentItem(self, item: QListWidgetItem) -> None: ...
    @typing.overload
    def setCurrentItem(self, item: QListWidgetItem, command: QItemSelectionModel.SelectionFlags) -> None: ...
    def currentItem(self) -> QListWidgetItem: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def takeItem(self, row: int) -> QListWidgetItem: ...
    def addItems(self, labels: typing.Sequence[str]) -> None: ...
    @typing.overload
    def addItem(self, aitem: QListWidgetItem) -> None: ...
    @typing.overload
    def addItem(self, label: str) -> None: ...
    def insertItems(self, row: int, labels: typing.Sequence[str]) -> None: ...
    @typing.overload
    def insertItem(self, row: int, item: QListWidgetItem) -> None: ...
    @typing.overload
    def insertItem(self, row: int, label: str) -> None: ...
    def row(self, item: QListWidgetItem) -> int: ...
    def item(self, row: int) -> QListWidgetItem: ...


class QMainWindow(QWidget):

    class DockOption(int): ...
    AnimatedDocks = ... # type: 'QMainWindow.DockOption'
    AllowNestedDocks = ... # type: 'QMainWindow.DockOption'
    AllowTabbedDocks = ... # type: 'QMainWindow.DockOption'
    ForceTabbedDocks = ... # type: 'QMainWindow.DockOption'
    VerticalTabs = ... # type: 'QMainWindow.DockOption'

    class DockOptions(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QMainWindow.DockOptions', 'QMainWindow.DockOption']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QMainWindow.DockOptions') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QMainWindow.DockOptions': ...
        def __int__(self) -> int: ...

    def __init__(self, parent: typing.Optional[QWidget] = ..., flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def tabifiedDockWidgets(self, dockwidget: QDockWidget) -> typing.List[QDockWidget]: ...
    def setTabPosition(self, areas: typing.Union[QtCore.Qt.DockWidgetAreas, QtCore.Qt.DockWidgetArea], tabPosition: 'QTabWidget.TabPosition') -> None: ...
    def tabPosition(self, area: QtCore.Qt.DockWidgetArea) -> 'QTabWidget.TabPosition': ...
    def setTabShape(self, tabShape: 'QTabWidget.TabShape') -> None: ...
    def tabShape(self) -> 'QTabWidget.TabShape': ...
    def setDocumentMode(self, enabled: bool) -> None: ...
    def documentMode(self) -> bool: ...
    def restoreDockWidget(self, dockwidget: QDockWidget) -> bool: ...
    def unifiedTitleAndToolBarOnMac(self) -> bool: ...
    def setUnifiedTitleAndToolBarOnMac(self, set: bool) -> None: ...
    def toolBarBreak(self, toolbar: 'QToolBar') -> bool: ...
    def removeToolBarBreak(self, before: 'QToolBar') -> None: ...
    def dockOptions(self) -> 'QMainWindow.DockOptions': ...
    def setDockOptions(self, options: 'QMainWindow.DockOptions') -> None: ...
    def tabifyDockWidget(self, first: QDockWidget, second: QDockWidget) -> None: ...
    def setMenuWidget(self, menubar: QWidget) -> None: ...
    def menuWidget(self) -> QWidget: ...
    def isSeparator(self, pos: QtCore.QPoint) -> bool: ...
    def isDockNestingEnabled(self) -> bool: ...
    def isAnimated(self) -> bool: ...
    def event(self, event: QtCore.QEvent) -> bool: ...
    def contextMenuEvent(self, event: QContextMenuEvent) -> None: ...
    def toolButtonStyleChanged(self, toolButtonStyle: QtCore.Qt.ToolButtonStyle) -> None: ...
    def iconSizeChanged(self, iconSize: QtCore.QSize) -> None: ...
    def setDockNestingEnabled(self, enabled: bool) -> None: ...
    def setAnimated(self, enabled: bool) -> None: ...
    def createPopupMenu(self) -> 'QMenu': ...
    def restoreState(self, state: typing.Union[QtCore.QByteArray, bytes, bytearray], version: int = ...) -> bool: ...
    def saveState(self, version: int = ...) -> QtCore.QByteArray: ...
    def dockWidgetArea(self, dockwidget: QDockWidget) -> QtCore.Qt.DockWidgetArea: ...
    def removeDockWidget(self, dockwidget: QDockWidget) -> None: ...
    def splitDockWidget(self, after: QDockWidget, dockwidget: QDockWidget, orientation: QtCore.Qt.Orientation) -> None: ...
    @typing.overload
    def addDockWidget(self, area: QtCore.Qt.DockWidgetArea, dockwidget: QDockWidget) -> None: ...
    @typing.overload
    def addDockWidget(self, area: QtCore.Qt.DockWidgetArea, dockwidget: QDockWidget, orientation: QtCore.Qt.Orientation) -> None: ...
    def toolBarArea(self, toolbar: 'QToolBar') -> QtCore.Qt.ToolBarArea: ...
    def removeToolBar(self, toolbar: 'QToolBar') -> None: ...
    def insertToolBar(self, before: 'QToolBar', toolbar: 'QToolBar') -> None: ...
    @typing.overload
    def addToolBar(self, area: QtCore.Qt.ToolBarArea, toolbar: 'QToolBar') -> None: ...
    @typing.overload
    def addToolBar(self, toolbar: 'QToolBar') -> None: ...
    @typing.overload
    def addToolBar(self, title: str) -> 'QToolBar': ...
    def insertToolBarBreak(self, before: 'QToolBar') -> None: ...
    def addToolBarBreak(self, area: QtCore.Qt.ToolBarArea = ...) -> None: ...
    def corner(self, corner: QtCore.Qt.Corner) -> QtCore.Qt.DockWidgetArea: ...
    def setCorner(self, corner: QtCore.Qt.Corner, area: QtCore.Qt.DockWidgetArea) -> None: ...
    def setCentralWidget(self, widget: QWidget) -> None: ...
    def centralWidget(self) -> QWidget: ...
    def setStatusBar(self, statusbar: 'QStatusBar') -> None: ...
    def statusBar(self) -> 'QStatusBar': ...
    def setMenuBar(self, menubar: 'QMenuBar') -> None: ...
    def menuBar(self) -> 'QMenuBar': ...
    def setToolButtonStyle(self, toolButtonStyle: QtCore.Qt.ToolButtonStyle) -> None: ...
    def toolButtonStyle(self) -> QtCore.Qt.ToolButtonStyle: ...
    def setIconSize(self, iconSize: QtCore.QSize) -> None: ...
    def iconSize(self) -> QtCore.QSize: ...


class QMatrix(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, m11: float, m12: float, m21: float, m22: float, dx: float, dy: float) -> None: ...
    @typing.overload
    def __init__(self, matrix: 'QMatrix') -> None: ...

    def determinant(self) -> float: ...
    def isIdentity(self) -> bool: ...
    def inverted(self) -> typing.Tuple['QMatrix', bool]: ...
    def det(self) -> float: ...
    def isInvertible(self) -> bool: ...
    def rotate(self, a: float) -> 'QMatrix': ...
    def shear(self, sh: float, sv: float) -> 'QMatrix': ...
    def scale(self, sx: float, sy: float) -> 'QMatrix': ...
    def translate(self, dx: float, dy: float) -> 'QMatrix': ...
    def reset(self) -> None: ...
    def mapToPolygon(self, r: QtCore.QRect) -> 'QPolygon': ...
    @typing.overload
    def mapRect(self, a0: QtCore.QRect) -> QtCore.QRect: ...
    @typing.overload
    def mapRect(self, a0: QtCore.QRectF) -> QtCore.QRectF: ...
    @typing.overload
    def map(self, x: int, y: int) -> typing.Tuple[int, int]: ...
    @typing.overload
    def map(self, x: float, y: float) -> typing.Tuple[float, float]: ...
    @typing.overload
    def map(self, p: QtCore.QPoint) -> QtCore.QPoint: ...
    @typing.overload
    def map(self, p: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> QtCore.QPointF: ...
    @typing.overload
    def map(self, l: QtCore.QLine) -> QtCore.QLine: ...
    @typing.overload
    def map(self, l: QtCore.QLineF) -> QtCore.QLineF: ...
    @typing.overload
    def map(self, a: 'QPolygonF') -> 'QPolygonF': ...
    @typing.overload
    def map(self, a: 'QPolygon') -> 'QPolygon': ...
    @typing.overload
    def map(self, r: 'QRegion') -> 'QRegion': ...
    @typing.overload
    def map(self, p: 'QPainterPath') -> 'QPainterPath': ...
    def dy(self) -> float: ...
    def dx(self) -> float: ...
    def m22(self) -> float: ...
    def m21(self) -> float: ...
    def m12(self) -> float: ...
    def m11(self) -> float: ...
    def setMatrix(self, m11: float, m12: float, m21: float, m22: float, dx: float, dy: float) -> None: ...


class QMatrix4x4(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, values: typing.Sequence[float]) -> None: ...
    @typing.overload
    def __init__(self, m11: float, m12: float, m13: float, m14: float, m21: float, m22: float, m23: float, m24: float, m31: float, m32: float, m33: float, m34: float, m41: float, m42: float, m43: float, m44: float) -> None: ...
    @typing.overload
    def __init__(self, transform: 'QTransform') -> None: ...
    @typing.overload
    def __init__(self, matrix: QMatrix) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QMatrix4x4') -> None: ...

    def __neg__(self) -> 'QMatrix4x4': ...
    def mapVector(self, vector: 'QVector3D') -> 'QVector3D': ...
    @typing.overload
    def map(self, point: QtCore.QPoint) -> QtCore.QPoint: ...
    @typing.overload
    def map(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> QtCore.QPointF: ...
    @typing.overload
    def map(self, point: 'QVector3D') -> 'QVector3D': ...
    @typing.overload
    def map(self, point: 'QVector4D') -> 'QVector4D': ...
    def fill(self, value: float) -> None: ...
    def setToIdentity(self) -> None: ...
    def isIdentity(self) -> bool: ...
    def setRow(self, index: int, value: 'QVector4D') -> None: ...
    def row(self, index: int) -> 'QVector4D': ...
    def setColumn(self, index: int, value: 'QVector4D') -> None: ...
    def column(self, index: int) -> 'QVector4D': ...
    def __setitem__(self, a0: typing.Any, a1: float) -> None: ...
    def __getitem__(self, a0: typing.Any) -> typing.Any: ...
    def optimize(self) -> None: ...
    def data(self) -> typing.List[float]: ...
    @typing.overload
    def mapRect(self, rect: QtCore.QRect) -> QtCore.QRect: ...
    @typing.overload
    def mapRect(self, rect: QtCore.QRectF) -> QtCore.QRectF: ...
    @typing.overload
    def toTransform(self) -> 'QTransform': ...
    @typing.overload
    def toTransform(self, distanceToPlane: float) -> 'QTransform': ...
    def toAffine(self) -> QMatrix: ...
    def copyDataTo(self) -> typing.List[float]: ...
    def flipCoordinates(self) -> None: ...
    def lookAt(self, eye: 'QVector3D', center: 'QVector3D', up: 'QVector3D') -> None: ...
    def perspective(self, angle: float, aspect: float, nearPlane: float, farPlane: float) -> None: ...
    def frustum(self, left: float, right: float, bottom: float, top: float, nearPlane: float, farPlane: float) -> None: ...
    @typing.overload
    def ortho(self, rect: QtCore.QRect) -> None: ...
    @typing.overload
    def ortho(self, rect: QtCore.QRectF) -> None: ...
    @typing.overload
    def ortho(self, left: float, right: float, bottom: float, top: float, nearPlane: float, farPlane: float) -> None: ...
    @typing.overload
    def rotate(self, angle: float, vector: 'QVector3D') -> None: ...
    @typing.overload
    def rotate(self, angle: float, x: float, y: float, z: float = ...) -> None: ...
    @typing.overload
    def rotate(self, quaternion: 'QQuaternion') -> None: ...
    @typing.overload
    def translate(self, vector: 'QVector3D') -> None: ...
    @typing.overload
    def translate(self, x: float, y: float) -> None: ...
    @typing.overload
    def translate(self, x: float, y: float, z: float) -> None: ...
    @typing.overload
    def scale(self, vector: 'QVector3D') -> None: ...
    @typing.overload
    def scale(self, x: float, y: float) -> None: ...
    @typing.overload
    def scale(self, x: float, y: float, z: float) -> None: ...
    @typing.overload
    def scale(self, factor: float) -> None: ...
    def normalMatrix(self) -> QMatrix3x3: ...
    def transposed(self) -> 'QMatrix4x4': ...
    def inverted(self) -> typing.Tuple['QMatrix4x4', bool]: ...
    def determinant(self) -> float: ...
    def __repr__(self) -> str: ...


class QMdiArea(QAbstractScrollArea):

    class WindowOrder(int): ...
    CreationOrder = ... # type: 'QMdiArea.WindowOrder'
    StackingOrder = ... # type: 'QMdiArea.WindowOrder'
    ActivationHistoryOrder = ... # type: 'QMdiArea.WindowOrder'

    class ViewMode(int): ...
    SubWindowView = ... # type: 'QMdiArea.ViewMode'
    TabbedView = ... # type: 'QMdiArea.ViewMode'

    class AreaOption(int): ...
    DontMaximizeSubWindowOnActivation = ... # type: 'QMdiArea.AreaOption'

    class AreaOptions(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QMdiArea.AreaOptions', 'QMdiArea.AreaOption']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QMdiArea.AreaOptions') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QMdiArea.AreaOptions': ...
        def __int__(self) -> int: ...

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...

    def tabsMovable(self) -> bool: ...
    def setTabsMovable(self, movable: bool) -> None: ...
    def tabsClosable(self) -> bool: ...
    def setTabsClosable(self, closable: bool) -> None: ...
    def setDocumentMode(self, enabled: bool) -> None: ...
    def documentMode(self) -> bool: ...
    def tabPosition(self) -> 'QTabWidget.TabPosition': ...
    def setTabPosition(self, position: 'QTabWidget.TabPosition') -> None: ...
    def tabShape(self) -> 'QTabWidget.TabShape': ...
    def setTabShape(self, shape: 'QTabWidget.TabShape') -> None: ...
    def viewMode(self) -> 'QMdiArea.ViewMode': ...
    def setViewMode(self, mode: 'QMdiArea.ViewMode') -> None: ...
    def setActivationOrder(self, order: 'QMdiArea.WindowOrder') -> None: ...
    def activationOrder(self) -> 'QMdiArea.WindowOrder': ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def viewportEvent(self, event: QtCore.QEvent) -> bool: ...
    def showEvent(self, showEvent: QShowEvent) -> None: ...
    def timerEvent(self, timerEvent: QtCore.QTimerEvent) -> None: ...
    def resizeEvent(self, resizeEvent: QResizeEvent) -> None: ...
    def childEvent(self, childEvent: QtCore.QChildEvent) -> None: ...
    def paintEvent(self, paintEvent: QPaintEvent) -> None: ...
    def eventFilter(self, object: QtCore.QObject, event: QtCore.QEvent) -> bool: ...
    def event(self, event: QtCore.QEvent) -> bool: ...
    def setupViewport(self, viewport: QWidget) -> None: ...
    def activatePreviousSubWindow(self) -> None: ...
    def activateNextSubWindow(self) -> None: ...
    def closeAllSubWindows(self) -> None: ...
    def closeActiveSubWindow(self) -> None: ...
    def cascadeSubWindows(self) -> None: ...
    def tileSubWindows(self) -> None: ...
    def setActiveSubWindow(self, window: 'QMdiSubWindow') -> None: ...
    def subWindowActivated(self, a0: 'QMdiSubWindow') -> None: ...
    def testOption(self, opton: 'QMdiArea.AreaOption') -> bool: ...
    def setOption(self, option: 'QMdiArea.AreaOption', on: bool = ...) -> None: ...
    def setBackground(self, background: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def background(self) -> QBrush: ...
    def removeSubWindow(self, widget: QWidget) -> None: ...
    def currentSubWindow(self) -> 'QMdiSubWindow': ...
    def subWindowList(self, order: 'QMdiArea.WindowOrder' = ...) -> typing.List['QMdiSubWindow']: ...
    def addSubWindow(self, widget: QWidget, flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> 'QMdiSubWindow': ...
    def activeSubWindow(self) -> 'QMdiSubWindow': ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...


class QMdiSubWindow(QWidget):

    class SubWindowOption(int): ...
    RubberBandResize = ... # type: 'QMdiSubWindow.SubWindowOption'
    RubberBandMove = ... # type: 'QMdiSubWindow.SubWindowOption'

    class SubWindowOptions(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QMdiSubWindow.SubWindowOptions', 'QMdiSubWindow.SubWindowOption']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QMdiSubWindow.SubWindowOptions') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QMdiSubWindow.SubWindowOptions': ...
        def __int__(self) -> int: ...

    def __init__(self, parent: typing.Optional[QWidget] = ..., flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def childEvent(self, childEvent: QtCore.QChildEvent) -> None: ...
    def focusOutEvent(self, focusOutEvent: QFocusEvent) -> None: ...
    def focusInEvent(self, focusInEvent: QFocusEvent) -> None: ...
    def contextMenuEvent(self, contextMenuEvent: QContextMenuEvent) -> None: ...
    def keyPressEvent(self, keyEvent: QKeyEvent) -> None: ...
    def mouseMoveEvent(self, mouseEvent: QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, mouseEvent: QMouseEvent) -> None: ...
    def mouseDoubleClickEvent(self, mouseEvent: QMouseEvent) -> None: ...
    def mousePressEvent(self, mouseEvent: QMouseEvent) -> None: ...
    def paintEvent(self, paintEvent: QPaintEvent) -> None: ...
    def moveEvent(self, moveEvent: QMoveEvent) -> None: ...
    def timerEvent(self, timerEvent: QtCore.QTimerEvent) -> None: ...
    def resizeEvent(self, resizeEvent: QResizeEvent) -> None: ...
    def leaveEvent(self, leaveEvent: QtCore.QEvent) -> None: ...
    def closeEvent(self, closeEvent: QCloseEvent) -> None: ...
    def changeEvent(self, changeEvent: QtCore.QEvent) -> None: ...
    def hideEvent(self, hideEvent: QHideEvent) -> None: ...
    def showEvent(self, showEvent: QShowEvent) -> None: ...
    def event(self, event: QtCore.QEvent) -> bool: ...
    def eventFilter(self, object: QtCore.QObject, event: QtCore.QEvent) -> bool: ...
    def showShaded(self) -> None: ...
    def showSystemMenu(self) -> None: ...
    def aboutToActivate(self) -> None: ...
    def windowStateChanged(self, oldState: typing.Union[QtCore.Qt.WindowStates, QtCore.Qt.WindowState], newState: typing.Union[QtCore.Qt.WindowStates, QtCore.Qt.WindowState]) -> None: ...
    def mdiArea(self) -> QMdiArea: ...
    def systemMenu(self) -> 'QMenu': ...
    def setSystemMenu(self, systemMenu: 'QMenu') -> None: ...
    def keyboardPageStep(self) -> int: ...
    def setKeyboardPageStep(self, step: int) -> None: ...
    def keyboardSingleStep(self) -> int: ...
    def setKeyboardSingleStep(self, step: int) -> None: ...
    def testOption(self, a0: 'QMdiSubWindow.SubWindowOption') -> bool: ...
    def setOption(self, option: 'QMdiSubWindow.SubWindowOption', on: bool = ...) -> None: ...
    def isShaded(self) -> bool: ...
    def widget(self) -> QWidget: ...
    def setWidget(self, widget: QWidget) -> None: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...


class QMenu(QWidget):

    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, title: str, parent: typing.Optional[QWidget] = ...) -> None: ...

    def setSeparatorsCollapsible(self, collapse: bool) -> None: ...
    def separatorsCollapsible(self) -> bool: ...
    def isEmpty(self) -> bool: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    def timerEvent(self, a0: QtCore.QTimerEvent) -> None: ...
    def actionEvent(self, a0: QActionEvent) -> None: ...
    def paintEvent(self, a0: QPaintEvent) -> None: ...
    def hideEvent(self, a0: QHideEvent) -> None: ...
    def leaveEvent(self, a0: QtCore.QEvent) -> None: ...
    def enterEvent(self, a0: QtCore.QEvent) -> None: ...
    def wheelEvent(self, a0: QWheelEvent) -> None: ...
    def mouseMoveEvent(self, a0: QMouseEvent) -> None: ...
    def mousePressEvent(self, a0: QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, a0: QMouseEvent) -> None: ...
    def keyPressEvent(self, a0: QKeyEvent) -> None: ...
    def changeEvent(self, a0: QtCore.QEvent) -> None: ...
    def initStyleOption(self, option: 'QStyleOptionMenuItem', action: QAction) -> None: ...
    def columnCount(self) -> int: ...
    def triggered(self, action: QAction) -> None: ...
    def hovered(self, action: QAction) -> None: ...
    def aboutToShow(self) -> None: ...
    def aboutToHide(self) -> None: ...
    def setNoReplayFor(self, widget: QWidget) -> None: ...
    def setIcon(self, icon: QIcon) -> None: ...
    def icon(self) -> QIcon: ...
    def setTitle(self, title: str) -> None: ...
    def title(self) -> str: ...
    def menuAction(self) -> QAction: ...
    def actionAt(self, a0: QtCore.QPoint) -> QAction: ...
    def actionGeometry(self, a0: QAction) -> QtCore.QRect: ...
    def sizeHint(self) -> QtCore.QSize: ...
    @typing.overload
    def exec(self) -> QAction: ...
    @typing.overload
    def exec(self, pos: QtCore.QPoint, action: typing.Optional[QAction] = ...) -> QAction: ...
    @typing.overload
    @staticmethod
    def exec(actions: typing.Sequence[QAction], pos: QtCore.QPoint, action: typing.Optional[QAction] = ...) -> QAction: ...
    @typing.overload
    @staticmethod
    def exec(actions: typing.Sequence[QAction], pos: QtCore.QPoint, at: QAction, parent: QWidget) -> QAction: ...
    @typing.overload
    def exec_(self) -> QAction: ...
    @typing.overload
    def exec_(self, p: QtCore.QPoint, action: typing.Optional[QAction] = ...) -> QAction: ...
    @typing.overload
    @staticmethod
    def exec_(actions: typing.Sequence[QAction], pos: QtCore.QPoint, action: typing.Optional[QAction] = ...) -> QAction: ...
    @typing.overload
    @staticmethod
    def exec_(actions: typing.Sequence[QAction], pos: QtCore.QPoint, at: QAction, parent: QWidget) -> QAction: ...
    def popup(self, p: QtCore.QPoint, action: typing.Optional[QAction] = ...) -> None: ...
    def activeAction(self) -> QAction: ...
    def setActiveAction(self, act: QAction) -> None: ...
    def defaultAction(self) -> QAction: ...
    def setDefaultAction(self, a0: QAction) -> None: ...
    def hideTearOffMenu(self) -> None: ...
    def isTearOffMenuVisible(self) -> bool: ...
    def isTearOffEnabled(self) -> bool: ...
    def setTearOffEnabled(self, a0: bool) -> None: ...
    def clear(self) -> None: ...
    def insertSeparator(self, before: QAction) -> QAction: ...
    def insertMenu(self, before: QAction, menu: 'QMenu') -> QAction: ...
    def addSeparator(self) -> QAction: ...
    @typing.overload
    def addMenu(self, menu: 'QMenu') -> QAction: ...
    @typing.overload
    def addMenu(self, title: str) -> 'QMenu': ...
    @typing.overload
    def addMenu(self, icon: QIcon, title: str) -> 'QMenu': ...
    @typing.overload
    def addAction(self, action: QAction) -> None: ...
    @typing.overload
    def addAction(self, text: str) -> QAction: ...
    @typing.overload
    def addAction(self, icon: QIcon, text: str) -> QAction: ...
    @typing.overload
    def addAction(self, text: str, receiver: QtCore.QObject, member: QT_SLOT, shortcut: typing.Union[QKeySequence, QKeySequence.StandardKey, str, int] = ...) -> QAction: ...
    @typing.overload
    def addAction(self, text: str, slot: PYQT_SLOT, shortcut: typing.Union[QKeySequence, QKeySequence.StandardKey, str, int] = ...) -> QAction: ...
    @typing.overload
    def addAction(self, icon: QIcon, text: str, receiver: QtCore.QObject, member: QT_SLOT, shortcut: typing.Union[QKeySequence, QKeySequence.StandardKey, str, int] = ...) -> QAction: ...
    @typing.overload
    def addAction(self, icon: QIcon, text: str, slot: PYQT_SLOT, shortcut: typing.Union[QKeySequence, QKeySequence.StandardKey, str, int] = ...) -> QAction: ...


class QMenuBar(QWidget):

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...

    def setNativeMenuBar(self, nativeMenuBar: bool) -> None: ...
    def isNativeMenuBar(self) -> bool: ...
    def timerEvent(self, a0: QtCore.QTimerEvent) -> None: ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    def eventFilter(self, a0: QtCore.QObject, a1: QtCore.QEvent) -> bool: ...
    def focusInEvent(self, a0: QFocusEvent) -> None: ...
    def focusOutEvent(self, a0: QFocusEvent) -> None: ...
    def actionEvent(self, a0: QActionEvent) -> None: ...
    def resizeEvent(self, a0: QResizeEvent) -> None: ...
    def paintEvent(self, a0: QPaintEvent) -> None: ...
    def leaveEvent(self, a0: QtCore.QEvent) -> None: ...
    def mouseMoveEvent(self, a0: QMouseEvent) -> None: ...
    def mousePressEvent(self, a0: QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, a0: QMouseEvent) -> None: ...
    def keyPressEvent(self, a0: QKeyEvent) -> None: ...
    def changeEvent(self, a0: QtCore.QEvent) -> None: ...
    def initStyleOption(self, option: 'QStyleOptionMenuItem', action: QAction) -> None: ...
    def hovered(self, action: QAction) -> None: ...
    def triggered(self, action: QAction) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def cornerWidget(self, corner: QtCore.Qt.Corner = ...) -> QWidget: ...
    def setCornerWidget(self, widget: QWidget, corner: QtCore.Qt.Corner = ...) -> None: ...
    def actionAt(self, a0: QtCore.QPoint) -> QAction: ...
    def actionGeometry(self, a0: QAction) -> QtCore.QRect: ...
    def heightForWidth(self, a0: int) -> int: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def isDefaultUp(self) -> bool: ...
    def setDefaultUp(self, a0: bool) -> None: ...
    def setActiveAction(self, action: QAction) -> None: ...
    def activeAction(self) -> QAction: ...
    def clear(self) -> None: ...
    def insertSeparator(self, before: QAction) -> QAction: ...
    def insertMenu(self, before: QAction, menu: QMenu) -> QAction: ...
    def addSeparator(self) -> QAction: ...
    @typing.overload
    def addMenu(self, menu: QMenu) -> QAction: ...
    @typing.overload
    def addMenu(self, title: str) -> QMenu: ...
    @typing.overload
    def addMenu(self, icon: QIcon, title: str) -> QMenu: ...
    @typing.overload
    def addAction(self, action: QAction) -> None: ...
    @typing.overload
    def addAction(self, text: str) -> QAction: ...
    @typing.overload
    def addAction(self, text: str, receiver: QtCore.QObject, member: QT_SLOT) -> QAction: ...
    @typing.overload
    def addAction(self, text: str, slot: PYQT_SLOT) -> QAction: ...


class QMessageBox(QDialog):

    class StandardButton(int): ...
    NoButton = ... # type: 'QMessageBox.StandardButton'
    Ok = ... # type: 'QMessageBox.StandardButton'
    Save = ... # type: 'QMessageBox.StandardButton'
    SaveAll = ... # type: 'QMessageBox.StandardButton'
    Open = ... # type: 'QMessageBox.StandardButton'
    Yes = ... # type: 'QMessageBox.StandardButton'
    YesToAll = ... # type: 'QMessageBox.StandardButton'
    No = ... # type: 'QMessageBox.StandardButton'
    NoToAll = ... # type: 'QMessageBox.StandardButton'
    Abort = ... # type: 'QMessageBox.StandardButton'
    Retry = ... # type: 'QMessageBox.StandardButton'
    Ignore = ... # type: 'QMessageBox.StandardButton'
    Close = ... # type: 'QMessageBox.StandardButton'
    Cancel = ... # type: 'QMessageBox.StandardButton'
    Discard = ... # type: 'QMessageBox.StandardButton'
    Help = ... # type: 'QMessageBox.StandardButton'
    Apply = ... # type: 'QMessageBox.StandardButton'
    Reset = ... # type: 'QMessageBox.StandardButton'
    RestoreDefaults = ... # type: 'QMessageBox.StandardButton'
    FirstButton = ... # type: 'QMessageBox.StandardButton'
    LastButton = ... # type: 'QMessageBox.StandardButton'
    YesAll = ... # type: 'QMessageBox.StandardButton'
    NoAll = ... # type: 'QMessageBox.StandardButton'
    Default = ... # type: 'QMessageBox.StandardButton'
    Escape = ... # type: 'QMessageBox.StandardButton'
    FlagMask = ... # type: 'QMessageBox.StandardButton'
    ButtonMask = ... # type: 'QMessageBox.StandardButton'

    class Icon(int): ...
    NoIcon = ... # type: 'QMessageBox.Icon'
    Information = ... # type: 'QMessageBox.Icon'
    Warning = ... # type: 'QMessageBox.Icon'
    Critical = ... # type: 'QMessageBox.Icon'
    Question = ... # type: 'QMessageBox.Icon'

    class ButtonRole(int): ...
    InvalidRole = ... # type: 'QMessageBox.ButtonRole'
    AcceptRole = ... # type: 'QMessageBox.ButtonRole'
    RejectRole = ... # type: 'QMessageBox.ButtonRole'
    DestructiveRole = ... # type: 'QMessageBox.ButtonRole'
    ActionRole = ... # type: 'QMessageBox.ButtonRole'
    HelpRole = ... # type: 'QMessageBox.ButtonRole'
    YesRole = ... # type: 'QMessageBox.ButtonRole'
    NoRole = ... # type: 'QMessageBox.ButtonRole'
    ResetRole = ... # type: 'QMessageBox.ButtonRole'
    ApplyRole = ... # type: 'QMessageBox.ButtonRole'

    class StandardButtons(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QMessageBox.StandardButtons', 'QMessageBox.StandardButton']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QMessageBox.StandardButtons') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QMessageBox.StandardButtons': ...
        def __int__(self) -> int: ...

    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, icon: 'QMessageBox.Icon', title: str, text: str, buttons: typing.Union['QMessageBox.StandardButtons', 'QMessageBox.StandardButton'] = ..., parent: typing.Optional[QWidget] = ..., flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...
    @typing.overload
    def __init__(self, title: str, text: str, icon: 'QMessageBox.Icon', button0: int, button1: int, button2: int, parent: typing.Optional[QWidget] = ..., flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def buttonClicked(self, button: QAbstractButton) -> None: ...
    def buttonRole(self, button: QAbstractButton) -> 'QMessageBox.ButtonRole': ...
    def buttons(self) -> typing.List[QAbstractButton]: ...
    @typing.overload
    def open(self) -> None: ...
    @typing.overload
    def open(self, receiver: QtCore.QObject, member: QT_SLOT) -> None: ...
    @typing.overload
    def open(self, slot: PYQT_SLOT) -> None: ...
    def setWindowModality(self, windowModality: QtCore.Qt.WindowModality) -> None: ...
    def setWindowTitle(self, title: str) -> None: ...
    def setDetailedText(self, text: str) -> None: ...
    def detailedText(self) -> str: ...
    def setInformativeText(self, text: str) -> None: ...
    def informativeText(self) -> str: ...
    def clickedButton(self) -> QAbstractButton: ...
    @typing.overload
    def setEscapeButton(self, button: QAbstractButton) -> None: ...
    @typing.overload
    def setEscapeButton(self, button: 'QMessageBox.StandardButton') -> None: ...
    def escapeButton(self) -> QAbstractButton: ...
    @typing.overload
    def setDefaultButton(self, button: QPushButton) -> None: ...
    @typing.overload
    def setDefaultButton(self, button: 'QMessageBox.StandardButton') -> None: ...
    def defaultButton(self) -> QPushButton: ...
    def button(self, which: 'QMessageBox.StandardButton') -> QAbstractButton: ...
    def standardButton(self, button: QAbstractButton) -> 'QMessageBox.StandardButton': ...
    def standardButtons(self) -> 'QMessageBox.StandardButtons': ...
    def setStandardButtons(self, buttons: typing.Union['QMessageBox.StandardButtons', 'QMessageBox.StandardButton']) -> None: ...
    def removeButton(self, button: QAbstractButton) -> None: ...
    @typing.overload
    def addButton(self, button: QAbstractButton, role: 'QMessageBox.ButtonRole') -> None: ...
    @typing.overload
    def addButton(self, text: str, role: 'QMessageBox.ButtonRole') -> QPushButton: ...
    @typing.overload
    def addButton(self, button: 'QMessageBox.StandardButton') -> QPushButton: ...
    def changeEvent(self, a0: QtCore.QEvent) -> None: ...
    def keyPressEvent(self, a0: QKeyEvent) -> None: ...
    def closeEvent(self, a0: QCloseEvent) -> None: ...
    def showEvent(self, a0: QShowEvent) -> None: ...
    def resizeEvent(self, a0: QResizeEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    @staticmethod
    def standardIcon(icon: 'QMessageBox.Icon') -> QPixmap: ...
    def sizeHint(self) -> QtCore.QSize: ...
    @staticmethod
    def aboutQt(parent: QWidget, title: str = ...) -> None: ...
    @staticmethod
    def about(parent: QWidget, caption: str, text: str) -> None: ...
    @typing.overload
    @staticmethod
    def critical(parent: QWidget, title: str, text: str, buttons: typing.Union['QMessageBox.StandardButtons', 'QMessageBox.StandardButton'] = ..., defaultButton: 'QMessageBox.StandardButton' = ...) -> 'QMessageBox.StandardButton': ...
    @typing.overload
    @staticmethod
    def critical(parent: QWidget, title: str, text: str, button0: int, button1: int, button2: int = ...) -> int: ...
    @typing.overload
    @staticmethod
    def critical(parent: QWidget, title: str, text: str, button0Text: str, button1Text: str = ..., button2Text: str = ..., defaultButtonNumber: int = ..., escapeButtonNumber: int = ...) -> int: ...
    @typing.overload
    @staticmethod
    def warning(parent: QWidget, title: str, text: str, buttons: typing.Union['QMessageBox.StandardButtons', 'QMessageBox.StandardButton'] = ..., defaultButton: 'QMessageBox.StandardButton' = ...) -> 'QMessageBox.StandardButton': ...
    @typing.overload
    @staticmethod
    def warning(parent: QWidget, title: str, text: str, button0: int, button1: int, button2: int = ...) -> int: ...
    @typing.overload
    @staticmethod
    def warning(parent: QWidget, title: str, text: str, button0Text: str, button1Text: str = ..., button2Text: str = ..., defaultButtonNumber: int = ..., escapeButtonNumber: int = ...) -> int: ...
    @typing.overload
    @staticmethod
    def question(parent: QWidget, title: str, text: str, buttons: typing.Union['QMessageBox.StandardButtons', 'QMessageBox.StandardButton'] = ..., defaultButton: 'QMessageBox.StandardButton' = ...) -> 'QMessageBox.StandardButton': ...
    @typing.overload
    @staticmethod
    def question(parent: QWidget, title: str, text: str, button0: int, button1: int = ..., button2: int = ...) -> int: ...
    @typing.overload
    @staticmethod
    def question(parent: QWidget, title: str, text: str, button0Text: str, button1Text: str = ..., button2Text: str = ..., defaultButtonNumber: int = ..., escapeButtonNumber: int = ...) -> int: ...
    @typing.overload
    @staticmethod
    def information(parent: QWidget, title: str, text: str, buttons: typing.Union['QMessageBox.StandardButtons', 'QMessageBox.StandardButton'] = ..., defaultButton: 'QMessageBox.StandardButton' = ...) -> 'QMessageBox.StandardButton': ...
    @typing.overload
    @staticmethod
    def information(parent: QWidget, title: str, text: str, button0: int, button1: int = ..., button2: int = ...) -> int: ...
    @typing.overload
    @staticmethod
    def information(parent: QWidget, title: str, text: str, button0Text: str, button1Text: str = ..., button2Text: str = ..., defaultButtonNumber: int = ..., escapeButtonNumber: int = ...) -> int: ...
    def setTextFormat(self, a0: QtCore.Qt.TextFormat) -> None: ...
    def textFormat(self) -> QtCore.Qt.TextFormat: ...
    def setButtonText(self, button: int, a1: str) -> None: ...
    def buttonText(self, button: int) -> str: ...
    def setIconPixmap(self, a0: QPixmap) -> None: ...
    def iconPixmap(self) -> QPixmap: ...
    def setIcon(self, a0: 'QMessageBox.Icon') -> None: ...
    def icon(self) -> 'QMessageBox.Icon': ...
    def setText(self, a0: str) -> None: ...
    def text(self) -> str: ...


class QMouseEventTransition(QtCore.QEventTransition):

    @typing.overload
    def __init__(self, sourceState: typing.Optional[QtCore.QState] = ...) -> None: ...
    @typing.overload
    def __init__(self, object: QtCore.QObject, type: QtCore.QEvent.Type, button: QtCore.Qt.MouseButton, sourceState: typing.Optional[QtCore.QState] = ...) -> None: ...

    def eventTest(self, event: QtCore.QEvent) -> bool: ...
    def onTransition(self, event: QtCore.QEvent) -> None: ...
    def setHitTestPath(self, path: 'QPainterPath') -> None: ...
    def hitTestPath(self) -> 'QPainterPath': ...
    def setModifierMask(self, modifiers: typing.Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier]) -> None: ...
    def modifierMask(self) -> QtCore.Qt.KeyboardModifiers: ...
    def setButton(self, button: QtCore.Qt.MouseButton) -> None: ...
    def button(self) -> QtCore.Qt.MouseButton: ...


class QMovie(QtCore.QObject):

    class CacheMode(int): ...
    CacheNone = ... # type: 'QMovie.CacheMode'
    CacheAll = ... # type: 'QMovie.CacheMode'

    class MovieState(int): ...
    NotRunning = ... # type: 'QMovie.MovieState'
    Paused = ... # type: 'QMovie.MovieState'
    Running = ... # type: 'QMovie.MovieState'

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, device: QtCore.QIODevice, format: typing.Union[QtCore.QByteArray, bytes, bytearray] = ..., parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, fileName: str, format: typing.Union[QtCore.QByteArray, bytes, bytearray] = ..., parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def stop(self) -> None: ...
    def setPaused(self, paused: bool) -> None: ...
    def jumpToNextFrame(self) -> bool: ...
    def start(self) -> None: ...
    def frameChanged(self, frameNumber: int) -> None: ...
    def finished(self) -> None: ...
    def error(self, error: QImageReader.ImageReaderError) -> None: ...
    def stateChanged(self, state: 'QMovie.MovieState') -> None: ...
    def updated(self, rect: QtCore.QRect) -> None: ...
    def resized(self, size: QtCore.QSize) -> None: ...
    def started(self) -> None: ...
    def setCacheMode(self, mode: 'QMovie.CacheMode') -> None: ...
    def cacheMode(self) -> 'QMovie.CacheMode': ...
    def setScaledSize(self, size: QtCore.QSize) -> None: ...
    def scaledSize(self) -> QtCore.QSize: ...
    def speed(self) -> int: ...
    def setSpeed(self, percentSpeed: int) -> None: ...
    def currentFrameNumber(self) -> int: ...
    def nextFrameDelay(self) -> int: ...
    def frameCount(self) -> int: ...
    def loopCount(self) -> int: ...
    def jumpToFrame(self, frameNumber: int) -> bool: ...
    def isValid(self) -> bool: ...
    def currentPixmap(self) -> QPixmap: ...
    def currentImage(self) -> QImage: ...
    def frameRect(self) -> QtCore.QRect: ...
    def state(self) -> 'QMovie.MovieState': ...
    def backgroundColor(self) -> QColor: ...
    def setBackgroundColor(self, color: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def format(self) -> QtCore.QByteArray: ...
    def setFormat(self, format: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    def fileName(self) -> str: ...
    def setFileName(self, fileName: str) -> None: ...
    def device(self) -> QtCore.QIODevice: ...
    def setDevice(self, device: QtCore.QIODevice) -> None: ...
    @staticmethod
    def supportedFormats() -> typing.List[QtCore.QByteArray]: ...


class QPageSetupDialog(QDialog):

    class PageSetupDialogOption(int): ...
    DontUseSheet = ... # type: 'QPageSetupDialog.PageSetupDialogOption'

    class PageSetupDialogOptions(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QPageSetupDialog.PageSetupDialogOptions', 'QPageSetupDialog.PageSetupDialogOption']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QPageSetupDialog.PageSetupDialogOptions') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QPageSetupDialog.PageSetupDialogOptions': ...
        def __int__(self) -> int: ...

    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, printer: 'QPrinter', parent: typing.Optional[QWidget] = ...) -> None: ...

    @typing.overload
    def open(self) -> None: ...
    @typing.overload
    def open(self, receiver: QtCore.QObject, member: QT_SLOT) -> None: ...
    @typing.overload
    def open(self, slot: PYQT_SLOT) -> None: ...
    def options(self) -> 'QPageSetupDialog.PageSetupDialogOptions': ...
    def setOptions(self, options: 'QPageSetupDialog.PageSetupDialogOptions') -> None: ...
    def testOption(self, option: 'QPageSetupDialog.PageSetupDialogOption') -> bool: ...
    def setOption(self, option: 'QPageSetupDialog.PageSetupDialogOption', on: bool = ...) -> None: ...
    def isOptionEnabled(self, option: 'QPageSetupDialog.PageSetupDialogOption') -> bool: ...
    def enabledOptions(self) -> 'QPageSetupDialog.PageSetupDialogOptions': ...
    def setEnabledOptions(self, options: 'QPageSetupDialog.PageSetupDialogOptions') -> None: ...
    def addEnabledOption(self, option: 'QPageSetupDialog.PageSetupDialogOption') -> None: ...
    def printer(self) -> 'QPrinter': ...
    def exec(self) -> int: ...
    def exec_(self) -> int: ...


class QPainter(sip.simplewrapper):

    class PixmapFragmentHint(int): ...
    OpaqueHint = ... # type: 'QPainter.PixmapFragmentHint'

    class CompositionMode(int): ...
    CompositionMode_SourceOver = ... # type: 'QPainter.CompositionMode'
    CompositionMode_DestinationOver = ... # type: 'QPainter.CompositionMode'
    CompositionMode_Clear = ... # type: 'QPainter.CompositionMode'
    CompositionMode_Source = ... # type: 'QPainter.CompositionMode'
    CompositionMode_Destination = ... # type: 'QPainter.CompositionMode'
    CompositionMode_SourceIn = ... # type: 'QPainter.CompositionMode'
    CompositionMode_DestinationIn = ... # type: 'QPainter.CompositionMode'
    CompositionMode_SourceOut = ... # type: 'QPainter.CompositionMode'
    CompositionMode_DestinationOut = ... # type: 'QPainter.CompositionMode'
    CompositionMode_SourceAtop = ... # type: 'QPainter.CompositionMode'
    CompositionMode_DestinationAtop = ... # type: 'QPainter.CompositionMode'
    CompositionMode_Xor = ... # type: 'QPainter.CompositionMode'
    CompositionMode_Plus = ... # type: 'QPainter.CompositionMode'
    CompositionMode_Multiply = ... # type: 'QPainter.CompositionMode'
    CompositionMode_Screen = ... # type: 'QPainter.CompositionMode'
    CompositionMode_Overlay = ... # type: 'QPainter.CompositionMode'
    CompositionMode_Darken = ... # type: 'QPainter.CompositionMode'
    CompositionMode_Lighten = ... # type: 'QPainter.CompositionMode'
    CompositionMode_ColorDodge = ... # type: 'QPainter.CompositionMode'
    CompositionMode_ColorBurn = ... # type: 'QPainter.CompositionMode'
    CompositionMode_HardLight = ... # type: 'QPainter.CompositionMode'
    CompositionMode_SoftLight = ... # type: 'QPainter.CompositionMode'
    CompositionMode_Difference = ... # type: 'QPainter.CompositionMode'
    CompositionMode_Exclusion = ... # type: 'QPainter.CompositionMode'
    RasterOp_SourceOrDestination = ... # type: 'QPainter.CompositionMode'
    RasterOp_SourceAndDestination = ... # type: 'QPainter.CompositionMode'
    RasterOp_SourceXorDestination = ... # type: 'QPainter.CompositionMode'
    RasterOp_NotSourceAndNotDestination = ... # type: 'QPainter.CompositionMode'
    RasterOp_NotSourceOrNotDestination = ... # type: 'QPainter.CompositionMode'
    RasterOp_NotSourceXorDestination = ... # type: 'QPainter.CompositionMode'
    RasterOp_NotSource = ... # type: 'QPainter.CompositionMode'
    RasterOp_NotSourceAndDestination = ... # type: 'QPainter.CompositionMode'
    RasterOp_SourceAndNotDestination = ... # type: 'QPainter.CompositionMode'

    class RenderHint(int): ...
    Antialiasing = ... # type: 'QPainter.RenderHint'
    TextAntialiasing = ... # type: 'QPainter.RenderHint'
    SmoothPixmapTransform = ... # type: 'QPainter.RenderHint'
    HighQualityAntialiasing = ... # type: 'QPainter.RenderHint'
    NonCosmeticDefaultPen = ... # type: 'QPainter.RenderHint'

    class RenderHints(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QPainter.RenderHints', 'QPainter.RenderHint']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QPainter.RenderHints') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QPainter.RenderHints': ...
        def __int__(self) -> int: ...

    class PixmapFragment(sip.simplewrapper):

        height = ... # type: float
        opacity = ... # type: float
        rotation = ... # type: float
        scaleX = ... # type: float
        scaleY = ... # type: float
        sourceLeft = ... # type: float
        sourceTop = ... # type: float
        width = ... # type: float
        x = ... # type: float
        y = ... # type: float

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QPainter.PixmapFragment') -> None: ...

        @staticmethod
        def create(pos: typing.Union[QtCore.QPointF, QtCore.QPoint], sourceRect: QtCore.QRectF, scaleX: float = ..., scaleY: float = ..., rotation: float = ..., opacity: float = ...) -> 'QPainter.PixmapFragment': ...

    class PixmapFragmentHints(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QPainter.PixmapFragmentHints', 'QPainter.PixmapFragmentHint']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QPainter.PixmapFragmentHints') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QPainter.PixmapFragmentHints': ...
        def __int__(self) -> int: ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: QPaintDevice) -> None: ...

    def drawGlyphRun(self, position: typing.Union[QtCore.QPointF, QtCore.QPoint], glyphRun: QGlyphRun) -> None: ...
    def clipBoundingRect(self) -> QtCore.QRectF: ...
    @typing.overload
    def drawStaticText(self, topLeftPosition: typing.Union[QtCore.QPointF, QtCore.QPoint], staticText: 'QStaticText') -> None: ...
    @typing.overload
    def drawStaticText(self, p: QtCore.QPoint, staticText: 'QStaticText') -> None: ...
    @typing.overload
    def drawStaticText(self, x: int, y: int, staticText: 'QStaticText') -> None: ...
    @typing.overload
    def drawPixmapFragments(self, fragments: typing.List['QPainter.PixmapFragment'], pixmap: QPixmap, hints: 'QPainter.PixmapFragmentHints' = ...) -> None: ...
    @typing.overload
    def drawPixmapFragments(self, targetRects: typing.List[QtCore.QRectF], sourceRects: typing.List[QtCore.QRectF], pixmap: QPixmap, hints: 'QPainter.PixmapFragmentHints' = ...) -> None: ...
    def endNativePainting(self) -> None: ...
    def beginNativePainting(self) -> None: ...
    @typing.overload
    def drawRoundedRect(self, rect: QtCore.QRectF, xRadius: float, yRadius: float, mode: QtCore.Qt.SizeMode = ...) -> None: ...
    @typing.overload
    def drawRoundedRect(self, x: int, y: int, w: int, h: int, xRadius: float, yRadius: float, mode: QtCore.Qt.SizeMode = ...) -> None: ...
    @typing.overload
    def drawRoundedRect(self, rect: QtCore.QRect, xRadius: float, yRadius: float, mode: QtCore.Qt.SizeMode = ...) -> None: ...
    def testRenderHint(self, hint: 'QPainter.RenderHint') -> bool: ...
    def combinedTransform(self) -> 'QTransform': ...
    def worldTransform(self) -> 'QTransform': ...
    def setWorldTransform(self, matrix: 'QTransform', combine: bool = ...) -> None: ...
    def resetTransform(self) -> None: ...
    def deviceTransform(self) -> 'QTransform': ...
    def transform(self) -> 'QTransform': ...
    def setTransform(self, transform: 'QTransform', combine: bool = ...) -> None: ...
    def setWorldMatrixEnabled(self, enabled: bool) -> None: ...
    def worldMatrixEnabled(self) -> bool: ...
    def setWorldMatrix(self, matrix: QMatrix, combine: bool = ...) -> None: ...
    def worldMatrix(self) -> QMatrix: ...
    def setOpacity(self, opacity: float) -> None: ...
    def opacity(self) -> float: ...
    def combinedMatrix(self) -> QMatrix: ...
    @typing.overload
    def drawImage(self, targetRect: QtCore.QRectF, image: QImage, sourceRect: QtCore.QRectF, flags: typing.Union[QtCore.Qt.ImageConversionFlags, QtCore.Qt.ImageConversionFlag] = ...) -> None: ...
    @typing.overload
    def drawImage(self, targetRect: QtCore.QRect, image: QImage, sourceRect: QtCore.QRect, flags: typing.Union[QtCore.Qt.ImageConversionFlags, QtCore.Qt.ImageConversionFlag] = ...) -> None: ...
    @typing.overload
    def drawImage(self, p: typing.Union[QtCore.QPointF, QtCore.QPoint], image: QImage, sr: QtCore.QRectF, flags: typing.Union[QtCore.Qt.ImageConversionFlags, QtCore.Qt.ImageConversionFlag] = ...) -> None: ...
    @typing.overload
    def drawImage(self, p: QtCore.QPoint, image: QImage, sr: QtCore.QRect, flags: typing.Union[QtCore.Qt.ImageConversionFlags, QtCore.Qt.ImageConversionFlag] = ...) -> None: ...
    @typing.overload
    def drawImage(self, r: QtCore.QRectF, image: QImage) -> None: ...
    @typing.overload
    def drawImage(self, r: QtCore.QRect, image: QImage) -> None: ...
    @typing.overload
    def drawImage(self, p: typing.Union[QtCore.QPointF, QtCore.QPoint], image: QImage) -> None: ...
    @typing.overload
    def drawImage(self, p: QtCore.QPoint, image: QImage) -> None: ...
    @typing.overload
    def drawImage(self, x: int, y: int, image: QImage, sx: int = ..., sy: int = ..., sw: int = ..., sh: int = ..., flags: typing.Union[QtCore.Qt.ImageConversionFlags, QtCore.Qt.ImageConversionFlag] = ...) -> None: ...
    @typing.overload
    def drawPoint(self, p: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @typing.overload
    def drawPoint(self, x: int, y: int) -> None: ...
    @typing.overload
    def drawPoint(self, p: QtCore.QPoint) -> None: ...
    @typing.overload
    def drawRect(self, rect: QtCore.QRectF) -> None: ...
    @typing.overload
    def drawRect(self, x: int, y: int, w: int, h: int) -> None: ...
    @typing.overload
    def drawRect(self, r: QtCore.QRect) -> None: ...
    @typing.overload
    def drawLine(self, l: QtCore.QLineF) -> None: ...
    @typing.overload
    def drawLine(self, line: QtCore.QLine) -> None: ...
    @typing.overload
    def drawLine(self, x1: int, y1: int, x2: int, y2: int) -> None: ...
    @typing.overload
    def drawLine(self, p1: QtCore.QPoint, p2: QtCore.QPoint) -> None: ...
    @typing.overload
    def drawLine(self, p1: typing.Union[QtCore.QPointF, QtCore.QPoint], p2: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @staticmethod
    def restoreRedirected(device: QPaintDevice) -> None: ...
    @staticmethod
    def redirected(device: QPaintDevice, offset: typing.Optional[QtCore.QPoint] = ...) -> QPaintDevice: ...
    @staticmethod
    def setRedirected(device: QPaintDevice, replacement: QPaintDevice, offset: QtCore.QPoint = ...) -> None: ...
    def paintEngine(self) -> 'QPaintEngine': ...
    def setRenderHints(self, hints: 'QPainter.RenderHints', on: bool = ...) -> None: ...
    def renderHints(self) -> 'QPainter.RenderHints': ...
    def setRenderHint(self, hint: 'QPainter.RenderHint', on: bool = ...) -> None: ...
    @typing.overload
    def eraseRect(self, a0: QtCore.QRectF) -> None: ...
    @typing.overload
    def eraseRect(self, rect: QtCore.QRect) -> None: ...
    @typing.overload
    def eraseRect(self, x: int, y: int, w: int, h: int) -> None: ...
    @typing.overload
    def fillRect(self, a0: QtCore.QRectF, a1: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    @typing.overload
    def fillRect(self, a0: QtCore.QRect, a1: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    @typing.overload
    def fillRect(self, x: int, y: int, w: int, h: int, b: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    @typing.overload
    def fillRect(self, a0: QtCore.QRectF, color: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    @typing.overload
    def fillRect(self, a0: QtCore.QRect, color: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    @typing.overload
    def fillRect(self, x: int, y: int, w: int, h: int, b: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    @typing.overload
    def fillRect(self, x: int, y: int, w: int, h: int, c: QtCore.Qt.GlobalColor) -> None: ...
    @typing.overload
    def fillRect(self, r: QtCore.QRect, c: QtCore.Qt.GlobalColor) -> None: ...
    @typing.overload
    def fillRect(self, r: QtCore.QRectF, c: QtCore.Qt.GlobalColor) -> None: ...
    @typing.overload
    def fillRect(self, x: int, y: int, w: int, h: int, style: QtCore.Qt.BrushStyle) -> None: ...
    @typing.overload
    def fillRect(self, r: QtCore.QRect, style: QtCore.Qt.BrushStyle) -> None: ...
    @typing.overload
    def fillRect(self, r: QtCore.QRectF, style: QtCore.Qt.BrushStyle) -> None: ...
    @typing.overload
    def boundingRect(self, rect: QtCore.QRectF, flags: int, text: str) -> QtCore.QRectF: ...
    @typing.overload
    def boundingRect(self, rect: QtCore.QRect, flags: int, text: str) -> QtCore.QRect: ...
    @typing.overload
    def boundingRect(self, rectangle: QtCore.QRectF, text: str, option: 'QTextOption' = ...) -> QtCore.QRectF: ...
    @typing.overload
    def boundingRect(self, x: int, y: int, w: int, h: int, flags: int, text: str) -> QtCore.QRect: ...
    @typing.overload
    def drawText(self, p: typing.Union[QtCore.QPointF, QtCore.QPoint], s: str) -> None: ...
    @typing.overload
    def drawText(self, rectangle: QtCore.QRectF, flags: int, text: str) -> QtCore.QRectF: ...
    @typing.overload
    def drawText(self, rectangle: QtCore.QRect, flags: int, text: str) -> QtCore.QRect: ...
    @typing.overload
    def drawText(self, rectangle: QtCore.QRectF, text: str, option: 'QTextOption' = ...) -> None: ...
    @typing.overload
    def drawText(self, p: QtCore.QPoint, s: str) -> None: ...
    @typing.overload
    def drawText(self, x: int, y: int, width: int, height: int, flags: int, text: str) -> QtCore.QRect: ...
    @typing.overload
    def drawText(self, x: int, y: int, s: str) -> None: ...
    def layoutDirection(self) -> QtCore.Qt.LayoutDirection: ...
    def setLayoutDirection(self, direction: QtCore.Qt.LayoutDirection) -> None: ...
    @typing.overload
    def drawPixmap(self, targetRect: QtCore.QRectF, pixmap: QPixmap, sourceRect: QtCore.QRectF) -> None: ...
    @typing.overload
    def drawPixmap(self, targetRect: QtCore.QRect, pixmap: QPixmap, sourceRect: QtCore.QRect) -> None: ...
    @typing.overload
    def drawPixmap(self, p: typing.Union[QtCore.QPointF, QtCore.QPoint], pm: QPixmap) -> None: ...
    @typing.overload
    def drawPixmap(self, p: QtCore.QPoint, pm: QPixmap) -> None: ...
    @typing.overload
    def drawPixmap(self, r: QtCore.QRect, pm: QPixmap) -> None: ...
    @typing.overload
    def drawPixmap(self, x: int, y: int, pm: QPixmap) -> None: ...
    @typing.overload
    def drawPixmap(self, x: int, y: int, w: int, h: int, pm: QPixmap) -> None: ...
    @typing.overload
    def drawPixmap(self, x: int, y: int, w: int, h: int, pm: QPixmap, sx: int, sy: int, sw: int, sh: int) -> None: ...
    @typing.overload
    def drawPixmap(self, x: int, y: int, pm: QPixmap, sx: int, sy: int, sw: int, sh: int) -> None: ...
    @typing.overload
    def drawPixmap(self, p: typing.Union[QtCore.QPointF, QtCore.QPoint], pm: QPixmap, sr: QtCore.QRectF) -> None: ...
    @typing.overload
    def drawPixmap(self, p: QtCore.QPoint, pm: QPixmap, sr: QtCore.QRect) -> None: ...
    @typing.overload
    def drawPicture(self, p: typing.Union[QtCore.QPointF, QtCore.QPoint], picture: 'QPicture') -> None: ...
    @typing.overload
    def drawPicture(self, x: int, y: int, p: 'QPicture') -> None: ...
    @typing.overload
    def drawPicture(self, pt: QtCore.QPoint, p: 'QPicture') -> None: ...
    @typing.overload
    def drawTiledPixmap(self, rectangle: QtCore.QRectF, pixmap: QPixmap, pos: typing.Union[QtCore.QPointF, QtCore.QPoint] = ...) -> None: ...
    @typing.overload
    def drawTiledPixmap(self, rectangle: QtCore.QRect, pixmap: QPixmap, pos: QtCore.QPoint = ...) -> None: ...
    @typing.overload
    def drawTiledPixmap(self, x: int, y: int, width: int, height: int, pixmap: QPixmap, sx: int = ..., sy: int = ...) -> None: ...
    @typing.overload
    def drawRoundRect(self, r: QtCore.QRectF, xRound: int = ..., yRound: int = ...) -> None: ...
    @typing.overload
    def drawRoundRect(self, x: int, y: int, w: int, h: int, xRound: int = ..., yRound: int = ...) -> None: ...
    @typing.overload
    def drawRoundRect(self, r: QtCore.QRect, xRound: int = ..., yRound: int = ...) -> None: ...
    @typing.overload
    def drawChord(self, rect: QtCore.QRectF, a: int, alen: int) -> None: ...
    @typing.overload
    def drawChord(self, rect: QtCore.QRect, a: int, alen: int) -> None: ...
    @typing.overload
    def drawChord(self, x: int, y: int, w: int, h: int, a: int, alen: int) -> None: ...
    @typing.overload
    def drawPie(self, rect: QtCore.QRectF, a: int, alen: int) -> None: ...
    @typing.overload
    def drawPie(self, rect: QtCore.QRect, a: int, alen: int) -> None: ...
    @typing.overload
    def drawPie(self, x: int, y: int, w: int, h: int, a: int, alen: int) -> None: ...
    @typing.overload
    def drawArc(self, rect: QtCore.QRectF, a: int, alen: int) -> None: ...
    @typing.overload
    def drawArc(self, r: QtCore.QRect, a: int, alen: int) -> None: ...
    @typing.overload
    def drawArc(self, x: int, y: int, w: int, h: int, a: int, alen: int) -> None: ...
    @typing.overload
    def drawConvexPolygon(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint], *a1) -> None: ...
    @typing.overload
    def drawConvexPolygon(self, poly: 'QPolygonF') -> None: ...
    @typing.overload
    def drawConvexPolygon(self, point: QtCore.QPoint, *a1) -> None: ...
    @typing.overload
    def drawConvexPolygon(self, poly: 'QPolygon') -> None: ...
    @typing.overload
    def drawPolygon(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint], *a1) -> None: ...
    @typing.overload
    def drawPolygon(self, points: 'QPolygonF', fillRule: QtCore.Qt.FillRule = ...) -> None: ...
    @typing.overload
    def drawPolygon(self, point: QtCore.QPoint, *a1) -> None: ...
    @typing.overload
    def drawPolygon(self, points: 'QPolygon', fillRule: QtCore.Qt.FillRule = ...) -> None: ...
    @typing.overload
    def drawPolyline(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint], *a1) -> None: ...
    @typing.overload
    def drawPolyline(self, polyline: 'QPolygonF') -> None: ...
    @typing.overload
    def drawPolyline(self, point: QtCore.QPoint, *a1) -> None: ...
    @typing.overload
    def drawPolyline(self, polyline: 'QPolygon') -> None: ...
    @typing.overload
    def drawEllipse(self, r: QtCore.QRectF) -> None: ...
    @typing.overload
    def drawEllipse(self, r: QtCore.QRect) -> None: ...
    @typing.overload
    def drawEllipse(self, x: int, y: int, w: int, h: int) -> None: ...
    @typing.overload
    def drawEllipse(self, center: typing.Union[QtCore.QPointF, QtCore.QPoint], rx: float, ry: float) -> None: ...
    @typing.overload
    def drawEllipse(self, center: QtCore.QPoint, rx: int, ry: int) -> None: ...
    @typing.overload
    def drawRects(self, rect: QtCore.QRectF, *a1) -> None: ...
    @typing.overload
    def drawRects(self, rects: typing.List[QtCore.QRectF]) -> None: ...
    @typing.overload
    def drawRects(self, rect: QtCore.QRect, *a1) -> None: ...
    @typing.overload
    def drawRects(self, rects: typing.List[QtCore.QRect]) -> None: ...
    @typing.overload
    def drawLines(self, line: QtCore.QLineF, *a1) -> None: ...
    @typing.overload
    def drawLines(self, lines: typing.List[QtCore.QLineF]) -> None: ...
    @typing.overload
    def drawLines(self, pointPair: typing.Union[QtCore.QPointF, QtCore.QPoint], *a1) -> None: ...
    @typing.overload
    def drawLines(self, pointPairs: typing.List[typing.Union[QtCore.QPointF, QtCore.QPoint]]) -> None: ...
    @typing.overload
    def drawLines(self, line: QtCore.QLine, *a1) -> None: ...
    @typing.overload
    def drawLines(self, lines: typing.List[QtCore.QLine]) -> None: ...
    @typing.overload
    def drawLines(self, pointPair: QtCore.QPoint, *a1) -> None: ...
    @typing.overload
    def drawLines(self, pointPairs: typing.List[QtCore.QPoint]) -> None: ...
    @typing.overload
    def drawPoints(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint], *a1) -> None: ...
    @typing.overload
    def drawPoints(self, points: 'QPolygonF') -> None: ...
    @typing.overload
    def drawPoints(self, point: QtCore.QPoint, *a1) -> None: ...
    @typing.overload
    def drawPoints(self, points: 'QPolygon') -> None: ...
    def drawPath(self, path: 'QPainterPath') -> None: ...
    def fillPath(self, path: 'QPainterPath', brush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def strokePath(self, path: 'QPainterPath', pen: typing.Union['QPen', QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def viewTransformEnabled(self) -> bool: ...
    def setViewTransformEnabled(self, enable: bool) -> None: ...
    @typing.overload
    def setViewport(self, viewport: QtCore.QRect) -> None: ...
    @typing.overload
    def setViewport(self, x: int, y: int, w: int, h: int) -> None: ...
    def viewport(self) -> QtCore.QRect: ...
    @typing.overload
    def setWindow(self, window: QtCore.QRect) -> None: ...
    @typing.overload
    def setWindow(self, x: int, y: int, w: int, h: int) -> None: ...
    def window(self) -> QtCore.QRect: ...
    @typing.overload
    def translate(self, offset: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @typing.overload
    def translate(self, dx: float, dy: float) -> None: ...
    @typing.overload
    def translate(self, offset: QtCore.QPoint) -> None: ...
    def rotate(self, a: float) -> None: ...
    def shear(self, sh: float, sv: float) -> None: ...
    def scale(self, sx: float, sy: float) -> None: ...
    def matrixEnabled(self) -> bool: ...
    def setMatrixEnabled(self, enabled: bool) -> None: ...
    def resetMatrix(self) -> None: ...
    def deviceMatrix(self) -> QMatrix: ...
    def matrix(self) -> QMatrix: ...
    def setMatrix(self, matrix: QMatrix, combine: bool = ...) -> None: ...
    def restore(self) -> None: ...
    def save(self) -> None: ...
    def hasClipping(self) -> bool: ...
    def setClipping(self, enable: bool) -> None: ...
    def setClipPath(self, path: 'QPainterPath', operation: QtCore.Qt.ClipOperation = ...) -> None: ...
    def setClipRegion(self, region: 'QRegion', operation: QtCore.Qt.ClipOperation = ...) -> None: ...
    @typing.overload
    def setClipRect(self, rectangle: QtCore.QRectF, operation: QtCore.Qt.ClipOperation = ...) -> None: ...
    @typing.overload
    def setClipRect(self, x: int, y: int, width: int, height: int, operation: QtCore.Qt.ClipOperation = ...) -> None: ...
    @typing.overload
    def setClipRect(self, rectangle: QtCore.QRect, operation: QtCore.Qt.ClipOperation = ...) -> None: ...
    def clipPath(self) -> 'QPainterPath': ...
    def clipRegion(self) -> 'QRegion': ...
    def background(self) -> QBrush: ...
    def setBackground(self, bg: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    @typing.overload
    def setBrushOrigin(self, a0: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @typing.overload
    def setBrushOrigin(self, x: int, y: int) -> None: ...
    @typing.overload
    def setBrushOrigin(self, p: QtCore.QPoint) -> None: ...
    def brushOrigin(self) -> QtCore.QPoint: ...
    def backgroundMode(self) -> QtCore.Qt.BGMode: ...
    def setBackgroundMode(self, mode: QtCore.Qt.BGMode) -> None: ...
    def brush(self) -> QBrush: ...
    @typing.overload
    def setBrush(self, brush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    @typing.overload
    def setBrush(self, style: QtCore.Qt.BrushStyle) -> None: ...
    def pen(self) -> 'QPen': ...
    @typing.overload
    def setPen(self, color: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    @typing.overload
    def setPen(self, pen: typing.Union['QPen', QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    @typing.overload
    def setPen(self, style: QtCore.Qt.PenStyle) -> None: ...
    def fontInfo(self) -> QFontInfo: ...
    def fontMetrics(self) -> QFontMetrics: ...
    def setFont(self, f: QFont) -> None: ...
    def font(self) -> QFont: ...
    def compositionMode(self) -> 'QPainter.CompositionMode': ...
    def setCompositionMode(self, mode: 'QPainter.CompositionMode') -> None: ...
    def initFrom(self, widget: QWidget) -> None: ...
    def isActive(self) -> bool: ...
    def end(self) -> bool: ...
    def begin(self, a0: QPaintDevice) -> bool: ...
    def device(self) -> QPaintDevice: ...
    def __exit__(self, type: typing.Any, value: typing.Any, traceback: typing.Any) -> None: ...
    def __enter__(self) -> typing.Any: ...


class QTextItem(sip.simplewrapper):

    class RenderFlag(int): ...
    RightToLeft = ... # type: 'QTextItem.RenderFlag'
    Overline = ... # type: 'QTextItem.RenderFlag'
    Underline = ... # type: 'QTextItem.RenderFlag'
    StrikeOut = ... # type: 'QTextItem.RenderFlag'

    class RenderFlags(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QTextItem.RenderFlags', 'QTextItem.RenderFlag']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QTextItem.RenderFlags') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QTextItem.RenderFlags': ...
        def __int__(self) -> int: ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QTextItem') -> None: ...

    def font(self) -> QFont: ...
    def text(self) -> str: ...
    def renderFlags(self) -> 'QTextItem.RenderFlags': ...
    def width(self) -> float: ...
    def ascent(self) -> float: ...
    def descent(self) -> float: ...


class QPaintEngine(sip.simplewrapper):

    class Type(int): ...
    X11 = ... # type: 'QPaintEngine.Type'
    Windows = ... # type: 'QPaintEngine.Type'
    QuickDraw = ... # type: 'QPaintEngine.Type'
    CoreGraphics = ... # type: 'QPaintEngine.Type'
    MacPrinter = ... # type: 'QPaintEngine.Type'
    QWindowSystem = ... # type: 'QPaintEngine.Type'
    PostScript = ... # type: 'QPaintEngine.Type'
    OpenGL = ... # type: 'QPaintEngine.Type'
    Picture = ... # type: 'QPaintEngine.Type'
    SVG = ... # type: 'QPaintEngine.Type'
    Raster = ... # type: 'QPaintEngine.Type'
    Direct3D = ... # type: 'QPaintEngine.Type'
    Pdf = ... # type: 'QPaintEngine.Type'
    OpenVG = ... # type: 'QPaintEngine.Type'
    OpenGL2 = ... # type: 'QPaintEngine.Type'
    PaintBuffer = ... # type: 'QPaintEngine.Type'
    Blitter = ... # type: 'QPaintEngine.Type'
    User = ... # type: 'QPaintEngine.Type'
    MaxUser = ... # type: 'QPaintEngine.Type'

    class PolygonDrawMode(int): ...
    OddEvenMode = ... # type: 'QPaintEngine.PolygonDrawMode'
    WindingMode = ... # type: 'QPaintEngine.PolygonDrawMode'
    ConvexMode = ... # type: 'QPaintEngine.PolygonDrawMode'
    PolylineMode = ... # type: 'QPaintEngine.PolygonDrawMode'

    class DirtyFlag(int): ...
    DirtyPen = ... # type: 'QPaintEngine.DirtyFlag'
    DirtyBrush = ... # type: 'QPaintEngine.DirtyFlag'
    DirtyBrushOrigin = ... # type: 'QPaintEngine.DirtyFlag'
    DirtyFont = ... # type: 'QPaintEngine.DirtyFlag'
    DirtyBackground = ... # type: 'QPaintEngine.DirtyFlag'
    DirtyBackgroundMode = ... # type: 'QPaintEngine.DirtyFlag'
    DirtyTransform = ... # type: 'QPaintEngine.DirtyFlag'
    DirtyClipRegion = ... # type: 'QPaintEngine.DirtyFlag'
    DirtyClipPath = ... # type: 'QPaintEngine.DirtyFlag'
    DirtyHints = ... # type: 'QPaintEngine.DirtyFlag'
    DirtyCompositionMode = ... # type: 'QPaintEngine.DirtyFlag'
    DirtyClipEnabled = ... # type: 'QPaintEngine.DirtyFlag'
    DirtyOpacity = ... # type: 'QPaintEngine.DirtyFlag'
    AllDirty = ... # type: 'QPaintEngine.DirtyFlag'

    class PaintEngineFeature(int): ...
    PrimitiveTransform = ... # type: 'QPaintEngine.PaintEngineFeature'
    PatternTransform = ... # type: 'QPaintEngine.PaintEngineFeature'
    PixmapTransform = ... # type: 'QPaintEngine.PaintEngineFeature'
    PatternBrush = ... # type: 'QPaintEngine.PaintEngineFeature'
    LinearGradientFill = ... # type: 'QPaintEngine.PaintEngineFeature'
    RadialGradientFill = ... # type: 'QPaintEngine.PaintEngineFeature'
    ConicalGradientFill = ... # type: 'QPaintEngine.PaintEngineFeature'
    AlphaBlend = ... # type: 'QPaintEngine.PaintEngineFeature'
    PorterDuff = ... # type: 'QPaintEngine.PaintEngineFeature'
    PainterPaths = ... # type: 'QPaintEngine.PaintEngineFeature'
    Antialiasing = ... # type: 'QPaintEngine.PaintEngineFeature'
    BrushStroke = ... # type: 'QPaintEngine.PaintEngineFeature'
    ConstantOpacity = ... # type: 'QPaintEngine.PaintEngineFeature'
    MaskedBrush = ... # type: 'QPaintEngine.PaintEngineFeature'
    PaintOutsidePaintEvent = ... # type: 'QPaintEngine.PaintEngineFeature'
    PerspectiveTransform = ... # type: 'QPaintEngine.PaintEngineFeature'
    BlendModes = ... # type: 'QPaintEngine.PaintEngineFeature'
    ObjectBoundingModeGradients = ... # type: 'QPaintEngine.PaintEngineFeature'
    RasterOpModes = ... # type: 'QPaintEngine.PaintEngineFeature'
    AllFeatures = ... # type: 'QPaintEngine.PaintEngineFeature'

    class PaintEngineFeatures(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QPaintEngine.PaintEngineFeatures', 'QPaintEngine.PaintEngineFeature']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QPaintEngine.PaintEngineFeatures') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QPaintEngine.PaintEngineFeatures': ...
        def __int__(self) -> int: ...

    class DirtyFlags(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QPaintEngine.DirtyFlags', 'QPaintEngine.DirtyFlag']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QPaintEngine.DirtyFlags') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QPaintEngine.DirtyFlags': ...
        def __int__(self) -> int: ...

    def __init__(self, features: 'QPaintEngine.PaintEngineFeatures' = ...) -> None: ...

    def painter(self) -> QPainter: ...
    def hasFeature(self, feature: 'QPaintEngine.PaintEngineFeatures') -> bool: ...
    def type(self) -> 'QPaintEngine.Type': ...
    def paintDevice(self) -> QPaintDevice: ...
    def setPaintDevice(self, device: QPaintDevice) -> None: ...
    def drawImage(self, r: QtCore.QRectF, pm: QImage, sr: QtCore.QRectF, flags: typing.Union[QtCore.Qt.ImageConversionFlags, QtCore.Qt.ImageConversionFlag] = ...) -> None: ...
    def drawTiledPixmap(self, r: QtCore.QRectF, pixmap: QPixmap, s: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def drawTextItem(self, p: typing.Union[QtCore.QPointF, QtCore.QPoint], textItem: QTextItem) -> None: ...
    def drawPixmap(self, r: QtCore.QRectF, pm: QPixmap, sr: QtCore.QRectF) -> None: ...
    @typing.overload
    def drawPolygon(self, points: typing.Union[QtCore.QPointF, QtCore.QPoint], mode: 'QPaintEngine.PolygonDrawMode') -> None: ...
    @typing.overload
    def drawPolygon(self, points: QtCore.QPoint, mode: 'QPaintEngine.PolygonDrawMode') -> None: ...
    @typing.overload
    def drawPoints(self, points: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @typing.overload
    def drawPoints(self, points: QtCore.QPoint) -> None: ...
    def drawPath(self, path: 'QPainterPath') -> None: ...
    @typing.overload
    def drawEllipse(self, r: QtCore.QRectF) -> None: ...
    @typing.overload
    def drawEllipse(self, r: QtCore.QRect) -> None: ...
    @typing.overload
    def drawLines(self, lines: QtCore.QLine) -> None: ...
    @typing.overload
    def drawLines(self, lines: QtCore.QLineF) -> None: ...
    @typing.overload
    def drawRects(self, rects: QtCore.QRect) -> None: ...
    @typing.overload
    def drawRects(self, rects: QtCore.QRectF) -> None: ...
    def updateState(self, state: 'QPaintEngineState') -> None: ...
    def end(self) -> bool: ...
    def begin(self, pdev: QPaintDevice) -> bool: ...
    def setActive(self, newState: bool) -> None: ...
    def isActive(self) -> bool: ...


class QPaintEngineState(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QPaintEngineState') -> None: ...

    def penNeedsResolving(self) -> bool: ...
    def brushNeedsResolving(self) -> bool: ...
    def transform(self) -> 'QTransform': ...
    def painter(self) -> QPainter: ...
    def compositionMode(self) -> QPainter.CompositionMode: ...
    def renderHints(self) -> QPainter.RenderHints: ...
    def isClipEnabled(self) -> bool: ...
    def clipPath(self) -> 'QPainterPath': ...
    def clipRegion(self) -> 'QRegion': ...
    def clipOperation(self) -> QtCore.Qt.ClipOperation: ...
    def opacity(self) -> float: ...
    def matrix(self) -> QMatrix: ...
    def font(self) -> QFont: ...
    def backgroundMode(self) -> QtCore.Qt.BGMode: ...
    def backgroundBrush(self) -> QBrush: ...
    def brushOrigin(self) -> QtCore.QPointF: ...
    def brush(self) -> QBrush: ...
    def pen(self) -> 'QPen': ...
    def state(self) -> QPaintEngine.DirtyFlags: ...


class QPainterPath(sip.simplewrapper):

    class ElementType(int): ...
    MoveToElement = ... # type: 'QPainterPath.ElementType'
    LineToElement = ... # type: 'QPainterPath.ElementType'
    CurveToElement = ... # type: 'QPainterPath.ElementType'
    CurveToDataElement = ... # type: 'QPainterPath.ElementType'

    class Element(sip.simplewrapper):

        type = ... # type: 'QPainterPath.ElementType'
        x = ... # type: float
        y = ... # type: float

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QPainterPath.Element') -> None: ...

        def isCurveTo(self) -> bool: ...
        def isLineTo(self) -> bool: ...
        def isMoveTo(self) -> bool: ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, startPoint: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @typing.overload
    def __init__(self, other: 'QPainterPath') -> None: ...

    def swap(self, other: 'QPainterPath') -> None: ...
    @typing.overload
    def translated(self, dx: float, dy: float) -> 'QPainterPath': ...
    @typing.overload
    def translated(self, offset: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> 'QPainterPath': ...
    @typing.overload
    def translate(self, dx: float, dy: float) -> None: ...
    @typing.overload
    def translate(self, offset: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def simplified(self) -> 'QPainterPath': ...
    @typing.overload
    def addRoundedRect(self, rect: QtCore.QRectF, xRadius: float, yRadius: float, mode: QtCore.Qt.SizeMode = ...) -> None: ...
    @typing.overload
    def addRoundedRect(self, x: float, y: float, w: float, h: float, xRadius: float, yRadius: float, mode: QtCore.Qt.SizeMode = ...) -> None: ...
    def subtractedInverted(self, r: 'QPainterPath') -> 'QPainterPath': ...
    def subtracted(self, r: 'QPainterPath') -> 'QPainterPath': ...
    def intersected(self, r: 'QPainterPath') -> 'QPainterPath': ...
    def united(self, r: 'QPainterPath') -> 'QPainterPath': ...
    def slopeAtPercent(self, t: float) -> float: ...
    def angleAtPercent(self, t: float) -> float: ...
    def pointAtPercent(self, t: float) -> QtCore.QPointF: ...
    def percentAtLength(self, t: float) -> float: ...
    def length(self) -> float: ...
    @typing.overload
    def addRoundRect(self, rect: QtCore.QRectF, xRnd: int, yRnd: int) -> None: ...
    @typing.overload
    def addRoundRect(self, x: float, y: float, w: float, h: float, xRnd: int, yRnd: int) -> None: ...
    @typing.overload
    def addRoundRect(self, rect: QtCore.QRectF, roundness: int) -> None: ...
    @typing.overload
    def addRoundRect(self, x: float, y: float, w: float, h: float, roundness: int) -> None: ...
    def setElementPositionAt(self, i: int, x: float, y: float) -> None: ...
    def elementAt(self, i: int) -> 'QPainterPath.Element': ...
    def elementCount(self) -> int: ...
    def isEmpty(self) -> bool: ...
    @typing.overload
    def arcMoveTo(self, rect: QtCore.QRectF, angle: float) -> None: ...
    @typing.overload
    def arcMoveTo(self, x: float, y: float, w: float, h: float, angle: float) -> None: ...
    @typing.overload
    def toFillPolygon(self, matrix: QMatrix = ...) -> 'QPolygonF': ...
    @typing.overload
    def toFillPolygon(self, matrix: 'QTransform') -> 'QPolygonF': ...
    @typing.overload
    def toFillPolygons(self, matrix: QMatrix = ...) -> typing.List['QPolygonF']: ...
    @typing.overload
    def toFillPolygons(self, matrix: 'QTransform') -> typing.List['QPolygonF']: ...
    @typing.overload
    def toSubpathPolygons(self, matrix: QMatrix = ...) -> typing.List['QPolygonF']: ...
    @typing.overload
    def toSubpathPolygons(self, matrix: 'QTransform') -> typing.List['QPolygonF']: ...
    def toReversed(self) -> 'QPainterPath': ...
    def setFillRule(self, fillRule: QtCore.Qt.FillRule) -> None: ...
    def fillRule(self) -> QtCore.Qt.FillRule: ...
    def controlPointRect(self) -> QtCore.QRectF: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    @typing.overload
    def intersects(self, rect: QtCore.QRectF) -> bool: ...
    @typing.overload
    def intersects(self, p: 'QPainterPath') -> bool: ...
    @typing.overload
    def contains(self, pt: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> bool: ...
    @typing.overload
    def contains(self, rect: QtCore.QRectF) -> bool: ...
    @typing.overload
    def contains(self, p: 'QPainterPath') -> bool: ...
    def connectPath(self, path: 'QPainterPath') -> None: ...
    def addRegion(self, region: 'QRegion') -> None: ...
    def addPath(self, path: 'QPainterPath') -> None: ...
    @typing.overload
    def addText(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint], f: QFont, text: str) -> None: ...
    @typing.overload
    def addText(self, x: float, y: float, f: QFont, text: str) -> None: ...
    def addPolygon(self, polygon: 'QPolygonF') -> None: ...
    @typing.overload
    def addEllipse(self, rect: QtCore.QRectF) -> None: ...
    @typing.overload
    def addEllipse(self, x: float, y: float, w: float, h: float) -> None: ...
    @typing.overload
    def addEllipse(self, center: typing.Union[QtCore.QPointF, QtCore.QPoint], rx: float, ry: float) -> None: ...
    @typing.overload
    def addRect(self, rect: QtCore.QRectF) -> None: ...
    @typing.overload
    def addRect(self, x: float, y: float, w: float, h: float) -> None: ...
    def currentPosition(self) -> QtCore.QPointF: ...
    @typing.overload
    def quadTo(self, ctrlPt: typing.Union[QtCore.QPointF, QtCore.QPoint], endPt: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @typing.overload
    def quadTo(self, ctrlPtx: float, ctrlPty: float, endPtx: float, endPty: float) -> None: ...
    @typing.overload
    def cubicTo(self, ctrlPt1: typing.Union[QtCore.QPointF, QtCore.QPoint], ctrlPt2: typing.Union[QtCore.QPointF, QtCore.QPoint], endPt: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @typing.overload
    def cubicTo(self, ctrlPt1x: float, ctrlPt1y: float, ctrlPt2x: float, ctrlPt2y: float, endPtx: float, endPty: float) -> None: ...
    @typing.overload
    def arcTo(self, rect: QtCore.QRectF, startAngle: float, arcLength: float) -> None: ...
    @typing.overload
    def arcTo(self, x: float, y: float, w: float, h: float, startAngle: float, arcLenght: float) -> None: ...
    @typing.overload
    def lineTo(self, p: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @typing.overload
    def lineTo(self, x: float, y: float) -> None: ...
    @typing.overload
    def moveTo(self, p: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @typing.overload
    def moveTo(self, x: float, y: float) -> None: ...
    def closeSubpath(self) -> None: ...


class QPainterPathStroker(sip.simplewrapper):

    def __init__(self) -> None: ...

    def dashOffset(self) -> float: ...
    def setDashOffset(self, offset: float) -> None: ...
    def createStroke(self, path: QPainterPath) -> QPainterPath: ...
    def dashPattern(self) -> typing.List[float]: ...
    @typing.overload
    def setDashPattern(self, a0: QtCore.Qt.PenStyle) -> None: ...
    @typing.overload
    def setDashPattern(self, dashPattern: typing.List[float]) -> None: ...
    def curveThreshold(self) -> float: ...
    def setCurveThreshold(self, threshold: float) -> None: ...
    def miterLimit(self) -> float: ...
    def setMiterLimit(self, length: float) -> None: ...
    def joinStyle(self) -> QtCore.Qt.PenJoinStyle: ...
    def setJoinStyle(self, style: QtCore.Qt.PenJoinStyle) -> None: ...
    def capStyle(self) -> QtCore.Qt.PenCapStyle: ...
    def setCapStyle(self, style: QtCore.Qt.PenCapStyle) -> None: ...
    def width(self) -> float: ...
    def setWidth(self, width: float) -> None: ...


class QPalette(sip.simplewrapper):

    class ColorRole(int): ...
    WindowText = ... # type: 'QPalette.ColorRole'
    Foreground = ... # type: 'QPalette.ColorRole'
    Button = ... # type: 'QPalette.ColorRole'
    Light = ... # type: 'QPalette.ColorRole'
    Midlight = ... # type: 'QPalette.ColorRole'
    Dark = ... # type: 'QPalette.ColorRole'
    Mid = ... # type: 'QPalette.ColorRole'
    Text = ... # type: 'QPalette.ColorRole'
    BrightText = ... # type: 'QPalette.ColorRole'
    ButtonText = ... # type: 'QPalette.ColorRole'
    Base = ... # type: 'QPalette.ColorRole'
    Window = ... # type: 'QPalette.ColorRole'
    Background = ... # type: 'QPalette.ColorRole'
    Shadow = ... # type: 'QPalette.ColorRole'
    Highlight = ... # type: 'QPalette.ColorRole'
    HighlightedText = ... # type: 'QPalette.ColorRole'
    Link = ... # type: 'QPalette.ColorRole'
    LinkVisited = ... # type: 'QPalette.ColorRole'
    AlternateBase = ... # type: 'QPalette.ColorRole'
    ToolTipBase = ... # type: 'QPalette.ColorRole'
    ToolTipText = ... # type: 'QPalette.ColorRole'
    NColorRoles = ... # type: 'QPalette.ColorRole'
    NoRole = ... # type: 'QPalette.ColorRole'

    class ColorGroup(int): ...
    Active = ... # type: 'QPalette.ColorGroup'
    Disabled = ... # type: 'QPalette.ColorGroup'
    Inactive = ... # type: 'QPalette.ColorGroup'
    NColorGroups = ... # type: 'QPalette.ColorGroup'
    Current = ... # type: 'QPalette.ColorGroup'
    All = ... # type: 'QPalette.ColorGroup'
    Normal = ... # type: 'QPalette.ColorGroup'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, button: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    @typing.overload
    def __init__(self, button: QtCore.Qt.GlobalColor) -> None: ...
    @typing.overload
    def __init__(self, button: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient], background: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    @typing.overload
    def __init__(self, foreground: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient], button: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient], light: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient], dark: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient], mid: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient], text: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient], bright_text: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient], base: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient], background: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    @typing.overload
    def __init__(self, foreground: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient], background: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient], light: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient], dark: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient], mid: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient], text: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient], base: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    @typing.overload
    def __init__(self, palette: 'QPalette') -> None: ...
    @typing.overload
    def __init__(self, variant: typing.Any) -> None: ...

    def cacheKey(self) -> int: ...
    def isBrushSet(self, cg: 'QPalette.ColorGroup', cr: 'QPalette.ColorRole') -> bool: ...
    @typing.overload
    def setColor(self, acg: 'QPalette.ColorGroup', acr: 'QPalette.ColorRole', acolor: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    @typing.overload
    def setColor(self, acr: 'QPalette.ColorRole', acolor: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    @typing.overload
    def resolve(self, a0: 'QPalette') -> 'QPalette': ...
    @typing.overload
    def resolve(self) -> int: ...
    @typing.overload
    def resolve(self, mask: int) -> None: ...
    def serialNumber(self) -> int: ...
    def isCopyOf(self, p: 'QPalette') -> bool: ...
    def toolTipText(self) -> QBrush: ...
    def toolTipBase(self) -> QBrush: ...
    def linkVisited(self) -> QBrush: ...
    def link(self) -> QBrush: ...
    def highlightedText(self) -> QBrush: ...
    def highlight(self) -> QBrush: ...
    def shadow(self) -> QBrush: ...
    def buttonText(self) -> QBrush: ...
    def brightText(self) -> QBrush: ...
    def midlight(self) -> QBrush: ...
    def background(self) -> QBrush: ...
    def window(self) -> QBrush: ...
    def alternateBase(self) -> QBrush: ...
    def base(self) -> QBrush: ...
    def text(self) -> QBrush: ...
    def mid(self) -> QBrush: ...
    def dark(self) -> QBrush: ...
    def light(self) -> QBrush: ...
    def button(self) -> QBrush: ...
    def windowText(self) -> QBrush: ...
    def foreground(self) -> QBrush: ...
    def isEqual(self, cr1: 'QPalette.ColorGroup', cr2: 'QPalette.ColorGroup') -> bool: ...
    def setColorGroup(self, cr: 'QPalette.ColorGroup', foreground: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient], button: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient], light: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient], dark: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient], mid: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient], text: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient], bright_text: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient], base: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient], background: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    @typing.overload
    def setBrush(self, cg: 'QPalette.ColorGroup', cr: 'QPalette.ColorRole', brush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    @typing.overload
    def setBrush(self, acr: 'QPalette.ColorRole', abrush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    @typing.overload
    def brush(self, cg: 'QPalette.ColorGroup', cr: 'QPalette.ColorRole') -> QBrush: ...
    @typing.overload
    def brush(self, cr: 'QPalette.ColorRole') -> QBrush: ...
    @typing.overload
    def color(self, cg: 'QPalette.ColorGroup', cr: 'QPalette.ColorRole') -> QColor: ...
    @typing.overload
    def color(self, cr: 'QPalette.ColorRole') -> QColor: ...
    def setCurrentColorGroup(self, cg: 'QPalette.ColorGroup') -> None: ...
    def currentColorGroup(self) -> 'QPalette.ColorGroup': ...


class QPen(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: QtCore.Qt.PenStyle) -> None: ...
    @typing.overload
    def __init__(self, brush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient], width: float, style: QtCore.Qt.PenStyle = ..., cap: QtCore.Qt.PenCapStyle = ..., join: QtCore.Qt.PenJoinStyle = ...) -> None: ...
    @typing.overload
    def __init__(self, pen: typing.Union['QPen', QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    @typing.overload
    def __init__(self, variant: typing.Any) -> None: ...

    def swap(self, other: typing.Union['QPen', QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def setCosmetic(self, cosmetic: bool) -> None: ...
    def isCosmetic(self) -> bool: ...
    def setDashOffset(self, doffset: float) -> None: ...
    def dashOffset(self) -> float: ...
    def setMiterLimit(self, limit: float) -> None: ...
    def miterLimit(self) -> float: ...
    def setDashPattern(self, pattern: typing.List[float]) -> None: ...
    def dashPattern(self) -> typing.List[float]: ...
    def setJoinStyle(self, pcs: QtCore.Qt.PenJoinStyle) -> None: ...
    def joinStyle(self) -> QtCore.Qt.PenJoinStyle: ...
    def setCapStyle(self, pcs: QtCore.Qt.PenCapStyle) -> None: ...
    def capStyle(self) -> QtCore.Qt.PenCapStyle: ...
    def isSolid(self) -> bool: ...
    def setBrush(self, brush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def brush(self) -> QBrush: ...
    def setColor(self, color: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def color(self) -> QColor: ...
    def setWidth(self, width: int) -> None: ...
    def width(self) -> int: ...
    def setWidthF(self, width: float) -> None: ...
    def widthF(self) -> float: ...
    def setStyle(self, a0: QtCore.Qt.PenStyle) -> None: ...
    def style(self) -> QtCore.Qt.PenStyle: ...


class QPicture(QPaintDevice):

    @typing.overload
    def __init__(self, formatVersion: int = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QPicture') -> None: ...

    def swap(self, other: 'QPicture') -> None: ...
    def metric(self, m: QPaintDevice.PaintDeviceMetric) -> int: ...
    def paintEngine(self) -> QPaintEngine: ...
    @staticmethod
    def outputFormatList() -> typing.List[str]: ...
    @staticmethod
    def inputFormatList() -> typing.List[str]: ...
    @staticmethod
    def outputFormats() -> typing.List[QtCore.QByteArray]: ...
    @staticmethod
    def inputFormats() -> typing.List[QtCore.QByteArray]: ...
    @staticmethod
    def pictureFormat(fileName: str) -> str: ...
    def isDetached(self) -> bool: ...
    def detach(self) -> None: ...
    def setBoundingRect(self, r: QtCore.QRect) -> None: ...
    def boundingRect(self) -> QtCore.QRect: ...
    @typing.overload
    def save(self, dev: QtCore.QIODevice, format: typing.Optional[str] = ...) -> bool: ...
    @typing.overload
    def save(self, fileName: str, format: typing.Optional[str] = ...) -> bool: ...
    @typing.overload
    def load(self, dev: QtCore.QIODevice, format: typing.Optional[str] = ...) -> bool: ...
    @typing.overload
    def load(self, fileName: str, format: typing.Optional[str] = ...) -> bool: ...
    def play(self, p: QPainter) -> bool: ...
    def setData(self, data: bytes) -> None: ...
    def data(self) -> str: ...
    def size(self) -> int: ...
    def devType(self) -> int: ...
    def isNull(self) -> bool: ...


class QPictureIO(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, ioDevice: QtCore.QIODevice, format: str) -> None: ...
    @typing.overload
    def __init__(self, fileName: str, format: str) -> None: ...

    @staticmethod
    def defineIOHandler(format: str, header: str, flags: str, read_picture: typing.Optional[typing.Callable[['QPictureIO'], None]], write_picture: typing.Optional[typing.Callable[['QPictureIO'], None]]) -> None: ...
    @staticmethod
    def outputFormats() -> typing.List[QtCore.QByteArray]: ...
    @staticmethod
    def inputFormats() -> typing.List[QtCore.QByteArray]: ...
    @typing.overload
    @staticmethod
    def pictureFormat(fileName: str) -> QtCore.QByteArray: ...
    @typing.overload
    @staticmethod
    def pictureFormat(a0: QtCore.QIODevice) -> QtCore.QByteArray: ...
    def write(self) -> bool: ...
    def read(self) -> bool: ...
    def setGamma(self, a0: float) -> None: ...
    def setParameters(self, a0: str) -> None: ...
    def setDescription(self, a0: str) -> None: ...
    def setQuality(self, a0: int) -> None: ...
    def setFileName(self, a0: str) -> None: ...
    def setIODevice(self, a0: QtCore.QIODevice) -> None: ...
    def setFormat(self, a0: str) -> None: ...
    def setStatus(self, a0: int) -> None: ...
    def setPicture(self, a0: QPicture) -> None: ...
    def gamma(self) -> float: ...
    def parameters(self) -> str: ...
    def description(self) -> str: ...
    def quality(self) -> int: ...
    def fileName(self) -> str: ...
    def ioDevice(self) -> QtCore.QIODevice: ...
    def format(self) -> str: ...
    def status(self) -> int: ...
    def picture(self) -> QPicture: ...


class QPixmapCache(sip.simplewrapper):

    class Key(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, other: 'QPixmapCache.Key') -> None: ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QPixmapCache') -> None: ...

    @staticmethod
    def setCacheLimit(a0: int) -> None: ...
    @staticmethod
    def replace(key: 'QPixmapCache.Key', pixmap: QPixmap) -> bool: ...
    @typing.overload
    @staticmethod
    def remove(key: str) -> None: ...
    @typing.overload
    @staticmethod
    def remove(key: 'QPixmapCache.Key') -> None: ...
    @typing.overload
    @staticmethod
    def insert(key: str, a1: QPixmap) -> bool: ...
    @typing.overload
    @staticmethod
    def insert(pixmap: QPixmap) -> 'QPixmapCache.Key': ...
    @typing.overload
    @staticmethod
    def find(key: str) -> QPixmap: ...
    @typing.overload
    @staticmethod
    def find(key: str, pixmap: QPixmap) -> bool: ...
    @typing.overload
    @staticmethod
    def find(key: 'QPixmapCache.Key', pixmap: QPixmap) -> bool: ...
    @staticmethod
    def clear() -> None: ...
    @staticmethod
    def cacheLimit() -> int: ...


class QPlainTextEdit(QAbstractScrollArea):

    class LineWrapMode(int): ...
    NoWrap = ... # type: 'QPlainTextEdit.LineWrapMode'
    WidgetWidth = ... # type: 'QPlainTextEdit.LineWrapMode'

    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str, parent: typing.Optional[QWidget] = ...) -> None: ...

    def anchorAt(self, pos: QtCore.QPoint) -> str: ...
    def getPaintContext(self) -> QAbstractTextDocumentLayout.PaintContext: ...
    def blockBoundingGeometry(self, block: 'QTextBlock') -> QtCore.QRectF: ...
    def blockBoundingRect(self, block: 'QTextBlock') -> QtCore.QRectF: ...
    def contentOffset(self) -> QtCore.QPointF: ...
    def firstVisibleBlock(self) -> 'QTextBlock': ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def insertFromMimeData(self, source: QtCore.QMimeData) -> None: ...
    def canInsertFromMimeData(self, source: QtCore.QMimeData) -> bool: ...
    def createMimeDataFromSelection(self) -> QtCore.QMimeData: ...
    def inputMethodQuery(self, property: QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def inputMethodEvent(self, a0: QInputMethodEvent) -> None: ...
    def wheelEvent(self, e: QWheelEvent) -> None: ...
    def changeEvent(self, e: QtCore.QEvent) -> None: ...
    def showEvent(self, a0: QShowEvent) -> None: ...
    def focusOutEvent(self, e: QFocusEvent) -> None: ...
    def focusInEvent(self, e: QFocusEvent) -> None: ...
    def dropEvent(self, e: QDropEvent) -> None: ...
    def dragMoveEvent(self, e: QDragMoveEvent) -> None: ...
    def dragLeaveEvent(self, e: QDragLeaveEvent) -> None: ...
    def dragEnterEvent(self, e: QDragEnterEvent) -> None: ...
    def contextMenuEvent(self, e: QContextMenuEvent) -> None: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def mouseDoubleClickEvent(self, e: QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, e: QMouseEvent) -> None: ...
    def mouseMoveEvent(self, e: QMouseEvent) -> None: ...
    def mousePressEvent(self, e: QMouseEvent) -> None: ...
    def paintEvent(self, e: QPaintEvent) -> None: ...
    def resizeEvent(self, e: QResizeEvent) -> None: ...
    def keyReleaseEvent(self, e: QKeyEvent) -> None: ...
    def keyPressEvent(self, e: QKeyEvent) -> None: ...
    def timerEvent(self, e: QtCore.QTimerEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def modificationChanged(self, a0: bool) -> None: ...
    def blockCountChanged(self, newBlockCount: int) -> None: ...
    def updateRequest(self, rect: QtCore.QRect, dy: int) -> None: ...
    def cursorPositionChanged(self) -> None: ...
    def selectionChanged(self) -> None: ...
    def copyAvailable(self, b: bool) -> None: ...
    def redoAvailable(self, b: bool) -> None: ...
    def undoAvailable(self, b: bool) -> None: ...
    def textChanged(self) -> None: ...
    def centerCursor(self) -> None: ...
    def appendHtml(self, html: str) -> None: ...
    def appendPlainText(self, text: str) -> None: ...
    def insertPlainText(self, text: str) -> None: ...
    def selectAll(self) -> None: ...
    def clear(self) -> None: ...
    def redo(self) -> None: ...
    def undo(self) -> None: ...
    def paste(self) -> None: ...
    def copy(self) -> None: ...
    def cut(self) -> None: ...
    def setPlainText(self, text: str) -> None: ...
    def blockCount(self) -> int: ...
    def print(self, printer: 'QPrinter') -> None: ...
    def print_(self, printer: 'QPrinter') -> None: ...
    def canPaste(self) -> bool: ...
    def moveCursor(self, operation: 'QTextCursor.MoveOperation', mode: 'QTextCursor.MoveMode' = ...) -> None: ...
    def extraSelections(self) -> typing.List['QTextEdit.ExtraSelection']: ...
    def setExtraSelections(self, selections: typing.Sequence['QTextEdit.ExtraSelection']) -> None: ...
    def setCursorWidth(self, width: int) -> None: ...
    def cursorWidth(self) -> int: ...
    def setTabStopWidth(self, width: int) -> None: ...
    def tabStopWidth(self) -> int: ...
    def setOverwriteMode(self, overwrite: bool) -> None: ...
    def overwriteMode(self) -> bool: ...
    @typing.overload
    def cursorRect(self, cursor: 'QTextCursor') -> QtCore.QRect: ...
    @typing.overload
    def cursorRect(self) -> QtCore.QRect: ...
    def cursorForPosition(self, pos: QtCore.QPoint) -> 'QTextCursor': ...
    def createStandardContextMenu(self) -> QMenu: ...
    def loadResource(self, type: int, name: QtCore.QUrl) -> typing.Any: ...
    def ensureCursorVisible(self) -> None: ...
    def toPlainText(self) -> str: ...
    def find(self, exp: str, options: 'QTextDocument.FindFlags' = ...) -> bool: ...
    def centerOnScroll(self) -> bool: ...
    def setCenterOnScroll(self, enabled: bool) -> None: ...
    def backgroundVisible(self) -> bool: ...
    def setBackgroundVisible(self, visible: bool) -> None: ...
    def setWordWrapMode(self, policy: 'QTextOption.WrapMode') -> None: ...
    def wordWrapMode(self) -> 'QTextOption.WrapMode': ...
    def setLineWrapMode(self, mode: 'QPlainTextEdit.LineWrapMode') -> None: ...
    def lineWrapMode(self) -> 'QPlainTextEdit.LineWrapMode': ...
    def maximumBlockCount(self) -> int: ...
    def setMaximumBlockCount(self, maximum: int) -> None: ...
    def setUndoRedoEnabled(self, enable: bool) -> None: ...
    def isUndoRedoEnabled(self) -> bool: ...
    def documentTitle(self) -> str: ...
    def setDocumentTitle(self, title: str) -> None: ...
    def setTabChangesFocus(self, b: bool) -> None: ...
    def tabChangesFocus(self) -> bool: ...
    def currentCharFormat(self) -> 'QTextCharFormat': ...
    def setCurrentCharFormat(self, format: 'QTextCharFormat') -> None: ...
    def mergeCurrentCharFormat(self, modifier: 'QTextCharFormat') -> None: ...
    def textInteractionFlags(self) -> QtCore.Qt.TextInteractionFlags: ...
    def setTextInteractionFlags(self, flags: typing.Union[QtCore.Qt.TextInteractionFlags, QtCore.Qt.TextInteractionFlag]) -> None: ...
    def setReadOnly(self, ro: bool) -> None: ...
    def isReadOnly(self) -> bool: ...
    def textCursor(self) -> 'QTextCursor': ...
    def setTextCursor(self, cursor: 'QTextCursor') -> None: ...
    def document(self) -> 'QTextDocument': ...
    def setDocument(self, document: 'QTextDocument') -> None: ...


class QPlainTextDocumentLayout(QAbstractTextDocumentLayout):

    def __init__(self, document: 'QTextDocument') -> None: ...

    def documentChanged(self, from_: int, a1: int, charsAdded: int) -> None: ...
    def requestUpdate(self) -> None: ...
    def cursorWidth(self) -> int: ...
    def setCursorWidth(self, width: int) -> None: ...
    def ensureBlockLayout(self, block: 'QTextBlock') -> None: ...
    def blockBoundingRect(self, block: 'QTextBlock') -> QtCore.QRectF: ...
    def frameBoundingRect(self, a0: 'QTextFrame') -> QtCore.QRectF: ...
    def documentSize(self) -> QtCore.QSizeF: ...
    def pageCount(self) -> int: ...
    def hitTest(self, a0: typing.Union[QtCore.QPointF, QtCore.QPoint], a1: 'Qt.HitTestAccuracy') -> int: ...
    def draw(self, a0: QPainter, a1: QAbstractTextDocumentLayout.PaintContext) -> None: ...


class QPolygon(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a: 'QPolygon') -> None: ...
    @typing.overload
    def __init__(self, v: typing.List[QtCore.QPoint]) -> None: ...
    @typing.overload
    def __init__(self, rectangle: QtCore.QRect, closed: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, asize: int) -> None: ...
    @typing.overload
    def __init__(self, points: typing.List[int]) -> None: ...
    @typing.overload
    def __init__(self, variant: typing.Any) -> None: ...

    def swap(self, other: 'QPolygon') -> None: ...
    def __contains__(self, value: QtCore.QPoint) -> int: ...
    @typing.overload
    def __delitem__(self, i: int) -> None: ...
    @typing.overload
    def __delitem__(self, slice: slice) -> None: ...
    @typing.overload
    def __setitem__(self, i: int, value: QtCore.QPoint) -> None: ...
    @typing.overload
    def __setitem__(self, slice: slice, list: 'QPolygon') -> None: ...
    @typing.overload
    def __getitem__(self, i: int) -> QtCore.QPoint: ...
    @typing.overload
    def __getitem__(self, slice: slice) -> 'QPolygon': ...
    @typing.overload
    def value(self, i: int) -> QtCore.QPoint: ...
    @typing.overload
    def value(self, i: int, defaultValue: QtCore.QPoint) -> QtCore.QPoint: ...
    def size(self) -> int: ...
    def replace(self, i: int, value: QtCore.QPoint) -> None: ...
    @typing.overload
    def remove(self, i: int) -> None: ...
    @typing.overload
    def remove(self, i: int, count: int) -> None: ...
    def prepend(self, value: QtCore.QPoint) -> None: ...
    def mid(self, pos: int, length: int = ...) -> 'QPolygon': ...
    def lastIndexOf(self, value: QtCore.QPoint, from_: int = ...) -> int: ...
    def last(self) -> QtCore.QPoint: ...
    def isEmpty(self) -> bool: ...
    def insert(self, i: int, value: QtCore.QPoint) -> None: ...
    def indexOf(self, value: QtCore.QPoint, from_: int = ...) -> int: ...
    def first(self) -> QtCore.QPoint: ...
    def fill(self, value: QtCore.QPoint, size: int = ...) -> None: ...
    def data(self) -> sip.voidptr: ...
    def __len__(self) -> int: ...
    @typing.overload
    def count(self, value: QtCore.QPoint) -> int: ...
    @typing.overload
    def count(self) -> int: ...
    def contains(self, value: QtCore.QPoint) -> bool: ...
    def clear(self) -> None: ...
    def at(self, i: int) -> QtCore.QPoint: ...
    def append(self, value: QtCore.QPoint) -> None: ...
    @typing.overload
    def translated(self, dx: int, dy: int) -> 'QPolygon': ...
    @typing.overload
    def translated(self, offset: QtCore.QPoint) -> 'QPolygon': ...
    def subtracted(self, r: 'QPolygon') -> 'QPolygon': ...
    def intersected(self, r: 'QPolygon') -> 'QPolygon': ...
    def united(self, r: 'QPolygon') -> 'QPolygon': ...
    def containsPoint(self, pt: QtCore.QPoint, fillRule: QtCore.Qt.FillRule) -> bool: ...
    @typing.overload
    def setPoint(self, index: int, pt: QtCore.QPoint) -> None: ...
    @typing.overload
    def setPoint(self, index: int, x: int, y: int) -> None: ...
    @typing.overload
    def putPoints(self, index: int, firstx: int, firsty: int, *a3) -> None: ...
    @typing.overload
    def putPoints(self, index: int, nPoints: int, fromPolygon: 'QPolygon', from_: int = ...) -> None: ...
    @typing.overload
    def setPoints(self, points: typing.List[int]) -> None: ...
    @typing.overload
    def setPoints(self, firstx: int, firsty: int, *a2) -> None: ...
    def point(self, index: int) -> QtCore.QPoint: ...
    def boundingRect(self) -> QtCore.QRect: ...
    @typing.overload
    def translate(self, dx: int, dy: int) -> None: ...
    @typing.overload
    def translate(self, offset: QtCore.QPoint) -> None: ...


class QPolygonF(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a: 'QPolygonF') -> None: ...
    @typing.overload
    def __init__(self, v: typing.List[typing.Union[QtCore.QPointF, QtCore.QPoint]]) -> None: ...
    @typing.overload
    def __init__(self, r: QtCore.QRectF) -> None: ...
    @typing.overload
    def __init__(self, a: QPolygon) -> None: ...
    @typing.overload
    def __init__(self, asize: int) -> None: ...

    def swap(self, other: 'QPolygonF') -> None: ...
    def __contains__(self, value: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> int: ...
    @typing.overload
    def __delitem__(self, i: int) -> None: ...
    @typing.overload
    def __delitem__(self, slice: slice) -> None: ...
    @typing.overload
    def __setitem__(self, i: int, value: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @typing.overload
    def __setitem__(self, slice: slice, list: 'QPolygonF') -> None: ...
    @typing.overload
    def __getitem__(self, i: int) -> QtCore.QPointF: ...
    @typing.overload
    def __getitem__(self, slice: slice) -> 'QPolygonF': ...
    @typing.overload
    def value(self, i: int) -> QtCore.QPointF: ...
    @typing.overload
    def value(self, i: int, defaultValue: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> QtCore.QPointF: ...
    def size(self) -> int: ...
    def replace(self, i: int, value: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @typing.overload
    def remove(self, i: int) -> None: ...
    @typing.overload
    def remove(self, i: int, count: int) -> None: ...
    def prepend(self, value: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def mid(self, pos: int, length: int = ...) -> 'QPolygonF': ...
    def lastIndexOf(self, value: typing.Union[QtCore.QPointF, QtCore.QPoint], from_: int = ...) -> int: ...
    def last(self) -> QtCore.QPointF: ...
    def isEmpty(self) -> bool: ...
    def insert(self, i: int, value: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def indexOf(self, value: typing.Union[QtCore.QPointF, QtCore.QPoint], from_: int = ...) -> int: ...
    def first(self) -> QtCore.QPointF: ...
    def fill(self, value: typing.Union[QtCore.QPointF, QtCore.QPoint], size: int = ...) -> None: ...
    def data(self) -> sip.voidptr: ...
    def __len__(self) -> int: ...
    @typing.overload
    def count(self, value: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> int: ...
    @typing.overload
    def count(self) -> int: ...
    def contains(self, value: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> bool: ...
    def clear(self) -> None: ...
    def at(self, i: int) -> QtCore.QPointF: ...
    def append(self, value: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @typing.overload
    def translated(self, offset: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> 'QPolygonF': ...
    @typing.overload
    def translated(self, dx: float, dy: float) -> 'QPolygonF': ...
    def subtracted(self, r: 'QPolygonF') -> 'QPolygonF': ...
    def intersected(self, r: 'QPolygonF') -> 'QPolygonF': ...
    def united(self, r: 'QPolygonF') -> 'QPolygonF': ...
    def containsPoint(self, pt: typing.Union[QtCore.QPointF, QtCore.QPoint], fillRule: QtCore.Qt.FillRule) -> bool: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def isClosed(self) -> bool: ...
    def toPolygon(self) -> QPolygon: ...
    @typing.overload
    def translate(self, offset: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @typing.overload
    def translate(self, dx: float, dy: float) -> None: ...


class QPrinter(QPaintDevice):

    class Unit(int): ...
    Millimeter = ... # type: 'QPrinter.Unit'
    Point = ... # type: 'QPrinter.Unit'
    Inch = ... # type: 'QPrinter.Unit'
    Pica = ... # type: 'QPrinter.Unit'
    Didot = ... # type: 'QPrinter.Unit'
    Cicero = ... # type: 'QPrinter.Unit'
    DevicePixel = ... # type: 'QPrinter.Unit'

    class DuplexMode(int): ...
    DuplexNone = ... # type: 'QPrinter.DuplexMode'
    DuplexAuto = ... # type: 'QPrinter.DuplexMode'
    DuplexLongSide = ... # type: 'QPrinter.DuplexMode'
    DuplexShortSide = ... # type: 'QPrinter.DuplexMode'

    class PrintRange(int): ...
    AllPages = ... # type: 'QPrinter.PrintRange'
    Selection = ... # type: 'QPrinter.PrintRange'
    PageRange = ... # type: 'QPrinter.PrintRange'
    CurrentPage = ... # type: 'QPrinter.PrintRange'

    class OutputFormat(int): ...
    NativeFormat = ... # type: 'QPrinter.OutputFormat'
    PdfFormat = ... # type: 'QPrinter.OutputFormat'
    PostScriptFormat = ... # type: 'QPrinter.OutputFormat'

    class PrinterState(int): ...
    Idle = ... # type: 'QPrinter.PrinterState'
    Active = ... # type: 'QPrinter.PrinterState'
    Aborted = ... # type: 'QPrinter.PrinterState'
    Error = ... # type: 'QPrinter.PrinterState'

    class PaperSource(int): ...
    OnlyOne = ... # type: 'QPrinter.PaperSource'
    Lower = ... # type: 'QPrinter.PaperSource'
    Middle = ... # type: 'QPrinter.PaperSource'
    Manual = ... # type: 'QPrinter.PaperSource'
    Envelope = ... # type: 'QPrinter.PaperSource'
    EnvelopeManual = ... # type: 'QPrinter.PaperSource'
    Auto = ... # type: 'QPrinter.PaperSource'
    Tractor = ... # type: 'QPrinter.PaperSource'
    SmallFormat = ... # type: 'QPrinter.PaperSource'
    LargeFormat = ... # type: 'QPrinter.PaperSource'
    LargeCapacity = ... # type: 'QPrinter.PaperSource'
    Cassette = ... # type: 'QPrinter.PaperSource'
    FormSource = ... # type: 'QPrinter.PaperSource'
    MaxPageSource = ... # type: 'QPrinter.PaperSource'

    class ColorMode(int): ...
    GrayScale = ... # type: 'QPrinter.ColorMode'
    Color = ... # type: 'QPrinter.ColorMode'

    class PageOrder(int): ...
    FirstPageFirst = ... # type: 'QPrinter.PageOrder'
    LastPageFirst = ... # type: 'QPrinter.PageOrder'

    class PageSize(int): ...
    A4 = ... # type: 'QPrinter.PageSize'
    B5 = ... # type: 'QPrinter.PageSize'
    Letter = ... # type: 'QPrinter.PageSize'
    Legal = ... # type: 'QPrinter.PageSize'
    Executive = ... # type: 'QPrinter.PageSize'
    A0 = ... # type: 'QPrinter.PageSize'
    A1 = ... # type: 'QPrinter.PageSize'
    A2 = ... # type: 'QPrinter.PageSize'
    A3 = ... # type: 'QPrinter.PageSize'
    A5 = ... # type: 'QPrinter.PageSize'
    A6 = ... # type: 'QPrinter.PageSize'
    A7 = ... # type: 'QPrinter.PageSize'
    A8 = ... # type: 'QPrinter.PageSize'
    A9 = ... # type: 'QPrinter.PageSize'
    B0 = ... # type: 'QPrinter.PageSize'
    B1 = ... # type: 'QPrinter.PageSize'
    B10 = ... # type: 'QPrinter.PageSize'
    B2 = ... # type: 'QPrinter.PageSize'
    B3 = ... # type: 'QPrinter.PageSize'
    B4 = ... # type: 'QPrinter.PageSize'
    B6 = ... # type: 'QPrinter.PageSize'
    B7 = ... # type: 'QPrinter.PageSize'
    B8 = ... # type: 'QPrinter.PageSize'
    B9 = ... # type: 'QPrinter.PageSize'
    C5E = ... # type: 'QPrinter.PageSize'
    Comm10E = ... # type: 'QPrinter.PageSize'
    DLE = ... # type: 'QPrinter.PageSize'
    Folio = ... # type: 'QPrinter.PageSize'
    Ledger = ... # type: 'QPrinter.PageSize'
    Tabloid = ... # type: 'QPrinter.PageSize'
    Custom = ... # type: 'QPrinter.PageSize'

    class Orientation(int): ...
    Portrait = ... # type: 'QPrinter.Orientation'
    Landscape = ... # type: 'QPrinter.Orientation'

    class PrinterMode(int): ...
    ScreenResolution = ... # type: 'QPrinter.PrinterMode'
    PrinterResolution = ... # type: 'QPrinter.PrinterMode'
    HighResolution = ... # type: 'QPrinter.PrinterMode'

    @typing.overload
    def __init__(self, mode: 'QPrinter.PrinterMode' = ...) -> None: ...
    @typing.overload
    def __init__(self, printer: 'QPrinterInfo', mode: 'QPrinter.PrinterMode' = ...) -> None: ...

    def supportsMultipleCopies(self) -> bool: ...
    def copyCount(self) -> int: ...
    def setCopyCount(self, a0: int) -> None: ...
    def setEngines(self, printEngine: 'QPrintEngine', paintEngine: QPaintEngine) -> None: ...
    def metric(self, a0: QPaintDevice.PaintDeviceMetric) -> int: ...
    def actualNumCopies(self) -> int: ...
    def getPageMargins(self, unit: 'QPrinter.Unit') -> typing.Tuple[float, float, float, float]: ...
    def setPageMargins(self, left: float, top: float, right: float, bottom: float, unit: 'QPrinter.Unit') -> None: ...
    def duplex(self) -> 'QPrinter.DuplexMode': ...
    def setDuplex(self, duplex: 'QPrinter.DuplexMode') -> None: ...
    @typing.overload
    def paperSize(self) -> 'QPrinter.PageSize': ...
    @typing.overload
    def paperSize(self, unit: 'QPrinter.Unit') -> QtCore.QSizeF: ...
    @typing.overload
    def setPaperSize(self, a0: 'QPrinter.PageSize') -> None: ...
    @typing.overload
    def setPaperSize(self, paperSize: QtCore.QSizeF, unit: 'QPrinter.Unit') -> None: ...
    def isValid(self) -> bool: ...
    def doubleSidedPrinting(self) -> bool: ...
    def setDoubleSidedPrinting(self, enable: bool) -> None: ...
    def printRange(self) -> 'QPrinter.PrintRange': ...
    def setPrintRange(self, range: 'QPrinter.PrintRange') -> None: ...
    def toPage(self) -> int: ...
    def fromPage(self) -> int: ...
    def setFromTo(self, fromPage: int, toPage: int) -> None: ...
    def printEngine(self) -> 'QPrintEngine': ...
    def fontEmbeddingEnabled(self) -> bool: ...
    def setFontEmbeddingEnabled(self, enable: bool) -> None: ...
    def outputFormat(self) -> 'QPrinter.OutputFormat': ...
    def setOutputFormat(self, format: 'QPrinter.OutputFormat') -> None: ...
    def paintEngine(self) -> QPaintEngine: ...
    def printerState(self) -> 'QPrinter.PrinterState': ...
    def abort(self) -> bool: ...
    def newPage(self) -> bool: ...
    def setPrinterSelectionOption(self, a0: str) -> None: ...
    def printerSelectionOption(self) -> str: ...
    @typing.overload
    def pageRect(self) -> QtCore.QRect: ...
    @typing.overload
    def pageRect(self, a0: 'QPrinter.Unit') -> QtCore.QRectF: ...
    @typing.overload
    def paperRect(self) -> QtCore.QRect: ...
    @typing.overload
    def paperRect(self, a0: 'QPrinter.Unit') -> QtCore.QRectF: ...
    def supportedResolutions(self) -> typing.List[int]: ...
    def paperSource(self) -> 'QPrinter.PaperSource': ...
    def setPaperSource(self, a0: 'QPrinter.PaperSource') -> None: ...
    def numCopies(self) -> int: ...
    def setNumCopies(self, a0: int) -> None: ...
    def fullPage(self) -> bool: ...
    def setFullPage(self, a0: bool) -> None: ...
    def collateCopies(self) -> bool: ...
    def setCollateCopies(self, collate: bool) -> None: ...
    def colorMode(self) -> 'QPrinter.ColorMode': ...
    def setColorMode(self, a0: 'QPrinter.ColorMode') -> None: ...
    def resolution(self) -> int: ...
    def setResolution(self, a0: int) -> None: ...
    def pageOrder(self) -> 'QPrinter.PageOrder': ...
    def setPageOrder(self, a0: 'QPrinter.PageOrder') -> None: ...
    def pageSize(self) -> 'QPrinter.PageSize': ...
    def setPageSize(self, a0: 'QPrinter.PageSize') -> None: ...
    def orientation(self) -> 'QPrinter.Orientation': ...
    def setOrientation(self, a0: 'QPrinter.Orientation') -> None: ...
    def creator(self) -> str: ...
    def setCreator(self, a0: str) -> None: ...
    def docName(self) -> str: ...
    def setDocName(self, a0: str) -> None: ...
    def printProgram(self) -> str: ...
    def setPrintProgram(self, a0: str) -> None: ...
    def outputFileName(self) -> str: ...
    def setOutputFileName(self, a0: str) -> None: ...
    def printerName(self) -> str: ...
    def setPrinterName(self, a0: str) -> None: ...


class QPrintDialog(QAbstractPrintDialog):

    @typing.overload
    def __init__(self, printer: QPrinter, parent: typing.Optional[QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...

    @typing.overload
    def accepted(self) -> None: ...
    @typing.overload
    def accepted(self, printer: QPrinter) -> None: ...
    @typing.overload
    def open(self) -> None: ...
    @typing.overload
    def open(self, receiver: QtCore.QObject, member: QT_SLOT) -> None: ...
    @typing.overload
    def open(self, slot: PYQT_SLOT) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def options(self) -> QAbstractPrintDialog.PrintDialogOptions: ...
    def setOptions(self, options: QAbstractPrintDialog.PrintDialogOptions) -> None: ...
    def testOption(self, option: QAbstractPrintDialog.PrintDialogOption) -> bool: ...
    def setOption(self, option: QAbstractPrintDialog.PrintDialogOption, on: bool = ...) -> None: ...
    def done(self, result: int) -> None: ...
    def accept(self) -> None: ...
    def exec(self) -> int: ...
    def exec_(self) -> int: ...


class QPrintEngine(sip.simplewrapper):

    class PrintEnginePropertyKey(int): ...
    PPK_CollateCopies = ... # type: 'QPrintEngine.PrintEnginePropertyKey'
    PPK_ColorMode = ... # type: 'QPrintEngine.PrintEnginePropertyKey'
    PPK_Creator = ... # type: 'QPrintEngine.PrintEnginePropertyKey'
    PPK_DocumentName = ... # type: 'QPrintEngine.PrintEnginePropertyKey'
    PPK_FullPage = ... # type: 'QPrintEngine.PrintEnginePropertyKey'
    PPK_NumberOfCopies = ... # type: 'QPrintEngine.PrintEnginePropertyKey'
    PPK_Orientation = ... # type: 'QPrintEngine.PrintEnginePropertyKey'
    PPK_OutputFileName = ... # type: 'QPrintEngine.PrintEnginePropertyKey'
    PPK_PageOrder = ... # type: 'QPrintEngine.PrintEnginePropertyKey'
    PPK_PageRect = ... # type: 'QPrintEngine.PrintEnginePropertyKey'
    PPK_PageSize = ... # type: 'QPrintEngine.PrintEnginePropertyKey'
    PPK_PaperRect = ... # type: 'QPrintEngine.PrintEnginePropertyKey'
    PPK_PaperSource = ... # type: 'QPrintEngine.PrintEnginePropertyKey'
    PPK_PrinterName = ... # type: 'QPrintEngine.PrintEnginePropertyKey'
    PPK_PrinterProgram = ... # type: 'QPrintEngine.PrintEnginePropertyKey'
    PPK_Resolution = ... # type: 'QPrintEngine.PrintEnginePropertyKey'
    PPK_SelectionOption = ... # type: 'QPrintEngine.PrintEnginePropertyKey'
    PPK_SupportedResolutions = ... # type: 'QPrintEngine.PrintEnginePropertyKey'
    PPK_WindowsPageSize = ... # type: 'QPrintEngine.PrintEnginePropertyKey'
    PPK_FontEmbedding = ... # type: 'QPrintEngine.PrintEnginePropertyKey'
    PPK_SuppressSystemPrintStatus = ... # type: 'QPrintEngine.PrintEnginePropertyKey'
    PPK_Duplex = ... # type: 'QPrintEngine.PrintEnginePropertyKey'
    PPK_PaperSources = ... # type: 'QPrintEngine.PrintEnginePropertyKey'
    PPK_CustomPaperSize = ... # type: 'QPrintEngine.PrintEnginePropertyKey'
    PPK_PageMargins = ... # type: 'QPrintEngine.PrintEnginePropertyKey'
    PPK_PaperSize = ... # type: 'QPrintEngine.PrintEnginePropertyKey'
    PPK_CopyCount = ... # type: 'QPrintEngine.PrintEnginePropertyKey'
    PPK_SupportsMultipleCopies = ... # type: 'QPrintEngine.PrintEnginePropertyKey'
    PPK_CustomBase = ... # type: 'QPrintEngine.PrintEnginePropertyKey'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QPrintEngine') -> None: ...

    def printerState(self) -> QPrinter.PrinterState: ...
    def metric(self, a0: QPaintDevice.PaintDeviceMetric) -> int: ...
    def abort(self) -> bool: ...
    def newPage(self) -> bool: ...
    def property(self, key: 'QPrintEngine.PrintEnginePropertyKey') -> typing.Any: ...
    def setProperty(self, key: 'QPrintEngine.PrintEnginePropertyKey', value: typing.Any) -> None: ...


class QPrinterInfo(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, src: 'QPrinterInfo') -> None: ...
    @typing.overload
    def __init__(self, printer: QPrinter) -> None: ...

    @staticmethod
    def defaultPrinter() -> 'QPrinterInfo': ...
    @staticmethod
    def availablePrinters() -> typing.List['QPrinterInfo']: ...
    def supportedPaperSizes(self) -> typing.List[QPrinter.PageSize]: ...
    def isDefault(self) -> bool: ...
    def isNull(self) -> bool: ...
    def printerName(self) -> str: ...


class QPrintPreviewDialog(QDialog):

    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ..., flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...
    @typing.overload
    def __init__(self, printer: QPrinter, parent: typing.Optional[QWidget] = ..., flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def paintRequested(self, printer: QPrinter) -> None: ...
    def done(self, result: int) -> None: ...
    def printer(self) -> QPrinter: ...
    @typing.overload
    def open(self) -> None: ...
    @typing.overload
    def open(self, receiver: QtCore.QObject, member: QT_SLOT) -> None: ...
    @typing.overload
    def open(self, slot: PYQT_SLOT) -> None: ...
    def setVisible(self, visible: bool) -> None: ...


class QPrintPreviewWidget(QWidget):

    class ZoomMode(int): ...
    CustomZoom = ... # type: 'QPrintPreviewWidget.ZoomMode'
    FitToWidth = ... # type: 'QPrintPreviewWidget.ZoomMode'
    FitInView = ... # type: 'QPrintPreviewWidget.ZoomMode'

    class ViewMode(int): ...
    SinglePageView = ... # type: 'QPrintPreviewWidget.ViewMode'
    FacingPagesView = ... # type: 'QPrintPreviewWidget.ViewMode'
    AllPagesView = ... # type: 'QPrintPreviewWidget.ViewMode'

    @typing.overload
    def __init__(self, printer: QPrinter, parent: typing.Optional[QWidget] = ..., flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ..., flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def pageCount(self) -> int: ...
    def previewChanged(self) -> None: ...
    def paintRequested(self, printer: QPrinter) -> None: ...
    def updatePreview(self) -> None: ...
    def setAllPagesViewMode(self) -> None: ...
    def setFacingPagesViewMode(self) -> None: ...
    def setSinglePageViewMode(self) -> None: ...
    def setPortraitOrientation(self) -> None: ...
    def setLandscapeOrientation(self) -> None: ...
    def fitInView(self) -> None: ...
    def fitToWidth(self) -> None: ...
    def setCurrentPage(self, pageNumber: int) -> None: ...
    def setZoomMode(self, zoomMode: 'QPrintPreviewWidget.ZoomMode') -> None: ...
    def setViewMode(self, viewMode: 'QPrintPreviewWidget.ViewMode') -> None: ...
    def setOrientation(self, orientation: QPrinter.Orientation) -> None: ...
    def setZoomFactor(self, zoomFactor: float) -> None: ...
    def zoomOut(self, factor: float = ...) -> None: ...
    def zoomIn(self, factor: float = ...) -> None: ...
    def print(self) -> None: ...
    def print_(self) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def numPages(self) -> int: ...
    def currentPage(self) -> int: ...
    def zoomMode(self) -> 'QPrintPreviewWidget.ZoomMode': ...
    def viewMode(self) -> 'QPrintPreviewWidget.ViewMode': ...
    def orientation(self) -> QPrinter.Orientation: ...
    def zoomFactor(self) -> float: ...


class QProgressBar(QWidget):

    class Direction(int): ...
    TopToBottom = ... # type: 'QProgressBar.Direction'
    BottomToTop = ... # type: 'QProgressBar.Direction'

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...

    def paintEvent(self, a0: QPaintEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def initStyleOption(self, option: 'QStyleOptionProgressBar') -> None: ...
    def valueChanged(self, value: int) -> None: ...
    def setOrientation(self, a0: QtCore.Qt.Orientation) -> None: ...
    def setValue(self, value: int) -> None: ...
    def setMaximum(self, maximum: int) -> None: ...
    def setMinimum(self, minimum: int) -> None: ...
    def reset(self) -> None: ...
    def format(self) -> str: ...
    def setFormat(self, format: str) -> None: ...
    def textDirection(self) -> 'QProgressBar.Direction': ...
    def setTextDirection(self, textDirection: 'QProgressBar.Direction') -> None: ...
    def invertedAppearance(self) -> bool: ...
    def setInvertedAppearance(self, invert: bool) -> None: ...
    def orientation(self) -> QtCore.Qt.Orientation: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def setAlignment(self, alignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> None: ...
    def alignment(self) -> QtCore.Qt.Alignment: ...
    def isTextVisible(self) -> bool: ...
    def setTextVisible(self, visible: bool) -> None: ...
    def text(self) -> str: ...
    def value(self) -> int: ...
    def setRange(self, minimum: int, maximum: int) -> None: ...
    def maximum(self) -> int: ...
    def minimum(self) -> int: ...


class QProgressDialog(QDialog):

    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ..., flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...
    @typing.overload
    def __init__(self, labelText: str, cancelButtonText: str, minimum: int, maximum: int, parent: typing.Optional[QWidget] = ..., flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    @typing.overload
    def open(self) -> None: ...
    @typing.overload
    def open(self, receiver: QtCore.QObject, member: QT_SLOT) -> None: ...
    @typing.overload
    def open(self, slot: PYQT_SLOT) -> None: ...
    def forceShow(self) -> None: ...
    def showEvent(self, e: QShowEvent) -> None: ...
    def changeEvent(self, a0: QtCore.QEvent) -> None: ...
    def closeEvent(self, a0: QCloseEvent) -> None: ...
    def resizeEvent(self, a0: QResizeEvent) -> None: ...
    def canceled(self) -> None: ...
    def setMinimumDuration(self, ms: int) -> None: ...
    def setCancelButtonText(self, a0: str) -> None: ...
    def setLabelText(self, a0: str) -> None: ...
    def setValue(self, progress: int) -> None: ...
    def setMinimum(self, minimum: int) -> None: ...
    def setMaximum(self, maximum: int) -> None: ...
    def reset(self) -> None: ...
    def cancel(self) -> None: ...
    def autoClose(self) -> bool: ...
    def setAutoClose(self, b: bool) -> None: ...
    def autoReset(self) -> bool: ...
    def setAutoReset(self, b: bool) -> None: ...
    def minimumDuration(self) -> int: ...
    def labelText(self) -> str: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def value(self) -> int: ...
    def setRange(self, minimum: int, maximum: int) -> None: ...
    def maximum(self) -> int: ...
    def minimum(self) -> int: ...
    def wasCanceled(self) -> bool: ...
    def setBar(self, bar: QProgressBar) -> None: ...
    def setCancelButton(self, button: QPushButton) -> None: ...
    def setLabel(self, label: QLabel) -> None: ...


class QProxyModel(QtCore.QAbstractItemModel):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def revert(self) -> None: ...
    def submit(self) -> bool: ...
    def span(self, index: QtCore.QModelIndex) -> QtCore.QSize: ...
    def match(self, start: QtCore.QModelIndex, role: int, value: typing.Any, hits: int = ..., flags: typing.Union[QtCore.Qt.MatchFlags, QtCore.Qt.MatchFlag] = ...) -> typing.List[QtCore.QModelIndex]: ...
    def sort(self, column: int, order: QtCore.Qt.SortOrder = ...) -> None: ...
    def flags(self, index: QtCore.QModelIndex) -> QtCore.Qt.ItemFlags: ...
    def fetchMore(self, parent: QtCore.QModelIndex) -> None: ...
    def insertColumns(self, column: int, count: int, parent: QtCore.QModelIndex = ...) -> bool: ...
    def insertRows(self, row: int, count: int, parent: QtCore.QModelIndex = ...) -> bool: ...
    def supportedDropActions(self) -> QtCore.Qt.DropActions: ...
    def dropMimeData(self, data: QtCore.QMimeData, action: QtCore.Qt.DropAction, row: int, column: int, parent: QtCore.QModelIndex) -> bool: ...
    def mimeData(self, indexes: typing.Sequence[QtCore.QModelIndex]) -> QtCore.QMimeData: ...
    def mimeTypes(self) -> typing.List[str]: ...
    def setHeaderData(self, section: int, orientation: QtCore.Qt.Orientation, value: typing.Any, role: int = ...) -> bool: ...
    def headerData(self, section: int, orientation: QtCore.Qt.Orientation, role: int = ...) -> typing.Any: ...
    def setData(self, index: QtCore.QModelIndex, value: typing.Any, role: int = ...) -> bool: ...
    def data(self, index: QtCore.QModelIndex, role: int = ...) -> typing.Any: ...
    def hasChildren(self, parent: QtCore.QModelIndex = ...) -> bool: ...
    def columnCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    @typing.overload
    def parent(self, child: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    @typing.overload
    def parent(self) -> QtCore.QObject: ...
    def index(self, row: int, column: int, parent: QtCore.QModelIndex = ...) -> QtCore.QModelIndex: ...
    def model(self) -> QtCore.QAbstractItemModel: ...
    def setModel(self, model: QtCore.QAbstractItemModel) -> None: ...


class QQuaternion(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, aScalar: float, xpos: float, ypos: float, zpos: float) -> None: ...
    @typing.overload
    def __init__(self, aScalar: float, aVector: 'QVector3D') -> None: ...
    @typing.overload
    def __init__(self, aVector: 'QVector4D') -> None: ...
    @typing.overload
    def __init__(self, a0: 'QQuaternion') -> None: ...

    def __neg__(self) -> 'QQuaternion': ...
    def toVector4D(self) -> 'QVector4D': ...
    def vector(self) -> 'QVector3D': ...
    @typing.overload
    def setVector(self, aVector: 'QVector3D') -> None: ...
    @typing.overload
    def setVector(self, aX: float, aY: float, aZ: float) -> None: ...
    def conjugate(self) -> 'QQuaternion': ...
    def setScalar(self, aScalar: float) -> None: ...
    def setZ(self, aZ: float) -> None: ...
    def setY(self, aY: float) -> None: ...
    def setX(self, aX: float) -> None: ...
    def scalar(self) -> float: ...
    def z(self) -> float: ...
    def y(self) -> float: ...
    def x(self) -> float: ...
    def isIdentity(self) -> bool: ...
    def isNull(self) -> bool: ...
    @staticmethod
    def nlerp(q1: 'QQuaternion', q2: 'QQuaternion', t: float) -> 'QQuaternion': ...
    @staticmethod
    def slerp(q1: 'QQuaternion', q2: 'QQuaternion', t: float) -> 'QQuaternion': ...
    @typing.overload
    @staticmethod
    def fromAxisAndAngle(axis: 'QVector3D', angle: float) -> 'QQuaternion': ...
    @typing.overload
    @staticmethod
    def fromAxisAndAngle(x: float, y: float, z: float, angle: float) -> 'QQuaternion': ...
    def rotatedVector(self, vector: 'QVector3D') -> 'QVector3D': ...
    def normalize(self) -> None: ...
    def normalized(self) -> 'QQuaternion': ...
    def lengthSquared(self) -> float: ...
    def length(self) -> float: ...
    def __repr__(self) -> str: ...


class QRadioButton(QAbstractButton):

    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str, parent: typing.Optional[QWidget] = ...) -> None: ...

    def mouseMoveEvent(self, a0: QMouseEvent) -> None: ...
    def paintEvent(self, a0: QPaintEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def hitButton(self, a0: QtCore.QPoint) -> bool: ...
    def initStyleOption(self, button: 'QStyleOptionButton') -> None: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...


class QRawFont(sip.simplewrapper):

    class AntialiasingType(int): ...
    PixelAntialiasing = ... # type: 'QRawFont.AntialiasingType'
    SubPixelAntialiasing = ... # type: 'QRawFont.AntialiasingType'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, fileName: str, pixelSize: float, hintingPreference: QFont.HintingPreference = ...) -> None: ...
    @typing.overload
    def __init__(self, fontData: typing.Union[QtCore.QByteArray, bytes, bytearray], pixelSize: float, hintingPreference: QFont.HintingPreference = ...) -> None: ...
    @typing.overload
    def __init__(self, other: 'QRawFont') -> None: ...

    @staticmethod
    def fromFont(font: QFont, writingSystem: QFontDatabase.WritingSystem = ...) -> 'QRawFont': ...
    def fontTable(self, tagName: str) -> QtCore.QByteArray: ...
    def supportedWritingSystems(self) -> typing.List[QFontDatabase.WritingSystem]: ...
    @typing.overload
    def supportsCharacter(self, ucs4: int) -> bool: ...
    @typing.overload
    def supportsCharacter(self, character: str) -> bool: ...
    def loadFromData(self, fontData: typing.Union[QtCore.QByteArray, bytes, bytearray], pixelSize: float, hintingPreference: QFont.HintingPreference) -> None: ...
    def loadFromFile(self, fileName: str, pixelSize: float, hintingPreference: QFont.HintingPreference) -> None: ...
    def unitsPerEm(self) -> float: ...
    def maxCharWidth(self) -> float: ...
    def averageCharWidth(self) -> float: ...
    def xHeight(self) -> float: ...
    def leading(self) -> float: ...
    def descent(self) -> float: ...
    def ascent(self) -> float: ...
    def hintingPreference(self) -> QFont.HintingPreference: ...
    def pixelSize(self) -> float: ...
    def setPixelSize(self, pixelSize: float) -> None: ...
    def pathForGlyph(self, glyphIndex: int) -> QPainterPath: ...
    def alphaMapForGlyph(self, glyphIndex: int, antialiasingType: 'QRawFont.AntialiasingType' = ..., transform: 'QTransform' = ...) -> QImage: ...
    def advancesForGlyphIndexes(self, glyphIndexes: typing.List[int]) -> typing.List[QtCore.QPointF]: ...
    def glyphIndexesForString(self, text: str) -> typing.List[int]: ...
    def weight(self) -> int: ...
    def style(self) -> QFont.Style: ...
    def styleName(self) -> str: ...
    def familyName(self) -> str: ...
    def isValid(self) -> bool: ...


class QRegion(sip.simplewrapper):

    class RegionType(int): ...
    Rectangle = ... # type: 'QRegion.RegionType'
    Ellipse = ... # type: 'QRegion.RegionType'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, x: int, y: int, w: int, h: int, type: 'QRegion.RegionType' = ...) -> None: ...
    @typing.overload
    def __init__(self, r: QtCore.QRect, type: 'QRegion.RegionType' = ...) -> None: ...
    @typing.overload
    def __init__(self, a: QPolygon, fillRule: QtCore.Qt.FillRule = ...) -> None: ...
    @typing.overload
    def __init__(self, bitmap: QBitmap) -> None: ...
    @typing.overload
    def __init__(self, region: 'QRegion') -> None: ...
    @typing.overload
    def __init__(self, variant: typing.Any) -> None: ...

    def swap(self, other: 'QRegion') -> None: ...
    def rectCount(self) -> int: ...
    def numRects(self) -> int: ...
    @typing.overload
    def intersects(self, r: 'QRegion') -> bool: ...
    @typing.overload
    def intersects(self, r: QtCore.QRect) -> bool: ...
    def xored(self, r: 'QRegion') -> 'QRegion': ...
    def subtracted(self, r: 'QRegion') -> 'QRegion': ...
    @typing.overload
    def intersected(self, r: 'QRegion') -> 'QRegion': ...
    @typing.overload
    def intersected(self, r: QtCore.QRect) -> 'QRegion': ...
    def rects(self) -> typing.List[QtCore.QRect]: ...
    def boundingRect(self) -> QtCore.QRect: ...
    def eor(self, r: 'QRegion') -> 'QRegion': ...
    def subtract(self, r: 'QRegion') -> 'QRegion': ...
    def intersect(self, r: 'QRegion') -> 'QRegion': ...
    @typing.overload
    def united(self, r: 'QRegion') -> 'QRegion': ...
    @typing.overload
    def united(self, r: QtCore.QRect) -> 'QRegion': ...
    def unite(self, r: 'QRegion') -> 'QRegion': ...
    @typing.overload
    def translated(self, dx: int, dy: int) -> 'QRegion': ...
    @typing.overload
    def translated(self, p: QtCore.QPoint) -> 'QRegion': ...
    @typing.overload
    def translate(self, dx: int, dy: int) -> None: ...
    @typing.overload
    def translate(self, p: QtCore.QPoint) -> None: ...
    @typing.overload
    def __contains__(self, p: QtCore.QPoint) -> int: ...
    @typing.overload
    def __contains__(self, r: QtCore.QRect) -> int: ...
    @typing.overload
    def contains(self, p: QtCore.QPoint) -> bool: ...
    @typing.overload
    def contains(self, r: QtCore.QRect) -> bool: ...
    def __bool__(self) -> int: ...
    def isEmpty(self) -> bool: ...


class QRubberBand(QWidget):

    class Shape(int): ...
    Line = ... # type: 'QRubberBand.Shape'
    Rectangle = ... # type: 'QRubberBand.Shape'

    def __init__(self, a0: 'QRubberBand.Shape', parent: typing.Optional[QWidget] = ...) -> None: ...

    def moveEvent(self, a0: QMoveEvent) -> None: ...
    def resizeEvent(self, a0: QResizeEvent) -> None: ...
    def showEvent(self, a0: QShowEvent) -> None: ...
    def changeEvent(self, a0: QtCore.QEvent) -> None: ...
    def paintEvent(self, a0: QPaintEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def initStyleOption(self, option: 'QStyleOptionRubberBand') -> None: ...
    @typing.overload
    def resize(self, w: int, h: int) -> None: ...
    @typing.overload
    def resize(self, s: QtCore.QSize) -> None: ...
    @typing.overload
    def move(self, p: QtCore.QPoint) -> None: ...
    @typing.overload
    def move(self, ax: int, ay: int) -> None: ...
    @typing.overload
    def setGeometry(self, r: QtCore.QRect) -> None: ...
    @typing.overload
    def setGeometry(self, ax: int, ay: int, aw: int, ah: int) -> None: ...
    def shape(self) -> 'QRubberBand.Shape': ...


class QScrollArea(QAbstractScrollArea):

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...

    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def resizeEvent(self, a0: QResizeEvent) -> None: ...
    def eventFilter(self, a0: QtCore.QObject, a1: QtCore.QEvent) -> bool: ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    def ensureWidgetVisible(self, childWidget: QWidget, xMargin: int = ..., yMargin: int = ...) -> None: ...
    def ensureVisible(self, x: int, y: int, xMargin: int = ..., yMargin: int = ...) -> None: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def setAlignment(self, a0: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> None: ...
    def alignment(self) -> QtCore.Qt.Alignment: ...
    def setWidgetResizable(self, resizable: bool) -> None: ...
    def widgetResizable(self) -> bool: ...
    def takeWidget(self) -> QWidget: ...
    def setWidget(self, w: QWidget) -> None: ...
    def widget(self) -> QWidget: ...


class QScrollBar(QAbstractSlider):

    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, orientation: QtCore.Qt.Orientation, parent: typing.Optional[QWidget] = ...) -> None: ...

    def sliderChange(self, change: QAbstractSlider.SliderChange) -> None: ...
    def contextMenuEvent(self, a0: QContextMenuEvent) -> None: ...
    def hideEvent(self, a0: QHideEvent) -> None: ...
    def mouseMoveEvent(self, a0: QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, a0: QMouseEvent) -> None: ...
    def mousePressEvent(self, a0: QMouseEvent) -> None: ...
    def paintEvent(self, a0: QPaintEvent) -> None: ...
    def initStyleOption(self, option: 'QStyleOptionSlider') -> None: ...
    def event(self, event: QtCore.QEvent) -> bool: ...
    def sizeHint(self) -> QtCore.QSize: ...


class QSessionManager(QtCore.QObject):

    class RestartHint(int): ...
    RestartIfRunning = ... # type: 'QSessionManager.RestartHint'
    RestartAnyway = ... # type: 'QSessionManager.RestartHint'
    RestartImmediately = ... # type: 'QSessionManager.RestartHint'
    RestartNever = ... # type: 'QSessionManager.RestartHint'

    def requestPhase2(self) -> None: ...
    def isPhase2(self) -> bool: ...
    @typing.overload
    def setManagerProperty(self, name: str, value: str) -> None: ...
    @typing.overload
    def setManagerProperty(self, name: str, value: typing.Sequence[str]) -> None: ...
    def discardCommand(self) -> typing.List[str]: ...
    def setDiscardCommand(self, a0: typing.Sequence[str]) -> None: ...
    def restartCommand(self) -> typing.List[str]: ...
    def setRestartCommand(self, a0: typing.Sequence[str]) -> None: ...
    def restartHint(self) -> 'QSessionManager.RestartHint': ...
    def setRestartHint(self, a0: 'QSessionManager.RestartHint') -> None: ...
    def cancel(self) -> None: ...
    def release(self) -> None: ...
    def allowsErrorInteraction(self) -> bool: ...
    def allowsInteraction(self) -> bool: ...
    def sessionKey(self) -> str: ...
    def sessionId(self) -> str: ...


class QShortcut(QtCore.QObject):

    @typing.overload
    def __init__(self, parent: QWidget) -> None: ...
    @typing.overload
    def __init__(self, key: typing.Union[QKeySequence, QKeySequence.StandardKey, str, int], parent: QWidget, member: PYQT_SLOT = ..., ambiguousMember: PYQT_SLOT = ..., context: QtCore.Qt.ShortcutContext = ...) -> None: ...

    def event(self, e: QtCore.QEvent) -> bool: ...
    def activatedAmbiguously(self) -> None: ...
    def activated(self) -> None: ...
    def autoRepeat(self) -> bool: ...
    def setAutoRepeat(self, on: bool) -> None: ...
    def parentWidget(self) -> QWidget: ...
    def id(self) -> int: ...
    def whatsThis(self) -> str: ...
    def setWhatsThis(self, text: str) -> None: ...
    def context(self) -> QtCore.Qt.ShortcutContext: ...
    def setContext(self, context: QtCore.Qt.ShortcutContext) -> None: ...
    def isEnabled(self) -> bool: ...
    def setEnabled(self, enable: bool) -> None: ...
    def key(self) -> QKeySequence: ...
    def setKey(self, key: typing.Union[QKeySequence, QKeySequence.StandardKey, str, int]) -> None: ...


class QSizeGrip(QWidget):

    def __init__(self, parent: QWidget) -> None: ...

    def hideEvent(self, hideEvent: QHideEvent) -> None: ...
    def showEvent(self, showEvent: QShowEvent) -> None: ...
    def moveEvent(self, moveEvent: QMoveEvent) -> None: ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    def eventFilter(self, a0: QtCore.QObject, a1: QtCore.QEvent) -> bool: ...
    def mouseMoveEvent(self, a0: QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, mouseEvent: QMouseEvent) -> None: ...
    def mousePressEvent(self, a0: QMouseEvent) -> None: ...
    def paintEvent(self, a0: QPaintEvent) -> None: ...
    def setVisible(self, a0: bool) -> None: ...
    def sizeHint(self) -> QtCore.QSize: ...


class QSizePolicy(sip.simplewrapper):

    class ControlType(int): ...
    DefaultType = ... # type: 'QSizePolicy.ControlType'
    ButtonBox = ... # type: 'QSizePolicy.ControlType'
    CheckBox = ... # type: 'QSizePolicy.ControlType'
    ComboBox = ... # type: 'QSizePolicy.ControlType'
    Frame = ... # type: 'QSizePolicy.ControlType'
    GroupBox = ... # type: 'QSizePolicy.ControlType'
    Label = ... # type: 'QSizePolicy.ControlType'
    Line = ... # type: 'QSizePolicy.ControlType'
    LineEdit = ... # type: 'QSizePolicy.ControlType'
    PushButton = ... # type: 'QSizePolicy.ControlType'
    RadioButton = ... # type: 'QSizePolicy.ControlType'
    Slider = ... # type: 'QSizePolicy.ControlType'
    SpinBox = ... # type: 'QSizePolicy.ControlType'
    TabWidget = ... # type: 'QSizePolicy.ControlType'
    ToolButton = ... # type: 'QSizePolicy.ControlType'

    class Policy(int): ...
    Fixed = ... # type: 'QSizePolicy.Policy'
    Minimum = ... # type: 'QSizePolicy.Policy'
    Maximum = ... # type: 'QSizePolicy.Policy'
    Preferred = ... # type: 'QSizePolicy.Policy'
    MinimumExpanding = ... # type: 'QSizePolicy.Policy'
    Expanding = ... # type: 'QSizePolicy.Policy'
    Ignored = ... # type: 'QSizePolicy.Policy'

    class PolicyFlag(int): ...
    GrowFlag = ... # type: 'QSizePolicy.PolicyFlag'
    ExpandFlag = ... # type: 'QSizePolicy.PolicyFlag'
    ShrinkFlag = ... # type: 'QSizePolicy.PolicyFlag'
    IgnoreFlag = ... # type: 'QSizePolicy.PolicyFlag'

    class ControlTypes(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QSizePolicy.ControlTypes', 'QSizePolicy.ControlType']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QSizePolicy.ControlTypes') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QSizePolicy.ControlTypes': ...
        def __int__(self) -> int: ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, horizontal: 'QSizePolicy.Policy', vertical: 'QSizePolicy.Policy') -> None: ...
    @typing.overload
    def __init__(self, horizontal: 'QSizePolicy.Policy', vertical: 'QSizePolicy.Policy', type: 'QSizePolicy.ControlType') -> None: ...
    @typing.overload
    def __init__(self, variant: typing.Any) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QSizePolicy') -> None: ...

    def hasWidthForHeight(self) -> bool: ...
    def setWidthForHeight(self, b: bool) -> None: ...
    def setControlType(self, type: 'QSizePolicy.ControlType') -> None: ...
    def controlType(self) -> 'QSizePolicy.ControlType': ...
    def transpose(self) -> None: ...
    def setVerticalStretch(self, stretchFactor: int) -> None: ...
    def setHorizontalStretch(self, stretchFactor: int) -> None: ...
    def verticalStretch(self) -> int: ...
    def horizontalStretch(self) -> int: ...
    def hasHeightForWidth(self) -> bool: ...
    def setHeightForWidth(self, b: bool) -> None: ...
    def expandingDirections(self) -> QtCore.Qt.Orientations: ...
    def setVerticalPolicy(self, d: 'QSizePolicy.Policy') -> None: ...
    def setHorizontalPolicy(self, d: 'QSizePolicy.Policy') -> None: ...
    def verticalPolicy(self) -> 'QSizePolicy.Policy': ...
    def horizontalPolicy(self) -> 'QSizePolicy.Policy': ...


class QSlider(QAbstractSlider):

    class TickPosition(int): ...
    NoTicks = ... # type: 'QSlider.TickPosition'
    TicksAbove = ... # type: 'QSlider.TickPosition'
    TicksLeft = ... # type: 'QSlider.TickPosition'
    TicksBelow = ... # type: 'QSlider.TickPosition'
    TicksRight = ... # type: 'QSlider.TickPosition'
    TicksBothSides = ... # type: 'QSlider.TickPosition'

    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, orientation: QtCore.Qt.Orientation, parent: typing.Optional[QWidget] = ...) -> None: ...

    def mouseMoveEvent(self, ev: QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, ev: QMouseEvent) -> None: ...
    def mousePressEvent(self, ev: QMouseEvent) -> None: ...
    def paintEvent(self, ev: QPaintEvent) -> None: ...
    def initStyleOption(self, option: 'QStyleOptionSlider') -> None: ...
    def event(self, event: QtCore.QEvent) -> bool: ...
    def tickInterval(self) -> int: ...
    def setTickInterval(self, ti: int) -> None: ...
    def tickPosition(self) -> 'QSlider.TickPosition': ...
    def setTickPosition(self, position: 'QSlider.TickPosition') -> None: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...


class QSortFilterProxyModel(QAbstractProxyModel):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def invalidateFilter(self) -> None: ...
    def invalidate(self) -> None: ...
    def setSortLocaleAware(self, on: bool) -> None: ...
    def isSortLocaleAware(self) -> bool: ...
    def supportedDropActions(self) -> QtCore.Qt.DropActions: ...
    def mimeTypes(self) -> typing.List[str]: ...
    def setFilterRole(self, role: int) -> None: ...
    def filterRole(self) -> int: ...
    def sortOrder(self) -> QtCore.Qt.SortOrder: ...
    def sortColumn(self) -> int: ...
    def setSortRole(self, role: int) -> None: ...
    def sortRole(self) -> int: ...
    def setDynamicSortFilter(self, enable: bool) -> None: ...
    def dynamicSortFilter(self) -> bool: ...
    def setSortCaseSensitivity(self, cs: QtCore.Qt.CaseSensitivity) -> None: ...
    def sortCaseSensitivity(self) -> QtCore.Qt.CaseSensitivity: ...
    def sort(self, column: int, order: QtCore.Qt.SortOrder = ...) -> None: ...
    def match(self, start: QtCore.QModelIndex, role: int, value: typing.Any, hits: int = ..., flags: typing.Union[QtCore.Qt.MatchFlags, QtCore.Qt.MatchFlag] = ...) -> typing.List[QtCore.QModelIndex]: ...
    def span(self, index: QtCore.QModelIndex) -> QtCore.QSize: ...
    def buddy(self, index: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def flags(self, index: QtCore.QModelIndex) -> QtCore.Qt.ItemFlags: ...
    def canFetchMore(self, parent: QtCore.QModelIndex) -> bool: ...
    def fetchMore(self, parent: QtCore.QModelIndex) -> None: ...
    def removeColumns(self, column: int, count: int, parent: QtCore.QModelIndex = ...) -> bool: ...
    def removeRows(self, row: int, count: int, parent: QtCore.QModelIndex = ...) -> bool: ...
    def insertColumns(self, column: int, count: int, parent: QtCore.QModelIndex = ...) -> bool: ...
    def insertRows(self, row: int, count: int, parent: QtCore.QModelIndex = ...) -> bool: ...
    def dropMimeData(self, data: QtCore.QMimeData, action: QtCore.Qt.DropAction, row: int, column: int, parent: QtCore.QModelIndex) -> bool: ...
    def mimeData(self, indexes: typing.Sequence[QtCore.QModelIndex]) -> QtCore.QMimeData: ...
    def setHeaderData(self, section: int, orientation: QtCore.Qt.Orientation, value: typing.Any, role: int = ...) -> bool: ...
    def headerData(self, section: int, orientation: QtCore.Qt.Orientation, role: int = ...) -> typing.Any: ...
    def setData(self, index: QtCore.QModelIndex, value: typing.Any, role: int = ...) -> bool: ...
    def data(self, index: QtCore.QModelIndex, role: int = ...) -> typing.Any: ...
    def hasChildren(self, parent: QtCore.QModelIndex = ...) -> bool: ...
    def columnCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    @typing.overload
    def parent(self, child: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    @typing.overload
    def parent(self) -> QtCore.QObject: ...
    def index(self, row: int, column: int, parent: QtCore.QModelIndex = ...) -> QtCore.QModelIndex: ...
    def lessThan(self, left: QtCore.QModelIndex, right: QtCore.QModelIndex) -> bool: ...
    def filterChanged(self) -> None: ...
    def filterAcceptsColumn(self, source_column: int, source_parent: QtCore.QModelIndex) -> bool: ...
    def filterAcceptsRow(self, source_row: int, source_parent: QtCore.QModelIndex) -> bool: ...
    def clear(self) -> None: ...
    def setFilterFixedString(self, pattern: str) -> None: ...
    def setFilterWildcard(self, pattern: str) -> None: ...
    def setFilterCaseSensitivity(self, cs: QtCore.Qt.CaseSensitivity) -> None: ...
    def filterCaseSensitivity(self) -> QtCore.Qt.CaseSensitivity: ...
    def setFilterKeyColumn(self, column: int) -> None: ...
    def filterKeyColumn(self) -> int: ...
    @typing.overload
    def setFilterRegExp(self, regExp: QtCore.QRegExp) -> None: ...
    @typing.overload
    def setFilterRegExp(self, pattern: str) -> None: ...
    def filterRegExp(self) -> QtCore.QRegExp: ...
    def mapSelectionFromSource(self, sourceSelection: QItemSelection) -> QItemSelection: ...
    def mapSelectionToSource(self, proxySelection: QItemSelection) -> QItemSelection: ...
    def mapFromSource(self, sourceIndex: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def mapToSource(self, proxyIndex: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def setSourceModel(self, sourceModel: QtCore.QAbstractItemModel) -> None: ...


class QSound(QtCore.QObject):

    def __init__(self, filename: str, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def stop(self) -> None: ...
    def isFinished(self) -> bool: ...
    def fileName(self) -> str: ...
    def setLoops(self, a0: int) -> None: ...
    def loopsRemaining(self) -> int: ...
    def loops(self) -> int: ...
    @typing.overload
    @staticmethod
    def play(filename: str) -> None: ...
    @typing.overload
    def play(self) -> None: ...
    @staticmethod
    def isAvailable() -> bool: ...


class QSpinBox(QAbstractSpinBox):

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...

    @typing.overload
    def valueChanged(self, a0: int) -> None: ...
    @typing.overload
    def valueChanged(self, a0: str) -> None: ...
    def setValue(self, val: int) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def fixup(self, str: str) -> str: ...
    def textFromValue(self, v: int) -> str: ...
    def valueFromText(self, text: str) -> int: ...
    def validate(self, input: str, pos: int) -> typing.Tuple['QValidator.State', str, int]: ...
    def setRange(self, min: int, max: int) -> None: ...
    def setMaximum(self, max: int) -> None: ...
    def maximum(self) -> int: ...
    def setMinimum(self, min: int) -> None: ...
    def minimum(self) -> int: ...
    def setSingleStep(self, val: int) -> None: ...
    def singleStep(self) -> int: ...
    def cleanText(self) -> str: ...
    def setSuffix(self, s: str) -> None: ...
    def suffix(self) -> str: ...
    def setPrefix(self, p: str) -> None: ...
    def prefix(self) -> str: ...
    def value(self) -> int: ...


class QDoubleSpinBox(QAbstractSpinBox):

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...

    @typing.overload
    def valueChanged(self, a0: float) -> None: ...
    @typing.overload
    def valueChanged(self, a0: str) -> None: ...
    def setValue(self, val: float) -> None: ...
    def fixup(self, str: str) -> str: ...
    def textFromValue(self, v: float) -> str: ...
    def valueFromText(self, text: str) -> float: ...
    def validate(self, input: str, pos: int) -> typing.Tuple['QValidator.State', str, int]: ...
    def setDecimals(self, prec: int) -> None: ...
    def decimals(self) -> int: ...
    def setRange(self, min: float, max: float) -> None: ...
    def setMaximum(self, max: float) -> None: ...
    def maximum(self) -> float: ...
    def setMinimum(self, min: float) -> None: ...
    def minimum(self) -> float: ...
    def setSingleStep(self, val: float) -> None: ...
    def singleStep(self) -> float: ...
    def cleanText(self) -> str: ...
    def setSuffix(self, s: str) -> None: ...
    def suffix(self) -> str: ...
    def setPrefix(self, p: str) -> None: ...
    def prefix(self) -> str: ...
    def value(self) -> float: ...


class QSplashScreen(QWidget):

    @typing.overload
    def __init__(self, pixmap: QPixmap = ..., flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: QWidget, pixmap: QPixmap = ..., flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def mousePressEvent(self, a0: QMouseEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def drawContents(self, painter: QPainter) -> None: ...
    def messageChanged(self, message: str) -> None: ...
    def clearMessage(self) -> None: ...
    def showMessage(self, message: str, alignment: int = ..., color: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient] = ...) -> None: ...
    def repaint(self) -> None: ...
    def finish(self, w: QWidget) -> None: ...
    def pixmap(self) -> QPixmap: ...
    def setPixmap(self, pixmap: QPixmap) -> None: ...


class QSplitter(QFrame):

    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, orientation: QtCore.Qt.Orientation, parent: typing.Optional[QWidget] = ...) -> None: ...

    def closestLegalPosition(self, a0: int, a1: int) -> int: ...
    def setRubberBand(self, position: int) -> None: ...
    def moveSplitter(self, pos: int, index: int) -> None: ...
    def changeEvent(self, a0: QtCore.QEvent) -> None: ...
    def resizeEvent(self, a0: QResizeEvent) -> None: ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    def childEvent(self, a0: QtCore.QChildEvent) -> None: ...
    def createHandle(self) -> 'QSplitterHandle': ...
    def splitterMoved(self, pos: int, index: int) -> None: ...
    def setStretchFactor(self, index: int, stretch: int) -> None: ...
    def handle(self, index: int) -> 'QSplitterHandle': ...
    def getRange(self, index: int) -> typing.Tuple[int, int]: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def widget(self, index: int) -> QWidget: ...
    def indexOf(self, w: QWidget) -> int: ...
    def setHandleWidth(self, a0: int) -> None: ...
    def handleWidth(self) -> int: ...
    def restoreState(self, state: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> bool: ...
    def saveState(self) -> QtCore.QByteArray: ...
    def setSizes(self, list: typing.Sequence[int]) -> None: ...
    def sizes(self) -> typing.List[int]: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def refresh(self) -> None: ...
    def opaqueResize(self) -> bool: ...
    def setOpaqueResize(self, opaque: bool = ...) -> None: ...
    def isCollapsible(self, index: int) -> bool: ...
    def setCollapsible(self, index: int, a1: bool) -> None: ...
    def childrenCollapsible(self) -> bool: ...
    def setChildrenCollapsible(self, a0: bool) -> None: ...
    def orientation(self) -> QtCore.Qt.Orientation: ...
    def setOrientation(self, a0: QtCore.Qt.Orientation) -> None: ...
    def insertWidget(self, index: int, widget: QWidget) -> None: ...
    def addWidget(self, widget: QWidget) -> None: ...


class QSplitterHandle(QWidget):

    def __init__(self, o: QtCore.Qt.Orientation, parent: QSplitter) -> None: ...

    def resizeEvent(self, a0: QResizeEvent) -> None: ...
    def closestLegalPosition(self, p: int) -> int: ...
    def moveSplitter(self, p: int) -> None: ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    def mouseReleaseEvent(self, a0: QMouseEvent) -> None: ...
    def mousePressEvent(self, a0: QMouseEvent) -> None: ...
    def mouseMoveEvent(self, a0: QMouseEvent) -> None: ...
    def paintEvent(self, a0: QPaintEvent) -> None: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def splitter(self) -> QSplitter: ...
    def opaqueResize(self) -> bool: ...
    def orientation(self) -> QtCore.Qt.Orientation: ...
    def setOrientation(self, o: QtCore.Qt.Orientation) -> None: ...


class QStackedLayout(QLayout):

    class StackingMode(int): ...
    StackOne = ... # type: 'QStackedLayout.StackingMode'
    StackAll = ... # type: 'QStackedLayout.StackingMode'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, parent: QWidget) -> None: ...
    @typing.overload
    def __init__(self, parentLayout: QLayout) -> None: ...

    def setStackingMode(self, stackingMode: 'QStackedLayout.StackingMode') -> None: ...
    def stackingMode(self) -> 'QStackedLayout.StackingMode': ...
    def setCurrentWidget(self, w: QWidget) -> None: ...
    def setCurrentIndex(self, index: int) -> None: ...
    def currentChanged(self, index: int) -> None: ...
    def widgetRemoved(self, index: int) -> None: ...
    def setGeometry(self, rect: QtCore.QRect) -> None: ...
    def takeAt(self, a0: int) -> QLayoutItem: ...
    def itemAt(self, a0: int) -> QLayoutItem: ...
    def minimumSize(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def addItem(self, item: QLayoutItem) -> None: ...
    def count(self) -> int: ...
    @typing.overload
    def widget(self, a0: int) -> QWidget: ...
    @typing.overload
    def widget(self) -> QWidget: ...
    def currentIndex(self) -> int: ...
    def currentWidget(self) -> QWidget: ...
    def insertWidget(self, index: int, w: QWidget) -> int: ...
    def addWidget(self, w: QWidget) -> int: ...


class QStackedWidget(QFrame):

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...

    def event(self, e: QtCore.QEvent) -> bool: ...
    def widgetRemoved(self, index: int) -> None: ...
    def currentChanged(self, a0: int) -> None: ...
    def setCurrentWidget(self, w: QWidget) -> None: ...
    def setCurrentIndex(self, index: int) -> None: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def widget(self, a0: int) -> QWidget: ...
    def indexOf(self, a0: QWidget) -> int: ...
    def currentIndex(self) -> int: ...
    def currentWidget(self) -> QWidget: ...
    def removeWidget(self, w: QWidget) -> None: ...
    def insertWidget(self, index: int, w: QWidget) -> int: ...
    def addWidget(self, w: QWidget) -> int: ...


class QStandardItemModel(QtCore.QAbstractItemModel):

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, rows: int, columns: int, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def itemChanged(self, item: 'QStandardItem') -> None: ...
    def dropMimeData(self, data: QtCore.QMimeData, action: QtCore.Qt.DropAction, row: int, column: int, parent: QtCore.QModelIndex) -> bool: ...
    def mimeData(self, indexes: typing.Sequence[QtCore.QModelIndex]) -> QtCore.QMimeData: ...
    def mimeTypes(self) -> typing.List[str]: ...
    def setSortRole(self, role: int) -> None: ...
    def sortRole(self) -> int: ...
    def findItems(self, text: str, flags: typing.Union[QtCore.Qt.MatchFlags, QtCore.Qt.MatchFlag] = ..., column: int = ...) -> typing.List['QStandardItem']: ...
    def setItemPrototype(self, item: 'QStandardItem') -> None: ...
    def itemPrototype(self) -> 'QStandardItem': ...
    def takeVerticalHeaderItem(self, row: int) -> 'QStandardItem': ...
    def takeHorizontalHeaderItem(self, column: int) -> 'QStandardItem': ...
    def takeColumn(self, column: int) -> typing.List['QStandardItem']: ...
    def takeRow(self, row: int) -> typing.List['QStandardItem']: ...
    def takeItem(self, row: int, column: int = ...) -> 'QStandardItem': ...
    @typing.overload
    def insertColumn(self, column: int, items: typing.Sequence['QStandardItem']) -> None: ...
    @typing.overload
    def insertColumn(self, column: int, parent: QtCore.QModelIndex = ...) -> bool: ...
    @typing.overload
    def insertRow(self, row: int, items: typing.Sequence['QStandardItem']) -> None: ...
    @typing.overload
    def insertRow(self, arow: int, aitem: 'QStandardItem') -> None: ...
    @typing.overload
    def insertRow(self, row: int, parent: QtCore.QModelIndex = ...) -> bool: ...
    def appendColumn(self, items: typing.Sequence['QStandardItem']) -> None: ...
    @typing.overload
    def appendRow(self, items: typing.Sequence['QStandardItem']) -> None: ...
    @typing.overload
    def appendRow(self, aitem: 'QStandardItem') -> None: ...
    def setColumnCount(self, columns: int) -> None: ...
    def setRowCount(self, rows: int) -> None: ...
    def setVerticalHeaderLabels(self, labels: typing.Sequence[str]) -> None: ...
    def setHorizontalHeaderLabels(self, labels: typing.Sequence[str]) -> None: ...
    def setVerticalHeaderItem(self, row: int, item: 'QStandardItem') -> None: ...
    def verticalHeaderItem(self, row: int) -> 'QStandardItem': ...
    def setHorizontalHeaderItem(self, column: int, item: 'QStandardItem') -> None: ...
    def horizontalHeaderItem(self, column: int) -> 'QStandardItem': ...
    def invisibleRootItem(self) -> 'QStandardItem': ...
    @typing.overload
    def setItem(self, row: int, column: int, item: 'QStandardItem') -> None: ...
    @typing.overload
    def setItem(self, arow: int, aitem: 'QStandardItem') -> None: ...
    def item(self, row: int, column: int = ...) -> 'QStandardItem': ...
    def indexFromItem(self, item: 'QStandardItem') -> QtCore.QModelIndex: ...
    def itemFromIndex(self, index: QtCore.QModelIndex) -> 'QStandardItem': ...
    def sort(self, column: int, order: QtCore.Qt.SortOrder = ...) -> None: ...
    def setItemData(self, index: QtCore.QModelIndex, roles: typing.Dict[int, typing.Any]) -> bool: ...
    def itemData(self, index: QtCore.QModelIndex) -> typing.Dict[int, typing.Any]: ...
    def supportedDropActions(self) -> QtCore.Qt.DropActions: ...
    def clear(self) -> None: ...
    def flags(self, index: QtCore.QModelIndex) -> QtCore.Qt.ItemFlags: ...
    def removeColumns(self, column: int, count: int, parent: QtCore.QModelIndex = ...) -> bool: ...
    def removeRows(self, row: int, count: int, parent: QtCore.QModelIndex = ...) -> bool: ...
    def insertColumns(self, column: int, count: int, parent: QtCore.QModelIndex = ...) -> bool: ...
    def insertRows(self, row: int, count: int, parent: QtCore.QModelIndex = ...) -> bool: ...
    def setHeaderData(self, section: int, orientation: QtCore.Qt.Orientation, value: typing.Any, role: int = ...) -> bool: ...
    def headerData(self, section: int, orientation: QtCore.Qt.Orientation, role: int = ...) -> typing.Any: ...
    def setData(self, index: QtCore.QModelIndex, value: typing.Any, role: int = ...) -> bool: ...
    def data(self, index: QtCore.QModelIndex, role: int = ...) -> typing.Any: ...
    def hasChildren(self, parent: QtCore.QModelIndex = ...) -> bool: ...
    def columnCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    @typing.overload
    def parent(self, child: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    @typing.overload
    def parent(self) -> QtCore.QObject: ...
    def index(self, row: int, column: int, parent: QtCore.QModelIndex = ...) -> QtCore.QModelIndex: ...


class QStandardItem(sip.wrapper):

    class ItemType(int): ...
    Type = ... # type: 'QStandardItem.ItemType'
    UserType = ... # type: 'QStandardItem.ItemType'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, text: str) -> None: ...
    @typing.overload
    def __init__(self, icon: QIcon, text: str) -> None: ...
    @typing.overload
    def __init__(self, rows: int, columns: int = ...) -> None: ...
    @typing.overload
    def __init__(self, other: 'QStandardItem') -> None: ...

    def emitDataChanged(self) -> None: ...
    def appendRows(self, aitems: typing.Sequence['QStandardItem']) -> None: ...
    def appendColumn(self, aitems: typing.Sequence['QStandardItem']) -> None: ...
    @typing.overload
    def appendRow(self, aitems: typing.Sequence['QStandardItem']) -> None: ...
    @typing.overload
    def appendRow(self, aitem: 'QStandardItem') -> None: ...
    def setAccessibleDescription(self, aaccessibleDescription: str) -> None: ...
    def setAccessibleText(self, aaccessibleText: str) -> None: ...
    def setCheckState(self, acheckState: QtCore.Qt.CheckState) -> None: ...
    def setForeground(self, abrush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def setBackground(self, abrush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def setTextAlignment(self, atextAlignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> None: ...
    def setFont(self, afont: QFont) -> None: ...
    def setSizeHint(self, asizeHint: QtCore.QSize) -> None: ...
    def setWhatsThis(self, awhatsThis: str) -> None: ...
    def setStatusTip(self, astatusTip: str) -> None: ...
    def setToolTip(self, atoolTip: str) -> None: ...
    def setIcon(self, aicon: QIcon) -> None: ...
    def setText(self, atext: str) -> None: ...
    def write(self, out: QtCore.QDataStream) -> None: ...
    def read(self, in_: QtCore.QDataStream) -> None: ...
    def type(self) -> int: ...
    def clone(self) -> 'QStandardItem': ...
    def sortChildren(self, column: int, order: QtCore.Qt.SortOrder = ...) -> None: ...
    def takeColumn(self, column: int) -> typing.List['QStandardItem']: ...
    def takeRow(self, row: int) -> typing.List['QStandardItem']: ...
    def takeChild(self, row: int, column: int = ...) -> 'QStandardItem': ...
    def removeColumns(self, column: int, count: int) -> None: ...
    def removeRows(self, row: int, count: int) -> None: ...
    def removeColumn(self, column: int) -> None: ...
    def removeRow(self, row: int) -> None: ...
    def insertColumns(self, column: int, count: int) -> None: ...
    def insertColumn(self, column: int, items: typing.Sequence['QStandardItem']) -> None: ...
    @typing.overload
    def insertRows(self, row: int, count: int) -> None: ...
    @typing.overload
    def insertRows(self, row: int, items: typing.Sequence['QStandardItem']) -> None: ...
    @typing.overload
    def insertRow(self, row: int, items: typing.Sequence['QStandardItem']) -> None: ...
    @typing.overload
    def insertRow(self, arow: int, aitem: 'QStandardItem') -> None: ...
    @typing.overload
    def setChild(self, row: int, column: int, item: 'QStandardItem') -> None: ...
    @typing.overload
    def setChild(self, arow: int, aitem: 'QStandardItem') -> None: ...
    def child(self, row: int, column: int = ...) -> 'QStandardItem': ...
    def hasChildren(self) -> bool: ...
    def setColumnCount(self, columns: int) -> None: ...
    def columnCount(self) -> int: ...
    def setRowCount(self, rows: int) -> None: ...
    def rowCount(self) -> int: ...
    def model(self) -> QStandardItemModel: ...
    def index(self) -> QtCore.QModelIndex: ...
    def column(self) -> int: ...
    def row(self) -> int: ...
    def parent(self) -> 'QStandardItem': ...
    def setDropEnabled(self, dropEnabled: bool) -> None: ...
    def isDropEnabled(self) -> bool: ...
    def setDragEnabled(self, dragEnabled: bool) -> None: ...
    def isDragEnabled(self) -> bool: ...
    def setTristate(self, tristate: bool) -> None: ...
    def isTristate(self) -> bool: ...
    def setCheckable(self, checkable: bool) -> None: ...
    def isCheckable(self) -> bool: ...
    def setSelectable(self, selectable: bool) -> None: ...
    def isSelectable(self) -> bool: ...
    def setEditable(self, editable: bool) -> None: ...
    def isEditable(self) -> bool: ...
    def setEnabled(self, enabled: bool) -> None: ...
    def isEnabled(self) -> bool: ...
    def setFlags(self, flags: typing.Union[QtCore.Qt.ItemFlags, QtCore.Qt.ItemFlag]) -> None: ...
    def flags(self) -> QtCore.Qt.ItemFlags: ...
    def accessibleDescription(self) -> str: ...
    def accessibleText(self) -> str: ...
    def checkState(self) -> QtCore.Qt.CheckState: ...
    def foreground(self) -> QBrush: ...
    def background(self) -> QBrush: ...
    def textAlignment(self) -> QtCore.Qt.Alignment: ...
    def font(self) -> QFont: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def whatsThis(self) -> str: ...
    def statusTip(self) -> str: ...
    def toolTip(self) -> str: ...
    def icon(self) -> QIcon: ...
    def text(self) -> str: ...
    def setData(self, value: typing.Any, role: int = ...) -> None: ...
    def data(self, role: int = ...) -> typing.Any: ...


class QStaticText(sip.simplewrapper):

    class PerformanceHint(int): ...
    ModerateCaching = ... # type: 'QStaticText.PerformanceHint'
    AggressiveCaching = ... # type: 'QStaticText.PerformanceHint'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, text: str) -> None: ...
    @typing.overload
    def __init__(self, other: 'QStaticText') -> None: ...

    def performanceHint(self) -> 'QStaticText.PerformanceHint': ...
    def setPerformanceHint(self, performanceHint: 'QStaticText.PerformanceHint') -> None: ...
    def prepare(self, matrix: 'QTransform' = ..., font: QFont = ...) -> None: ...
    def size(self) -> QtCore.QSizeF: ...
    def textOption(self) -> 'QTextOption': ...
    def setTextOption(self, textOption: 'QTextOption') -> None: ...
    def textWidth(self) -> float: ...
    def setTextWidth(self, textWidth: float) -> None: ...
    def textFormat(self) -> QtCore.Qt.TextFormat: ...
    def setTextFormat(self, textFormat: QtCore.Qt.TextFormat) -> None: ...
    def text(self) -> str: ...
    def setText(self, text: str) -> None: ...


class QStatusBar(QWidget):

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...

    def showEvent(self, a0: QShowEvent) -> None: ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    def hideOrShow(self) -> None: ...
    def reformat(self) -> None: ...
    def resizeEvent(self, a0: QResizeEvent) -> None: ...
    def paintEvent(self, a0: QPaintEvent) -> None: ...
    def messageChanged(self, text: str) -> None: ...
    def clearMessage(self) -> None: ...
    def showMessage(self, message: str, msecs: int = ...) -> None: ...
    def insertPermanentWidget(self, index: int, widget: QWidget, stretch: int = ...) -> int: ...
    def insertWidget(self, index: int, widget: QWidget, stretch: int = ...) -> int: ...
    def currentMessage(self) -> str: ...
    def isSizeGripEnabled(self) -> bool: ...
    def setSizeGripEnabled(self, a0: bool) -> None: ...
    def removeWidget(self, widget: QWidget) -> None: ...
    def addPermanentWidget(self, widget: QWidget, stretch: int = ...) -> None: ...
    def addWidget(self, widget: QWidget, stretch: int = ...) -> None: ...


class QStringListModel(QtCore.QAbstractListModel):

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, strings: typing.Sequence[str], parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def supportedDropActions(self) -> QtCore.Qt.DropActions: ...
    def sort(self, column: int, order: QtCore.Qt.SortOrder = ...) -> None: ...
    def setStringList(self, strings: typing.Sequence[str]) -> None: ...
    def stringList(self) -> typing.List[str]: ...
    def removeRows(self, row: int, count: int, parent: QtCore.QModelIndex = ...) -> bool: ...
    def insertRows(self, row: int, count: int, parent: QtCore.QModelIndex = ...) -> bool: ...
    def flags(self, index: QtCore.QModelIndex) -> QtCore.Qt.ItemFlags: ...
    def setData(self, index: QtCore.QModelIndex, value: typing.Any, role: int = ...) -> bool: ...
    def data(self, index: QtCore.QModelIndex, role: int) -> typing.Any: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...


class QStyledItemDelegate(QAbstractItemDelegate):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def editorEvent(self, event: QtCore.QEvent, model: QtCore.QAbstractItemModel, option: 'QStyleOptionViewItem', index: QtCore.QModelIndex) -> bool: ...
    def eventFilter(self, object: QtCore.QObject, event: QtCore.QEvent) -> bool: ...
    def initStyleOption(self, option: 'QStyleOptionViewItem', index: QtCore.QModelIndex) -> None: ...
    def displayText(self, value: typing.Any, locale: QtCore.QLocale) -> str: ...
    def setItemEditorFactory(self, factory: QItemEditorFactory) -> None: ...
    def itemEditorFactory(self) -> QItemEditorFactory: ...
    def updateEditorGeometry(self, editor: QWidget, option: 'QStyleOptionViewItem', index: QtCore.QModelIndex) -> None: ...
    def setModelData(self, editor: QWidget, model: QtCore.QAbstractItemModel, index: QtCore.QModelIndex) -> None: ...
    def setEditorData(self, editor: QWidget, index: QtCore.QModelIndex) -> None: ...
    def createEditor(self, parent: QWidget, option: 'QStyleOptionViewItem', index: QtCore.QModelIndex) -> QWidget: ...
    def sizeHint(self, option: 'QStyleOptionViewItem', index: QtCore.QModelIndex) -> QtCore.QSize: ...
    def paint(self, painter: QPainter, option: 'QStyleOptionViewItem', index: QtCore.QModelIndex) -> None: ...


class QStyleFactory(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QStyleFactory') -> None: ...

    @staticmethod
    def create(a0: str) -> QStyle: ...
    @staticmethod
    def keys() -> typing.List[str]: ...


class QStyleOption(sip.simplewrapper):

    class StyleOptionVersion(int): ...
    Version = ... # type: 'QStyleOption.StyleOptionVersion'

    class StyleOptionType(int): ...
    Type = ... # type: 'QStyleOption.StyleOptionType'

    class OptionType(int): ...
    SO_Default = ... # type: 'QStyleOption.OptionType'
    SO_FocusRect = ... # type: 'QStyleOption.OptionType'
    SO_Button = ... # type: 'QStyleOption.OptionType'
    SO_Tab = ... # type: 'QStyleOption.OptionType'
    SO_MenuItem = ... # type: 'QStyleOption.OptionType'
    SO_Frame = ... # type: 'QStyleOption.OptionType'
    SO_ProgressBar = ... # type: 'QStyleOption.OptionType'
    SO_ToolBox = ... # type: 'QStyleOption.OptionType'
    SO_Header = ... # type: 'QStyleOption.OptionType'
    SO_Q3DockWindow = ... # type: 'QStyleOption.OptionType'
    SO_DockWidget = ... # type: 'QStyleOption.OptionType'
    SO_Q3ListViewItem = ... # type: 'QStyleOption.OptionType'
    SO_ViewItem = ... # type: 'QStyleOption.OptionType'
    SO_TabWidgetFrame = ... # type: 'QStyleOption.OptionType'
    SO_TabBarBase = ... # type: 'QStyleOption.OptionType'
    SO_RubberBand = ... # type: 'QStyleOption.OptionType'
    SO_ToolBar = ... # type: 'QStyleOption.OptionType'
    SO_Complex = ... # type: 'QStyleOption.OptionType'
    SO_Slider = ... # type: 'QStyleOption.OptionType'
    SO_SpinBox = ... # type: 'QStyleOption.OptionType'
    SO_ToolButton = ... # type: 'QStyleOption.OptionType'
    SO_ComboBox = ... # type: 'QStyleOption.OptionType'
    SO_Q3ListView = ... # type: 'QStyleOption.OptionType'
    SO_TitleBar = ... # type: 'QStyleOption.OptionType'
    SO_GroupBox = ... # type: 'QStyleOption.OptionType'
    SO_ComplexCustomBase = ... # type: 'QStyleOption.OptionType'
    SO_GraphicsItem = ... # type: 'QStyleOption.OptionType'
    SO_SizeGrip = ... # type: 'QStyleOption.OptionType'
    SO_CustomBase = ... # type: 'QStyleOption.OptionType'

    direction = ... # type: QtCore.Qt.LayoutDirection
    fontMetrics = ... # type: QFontMetrics
    palette = ... # type: QPalette
    rect = ... # type: QtCore.QRect
    state = ... # type: QStyle.State
    type = ... # type: int
    version = ... # type: int

    @typing.overload
    def __init__(self, version: int = ..., type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, other: 'QStyleOption') -> None: ...

    def initFrom(self, w: QWidget) -> None: ...
    def init(self, w: QWidget) -> None: ...


class QStyleOptionFocusRect(QStyleOption):

    class StyleOptionVersion(int): ...
    Version = ... # type: 'QStyleOptionFocusRect.StyleOptionVersion'

    class StyleOptionType(int): ...
    Type = ... # type: 'QStyleOptionFocusRect.StyleOptionType'

    backgroundColor = ... # type: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient]

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QStyleOptionFocusRect') -> None: ...


class QStyleOptionFrame(QStyleOption):

    class StyleOptionVersion(int): ...
    Version = ... # type: 'QStyleOptionFrame.StyleOptionVersion'

    class StyleOptionType(int): ...
    Type = ... # type: 'QStyleOptionFrame.StyleOptionType'

    lineWidth = ... # type: int
    midLineWidth = ... # type: int

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QStyleOptionFrame') -> None: ...


class QStyleOptionFrameV2(QStyleOptionFrame):

    class FrameFeature(int): ...
    None_ = ... # type: 'QStyleOptionFrameV2.FrameFeature'
    Flat = ... # type: 'QStyleOptionFrameV2.FrameFeature'

    class StyleOptionVersion(int): ...
    Version = ... # type: 'QStyleOptionFrameV2.StyleOptionVersion'

    class FrameFeatures(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QStyleOptionFrameV2.FrameFeatures', 'QStyleOptionFrameV2.FrameFeature']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QStyleOptionFrameV2.FrameFeatures') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QStyleOptionFrameV2.FrameFeatures': ...
        def __int__(self) -> int: ...

    features = ... # type: 'QStyleOptionFrameV2.FrameFeatures'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QStyleOptionFrameV2') -> None: ...
    @typing.overload
    def __init__(self, other: QStyleOptionFrame) -> None: ...


class QStyleOptionTabWidgetFrame(QStyleOption):

    class StyleOptionVersion(int): ...
    Version = ... # type: 'QStyleOptionTabWidgetFrame.StyleOptionVersion'

    class StyleOptionType(int): ...
    Type = ... # type: 'QStyleOptionTabWidgetFrame.StyleOptionType'

    leftCornerWidgetSize = ... # type: QtCore.QSize
    lineWidth = ... # type: int
    midLineWidth = ... # type: int
    rightCornerWidgetSize = ... # type: QtCore.QSize
    shape = ... # type: 'QTabBar.Shape'
    tabBarSize = ... # type: QtCore.QSize

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QStyleOptionTabWidgetFrame') -> None: ...


class QStyleOptionTabBarBase(QStyleOption):

    class StyleOptionVersion(int): ...
    Version = ... # type: 'QStyleOptionTabBarBase.StyleOptionVersion'

    class StyleOptionType(int): ...
    Type = ... # type: 'QStyleOptionTabBarBase.StyleOptionType'

    selectedTabRect = ... # type: QtCore.QRect
    shape = ... # type: 'QTabBar.Shape'
    tabBarRect = ... # type: QtCore.QRect

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QStyleOptionTabBarBase') -> None: ...


class QStyleOptionHeader(QStyleOption):

    class SortIndicator(int): ...
    None_ = ... # type: 'QStyleOptionHeader.SortIndicator'
    SortUp = ... # type: 'QStyleOptionHeader.SortIndicator'
    SortDown = ... # type: 'QStyleOptionHeader.SortIndicator'

    class SelectedPosition(int): ...
    NotAdjacent = ... # type: 'QStyleOptionHeader.SelectedPosition'
    NextIsSelected = ... # type: 'QStyleOptionHeader.SelectedPosition'
    PreviousIsSelected = ... # type: 'QStyleOptionHeader.SelectedPosition'
    NextAndPreviousAreSelected = ... # type: 'QStyleOptionHeader.SelectedPosition'

    class SectionPosition(int): ...
    Beginning = ... # type: 'QStyleOptionHeader.SectionPosition'
    Middle = ... # type: 'QStyleOptionHeader.SectionPosition'
    End = ... # type: 'QStyleOptionHeader.SectionPosition'
    OnlyOneSection = ... # type: 'QStyleOptionHeader.SectionPosition'

    class StyleOptionVersion(int): ...
    Version = ... # type: 'QStyleOptionHeader.StyleOptionVersion'

    class StyleOptionType(int): ...
    Type = ... # type: 'QStyleOptionHeader.StyleOptionType'

    icon = ... # type: QIcon
    iconAlignment = ... # type: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]
    orientation = ... # type: QtCore.Qt.Orientation
    position = ... # type: 'QStyleOptionHeader.SectionPosition'
    section = ... # type: int
    selectedPosition = ... # type: 'QStyleOptionHeader.SelectedPosition'
    sortIndicator = ... # type: 'QStyleOptionHeader.SortIndicator'
    text = ... # type: str
    textAlignment = ... # type: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QStyleOptionHeader') -> None: ...


class QStyleOptionButton(QStyleOption):

    class ButtonFeature(int): ...
    None_ = ... # type: 'QStyleOptionButton.ButtonFeature'
    Flat = ... # type: 'QStyleOptionButton.ButtonFeature'
    HasMenu = ... # type: 'QStyleOptionButton.ButtonFeature'
    DefaultButton = ... # type: 'QStyleOptionButton.ButtonFeature'
    AutoDefaultButton = ... # type: 'QStyleOptionButton.ButtonFeature'
    CommandLinkButton = ... # type: 'QStyleOptionButton.ButtonFeature'

    class StyleOptionVersion(int): ...
    Version = ... # type: 'QStyleOptionButton.StyleOptionVersion'

    class StyleOptionType(int): ...
    Type = ... # type: 'QStyleOptionButton.StyleOptionType'

    class ButtonFeatures(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QStyleOptionButton.ButtonFeatures', 'QStyleOptionButton.ButtonFeature']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QStyleOptionButton.ButtonFeatures') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QStyleOptionButton.ButtonFeatures': ...
        def __int__(self) -> int: ...

    features = ... # type: 'QStyleOptionButton.ButtonFeatures'
    icon = ... # type: QIcon
    iconSize = ... # type: QtCore.QSize
    text = ... # type: str

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QStyleOptionButton') -> None: ...


class QStyleOptionTab(QStyleOption):

    class CornerWidget(int): ...
    NoCornerWidgets = ... # type: 'QStyleOptionTab.CornerWidget'
    LeftCornerWidget = ... # type: 'QStyleOptionTab.CornerWidget'
    RightCornerWidget = ... # type: 'QStyleOptionTab.CornerWidget'

    class SelectedPosition(int): ...
    NotAdjacent = ... # type: 'QStyleOptionTab.SelectedPosition'
    NextIsSelected = ... # type: 'QStyleOptionTab.SelectedPosition'
    PreviousIsSelected = ... # type: 'QStyleOptionTab.SelectedPosition'

    class TabPosition(int): ...
    Beginning = ... # type: 'QStyleOptionTab.TabPosition'
    Middle = ... # type: 'QStyleOptionTab.TabPosition'
    End = ... # type: 'QStyleOptionTab.TabPosition'
    OnlyOneTab = ... # type: 'QStyleOptionTab.TabPosition'

    class StyleOptionVersion(int): ...
    Version = ... # type: 'QStyleOptionTab.StyleOptionVersion'

    class StyleOptionType(int): ...
    Type = ... # type: 'QStyleOptionTab.StyleOptionType'

    class CornerWidgets(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QStyleOptionTab.CornerWidgets', 'QStyleOptionTab.CornerWidget']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QStyleOptionTab.CornerWidgets') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QStyleOptionTab.CornerWidgets': ...
        def __int__(self) -> int: ...

    cornerWidgets = ... # type: 'QStyleOptionTab.CornerWidgets'
    icon = ... # type: QIcon
    position = ... # type: 'QStyleOptionTab.TabPosition'
    row = ... # type: int
    selectedPosition = ... # type: 'QStyleOptionTab.SelectedPosition'
    shape = ... # type: 'QTabBar.Shape'
    text = ... # type: str

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QStyleOptionTab') -> None: ...


class QStyleOptionTabV2(QStyleOptionTab):

    class StyleOptionVersion(int): ...
    Version = ... # type: 'QStyleOptionTabV2.StyleOptionVersion'

    iconSize = ... # type: QtCore.QSize

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QStyleOptionTabV2') -> None: ...
    @typing.overload
    def __init__(self, other: QStyleOptionTab) -> None: ...


class QStyleOptionProgressBar(QStyleOption):

    class StyleOptionVersion(int): ...
    Version = ... # type: 'QStyleOptionProgressBar.StyleOptionVersion'

    class StyleOptionType(int): ...
    Type = ... # type: 'QStyleOptionProgressBar.StyleOptionType'

    maximum = ... # type: int
    minimum = ... # type: int
    progress = ... # type: int
    text = ... # type: str
    textAlignment = ... # type: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]
    textVisible = ... # type: bool

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QStyleOptionProgressBar') -> None: ...


class QStyleOptionProgressBarV2(QStyleOptionProgressBar):

    class StyleOptionVersion(int): ...
    Version = ... # type: 'QStyleOptionProgressBarV2.StyleOptionVersion'

    class StyleOptionType(int): ...
    Type = ... # type: 'QStyleOptionProgressBarV2.StyleOptionType'

    bottomToTop = ... # type: bool
    invertedAppearance = ... # type: bool
    orientation = ... # type: QtCore.Qt.Orientation

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: QStyleOptionProgressBar) -> None: ...
    @typing.overload
    def __init__(self, other: 'QStyleOptionProgressBarV2') -> None: ...


class QStyleOptionMenuItem(QStyleOption):

    class CheckType(int): ...
    NotCheckable = ... # type: 'QStyleOptionMenuItem.CheckType'
    Exclusive = ... # type: 'QStyleOptionMenuItem.CheckType'
    NonExclusive = ... # type: 'QStyleOptionMenuItem.CheckType'

    class MenuItemType(int): ...
    Normal = ... # type: 'QStyleOptionMenuItem.MenuItemType'
    DefaultItem = ... # type: 'QStyleOptionMenuItem.MenuItemType'
    Separator = ... # type: 'QStyleOptionMenuItem.MenuItemType'
    SubMenu = ... # type: 'QStyleOptionMenuItem.MenuItemType'
    Scroller = ... # type: 'QStyleOptionMenuItem.MenuItemType'
    TearOff = ... # type: 'QStyleOptionMenuItem.MenuItemType'
    Margin = ... # type: 'QStyleOptionMenuItem.MenuItemType'
    EmptyArea = ... # type: 'QStyleOptionMenuItem.MenuItemType'

    class StyleOptionVersion(int): ...
    Version = ... # type: 'QStyleOptionMenuItem.StyleOptionVersion'

    class StyleOptionType(int): ...
    Type = ... # type: 'QStyleOptionMenuItem.StyleOptionType'

    checkType = ... # type: 'QStyleOptionMenuItem.CheckType'
    checked = ... # type: bool
    font = ... # type: QFont
    icon = ... # type: QIcon
    maxIconWidth = ... # type: int
    menuHasCheckableItems = ... # type: bool
    menuItemType = ... # type: 'QStyleOptionMenuItem.MenuItemType'
    menuRect = ... # type: QtCore.QRect
    tabWidth = ... # type: int
    text = ... # type: str

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QStyleOptionMenuItem') -> None: ...


class QStyleOptionDockWidget(QStyleOption):

    class StyleOptionVersion(int): ...
    Version = ... # type: 'QStyleOptionDockWidget.StyleOptionVersion'

    class StyleOptionType(int): ...
    Type = ... # type: 'QStyleOptionDockWidget.StyleOptionType'

    closable = ... # type: bool
    floatable = ... # type: bool
    movable = ... # type: bool
    title = ... # type: str

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QStyleOptionDockWidget') -> None: ...


class QStyleOptionViewItem(QStyleOption):

    class Position(int): ...
    Left = ... # type: 'QStyleOptionViewItem.Position'
    Right = ... # type: 'QStyleOptionViewItem.Position'
    Top = ... # type: 'QStyleOptionViewItem.Position'
    Bottom = ... # type: 'QStyleOptionViewItem.Position'

    class StyleOptionVersion(int): ...
    Version = ... # type: 'QStyleOptionViewItem.StyleOptionVersion'

    class StyleOptionType(int): ...
    Type = ... # type: 'QStyleOptionViewItem.StyleOptionType'

    decorationAlignment = ... # type: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]
    decorationPosition = ... # type: 'QStyleOptionViewItem.Position'
    decorationSize = ... # type: QtCore.QSize
    displayAlignment = ... # type: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]
    font = ... # type: QFont
    showDecorationSelected = ... # type: bool
    textElideMode = ... # type: QtCore.Qt.TextElideMode

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QStyleOptionViewItem') -> None: ...


class QStyleOptionToolBox(QStyleOption):

    class StyleOptionVersion(int): ...
    Version = ... # type: 'QStyleOptionToolBox.StyleOptionVersion'

    class StyleOptionType(int): ...
    Type = ... # type: 'QStyleOptionToolBox.StyleOptionType'

    icon = ... # type: QIcon
    text = ... # type: str

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QStyleOptionToolBox') -> None: ...


class QStyleOptionRubberBand(QStyleOption):

    class StyleOptionVersion(int): ...
    Version = ... # type: 'QStyleOptionRubberBand.StyleOptionVersion'

    class StyleOptionType(int): ...
    Type = ... # type: 'QStyleOptionRubberBand.StyleOptionType'

    opaque = ... # type: bool
    shape = ... # type: QRubberBand.Shape

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QStyleOptionRubberBand') -> None: ...


class QStyleOptionComplex(QStyleOption):

    class StyleOptionVersion(int): ...
    Version = ... # type: 'QStyleOptionComplex.StyleOptionVersion'

    class StyleOptionType(int): ...
    Type = ... # type: 'QStyleOptionComplex.StyleOptionType'

    activeSubControls = ... # type: QStyle.SubControls
    subControls = ... # type: QStyle.SubControls

    @typing.overload
    def __init__(self, version: int = ..., type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, other: 'QStyleOptionComplex') -> None: ...


class QStyleOptionSlider(QStyleOptionComplex):

    class StyleOptionVersion(int): ...
    Version = ... # type: 'QStyleOptionSlider.StyleOptionVersion'

    class StyleOptionType(int): ...
    Type = ... # type: 'QStyleOptionSlider.StyleOptionType'

    dialWrapping = ... # type: bool
    maximum = ... # type: int
    minimum = ... # type: int
    notchTarget = ... # type: float
    orientation = ... # type: QtCore.Qt.Orientation
    pageStep = ... # type: int
    singleStep = ... # type: int
    sliderPosition = ... # type: int
    sliderValue = ... # type: int
    tickInterval = ... # type: int
    tickPosition = ... # type: QSlider.TickPosition
    upsideDown = ... # type: bool

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QStyleOptionSlider') -> None: ...


class QStyleOptionSpinBox(QStyleOptionComplex):

    class StyleOptionVersion(int): ...
    Version = ... # type: 'QStyleOptionSpinBox.StyleOptionVersion'

    class StyleOptionType(int): ...
    Type = ... # type: 'QStyleOptionSpinBox.StyleOptionType'

    buttonSymbols = ... # type: QAbstractSpinBox.ButtonSymbols
    frame = ... # type: bool
    stepEnabled = ... # type: QAbstractSpinBox.StepEnabled

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QStyleOptionSpinBox') -> None: ...


class QStyleOptionToolButton(QStyleOptionComplex):

    class ToolButtonFeature(int): ...
    None_ = ... # type: 'QStyleOptionToolButton.ToolButtonFeature'
    Arrow = ... # type: 'QStyleOptionToolButton.ToolButtonFeature'
    Menu = ... # type: 'QStyleOptionToolButton.ToolButtonFeature'
    PopupDelay = ... # type: 'QStyleOptionToolButton.ToolButtonFeature'
    MenuButtonPopup = ... # type: 'QStyleOptionToolButton.ToolButtonFeature'
    HasMenu = ... # type: 'QStyleOptionToolButton.ToolButtonFeature'

    class StyleOptionVersion(int): ...
    Version = ... # type: 'QStyleOptionToolButton.StyleOptionVersion'

    class StyleOptionType(int): ...
    Type = ... # type: 'QStyleOptionToolButton.StyleOptionType'

    class ToolButtonFeatures(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QStyleOptionToolButton.ToolButtonFeatures', 'QStyleOptionToolButton.ToolButtonFeature']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QStyleOptionToolButton.ToolButtonFeatures') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QStyleOptionToolButton.ToolButtonFeatures': ...
        def __int__(self) -> int: ...

    arrowType = ... # type: QtCore.Qt.ArrowType
    features = ... # type: 'QStyleOptionToolButton.ToolButtonFeatures'
    font = ... # type: QFont
    icon = ... # type: QIcon
    iconSize = ... # type: QtCore.QSize
    pos = ... # type: QtCore.QPoint
    text = ... # type: str
    toolButtonStyle = ... # type: QtCore.Qt.ToolButtonStyle

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QStyleOptionToolButton') -> None: ...


class QStyleOptionComboBox(QStyleOptionComplex):

    class StyleOptionVersion(int): ...
    Version = ... # type: 'QStyleOptionComboBox.StyleOptionVersion'

    class StyleOptionType(int): ...
    Type = ... # type: 'QStyleOptionComboBox.StyleOptionType'

    currentIcon = ... # type: QIcon
    currentText = ... # type: str
    editable = ... # type: bool
    frame = ... # type: bool
    iconSize = ... # type: QtCore.QSize
    popupRect = ... # type: QtCore.QRect

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QStyleOptionComboBox') -> None: ...


class QStyleOptionTitleBar(QStyleOptionComplex):

    class StyleOptionVersion(int): ...
    Version = ... # type: 'QStyleOptionTitleBar.StyleOptionVersion'

    class StyleOptionType(int): ...
    Type = ... # type: 'QStyleOptionTitleBar.StyleOptionType'

    icon = ... # type: QIcon
    text = ... # type: str
    titleBarFlags = ... # type: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType]
    titleBarState = ... # type: int

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QStyleOptionTitleBar') -> None: ...


class QStyleHintReturn(sip.simplewrapper):

    class StyleOptionVersion(int): ...
    Version = ... # type: 'QStyleHintReturn.StyleOptionVersion'

    class StyleOptionType(int): ...
    Type = ... # type: 'QStyleHintReturn.StyleOptionType'

    class HintReturnType(int): ...
    SH_Default = ... # type: 'QStyleHintReturn.HintReturnType'
    SH_Mask = ... # type: 'QStyleHintReturn.HintReturnType'
    SH_Variant = ... # type: 'QStyleHintReturn.HintReturnType'

    type = ... # type: int
    version = ... # type: int

    @typing.overload
    def __init__(self, version: int = ..., type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QStyleHintReturn') -> None: ...


class QStyleHintReturnMask(QStyleHintReturn):

    class StyleOptionVersion(int): ...
    Version = ... # type: 'QStyleHintReturnMask.StyleOptionVersion'

    class StyleOptionType(int): ...
    Type = ... # type: 'QStyleHintReturnMask.StyleOptionType'

    region = ... # type: QRegion

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QStyleHintReturnMask') -> None: ...


class QStyleOptionToolBar(QStyleOption):

    class ToolBarFeature(int): ...
    None_ = ... # type: 'QStyleOptionToolBar.ToolBarFeature'
    Movable = ... # type: 'QStyleOptionToolBar.ToolBarFeature'

    class ToolBarPosition(int): ...
    Beginning = ... # type: 'QStyleOptionToolBar.ToolBarPosition'
    Middle = ... # type: 'QStyleOptionToolBar.ToolBarPosition'
    End = ... # type: 'QStyleOptionToolBar.ToolBarPosition'
    OnlyOne = ... # type: 'QStyleOptionToolBar.ToolBarPosition'

    class StyleOptionVersion(int): ...
    Version = ... # type: 'QStyleOptionToolBar.StyleOptionVersion'

    class StyleOptionType(int): ...
    Type = ... # type: 'QStyleOptionToolBar.StyleOptionType'

    class ToolBarFeatures(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QStyleOptionToolBar.ToolBarFeatures', 'QStyleOptionToolBar.ToolBarFeature']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QStyleOptionToolBar.ToolBarFeatures') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QStyleOptionToolBar.ToolBarFeatures': ...
        def __int__(self) -> int: ...

    features = ... # type: 'QStyleOptionToolBar.ToolBarFeatures'
    lineWidth = ... # type: int
    midLineWidth = ... # type: int
    positionOfLine = ... # type: 'QStyleOptionToolBar.ToolBarPosition'
    positionWithinLine = ... # type: 'QStyleOptionToolBar.ToolBarPosition'
    toolBarArea = ... # type: QtCore.Qt.ToolBarArea

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QStyleOptionToolBar') -> None: ...


class QStyleOptionGroupBox(QStyleOptionComplex):

    class StyleOptionVersion(int): ...
    Version = ... # type: 'QStyleOptionGroupBox.StyleOptionVersion'

    class StyleOptionType(int): ...
    Type = ... # type: 'QStyleOptionGroupBox.StyleOptionType'

    features = ... # type: QStyleOptionFrameV2.FrameFeatures
    lineWidth = ... # type: int
    midLineWidth = ... # type: int
    text = ... # type: str
    textAlignment = ... # type: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]
    textColor = ... # type: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient]

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QStyleOptionGroupBox') -> None: ...


class QStyleOptionViewItemV2(QStyleOptionViewItem):

    class ViewItemFeature(int): ...
    None_ = ... # type: 'QStyleOptionViewItemV2.ViewItemFeature'
    WrapText = ... # type: 'QStyleOptionViewItemV2.ViewItemFeature'
    Alternate = ... # type: 'QStyleOptionViewItemV2.ViewItemFeature'
    HasCheckIndicator = ... # type: 'QStyleOptionViewItemV2.ViewItemFeature'
    HasDisplay = ... # type: 'QStyleOptionViewItemV2.ViewItemFeature'
    HasDecoration = ... # type: 'QStyleOptionViewItemV2.ViewItemFeature'

    class StyleOptionVersion(int): ...
    Version = ... # type: 'QStyleOptionViewItemV2.StyleOptionVersion'

    class ViewItemFeatures(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QStyleOptionViewItemV2.ViewItemFeatures', 'QStyleOptionViewItemV2.ViewItemFeature']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QStyleOptionViewItemV2.ViewItemFeatures') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QStyleOptionViewItemV2.ViewItemFeatures': ...
        def __int__(self) -> int: ...

    features = ... # type: 'QStyleOptionViewItemV2.ViewItemFeatures'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QStyleOptionViewItemV2') -> None: ...
    @typing.overload
    def __init__(self, other: QStyleOptionViewItem) -> None: ...


class QStyleOptionSizeGrip(QStyleOptionComplex):

    class StyleOptionVersion(int): ...
    Version = ... # type: 'QStyleOptionSizeGrip.StyleOptionVersion'

    class StyleOptionType(int): ...
    Type = ... # type: 'QStyleOptionSizeGrip.StyleOptionType'

    corner = ... # type: QtCore.Qt.Corner

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QStyleOptionSizeGrip') -> None: ...


class QStyleOptionGraphicsItem(QStyleOption):

    class StyleOptionVersion(int): ...
    Version = ... # type: 'QStyleOptionGraphicsItem.StyleOptionVersion'

    class StyleOptionType(int): ...
    Type = ... # type: 'QStyleOptionGraphicsItem.StyleOptionType'

    exposedRect = ... # type: QtCore.QRectF
    levelOfDetail = ... # type: float
    matrix = ... # type: QMatrix

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QStyleOptionGraphicsItem') -> None: ...

    @staticmethod
    def levelOfDetailFromTransform(worldTransform: 'QTransform') -> float: ...


class QStyleOptionDockWidgetV2(QStyleOptionDockWidget):

    class StyleOptionVersion(int): ...
    Version = ... # type: 'QStyleOptionDockWidgetV2.StyleOptionVersion'

    verticalTitleBar = ... # type: bool

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QStyleOptionDockWidgetV2') -> None: ...
    @typing.overload
    def __init__(self, other: QStyleOptionDockWidget) -> None: ...


class QStyleOptionViewItemV3(QStyleOptionViewItemV2):

    class StyleOptionVersion(int): ...
    Version = ... # type: 'QStyleOptionViewItemV3.StyleOptionVersion'

    locale = ... # type: QtCore.QLocale
    widget = ... # type: QWidget

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QStyleOptionViewItemV3') -> None: ...
    @typing.overload
    def __init__(self, other: QStyleOptionViewItem) -> None: ...


class QStyleOptionToolBoxV2(QStyleOptionToolBox):

    class SelectedPosition(int): ...
    NotAdjacent = ... # type: 'QStyleOptionToolBoxV2.SelectedPosition'
    NextIsSelected = ... # type: 'QStyleOptionToolBoxV2.SelectedPosition'
    PreviousIsSelected = ... # type: 'QStyleOptionToolBoxV2.SelectedPosition'

    class TabPosition(int): ...
    Beginning = ... # type: 'QStyleOptionToolBoxV2.TabPosition'
    Middle = ... # type: 'QStyleOptionToolBoxV2.TabPosition'
    End = ... # type: 'QStyleOptionToolBoxV2.TabPosition'
    OnlyOneTab = ... # type: 'QStyleOptionToolBoxV2.TabPosition'

    class StyleOptionVersion(int): ...
    Version = ... # type: 'QStyleOptionToolBoxV2.StyleOptionVersion'

    position = ... # type: 'QStyleOptionToolBoxV2.TabPosition'
    selectedPosition = ... # type: 'QStyleOptionToolBoxV2.SelectedPosition'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QStyleOptionToolBoxV2') -> None: ...
    @typing.overload
    def __init__(self, other: QStyleOptionToolBox) -> None: ...


class QStyleHintReturnVariant(QStyleHintReturn):

    class StyleOptionVersion(int): ...
    Version = ... # type: 'QStyleHintReturnVariant.StyleOptionVersion'

    class StyleOptionType(int): ...
    Type = ... # type: 'QStyleHintReturnVariant.StyleOptionType'

    variant = ... # type: typing.Any

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QStyleHintReturnVariant') -> None: ...


class QStyleOptionViewItemV4(QStyleOptionViewItemV3):

    class ViewItemPosition(int): ...
    Invalid = ... # type: 'QStyleOptionViewItemV4.ViewItemPosition'
    Beginning = ... # type: 'QStyleOptionViewItemV4.ViewItemPosition'
    Middle = ... # type: 'QStyleOptionViewItemV4.ViewItemPosition'
    End = ... # type: 'QStyleOptionViewItemV4.ViewItemPosition'
    OnlyOne = ... # type: 'QStyleOptionViewItemV4.ViewItemPosition'

    class StyleOptionVersion(int): ...
    Version = ... # type: 'QStyleOptionViewItemV4.StyleOptionVersion'

    backgroundBrush = ... # type: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]
    checkState = ... # type: QtCore.Qt.CheckState
    icon = ... # type: QIcon
    index = ... # type: QtCore.QModelIndex
    text = ... # type: str
    viewItemPosition = ... # type: 'QStyleOptionViewItemV4.ViewItemPosition'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QStyleOptionViewItemV4') -> None: ...
    @typing.overload
    def __init__(self, other: QStyleOptionViewItem) -> None: ...


class QStyleOptionFrameV3(QStyleOptionFrameV2):

    class StyleOptionVersion(int): ...
    Version = ... # type: 'QStyleOptionFrameV3.StyleOptionVersion'

    frameShape = ... # type: QFrame.Shape
    unused = ... # type: int

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QStyleOptionFrameV3') -> None: ...
    @typing.overload
    def __init__(self, other: QStyleOptionFrame) -> None: ...


class QStyleOptionTabBarBaseV2(QStyleOptionTabBarBase):

    class StyleOptionVersion(int): ...
    Version = ... # type: 'QStyleOptionTabBarBaseV2.StyleOptionVersion'

    documentMode = ... # type: bool

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QStyleOptionTabBarBaseV2') -> None: ...
    @typing.overload
    def __init__(self, other: QStyleOptionTabBarBase) -> None: ...


class QStyleOptionTabV3(QStyleOptionTabV2):

    class StyleOptionVersion(int): ...
    Version = ... # type: 'QStyleOptionTabV3.StyleOptionVersion'

    documentMode = ... # type: bool
    leftButtonSize = ... # type: QtCore.QSize
    rightButtonSize = ... # type: QtCore.QSize

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QStyleOptionTabV3') -> None: ...
    @typing.overload
    def __init__(self, other: QStyleOptionTabV2) -> None: ...
    @typing.overload
    def __init__(self, other: QStyleOptionTab) -> None: ...


class QStyleOptionTabWidgetFrameV2(QStyleOptionTabWidgetFrame):

    class StyleOptionVersion(int): ...
    Version = ... # type: 'QStyleOptionTabWidgetFrameV2.StyleOptionVersion'

    selectedTabRect = ... # type: QtCore.QRect
    tabBarRect = ... # type: QtCore.QRect

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QStyleOptionTabWidgetFrameV2') -> None: ...
    @typing.overload
    def __init__(self, other: QStyleOptionTabWidgetFrame) -> None: ...


class QStylePainter(QPainter):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, w: QWidget) -> None: ...
    @typing.overload
    def __init__(self, pd: QPaintDevice, w: QWidget) -> None: ...

    def drawItemPixmap(self, r: QtCore.QRect, flags: int, pixmap: QPixmap) -> None: ...
    def drawItemText(self, rect: QtCore.QRect, flags: int, pal: QPalette, enabled: bool, text: str, textRole: QPalette.ColorRole = ...) -> None: ...
    def drawComplexControl(self, cc: QStyle.ComplexControl, opt: QStyleOptionComplex) -> None: ...
    def drawControl(self, ce: QStyle.ControlElement, opt: QStyleOption) -> None: ...
    def drawPrimitive(self, pe: QStyle.PrimitiveElement, opt: QStyleOption) -> None: ...
    def style(self) -> QStyle: ...
    @typing.overload
    def begin(self, w: QWidget) -> bool: ...
    @typing.overload
    def begin(self, pd: QPaintDevice, w: QWidget) -> bool: ...


class QSyntaxHighlighter(QtCore.QObject):

    @typing.overload
    def __init__(self, parent: 'QTextEdit') -> None: ...
    @typing.overload
    def __init__(self, parent: 'QTextDocument') -> None: ...
    @typing.overload
    def __init__(self, parent: QtCore.QObject) -> None: ...

    def currentBlock(self) -> 'QTextBlock': ...
    def currentBlockUserData(self) -> 'QTextBlockUserData': ...
    def setCurrentBlockUserData(self, data: 'QTextBlockUserData') -> None: ...
    def setCurrentBlockState(self, newState: int) -> None: ...
    def currentBlockState(self) -> int: ...
    def previousBlockState(self) -> int: ...
    def format(self, pos: int) -> 'QTextCharFormat': ...
    @typing.overload
    def setFormat(self, start: int, count: int, format: 'QTextCharFormat') -> None: ...
    @typing.overload
    def setFormat(self, start: int, count: int, color: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    @typing.overload
    def setFormat(self, start: int, count: int, font: QFont) -> None: ...
    def highlightBlock(self, text: str) -> None: ...
    def rehighlightBlock(self, block: 'QTextBlock') -> None: ...
    def rehighlight(self) -> None: ...
    def document(self) -> 'QTextDocument': ...
    def setDocument(self, doc: 'QTextDocument') -> None: ...


class QSystemTrayIcon(QtCore.QObject):

    class MessageIcon(int): ...
    NoIcon = ... # type: 'QSystemTrayIcon.MessageIcon'
    Information = ... # type: 'QSystemTrayIcon.MessageIcon'
    Warning = ... # type: 'QSystemTrayIcon.MessageIcon'
    Critical = ... # type: 'QSystemTrayIcon.MessageIcon'

    class ActivationReason(int): ...
    Unknown = ... # type: 'QSystemTrayIcon.ActivationReason'
    Context = ... # type: 'QSystemTrayIcon.ActivationReason'
    DoubleClick = ... # type: 'QSystemTrayIcon.ActivationReason'
    Trigger = ... # type: 'QSystemTrayIcon.ActivationReason'
    MiddleClick = ... # type: 'QSystemTrayIcon.ActivationReason'

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, icon: QIcon, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def event(self, event: QtCore.QEvent) -> bool: ...
    def messageClicked(self) -> None: ...
    def activated(self, reason: 'QSystemTrayIcon.ActivationReason') -> None: ...
    def show(self) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def hide(self) -> None: ...
    def isVisible(self) -> bool: ...
    def showMessage(self, title: str, msg: str, icon: 'QSystemTrayIcon.MessageIcon' = ..., msecs: int = ...) -> None: ...
    @staticmethod
    def supportsMessages() -> bool: ...
    @staticmethod
    def isSystemTrayAvailable() -> bool: ...
    def setToolTip(self, tip: str) -> None: ...
    def toolTip(self) -> str: ...
    def setIcon(self, icon: QIcon) -> None: ...
    def icon(self) -> QIcon: ...
    def geometry(self) -> QtCore.QRect: ...
    def contextMenu(self) -> QMenu: ...
    def setContextMenu(self, menu: QMenu) -> None: ...


class QTabBar(QWidget):

    class SelectionBehavior(int): ...
    SelectLeftTab = ... # type: 'QTabBar.SelectionBehavior'
    SelectRightTab = ... # type: 'QTabBar.SelectionBehavior'
    SelectPreviousTab = ... # type: 'QTabBar.SelectionBehavior'

    class ButtonPosition(int): ...
    LeftSide = ... # type: 'QTabBar.ButtonPosition'
    RightSide = ... # type: 'QTabBar.ButtonPosition'

    class Shape(int): ...
    RoundedNorth = ... # type: 'QTabBar.Shape'
    RoundedSouth = ... # type: 'QTabBar.Shape'
    RoundedWest = ... # type: 'QTabBar.Shape'
    RoundedEast = ... # type: 'QTabBar.Shape'
    TriangularNorth = ... # type: 'QTabBar.Shape'
    TriangularSouth = ... # type: 'QTabBar.Shape'
    TriangularWest = ... # type: 'QTabBar.Shape'
    TriangularEast = ... # type: 'QTabBar.Shape'

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...

    def wheelEvent(self, event: QWheelEvent) -> None: ...
    def hideEvent(self, a0: QHideEvent) -> None: ...
    def tabMoved(self, from_: int, to: int) -> None: ...
    def tabCloseRequested(self, index: int) -> None: ...
    def setDocumentMode(self, set: bool) -> None: ...
    def documentMode(self) -> bool: ...
    def setMovable(self, movable: bool) -> None: ...
    def isMovable(self) -> bool: ...
    def setExpanding(self, enabled: bool) -> None: ...
    def expanding(self) -> bool: ...
    def setSelectionBehaviorOnRemove(self, behavior: 'QTabBar.SelectionBehavior') -> None: ...
    def selectionBehaviorOnRemove(self) -> 'QTabBar.SelectionBehavior': ...
    def tabButton(self, index: int, position: 'QTabBar.ButtonPosition') -> QWidget: ...
    def setTabButton(self, index: int, position: 'QTabBar.ButtonPosition', widget: QWidget) -> None: ...
    def setTabsClosable(self, closable: bool) -> None: ...
    def tabsClosable(self) -> bool: ...
    def moveTab(self, from_: int, to: int) -> None: ...
    def changeEvent(self, a0: QtCore.QEvent) -> None: ...
    def keyPressEvent(self, a0: QKeyEvent) -> None: ...
    def mouseReleaseEvent(self, a0: QMouseEvent) -> None: ...
    def mouseMoveEvent(self, a0: QMouseEvent) -> None: ...
    def mousePressEvent(self, a0: QMouseEvent) -> None: ...
    def paintEvent(self, a0: QPaintEvent) -> None: ...
    def showEvent(self, a0: QShowEvent) -> None: ...
    def resizeEvent(self, a0: QResizeEvent) -> None: ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    def tabLayoutChange(self) -> None: ...
    def tabRemoved(self, index: int) -> None: ...
    def tabInserted(self, index: int) -> None: ...
    def tabSizeHint(self, index: int) -> QtCore.QSize: ...
    def initStyleOption(self, option: QStyleOptionTab, tabIndex: int) -> None: ...
    def currentChanged(self, index: int) -> None: ...
    def setCurrentIndex(self, index: int) -> None: ...
    def usesScrollButtons(self) -> bool: ...
    def setUsesScrollButtons(self, useButtons: bool) -> None: ...
    def setElideMode(self, a0: QtCore.Qt.TextElideMode) -> None: ...
    def elideMode(self) -> QtCore.Qt.TextElideMode: ...
    def setIconSize(self, size: QtCore.QSize) -> None: ...
    def iconSize(self) -> QtCore.QSize: ...
    def drawBase(self) -> bool: ...
    def setDrawBase(self, drawTheBase: bool) -> None: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def currentIndex(self) -> int: ...
    def tabRect(self, index: int) -> QtCore.QRect: ...
    def tabAt(self, pos: QtCore.QPoint) -> int: ...
    def tabData(self, index: int) -> typing.Any: ...
    def setTabData(self, index: int, data: typing.Any) -> None: ...
    def tabWhatsThis(self, index: int) -> str: ...
    def setTabWhatsThis(self, index: int, text: str) -> None: ...
    def tabToolTip(self, index: int) -> str: ...
    def setTabToolTip(self, index: int, tip: str) -> None: ...
    def setTabIcon(self, index: int, icon: QIcon) -> None: ...
    def tabIcon(self, index: int) -> QIcon: ...
    def setTabTextColor(self, index: int, color: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def tabTextColor(self, index: int) -> QColor: ...
    def setTabText(self, index: int, text: str) -> None: ...
    def tabText(self, index: int) -> str: ...
    def setTabEnabled(self, index: int, a1: bool) -> None: ...
    def isTabEnabled(self, index: int) -> bool: ...
    def removeTab(self, index: int) -> None: ...
    @typing.overload
    def insertTab(self, index: int, text: str) -> int: ...
    @typing.overload
    def insertTab(self, index: int, icon: QIcon, text: str) -> int: ...
    @typing.overload
    def addTab(self, text: str) -> int: ...
    @typing.overload
    def addTab(self, icon: QIcon, text: str) -> int: ...
    def setShape(self, shape: 'QTabBar.Shape') -> None: ...
    def shape(self) -> 'QTabBar.Shape': ...


class QTableView(QAbstractItemView):

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...

    def currentChanged(self, current: QtCore.QModelIndex, previous: QtCore.QModelIndex) -> None: ...
    def selectionChanged(self, selected: QItemSelection, deselected: QItemSelection) -> None: ...
    def clearSpans(self) -> None: ...
    def isCornerButtonEnabled(self) -> bool: ...
    def setCornerButtonEnabled(self, enable: bool) -> None: ...
    def wordWrap(self) -> bool: ...
    def setWordWrap(self, on: bool) -> None: ...
    def columnSpan(self, row: int, column: int) -> int: ...
    def rowSpan(self, row: int, column: int) -> int: ...
    def setSpan(self, row: int, column: int, rowSpan: int, columnSpan: int) -> None: ...
    def isSortingEnabled(self) -> bool: ...
    def setSortingEnabled(self, enable: bool) -> None: ...
    def isIndexHidden(self, index: QtCore.QModelIndex) -> bool: ...
    def horizontalScrollbarAction(self, action: int) -> None: ...
    def verticalScrollbarAction(self, action: int) -> None: ...
    def sizeHintForColumn(self, column: int) -> int: ...
    def sizeHintForRow(self, row: int) -> int: ...
    def updateGeometries(self) -> None: ...
    def selectedIndexes(self) -> typing.List[QtCore.QModelIndex]: ...
    def visualRegionForSelection(self, selection: QItemSelection) -> QRegion: ...
    def setSelection(self, rect: QtCore.QRect, command: QItemSelectionModel.SelectionFlags) -> None: ...
    def moveCursor(self, cursorAction: QAbstractItemView.CursorAction, modifiers: typing.Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier]) -> QtCore.QModelIndex: ...
    def verticalOffset(self) -> int: ...
    def horizontalOffset(self) -> int: ...
    def timerEvent(self, event: QtCore.QTimerEvent) -> None: ...
    def paintEvent(self, e: QPaintEvent) -> None: ...
    def viewOptions(self) -> QStyleOptionViewItem: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def columnCountChanged(self, oldCount: int, newCount: int) -> None: ...
    def rowCountChanged(self, oldCount: int, newCount: int) -> None: ...
    def columnResized(self, column: int, oldWidth: int, newWidth: int) -> None: ...
    def rowResized(self, row: int, oldHeight: int, newHeight: int) -> None: ...
    def columnMoved(self, column: int, oldIndex: int, newIndex: int) -> None: ...
    def rowMoved(self, row: int, oldIndex: int, newIndex: int) -> None: ...
    @typing.overload
    def sortByColumn(self, column: int) -> None: ...
    @typing.overload
    def sortByColumn(self, column: int, order: QtCore.Qt.SortOrder) -> None: ...
    def resizeColumnsToContents(self) -> None: ...
    def resizeColumnToContents(self, column: int) -> None: ...
    def resizeRowsToContents(self) -> None: ...
    def resizeRowToContents(self, row: int) -> None: ...
    def showColumn(self, column: int) -> None: ...
    def showRow(self, row: int) -> None: ...
    def hideColumn(self, column: int) -> None: ...
    def hideRow(self, row: int) -> None: ...
    def selectColumn(self, column: int) -> None: ...
    def selectRow(self, row: int) -> None: ...
    def indexAt(self, p: QtCore.QPoint) -> QtCore.QModelIndex: ...
    def scrollTo(self, index: QtCore.QModelIndex, hint: QAbstractItemView.ScrollHint = ...) -> None: ...
    def visualRect(self, index: QtCore.QModelIndex) -> QtCore.QRect: ...
    def setGridStyle(self, style: QtCore.Qt.PenStyle) -> None: ...
    def gridStyle(self) -> QtCore.Qt.PenStyle: ...
    def setShowGrid(self, show: bool) -> None: ...
    def showGrid(self) -> bool: ...
    def setColumnHidden(self, column: int, hide: bool) -> None: ...
    def isColumnHidden(self, column: int) -> bool: ...
    def setRowHidden(self, row: int, hide: bool) -> None: ...
    def isRowHidden(self, row: int) -> bool: ...
    def columnAt(self, x: int) -> int: ...
    def columnWidth(self, column: int) -> int: ...
    def setColumnWidth(self, column: int, width: int) -> None: ...
    def columnViewportPosition(self, column: int) -> int: ...
    def rowAt(self, y: int) -> int: ...
    def rowHeight(self, row: int) -> int: ...
    def setRowHeight(self, row: int, height: int) -> None: ...
    def rowViewportPosition(self, row: int) -> int: ...
    def setVerticalHeader(self, header: QHeaderView) -> None: ...
    def setHorizontalHeader(self, header: QHeaderView) -> None: ...
    def verticalHeader(self) -> QHeaderView: ...
    def horizontalHeader(self) -> QHeaderView: ...
    def setSelectionModel(self, selectionModel: QItemSelectionModel) -> None: ...
    def setRootIndex(self, index: QtCore.QModelIndex) -> None: ...
    def setModel(self, model: QtCore.QAbstractItemModel) -> None: ...


class QTableWidgetSelectionRange(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, top: int, left: int, bottom: int, right: int) -> None: ...
    @typing.overload
    def __init__(self, other: 'QTableWidgetSelectionRange') -> None: ...

    def columnCount(self) -> int: ...
    def rowCount(self) -> int: ...
    def rightColumn(self) -> int: ...
    def leftColumn(self) -> int: ...
    def bottomRow(self) -> int: ...
    def topRow(self) -> int: ...


class QTableWidgetItem(sip.wrapper):

    class ItemType(int): ...
    Type = ... # type: 'QTableWidgetItem.ItemType'
    UserType = ... # type: 'QTableWidgetItem.ItemType'

    @typing.overload
    def __init__(self, type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str, type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, icon: QIcon, text: str, type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, other: 'QTableWidgetItem') -> None: ...

    def isSelected(self) -> bool: ...
    def setSelected(self, aselect: bool) -> None: ...
    def column(self) -> int: ...
    def row(self) -> int: ...
    def setForeground(self, brush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def foreground(self) -> QBrush: ...
    def setBackground(self, brush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def background(self) -> QBrush: ...
    def setSizeHint(self, size: QtCore.QSize) -> None: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def setFont(self, afont: QFont) -> None: ...
    def setWhatsThis(self, awhatsThis: str) -> None: ...
    def setToolTip(self, atoolTip: str) -> None: ...
    def setStatusTip(self, astatusTip: str) -> None: ...
    def setIcon(self, aicon: QIcon) -> None: ...
    def setText(self, atext: str) -> None: ...
    def setFlags(self, aflags: typing.Union[QtCore.Qt.ItemFlags, QtCore.Qt.ItemFlag]) -> None: ...
    def type(self) -> int: ...
    def write(self, out: QtCore.QDataStream) -> None: ...
    def read(self, in_: QtCore.QDataStream) -> None: ...
    def setData(self, role: int, value: typing.Any) -> None: ...
    def data(self, role: int) -> typing.Any: ...
    def setCheckState(self, state: QtCore.Qt.CheckState) -> None: ...
    def checkState(self) -> QtCore.Qt.CheckState: ...
    def setTextColor(self, color: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def textColor(self) -> QColor: ...
    def setBackgroundColor(self, color: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def backgroundColor(self) -> QColor: ...
    def setTextAlignment(self, alignment: int) -> None: ...
    def textAlignment(self) -> int: ...
    def font(self) -> QFont: ...
    def whatsThis(self) -> str: ...
    def toolTip(self) -> str: ...
    def statusTip(self) -> str: ...
    def icon(self) -> QIcon: ...
    def text(self) -> str: ...
    def flags(self) -> QtCore.Qt.ItemFlags: ...
    def tableWidget(self) -> 'QTableWidget': ...
    def clone(self) -> 'QTableWidgetItem': ...


class QTableWidget(QTableView):

    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, rows: int, columns: int, parent: typing.Optional[QWidget] = ...) -> None: ...

    def dropEvent(self, event: QDropEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def itemFromIndex(self, index: QtCore.QModelIndex) -> QTableWidgetItem: ...
    def indexFromItem(self, item: QTableWidgetItem) -> QtCore.QModelIndex: ...
    def items(self, data: QtCore.QMimeData) -> typing.List[QTableWidgetItem]: ...
    def supportedDropActions(self) -> QtCore.Qt.DropActions: ...
    def dropMimeData(self, row: int, column: int, data: QtCore.QMimeData, action: QtCore.Qt.DropAction) -> bool: ...
    def mimeData(self, items: typing.Sequence[QTableWidgetItem]) -> QtCore.QMimeData: ...
    def mimeTypes(self) -> typing.List[str]: ...
    def currentCellChanged(self, currentRow: int, currentColumn: int, previousRow: int, previousColumn: int) -> None: ...
    def cellChanged(self, row: int, column: int) -> None: ...
    def cellEntered(self, row: int, column: int) -> None: ...
    def cellActivated(self, row: int, column: int) -> None: ...
    def cellDoubleClicked(self, row: int, column: int) -> None: ...
    def cellClicked(self, row: int, column: int) -> None: ...
    def cellPressed(self, row: int, column: int) -> None: ...
    def itemSelectionChanged(self) -> None: ...
    def currentItemChanged(self, current: QTableWidgetItem, previous: QTableWidgetItem) -> None: ...
    def itemChanged(self, item: QTableWidgetItem) -> None: ...
    def itemEntered(self, item: QTableWidgetItem) -> None: ...
    def itemActivated(self, item: QTableWidgetItem) -> None: ...
    def itemDoubleClicked(self, item: QTableWidgetItem) -> None: ...
    def itemClicked(self, item: QTableWidgetItem) -> None: ...
    def itemPressed(self, item: QTableWidgetItem) -> None: ...
    def clearContents(self) -> None: ...
    def clear(self) -> None: ...
    def removeColumn(self, column: int) -> None: ...
    def removeRow(self, row: int) -> None: ...
    def insertColumn(self, column: int) -> None: ...
    def insertRow(self, row: int) -> None: ...
    def scrollToItem(self, item: QTableWidgetItem, hint: QAbstractItemView.ScrollHint = ...) -> None: ...
    def setItemPrototype(self, item: QTableWidgetItem) -> None: ...
    def itemPrototype(self) -> QTableWidgetItem: ...
    def visualItemRect(self, item: QTableWidgetItem) -> QtCore.QRect: ...
    @typing.overload
    def itemAt(self, p: QtCore.QPoint) -> QTableWidgetItem: ...
    @typing.overload
    def itemAt(self, ax: int, ay: int) -> QTableWidgetItem: ...
    def visualColumn(self, logicalColumn: int) -> int: ...
    def visualRow(self, logicalRow: int) -> int: ...
    def findItems(self, text: str, flags: typing.Union[QtCore.Qt.MatchFlags, QtCore.Qt.MatchFlag]) -> typing.List[QTableWidgetItem]: ...
    def selectedItems(self) -> typing.List[QTableWidgetItem]: ...
    def selectedRanges(self) -> typing.List[QTableWidgetSelectionRange]: ...
    def setRangeSelected(self, range: QTableWidgetSelectionRange, select: bool) -> None: ...
    def setItemSelected(self, item: QTableWidgetItem, select: bool) -> None: ...
    def isItemSelected(self, item: QTableWidgetItem) -> bool: ...
    def removeCellWidget(self, arow: int, acolumn: int) -> None: ...
    def setCellWidget(self, row: int, column: int, widget: QWidget) -> None: ...
    def cellWidget(self, row: int, column: int) -> QWidget: ...
    def closePersistentEditor(self, item: QTableWidgetItem) -> None: ...
    def openPersistentEditor(self, item: QTableWidgetItem) -> None: ...
    def editItem(self, item: QTableWidgetItem) -> None: ...
    def isSortingEnabled(self) -> bool: ...
    def setSortingEnabled(self, enable: bool) -> None: ...
    def sortItems(self, column: int, order: QtCore.Qt.SortOrder = ...) -> None: ...
    @typing.overload
    def setCurrentCell(self, row: int, column: int) -> None: ...
    @typing.overload
    def setCurrentCell(self, row: int, column: int, command: QItemSelectionModel.SelectionFlags) -> None: ...
    @typing.overload
    def setCurrentItem(self, item: QTableWidgetItem) -> None: ...
    @typing.overload
    def setCurrentItem(self, item: QTableWidgetItem, command: QItemSelectionModel.SelectionFlags) -> None: ...
    def currentItem(self) -> QTableWidgetItem: ...
    def currentColumn(self) -> int: ...
    def currentRow(self) -> int: ...
    def setHorizontalHeaderLabels(self, labels: typing.Sequence[str]) -> None: ...
    def setVerticalHeaderLabels(self, labels: typing.Sequence[str]) -> None: ...
    def takeHorizontalHeaderItem(self, column: int) -> QTableWidgetItem: ...
    def setHorizontalHeaderItem(self, column: int, item: QTableWidgetItem) -> None: ...
    def horizontalHeaderItem(self, column: int) -> QTableWidgetItem: ...
    def takeVerticalHeaderItem(self, row: int) -> QTableWidgetItem: ...
    def setVerticalHeaderItem(self, row: int, item: QTableWidgetItem) -> None: ...
    def verticalHeaderItem(self, row: int) -> QTableWidgetItem: ...
    def takeItem(self, row: int, column: int) -> QTableWidgetItem: ...
    def setItem(self, row: int, column: int, item: QTableWidgetItem) -> None: ...
    def item(self, row: int, column: int) -> QTableWidgetItem: ...
    def column(self, item: QTableWidgetItem) -> int: ...
    def row(self, item: QTableWidgetItem) -> int: ...
    def columnCount(self) -> int: ...
    def setColumnCount(self, columns: int) -> None: ...
    def rowCount(self) -> int: ...
    def setRowCount(self, rows: int) -> None: ...


class QTabWidget(QWidget):

    class TabShape(int): ...
    Rounded = ... # type: 'QTabWidget.TabShape'
    Triangular = ... # type: 'QTabWidget.TabShape'

    class TabPosition(int): ...
    North = ... # type: 'QTabWidget.TabPosition'
    South = ... # type: 'QTabWidget.TabPosition'
    West = ... # type: 'QTabWidget.TabPosition'
    East = ... # type: 'QTabWidget.TabPosition'

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...

    def heightForWidth(self, width: int) -> int: ...
    def tabCloseRequested(self, index: int) -> None: ...
    def setDocumentMode(self, set: bool) -> None: ...
    def documentMode(self) -> bool: ...
    def setMovable(self, movable: bool) -> None: ...
    def isMovable(self) -> bool: ...
    def setTabsClosable(self, closeable: bool) -> None: ...
    def tabsClosable(self) -> bool: ...
    def setUsesScrollButtons(self, useButtons: bool) -> None: ...
    def usesScrollButtons(self) -> bool: ...
    def setIconSize(self, size: QtCore.QSize) -> None: ...
    def iconSize(self) -> QtCore.QSize: ...
    def setElideMode(self, a0: QtCore.Qt.TextElideMode) -> None: ...
    def elideMode(self) -> QtCore.Qt.TextElideMode: ...
    def changeEvent(self, a0: QtCore.QEvent) -> None: ...
    def tabBar(self) -> QTabBar: ...
    def setTabBar(self, a0: QTabBar) -> None: ...
    def paintEvent(self, a0: QPaintEvent) -> None: ...
    def keyPressEvent(self, a0: QKeyEvent) -> None: ...
    def resizeEvent(self, a0: QResizeEvent) -> None: ...
    def showEvent(self, a0: QShowEvent) -> None: ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    def tabRemoved(self, index: int) -> None: ...
    def tabInserted(self, index: int) -> None: ...
    def initStyleOption(self, option: QStyleOptionTabWidgetFrame) -> None: ...
    def currentChanged(self, index: int) -> None: ...
    def setCurrentWidget(self, widget: QWidget) -> None: ...
    def setCurrentIndex(self, index: int) -> None: ...
    def cornerWidget(self, corner: QtCore.Qt.Corner = ...) -> QWidget: ...
    def setCornerWidget(self, widget: QWidget, corner: QtCore.Qt.Corner = ...) -> None: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def setTabShape(self, s: 'QTabWidget.TabShape') -> None: ...
    def tabShape(self) -> 'QTabWidget.TabShape': ...
    def setTabPosition(self, a0: 'QTabWidget.TabPosition') -> None: ...
    def tabPosition(self) -> 'QTabWidget.TabPosition': ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def indexOf(self, widget: QWidget) -> int: ...
    def widget(self, index: int) -> QWidget: ...
    def currentWidget(self) -> QWidget: ...
    def currentIndex(self) -> int: ...
    def tabWhatsThis(self, index: int) -> str: ...
    def setTabWhatsThis(self, index: int, text: str) -> None: ...
    def tabToolTip(self, index: int) -> str: ...
    def setTabToolTip(self, index: int, tip: str) -> None: ...
    def setTabIcon(self, index: int, icon: QIcon) -> None: ...
    def tabIcon(self, index: int) -> QIcon: ...
    def setTabText(self, index: int, a1: str) -> None: ...
    def tabText(self, index: int) -> str: ...
    def setTabEnabled(self, index: int, a1: bool) -> None: ...
    def isTabEnabled(self, index: int) -> bool: ...
    def removeTab(self, index: int) -> None: ...
    @typing.overload
    def insertTab(self, index: int, widget: QWidget, a2: str) -> int: ...
    @typing.overload
    def insertTab(self, index: int, widget: QWidget, icon: QIcon, label: str) -> int: ...
    @typing.overload
    def addTab(self, widget: QWidget, a1: str) -> int: ...
    @typing.overload
    def addTab(self, widget: QWidget, icon: QIcon, label: str) -> int: ...
    def clear(self) -> None: ...


class QTextEdit(QAbstractScrollArea):

    class AutoFormattingFlag(int): ...
    AutoNone = ... # type: 'QTextEdit.AutoFormattingFlag'
    AutoBulletList = ... # type: 'QTextEdit.AutoFormattingFlag'
    AutoAll = ... # type: 'QTextEdit.AutoFormattingFlag'

    class LineWrapMode(int): ...
    NoWrap = ... # type: 'QTextEdit.LineWrapMode'
    WidgetWidth = ... # type: 'QTextEdit.LineWrapMode'
    FixedPixelWidth = ... # type: 'QTextEdit.LineWrapMode'
    FixedColumnWidth = ... # type: 'QTextEdit.LineWrapMode'

    class ExtraSelection(sip.simplewrapper):

        cursor = ... # type: 'QTextCursor'
        format = ... # type: 'QTextCharFormat'

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QTextEdit.ExtraSelection') -> None: ...

    class AutoFormatting(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QTextEdit.AutoFormatting', 'QTextEdit.AutoFormattingFlag']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QTextEdit.AutoFormatting') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QTextEdit.AutoFormatting': ...
        def __int__(self) -> int: ...

    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str, parent: typing.Optional[QWidget] = ...) -> None: ...

    def setTextBackgroundColor(self, c: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def textBackgroundColor(self) -> QColor: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def inputMethodQuery(self, property: QtCore.Qt.InputMethodQuery) -> typing.Any: ...
    def inputMethodEvent(self, a0: QInputMethodEvent) -> None: ...
    def insertFromMimeData(self, source: QtCore.QMimeData) -> None: ...
    def canInsertFromMimeData(self, source: QtCore.QMimeData) -> bool: ...
    def createMimeDataFromSelection(self) -> QtCore.QMimeData: ...
    def wheelEvent(self, e: QWheelEvent) -> None: ...
    def changeEvent(self, e: QtCore.QEvent) -> None: ...
    def showEvent(self, a0: QShowEvent) -> None: ...
    def focusOutEvent(self, e: QFocusEvent) -> None: ...
    def focusInEvent(self, e: QFocusEvent) -> None: ...
    def dropEvent(self, e: QDropEvent) -> None: ...
    def dragMoveEvent(self, e: QDragMoveEvent) -> None: ...
    def dragLeaveEvent(self, e: QDragLeaveEvent) -> None: ...
    def dragEnterEvent(self, e: QDragEnterEvent) -> None: ...
    def contextMenuEvent(self, e: QContextMenuEvent) -> None: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def mouseDoubleClickEvent(self, e: QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, e: QMouseEvent) -> None: ...
    def mouseMoveEvent(self, e: QMouseEvent) -> None: ...
    def mousePressEvent(self, e: QMouseEvent) -> None: ...
    def paintEvent(self, e: QPaintEvent) -> None: ...
    def resizeEvent(self, a0: QResizeEvent) -> None: ...
    def keyReleaseEvent(self, e: QKeyEvent) -> None: ...
    def keyPressEvent(self, e: QKeyEvent) -> None: ...
    def timerEvent(self, e: QtCore.QTimerEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def cursorPositionChanged(self) -> None: ...
    def selectionChanged(self) -> None: ...
    def copyAvailable(self, b: bool) -> None: ...
    def currentCharFormatChanged(self, format: 'QTextCharFormat') -> None: ...
    def redoAvailable(self, b: bool) -> None: ...
    def undoAvailable(self, b: bool) -> None: ...
    def textChanged(self) -> None: ...
    def zoomOut(self, range: int = ...) -> None: ...
    def zoomIn(self, range: int = ...) -> None: ...
    def undo(self) -> None: ...
    def redo(self) -> None: ...
    def scrollToAnchor(self, name: str) -> None: ...
    def insertHtml(self, text: str) -> None: ...
    def insertPlainText(self, text: str) -> None: ...
    def selectAll(self) -> None: ...
    def clear(self) -> None: ...
    def paste(self) -> None: ...
    def copy(self) -> None: ...
    def cut(self) -> None: ...
    def setHtml(self, text: str) -> None: ...
    def setPlainText(self, text: str) -> None: ...
    def setAlignment(self, a: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> None: ...
    def setCurrentFont(self, f: QFont) -> None: ...
    def setTextColor(self, c: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def setText(self, text: str) -> None: ...
    def setFontItalic(self, b: bool) -> None: ...
    def setFontUnderline(self, b: bool) -> None: ...
    def setFontWeight(self, w: int) -> None: ...
    def setFontFamily(self, fontFamily: str) -> None: ...
    def setFontPointSize(self, s: float) -> None: ...
    def print(self, printer: QPrinter) -> None: ...
    def print_(self, printer: QPrinter) -> None: ...
    def moveCursor(self, operation: 'QTextCursor.MoveOperation', mode: 'QTextCursor.MoveMode' = ...) -> None: ...
    def canPaste(self) -> bool: ...
    def extraSelections(self) -> typing.List['QTextEdit.ExtraSelection']: ...
    def setExtraSelections(self, selections: typing.Sequence['QTextEdit.ExtraSelection']) -> None: ...
    def cursorWidth(self) -> int: ...
    def setCursorWidth(self, width: int) -> None: ...
    def textInteractionFlags(self) -> QtCore.Qt.TextInteractionFlags: ...
    def setTextInteractionFlags(self, flags: typing.Union[QtCore.Qt.TextInteractionFlags, QtCore.Qt.TextInteractionFlag]) -> None: ...
    def setAcceptRichText(self, accept: bool) -> None: ...
    def acceptRichText(self) -> bool: ...
    def setTabStopWidth(self, width: int) -> None: ...
    def tabStopWidth(self) -> int: ...
    def setOverwriteMode(self, overwrite: bool) -> None: ...
    def overwriteMode(self) -> bool: ...
    def anchorAt(self, pos: QtCore.QPoint) -> str: ...
    @typing.overload
    def cursorRect(self, cursor: 'QTextCursor') -> QtCore.QRect: ...
    @typing.overload
    def cursorRect(self) -> QtCore.QRect: ...
    def cursorForPosition(self, pos: QtCore.QPoint) -> 'QTextCursor': ...
    @typing.overload
    def createStandardContextMenu(self) -> QMenu: ...
    @typing.overload
    def createStandardContextMenu(self, position: QtCore.QPoint) -> QMenu: ...
    def loadResource(self, type: int, name: QtCore.QUrl) -> typing.Any: ...
    def ensureCursorVisible(self) -> None: ...
    def append(self, text: str) -> None: ...
    def toHtml(self) -> str: ...
    def toPlainText(self) -> str: ...
    def find(self, exp: str, options: 'QTextDocument.FindFlags' = ...) -> bool: ...
    def setWordWrapMode(self, policy: 'QTextOption.WrapMode') -> None: ...
    def wordWrapMode(self) -> 'QTextOption.WrapMode': ...
    def setLineWrapColumnOrWidth(self, w: int) -> None: ...
    def lineWrapColumnOrWidth(self) -> int: ...
    def setLineWrapMode(self, mode: 'QTextEdit.LineWrapMode') -> None: ...
    def lineWrapMode(self) -> 'QTextEdit.LineWrapMode': ...
    def setUndoRedoEnabled(self, enable: bool) -> None: ...
    def isUndoRedoEnabled(self) -> bool: ...
    def documentTitle(self) -> str: ...
    def setDocumentTitle(self, title: str) -> None: ...
    def setTabChangesFocus(self, b: bool) -> None: ...
    def tabChangesFocus(self) -> bool: ...
    def setAutoFormatting(self, features: 'QTextEdit.AutoFormatting') -> None: ...
    def autoFormatting(self) -> 'QTextEdit.AutoFormatting': ...
    def currentCharFormat(self) -> 'QTextCharFormat': ...
    def setCurrentCharFormat(self, format: 'QTextCharFormat') -> None: ...
    def mergeCurrentCharFormat(self, modifier: 'QTextCharFormat') -> None: ...
    def alignment(self) -> QtCore.Qt.Alignment: ...
    def currentFont(self) -> QFont: ...
    def textColor(self) -> QColor: ...
    def fontItalic(self) -> bool: ...
    def fontUnderline(self) -> bool: ...
    def fontWeight(self) -> int: ...
    def fontFamily(self) -> str: ...
    def fontPointSize(self) -> float: ...
    def setReadOnly(self, ro: bool) -> None: ...
    def isReadOnly(self) -> bool: ...
    def textCursor(self) -> 'QTextCursor': ...
    def setTextCursor(self, cursor: 'QTextCursor') -> None: ...
    def document(self) -> 'QTextDocument': ...
    def setDocument(self, document: 'QTextDocument') -> None: ...


class QTextBrowser(QTextEdit):

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...

    def historyChanged(self) -> None: ...
    def forwardHistoryCount(self) -> int: ...
    def backwardHistoryCount(self) -> int: ...
    def historyUrl(self, a0: int) -> QtCore.QUrl: ...
    def historyTitle(self, a0: int) -> str: ...
    def setOpenLinks(self, open: bool) -> None: ...
    def openLinks(self) -> bool: ...
    def setOpenExternalLinks(self, open: bool) -> None: ...
    def openExternalLinks(self) -> bool: ...
    def clearHistory(self) -> None: ...
    def isForwardAvailable(self) -> bool: ...
    def isBackwardAvailable(self) -> bool: ...
    def paintEvent(self, e: QPaintEvent) -> None: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOutEvent(self, ev: QFocusEvent) -> None: ...
    def mouseReleaseEvent(self, ev: QMouseEvent) -> None: ...
    def mousePressEvent(self, ev: QMouseEvent) -> None: ...
    def mouseMoveEvent(self, ev: QMouseEvent) -> None: ...
    def keyPressEvent(self, ev: QKeyEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def anchorClicked(self, a0: QtCore.QUrl) -> None: ...
    @typing.overload
    def highlighted(self, a0: QtCore.QUrl) -> None: ...
    @typing.overload
    def highlighted(self, a0: str) -> None: ...
    def sourceChanged(self, a0: QtCore.QUrl) -> None: ...
    def forwardAvailable(self, a0: bool) -> None: ...
    def backwardAvailable(self, a0: bool) -> None: ...
    def reload(self) -> None: ...
    def home(self) -> None: ...
    def forward(self) -> None: ...
    def backward(self) -> None: ...
    def setSource(self, name: QtCore.QUrl) -> None: ...
    def loadResource(self, type: int, name: QtCore.QUrl) -> typing.Any: ...
    def setSearchPaths(self, paths: typing.Sequence[str]) -> None: ...
    def searchPaths(self) -> typing.List[str]: ...
    def source(self) -> QtCore.QUrl: ...


class QTextCursor(sip.simplewrapper):

    class SelectionType(int): ...
    WordUnderCursor = ... # type: 'QTextCursor.SelectionType'
    LineUnderCursor = ... # type: 'QTextCursor.SelectionType'
    BlockUnderCursor = ... # type: 'QTextCursor.SelectionType'
    Document = ... # type: 'QTextCursor.SelectionType'

    class MoveOperation(int): ...
    NoMove = ... # type: 'QTextCursor.MoveOperation'
    Start = ... # type: 'QTextCursor.MoveOperation'
    Up = ... # type: 'QTextCursor.MoveOperation'
    StartOfLine = ... # type: 'QTextCursor.MoveOperation'
    StartOfBlock = ... # type: 'QTextCursor.MoveOperation'
    StartOfWord = ... # type: 'QTextCursor.MoveOperation'
    PreviousBlock = ... # type: 'QTextCursor.MoveOperation'
    PreviousCharacter = ... # type: 'QTextCursor.MoveOperation'
    PreviousWord = ... # type: 'QTextCursor.MoveOperation'
    Left = ... # type: 'QTextCursor.MoveOperation'
    WordLeft = ... # type: 'QTextCursor.MoveOperation'
    End = ... # type: 'QTextCursor.MoveOperation'
    Down = ... # type: 'QTextCursor.MoveOperation'
    EndOfLine = ... # type: 'QTextCursor.MoveOperation'
    EndOfWord = ... # type: 'QTextCursor.MoveOperation'
    EndOfBlock = ... # type: 'QTextCursor.MoveOperation'
    NextBlock = ... # type: 'QTextCursor.MoveOperation'
    NextCharacter = ... # type: 'QTextCursor.MoveOperation'
    NextWord = ... # type: 'QTextCursor.MoveOperation'
    Right = ... # type: 'QTextCursor.MoveOperation'
    WordRight = ... # type: 'QTextCursor.MoveOperation'
    NextCell = ... # type: 'QTextCursor.MoveOperation'
    PreviousCell = ... # type: 'QTextCursor.MoveOperation'
    NextRow = ... # type: 'QTextCursor.MoveOperation'
    PreviousRow = ... # type: 'QTextCursor.MoveOperation'

    class MoveMode(int): ...
    MoveAnchor = ... # type: 'QTextCursor.MoveMode'
    KeepAnchor = ... # type: 'QTextCursor.MoveMode'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, document: 'QTextDocument') -> None: ...
    @typing.overload
    def __init__(self, frame: 'QTextFrame') -> None: ...
    @typing.overload
    def __init__(self, block: 'QTextBlock') -> None: ...
    @typing.overload
    def __init__(self, cursor: 'QTextCursor') -> None: ...

    def keepPositionOnInsert(self) -> bool: ...
    def setKeepPositionOnInsert(self, b: bool) -> None: ...
    def verticalMovementX(self) -> int: ...
    def setVerticalMovementX(self, x: int) -> None: ...
    def positionInBlock(self) -> int: ...
    def document(self) -> 'QTextDocument': ...
    def setVisualNavigation(self, b: bool) -> None: ...
    def visualNavigation(self) -> bool: ...
    def isCopyOf(self, other: 'QTextCursor') -> bool: ...
    def columnNumber(self) -> int: ...
    def blockNumber(self) -> int: ...
    def endEditBlock(self) -> None: ...
    def joinPreviousEditBlock(self) -> None: ...
    def beginEditBlock(self) -> None: ...
    @typing.overload
    def insertImage(self, format: 'QTextImageFormat') -> None: ...
    @typing.overload
    def insertImage(self, format: 'QTextImageFormat', alignment: 'QTextFrameFormat.Position') -> None: ...
    @typing.overload
    def insertImage(self, name: str) -> None: ...
    @typing.overload
    def insertImage(self, image: QImage, name: str = ...) -> None: ...
    def insertHtml(self, html: str) -> None: ...
    def insertFragment(self, fragment: 'QTextDocumentFragment') -> None: ...
    def currentFrame(self) -> 'QTextFrame': ...
    def insertFrame(self, format: 'QTextFrameFormat') -> 'QTextFrame': ...
    def currentTable(self) -> 'QTextTable': ...
    @typing.overload
    def insertTable(self, rows: int, cols: int, format: 'QTextTableFormat') -> 'QTextTable': ...
    @typing.overload
    def insertTable(self, rows: int, cols: int) -> 'QTextTable': ...
    def currentList(self) -> 'QTextList': ...
    @typing.overload
    def createList(self, format: 'QTextListFormat') -> 'QTextList': ...
    @typing.overload
    def createList(self, style: 'QTextListFormat.Style') -> 'QTextList': ...
    @typing.overload
    def insertList(self, format: 'QTextListFormat') -> 'QTextList': ...
    @typing.overload
    def insertList(self, style: 'QTextListFormat.Style') -> 'QTextList': ...
    @typing.overload
    def insertBlock(self) -> None: ...
    @typing.overload
    def insertBlock(self, format: 'QTextBlockFormat') -> None: ...
    @typing.overload
    def insertBlock(self, format: 'QTextBlockFormat', charFormat: 'QTextCharFormat') -> None: ...
    def atEnd(self) -> bool: ...
    def atStart(self) -> bool: ...
    def atBlockEnd(self) -> bool: ...
    def atBlockStart(self) -> bool: ...
    def mergeBlockCharFormat(self, modifier: 'QTextCharFormat') -> None: ...
    def setBlockCharFormat(self, format: 'QTextCharFormat') -> None: ...
    def blockCharFormat(self) -> 'QTextCharFormat': ...
    def mergeBlockFormat(self, modifier: 'QTextBlockFormat') -> None: ...
    def setBlockFormat(self, format: 'QTextBlockFormat') -> None: ...
    def blockFormat(self) -> 'QTextBlockFormat': ...
    def mergeCharFormat(self, modifier: 'QTextCharFormat') -> None: ...
    def setCharFormat(self, format: 'QTextCharFormat') -> None: ...
    def charFormat(self) -> 'QTextCharFormat': ...
    def block(self) -> 'QTextBlock': ...
    def selectedTableCells(self) -> typing.Tuple[int, int, int, int]: ...
    def selection(self) -> 'QTextDocumentFragment': ...
    def selectedText(self) -> str: ...
    def selectionEnd(self) -> int: ...
    def selectionStart(self) -> int: ...
    def clearSelection(self) -> None: ...
    def removeSelectedText(self) -> None: ...
    def hasComplexSelection(self) -> bool: ...
    def hasSelection(self) -> bool: ...
    def select(self, selection: 'QTextCursor.SelectionType') -> None: ...
    def deletePreviousChar(self) -> None: ...
    def deleteChar(self) -> None: ...
    def movePosition(self, op: 'QTextCursor.MoveOperation', mode: 'QTextCursor.MoveMode' = ..., n: int = ...) -> bool: ...
    @typing.overload
    def insertText(self, text: str) -> None: ...
    @typing.overload
    def insertText(self, text: str, format: 'QTextCharFormat') -> None: ...
    def anchor(self) -> int: ...
    def position(self) -> int: ...
    def setPosition(self, pos: int, mode: 'QTextCursor.MoveMode' = ...) -> None: ...
    def isNull(self) -> bool: ...


class Qt(sip.simplewrapper):

    class WhiteSpaceMode(int): ...
    WhiteSpaceNormal = ... # type: 'Qt.WhiteSpaceMode'
    WhiteSpacePre = ... # type: 'Qt.WhiteSpaceMode'
    WhiteSpaceNoWrap = ... # type: 'Qt.WhiteSpaceMode'
    WhiteSpaceModeUndefined = ... # type: 'Qt.WhiteSpaceMode'

    class HitTestAccuracy(int): ...
    ExactHit = ... # type: 'Qt.HitTestAccuracy'
    FuzzyHit = ... # type: 'Qt.HitTestAccuracy'

    def convertFromPlainText(self, plain: str, mode: 'Qt.WhiteSpaceMode' = ...) -> str: ...
    def escape(self, plain: str) -> str: ...
    def mightBeRichText(self, a0: str) -> bool: ...


class QTextDocument(QtCore.QObject):

    class Stacks(int): ...
    UndoStack = ... # type: 'QTextDocument.Stacks'
    RedoStack = ... # type: 'QTextDocument.Stacks'
    UndoAndRedoStacks = ... # type: 'QTextDocument.Stacks'

    class ResourceType(int): ...
    HtmlResource = ... # type: 'QTextDocument.ResourceType'
    ImageResource = ... # type: 'QTextDocument.ResourceType'
    StyleSheetResource = ... # type: 'QTextDocument.ResourceType'
    UserResource = ... # type: 'QTextDocument.ResourceType'

    class FindFlag(int): ...
    FindBackward = ... # type: 'QTextDocument.FindFlag'
    FindCaseSensitively = ... # type: 'QTextDocument.FindFlag'
    FindWholeWords = ... # type: 'QTextDocument.FindFlag'

    class MetaInformation(int): ...
    DocumentTitle = ... # type: 'QTextDocument.MetaInformation'
    DocumentUrl = ... # type: 'QTextDocument.MetaInformation'

    class FindFlags(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QTextDocument.FindFlags', 'QTextDocument.FindFlag']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QTextDocument.FindFlags') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QTextDocument.FindFlags': ...
        def __int__(self) -> int: ...

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def setDefaultCursorMoveStyle(self, style: QtCore.Qt.CursorMoveStyle) -> None: ...
    def defaultCursorMoveStyle(self) -> QtCore.Qt.CursorMoveStyle: ...
    def clearUndoRedoStacks(self, stacks: 'QTextDocument.Stacks' = ...) -> None: ...
    def availableRedoSteps(self) -> int: ...
    def availableUndoSteps(self) -> int: ...
    def characterCount(self) -> int: ...
    def lineCount(self) -> int: ...
    def setDocumentMargin(self, margin: float) -> None: ...
    def documentMargin(self) -> float: ...
    def characterAt(self, pos: int) -> str: ...
    def documentLayoutChanged(self) -> None: ...
    def undoCommandAdded(self) -> None: ...
    def setIndentWidth(self, width: float) -> None: ...
    def indentWidth(self) -> float: ...
    def lastBlock(self) -> 'QTextBlock': ...
    def firstBlock(self) -> 'QTextBlock': ...
    def findBlockByLineNumber(self, blockNumber: int) -> 'QTextBlock': ...
    def findBlockByNumber(self, blockNumber: int) -> 'QTextBlock': ...
    def revision(self) -> int: ...
    def setDefaultTextOption(self, option: 'QTextOption') -> None: ...
    def defaultTextOption(self) -> 'QTextOption': ...
    def setMaximumBlockCount(self, maximum: int) -> None: ...
    def maximumBlockCount(self) -> int: ...
    def defaultStyleSheet(self) -> str: ...
    def setDefaultStyleSheet(self, sheet: str) -> None: ...
    def blockCount(self) -> int: ...
    def size(self) -> QtCore.QSizeF: ...
    def adjustSize(self) -> None: ...
    def idealWidth(self) -> float: ...
    def textWidth(self) -> float: ...
    def setTextWidth(self, width: float) -> None: ...
    def drawContents(self, p: QPainter, rect: QtCore.QRectF = ...) -> None: ...
    def loadResource(self, type: int, name: QtCore.QUrl) -> typing.Any: ...
    def createObject(self, f: 'QTextFormat') -> 'QTextObject': ...
    def setModified(self, on: bool = ...) -> None: ...
    @typing.overload
    def redo(self) -> None: ...
    @typing.overload
    def redo(self, cursor: QTextCursor) -> None: ...
    @typing.overload
    def undo(self) -> None: ...
    @typing.overload
    def undo(self, cursor: QTextCursor) -> None: ...
    def undoAvailable(self, a0: bool) -> None: ...
    def redoAvailable(self, a0: bool) -> None: ...
    def modificationChanged(self, m: bool) -> None: ...
    def cursorPositionChanged(self, cursor: QTextCursor) -> None: ...
    def contentsChanged(self) -> None: ...
    def contentsChange(self, from_: int, charsRemoves: int, charsAdded: int) -> None: ...
    def blockCountChanged(self, newBlockCount: int) -> None: ...
    def useDesignMetrics(self) -> bool: ...
    def setUseDesignMetrics(self, b: bool) -> None: ...
    def markContentsDirty(self, from_: int, length: int) -> None: ...
    def allFormats(self) -> typing.List['QTextFormat']: ...
    def addResource(self, type: int, name: QtCore.QUrl, resource: typing.Any) -> None: ...
    def resource(self, type: int, name: QtCore.QUrl) -> typing.Any: ...
    def print(self, printer: QPrinter) -> None: ...
    def print_(self, printer: QPrinter) -> None: ...
    def isModified(self) -> bool: ...
    def pageCount(self) -> int: ...
    def defaultFont(self) -> QFont: ...
    def setDefaultFont(self, font: QFont) -> None: ...
    def pageSize(self) -> QtCore.QSizeF: ...
    def setPageSize(self, size: QtCore.QSizeF) -> None: ...
    def end(self) -> 'QTextBlock': ...
    def begin(self) -> 'QTextBlock': ...
    def findBlock(self, pos: int) -> 'QTextBlock': ...
    def objectForFormat(self, a0: 'QTextFormat') -> 'QTextObject': ...
    def object(self, objectIndex: int) -> 'QTextObject': ...
    def rootFrame(self) -> 'QTextFrame': ...
    @typing.overload
    def find(self, subString: str, position: int = ..., options: 'QTextDocument.FindFlags' = ...) -> QTextCursor: ...
    @typing.overload
    def find(self, expr: QtCore.QRegExp, position: int = ..., options: 'QTextDocument.FindFlags' = ...) -> QTextCursor: ...
    @typing.overload
    def find(self, subString: str, cursor: QTextCursor, options: 'QTextDocument.FindFlags' = ...) -> QTextCursor: ...
    @typing.overload
    def find(self, expr: QtCore.QRegExp, cursor: QTextCursor, options: 'QTextDocument.FindFlags' = ...) -> QTextCursor: ...
    def setPlainText(self, text: str) -> None: ...
    def toPlainText(self) -> str: ...
    def setHtml(self, html: str) -> None: ...
    def toHtml(self, encoding: typing.Union[QtCore.QByteArray, bytes, bytearray] = ...) -> str: ...
    def metaInformation(self, info: 'QTextDocument.MetaInformation') -> str: ...
    def setMetaInformation(self, info: 'QTextDocument.MetaInformation', a1: str) -> None: ...
    def documentLayout(self) -> QAbstractTextDocumentLayout: ...
    def setDocumentLayout(self, layout: QAbstractTextDocumentLayout) -> None: ...
    def isRedoAvailable(self) -> bool: ...
    def isUndoAvailable(self) -> bool: ...
    def isUndoRedoEnabled(self) -> bool: ...
    def setUndoRedoEnabled(self, enable: bool) -> None: ...
    def clear(self) -> None: ...
    def isEmpty(self) -> bool: ...
    def clone(self, parent: typing.Optional[QtCore.QObject] = ...) -> 'QTextDocument': ...


class QTextDocumentFragment(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, document: QTextDocument) -> None: ...
    @typing.overload
    def __init__(self, range: QTextCursor) -> None: ...
    @typing.overload
    def __init__(self, rhs: 'QTextDocumentFragment') -> None: ...

    @typing.overload
    @staticmethod
    def fromHtml(html: str) -> 'QTextDocumentFragment': ...
    @typing.overload
    @staticmethod
    def fromHtml(html: str, resourceProvider: QTextDocument) -> 'QTextDocumentFragment': ...
    @staticmethod
    def fromPlainText(plainText: str) -> 'QTextDocumentFragment': ...
    @typing.overload
    def toHtml(self) -> str: ...
    @typing.overload
    def toHtml(self, encoding: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> str: ...
    def toPlainText(self) -> str: ...
    def isEmpty(self) -> bool: ...


class QTextDocumentWriter(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, device: QtCore.QIODevice, format: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    @typing.overload
    def __init__(self, fileName: str, format: typing.Union[QtCore.QByteArray, bytes, bytearray] = ...) -> None: ...

    @staticmethod
    def supportedDocumentFormats() -> typing.List[QtCore.QByteArray]: ...
    def codec(self) -> QtCore.QTextCodec: ...
    def setCodec(self, codec: QtCore.QTextCodec) -> None: ...
    @typing.overload
    def write(self, document: QTextDocument) -> bool: ...
    @typing.overload
    def write(self, fragment: QTextDocumentFragment) -> bool: ...
    def fileName(self) -> str: ...
    def setFileName(self, fileName: str) -> None: ...
    def device(self) -> QtCore.QIODevice: ...
    def setDevice(self, device: QtCore.QIODevice) -> None: ...
    def format(self) -> QtCore.QByteArray: ...
    def setFormat(self, format: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...


class QTextLength(sip.simplewrapper):

    class Type(int): ...
    VariableLength = ... # type: 'QTextLength.Type'
    FixedLength = ... # type: 'QTextLength.Type'
    PercentageLength = ... # type: 'QTextLength.Type'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, atype: 'QTextLength.Type', avalue: float) -> None: ...
    @typing.overload
    def __init__(self, variant: typing.Any) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QTextLength') -> None: ...

    def rawValue(self) -> float: ...
    def value(self, maximumLength: float) -> float: ...
    def type(self) -> 'QTextLength.Type': ...


class QTextFormat(sip.simplewrapper):

    class Property(int): ...
    ObjectIndex = ... # type: 'QTextFormat.Property'
    CssFloat = ... # type: 'QTextFormat.Property'
    LayoutDirection = ... # type: 'QTextFormat.Property'
    OutlinePen = ... # type: 'QTextFormat.Property'
    BackgroundBrush = ... # type: 'QTextFormat.Property'
    ForegroundBrush = ... # type: 'QTextFormat.Property'
    BlockAlignment = ... # type: 'QTextFormat.Property'
    BlockTopMargin = ... # type: 'QTextFormat.Property'
    BlockBottomMargin = ... # type: 'QTextFormat.Property'
    BlockLeftMargin = ... # type: 'QTextFormat.Property'
    BlockRightMargin = ... # type: 'QTextFormat.Property'
    TextIndent = ... # type: 'QTextFormat.Property'
    BlockIndent = ... # type: 'QTextFormat.Property'
    BlockNonBreakableLines = ... # type: 'QTextFormat.Property'
    BlockTrailingHorizontalRulerWidth = ... # type: 'QTextFormat.Property'
    FontFamily = ... # type: 'QTextFormat.Property'
    FontPointSize = ... # type: 'QTextFormat.Property'
    FontSizeAdjustment = ... # type: 'QTextFormat.Property'
    FontSizeIncrement = ... # type: 'QTextFormat.Property'
    FontWeight = ... # type: 'QTextFormat.Property'
    FontItalic = ... # type: 'QTextFormat.Property'
    FontUnderline = ... # type: 'QTextFormat.Property'
    FontOverline = ... # type: 'QTextFormat.Property'
    FontStrikeOut = ... # type: 'QTextFormat.Property'
    FontFixedPitch = ... # type: 'QTextFormat.Property'
    FontPixelSize = ... # type: 'QTextFormat.Property'
    TextUnderlineColor = ... # type: 'QTextFormat.Property'
    TextVerticalAlignment = ... # type: 'QTextFormat.Property'
    TextOutline = ... # type: 'QTextFormat.Property'
    IsAnchor = ... # type: 'QTextFormat.Property'
    AnchorHref = ... # type: 'QTextFormat.Property'
    AnchorName = ... # type: 'QTextFormat.Property'
    ObjectType = ... # type: 'QTextFormat.Property'
    ListStyle = ... # type: 'QTextFormat.Property'
    ListIndent = ... # type: 'QTextFormat.Property'
    FrameBorder = ... # type: 'QTextFormat.Property'
    FrameMargin = ... # type: 'QTextFormat.Property'
    FramePadding = ... # type: 'QTextFormat.Property'
    FrameWidth = ... # type: 'QTextFormat.Property'
    FrameHeight = ... # type: 'QTextFormat.Property'
    TableColumns = ... # type: 'QTextFormat.Property'
    TableColumnWidthConstraints = ... # type: 'QTextFormat.Property'
    TableCellSpacing = ... # type: 'QTextFormat.Property'
    TableCellPadding = ... # type: 'QTextFormat.Property'
    TableCellRowSpan = ... # type: 'QTextFormat.Property'
    TableCellColumnSpan = ... # type: 'QTextFormat.Property'
    ImageName = ... # type: 'QTextFormat.Property'
    ImageWidth = ... # type: 'QTextFormat.Property'
    ImageHeight = ... # type: 'QTextFormat.Property'
    TextUnderlineStyle = ... # type: 'QTextFormat.Property'
    TableHeaderRowCount = ... # type: 'QTextFormat.Property'
    FullWidthSelection = ... # type: 'QTextFormat.Property'
    PageBreakPolicy = ... # type: 'QTextFormat.Property'
    TextToolTip = ... # type: 'QTextFormat.Property'
    FrameTopMargin = ... # type: 'QTextFormat.Property'
    FrameBottomMargin = ... # type: 'QTextFormat.Property'
    FrameLeftMargin = ... # type: 'QTextFormat.Property'
    FrameRightMargin = ... # type: 'QTextFormat.Property'
    FrameBorderBrush = ... # type: 'QTextFormat.Property'
    FrameBorderStyle = ... # type: 'QTextFormat.Property'
    BackgroundImageUrl = ... # type: 'QTextFormat.Property'
    TabPositions = ... # type: 'QTextFormat.Property'
    FirstFontProperty = ... # type: 'QTextFormat.Property'
    FontCapitalization = ... # type: 'QTextFormat.Property'
    FontLetterSpacing = ... # type: 'QTextFormat.Property'
    FontWordSpacing = ... # type: 'QTextFormat.Property'
    LastFontProperty = ... # type: 'QTextFormat.Property'
    TableCellTopPadding = ... # type: 'QTextFormat.Property'
    TableCellBottomPadding = ... # type: 'QTextFormat.Property'
    TableCellLeftPadding = ... # type: 'QTextFormat.Property'
    TableCellRightPadding = ... # type: 'QTextFormat.Property'
    FontStyleHint = ... # type: 'QTextFormat.Property'
    FontStyleStrategy = ... # type: 'QTextFormat.Property'
    FontKerning = ... # type: 'QTextFormat.Property'
    LineHeight = ... # type: 'QTextFormat.Property'
    LineHeightType = ... # type: 'QTextFormat.Property'
    FontHintingPreference = ... # type: 'QTextFormat.Property'
    ListNumberPrefix = ... # type: 'QTextFormat.Property'
    ListNumberSuffix = ... # type: 'QTextFormat.Property'
    UserProperty = ... # type: 'QTextFormat.Property'

    class PageBreakFlag(int): ...
    PageBreak_Auto = ... # type: 'QTextFormat.PageBreakFlag'
    PageBreak_AlwaysBefore = ... # type: 'QTextFormat.PageBreakFlag'
    PageBreak_AlwaysAfter = ... # type: 'QTextFormat.PageBreakFlag'

    class ObjectTypes(int): ...
    NoObject = ... # type: 'QTextFormat.ObjectTypes'
    ImageObject = ... # type: 'QTextFormat.ObjectTypes'
    TableObject = ... # type: 'QTextFormat.ObjectTypes'
    TableCellObject = ... # type: 'QTextFormat.ObjectTypes'
    UserObject = ... # type: 'QTextFormat.ObjectTypes'

    class FormatType(int): ...
    InvalidFormat = ... # type: 'QTextFormat.FormatType'
    BlockFormat = ... # type: 'QTextFormat.FormatType'
    CharFormat = ... # type: 'QTextFormat.FormatType'
    ListFormat = ... # type: 'QTextFormat.FormatType'
    TableFormat = ... # type: 'QTextFormat.FormatType'
    FrameFormat = ... # type: 'QTextFormat.FormatType'
    UserFormat = ... # type: 'QTextFormat.FormatType'

    class PageBreakFlags(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QTextFormat.PageBreakFlags', 'QTextFormat.PageBreakFlag']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QTextFormat.PageBreakFlags') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QTextFormat.PageBreakFlags': ...
        def __int__(self) -> int: ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, type: int) -> None: ...
    @typing.overload
    def __init__(self, rhs: 'QTextFormat') -> None: ...
    @typing.overload
    def __init__(self, variant: typing.Any) -> None: ...

    def toTableCellFormat(self) -> 'QTextTableCellFormat': ...
    def isTableCellFormat(self) -> bool: ...
    def propertyCount(self) -> int: ...
    def setObjectType(self, atype: int) -> None: ...
    def clearForeground(self) -> None: ...
    def foreground(self) -> QBrush: ...
    def setForeground(self, brush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def clearBackground(self) -> None: ...
    def background(self) -> QBrush: ...
    def setBackground(self, brush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def layoutDirection(self) -> QtCore.Qt.LayoutDirection: ...
    def setLayoutDirection(self, direction: QtCore.Qt.LayoutDirection) -> None: ...
    def toImageFormat(self) -> 'QTextImageFormat': ...
    def toFrameFormat(self) -> 'QTextFrameFormat': ...
    def toTableFormat(self) -> 'QTextTableFormat': ...
    def toListFormat(self) -> 'QTextListFormat': ...
    def toCharFormat(self) -> 'QTextCharFormat': ...
    def toBlockFormat(self) -> 'QTextBlockFormat': ...
    def isTableFormat(self) -> bool: ...
    def isImageFormat(self) -> bool: ...
    def isFrameFormat(self) -> bool: ...
    def isListFormat(self) -> bool: ...
    def isBlockFormat(self) -> bool: ...
    def isCharFormat(self) -> bool: ...
    def objectType(self) -> int: ...
    def properties(self) -> typing.Dict[int, typing.Any]: ...
    def lengthVectorProperty(self, propertyId: int) -> typing.List[QTextLength]: ...
    def lengthProperty(self, propertyId: int) -> QTextLength: ...
    def brushProperty(self, propertyId: int) -> QBrush: ...
    def penProperty(self, propertyId: int) -> QPen: ...
    def colorProperty(self, propertyId: int) -> QColor: ...
    def stringProperty(self, propertyId: int) -> str: ...
    def doubleProperty(self, propertyId: int) -> float: ...
    def intProperty(self, propertyId: int) -> int: ...
    def boolProperty(self, propertyId: int) -> bool: ...
    def hasProperty(self, propertyId: int) -> bool: ...
    def clearProperty(self, propertyId: int) -> None: ...
    @typing.overload
    def setProperty(self, propertyId: int, value: typing.Any) -> None: ...
    @typing.overload
    def setProperty(self, propertyId: int, lengths: typing.List[QTextLength]) -> None: ...
    def property(self, propertyId: int) -> typing.Any: ...
    def setObjectIndex(self, object: int) -> None: ...
    def objectIndex(self) -> int: ...
    def type(self) -> int: ...
    def isValid(self) -> bool: ...
    def merge(self, other: 'QTextFormat') -> None: ...


class QTextCharFormat(QTextFormat):

    class UnderlineStyle(int): ...
    NoUnderline = ... # type: 'QTextCharFormat.UnderlineStyle'
    SingleUnderline = ... # type: 'QTextCharFormat.UnderlineStyle'
    DashUnderline = ... # type: 'QTextCharFormat.UnderlineStyle'
    DotLine = ... # type: 'QTextCharFormat.UnderlineStyle'
    DashDotLine = ... # type: 'QTextCharFormat.UnderlineStyle'
    DashDotDotLine = ... # type: 'QTextCharFormat.UnderlineStyle'
    WaveUnderline = ... # type: 'QTextCharFormat.UnderlineStyle'
    SpellCheckUnderline = ... # type: 'QTextCharFormat.UnderlineStyle'

    class VerticalAlignment(int): ...
    AlignNormal = ... # type: 'QTextCharFormat.VerticalAlignment'
    AlignSuperScript = ... # type: 'QTextCharFormat.VerticalAlignment'
    AlignSubScript = ... # type: 'QTextCharFormat.VerticalAlignment'
    AlignMiddle = ... # type: 'QTextCharFormat.VerticalAlignment'
    AlignTop = ... # type: 'QTextCharFormat.VerticalAlignment'
    AlignBottom = ... # type: 'QTextCharFormat.VerticalAlignment'
    AlignBaseline = ... # type: 'QTextCharFormat.VerticalAlignment'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QTextCharFormat') -> None: ...

    def fontHintingPreference(self) -> QFont.HintingPreference: ...
    def setFontHintingPreference(self, hintingPreference: QFont.HintingPreference) -> None: ...
    def fontKerning(self) -> bool: ...
    def setFontKerning(self, enable: bool) -> None: ...
    def fontStyleStrategy(self) -> QFont.StyleStrategy: ...
    def fontStyleHint(self) -> QFont.StyleHint: ...
    def setFontStyleStrategy(self, strategy: QFont.StyleStrategy) -> None: ...
    def setFontStyleHint(self, hint: QFont.StyleHint, strategy: QFont.StyleStrategy = ...) -> None: ...
    def fontWordSpacing(self) -> float: ...
    def setFontWordSpacing(self, spacing: float) -> None: ...
    def fontLetterSpacing(self) -> float: ...
    def setFontLetterSpacing(self, spacing: float) -> None: ...
    def fontCapitalization(self) -> QFont.Capitalization: ...
    def setFontCapitalization(self, capitalization: QFont.Capitalization) -> None: ...
    def anchorNames(self) -> typing.List[str]: ...
    def setAnchorNames(self, names: typing.Sequence[str]) -> None: ...
    def toolTip(self) -> str: ...
    def setToolTip(self, tip: str) -> None: ...
    def underlineStyle(self) -> 'QTextCharFormat.UnderlineStyle': ...
    def setUnderlineStyle(self, style: 'QTextCharFormat.UnderlineStyle') -> None: ...
    def textOutline(self) -> QPen: ...
    def setTextOutline(self, pen: typing.Union[QPen, QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def setTableCellColumnSpan(self, atableCellColumnSpan: int) -> None: ...
    def setTableCellRowSpan(self, atableCellRowSpan: int) -> None: ...
    def tableCellColumnSpan(self) -> int: ...
    def tableCellRowSpan(self) -> int: ...
    def anchorName(self) -> str: ...
    def setAnchorName(self, name: str) -> None: ...
    def anchorHref(self) -> str: ...
    def setAnchorHref(self, value: str) -> None: ...
    def isAnchor(self) -> bool: ...
    def setAnchor(self, anchor: bool) -> None: ...
    def verticalAlignment(self) -> 'QTextCharFormat.VerticalAlignment': ...
    def setVerticalAlignment(self, alignment: 'QTextCharFormat.VerticalAlignment') -> None: ...
    def fontFixedPitch(self) -> bool: ...
    def setFontFixedPitch(self, fixedPitch: bool) -> None: ...
    def underlineColor(self) -> QColor: ...
    def setUnderlineColor(self, color: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def fontStrikeOut(self) -> bool: ...
    def setFontStrikeOut(self, strikeOut: bool) -> None: ...
    def fontOverline(self) -> bool: ...
    def setFontOverline(self, overline: bool) -> None: ...
    def fontUnderline(self) -> bool: ...
    def setFontUnderline(self, underline: bool) -> None: ...
    def fontItalic(self) -> bool: ...
    def setFontItalic(self, italic: bool) -> None: ...
    def fontWeight(self) -> int: ...
    def setFontWeight(self, weight: int) -> None: ...
    def fontPointSize(self) -> float: ...
    def setFontPointSize(self, size: float) -> None: ...
    def fontFamily(self) -> str: ...
    def setFontFamily(self, family: str) -> None: ...
    def font(self) -> QFont: ...
    def setFont(self, font: QFont) -> None: ...
    def isValid(self) -> bool: ...


class QTextBlockFormat(QTextFormat):

    class LineHeightTypes(int): ...
    SingleHeight = ... # type: 'QTextBlockFormat.LineHeightTypes'
    ProportionalHeight = ... # type: 'QTextBlockFormat.LineHeightTypes'
    FixedHeight = ... # type: 'QTextBlockFormat.LineHeightTypes'
    MinimumHeight = ... # type: 'QTextBlockFormat.LineHeightTypes'
    LineDistanceHeight = ... # type: 'QTextBlockFormat.LineHeightTypes'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QTextBlockFormat') -> None: ...

    def lineHeightType(self) -> int: ...
    @typing.overload
    def lineHeight(self, scriptLineHeight: float, scaling: float) -> float: ...
    @typing.overload
    def lineHeight(self) -> float: ...
    def setLineHeight(self, height: float, heightType: int) -> None: ...
    def tabPositions(self) -> typing.List['QTextOption.Tab']: ...
    def setTabPositions(self, tabs: typing.Sequence['QTextOption.Tab']) -> None: ...
    def pageBreakPolicy(self) -> QTextFormat.PageBreakFlags: ...
    def setPageBreakPolicy(self, flags: QTextFormat.PageBreakFlags) -> None: ...
    def setIndent(self, aindent: int) -> None: ...
    def setAlignment(self, aalignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> None: ...
    def nonBreakableLines(self) -> bool: ...
    def setNonBreakableLines(self, b: bool) -> None: ...
    def indent(self) -> int: ...
    def textIndent(self) -> float: ...
    def setTextIndent(self, margin: float) -> None: ...
    def rightMargin(self) -> float: ...
    def setRightMargin(self, margin: float) -> None: ...
    def leftMargin(self) -> float: ...
    def setLeftMargin(self, margin: float) -> None: ...
    def bottomMargin(self) -> float: ...
    def setBottomMargin(self, margin: float) -> None: ...
    def topMargin(self) -> float: ...
    def setTopMargin(self, margin: float) -> None: ...
    def alignment(self) -> QtCore.Qt.Alignment: ...
    def isValid(self) -> bool: ...


class QTextListFormat(QTextFormat):

    class Style(int): ...
    ListDisc = ... # type: 'QTextListFormat.Style'
    ListCircle = ... # type: 'QTextListFormat.Style'
    ListSquare = ... # type: 'QTextListFormat.Style'
    ListDecimal = ... # type: 'QTextListFormat.Style'
    ListLowerAlpha = ... # type: 'QTextListFormat.Style'
    ListUpperAlpha = ... # type: 'QTextListFormat.Style'
    ListLowerRoman = ... # type: 'QTextListFormat.Style'
    ListUpperRoman = ... # type: 'QTextListFormat.Style'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QTextListFormat') -> None: ...

    def setNumberSuffix(self, ns: str) -> None: ...
    def setNumberPrefix(self, np: str) -> None: ...
    def numberSuffix(self) -> str: ...
    def numberPrefix(self) -> str: ...
    def setIndent(self, aindent: int) -> None: ...
    def setStyle(self, astyle: 'QTextListFormat.Style') -> None: ...
    def indent(self) -> int: ...
    def style(self) -> 'QTextListFormat.Style': ...
    def isValid(self) -> bool: ...


class QTextImageFormat(QTextCharFormat):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QTextImageFormat') -> None: ...

    def setHeight(self, aheight: float) -> None: ...
    def setWidth(self, awidth: float) -> None: ...
    def setName(self, aname: str) -> None: ...
    def height(self) -> float: ...
    def width(self) -> float: ...
    def name(self) -> str: ...
    def isValid(self) -> bool: ...


class QTextFrameFormat(QTextFormat):

    class BorderStyle(int): ...
    BorderStyle_None = ... # type: 'QTextFrameFormat.BorderStyle'
    BorderStyle_Dotted = ... # type: 'QTextFrameFormat.BorderStyle'
    BorderStyle_Dashed = ... # type: 'QTextFrameFormat.BorderStyle'
    BorderStyle_Solid = ... # type: 'QTextFrameFormat.BorderStyle'
    BorderStyle_Double = ... # type: 'QTextFrameFormat.BorderStyle'
    BorderStyle_DotDash = ... # type: 'QTextFrameFormat.BorderStyle'
    BorderStyle_DotDotDash = ... # type: 'QTextFrameFormat.BorderStyle'
    BorderStyle_Groove = ... # type: 'QTextFrameFormat.BorderStyle'
    BorderStyle_Ridge = ... # type: 'QTextFrameFormat.BorderStyle'
    BorderStyle_Inset = ... # type: 'QTextFrameFormat.BorderStyle'
    BorderStyle_Outset = ... # type: 'QTextFrameFormat.BorderStyle'

    class Position(int): ...
    InFlow = ... # type: 'QTextFrameFormat.Position'
    FloatLeft = ... # type: 'QTextFrameFormat.Position'
    FloatRight = ... # type: 'QTextFrameFormat.Position'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QTextFrameFormat') -> None: ...

    def setRightMargin(self, amargin: float) -> None: ...
    def setLeftMargin(self, amargin: float) -> None: ...
    def setBottomMargin(self, amargin: float) -> None: ...
    def setTopMargin(self, amargin: float) -> None: ...
    def rightMargin(self) -> float: ...
    def leftMargin(self) -> float: ...
    def bottomMargin(self) -> float: ...
    def topMargin(self) -> float: ...
    def borderStyle(self) -> 'QTextFrameFormat.BorderStyle': ...
    def setBorderStyle(self, style: 'QTextFrameFormat.BorderStyle') -> None: ...
    def borderBrush(self) -> QBrush: ...
    def setBorderBrush(self, brush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def pageBreakPolicy(self) -> QTextFormat.PageBreakFlags: ...
    def setPageBreakPolicy(self, flags: QTextFormat.PageBreakFlags) -> None: ...
    @typing.overload
    def setHeight(self, aheight: float) -> None: ...
    @typing.overload
    def setHeight(self, aheight: QTextLength) -> None: ...
    def setPadding(self, apadding: float) -> None: ...
    def setMargin(self, amargin: float) -> None: ...
    def setBorder(self, aborder: float) -> None: ...
    def height(self) -> QTextLength: ...
    def width(self) -> QTextLength: ...
    @typing.overload
    def setWidth(self, length: QTextLength) -> None: ...
    @typing.overload
    def setWidth(self, awidth: float) -> None: ...
    def padding(self) -> float: ...
    def margin(self) -> float: ...
    def border(self) -> float: ...
    def position(self) -> 'QTextFrameFormat.Position': ...
    def setPosition(self, f: 'QTextFrameFormat.Position') -> None: ...
    def isValid(self) -> bool: ...


class QTextTableFormat(QTextFrameFormat):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QTextTableFormat') -> None: ...

    def headerRowCount(self) -> int: ...
    def setHeaderRowCount(self, count: int) -> None: ...
    def setAlignment(self, aalignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> None: ...
    def setCellPadding(self, apadding: float) -> None: ...
    def setColumns(self, acolumns: int) -> None: ...
    def alignment(self) -> QtCore.Qt.Alignment: ...
    def cellPadding(self) -> float: ...
    def setCellSpacing(self, spacing: float) -> None: ...
    def cellSpacing(self) -> float: ...
    def clearColumnWidthConstraints(self) -> None: ...
    def columnWidthConstraints(self) -> typing.List[QTextLength]: ...
    def setColumnWidthConstraints(self, constraints: typing.List[QTextLength]) -> None: ...
    def columns(self) -> int: ...
    def isValid(self) -> bool: ...


class QTextTableCellFormat(QTextCharFormat):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QTextTableCellFormat') -> None: ...

    def setPadding(self, padding: float) -> None: ...
    def rightPadding(self) -> float: ...
    def setRightPadding(self, padding: float) -> None: ...
    def leftPadding(self) -> float: ...
    def setLeftPadding(self, padding: float) -> None: ...
    def bottomPadding(self) -> float: ...
    def setBottomPadding(self, padding: float) -> None: ...
    def topPadding(self) -> float: ...
    def setTopPadding(self, padding: float) -> None: ...
    def isValid(self) -> bool: ...


class QTextInlineObject(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QTextInlineObject') -> None: ...

    def format(self) -> QTextFormat: ...
    def formatIndex(self) -> int: ...
    def textPosition(self) -> int: ...
    def setDescent(self, d: float) -> None: ...
    def setAscent(self, a: float) -> None: ...
    def setWidth(self, w: float) -> None: ...
    def textDirection(self) -> QtCore.Qt.LayoutDirection: ...
    def height(self) -> float: ...
    def descent(self) -> float: ...
    def ascent(self) -> float: ...
    def width(self) -> float: ...
    def rect(self) -> QtCore.QRectF: ...
    def isValid(self) -> bool: ...


class QTextLayout(sip.simplewrapper):

    class CursorMode(int): ...
    SkipCharacters = ... # type: 'QTextLayout.CursorMode'
    SkipWords = ... # type: 'QTextLayout.CursorMode'

    class FormatRange(sip.simplewrapper):

        format = ... # type: QTextCharFormat
        length = ... # type: int
        start = ... # type: int

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QTextLayout.FormatRange') -> None: ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, text: str) -> None: ...
    @typing.overload
    def __init__(self, text: str, font: QFont, paintDevice: typing.Optional[QPaintDevice] = ...) -> None: ...
    @typing.overload
    def __init__(self, b: 'QTextBlock') -> None: ...

    def glyphRuns(self) -> typing.List[QGlyphRun]: ...
    def rightCursorPosition(self, oldPos: int) -> int: ...
    def leftCursorPosition(self, oldPos: int) -> int: ...
    def cursorMoveStyle(self) -> QtCore.Qt.CursorMoveStyle: ...
    def setCursorMoveStyle(self, style: QtCore.Qt.CursorMoveStyle) -> None: ...
    def clearLayout(self) -> None: ...
    def maximumWidth(self) -> float: ...
    def minimumWidth(self) -> float: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def setPosition(self, p: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def position(self) -> QtCore.QPointF: ...
    @typing.overload
    def drawCursor(self, p: QPainter, pos: typing.Union[QtCore.QPointF, QtCore.QPoint], cursorPosition: int) -> None: ...
    @typing.overload
    def drawCursor(self, p: QPainter, pos: typing.Union[QtCore.QPointF, QtCore.QPoint], cursorPosition: int, width: int) -> None: ...
    def draw(self, p: QPainter, pos: typing.Union[QtCore.QPointF, QtCore.QPoint], selections: typing.List['QTextLayout.FormatRange'] = ..., clip: QtCore.QRectF = ...) -> None: ...
    def previousCursorPosition(self, oldPos: int, mode: 'QTextLayout.CursorMode' = ...) -> int: ...
    def nextCursorPosition(self, oldPos: int, mode: 'QTextLayout.CursorMode' = ...) -> int: ...
    def isValidCursorPosition(self, pos: int) -> bool: ...
    def lineForTextPosition(self, pos: int) -> 'QTextLine': ...
    def lineAt(self, i: int) -> 'QTextLine': ...
    def lineCount(self) -> int: ...
    def createLine(self) -> 'QTextLine': ...
    def endLayout(self) -> None: ...
    def beginLayout(self) -> None: ...
    def cacheEnabled(self) -> bool: ...
    def setCacheEnabled(self, enable: bool) -> None: ...
    def clearAdditionalFormats(self) -> None: ...
    def additionalFormats(self) -> typing.List['QTextLayout.FormatRange']: ...
    def setAdditionalFormats(self, overrides: typing.Sequence['QTextLayout.FormatRange']) -> None: ...
    def preeditAreaText(self) -> str: ...
    def preeditAreaPosition(self) -> int: ...
    def setPreeditArea(self, position: int, text: str) -> None: ...
    def textOption(self) -> 'QTextOption': ...
    def setTextOption(self, option: 'QTextOption') -> None: ...
    def text(self) -> str: ...
    def setText(self, string: str) -> None: ...
    def font(self) -> QFont: ...
    def setFont(self, f: QFont) -> None: ...


class QTextLine(sip.simplewrapper):

    class CursorPosition(int): ...
    CursorBetweenCharacters = ... # type: 'QTextLine.CursorPosition'
    CursorOnCharacter = ... # type: 'QTextLine.CursorPosition'

    class Edge(int): ...
    Leading = ... # type: 'QTextLine.Edge'
    Trailing = ... # type: 'QTextLine.Edge'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QTextLine') -> None: ...

    def horizontalAdvance(self) -> float: ...
    def leadingIncluded(self) -> bool: ...
    def setLeadingIncluded(self, included: bool) -> None: ...
    def leading(self) -> float: ...
    def position(self) -> QtCore.QPointF: ...
    def draw(self, painter: QPainter, position: typing.Union[QtCore.QPointF, QtCore.QPoint], selection: typing.Optional[QTextLayout.FormatRange] = ...) -> None: ...
    def lineNumber(self) -> int: ...
    def textLength(self) -> int: ...
    def textStart(self) -> int: ...
    def setPosition(self, pos: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @typing.overload
    def setNumColumns(self, columns: int) -> None: ...
    @typing.overload
    def setNumColumns(self, columns: int, alignmentWidth: float) -> None: ...
    def setLineWidth(self, width: float) -> None: ...
    def xToCursor(self, x: float, edge: 'QTextLine.CursorPosition' = ...) -> int: ...
    def cursorToX(self, cursorPos: int, edge: 'QTextLine.Edge' = ...) -> typing.Tuple[float, int]: ...
    def naturalTextRect(self) -> QtCore.QRectF: ...
    def naturalTextWidth(self) -> float: ...
    def height(self) -> float: ...
    def descent(self) -> float: ...
    def ascent(self) -> float: ...
    def width(self) -> float: ...
    def y(self) -> float: ...
    def x(self) -> float: ...
    def rect(self) -> QtCore.QRectF: ...
    def isValid(self) -> bool: ...


class QTextObject(QtCore.QObject):

    def __init__(self, doc: QTextDocument) -> None: ...

    def objectIndex(self) -> int: ...
    def document(self) -> QTextDocument: ...
    def formatIndex(self) -> int: ...
    def format(self) -> QTextFormat: ...
    def setFormat(self, format: QTextFormat) -> None: ...


class QTextBlockGroup(QTextObject):

    def __init__(self, doc: QTextDocument) -> None: ...

    def blockList(self) -> typing.List['QTextBlock']: ...
    def blockFormatChanged(self, block: 'QTextBlock') -> None: ...
    def blockRemoved(self, block: 'QTextBlock') -> None: ...
    def blockInserted(self, block: 'QTextBlock') -> None: ...


class QTextList(QTextBlockGroup):

    def __init__(self, doc: QTextDocument) -> None: ...

    def setFormat(self, aformat: QTextListFormat) -> None: ...
    def format(self) -> QTextListFormat: ...
    def add(self, block: 'QTextBlock') -> None: ...
    def remove(self, a0: 'QTextBlock') -> None: ...
    def removeItem(self, i: int) -> None: ...
    def itemText(self, a0: 'QTextBlock') -> str: ...
    def itemNumber(self, a0: 'QTextBlock') -> int: ...
    def item(self, i: int) -> 'QTextBlock': ...
    def isEmpty(self) -> bool: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...


class QTextFrame(QTextObject):

    class iterator(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, o: 'QTextFrame.iterator') -> None: ...

        def atEnd(self) -> bool: ...
        def currentBlock(self) -> 'QTextBlock': ...
        def currentFrame(self) -> 'QTextFrame': ...
        def parentFrame(self) -> 'QTextFrame': ...

    def __init__(self, doc: QTextDocument) -> None: ...

    def setFrameFormat(self, aformat: QTextFrameFormat) -> None: ...
    def end(self) -> 'QTextFrame.iterator': ...
    def begin(self) -> 'QTextFrame.iterator': ...
    def parentFrame(self) -> 'QTextFrame': ...
    def childFrames(self) -> typing.List['QTextFrame']: ...
    def lastPosition(self) -> int: ...
    def firstPosition(self) -> int: ...
    def lastCursorPosition(self) -> QTextCursor: ...
    def firstCursorPosition(self) -> QTextCursor: ...
    def frameFormat(self) -> QTextFrameFormat: ...


class QTextBlock(sip.wrapper):

    class iterator(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, o: 'QTextBlock.iterator') -> None: ...

        def atEnd(self) -> bool: ...
        def fragment(self) -> 'QTextFragment': ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, o: 'QTextBlock') -> None: ...

    def textDirection(self) -> QtCore.Qt.LayoutDirection: ...
    def lineCount(self) -> int: ...
    def setLineCount(self, count: int) -> None: ...
    def firstLineNumber(self) -> int: ...
    def blockNumber(self) -> int: ...
    def setVisible(self, visible: bool) -> None: ...
    def isVisible(self) -> bool: ...
    def setRevision(self, rev: int) -> None: ...
    def revision(self) -> int: ...
    def clearLayout(self) -> None: ...
    def setUserState(self, state: int) -> None: ...
    def userState(self) -> int: ...
    def setUserData(self, data: 'QTextBlockUserData') -> None: ...
    def userData(self) -> 'QTextBlockUserData': ...
    def previous(self) -> 'QTextBlock': ...
    def next(self) -> 'QTextBlock': ...
    def end(self) -> 'QTextBlock.iterator': ...
    def begin(self) -> 'QTextBlock.iterator': ...
    def textList(self) -> QTextList: ...
    def document(self) -> QTextDocument: ...
    def text(self) -> str: ...
    def charFormatIndex(self) -> int: ...
    def charFormat(self) -> QTextCharFormat: ...
    def blockFormatIndex(self) -> int: ...
    def blockFormat(self) -> QTextBlockFormat: ...
    def layout(self) -> QTextLayout: ...
    def contains(self, position: int) -> bool: ...
    def length(self) -> int: ...
    def position(self) -> int: ...
    def isValid(self) -> bool: ...


class QTextFragment(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, o: 'QTextFragment') -> None: ...

    def glyphRuns(self) -> typing.List[QGlyphRun]: ...
    def text(self) -> str: ...
    def charFormatIndex(self) -> int: ...
    def charFormat(self) -> QTextCharFormat: ...
    def contains(self, position: int) -> bool: ...
    def length(self) -> int: ...
    def position(self) -> int: ...
    def isValid(self) -> bool: ...


class QTextBlockUserData(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QTextBlockUserData') -> None: ...


class QTextOption(sip.simplewrapper):

    class TabType(int): ...
    LeftTab = ... # type: 'QTextOption.TabType'
    RightTab = ... # type: 'QTextOption.TabType'
    CenterTab = ... # type: 'QTextOption.TabType'
    DelimiterTab = ... # type: 'QTextOption.TabType'

    class Flag(int): ...
    IncludeTrailingSpaces = ... # type: 'QTextOption.Flag'
    ShowTabsAndSpaces = ... # type: 'QTextOption.Flag'
    ShowLineAndParagraphSeparators = ... # type: 'QTextOption.Flag'
    AddSpaceForLineAndParagraphSeparators = ... # type: 'QTextOption.Flag'
    SuppressColors = ... # type: 'QTextOption.Flag'

    class WrapMode(int): ...
    NoWrap = ... # type: 'QTextOption.WrapMode'
    WordWrap = ... # type: 'QTextOption.WrapMode'
    ManualWrap = ... # type: 'QTextOption.WrapMode'
    WrapAnywhere = ... # type: 'QTextOption.WrapMode'
    WrapAtWordBoundaryOrAnywhere = ... # type: 'QTextOption.WrapMode'

    class Flags(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QTextOption.Flags', 'QTextOption.Flag']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QTextOption.Flags') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QTextOption.Flags': ...
        def __int__(self) -> int: ...

    class Tab(sip.simplewrapper):

        delimiter = ... # type: str
        position = ... # type: float
        type = ... # type: 'QTextOption.TabType'

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, pos: float, tabType: 'QTextOption.TabType', delim: str = ...) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QTextOption.Tab') -> None: ...

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, alignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> None: ...
    @typing.overload
    def __init__(self, o: 'QTextOption') -> None: ...

    def tabs(self) -> typing.List['QTextOption.Tab']: ...
    def setTabs(self, tabStops: typing.Sequence['QTextOption.Tab']) -> None: ...
    def setTabStop(self, atabStop: float) -> None: ...
    def setFlags(self, aflags: 'QTextOption.Flags') -> None: ...
    def setAlignment(self, aalignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> None: ...
    def useDesignMetrics(self) -> bool: ...
    def setUseDesignMetrics(self, b: bool) -> None: ...
    def tabArray(self) -> typing.List[float]: ...
    def setTabArray(self, tabStops: typing.Sequence[float]) -> None: ...
    def tabStop(self) -> float: ...
    def flags(self) -> 'QTextOption.Flags': ...
    def wrapMode(self) -> 'QTextOption.WrapMode': ...
    def setWrapMode(self, wrap: 'QTextOption.WrapMode') -> None: ...
    def textDirection(self) -> QtCore.Qt.LayoutDirection: ...
    def setTextDirection(self, aDirection: QtCore.Qt.LayoutDirection) -> None: ...
    def alignment(self) -> QtCore.Qt.Alignment: ...


class QTextTableCell(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, o: 'QTextTableCell') -> None: ...

    def tableCellFormatIndex(self) -> int: ...
    def lastCursorPosition(self) -> QTextCursor: ...
    def firstCursorPosition(self) -> QTextCursor: ...
    def isValid(self) -> bool: ...
    def columnSpan(self) -> int: ...
    def rowSpan(self) -> int: ...
    def column(self) -> int: ...
    def row(self) -> int: ...
    def setFormat(self, format: QTextCharFormat) -> None: ...
    def format(self) -> QTextCharFormat: ...


class QTextTable(QTextFrame):

    def __init__(self, doc: QTextDocument) -> None: ...

    def appendColumns(self, count: int) -> None: ...
    def appendRows(self, count: int) -> None: ...
    def setFormat(self, aformat: QTextTableFormat) -> None: ...
    def format(self) -> QTextTableFormat: ...
    def rowEnd(self, c: QTextCursor) -> QTextCursor: ...
    def rowStart(self, c: QTextCursor) -> QTextCursor: ...
    @typing.overload
    def cellAt(self, row: int, col: int) -> QTextTableCell: ...
    @typing.overload
    def cellAt(self, position: int) -> QTextTableCell: ...
    @typing.overload
    def cellAt(self, c: QTextCursor) -> QTextTableCell: ...
    def columns(self) -> int: ...
    def rows(self) -> int: ...
    def splitCell(self, row: int, col: int, numRows: int, numCols: int) -> None: ...
    @typing.overload
    def mergeCells(self, row: int, col: int, numRows: int, numCols: int) -> None: ...
    @typing.overload
    def mergeCells(self, cursor: QTextCursor) -> None: ...
    def removeColumns(self, pos: int, num: int) -> None: ...
    def removeRows(self, pos: int, num: int) -> None: ...
    def insertColumns(self, pos: int, num: int) -> None: ...
    def insertRows(self, pos: int, num: int) -> None: ...
    def resize(self, rows: int, cols: int) -> None: ...


class QToolBar(QWidget):

    @typing.overload
    def __init__(self, title: str, parent: typing.Optional[QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...

    def isFloating(self) -> bool: ...
    def setFloatable(self, floatable: bool) -> None: ...
    def isFloatable(self) -> bool: ...
    def event(self, event: QtCore.QEvent) -> bool: ...
    def resizeEvent(self, event: QResizeEvent) -> None: ...
    def paintEvent(self, event: QPaintEvent) -> None: ...
    def childEvent(self, event: QtCore.QChildEvent) -> None: ...
    def changeEvent(self, event: QtCore.QEvent) -> None: ...
    def actionEvent(self, event: QActionEvent) -> None: ...
    def initStyleOption(self, option: QStyleOptionToolBar) -> None: ...
    def visibilityChanged(self, visible: bool) -> None: ...
    def topLevelChanged(self, topLevel: bool) -> None: ...
    def toolButtonStyleChanged(self, toolButtonStyle: QtCore.Qt.ToolButtonStyle) -> None: ...
    def iconSizeChanged(self, iconSize: QtCore.QSize) -> None: ...
    def orientationChanged(self, orientation: QtCore.Qt.Orientation) -> None: ...
    def allowedAreasChanged(self, allowedAreas: typing.Union[QtCore.Qt.ToolBarAreas, QtCore.Qt.ToolBarArea]) -> None: ...
    def movableChanged(self, movable: bool) -> None: ...
    def actionTriggered(self, action: QAction) -> None: ...
    def setToolButtonStyle(self, toolButtonStyle: QtCore.Qt.ToolButtonStyle) -> None: ...
    def setIconSize(self, iconSize: QtCore.QSize) -> None: ...
    def widgetForAction(self, action: QAction) -> QWidget: ...
    def toolButtonStyle(self) -> QtCore.Qt.ToolButtonStyle: ...
    def iconSize(self) -> QtCore.QSize: ...
    def toggleViewAction(self) -> QAction: ...
    @typing.overload
    def actionAt(self, p: QtCore.QPoint) -> QAction: ...
    @typing.overload
    def actionAt(self, ax: int, ay: int) -> QAction: ...
    def actionGeometry(self, action: QAction) -> QtCore.QRect: ...
    def insertWidget(self, before: QAction, widget: QWidget) -> QAction: ...
    def addWidget(self, widget: QWidget) -> QAction: ...
    def insertSeparator(self, before: QAction) -> QAction: ...
    def addSeparator(self) -> QAction: ...
    @typing.overload
    def addAction(self, action: QAction) -> None: ...
    @typing.overload
    def addAction(self, text: str) -> QAction: ...
    @typing.overload
    def addAction(self, icon: QIcon, text: str) -> QAction: ...
    @typing.overload
    def addAction(self, text: str, receiver: QtCore.QObject, member: QT_SLOT) -> QAction: ...
    @typing.overload
    def addAction(self, text: str, slot: PYQT_SLOT) -> QAction: ...
    @typing.overload
    def addAction(self, icon: QIcon, text: str, receiver: QtCore.QObject, member: QT_SLOT) -> QAction: ...
    @typing.overload
    def addAction(self, icon: QIcon, text: str, slot: PYQT_SLOT) -> QAction: ...
    def clear(self) -> None: ...
    def orientation(self) -> QtCore.Qt.Orientation: ...
    def setOrientation(self, orientation: QtCore.Qt.Orientation) -> None: ...
    def isAreaAllowed(self, area: QtCore.Qt.ToolBarArea) -> bool: ...
    def allowedAreas(self) -> QtCore.Qt.ToolBarAreas: ...
    def setAllowedAreas(self, areas: typing.Union[QtCore.Qt.ToolBarAreas, QtCore.Qt.ToolBarArea]) -> None: ...
    def isMovable(self) -> bool: ...
    def setMovable(self, movable: bool) -> None: ...


class QToolBox(QFrame):

    def __init__(self, parent: typing.Optional[QWidget] = ..., flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def changeEvent(self, a0: QtCore.QEvent) -> None: ...
    def showEvent(self, e: QShowEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def itemRemoved(self, index: int) -> None: ...
    def itemInserted(self, index: int) -> None: ...
    def currentChanged(self, index: int) -> None: ...
    def setCurrentWidget(self, widget: QWidget) -> None: ...
    def setCurrentIndex(self, index: int) -> None: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def indexOf(self, widget: QWidget) -> int: ...
    def widget(self, index: int) -> QWidget: ...
    def currentWidget(self) -> QWidget: ...
    def currentIndex(self) -> int: ...
    def itemToolTip(self, index: int) -> str: ...
    def setItemToolTip(self, index: int, toolTip: str) -> None: ...
    def itemIcon(self, index: int) -> QIcon: ...
    def setItemIcon(self, index: int, icon: QIcon) -> None: ...
    def itemText(self, index: int) -> str: ...
    def setItemText(self, index: int, text: str) -> None: ...
    def isItemEnabled(self, index: int) -> bool: ...
    def setItemEnabled(self, index: int, enabled: bool) -> None: ...
    def removeItem(self, index: int) -> None: ...
    @typing.overload
    def insertItem(self, index: int, item: QWidget, text: str) -> int: ...
    @typing.overload
    def insertItem(self, index: int, widget: QWidget, icon: QIcon, text: str) -> int: ...
    @typing.overload
    def addItem(self, item: QWidget, text: str) -> int: ...
    @typing.overload
    def addItem(self, item: QWidget, iconSet: QIcon, text: str) -> int: ...


class QToolButton(QAbstractButton):

    class ToolButtonPopupMode(int): ...
    DelayedPopup = ... # type: 'QToolButton.ToolButtonPopupMode'
    MenuButtonPopup = ... # type: 'QToolButton.ToolButtonPopupMode'
    InstantPopup = ... # type: 'QToolButton.ToolButtonPopupMode'

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...

    def hitButton(self, pos: QtCore.QPoint) -> bool: ...
    def nextCheckState(self) -> None: ...
    def mouseReleaseEvent(self, a0: QMouseEvent) -> None: ...
    def changeEvent(self, a0: QtCore.QEvent) -> None: ...
    def timerEvent(self, a0: QtCore.QTimerEvent) -> None: ...
    def leaveEvent(self, a0: QtCore.QEvent) -> None: ...
    def enterEvent(self, a0: QtCore.QEvent) -> None: ...
    def actionEvent(self, a0: QActionEvent) -> None: ...
    def paintEvent(self, a0: QPaintEvent) -> None: ...
    def mousePressEvent(self, a0: QMouseEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def initStyleOption(self, option: QStyleOptionToolButton) -> None: ...
    def triggered(self, a0: QAction) -> None: ...
    def setDefaultAction(self, a0: QAction) -> None: ...
    def setToolButtonStyle(self, style: QtCore.Qt.ToolButtonStyle) -> None: ...
    def showMenu(self) -> None: ...
    def autoRaise(self) -> bool: ...
    def setAutoRaise(self, enable: bool) -> None: ...
    def defaultAction(self) -> QAction: ...
    def popupMode(self) -> 'QToolButton.ToolButtonPopupMode': ...
    def setPopupMode(self, mode: 'QToolButton.ToolButtonPopupMode') -> None: ...
    def menu(self) -> QMenu: ...
    def setMenu(self, menu: QMenu) -> None: ...
    def setArrowType(self, type: QtCore.Qt.ArrowType) -> None: ...
    def arrowType(self) -> QtCore.Qt.ArrowType: ...
    def toolButtonStyle(self) -> QtCore.Qt.ToolButtonStyle: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...


class QToolTip(sip.simplewrapper):

    def __init__(self, a0: 'QToolTip') -> None: ...

    @staticmethod
    def text() -> str: ...
    @staticmethod
    def isVisible() -> bool: ...
    @staticmethod
    def setFont(a0: QFont) -> None: ...
    @staticmethod
    def font() -> QFont: ...
    @staticmethod
    def setPalette(a0: QPalette) -> None: ...
    @staticmethod
    def hideText() -> None: ...
    @staticmethod
    def palette() -> QPalette: ...
    @typing.overload
    @staticmethod
    def showText(pos: QtCore.QPoint, text: str, widget: typing.Optional[QWidget] = ...) -> None: ...
    @typing.overload
    @staticmethod
    def showText(pos: QtCore.QPoint, text: str, w: QWidget, rect: QtCore.QRect) -> None: ...


class QTransform(sip.simplewrapper):

    class TransformationType(int): ...
    TxNone = ... # type: 'QTransform.TransformationType'
    TxTranslate = ... # type: 'QTransform.TransformationType'
    TxScale = ... # type: 'QTransform.TransformationType'
    TxRotate = ... # type: 'QTransform.TransformationType'
    TxShear = ... # type: 'QTransform.TransformationType'
    TxProject = ... # type: 'QTransform.TransformationType'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, m11: float, m12: float, m13: float, m21: float, m22: float, m23: float, m31: float, m32: float, m33: float = ...) -> None: ...
    @typing.overload
    def __init__(self, h11: float, h12: float, h13: float, h21: float, h22: float, h23: float) -> None: ...
    @typing.overload
    def __init__(self, mtx: QMatrix) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QTransform') -> None: ...

    @staticmethod
    def fromScale(dx: float, dy: float) -> 'QTransform': ...
    @staticmethod
    def fromTranslate(dx: float, dy: float) -> 'QTransform': ...
    def dy(self) -> float: ...
    def dx(self) -> float: ...
    def m33(self) -> float: ...
    def m32(self) -> float: ...
    def m31(self) -> float: ...
    def m23(self) -> float: ...
    def m22(self) -> float: ...
    def m21(self) -> float: ...
    def m13(self) -> float: ...
    def m12(self) -> float: ...
    def m11(self) -> float: ...
    def det(self) -> float: ...
    def determinant(self) -> float: ...
    def isTranslating(self) -> bool: ...
    def isRotating(self) -> bool: ...
    def isScaling(self) -> bool: ...
    def isInvertible(self) -> bool: ...
    def isIdentity(self) -> bool: ...
    def isAffine(self) -> bool: ...
    def toAffine(self) -> QMatrix: ...
    @typing.overload
    def mapRect(self, a0: QtCore.QRect) -> QtCore.QRect: ...
    @typing.overload
    def mapRect(self, a0: QtCore.QRectF) -> QtCore.QRectF: ...
    def mapToPolygon(self, r: QtCore.QRect) -> QPolygon: ...
    @typing.overload
    def map(self, x: int, y: int) -> typing.Tuple[int, int]: ...
    @typing.overload
    def map(self, x: float, y: float) -> typing.Tuple[float, float]: ...
    @typing.overload
    def map(self, p: QtCore.QPoint) -> QtCore.QPoint: ...
    @typing.overload
    def map(self, p: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> QtCore.QPointF: ...
    @typing.overload
    def map(self, l: QtCore.QLine) -> QtCore.QLine: ...
    @typing.overload
    def map(self, l: QtCore.QLineF) -> QtCore.QLineF: ...
    @typing.overload
    def map(self, a: QPolygonF) -> QPolygonF: ...
    @typing.overload
    def map(self, a: QPolygon) -> QPolygon: ...
    @typing.overload
    def map(self, r: QRegion) -> QRegion: ...
    @typing.overload
    def map(self, p: QPainterPath) -> QPainterPath: ...
    def reset(self) -> None: ...
    @staticmethod
    def quadToQuad(one: QPolygonF, two: QPolygonF, result: 'QTransform') -> bool: ...
    @staticmethod
    def quadToSquare(quad: QPolygonF, result: 'QTransform') -> bool: ...
    @staticmethod
    def squareToQuad(square: QPolygonF, result: 'QTransform') -> bool: ...
    def rotateRadians(self, angle: float, axis: QtCore.Qt.Axis = ...) -> 'QTransform': ...
    def rotate(self, angle: float, axis: QtCore.Qt.Axis = ...) -> 'QTransform': ...
    def shear(self, sh: float, sv: float) -> 'QTransform': ...
    def scale(self, sx: float, sy: float) -> 'QTransform': ...
    def translate(self, dx: float, dy: float) -> 'QTransform': ...
    def transposed(self) -> 'QTransform': ...
    def adjoint(self) -> 'QTransform': ...
    def inverted(self) -> typing.Tuple['QTransform', bool]: ...
    def setMatrix(self, m11: float, m12: float, m13: float, m21: float, m22: float, m23: float, m31: float, m32: float, m33: float) -> None: ...
    def type(self) -> 'QTransform.TransformationType': ...


class QTreeView(QAbstractItemView):

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...

    def setHeaderHidden(self, hide: bool) -> None: ...
    def isHeaderHidden(self) -> bool: ...
    def setExpandsOnDoubleClick(self, enable: bool) -> None: ...
    def expandsOnDoubleClick(self) -> bool: ...
    def currentChanged(self, current: QtCore.QModelIndex, previous: QtCore.QModelIndex) -> None: ...
    def selectionChanged(self, selected: QItemSelection, deselected: QItemSelection) -> None: ...
    def rowHeight(self, index: QtCore.QModelIndex) -> int: ...
    def viewportEvent(self, event: QtCore.QEvent) -> bool: ...
    def dragMoveEvent(self, event: QDragMoveEvent) -> None: ...
    def expandToDepth(self, depth: int) -> None: ...
    def wordWrap(self) -> bool: ...
    def setWordWrap(self, on: bool) -> None: ...
    def setFirstColumnSpanned(self, row: int, parent: QtCore.QModelIndex, span: bool) -> None: ...
    def isFirstColumnSpanned(self, row: int, parent: QtCore.QModelIndex) -> bool: ...
    def setAutoExpandDelay(self, delay: int) -> None: ...
    def autoExpandDelay(self) -> int: ...
    def allColumnsShowFocus(self) -> bool: ...
    def setAllColumnsShowFocus(self, enable: bool) -> None: ...
    def isAnimated(self) -> bool: ...
    def setAnimated(self, enable: bool) -> None: ...
    def isSortingEnabled(self) -> bool: ...
    def setSortingEnabled(self, enable: bool) -> None: ...
    def setColumnWidth(self, column: int, width: int) -> None: ...
    def isIndexHidden(self, index: QtCore.QModelIndex) -> bool: ...
    def horizontalScrollbarAction(self, action: int) -> None: ...
    def indexRowSizeHint(self, index: QtCore.QModelIndex) -> int: ...
    def sizeHintForColumn(self, column: int) -> int: ...
    def updateGeometries(self) -> None: ...
    def keyPressEvent(self, event: QKeyEvent) -> None: ...
    def mouseDoubleClickEvent(self, e: QMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: QMouseEvent) -> None: ...
    def mousePressEvent(self, e: QMouseEvent) -> None: ...
    def drawTree(self, painter: QPainter, region: QRegion) -> None: ...
    def drawBranches(self, painter: QPainter, rect: QtCore.QRect, index: QtCore.QModelIndex) -> None: ...
    def drawRow(self, painter: QPainter, options: QStyleOptionViewItem, index: QtCore.QModelIndex) -> None: ...
    def mouseReleaseEvent(self, event: QMouseEvent) -> None: ...
    def timerEvent(self, event: QtCore.QTimerEvent) -> None: ...
    def paintEvent(self, e: QPaintEvent) -> None: ...
    def selectedIndexes(self) -> typing.List[QtCore.QModelIndex]: ...
    def visualRegionForSelection(self, selection: QItemSelection) -> QRegion: ...
    def setSelection(self, rect: QtCore.QRect, command: QItemSelectionModel.SelectionFlags) -> None: ...
    def verticalOffset(self) -> int: ...
    def horizontalOffset(self) -> int: ...
    def moveCursor(self, cursorAction: QAbstractItemView.CursorAction, modifiers: typing.Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier]) -> QtCore.QModelIndex: ...
    def rowsAboutToBeRemoved(self, parent: QtCore.QModelIndex, start: int, end: int) -> None: ...
    def rowsInserted(self, parent: QtCore.QModelIndex, start: int, end: int) -> None: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def rowsRemoved(self, parent: QtCore.QModelIndex, first: int, last: int) -> None: ...
    def reexpand(self) -> None: ...
    def columnMoved(self) -> None: ...
    def columnCountChanged(self, oldCount: int, newCount: int) -> None: ...
    def columnResized(self, column: int, oldSize: int, newSize: int) -> None: ...
    def selectAll(self) -> None: ...
    @typing.overload
    def sortByColumn(self, column: int) -> None: ...
    @typing.overload
    def sortByColumn(self, column: int, order: QtCore.Qt.SortOrder) -> None: ...
    def resizeColumnToContents(self, column: int) -> None: ...
    def collapseAll(self) -> None: ...
    def collapse(self, index: QtCore.QModelIndex) -> None: ...
    def expandAll(self) -> None: ...
    def expand(self, index: QtCore.QModelIndex) -> None: ...
    def showColumn(self, column: int) -> None: ...
    def hideColumn(self, column: int) -> None: ...
    def dataChanged(self, topLeft: QtCore.QModelIndex, bottomRight: QtCore.QModelIndex) -> None: ...
    def collapsed(self, index: QtCore.QModelIndex) -> None: ...
    def expanded(self, index: QtCore.QModelIndex) -> None: ...
    def reset(self) -> None: ...
    def indexBelow(self, index: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def indexAbove(self, index: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def indexAt(self, p: QtCore.QPoint) -> QtCore.QModelIndex: ...
    def scrollTo(self, index: QtCore.QModelIndex, hint: QAbstractItemView.ScrollHint = ...) -> None: ...
    def visualRect(self, index: QtCore.QModelIndex) -> QtCore.QRect: ...
    def keyboardSearch(self, search: str) -> None: ...
    def setExpanded(self, index: QtCore.QModelIndex, expand: bool) -> None: ...
    def isExpanded(self, index: QtCore.QModelIndex) -> bool: ...
    def setRowHidden(self, row: int, parent: QtCore.QModelIndex, hide: bool) -> None: ...
    def isRowHidden(self, row: int, parent: QtCore.QModelIndex) -> bool: ...
    def setColumnHidden(self, column: int, hide: bool) -> None: ...
    def isColumnHidden(self, column: int) -> bool: ...
    def columnAt(self, x: int) -> int: ...
    def columnWidth(self, column: int) -> int: ...
    def columnViewportPosition(self, column: int) -> int: ...
    def setItemsExpandable(self, enable: bool) -> None: ...
    def itemsExpandable(self) -> bool: ...
    def setUniformRowHeights(self, uniform: bool) -> None: ...
    def uniformRowHeights(self) -> bool: ...
    def setRootIsDecorated(self, show: bool) -> None: ...
    def rootIsDecorated(self) -> bool: ...
    def setIndentation(self, i: int) -> None: ...
    def indentation(self) -> int: ...
    def setHeader(self, header: QHeaderView) -> None: ...
    def header(self) -> QHeaderView: ...
    def setSelectionModel(self, selectionModel: QItemSelectionModel) -> None: ...
    def setRootIndex(self, index: QtCore.QModelIndex) -> None: ...
    def setModel(self, model: QtCore.QAbstractItemModel) -> None: ...


class QTreeWidgetItem(sip.wrapper):

    class ChildIndicatorPolicy(int): ...
    ShowIndicator = ... # type: 'QTreeWidgetItem.ChildIndicatorPolicy'
    DontShowIndicator = ... # type: 'QTreeWidgetItem.ChildIndicatorPolicy'
    DontShowIndicatorWhenChildless = ... # type: 'QTreeWidgetItem.ChildIndicatorPolicy'

    class ItemType(int): ...
    Type = ... # type: 'QTreeWidgetItem.ItemType'
    UserType = ... # type: 'QTreeWidgetItem.ItemType'

    @typing.overload
    def __init__(self, type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, strings: typing.Sequence[str], type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: 'QTreeWidget', type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: 'QTreeWidget', strings: typing.Sequence[str], type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: 'QTreeWidget', preceding: 'QTreeWidgetItem', type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: 'QTreeWidgetItem', type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: 'QTreeWidgetItem', strings: typing.Sequence[str], type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: 'QTreeWidgetItem', preceding: 'QTreeWidgetItem', type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, other: 'QTreeWidgetItem') -> None: ...

    def emitDataChanged(self) -> None: ...
    def isDisabled(self) -> bool: ...
    def setDisabled(self, disabled: bool) -> None: ...
    def isFirstColumnSpanned(self) -> bool: ...
    def setFirstColumnSpanned(self, aspan: bool) -> None: ...
    def removeChild(self, child: 'QTreeWidgetItem') -> None: ...
    def childIndicatorPolicy(self) -> 'QTreeWidgetItem.ChildIndicatorPolicy': ...
    def setChildIndicatorPolicy(self, policy: 'QTreeWidgetItem.ChildIndicatorPolicy') -> None: ...
    def isExpanded(self) -> bool: ...
    def setExpanded(self, aexpand: bool) -> None: ...
    def isHidden(self) -> bool: ...
    def setHidden(self, ahide: bool) -> None: ...
    def isSelected(self) -> bool: ...
    def setSelected(self, aselect: bool) -> None: ...
    def sortChildren(self, column: int, order: QtCore.Qt.SortOrder) -> None: ...
    def setForeground(self, column: int, brush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def foreground(self, column: int) -> QBrush: ...
    def setBackground(self, column: int, brush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def background(self, column: int) -> QBrush: ...
    def takeChildren(self) -> typing.List['QTreeWidgetItem']: ...
    def insertChildren(self, index: int, children: typing.Sequence['QTreeWidgetItem']) -> None: ...
    def addChildren(self, children: typing.Sequence['QTreeWidgetItem']) -> None: ...
    def setSizeHint(self, column: int, size: QtCore.QSize) -> None: ...
    def sizeHint(self, column: int) -> QtCore.QSize: ...
    def indexOfChild(self, achild: 'QTreeWidgetItem') -> int: ...
    def setFont(self, column: int, afont: QFont) -> None: ...
    def setWhatsThis(self, column: int, awhatsThis: str) -> None: ...
    def setToolTip(self, column: int, atoolTip: str) -> None: ...
    def setStatusTip(self, column: int, astatusTip: str) -> None: ...
    def setIcon(self, column: int, aicon: QIcon) -> None: ...
    def setText(self, column: int, atext: str) -> None: ...
    def setFlags(self, aflags: typing.Union[QtCore.Qt.ItemFlags, QtCore.Qt.ItemFlag]) -> None: ...
    def type(self) -> int: ...
    def takeChild(self, index: int) -> 'QTreeWidgetItem': ...
    def insertChild(self, index: int, child: 'QTreeWidgetItem') -> None: ...
    def addChild(self, child: 'QTreeWidgetItem') -> None: ...
    def columnCount(self) -> int: ...
    def childCount(self) -> int: ...
    def child(self, index: int) -> 'QTreeWidgetItem': ...
    def parent(self) -> 'QTreeWidgetItem': ...
    def write(self, out: QtCore.QDataStream) -> None: ...
    def read(self, in_: QtCore.QDataStream) -> None: ...
    def setData(self, column: int, role: int, value: typing.Any) -> None: ...
    def data(self, column: int, role: int) -> typing.Any: ...
    def setCheckState(self, column: int, state: QtCore.Qt.CheckState) -> None: ...
    def checkState(self, column: int) -> QtCore.Qt.CheckState: ...
    def setTextColor(self, column: int, color: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def textColor(self, column: int) -> QColor: ...
    def setBackgroundColor(self, column: int, color: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def backgroundColor(self, column: int) -> QColor: ...
    def setTextAlignment(self, column: int, alignment: int) -> None: ...
    def textAlignment(self, column: int) -> int: ...
    def font(self, column: int) -> QFont: ...
    def whatsThis(self, column: int) -> str: ...
    def toolTip(self, column: int) -> str: ...
    def statusTip(self, column: int) -> str: ...
    def icon(self, column: int) -> QIcon: ...
    def text(self, column: int) -> str: ...
    def flags(self) -> QtCore.Qt.ItemFlags: ...
    def treeWidget(self) -> 'QTreeWidget': ...
    def clone(self) -> 'QTreeWidgetItem': ...


class QTreeWidget(QTreeView):

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...

    def setSelectionModel(self, selectionModel: QItemSelectionModel) -> None: ...
    def removeItemWidget(self, item: QTreeWidgetItem, column: int) -> None: ...
    def itemBelow(self, item: QTreeWidgetItem) -> QTreeWidgetItem: ...
    def itemAbove(self, item: QTreeWidgetItem) -> QTreeWidgetItem: ...
    def setFirstItemColumnSpanned(self, item: QTreeWidgetItem, span: bool) -> None: ...
    def isFirstItemColumnSpanned(self, item: QTreeWidgetItem) -> bool: ...
    def setHeaderLabel(self, alabel: str) -> None: ...
    def invisibleRootItem(self) -> QTreeWidgetItem: ...
    def dropEvent(self, event: QDropEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def itemFromIndex(self, index: QtCore.QModelIndex) -> QTreeWidgetItem: ...
    def indexFromItem(self, item: QTreeWidgetItem, column: int = ...) -> QtCore.QModelIndex: ...
    def items(self, data: QtCore.QMimeData) -> typing.List[QTreeWidgetItem]: ...
    def supportedDropActions(self) -> QtCore.Qt.DropActions: ...
    def dropMimeData(self, parent: QTreeWidgetItem, index: int, data: QtCore.QMimeData, action: QtCore.Qt.DropAction) -> bool: ...
    def mimeData(self, items: typing.Sequence[QTreeWidgetItem]) -> QtCore.QMimeData: ...
    def mimeTypes(self) -> typing.List[str]: ...
    def itemSelectionChanged(self) -> None: ...
    def currentItemChanged(self, current: QTreeWidgetItem, previous: QTreeWidgetItem) -> None: ...
    def itemCollapsed(self, item: QTreeWidgetItem) -> None: ...
    def itemExpanded(self, item: QTreeWidgetItem) -> None: ...
    def itemChanged(self, item: QTreeWidgetItem, column: int) -> None: ...
    def itemEntered(self, item: QTreeWidgetItem, column: int) -> None: ...
    def itemActivated(self, item: QTreeWidgetItem, column: int) -> None: ...
    def itemDoubleClicked(self, item: QTreeWidgetItem, column: int) -> None: ...
    def itemClicked(self, item: QTreeWidgetItem, column: int) -> None: ...
    def itemPressed(self, item: QTreeWidgetItem, column: int) -> None: ...
    def clear(self) -> None: ...
    def collapseItem(self, item: QTreeWidgetItem) -> None: ...
    def expandItem(self, item: QTreeWidgetItem) -> None: ...
    def scrollToItem(self, item: QTreeWidgetItem, hint: QAbstractItemView.ScrollHint = ...) -> None: ...
    def setItemExpanded(self, item: QTreeWidgetItem, expand: bool) -> None: ...
    def isItemExpanded(self, item: QTreeWidgetItem) -> bool: ...
    def setItemHidden(self, item: QTreeWidgetItem, hide: bool) -> None: ...
    def isItemHidden(self, item: QTreeWidgetItem) -> bool: ...
    def findItems(self, text: str, flags: typing.Union[QtCore.Qt.MatchFlags, QtCore.Qt.MatchFlag], column: int = ...) -> typing.List[QTreeWidgetItem]: ...
    def selectedItems(self) -> typing.List[QTreeWidgetItem]: ...
    def setItemSelected(self, item: QTreeWidgetItem, select: bool) -> None: ...
    def isItemSelected(self, item: QTreeWidgetItem) -> bool: ...
    def setItemWidget(self, item: QTreeWidgetItem, column: int, widget: QWidget) -> None: ...
    def itemWidget(self, item: QTreeWidgetItem, column: int) -> QWidget: ...
    def closePersistentEditor(self, item: QTreeWidgetItem, column: int = ...) -> None: ...
    def openPersistentEditor(self, item: QTreeWidgetItem, column: int = ...) -> None: ...
    def editItem(self, item: QTreeWidgetItem, column: int = ...) -> None: ...
    def isSortingEnabled(self) -> bool: ...
    def setSortingEnabled(self, enable: bool) -> None: ...
    def sortItems(self, column: int, order: QtCore.Qt.SortOrder) -> None: ...
    def sortColumn(self) -> int: ...
    def visualItemRect(self, item: QTreeWidgetItem) -> QtCore.QRect: ...
    @typing.overload
    def itemAt(self, p: QtCore.QPoint) -> QTreeWidgetItem: ...
    @typing.overload
    def itemAt(self, ax: int, ay: int) -> QTreeWidgetItem: ...
    @typing.overload
    def setCurrentItem(self, item: QTreeWidgetItem) -> None: ...
    @typing.overload
    def setCurrentItem(self, item: QTreeWidgetItem, column: int) -> None: ...
    @typing.overload
    def setCurrentItem(self, item: QTreeWidgetItem, column: int, command: QItemSelectionModel.SelectionFlags) -> None: ...
    def currentColumn(self) -> int: ...
    def currentItem(self) -> QTreeWidgetItem: ...
    def setHeaderLabels(self, labels: typing.Sequence[str]) -> None: ...
    def setHeaderItem(self, item: QTreeWidgetItem) -> None: ...
    def headerItem(self) -> QTreeWidgetItem: ...
    def addTopLevelItems(self, items: typing.Sequence[QTreeWidgetItem]) -> None: ...
    def insertTopLevelItems(self, index: int, items: typing.Sequence[QTreeWidgetItem]) -> None: ...
    def indexOfTopLevelItem(self, item: QTreeWidgetItem) -> int: ...
    def takeTopLevelItem(self, index: int) -> QTreeWidgetItem: ...
    def addTopLevelItem(self, item: QTreeWidgetItem) -> None: ...
    def insertTopLevelItem(self, index: int, item: QTreeWidgetItem) -> None: ...
    def topLevelItemCount(self) -> int: ...
    def topLevelItem(self, index: int) -> QTreeWidgetItem: ...
    def setColumnCount(self, columns: int) -> None: ...
    def columnCount(self) -> int: ...


class QTreeWidgetItemIterator(sip.simplewrapper):

    class IteratorFlag(int): ...
    All = ... # type: 'QTreeWidgetItemIterator.IteratorFlag'
    Hidden = ... # type: 'QTreeWidgetItemIterator.IteratorFlag'
    NotHidden = ... # type: 'QTreeWidgetItemIterator.IteratorFlag'
    Selected = ... # type: 'QTreeWidgetItemIterator.IteratorFlag'
    Unselected = ... # type: 'QTreeWidgetItemIterator.IteratorFlag'
    Selectable = ... # type: 'QTreeWidgetItemIterator.IteratorFlag'
    NotSelectable = ... # type: 'QTreeWidgetItemIterator.IteratorFlag'
    DragEnabled = ... # type: 'QTreeWidgetItemIterator.IteratorFlag'
    DragDisabled = ... # type: 'QTreeWidgetItemIterator.IteratorFlag'
    DropEnabled = ... # type: 'QTreeWidgetItemIterator.IteratorFlag'
    DropDisabled = ... # type: 'QTreeWidgetItemIterator.IteratorFlag'
    HasChildren = ... # type: 'QTreeWidgetItemIterator.IteratorFlag'
    NoChildren = ... # type: 'QTreeWidgetItemIterator.IteratorFlag'
    Checked = ... # type: 'QTreeWidgetItemIterator.IteratorFlag'
    NotChecked = ... # type: 'QTreeWidgetItemIterator.IteratorFlag'
    Enabled = ... # type: 'QTreeWidgetItemIterator.IteratorFlag'
    Disabled = ... # type: 'QTreeWidgetItemIterator.IteratorFlag'
    Editable = ... # type: 'QTreeWidgetItemIterator.IteratorFlag'
    NotEditable = ... # type: 'QTreeWidgetItemIterator.IteratorFlag'
    UserFlag = ... # type: 'QTreeWidgetItemIterator.IteratorFlag'

    class IteratorFlags(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QTreeWidgetItemIterator.IteratorFlags', 'QTreeWidgetItemIterator.IteratorFlag']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QTreeWidgetItemIterator.IteratorFlags') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QTreeWidgetItemIterator.IteratorFlags': ...
        def __int__(self) -> int: ...

    @typing.overload
    def __init__(self, it: 'QTreeWidgetItemIterator') -> None: ...
    @typing.overload
    def __init__(self, widget: QTreeWidget, flags: 'QTreeWidgetItemIterator.IteratorFlags' = ...) -> None: ...
    @typing.overload
    def __init__(self, item: QTreeWidgetItem, flags: 'QTreeWidgetItemIterator.IteratorFlags' = ...) -> None: ...

    def value(self) -> QTreeWidgetItem: ...


class QUndoGroup(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def undoTextChanged(self, undoText: str) -> None: ...
    def redoTextChanged(self, redoText: str) -> None: ...
    def indexChanged(self, idx: int) -> None: ...
    def cleanChanged(self, clean: bool) -> None: ...
    def canUndoChanged(self, canUndo: bool) -> None: ...
    def canRedoChanged(self, canRedo: bool) -> None: ...
    def activeStackChanged(self, stack: 'QUndoStack') -> None: ...
    def undo(self) -> None: ...
    def setActiveStack(self, stack: 'QUndoStack') -> None: ...
    def redo(self) -> None: ...
    def isClean(self) -> bool: ...
    def redoText(self) -> str: ...
    def undoText(self) -> str: ...
    def canRedo(self) -> bool: ...
    def canUndo(self) -> bool: ...
    def createUndoAction(self, parent: QtCore.QObject, prefix: str = ...) -> QAction: ...
    def createRedoAction(self, parent: QtCore.QObject, prefix: str = ...) -> QAction: ...
    def activeStack(self) -> 'QUndoStack': ...
    def stacks(self) -> typing.List['QUndoStack']: ...
    def removeStack(self, stack: 'QUndoStack') -> None: ...
    def addStack(self, stack: 'QUndoStack') -> None: ...


class QUndoCommand(sip.wrapper):

    @typing.overload
    def __init__(self, parent: typing.Optional['QUndoCommand'] = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str, parent: typing.Optional['QUndoCommand'] = ...) -> None: ...

    def actionText(self) -> str: ...
    def child(self, index: int) -> 'QUndoCommand': ...
    def childCount(self) -> int: ...
    def undo(self) -> None: ...
    def text(self) -> str: ...
    def setText(self, text: str) -> None: ...
    def redo(self) -> None: ...
    def mergeWith(self, other: 'QUndoCommand') -> bool: ...
    def id(self) -> int: ...


class QUndoStack(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def command(self, index: int) -> QUndoCommand: ...
    def undoLimit(self) -> int: ...
    def setUndoLimit(self, limit: int) -> None: ...
    def undoTextChanged(self, undoText: str) -> None: ...
    def redoTextChanged(self, redoText: str) -> None: ...
    def indexChanged(self, idx: int) -> None: ...
    def cleanChanged(self, clean: bool) -> None: ...
    def canUndoChanged(self, canUndo: bool) -> None: ...
    def canRedoChanged(self, canRedo: bool) -> None: ...
    def undo(self) -> None: ...
    def setIndex(self, idx: int) -> None: ...
    def setClean(self) -> None: ...
    def setActive(self, active: bool = ...) -> None: ...
    def redo(self) -> None: ...
    def endMacro(self) -> None: ...
    def beginMacro(self, text: str) -> None: ...
    def cleanIndex(self) -> int: ...
    def isClean(self) -> bool: ...
    def isActive(self) -> bool: ...
    def createRedoAction(self, parent: QtCore.QObject, prefix: str = ...) -> QAction: ...
    def createUndoAction(self, parent: QtCore.QObject, prefix: str = ...) -> QAction: ...
    def text(self, idx: int) -> str: ...
    def index(self) -> int: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def redoText(self) -> str: ...
    def undoText(self) -> str: ...
    def canRedo(self) -> bool: ...
    def canUndo(self) -> bool: ...
    def push(self, cmd: QUndoCommand) -> None: ...
    def clear(self) -> None: ...


class QUndoView(QListView):

    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, stack: QUndoStack, parent: typing.Optional[QWidget] = ...) -> None: ...
    @typing.overload
    def __init__(self, group: QUndoGroup, parent: typing.Optional[QWidget] = ...) -> None: ...

    def setGroup(self, group: QUndoGroup) -> None: ...
    def setStack(self, stack: QUndoStack) -> None: ...
    def cleanIcon(self) -> QIcon: ...
    def setCleanIcon(self, icon: QIcon) -> None: ...
    def emptyLabel(self) -> str: ...
    def setEmptyLabel(self, label: str) -> None: ...
    def group(self) -> QUndoGroup: ...
    def stack(self) -> QUndoStack: ...


class QValidator(QtCore.QObject):

    class State(int): ...
    Invalid = ... # type: 'QValidator.State'
    Intermediate = ... # type: 'QValidator.State'
    Acceptable = ... # type: 'QValidator.State'

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def locale(self) -> QtCore.QLocale: ...
    def setLocale(self, locale: QtCore.QLocale) -> None: ...
    def fixup(self, input: str) -> str: ...
    def validate(self, a0: str, a1: int) -> typing.Tuple['QValidator.State', str, int]: ...


class QIntValidator(QValidator):

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, bottom: int, top: int, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def top(self) -> int: ...
    def bottom(self) -> int: ...
    def setRange(self, bottom: int, top: int) -> None: ...
    def setTop(self, a0: int) -> None: ...
    def setBottom(self, a0: int) -> None: ...
    def fixup(self, input: str) -> str: ...
    def validate(self, a0: str, a1: int) -> typing.Tuple[QValidator.State, str, int]: ...


class QDoubleValidator(QValidator):

    class Notation(int): ...
    StandardNotation = ... # type: 'QDoubleValidator.Notation'
    ScientificNotation = ... # type: 'QDoubleValidator.Notation'

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, bottom: float, top: float, decimals: int, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def notation(self) -> 'QDoubleValidator.Notation': ...
    def setNotation(self, a0: 'QDoubleValidator.Notation') -> None: ...
    def decimals(self) -> int: ...
    def top(self) -> float: ...
    def bottom(self) -> float: ...
    def setDecimals(self, a0: int) -> None: ...
    def setTop(self, a0: float) -> None: ...
    def setBottom(self, a0: float) -> None: ...
    def setRange(self, minimum: float, maximum: float, decimals: int = ...) -> None: ...
    def validate(self, a0: str, a1: int) -> typing.Tuple[QValidator.State, str, int]: ...


class QRegExpValidator(QValidator):

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, rx: QtCore.QRegExp, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def regExp(self) -> QtCore.QRegExp: ...
    def setRegExp(self, rx: QtCore.QRegExp) -> None: ...
    def validate(self, input: str, pos: int) -> typing.Tuple[QValidator.State, str, int]: ...


class QVector2D(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, xpos: float, ypos: float) -> None: ...
    @typing.overload
    def __init__(self, point: QtCore.QPoint) -> None: ...
    @typing.overload
    def __init__(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @typing.overload
    def __init__(self, vector: 'QVector3D') -> None: ...
    @typing.overload
    def __init__(self, vector: 'QVector4D') -> None: ...
    @typing.overload
    def __init__(self, a0: 'QVector2D') -> None: ...

    def __neg__(self) -> 'QVector2D': ...
    def toPointF(self) -> QtCore.QPointF: ...
    def toPoint(self) -> QtCore.QPoint: ...
    def setY(self, aY: float) -> None: ...
    def setX(self, aX: float) -> None: ...
    def y(self) -> float: ...
    def x(self) -> float: ...
    def isNull(self) -> bool: ...
    def toVector4D(self) -> 'QVector4D': ...
    def toVector3D(self) -> 'QVector3D': ...
    @staticmethod
    def dotProduct(v1: 'QVector2D', v2: 'QVector2D') -> float: ...
    def normalize(self) -> None: ...
    def normalized(self) -> 'QVector2D': ...
    def lengthSquared(self) -> float: ...
    def length(self) -> float: ...
    def __repr__(self) -> str: ...


class QVector3D(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, xpos: float, ypos: float, zpos: float) -> None: ...
    @typing.overload
    def __init__(self, point: QtCore.QPoint) -> None: ...
    @typing.overload
    def __init__(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @typing.overload
    def __init__(self, vector: QVector2D) -> None: ...
    @typing.overload
    def __init__(self, vector: QVector2D, zpos: float) -> None: ...
    @typing.overload
    def __init__(self, vector: 'QVector4D') -> None: ...
    @typing.overload
    def __init__(self, a0: 'QVector3D') -> None: ...

    def __neg__(self) -> 'QVector3D': ...
    def toPointF(self) -> QtCore.QPointF: ...
    def toPoint(self) -> QtCore.QPoint: ...
    def setZ(self, aZ: float) -> None: ...
    def setY(self, aY: float) -> None: ...
    def setX(self, aX: float) -> None: ...
    def z(self) -> float: ...
    def y(self) -> float: ...
    def x(self) -> float: ...
    def isNull(self) -> bool: ...
    def toVector4D(self) -> 'QVector4D': ...
    def toVector2D(self) -> QVector2D: ...
    def distanceToLine(self, point: 'QVector3D', direction: 'QVector3D') -> float: ...
    @typing.overload
    def distanceToPlane(self, plane: 'QVector3D', normal: 'QVector3D') -> float: ...
    @typing.overload
    def distanceToPlane(self, plane1: 'QVector3D', plane2: 'QVector3D', plane3: 'QVector3D') -> float: ...
    @typing.overload
    @staticmethod
    def normal(v1: 'QVector3D', v2: 'QVector3D') -> 'QVector3D': ...
    @typing.overload
    @staticmethod
    def normal(v1: 'QVector3D', v2: 'QVector3D', v3: 'QVector3D') -> 'QVector3D': ...
    @staticmethod
    def crossProduct(v1: 'QVector3D', v2: 'QVector3D') -> 'QVector3D': ...
    @staticmethod
    def dotProduct(v1: 'QVector3D', v2: 'QVector3D') -> float: ...
    def normalize(self) -> None: ...
    def normalized(self) -> 'QVector3D': ...
    def lengthSquared(self) -> float: ...
    def length(self) -> float: ...
    def __repr__(self) -> str: ...


class QVector4D(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, xpos: float, ypos: float, zpos: float, wpos: float) -> None: ...
    @typing.overload
    def __init__(self, point: QtCore.QPoint) -> None: ...
    @typing.overload
    def __init__(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @typing.overload
    def __init__(self, vector: QVector2D) -> None: ...
    @typing.overload
    def __init__(self, vector: QVector2D, zpos: float, wpos: float) -> None: ...
    @typing.overload
    def __init__(self, vector: QVector3D) -> None: ...
    @typing.overload
    def __init__(self, vector: QVector3D, wpos: float) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QVector4D') -> None: ...

    def __neg__(self) -> 'QVector4D': ...
    def toPointF(self) -> QtCore.QPointF: ...
    def toPoint(self) -> QtCore.QPoint: ...
    def setW(self, aW: float) -> None: ...
    def setZ(self, aZ: float) -> None: ...
    def setY(self, aY: float) -> None: ...
    def setX(self, aX: float) -> None: ...
    def w(self) -> float: ...
    def z(self) -> float: ...
    def y(self) -> float: ...
    def x(self) -> float: ...
    def isNull(self) -> bool: ...
    def toVector3DAffine(self) -> QVector3D: ...
    def toVector3D(self) -> QVector3D: ...
    def toVector2DAffine(self) -> QVector2D: ...
    def toVector2D(self) -> QVector2D: ...
    @staticmethod
    def dotProduct(v1: 'QVector4D', v2: 'QVector4D') -> float: ...
    def normalize(self) -> None: ...
    def normalized(self) -> 'QVector4D': ...
    def lengthSquared(self) -> float: ...
    def length(self) -> float: ...
    def __repr__(self) -> str: ...


class QWhatsThis(sip.simplewrapper):

    def __init__(self, a0: 'QWhatsThis') -> None: ...

    @staticmethod
    def createAction(parent: typing.Optional[QtCore.QObject] = ...) -> QAction: ...
    @staticmethod
    def hideText() -> None: ...
    @staticmethod
    def showText(pos: QtCore.QPoint, text: str, widget: typing.Optional[QWidget] = ...) -> None: ...
    @staticmethod
    def leaveWhatsThisMode() -> None: ...
    @staticmethod
    def inWhatsThisMode() -> bool: ...
    @staticmethod
    def enterWhatsThisMode() -> None: ...


class QWidgetAction(QAction):

    def __init__(self, parent: QtCore.QObject) -> None: ...

    def createdWidgets(self) -> typing.List[QWidget]: ...
    def deleteWidget(self, widget: QWidget) -> None: ...
    def createWidget(self, parent: QWidget) -> QWidget: ...
    def eventFilter(self, a0: QtCore.QObject, a1: QtCore.QEvent) -> bool: ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    def releaseWidget(self, widget: QWidget) -> None: ...
    def requestWidget(self, parent: QWidget) -> QWidget: ...
    def defaultWidget(self) -> QWidget: ...
    def setDefaultWidget(self, w: QWidget) -> None: ...


class QWizard(QDialog):

    class WizardOption(int): ...
    IndependentPages = ... # type: 'QWizard.WizardOption'
    IgnoreSubTitles = ... # type: 'QWizard.WizardOption'
    ExtendedWatermarkPixmap = ... # type: 'QWizard.WizardOption'
    NoDefaultButton = ... # type: 'QWizard.WizardOption'
    NoBackButtonOnStartPage = ... # type: 'QWizard.WizardOption'
    NoBackButtonOnLastPage = ... # type: 'QWizard.WizardOption'
    DisabledBackButtonOnLastPage = ... # type: 'QWizard.WizardOption'
    HaveNextButtonOnLastPage = ... # type: 'QWizard.WizardOption'
    HaveFinishButtonOnEarlyPages = ... # type: 'QWizard.WizardOption'
    NoCancelButton = ... # type: 'QWizard.WizardOption'
    CancelButtonOnLeft = ... # type: 'QWizard.WizardOption'
    HaveHelpButton = ... # type: 'QWizard.WizardOption'
    HelpButtonOnRight = ... # type: 'QWizard.WizardOption'
    HaveCustomButton1 = ... # type: 'QWizard.WizardOption'
    HaveCustomButton2 = ... # type: 'QWizard.WizardOption'
    HaveCustomButton3 = ... # type: 'QWizard.WizardOption'

    class WizardStyle(int): ...
    ClassicStyle = ... # type: 'QWizard.WizardStyle'
    ModernStyle = ... # type: 'QWizard.WizardStyle'
    MacStyle = ... # type: 'QWizard.WizardStyle'
    AeroStyle = ... # type: 'QWizard.WizardStyle'

    class WizardPixmap(int): ...
    WatermarkPixmap = ... # type: 'QWizard.WizardPixmap'
    LogoPixmap = ... # type: 'QWizard.WizardPixmap'
    BannerPixmap = ... # type: 'QWizard.WizardPixmap'
    BackgroundPixmap = ... # type: 'QWizard.WizardPixmap'

    class WizardButton(int): ...
    BackButton = ... # type: 'QWizard.WizardButton'
    NextButton = ... # type: 'QWizard.WizardButton'
    CommitButton = ... # type: 'QWizard.WizardButton'
    FinishButton = ... # type: 'QWizard.WizardButton'
    CancelButton = ... # type: 'QWizard.WizardButton'
    HelpButton = ... # type: 'QWizard.WizardButton'
    CustomButton1 = ... # type: 'QWizard.WizardButton'
    CustomButton2 = ... # type: 'QWizard.WizardButton'
    CustomButton3 = ... # type: 'QWizard.WizardButton'
    Stretch = ... # type: 'QWizard.WizardButton'

    class WizardOptions(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QWizard.WizardOptions', 'QWizard.WizardOption']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QWizard.WizardOptions') -> None: ...

        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QWizard.WizardOptions': ...
        def __int__(self) -> int: ...

    def __init__(self, parent: typing.Optional[QWidget] = ..., flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def pageRemoved(self, id: int) -> None: ...
    def pageAdded(self, id: int) -> None: ...
    def sideWidget(self) -> QWidget: ...
    def setSideWidget(self, widget: QWidget) -> None: ...
    def pageIds(self) -> typing.List[int]: ...
    def removePage(self, id: int) -> None: ...
    def cleanupPage(self, id: int) -> None: ...
    def initializePage(self, id: int) -> None: ...
    def done(self, result: int) -> None: ...
    def paintEvent(self, event: QPaintEvent) -> None: ...
    def resizeEvent(self, event: QResizeEvent) -> None: ...
    def event(self, event: QtCore.QEvent) -> bool: ...
    def restart(self) -> None: ...
    def next(self) -> None: ...
    def back(self) -> None: ...
    def customButtonClicked(self, which: int) -> None: ...
    def helpRequested(self) -> None: ...
    def currentIdChanged(self, id: int) -> None: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def setVisible(self, visible: bool) -> None: ...
    def setDefaultProperty(self, className: str, property: str, changedSignal: QT_SIGNAL) -> None: ...
    def pixmap(self, which: 'QWizard.WizardPixmap') -> QPixmap: ...
    def setPixmap(self, which: 'QWizard.WizardPixmap', pixmap: QPixmap) -> None: ...
    def subTitleFormat(self) -> QtCore.Qt.TextFormat: ...
    def setSubTitleFormat(self, format: QtCore.Qt.TextFormat) -> None: ...
    def titleFormat(self) -> QtCore.Qt.TextFormat: ...
    def setTitleFormat(self, format: QtCore.Qt.TextFormat) -> None: ...
    def button(self, which: 'QWizard.WizardButton') -> QAbstractButton: ...
    def setButton(self, which: 'QWizard.WizardButton', button: QAbstractButton) -> None: ...
    def setButtonLayout(self, layout: typing.List['QWizard.WizardButton']) -> None: ...
    def buttonText(self, which: 'QWizard.WizardButton') -> str: ...
    def setButtonText(self, which: 'QWizard.WizardButton', text: str) -> None: ...
    def options(self) -> 'QWizard.WizardOptions': ...
    def setOptions(self, options: 'QWizard.WizardOptions') -> None: ...
    def testOption(self, option: 'QWizard.WizardOption') -> bool: ...
    def setOption(self, option: 'QWizard.WizardOption', on: bool = ...) -> None: ...
    def wizardStyle(self) -> 'QWizard.WizardStyle': ...
    def setWizardStyle(self, style: 'QWizard.WizardStyle') -> None: ...
    def field(self, name: str) -> typing.Any: ...
    def setField(self, name: str, value: typing.Any) -> None: ...
    def nextId(self) -> int: ...
    def validateCurrentPage(self) -> bool: ...
    def currentId(self) -> int: ...
    def currentPage(self) -> 'QWizardPage': ...
    def startId(self) -> int: ...
    def setStartId(self, id: int) -> None: ...
    def visitedPages(self) -> typing.List[int]: ...
    def hasVisitedPage(self, id: int) -> bool: ...
    def page(self, id: int) -> 'QWizardPage': ...
    def setPage(self, id: int, page: 'QWizardPage') -> None: ...
    def addPage(self, page: 'QWizardPage') -> int: ...


class QWizardPage(QWidget):

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...

    def wizard(self) -> QWizard: ...
    def registerField(self, name: str, widget: QWidget, property: typing.Optional[str] = ..., changedSignal: QT_SIGNAL = ...) -> None: ...
    def field(self, name: str) -> typing.Any: ...
    def setField(self, name: str, value: typing.Any) -> None: ...
    def completeChanged(self) -> None: ...
    def nextId(self) -> int: ...
    def isComplete(self) -> bool: ...
    def validatePage(self) -> bool: ...
    def cleanupPage(self) -> None: ...
    def initializePage(self) -> None: ...
    def buttonText(self, which: QWizard.WizardButton) -> str: ...
    def setButtonText(self, which: QWizard.WizardButton, text: str) -> None: ...
    def isCommitPage(self) -> bool: ...
    def setCommitPage(self, commitPage: bool) -> None: ...
    def isFinalPage(self) -> bool: ...
    def setFinalPage(self, finalPage: bool) -> None: ...
    def pixmap(self, which: QWizard.WizardPixmap) -> QPixmap: ...
    def setPixmap(self, which: QWizard.WizardPixmap, pixmap: QPixmap) -> None: ...
    def subTitle(self) -> str: ...
    def setSubTitle(self, subTitle: str) -> None: ...
    def title(self) -> str: ...
    def setTitle(self, title: str) -> None: ...


class QWorkspace(QWidget):

    class WindowOrder(int): ...
    CreationOrder = ... # type: 'QWorkspace.WindowOrder'
    StackingOrder = ... # type: 'QWorkspace.WindowOrder'

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...

    def wheelEvent(self, e: QWheelEvent) -> None: ...
    def hideEvent(self, e: QHideEvent) -> None: ...
    def showEvent(self, e: QShowEvent) -> None: ...
    def eventFilter(self, a0: QtCore.QObject, a1: QtCore.QEvent) -> bool: ...
    def resizeEvent(self, a0: QResizeEvent) -> None: ...
    def childEvent(self, a0: QtCore.QChildEvent) -> None: ...
    def changeEvent(self, a0: QtCore.QEvent) -> None: ...
    def paintEvent(self, e: QPaintEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def activatePreviousWindow(self) -> None: ...
    def activateNextWindow(self) -> None: ...
    def closeAllWindows(self) -> None: ...
    def closeActiveWindow(self) -> None: ...
    def arrangeIcons(self) -> None: ...
    def tile(self) -> None: ...
    def cascade(self) -> None: ...
    def setActiveWindow(self, w: QWidget) -> None: ...
    def windowActivated(self, w: QWidget) -> None: ...
    def background(self) -> QBrush: ...
    def setBackground(self, background: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]) -> None: ...
    def setScrollBarsEnabled(self, enable: bool) -> None: ...
    def scrollBarsEnabled(self) -> bool: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def addWindow(self, w: QWidget, flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> QWidget: ...
    def windowList(self, order: 'QWorkspace.WindowOrder' = ...) -> typing.List[QWidget]: ...
    def activeWindow(self) -> QWidget: ...


class QX11EmbedWidget(QWidget):

    class Error(int): ...
    Unknown = ... # type: 'QX11EmbedWidget.Error'
    Internal = ... # type: 'QX11EmbedWidget.Error'
    InvalidWindowID = ... # type: 'QX11EmbedWidget.Error'

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...

    def resizeEvent(self, a0: QResizeEvent) -> None: ...
    def event(self, a0: QtCore.QEvent) -> bool: ...
    def eventFilter(self, a0: QtCore.QObject, a1: QtCore.QEvent) -> bool: ...
    def embedded(self) -> None: ...
    def containerClosed(self) -> None: ...
    @typing.overload
    def error(self) -> 'QX11EmbedWidget.Error': ...
    @typing.overload
    def error(self, error: 'QX11EmbedWidget.Error') -> None: ...
    def containerWinId(self) -> int: ...
    def embedInto(self, id: int) -> None: ...


class QX11EmbedContainer(QWidget):

    class Error(int): ...
    Unknown = ... # type: 'QX11EmbedContainer.Error'
    Internal = ... # type: 'QX11EmbedContainer.Error'
    InvalidWindowID = ... # type: 'QX11EmbedContainer.Error'

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None: ...

    def event(self, a0: QtCore.QEvent) -> bool: ...
    def hideEvent(self, a0: QHideEvent) -> None: ...
    def showEvent(self, a0: QShowEvent) -> None: ...
    def resizeEvent(self, a0: QResizeEvent) -> None: ...
    def paintEvent(self, e: QPaintEvent) -> None: ...
    def eventFilter(self, a0: QtCore.QObject, a1: QtCore.QEvent) -> bool: ...
    def clientIsEmbedded(self) -> None: ...
    def clientClosed(self) -> None: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    @typing.overload
    def error(self) -> 'QX11EmbedContainer.Error': ...
    @typing.overload
    def error(self, a0: 'QX11EmbedContainer.Error') -> None: ...
    def embedClient(self, id: int) -> None: ...
    def discardClient(self) -> None: ...
    def clientWinId(self) -> int: ...


class Display(sip.simplewrapper): ...


class QX11Info(sip.simplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'QX11Info') -> None: ...

    @staticmethod
    def isCompositingManagerRunning() -> bool: ...
    @staticmethod
    def setAppUserTime(time: int) -> None: ...
    @staticmethod
    def setAppTime(time: int) -> None: ...
    @staticmethod
    def appUserTime() -> int: ...
    @staticmethod
    def appTime() -> int: ...
    @staticmethod
    def setAppDpiY(screen: int, dpi: int) -> None: ...
    @staticmethod
    def setAppDpiX(screen: int, dpi: int) -> None: ...
    @staticmethod
    def appDpiY(screen: int = ...) -> int: ...
    @staticmethod
    def appDpiX(screen: int = ...) -> int: ...
    @staticmethod
    def appDefaultVisual(screen: int = ...) -> bool: ...
    @staticmethod
    def appDefaultColormap(screen: int = ...) -> bool: ...
    @staticmethod
    def appRootWindow(screen: int = ...) -> int: ...
    @staticmethod
    def appVisual(screen: int = ...) -> sip.voidptr: ...
    @staticmethod
    def appColormap(screen: int = ...) -> int: ...
    @staticmethod
    def appCells(screen: int = ...) -> int: ...
    @staticmethod
    def appDepth(screen: int = ...) -> int: ...
    @staticmethod
    def appScreen() -> int: ...
    def defaultVisual(self) -> bool: ...
    def visual(self) -> sip.voidptr: ...
    def defaultColormap(self) -> bool: ...
    def colormap(self) -> int: ...
    def cells(self) -> int: ...
    def depth(self) -> int: ...
    def screen(self) -> int: ...
    @staticmethod
    def appClass() -> str: ...
    @staticmethod
    def display() -> Display: ...


class QPyTextObject(QtCore.QObject, QTextObjectInterface):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...


QWIDGETSIZE_MAX = ... # type: int
qApp = ... # type: QApplication


def qIsGray(rgb: int) -> bool: ...
@typing.overload
def qGray(r: int, g: int, b: int) -> int: ...
@typing.overload
def qGray(rgb: int) -> int: ...
def qRgba(r: int, g: int, b: int, a: int) -> int: ...
def qRgb(r: int, g: int, b: int) -> int: ...
def qAlpha(rgb: int) -> int: ...
def qBlue(rgb: int) -> int: ...
def qGreen(rgb: int) -> int: ...
def qRed(rgb: int) -> int: ...
@typing.overload
def qFuzzyCompare(m1: QMatrix, m2: QMatrix) -> bool: ...
@typing.overload
def qFuzzyCompare(m1: QMatrix4x4, m2: QMatrix4x4) -> bool: ...
@typing.overload
def qFuzzyCompare(q1: QQuaternion, q2: QQuaternion) -> bool: ...
@typing.overload
def qFuzzyCompare(t1: QTransform, t2: QTransform) -> bool: ...
@typing.overload
def qFuzzyCompare(v1: QVector2D, v2: QVector2D) -> bool: ...
@typing.overload
def qFuzzyCompare(v1: QVector3D, v2: QVector3D) -> bool: ...
@typing.overload
def qFuzzyCompare(v1: QVector4D, v2: QVector4D) -> bool: ...
def qDrawBorderPixmap(painter: QPainter, target: QtCore.QRect, margins: QtCore.QMargins, pixmap: QPixmap) -> None: ...
@typing.overload
def qDrawPlainRect(p: QPainter, x: int, y: int, w: int, h: int, a5: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient], lineWidth: int = ..., fill: typing.Optional[typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]] = ...) -> None: ...
@typing.overload
def qDrawPlainRect(p: QPainter, r: QtCore.QRect, a2: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient], lineWidth: int = ..., fill: typing.Optional[typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]] = ...) -> None: ...
@typing.overload
def qDrawWinPanel(p: QPainter, x: int, y: int, w: int, h: int, pal: QPalette, sunken: bool = ..., fill: typing.Optional[typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]] = ...) -> None: ...
@typing.overload
def qDrawWinPanel(p: QPainter, r: QtCore.QRect, pal: QPalette, sunken: bool = ..., fill: typing.Optional[typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]] = ...) -> None: ...
@typing.overload
def qDrawWinButton(p: QPainter, x: int, y: int, w: int, h: int, pal: QPalette, sunken: bool = ..., fill: typing.Optional[typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]] = ...) -> None: ...
@typing.overload
def qDrawWinButton(p: QPainter, r: QtCore.QRect, pal: QPalette, sunken: bool = ..., fill: typing.Optional[typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]] = ...) -> None: ...
@typing.overload
def qDrawShadePanel(p: QPainter, x: int, y: int, w: int, h: int, pal: QPalette, sunken: bool = ..., lineWidth: int = ..., fill: typing.Optional[typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]] = ...) -> None: ...
@typing.overload
def qDrawShadePanel(p: QPainter, r: QtCore.QRect, pal: QPalette, sunken: bool = ..., lineWidth: int = ..., fill: typing.Optional[typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]] = ...) -> None: ...
@typing.overload
def qDrawShadeRect(p: QPainter, x: int, y: int, w: int, h: int, pal: QPalette, sunken: bool = ..., lineWidth: int = ..., midLineWidth: int = ..., fill: typing.Optional[typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]] = ...) -> None: ...
@typing.overload
def qDrawShadeRect(p: QPainter, r: QtCore.QRect, pal: QPalette, sunken: bool = ..., lineWidth: int = ..., midLineWidth: int = ..., fill: typing.Optional[typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]] = ...) -> None: ...
@typing.overload
def qDrawShadeLine(p: QPainter, x1: int, y1: int, x2: int, y2: int, pal: QPalette, sunken: bool = ..., lineWidth: int = ..., midLineWidth: int = ...) -> None: ...
@typing.overload
def qDrawShadeLine(p: QPainter, p1: QtCore.QPoint, p2: QtCore.QPoint, pal: QPalette, sunken: bool = ..., lineWidth: int = ..., midLineWidth: int = ...) -> None: ...
def qt_x11_wait_for_window_manager(widget: QWidget) -> None: ...
