rule Win32_Trojan_HermeticWiper : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "HERMETICWIPER"
        description         = "Yara rule that detects HermeticWiper trojan."

        tc_detection_type   = "Trojan"
        tc_detection_name   = "HermeticWiper"
        tc_detection_factor = 5

    strings:
        $corrupt_physical_drive = {
            55 8B EC 81 EC ?? ?? ?? ?? 53 56 57 51 68 ?? ?? ?? ?? 0F 57 C0 89 55 ?? 8D 85 ?? ?? 
            ?? ?? C7 45 ?? ?? ?? ?? ?? 68 ?? ?? ?? ?? 33 F6 66 0F D6 45 ?? 33 FF 89 75 ?? 50 0F 
            11 45 ?? 89 7D ?? 0F 11 45 ?? FF 15 ?? ?? ?? ?? 83 C4 ?? 8D 45 ?? 8D 55 ?? 8D 8D ?? 
            ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B D8 83 FB ?? 0F 84 ?? ?? ?? ?? 85 DB 0F 84 ?? ?? ?? ?? 
            BF ?? ?? ?? ?? 57 6A ?? FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 6A ?? 8B F0 8D 45 ?? 
            50 57 56 6A ?? 6A ?? 68 ?? ?? ?? ?? 53 FF 15 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 83 F8 ?? 
            75 ?? 66 0F 1F 44 00 ?? 56 6A ?? FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 81 C7 ?? ?? 
            ?? ?? 33 F6 81 FF ?? ?? ?? ?? 0F 83 ?? ?? ?? ?? 57 6A ?? FF 15 ?? ?? ?? ?? 50 FF 15 
            ?? ?? ?? ?? 8B F0 85 F6 0F 84 ?? ?? ?? ?? 6A ?? 8D 45 ?? 50 57 56 6A ?? 6A ?? 68 ?? 
            ?? ?? ?? 53 FF 15 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 83 F8 ?? 74 ?? 85 F6 0F 84 ?? ?? ?? 
            ?? 8B 06 C7 45 ?? ?? ?? ?? ?? 83 F8 ?? 74 ?? 85 C0 74 ?? 83 F8 ?? 0F 85 ?? ?? ?? ?? 
            83 7E ?? ?? C7 45 ?? ?? ?? ?? ?? 0F 86 ?? ?? ?? ?? 8B 55 ?? 8D 46 ?? 89 45 ?? 66 90 
            8B 00 85 C0 74 ?? 83 F8 ?? 0F 85 ?? ?? ?? ?? 52 6A ?? FF 15 ?? ?? ?? ?? 50 FF 15 ?? 
            ?? ?? ?? 8B F8 89 7D ?? 85 FF 0F 84 ?? ?? ?? ?? 8B 45 ?? 6A ?? 6A ?? FF 70 ?? FF 70 
            ?? 53 FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 6A ?? 8D 45 ?? 50 FF 75 ?? 57 53 FF 
            15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 8B 55 ?? 81 FA ?? ?? ?? ?? 72 ?? 66 83 7F ?? 
            ?? 75 ?? 85 D2 0F B7 C2 B9 ?? ?? ?? ?? 0F 45 C8 66 89 4F ?? 8B 45 ?? FF 70 ?? FF 70 
            ?? FF 75 ?? FF 75 ?? 57 53 FF 55 ?? 8B 55 ?? 8B 4D ?? 8B 45 ?? 41 05 ?? ?? ?? ?? 89 
            4D ?? 89 45 ?? 3B 4E ?? 0F 82 ?? ?? ?? ?? 8B 7D ?? EB ?? FF 15 ?? ?? ?? ?? 33 FF 85 
            DB 74 ?? 83 FB ?? 74 ?? 53 FF 15 ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 85 F6 74 ?? 56 6A ?? 
            FF D3 8B 35 ?? ?? ?? ?? 50 FF D6 EB ?? FF 15 ?? ?? ?? ?? 8B 7D ?? EB ?? 33 C0 5F 5E 
            5B 8B E5 5D C2 ?? ?? 8B 35 ?? ?? ?? ?? 85 FF 74 ?? 57 6A ?? FF D3 50 FF D6 8B 45 ?? 
            5F 5E 5B 8B E5 5D C2
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            $corrupt_physical_drive
        )
}