"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.scanJsFiles = scanJsFiles;
const fs = __importStar(require("fs"));
const walkdir = __importStar(require("walkdir"));
function scanJsFiles(path, options) {
    const finder = walkdir.find(path, { follow_symlinks: false, no_return: true });
    const ext = (options.ext || 'js').split(',').map((e) => `.${e}`);
    function onFile(file) {
        if (ext.some((e) => file.endsWith(e))) {
            finder.emit('jsfile', file);
        }
        if (file.match(/\/bower.json$/)) {
            finder.emit('bowerfile', file);
        }
    }
    finder.on('file', onFile);
    finder.on('link', (link) => {
        if (fs.existsSync(link)) {
            const file = fs.realpathSync(link);
            if (fs.lstatSync(file).isFile()) {
                onFile(link);
            }
        }
        else {
            options.log.warn(`Could not follow symlink: ${link}`);
        }
    });
    return finder;
}
