from ScoutSuite.providers.azure.facade.base import AzureFacade
from ScoutSuite.providers.azure.resources.base import AzureResources


class ServerVulnerabilityAssessments(AzureResources):

    def __init__(self, facade: AzureFacade, resource_group_name: str, server_name: str, subscription_id: str):
        super().__init__(facade)
        self.resource_group_name = resource_group_name
        self.server_name = server_name
        self.subscription_id = subscription_id

    async def fetch_all(self):
        server_vulnerability = await self.facade.sqldatabase.get_server_vulnerability_assessments(
            self.resource_group_name, self.server_name, self.subscription_id)
        self._parse_vulnerabilities(server_vulnerability)

    def _parse_vulnerabilities(self, vulnerability):
        self.update({
            'storage_account_name': vulnerability.name,
            'recurring_scans_enabled': vulnerability.recurring_scans.is_enabled,
            'send_scan_reports_to_not_empty': vulnerability.recurring_scans.emails != [],
            'email_subscription_admin': vulnerability.recurring_scans.email_subscription_admins
        })


