from binascii import hexlify, unhexlify

TERM_PRIV_KEY = { # little endian, from [MS-RDPBCGR].pdf
    "n": [ 0x3d, 0x3a, 0x5e, 0xbd, 0x72, 0x43, 0x3e, 0xc9, 0x4d, 0xbb, 0xc1,
          0x1e, 0x4a, 0xba, 0x5f, 0xcb, 0x3e, 0x88, 0x20, 0x87, 0xef, 0xf5,
          0xc1, 0xe2, 0xd7, 0xb7, 0x6b, 0x9a, 0xf2, 0x52, 0x45, 0x95, 0xce,
          0x63, 0x65, 0x6b, 0x58, 0x3a, 0xfe, 0xef, 0x7c, 0xe7, 0xbf, 0xfe,
          0x3d, 0xf6, 0x5c, 0x7d, 0x6c, 0x5e, 0x06, 0x09, 0x1a, 0xf5, 0x61,
          0xbb, 0x20, 0x93, 0x09, 0x5f, 0x05, 0x6d, 0xea, 0x87 ],
                      # modulus
    "d": [ 0x87, 0xa7, 0x19, 0x32, 0xda, 0x11, 0x87, 0x55, 0x58, 0x00, 0x16,
          0x16, 0x25, 0x65, 0x68, 0xf8, 0x24, 0x3e, 0xe6, 0xfa, 0xe9, 0x67,
          0x49, 0x94, 0xcf, 0x92, 0xcc, 0x33, 0x99, 0xe8, 0x08, 0x60, 0x17,
          0x9a, 0x12, 0x9f, 0x24, 0xdd, 0xb1, 0x24, 0x99, 0xc7, 0x3a, 0xb8,
          0x0a, 0x7b, 0x0d, 0xdd, 0x35, 0x07, 0x79, 0x17, 0x0b, 0x51, 0x9b,
          0xb3, 0xc7, 0x10, 0x01, 0x13, 0xe7, 0x3f, 0xf3, 0x5f ],
                      # private exponent
    "e": [ 0x5b, 0x7b, 0x88, 0xc0 ] # public exponent
}


# http://www.millisecond.com/support/docs/v5/html/language/scancodes.htm
SCANCODE = {
    0: None,
    1: "ESC", 2: "1", 3: "2", 4: "3", 5: "4", 6: "5", 7: "6", 8: "7", 9:
    "8", 10: "9", 11: "0", 12: "-", 13: "=", 14: "Backspace", 15: "Tab", 16: "Q",
    17: "W", 18: "E", 19: "R", 20: "T", 21: "Y", 22: "U", 23: "I", 24: "O",
    25: "P", 26: "[", 27: "]", 28: "Enter", 29: "CTRL", 30: "A", 31: "S",
    32: "D", 33: "F", 34: "G", 35: "H", 36: "J", 37: "K", 38: "L", 39: ";",
    40: "'", 41: "`", 42: "LShift", 43: "\\", 44: "Z", 45: "X", 46: "C", 47:
    "V", 48: "B", 49: "N", 50: "M", 51: ",", 52: ".", 53: "/", 54: "RShift",
    55: "PrtSc", 56: "Alt", 57: "Space", 58: "Caps", 59: "F1", 60: "F2", 61:
    "F3", 62: "F4", 63: "F5", 64: "F6", 65: "F7", 66: "F8", 67: "F9", 68:
    "F10", 69: "Num", 70: "Scroll", 71: "Home (7)", 72: "Up (8)", 73:
    "PgUp (9)", 74: "-", 75: "Left (4)", 76: "Center (5)", 77: "Right (6)",
    78: "+", 79: "End (1)", 80: "Down (2)", 81: "PgDn (3)", 82: "Ins", 83:
    "Del", #91: "LMeta", 92: "RMeta",
}

REV_SCANCODE = dict([(v, k) for k, v in SCANCODE.items()])
REV_SCANCODE[" "] = REV_SCANCODE["Space"]
REV_SCANCODE["LMeta"] = 91

#  https://support.microsoft.com/de-de/help/324097/list-of-language-packs-and-their-codes-for-windows-2000-domain-control
KBD_LAYOUT_CNTRY = {
    0x436: b"Afrikaans",
    0x041c: b"Albanian",
    0x401: b"Arabic_Saudi_Arabia",
    0x801: b"Arabic_Iraq",
    0x0c01: b"Arabic_Egypt",
    0x1001: b"Arabic_Libya",
    0x1401: b"Arabic_Algeria",
    0x1801: b"Arabic_Morocco",
    0x1c01: b"Arabic_Tunisia",
    0x2001: b"Arabic_Oman",
    0x2401: b"Arabic_Yemen",
    0x2801: b"Arabic_Syria",
    0x2c01: b"Arabic_Jordan",
    0x3001: b"Arabic_Lebanon",
    0x3401: b"Arabic_Kuwait",
    0x3801: b"Arabic_UAE",
    0x3c01: b"Arabic_Bahrain",
    0x4001: b"Arabic_Qatar",
    0x042b: b"Armenian",
    0x042c: b"Azeri_Latin",
    0x082c: b"Azeri_Cyrillic",
    0x042d: b"Basque",
    0x423: b"Belarusian",
    0x402: b"Bulgarian",
    0x403: b"Catalan",
    0x404: b"Chinese_Taiwan",
    0x804: b"Chinese_PRC",
    0x0c04: b"Chinese_Hong_Kong",
    0x1004: b"Chinese_Singapore",
    0x1404: b"Chinese_Macau",
    0x041a: b"Croatian",
    0x405: b"Czech",
    0x406: b"Danish",
    0x413: b"Dutch_Standard",
    0x813: b"Dutch_Belgian",
    0x409: b"English_United_States",
    0x809: b"English_United_Kingdom",
    0x0c09: b"English_Australian",
    0x1009: b"English_Canadian",
    0x1409: b"English_New_Zealand",
    0x1809: b"English_Irish",
    0x1c09: b"English_South_Africa", 
    0x2009: b"English_Jamaica",
    0x2409: b"English_Caribbean",
    0x2809: b"English_Belize",
    0x2c09: b"English_Trinidad",
    0x3009: b"English_Zimbabwe",
    0x3409: b"English_Philippines",
    0x425: b"Estonian",
    0x438: b"Faeroese",
    0x429: b"Farsi",
    0x040b: b"Finnish",
    0x040c: b"French_Standard",
    0x080c: b"French_Belgian",
    0x0c0c: b"French_Canadian",
    0x100c: b"French_Swiss",
    0x140c: b"French_Luxembourg",
    0x180c: b"French_Monaco",
    0x437: b"Georgian",
    0x407: b"German_Standard",
    0x807: b"German_Swiss",
    0x0c07: b"German_Austrian",
    0x1007: b"German_Luxembourg",
    0x1407: b"German_Liechtenstein",
    0x408: b"Greek",
    0x040d: b"Hebrew",
    0x439: b"Hindi",
    0x040e: b"Hungarian",
    0x040f: b"Icelandic",
    0x421: b"Indonesian",
    0x410: b"Italian_Standard",
    0x810: b"Italian_Swiss",
    0x411: b"Japanese",
    0x043f: b"Kazakh",
    0x457: b"Konkani",
    0x412: b"Korean",
    0x426: b"Latvian",
    0x427: b"Lithuanian",
    0x042f: b"FYRO Macedonian",
    0x043e: b"Malay_Malaysia",
    0x083e: b"Malay_Brunei_Darussalam",
    0x044e: b"Marathi",
    0x414: b"Norwegian_Bokmal",
    0x814: b"Norwegian_Nynorsk",
    0x415: b"Polish",
    0x416: b"Portuguese_Brazilian",
    0x816: b"Portuguese_Standard",
    0x418: b"Romanian",
    0x419: b"Russian",
    0x044f: b"Sanskrit",
    0x081a: b"Serbian_Latin",
    0x0c1a: b"Serbian_Cyrillic",
    0x041b: b"Slovak",
    0x424: b"Slovenian",
    0x040a: b"Spanish_Traditional_Sort",
    0x080a: b"Spanish_Mexican",
    0x0c0a: b"Spanish_Modern_Sort",
    0x100a: b"Spanish_Guatemala",
    0x140a: b"Spanish_Costa_Rica",
    0x180a: b"Spanish_Panama",
    0x1c0a: b"Spanish_Dominican_Republic",
    0x200a: b"Spanish_Venezuela",
    0x240a: b"Spanish_Colombia",
    0x280a: b"Spanish_Peru",
    0x2c0a: b"Spanish_Argentina",
    0x300a: b"Spanish_Ecuador",
    0x340a: b"Spanish_Chile",
    0x380a: b"Spanish_Uruguay",
    0x3c0a: b"Spanish_Paraguay",
    0x400a: b"Spanish_Bolivia",
    0x440a: b"Spanish_El_Salvador",
    0x480a: b"Spanish_Honduras",
    0x4c0a: b"Spanish_Nicaragua",
    0x500a: b"Spanish_Puerto_Rico",
    0x441: b"Swahili",
    0x041d: b"Swedish",
    0x081d: b"Swedish_Finland",
    0x449: b"Tamil",
    0x444: b"Tatar",
    0x041e: b"Thai",
    0x041f: b"Turkish",
    0x422: b"Ukrainian",
    0x420: b"Urdu",
    0x443: b"Uzbek_Latin",
    0x843: b"Uzbek_Cyrillic",
    0x042a: b"Vietnamese",
}

RELAY_PORT=13389

SERVER_RESPONSES = [
    "030000130ed00000123400020f080001000000",
    "0300007e02f0807f66740a0100020100301a020122020103020100020101020100020101020300fff80201020450000500147c00012a14760a01010001c0004d63446e3a010c1000040008000100000003000000030c1000eb030400ec03ed03ee03ef03020c0c000000000000000000040c0600f003080c080005030000",
    "0300000b02f0802e000008",
    "300da003020104a4060204c000005e",
]

SERVER_RESPONSES = [unhexlify(x.encode()) for x in SERVER_RESPONSES]
