/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableSet;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.sleuthkit.datamodel.AbstractFile;
import org.sleuthkit.datamodel.AnalysisResult;
import org.sleuthkit.datamodel.AnalysisResultAdded;
import org.sleuthkit.datamodel.Attribute;
import org.sleuthkit.datamodel.BlackboardArtifact;
import org.sleuthkit.datamodel.BlackboardAttribute;
import org.sleuthkit.datamodel.Content;
import org.sleuthkit.datamodel.DataArtifact;
import org.sleuthkit.datamodel.OsAccountInstance;
import org.sleuthkit.datamodel.Score;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.TskCoreException;
import org.sleuthkit.datamodel.TskData;

public final class Blackboard {
    private static final Logger LOGGER = Logger.getLogger(Blackboard.class.getName());
    private final Map<Integer, BlackboardArtifact.Type> typeIdToArtifactTypeMap = new ConcurrentHashMap<Integer, BlackboardArtifact.Type>();
    private final Map<Integer, BlackboardAttribute.Type> typeIdToAttributeTypeMap = new ConcurrentHashMap<Integer, BlackboardAttribute.Type>();
    private final Map<String, BlackboardArtifact.Type> typeNameToArtifactTypeMap = new ConcurrentHashMap<String, BlackboardArtifact.Type>();
    private final Map<String, BlackboardAttribute.Type> typeNameToAttributeTypeMap = new ConcurrentHashMap<String, BlackboardAttribute.Type>();
    static final int MIN_USER_DEFINED_TYPE_ID = 10000;
    private final SleuthkitCase caseDb;
    private static final String ANALYSIS_RESULT_QUERY_STRING_GENERIC = "SELECT DISTINCT artifacts.artifact_id AS artifact_id,  artifacts.obj_id AS obj_id, artifacts.artifact_obj_id AS artifact_obj_id, artifacts.data_source_obj_id AS data_source_obj_id, artifacts.artifact_type_id AS artifact_type_id,  types.type_name AS type_name, types.display_name AS display_name, types.category_type as category_type, artifacts.review_status_id AS review_status_id,  results.conclusion AS conclusion,  results.significance AS significance,  results.priority AS priority,   results.configuration AS configuration,  results.justification AS justification,  results.ignore_score AS ignore_score  FROM blackboard_artifacts AS artifacts  JOIN blackboard_artifact_types AS types \t\tON artifacts.artifact_type_id = types.artifact_type_id LEFT JOIN tsk_analysis_results AS results \t\tON artifacts.artifact_obj_id = results.artifact_obj_id ";
    private static final String ANALYSIS_RESULT_QUERY_STRING_WITH_ATTRIBUTES = "SELECT DISTINCT artifacts.artifact_id AS artifact_id,  artifacts.obj_id AS obj_id, artifacts.artifact_obj_id AS artifact_obj_id, artifacts.data_source_obj_id AS data_source_obj_id, artifacts.artifact_type_id AS artifact_type_id,  types.type_name AS type_name, types.display_name AS display_name, types.category_type as category_type, artifacts.review_status_id AS review_status_id,  results.conclusion AS conclusion,  results.significance AS significance,  results.priority AS priority,   results.configuration AS configuration,  results.justification AS justification,  results.ignore_score AS ignore_score  FROM blackboard_artifacts AS artifacts  JOIN blackboard_artifact_types AS types \t\tON artifacts.artifact_type_id = types.artifact_type_id LEFT JOIN tsk_analysis_results AS results \t\tON artifacts.artifact_obj_id = results.artifact_obj_id  JOIN blackboard_attributes AS attributes  ON artifacts.artifact_id = attributes.artifact_id  WHERE types.category_type = " + BlackboardArtifact.Category.ANALYSIS_RESULT.getID();
    private static final String ANALYSIS_RESULT_QUERY_STRING_WHERE = "SELECT DISTINCT artifacts.artifact_id AS artifact_id,  artifacts.obj_id AS obj_id, artifacts.artifact_obj_id AS artifact_obj_id, artifacts.data_source_obj_id AS data_source_obj_id, artifacts.artifact_type_id AS artifact_type_id,  types.type_name AS type_name, types.display_name AS display_name, types.category_type as category_type, artifacts.review_status_id AS review_status_id,  results.conclusion AS conclusion,  results.significance AS significance,  results.priority AS priority,   results.configuration AS configuration,  results.justification AS justification,  results.ignore_score AS ignore_score  FROM blackboard_artifacts AS artifacts  JOIN blackboard_artifact_types AS types \t\tON artifacts.artifact_type_id = types.artifact_type_id LEFT JOIN tsk_analysis_results AS results \t\tON artifacts.artifact_obj_id = results.artifact_obj_id  WHERE artifacts.review_status_id != " + BlackboardArtifact.ReviewStatus.REJECTED.getID() + "     AND types.category_type = " + BlackboardArtifact.Category.ANALYSIS_RESULT.getID();
    private static final String DATA_ARTIFACT_QUERY_STRING_GENERIC = "SELECT DISTINCT artifacts.artifact_id AS artifact_id, artifacts.obj_id AS obj_id, artifacts.artifact_obj_id AS artifact_obj_id, artifacts.data_source_obj_id AS data_source_obj_id, artifacts.artifact_type_id AS artifact_type_id,  types.type_name AS type_name, types.display_name AS display_name, types.category_type as category_type, artifacts.review_status_id AS review_status_id,  data_artifacts.os_account_obj_id as os_account_obj_id  FROM blackboard_artifacts AS artifacts  JOIN blackboard_artifact_types AS types \t\tON artifacts.artifact_type_id = types.artifact_type_id LEFT JOIN tsk_data_artifacts AS data_artifacts \t\tON artifacts.artifact_obj_id = data_artifacts.artifact_obj_id ";
    private static final String DATA_ARTIFACT_QUERY_STRING_WITH_ATTRIBUTES = "SELECT DISTINCT artifacts.artifact_id AS artifact_id, artifacts.obj_id AS obj_id, artifacts.artifact_obj_id AS artifact_obj_id, artifacts.data_source_obj_id AS data_source_obj_id, artifacts.artifact_type_id AS artifact_type_id,  types.type_name AS type_name, types.display_name AS display_name, types.category_type as category_type, artifacts.review_status_id AS review_status_id,  data_artifacts.os_account_obj_id as os_account_obj_id  FROM blackboard_artifacts AS artifacts  JOIN blackboard_artifact_types AS types \t\tON artifacts.artifact_type_id = types.artifact_type_id LEFT JOIN tsk_data_artifacts AS data_artifacts \t\tON artifacts.artifact_obj_id = data_artifacts.artifact_obj_id  JOIN blackboard_attributes AS attributes  ON artifacts.artifact_id = attributes.artifact_id  WHERE types.category_type = " + BlackboardArtifact.Category.DATA_ARTIFACT.getID();
    private static final String DATA_ARTIFACT_QUERY_STRING_WHERE = "SELECT DISTINCT artifacts.artifact_id AS artifact_id, artifacts.obj_id AS obj_id, artifacts.artifact_obj_id AS artifact_obj_id, artifacts.data_source_obj_id AS data_source_obj_id, artifacts.artifact_type_id AS artifact_type_id,  types.type_name AS type_name, types.display_name AS display_name, types.category_type as category_type, artifacts.review_status_id AS review_status_id,  data_artifacts.os_account_obj_id as os_account_obj_id  FROM blackboard_artifacts AS artifacts  JOIN blackboard_artifact_types AS types \t\tON artifacts.artifact_type_id = types.artifact_type_id LEFT JOIN tsk_data_artifacts AS data_artifacts \t\tON artifacts.artifact_obj_id = data_artifacts.artifact_obj_id  WHERE artifacts.review_status_id != " + BlackboardArtifact.ReviewStatus.REJECTED.getID() + "     AND types.category_type = " + BlackboardArtifact.Category.DATA_ARTIFACT.getID();

    Blackboard(SleuthkitCase casedb) {
        this.caseDb = Objects.requireNonNull(casedb, "Cannot create Blackboard for null SleuthkitCase");
    }

    @Deprecated
    public void postArtifact(BlackboardArtifact artifact, String moduleName) throws BlackboardException {
        this.postArtifacts(Collections.singleton(artifact), moduleName, null);
    }

    @Deprecated
    public void postArtifacts(Collection<BlackboardArtifact> artifacts, String moduleName) throws BlackboardException {
        this.postArtifacts(artifacts, moduleName, null);
    }

    public void postArtifact(BlackboardArtifact artifact, String moduleName, Long ingestJobId) throws BlackboardException {
        this.postArtifacts(Collections.singleton(artifact), moduleName, ingestJobId);
    }

    public void postArtifacts(Collection<BlackboardArtifact> artifacts, String moduleName, Long ingestJobId) throws BlackboardException {
        for (BlackboardArtifact artifact : artifacts) {
            try {
                this.caseDb.getTimelineManager().addArtifactEvents(artifact);
            }
            catch (TskCoreException ex) {
                throw new BlackboardException(String.format("Failed to add events to timeline for artifact '%s'", artifact), ex);
            }
        }
        this.caseDb.fireTSKEvent(new ArtifactsPostedEvent(this, artifacts, moduleName, ingestJobId));
    }

    public BlackboardArtifact.Type getOrAddArtifactType(String typeName, String displayName) throws BlackboardException {
        return this.getOrAddArtifactType(typeName, displayName, BlackboardArtifact.Category.DATA_ARTIFACT);
    }

    public BlackboardArtifact.Type getOrAddArtifactType(String typeName, String displayName, BlackboardArtifact.Category category) throws BlackboardException {
        if (category == null) {
            throw new BlackboardException("Category provided must be non-null");
        }
        if (this.typeNameToArtifactTypeMap.containsKey(typeName)) {
            return this.typeNameToArtifactTypeMap.get(typeName);
        }
        SleuthkitCase.CaseDbTransaction trans = null;
        try {
            boolean typeFound;
            trans = this.caseDb.beginTransaction();
            SleuthkitCase.CaseDbConnection connection = trans.getConnection();
            try (PreparedStatement findCurrPrepState = connection.prepareStatement("SELECT artifact_type_id FROM blackboard_artifact_types WHERE type_name = ?", 1);){
                findCurrPrepState.setString(1, typeName);
                try (ResultSet rs = connection.executeQuery(findCurrPrepState);){
                    typeFound = rs.next();
                }
            }
            if (!typeFound) {
                int maxID = 0;
                try (Statement getNextIdState = connection.createStatement();
                     ResultSet rs = connection.executeQuery(getNextIdState, "SELECT MAX(artifact_type_id) AS highest_id FROM blackboard_artifact_types");){
                    if (rs.next()) {
                        maxID = rs.getInt("highest_id");
                        maxID = maxID < 10000 ? 10000 : ++maxID;
                    }
                }
                try (PreparedStatement insertItemPrepState = connection.prepareStatement("INSERT INTO blackboard_artifact_types (artifact_type_id, type_name, display_name, category_type) VALUES (?, ?, ?, ?)", 1);){
                    insertItemPrepState.setInt(1, maxID);
                    insertItemPrepState.setString(2, typeName);
                    insertItemPrepState.setString(3, displayName);
                    insertItemPrepState.setInt(4, category.getID());
                    insertItemPrepState.executeUpdate();
                }
                BlackboardArtifact.Type type = new BlackboardArtifact.Type(maxID, typeName, displayName, category);
                this.typeIdToArtifactTypeMap.put(type.getTypeID(), type);
                this.typeNameToArtifactTypeMap.put(type.getTypeName(), type);
                trans.commit();
                trans = null;
                BlackboardArtifact.Type type2 = type;
                return type2;
            }
            trans.commit();
            trans = null;
            try {
                BlackboardArtifact.Type maxID = this.getArtifactType(typeName);
                return maxID;
            }
            catch (TskCoreException ex) {
                try {
                    throw new BlackboardException("Failed to get or add artifact type: " + typeName, ex);
                }
                catch (SQLException | TskCoreException ex2) {
                    try {
                        if (trans != null) {
                            trans.rollback();
                            trans = null;
                        }
                    }
                    catch (TskCoreException ex22) {
                        LOGGER.log(Level.SEVERE, "Error rolling back transaction", ex22);
                    }
                    throw new BlackboardException("Error adding artifact type: " + typeName, ex2);
                }
            }
        }
        finally {
            if (trans != null) {
                try {
                    trans.rollback();
                }
                catch (TskCoreException ex) {
                    throw new BlackboardException("Error rolling back transaction", ex);
                }
            }
        }
    }

    public BlackboardAttribute.Type getAttributeType(String attrTypeName) throws TskCoreException {
        BlackboardAttribute.Type type;
        if (this.typeNameToAttributeTypeMap.containsKey(attrTypeName)) {
            return this.typeNameToAttributeTypeMap.get(attrTypeName);
        }
        SleuthkitCase.CaseDbConnection connection = null;
        Statement s = null;
        ResultSet rs = null;
        this.caseDb.acquireSingleUserCaseReadLock();
        try {
            connection = this.caseDb.getConnection();
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT attribute_type_id, type_name, display_name, value_type FROM blackboard_attribute_types WHERE type_name = '" + attrTypeName + "'");
            BlackboardAttribute.Type type2 = null;
            if (rs.next()) {
                type2 = new BlackboardAttribute.Type(rs.getInt("attribute_type_id"), rs.getString("type_name"), rs.getString("display_name"), BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.fromType(rs.getLong("value_type")));
                this.typeIdToAttributeTypeMap.put(type2.getTypeID(), type2);
                this.typeNameToAttributeTypeMap.put(attrTypeName, type2);
            }
            type = type2;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting attribute type id", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                SleuthkitCase.closeConnection(connection);
                this.caseDb.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        SleuthkitCase.closeConnection(connection);
        this.caseDb.releaseSingleUserCaseReadLock();
        return type;
    }

    BlackboardAttribute.Type getAttributeType(int typeID) throws TskCoreException {
        BlackboardAttribute.Type type;
        if (this.typeIdToAttributeTypeMap.containsKey(typeID)) {
            return this.typeIdToAttributeTypeMap.get(typeID);
        }
        SleuthkitCase.CaseDbConnection connection = null;
        Statement s = null;
        ResultSet rs = null;
        this.caseDb.acquireSingleUserCaseReadLock();
        try {
            connection = this.caseDb.getConnection();
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT attribute_type_id, type_name, display_name, value_type FROM blackboard_attribute_types WHERE attribute_type_id = " + typeID);
            BlackboardAttribute.Type type2 = null;
            if (rs.next()) {
                type2 = new BlackboardAttribute.Type(rs.getInt("attribute_type_id"), rs.getString("type_name"), rs.getString("display_name"), BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.fromType(rs.getLong("value_type")));
                this.typeIdToAttributeTypeMap.put(typeID, type2);
                this.typeNameToAttributeTypeMap.put(type2.getTypeName(), type2);
            }
            type = type2;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting attribute type id", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                SleuthkitCase.closeConnection(connection);
                this.caseDb.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        SleuthkitCase.closeConnection(connection);
        this.caseDb.releaseSingleUserCaseReadLock();
        return type;
    }

    /*
     * Exception decompiling
     */
    public BlackboardArtifact.Type getArtifactType(String artTypeName) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public BlackboardArtifact.Type getArtifactType(int artTypeId) throws TskCoreException {
        ResultSet rs;
        Statement s;
        SleuthkitCase.CaseDbConnection connection;
        block6: {
            if (this.typeIdToArtifactTypeMap.containsKey(artTypeId)) {
                return this.typeIdToArtifactTypeMap.get(artTypeId);
            }
            connection = null;
            s = null;
            rs = null;
            this.caseDb.acquireSingleUserCaseReadLock();
            connection = this.caseDb.getConnection();
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT artifact_type_id, type_name, display_name, category_type FROM blackboard_artifact_types WHERE artifact_type_id = " + artTypeId);
            BlackboardArtifact.Type type = null;
            if (!rs.next()) break block6;
            type = new BlackboardArtifact.Type(rs.getInt("artifact_type_id"), rs.getString("type_name"), rs.getString("display_name"), BlackboardArtifact.Category.fromID(rs.getInt("category_type")));
            this.typeIdToArtifactTypeMap.put(artTypeId, type);
            this.typeNameToArtifactTypeMap.put(type.getTypeName(), type);
            BlackboardArtifact.Type type2 = type;
            SleuthkitCase.closeResultSet(rs);
            SleuthkitCase.closeStatement(s);
            SleuthkitCase.closeConnection(connection);
            this.caseDb.releaseSingleUserCaseReadLock();
            return type2;
        }
        try {
            try {
                throw new TskCoreException("No artifact type found matching id: " + artTypeId);
            }
            catch (SQLException ex) {
                throw new TskCoreException("Error getting artifact type from the database", ex);
            }
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(rs);
            SleuthkitCase.closeStatement(s);
            SleuthkitCase.closeConnection(connection);
            this.caseDb.releaseSingleUserCaseReadLock();
            throw throwable;
        }
    }

    public ArrayList<BlackboardAttribute> getBlackboardAttributes(BlackboardArtifact artifact) throws TskCoreException {
        ArrayList<BlackboardAttribute> arrayList;
        SleuthkitCase.CaseDbConnection connection = null;
        Statement statement = null;
        ResultSet rs = null;
        String rowId = switch (this.caseDb.getDatabaseType()) {
            case TskData.DbType.POSTGRESQL -> "attrs.CTID";
            case TskData.DbType.SQLITE -> "attrs.ROWID";
            default -> throw new TskCoreException("Unknown database type: " + String.valueOf((Object)this.caseDb.getDatabaseType()));
        };
        this.caseDb.acquireSingleUserCaseReadLock();
        try {
            connection = this.caseDb.getConnection();
            statement = connection.createStatement();
            rs = connection.executeQuery(statement, "SELECT attrs.artifact_id AS artifact_id, attrs.source AS source, attrs.context AS context, attrs.attribute_type_id AS attribute_type_id, attrs.value_type AS value_type, attrs.value_byte AS value_byte, attrs.value_text AS value_text, attrs.value_int32 AS value_int32, attrs.value_int64 AS value_int64, attrs.value_double AS value_double, types.type_name AS type_name, types.display_name AS display_name FROM blackboard_attributes AS attrs, blackboard_attribute_types AS types WHERE attrs.artifact_id = " + artifact.getArtifactID() + " AND attrs.attribute_type_id = types.attribute_type_id  ORDER BY " + rowId);
            ArrayList<BlackboardAttribute> attributes = new ArrayList<BlackboardAttribute>();
            while (rs.next()) {
                BlackboardAttribute attr = this.createAttributeFromResultSet(rs);
                attr.setParentDataSourceID(artifact.getDataSourceObjectID());
                attributes.add(attr);
            }
            arrayList = attributes;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting attributes for artifact, artifact id = " + artifact.getArtifactID(), ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(statement);
                SleuthkitCase.closeConnection(connection);
                this.caseDb.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(statement);
        SleuthkitCase.closeConnection(connection);
        this.caseDb.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    @Beta
    public <T extends BlackboardArtifact> void loadBlackboardAttributes(List<T> arts) throws TskCoreException {
        if (arts.isEmpty()) {
            return;
        }
        HashMap<Long, BlackboardArtifact> artifactMap = new HashMap<Long, BlackboardArtifact>();
        for (BlackboardArtifact art : arts) {
            artifactMap.put(art.getArtifactID(), art);
        }
        HashMap attributeMap = new HashMap();
        String idString = arts.stream().map(p -> Long.toString(p.getArtifactID())).collect(Collectors.joining(", "));
        String rowId = switch (this.caseDb.getDatabaseType()) {
            case TskData.DbType.POSTGRESQL -> "attrs.CTID";
            case TskData.DbType.SQLITE -> "attrs.ROWID";
            default -> throw new TskCoreException("Unknown database type: " + String.valueOf((Object)this.caseDb.getDatabaseType()));
        };
        SleuthkitCase.CaseDbConnection connection = null;
        Statement statement = null;
        ResultSet rs = null;
        this.caseDb.acquireSingleUserCaseReadLock();
        try {
            connection = this.caseDb.getConnection();
            statement = connection.createStatement();
            rs = connection.executeQuery(statement, "SELECT attrs.artifact_id AS artifact_id, attrs.source AS source, attrs.context AS context, attrs.attribute_type_id AS attribute_type_id, attrs.value_type AS value_type, attrs.value_byte AS value_byte, attrs.value_text AS value_text, attrs.value_int32 AS value_int32, attrs.value_int64 AS value_int64, attrs.value_double AS value_double, types.type_name AS type_name, types.display_name AS display_name FROM blackboard_attributes AS attrs, blackboard_attribute_types AS types WHERE attrs.artifact_id IN (" + idString + ")  AND attrs.attribute_type_id = types.attribute_type_id ORDER BY " + rowId);
            while (rs.next()) {
                BlackboardAttribute attr = this.createAttributeFromResultSet(rs);
                attr.setParentDataSourceID(((BlackboardArtifact)artifactMap.get(attr.getArtifactID())).getDataSourceObjectID());
                if (!attributeMap.containsKey(attr.getArtifactID())) {
                    attributeMap.put(attr.getArtifactID(), new ArrayList());
                }
                ((List)attributeMap.get(attr.getArtifactID())).add(attr);
            }
            for (Long artifactID : attributeMap.keySet()) {
                ((BlackboardArtifact)artifactMap.get(artifactID)).setAttributes((List)attributeMap.get(artifactID));
            }
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error loading attributes", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(statement);
                SleuthkitCase.closeConnection(connection);
                this.caseDb.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(statement);
        SleuthkitCase.closeConnection(connection);
        this.caseDb.releaseSingleUserCaseReadLock();
    }

    private BlackboardAttribute createAttributeFromResultSet(ResultSet rs) throws SQLException {
        BlackboardAttribute.Type attributeType;
        int attributeTypeId = rs.getInt("attribute_type_id");
        String attributeTypeName = rs.getString("type_name");
        if (this.typeIdToAttributeTypeMap.containsKey(attributeTypeId)) {
            attributeType = this.typeIdToAttributeTypeMap.get(attributeTypeId);
        } else {
            attributeType = new BlackboardAttribute.Type(attributeTypeId, attributeTypeName, rs.getString("display_name"), BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.fromType(rs.getInt("value_type")));
            this.typeIdToAttributeTypeMap.put(attributeTypeId, attributeType);
            this.typeNameToAttributeTypeMap.put(attributeTypeName, attributeType);
        }
        return new BlackboardAttribute(rs.getLong("artifact_id"), attributeType, rs.getString("source"), rs.getString("context"), rs.getInt("value_int32"), rs.getLong("value_int64"), rs.getDouble("value_double"), rs.getString("value_text"), rs.getBytes("value_byte"), this.caseDb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Beta
    public void updateFileAttributes(long fileObjId, List<Attribute> attributes) throws TskCoreException {
        this.caseDb.acquireSingleUserCaseWriteLock();
        try (SleuthkitCase.CaseDbConnection connection = this.caseDb.getConnection();){
            for (Attribute attr : attributes) {
                String updateString = "UPDATE tsk_file_attributes SET value_byte = ?, value_text = ?, value_int32 = ?,  value_int64 = ?, value_double = ? WHERE attribute_type_id = " + attr.getAttributeType().getTypeID() + " AND obj_id = " + fileObjId;
                try {
                    PreparedStatement preparedStatement = connection.getPreparedStatement(updateString, 2);
                    try {
                        preparedStatement.clearParameters();
                        if (attr.getAttributeType().getValueType() == BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.BYTE) {
                            preparedStatement.setBytes(1, attr.getValueBytes());
                        } else {
                            preparedStatement.setBytes(1, null);
                        }
                        if (attr.getAttributeType().getValueType() == BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING || attr.getAttributeType().getValueType() == BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.JSON) {
                            preparedStatement.setString(2, attr.getValueString());
                        } else {
                            preparedStatement.setString(2, null);
                        }
                        if (attr.getAttributeType().getValueType() == BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.INTEGER) {
                            preparedStatement.setInt(3, attr.getValueInt());
                        } else {
                            preparedStatement.setNull(3, 4);
                        }
                        if (attr.getAttributeType().getValueType() == BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.DATETIME || attr.getAttributeType().getValueType() == BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.LONG) {
                            preparedStatement.setLong(4, attr.getValueLong());
                        } else {
                            preparedStatement.setNull(4, -5);
                        }
                        if (attr.getAttributeType().getValueType() == BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.DOUBLE) {
                            preparedStatement.setDouble(5, attr.getValueDouble());
                        } else {
                            preparedStatement.setNull(5, 8);
                        }
                        connection.executeUpdate(preparedStatement);
                    }
                    finally {
                        if (preparedStatement == null) continue;
                        preparedStatement.close();
                    }
                }
                catch (SQLException ex) {
                    throw new TskCoreException(String.format("Error updating attribute using query = '%s'", updateString), ex);
                    return;
                }
            }
        }
        finally {
            this.caseDb.releaseSingleUserCaseWriteLock();
        }
    }

    ArrayList<Attribute> getFileAttributes(AbstractFile file) throws TskCoreException {
        ArrayList<Attribute> arrayList;
        SleuthkitCase.CaseDbConnection connection = null;
        Statement statement = null;
        ResultSet rs = null;
        this.caseDb.acquireSingleUserCaseReadLock();
        try {
            connection = this.caseDb.getConnection();
            statement = connection.createStatement();
            rs = connection.executeQuery(statement, "SELECT attrs.id as id,  attrs.obj_id AS obj_id, attrs.attribute_type_id AS attribute_type_id, attrs.value_type AS value_type, attrs.value_byte AS value_byte, attrs.value_text AS value_text, attrs.value_int32 AS value_int32, attrs.value_int64 AS value_int64, attrs.value_double AS value_double, types.type_name AS type_name, types.display_name AS display_name FROM tsk_file_attributes AS attrs  INNER JOIN blackboard_attribute_types AS types  ON attrs.attribute_type_id = types.attribute_type_id  WHERE attrs.obj_id = " + file.getId());
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            while (rs.next()) {
                BlackboardAttribute.Type attributeType;
                int attributeTypeId = rs.getInt("attribute_type_id");
                String attributeTypeName = rs.getString("type_name");
                if (this.typeIdToAttributeTypeMap.containsKey(attributeTypeId)) {
                    attributeType = this.typeIdToAttributeTypeMap.get(attributeTypeId);
                } else {
                    attributeType = new BlackboardAttribute.Type(attributeTypeId, attributeTypeName, rs.getString("display_name"), BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.fromType(rs.getInt("value_type")));
                    this.typeIdToAttributeTypeMap.put(attributeTypeId, attributeType);
                    this.typeNameToAttributeTypeMap.put(attributeTypeName, attributeType);
                }
                Attribute attr = new Attribute(rs.getLong("id"), rs.getLong("obj_id"), attributeType, rs.getInt("value_int32"), rs.getLong("value_int64"), rs.getDouble("value_double"), rs.getString("value_text"), rs.getBytes("value_byte"), this.caseDb);
                attributes.add(attr);
            }
            arrayList = attributes;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting attributes for file, file id = " + file.getId(), ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(statement);
                SleuthkitCase.closeConnection(connection);
                this.caseDb.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(statement);
        SleuthkitCase.closeConnection(connection);
        this.caseDb.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initBlackboardArtifactTypes(SleuthkitCase.CaseDbConnection connection) throws SQLException {
        block25: {
            this.caseDb.acquireSingleUserCaseWriteLock();
            try {
                try (Statement getExistingStatement = connection.createStatement();){
                    BlackboardArtifact.ARTIFACT_TYPE[] resultSet = connection.executeQuery(getExistingStatement, "SELECT artifact_type_id, type_name, display_name, category_type FROM blackboard_artifact_types");
                    while (resultSet.next()) {
                        BlackboardArtifact.Type type = new BlackboardArtifact.Type(resultSet.getInt("artifact_type_id"), resultSet.getString("type_name"), resultSet.getString("display_name"), BlackboardArtifact.Category.fromID(resultSet.getInt("category_type")));
                        this.typeIdToArtifactTypeMap.put(type.getTypeID(), type);
                        this.typeNameToArtifactTypeMap.put(type.getTypeName(), type);
                    }
                }
                String insertSql = this.caseDb.getDatabaseType() == TskData.DbType.POSTGRESQL ? "INSERT INTO blackboard_artifact_types (artifact_type_id, type_name, display_name, category_type) VALUES (?, ?, ?, ?) ON CONFLICT DO NOTHING" : "INSERT OR IGNORE INTO blackboard_artifact_types (artifact_type_id, type_name, display_name, category_type) VALUES (?, ?, ?, ?)";
                for (BlackboardArtifact.ARTIFACT_TYPE type : BlackboardArtifact.ARTIFACT_TYPE.values()) {
                    if (this.typeIdToArtifactTypeMap.containsKey(type.getTypeID())) continue;
                    try (PreparedStatement insertArtType = connection.getPreparedStatement(insertSql, 1);){
                        insertArtType.setInt(1, type.getTypeID());
                        insertArtType.setString(2, type.getLabel());
                        insertArtType.setString(3, type.getDisplayName());
                        insertArtType.setInt(4, type.getCategory().getID());
                        insertArtType.executeUpdate();
                    }
                    this.typeIdToArtifactTypeMap.put(type.getTypeID(), new BlackboardArtifact.Type(type));
                    this.typeNameToArtifactTypeMap.put(type.getLabel(), new BlackboardArtifact.Type(type));
                }
                if (this.caseDb.getDatabaseType() != TskData.DbType.POSTGRESQL) break block25;
                int newPrimaryKeyIndex = Collections.max(Arrays.asList(BlackboardArtifact.ARTIFACT_TYPE.values())).getTypeID() + 1;
                try (Statement updateSequenceStatement = connection.createStatement();){
                    updateSequenceStatement.execute("ALTER SEQUENCE blackboard_artifact_types_artifact_type_id_seq RESTART WITH " + newPrimaryKeyIndex);
                }
            }
            finally {
                this.caseDb.releaseSingleUserCaseWriteLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initBlackboardAttributeTypes(SleuthkitCase.CaseDbConnection connection) throws SQLException {
        this.caseDb.acquireSingleUserCaseWriteLock();
        try (Statement statement = connection.createStatement();){
            ResultSet resultSet = connection.executeQuery(statement, "SELECT attribute_type_id, type_name, display_name, value_type FROM blackboard_attribute_types");
            while (resultSet.next()) {
                BlackboardAttribute.Type type = new BlackboardAttribute.Type(resultSet.getInt("attribute_type_id"), resultSet.getString("type_name"), resultSet.getString("display_name"), BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.fromType(resultSet.getLong("value_type")));
                this.typeIdToAttributeTypeMap.put(type.getTypeID(), type);
                this.typeNameToAttributeTypeMap.put(type.getTypeName(), type);
            }
            for (BlackboardAttribute.ATTRIBUTE_TYPE type : BlackboardAttribute.ATTRIBUTE_TYPE.values()) {
                if (this.typeIdToAttributeTypeMap.containsKey(type.getTypeID())) continue;
                if (this.caseDb.getDatabaseType() == TskData.DbType.POSTGRESQL) {
                    statement.execute("INSERT INTO blackboard_attribute_types (attribute_type_id, type_name, display_name, value_type) VALUES (" + type.getTypeID() + ", '" + type.getLabel() + "', '" + type.getDisplayName() + "', '" + type.getValueType().getType() + "') ON CONFLICT DO NOTHING");
                } else {
                    statement.execute("INSERT OR IGNORE INTO blackboard_attribute_types (attribute_type_id, type_name, display_name, value_type) VALUES (" + type.getTypeID() + ", '" + type.getLabel() + "', '" + type.getDisplayName() + "', '" + type.getValueType().getType() + "')");
                }
                this.typeIdToAttributeTypeMap.put(type.getTypeID(), new BlackboardAttribute.Type(type));
                this.typeNameToAttributeTypeMap.put(type.getLabel(), new BlackboardAttribute.Type(type));
            }
            if (this.caseDb.getDatabaseType() == TskData.DbType.POSTGRESQL) {
                int newPrimaryKeyIndex = Collections.max(Arrays.asList(BlackboardAttribute.ATTRIBUTE_TYPE.values())).getTypeID() + 1;
                statement.execute("ALTER SEQUENCE blackboard_attribute_types_attribute_type_id_seq RESTART WITH " + newPrimaryKeyIndex);
            }
        }
        finally {
            this.caseDb.releaseSingleUserCaseWriteLock();
        }
    }

    public AnalysisResultAdded newAnalysisResult(BlackboardArtifact.Type artifactType, long objId, Long dataSourceObjId, Score score, String conclusion, String configuration, String justification, Collection<BlackboardAttribute> attributesList) throws BlackboardException, TskCoreException {
        if (artifactType.getCategory() != BlackboardArtifact.Category.ANALYSIS_RESULT) {
            throw new BlackboardException(String.format("Artifact type (name = %s) is not of Analysis Result category. ", artifactType.getTypeName()));
        }
        SleuthkitCase.CaseDbTransaction transaction = this.caseDb.beginTransaction();
        try {
            AnalysisResultAdded analysisResult = this.newAnalysisResult(artifactType, objId, dataSourceObjId, score, conclusion, configuration, justification, attributesList, transaction);
            transaction.commit();
            return analysisResult;
        }
        catch (BlackboardException | TskCoreException ex) {
            try {
                transaction.rollback();
            }
            catch (TskCoreException ex2) {
                LOGGER.log(Level.SEVERE, "Failed to rollback transaction after exception. Error invoking newAnalysisResult with dataSourceObjId: " + String.valueOf(dataSourceObjId == null ? "<null>" : dataSourceObjId) + ",  sourceObjId: " + objId, ex2);
            }
            throw ex;
        }
    }

    public AnalysisResultAdded newAnalysisResult(BlackboardArtifact.Type artifactType, long objId, Long dataSourceObjId, Score score, String conclusion, String configuration, String justification, Collection<BlackboardAttribute> attributesList, SleuthkitCase.CaseDbTransaction transaction) throws BlackboardException {
        if (artifactType.getCategory() != BlackboardArtifact.Category.ANALYSIS_RESULT) {
            throw new BlackboardException(String.format("Artifact type (name = %s) is not of Analysis Result category. ", artifactType.getTypeName()));
        }
        try {
            AnalysisResult analysisResult = this.caseDb.newAnalysisResult(artifactType, objId, dataSourceObjId, score, conclusion, configuration, justification, transaction.getConnection());
            if (attributesList != null && !attributesList.isEmpty()) {
                analysisResult.addAttributes(attributesList, transaction);
            }
            Score aggregateScore = this.caseDb.getScoringManager().updateAggregateScoreAfterAddition(objId, dataSourceObjId, analysisResult.getScore(), transaction);
            return new AnalysisResultAdded(analysisResult, aggregateScore);
        }
        catch (TskCoreException ex) {
            throw new BlackboardException("Failed to add analysis result.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Score deleteAnalysisResult(AnalysisResult analysisResult) throws TskCoreException {
        SleuthkitCase.CaseDbTransaction transaction = this.caseDb.beginTransaction();
        try {
            Score score = this.deleteAnalysisResult(analysisResult, transaction);
            transaction.commit();
            transaction = null;
            Score score2 = score;
            return score2;
        }
        finally {
            if (transaction != null) {
                transaction.rollback();
            }
        }
    }

    public Score deleteAnalysisResult(long artifactObjId, SleuthkitCase.CaseDbTransaction transaction) throws TskCoreException {
        List<AnalysisResult> analysisResults = this.getAnalysisResultsWhere(" artifacts.artifact_obj_id = " + artifactObjId, transaction.getConnection());
        if (analysisResults.isEmpty()) {
            throw new TskCoreException(String.format("Analysis Result not found for artifact obj id %d", artifactObjId));
        }
        return this.deleteAnalysisResult(analysisResults.get(0), transaction);
    }

    private Score deleteAnalysisResult(AnalysisResult analysisResult, SleuthkitCase.CaseDbTransaction transaction) throws TskCoreException {
        try {
            SleuthkitCase.CaseDbConnection connection = transaction.getConnection();
            String deleteSQL = "DELETE FROM blackboard_artifacts WHERE artifact_obj_id = ?";
            PreparedStatement deleteStatement = connection.getPreparedStatement(deleteSQL, 1);
            deleteStatement.clearParameters();
            deleteStatement.setLong(1, analysisResult.getId());
            deleteStatement.executeUpdate();
            transaction.registerDeletedAnalysisResult(analysisResult.getObjectID());
            return this.caseDb.getScoringManager().updateAggregateScoreAfterDeletion(analysisResult.getObjectID(), analysisResult.getDataSourceObjectID(), transaction);
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error deleting analysis result with artifact obj id %d", analysisResult.getId()), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Score ignoreAnalysisResultScore(AnalysisResult analysisResult, boolean ignore) throws TskCoreException {
        SleuthkitCase.CaseDbTransaction transaction = this.caseDb.beginTransaction();
        try {
            Score score = this.ignoreAnalysisResultScore(analysisResult, ignore, transaction);
            transaction.commit();
            transaction = null;
            Score score2 = score;
            return score2;
        }
        finally {
            if (transaction != null) {
                transaction.rollback();
            }
        }
    }

    public Score ignoreAnalysisResultScore(long artifactObjId, boolean ignore, SleuthkitCase.CaseDbTransaction transaction) throws TskCoreException {
        List<AnalysisResult> analysisResults = this.getAnalysisResultsWhere(" artifacts.artifact_obj_id = " + artifactObjId, transaction.getConnection());
        if (analysisResults.isEmpty()) {
            throw new TskCoreException(String.format("Analysis Result not found for artifact obj id %d", artifactObjId));
        }
        return this.ignoreAnalysisResultScore(analysisResults.get(0), ignore, transaction);
    }

    private Score ignoreAnalysisResultScore(AnalysisResult analysisResult, boolean ignore, SleuthkitCase.CaseDbTransaction transaction) throws TskCoreException {
        try {
            SleuthkitCase.CaseDbConnection connection = transaction.getConnection();
            String query = "UPDATE tsk_analysis_results SET ignore_score = CASE WHEN ? THEN 1 ELSE 0 END WHERE artifact_obj_id = ?";
            PreparedStatement ignoreScoreStatement = connection.getPreparedStatement(query, 1);
            ignoreScoreStatement.clearParameters();
            ignoreScoreStatement.setBoolean(1, ignore);
            ignoreScoreStatement.setLong(2, analysisResult.getId());
            ignoreScoreStatement.executeUpdate();
            return this.caseDb.getScoringManager().updateAggregateScoreAfterDeletion(analysisResult.getObjectID(), analysisResult.getDataSourceObjectID(), transaction);
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error ignoring score of analysis result with artifact obj id %d", analysisResult.getId()), ex);
        }
    }

    public List<AnalysisResult> getAnalysisResultsByType(int artifactTypeId) throws TskCoreException {
        return this.getAnalysisResultsWhere(" artifacts.artifact_type_id = " + artifactTypeId);
    }

    public List<AnalysisResult> getAnalysisResultsByType(int artifactTypeId, long dataSourceObjId) throws TskCoreException {
        return this.getAnalysisResultsWhere(" artifacts.artifact_type_id = " + artifactTypeId + " AND artifacts.data_source_obj_id = " + dataSourceObjId);
    }

    public List<AnalysisResult> getAnalysisResults(long dataSourceObjId, Integer artifactTypeID) throws TskCoreException {
        this.caseDb.acquireSingleUserCaseReadLock();
        try {
            SleuthkitCase.CaseDbConnection connection = this.caseDb.getConnection();
            try {
                String whereClause = " artifacts.data_source_obj_id = " + dataSourceObjId;
                if (artifactTypeID != null) {
                    whereClause = whereClause + " AND artifacts.artifact_type_id = " + artifactTypeID;
                }
                List<AnalysisResult> list = this.getAnalysisResultsWhere(whereClause, connection);
                if (connection != null) {
                    connection.close();
                }
                return list;
            }
            catch (Throwable throwable) {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            this.caseDb.releaseSingleUserCaseReadLock();
        }
    }

    public List<AnalysisResult> getAnalysisResults(long sourceObjId) throws TskCoreException {
        return this.getAnalysisResultsWhere(" artifacts.obj_id = " + sourceObjId);
    }

    List<DataArtifact> getDataArtifactsBySource(long sourceObjId) throws TskCoreException {
        this.caseDb.acquireSingleUserCaseReadLock();
        try {
            SleuthkitCase.CaseDbConnection connection = this.caseDb.getConnection();
            try {
                List<DataArtifact> list = this.getDataArtifactsWhere(String.format(" artifacts.obj_id = %d", sourceObjId), connection);
                if (connection != null) {
                    connection.close();
                }
                return list;
            }
            catch (Throwable throwable) {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            this.caseDb.releaseSingleUserCaseReadLock();
        }
    }

    public boolean hasDataArtifacts(long sourceObjId) throws TskCoreException {
        return this.hasArtifactsOfCategory(BlackboardArtifact.Category.DATA_ARTIFACT, sourceObjId);
    }

    public boolean hasAnalysisResults(long sourceObjId) throws TskCoreException {
        return this.hasArtifactsOfCategory(BlackboardArtifact.Category.ANALYSIS_RESULT, sourceObjId);
    }

    /*
     * Exception decompiling
     */
    private boolean hasArtifactsOfCategory(BlackboardArtifact.Category category, long sourceObjId) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    List<AnalysisResult> getAnalysisResults(long sourceObjId, SleuthkitCase.CaseDbConnection connection) throws TskCoreException {
        return this.getAnalysisResultsWhere(" artifacts.obj_id = " + sourceObjId, connection);
    }

    public List<AnalysisResult> getAnalysisResults(long sourceObjId, int artifactTypeId) throws TskCoreException {
        BlackboardArtifact.Type artifactType = this.getArtifactType(artifactTypeId);
        if (artifactType.getCategory() != BlackboardArtifact.Category.ANALYSIS_RESULT) {
            throw new TskCoreException(String.format("Artifact type id %d is not in analysis result catgeory.", artifactTypeId));
        }
        String whereClause = " types.artifact_type_id = " + artifactTypeId + " AND artifacts.obj_id = " + sourceObjId;
        return this.getAnalysisResultsWhere(whereClause);
    }

    public List<AnalysisResult> getAnalysisResultsWhere(String whereClause) throws TskCoreException {
        this.caseDb.acquireSingleUserCaseReadLock();
        try {
            SleuthkitCase.CaseDbConnection connection = this.caseDb.getConnection();
            try {
                List<AnalysisResult> list = this.getAnalysisResultsWhere(whereClause, connection);
                if (connection != null) {
                    connection.close();
                }
                return list;
            }
            catch (Throwable throwable) {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            this.caseDb.releaseSingleUserCaseReadLock();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    List<AnalysisResult> getAnalysisResultsWhere(String whereClause, SleuthkitCase.CaseDbConnection connection) throws TskCoreException {
        String queryString = ANALYSIS_RESULT_QUERY_STRING_WHERE + " AND " + whereClause;
        try (Statement statement = connection.createStatement();){
            List<AnalysisResult> list;
            block14: {
                ResultSet resultSet = connection.executeQuery(statement, queryString);
                try {
                    List<AnalysisResult> analysisResults;
                    list = analysisResults = this.resultSetToAnalysisResults(resultSet);
                    if (resultSet == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return list;
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error getting analysis results for WHERE clause = '%s'", whereClause), ex);
        }
    }

    public AnalysisResult getAnalysisResultById(long artifactObjId) throws TskCoreException {
        String whereClause = " artifacts.artifact_obj_id = " + artifactObjId;
        List<AnalysisResult> results = this.getAnalysisResultsWhere(whereClause);
        if (results.isEmpty()) {
            throw new TskCoreException(String.format("Error getting analysis result with id = '%d'", artifactObjId));
        }
        if (results.size() > 1) {
            throw new TskCoreException(String.format("Multiple analysis results found with id = '%d'", artifactObjId));
        }
        return results.get(0);
    }

    private List<AnalysisResult> resultSetToAnalysisResults(ResultSet resultSet) throws SQLException, TskCoreException {
        ArrayList<AnalysisResult> analysisResults = new ArrayList<AnalysisResult>();
        while (resultSet.next()) {
            analysisResults.add(new AnalysisResult(this.caseDb, resultSet.getLong("artifact_id"), resultSet.getLong("obj_id"), resultSet.getLong("artifact_obj_id"), resultSet.getObject("data_source_obj_id") != null ? Long.valueOf(resultSet.getLong("data_source_obj_id")) : null, resultSet.getInt("artifact_type_id"), resultSet.getString("type_name"), resultSet.getString("display_name"), BlackboardArtifact.ReviewStatus.withID(resultSet.getInt("review_status_id")), new Score(Score.Significance.fromID(resultSet.getInt("significance")), Score.Priority.fromID(resultSet.getInt("priority"))), resultSet.getString("conclusion"), resultSet.getString("configuration"), resultSet.getString("justification"), resultSet.getBoolean("ignore_score")));
        }
        return analysisResults;
    }

    public List<DataArtifact> getDataArtifacts(long dataSourceObjId, Integer artifactTypeID) throws TskCoreException {
        this.caseDb.acquireSingleUserCaseReadLock();
        try {
            SleuthkitCase.CaseDbConnection connection = this.caseDb.getConnection();
            try {
                String whereClause = " artifacts.data_source_obj_id = " + dataSourceObjId;
                if (artifactTypeID != null) {
                    whereClause = whereClause + " AND artifacts.artifact_type_id = " + artifactTypeID;
                }
                List<DataArtifact> list = this.getDataArtifactsWhere(whereClause, connection);
                if (connection != null) {
                    connection.close();
                }
                return list;
            }
            catch (Throwable throwable) {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            this.caseDb.releaseSingleUserCaseReadLock();
        }
    }

    public List<DataArtifact> getDataArtifacts(int artifactTypeID, long dataSourceObjId) throws TskCoreException {
        BlackboardArtifact.Type artifactType = this.getArtifactType(artifactTypeID);
        if (artifactType.getCategory() != BlackboardArtifact.Category.DATA_ARTIFACT) {
            throw new TskCoreException(String.format("Artifact type id %d is not in data artifact catgeory.", artifactTypeID));
        }
        this.caseDb.acquireSingleUserCaseReadLock();
        try {
            SleuthkitCase.CaseDbConnection connection = this.caseDb.getConnection();
            try {
                String whereClause = "artifacts.data_source_obj_id = " + dataSourceObjId + " AND artifacts.artifact_type_id = " + artifactTypeID;
                List<DataArtifact> list = this.getDataArtifactsWhere(whereClause, connection);
                if (connection != null) {
                    connection.close();
                }
                return list;
            }
            catch (Throwable throwable) {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            this.caseDb.releaseSingleUserCaseReadLock();
        }
    }

    public List<DataArtifact> getDataArtifacts(int artifactTypeID) throws TskCoreException {
        BlackboardArtifact.Type artifactType = this.getArtifactType(artifactTypeID);
        if (artifactType.getCategory() != BlackboardArtifact.Category.DATA_ARTIFACT) {
            throw new TskCoreException(String.format("Artifact type id %d is not in data artifact catgeory.", artifactTypeID));
        }
        this.caseDb.acquireSingleUserCaseReadLock();
        try {
            SleuthkitCase.CaseDbConnection connection = this.caseDb.getConnection();
            try {
                String whereClause = " artifacts.artifact_type_id = " + artifactTypeID;
                List<DataArtifact> list = this.getDataArtifactsWhere(whereClause, connection);
                if (connection != null) {
                    connection.close();
                }
                return list;
            }
            catch (Throwable throwable) {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            this.caseDb.releaseSingleUserCaseReadLock();
        }
    }

    public DataArtifact getDataArtifactById(long artifactObjId) throws TskCoreException {
        this.caseDb.acquireSingleUserCaseReadLock();
        try {
            SleuthkitCase.CaseDbConnection connection = this.caseDb.getConnection();
            try {
                String whereClause = " artifacts.artifact_obj_id = " + artifactObjId;
                List<DataArtifact> artifacts = this.getDataArtifactsWhere(whereClause, connection);
                if (artifacts.isEmpty()) {
                    throw new TskCoreException(String.format("Error getting data artifact with id = '%d'", artifactObjId));
                }
                if (artifacts.size() > 1) {
                    throw new TskCoreException(String.format("Multiple data artifacts found with id = '%d'", artifactObjId));
                }
                DataArtifact dataArtifact = artifacts.get(0);
                if (connection != null) {
                    connection.close();
                }
                return dataArtifact;
            }
            catch (Throwable throwable) {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            this.caseDb.releaseSingleUserCaseReadLock();
        }
    }

    public List<DataArtifact> getDataArtifactsWhere(String whereClause) throws TskCoreException {
        this.caseDb.acquireSingleUserCaseReadLock();
        try {
            SleuthkitCase.CaseDbConnection connection = this.caseDb.getConnection();
            try {
                List<DataArtifact> list = this.getDataArtifactsWhere(whereClause, connection);
                if (connection != null) {
                    connection.close();
                }
                return list;
            }
            catch (Throwable throwable) {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            this.caseDb.releaseSingleUserCaseReadLock();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    List<DataArtifact> getDataArtifactsWhere(String whereClause, SleuthkitCase.CaseDbConnection connection) throws TskCoreException {
        String queryString = DATA_ARTIFACT_QUERY_STRING_WHERE + " AND " + whereClause + " ";
        try (Statement statement = connection.createStatement();){
            List<DataArtifact> list;
            block14: {
                ResultSet resultSet = connection.executeQuery(statement, queryString);
                try {
                    List<DataArtifact> dataArtifacts;
                    list = dataArtifacts = this.resultSetToDataArtifacts(resultSet);
                    if (resultSet == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return list;
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error getting data artifacts with queryString = %s", queryString), ex);
        }
    }

    private List<DataArtifact> resultSetToDataArtifacts(ResultSet resultSet) throws SQLException, TskCoreException {
        ArrayList<DataArtifact> dataArtifacts = new ArrayList<DataArtifact>();
        while (resultSet.next()) {
            Long osAccountObjId = resultSet.getLong("os_account_obj_id");
            if (resultSet.wasNull()) {
                osAccountObjId = null;
            }
            dataArtifacts.add(new DataArtifact(this.caseDb, resultSet.getLong("artifact_id"), resultSet.getLong("obj_id"), resultSet.getLong("artifact_obj_id"), resultSet.getObject("data_source_obj_id") != null ? Long.valueOf(resultSet.getLong("data_source_obj_id")) : null, resultSet.getInt("artifact_type_id"), resultSet.getString("type_name"), resultSet.getString("display_name"), BlackboardArtifact.ReviewStatus.withID(resultSet.getInt("review_status_id")), osAccountObjId, false));
        }
        return dataArtifacts;
    }

    public synchronized BlackboardAttribute.Type getOrAddAttributeType(String typeName, BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE valueType, String displayName) throws BlackboardException {
        if (this.typeNameToAttributeTypeMap.containsKey(typeName)) {
            return this.typeNameToAttributeTypeMap.get(typeName);
        }
        SleuthkitCase.CaseDbTransaction trans = null;
        try {
            trans = this.caseDb.beginTransaction();
            String matchingAttrQuery = "SELECT attribute_type_id, type_name, display_name, value_type FROM blackboard_attribute_types WHERE type_name = ?";
            PreparedStatement query = trans.getConnection().getPreparedStatement(matchingAttrQuery, 1);
            query.clearParameters();
            query.setString(1, typeName);
            try (ResultSet rs = query.executeQuery();){
                if (rs.next()) {
                    trans.commit();
                    trans = null;
                    BlackboardAttribute.Type foundType = new BlackboardAttribute.Type(rs.getInt("attribute_type_id"), rs.getString("type_name"), rs.getString("display_name"), BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.fromType(rs.getLong("value_type")));
                    this.typeIdToAttributeTypeMap.put(foundType.getTypeID(), foundType);
                    this.typeNameToAttributeTypeMap.put(foundType.getTypeName(), foundType);
                    BlackboardAttribute.Type type = foundType;
                    return type;
                }
            }
            String insertStatement = "INSERT INTO blackboard_attribute_types (attribute_type_id, type_name, display_name, value_type) VALUES (\n(SELECT MAX(q.attribute_type_id) FROM (SELECT attribute_type_id FROM blackboard_attribute_types UNION SELECT 9999) q) + 1,\n?, ?, ?)";
            PreparedStatement insertPreparedStatement = trans.getConnection().getPreparedStatement(insertStatement, 1);
            insertPreparedStatement.clearParameters();
            insertPreparedStatement.setString(1, typeName);
            insertPreparedStatement.setString(2, displayName);
            insertPreparedStatement.setLong(3, valueType.getType());
            int numUpdated = insertPreparedStatement.executeUpdate();
            Integer attrId = null;
            if (numUpdated > 0) {
                try (ResultSet insertResult = insertPreparedStatement.getGeneratedKeys();){
                    if (insertResult.next()) {
                        attrId = insertResult.getInt(1);
                    }
                }
            }
            if (attrId == null) {
                throw new BlackboardException(MessageFormat.format("Error adding attribute type.  Item with name {0} was not inserted successfully into the database.", typeName));
            }
            trans.commit();
            trans = null;
            BlackboardAttribute.Type type = new BlackboardAttribute.Type(attrId, typeName, displayName, valueType);
            this.typeIdToAttributeTypeMap.put(type.getTypeID(), type);
            this.typeNameToAttributeTypeMap.put(type.getTypeName(), type);
            BlackboardAttribute.Type type2 = type;
            return type2;
        }
        catch (SQLException | TskCoreException ex) {
            throw new BlackboardException("Error adding attribute type: " + typeName, ex);
        }
        finally {
            try {
                if (trans != null) {
                    trans.rollback();
                    trans = null;
                }
            }
            catch (TskCoreException ex2) {
                LOGGER.log(Level.SEVERE, "Error rolling back transaction", ex2);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public List<BlackboardArtifact.Type> getArtifactTypesInUse(long dataSourceObjId) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public long getArtifactsCount(int artifactTypeID, long dataSourceObjId) throws TskCoreException {
        return this.getArtifactsCountHelper(artifactTypeID, "blackboard_artifacts.data_source_obj_id = '" + dataSourceObjId + "';");
    }

    public long getArtifactsCount(int artifactTypeID) throws TskCoreException {
        return this.getArtifactsCountHelper(artifactTypeID, null);
    }

    public List<BlackboardArtifact> getArtifacts(int artifactTypeID, long dataSourceObjId) throws TskCoreException {
        String whereClause = String.format("artifacts.data_source_obj_id = %d", dataSourceObjId);
        return this.getArtifactsWhere(this.getArtifactType(artifactTypeID), whereClause);
    }

    public List<BlackboardArtifact> getArtifacts(Collection<BlackboardArtifact.Type> artifactTypes, Collection<Long> dataSourceObjIds) throws TskCoreException {
        if (artifactTypes.isEmpty() || dataSourceObjIds.isEmpty()) {
            return new ArrayList<BlackboardArtifact>();
        }
        Object analysisResultQuery = "";
        Object dataArtifactQuery = "";
        for (BlackboardArtifact.Type type : artifactTypes) {
            if (type.getCategory() == BlackboardArtifact.Category.ANALYSIS_RESULT) {
                if (!((String)analysisResultQuery).isEmpty()) {
                    analysisResultQuery = (String)analysisResultQuery + " OR ";
                }
                analysisResultQuery = (String)analysisResultQuery + "types.artifact_type_id = " + type.getTypeID();
                continue;
            }
            if (!((String)dataArtifactQuery).isEmpty()) {
                dataArtifactQuery = (String)dataArtifactQuery + " OR ";
            }
            dataArtifactQuery = (String)dataArtifactQuery + "types.artifact_type_id = " + type.getTypeID();
        }
        Object dsQuery = "";
        for (long dsId : dataSourceObjIds) {
            if (!((String)dsQuery).isEmpty()) {
                dsQuery = (String)dsQuery + " OR ";
            }
            dsQuery = (String)dsQuery + "artifacts.data_source_obj_id = " + dsId;
        }
        ArrayList<BlackboardArtifact> arrayList = new ArrayList<BlackboardArtifact>();
        if (!((String)analysisResultQuery).isEmpty()) {
            String fullQuery = "( " + (String)analysisResultQuery + " ) AND (" + (String)dsQuery + ") ";
            arrayList.addAll(this.getAnalysisResultsWhere(fullQuery));
        }
        if (!((String)dataArtifactQuery).isEmpty()) {
            String fullQuery = "( " + (String)dataArtifactQuery + " ) AND (" + (String)dsQuery + ") ";
            arrayList.addAll(this.getDataArtifactsWhere(fullQuery));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BlackboardArtifact> getArtifacts(BlackboardArtifact.Type artifactType, BlackboardAttribute.Type attributeType, String value, Long dataSourceObjId, boolean showRejected) throws TskCoreException {
        String query = " AND artifacts.artifact_type_id = " + artifactType.getTypeID() + " AND attributes.attribute_type_id = " + attributeType.getTypeID() + (String)(value == null || value.isEmpty() ? "" : " AND attributes.value_text = '" + value + "'") + (String)(showRejected ? "" : " AND artifacts.review_status_id != " + BlackboardArtifact.ReviewStatus.REJECTED.getID()) + (String)(dataSourceObjId != null ? " AND artifacts.data_source_obj_id = " + dataSourceObjId : "");
        ArrayList<BlackboardArtifact> artifacts = new ArrayList<BlackboardArtifact>();
        this.caseDb.acquireSingleUserCaseReadLock();
        String finalQuery = artifactType.getCategory() == BlackboardArtifact.Category.ANALYSIS_RESULT ? ANALYSIS_RESULT_QUERY_STRING_WITH_ATTRIBUTES + query : DATA_ARTIFACT_QUERY_STRING_WITH_ATTRIBUTES + query;
        try (SleuthkitCase.CaseDbConnection connection = this.caseDb.getConnection();){
            try (Statement statement = connection.createStatement();
                 ResultSet resultSet = connection.executeQuery(statement, finalQuery);){
                if (artifactType.getCategory() == BlackboardArtifact.Category.ANALYSIS_RESULT) {
                    artifacts.addAll(this.resultSetToAnalysisResults(resultSet));
                } else {
                    artifacts.addAll(this.resultSetToDataArtifacts(resultSet));
                }
            }
            catch (SQLException ex) {
                throw new TskCoreException(String.format("Error getting results with queryString = '%s'", finalQuery), ex);
            }
        }
        finally {
            this.caseDb.releaseSingleUserCaseReadLock();
        }
        return artifacts;
    }

    public List<BlackboardArtifact> getExactMatchKeywordSearchResults(String keyword, TskData.KeywordSearchQueryType searchType, String kwsListName, Long dataSourceId) throws TskCoreException {
        return this.getKeywordSearchResults(keyword, "", searchType, kwsListName, dataSourceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BlackboardArtifact> getKeywordSearchResults(String keyword, String regex, TskData.KeywordSearchQueryType searchType, String kwsListName, Long dataSourceId) throws TskCoreException {
        String dataSourceClause = dataSourceId == null ? "" : " AND artifacts.data_source_obj_id = ? ";
        String kwsListClause = kwsListName == null || kwsListName.isEmpty() ? " WHERE r.set_name IS NULL " : " WHERE r.set_name = ? ";
        String keywordClause = keyword == null || keyword.isEmpty() ? "" : " AND r.keyword = ? ";
        String searchTypeClause = searchType == null ? "" : " AND r.search_type = ? ";
        String regexClause = regex == null || regex.isEmpty() ? "" : " AND r.regexp_str = ? ";
        String query = "SELECT r.* FROM (  SELECT DISTINCT artifacts.artifact_id AS artifact_id,  artifacts.obj_id AS obj_id,  artifacts.artifact_obj_id AS artifact_obj_id,  artifacts.data_source_obj_id AS data_source_obj_id,  artifacts.artifact_type_id AS artifact_type_id,  types.type_name AS type_name,  types.display_name AS display_name,  types.category_type as category_type, artifacts.review_status_id AS review_status_id,  results.conclusion AS conclusion,  results.significance AS significance,  results.priority AS priority,  results.configuration AS configuration,  results.justification AS justification,  (SELECT value_text FROM blackboard_attributes attr WHERE attr.artifact_id = artifacts.artifact_id AND attr.attribute_type_id = " + BlackboardAttribute.Type.TSK_SET_NAME.getTypeID() + " LIMIT 1) AS set_name,  (SELECT value_int32 FROM blackboard_attributes attr WHERE attr.artifact_id = artifacts.artifact_id AND attr.attribute_type_id = " + BlackboardAttribute.ATTRIBUTE_TYPE.TSK_KEYWORD_SEARCH_TYPE.getTypeID() + " LIMIT 1) AS search_type,  (SELECT value_text FROM blackboard_attributes attr WHERE attr.artifact_id = artifacts.artifact_id AND attr.attribute_type_id = " + BlackboardAttribute.Type.TSK_KEYWORD_REGEXP.getTypeID() + " LIMIT 1) AS regexp_str,  (SELECT value_text FROM blackboard_attributes attr WHERE attr.artifact_id = artifacts.artifact_id AND attr.attribute_type_id = " + BlackboardAttribute.Type.TSK_KEYWORD.getTypeID() + " LIMIT 1) AS keyword  FROM blackboard_artifacts artifacts  JOIN blackboard_artifact_types AS types  ON artifacts.artifact_type_id = types.artifact_type_id  LEFT JOIN tsk_analysis_results AS results  ON artifacts.artifact_obj_id = results.artifact_obj_id  WHERE types.category_type = " + BlackboardArtifact.Category.ANALYSIS_RESULT.getID() + " AND artifacts.artifact_type_id = " + BlackboardArtifact.Type.TSK_KEYWORD_HIT.getTypeID() + " " + dataSourceClause + " ) r " + kwsListClause + keywordClause + searchTypeClause + regexClause;
        ArrayList<BlackboardArtifact> artifacts = new ArrayList<BlackboardArtifact>();
        this.caseDb.acquireSingleUserCaseReadLock();
        try (SleuthkitCase.CaseDbConnection connection = this.caseDb.getConnection();){
            try {
                PreparedStatement preparedStatement = connection.getPreparedStatement(query, 1);
                preparedStatement.clearParameters();
                int paramIdx = 0;
                if (dataSourceId != null) {
                    preparedStatement.setLong(++paramIdx, dataSourceId);
                }
                if (kwsListName != null && !kwsListName.isEmpty()) {
                    preparedStatement.setString(++paramIdx, kwsListName);
                }
                if (keyword != null && !keyword.isEmpty()) {
                    preparedStatement.setString(++paramIdx, keyword);
                }
                if (searchType != null) {
                    preparedStatement.setInt(++paramIdx, searchType.getType());
                }
                if (regex != null && !regex.isEmpty()) {
                    preparedStatement.setString(++paramIdx, regex);
                }
                try (ResultSet resultSet = connection.executeQuery(preparedStatement);){
                    artifacts.addAll(this.resultSetToAnalysisResults(resultSet));
                }
            }
            catch (SQLException ex) {
                throw new TskCoreException(String.format("Error getting keyword search results with queryString = '%s'", query), ex);
            }
        }
        finally {
            this.caseDb.releaseSingleUserCaseReadLock();
        }
        return artifacts;
    }

    /*
     * Exception decompiling
     */
    private long getArtifactsCountHelper(int artifactTypeID, String whereClause) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean artifactExists(Content content, BlackboardArtifact.Type artifactType, Collection<BlackboardAttribute> attributes) throws TskCoreException {
        ArrayList<BlackboardArtifact> existingArtifacts = content.getArtifacts(artifactType.getTypeID());
        for (BlackboardArtifact artifact : existingArtifacts) {
            if (!this.attributesMatch(artifact.getAttributes(), attributes)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean artifactExists(Content content, BlackboardArtifact.ARTIFACT_TYPE artifactType, Collection<BlackboardAttribute> attributes) throws TskCoreException {
        return this.artifactExists(content, this.getArtifactType(artifactType.getTypeID()), attributes);
    }

    private boolean attributesMatch(Collection<BlackboardAttribute> fileAttributesList, Collection<BlackboardAttribute> expectedAttributesList) {
        for (BlackboardAttribute expectedAttribute : expectedAttributesList) {
            boolean match = false;
            for (BlackboardAttribute fileAttribute : fileAttributesList) {
                Object fileAttributeValue;
                BlackboardAttribute.Type attributeType = fileAttribute.getAttributeType();
                if (attributeType.getTypeID() != expectedAttribute.getAttributeType().getTypeID()) continue;
                Object expectedAttributeValue = switch (attributeType.getValueType()) {
                    case BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.BYTE -> {
                        fileAttributeValue = fileAttribute.getValueBytes();
                        yield expectedAttribute.getValueBytes();
                    }
                    case BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.DOUBLE -> {
                        fileAttributeValue = fileAttribute.getValueDouble();
                        yield (Object)expectedAttribute.getValueDouble();
                    }
                    case BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.INTEGER -> {
                        fileAttributeValue = fileAttribute.getValueInt();
                        yield (Object)expectedAttribute.getValueInt();
                    }
                    case BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.LONG, BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.DATETIME -> {
                        fileAttributeValue = fileAttribute.getValueLong();
                        yield (Object)expectedAttribute.getValueLong();
                    }
                    case BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING, BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.JSON -> {
                        fileAttributeValue = fileAttribute.getValueString();
                        yield (Object)expectedAttribute.getValueString();
                    }
                    default -> {
                        fileAttributeValue = fileAttribute.getDisplayString();
                        yield (Object)expectedAttribute.getDisplayString();
                    }
                };
                if (fileAttributeValue instanceof byte[]) {
                    if (!Arrays.equals((byte[])fileAttributeValue, expectedAttributeValue)) continue;
                    match = true;
                    break;
                }
                if (!fileAttributeValue.equals(expectedAttributeValue)) continue;
                match = true;
                break;
            }
            if (match) continue;
            return false;
        }
        return true;
    }

    public DataArtifact newDataArtifact(BlackboardArtifact.Type artifactType, long sourceObjId, Long dataSourceObjId, Collection<BlackboardAttribute> attributes, Long osAccountId) throws TskCoreException {
        if (artifactType.getCategory() != BlackboardArtifact.Category.DATA_ARTIFACT) {
            throw new TskCoreException(String.format("Artifact type (name = %s) is not of Data Artifact category. ", artifactType.getTypeName()));
        }
        SleuthkitCase.CaseDbTransaction transaction = this.caseDb.beginTransaction();
        try {
            DataArtifact dataArtifact = this.newDataArtifact(artifactType, sourceObjId, dataSourceObjId, attributes, osAccountId, transaction);
            transaction.commit();
            return dataArtifact;
        }
        catch (TskCoreException ex) {
            try {
                transaction.rollback();
            }
            catch (TskCoreException ex2) {
                LOGGER.log(Level.SEVERE, "Failed to rollback transaction after exception. Error invoking newDataArtifact with dataSourceObjId: " + dataSourceObjId + ",  sourceObjId: " + sourceObjId, ex2);
            }
            throw ex;
        }
    }

    public DataArtifact newDataArtifact(BlackboardArtifact.Type artifactType, long sourceObjId, Long dataSourceObjId, Collection<BlackboardAttribute> attributes, Long osAccountObjId, SleuthkitCase.CaseDbTransaction transaction) throws TskCoreException {
        return this.newDataArtifact(artifactType, sourceObjId, dataSourceObjId, attributes, osAccountObjId, OsAccountInstance.OsAccountInstanceType.ACCESSED, transaction);
    }

    public DataArtifact newDataArtifact(BlackboardArtifact.Type artifactType, long sourceObjId, Long dataSourceObjId, Collection<BlackboardAttribute> attributes, Long osAccountObjId, OsAccountInstance.OsAccountInstanceType osAccountInstanceType, SleuthkitCase.CaseDbTransaction transaction) throws TskCoreException {
        DataArtifact dataArtifact;
        block12: {
            if (artifactType.getCategory() != BlackboardArtifact.Category.DATA_ARTIFACT) {
                throw new TskCoreException(String.format("Artifact type (name = %s) is not of Data Artifact category. ", artifactType.getTypeName()));
            }
            SleuthkitCase.CaseDbConnection connection = transaction.getConnection();
            long artifact_obj_id = this.caseDb.addObject(sourceObjId, TskData.ObjectType.ARTIFACT.getObjectType(), connection);
            PreparedStatement statement = this.caseDb.createInsertArtifactStatement(artifactType.getTypeID(), sourceObjId, artifact_obj_id, dataSourceObjId, connection);
            connection.executeUpdate(statement);
            ResultSet resultSet = statement.getGeneratedKeys();
            try {
                resultSet.next();
                DataArtifact dataArtifact2 = new DataArtifact(this.caseDb, resultSet.getLong(1), sourceObjId, artifact_obj_id, dataSourceObjId, artifactType.getTypeID(), artifactType.getTypeName(), artifactType.getDisplayName(), BlackboardArtifact.ReviewStatus.UNDECIDED, osAccountObjId, true);
                if (osAccountObjId != null) {
                    String insertDataArtifactSQL = "INSERT INTO tsk_data_artifacts (artifact_obj_id, os_account_obj_id) VALUES (?, ?)";
                    statement = connection.getPreparedStatement(insertDataArtifactSQL, 2);
                    statement.clearParameters();
                    statement.setLong(1, artifact_obj_id);
                    statement.setLong(2, osAccountObjId);
                    connection.executeUpdate(statement);
                    if (Objects.nonNull((Object)osAccountInstanceType)) {
                        this.caseDb.getOsAccountManager().newOsAccountInstance(osAccountObjId, dataSourceObjId, osAccountInstanceType, connection);
                    }
                }
                if (Objects.nonNull(attributes) && !attributes.isEmpty()) {
                    dataArtifact2.addAttributes(attributes, transaction);
                }
                dataArtifact = dataArtifact2;
                if (resultSet == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new TskCoreException(String.format("Error creating a data artifact with type id = %d, objId = %d, and data source oj id = %d ", artifactType.getTypeID(), sourceObjId, dataSourceObjId), ex);
                }
            }
            resultSet.close();
        }
        return dataArtifact;
    }

    List<BlackboardArtifact> getArtifactsBySourceId(BlackboardArtifact.Type artifactType, long sourceObjId) throws TskCoreException {
        String whereClause = String.format("artifacts.obj_id = %d", sourceObjId);
        return this.getArtifactsWhere(artifactType, whereClause);
    }

    List<BlackboardArtifact> getArtifactsByType(BlackboardArtifact.Type artifactType) throws TskCoreException {
        ArrayList<BlackboardArtifact> artifacts = new ArrayList<BlackboardArtifact>();
        if (artifactType.getCategory() == BlackboardArtifact.Category.ANALYSIS_RESULT) {
            artifacts.addAll(this.getAnalysisResultsByType(artifactType.getTypeID()));
        } else {
            artifacts.addAll(this.getDataArtifacts(artifactType.getTypeID()));
        }
        return artifacts;
    }

    private List<BlackboardArtifact> getArtifactsWhere(BlackboardArtifact.Type artifactType, String whereClause) throws TskCoreException {
        ArrayList<BlackboardArtifact> artifacts = new ArrayList<BlackboardArtifact>();
        String whereWithType = whereClause + " AND artifacts.artifact_type_id = " + artifactType.getTypeID();
        if (artifactType.getCategory() == BlackboardArtifact.Category.ANALYSIS_RESULT) {
            artifacts.addAll(this.getAnalysisResultsWhere(whereWithType));
        } else {
            artifacts.addAll(this.getDataArtifactsWhere(whereWithType));
        }
        return artifacts;
    }

    public static final class BlackboardException
    extends Exception {
        private static final long serialVersionUID = 1L;

        BlackboardException(String message) {
            super(message);
        }

        BlackboardException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public final class ArtifactsPostedEvent {
        private final String moduleName;
        private final ImmutableSet<BlackboardArtifact.Type> artifactTypes;
        private final ImmutableSet<BlackboardArtifact> artifacts;
        private final Long ingestJobId;

        private ArtifactsPostedEvent(Blackboard this$0, Collection<BlackboardArtifact> artifacts, String moduleName, Long ingestJobId) throws BlackboardException {
            Set typeIDS = artifacts.stream().map(BlackboardArtifact::getArtifactTypeID).collect(Collectors.toSet());
            HashSet<BlackboardArtifact.Type> types = new HashSet<BlackboardArtifact.Type>();
            for (Integer typeID : typeIDS) {
                try {
                    types.add(this$0.getArtifactType(typeID));
                }
                catch (TskCoreException tskCoreException) {
                    throw new BlackboardException("Error getting artifact type by id.", tskCoreException);
                }
            }
            this.artifactTypes = ImmutableSet.copyOf(types);
            this.artifacts = ImmutableSet.copyOf(artifacts);
            this.moduleName = moduleName;
            this.ingestJobId = ingestJobId;
        }

        public Collection<BlackboardArtifact> getArtifacts() {
            return ImmutableSet.copyOf(this.artifacts);
        }

        public Collection<BlackboardArtifact> getArtifacts(BlackboardArtifact.Type artifactType) {
            Set tempSet = this.artifacts.stream().filter(artifact -> artifact.getArtifactTypeID() == artifactType.getTypeID()).collect(Collectors.toSet());
            return ImmutableSet.copyOf(tempSet);
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public Collection<BlackboardArtifact.Type> getArtifactTypes() {
            return ImmutableSet.copyOf(this.artifactTypes);
        }

        public Optional<Long> getIngestJobId() {
            return Optional.ofNullable(this.ingestJobId);
        }
    }
}

