/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sleuthkit.datamodel.Account;
import org.sleuthkit.datamodel.CommManagerSqlStringUtils;
import org.sleuthkit.datamodel.CommunicationsManager;
import org.sleuthkit.datamodel.Relationship;
import org.sleuthkit.datamodel.TskCoreException;

public final class CommunicationsFilter {
    private final List<SubFilter> andFilters;

    public CommunicationsFilter() {
        this(Collections.emptyList());
    }

    CommunicationsFilter(List<? extends SubFilter> andSubFilters) {
        this.andFilters = new ArrayList<SubFilter>(andSubFilters);
    }

    public List<SubFilter> getAndFilters() {
        return Collections.unmodifiableList(this.andFilters);
    }

    public void addAndFilter(SubFilter subFilter) {
        this.andFilters.add(subFilter);
    }

    public static final class MostRecentFilter
    extends SubFilter {
        private final int limit;

        public MostRecentFilter(int limit) {
            this.limit = limit;
        }

        public int getLimit() {
            return this.limit;
        }

        @Override
        public String getDescription() {
            return "Filters accounts and relationships by the most recent given relationships.";
        }

        @Override
        String getSQL(CommunicationsManager commsManager) {
            if (this.limit > 0) {
                return "ORDER BY relationships.date_time DESC LIMIT " + this.limit;
            }
            return "";
        }
    }

    public static final class DeviceFilter
    extends SubFilter {
        private final Set<String> deviceIds;

        public DeviceFilter(Collection<String> deviceIds) {
            this.deviceIds = new HashSet<String>(deviceIds);
        }

        @Override
        public String getDescription() {
            return "Filters accounts and relationships by device id.";
        }

        public Collection<String> getDevices() {
            return this.deviceIds;
        }

        @Override
        public String getSQL(CommunicationsManager commsManager) {
            if (this.deviceIds.isEmpty()) {
                return "";
            }
            Object sql = "";
            ArrayList<Long> ds_ids = new ArrayList<Long>();
            for (String deviceId : this.deviceIds) {
                try {
                    ds_ids.addAll(commsManager.getSleuthkitCase().getDataSourceObjIds(deviceId));
                }
                catch (TskCoreException ex) {
                    Logger.getLogger(DeviceFilter.class.getName()).log(Level.WARNING, "failed to get datasource object ids for deviceId", ex);
                }
            }
            String datasource_obj_ids_list = CommManagerSqlStringUtils.buildCSVString(ds_ids);
            if (!datasource_obj_ids_list.isEmpty()) {
                sql = " relationships.data_source_obj_id IN ( " + datasource_obj_ids_list + " )";
            }
            return sql;
        }
    }

    public static final class AccountTypeFilter
    extends SubFilter {
        private final Set<Account.Type> accountTypes;

        public AccountTypeFilter(Collection<Account.Type> accountTypes) {
            this.accountTypes = new HashSet<Account.Type>(accountTypes);
        }

        public Set<Account.Type> getAccountTypes() {
            return this.accountTypes;
        }

        @Override
        public String getDescription() {
            return "Filters accounts and relationships by account type.";
        }

        @Override
        public String getSQL(CommunicationsManager commsManager) {
            if (this.accountTypes.isEmpty()) {
                return "";
            }
            ArrayList<Integer> type_ids = new ArrayList<Integer>();
            for (Account.Type accountType : this.accountTypes) {
                type_ids.add(commsManager.getAccountTypeId(accountType));
            }
            String account_type_ids_list = CommManagerSqlStringUtils.buildCSVString(type_ids);
            return " account_types.account_type_id IN ( " + account_type_ids_list + " )";
        }
    }

    public static final class DateRangeFilter
    extends SubFilter {
        private final long startDate;
        private final long endDate;
        private static final long SECS_PER_DAY = 86400L;

        public DateRangeFilter(long startDate, long endDate) {
            this.startDate = startDate;
            this.endDate = endDate > 0L ? endDate + 86400L : endDate;
        }

        public long getStartDate() {
            return this.startDate;
        }

        public long getEndDate() {
            return this.endDate;
        }

        @Override
        public String getDescription() {
            return "Filters communications by date range.";
        }

        @Override
        public String getSQL(CommunicationsManager commsManager) {
            if (0L == this.startDate && 0L == this.endDate) {
                return "";
            }
            Object sql = "";
            if (this.startDate > 0L) {
                sql = "( relationships.date_time IS NULL OR relationships.date_time >= " + this.startDate + ")";
            }
            if (this.endDate > 0L) {
                if (!((String)sql).isEmpty()) {
                    sql = (String)sql + " AND ";
                }
                sql = (String)sql + "( relationships.date_time IS NULL OR relationships.date_time < " + this.endDate + ")";
            }
            return sql;
        }
    }

    public static final class RelationshipTypeFilter
    extends SubFilter {
        private final Set<Relationship.Type> relationshipTypes;

        public RelationshipTypeFilter(Collection<Relationship.Type> relationshipTypes) {
            this.relationshipTypes = new HashSet<Relationship.Type>(relationshipTypes);
        }

        @Override
        public String getDescription() {
            return "Filters relationships by relationship type.";
        }

        @Override
        public String getSQL(CommunicationsManager commsManager) {
            if (this.relationshipTypes.isEmpty()) {
                return "";
            }
            ArrayList<Integer> relationShipTypeIds = new ArrayList<Integer>();
            for (Relationship.Type relType : this.relationshipTypes) {
                relationShipTypeIds.add(relType.getTypeID());
            }
            return " relationships.relationship_type IN ( " + CommManagerSqlStringUtils.buildCSVString(relationShipTypeIds) + " )";
        }
    }

    public static abstract class SubFilter {
        public abstract String getDescription();

        abstract String getSQL(CommunicationsManager var1);
    }
}

