/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.util.Objects;
import org.sleuthkit.datamodel.AbstractContent;
import org.sleuthkit.datamodel.ContentVisitor;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.SleuthkitItemVisitor;
import org.sleuthkit.datamodel.TskCoreException;

public final class HostAddress
extends AbstractContent {
    private final SleuthkitCase sleuthkitCase;
    private final long id;
    private final HostAddressType addressType;
    private final String address;

    HostAddress(SleuthkitCase skCase, long id, HostAddressType type, String address) {
        super(skCase, id, address + "(" + type.getName() + ")");
        this.sleuthkitCase = skCase;
        this.id = id;
        this.addressType = type;
        this.address = address;
    }

    @Override
    public long getId() {
        return this.id;
    }

    public HostAddressType getAddressType() {
        return this.addressType;
    }

    public String getAddress() {
        return this.address;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + (int)(this.id ^ this.id >>> 32);
        hash = 53 * hash + Objects.hashCode((Object)this.addressType);
        hash = 53 * hash + Objects.hashCode(this.address);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HostAddress other = (HostAddress)obj;
        if (this.id != other.id) {
            return false;
        }
        if (this.addressType != other.addressType) {
            return false;
        }
        return !(this.address == null ? other.address != null : !this.address.equals(other.address));
    }

    @Override
    public SleuthkitCase getSleuthkitCase() {
        return this.sleuthkitCase;
    }

    @Override
    public int read(byte[] buf, long offset, long len) throws TskCoreException {
        return 0;
    }

    @Override
    public void close() {
    }

    @Override
    public long getSize() {
        return 0L;
    }

    @Override
    public <T> T accept(ContentVisitor<T> v) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> T accept(SleuthkitItemVisitor<T> v) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static enum HostAddressType {
        DNS_AUTO(0, "DNS Auto Detection"),
        HOSTNAME(1, "Host Name"),
        IPV4(2, "IPv4"),
        IPV6(3, "IPv6"),
        ETHERNET_MAC(4, "Ethernet MAC"),
        WIFI_MAC(5, "WiFi MAC"),
        BLUETOOTH_MAC(6, "BlueTooth MAC");

        private final int id;
        private final String name;

        private HostAddressType(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        String getName() {
            return this.name;
        }

        public static HostAddressType fromID(int typeId) {
            for (HostAddressType type : HostAddressType.values()) {
                if (type.ordinal() != typeId) continue;
                return type;
            }
            return null;
        }
    }
}

