/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.util.ResourceBundle;

public final class IngestModuleInfo {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org.sleuthkit.datamodel.Bundle");
    private final long ingestModuleId;
    private final String displayName;
    private final String uniqueName;
    private final IngestModuleType type;
    private final String version;

    IngestModuleInfo(long ingestModuleId, String displayName, String uniqueName, IngestModuleType type, String version) {
        this.ingestModuleId = ingestModuleId;
        this.displayName = displayName;
        this.uniqueName = uniqueName;
        this.type = type;
        this.version = version;
    }

    public long getIngestModuleId() {
        return this.ingestModuleId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public IngestModuleType getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public static enum IngestModuleType {
        DATA_SOURCE_LEVEL(bundle.getString("IngestModuleInfo.IngestModuleType.DataSourceLevel.displayName")),
        FILE_LEVEL(bundle.getString("IngestModuleInfo.IngestModuleType.FileLevel.displayName")),
        DATA_ARTIFACT(bundle.getString("IngestModuleInfo.IngestModuleType.DataArtifact.displayName")),
        MULTIPLE("IngestModuleInfo.IngestModuleType.Multiple.displayName"),
        ANALYSIS_RESULT(bundle.getString("IngestModuleInfo.IngestModuleType.AnalysisResult.displayName"));

        private final String displayName;

        private IngestModuleType(String displayName) {
            this.displayName = displayName;
        }

        public static IngestModuleType fromID(int typeId) {
            for (IngestModuleType moduleType : IngestModuleType.values()) {
                if (moduleType.ordinal() != typeId) continue;
                return moduleType;
            }
            return null;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

