/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sleuthkit.datamodel.AbstractFile;
import org.sleuthkit.datamodel.Content;
import org.sleuthkit.datamodel.ContentVisitor;
import org.sleuthkit.datamodel.Image;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.SleuthkitItemVisitor;
import org.sleuthkit.datamodel.SleuthkitJNI;
import org.sleuthkit.datamodel.TskCoreException;
import org.sleuthkit.datamodel.TskData;
import org.sleuthkit.datamodel.TskFileRange;

public class LayoutFile
extends AbstractFile {
    private long imageHandle = -1L;

    LayoutFile(SleuthkitCase db, long objId, long dataSourceObjectId, Long fileSystemObjectId, String name, TskData.TSK_DB_FILES_TYPE_ENUM fileType, TskData.TSK_FS_NAME_TYPE_ENUM dirType, TskData.TSK_FS_META_TYPE_ENUM metaType, TskData.TSK_FS_NAME_FLAG_ENUM dirFlag, short metaFlags, long size, long ctime, long crtime, long atime, long mtime, String md5Hash, String sha256Hash, String sha1Hash, TskData.FileKnown knownState, String parentPath, String mimeType, String ownerUid, Long osAccountObjId) {
        super(db, objId, dataSourceObjectId, fileSystemObjectId, TskData.TSK_FS_ATTR_TYPE_ENUM.TSK_FS_ATTR_TYPE_DEFAULT, 0, name, fileType, 0L, 0, dirType, metaType, dirFlag, metaFlags, size, ctime, crtime, atime, mtime, (short)0, 0, 0, md5Hash, sha256Hash, sha1Hash, knownState, parentPath, mimeType, SleuthkitCase.extractExtension(name), ownerUid, osAccountObjId, TskData.CollectedStatus.UNKNOWN, Collections.emptyList());
    }

    public int getNumParts() {
        int numParts = 0;
        try {
            numParts = this.getRanges().size();
        }
        catch (TskCoreException ex) {
            Logger.getLogger(LayoutFile.class.getName()).log(Level.SEVERE, String.format("Error getting layout ranges for layout file (objId = %d)", this.getId()), ex);
        }
        return numParts;
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public void close() {
    }

    @Override
    protected int readInt(byte[] buf, long offset, long len) throws TskCoreException {
        long offsetInThisLayoutContent = 0L;
        int bytesRead = 0;
        long readLen = len;
        if (offset + readLen > this.size) {
            readLen = this.size - offset;
        }
        if (this.imageHandle == -1L) {
            Content dataSource = this.getDataSource();
            if (dataSource != null && dataSource instanceof Image) {
                Image image = (Image)dataSource;
                this.imageHandle = image.getImageHandle();
            } else {
                throw new TskCoreException("Data Source of LayoutFile is not Image");
            }
        }
        for (TskFileRange range : this.getRanges()) {
            if ((long)bytesRead >= readLen) break;
            if (offset < offsetInThisLayoutContent + range.getByteLen()) {
                long offsetInRange = 0L;
                if (bytesRead == 0) {
                    offsetInRange = offset - offsetInThisLayoutContent;
                }
                long offsetInImage = range.getByteStart() + offsetInRange;
                long lenToReadInRange = Math.min(range.getByteLen() - offsetInRange, readLen - (long)bytesRead);
                int lenRead = this.readImgToOffset(this.imageHandle, buf, bytesRead, offsetInImage, (int)lenToReadInRange);
                bytesRead += lenRead;
                if (lenToReadInRange != (long)lenRead) break;
            }
            offsetInThisLayoutContent += range.getByteLen();
        }
        return bytesRead;
    }

    private int readImgToOffset(long imgHandle, byte[] buf, int offsetInBuf, long offsetInImage, int lenToRead) throws TskCoreException {
        byte[] currentBuffer = new byte[lenToRead];
        int lenRead = SleuthkitJNI.readImg(imgHandle, currentBuffer, offsetInImage, lenToRead);
        System.arraycopy(currentBuffer, 0, buf, offsetInBuf, lenToRead);
        return lenRead;
    }

    @Override
    public <T> T accept(ContentVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <T> T accept(SleuthkitItemVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public String toString(boolean preserveState) {
        return super.toString(preserveState) + "LayoutFile [\t]\t";
    }
}

