/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sleuthkit.datamodel.AbstractContent;
import org.sleuthkit.datamodel.Content;
import org.sleuthkit.datamodel.ContentVisitor;
import org.sleuthkit.datamodel.Image;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.SleuthkitItemVisitor;
import org.sleuthkit.datamodel.SleuthkitJNI;
import org.sleuthkit.datamodel.TskCoreException;
import org.sleuthkit.datamodel.TskData;
import org.sleuthkit.datamodel.Volume;
import org.sleuthkit.datamodel.VolumeSystem;

public class Pool
extends AbstractContent {
    private static final Logger logger = Logger.getLogger(Pool.class.getName());
    private volatile long poolHandle = 0L;
    private final long type;

    protected Pool(SleuthkitCase db, long obj_id, String name, long type) {
        super(db, obj_id, name);
        this.type = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] readBuffer, long offset, long len) throws TskCoreException {
        Pool pool = this;
        synchronized (pool) {
            if (this.poolHandle == 0L) {
                this.getPoolHandle();
            }
        }
        return SleuthkitJNI.readPool(this.poolHandle, readBuffer, offset, len);
    }

    @Override
    public long getSize() {
        try {
            return this.getParent().getSize();
        }
        catch (TskCoreException ex) {
            logger.log(Level.SEVERE, "Error getting parent of pool with obj ID {0}", this.getId());
            return 0L;
        }
    }

    public TskData.TSK_POOL_TYPE_ENUM getType() {
        return TskData.TSK_POOL_TYPE_ENUM.valueOf(this.type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getPoolHandle() throws TskCoreException {
        if (this.poolHandle == 0L) {
            Pool pool = this;
            synchronized (pool) {
                if (this.poolHandle == 0L) {
                    Content dataSource = this.getDataSource();
                    if (dataSource != null && dataSource instanceof Image) {
                        Image image = (Image)dataSource;
                        this.poolHandle = SleuthkitJNI.openPool(image.getImageHandle(), this.getPoolOffset(image), this.getSleuthkitCase());
                    } else {
                        throw new TskCoreException("Data Source of pool is not an image");
                    }
                }
            }
        }
        return this.poolHandle;
    }

    private long getPoolOffset(Image image) throws TskCoreException {
        if (this.getParent() instanceof Image) {
            return 0L;
        }
        if (this.getParent() instanceof Volume) {
            Volume parent = (Volume)this.getParent();
            if (parent.getParent() instanceof VolumeSystem) {
                return parent.getStart() * ((VolumeSystem)parent.getParent()).getBlockSize();
            }
            return parent.getStart() * image.getSsize();
        }
        throw new TskCoreException("Pool with object ID " + this.getId() + " does not have Image or Volume parent");
    }

    @Override
    public void close() {
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public <T> T accept(SleuthkitItemVisitor<T> v) {
        return v.visit(this);
    }

    @Override
    public <T> T accept(ContentVisitor<T> v) {
        return v.visit(this);
    }

    @Override
    public List<Content> getChildren() throws TskCoreException {
        return this.getSleuthkitCase().getPoolChildren(this);
    }

    @Override
    public List<Long> getChildrenIds() throws TskCoreException {
        return this.getSleuthkitCase().getPoolChildrenIds(this);
    }

    @Override
    public String toString(boolean preserveState) {
        return super.toString(preserveState) + "Pool [\ttype " + this.type + "]\t";
    }
}

