/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import com.google.common.annotations.Beta;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableSet;
import com.google.common.eventbus.EventBus;
import com.google.gson.Gson;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.mchange.v2.c3p0.DataSources;
import com.mchange.v2.c3p0.PooledDataSource;
import com.zaxxer.sparsebits.SparseBitSet;
import java.beans.PropertyVetoException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.postgresql.util.PSQLState;
import org.sleuthkit.datamodel.AbstractContent;
import org.sleuthkit.datamodel.AbstractFile;
import org.sleuthkit.datamodel.AnalysisResult;
import org.sleuthkit.datamodel.Attribute;
import org.sleuthkit.datamodel.Blackboard;
import org.sleuthkit.datamodel.BlackboardArtifact;
import org.sleuthkit.datamodel.BlackboardArtifactTag;
import org.sleuthkit.datamodel.BlackboardAttribute;
import org.sleuthkit.datamodel.CarvedFileContainer;
import org.sleuthkit.datamodel.CarvingResult;
import org.sleuthkit.datamodel.CaseDatabaseFactory;
import org.sleuthkit.datamodel.CaseDbAccessManager;
import org.sleuthkit.datamodel.CaseDbConnectionInfo;
import org.sleuthkit.datamodel.CaseDbSchemaVersionNumber;
import org.sleuthkit.datamodel.CommunicationsManager;
import org.sleuthkit.datamodel.Content;
import org.sleuthkit.datamodel.ContentStreamProvider;
import org.sleuthkit.datamodel.ContentTag;
import org.sleuthkit.datamodel.DataArtifact;
import org.sleuthkit.datamodel.DataSource;
import org.sleuthkit.datamodel.DerivedFile;
import org.sleuthkit.datamodel.Directory;
import org.sleuthkit.datamodel.Examiner;
import org.sleuthkit.datamodel.File;
import org.sleuthkit.datamodel.FileManager;
import org.sleuthkit.datamodel.FileSystem;
import org.sleuthkit.datamodel.FsContent;
import org.sleuthkit.datamodel.Host;
import org.sleuthkit.datamodel.HostAddressManager;
import org.sleuthkit.datamodel.HostManager;
import org.sleuthkit.datamodel.Image;
import org.sleuthkit.datamodel.IngestJobInfo;
import org.sleuthkit.datamodel.IngestModuleInfo;
import org.sleuthkit.datamodel.LayoutFile;
import org.sleuthkit.datamodel.LocalDirectory;
import org.sleuthkit.datamodel.LocalFile;
import org.sleuthkit.datamodel.LocalFilesDataSource;
import org.sleuthkit.datamodel.LockResources;
import org.sleuthkit.datamodel.OsAccount;
import org.sleuthkit.datamodel.OsAccountInstance;
import org.sleuthkit.datamodel.OsAccountManager;
import org.sleuthkit.datamodel.OsAccountRealmManager;
import org.sleuthkit.datamodel.PersonManager;
import org.sleuthkit.datamodel.Pool;
import org.sleuthkit.datamodel.Report;
import org.sleuthkit.datamodel.Score;
import org.sleuthkit.datamodel.ScoreChange;
import org.sleuthkit.datamodel.ScoringManager;
import org.sleuthkit.datamodel.SlackFile;
import org.sleuthkit.datamodel.SleuthkitJNI;
import org.sleuthkit.datamodel.Tag;
import org.sleuthkit.datamodel.TagName;
import org.sleuthkit.datamodel.TaggingManager;
import org.sleuthkit.datamodel.TimelineManager;
import org.sleuthkit.datamodel.TskCoreException;
import org.sleuthkit.datamodel.TskData;
import org.sleuthkit.datamodel.TskDataException;
import org.sleuthkit.datamodel.TskEvent;
import org.sleuthkit.datamodel.TskFileRange;
import org.sleuthkit.datamodel.TskUnsupportedSchemaVersionException;
import org.sleuthkit.datamodel.UnsupportedContent;
import org.sleuthkit.datamodel.VersionNumber;
import org.sleuthkit.datamodel.VirtualDirectory;
import org.sleuthkit.datamodel.Volume;
import org.sleuthkit.datamodel.VolumeSystem;
import org.sqlite.SQLiteConfig;
import org.sqlite.SQLiteDataSource;
import org.sqlite.SQLiteJDBCLoader;

public class SleuthkitCase {
    private static final int MAX_DB_NAME_LEN_BEFORE_TIMESTAMP = 47;
    static final CaseDbSchemaVersionNumber CURRENT_DB_SCHEMA_VERSION = new CaseDbSchemaVersionNumber(9, 6);
    private static final long BASE_ARTIFACT_ID = Long.MIN_VALUE;
    private static final Logger logger = Logger.getLogger(SleuthkitCase.class.getName());
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org.sleuthkit.datamodel.Bundle");
    private static final int IS_REACHABLE_TIMEOUT_MS = 1000;
    private static final String SQL_ERROR_CONNECTION_GROUP = "08";
    private static final String SQL_CONNECTION_REJECTED = "08004";
    private static final String UNABLE_TO_VERIFY_SSL = "08006";
    private static final String SQL_ERROR_AUTHENTICATION_GROUP = "28";
    private static final String SQL_ERROR_PRIVILEGE_GROUP = "42";
    private static final String SQL_ERROR_RESOURCE_GROUP = "53";
    private static final String SQL_ERROR_LIMIT_GROUP = "54";
    private static final String SQL_ERROR_INTERNAL_GROUP = "xx";
    private static final Set<String> CORE_TABLE_NAMES = ImmutableSet.of((Object)"tsk_events", (Object)"tsk_event_descriptions", (Object)"tsk_event_types", (Object)"tsk_db_info", (Object)"tsk_objects", (Object)"tsk_image_info", (Object[])new String[]{"tsk_image_names", "tsk_vs_info", "tsk_vs_parts", "tsk_fs_info", "tsk_file_layout", "tsk_files", "tsk_files_path", "tsk_files_derived", "tsk_files_derived_method", "tag_names", "content_tags", "blackboard_artifact_tags", "blackboard_artifacts", "blackboard_attributes", "blackboard_artifact_types", "blackboard_attribute_types", "data_source_info", "file_encoding_types", "file_collection_status_types", "ingest_module_types", "ingest_job_status_types", "ingest_modules", "ingest_jobs", "ingest_job_modules", "account_types", "accounts", "account_relationships", "review_statuses", "reports,"});
    private static final Set<String> CORE_INDEX_NAMES = ImmutableSet.of((Object)"parObjId", (Object)"layout_objID", (Object)"artifact_objID", (Object)"artifact_artifact_objID", (Object)"artifact_typeID", (Object)"attrsArtifactID", (Object[])new String[]{"mime_type", "file_extension", "relationships_account1", "relationships_account2", "relationships_relationship_source_obj_id", "relationships_date_time", "relationships_relationship_type", "relationships_data_source_obj_id", "events_time", "events_type", "events_data_source_obj_id", "events_file_obj_id", "events_artifact_id"});
    private static final String TSK_VERSION_KEY = "TSK_VER";
    private static final String SCHEMA_MAJOR_VERSION_KEY = "SCHEMA_MAJOR_VERSION";
    private static final String SCHEMA_MINOR_VERSION_KEY = "SCHEMA_MINOR_VERSION";
    private static final String CREATION_SCHEMA_MAJOR_VERSION_KEY = "CREATION_SCHEMA_MAJOR_VERSION";
    private static final String CREATION_SCHEMA_MINOR_VERSION_KEY = "CREATION_SCHEMA_MINOR_VERSION";
    static final String IMAGE_PASSWORD_KEY = "imagePassword";
    private final ConnectionPool connections;
    private final Object carvedFileDirsLock = new Object();
    private static final int MAX_CARVED_FILES_PER_FOLDER = 2000;
    private final Map<Long, CarvedFileDirInfo> rootIdsToCarvedFileDirs = new HashMap<Long, CarvedFileDirInfo>();
    private final Map<Long, FileSystem> fileSystemIdMap = new HashMap<Long, FileSystem>();
    private final List<ErrorObserver> sleuthkitCaseErrorObservers = new ArrayList<ErrorObserver>();
    private final String databaseName;
    private final String dbPath;
    private final TskData.DbType dbType;
    private final String caseDirPath;
    private SleuthkitJNI.CaseDbHandle caseHandle;
    private final String caseHandleIdentifier;
    private String dbBackupPath;
    private AtomicBoolean timelineEventsDisabled = new AtomicBoolean(false);
    private CaseDbSchemaVersionNumber caseDBSchemaCreationVersion;
    private final Object rootDirectoryMapLock = new Object();
    private final Map<RootDirectoryKey, Long> rootDirectoryMap = new HashMap<RootDirectoryKey, Long>();
    private final Cache<Long, Boolean> isRootDirectoryCache = CacheBuilder.newBuilder().maximumSize(200000L).expireAfterAccess(5L, TimeUnit.MINUTES).build();
    private final ContentStreamProvider contentProvider;
    private final LockResources lockResources;
    private final Map<Long, SparseBitSet> hasChildrenBitSetMap = new HashMap<Long, SparseBitSet>();
    private final ReentrantLock childrenBitSetLock = new ReentrantLock();
    private final CountDownLatch childrenBitSetInitLatch = new CountDownLatch(1);
    private long nextArtifactId;
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock(true);
    private CommunicationsManager communicationsMgr;
    private TimelineManager timelineMgr;
    private Blackboard blackboard;
    private CaseDbAccessManager dbAccessManager;
    private FileManager fileManager;
    private TaggingManager taggingMgr;
    private ScoringManager scoringManager;
    private OsAccountRealmManager osAccountRealmManager;
    private OsAccountManager osAccountManager;
    private HostManager hostManager;
    private PersonManager personManager;
    private HostAddressManager hostAddressManager;
    private final Map<String, Set<Long>> deviceIdToDatasourceObjIdMap = new HashMap<String, Set<Long>>();
    private final EventBus eventBus = new EventBus("SleuthkitCase-EventBus");
    private final Map<Long, Content> frequentlyUsedContentMap = new HashMap<Long, Content>();
    private Examiner cachedCurrentExaminer = null;

    public void registerForEvents(Object listener) {
        this.eventBus.register(listener);
    }

    public void unregisterForEvents(Object listener) {
        this.eventBus.unregister(listener);
    }

    void fireTSKEvent(Object event) {
        this.eventBus.post(event);
    }

    public static void tryConnect(CaseDbConnectionInfo info) throws TskCoreException {
        if (info.getHost() == null || info.getHost().isEmpty()) {
            throw new TskCoreException(bundle.getString("DatabaseConnectionCheck.MissingHostname"));
        }
        if (info.getPort() == null || info.getPort().isEmpty()) {
            throw new TskCoreException(bundle.getString("DatabaseConnectionCheck.MissingPort"));
        }
        if (info.getUserName() == null || info.getUserName().isEmpty()) {
            throw new TskCoreException(bundle.getString("DatabaseConnectionCheck.MissingUsername"));
        }
        if (info.getPassword() == null || info.getPassword().isEmpty()) {
            throw new TskCoreException(bundle.getString("DatabaseConnectionCheck.MissingPassword"));
        }
        try {
            Connection conn;
            Class.forName("org.postgresql.Driver");
            String connectionURL = "jdbc:postgresql://" + info.getHost() + ":" + info.getPort() + "/postgres";
            if (info.isSslEnabled()) {
                connectionURL = info.isSslVerify() ? (info.getCustomSslValidationClassName().isBlank() ? connectionURL + "?ssl=true&sslfactory=org.postgresql.ssl.DefaultJavaSSLFactory&sslmode=verify-ca" : connectionURL + CaseDatabaseFactory.getCustomPostrgesSslVerificationUrl(info.getCustomSslValidationClassName())) : connectionURL + "?ssl=true&sslfactory=org.postgresql.ssl.NonValidatingFactory&sslmode=require";
            }
            if ((conn = DriverManager.getConnection(connectionURL, info.getUserName(), info.getPassword())) != null) {
                conn.close();
            }
        }
        catch (SQLException ex) {
            String result;
            block18: {
                String sqlState = ex.getSQLState().toLowerCase();
                if (sqlState.startsWith(SQL_ERROR_CONNECTION_GROUP)) {
                    if (SQL_CONNECTION_REJECTED.equals(ex.getSQLState())) {
                        result = info.isSslEnabled() ? "Server rejected the SSL connection attempt. Check SSL configuration." : "Server rejected the connection attempt. Check server configuration.";
                    } else if (UNABLE_TO_VERIFY_SSL.equals(ex.getSQLState())) {
                        result = "Unable to verify SSL certificates. Check SSL configuration.";
                    } else {
                        try {
                            if (InetAddress.getByName(info.getHost()).isReachable(1000)) {
                                result = bundle.getString("DatabaseConnectionCheck.Port");
                                break block18;
                            }
                            result = bundle.getString("DatabaseConnectionCheck.HostnameOrPort");
                        }
                        catch (IOException | MissingResourceException any) {
                            result = bundle.getString("DatabaseConnectionCheck.Everything");
                        }
                    }
                } else {
                    result = sqlState.startsWith(SQL_ERROR_AUTHENTICATION_GROUP) ? bundle.getString("DatabaseConnectionCheck.Authentication") : (sqlState.startsWith(SQL_ERROR_PRIVILEGE_GROUP) ? bundle.getString("DatabaseConnectionCheck.Access") : (sqlState.startsWith(SQL_ERROR_RESOURCE_GROUP) ? bundle.getString("DatabaseConnectionCheck.ServerDiskSpace") : (sqlState.startsWith(SQL_ERROR_LIMIT_GROUP) ? bundle.getString("DatabaseConnectionCheck.ServerRestart") : (sqlState.startsWith(SQL_ERROR_INTERNAL_GROUP) ? bundle.getString("DatabaseConnectionCheck.InternalServerIssue") : bundle.getString("DatabaseConnectionCheck.Connection")))));
                }
            }
            throw new TskCoreException(result);
        }
        catch (ClassNotFoundException ex) {
            throw new TskCoreException(bundle.getString("DatabaseConnectionCheck.Installation"));
        }
    }

    private SleuthkitCase(String dbPath, SleuthkitJNI.CaseDbHandle caseHandle, TskData.DbType dbType, ContentStreamProvider contentProvider, String lockingApplicationName, boolean useWAL) throws Exception {
        Class.forName("org.sqlite.JDBC");
        this.dbPath = dbPath;
        this.dbType = dbType;
        java.io.File dbFile = new java.io.File(dbPath);
        this.caseDirPath = dbFile.getParentFile().getAbsolutePath();
        this.databaseName = dbFile.getName();
        this.lockResources = lockingApplicationName == null ? null : LockResources.tryAcquireFileLock(this.caseDirPath, this.databaseName, lockingApplicationName);
        this.connections = new SQLiteConnections(dbPath, useWAL);
        this.caseHandle = caseHandle;
        this.caseHandleIdentifier = caseHandle.getCaseDbIdentifier();
        this.contentProvider = contentProvider;
        this.init();
        this.logSQLiteJDBCDriverInfo();
    }

    private SleuthkitCase(CaseDbConnectionInfo info, String dbName, SleuthkitJNI.CaseDbHandle caseHandle, String caseDirPath, ContentStreamProvider contentProvider) throws Exception {
        this.dbPath = "";
        this.databaseName = dbName;
        this.dbType = info.getDbType();
        this.caseDirPath = caseDirPath;
        this.connections = new PostgreSQLConnections(info, dbName);
        this.caseHandle = caseHandle;
        this.caseHandleIdentifier = caseHandle.getCaseDbIdentifier();
        this.contentProvider = contentProvider;
        this.lockResources = null;
        this.init();
    }

    private void init() throws Exception {
        this.blackboard = new Blackboard(this);
        this.updateDatabaseSchema(null);
        try (CaseDbConnection connection = this.connections.getConnection();){
            this.blackboard.initBlackboardArtifactTypes(connection);
            this.blackboard.initBlackboardAttributeTypes(connection);
            this.initNextArtifactId(connection);
            this.initIngestModuleTypes(connection);
            this.initIngestStatusTypes(connection);
            this.initReviewStatuses(connection);
            this.initEncodingTypes(connection);
            this.initCollectedStatusTypes(connection);
            this.populateHasChildrenMap(true);
            this.updateExaminers(connection);
            this.initDBSchemaCreationVersion(connection);
        }
        this.fileManager = new FileManager(this);
        this.communicationsMgr = new CommunicationsManager(this);
        this.timelineMgr = new TimelineManager(this);
        this.dbAccessManager = new CaseDbAccessManager(this);
        this.taggingMgr = new TaggingManager(this);
        this.scoringManager = new ScoringManager(this);
        this.osAccountRealmManager = new OsAccountRealmManager(this);
        this.osAccountManager = new OsAccountManager(this);
        this.hostManager = new HostManager(this);
        this.personManager = new PersonManager(this);
        this.hostAddressManager = new HostAddressManager(this);
    }

    ContentStreamProvider getContentProvider() {
        return this.contentProvider;
    }

    static Set<String> getCoreTableNames() {
        return Collections.unmodifiableSet(CORE_TABLE_NAMES);
    }

    static Set<String> getCoreIndexNames() {
        return Collections.unmodifiableSet(CORE_INDEX_NAMES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getHasChildren(Content content) {
        try {
            this.childrenBitSetInitLatch.await();
        }
        catch (InterruptedException ex) {
            throw new AssertionError("Interrupted Exception awaiting Children bit set initialization", ex);
        }
        this.childrenBitSetLock.lock();
        try {
            long objId = content.getId();
            long mapIndex = objId / Integer.MAX_VALUE;
            int mapValue = (int)(objId % Integer.MAX_VALUE);
            if (this.hasChildrenBitSetMap.containsKey(mapIndex)) {
                boolean bl = this.hasChildrenBitSetMap.get(mapIndex).get(mapValue);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.childrenBitSetLock.unlock();
        }
    }

    private void setHasChildren(Long objId) {
        this.setHasChildren(objId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHasChildren(Long objId, boolean initializing) {
        try {
            if (!initializing) {
                this.childrenBitSetInitLatch.await();
            }
        }
        catch (InterruptedException ex) {
            throw new AssertionError("Interrupted Exception awaiting Children bit set initialization", ex);
        }
        this.childrenBitSetLock.lock();
        try {
            long mapIndex = objId / Integer.MAX_VALUE;
            int mapValue = (int)(objId % Integer.MAX_VALUE);
            if (this.hasChildrenBitSetMap.containsKey(mapIndex)) {
                this.hasChildrenBitSetMap.get(mapIndex).set(mapValue);
            } else {
                SparseBitSet bitSet = new SparseBitSet();
                bitSet.set(mapValue);
                this.hasChildrenBitSetMap.put(mapIndex, bitSet);
            }
        }
        finally {
            this.childrenBitSetLock.unlock();
        }
    }

    public CommunicationsManager getCommunicationsManager() throws TskCoreException {
        return this.communicationsMgr;
    }

    public Blackboard getBlackboard() {
        return this.blackboard;
    }

    public FileManager getFileManager() {
        return this.fileManager;
    }

    public TimelineManager getTimelineManager() throws TskCoreException {
        return this.timelineMgr;
    }

    public synchronized CaseDbAccessManager getCaseDbAccessManager() throws TskCoreException {
        return this.dbAccessManager;
    }

    public synchronized TaggingManager getTaggingManager() {
        return this.taggingMgr;
    }

    public ScoringManager getScoringManager() throws TskCoreException {
        return this.scoringManager;
    }

    public OsAccountRealmManager getOsAccountRealmManager() throws TskCoreException {
        return this.osAccountRealmManager;
    }

    public OsAccountManager getOsAccountManager() throws TskCoreException {
        return this.osAccountManager;
    }

    public HostManager getHostManager() throws TskCoreException {
        return this.hostManager;
    }

    public PersonManager getPersonManager() throws TskCoreException {
        return this.personManager;
    }

    public HostAddressManager getHostAddressManager() throws TskCoreException {
        return this.hostAddressManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initNextArtifactId(CaseDbConnection connection) throws SQLException {
        this.acquireSingleUserCaseReadLock();
        try (Statement statement = connection.createStatement();){
            ResultSet resultSet = connection.executeQuery(statement, "SELECT MAX(artifact_id) AS max_artifact_id FROM blackboard_artifacts");
            resultSet.next();
            this.nextArtifactId = resultSet.getLong("max_artifact_id") + 1L;
            if (this.nextArtifactId == 1L) {
                this.nextArtifactId = Long.MIN_VALUE;
            }
        }
        finally {
            this.releaseSingleUserCaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initIngestModuleTypes(CaseDbConnection connection) throws SQLException, TskCoreException {
        Statement statement = null;
        ResultSet resultSet = null;
        this.acquireSingleUserCaseWriteLock();
        try {
            statement = connection.createStatement();
            for (IngestModuleInfo.IngestModuleType type : IngestModuleInfo.IngestModuleType.values()) {
                try {
                    String query = "INSERT INTO ingest_module_types (type_id, type_name) VALUES (" + type.ordinal() + ", '" + type.toString() + "')";
                    if (this.getDatabaseType().equals((Object)TskData.DbType.POSTGRESQL)) {
                        query = query + " ON CONFLICT ON CONSTRAINT ingest_module_types_pkey DO NOTHING";
                    }
                    statement.execute(query);
                }
                catch (SQLException ex) {
                    resultSet = connection.executeQuery(statement, "SELECT COUNT(*) as count FROM ingest_module_types WHERE type_id = " + type.ordinal() + ";");
                    resultSet.next();
                    if (resultSet.getLong("count") == 0L) {
                        throw ex;
                    }
                    resultSet.close();
                    resultSet = null;
                }
            }
        }
        finally {
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeStatement(statement);
            this.releaseSingleUserCaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initIngestStatusTypes(CaseDbConnection connection) throws SQLException, TskCoreException {
        Statement statement = null;
        ResultSet resultSet = null;
        this.acquireSingleUserCaseWriteLock();
        try {
            statement = connection.createStatement();
            for (IngestJobInfo.IngestJobStatusType type : IngestJobInfo.IngestJobStatusType.values()) {
                try {
                    String query = "INSERT INTO ingest_job_status_types (type_id, type_name) VALUES (" + type.ordinal() + ", '" + type.toString() + "')";
                    if (this.getDatabaseType().equals((Object)TskData.DbType.POSTGRESQL)) {
                        query = query + " ON CONFLICT ON CONSTRAINT ingest_job_status_types_pkey DO NOTHING";
                    }
                    statement.execute(query);
                }
                catch (SQLException ex) {
                    resultSet = connection.executeQuery(statement, "SELECT COUNT(*) as count FROM ingest_job_status_types WHERE type_id = " + type.ordinal() + ";");
                    resultSet.next();
                    if (resultSet.getLong("count") == 0L) {
                        throw ex;
                    }
                    resultSet.close();
                    resultSet = null;
                }
            }
        }
        finally {
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeStatement(statement);
            this.releaseSingleUserCaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initReviewStatuses(CaseDbConnection connection) throws SQLException, TskCoreException {
        Statement statement = null;
        ResultSet resultSet = null;
        this.acquireSingleUserCaseWriteLock();
        try {
            statement = connection.createStatement();
            for (BlackboardArtifact.ReviewStatus status : BlackboardArtifact.ReviewStatus.values()) {
                try {
                    String query = "INSERT INTO review_statuses (review_status_id, review_status_name, display_name) VALUES (" + status.getID() + ",'" + status.getName() + "','" + status.getDisplayName() + "')";
                    if (this.getDatabaseType().equals((Object)TskData.DbType.POSTGRESQL)) {
                        query = query + " ON CONFLICT ON CONSTRAINT review_statuses_pkey DO NOTHING";
                    }
                    statement.execute(query);
                }
                catch (SQLException ex) {
                    resultSet = connection.executeQuery(statement, "SELECT COUNT(*) as count FROM review_statuses WHERE review_status_id = " + status.getID());
                    resultSet.next();
                    if (resultSet.getLong("count") == 0L) {
                        throw ex;
                    }
                    resultSet.close();
                    resultSet = null;
                }
            }
        }
        finally {
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeStatement(statement);
            this.releaseSingleUserCaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initEncodingTypes(CaseDbConnection connection) throws SQLException, TskCoreException {
        Statement statement = null;
        ResultSet resultSet = null;
        this.acquireSingleUserCaseWriteLock();
        try {
            statement = connection.createStatement();
            for (TskData.EncodingType type : TskData.EncodingType.values()) {
                try {
                    String query = "INSERT INTO file_encoding_types (encoding_type, name) VALUES (" + type.getType() + " , '" + type.name() + "')";
                    if (this.getDatabaseType().equals((Object)TskData.DbType.POSTGRESQL)) {
                        query = query + " ON CONFLICT ON CONSTRAINT file_encoding_types_pkey DO NOTHING";
                    }
                    statement.execute(query);
                }
                catch (SQLException ex) {
                    resultSet = connection.executeQuery(statement, "SELECT COUNT(*) as count FROM file_encoding_types WHERE encoding_type = " + type.getType());
                    resultSet.next();
                    if (resultSet.getLong("count") == 0L) {
                        throw ex;
                    }
                    resultSet.close();
                    resultSet = null;
                }
            }
        }
        finally {
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeStatement(statement);
            this.releaseSingleUserCaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCollectedStatusTypes(CaseDbConnection connection) throws SQLException, TskCoreException {
        Statement statement = null;
        ResultSet resultSet = null;
        this.acquireSingleUserCaseWriteLock();
        try {
            statement = connection.createStatement();
            for (TskData.CollectedStatus type : TskData.CollectedStatus.values()) {
                try {
                    String query = "INSERT INTO file_collection_status_types (collection_status_type, name) VALUES (" + type.getType() + " , '" + type.name() + "')";
                    if (this.getDatabaseType().equals((Object)TskData.DbType.POSTGRESQL)) {
                        query = query + " ON CONFLICT ON CONSTRAINT file_collection_status_types_pkey DO NOTHING";
                    }
                    statement.execute(query);
                }
                catch (SQLException ex) {
                    resultSet = connection.executeQuery(statement, "SELECT COUNT(*) as count FROM file_collection_status_types WHERE collection_status_type = " + type.getType());
                    resultSet.next();
                    if (resultSet.getLong("count") == 0L) {
                        throw ex;
                    }
                    resultSet.close();
                    resultSet = null;
                }
            }
        }
        finally {
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeStatement(statement);
            this.releaseSingleUserCaseWriteLock();
        }
    }

    private void updateExaminers(CaseDbConnection connection) throws SQLException, TskCoreException {
        String loginName = System.getProperty("user.name");
        if (loginName.isEmpty()) {
            logger.log(Level.SEVERE, "Cannot determine logged in user name");
            return;
        }
        this.acquireSingleUserCaseWriteLock();
        try {
            PreparedStatement statement = switch (this.getDatabaseType()) {
                case TskData.DbType.POSTGRESQL -> connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_EXAMINER_POSTGRESQL);
                case TskData.DbType.SQLITE -> connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_EXAMINER_SQLITE);
                default -> throw new TskCoreException("Unknown DB Type: " + this.getDatabaseType().name());
            };
            statement.clearParameters();
            statement.setString(1, loginName);
            connection.executeUpdate(statement);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error inserting row in tsk_examiners. login name: " + loginName, ex);
        }
        finally {
            this.releaseSingleUserCaseWriteLock();
        }
    }

    private void populateHasChildrenMap(boolean async) throws TskCoreException {
        Runnable childrenBitSetLockInitRunnable = () -> {
            this.childrenBitSetLock.lock();
            long timestamp = System.currentTimeMillis();
            Statement statement = null;
            ResultSet resultSet = null;
            this.acquireSingleUserCaseWriteLock();
            try (CaseDbConnection neoConnection = this.connections.getConnection();){
                statement = neoConnection.createStatement();
                String query = "select distinct par_obj_id from tsk_objects";
                if (this.dbType == TskData.DbType.POSTGRESQL) {
                    query = "select distinct ON (par_obj_id) par_obj_id from tsk_objects";
                }
                resultSet = statement.executeQuery(query);
                while (resultSet.next()) {
                    this.setHasChildren(resultSet.getLong("par_obj_id"), true);
                }
                long delay = System.currentTimeMillis() - timestamp;
                logger.log(Level.INFO, "Time to initialize parent node cache: {0} ms", delay);
            }
            catch (SQLException ex) {
                try {
                    logger.log(Level.SEVERE, "Error populating parent node cache", ex);
                    throw new AssertionError("Error populating parent node cache", ex);
                    catch (TskCoreException ex2) {
                        logger.log(Level.SEVERE, "Error acquiring connection", ex2);
                        throw new AssertionError("Error acquiring connection", ex2);
                    }
                }
                catch (Throwable throwable) {
                    SleuthkitCase.closeResultSet(resultSet);
                    SleuthkitCase.closeStatement(statement);
                    this.releaseSingleUserCaseWriteLock();
                    this.childrenBitSetLock.unlock();
                    this.childrenBitSetInitLatch.countDown();
                    throw throwable;
                }
            }
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeStatement(statement);
            this.releaseSingleUserCaseWriteLock();
            this.childrenBitSetLock.unlock();
            this.childrenBitSetInitLatch.countDown();
        };
        if (async) {
            CompletableFuture.runAsync(childrenBitSetLockInitRunnable);
        } else {
            childrenBitSetLockInitRunnable.run();
        }
    }

    void addDataSourceToHasChildrenMap() throws TskCoreException {
        try {
            this.childrenBitSetInitLatch.await();
        }
        catch (InterruptedException ex) {
            throw new AssertionError("Interrupted Exception awaiting Children bit set initialization", ex);
        }
        this.populateHasChildrenMap(false);
    }

    private void updateDatabaseSchema(String dbPath) throws Exception {
        CaseDbConnection connection = null;
        ResultSet resultSet = null;
        Statement statement = null;
        this.acquireSingleUserCaseWriteLock();
        try {
            int dbSchemaMajorVersion;
            connection = this.connections.getConnection();
            connection.beginTransaction();
            boolean hasMinorVersion = false;
            ResultSet columns = connection.getConnection().getMetaData().getColumns(null, null, "tsk_db_info", "schema%");
            while (columns.next()) {
                if (!columns.getString("COLUMN_NAME").equals("schema_minor_ver")) continue;
                hasMinorVersion = true;
            }
            int dbSchemaMinorVersion = 0;
            statement = connection.createStatement();
            resultSet = connection.executeQuery(statement, "SELECT schema_ver" + (hasMinorVersion ? ", schema_minor_ver" : "") + " FROM tsk_db_info");
            if (resultSet.next()) {
                dbSchemaMajorVersion = resultSet.getInt("schema_ver");
                if (hasMinorVersion) {
                    dbSchemaMinorVersion = resultSet.getInt("schema_minor_ver");
                }
            } else {
                throw new TskCoreException();
            }
            CaseDbSchemaVersionNumber dbSchemaVersion = new CaseDbSchemaVersionNumber(dbSchemaMajorVersion, dbSchemaMinorVersion);
            resultSet.close();
            resultSet = null;
            statement.close();
            statement = null;
            if (!CURRENT_DB_SCHEMA_VERSION.isCompatible(dbSchemaVersion)) {
                throw new TskUnsupportedSchemaVersionException("Unsupported DB schema version " + String.valueOf(dbSchemaVersion) + ", the highest supported schema version is " + CURRENT_DB_SCHEMA_VERSION.getMajor() + ".X");
            }
            if (dbSchemaVersion.compareTo(CURRENT_DB_SCHEMA_VERSION) < 0) {
                if (null != dbPath) {
                    String backupFilePath = dbPath + ".schemaVer" + dbSchemaVersion.toString() + ".backup";
                    this.copyCaseDB(backupFilePath);
                    this.dbBackupPath = backupFilePath;
                }
                dbSchemaVersion = this.updateFromSchema2toSchema3(dbSchemaVersion, connection);
                dbSchemaVersion = this.updateFromSchema3toSchema4(dbSchemaVersion, connection);
                dbSchemaVersion = this.updateFromSchema4toSchema5(dbSchemaVersion, connection);
                dbSchemaVersion = this.updateFromSchema5toSchema6(dbSchemaVersion, connection);
                dbSchemaVersion = this.updateFromSchema6toSchema7(dbSchemaVersion, connection);
                dbSchemaVersion = this.updateFromSchema7toSchema7dot1(dbSchemaVersion, connection);
                dbSchemaVersion = this.updateFromSchema7dot1toSchema7dot2(dbSchemaVersion, connection);
                dbSchemaVersion = this.updateFromSchema7dot2toSchema8dot0(dbSchemaVersion, connection);
                dbSchemaVersion = this.updateFromSchema8dot0toSchema8dot1(dbSchemaVersion, connection);
                dbSchemaVersion = this.updateFromSchema8dot1toSchema8dot2(dbSchemaVersion, connection);
                dbSchemaVersion = this.updateFromSchema8dot2toSchema8dot3(dbSchemaVersion, connection);
                dbSchemaVersion = this.updateFromSchema8dot3toSchema8dot4(dbSchemaVersion, connection);
                dbSchemaVersion = this.updateFromSchema8dot4toSchema8dot5(dbSchemaVersion, connection);
                dbSchemaVersion = this.updateFromSchema8dot5toSchema8dot6(dbSchemaVersion, connection);
                dbSchemaVersion = this.updateFromSchema8dot6toSchema9dot0(dbSchemaVersion, connection);
                dbSchemaVersion = this.updateFromSchema9dot0toSchema9dot1(dbSchemaVersion, connection);
                dbSchemaVersion = this.updateFromSchema9dot1toSchema9dot2(dbSchemaVersion, connection);
                dbSchemaVersion = this.updateFromSchema9dot2toSchema9dot3(dbSchemaVersion, connection);
                dbSchemaVersion = this.updateFromSchema9dot3toSchema9dot4(dbSchemaVersion, connection);
                dbSchemaVersion = this.updateFromSchema9dot4toSchema9dot5(dbSchemaVersion, connection);
                dbSchemaVersion = this.updateFromSchema9dot5toSchema9dot6(dbSchemaVersion, connection);
                statement = connection.createStatement();
                connection.executeUpdate(statement, "UPDATE tsk_db_info SET schema_ver = " + dbSchemaVersion.getMajor() + ", schema_minor_ver = " + dbSchemaVersion.getMinor());
                connection.executeUpdate(statement, "UPDATE tsk_db_info_extended SET value = " + dbSchemaVersion.getMajor() + " WHERE name = 'SCHEMA_MAJOR_VERSION'");
                connection.executeUpdate(statement, "UPDATE tsk_db_info_extended SET value = " + dbSchemaVersion.getMinor() + " WHERE name = 'SCHEMA_MINOR_VERSION'");
                statement.close();
                statement = null;
            }
            connection.commitTransaction();
        }
        catch (Exception ex) {
            try {
                SleuthkitCase.rollbackTransaction(connection);
                throw ex;
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeStatement(statement);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseWriteLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeStatement(statement);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDBSchemaCreationVersion(CaseDbConnection connection) throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        String createdSchemaMajorVersion = "0";
        String createdSchemaMinorVersion = "0";
        this.acquireSingleUserCaseReadLock();
        try {
            statement = connection.createStatement();
            resultSet = connection.executeQuery(statement, "SELECT name, value FROM tsk_db_info_extended");
            while (resultSet.next()) {
                String name = resultSet.getString("name");
                if (name.equals(CREATION_SCHEMA_MAJOR_VERSION_KEY) || name.equals("CREATED_SCHEMA_MAJOR_VERSION")) {
                    createdSchemaMajorVersion = resultSet.getString("value");
                    continue;
                }
                if (!name.equals(CREATION_SCHEMA_MINOR_VERSION_KEY) && !name.equals("CREATED_SCHEMA_MINOR_VERSION")) continue;
                createdSchemaMinorVersion = resultSet.getString("value");
            }
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeStatement(statement);
            this.releaseSingleUserCaseReadLock();
            throw throwable;
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeStatement(statement);
        this.releaseSingleUserCaseReadLock();
        this.caseDBSchemaCreationVersion = new CaseDbSchemaVersionNumber(Integer.parseInt(createdSchemaMajorVersion), Integer.parseInt(createdSchemaMinorVersion));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyCaseDB(String newDBPath) throws IOException {
        if (this.dbPath.isEmpty()) {
            throw new IOException("Copying case database files is not supported for this type of case database");
        }
        InputStream in = null;
        OutputStream out = null;
        this.acquireSingleUserCaseWriteLock();
        try {
            FileInputStream inFile = new FileInputStream(this.dbPath);
            in = new BufferedInputStream(inFile);
            FileOutputStream outFile = new FileOutputStream(newDBPath);
            out = new BufferedOutputStream(outFile);
            int bytesRead = in.read();
            while (bytesRead != -1) {
                out.write(bytesRead);
                bytesRead = in.read();
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Could not close streams after db copy", e);
            }
            this.releaseSingleUserCaseWriteLock();
        }
    }

    private void logSQLiteJDBCDriverInfo() {
        try {
            logger.info(String.format("sqlite-jdbc version %s loaded in %s mode", SQLiteJDBCLoader.getVersion(), SQLiteJDBCLoader.isNativeMode() ? "native" : "pure-java"));
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Error querying case database mode", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaseDbSchemaVersionNumber updateFromSchema2toSchema3(CaseDbSchemaVersionNumber schemaVersion, CaseDbConnection connection) throws SQLException, TskCoreException {
        CaseDbSchemaVersionNumber caseDbSchemaVersionNumber;
        if (schemaVersion.getMajor() != 2) {
            return schemaVersion;
        }
        Statement statement = null;
        Statement statement2 = null;
        Statement updateStatement = null;
        ResultSet resultSet = null;
        this.acquireSingleUserCaseWriteLock();
        try {
            statement = connection.createStatement();
            statement2 = connection.createStatement();
            statement.execute("CREATE TABLE tag_names (tag_name_id INTEGER PRIMARY KEY, display_name TEXT UNIQUE, description TEXT NOT NULL, color TEXT NOT NULL)");
            statement.execute("CREATE TABLE content_tags (tag_id INTEGER PRIMARY KEY, obj_id INTEGER NOT NULL, tag_name_id INTEGER NOT NULL, comment TEXT NOT NULL, begin_byte_offset INTEGER NOT NULL, end_byte_offset INTEGER NOT NULL)");
            statement.execute("CREATE TABLE blackboard_artifact_tags (tag_id INTEGER PRIMARY KEY, artifact_id INTEGER NOT NULL, tag_name_id INTEGER NOT NULL, comment TEXT NOT NULL)");
            statement.execute("CREATE TABLE reports (report_id INTEGER PRIMARY KEY, path TEXT NOT NULL, crtime INTEGER NOT NULL, src_module_name TEXT NOT NULL, report_name TEXT NOT NULL)");
            statement.execute("ALTER TABLE tsk_image_info ADD COLUMN size INTEGER;");
            statement.execute("ALTER TABLE tsk_image_info ADD COLUMN md5 TEXT;");
            statement.execute("ALTER TABLE tsk_image_info ADD COLUMN display_name TEXT;");
            statement.execute("ALTER TABLE tsk_fs_info ADD COLUMN display_name TEXT;");
            statement.execute("ALTER TABLE tsk_files ADD COLUMN meta_seq INTEGER;");
            statement.execute("ALTER TABLE blackboard_attributes ADD COLUMN artifact_type_id INTEGER NULL NOT NULL DEFAULT -1;");
            statement.execute("CREATE INDEX attribute_artifactTypeId ON blackboard_attributes(artifact_type_id);");
            statement.execute("CREATE INDEX attribute_valueText ON blackboard_attributes(value_text);");
            statement.execute("CREATE INDEX attribute_valueInt32 ON blackboard_attributes(value_int32);");
            statement.execute("CREATE INDEX attribute_valueInt64 ON blackboard_attributes(value_int64);");
            statement.execute("CREATE INDEX attribute_valueDouble ON blackboard_attributes(value_double);");
            resultSet = statement.executeQuery("SELECT attrs.artifact_id AS artifact_id, arts.artifact_type_id AS artifact_type_id FROM blackboard_attributes AS attrs INNER JOIN blackboard_artifacts AS arts WHERE attrs.artifact_id = arts.artifact_id;");
            updateStatement = connection.createStatement();
            while (resultSet.next()) {
                long artifactId = resultSet.getLong("artifact_id");
                int artifactTypeId = resultSet.getInt("artifact_type_id");
                updateStatement.executeUpdate("UPDATE blackboard_attributes SET artifact_type_id = " + artifactTypeId + " WHERE blackboard_attributes.artifact_id = " + artifactId + ";");
            }
            resultSet.close();
            HashMap<String, Long> tagNames = new HashMap<String, Long>();
            long tagNameCounter = 1L;
            resultSet = statement.executeQuery("SELECT * FROM \n(SELECT blackboard_artifacts.obj_id AS objId, blackboard_attributes.artifact_id AS artifactId, blackboard_attributes.value_text AS name\nFROM blackboard_artifacts INNER JOIN blackboard_attributes \nON blackboard_artifacts.artifact_id = blackboard_attributes.artifact_id \nWHERE blackboard_artifacts.artifact_type_id = " + BlackboardArtifact.ARTIFACT_TYPE.TSK_TAG_FILE.getTypeID() + " AND blackboard_attributes.attribute_type_id = " + BlackboardAttribute.ATTRIBUTE_TYPE.TSK_TAG_NAME.getTypeID() + ") AS tagNames \nINNER JOIN \n(SELECT tsk_files.obj_id as objId2, tsk_files.size AS fileSize \nFROM blackboard_artifacts INNER JOIN tsk_files \nON blackboard_artifacts.obj_id = tsk_files.obj_id) AS fileData \nON tagNames.objId = fileData.objId2 \nLEFT JOIN \n(SELECT value_text AS comment, artifact_id AS tagArtifactId FROM blackboard_attributes WHERE attribute_type_id = " + BlackboardAttribute.ATTRIBUTE_TYPE.TSK_COMMENT.getTypeID() + ") AS tagComments \nON tagNames.artifactId = tagComments.tagArtifactId");
            while (resultSet.next()) {
                long tagNameIndex;
                long objId = resultSet.getLong("objId");
                long fileSize = resultSet.getLong("fileSize");
                String tagName = resultSet.getString("name");
                String tagComment = resultSet.getString("comment");
                if (tagComment == null) {
                    tagComment = "";
                }
                if (tagName == null || tagName.isEmpty()) continue;
                if (tagNames.containsKey(tagName)) {
                    tagNameIndex = (Long)tagNames.get(tagName);
                } else {
                    statement2.execute("INSERT INTO tag_names (display_name, description, color) VALUES(\"" + tagName + "\", \"\", \"None\")");
                    tagNames.put(tagName, tagNameCounter);
                    tagNameIndex = tagNameCounter++;
                }
                statement2.execute("INSERT INTO content_tags (obj_id, tag_name_id, comment, begin_byte_offset, end_byte_offset) VALUES(" + objId + ", " + tagNameIndex + ", \"" + tagComment + "\", 0, " + fileSize + ")");
            }
            resultSet.close();
            resultSet = statement.executeQuery("SELECT * FROM \n(SELECT blackboard_artifacts.obj_id AS objId, blackboard_attributes.artifact_id AS artifactId, blackboard_attributes.value_text AS name\nFROM blackboard_artifacts INNER JOIN blackboard_attributes \nON blackboard_artifacts.artifact_id = blackboard_attributes.artifact_id \nWHERE blackboard_artifacts.artifact_type_id = " + BlackboardArtifact.ARTIFACT_TYPE.TSK_TAG_ARTIFACT.getTypeID() + " AND blackboard_attributes.attribute_type_id = " + BlackboardAttribute.ATTRIBUTE_TYPE.TSK_TAG_NAME.getTypeID() + ") AS tagNames \nINNER JOIN \n(SELECT value_int64 AS taggedArtifactId, artifact_id AS associatedArtifactId FROM blackboard_attributes WHERE attribute_type_id = " + BlackboardAttribute.ATTRIBUTE_TYPE.TSK_TAGGED_ARTIFACT.getTypeID() + ") AS tagArtifacts \nON tagNames.artifactId = tagArtifacts.associatedArtifactId \nLEFT JOIN \n(SELECT value_text AS comment, artifact_id AS commentArtifactId FROM blackboard_attributes WHERE attribute_type_id = " + BlackboardAttribute.ATTRIBUTE_TYPE.TSK_COMMENT.getTypeID() + ") AS tagComments \nON tagNames.artifactId = tagComments.commentArtifactId");
            while (resultSet.next()) {
                long tagNameIndex;
                long artifactId = resultSet.getLong("taggedArtifactId");
                String tagName = resultSet.getString("name");
                String tagComment = resultSet.getString("comment");
                if (tagComment == null) {
                    tagComment = "";
                }
                if (tagName == null || tagName.isEmpty()) continue;
                if (tagNames.containsKey(tagName)) {
                    tagNameIndex = (Long)tagNames.get(tagName);
                } else {
                    statement2.execute("INSERT INTO tag_names (display_name, description, color) VALUES(\"" + tagName + "\", \"\", \"None\")");
                    tagNames.put(tagName, tagNameCounter);
                    tagNameIndex = tagNameCounter++;
                }
                statement2.execute("INSERT INTO blackboard_artifact_tags (artifact_id, tag_name_id, comment) VALUES(" + artifactId + ", " + tagNameIndex + ", \"" + tagComment + "\")");
            }
            resultSet.close();
            statement.execute("DELETE FROM blackboard_attributes WHERE artifact_id IN (SELECT artifact_id FROM blackboard_artifacts WHERE artifact_type_id = " + BlackboardArtifact.ARTIFACT_TYPE.TSK_TAG_FILE.getTypeID() + " OR artifact_type_id = " + BlackboardArtifact.ARTIFACT_TYPE.TSK_TAG_ARTIFACT.getTypeID() + ");");
            statement.execute("DELETE FROM blackboard_artifacts WHERE artifact_type_id = " + BlackboardArtifact.ARTIFACT_TYPE.TSK_TAG_FILE.getTypeID() + " OR artifact_type_id = " + BlackboardArtifact.ARTIFACT_TYPE.TSK_TAG_ARTIFACT.getTypeID() + ";");
            caseDbSchemaVersionNumber = new CaseDbSchemaVersionNumber(3, 0);
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeStatement(updateStatement);
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeStatement(statement);
            SleuthkitCase.closeStatement(statement2);
            this.releaseSingleUserCaseWriteLock();
            throw throwable;
        }
        SleuthkitCase.closeStatement(updateStatement);
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeStatement(statement);
        SleuthkitCase.closeStatement(statement2);
        this.releaseSingleUserCaseWriteLock();
        return caseDbSchemaVersionNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaseDbSchemaVersionNumber updateFromSchema3toSchema4(CaseDbSchemaVersionNumber schemaVersion, CaseDbConnection connection) throws SQLException, TskCoreException {
        CaseDbSchemaVersionNumber caseDbSchemaVersionNumber;
        if (schemaVersion.getMajor() != 3) {
            return schemaVersion;
        }
        Statement statement = null;
        ResultSet resultSet = null;
        Statement queryStatement = null;
        ResultSet queryResultSet = null;
        Statement updateStatement = null;
        this.acquireSingleUserCaseWriteLock();
        try {
            statement = connection.createStatement();
            updateStatement = connection.createStatement();
            statement.execute("ALTER TABLE tsk_files ADD COLUMN mime_type TEXT;");
            resultSet = statement.executeQuery("SELECT files.obj_id AS obj_id, attrs.value_text AS value_text FROM tsk_files AS files, blackboard_attributes AS attrs, blackboard_artifacts AS arts WHERE files.obj_id = arts.obj_id AND arts.artifact_id = attrs.artifact_id AND arts.artifact_type_id = 1 AND attrs.attribute_type_id = 62");
            while (resultSet.next()) {
                updateStatement.executeUpdate("UPDATE tsk_files SET mime_type = '" + resultSet.getString("value_text") + "' WHERE tsk_files.obj_id = " + resultSet.getInt("obj_id") + ";");
            }
            resultSet.close();
            statement.execute("ALTER TABLE blackboard_attribute_types ADD COLUMN value_type INTEGER NOT NULL DEFAULT -1;");
            resultSet = statement.executeQuery("SELECT * FROM blackboard_attribute_types AS types");
            while (resultSet.next()) {
                int attributeTypeId = resultSet.getInt("attribute_type_id");
                String attributeLabel = resultSet.getString("type_name");
                if (attributeTypeId >= 10000) continue;
                updateStatement.executeUpdate("UPDATE blackboard_attribute_types SET value_type = " + BlackboardAttribute.ATTRIBUTE_TYPE.fromLabel(attributeLabel).getValueType().getType() + " WHERE blackboard_attribute_types.attribute_type_id = " + attributeTypeId + ";");
            }
            resultSet.close();
            queryStatement = connection.createStatement();
            statement.execute("CREATE TABLE data_source_info (obj_id INTEGER PRIMARY KEY, device_id TEXT NOT NULL, time_zone TEXT NOT NULL, FOREIGN KEY(obj_id) REFERENCES tsk_objects(obj_id));");
            resultSet = statement.executeQuery("SELECT * FROM tsk_objects WHERE par_obj_id IS NULL");
            while (resultSet.next()) {
                long objectId = resultSet.getLong("obj_id");
                String timeZone = "";
                queryResultSet = queryStatement.executeQuery("SELECT tzone FROM tsk_image_info WHERE obj_id = " + objectId);
                if (queryResultSet.next()) {
                    timeZone = queryResultSet.getString("tzone");
                }
                queryResultSet.close();
                updateStatement.executeUpdate("INSERT INTO data_source_info (obj_id, device_id, time_zone) VALUES(" + objectId + ", '" + UUID.randomUUID().toString() + "' , '" + timeZone + "');");
            }
            resultSet.close();
            statement.execute("ALTER TABLE tsk_files ADD COLUMN data_source_obj_id BIGINT NOT NULL DEFAULT -1;");
            resultSet = statement.executeQuery("SELECT tsk_files.obj_id AS obj_id, par_obj_id FROM tsk_files, tsk_objects WHERE tsk_files.obj_id = tsk_objects.obj_id");
            while (resultSet.next()) {
                long fileId = resultSet.getLong("obj_id");
                long dataSourceId = this.getDataSourceObjectId(connection, fileId);
                updateStatement.executeUpdate("UPDATE tsk_files SET data_source_obj_id = " + dataSourceId + " WHERE obj_id = " + fileId + ";");
            }
            resultSet.close();
            statement.execute("CREATE TABLE ingest_module_types (type_id INTEGER PRIMARY KEY, type_name TEXT NOT NULL)");
            statement.execute("CREATE TABLE ingest_job_status_types (type_id INTEGER PRIMARY KEY, type_name TEXT NOT NULL)");
            if (this.dbType.equals((Object)TskData.DbType.SQLITE)) {
                statement.execute("CREATE TABLE ingest_modules (ingest_module_id INTEGER PRIMARY KEY, display_name TEXT NOT NULL, unique_name TEXT UNIQUE NOT NULL, type_id INTEGER NOT NULL, version TEXT NOT NULL, FOREIGN KEY(type_id) REFERENCES ingest_module_types(type_id));");
                statement.execute("CREATE TABLE ingest_jobs (ingest_job_id INTEGER PRIMARY KEY, obj_id BIGINT NOT NULL, host_name TEXT NOT NULL, start_date_time BIGINT NOT NULL, end_date_time BIGINT NOT NULL, status_id INTEGER NOT NULL, settings_dir TEXT, FOREIGN KEY(obj_id) REFERENCES tsk_objects(obj_id), FOREIGN KEY(status_id) REFERENCES ingest_job_status_types(type_id));");
            } else {
                statement.execute("CREATE TABLE ingest_modules (ingest_module_id BIGSERIAL PRIMARY KEY, display_name TEXT NOT NULL, unique_name TEXT UNIQUE NOT NULL, type_id INTEGER NOT NULL, version TEXT NOT NULL, FOREIGN KEY(type_id) REFERENCES ingest_module_types(type_id));");
                statement.execute("CREATE TABLE ingest_jobs (ingest_job_id BIGSERIAL PRIMARY KEY, obj_id BIGINT NOT NULL, host_name TEXT NOT NULL, start_date_time BIGINT NOT NULL, end_date_time BIGINT NOT NULL, status_id INTEGER NOT NULL, settings_dir TEXT, FOREIGN KEY(obj_id) REFERENCES tsk_objects(obj_id), FOREIGN KEY(status_id) REFERENCES ingest_job_status_types(type_id));");
            }
            statement.execute("CREATE TABLE ingest_job_modules (ingest_job_id INTEGER, ingest_module_id INTEGER, pipeline_position INTEGER, PRIMARY KEY(ingest_job_id, ingest_module_id), FOREIGN KEY(ingest_job_id) REFERENCES ingest_jobs(ingest_job_id), FOREIGN KEY(ingest_module_id) REFERENCES ingest_modules(ingest_module_id));");
            this.initIngestModuleTypes(connection);
            this.initIngestStatusTypes(connection);
            caseDbSchemaVersionNumber = new CaseDbSchemaVersionNumber(4, 0);
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(queryResultSet);
            SleuthkitCase.closeStatement(queryStatement);
            SleuthkitCase.closeStatement(updateStatement);
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeStatement(statement);
            this.releaseSingleUserCaseWriteLock();
            throw throwable;
        }
        SleuthkitCase.closeResultSet(queryResultSet);
        SleuthkitCase.closeStatement(queryStatement);
        SleuthkitCase.closeStatement(updateStatement);
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeStatement(statement);
        this.releaseSingleUserCaseWriteLock();
        return caseDbSchemaVersionNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaseDbSchemaVersionNumber updateFromSchema4toSchema5(CaseDbSchemaVersionNumber schemaVersion, CaseDbConnection connection) throws SQLException, TskCoreException {
        if (schemaVersion.getMajor() != 4) {
            return schemaVersion;
        }
        Statement statement = null;
        this.acquireSingleUserCaseWriteLock();
        try {
            statement = connection.createStatement();
            statement.execute("CREATE TABLE review_statuses (review_status_id INTEGER PRIMARY KEY, review_status_name TEXT NOT NULL, display_name TEXT NOT NULL)");
            statement.execute("ALTER TABLE blackboard_artifacts ADD COLUMN review_status_id INTEGER NOT NULL DEFAULT " + BlackboardArtifact.ReviewStatus.UNDECIDED.getID());
            statement.execute("CREATE TABLE file_encoding_types (encoding_type INTEGER PRIMARY KEY, name TEXT NOT NULL);");
            this.initEncodingTypes(connection);
            this.initReviewStatuses(connection);
            statement.execute("ALTER TABLE tsk_files_path ADD COLUMN encoding_type INTEGER NOT NULL DEFAULT 0;");
            CaseDbSchemaVersionNumber caseDbSchemaVersionNumber = new CaseDbSchemaVersionNumber(5, 0);
            return caseDbSchemaVersionNumber;
        }
        finally {
            SleuthkitCase.closeStatement(statement);
            this.releaseSingleUserCaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaseDbSchemaVersionNumber updateFromSchema5toSchema6(CaseDbSchemaVersionNumber schemaVersion, CaseDbConnection connection) throws SQLException, TskCoreException {
        CaseDbSchemaVersionNumber caseDbSchemaVersionNumber;
        if (schemaVersion.getMajor() != 5) {
            return schemaVersion;
        }
        Statement statement = null;
        ResultSet resultSet = null;
        this.acquireSingleUserCaseWriteLock();
        try {
            statement = connection.createStatement();
            statement.execute("CREATE TABLE IF NOT EXISTS review_statuses (review_status_id INTEGER PRIMARY KEY, review_status_name TEXT NOT NULL, display_name TEXT NOT NULL)");
            resultSet = connection.executeQuery(statement, "SELECT COUNT(*) AS count FROM review_statuses");
            resultSet.next();
            if (resultSet.getLong("count") == 0L) {
                statement.execute("ALTER TABLE blackboard_artifacts ADD COLUMN review_status_id INTEGER NOT NULL DEFAULT " + BlackboardArtifact.ReviewStatus.UNDECIDED.getID());
            }
            caseDbSchemaVersionNumber = new CaseDbSchemaVersionNumber(6, 0);
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeStatement(statement);
            this.releaseSingleUserCaseWriteLock();
            throw throwable;
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeStatement(statement);
        this.releaseSingleUserCaseWriteLock();
        return caseDbSchemaVersionNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaseDbSchemaVersionNumber updateFromSchema6toSchema7(CaseDbSchemaVersionNumber schemaVersion, CaseDbConnection connection) throws SQLException, TskCoreException {
        CaseDbSchemaVersionNumber caseDbSchemaVersionNumber;
        if (schemaVersion.getMajor() != 6) {
            return schemaVersion;
        }
        Statement statement = null;
        Statement updstatement = null;
        ResultSet resultSet = null;
        this.acquireSingleUserCaseWriteLock();
        try {
            statement = connection.createStatement();
            updstatement = connection.createStatement();
            statement.execute("ALTER TABLE tsk_files ADD COLUMN extension TEXT");
            resultSet = connection.executeQuery(statement, "SELECT obj_id,name FROM tsk_files");
            while (resultSet.next()) {
                long objID = resultSet.getLong("obj_id");
                String name = resultSet.getString("name");
                updstatement.executeUpdate("UPDATE tsk_files SET extension = '" + SleuthkitCase.escapeSingleQuotes(SleuthkitCase.extractExtension(name)) + "' WHERE obj_id = " + objID);
            }
            statement.execute("CREATE INDEX file_extension ON tsk_files ( extension )");
            statement.execute("ALTER TABLE blackboard_artifacts ADD COLUMN artifact_obj_id INTEGER NOT NULL DEFAULT -1");
            caseDbSchemaVersionNumber = new CaseDbSchemaVersionNumber(7, 0);
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeStatement(statement);
            SleuthkitCase.closeStatement(updstatement);
            this.releaseSingleUserCaseWriteLock();
            throw throwable;
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeStatement(statement);
        SleuthkitCase.closeStatement(updstatement);
        this.releaseSingleUserCaseWriteLock();
        return caseDbSchemaVersionNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaseDbSchemaVersionNumber updateFromSchema7toSchema7dot1(CaseDbSchemaVersionNumber schemaVersion, CaseDbConnection connection) throws SQLException, TskCoreException {
        if (schemaVersion.getMajor() != 7) {
            return schemaVersion;
        }
        if (schemaVersion.getMinor() != 0) {
            return schemaVersion;
        }
        Statement statement = null;
        ResultSet resultSet = null;
        this.acquireSingleUserCaseWriteLock();
        try {
            statement = connection.createStatement();
            if (schemaVersion.getMinor() == 0) {
                statement.execute("ALTER TABLE tsk_db_info ADD COLUMN schema_minor_ver INTEGER DEFAULT 1");
            }
            CaseDbSchemaVersionNumber caseDbSchemaVersionNumber = new CaseDbSchemaVersionNumber(7, 1);
            return caseDbSchemaVersionNumber;
        }
        finally {
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeStatement(statement);
            this.releaseSingleUserCaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaseDbSchemaVersionNumber updateFromSchema7dot1toSchema7dot2(CaseDbSchemaVersionNumber schemaVersion, CaseDbConnection connection) throws SQLException, TskCoreException {
        CaseDbSchemaVersionNumber caseDbSchemaVersionNumber;
        if (schemaVersion.getMajor() != 7) {
            return schemaVersion;
        }
        if (schemaVersion.getMinor() != 1) {
            return schemaVersion;
        }
        Statement statement = null;
        Statement updstatement = null;
        ResultSet resultSet = null;
        this.acquireSingleUserCaseWriteLock();
        try {
            statement = connection.createStatement();
            statement.execute("ALTER TABLE blackboard_artifacts ADD COLUMN data_source_obj_id INTEGER NOT NULL DEFAULT -1");
            updstatement = connection.createStatement();
            resultSet = connection.executeQuery(statement, "SELECT artifact_id, obj_id FROM blackboard_artifacts");
            while (resultSet.next()) {
                long artifact_id = resultSet.getLong("artifact_id");
                long obj_id = resultSet.getLong("obj_id");
                long data_source_obj_id = this.getDataSourceObjectId(connection, obj_id);
                updstatement.executeUpdate("UPDATE blackboard_artifacts SET data_source_obj_id = " + data_source_obj_id + " WHERE artifact_id = " + artifact_id);
            }
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeStatement(statement);
            SleuthkitCase.closeStatement(updstatement);
            statement = connection.createStatement();
            statement.execute("ALTER TABLE tag_names ADD COLUMN knownStatus INTEGER NOT NULL DEFAULT " + TskData.FileKnown.UNKNOWN.getFileKnownValue());
            if (this.dbType.equals((Object)TskData.DbType.SQLITE)) {
                statement.execute("CREATE TABLE account_types (account_type_id INTEGER PRIMARY KEY, type_name TEXT UNIQUE NOT NULL, display_name TEXT NOT NULL)");
                statement.execute("CREATE TABLE accounts (account_id INTEGER PRIMARY KEY, account_type_id INTEGER NOT NULL, account_unique_identifier TEXT NOT NULL,  UNIQUE(account_type_id, account_unique_identifier) , FOREIGN KEY(account_type_id) REFERENCES account_types(account_type_id))");
                statement.execute("CREATE TABLE account_relationships (relationship_id INTEGER PRIMARY KEY, account1_id INTEGER NOT NULL, account2_id INTEGER NOT NULL, relationship_source_obj_id INTEGER NOT NULL,  date_time INTEGER, relationship_type INTEGER NOT NULL, data_source_obj_id INTEGER NOT NULL, UNIQUE(account1_id, account2_id, relationship_source_obj_id), FOREIGN KEY(account1_id) REFERENCES accounts(account_id), FOREIGN KEY(account2_id) REFERENCES accounts(account_id), FOREIGN KEY(relationship_source_obj_id) REFERENCES tsk_objects(obj_id), FOREIGN KEY(data_source_obj_id) REFERENCES tsk_objects(obj_id))");
            } else {
                statement.execute("CREATE TABLE account_types (account_type_id BIGSERIAL PRIMARY KEY, type_name TEXT UNIQUE NOT NULL, display_name TEXT NOT NULL)");
                statement.execute("CREATE TABLE accounts (account_id BIGSERIAL PRIMARY KEY, account_type_id INTEGER NOT NULL, account_unique_identifier TEXT NOT NULL,  UNIQUE(account_type_id, account_unique_identifier) , FOREIGN KEY(account_type_id) REFERENCES account_types(account_type_id))");
                statement.execute("CREATE TABLE account_relationships  (relationship_id BIGSERIAL PRIMARY KEY, account1_id INTEGER NOT NULL, account2_id INTEGER NOT NULL, relationship_source_obj_id INTEGER NOT NULL, date_time BIGINT, relationship_type INTEGER NOT NULL, data_source_obj_id INTEGER NOT NULL, UNIQUE(account1_id, account2_id, relationship_source_obj_id), FOREIGN KEY(account1_id) REFERENCES accounts(account_id), FOREIGN KEY(account2_id) REFERENCES accounts(account_id), FOREIGN KEY(relationship_source_obj_id) REFERENCES tsk_objects(obj_id), FOREIGN KEY(data_source_obj_id) REFERENCES tsk_objects(obj_id))");
            }
            statement.execute("CREATE INDEX artifact_artifact_objID ON blackboard_artifacts(artifact_obj_id)");
            statement.execute("CREATE INDEX relationships_account1  ON account_relationships(account1_id)");
            statement.execute("CREATE INDEX relationships_account2  ON account_relationships(account2_id)");
            statement.execute("CREATE INDEX relationships_relationship_source_obj_id  ON account_relationships(relationship_source_obj_id)");
            statement.execute("CREATE INDEX relationships_date_time  ON account_relationships(date_time)");
            statement.execute("CREATE INDEX relationships_relationship_type  ON account_relationships(relationship_type)");
            statement.execute("CREATE INDEX relationships_data_source_obj_id  ON account_relationships(data_source_obj_id)");
            caseDbSchemaVersionNumber = new CaseDbSchemaVersionNumber(7, 2);
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeStatement(statement);
            SleuthkitCase.closeStatement(updstatement);
            this.releaseSingleUserCaseWriteLock();
            throw throwable;
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeStatement(statement);
        SleuthkitCase.closeStatement(updstatement);
        this.releaseSingleUserCaseWriteLock();
        return caseDbSchemaVersionNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaseDbSchemaVersionNumber updateFromSchema7dot2toSchema8dot0(CaseDbSchemaVersionNumber schemaVersion, CaseDbConnection connection) throws SQLException, TskCoreException {
        CaseDbSchemaVersionNumber caseDbSchemaVersionNumber;
        if (schemaVersion.getMajor() != 7) {
            return schemaVersion;
        }
        if (schemaVersion.getMinor() != 2) {
            return schemaVersion;
        }
        Statement updateSchemaStatement = connection.createStatement();
        Statement getExistingReportsStatement = connection.createStatement();
        ResultSet resultSet = null;
        ResultSet existingReports = null;
        this.acquireSingleUserCaseWriteLock();
        try {
            updateSchemaStatement.execute("ALTER TABLE reports RENAME TO old_reports");
            updateSchemaStatement.execute("CREATE TABLE reports (obj_id BIGSERIAL PRIMARY KEY, path TEXT NOT NULL, crtime INTEGER NOT NULL, src_module_name TEXT NOT NULL, report_name TEXT NOT NULL, FOREIGN KEY(obj_id) REFERENCES tsk_objects(obj_id))");
            existingReports = getExistingReportsStatement.executeQuery("SELECT * FROM old_reports");
            while (existingReports.next()) {
                String path = existingReports.getString(2);
                long crtime = existingReports.getInt(3);
                String sourceModule = existingReports.getString(4);
                String reportName = existingReports.getString(5);
                PreparedStatement insertObjectStatement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_OBJECT, 1);
                insertObjectStatement.clearParameters();
                insertObjectStatement.setNull(1, -5);
                insertObjectStatement.setLong(2, TskData.ObjectType.REPORT.getObjectType());
                connection.executeUpdate(insertObjectStatement);
                resultSet = insertObjectStatement.getGeneratedKeys();
                if (!resultSet.next()) {
                    throw new TskCoreException(String.format("Failed to INSERT report %s (%s) in tsk_objects table", reportName, path));
                }
                long objectId = resultSet.getLong(1);
                PreparedStatement insertReportStatement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_REPORT);
                insertReportStatement.clearParameters();
                insertReportStatement.setLong(1, objectId);
                insertReportStatement.setString(2, path);
                insertReportStatement.setLong(3, crtime);
                insertReportStatement.setString(4, sourceModule);
                insertReportStatement.setString(5, reportName);
                connection.executeUpdate(insertReportStatement);
            }
            updateSchemaStatement.execute("DROP TABLE old_reports");
            caseDbSchemaVersionNumber = new CaseDbSchemaVersionNumber(8, 0);
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeResultSet(existingReports);
            SleuthkitCase.closeStatement(updateSchemaStatement);
            SleuthkitCase.closeStatement(getExistingReportsStatement);
            this.releaseSingleUserCaseWriteLock();
            throw throwable;
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeResultSet(existingReports);
        SleuthkitCase.closeStatement(updateSchemaStatement);
        SleuthkitCase.closeStatement(getExistingReportsStatement);
        this.releaseSingleUserCaseWriteLock();
        return caseDbSchemaVersionNumber;
    }

    private CaseDbSchemaVersionNumber updateFromSchema8dot0toSchema8dot1(CaseDbSchemaVersionNumber schemaVersion, CaseDbConnection connection) throws SQLException, TskCoreException {
        if (schemaVersion.getMajor() != 8) {
            return schemaVersion;
        }
        if (schemaVersion.getMinor() != 0) {
            return schemaVersion;
        }
        this.acquireSingleUserCaseWriteLock();
        try {
            CaseDbSchemaVersionNumber caseDbSchemaVersionNumber;
            block13: {
                Statement statement = connection.createStatement();
                try {
                    if (this.dbType.equals((Object)TskData.DbType.SQLITE)) {
                        statement.execute("CREATE TABLE tsk_examiners (examiner_id INTEGER PRIMARY KEY, login_name TEXT NOT NULL, display_name TEXT, UNIQUE(login_name) )");
                        statement.execute("ALTER TABLE content_tags ADD COLUMN examiner_id INTEGER REFERENCES tsk_examiners(examiner_id) DEFAULT NULL");
                        statement.execute("ALTER TABLE blackboard_artifact_tags ADD COLUMN examiner_id INTEGER REFERENCES tsk_examiners(examiner_id) DEFAULT NULL");
                    } else {
                        statement.execute("CREATE TABLE tsk_examiners (examiner_id BIGSERIAL PRIMARY KEY, login_name TEXT NOT NULL, display_name TEXT, UNIQUE(login_name))");
                        statement.execute("ALTER TABLE content_tags ADD COLUMN examiner_id BIGINT REFERENCES tsk_examiners(examiner_id) DEFAULT NULL");
                        statement.execute("ALTER TABLE blackboard_artifact_tags ADD COLUMN examiner_id BIGINT REFERENCES tsk_examiners(examiner_id) DEFAULT NULL");
                    }
                    caseDbSchemaVersionNumber = new CaseDbSchemaVersionNumber(8, 1);
                    if (statement == null) break block13;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return caseDbSchemaVersionNumber;
        }
        finally {
            this.releaseSingleUserCaseWriteLock();
        }
    }

    private CaseDbSchemaVersionNumber updateFromSchema8dot1toSchema8dot2(CaseDbSchemaVersionNumber schemaVersion, CaseDbConnection connection) throws SQLException, TskCoreException {
        if (schemaVersion.getMajor() != 8) {
            return schemaVersion;
        }
        if (schemaVersion.getMinor() != 1) {
            return schemaVersion;
        }
        this.acquireSingleUserCaseWriteLock();
        try {
            CaseDbSchemaVersionNumber caseDbSchemaVersionNumber;
            block15: {
                Statement statement = connection.createStatement();
                try {
                    statement.execute("ALTER TABLE tsk_image_info ADD COLUMN sha1 TEXT DEFAULT NULL");
                    statement.execute("ALTER TABLE tsk_image_info ADD COLUMN sha256 TEXT DEFAULT NULL");
                    statement.execute("ALTER TABLE data_source_info ADD COLUMN acquisition_details TEXT");
                    statement.execute("CREATE TABLE tsk_db_info_extended (name TEXT PRIMARY KEY, value TEXT NOT NULL)");
                    ResultSet result = statement.executeQuery("SELECT tsk_ver FROM tsk_db_info");
                    result.next();
                    statement.execute("INSERT INTO tsk_db_info_extended (name, value) VALUES ('TSK_VER', '" + result.getLong("tsk_ver") + "')");
                    statement.execute("INSERT INTO tsk_db_info_extended (name, value) VALUES ('SCHEMA_MAJOR_VERSION', '8')");
                    statement.execute("INSERT INTO tsk_db_info_extended (name, value) VALUES ('SCHEMA_MINOR_VERSION', '2')");
                    statement.execute("INSERT INTO tsk_db_info_extended (name, value) VALUES ('CREATION_SCHEMA_MAJOR_VERSION', '0')");
                    statement.execute("INSERT INTO tsk_db_info_extended (name, value) VALUES ('CREATION_SCHEMA_MINOR_VERSION', '0')");
                    String primaryKeyType = switch (this.getDatabaseType()) {
                        case TskData.DbType.POSTGRESQL -> "BIGSERIAL";
                        case TskData.DbType.SQLITE -> "INTEGER";
                        default -> throw new TskCoreException("Unsupported data base type: " + this.getDatabaseType().toString());
                    };
                    statement.execute("CREATE TABLE tsk_event_types ( event_type_id " + primaryKeyType + " PRIMARY KEY,  display_name TEXT UNIQUE NOT NULL,  super_type_id INTEGER REFERENCES tsk_event_types(event_type_id) )");
                    statement.execute("insert into tsk_event_types(event_type_id, display_name, super_type_id) values( 0, 'Event Types', null)");
                    statement.execute("insert into tsk_event_types(event_type_id, display_name, super_type_id) values(1, 'File System', 0)");
                    statement.execute("insert into tsk_event_types(event_type_id, display_name, super_type_id) values(2, 'Web Activity', 0)");
                    statement.execute("insert into tsk_event_types(event_type_id, display_name, super_type_id) values(3, 'Misc Types', 0)");
                    statement.execute("insert into tsk_event_types(event_type_id, display_name, super_type_id) values(4, 'Modified', 1)");
                    statement.execute("insert into tsk_event_types(event_type_id, display_name, super_type_id) values(5, 'Accessed', 1)");
                    statement.execute("insert into tsk_event_types(event_type_id, display_name, super_type_id) values(6, 'Created', 1)");
                    statement.execute("insert into tsk_event_types(event_type_id, display_name, super_type_id) values(7, 'Changed', 1)");
                    statement.execute("CREATE TABLE tsk_event_descriptions ( event_description_id " + primaryKeyType + " PRIMARY KEY,  full_description TEXT NOT NULL,  med_description TEXT,  short_description TEXT, data_source_obj_id BIGINT NOT NULL,  file_obj_id BIGINT NOT NULL,  artifact_id BIGINT,  hash_hit INTEGER NOT NULL,  tagged INTEGER NOT NULL,  FOREIGN KEY(data_source_obj_id) REFERENCES data_source_info(obj_id),  FOREIGN KEY(file_obj_id) REFERENCES tsk_files(obj_id),  FOREIGN KEY(artifact_id) REFERENCES blackboard_artifacts(artifact_id))");
                    statement.execute("CREATE TABLE tsk_events (  event_id " + primaryKeyType + " PRIMARY KEY,  event_type_id BIGINT NOT NULL REFERENCES tsk_event_types(event_type_id) , event_description_id BIGINT NOT NULL REFERENCES tsk_event_descriptions(event_description_id) , time INTEGER NOT NULL) ");
                    statement.execute("CREATE INDEX events_time ON tsk_events(time)");
                    statement.execute("CREATE INDEX events_type ON tsk_events(event_type_id)");
                    statement.execute("CREATE INDEX events_data_source_obj_id  ON tsk_event_descriptions(data_source_obj_id) ");
                    statement.execute("CREATE INDEX events_file_obj_id  ON tsk_event_descriptions(file_obj_id) ");
                    statement.execute("CREATE INDEX events_artifact_id  ON tsk_event_descriptions(artifact_id) ");
                    statement.execute("CREATE INDEX events_sub_type_time ON tsk_events(event_type_id,  time) ");
                    caseDbSchemaVersionNumber = new CaseDbSchemaVersionNumber(8, 2);
                    if (statement == null) break block15;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return caseDbSchemaVersionNumber;
        }
        finally {
            this.releaseSingleUserCaseWriteLock();
        }
    }

    /*
     * Loose catch block
     */
    private CaseDbSchemaVersionNumber updateFromSchema8dot2toSchema8dot3(CaseDbSchemaVersionNumber schemaVersion, CaseDbConnection connection) throws SQLException, TskCoreException {
        CaseDbSchemaVersionNumber caseDbSchemaVersionNumber;
        Statement statement;
        ResultSet resultSet;
        block15: {
            if (schemaVersion.getMajor() != 8) {
                return schemaVersion;
            }
            if (schemaVersion.getMinor() != 2) {
                return schemaVersion;
            }
            this.acquireSingleUserCaseWriteLock();
            resultSet = null;
            statement = connection.createStatement();
            String primaryKeyType = switch (this.getDatabaseType()) {
                case TskData.DbType.POSTGRESQL -> "BIGSERIAL";
                case TskData.DbType.SQLITE -> "INTEGER";
                default -> throw new TskCoreException("Unsupported data base type: " + this.getDatabaseType().toString());
            };
            statement.execute("CREATE TABLE IF NOT EXISTS tsk_event_types ( event_type_id " + primaryKeyType + " PRIMARY KEY,  display_name TEXT UNIQUE NOT NULL,  super_type_id INTEGER REFERENCES tsk_event_types(event_type_id) )");
            resultSet = statement.executeQuery("SELECT * from tsk_event_types");
            if (!resultSet.next()) {
                statement.execute("insert into tsk_event_types(event_type_id, display_name, super_type_id) values( 0, 'Event Types', null)");
                statement.execute("insert into tsk_event_types(event_type_id, display_name, super_type_id) values(1, 'File System', 0)");
                statement.execute("insert into tsk_event_types(event_type_id, display_name, super_type_id) values(2, 'Web Activity', 0)");
                statement.execute("insert into tsk_event_types(event_type_id, display_name, super_type_id) values(3, 'Misc Types', 0)");
                statement.execute("insert into tsk_event_types(event_type_id, display_name, super_type_id) values(4, 'Modified', 1)");
                statement.execute("insert into tsk_event_types(event_type_id, display_name, super_type_id) values(5, 'Accessed', 1)");
                statement.execute("insert into tsk_event_types(event_type_id, display_name, super_type_id) values(6, 'Created', 1)");
                statement.execute("insert into tsk_event_types(event_type_id, display_name, super_type_id) values(7, 'Changed', 1)");
            }
            statement.execute("DROP TABLE IF EXISTS tsk_events");
            statement.execute("DROP TABLE IF EXISTS tsk_event_descriptions");
            statement.execute("CREATE TABLE tsk_event_descriptions ( event_description_id " + primaryKeyType + " PRIMARY KEY,  full_description TEXT NOT NULL,  med_description TEXT,  short_description TEXT, data_source_obj_id BIGINT NOT NULL,  file_obj_id BIGINT NOT NULL,  artifact_id BIGINT,  hash_hit INTEGER NOT NULL,  tagged INTEGER NOT NULL,  UNIQUE(full_description, file_obj_id, artifact_id),  FOREIGN KEY(data_source_obj_id) REFERENCES data_source_info(obj_id),  FOREIGN KEY(file_obj_id) REFERENCES tsk_files(obj_id),  FOREIGN KEY(artifact_id) REFERENCES blackboard_artifacts(artifact_id))");
            statement.execute("CREATE TABLE tsk_events (  event_id " + primaryKeyType + " PRIMARY KEY,  event_type_id BIGINT NOT NULL REFERENCES tsk_event_types(event_type_id) , event_description_id BIGINT NOT NULL REFERENCES tsk_event_descriptions(event_description_id) , time INTEGER NOT NULL,  UNIQUE (event_type_id, event_description_id, time))");
            statement.execute("UPDATE tsk_db_info_extended SET name = 'CREATION_SCHEMA_MAJOR_VERSION' WHERE name = 'CREATED_SCHEMA_MAJOR_VERSION'");
            statement.execute("UPDATE tsk_db_info_extended SET name = 'CREATION_SCHEMA_MINOR_VERSION' WHERE name = 'CREATED_SCHEMA_MINOR_VERSION'");
            caseDbSchemaVersionNumber = new CaseDbSchemaVersionNumber(8, 3);
            if (statement == null) break block15;
            statement.close();
        }
        SleuthkitCase.closeResultSet(resultSet);
        this.releaseSingleUserCaseWriteLock();
        return caseDbSchemaVersionNumber;
        {
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    SleuthkitCase.closeResultSet(resultSet);
                    this.releaseSingleUserCaseWriteLock();
                    throw throwable3;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaseDbSchemaVersionNumber updateFromSchema8dot3toSchema8dot4(CaseDbSchemaVersionNumber schemaVersion, CaseDbConnection connection) throws SQLException, TskCoreException {
        CaseDbSchemaVersionNumber caseDbSchemaVersionNumber;
        if (schemaVersion.getMajor() != 8) {
            return schemaVersion;
        }
        if (schemaVersion.getMinor() != 3) {
            return schemaVersion;
        }
        Statement statement = connection.createStatement();
        ResultSet results = null;
        this.acquireSingleUserCaseWriteLock();
        try {
            if (null == this.getDatabaseType()) {
                throw new TskCoreException("Unsupported data base type: " + this.getDatabaseType().toString());
            }
            switch (this.getDatabaseType()) {
                case POSTGRESQL: {
                    results = statement.executeQuery("SELECT column_name FROM information_schema.columns WHERE table_name='tsk_event_descriptions' and column_name='file_obj_id'");
                    if (!results.next()) break;
                    statement.execute("ALTER TABLE tsk_event_descriptions RENAME COLUMN file_obj_id TO content_obj_id");
                    statement.execute("CREATE TABLE temp_tsk_events (  event_id BIGSERIAL PRIMARY KEY,  event_type_id BIGINT NOT NULL REFERENCES tsk_event_types(event_type_id) , event_description_id BIGINT NOT NULL REFERENCES tsk_event_descriptions(event_description_id), time BIGINT NOT NULL,  UNIQUE (event_type_id, event_description_id, time))");
                    statement.execute("INSERT INTO temp_tsk_events(event_id, event_type_id, event_description_id, time) SELECT * FROM tsk_events");
                    statement.execute("DROP TABLE tsk_events");
                    statement.execute("ALTER TABLE temp_tsk_events RENAME TO tsk_events");
                    statement.execute("CREATE INDEX events_data_source_obj_id  ON tsk_event_descriptions(data_source_obj_id) ");
                    statement.execute("CREATE INDEX events_content_obj_id  ON tsk_event_descriptions(content_obj_id) ");
                    statement.execute("CREATE INDEX events_artifact_id  ON tsk_event_descriptions(artifact_id) ");
                    statement.execute("CREATE INDEX events_sub_type_time ON tsk_events(event_type_id,  time) ");
                    statement.execute("CREATE INDEX events_time  ON tsk_events(time) ");
                    break;
                }
                case SQLITE: {
                    boolean hasMisnamedColumn = false;
                    results = statement.executeQuery("pragma table_info('tsk_event_descriptions')");
                    while (results.next()) {
                        if (results.getString("name") == null || !results.getString("name").equals("file_obj_id")) continue;
                        hasMisnamedColumn = true;
                        break;
                    }
                    if (!hasMisnamedColumn) break;
                    statement.execute("CREATE TABLE temp_tsk_event_descriptions ( event_description_id INTEGER PRIMARY KEY,  full_description TEXT NOT NULL,  med_description TEXT,  short_description TEXT, data_source_obj_id BIGINT NOT NULL,  content_obj_id BIGINT NOT NULL,  artifact_id BIGINT,  hash_hit INTEGER NOT NULL,  tagged INTEGER NOT NULL,  UNIQUE(full_description, content_obj_id, artifact_id),  FOREIGN KEY(data_source_obj_id) REFERENCES data_source_info(obj_id),  FOREIGN KEY(content_obj_id) REFERENCES tsk_files(obj_id),  FOREIGN KEY(artifact_id) REFERENCES blackboard_artifacts(artifact_id))");
                    statement.execute("CREATE TABLE temp_tsk_events (  event_id INTEGER PRIMARY KEY,  event_type_id BIGINT NOT NULL REFERENCES tsk_event_types(event_type_id) , event_description_id BIGINT NOT NULL REFERENCES temp_tsk_event_descriptions(event_description_id), time INTEGER NOT NULL,  UNIQUE (event_type_id, event_description_id, time))");
                    statement.execute("INSERT INTO temp_tsk_event_descriptions(event_description_id, full_description, med_description, short_description, data_source_obj_id, content_obj_id, artifact_id, hash_hit, tagged) SELECT * FROM tsk_event_descriptions");
                    statement.execute("INSERT INTO temp_tsk_events(event_id, event_type_id, event_description_id, time) SELECT * FROM tsk_events");
                    statement.execute("DROP TABLE tsk_events");
                    statement.execute("DROP TABLE tsk_event_descriptions");
                    statement.execute("ALTER TABLE temp_tsk_event_descriptions RENAME TO tsk_event_descriptions");
                    statement.execute("ALTER TABLE temp_tsk_events RENAME TO tsk_events");
                    statement.execute("CREATE INDEX events_data_source_obj_id  ON tsk_event_descriptions(data_source_obj_id) ");
                    statement.execute("CREATE INDEX events_content_obj_id  ON tsk_event_descriptions(content_obj_id) ");
                    statement.execute("CREATE INDEX events_artifact_id  ON tsk_event_descriptions(artifact_id) ");
                    statement.execute("CREATE INDEX events_sub_type_time ON tsk_events(event_type_id,  time) ");
                    statement.execute("CREATE INDEX events_time  ON tsk_events(time) ");
                    break;
                }
                default: {
                    throw new TskCoreException("Unsupported data base type: " + this.getDatabaseType().toString());
                }
            }
            if (this.dbType.equals((Object)TskData.DbType.SQLITE)) {
                statement.execute("CREATE TABLE tsk_pool_info (obj_id INTEGER PRIMARY KEY, pool_type INTEGER NOT NULL, FOREIGN KEY(obj_id) REFERENCES tsk_objects(obj_id) ON DELETE CASCADE)");
            } else {
                statement.execute("CREATE TABLE tsk_pool_info (obj_id BIGSERIAL PRIMARY KEY, pool_type INTEGER NOT NULL, FOREIGN KEY(obj_id) REFERENCES tsk_objects(obj_id) ON DELETE CASCADE)");
            }
            this.insertAccountTypeIfNotExists(statement, "IMO", "IMO");
            this.insertAccountTypeIfNotExists(statement, "LINE", "LINE");
            this.insertAccountTypeIfNotExists(statement, "SKYPE", "Skype");
            this.insertAccountTypeIfNotExists(statement, "TANGO", "Tango");
            this.insertAccountTypeIfNotExists(statement, "TEXTNOW", "TextNow");
            this.insertAccountTypeIfNotExists(statement, "THREEMA", "ThreeMa");
            this.insertAccountTypeIfNotExists(statement, "VIBER", "Viber");
            this.insertAccountTypeIfNotExists(statement, "XENDER", "Xender");
            this.insertAccountTypeIfNotExists(statement, "ZAPYA", "Zapya");
            this.insertAccountTypeIfNotExists(statement, "SHAREIT", "ShareIt");
            caseDbSchemaVersionNumber = new CaseDbSchemaVersionNumber(8, 4);
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(results);
            SleuthkitCase.closeStatement(statement);
            this.releaseSingleUserCaseWriteLock();
            throw throwable;
        }
        SleuthkitCase.closeResultSet(results);
        SleuthkitCase.closeStatement(statement);
        this.releaseSingleUserCaseWriteLock();
        return caseDbSchemaVersionNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaseDbSchemaVersionNumber updateFromSchema8dot4toSchema8dot5(CaseDbSchemaVersionNumber schemaVersion, CaseDbConnection connection) throws SQLException, TskCoreException {
        if (schemaVersion.getMajor() != 8) {
            return schemaVersion;
        }
        if (schemaVersion.getMinor() != 4) {
            return schemaVersion;
        }
        Statement statement = connection.createStatement();
        this.acquireSingleUserCaseWriteLock();
        try {
            block32: {
                switch (this.getDatabaseType()) {
                    case POSTGRESQL: {
                        statement.execute("CREATE TABLE tsk_tag_sets (tag_set_id BIGSERIAL PRIMARY KEY, name TEXT UNIQUE)");
                        statement.execute("ALTER TABLE tag_names ADD COLUMN tag_set_id BIGINT REFERENCES tsk_tag_sets(tag_set_id)");
                        break;
                    }
                    case SQLITE: {
                        statement.execute("CREATE TABLE tsk_tag_sets (tag_set_id INTEGER PRIMARY KEY, name TEXT UNIQUE)");
                        statement.execute("ALTER TABLE tag_names ADD COLUMN tag_set_id INTEGER REFERENCES tsk_tag_sets(tag_set_id)");
                    }
                }
                statement.execute("ALTER TABLE tag_names ADD COLUMN rank INTEGER");
                String insertStmt = "INSERT INTO tsk_tag_sets (name) VALUES ('Project VIC')";
                if (this.getDatabaseType() == TskData.DbType.POSTGRESQL) {
                    statement.execute(insertStmt, 1);
                } else {
                    statement.execute(insertStmt);
                }
                try (ResultSet resultSet = statement.getGeneratedKeys();){
                    if (resultSet != null && resultSet.next()) {
                        int tagSetId = resultSet.getInt(1);
                        String updateQuery = "UPDATE tag_names SET tag_set_id = %d, color = '%s', rank = %d, display_name = '%s' WHERE display_name = '%s'";
                        statement.executeUpdate(String.format(updateQuery, tagSetId, "Red", 1, "Child Exploitation (Illegal)", "CAT-1: Child Exploitation (Illegal)"));
                        statement.executeUpdate(String.format(updateQuery, tagSetId, "Lime", 2, "Child Exploitation (Non-Illegal/Age Difficult)", "CAT-2: Child Exploitation (Non-Illegal/Age Difficult)"));
                        statement.executeUpdate(String.format(updateQuery, tagSetId, "Yellow", 3, "CGI/Animation (Child Exploitive)", "CAT-3: CGI/Animation (Child Exploitive)"));
                        statement.executeUpdate(String.format(updateQuery, tagSetId, "Purple", 4, "Exemplar/Comparison (Internal Use Only)", "CAT-4: Exemplar/Comparison (Internal Use Only)"));
                        statement.executeUpdate(String.format(updateQuery, tagSetId, "Fuchsia", 5, "Non-pertinent", "CAT-5: Non-pertinent"));
                        String deleteContentTag = "DELETE FROM content_tags WHERE tag_name_id IN (SELECT tag_name_id from tag_names WHERE display_name LIKE 'CAT-0: Uncategorized')";
                        String deleteArtifactTag = "DELETE FROM blackboard_artifact_tags WHERE tag_name_id IN (SELECT tag_name_id from tag_names WHERE display_name LIKE 'CAT-0: Uncategorized')";
                        String deleteCat0 = "DELETE FROM tag_names WHERE display_name = 'CAT-0: Uncategorized'";
                        statement.executeUpdate(deleteContentTag);
                        statement.executeUpdate(deleteArtifactTag);
                        statement.executeUpdate(deleteCat0);
                        break block32;
                    }
                    throw new TskCoreException("Failed to retrieve the default tag_set_id from DB");
                }
            }
            switch (this.getDatabaseType()) {
                case POSTGRESQL: {
                    statement.execute("ALTER TABLE tsk_fs_info ADD COLUMN data_source_obj_id BIGINT NOT NULL DEFAULT -1;");
                    break;
                }
                case SQLITE: {
                    statement.execute("ALTER TABLE tsk_fs_info ADD COLUMN data_source_obj_id INTEGER NOT NULL DEFAULT -1;");
                }
            }
            Statement updateStatement = connection.createStatement();
            try (ResultSet resultSet = statement.executeQuery("SELECT obj_id FROM tsk_fs_info");){
                while (resultSet.next()) {
                    long fsId = resultSet.getLong("obj_id");
                    long dataSourceId = this.getDataSourceObjectId(connection, fsId);
                    updateStatement.executeUpdate("UPDATE tsk_fs_info SET data_source_obj_id = " + dataSourceId + " WHERE obj_id = " + fsId + ";");
                }
            }
            finally {
                SleuthkitCase.closeStatement(updateStatement);
            }
            CaseDbSchemaVersionNumber caseDbSchemaVersionNumber = new CaseDbSchemaVersionNumber(8, 5);
            return caseDbSchemaVersionNumber;
        }
        finally {
            SleuthkitCase.closeStatement(statement);
            this.releaseSingleUserCaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaseDbSchemaVersionNumber updateFromSchema8dot5toSchema8dot6(CaseDbSchemaVersionNumber schemaVersion, CaseDbConnection connection) throws SQLException, TskCoreException {
        if (schemaVersion.getMajor() != 8) {
            return schemaVersion;
        }
        if (schemaVersion.getMinor() != 5) {
            return schemaVersion;
        }
        Statement statement = connection.createStatement();
        this.acquireSingleUserCaseWriteLock();
        try {
            statement.execute("ALTER TABLE tsk_files ADD COLUMN sha256 TEXT");
            CaseDbSchemaVersionNumber caseDbSchemaVersionNumber = new CaseDbSchemaVersionNumber(8, 6);
            return caseDbSchemaVersionNumber;
        }
        finally {
            SleuthkitCase.closeStatement(statement);
            this.releaseSingleUserCaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaseDbSchemaVersionNumber updateFromSchema8dot6toSchema9dot0(CaseDbSchemaVersionNumber schemaVersion, CaseDbConnection connection) throws SQLException, TskCoreException {
        if (schemaVersion.getMajor() != 8) {
            return schemaVersion;
        }
        if (schemaVersion.getMinor() != 6) {
            return schemaVersion;
        }
        Statement statement = connection.createStatement();
        this.acquireSingleUserCaseWriteLock();
        try {
            String dateDataType = "BIGINT";
            String bigIntDataType = "BIGINT";
            String blobDataType = "BYTEA";
            String primaryKeyType = "BIGSERIAL";
            if (this.dbType.equals((Object)TskData.DbType.SQLITE)) {
                dateDataType = "INTEGER";
                bigIntDataType = "INTEGER";
                blobDataType = "BLOB";
                primaryKeyType = "INTEGER";
            }
            statement.execute("ALTER TABLE data_source_info ADD COLUMN added_date_time " + dateDataType);
            statement.execute("ALTER TABLE data_source_info ADD COLUMN acquisition_tool_settings TEXT");
            statement.execute("ALTER TABLE data_source_info ADD COLUMN acquisition_tool_name TEXT");
            statement.execute("ALTER TABLE data_source_info ADD COLUMN acquisition_tool_version TEXT");
            statement.execute("ALTER TABLE blackboard_artifact_types ADD COLUMN category_type INTEGER DEFAULT 0");
            String analysisTypeObjIdList = BlackboardArtifact.ARTIFACT_TYPE.TSK_KEYWORD_HIT.getTypeID() + ", " + BlackboardArtifact.ARTIFACT_TYPE.TSK_HASHSET_HIT.getTypeID() + ", " + BlackboardArtifact.ARTIFACT_TYPE.TSK_INTERESTING_FILE_HIT.getTypeID() + ", " + BlackboardArtifact.ARTIFACT_TYPE.TSK_TAG_FILE.getTypeID() + ", " + BlackboardArtifact.ARTIFACT_TYPE.TSK_TAG_ARTIFACT.getTypeID() + ", " + BlackboardArtifact.ARTIFACT_TYPE.TSK_ENCRYPTION_DETECTED.getTypeID() + ", " + BlackboardArtifact.ARTIFACT_TYPE.TSK_EXT_MISMATCH_DETECTED.getTypeID() + ", " + BlackboardArtifact.ARTIFACT_TYPE.TSK_INTERESTING_ARTIFACT_HIT.getTypeID() + ", " + BlackboardArtifact.ARTIFACT_TYPE.TSK_FACE_DETECTED.getTypeID() + ", " + BlackboardArtifact.ARTIFACT_TYPE.TSK_ENCRYPTION_SUSPECTED.getTypeID() + ", " + BlackboardArtifact.ARTIFACT_TYPE.TSK_OBJECT_DETECTED.getTypeID() + ", " + BlackboardArtifact.ARTIFACT_TYPE.TSK_VERIFICATION_FAILED.getTypeID() + ", " + BlackboardArtifact.ARTIFACT_TYPE.TSK_DATA_SOURCE_USAGE.getTypeID() + ", " + BlackboardArtifact.ARTIFACT_TYPE.TSK_USER_CONTENT_SUSPECTED.getTypeID() + ", " + BlackboardArtifact.ARTIFACT_TYPE.TSK_WEB_ACCOUNT_TYPE.getTypeID() + ", " + BlackboardArtifact.ARTIFACT_TYPE.TSK_YARA_HIT.getTypeID() + ", " + BlackboardArtifact.ARTIFACT_TYPE.TSK_WEB_CATEGORIZATION.getTypeID();
            statement.execute("UPDATE blackboard_artifact_types SET category_type = " + BlackboardArtifact.Category.ANALYSIS_RESULT.getID() + " WHERE artifact_type_id IN (" + analysisTypeObjIdList + ")");
            statement.execute("CREATE TABLE tsk_file_attributes (id " + primaryKeyType + " PRIMARY KEY, obj_id " + bigIntDataType + " NOT NULL, attribute_type_id " + bigIntDataType + " NOT NULL, value_type INTEGER NOT NULL, value_byte " + blobDataType + ", value_text TEXT, value_int32 INTEGER, value_int64 " + bigIntDataType + ", value_double NUMERIC(20, 10), FOREIGN KEY(obj_id) REFERENCES tsk_files(obj_id) ON DELETE CASCADE, FOREIGN KEY(attribute_type_id) REFERENCES blackboard_attribute_types(attribute_type_id))");
            statement.execute("CREATE TABLE tsk_analysis_results (artifact_obj_id " + bigIntDataType + " PRIMARY KEY, conclusion TEXT, significance INTEGER NOT NULL, configuration TEXT, justification TEXT, ignore_score INTEGER DEFAULT 0 )");
            statement.execute("CREATE TABLE tsk_aggregate_score( obj_id " + bigIntDataType + " PRIMARY KEY, data_source_obj_id " + bigIntDataType + ", significance INTEGER NOT NULL, UNIQUE (obj_id),FOREIGN KEY(obj_id) REFERENCES tsk_objects(obj_id) ON DELETE CASCADE, FOREIGN KEY(data_source_obj_id) REFERENCES tsk_objects(obj_id) ON DELETE CASCADE )");
            statement.execute("CREATE TABLE tsk_persons (id " + primaryKeyType + " PRIMARY KEY, name TEXT NOT NULL, UNIQUE(name)) ");
            statement.execute("CREATE TABLE tsk_hosts (id " + primaryKeyType + " PRIMARY KEY, name TEXT NOT NULL, db_status INTEGER DEFAULT 0, person_id INTEGER, merged_into " + bigIntDataType + ", FOREIGN KEY(person_id) REFERENCES tsk_persons(id) ON DELETE SET NULL, FOREIGN KEY(merged_into) REFERENCES tsk_hosts(id), UNIQUE(name)) ");
            statement.execute("CREATE TABLE tsk_os_account_realms (id " + primaryKeyType + " PRIMARY KEY, realm_name TEXT DEFAULT NULL, realm_addr TEXT DEFAULT NULL, realm_signature TEXT NOT NULL, scope_host_id " + bigIntDataType + " DEFAULT NULL, scope_confidence INTEGER, db_status INTEGER DEFAULT 0, merged_into " + bigIntDataType + " DEFAULT NULL, UNIQUE(realm_signature), FOREIGN KEY(scope_host_id) REFERENCES tsk_hosts(id),FOREIGN KEY(merged_into) REFERENCES tsk_os_account_realms(id) )");
            statement.execute("ALTER TABLE data_source_info ADD COLUMN host_id INTEGER REFERENCES tsk_hosts(id)");
            Statement updateStatement = connection.createStatement();
            try (ResultSet resultSet = statement.executeQuery("SELECT obj_id, device_id FROM data_source_info");){
                HashMap<String, Long> hostMap = new HashMap<String, Long>();
                long hostIndex = 1L;
                while (resultSet.next()) {
                    long objId = resultSet.getLong("obj_id");
                    String deviceId = resultSet.getString("device_id");
                    if (!hostMap.containsKey(deviceId)) {
                        String hostName = "Host " + hostIndex;
                        updateStatement.execute("INSERT INTO tsk_hosts (name, db_status) VALUES ('" + hostName + "', 0)");
                        hostMap.put(deviceId, hostIndex);
                        ++hostIndex;
                    }
                    updateStatement.execute("UPDATE data_source_info SET host_id = " + String.valueOf(hostMap.get(deviceId)) + " WHERE obj_id = " + objId);
                }
            }
            finally {
                SleuthkitCase.closeStatement(updateStatement);
            }
            statement.execute("CREATE TABLE tsk_os_accounts (os_account_obj_id " + bigIntDataType + " PRIMARY KEY, login_name TEXT DEFAULT NULL, full_name TEXT DEFAULT NULL, realm_id " + bigIntDataType + " NOT NULL, addr TEXT DEFAULT NULL, signature TEXT NOT NULL, status INTEGER, type INTEGER, created_date " + bigIntDataType + " DEFAULT NULL, db_status INTEGER DEFAULT 0, merged_into " + bigIntDataType + " DEFAULT NULL, UNIQUE(signature, realm_id), FOREIGN KEY(os_account_obj_id) REFERENCES tsk_objects(obj_id) ON DELETE CASCADE, FOREIGN KEY(realm_id) REFERENCES tsk_os_account_realms(id),FOREIGN KEY(merged_into) REFERENCES tsk_os_accounts(os_account_obj_id) )");
            statement.execute("CREATE TABLE tsk_os_account_attributes (id " + primaryKeyType + " PRIMARY KEY, os_account_obj_id " + bigIntDataType + " NOT NULL, host_id " + bigIntDataType + ", source_obj_id " + bigIntDataType + ", attribute_type_id " + bigIntDataType + " NOT NULL, value_type INTEGER NOT NULL, value_byte " + bigIntDataType + ", value_text TEXT, value_int32 INTEGER, value_int64 " + bigIntDataType + ", value_double NUMERIC(20, 10), FOREIGN KEY(os_account_obj_id) REFERENCES tsk_os_accounts(os_account_obj_id), FOREIGN KEY(host_id) REFERENCES tsk_hosts(id), FOREIGN KEY(source_obj_id) REFERENCES tsk_objects(obj_id) ON DELETE SET NULL, FOREIGN KEY(attribute_type_id) REFERENCES blackboard_attribute_types(attribute_type_id))");
            statement.execute("CREATE TABLE tsk_os_account_instances (id " + primaryKeyType + " PRIMARY KEY, os_account_obj_id " + bigIntDataType + " NOT NULL, data_source_obj_id " + bigIntDataType + " NOT NULL, instance_type INTEGER NOT NULL, UNIQUE(os_account_obj_id, data_source_obj_id), FOREIGN KEY(os_account_obj_id) REFERENCES tsk_os_accounts(os_account_obj_id), FOREIGN KEY(data_source_obj_id) REFERENCES tsk_objects(obj_id) ON DELETE CASCADE )");
            statement.execute("CREATE TABLE tsk_data_artifacts ( artifact_obj_id " + bigIntDataType + " PRIMARY KEY, os_account_obj_id " + bigIntDataType + ", FOREIGN KEY(os_account_obj_id) REFERENCES tsk_os_accounts(os_account_obj_id)) ");
            statement.execute("ALTER TABLE tsk_files ADD COLUMN owner_uid TEXT DEFAULT NULL");
            statement.execute("ALTER TABLE tsk_files ADD COLUMN os_account_obj_id " + bigIntDataType + " DEFAULT NULL REFERENCES tsk_os_accounts(os_account_obj_id) ");
            statement.execute("CREATE TABLE tsk_host_addresses (id " + primaryKeyType + " PRIMARY KEY, address_type INTEGER NOT NULL, address TEXT NOT NULL, UNIQUE(address_type, address)) ");
            statement.execute("CREATE TABLE tsk_host_address_map (id " + primaryKeyType + " PRIMARY KEY, host_id " + bigIntDataType + " NOT NULL, addr_obj_id " + bigIntDataType + " NOT NULL, source_obj_id " + bigIntDataType + ", time " + bigIntDataType + ", UNIQUE(host_id, addr_obj_id, time), FOREIGN KEY(host_id) REFERENCES tsk_hosts(id) ON DELETE CASCADE, FOREIGN KEY(addr_obj_id) REFERENCES tsk_host_addresses(id), FOREIGN KEY(source_obj_id) REFERENCES tsk_objects(obj_id) ON DELETE SET NULL )");
            statement.execute("CREATE TABLE tsk_host_address_dns_ip_map (id " + primaryKeyType + " PRIMARY KEY, dns_address_id " + bigIntDataType + " NOT NULL, ip_address_id " + bigIntDataType + " NOT NULL, source_obj_id " + bigIntDataType + ", time " + bigIntDataType + ", UNIQUE(dns_address_id, ip_address_id, time), FOREIGN KEY(dns_address_id) REFERENCES tsk_host_addresses(id) ON DELETE CASCADE, FOREIGN KEY(ip_address_id) REFERENCES tsk_host_addresses(id) ON DELETE CASCADE,FOREIGN KEY(source_obj_id) REFERENCES tsk_objects(obj_id) ON DELETE SET NULL )");
            statement.execute("CREATE TABLE tsk_host_address_usage (id " + primaryKeyType + " PRIMARY KEY, addr_obj_id " + bigIntDataType + " NOT NULL, obj_id " + bigIntDataType + " NOT NULL, data_source_obj_id " + bigIntDataType + " NOT NULL, UNIQUE(addr_obj_id, obj_id), FOREIGN KEY(addr_obj_id) REFERENCES tsk_host_addresses(id) ON DELETE CASCADE, FOREIGN KEY(obj_id) REFERENCES tsk_objects(obj_id) ON DELETE CASCADE )");
            CaseDbSchemaVersionNumber caseDbSchemaVersionNumber = new CaseDbSchemaVersionNumber(9, 0);
            return caseDbSchemaVersionNumber;
        }
        finally {
            SleuthkitCase.closeStatement(statement);
            this.releaseSingleUserCaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaseDbSchemaVersionNumber updateFromSchema9dot0toSchema9dot1(CaseDbSchemaVersionNumber schemaVersion, CaseDbConnection connection) throws SQLException, TskCoreException {
        CaseDbSchemaVersionNumber caseDbSchemaVersionNumber;
        if (schemaVersion.getMajor() != 9) {
            return schemaVersion;
        }
        if (schemaVersion.getMinor() != 0) {
            return schemaVersion;
        }
        Statement statement = connection.createStatement();
        ResultSet results = null;
        this.acquireSingleUserCaseWriteLock();
        try {
            switch (this.getDatabaseType()) {
                case POSTGRESQL: {
                    results = statement.executeQuery("SELECT column_name FROM information_schema.columns WHERE table_name='tsk_analysis_results' and column_name='method_category'");
                    if (!results.next()) break;
                    statement.execute("ALTER TABLE tsk_analysis_results DROP COLUMN method_category");
                    statement.execute("ALTER TABLE tsk_aggregate_score DROP COLUMN method_category");
                    break;
                }
                case SQLITE: {
                    boolean hasMisnamedColumn = false;
                    results = statement.executeQuery("pragma table_info('tsk_analysis_results')");
                    while (results.next()) {
                        if (results.getString("name") == null || !results.getString("name").equals("method_category")) continue;
                        hasMisnamedColumn = true;
                        break;
                    }
                    if (!hasMisnamedColumn) break;
                    statement.execute("CREATE TABLE temp_tsk_analysis_results (artifact_obj_id INTEGER PRIMARY KEY, conclusion TEXT, significance INTEGER NOT NULL, configuration TEXT, justification TEXT, ignore_score INTEGER DEFAULT 0 )");
                    statement.execute("CREATE TABLE temp_tsk_aggregate_score( obj_id INTEGER PRIMARY KEY, data_source_obj_id INTEGER, significance INTEGER NOT NULL, UNIQUE (obj_id),FOREIGN KEY(obj_id) REFERENCES tsk_objects(obj_id) ON DELETE CASCADE, FOREIGN KEY(data_source_obj_id) REFERENCES tsk_objects(obj_id) ON DELETE CASCADE )");
                    statement.execute("INSERT INTO temp_tsk_analysis_results(artifact_obj_id, conclusion, justification, significance, configuration, ignore_score) SELECT artifact_obj_id, conclusion, justification, significance, configuration, ignore_score FROM tsk_analysis_results");
                    statement.execute("INSERT INTO temp_tsk_aggregate_score(obj_id, data_source_obj_id, significance) SELECT obj_id, data_source_obj_id, significance FROM tsk_aggregate_score");
                    statement.execute("DROP TABLE tsk_analysis_results");
                    statement.execute("DROP TABLE tsk_aggregate_score");
                    statement.execute("ALTER TABLE temp_tsk_analysis_results RENAME TO tsk_analysis_results");
                    statement.execute("ALTER TABLE temp_tsk_aggregate_score RENAME TO tsk_aggregate_score");
                    break;
                }
                default: {
                    throw new TskCoreException("Unsupported database type: " + this.getDatabaseType().toString());
                }
            }
            statement.execute("CREATE INDEX tsk_file_attributes_obj_id ON tsk_file_attributes(obj_id)");
            statement.execute("ALTER TABLE tsk_analysis_results ADD COLUMN priority INTEGER NOT NULL DEFAULT " + Score.Priority.NORMAL.getId());
            statement.execute("ALTER TABLE tsk_aggregate_score ADD COLUMN priority INTEGER NOT NULL DEFAULT " + Score.Priority.NORMAL.getId());
            statement.execute("UPDATE blackboard_artifact_types SET category_type = 1 WHERE artifact_type_id = 16");
            caseDbSchemaVersionNumber = new CaseDbSchemaVersionNumber(9, 1);
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(results);
            SleuthkitCase.closeStatement(statement);
            this.releaseSingleUserCaseWriteLock();
            throw throwable;
        }
        SleuthkitCase.closeResultSet(results);
        SleuthkitCase.closeStatement(statement);
        this.releaseSingleUserCaseWriteLock();
        return caseDbSchemaVersionNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaseDbSchemaVersionNumber updateFromSchema9dot1toSchema9dot2(CaseDbSchemaVersionNumber schemaVersion, CaseDbConnection connection) throws SQLException, TskCoreException {
        if (schemaVersion.getMajor() != 9) {
            return schemaVersion;
        }
        if (schemaVersion.getMinor() != 1) {
            return schemaVersion;
        }
        Statement updateSchemaStatement = connection.createStatement();
        ResultSet results = null;
        this.acquireSingleUserCaseWriteLock();
        try {
            String bigIntDataType = "BIGINT";
            String primaryKeyType = "BIGSERIAL";
            if (this.dbType.equals((Object)TskData.DbType.SQLITE)) {
                bigIntDataType = "INTEGER";
                primaryKeyType = "INTEGER";
            }
            updateSchemaStatement.execute("ALTER TABLE tsk_os_account_instances RENAME TO old_tsk_os_account_instances");
            updateSchemaStatement.execute("CREATE TABLE tsk_os_account_instances (id " + primaryKeyType + " PRIMARY KEY, os_account_obj_id " + bigIntDataType + " NOT NULL, data_source_obj_id " + bigIntDataType + " NOT NULL, instance_type INTEGER NOT NULL, UNIQUE(os_account_obj_id, data_source_obj_id, instance_type), FOREIGN KEY(os_account_obj_id) REFERENCES tsk_os_accounts(os_account_obj_id) ON DELETE CASCADE, FOREIGN KEY(data_source_obj_id) REFERENCES tsk_objects(obj_id) ON DELETE CASCADE ) ");
            updateSchemaStatement.execute("INSERT INTO tsk_os_account_instances(os_account_obj_id, data_source_obj_id, instance_type) SELECT os_account_obj_id, data_source_obj_id, instance_type FROM old_tsk_os_account_instances ORDER BY id ASC");
            updateSchemaStatement.execute("DROP TABLE old_tsk_os_account_instances");
            CaseDbSchemaVersionNumber caseDbSchemaVersionNumber = new CaseDbSchemaVersionNumber(9, 2);
            return caseDbSchemaVersionNumber;
        }
        finally {
            SleuthkitCase.closeResultSet(results);
            SleuthkitCase.closeStatement(updateSchemaStatement);
            this.releaseSingleUserCaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaseDbSchemaVersionNumber updateFromSchema9dot2toSchema9dot3(CaseDbSchemaVersionNumber schemaVersion, CaseDbConnection connection) throws SQLException, TskCoreException {
        if (schemaVersion.getMajor() != 9) {
            return schemaVersion;
        }
        if (schemaVersion.getMinor() != 2) {
            return schemaVersion;
        }
        Statement statement = connection.createStatement();
        this.acquireSingleUserCaseWriteLock();
        try {
            statement.execute("ALTER TABLE tsk_files ADD COLUMN sha1 TEXT");
            CaseDbSchemaVersionNumber caseDbSchemaVersionNumber = new CaseDbSchemaVersionNumber(9, 3);
            return caseDbSchemaVersionNumber;
        }
        finally {
            SleuthkitCase.closeStatement(statement);
            this.releaseSingleUserCaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaseDbSchemaVersionNumber updateFromSchema9dot3toSchema9dot4(CaseDbSchemaVersionNumber schemaVersion, CaseDbConnection connection) throws SQLException, TskCoreException {
        if (schemaVersion.getMajor() != 9) {
            return schemaVersion;
        }
        if (schemaVersion.getMinor() != 3) {
            return schemaVersion;
        }
        Statement statement = connection.createStatement();
        this.acquireSingleUserCaseWriteLock();
        try {
            statement.execute("CREATE TABLE file_collection_status_types (collection_status_type INTEGER PRIMARY KEY, name TEXT NOT NULL);");
            this.initCollectedStatusTypes(connection);
            statement.execute("ALTER TABLE tsk_files ADD COLUMN collected INTEGER NOT NULL DEFAULT " + TskData.CollectedStatus.UNKNOWN.getType() + ";");
            CaseDbSchemaVersionNumber caseDbSchemaVersionNumber = new CaseDbSchemaVersionNumber(9, 4);
            return caseDbSchemaVersionNumber;
        }
        finally {
            SleuthkitCase.closeStatement(statement);
            this.releaseSingleUserCaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaseDbSchemaVersionNumber updateFromSchema9dot4toSchema9dot5(CaseDbSchemaVersionNumber schemaVersion, CaseDbConnection connection) throws SQLException, TskCoreException {
        if (schemaVersion.getMajor() != 9) {
            return schemaVersion;
        }
        if (schemaVersion.getMinor() != 4) {
            return schemaVersion;
        }
        Statement statement = connection.createStatement();
        this.acquireSingleUserCaseWriteLock();
        try {
            statement.execute("CREATE INDEX tsk_os_accounts_login_name_idx  ON tsk_os_accounts(login_name, db_status, realm_id)");
            statement.execute("CREATE INDEX tsk_os_accounts_addr_idx  ON tsk_os_accounts(addr, db_status, realm_id)");
            statement.execute("CREATE INDEX tsk_os_account_realms_realm_name_idx  ON tsk_os_account_realms(realm_name)");
            statement.execute("CREATE INDEX tsk_os_account_realms_realm_addr_idx  ON tsk_os_account_realms(realm_addr)");
            CaseDbSchemaVersionNumber caseDbSchemaVersionNumber = new CaseDbSchemaVersionNumber(9, 5);
            return caseDbSchemaVersionNumber;
        }
        finally {
            SleuthkitCase.closeStatement(statement);
            this.releaseSingleUserCaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaseDbSchemaVersionNumber updateFromSchema9dot5toSchema9dot6(CaseDbSchemaVersionNumber schemaVersion, CaseDbConnection connection) throws SQLException, TskCoreException {
        if (schemaVersion.getMajor() != 9) {
            return schemaVersion;
        }
        if (schemaVersion.getMinor() != 5) {
            return schemaVersion;
        }
        String insertSQL = "";
        switch (this.getDatabaseType()) {
            case POSTGRESQL: {
                insertSQL = "CREATE INDEX tsk_files_datasrc_md5_size_partial_index ON tsk_files(data_source_obj_id, md5, size) WHERE md5 IS NOT NULL AND size > 0";
                break;
            }
            case SQLITE: {
                insertSQL = "CREATE INDEX tsk_files_datasrc_md5_size_index ON tsk_files(data_source_obj_id, md5, size)";
                break;
            }
            default: {
                throw new TskCoreException("Unknown DB Type: " + this.getDatabaseType().name());
            }
        }
        Statement statement = connection.createStatement();
        this.acquireSingleUserCaseWriteLock();
        try {
            statement.execute(insertSQL);
            CaseDbSchemaVersionNumber caseDbSchemaVersionNumber = new CaseDbSchemaVersionNumber(9, 6);
            return caseDbSchemaVersionNumber;
        }
        finally {
            SleuthkitCase.closeStatement(statement);
            this.releaseSingleUserCaseWriteLock();
        }
    }

    private void insertAccountTypeIfNotExists(Statement statement, String type_name, String display_name) throws TskCoreException, SQLException {
        Object insertSQL = String.format("INTO account_types(type_name, display_name) VALUES ('%s', '%s')", type_name, display_name);
        switch (this.getDatabaseType()) {
            case POSTGRESQL: {
                insertSQL = "INSERT " + (String)insertSQL + " ON CONFLICT DO NOTHING";
                break;
            }
            case SQLITE: {
                insertSQL = "INSERT OR IGNORE " + (String)insertSQL;
                break;
            }
            default: {
                throw new TskCoreException("Unknown DB Type: " + this.getDatabaseType().name());
            }
        }
        statement.execute((String)insertSQL);
    }

    static String extractExtension(String fileName) {
        int i = fileName.lastIndexOf(".");
        if (i <= 0 || i + 1 >= fileName.length()) {
            return "";
        }
        String ext = fileName.substring(i + 1);
        return ext.toLowerCase();
    }

    @Deprecated
    public int getSchemaVersion() {
        return this.getDBSchemaVersion().getMajor();
    }

    public VersionNumber getDBSchemaVersion() {
        return CURRENT_DB_SCHEMA_VERSION;
    }

    public CaseDbSchemaVersionNumber getDBSchemaCreationVersion() {
        return this.caseDBSchemaCreationVersion;
    }

    public TskData.DbType getDatabaseType() {
        return this.dbType;
    }

    public String getBackupDatabasePath() {
        return this.dbBackupPath;
    }

    public CaseDbTransaction beginTransaction() throws TskCoreException {
        return new CaseDbTransaction(this);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getDbDirPath() {
        return this.caseDirPath;
    }

    public void acquireSingleUserCaseWriteLock() {
        if (this.dbType == TskData.DbType.SQLITE) {
            this.rwLock.writeLock().lock();
        }
    }

    public void releaseSingleUserCaseWriteLock() {
        if (this.dbType == TskData.DbType.SQLITE) {
            this.rwLock.writeLock().unlock();
        }
    }

    public void acquireSingleUserCaseReadLock() {
        if (this.dbType == TskData.DbType.SQLITE) {
            this.rwLock.readLock().lock();
        }
    }

    public void releaseSingleUserCaseReadLock() {
        if (this.dbType == TskData.DbType.SQLITE) {
            this.rwLock.readLock().unlock();
        }
    }

    public static SleuthkitCase openCase(String dbPath) throws TskCoreException {
        return SleuthkitCase.openCase(dbPath, null);
    }

    @Beta
    public static SleuthkitCase openCase(String dbPath, ContentStreamProvider contentProvider) throws TskCoreException {
        return SleuthkitCase.openCase(dbPath, contentProvider, null);
    }

    @Beta
    public static SleuthkitCase openCase(String dbPath, ContentStreamProvider contentProvider, String lockingApplicationName) throws TskCoreException {
        return SleuthkitCase.openCase(dbPath, contentProvider, null, false);
    }

    @Beta
    public static SleuthkitCase openCase(String dbPath, ContentStreamProvider contentProvider, String lockingApplicationName, boolean useWAL) throws TskCoreException {
        try {
            SleuthkitJNI.CaseDbHandle caseHandle = SleuthkitJNI.openCaseDb(dbPath);
            return new SleuthkitCase(dbPath, caseHandle, TskData.DbType.SQLITE, contentProvider, lockingApplicationName, useWAL);
        }
        catch (TskUnsupportedSchemaVersionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new TskCoreException("Failed to open case database at " + dbPath, ex);
        }
    }

    public static SleuthkitCase openCase(String databaseName, CaseDbConnectionInfo info, String caseDir) throws TskCoreException {
        return SleuthkitCase.openCase(databaseName, info, caseDir, null);
    }

    @Beta
    public static SleuthkitCase openCase(String databaseName, CaseDbConnectionInfo info, String caseDir, ContentStreamProvider contentProvider) throws TskCoreException {
        try {
            SleuthkitJNI.CaseDbHandle caseHandle = SleuthkitJNI.openCaseDb(databaseName, info);
            return new SleuthkitCase(info, databaseName, caseHandle, caseDir, contentProvider);
        }
        catch (PropertyVetoException exp) {
            throw new TskCoreException(exp.getMessage(), exp);
        }
        catch (TskUnsupportedSchemaVersionException ex) {
            throw ex;
        }
        catch (Exception exp) {
            SleuthkitCase.tryConnect(info);
            throw new TskCoreException(exp.getMessage(), exp);
        }
    }

    public static SleuthkitCase newCase(String dbPath) throws TskCoreException {
        return SleuthkitCase.newCase(dbPath, null);
    }

    @Beta
    public static SleuthkitCase newCase(String dbPath, ContentStreamProvider contentProvider) throws TskCoreException {
        return SleuthkitCase.newCase(dbPath, contentProvider, null);
    }

    @Beta
    public static SleuthkitCase newCase(String dbPath, ContentStreamProvider contentProvider, String lockingApplicationName) throws TskCoreException {
        return SleuthkitCase.newCase(dbPath, contentProvider, null, false);
    }

    @Beta
    public static SleuthkitCase newCase(String dbPath, ContentStreamProvider contentProvider, String lockingApplicationName, boolean useWAL) throws TskCoreException {
        try {
            CaseDatabaseFactory factory = new CaseDatabaseFactory(dbPath);
            factory.createCaseDatabase();
            SleuthkitJNI.CaseDbHandle caseHandle = SleuthkitJNI.openCaseDb(dbPath);
            return new SleuthkitCase(dbPath, caseHandle, TskData.DbType.SQLITE, contentProvider, lockingApplicationName, useWAL);
        }
        catch (Exception ex) {
            throw new TskCoreException("Failed to create case database at " + dbPath, ex);
        }
    }

    public static SleuthkitCase newCase(String caseName, CaseDbConnectionInfo info, String caseDirPath) throws TskCoreException {
        return SleuthkitCase.newCase(caseName, info, caseDirPath, null);
    }

    @Beta
    public static SleuthkitCase newCase(String caseName, CaseDbConnectionInfo info, String caseDirPath, ContentStreamProvider contentProvider) throws TskCoreException {
        String databaseName = SleuthkitCase.createCaseDataBaseName(caseName);
        try {
            CaseDatabaseFactory factory = new CaseDatabaseFactory(databaseName, info);
            factory.createCaseDatabase();
            SleuthkitJNI.CaseDbHandle caseHandle = SleuthkitJNI.openCaseDb(databaseName, info);
            return new SleuthkitCase(info, databaseName, caseHandle, caseDirPath, contentProvider);
        }
        catch (PropertyVetoException exp) {
            throw new TskCoreException(exp.getMessage(), exp);
        }
        catch (Exception exp) {
            SleuthkitCase.tryConnect(info);
            throw new TskCoreException(exp.getMessage(), exp);
        }
    }

    private static String createCaseDataBaseName(String candidateDbName) {
        Object dbName;
        if (!candidateDbName.isEmpty()) {
            dbName = candidateDbName.replaceAll("[^\\p{ASCII}]", "_");
            dbName = ((String)dbName).replaceAll("[\\p{Cntrl}]", "_");
            dbName = ((String)dbName).replaceAll("[ /?:'\"\\\\]", "_");
            if (((String)(dbName = ((String)dbName).toLowerCase())).length() > 0 && !Character.isLetter(((String)dbName).codePointAt(0)) && ((String)dbName).codePointAt(0) != 95) {
                dbName = "_" + (String)dbName;
            }
            if (((String)dbName).length() > 47) {
                dbName = ((String)dbName).substring(0, 47);
            }
        } else {
            dbName = "_";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        Date date = new Date();
        dbName = (String)dbName + "_" + dateFormat.format(date);
        return dbName;
    }

    @Beta
    public void disableTimelineEventCreation() {
        this.timelineEventsDisabled.set(true);
    }

    public Examiner getCurrentExaminer() throws TskCoreException {
        CaseDbConnection connection;
        ResultSet resultSet;
        String loginName;
        block7: {
            if (this.cachedCurrentExaminer != null) {
                return this.cachedCurrentExaminer;
            }
            loginName = System.getProperty("user.name");
            if (loginName == null || loginName.isEmpty()) {
                throw new TskCoreException("Failed to determine logged in user name.");
            }
            resultSet = null;
            connection = null;
            this.acquireSingleUserCaseReadLock();
            connection = this.connections.getConnection();
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_EXAMINER_BY_LOGIN_NAME);
            statement.clearParameters();
            statement.setString(1, loginName);
            resultSet = connection.executeQuery(statement);
            if (!resultSet.next()) break block7;
            Examiner examiner = this.cachedCurrentExaminer = new Examiner(resultSet.getLong("examiner_id"), resultSet.getString("login_name"), resultSet.getString("display_name"));
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeConnection(connection);
            this.releaseSingleUserCaseReadLock();
            return examiner;
        }
        try {
            try {
                throw new TskCoreException("Error getting examaminer for name = " + loginName);
            }
            catch (SQLException ex) {
                throw new TskCoreException("Error getting examaminer for name = " + loginName, ex);
            }
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeConnection(connection);
            this.releaseSingleUserCaseReadLock();
            throw throwable;
        }
    }

    Examiner getExaminerById(long id) throws TskCoreException {
        ResultSet resultSet;
        CaseDbConnection connection;
        block5: {
            connection = null;
            resultSet = null;
            this.acquireSingleUserCaseReadLock();
            connection = this.connections.getConnection();
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_EXAMINER_BY_ID);
            statement.clearParameters();
            statement.setLong(1, id);
            resultSet = connection.executeQuery(statement);
            if (!resultSet.next()) break block5;
            Examiner examiner = new Examiner(resultSet.getLong("examiner_id"), resultSet.getString("login_name"), resultSet.getString("full_name"));
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeConnection(connection);
            this.releaseSingleUserCaseReadLock();
            return examiner;
        }
        try {
            try {
                throw new TskCoreException("Error getting examaminer for id = " + id);
            }
            catch (SQLException ex) {
                throw new TskCoreException("Error getting examaminer for id = " + id, ex);
            }
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeConnection(connection);
            this.releaseSingleUserCaseReadLock();
            throw throwable;
        }
    }

    public SleuthkitJNI.CaseDbHandle.AddImageProcess makeAddImageProcess(String timeZone, boolean addUnallocSpace, boolean noFatFsOrphans, String imageCopyPath) {
        return this.makeAddImageProcess(timeZone, addUnallocSpace, noFatFsOrphans, imageCopyPath, null);
    }

    @Beta
    public SleuthkitJNI.CaseDbHandle.AddImageProcess makeAddImageProcess(String timeZone, boolean addUnallocSpace, boolean noFatFsOrphans, String imageCopyPath, String password) {
        return this.caseHandle.initAddImageProcess(timeZone, addUnallocSpace, noFatFsOrphans, imageCopyPath, password, this);
    }

    public List<Content> getRootObjects() throws TskCoreException {
        ArrayList<AbstractContent> arrayList;
        CaseDbConnection connection = null;
        Statement s = null;
        ResultSet rs = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT obj_id, type FROM tsk_objects WHERE par_obj_id IS NULL");
            ArrayList<ObjectInfo> infos = new ArrayList<ObjectInfo>();
            while (rs.next()) {
                infos.add(new ObjectInfo(rs.getLong("obj_id"), TskData.ObjectType.valueOf(rs.getShort("type"))));
            }
            ArrayList<AbstractContent> rootObjs = new ArrayList<AbstractContent>();
            block13: for (ObjectInfo i : infos) {
                if (null == i.type) continue;
                switch (i.type) {
                    case IMG: {
                        rootObjs.add(this.getImageById(i.id));
                        continue block13;
                    }
                    case ABSTRACTFILE: {
                        AbstractFile af = this.getAbstractFileById(i.id);
                        if (af instanceof VirtualDirectory) {
                            rootObjs.add(af);
                            continue block13;
                        }
                        throw new TskCoreException("Parentless object has wrong type to be a root (ABSTRACTFILE, but not VIRTUAL_DIRECTORY: " + String.valueOf((Object)i.type));
                    }
                    case REPORT: {
                        continue block13;
                    }
                    case OS_ACCOUNT: {
                        continue block13;
                    }
                    case HOST_ADDRESS: {
                        continue block13;
                    }
                    case UNSUPPORTED: {
                        continue block13;
                    }
                }
                throw new TskCoreException("Parentless object has wrong type to be a root: " + String.valueOf((Object)i.type));
            }
            arrayList = rootObjs;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting root objects", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    List<Long> getDataSourceObjIds(String deviceId) throws TskCoreException {
        Map<String, Set<Long>> map = this.deviceIdToDatasourceObjIdMap;
        synchronized (map) {
            ArrayList<Long> arrayList;
            if (this.deviceIdToDatasourceObjIdMap.containsKey(deviceId)) {
                return new ArrayList<Long>((Collection)this.deviceIdToDatasourceObjIdMap.get(deviceId));
            }
            CaseDbConnection connection = null;
            Statement s = null;
            ResultSet rs = null;
            this.acquireSingleUserCaseReadLock();
            try {
                connection = this.connections.getConnection();
                s = connection.createStatement();
                rs = connection.executeQuery(s, "SELECT obj_id FROM data_source_info WHERE device_id = '" + deviceId + "'");
                ArrayList<Long> dataSourceObjIds = new ArrayList<Long>();
                while (rs.next()) {
                    dataSourceObjIds.add(rs.getLong("obj_id"));
                    long ds_obj_id = rs.getLong("obj_id");
                    if (this.deviceIdToDatasourceObjIdMap.containsKey(deviceId)) {
                        this.deviceIdToDatasourceObjIdMap.get(deviceId).add(ds_obj_id);
                        continue;
                    }
                    this.deviceIdToDatasourceObjIdMap.put(deviceId, new HashSet<Long>(Arrays.asList(ds_obj_id)));
                }
                arrayList = dataSourceObjIds;
            }
            catch (SQLException ex) {
                try {
                    throw new TskCoreException("Error getting data sources", ex);
                }
                catch (Throwable throwable) {
                    SleuthkitCase.closeResultSet(rs);
                    SleuthkitCase.closeStatement(s);
                    SleuthkitCase.closeConnection(connection);
                    this.releaseSingleUserCaseReadLock();
                    throw throwable;
                }
            }
            SleuthkitCase.closeResultSet(rs);
            SleuthkitCase.closeStatement(s);
            SleuthkitCase.closeConnection(connection);
            this.releaseSingleUserCaseReadLock();
            return arrayList;
        }
    }

    public List<DataSource> getDataSources() throws TskCoreException {
        ArrayList<DataSource> arrayList;
        CaseDbConnection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        Statement statement2 = null;
        ResultSet resultSet2 = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            statement = connection.createStatement();
            statement2 = connection.createStatement();
            resultSet = connection.executeQuery(statement, "SELECT ds.obj_id, ds.device_id, ds.time_zone, img.type, img.ssize, img.size, img.md5, img.sha1, img.sha256, img.display_name FROM data_source_info AS ds LEFT JOIN tsk_image_info AS img ON ds.obj_id = img.obj_id");
            ArrayList<DataSource> dataSourceList = new ArrayList<DataSource>();
            Map<Long, List<String>> imagePathsMap = this.getImagePaths();
            while (resultSet.next()) {
                AbstractContent dataSource;
                Long objectId = resultSet.getLong("obj_id");
                String deviceId = resultSet.getString("device_id");
                String timezone = resultSet.getString("time_zone");
                String type = resultSet.getString("type");
                if (type == null) {
                    resultSet2 = connection.executeQuery(statement2, "SELECT name FROM tsk_files WHERE tsk_files.obj_id = " + objectId);
                    String dsName = resultSet2.next() ? resultSet2.getString("name") : "";
                    resultSet2.close();
                    TskData.TSK_FS_NAME_TYPE_ENUM dirType = TskData.TSK_FS_NAME_TYPE_ENUM.DIR;
                    TskData.TSK_FS_META_TYPE_ENUM metaType = TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_DIR;
                    TskData.TSK_FS_NAME_FLAG_ENUM dirFlag = TskData.TSK_FS_NAME_FLAG_ENUM.ALLOC;
                    short metaFlags = (short)(TskData.TSK_FS_META_FLAG_ENUM.ALLOC.getValue() | TskData.TSK_FS_META_FLAG_ENUM.USED.getValue());
                    String parentPath = "/";
                    dataSource = new LocalFilesDataSource(this, objectId, objectId, deviceId, dsName, dirType, metaType, dirFlag, metaFlags, timezone, null, null, null, TskData.FileKnown.UNKNOWN, parentPath);
                } else {
                    Long ssize = resultSet.getLong("ssize");
                    Long size = resultSet.getLong("size");
                    String md5 = resultSet.getString("md5");
                    String sha1 = resultSet.getString("sha1");
                    String sha256 = resultSet.getString("sha256");
                    String name = resultSet.getString("display_name");
                    List<String> imagePaths = imagePathsMap.get(objectId);
                    if (name == null) {
                        if (imagePaths.size() > 0) {
                            String path = imagePaths.get(0);
                            name = new java.io.File(path).getName();
                        } else {
                            name = "";
                        }
                    }
                    dataSource = new Image(this, objectId, Long.valueOf(type), deviceId, ssize, name, imagePaths.toArray(new String[imagePaths.size()]), timezone, md5, sha1, sha256, size);
                }
                dataSourceList.add((DataSource)((Object)dataSource));
            }
            arrayList = dataSourceList;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting data sources", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeStatement(statement);
                SleuthkitCase.closeResultSet(resultSet2);
                SleuthkitCase.closeStatement(statement2);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeStatement(statement);
        SleuthkitCase.closeResultSet(resultSet2);
        SleuthkitCase.closeStatement(statement2);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public DataSource getDataSource(long objectId) throws TskDataException, TskCoreException {
        ResultSet resultSet2;
        Statement statement2;
        ResultSet resultSet;
        Statement statement;
        CaseDbConnection connection;
        AbstractContent dataSource;
        block10: {
            dataSource = null;
            connection = null;
            statement = null;
            resultSet = null;
            statement2 = null;
            resultSet2 = null;
            this.acquireSingleUserCaseReadLock();
            try {
                connection = this.connections.getConnection();
                statement = connection.createStatement();
                statement2 = connection.createStatement();
                resultSet = connection.executeQuery(statement, "SELECT ds.device_id, ds.time_zone, img.type, img.ssize, img.size, img.md5, img.sha1, img.sha256, img.display_name FROM data_source_info AS ds LEFT JOIN tsk_image_info AS img ON ds.obj_id = img.obj_id WHERE ds.obj_id = " + objectId);
                if (resultSet.next()) {
                    String deviceId = resultSet.getString("device_id");
                    String timezone = resultSet.getString("time_zone");
                    String type = resultSet.getString("type");
                    if (type == null) {
                        resultSet2 = connection.executeQuery(statement2, "SELECT name FROM tsk_files WHERE tsk_files.obj_id = " + objectId);
                        String dsName = resultSet2.next() ? resultSet2.getString("name") : "";
                        TskData.TSK_FS_NAME_TYPE_ENUM dirType = TskData.TSK_FS_NAME_TYPE_ENUM.DIR;
                        TskData.TSK_FS_META_TYPE_ENUM metaType = TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_DIR;
                        TskData.TSK_FS_NAME_FLAG_ENUM dirFlag = TskData.TSK_FS_NAME_FLAG_ENUM.ALLOC;
                        short metaFlags = (short)(TskData.TSK_FS_META_FLAG_ENUM.ALLOC.getValue() | TskData.TSK_FS_META_FLAG_ENUM.USED.getValue());
                        String parentPath = "/";
                        dataSource = new LocalFilesDataSource(this, objectId, objectId, deviceId, dsName, dirType, metaType, dirFlag, metaFlags, timezone, null, null, null, TskData.FileKnown.UNKNOWN, parentPath);
                    } else {
                        Long ssize = resultSet.getLong("ssize");
                        Long size = resultSet.getLong("size");
                        String md5 = resultSet.getString("md5");
                        String sha1 = resultSet.getString("sha1");
                        String sha256 = resultSet.getString("sha256");
                        String name = resultSet.getString("display_name");
                        List<String> imagePaths = this.getImagePathsById(objectId, connection);
                        if (name == null) {
                            if (imagePaths.size() > 0) {
                                String path = imagePaths.get(0);
                                name = new java.io.File(path).getName();
                            } else {
                                name = "";
                            }
                        }
                        dataSource = new Image(this, objectId, Long.valueOf(type), deviceId, ssize, name, imagePaths.toArray(new String[imagePaths.size()]), timezone, md5, sha1, sha256, size);
                    }
                    break block10;
                }
                throw new TskDataException(String.format("There is no data source with obj_id = %d", objectId));
            }
            catch (SQLException ex) {
                try {
                    throw new TskCoreException(String.format("Error getting data source with obj_id = %d", objectId), ex);
                }
                catch (Throwable throwable) {
                    SleuthkitCase.closeResultSet(resultSet);
                    SleuthkitCase.closeStatement(statement);
                    SleuthkitCase.closeResultSet(resultSet2);
                    SleuthkitCase.closeStatement(statement2);
                    SleuthkitCase.closeConnection(connection);
                    this.releaseSingleUserCaseReadLock();
                    throw throwable;
                }
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeStatement(statement);
        SleuthkitCase.closeResultSet(resultSet2);
        SleuthkitCase.closeStatement(statement2);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return dataSource;
    }

    @Deprecated
    public ArrayList<BlackboardArtifact> getBlackboardArtifacts(int artifactTypeID) throws TskCoreException {
        ArrayList<BlackboardArtifact> artifacts = new ArrayList<BlackboardArtifact>();
        artifacts.addAll(this.blackboard.getArtifactsByType(this.blackboard.getArtifactType(artifactTypeID)));
        return artifacts;
    }

    public long getBlackboardArtifactsCount(long objId) throws TskCoreException {
        long l;
        CaseDbConnection connection = null;
        ResultSet rs = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.COUNT_ARTIFACTS_FROM_SOURCE);
            statement.clearParameters();
            statement.setLong(1, objId);
            rs = connection.executeQuery(statement);
            long count = 0L;
            if (rs.next()) {
                count = rs.getLong("count");
            }
            l = count;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting number of blackboard artifacts by content", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return l;
    }

    public long getBlackboardArtifactsTypeCount(int artifactTypeID) throws TskCoreException {
        long l;
        CaseDbConnection connection = null;
        ResultSet rs = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.COUNT_ARTIFACTS_OF_TYPE);
            statement.clearParameters();
            statement.setInt(1, artifactTypeID);
            rs = connection.executeQuery(statement);
            long count = 0L;
            if (rs.next()) {
                count = rs.getLong("count");
            }
            l = count;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting number of blackboard artifacts by type", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return l;
    }

    public long getBlackboardArtifactsTypeCount(int artifactTypeID, long dataSourceID) throws TskCoreException {
        long l;
        CaseDbConnection connection = null;
        ResultSet rs = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.COUNT_ARTIFACTS_OF_TYPE_BY_DATA_SOURCE);
            statement.clearParameters();
            statement.setInt(2, artifactTypeID);
            statement.setLong(1, dataSourceID);
            rs = connection.executeQuery(statement);
            long count = 0L;
            if (rs.next()) {
                count = rs.getLong("count");
            }
            l = count;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException(String.format("Error getting number of blackboard artifacts by type (%d) and data source (%d)", artifactTypeID, dataSourceID), ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return l;
    }

    /*
     * Exception decompiling
     */
    @Deprecated
    public List<BlackboardArtifact> getBlackboardArtifacts(BlackboardAttribute.ATTRIBUTE_TYPE attrType, String value) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Deprecated
    public List<BlackboardArtifact> getBlackboardArtifacts(BlackboardAttribute.ATTRIBUTE_TYPE attrType, String subString, boolean startsWith) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Deprecated
    public List<BlackboardArtifact> getBlackboardArtifacts(BlackboardAttribute.ATTRIBUTE_TYPE attrType, int value) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Deprecated
    public List<BlackboardArtifact> getBlackboardArtifacts(BlackboardAttribute.ATTRIBUTE_TYPE attrType, long value) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Deprecated
    public List<BlackboardArtifact> getBlackboardArtifacts(BlackboardAttribute.ATTRIBUTE_TYPE attrType, double value) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Deprecated
    public List<BlackboardArtifact> getBlackboardArtifacts(BlackboardAttribute.ATTRIBUTE_TYPE attrType, byte value) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Iterable<BlackboardArtifact.Type> getArtifactTypes() throws TskCoreException {
        ArrayList<BlackboardArtifact.Type> arrayList;
        CaseDbConnection connection = null;
        Statement s = null;
        ResultSet rs = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT artifact_type_id, type_name, display_name, category_type FROM blackboard_artifact_types");
            ArrayList<BlackboardArtifact.Type> artifactTypes = new ArrayList<BlackboardArtifact.Type>();
            while (rs.next()) {
                artifactTypes.add(new BlackboardArtifact.Type(rs.getInt("artifact_type_id"), rs.getString("type_name"), rs.getString("display_name"), BlackboardArtifact.Category.fromID(rs.getInt("category_type"))));
            }
            arrayList = artifactTypes;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting artifact types", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public ArrayList<BlackboardArtifact.ARTIFACT_TYPE> getBlackboardArtifactTypesInUse() throws TskCoreException {
        ArrayList<BlackboardArtifact.ARTIFACT_TYPE> arrayList;
        Object typeIdList = "";
        for (int i = 0; i < BlackboardArtifact.ARTIFACT_TYPE.values().length; ++i) {
            typeIdList = (String)typeIdList + BlackboardArtifact.ARTIFACT_TYPE.values()[i].getTypeID();
            if (i >= BlackboardArtifact.ARTIFACT_TYPE.values().length - 1) continue;
            typeIdList = (String)typeIdList + ", ";
        }
        String query = "SELECT DISTINCT artifact_type_id FROM blackboard_artifacts WHERE artifact_type_id IN (" + (String)typeIdList + ")";
        CaseDbConnection connection = null;
        Statement s = null;
        ResultSet rs = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            s = connection.createStatement();
            rs = connection.executeQuery(s, query);
            ArrayList<BlackboardArtifact.ARTIFACT_TYPE> usedArts = new ArrayList<BlackboardArtifact.ARTIFACT_TYPE>();
            while (rs.next()) {
                usedArts.add(BlackboardArtifact.ARTIFACT_TYPE.fromID(rs.getInt("artifact_type_id")));
            }
            arrayList = usedArts;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting artifact types in use", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public List<BlackboardArtifact.Type> getArtifactTypesInUse() throws TskCoreException {
        ArrayList<BlackboardArtifact.Type> arrayList;
        CaseDbConnection connection = null;
        Statement s = null;
        ResultSet rs = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT DISTINCT arts.artifact_type_id AS artifact_type_id, types.type_name AS type_name, types.display_name AS display_name, types.category_type AS category_type FROM blackboard_artifact_types AS types INNER JOIN blackboard_artifacts AS arts ON arts.artifact_type_id = types.artifact_type_id");
            ArrayList<BlackboardArtifact.Type> uniqueArtifactTypes = new ArrayList<BlackboardArtifact.Type>();
            while (rs.next()) {
                uniqueArtifactTypes.add(new BlackboardArtifact.Type(rs.getInt("artifact_type_id"), rs.getString("type_name"), rs.getString("display_name"), BlackboardArtifact.Category.fromID(rs.getInt("category_type"))));
            }
            arrayList = uniqueArtifactTypes;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting attribute types", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public List<BlackboardAttribute.Type> getAttributeTypes() throws TskCoreException {
        ArrayList<BlackboardAttribute.Type> arrayList;
        CaseDbConnection connection = null;
        Statement s = null;
        ResultSet rs = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT attribute_type_id, type_name, display_name, value_type FROM blackboard_attribute_types");
            ArrayList<BlackboardAttribute.Type> attribute_types = new ArrayList<BlackboardAttribute.Type>();
            while (rs.next()) {
                attribute_types.add(new BlackboardAttribute.Type(rs.getInt("attribute_type_id"), rs.getString("type_name"), rs.getString("display_name"), BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.fromType(rs.getLong("value_type"))));
            }
            arrayList = attribute_types;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting attribute types", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public int getBlackboardAttributeTypesCount() throws TskCoreException {
        int n;
        CaseDbConnection connection = null;
        Statement s = null;
        ResultSet rs = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT COUNT(*) AS count FROM blackboard_attribute_types");
            int count = 0;
            if (rs.next()) {
                count = rs.getInt("count");
            }
            n = count;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting number of blackboard artifacts by type", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return n;
    }

    private long getArtifactsCountHelper(int artifactTypeID, long obj_id) throws TskCoreException {
        long l;
        CaseDbConnection connection = null;
        ResultSet rs = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.COUNT_ARTIFACTS_BY_SOURCE_AND_TYPE);
            statement.clearParameters();
            statement.setLong(1, obj_id);
            statement.setInt(2, artifactTypeID);
            rs = connection.executeQuery(statement);
            long count = 0L;
            if (rs.next()) {
                count = rs.getLong("count");
            }
            l = count;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting blackboard artifact count", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return l;
    }

    public ArrayList<BlackboardArtifact> getBlackboardArtifacts(String artifactTypeName, long obj_id) throws TskCoreException {
        ArrayList<BlackboardArtifact> artifacts = new ArrayList<BlackboardArtifact>();
        artifacts.addAll(this.blackboard.getArtifactsBySourceId(this.getArtifactType(artifactTypeName), obj_id));
        return artifacts;
    }

    public ArrayList<BlackboardArtifact> getBlackboardArtifacts(int artifactTypeID, long obj_id) throws TskCoreException {
        ArrayList<BlackboardArtifact> artifacts = new ArrayList<BlackboardArtifact>();
        artifacts.addAll(this.blackboard.getArtifactsBySourceId(this.blackboard.getArtifactType(artifactTypeID), obj_id));
        return artifacts;
    }

    public ArrayList<BlackboardArtifact> getBlackboardArtifacts(BlackboardArtifact.ARTIFACT_TYPE artifactType, long obj_id) throws TskCoreException {
        return this.getBlackboardArtifacts(artifactType.getTypeID(), obj_id);
    }

    public long getBlackboardArtifactsCount(String artifactTypeName, long obj_id) throws TskCoreException {
        int artifactTypeID = this.getArtifactType(artifactTypeName).getTypeID();
        if (artifactTypeID == -1) {
            return 0L;
        }
        return this.getArtifactsCountHelper(artifactTypeID, obj_id);
    }

    public long getBlackboardArtifactsCount(int artifactTypeID, long obj_id) throws TskCoreException {
        return this.getArtifactsCountHelper(artifactTypeID, obj_id);
    }

    public long getBlackboardArtifactsCount(BlackboardArtifact.ARTIFACT_TYPE artifactType, long obj_id) throws TskCoreException {
        return this.getArtifactsCountHelper(artifactType.getTypeID(), obj_id);
    }

    public ArrayList<BlackboardArtifact> getBlackboardArtifacts(String artifactTypeName) throws TskCoreException {
        ArrayList<BlackboardArtifact> artifacts = new ArrayList<BlackboardArtifact>();
        artifacts.addAll(this.blackboard.getArtifactsByType(this.getArtifactType(artifactTypeName)));
        return artifacts;
    }

    public ArrayList<BlackboardArtifact> getBlackboardArtifacts(BlackboardArtifact.ARTIFACT_TYPE artifactType) throws TskCoreException {
        ArrayList<BlackboardArtifact> artifacts = new ArrayList<BlackboardArtifact>();
        artifacts.addAll(this.blackboard.getArtifactsByType(this.blackboard.getArtifactType(artifactType.getTypeID())));
        return artifacts;
    }

    /*
     * Exception decompiling
     */
    @Deprecated
    public List<BlackboardArtifact> getBlackboardArtifacts(BlackboardArtifact.ARTIFACT_TYPE artifactType, BlackboardAttribute.ATTRIBUTE_TYPE attrType, String value) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public BlackboardArtifact getBlackboardArtifact(long artifactID) throws TskCoreException {
        List<DataArtifact> dataArtifacts = this.blackboard.getDataArtifactsWhere("artifacts.artifact_id = " + artifactID);
        if (!dataArtifacts.isEmpty()) {
            return dataArtifacts.get(0);
        }
        List<AnalysisResult> analysisResults = this.blackboard.getAnalysisResultsWhere("artifacts.artifact_id = " + artifactID);
        if (!analysisResults.isEmpty()) {
            return analysisResults.get(0);
        }
        throw new TskCoreException("No blackboard artifact with id " + artifactID);
    }

    public void addBlackboardAttribute(BlackboardAttribute attr, int artifactTypeId) throws TskCoreException {
        this.acquireSingleUserCaseWriteLock();
        try (CaseDbConnection connection = this.connections.getConnection();){
            this.addBlackBoardAttribute(attr, artifactTypeId, connection);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error adding blackboard attribute " + attr.toString(), ex);
        }
        finally {
            this.releaseSingleUserCaseWriteLock();
        }
    }

    public void addBlackboardAttributes(Collection<BlackboardAttribute> attributes, int artifactTypeId) throws TskCoreException {
        CaseDbConnection connection = null;
        this.acquireSingleUserCaseWriteLock();
        try {
            connection = this.connections.getConnection();
            connection.beginTransaction();
            for (BlackboardAttribute attr : attributes) {
                this.addBlackBoardAttribute(attr, artifactTypeId, connection);
            }
            connection.commitTransaction();
        }
        catch (SQLException ex) {
            SleuthkitCase.rollbackTransaction(connection);
            throw new TskCoreException("Error adding blackboard attributes", ex);
        }
        finally {
            SleuthkitCase.closeConnection(connection);
            this.releaseSingleUserCaseWriteLock();
        }
    }

    void addBlackBoardAttribute(BlackboardAttribute attr, int artifactTypeId, CaseDbConnection connection) throws SQLException, TskCoreException {
        PreparedStatement statement;
        switch (attr.getAttributeType().getValueType()) {
            case STRING: 
            case JSON: {
                statement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_STRING_ATTRIBUTE);
                statement.clearParameters();
                statement.setString(7, attr.getValueString());
                break;
            }
            case BYTE: {
                statement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_BYTE_ATTRIBUTE);
                statement.clearParameters();
                statement.setBytes(7, attr.getValueBytes());
                break;
            }
            case INTEGER: {
                statement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_INT_ATTRIBUTE);
                statement.clearParameters();
                statement.setInt(7, attr.getValueInt());
                break;
            }
            case LONG: {
                statement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_LONG_ATTRIBUTE);
                statement.clearParameters();
                statement.setLong(7, attr.getValueLong());
                break;
            }
            case DOUBLE: {
                statement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_DOUBLE_ATTRIBUTE);
                statement.clearParameters();
                statement.setDouble(7, attr.getValueDouble());
                break;
            }
            case DATETIME: {
                statement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_LONG_ATTRIBUTE);
                statement.clearParameters();
                statement.setLong(7, attr.getValueLong());
                break;
            }
            default: {
                throw new TskCoreException("Unrecognized artifact attribute value type");
            }
        }
        statement.setLong(1, attr.getArtifactID());
        statement.setInt(2, artifactTypeId);
        statement.setString(3, attr.getSourcesCSV());
        statement.setString(4, "");
        statement.setInt(5, attr.getAttributeType().getTypeID());
        statement.setLong(6, attr.getAttributeType().getValueType().getType());
        connection.executeUpdate(statement);
    }

    void addFileAttribute(Attribute attr, CaseDbConnection connection) throws SQLException, TskCoreException {
        PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_FILE_ATTRIBUTE, 1);
        statement.clearParameters();
        statement.setLong(1, attr.getAttributeParentId());
        statement.setInt(2, attr.getAttributeType().getTypeID());
        statement.setLong(3, attr.getAttributeType().getValueType().getType());
        if (attr.getAttributeType().getValueType() == BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.BYTE) {
            statement.setBytes(4, attr.getValueBytes());
        } else {
            statement.setBytes(4, null);
        }
        if (attr.getAttributeType().getValueType() == BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING || attr.getAttributeType().getValueType() == BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.JSON) {
            statement.setString(5, attr.getValueString());
        } else {
            statement.setString(5, null);
        }
        if (attr.getAttributeType().getValueType() == BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.INTEGER) {
            statement.setInt(6, attr.getValueInt());
        } else {
            statement.setNull(6, 4);
        }
        if (attr.getAttributeType().getValueType() == BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.DATETIME || attr.getAttributeType().getValueType() == BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.LONG) {
            statement.setLong(7, attr.getValueLong());
        } else {
            statement.setNull(7, -5);
        }
        if (attr.getAttributeType().getValueType() == BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.DOUBLE) {
            statement.setDouble(8, attr.getValueDouble());
        } else {
            statement.setNull(8, 8);
        }
        connection.executeUpdate(statement);
        try (ResultSet resultSet = statement.getGeneratedKeys();){
            if (!resultSet.next()) {
                throw new TskCoreException(String.format("Failed to insert file attribute with id=%d. The expected key was not generated", attr.getId()));
            }
            attr.setId(resultSet.getLong(1));
        }
    }

    String addSourceToArtifactAttribute(BlackboardAttribute attr, String source) throws TskCoreException {
        String string;
        if (null == source || source.isEmpty()) {
            throw new TskCoreException("Attempt to add null or empty source module name to artifact attribute");
        }
        CaseDbConnection connection = null;
        this.acquireSingleUserCaseWriteLock();
        Statement queryStmt = null;
        Statement updateStmt = null;
        ResultSet result = null;
        Object newSources = "";
        try {
            connection = this.connections.getConnection();
            connection.beginTransaction();
            Object valueClause = "";
            BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE valueType = attr.getAttributeType().getValueType();
            if (BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.BYTE != valueType) {
                switch (valueType) {
                    case STRING: 
                    case JSON: {
                        valueClause = " value_text = '" + SleuthkitCase.escapeSingleQuotes(attr.getValueString()) + "'";
                        break;
                    }
                    case INTEGER: {
                        valueClause = " value_int32 = " + attr.getValueInt();
                        break;
                    }
                    case LONG: 
                    case DATETIME: {
                        valueClause = " value_int64 = " + attr.getValueLong();
                        break;
                    }
                    case DOUBLE: {
                        valueClause = " value_double = " + attr.getValueDouble();
                        break;
                    }
                    default: {
                        throw new TskCoreException(String.format("Unrecognized value type for attribute %s", attr.getDisplayString()));
                    }
                }
                String query = "SELECT source FROM blackboard_attributes WHERE artifact_id = " + attr.getArtifactID() + " AND attribute_type_id = " + attr.getAttributeType().getTypeID() + " AND value_type = " + attr.getAttributeType().getValueType().getType() + " AND " + (String)valueClause + ";";
                queryStmt = connection.createStatement();
                updateStmt = connection.createStatement();
                result = connection.executeQuery(queryStmt, query);
            } else {
                PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_ATTR_BY_VALUE_BYTE);
                statement.clearParameters();
                statement.setLong(1, attr.getArtifactID());
                statement.setLong(2, attr.getAttributeType().getTypeID());
                statement.setBytes(3, attr.getValueBytes());
                result = connection.executeQuery(statement);
            }
            while (result.next()) {
                HashSet<String> uniqueSources;
                String oldSources = result.getString("source");
                newSources = null != oldSources && !oldSources.isEmpty() ? (!(uniqueSources = new HashSet<String>(Arrays.asList(oldSources.split(",")))).contains(source) ? oldSources + "," + source : oldSources) : source;
                if (BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.BYTE != valueType) {
                    String update = "UPDATE blackboard_attributes SET source = '" + (String)newSources + "' WHERE artifact_id = " + attr.getArtifactID() + " AND attribute_type_id = " + attr.getAttributeType().getTypeID() + " AND value_type = " + attr.getAttributeType().getValueType().getType() + " AND " + (String)valueClause + ";";
                    connection.executeUpdate(updateStmt, update);
                    continue;
                }
                PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.UPDATE_ATTR_BY_VALUE_BYTE);
                statement.clearParameters();
                statement.setString(1, (String)newSources);
                statement.setLong(2, attr.getArtifactID());
                statement.setLong(3, attr.getAttributeType().getTypeID());
                statement.setBytes(4, attr.getValueBytes());
                connection.executeUpdate(statement);
            }
            connection.commitTransaction();
            string = newSources;
        }
        catch (SQLException ex) {
            try {
                SleuthkitCase.rollbackTransaction(connection);
                throw new TskCoreException(String.format("Error adding source module to attribute %s", attr.getDisplayString()), ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(result);
                SleuthkitCase.closeStatement(updateStmt);
                SleuthkitCase.closeStatement(queryStmt);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseWriteLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(result);
        SleuthkitCase.closeStatement(updateStmt);
        SleuthkitCase.closeStatement(queryStmt);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseWriteLock();
        return string;
    }

    @Deprecated
    public BlackboardAttribute.Type addArtifactAttributeType(String attrTypeString, BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE valueType, String displayName) throws TskCoreException, TskDataException {
        try {
            return this.blackboard.getOrAddAttributeType(attrTypeString, valueType, displayName);
        }
        catch (Blackboard.BlackboardException ex) {
            throw new TskCoreException("Error adding artifact type: " + attrTypeString, ex);
        }
    }

    @Deprecated
    public BlackboardAttribute.Type getAttributeType(String attrTypeName) throws TskCoreException {
        return this.blackboard.getAttributeType(attrTypeName);
    }

    @Deprecated
    public BlackboardArtifact.Type getArtifactType(String artTypeName) throws TskCoreException {
        return this.blackboard.getArtifactType(artTypeName);
    }

    @Deprecated
    public BlackboardArtifact.Type addBlackboardArtifactType(String artifactTypeName, String displayName) throws TskCoreException, TskDataException {
        return this.addBlackboardArtifactType(artifactTypeName, displayName, BlackboardArtifact.Category.DATA_ARTIFACT);
    }

    @Deprecated
    BlackboardArtifact.Type addBlackboardArtifactType(String artifactTypeName, String displayName, BlackboardArtifact.Category category) throws TskCoreException, TskDataException {
        try {
            return this.blackboard.getOrAddArtifactType(displayName, displayName, category);
        }
        catch (Blackboard.BlackboardException ex) {
            throw new TskCoreException("Error getting or adding artifact type with name: " + artifactTypeName, ex);
        }
    }

    @Deprecated
    public ArrayList<BlackboardAttribute> getBlackboardAttributes(BlackboardArtifact artifact) throws TskCoreException {
        return this.blackboard.getBlackboardAttributes(artifact);
    }

    public ArrayList<BlackboardAttribute> getMatchingAttributes(String whereClause) throws TskCoreException {
        ArrayList<BlackboardAttribute> arrayList;
        CaseDbConnection connection = null;
        Statement s = null;
        ResultSet rs = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT blackboard_attributes.artifact_id AS artifact_id, blackboard_attributes.source AS source, blackboard_attributes.context AS context, blackboard_attributes.attribute_type_id AS attribute_type_id, blackboard_attributes.value_type AS value_type, blackboard_attributes.value_byte AS value_byte, blackboard_attributes.value_text AS value_text, blackboard_attributes.value_int32 AS value_int32, blackboard_attributes.value_int64 AS value_int64, blackboard_attributes.value_double AS value_double FROM blackboard_attributes " + whereClause);
            ArrayList<BlackboardAttribute> matches = new ArrayList<BlackboardAttribute>();
            while (rs.next()) {
                BlackboardAttribute.Type type = this.blackboard.getAttributeType(rs.getInt("attribute_type_id"));
                BlackboardAttribute attr = new BlackboardAttribute(rs.getLong("artifact_id"), type, rs.getString("source"), rs.getString("context"), rs.getInt("value_int32"), rs.getLong("value_int64"), rs.getDouble("value_double"), rs.getString("value_text"), rs.getBytes("value_byte"), this);
                matches.add(attr);
            }
            arrayList = matches;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting attributes using this where clause: " + whereClause, ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    /*
     * Exception decompiling
     */
    public ArrayList<BlackboardArtifact> getMatchingArtifacts(String whereClause) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Deprecated
    public BlackboardArtifact newBlackboardArtifact(int artifactTypeID, long obj_id) throws TskCoreException {
        BlackboardArtifact.Type type = this.blackboard.getArtifactType(artifactTypeID);
        if (type == null) {
            throw new TskCoreException("Unknown artifact type for id: " + artifactTypeID);
        }
        BlackboardArtifact.Category category = type.getCategory();
        if (category == null) {
            throw new TskCoreException(String.format("No category for %s (id: %d)", type.getDisplayName() == null ? "<null>" : type.getDisplayName(), type.getTypeID()));
        }
        Content content = this.getContentById(obj_id);
        if (content == null) {
            throw new TskCoreException("No content found for object id: " + obj_id);
        }
        switch (category) {
            case ANALYSIS_RESULT: {
                return content.newAnalysisResult(type, Score.SCORE_UNKNOWN, null, null, null, Collections.emptyList()).getAnalysisResult();
            }
            case DATA_ARTIFACT: {
                return content.newDataArtifact(type, Collections.emptyList());
            }
        }
        throw new TskCoreException("Unknown category type: " + category.getName());
    }

    @Deprecated
    public BlackboardArtifact newBlackboardArtifact(BlackboardArtifact.ARTIFACT_TYPE artifactType, long obj_id) throws TskCoreException {
        return this.newBlackboardArtifact(artifactType.getTypeID(), obj_id);
    }

    @Deprecated
    BlackboardArtifact newBlackboardArtifact(int artifactTypeID, long obj_id, long data_source_obj_id) throws TskCoreException {
        BlackboardArtifact.Type type = this.blackboard.getArtifactType(artifactTypeID);
        try (CaseDbConnection connection = this.connections.getConnection();){
            BlackboardArtifact blackboardArtifact = this.newBlackboardArtifact(artifactTypeID, obj_id, type.getTypeName(), type.getDisplayName(), data_source_obj_id, connection);
            return blackboardArtifact;
        }
    }

    @Deprecated
    private BlackboardArtifact newBlackboardArtifact(int artifact_type_id, long obj_id, String artifactTypeName, String artifactDisplayName) throws TskCoreException {
        try (CaseDbConnection connection = this.connections.getConnection();){
            long data_source_obj_id = this.getDataSourceObjectId(connection, obj_id);
            BlackboardArtifact blackboardArtifact = this.newBlackboardArtifact(artifact_type_id, obj_id, artifactTypeName, artifactDisplayName, data_source_obj_id, connection);
            return blackboardArtifact;
        }
    }

    PreparedStatement createInsertArtifactStatement(int artifact_type_id, long obj_id, long artifact_obj_id, long data_source_obj_id, CaseDbConnection connection) throws TskCoreException, SQLException {
        PreparedStatement statement;
        if (this.dbType == TskData.DbType.POSTGRESQL) {
            statement = connection.getPreparedStatement(PREPARED_STATEMENT.POSTGRESQL_INSERT_ARTIFACT, 1);
            statement.clearParameters();
            statement.setLong(1, obj_id);
            statement.setLong(2, artifact_obj_id);
            statement.setLong(3, data_source_obj_id);
            statement.setInt(4, artifact_type_id);
        } else {
            statement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_ARTIFACT, 1);
            statement.clearParameters();
            ++this.nextArtifactId;
            statement.setLong(1, this.nextArtifactId);
            statement.setLong(2, obj_id);
            statement.setLong(3, artifact_obj_id);
            statement.setLong(4, data_source_obj_id);
            statement.setInt(5, artifact_type_id);
        }
        return statement;
    }

    @Deprecated
    private BlackboardArtifact newBlackboardArtifact(int artifact_type_id, long obj_id, String artifactTypeName, String artifactDisplayName, long data_source_obj_id, CaseDbConnection connection) throws TskCoreException {
        BlackboardArtifact.Type type = this.blackboard.getArtifactType(artifact_type_id);
        try {
            if (type.getCategory() == BlackboardArtifact.Category.ANALYSIS_RESULT) {
                return this.blackboard.newAnalysisResult(type, obj_id, data_source_obj_id, Score.SCORE_UNKNOWN, null, null, null, Collections.emptyList()).getAnalysisResult();
            }
            return this.blackboard.newDataArtifact(type, obj_id, data_source_obj_id, Collections.emptyList(), null);
        }
        catch (Blackboard.BlackboardException ex) {
            throw new TskCoreException("Error creating a blackboard artifact", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AnalysisResult newAnalysisResult(BlackboardArtifact.Type artifactType, long objId, Long dataSourceObjId, Score score, String conclusion, String configuration, String justification, CaseDbConnection connection) throws TskCoreException {
        if (artifactType.getCategory() != BlackboardArtifact.Category.ANALYSIS_RESULT) {
            throw new TskCoreException(String.format("Artifact type (name = %s) is not of the AnalysisResult category. ", artifactType.getTypeName()));
        }
        this.acquireSingleUserCaseWriteLock();
        try {
            AnalysisResult analysisResult;
            long artifactObjId = this.addObject(objId, TskData.ObjectType.ARTIFACT.getObjectType(), connection);
            ResultSet resultSet = null;
            try {
                PreparedStatement insertArtifactstatement = this.createInsertArtifactStatement(artifactType.getTypeID(), objId, artifactObjId, dataSourceObjId, connection);
                connection.executeUpdate(insertArtifactstatement);
                resultSet = insertArtifactstatement.getGeneratedKeys();
                resultSet.next();
                long artifactID = resultSet.getLong(1);
                if (!(score.getSignificance() == Score.Significance.UNKNOWN && StringUtils.isBlank((CharSequence)conclusion) && StringUtils.isBlank((CharSequence)configuration) && StringUtils.isBlank((CharSequence)justification))) {
                    PreparedStatement analysisResultsStatement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_ANALYSIS_RESULT);
                    analysisResultsStatement.clearParameters();
                    analysisResultsStatement.setLong(1, artifactObjId);
                    analysisResultsStatement.setString(2, conclusion != null ? conclusion : "");
                    analysisResultsStatement.setInt(3, score.getSignificance().getId());
                    analysisResultsStatement.setInt(4, score.getPriority().getId());
                    analysisResultsStatement.setString(5, configuration != null ? configuration : "");
                    analysisResultsStatement.setString(6, justification != null ? justification : "");
                    connection.executeUpdate(analysisResultsStatement);
                }
                analysisResult = new AnalysisResult(this, artifactID, objId, artifactObjId, dataSourceObjId, artifactType.getTypeID(), artifactType.getTypeName(), artifactType.getDisplayName(), BlackboardArtifact.ReviewStatus.UNDECIDED, true, score, conclusion != null ? conclusion : "", configuration != null ? configuration : "", justification != null ? justification : "");
            }
            catch (Throwable throwable) {
                try {
                    SleuthkitCase.closeResultSet(resultSet);
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new TskCoreException("Error creating a analysis result", ex);
                }
            }
            SleuthkitCase.closeResultSet(resultSet);
            return analysisResult;
        }
        finally {
            this.releaseSingleUserCaseWriteLock();
        }
    }

    boolean getContentHasChildren(Content content) throws TskCoreException {
        boolean bl;
        CaseDbConnection connection = null;
        ResultSet rs = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.COUNT_CHILD_OBJECTS_BY_PARENT);
            statement.clearParameters();
            statement.setLong(1, content.getId());
            rs = connection.executeQuery(statement);
            boolean hasChildren = false;
            if (rs.next()) {
                hasChildren = rs.getInt("count") > 0;
            }
            bl = hasChildren;
        }
        catch (SQLException e) {
            try {
                throw new TskCoreException("Error checking for children of parent " + String.valueOf(content), e);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return bl;
    }

    int getContentChildrenCount(Content content) throws TskCoreException {
        int n;
        if (!this.getHasChildren(content)) {
            return 0;
        }
        CaseDbConnection connection = null;
        ResultSet rs = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.COUNT_CHILD_OBJECTS_BY_PARENT);
            statement.clearParameters();
            statement.setLong(1, content.getId());
            rs = connection.executeQuery(statement);
            int countChildren = -1;
            if (rs.next()) {
                countChildren = rs.getInt("count");
            }
            n = countChildren;
        }
        catch (SQLException e) {
            try {
                throw new TskCoreException("Error checking for children of parent " + String.valueOf(content), e);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return n;
    }

    int getAbstractFileChildrenCountByType(Content content, List<TskData.TSK_FS_NAME_TYPE_ENUM> types) throws TskCoreException {
        int n;
        if (!this.getHasChildren(content)) {
            return 0;
        }
        if (types == null || types.isEmpty()) {
            return 0;
        }
        CaseDbConnection connection = null;
        ResultSet rs = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            StringBuilder inClause = new StringBuilder("?");
            for (int i = 1; i < types.size(); ++i) {
                inClause.append(", ?");
            }
            String sql = "SELECT COUNT(*) AS count FROM tsk_objects INNER JOIN tsk_files ON tsk_objects.obj_id = tsk_files.obj_id WHERE (tsk_objects.par_obj_id = ? AND tsk_files.dir_type IN (" + inClause.toString() + "))";
            PreparedStatement statement = connection.getConnection().prepareStatement(sql);
            statement.clearParameters();
            statement.setLong(1, content.getId());
            for (int i = 0; i < types.size(); ++i) {
                statement.setInt(i + 2, types.get(i).getValue());
            }
            rs = connection.executeQuery(statement);
            int countChildren = -1;
            if (rs.next()) {
                countChildren = rs.getInt("count");
            }
            n = countChildren;
        }
        catch (SQLException e) {
            try {
                throw new TskCoreException("Error checking for children of parent " + String.valueOf(content), e);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return n;
    }

    List<Content> getAbstractFileChildren(Content parent, TskData.TSK_DB_FILES_TYPE_ENUM type) throws TskCoreException {
        List<Content> list;
        CaseDbConnection connection = null;
        ResultSet rs = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_FILES_BY_PARENT_AND_TYPE);
            statement.clearParameters();
            long parentId = parent.getId();
            statement.setLong(1, parentId);
            statement.setShort(2, type.getFileType());
            rs = connection.executeQuery(statement);
            list = this.fileChildren(rs, connection, parentId);
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting AbstractFile children for Content", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return list;
    }

    List<Content> getAbstractFileChildren(Content parent) throws TskCoreException {
        List<Content> list;
        CaseDbConnection connection = null;
        ResultSet rs = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_FILES_BY_PARENT);
            statement.clearParameters();
            long parentId = parent.getId();
            statement.setLong(1, parentId);
            rs = connection.executeQuery(statement);
            list = this.fileChildren(rs, connection, parentId);
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting AbstractFile children for Content", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return list;
    }

    List<Long> getAbstractFileChildrenIds(Content parent, TskData.TSK_DB_FILES_TYPE_ENUM type) throws TskCoreException {
        ArrayList<Long> arrayList;
        CaseDbConnection connection = null;
        ResultSet rs = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_FILE_IDS_BY_PARENT_AND_TYPE);
            statement.clearParameters();
            statement.setLong(1, parent.getId());
            statement.setShort(2, type.getFileType());
            rs = connection.executeQuery(statement);
            ArrayList<Long> children = new ArrayList<Long>();
            while (rs.next()) {
                children.add(rs.getLong("obj_id"));
            }
            arrayList = children;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting AbstractFile children for Content", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    List<Long> getAbstractFileChildrenIds(Content parent) throws TskCoreException {
        ArrayList<Long> arrayList;
        CaseDbConnection connection = null;
        ResultSet rs = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_FILE_IDS_BY_PARENT);
            statement.clearParameters();
            statement.setLong(1, parent.getId());
            rs = connection.executeQuery(statement);
            ArrayList<Long> children = new ArrayList<Long>();
            while (rs.next()) {
                children.add(rs.getLong("obj_id"));
            }
            arrayList = children;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting AbstractFile children for Content", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    List<Long> getBlackboardArtifactChildrenIds(Content parent) throws TskCoreException {
        ArrayList<Long> arrayList;
        CaseDbConnection connection = null;
        ResultSet rs = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_ARTIFACT_OBJECTIDS_BY_PARENT);
            statement.clearParameters();
            statement.setLong(1, parent.getId());
            rs = connection.executeQuery(statement);
            ArrayList<Long> children = new ArrayList<Long>();
            while (rs.next()) {
                children.add(rs.getLong("obj_id"));
            }
            arrayList = children;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting children for BlackboardArtifact", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    List<Content> getBlackboardArtifactChildren(Content parent) throws TskCoreException {
        long parentId = parent.getId();
        ArrayList<Content> lc = new ArrayList<Content>();
        lc.addAll(this.blackboard.getAnalysisResults(parentId));
        lc.addAll(this.blackboard.getDataArtifactsBySource(parentId));
        return lc;
    }

    Collection<ObjectInfo> getChildrenInfo(Content c) throws TskCoreException {
        ArrayList<ObjectInfo> arrayList;
        CaseDbConnection connection = null;
        Statement s = null;
        ResultSet rs = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT tsk_objects.obj_id AS obj_id, tsk_objects.type AS type FROM tsk_objects LEFT JOIN tsk_files ON tsk_objects.obj_id = tsk_files.obj_id WHERE tsk_objects.par_obj_id = " + c.getId() + " ORDER BY tsk_objects.obj_id");
            ArrayList<ObjectInfo> infos = new ArrayList<ObjectInfo>();
            while (rs.next()) {
                infos.add(new ObjectInfo(rs.getLong("obj_id"), TskData.ObjectType.valueOf(rs.getShort("type"))));
            }
            arrayList = infos;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting Children Info for Content", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    ObjectInfo getParentInfo(Content c) throws TskCoreException {
        return this.getParentInfo(c.getId());
    }

    ObjectInfo getParentInfo(long contentId) throws TskCoreException {
        ObjectInfo objectInfo;
        ResultSet rs;
        Statement s;
        CaseDbConnection connection;
        block5: {
            this.acquireSingleUserCaseReadLock();
            connection = null;
            s = null;
            rs = null;
            connection = this.connections.getConnection();
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT parent.obj_id AS obj_id, parent.type AS type FROM tsk_objects AS parent INNER JOIN tsk_objects AS child ON child.par_obj_id = parent.obj_id WHERE child.obj_id = " + contentId);
            if (!rs.next()) break block5;
            ObjectInfo objectInfo2 = new ObjectInfo(rs.getLong("obj_id"), TskData.ObjectType.valueOf(rs.getShort("type")));
            SleuthkitCase.closeResultSet(rs);
            SleuthkitCase.closeStatement(s);
            SleuthkitCase.closeConnection(connection);
            this.releaseSingleUserCaseReadLock();
            return objectInfo2;
        }
        try {
            objectInfo = null;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting Parent Info for Content: " + contentId, ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return objectInfo;
    }

    Directory getParentDirectory(FsContent fsc) throws TskCoreException {
        if (fsc.isRoot()) {
            return null;
        }
        ObjectInfo parentInfo = this.getParentInfo(fsc);
        if (parentInfo == null) {
            return null;
        }
        Directory parent = null;
        if (parentInfo.type != TskData.ObjectType.ABSTRACTFILE) {
            throw new TskCoreException("Parent of FsContent (id: " + fsc.getId() + ") has wrong type to be directory: " + String.valueOf((Object)parentInfo.type));
        }
        parent = this.getDirectoryById(parentInfo.id, fsc.getFileSystem());
        return parent;
    }

    public Content getContentById(long id) throws TskCoreException {
        TskData.ObjectType type;
        long parentId;
        ResultSet rs;
        Statement s;
        CaseDbConnection connection;
        Content content;
        block18: {
            content = this.frequentlyUsedContentMap.get(id);
            if (null != content) {
                return content;
            }
            connection = null;
            s = null;
            rs = null;
            this.acquireSingleUserCaseReadLock();
            connection = this.connections.getConnection();
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT * FROM tsk_objects WHERE obj_id = " + id + " LIMIT  1");
            if (rs.next()) break block18;
            Content content2 = null;
            SleuthkitCase.closeResultSet(rs);
            SleuthkitCase.closeStatement(s);
            SleuthkitCase.closeConnection(connection);
            this.releaseSingleUserCaseReadLock();
            return content2;
        }
        try {
            parentId = rs.getLong("par_obj_id");
            type = TskData.ObjectType.valueOf(rs.getShort("type"));
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting Content by ID.", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        switch (type) {
            case IMG: {
                content = this.getImageById(id);
                this.frequentlyUsedContentMap.put(id, content);
                break;
            }
            case VS: {
                content = this.getVolumeSystemById(id, parentId);
                break;
            }
            case VOL: {
                content = this.getVolumeById(id, parentId);
                this.frequentlyUsedContentMap.put(id, content);
                break;
            }
            case POOL: {
                content = this.getPoolById(id, parentId);
                break;
            }
            case FS: {
                content = this.getFileSystemById(id, parentId);
                this.frequentlyUsedContentMap.put(id, content);
                break;
            }
            case ABSTRACTFILE: {
                content = this.getAbstractFileById(id);
                if (!((AbstractFile)content).isVirtual() && (content instanceof LocalDirectory || !((AbstractFile)content).isRoot())) break;
                this.frequentlyUsedContentMap.put(id, content);
                break;
            }
            case ARTIFACT: {
                content = this.getArtifactById(id);
                break;
            }
            case REPORT: {
                content = this.getReportById(id);
                break;
            }
            case OS_ACCOUNT: {
                content = this.osAccountManager.getOsAccountByObjectId(id);
                break;
            }
            case HOST_ADDRESS: {
                content = this.hostAddressManager.getHostAddress(id);
                break;
            }
            default: {
                content = new UnsupportedContent(this, id);
            }
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getFilePath(long id) {
        String filePath;
        block6: {
            filePath = null;
            CaseDbConnection connection = null;
            ResultSet rs = null;
            this.acquireSingleUserCaseReadLock();
            try {
                connection = this.connections.getConnection();
                PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_LOCAL_PATH_FOR_FILE);
                statement.clearParameters();
                statement.setLong(1, id);
                rs = connection.executeQuery(statement);
                if (rs.next()) {
                    filePath = rs.getString("path");
                }
                SleuthkitCase.closeResultSet(rs);
            }
            catch (SQLException | TskCoreException ex) {
                logger.log(Level.SEVERE, "Error getting file path for file " + id, ex);
                break block6;
            }
            finally {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
            }
            SleuthkitCase.closeConnection(connection);
            this.releaseSingleUserCaseReadLock();
        }
        return filePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TskData.EncodingType getEncodingType(long id) {
        TskData.EncodingType type;
        block6: {
            type = TskData.EncodingType.NONE;
            CaseDbConnection connection = null;
            ResultSet rs = null;
            this.acquireSingleUserCaseReadLock();
            try {
                connection = this.connections.getConnection();
                PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_ENCODING_FOR_FILE);
                statement.clearParameters();
                statement.setLong(1, id);
                rs = connection.executeQuery(statement);
                if (rs.next()) {
                    type = TskData.EncodingType.valueOf(rs.getInt(1));
                }
                SleuthkitCase.closeResultSet(rs);
            }
            catch (SQLException | TskCoreException ex) {
                logger.log(Level.SEVERE, "Error getting encoding type for file " + id, ex);
                break block6;
            }
            finally {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
            }
            SleuthkitCase.closeConnection(connection);
            this.releaseSingleUserCaseReadLock();
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getFileParentPath(long objectId, CaseDbConnection connection) {
        String parentPath = null;
        this.acquireSingleUserCaseReadLock();
        ResultSet rs = null;
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_PATH_FOR_FILE);
            statement.clearParameters();
            statement.setLong(1, objectId);
            rs = connection.executeQuery(statement);
            if (rs.next()) {
                parentPath = rs.getString("parent_path");
            }
            SleuthkitCase.closeResultSet(rs);
            this.releaseSingleUserCaseReadLock();
        }
        catch (SQLException ex) {
            logger.log(Level.SEVERE, "Error getting file parent_path for file " + objectId, ex);
        }
        finally {
            SleuthkitCase.closeResultSet(rs);
            this.releaseSingleUserCaseReadLock();
        }
        return parentPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getFileName(long objectId, CaseDbConnection connection) {
        String fileName = null;
        this.acquireSingleUserCaseReadLock();
        ResultSet rs = null;
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_FILE_NAME);
            statement.clearParameters();
            statement.setLong(1, objectId);
            rs = connection.executeQuery(statement);
            if (rs.next()) {
                fileName = rs.getString("name");
            }
            SleuthkitCase.closeResultSet(rs);
            this.releaseSingleUserCaseReadLock();
        }
        catch (SQLException ex) {
            logger.log(Level.SEVERE, "Error getting file parent_path for file " + objectId, ex);
        }
        finally {
            SleuthkitCase.closeResultSet(rs);
            this.releaseSingleUserCaseReadLock();
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DerivedFile.DerivedMethod getDerivedMethod(long id) throws TskCoreException {
        DerivedFile.DerivedMethod method;
        block7: {
            method = null;
            CaseDbConnection connection = null;
            ResultSet rs1 = null;
            ResultSet rs2 = null;
            this.acquireSingleUserCaseReadLock();
            try {
                connection = this.connections.getConnection();
                PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_DERIVED_FILE);
                statement.clearParameters();
                statement.setLong(1, id);
                rs1 = connection.executeQuery(statement);
                if (rs1.next()) {
                    int method_id = rs1.getInt("derived_id");
                    String rederive = rs1.getString("rederive");
                    method = new DerivedFile.DerivedMethod(method_id, rederive);
                    statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_FILE_DERIVATION_METHOD);
                    statement.clearParameters();
                    statement.setInt(1, method_id);
                    rs2 = connection.executeQuery(statement);
                    if (rs2.next()) {
                        method.setToolName(rs2.getString("tool_name"));
                        method.setToolVersion(rs2.getString("tool_version"));
                        method.setOther(rs2.getString("other"));
                    }
                }
                SleuthkitCase.closeResultSet(rs2);
            }
            catch (SQLException e) {
                logger.log(Level.SEVERE, "Error getting derived method for file: " + id, e);
                break block7;
            }
            finally {
                SleuthkitCase.closeResultSet(rs2);
                SleuthkitCase.closeResultSet(rs1);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
            }
            SleuthkitCase.closeResultSet(rs1);
            SleuthkitCase.closeConnection(connection);
            this.releaseSingleUserCaseReadLock();
        }
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractFile getAbstractFileById(long id) throws TskCoreException {
        CaseDbConnection connection = this.connections.getConnection();
        try {
            AbstractFile abstractFile = this.getAbstractFileById(id, connection);
            return abstractFile;
        }
        finally {
            SleuthkitCase.closeConnection(connection);
        }
    }

    AbstractFile getAbstractFileById(long objectId, CaseDbConnection connection) throws TskCoreException {
        AbstractFile abstractFile;
        ResultSet rs;
        block5: {
            this.acquireSingleUserCaseReadLock();
            rs = null;
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_FILE_BY_ID);
            statement.clearParameters();
            statement.setLong(1, objectId);
            rs = connection.executeQuery(statement);
            List<AbstractFile> files = this.resultSetToAbstractFiles(rs, connection);
            if (files.size() <= 0) break block5;
            AbstractFile abstractFile2 = files.get(0);
            SleuthkitCase.closeResultSet(rs);
            this.releaseSingleUserCaseReadLock();
            return abstractFile2;
        }
        try {
            abstractFile = null;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting file by id, id = " + objectId, ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        this.releaseSingleUserCaseReadLock();
        return abstractFile;
    }

    /*
     * Exception decompiling
     */
    public BlackboardArtifact getArtifactById(long id) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Deprecated
    public BlackboardArtifact getArtifactByArtifactId(long id) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 20[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getFileSystemId(long fileId, CaseDbConnection connection) {
        this.acquireSingleUserCaseReadLock();
        ResultSet rs = null;
        long ret = -1L;
        try {
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_FILE_SYSTEM_BY_OBJECT);
            statement.clearParameters();
            statement.setLong(1, fileId);
            rs = connection.executeQuery(statement);
            if (rs.next() && (ret = rs.getLong("fs_obj_id")) == 0L) {
                ret = -1L;
            }
            SleuthkitCase.closeResultSet(rs);
            this.releaseSingleUserCaseReadLock();
        }
        catch (SQLException e) {
            logger.log(Level.SEVERE, "Error checking file system id of a file, id = " + fileId, e);
        }
        finally {
            SleuthkitCase.closeResultSet(rs);
            this.releaseSingleUserCaseReadLock();
        }
        return ret;
    }

    public boolean isFileFromSource(Content dataSource, long fileId) throws TskCoreException {
        boolean bl;
        String query = String.format("SELECT COUNT(*) AS count FROM tsk_files WHERE obj_id = %d AND data_source_obj_id = %d", fileId, dataSource.getId());
        CaseDbConnection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            statement = connection.createStatement();
            resultSet = connection.executeQuery(statement, query);
            resultSet.next();
            bl = resultSet.getLong("count") > 0L;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException(String.format("Error executing query %s", query), ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeStatement(statement);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeStatement(statement);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return bl;
    }

    private static boolean containsLikeWildcard(String str) {
        if (str == null) {
            return false;
        }
        return str.contains("%") || str.contains("_");
    }

    public List<AbstractFile> findFiles(Content dataSource, String fileName) throws TskCoreException {
        String ext = "";
        if (!SleuthkitCase.containsLikeWildcard(fileName)) {
            ext = SleuthkitCase.extractExtension(fileName);
        }
        ArrayList<AbstractFile> files = new ArrayList<AbstractFile>();
        CaseDbConnection connection = null;
        ResultSet resultSet = null;
        this.acquireSingleUserCaseReadLock();
        try {
            PreparedStatement statement;
            connection = this.connections.getConnection();
            if (ext.isEmpty()) {
                statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_FILES_BY_DATA_SOURCE_AND_NAME);
                statement.clearParameters();
                statement.setString(1, fileName.toLowerCase());
                statement.setLong(2, dataSource.getId());
            } else {
                statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_FILES_BY_EXTENSION_AND_DATA_SOURCE_AND_NAME);
                statement.clearParameters();
                statement.setString(1, ext);
                statement.setString(2, fileName.toLowerCase());
                statement.setLong(3, dataSource.getId());
            }
            resultSet = connection.executeQuery(statement);
            files.addAll(this.resultSetToAbstractFiles(resultSet, connection));
        }
        catch (SQLException e) {
            try {
                throw new TskCoreException(bundle.getString("SleuthkitCase.findFiles.exception.msg3.text"), e);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return files;
    }

    public List<AbstractFile> findFiles(Content dataSource, String fileName, String dirSubString) throws TskCoreException {
        String ext = "";
        if (!SleuthkitCase.containsLikeWildcard(fileName)) {
            ext = SleuthkitCase.extractExtension(fileName);
        }
        ArrayList<AbstractFile> files = new ArrayList<AbstractFile>();
        CaseDbConnection connection = null;
        ResultSet resultSet = null;
        this.acquireSingleUserCaseReadLock();
        try {
            PreparedStatement statement;
            connection = this.connections.getConnection();
            if (ext.isEmpty()) {
                statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_FILES_BY_DATA_SOURCE_AND_PARENT_PATH_AND_NAME);
                statement.clearParameters();
                statement.setString(1, fileName.toLowerCase());
                statement.setString(2, "%" + dirSubString.toLowerCase() + "%");
                statement.setLong(3, dataSource.getId());
            } else {
                statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_FILES_BY_EXTENSION_AND_DATA_SOURCE_AND_PARENT_PATH_AND_NAME);
                statement.clearParameters();
                statement.setString(1, ext);
                statement.setString(2, fileName.toLowerCase());
                statement.setString(3, "%" + dirSubString.toLowerCase() + "%");
                statement.setLong(4, dataSource.getId());
            }
            resultSet = connection.executeQuery(statement);
            files.addAll(this.resultSetToAbstractFiles(resultSet, connection));
        }
        catch (SQLException e) {
            try {
                throw new TskCoreException(bundle.getString("SleuthkitCase.findFiles3.exception.msg3.text"), e);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualDirectory addVirtualDirectory(long parentId, String directoryName) throws TskCoreException {
        CaseDbTransaction localTrans = this.beginTransaction();
        try {
            VirtualDirectory newVD = this.addVirtualDirectory(parentId, directoryName, localTrans);
            localTrans.commit();
            localTrans = null;
            VirtualDirectory virtualDirectory = newVD;
            return virtualDirectory;
        }
        finally {
            if (null != localTrans) {
                try {
                    localTrans.rollback();
                }
                catch (TskCoreException ex2) {
                    logger.log(Level.SEVERE, "Failed to rollback transaction after exception", ex2);
                }
            }
        }
    }

    long addObject(long parentId, int objectType, CaseDbConnection connection) throws SQLException {
        block6: {
            long l;
            ResultSet resultSet = null;
            this.acquireSingleUserCaseWriteLock();
            try {
                PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_OBJECT, 1);
                statement.clearParameters();
                if (parentId != 0L) {
                    statement.setLong(1, parentId);
                } else {
                    statement.setNull(1, -5);
                }
                statement.setInt(2, objectType);
                connection.executeUpdate(statement);
                resultSet = statement.getGeneratedKeys();
                if (!resultSet.next()) break block6;
                if (parentId != 0L) {
                    this.setHasChildren(parentId);
                }
                l = resultSet.getLong(1);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                this.releaseSingleUserCaseWriteLock();
                throw throwable;
            }
            SleuthkitCase.closeResultSet(resultSet);
            this.releaseSingleUserCaseWriteLock();
            return l;
        }
        throw new SQLException("Error inserting object with parent " + parentId + " into tsk_objects");
    }

    public VirtualDirectory addVirtualDirectory(long parentId, String directoryName, CaseDbTransaction transaction) throws TskCoreException {
        if (transaction == null) {
            throw new TskCoreException("Passed null CaseDbTransaction");
        }
        ResultSet resultSet = null;
        try {
            CaseDbConnection connection = transaction.getConnection();
            AbstractFile parent = this.getAbstractFileById(parentId, connection);
            Object parentPath = parent instanceof AbstractFile ? (this.isRootDirectory(parent, transaction) ? (parent.getName().isEmpty() ? "/" : "/" + parent.getName() + "/") : parent.getParentPath() + parent.getName() + "/") : "/";
            long newObjId = this.addObject(parentId, TskData.ObjectType.ABSTRACTFILE.getObjectType(), connection);
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_FILE);
            statement.clearParameters();
            statement.setLong(1, newObjId);
            Long fileSystemObjectId = null;
            if (0L != parentId) {
                fileSystemObjectId = this.getFileSystemId(parentId, connection);
                if (fileSystemObjectId != -1L) {
                    statement.setLong(2, fileSystemObjectId);
                } else {
                    statement.setNull(2, -5);
                    fileSystemObjectId = null;
                }
            } else {
                statement.setNull(2, -5);
            }
            statement.setString(3, directoryName);
            statement.setShort(4, TskData.TSK_DB_FILES_TYPE_ENUM.VIRTUAL_DIR.getFileType());
            statement.setShort(5, (short)1);
            TskData.TSK_FS_NAME_TYPE_ENUM dirType = TskData.TSK_FS_NAME_TYPE_ENUM.DIR;
            statement.setShort(6, dirType.getValue());
            TskData.TSK_FS_META_TYPE_ENUM metaType = TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_DIR;
            statement.setShort(7, metaType.getValue());
            TskData.TSK_FS_NAME_FLAG_ENUM dirFlag = TskData.TSK_FS_NAME_FLAG_ENUM.ALLOC;
            statement.setShort(8, dirFlag.getValue());
            short metaFlags = (short)(TskData.TSK_FS_META_FLAG_ENUM.ALLOC.getValue() | TskData.TSK_FS_META_FLAG_ENUM.USED.getValue());
            statement.setShort(9, metaFlags);
            statement.setLong(10, 0L);
            statement.setNull(11, -5);
            statement.setNull(12, -5);
            statement.setNull(13, -5);
            statement.setNull(14, -5);
            statement.setNull(15, 12);
            statement.setNull(16, 12);
            statement.setNull(17, 12);
            statement.setByte(18, TskData.FileKnown.UNKNOWN.getFileKnownValue());
            statement.setNull(19, 12);
            statement.setString(20, (String)parentPath);
            long dataSourceObjectId = 0L == parentId ? newObjId : this.getDataSourceObjectId(connection, parentId);
            statement.setLong(21, dataSourceObjectId);
            statement.setString(22, null);
            statement.setString(23, OsAccount.NO_OWNER_ID);
            statement.setNull(24, -5);
            statement.setLong(25, TskData.CollectedStatus.UNKNOWN.getType());
            connection.executeUpdate(statement);
            VirtualDirectory virtualDirectory = new VirtualDirectory(this, newObjId, dataSourceObjectId, fileSystemObjectId, directoryName, dirType, metaType, dirFlag, metaFlags, null, null, null, TskData.FileKnown.UNKNOWN, (String)parentPath);
            return virtualDirectory;
        }
        catch (SQLException e) {
            throw new TskCoreException("Error creating virtual directory '" + directoryName + "'", e);
        }
        finally {
            SleuthkitCase.closeResultSet(resultSet);
        }
    }

    public LocalDirectory addLocalDirectory(long parentId, String directoryName) throws TskCoreException {
        CaseDbTransaction localTrans = this.beginTransaction();
        try {
            LocalDirectory newLD = this.addLocalDirectory(parentId, directoryName, localTrans);
            localTrans.commit();
            return newLD;
        }
        catch (TskCoreException ex) {
            try {
                localTrans.rollback();
            }
            catch (TskCoreException ex2) {
                logger.log(Level.SEVERE, String.format("Failed to rollback transaction after exception: %s", ex.getMessage()), ex2);
            }
            throw ex;
        }
    }

    public LocalDirectory addLocalDirectory(long parentId, String directoryName, CaseDbTransaction transaction) throws TskCoreException {
        if (transaction == null) {
            throw new TskCoreException("Passed null CaseDbTransaction");
        }
        ResultSet resultSet = null;
        try {
            CaseDbConnection connection = transaction.getConnection();
            AbstractFile parent = this.getAbstractFileById(parentId, connection);
            Object parentPath = parent == null || this.isRootDirectory(parent, transaction) ? "/" : parent.getParentPath() + parent.getName() + "/";
            long newObjId = this.addObject(parentId, TskData.ObjectType.ABSTRACTFILE.getObjectType(), connection);
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_FILE);
            statement.clearParameters();
            statement.setLong(1, newObjId);
            statement.setNull(2, -5);
            statement.setString(3, directoryName);
            statement.setShort(4, TskData.TSK_DB_FILES_TYPE_ENUM.LOCAL_DIR.getFileType());
            statement.setShort(5, (short)1);
            TskData.TSK_FS_NAME_TYPE_ENUM dirType = TskData.TSK_FS_NAME_TYPE_ENUM.DIR;
            statement.setShort(6, dirType.getValue());
            TskData.TSK_FS_META_TYPE_ENUM metaType = TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_DIR;
            statement.setShort(7, metaType.getValue());
            TskData.TSK_FS_NAME_FLAG_ENUM dirFlag = TskData.TSK_FS_NAME_FLAG_ENUM.ALLOC;
            statement.setShort(8, dirFlag.getValue());
            short metaFlags = (short)(TskData.TSK_FS_META_FLAG_ENUM.ALLOC.getValue() | TskData.TSK_FS_META_FLAG_ENUM.USED.getValue());
            statement.setShort(9, metaFlags);
            statement.setLong(10, 0L);
            statement.setNull(11, -5);
            statement.setNull(12, -5);
            statement.setNull(13, -5);
            statement.setNull(14, -5);
            statement.setNull(15, 12);
            statement.setNull(16, 12);
            statement.setNull(17, 12);
            statement.setByte(18, TskData.FileKnown.UNKNOWN.getFileKnownValue());
            statement.setNull(19, 12);
            statement.setString(20, (String)parentPath);
            long dataSourceObjectId = this.getDataSourceObjectId(connection, parentId);
            statement.setLong(21, dataSourceObjectId);
            statement.setString(22, null);
            statement.setString(23, OsAccount.NO_OWNER_ID);
            statement.setNull(24, -5);
            statement.setLong(25, TskData.CollectedStatus.UNKNOWN.getType());
            connection.executeUpdate(statement);
            LocalDirectory localDirectory = new LocalDirectory(this, newObjId, dataSourceObjectId, directoryName, dirType, metaType, dirFlag, metaFlags, null, null, null, TskData.FileKnown.UNKNOWN, (String)parentPath);
            return localDirectory;
        }
        catch (SQLException e) {
            throw new TskCoreException("Error creating local directory '" + directoryName + "'", e);
        }
        finally {
            SleuthkitCase.closeResultSet(resultSet);
        }
    }

    public LocalFilesDataSource addLocalFilesDataSource(String deviceId, String rootDirectoryName, String timeZone, CaseDbTransaction transaction) throws TskCoreException {
        return this.addLocalFilesDataSource(deviceId, rootDirectoryName, timeZone, null, transaction);
    }

    public LocalFilesDataSource addLocalFilesDataSource(String deviceId, String rootDirectoryName, String timeZone, Host host, CaseDbTransaction transaction) throws TskCoreException {
        LocalFilesDataSource localFilesDataSource;
        Statement statement = null;
        try {
            CaseDbConnection connection = transaction.getConnection();
            long newObjId = this.addObject(0L, TskData.ObjectType.ABSTRACTFILE.getObjectType(), connection);
            if (host == null) {
                host = this.getHostManager().newHost("LogicalFileSet_" + newObjId + " Host", transaction);
            }
            statement = connection.createStatement();
            statement.executeUpdate("INSERT INTO data_source_info (obj_id, device_id, time_zone, host_id) VALUES(" + newObjId + ", '" + deviceId + "', '" + timeZone + "', " + host.getHostId() + ");");
            PreparedStatement preparedStatement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_FILE);
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, newObjId);
            preparedStatement.setNull(2, -5);
            preparedStatement.setString(3, rootDirectoryName);
            preparedStatement.setShort(4, TskData.TSK_DB_FILES_TYPE_ENUM.VIRTUAL_DIR.getFileType());
            preparedStatement.setShort(5, (short)1);
            TskData.TSK_FS_NAME_TYPE_ENUM dirType = TskData.TSK_FS_NAME_TYPE_ENUM.DIR;
            preparedStatement.setShort(6, TskData.TSK_FS_NAME_TYPE_ENUM.DIR.getValue());
            TskData.TSK_FS_META_TYPE_ENUM metaType = TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_DIR;
            preparedStatement.setShort(7, metaType.getValue());
            TskData.TSK_FS_NAME_FLAG_ENUM dirFlag = TskData.TSK_FS_NAME_FLAG_ENUM.ALLOC;
            preparedStatement.setShort(8, dirFlag.getValue());
            short metaFlags = (short)(TskData.TSK_FS_META_FLAG_ENUM.ALLOC.getValue() | TskData.TSK_FS_META_FLAG_ENUM.USED.getValue());
            preparedStatement.setShort(9, metaFlags);
            preparedStatement.setLong(10, 0L);
            preparedStatement.setNull(11, -5);
            preparedStatement.setNull(12, -5);
            preparedStatement.setNull(13, -5);
            preparedStatement.setNull(14, -5);
            preparedStatement.setNull(15, 12);
            preparedStatement.setNull(16, 12);
            preparedStatement.setNull(17, 12);
            preparedStatement.setByte(18, TskData.FileKnown.UNKNOWN.getFileKnownValue());
            preparedStatement.setNull(19, 12);
            String parentPath = "/";
            preparedStatement.setString(20, parentPath);
            preparedStatement.setLong(21, newObjId);
            preparedStatement.setString(22, null);
            preparedStatement.setString(23, OsAccount.NO_OWNER_ID);
            preparedStatement.setNull(24, -5);
            preparedStatement.setLong(25, TskData.CollectedStatus.UNKNOWN.getType());
            connection.executeUpdate(preparedStatement);
            localFilesDataSource = new LocalFilesDataSource(this, newObjId, newObjId, deviceId, rootDirectoryName, dirType, metaType, dirFlag, metaFlags, timeZone, null, null, null, TskData.FileKnown.UNKNOWN, parentPath);
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException(String.format("Error creating local files data source with device id %s and directory name %s", deviceId, rootDirectoryName), ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeStatement(statement);
                throw throwable;
            }
        }
        SleuthkitCase.closeStatement(statement);
        return localFilesDataSource;
    }

    public Image addImage(TskData.TSK_IMG_TYPE_ENUM type, long sectorSize, long size, String displayName, List<String> imagePaths, String timezone, String md5, String sha1, String sha256, String deviceId, CaseDbTransaction transaction) throws TskCoreException {
        return this.addImage(type, sectorSize, size, displayName, imagePaths, timezone, md5, sha1, sha256, deviceId, null, transaction);
    }

    public Image addImage(TskData.TSK_IMG_TYPE_ENUM type, long sectorSize, long size, String displayName, List<String> imagePaths, String timezone, String md5, String sha1, String sha256, String deviceId, Host host, CaseDbTransaction transaction) throws TskCoreException {
        return this.addImage(type, sectorSize, size, displayName, imagePaths, timezone, md5, sha1, sha256, deviceId, host, null, transaction);
    }

    @Beta
    public Image addImage(TskData.TSK_IMG_TYPE_ENUM type, long sectorSize, long size, String displayName, List<String> imagePaths, String timezone, String md5, String sha1, String sha256, String deviceId, Host host, String password, CaseDbTransaction transaction) throws TskCoreException {
        Image image;
        Statement statement = null;
        try {
            CaseDbConnection connection = transaction.getConnection();
            long newObjId = this.addObject(0L, TskData.ObjectType.IMG.getObjectType(), connection);
            PreparedStatement preparedStatement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_IMAGE_INFO);
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, newObjId);
            preparedStatement.setShort(2, (short)type.getValue());
            preparedStatement.setLong(3, sectorSize);
            preparedStatement.setString(4, timezone);
            long savedSize = size < 0L ? 0L : size;
            preparedStatement.setLong(5, savedSize);
            preparedStatement.setString(6, md5);
            preparedStatement.setString(7, sha1);
            preparedStatement.setString(8, sha256);
            preparedStatement.setString(9, displayName);
            connection.executeUpdate(preparedStatement);
            for (int i = 0; i < imagePaths.size(); ++i) {
                preparedStatement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_IMAGE_NAME);
                preparedStatement.clearParameters();
                preparedStatement.setLong(1, newObjId);
                preparedStatement.setString(2, imagePaths.get(i));
                preparedStatement.setLong(3, i);
                connection.executeUpdate(preparedStatement);
            }
            String name = displayName;
            if (name == null || name.isEmpty()) {
                if (imagePaths.size() > 0) {
                    String path = imagePaths.get(0);
                    name = new java.io.File(path).getName();
                } else {
                    name = "";
                }
            }
            if (host == null) {
                host = name.isEmpty() ? this.getHostManager().newHost("Image_" + newObjId + " Host", transaction) : this.getHostManager().newHost(name + "_" + newObjId + " Host", transaction);
            }
            HashMap<String, String> acquisitionToolMap = new HashMap<String, String>();
            if (password != null) {
                acquisitionToolMap.put(IMAGE_PASSWORD_KEY, password);
            }
            String acquisitionToolJson = new Gson().toJson(acquisitionToolMap);
            preparedStatement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_DATA_SOURCE_INFO);
            statement = connection.createStatement();
            preparedStatement.setLong(1, newObjId);
            preparedStatement.setString(2, deviceId);
            preparedStatement.setString(3, timezone);
            preparedStatement.setLong(4, new Date().getTime());
            preparedStatement.setLong(5, host.getHostId());
            preparedStatement.setString(6, acquisitionToolJson);
            connection.executeUpdate(preparedStatement);
            image = new Image(this, newObjId, type.getValue(), deviceId, sectorSize, name, imagePaths.toArray(new String[imagePaths.size()]), timezone, md5, sha1, sha256, savedSize);
        }
        catch (SQLException ex) {
            try {
                if (!imagePaths.isEmpty()) {
                    throw new TskCoreException(String.format("Error adding image with path %s to database", imagePaths.get(0)), ex);
                }
                throw new TskCoreException(String.format("Error adding image with display name %s to database", displayName), ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeStatement(statement);
                throw throwable;
            }
        }
        SleuthkitCase.closeStatement(statement);
        return image;
    }

    public VolumeSystem addVolumeSystem(long parentObjId, TskData.TSK_VS_TYPE_ENUM type, long imgOffset, long blockSize, CaseDbTransaction transaction) throws TskCoreException {
        try {
            CaseDbConnection connection = transaction.getConnection();
            long newObjId = this.addObject(parentObjId, TskData.ObjectType.VS.getObjectType(), connection);
            PreparedStatement preparedStatement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_VS_INFO);
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, newObjId);
            preparedStatement.setShort(2, (short)type.getVsType());
            preparedStatement.setLong(3, imgOffset);
            preparedStatement.setLong(4, blockSize);
            connection.executeUpdate(preparedStatement);
            return new VolumeSystem(this, newObjId, "", type.getVsType(), imgOffset, blockSize);
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error creating volume system with parent ID %d and image offset %d", parentObjId, imgOffset), ex);
        }
    }

    public Volume addVolume(long parentObjId, long addr, long start, long length, String desc, long flags, CaseDbTransaction transaction) throws TskCoreException {
        try {
            CaseDbConnection connection = transaction.getConnection();
            long newObjId = this.addObject(parentObjId, TskData.ObjectType.VOL.getObjectType(), connection);
            PreparedStatement preparedStatement = this.dbType == TskData.DbType.POSTGRESQL ? connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_VS_PART_POSTGRESQL) : connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_VS_PART_SQLITE);
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, newObjId);
            preparedStatement.setLong(2, addr);
            preparedStatement.setLong(3, start);
            preparedStatement.setLong(4, length);
            preparedStatement.setString(5, desc);
            preparedStatement.setShort(6, (short)flags);
            connection.executeUpdate(preparedStatement);
            return new Volume(this, newObjId, addr, start, length, flags, desc);
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error creating volume with address %d and parent ID %d", addr, parentObjId), ex);
        }
    }

    public Pool addPool(long parentObjId, TskData.TSK_POOL_TYPE_ENUM type, CaseDbTransaction transaction) throws TskCoreException {
        try {
            CaseDbConnection connection = transaction.getConnection();
            long newObjId = this.addObject(parentObjId, TskData.ObjectType.POOL.getObjectType(), connection);
            PreparedStatement preparedStatement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_POOL_INFO);
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, newObjId);
            preparedStatement.setShort(2, type.getValue());
            connection.executeUpdate(preparedStatement);
            return new Pool(this, newObjId, type.getName(), type.getValue());
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error creating pool with type %d and parent ID %d", type.getValue(), parentObjId), ex);
        }
    }

    public FileSystem addFileSystem(long parentObjId, long imgOffset, TskData.TSK_FS_TYPE_ENUM type, long blockSize, long blockCount, long rootInum, long firstInum, long lastInum, String displayName, CaseDbTransaction transaction) throws TskCoreException {
        try {
            CaseDbConnection connection = transaction.getConnection();
            long newObjId = this.addObject(parentObjId, TskData.ObjectType.FS.getObjectType(), connection);
            long dataSourceId = this.getDataSourceObjectId(connection, newObjId);
            PreparedStatement preparedStatement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_FS_INFO);
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, newObjId);
            preparedStatement.setLong(2, dataSourceId);
            preparedStatement.setLong(3, imgOffset);
            preparedStatement.setInt(4, type.getValue());
            preparedStatement.setLong(5, blockSize);
            preparedStatement.setLong(6, blockCount);
            preparedStatement.setLong(7, rootInum);
            preparedStatement.setLong(8, firstInum);
            preparedStatement.setLong(9, lastInum);
            preparedStatement.setString(10, displayName);
            connection.executeUpdate(preparedStatement);
            return new FileSystem(this, newObjId, displayName, imgOffset, type, blockSize, blockCount, rootInum, firstInum, lastInum);
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error creating file system with image offset %d and parent ID %d", imgOffset, parentObjId), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FsContent addFileSystemFile(long dataSourceObjId, long fsObjId, String fileName, long metaAddr, int metaSeq, TskData.TSK_FS_ATTR_TYPE_ENUM attrType, int attrId, TskData.TSK_FS_NAME_FLAG_ENUM dirFlag, short metaFlags, long size, long ctime, long crtime, long atime, long mtime, boolean isFile, Content parent) throws TskCoreException {
        CaseDbTransaction transaction = this.beginTransaction();
        try {
            FsContent fileSystemFile = this.addFileSystemFile(dataSourceObjId, fsObjId, fileName, metaAddr, metaSeq, attrType, attrId, dirFlag, metaFlags, size, ctime, crtime, atime, mtime, null, null, null, isFile, parent, OsAccount.NO_OWNER_ID, null, Collections.emptyList(), transaction);
            transaction.commit();
            transaction = null;
            FsContent fsContent = fileSystemFile;
            return fsContent;
        }
        finally {
            if (null != transaction) {
                try {
                    transaction.rollback();
                }
                catch (TskCoreException ex2) {
                    logger.log(Level.SEVERE, "Failed to rollback transaction after exception", ex2);
                }
            }
        }
    }

    public FsContent addFileSystemFile(long dataSourceObjId, long fsObjId, String fileName, long metaAddr, int metaSeq, TskData.TSK_FS_ATTR_TYPE_ENUM attrType, int attrId, TskData.TSK_FS_NAME_FLAG_ENUM dirFlag, short metaFlags, long size, long ctime, long crtime, long atime, long mtime, String md5Hash, String sha256Hash, String mimeType, boolean isFile, Content parent, String ownerUid, OsAccount osAccount, List<Attribute> fileAttributes, CaseDbTransaction transaction) throws TskCoreException {
        return this.addFileSystemFile(dataSourceObjId, fsObjId, fileName, metaAddr, metaSeq, attrType, attrId, dirFlag, metaFlags, size, ctime, crtime, atime, mtime, md5Hash, sha256Hash, null, mimeType, isFile, parent, ownerUid, osAccount, fileAttributes, transaction);
    }

    public FsContent addFileSystemFile(long dataSourceObjId, long fsObjId, String fileName, long metaAddr, int metaSeq, TskData.TSK_FS_ATTR_TYPE_ENUM attrType, int attrId, TskData.TSK_FS_NAME_FLAG_ENUM dirFlag, short metaFlags, long size, long ctime, long crtime, long atime, long mtime, String md5Hash, String sha256Hash, String sha1Hash, String mimeType, boolean isFile, Content parent, String ownerUid, OsAccount osAccount, List<Attribute> fileAttributes, CaseDbTransaction transaction) throws TskCoreException {
        return this.addFileSystemFile(dataSourceObjId, fsObjId, fileName, metaAddr, metaSeq, attrType, attrId, dirFlag, metaFlags, size, ctime, crtime, atime, mtime, md5Hash, sha256Hash, sha1Hash, mimeType, isFile, parent, ownerUid, osAccount, TskData.CollectedStatus.UNKNOWN, fileAttributes, transaction);
    }

    public FsContent addFileSystemFile(long dataSourceObjId, long fsObjId, String fileName, long metaAddr, int metaSeq, TskData.TSK_FS_ATTR_TYPE_ENUM attrType, int attrId, TskData.TSK_FS_NAME_FLAG_ENUM dirFlag, short metaFlags, long size, long ctime, long crtime, long atime, long mtime, String md5Hash, String sha256Hash, String sha1Hash, String mimeType, boolean isFile, Content parent, String ownerUid, OsAccount osAccount, TskData.CollectedStatus collected, List<Attribute> fileAttributes, CaseDbTransaction transaction) throws TskCoreException {
        TimelineManager timelineManager = this.getTimelineManager();
        Statement queryStatement = null;
        Object parentPath = "/";
        try {
            AbstractFile parentFile;
            CaseDbConnection connection = transaction.getConnection();
            long objectId = this.addObject(parent.getId(), TskData.ObjectType.ABSTRACTFILE.getObjectType(), connection);
            parentPath = parent instanceof AbstractFile ? (this.isRootDirectory(parentFile = (AbstractFile)parent, transaction) ? "/" : parentFile.getParentPath() + parent.getName() + "/") : "/";
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_FILE_SYSTEM_FILE);
            statement.clearParameters();
            statement.setLong(1, objectId);
            statement.setLong(2, fsObjId);
            statement.setLong(3, dataSourceObjId);
            statement.setShort(4, (short)attrType.getValue());
            statement.setInt(5, attrId);
            statement.setString(6, fileName);
            statement.setLong(7, metaAddr);
            statement.setInt(8, metaSeq);
            statement.setShort(9, TskData.TSK_DB_FILES_TYPE_ENUM.FS.getFileType());
            statement.setShort(10, (short)1);
            TskData.TSK_FS_NAME_TYPE_ENUM dirType = isFile ? TskData.TSK_FS_NAME_TYPE_ENUM.REG : TskData.TSK_FS_NAME_TYPE_ENUM.DIR;
            statement.setShort(11, dirType.getValue());
            TskData.TSK_FS_META_TYPE_ENUM metaType = isFile ? TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_REG : TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_DIR;
            statement.setShort(12, metaType.getValue());
            statement.setShort(13, dirFlag.getValue());
            statement.setShort(14, metaFlags);
            statement.setLong(15, size < 0L ? 0L : size);
            statement.setLong(16, ctime);
            statement.setLong(17, crtime);
            statement.setLong(18, atime);
            statement.setLong(19, mtime);
            statement.setString(20, md5Hash);
            statement.setString(21, sha256Hash);
            statement.setString(22, sha1Hash);
            statement.setString(23, mimeType);
            statement.setString(24, (String)parentPath);
            String extension = SleuthkitCase.extractExtension(fileName);
            statement.setString(25, extension);
            statement.setString(26, ownerUid);
            if (null != osAccount) {
                statement.setLong(27, osAccount.getId());
            } else {
                statement.setNull(27, -5);
            }
            statement.setLong(28, collected.getType());
            connection.executeUpdate(statement);
            Long osAccountId = osAccount != null ? Long.valueOf(osAccount.getId()) : null;
            DerivedFile derivedFile = new DerivedFile(this, objectId, dataSourceObjId, fsObjId, fileName, dirType, metaType, dirFlag, metaFlags, size, ctime, crtime, atime, mtime, md5Hash, sha256Hash, sha1Hash, null, (String)parentPath, null, parent.getId(), mimeType, null, extension, ownerUid, osAccountId);
            if (!this.timelineEventsDisabled.get()) {
                timelineManager.addEventsForNewFile(derivedFile, connection);
            }
            for (Attribute fileAttribute : fileAttributes) {
                fileAttribute.setAttributeParentId(objectId);
                fileAttribute.setCaseDatabase(this);
                this.addFileAttribute(fileAttribute, connection);
            }
            if (osAccount != null) {
                this.osAccountManager.newOsAccountInstance(osAccount.getId(), dataSourceObjId, OsAccountInstance.OsAccountInstanceType.ACCESSED, connection);
            }
            File file = new File(this, objectId, dataSourceObjId, fsObjId, attrType, attrId, fileName, metaAddr, metaSeq, dirType, metaType, dirFlag, metaFlags, size, ctime, crtime, atime, mtime, 0, 0, 0, md5Hash, sha256Hash, sha1Hash, null, (String)parentPath, mimeType, extension, ownerUid, osAccountId, collected, fileAttributes);
            return file;
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Failed to INSERT file system file %s (%s) with parent id %d in tsk_files table", fileName, parentPath, parent.getId()), ex);
        }
        finally {
            SleuthkitCase.closeStatement(queryStatement);
        }
    }

    public List<VirtualDirectory> getVirtualDirectoryRoots() throws TskCoreException {
        ArrayList<VirtualDirectory> arrayList;
        CaseDbConnection connection = null;
        Statement s = null;
        ResultSet rs = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT * FROM tsk_files WHERE type = " + TskData.TSK_DB_FILES_TYPE_ENUM.VIRTUAL_DIR.getFileType() + " AND obj_id = data_source_obj_id ORDER BY dir_type, LOWER(name)");
            ArrayList<VirtualDirectory> virtDirRootIds = new ArrayList<VirtualDirectory>();
            while (rs.next()) {
                virtDirRootIds.add(this.virtualDirectory(rs, connection));
            }
            arrayList = virtDirRootIds;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting local files virtual folder id", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public final List<LayoutFile> addLayoutFiles(Content parent, List<TskFileRange> fileRanges) throws TskCoreException {
        assert (null != fileRanges);
        if (null == fileRanges) {
            throw new TskCoreException("TskFileRange object is null");
        }
        assert (null != parent);
        if (null == parent) {
            throw new TskCoreException("Conent is null");
        }
        Object parentPath = parent instanceof AbstractFile ? ((AbstractFile)parent).getParentPath() + parent.getName() + "/" : "/";
        CaseDbTransaction transaction = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            Long fileSystemObjectId;
            transaction = this.beginTransaction();
            CaseDbConnection connection = transaction.getConnection();
            if (0L != parent.getId()) {
                fileSystemObjectId = this.getFileSystemId(parent.getId(), connection);
                if (fileSystemObjectId == -1L) {
                    fileSystemObjectId = null;
                }
            } else {
                fileSystemObjectId = null;
            }
            ArrayList<LayoutFile> fileRangeLayoutFiles = new ArrayList<LayoutFile>();
            for (TskFileRange fileRange : fileRanges) {
                long fileRangeId = this.addObject(parent.getId(), TskData.ObjectType.ABSTRACTFILE.getObjectType(), connection);
                long end_byte_in_parent = fileRange.getByteStart() + fileRange.getByteLen() - 1L;
                PreparedStatement prepStmt = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_FILE);
                prepStmt.clearParameters();
                prepStmt.setLong(1, fileRangeId);
                if (fileSystemObjectId != null) {
                    prepStmt.setLong(2, fileSystemObjectId);
                } else {
                    prepStmt.setNull(2, -5);
                }
                prepStmt.setString(3, "Unalloc_" + parent.getId() + "_" + fileRange.getByteStart() + "_" + end_byte_in_parent);
                prepStmt.setShort(4, TskData.TSK_DB_FILES_TYPE_ENUM.UNALLOC_BLOCKS.getFileType());
                prepStmt.setNull(5, -5);
                prepStmt.setShort(6, TskData.TSK_FS_NAME_TYPE_ENUM.REG.getValue());
                prepStmt.setShort(7, TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_REG.getValue());
                prepStmt.setShort(8, TskData.TSK_FS_NAME_FLAG_ENUM.UNALLOC.getValue());
                prepStmt.setShort(9, TskData.TSK_FS_META_FLAG_ENUM.UNALLOC.getValue());
                prepStmt.setLong(10, fileRange.getByteLen());
                prepStmt.setNull(11, -5);
                prepStmt.setNull(12, -5);
                prepStmt.setNull(13, -5);
                prepStmt.setNull(14, -5);
                prepStmt.setNull(15, 12);
                prepStmt.setNull(16, 12);
                prepStmt.setNull(17, 12);
                prepStmt.setByte(18, TskData.FileKnown.UNKNOWN.getFileKnownValue());
                prepStmt.setNull(19, 12);
                prepStmt.setString(20, (String)parentPath);
                prepStmt.setLong(21, parent.getId());
                prepStmt.setString(22, null);
                prepStmt.setString(23, OsAccount.NO_OWNER_ID);
                prepStmt.setNull(24, -5);
                prepStmt.setLong(25, TskData.CollectedStatus.UNKNOWN.getType());
                connection.executeUpdate(prepStmt);
                prepStmt = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_LAYOUT_FILE);
                prepStmt.clearParameters();
                prepStmt.setLong(1, fileRangeId);
                prepStmt.setLong(2, fileRange.getByteStart());
                prepStmt.setLong(3, fileRange.getByteLen());
                prepStmt.setLong(4, fileRange.getSequence());
                connection.executeUpdate(prepStmt);
                fileRangeLayoutFiles.add(new LayoutFile(this, fileRangeId, parent.getId(), fileSystemObjectId, Long.toString(fileRange.getSequence()), TskData.TSK_DB_FILES_TYPE_ENUM.UNALLOC_BLOCKS, TskData.TSK_FS_NAME_TYPE_ENUM.REG, TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_REG, TskData.TSK_FS_NAME_FLAG_ENUM.UNALLOC, TskData.TSK_FS_META_FLAG_ENUM.UNALLOC.getValue(), fileRange.getByteLen(), 0L, 0L, 0L, 0L, null, null, null, TskData.FileKnown.UNKNOWN, parent.getUniquePath(), null, OsAccount.NO_OWNER_ID, OsAccount.NO_ACCOUNT));
            }
            transaction.commit();
            transaction = null;
            ArrayList<LayoutFile> arrayList = fileRangeLayoutFiles;
            return arrayList;
        }
        catch (SQLException ex) {
            throw new TskCoreException("Failed to add layout files to case database", ex);
        }
        finally {
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeStatement(statement);
            if (null != transaction) {
                try {
                    transaction.rollback();
                }
                catch (TskCoreException ex2) {
                    logger.log(Level.SEVERE, "Failed to rollback transaction after exception", ex2);
                }
            }
        }
    }

    private CarvedFileDirInfo getMostRecentCarvedDirInfo(VirtualDirectory carvedFilesBaseDir) throws TskCoreException {
        AbstractContent mostRecentDir = null;
        for (Content child : carvedFilesBaseDir.getChildren()) {
            if (!this.isValidCarvedFileSubfolder(child) || mostRecentDir != null && mostRecentDir.getId() >= child.getId()) continue;
            mostRecentDir = (VirtualDirectory)child;
        }
        if (mostRecentDir != null) {
            return new CarvedFileDirInfo(this, (VirtualDirectory)mostRecentDir, mostRecentDir.getChildrenCount());
        }
        return null;
    }

    private boolean isValidCarvedFileSubfolder(Content subfolder) {
        if (!(subfolder instanceof VirtualDirectory)) {
            return false;
        }
        return subfolder.getName().matches("^[0-9]+$");
    }

    private CarvedFileDirInfo createCarvedFilesSubfolder(Content carvedFilesBaseDir, CarvedFileDirInfo currentSubfolderInfo) throws TskCoreException {
        int nextIndex = 1;
        if (currentSubfolderInfo != null) {
            try {
                int currentIndex = Integer.parseInt(currentSubfolderInfo.currentFolder.getName());
                nextIndex = currentIndex + 1;
            }
            catch (NumberFormatException ex) {
                throw new TskCoreException("Unexpected name format for carved files subdirectory with ID: " + currentSubfolderInfo.currentFolder.getId() + " (" + currentSubfolderInfo.currentFolder.getName() + ")", ex);
            }
        }
        VirtualDirectory carvedFilesSubdir = this.addVirtualDirectory(carvedFilesBaseDir.getId(), Integer.toString(nextIndex));
        return new CarvedFileDirInfo(this, carvedFilesSubdir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<LayoutFile> addCarvedFiles(CarvingResult carvingResult) throws TskCoreException {
        assert (null != carvingResult);
        if (null == carvingResult) {
            throw new TskCoreException("Carving is null");
        }
        assert (null != carvingResult.getParent());
        if (null == carvingResult.getParent()) {
            throw new TskCoreException("Carving result has null parent");
        }
        assert (null != carvingResult.getCarvedFiles());
        if (null == carvingResult.getCarvedFiles()) {
            throw new TskCoreException("Carving result has null carved files");
        }
        CaseDbTransaction transaction = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            Content root;
            for (root = carvingResult.getParent(); !(null == root || root instanceof FileSystem || root instanceof Volume || root instanceof Image); root = root.getParent()) {
            }
            if (null == root) {
                root = carvingResult.getParent();
            }
            CarvedFileDirInfo carvedFilesDirInfo = null;
            Object object = this.carvedFileDirsLock;
            synchronized (object) {
                carvedFilesDirInfo = this.rootIdsToCarvedFileDirs.get(root.getId());
                if (carvedFilesDirInfo != null) {
                    carvedFilesDirInfo.incrementFileCounter();
                    if (carvedFilesDirInfo.isFull()) {
                        carvedFilesDirInfo = this.createCarvedFilesSubfolder(carvedFilesDirInfo.currentFolder.getParent(), carvedFilesDirInfo);
                    }
                }
                if (null == carvedFilesDirInfo) {
                    List<Content> rootChildren = root instanceof FileSystem ? ((FileSystem)root).getRootDirectory().getChildren() : root.getChildren();
                    for (Content child : rootChildren) {
                        if (!(child instanceof VirtualDirectory) || !child.getName().equals("$CarvedFiles")) continue;
                        VirtualDirectory baseDir = (VirtualDirectory)child;
                        carvedFilesDirInfo = this.getMostRecentCarvedDirInfo(baseDir);
                        if (carvedFilesDirInfo == null) {
                            carvedFilesDirInfo = this.createCarvedFilesSubfolder(baseDir, null);
                        }
                        if (carvedFilesDirInfo.isFull()) {
                            carvedFilesDirInfo = this.createCarvedFilesSubfolder(baseDir, carvedFilesDirInfo);
                        }
                        this.rootIdsToCarvedFileDirs.put(root.getId(), carvedFilesDirInfo);
                        break;
                    }
                    if (carvedFilesDirInfo == null) {
                        long parId = root.getId();
                        if (root instanceof FileSystem) {
                            Directory rootDir = ((FileSystem)root).getRootDirectory();
                            parId = rootDir.getId();
                        }
                        VirtualDirectory carvedFilesBaseDir = this.addVirtualDirectory(parId, "$CarvedFiles");
                        carvedFilesDirInfo = this.createCarvedFilesSubfolder(carvedFilesBaseDir, null);
                        this.rootIdsToCarvedFileDirs.put(root.getId(), carvedFilesDirInfo);
                    }
                }
            }
            VirtualDirectory carvedFilesBaseDir = (VirtualDirectory)carvedFilesDirInfo.currentFolder.getParent();
            transaction = this.beginTransaction();
            CaseDbConnection connection = transaction.getConnection();
            String parentPath = this.getFileParentPath(carvedFilesDirInfo.currentFolder.getId(), connection) + carvedFilesDirInfo.currentFolder.getName() + "/";
            ArrayList<LayoutFile> carvedFiles = new ArrayList<LayoutFile>();
            for (CarvingResult.CarvedFile carvedFile : carvingResult.getCarvedFiles()) {
                Long fileSystemObjectId;
                VirtualDirectory carvedFilesDir = carvedFilesDirInfo.currentFolder;
                if (carvedFilesDirInfo.isFull()) {
                    transaction.commit();
                    Object object2 = this.carvedFileDirsLock;
                    synchronized (object2) {
                        carvedFilesDirInfo = this.rootIdsToCarvedFileDirs.get(root.getId());
                        if (carvedFilesDirInfo.isFull()) {
                            carvedFilesDirInfo = this.createCarvedFilesSubfolder(carvedFilesBaseDir, carvedFilesDirInfo);
                            this.rootIdsToCarvedFileDirs.put(root.getId(), carvedFilesDirInfo);
                            carvedFilesDir = carvedFilesDirInfo.currentFolder;
                        }
                    }
                    transaction = this.beginTransaction();
                    connection = transaction.getConnection();
                    parentPath = this.getFileParentPath(carvedFilesDir.getId(), connection) + carvedFilesDir.getName() + "/";
                }
                carvedFilesDirInfo.incrementFileCounter();
                long carvedFileId = this.addObject(carvedFilesDir.getId(), TskData.ObjectType.ABSTRACTFILE.getObjectType(), connection);
                PreparedStatement prepStmt = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_FILE);
                prepStmt.clearParameters();
                prepStmt.setLong(1, carvedFileId);
                if (root instanceof FileSystem) {
                    prepStmt.setLong(2, root.getId());
                    fileSystemObjectId = root.getId();
                } else {
                    prepStmt.setNull(2, -5);
                    fileSystemObjectId = null;
                }
                prepStmt.setString(3, carvedFile.getName());
                prepStmt.setShort(4, TskData.TSK_DB_FILES_TYPE_ENUM.CARVED.getFileType());
                prepStmt.setShort(5, (short)1);
                prepStmt.setShort(6, TskData.TSK_FS_NAME_TYPE_ENUM.REG.getValue());
                prepStmt.setShort(7, TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_REG.getValue());
                prepStmt.setShort(8, TskData.TSK_FS_NAME_FLAG_ENUM.UNALLOC.getValue());
                prepStmt.setShort(9, TskData.TSK_FS_META_FLAG_ENUM.UNALLOC.getValue());
                prepStmt.setLong(10, carvedFile.getSizeInBytes());
                prepStmt.setNull(11, -5);
                prepStmt.setNull(12, -5);
                prepStmt.setNull(13, -5);
                prepStmt.setNull(14, -5);
                prepStmt.setNull(15, 12);
                prepStmt.setNull(16, 12);
                prepStmt.setNull(17, 12);
                prepStmt.setByte(18, TskData.FileKnown.UNKNOWN.getFileKnownValue());
                prepStmt.setNull(19, 12);
                prepStmt.setString(20, parentPath);
                prepStmt.setLong(21, carvedFilesDir.getDataSourceObjectId());
                prepStmt.setString(22, SleuthkitCase.extractExtension(carvedFile.getName()));
                prepStmt.setString(23, OsAccount.NO_OWNER_ID);
                prepStmt.setNull(24, -5);
                prepStmt.setLong(25, TskData.CollectedStatus.UNKNOWN.getType());
                connection.executeUpdate(prepStmt);
                prepStmt = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_LAYOUT_FILE);
                for (TskFileRange tskFileRange : carvedFile.getLayoutInParent()) {
                    prepStmt.clearParameters();
                    prepStmt.setLong(1, carvedFileId);
                    prepStmt.setLong(2, tskFileRange.getByteStart());
                    prepStmt.setLong(3, tskFileRange.getByteLen());
                    prepStmt.setLong(4, tskFileRange.getSequence());
                    connection.executeUpdate(prepStmt);
                }
                carvedFiles.add(new LayoutFile(this, carvedFileId, carvedFilesDir.getDataSourceObjectId(), fileSystemObjectId, carvedFile.getName(), TskData.TSK_DB_FILES_TYPE_ENUM.CARVED, TskData.TSK_FS_NAME_TYPE_ENUM.REG, TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_REG, TskData.TSK_FS_NAME_FLAG_ENUM.UNALLOC, TskData.TSK_FS_META_FLAG_ENUM.UNALLOC.getValue(), carvedFile.getSizeInBytes(), 0L, 0L, 0L, 0L, null, null, null, TskData.FileKnown.UNKNOWN, parentPath, null, OsAccount.NO_OWNER_ID, OsAccount.NO_ACCOUNT));
            }
            transaction.commit();
            transaction = null;
            ArrayList<LayoutFile> arrayList = carvedFiles;
            return arrayList;
        }
        catch (SQLException ex) {
            throw new TskCoreException("Failed to add carved files to case database", ex);
        }
        finally {
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeStatement(statement);
            if (null != transaction) {
                try {
                    transaction.rollback();
                }
                catch (TskCoreException ex2) {
                    logger.log(Level.SEVERE, "Failed to rollback transaction after exception", ex2);
                }
            }
        }
    }

    public DerivedFile addDerivedFile(String fileName, String localPath, long size, long ctime, long crtime, long atime, long mtime, boolean isFile, Content parentObj, String rederiveDetails, String toolName, String toolVersion, String otherDetails, TskData.EncodingType encodingType) throws TskCoreException {
        CaseDbTransaction transaction = this.beginTransaction();
        try {
            DerivedFile df = this.addDerivedFile(fileName, localPath, size, ctime, crtime, atime, mtime, isFile, parentObj, rederiveDetails, toolName, toolVersion, otherDetails, encodingType, transaction);
            transaction.commit();
            return df;
        }
        catch (TskCoreException ex) {
            transaction.rollback();
            throw ex;
        }
    }

    public DerivedFile addDerivedFile(String fileName, String localPath, long size, long ctime, long crtime, long atime, long mtime, boolean isFile, Content parentObj, String rederiveDetails, String toolName, String toolVersion, String otherDetails, TskData.EncodingType encodingType, CaseDbTransaction transaction) throws TskCoreException {
        localPath = localPath.replaceAll("^[/\\\\]+", "");
        TimelineManager timelineManager = this.getTimelineManager();
        CaseDbConnection connection = transaction.getConnection();
        try {
            long parentId = parentObj.getId();
            Object parentPath = "";
            if (parentObj instanceof BlackboardArtifact) {
                parentPath = parentObj.getUniquePath() + "/" + parentObj.getName() + "/";
            } else if (parentObj instanceof AbstractFile) {
                parentPath = ((AbstractFile)parentObj).getParentPath() + parentObj.getName() + "/";
            }
            long newObjId = this.addObject(parentId, TskData.ObjectType.ABSTRACTFILE.getObjectType(), connection);
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_FILE);
            statement.clearParameters();
            statement.setLong(1, newObjId);
            Long fsObjId = this.getFileSystemId(parentId, connection);
            if (fsObjId != -1L) {
                statement.setLong(2, fsObjId);
            } else {
                fsObjId = null;
                statement.setNull(2, -5);
            }
            statement.setString(3, fileName);
            statement.setShort(4, TskData.TSK_DB_FILES_TYPE_ENUM.DERIVED.getFileType());
            statement.setShort(5, (short)1);
            TskData.TSK_FS_NAME_TYPE_ENUM dirType = isFile ? TskData.TSK_FS_NAME_TYPE_ENUM.REG : TskData.TSK_FS_NAME_TYPE_ENUM.DIR;
            statement.setShort(6, dirType.getValue());
            TskData.TSK_FS_META_TYPE_ENUM metaType = isFile ? TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_REG : TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_DIR;
            statement.setShort(7, metaType.getValue());
            TskData.TSK_FS_NAME_FLAG_ENUM dirFlag = TskData.TSK_FS_NAME_FLAG_ENUM.ALLOC;
            statement.setShort(8, dirFlag.getValue());
            short metaFlags = (short)(TskData.TSK_FS_META_FLAG_ENUM.ALLOC.getValue() | TskData.TSK_FS_META_FLAG_ENUM.USED.getValue());
            statement.setShort(9, metaFlags);
            long savedSize = size < 0L ? 0L : size;
            statement.setLong(10, savedSize);
            statement.setLong(11, ctime);
            statement.setLong(12, crtime);
            statement.setLong(13, atime);
            statement.setLong(14, mtime);
            statement.setNull(15, 12);
            statement.setNull(16, 12);
            statement.setNull(17, 12);
            statement.setByte(18, TskData.FileKnown.UNKNOWN.getFileKnownValue());
            statement.setNull(19, 12);
            statement.setString(20, (String)parentPath);
            long dataSourceObjId = this.getDataSourceObjectId(connection, parentObj);
            statement.setLong(21, dataSourceObjId);
            String extension = SleuthkitCase.extractExtension(fileName);
            statement.setString(22, extension);
            statement.setString(23, OsAccount.NO_OWNER_ID);
            statement.setNull(24, -5);
            statement.setLong(25, TskData.CollectedStatus.UNKNOWN.getType());
            connection.executeUpdate(statement);
            this.addFilePath(connection, newObjId, localPath, encodingType);
            DerivedFile derivedFile = new DerivedFile(this, newObjId, dataSourceObjId, fsObjId, fileName, dirType, metaType, dirFlag, metaFlags, savedSize, ctime, crtime, atime, mtime, null, null, null, null, (String)parentPath, localPath, parentId, null, encodingType, extension, OsAccount.NO_OWNER_ID, OsAccount.NO_ACCOUNT);
            if (!this.timelineEventsDisabled.get()) {
                timelineManager.addEventsForNewFile(derivedFile, connection);
            }
            return derivedFile;
        }
        catch (SQLException ex) {
            throw new TskCoreException("Failed to add derived file to case database", ex);
        }
    }

    public DerivedFile updateDerivedFile(DerivedFile derivedFile, String localPath, long size, long ctime, long crtime, long atime, long mtime, boolean isFile, String mimeType, String rederiveDetails, String toolName, String toolVersion, String otherDetails, TskData.EncodingType encodingType) throws TskCoreException {
        CaseDbTransaction trans = null;
        try {
            Content parentObj = derivedFile.getParent();
            trans = this.beginTransaction();
            DerivedFile updatedFile = this.updateDerivedFile(derivedFile, localPath, size, ctime, crtime, atime, mtime, isFile, mimeType, rederiveDetails, toolName, toolVersion, otherDetails, encodingType, parentObj, trans);
            trans.commit();
            return updatedFile;
        }
        catch (TskCoreException ex) {
            if (trans != null) {
                trans.rollback();
            }
            throw ex;
        }
    }

    public DerivedFile updateDerivedFile(DerivedFile derivedFile, String localPath, long size, long ctime, long crtime, long atime, long mtime, boolean isFile, String mimeType, String rederiveDetails, String toolName, String toolVersion, String otherDetails, TskData.EncodingType encodingType, Content parentObj, CaseDbTransaction trans) throws TskCoreException {
        localPath = localPath.replaceAll("^[/\\\\]+", "");
        ResultSet rs = null;
        try {
            long parentId = parentObj.getId();
            Object parentPath = "";
            if (parentObj instanceof BlackboardArtifact) {
                parentPath = parentObj.getUniquePath() + "/" + parentObj.getName() + "/";
            } else if (parentObj instanceof AbstractFile) {
                parentPath = ((AbstractFile)parentObj).getParentPath() + parentObj.getName() + "/";
            }
            PreparedStatement statement = trans.getConnection().getPreparedStatement(PREPARED_STATEMENT.UPDATE_DERIVED_FILE);
            statement.clearParameters();
            statement.setShort(1, TskData.TSK_DB_FILES_TYPE_ENUM.DERIVED.getFileType());
            TskData.TSK_FS_NAME_TYPE_ENUM dirType = isFile ? TskData.TSK_FS_NAME_TYPE_ENUM.REG : TskData.TSK_FS_NAME_TYPE_ENUM.DIR;
            statement.setShort(2, dirType.getValue());
            TskData.TSK_FS_META_TYPE_ENUM metaType = isFile ? TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_REG : TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_DIR;
            statement.setShort(3, metaType.getValue());
            TskData.TSK_FS_NAME_FLAG_ENUM dirFlag = TskData.TSK_FS_NAME_FLAG_ENUM.ALLOC;
            statement.setShort(4, dirFlag.getValue());
            short metaFlags = (short)(TskData.TSK_FS_META_FLAG_ENUM.ALLOC.getValue() | TskData.TSK_FS_META_FLAG_ENUM.USED.getValue());
            statement.setShort(5, metaFlags);
            long savedSize = size < 0L ? 0L : size;
            statement.setLong(6, savedSize);
            statement.setLong(7, ctime);
            statement.setLong(8, crtime);
            statement.setLong(9, atime);
            statement.setLong(10, mtime);
            statement.setString(11, mimeType);
            statement.setString(12, String.valueOf(derivedFile.getId()));
            trans.getConnection().executeUpdate(statement);
            this.updateFilePath(trans.getConnection(), derivedFile.getId(), localPath, encodingType);
            long dataSourceObjId = this.getDataSourceObjectId(trans.getConnection(), parentObj);
            Long fileSystemObjId = derivedFile.getFileSystemObjectId().orElse(null);
            String extension = SleuthkitCase.extractExtension(derivedFile.getName());
            DerivedFile derivedFile2 = new DerivedFile(this, derivedFile.getId(), dataSourceObjId, fileSystemObjId, derivedFile.getName(), dirType, metaType, dirFlag, metaFlags, savedSize, ctime, crtime, atime, mtime, null, null, null, null, (String)parentPath, localPath, parentId, null, encodingType, extension, derivedFile.getOwnerUid().orElse(null), derivedFile.getOsAccountObjectId().orElse(null));
            return derivedFile2;
        }
        catch (SQLException ex) {
            throw new TskCoreException("Failed to add derived file to case database", ex);
        }
        finally {
            SleuthkitCase.closeResultSet(rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalFile addLocalFile(String fileName, String localPath, long size, long ctime, long crtime, long atime, long mtime, boolean isFile, TskData.EncodingType encodingType, AbstractFile parent) throws TskCoreException {
        CaseDbTransaction localTrans = this.beginTransaction();
        try {
            LocalFile created = this.addLocalFile(fileName, localPath, size, ctime, crtime, atime, mtime, isFile, encodingType, parent, localTrans);
            localTrans.commit();
            localTrans = null;
            LocalFile localFile = created;
            return localFile;
        }
        finally {
            if (null != localTrans) {
                try {
                    localTrans.rollback();
                }
                catch (TskCoreException ex2) {
                    logger.log(Level.SEVERE, "Failed to rollback transaction after exception", ex2);
                }
            }
        }
    }

    public LocalFile addLocalFile(String fileName, String localPath, long size, long ctime, long crtime, long atime, long mtime, boolean isFile, TskData.EncodingType encodingType, Content parent, CaseDbTransaction transaction) throws TskCoreException {
        return this.addLocalFile(fileName, localPath, size, ctime, crtime, atime, mtime, null, null, null, isFile, encodingType, parent, transaction);
    }

    public LocalFile addLocalFile(String fileName, String localPath, long size, long ctime, long crtime, long atime, long mtime, String md5, String sha256, TskData.FileKnown known, String mimeType, boolean isFile, TskData.EncodingType encodingType, Content parent, CaseDbTransaction transaction) throws TskCoreException {
        return this.addLocalFile(fileName, localPath, size, ctime, crtime, atime, mtime, md5, sha256, known, mimeType, isFile, encodingType, OsAccount.NO_ACCOUNT, OsAccount.NO_OWNER_ID, parent, transaction);
    }

    public LocalFile addLocalFile(String fileName, String localPath, long size, long ctime, long crtime, long atime, long mtime, String md5, String sha256, TskData.FileKnown known, String mimeType, boolean isFile, TskData.EncodingType encodingType, Long osAccountId, String ownerAccount, Content parent, CaseDbTransaction transaction) throws TskCoreException {
        return this.addLocalFile(fileName, localPath, size, ctime, crtime, atime, mtime, md5, sha256, null, known, mimeType, isFile, encodingType, osAccountId, ownerAccount, parent, transaction);
    }

    public LocalFile addLocalFile(String fileName, String localPath, long size, long ctime, long crtime, long atime, long mtime, String md5, String sha256, String sha1Hash, TskData.FileKnown known, String mimeType, boolean isFile, TskData.EncodingType encodingType, Long osAccountId, String ownerAccount, Content parent, CaseDbTransaction transaction) throws TskCoreException {
        CaseDbConnection connection = transaction.getConnection();
        Statement queryStatement = null;
        try {
            long dataSourceObjId;
            Object parentPath;
            long objectId = this.addObject(parent.getId(), TskData.ObjectType.ABSTRACTFILE.getObjectType(), connection);
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_FILE);
            statement.clearParameters();
            statement.setLong(1, objectId);
            statement.setNull(2, -5);
            statement.setString(3, fileName);
            statement.setShort(4, TskData.TSK_DB_FILES_TYPE_ENUM.LOCAL.getFileType());
            statement.setShort(5, (short)1);
            TskData.TSK_FS_NAME_TYPE_ENUM dirType = isFile ? TskData.TSK_FS_NAME_TYPE_ENUM.REG : TskData.TSK_FS_NAME_TYPE_ENUM.DIR;
            statement.setShort(6, dirType.getValue());
            TskData.TSK_FS_META_TYPE_ENUM metaType = isFile ? TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_REG : TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_DIR;
            statement.setShort(7, metaType.getValue());
            TskData.TSK_FS_NAME_FLAG_ENUM dirFlag = TskData.TSK_FS_NAME_FLAG_ENUM.ALLOC;
            statement.setShort(8, dirFlag.getValue());
            short metaFlags = (short)(TskData.TSK_FS_META_FLAG_ENUM.ALLOC.getValue() | TskData.TSK_FS_META_FLAG_ENUM.USED.getValue());
            statement.setShort(9, metaFlags);
            long savedSize = size < 0L ? 0L : size;
            statement.setLong(10, savedSize);
            statement.setLong(11, ctime);
            statement.setLong(12, crtime);
            statement.setLong(13, atime);
            statement.setLong(14, mtime);
            statement.setString(15, md5);
            statement.setString(16, sha256);
            statement.setString(17, sha1Hash);
            if (known != null) {
                statement.setByte(18, known.getFileKnownValue());
            } else {
                statement.setByte(18, TskData.FileKnown.UNKNOWN.getFileKnownValue());
            }
            statement.setString(19, mimeType);
            if (parent instanceof AbstractFile) {
                AbstractFile parentFile = (AbstractFile)parent;
                parentPath = this.isRootDirectory(parentFile, transaction) ? "/" : parentFile.getParentPath() + parent.getName() + "/";
                dataSourceObjId = parentFile.getDataSourceObjectId();
            } else {
                parentPath = "/";
                dataSourceObjId = this.getDataSourceObjectId(connection, parent);
            }
            statement.setString(20, (String)parentPath);
            statement.setLong(21, dataSourceObjId);
            String extension = SleuthkitCase.extractExtension(fileName);
            statement.setString(22, extension);
            if (ownerAccount != null) {
                statement.setString(23, ownerAccount);
            } else {
                statement.setNull(23, 12);
            }
            if (osAccountId != null) {
                statement.setLong(24, osAccountId);
            } else {
                statement.setNull(24, -5);
            }
            statement.setLong(25, TskData.CollectedStatus.UNKNOWN.getType());
            connection.executeUpdate(statement);
            this.addFilePath(connection, objectId, localPath, encodingType);
            LocalFile localFile = new LocalFile(this, objectId, fileName, TskData.TSK_DB_FILES_TYPE_ENUM.LOCAL, dirType, metaType, dirFlag, metaFlags, savedSize, ctime, crtime, atime, mtime, mimeType, md5, sha256, sha1Hash, known, parent.getId(), (String)parentPath, dataSourceObjId, localPath, encodingType, extension, ownerAccount, osAccountId);
            if (!this.timelineEventsDisabled.get()) {
                this.getTimelineManager().addEventsForNewFile(localFile, connection);
            }
            LocalFile localFile2 = localFile;
            return localFile2;
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Failed to INSERT local file %s (%s) with parent id %d in tsk_files table", fileName, localPath, parent.getId()), ex);
        }
        finally {
            SleuthkitCase.closeStatement(queryStatement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRootDirectory(AbstractFile file, CaseDbTransaction transaction) throws TskCoreException {
        boolean bl;
        ResultSet resultSet;
        Statement statement;
        RootDirectoryKey key;
        block19: {
            boolean result;
            block20: {
                Long fsObjId = null;
                if (file instanceof FsContent) {
                    fsObjId = ((FsContent)file).getFileSystemId();
                }
                key = new RootDirectoryKey(this, file.getDataSourceObjectId(), fsObjId);
                Object object = this.rootDirectoryMapLock;
                synchronized (object) {
                    if (this.rootDirectoryMap.containsKey(key)) {
                        return this.rootDirectoryMap.get(key).equals(file.getId());
                    }
                }
                Boolean isRoot = (Boolean)this.isRootDirectoryCache.getIfPresent((Object)file.getId());
                if (isRoot != null) {
                    return isRoot;
                }
                CaseDbConnection connection = transaction.getConnection();
                statement = null;
                resultSet = null;
                String query = String.format("SELECT ParentRow.type AS parent_type, ParentRow.obj_id AS parent_object_id FROM tsk_objects ParentRow JOIN tsk_objects ChildRow ON ChildRow.par_obj_id = ParentRow.obj_id WHERE ChildRow.obj_id = %s;", file.getId());
                statement = connection.createStatement();
                resultSet = statement.executeQuery(query);
                if (!resultSet.next()) break block19;
                long parentId = resultSet.getLong("parent_object_id");
                if (parentId != 0L) break block20;
                boolean bl2 = true;
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeStatement(statement);
                return bl2;
            }
            int type = resultSet.getInt("parent_type");
            boolean bl3 = result = type == TskData.ObjectType.IMG.getObjectType() || type == TskData.ObjectType.VS.getObjectType() || type == TskData.ObjectType.VOL.getObjectType() || type == TskData.ObjectType.FS.getObjectType();
            if (result) {
                Object object = this.rootDirectoryMapLock;
                synchronized (object) {
                    this.rootDirectoryMap.put(key, file.getId());
                }
            }
            this.isRootDirectoryCache.put((Object)file.getId(), (Object)result);
            boolean bl4 = result;
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeStatement(statement);
            return bl4;
        }
        try {
            Object object = this.rootDirectoryMapLock;
            synchronized (object) {
                this.rootDirectoryMap.put(key, file.getId());
            }
            this.isRootDirectoryCache.put((Object)file.getId(), (Object)true);
            bl = true;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException(String.format("Failed to lookup parent of file (%s) with id %d", file.getName(), file.getId()), ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeStatement(statement);
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeStatement(statement);
        return bl;
    }

    public LayoutFile addLayoutFile(String fileName, long size, TskData.TSK_FS_NAME_FLAG_ENUM dirFlag, TskData.TSK_FS_META_FLAG_ENUM metaFlag, long ctime, long crtime, long atime, long mtime, List<TskFileRange> fileRanges, Content parent) throws TskCoreException {
        if (null == parent) {
            throw new TskCoreException("Parent can not be null");
        }
        Object parentPath = parent instanceof AbstractFile ? ((AbstractFile)parent).getParentPath() + parent.getName() + "/" : "/";
        CaseDbTransaction transaction = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            Long fileSystemObjectId;
            transaction = this.beginTransaction();
            CaseDbConnection connection = transaction.getConnection();
            long newFileId = this.addObject(parent.getId(), TskData.ObjectType.ABSTRACTFILE.getObjectType(), connection);
            PreparedStatement prepStmt = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_FILE);
            prepStmt.clearParameters();
            prepStmt.setLong(1, newFileId);
            if (0L != parent.getId()) {
                fileSystemObjectId = this.getFileSystemId(parent.getId(), connection);
                if (fileSystemObjectId != -1L) {
                    prepStmt.setLong(2, fileSystemObjectId);
                } else {
                    prepStmt.setNull(2, -5);
                    fileSystemObjectId = null;
                }
            } else {
                prepStmt.setNull(2, -5);
                fileSystemObjectId = null;
            }
            prepStmt.setString(3, fileName);
            prepStmt.setShort(4, TskData.TSK_DB_FILES_TYPE_ENUM.LAYOUT_FILE.getFileType());
            prepStmt.setShort(5, (short)0);
            prepStmt.setShort(6, TskData.TSK_FS_NAME_TYPE_ENUM.REG.getValue());
            prepStmt.setShort(7, TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_REG.getValue());
            prepStmt.setShort(8, dirFlag.getValue());
            prepStmt.setShort(9, metaFlag.getValue());
            long savedSize = size < 0L ? 0L : size;
            prepStmt.setLong(10, savedSize);
            prepStmt.setLong(11, ctime);
            prepStmt.setLong(12, crtime);
            prepStmt.setLong(13, atime);
            prepStmt.setLong(14, mtime);
            prepStmt.setNull(15, 12);
            prepStmt.setNull(16, 12);
            prepStmt.setNull(17, 12);
            prepStmt.setByte(18, TskData.FileKnown.UNKNOWN.getFileKnownValue());
            prepStmt.setNull(19, 12);
            prepStmt.setString(20, (String)parentPath);
            prepStmt.setLong(21, parent.getDataSource().getId());
            prepStmt.setString(22, SleuthkitCase.extractExtension(fileName));
            prepStmt.setString(23, OsAccount.NO_OWNER_ID);
            prepStmt.setNull(24, -5);
            prepStmt.setLong(25, TskData.CollectedStatus.UNKNOWN.getType());
            connection.executeUpdate(prepStmt);
            prepStmt = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_LAYOUT_FILE);
            for (TskFileRange tskFileRange : fileRanges) {
                prepStmt.clearParameters();
                prepStmt.setLong(1, newFileId);
                prepStmt.setLong(2, tskFileRange.getByteStart());
                prepStmt.setLong(3, tskFileRange.getByteLen());
                prepStmt.setLong(4, tskFileRange.getSequence());
                connection.executeUpdate(prepStmt);
            }
            LayoutFile layoutFile = new LayoutFile(this, newFileId, parent.getDataSource().getId(), fileSystemObjectId, fileName, TskData.TSK_DB_FILES_TYPE_ENUM.LAYOUT_FILE, TskData.TSK_FS_NAME_TYPE_ENUM.REG, TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_REG, dirFlag, metaFlag.getValue(), savedSize, ctime, crtime, atime, mtime, null, null, null, TskData.FileKnown.UNKNOWN, (String)parentPath, null, OsAccount.NO_OWNER_ID, OsAccount.NO_ACCOUNT);
            transaction.commit();
            transaction = null;
            LayoutFile layoutFile2 = layoutFile;
            return layoutFile2;
        }
        catch (SQLException ex) {
            throw new TskCoreException("Failed to add layout file " + fileName + " to case database", ex);
        }
        finally {
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeStatement(statement);
            if (null != transaction) {
                try {
                    transaction.rollback();
                }
                catch (TskCoreException ex2) {
                    logger.log(Level.SEVERE, "Failed to rollback transaction after exception", ex2);
                }
            }
        }
    }

    private long getDataSourceObjectId(CaseDbConnection connection, Content content) throws TskCoreException {
        if (content == null) {
            throw new TskCoreException("Null Content parameter given");
        }
        if (content instanceof AbstractFile) {
            return ((AbstractFile)content).getDataSourceObjectId();
        }
        return this.getDataSourceObjectId(connection, content.getId());
    }

    private long getDataSourceObjectId(CaseDbConnection connection, long objectId) throws TskCoreException {
        long l;
        this.acquireSingleUserCaseReadLock();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            long dataSourceObjId;
            statement = connection.createStatement();
            long ancestorId = objectId;
            do {
                dataSourceObjId = ancestorId;
                String query = String.format("SELECT par_obj_id FROM tsk_objects WHERE obj_id = %s;", ancestorId);
                resultSet = statement.executeQuery(query);
                if (!resultSet.next()) {
                    throw new TskCoreException(String.format("tsk_objects table is corrupt, SQL query returned no result: %s", query));
                }
                ancestorId = resultSet.getLong("par_obj_id");
                resultSet.close();
                resultSet = null;
            } while (0L != ancestorId);
            l = dataSourceObjId;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException(String.format("Error finding root data source for object (obj_id = %d)", objectId), ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeStatement(statement);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeStatement(statement);
        this.releaseSingleUserCaseReadLock();
        return l;
    }

    private void addFilePath(CaseDbConnection connection, long objId, String path, TskData.EncodingType type) throws SQLException {
        PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_LOCAL_PATH);
        statement.clearParameters();
        statement.setLong(1, objId);
        statement.setString(2, path);
        statement.setInt(3, type.getType());
        connection.executeUpdate(statement);
    }

    private void updateFilePath(CaseDbConnection connection, long objId, String path, TskData.EncodingType type) throws SQLException {
        PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.UPDATE_LOCAL_PATH);
        statement.clearParameters();
        statement.setString(1, path);
        statement.setInt(2, type.getType());
        statement.setLong(3, objId);
        connection.executeUpdate(statement);
    }

    public List<AbstractFile> findFilesInFolder(String fileName, AbstractFile parentFile) throws TskCoreException {
        List<AbstractFile> list;
        String ext = "";
        if (!SleuthkitCase.containsLikeWildcard(fileName)) {
            ext = SleuthkitCase.extractExtension(fileName);
        }
        CaseDbConnection connection = null;
        ResultSet rs = null;
        long parentId = parentFile.getId();
        this.acquireSingleUserCaseReadLock();
        try {
            PreparedStatement statement;
            connection = this.connections.getConnection();
            if (ext.isEmpty()) {
                statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_FILES_BY_PARENT_AND_NAME);
                statement.clearParameters();
                statement.setLong(1, parentId);
                statement.setString(2, fileName);
            } else {
                statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_FILES_BY_EXTENSION_AND_PARENT_AND_NAME);
                statement.clearParameters();
                statement.setString(1, ext);
                statement.setLong(2, parentId);
                statement.setString(3, fileName);
            }
            rs = connection.executeQuery(statement);
            list = this.resultSetToAbstractFiles(rs, connection);
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting AbstractFile children with name=" + fileName + " for Content parent with ID=" + parentFile.getId(), ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return list;
    }

    public long countFilesWhere(String sqlWhereClause) throws TskCoreException {
        long l;
        CaseDbConnection connection = null;
        Statement s = null;
        ResultSet rs = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT COUNT(*) AS count FROM tsk_files WHERE " + sqlWhereClause);
            rs.next();
            l = rs.getLong("count");
        }
        catch (SQLException e) {
            try {
                throw new TskCoreException("SQLException thrown when calling 'SleuthkitCase.countFilesWhere().", e);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return l;
    }

    public List<AbstractFile> findAllFilesWhere(String sqlWhereClause) throws TskCoreException {
        List<AbstractFile> list;
        CaseDbConnection connection = null;
        Statement s = null;
        ResultSet rs = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT * FROM tsk_files WHERE " + sqlWhereClause);
            list = this.resultSetToAbstractFiles(rs, connection);
        }
        catch (SQLException e) {
            try {
                throw new TskCoreException("SQLException thrown when calling 'SleuthkitCase.findAllFilesWhere(): " + sqlWhereClause, e);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return list;
    }

    /*
     * Exception decompiling
     */
    public List<AbstractFile> findAllFilesInFolderWhere(long parentId, String sqlWhereClause) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<Long> findAllFileIdsWhere(String sqlWhereClause) throws TskCoreException {
        ArrayList<Long> arrayList;
        CaseDbConnection connection = null;
        Statement s = null;
        ResultSet rs = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT obj_id FROM tsk_files WHERE " + sqlWhereClause);
            ArrayList<Long> ret = new ArrayList<Long>();
            while (rs.next()) {
                ret.add(rs.getLong("obj_id"));
            }
            arrayList = ret;
        }
        catch (SQLException e) {
            try {
                throw new TskCoreException("SQLException thrown when calling 'SleuthkitCase.findAllFileIdsWhere(): " + sqlWhereClause, e);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public List<AbstractFile> openFiles(Content dataSource, String filePath) throws TskCoreException {
        String path = AbstractFile.createNonUniquePath(filePath).toLowerCase();
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash == path.length()) {
            path = path.substring(0, lastSlash - 1);
            lastSlash = path.lastIndexOf(47);
        }
        String parentPath = path.substring(0, lastSlash);
        String fileName = path.substring(lastSlash);
        return this.findFiles(dataSource, fileName, parentPath);
    }

    public List<TskFileRange> getFileRanges(long id) throws TskCoreException {
        ArrayList<TskFileRange> arrayList;
        CaseDbConnection connection = null;
        Statement s = null;
        ResultSet rs = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT * FROM tsk_file_layout WHERE obj_id = " + id + " ORDER BY sequence");
            ArrayList<TskFileRange> ranges = new ArrayList<TskFileRange>();
            while (rs.next()) {
                TskFileRange range = new TskFileRange(rs.getLong("byte_start"), rs.getLong("byte_len"), rs.getLong("sequence"));
                ranges.add(range);
            }
            arrayList = ranges;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting TskFileLayoutRanges by id, id = " + id, ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public Image getImageById(long id) throws TskCoreException {
        Image image;
        CaseDbConnection connection = null;
        Statement s = null;
        ResultSet rs = null;
        this.acquireSingleUserCaseReadLock();
        try {
            String device_id;
            String name;
            String sha256;
            String sha1;
            String md5;
            long size;
            String tzone;
            long ssize;
            long type;
            String imagePath;
            connection = this.connections.getConnection();
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT tsk_image_info.type, tsk_image_info.ssize, tsk_image_info.tzone, tsk_image_info.size, tsk_image_info.md5, tsk_image_info.sha1, tsk_image_info.sha256, tsk_image_info.display_name, data_source_info.device_id, tsk_image_names.name FROM tsk_image_info INNER JOIN data_source_info ON tsk_image_info.obj_id = data_source_info.obj_id LEFT JOIN tsk_image_names ON tsk_image_names.obj_id = data_source_info.obj_id WHERE tsk_image_info.obj_id = " + id);
            ArrayList<String> imagePaths = new ArrayList<String>();
            if (rs.next()) {
                imagePath = rs.getString("name");
                if (imagePath != null) {
                    imagePaths.add(imagePath);
                }
                type = rs.getLong("type");
                ssize = rs.getLong("ssize");
                tzone = rs.getString("tzone");
                size = rs.getLong("size");
                md5 = rs.getString("md5");
                sha1 = rs.getString("sha1");
                sha256 = rs.getString("sha256");
                name = rs.getString("display_name");
                if (name == null) {
                    if (imagePaths.size() > 0) {
                        String path = (String)imagePaths.get(0);
                        name = new java.io.File(path).getName();
                    } else {
                        name = "";
                    }
                }
                device_id = rs.getString("device_id");
            } else {
                throw new TskCoreException("No image found for id: " + id);
            }
            while (rs.next()) {
                imagePath = rs.getString("name");
                if (imagePath == null) continue;
                imagePaths.add(imagePath);
            }
            image = new Image(this, id, type, device_id, ssize, name, imagePaths.toArray(new String[imagePaths.size()]), tzone, md5, sha1, sha256, size);
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting Image by id, id = " + id, ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return image;
    }

    VolumeSystem getVolumeSystemById(long id, Content parent) throws TskCoreException {
        ResultSet rs;
        Statement s;
        CaseDbConnection connection;
        block5: {
            connection = null;
            s = null;
            rs = null;
            this.acquireSingleUserCaseReadLock();
            connection = this.connections.getConnection();
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT * FROM tsk_vs_info where obj_id = " + id);
            if (!rs.next()) break block5;
            long type = rs.getLong("vs_type");
            long imgOffset = rs.getLong("img_offset");
            long blockSize = rs.getLong("block_size");
            VolumeSystem vs = new VolumeSystem(this, id, "", type, imgOffset, blockSize);
            vs.setParent(parent);
            VolumeSystem volumeSystem = vs;
            SleuthkitCase.closeResultSet(rs);
            SleuthkitCase.closeStatement(s);
            SleuthkitCase.closeConnection(connection);
            this.releaseSingleUserCaseReadLock();
            return volumeSystem;
        }
        try {
            try {
                throw new TskCoreException("No volume system found for id:" + id);
            }
            catch (SQLException ex) {
                throw new TskCoreException("Error getting Volume System by ID.", ex);
            }
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(rs);
            SleuthkitCase.closeStatement(s);
            SleuthkitCase.closeConnection(connection);
            this.releaseSingleUserCaseReadLock();
            throw throwable;
        }
    }

    VolumeSystem getVolumeSystemById(long id, long parentId) throws TskCoreException {
        VolumeSystem vs = this.getVolumeSystemById(id, null);
        vs.setParentId(parentId);
        return vs;
    }

    FileSystem getFileSystemById(long id, Image parent) throws TskCoreException {
        return this.getFileSystemByIdHelper(id, parent);
    }

    FileSystem getFileSystemById(long id, long parentId) throws TskCoreException {
        Volume vol = null;
        FileSystem fs = this.getFileSystemById(id, vol);
        fs.setParentId(parentId);
        return fs;
    }

    FileSystem getFileSystemById(long id, Volume parent) throws TskCoreException {
        return this.getFileSystemByIdHelper(id, parent);
    }

    Pool getPoolById(long id, Content parent) throws TskCoreException {
        return this.getPoolByIdHelper(id, parent);
    }

    Pool getPoolById(long id, long parentId) throws TskCoreException {
        Pool pool = this.getPoolById(id, null);
        pool.setParentId(parentId);
        return pool;
    }

    /*
     * Exception decompiling
     */
    private Pool getPoolByIdHelper(long id, Content parent) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileSystem getFileSystemByIdHelper(long id, Content parent) throws TskCoreException {
        ResultSet rs;
        Statement s;
        CaseDbConnection connection;
        block12: {
            Map<Long, FileSystem> map = this.fileSystemIdMap;
            synchronized (map) {
                if (this.fileSystemIdMap.containsKey(id)) {
                    return this.fileSystemIdMap.get(id);
                }
            }
            connection = null;
            s = null;
            rs = null;
            this.acquireSingleUserCaseReadLock();
            connection = this.connections.getConnection();
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT * FROM tsk_fs_info where obj_id = " + id);
            if (!rs.next()) break block12;
            TskData.TSK_FS_TYPE_ENUM fsType = TskData.TSK_FS_TYPE_ENUM.valueOf(rs.getInt("fs_type"));
            FileSystem fs = new FileSystem(this, rs.getLong("obj_id"), "", rs.getLong("img_offset"), fsType, rs.getLong("block_size"), rs.getLong("block_count"), rs.getLong("root_inum"), rs.getLong("first_inum"), rs.getLong("last_inum"));
            fs.setParent(parent);
            Object object = this.fileSystemIdMap;
            synchronized (object) {
                this.fileSystemIdMap.put(id, fs);
            }
            object = fs;
            SleuthkitCase.closeResultSet(rs);
            SleuthkitCase.closeStatement(s);
            SleuthkitCase.closeConnection(connection);
            this.releaseSingleUserCaseReadLock();
            return object;
        }
        try {
            try {
                throw new TskCoreException("No file system found for id:" + id);
            }
            catch (SQLException ex) {
                throw new TskCoreException("Error getting File System by ID", ex);
            }
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(rs);
            SleuthkitCase.closeStatement(s);
            SleuthkitCase.closeConnection(connection);
            this.releaseSingleUserCaseReadLock();
            throw throwable;
        }
    }

    Volume getVolumeById(long id, VolumeSystem parent) throws TskCoreException {
        ResultSet rs;
        Statement s;
        CaseDbConnection connection;
        block7: {
            String description;
            connection = null;
            s = null;
            rs = null;
            this.acquireSingleUserCaseReadLock();
            connection = this.connections.getConnection();
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT * FROM tsk_vs_parts where obj_id = " + id);
            if (!rs.next()) break block7;
            try {
                description = rs.getString("desc");
            }
            catch (Exception ex) {
                description = rs.getString("descr");
            }
            Volume vol = new Volume(this, rs.getLong("obj_id"), rs.getLong("addr"), rs.getLong("start"), rs.getLong("length"), rs.getLong("flags"), description);
            vol.setParent(parent);
            Volume volume = vol;
            SleuthkitCase.closeResultSet(rs);
            SleuthkitCase.closeStatement(s);
            SleuthkitCase.closeConnection(connection);
            this.releaseSingleUserCaseReadLock();
            return volume;
        }
        try {
            try {
                throw new TskCoreException("No volume found for id:" + id);
            }
            catch (SQLException ex) {
                throw new TskCoreException("Error getting Volume by ID", ex);
            }
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(rs);
            SleuthkitCase.closeStatement(s);
            SleuthkitCase.closeConnection(connection);
            this.releaseSingleUserCaseReadLock();
            throw throwable;
        }
    }

    Volume getVolumeById(long id, long parentId) throws TskCoreException {
        Volume vol = this.getVolumeById(id, null);
        vol.setParentId(parentId);
        return vol;
    }

    Directory getDirectoryById(long id, FileSystem parentFs) throws TskCoreException {
        Directory directory;
        CaseDbConnection connection = null;
        Statement s = null;
        ResultSet rs = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT * FROM tsk_files WHERE obj_id = " + id);
            Directory temp = null;
            if (rs.next()) {
                short type = rs.getShort("type");
                if (type == TskData.TSK_DB_FILES_TYPE_ENUM.FS.getFileType()) {
                    if (rs.getShort("meta_type") == TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_DIR.getValue() || rs.getShort("meta_type") == TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_VIRT_DIR.getValue()) {
                        temp = this.directory(rs, parentFs);
                    }
                } else if (type == TskData.TSK_DB_FILES_TYPE_ENUM.VIRTUAL_DIR.getFileType()) {
                    throw new TskCoreException("Expecting an FS-type directory, got virtual, id: " + id);
                }
            } else {
                throw new TskCoreException("No Directory found for id:" + id);
            }
            directory = temp;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting Directory by ID", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return directory;
    }

    public Collection<FileSystem> getImageFileSystems(Image image) throws TskCoreException {
        ArrayList<FileSystem> fileSystems = new ArrayList<FileSystem>();
        String queryStr = "SELECT * FROM tsk_fs_info WHERE data_source_obj_id = " + image.getId();
        CaseDbConnection connection = null;
        Statement s = null;
        ResultSet rs = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            s = connection.createStatement();
            rs = connection.executeQuery(s, queryStr);
            while (rs.next()) {
                TskData.TSK_FS_TYPE_ENUM fsType = TskData.TSK_FS_TYPE_ENUM.valueOf(rs.getInt("fs_type"));
                FileSystem fs = new FileSystem(this, rs.getLong("obj_id"), "", rs.getLong("img_offset"), fsType, rs.getLong("block_size"), rs.getLong("block_count"), rs.getLong("root_inum"), rs.getLong("first_inum"), rs.getLong("last_inum"));
                fs.setParent(null);
                fileSystems.add(fs);
            }
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error looking up files systems. Query: " + queryStr, ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return fileSystems;
    }

    List<Content> getImageChildren(Image img) throws TskCoreException {
        Collection<ObjectInfo> childInfos = this.getChildrenInfo(img);
        ArrayList<Content> children = new ArrayList<Content>();
        block8: for (ObjectInfo info : childInfos) {
            if (null == info.type) continue;
            switch (info.type) {
                case VS: {
                    children.add(this.getVolumeSystemById(info.id, img));
                    continue block8;
                }
                case POOL: {
                    children.add(this.getPoolById(info.id, img));
                    continue block8;
                }
                case FS: {
                    children.add(this.getFileSystemById(info.id, img));
                    continue block8;
                }
                case ABSTRACTFILE: {
                    AbstractFile f = this.getAbstractFileById(info.id);
                    if (f == null) continue block8;
                    children.add(f);
                    continue block8;
                }
                case ARTIFACT: {
                    BlackboardArtifact art = this.getArtifactById(info.id);
                    if (art == null) continue block8;
                    children.add(art);
                    continue block8;
                }
                case REPORT: {
                    continue block8;
                }
            }
            throw new TskCoreException("Image has child of invalid type: " + String.valueOf((Object)info.type));
        }
        return children;
    }

    List<Long> getImageChildrenIds(Image img) throws TskCoreException {
        Collection<ObjectInfo> childInfos = this.getChildrenInfo(img);
        ArrayList<Long> children = new ArrayList<Long>();
        for (ObjectInfo info : childInfos) {
            if (info.type == TskData.ObjectType.VS || info.type == TskData.ObjectType.POOL || info.type == TskData.ObjectType.FS || info.type == TskData.ObjectType.ABSTRACTFILE || info.type == TskData.ObjectType.ARTIFACT) {
                children.add(info.id);
                continue;
            }
            if (info.type == TskData.ObjectType.REPORT) continue;
            throw new TskCoreException("Image has child of invalid type: " + String.valueOf((Object)info.type));
        }
        return children;
    }

    List<Content> getPoolChildren(Pool pool) throws TskCoreException {
        Collection<ObjectInfo> childInfos = this.getChildrenInfo(pool);
        ArrayList<Content> children = new ArrayList<Content>();
        block5: for (ObjectInfo info : childInfos) {
            if (null == info.type) continue;
            switch (info.type) {
                case VS: {
                    children.add(this.getVolumeSystemById(info.id, pool));
                    continue block5;
                }
                case ABSTRACTFILE: {
                    AbstractFile f = this.getAbstractFileById(info.id);
                    if (f == null) continue block5;
                    children.add(f);
                    continue block5;
                }
                case ARTIFACT: {
                    BlackboardArtifact art = this.getArtifactById(info.id);
                    if (art == null) continue block5;
                    children.add(art);
                    continue block5;
                }
            }
            throw new TskCoreException("Pool has child of invalid type: " + String.valueOf((Object)info.type));
        }
        return children;
    }

    List<Long> getPoolChildrenIds(Pool pool) throws TskCoreException {
        Collection<ObjectInfo> childInfos = this.getChildrenInfo(pool);
        ArrayList<Long> children = new ArrayList<Long>();
        for (ObjectInfo info : childInfos) {
            if (info.type == TskData.ObjectType.VS || info.type == TskData.ObjectType.ABSTRACTFILE || info.type == TskData.ObjectType.ARTIFACT) {
                children.add(info.id);
                continue;
            }
            throw new TskCoreException("Pool has child of invalid type: " + String.valueOf((Object)info.type));
        }
        return children;
    }

    List<Content> getVolumeSystemChildren(VolumeSystem vs) throws TskCoreException {
        Collection<ObjectInfo> childInfos = this.getChildrenInfo(vs);
        ArrayList<Content> children = new ArrayList<Content>();
        block5: for (ObjectInfo info : childInfos) {
            if (null == info.type) continue;
            switch (info.type) {
                case VOL: {
                    children.add(this.getVolumeById(info.id, vs));
                    continue block5;
                }
                case ABSTRACTFILE: {
                    AbstractFile f = this.getAbstractFileById(info.id);
                    if (f == null) continue block5;
                    children.add(f);
                    continue block5;
                }
                case ARTIFACT: {
                    BlackboardArtifact art = this.getArtifactById(info.id);
                    if (art == null) continue block5;
                    children.add(art);
                    continue block5;
                }
            }
            throw new TskCoreException("VolumeSystem has child of invalid type: " + String.valueOf((Object)info.type));
        }
        return children;
    }

    List<Long> getVolumeSystemChildrenIds(VolumeSystem vs) throws TskCoreException {
        Collection<ObjectInfo> childInfos = this.getChildrenInfo(vs);
        ArrayList<Long> children = new ArrayList<Long>();
        for (ObjectInfo info : childInfos) {
            if (info.type == TskData.ObjectType.VOL || info.type == TskData.ObjectType.ABSTRACTFILE || info.type == TskData.ObjectType.ARTIFACT) {
                children.add(info.id);
                continue;
            }
            throw new TskCoreException("VolumeSystem has child of invalid type: " + String.valueOf((Object)info.type));
        }
        return children;
    }

    List<Content> getVolumeChildren(Volume vol) throws TskCoreException {
        Collection<ObjectInfo> childInfos = this.getChildrenInfo(vol);
        ArrayList<Content> children = new ArrayList<Content>();
        block6: for (ObjectInfo info : childInfos) {
            if (null == info.type) continue;
            switch (info.type) {
                case POOL: {
                    children.add(this.getPoolById(info.id, vol));
                    continue block6;
                }
                case FS: {
                    children.add(this.getFileSystemById(info.id, vol));
                    continue block6;
                }
                case ABSTRACTFILE: {
                    AbstractFile f = this.getAbstractFileById(info.id);
                    if (f == null) continue block6;
                    children.add(f);
                    continue block6;
                }
                case ARTIFACT: {
                    BlackboardArtifact art = this.getArtifactById(info.id);
                    if (art == null) continue block6;
                    children.add(art);
                    continue block6;
                }
            }
            throw new TskCoreException("Volume has child of invalid type: " + String.valueOf((Object)info.type));
        }
        return children;
    }

    List<Long> getVolumeChildrenIds(Volume vol) throws TskCoreException {
        Collection<ObjectInfo> childInfos = this.getChildrenInfo(vol);
        ArrayList<Long> children = new ArrayList<Long>();
        for (ObjectInfo info : childInfos) {
            if (info.type == TskData.ObjectType.FS || info.type == TskData.ObjectType.ABSTRACTFILE || info.type == TskData.ObjectType.ARTIFACT) {
                children.add(info.id);
                continue;
            }
            throw new TskCoreException("Volume has child of invalid type: " + String.valueOf((Object)info.type));
        }
        return children;
    }

    public Image addImageInfo(long deviceObjId, List<String> imageFilePaths, String timeZone) throws TskCoreException {
        return this.addImageInfo(deviceObjId, imageFilePaths, timeZone, null);
    }

    public Image addImageInfo(long deviceObjId, List<String> imageFilePaths, String timeZone, Host host) throws TskCoreException {
        return this.addImageInfo(deviceObjId, imageFilePaths, timeZone, host, null);
    }

    @Beta
    public Image addImageInfo(long deviceObjId, List<String> imageFilePaths, String timeZone, Host host, String password) throws TskCoreException {
        long imageId = this.caseHandle.addImageInfo(deviceObjId, imageFilePaths, timeZone, host, password, this);
        return this.getImageById(imageId);
    }

    public Map<Long, List<String>> getImagePaths() throws TskCoreException {
        LinkedHashMap<Long, List<String>> linkedHashMap;
        CaseDbConnection connection = null;
        Statement s1 = null;
        ResultSet rs1 = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            s1 = connection.createStatement();
            rs1 = connection.executeQuery(s1, "SELECT tsk_image_info.obj_id, tsk_image_names.name FROM tsk_image_info LEFT JOIN tsk_image_names ON tsk_image_info.obj_id = tsk_image_names.obj_id");
            LinkedHashMap<Long, List<String>> imgPaths = new LinkedHashMap<Long, List<String>>();
            while (rs1.next()) {
                long obj_id = rs1.getLong("obj_id");
                String name = rs1.getString("name");
                List imagePaths = (List)imgPaths.get(obj_id);
                if (imagePaths == null) {
                    ArrayList<String> paths = new ArrayList<String>();
                    if (name != null) {
                        paths.add(name);
                    }
                    imgPaths.put(obj_id, paths);
                    continue;
                }
                if (name == null) continue;
                imagePaths.add(name);
            }
            linkedHashMap = imgPaths;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting image paths.", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs1);
                SleuthkitCase.closeStatement(s1);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs1);
        SleuthkitCase.closeStatement(s1);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return linkedHashMap;
    }

    private List<String> getImagePathsById(long objectId, CaseDbConnection connection) throws TskCoreException {
        ArrayList<String> imagePaths = new ArrayList<String>();
        this.acquireSingleUserCaseReadLock();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = connection.executeQuery(statement, "SELECT name FROM tsk_image_names WHERE tsk_image_names.obj_id = " + objectId);
            while (resultSet.next()) {
                imagePaths.add(resultSet.getString("name"));
            }
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException(String.format("Error getting image names with obj_id = %d", objectId), ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeStatement(statement);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeStatement(statement);
        this.releaseSingleUserCaseReadLock();
        return imagePaths;
    }

    public List<Image> getImages() throws TskCoreException {
        Object object;
        CaseDbConnection connection = null;
        Statement s = null;
        ResultSet rs = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT obj_id FROM tsk_image_info");
            ArrayList<Long> imageIDs = new ArrayList<Long>();
            while (rs.next()) {
                imageIDs.add(rs.getLong("obj_id"));
            }
            ArrayList<Image> images = new ArrayList<Image>();
            object = imageIDs.iterator();
            while (object.hasNext()) {
                long id = (Long)object.next();
                images.add(this.getImageById(id));
            }
            object = images;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error retrieving images.", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImagePaths(long obj_id, List<String> paths) throws TskCoreException {
        CaseDbTransaction transaction = this.beginTransaction();
        try {
            this.setImagePaths(obj_id, paths, transaction);
            transaction.commit();
            transaction = null;
        }
        finally {
            if (transaction != null) {
                transaction.rollback();
            }
        }
    }

    @Beta
    public void setImagePaths(long objId, List<String> paths, CaseDbTransaction trans) throws TskCoreException {
        try {
            PreparedStatement statement = trans.getConnection().getPreparedStatement(PREPARED_STATEMENT.DELETE_IMAGE_NAME);
            statement.clearParameters();
            statement.setLong(1, objId);
            trans.getConnection().executeUpdate(statement);
            for (int i = 0; i < paths.size(); ++i) {
                statement = trans.getConnection().getPreparedStatement(PREPARED_STATEMENT.INSERT_IMAGE_NAME);
                statement.clearParameters();
                statement.setLong(1, objId);
                statement.setString(2, paths.get(i));
                statement.setLong(3, i);
                trans.getConnection().executeUpdate(statement);
            }
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error updating image paths.", ex);
        }
    }

    void deleteDataSource(long dataSourceObjectId) throws TskCoreException {
        Host hostToDelete = null;
        CaseDbSchemaVersionNumber version = this.getDBSchemaCreationVersion();
        int major = version.getMajor();
        int minor = version.getMinor();
        if (major > 9 || major == 9 && minor >= 1) {
            hostToDelete = this.getHostManager().getHostByDataSource(dataSourceObjectId);
            if (this.getHostManager().getDataSourcesForHost(hostToDelete).size() != 1) {
                hostToDelete = null;
            }
        }
        CaseDbConnection connection = null;
        this.acquireSingleUserCaseWriteLock();
        try {
            connection = this.connections.getConnection();
            Statement statement = connection.createStatement();
            connection.beginTransaction();
            statement.execute("DELETE FROM tsk_objects WHERE obj_id = " + dataSourceObjectId);
            String accountSql = "DELETE FROM accounts WHERE account_id in (SELECT account_id FROM accounts WHERE account_id NOT IN (SELECT account1_id FROM account_relationships) AND account_id NOT IN (SELECT account2_id FROM account_relationships))";
            statement.execute(accountSql);
            if (hostToDelete != null) {
                statement.execute("DELETE FROM tsk_hosts WHERE id = " + hostToDelete.getHostId());
                String deleteOsAcctObjectsQuery = "DELETE FROM tsk_objects WHERE type=" + TskData.ObjectType.OS_ACCOUNT.getObjectType() + " AND obj_id NOT IN (SELECT os_account_obj_id FROM tsk_os_accounts WHERE  os_account_obj_id IS NOT NULL)";
                statement.execute(deleteOsAcctObjectsQuery);
            }
            connection.commitTransaction();
        }
        catch (SQLException ex) {
            SleuthkitCase.rollbackTransaction(connection);
            throw new TskCoreException("Error deleting data source.", ex);
        }
        finally {
            SleuthkitCase.closeConnection(connection);
            this.releaseSingleUserCaseWriteLock();
        }
    }

    List<AbstractFile> resultSetToAbstractFiles(ResultSet rs, CaseDbConnection connection) throws SQLException {
        ArrayList<AbstractFile> results = new ArrayList<AbstractFile>();
        try {
            while (rs.next()) {
                short type = rs.getShort("type");
                if (type == TskData.TSK_DB_FILES_TYPE_ENUM.FS.getFileType() && rs.getShort("meta_type") != TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_VIRT_DIR.getValue()) {
                    FsContent result = rs.getShort("meta_type") == TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_DIR.getValue() ? this.directory(rs, null) : this.file(rs, null);
                    results.add(result);
                    continue;
                }
                if (type == TskData.TSK_DB_FILES_TYPE_ENUM.VIRTUAL_DIR.getFileType() || rs.getShort("meta_type") == TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_VIRT_DIR.getValue()) {
                    VirtualDirectory virtDir = this.virtualDirectory(rs, connection);
                    results.add(virtDir);
                    continue;
                }
                if (type == TskData.TSK_DB_FILES_TYPE_ENUM.LOCAL_DIR.getFileType()) {
                    LocalDirectory localDir = this.localDirectory(rs);
                    results.add(localDir);
                    continue;
                }
                if (type == TskData.TSK_DB_FILES_TYPE_ENUM.UNALLOC_BLOCKS.getFileType() || type == TskData.TSK_DB_FILES_TYPE_ENUM.UNUSED_BLOCKS.getFileType() || type == TskData.TSK_DB_FILES_TYPE_ENUM.CARVED.getFileType() || type == TskData.TSK_DB_FILES_TYPE_ENUM.LAYOUT_FILE.getFileType()) {
                    TskData.TSK_DB_FILES_TYPE_ENUM atype = TskData.TSK_DB_FILES_TYPE_ENUM.valueOf(type);
                    String parentPath = rs.getString("parent_path");
                    if (parentPath == null) {
                        parentPath = "/";
                    }
                    Long osAccountObjId = rs.getLong("os_account_obj_id");
                    if (rs.wasNull()) {
                        osAccountObjId = null;
                    }
                    LayoutFile lf = new LayoutFile(this, rs.getLong("obj_id"), rs.getLong("data_source_obj_id"), rs.getLong("fs_obj_id"), rs.getString("name"), atype, TskData.TSK_FS_NAME_TYPE_ENUM.valueOf(rs.getShort("dir_type")), TskData.TSK_FS_META_TYPE_ENUM.valueOf(rs.getShort("meta_type")), TskData.TSK_FS_NAME_FLAG_ENUM.valueOf(rs.getShort("dir_flags")), rs.getShort("meta_flags"), rs.getLong("size"), rs.getLong("ctime"), rs.getLong("crtime"), rs.getLong("atime"), rs.getLong("mtime"), rs.getString("md5"), rs.getString("sha256"), rs.getString("sha1"), TskData.FileKnown.valueOf(rs.getByte("known")), parentPath, rs.getString("mime_type"), rs.getString("owner_uid"), osAccountObjId);
                    results.add(lf);
                    continue;
                }
                if (type == TskData.TSK_DB_FILES_TYPE_ENUM.DERIVED.getFileType()) {
                    DerivedFile df = this.derivedFile(rs, connection, -1L);
                    results.add(df);
                    continue;
                }
                if (type == TskData.TSK_DB_FILES_TYPE_ENUM.LOCAL.getFileType()) {
                    LocalFile lf = this.localFile(rs, connection, -1L);
                    results.add(lf);
                    continue;
                }
                if (type != TskData.TSK_DB_FILES_TYPE_ENUM.SLACK.getFileType()) continue;
                SlackFile sf = this.slackFile(rs, null);
                results.add(sf);
            }
        }
        catch (SQLException e) {
            logger.log(Level.SEVERE, "Error getting abstract files from result set", e);
        }
        return results;
    }

    File file(ResultSet rs, FileSystem fs) throws SQLException {
        Long osAccountObjId = rs.getLong("os_account_obj_id");
        if (rs.wasNull()) {
            osAccountObjId = null;
        }
        File f = new File(this, rs.getLong("obj_id"), rs.getLong("data_source_obj_id"), rs.getLong("fs_obj_id"), TskData.TSK_FS_ATTR_TYPE_ENUM.valueOf(rs.getShort("attr_type")), rs.getInt("attr_id"), rs.getString("name"), rs.getLong("meta_addr"), rs.getInt("meta_seq"), TskData.TSK_FS_NAME_TYPE_ENUM.valueOf(rs.getShort("dir_type")), TskData.TSK_FS_META_TYPE_ENUM.valueOf(rs.getShort("meta_type")), TskData.TSK_FS_NAME_FLAG_ENUM.valueOf(rs.getShort("dir_flags")), rs.getShort("meta_flags"), rs.getLong("size"), rs.getLong("ctime"), rs.getLong("crtime"), rs.getLong("atime"), rs.getLong("mtime"), (short)rs.getInt("mode"), rs.getInt("uid"), rs.getInt("gid"), rs.getString("md5"), rs.getString("sha256"), rs.getString("sha1"), TskData.FileKnown.valueOf(rs.getByte("known")), rs.getString("parent_path"), rs.getString("mime_type"), rs.getString("extension"), rs.getString("owner_uid"), osAccountObjId, TskData.CollectedStatus.valueOf(rs.getInt("collected")), Collections.emptyList());
        f.setFileSystem(fs);
        return f;
    }

    Directory directory(ResultSet rs, FileSystem fs) throws SQLException {
        Long osAccountObjId = rs.getLong("os_account_obj_id");
        if (rs.wasNull()) {
            osAccountObjId = null;
        }
        Directory dir = new Directory(this, rs.getLong("obj_id"), rs.getLong("data_source_obj_id"), rs.getLong("fs_obj_id"), TskData.TSK_FS_ATTR_TYPE_ENUM.valueOf(rs.getShort("attr_type")), rs.getInt("attr_id"), rs.getString("name"), rs.getLong("meta_addr"), rs.getInt("meta_seq"), TskData.TSK_FS_NAME_TYPE_ENUM.valueOf(rs.getShort("dir_type")), TskData.TSK_FS_META_TYPE_ENUM.valueOf(rs.getShort("meta_type")), TskData.TSK_FS_NAME_FLAG_ENUM.valueOf(rs.getShort("dir_flags")), rs.getShort("meta_flags"), rs.getLong("size"), rs.getLong("ctime"), rs.getLong("crtime"), rs.getLong("atime"), rs.getLong("mtime"), rs.getShort("mode"), rs.getInt("uid"), rs.getInt("gid"), rs.getString("md5"), rs.getString("sha256"), rs.getString("sha1"), TskData.FileKnown.valueOf(rs.getByte("known")), rs.getString("parent_path"), rs.getString("owner_uid"), osAccountObjId);
        dir.setFileSystem(fs);
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VirtualDirectory virtualDirectory(ResultSet rs, CaseDbConnection connection) throws SQLException {
        long dsObjId;
        long objId;
        String parentPath;
        block6: {
            ResultSet rsDataSourceInfo;
            Statement s;
            String timeZone;
            String deviceId;
            block5: {
                parentPath = rs.getString("parent_path");
                if (parentPath == null) {
                    parentPath = "";
                }
                if ((objId = rs.getLong("obj_id")) != (dsObjId = rs.getLong("data_source_obj_id"))) break block6;
                deviceId = "";
                timeZone = "";
                s = null;
                rsDataSourceInfo = null;
                this.acquireSingleUserCaseReadLock();
                try {
                    s = connection.createStatement();
                    rsDataSourceInfo = connection.executeQuery(s, "SELECT device_id, time_zone FROM data_source_info WHERE obj_id = " + objId);
                    if (!rsDataSourceInfo.next()) break block5;
                    deviceId = rsDataSourceInfo.getString("device_id");
                    timeZone = rsDataSourceInfo.getString("time_zone");
                }
                catch (SQLException ex) {
                    try {
                        logger.log(Level.SEVERE, "Error data source info for datasource id " + objId, ex);
                    }
                    catch (Throwable throwable) {
                        SleuthkitCase.closeResultSet(rsDataSourceInfo);
                        SleuthkitCase.closeStatement(s);
                        this.releaseSingleUserCaseReadLock();
                        throw throwable;
                    }
                    SleuthkitCase.closeResultSet(rsDataSourceInfo);
                    SleuthkitCase.closeStatement(s);
                    this.releaseSingleUserCaseReadLock();
                }
            }
            SleuthkitCase.closeResultSet(rsDataSourceInfo);
            SleuthkitCase.closeStatement(s);
            this.releaseSingleUserCaseReadLock();
            return new LocalFilesDataSource(this, objId, dsObjId, deviceId, rs.getString("name"), TskData.TSK_FS_NAME_TYPE_ENUM.valueOf(rs.getShort("dir_type")), TskData.TSK_FS_META_TYPE_ENUM.valueOf(rs.getShort("meta_type")), TskData.TSK_FS_NAME_FLAG_ENUM.valueOf(rs.getShort("dir_flags")), rs.getShort("meta_flags"), timeZone, rs.getString("md5"), rs.getString("sha256"), rs.getString("sha1"), TskData.FileKnown.valueOf(rs.getByte("known")), parentPath);
        }
        VirtualDirectory vd = new VirtualDirectory(this, objId, dsObjId, rs.getLong("fs_obj_id"), rs.getString("name"), TskData.TSK_FS_NAME_TYPE_ENUM.valueOf(rs.getShort("dir_type")), TskData.TSK_FS_META_TYPE_ENUM.valueOf(rs.getShort("meta_type")), TskData.TSK_FS_NAME_FLAG_ENUM.valueOf(rs.getShort("dir_flags")), rs.getShort("meta_flags"), rs.getString("md5"), rs.getString("sha256"), rs.getString("sha1"), TskData.FileKnown.valueOf(rs.getByte("known")), parentPath);
        return vd;
    }

    LocalDirectory localDirectory(ResultSet rs) throws SQLException {
        String parentPath = rs.getString("parent_path");
        if (parentPath == null) {
            parentPath = "";
        }
        LocalDirectory ld = new LocalDirectory(this, rs.getLong("obj_id"), rs.getLong("data_source_obj_id"), rs.getString("name"), TskData.TSK_FS_NAME_TYPE_ENUM.valueOf(rs.getShort("dir_type")), TskData.TSK_FS_META_TYPE_ENUM.valueOf(rs.getShort("meta_type")), TskData.TSK_FS_NAME_FLAG_ENUM.valueOf(rs.getShort("dir_flags")), rs.getShort("meta_flags"), rs.getString("md5"), rs.getString("sha256"), rs.getString("sha1"), TskData.FileKnown.valueOf(rs.getByte("known")), parentPath);
        return ld;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DerivedFile derivedFile(ResultSet rs, CaseDbConnection connection, long parentId) throws SQLException {
        String parentPath;
        boolean hasLocalPath = rs.getBoolean("has_path");
        long objId = rs.getLong("obj_id");
        String localPath = null;
        TskData.EncodingType encodingType = TskData.EncodingType.NONE;
        if (hasLocalPath) {
            ResultSet rsFilePath = null;
            this.acquireSingleUserCaseReadLock();
            try {
                PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_LOCAL_PATH_AND_ENCODING_FOR_FILE);
                statement.clearParameters();
                statement.setLong(1, objId);
                rsFilePath = connection.executeQuery(statement);
                if (rsFilePath.next()) {
                    localPath = rsFilePath.getString("path");
                    encodingType = TskData.EncodingType.valueOf(rsFilePath.getInt("encoding_type"));
                }
                SleuthkitCase.closeResultSet(rsFilePath);
                this.releaseSingleUserCaseReadLock();
            }
            catch (SQLException ex) {
                logger.log(Level.SEVERE, "Error getting encoding type for file " + objId, ex);
            }
            finally {
                SleuthkitCase.closeResultSet(rsFilePath);
                this.releaseSingleUserCaseReadLock();
            }
        }
        if ((parentPath = rs.getString("parent_path")) == null) {
            parentPath = "";
        }
        Long osAccountObjId = rs.getLong("os_account_obj_id");
        if (rs.wasNull()) {
            osAccountObjId = null;
        }
        DerivedFile df = new DerivedFile(this, objId, rs.getLong("data_source_obj_id"), rs.getLong("fs_obj_id"), rs.getString("name"), TskData.TSK_FS_NAME_TYPE_ENUM.valueOf(rs.getShort("dir_type")), TskData.TSK_FS_META_TYPE_ENUM.valueOf(rs.getShort("meta_type")), TskData.TSK_FS_NAME_FLAG_ENUM.valueOf(rs.getShort("dir_flags")), rs.getShort("meta_flags"), rs.getLong("size"), rs.getLong("ctime"), rs.getLong("crtime"), rs.getLong("atime"), rs.getLong("mtime"), rs.getString("md5"), rs.getString("sha256"), rs.getString("sha1"), TskData.FileKnown.valueOf(rs.getByte("known")), parentPath, localPath, parentId, rs.getString("mime_type"), encodingType, rs.getString("extension"), rs.getString("owner_uid"), osAccountObjId);
        return df;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalFile localFile(ResultSet rs, CaseDbConnection connection, long parentId) throws SQLException {
        String parentPath;
        long objId = rs.getLong("obj_id");
        String localPath = null;
        TskData.EncodingType encodingType = TskData.EncodingType.NONE;
        if (rs.getBoolean("has_path")) {
            ResultSet rsFilePath = null;
            this.acquireSingleUserCaseReadLock();
            try {
                PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_LOCAL_PATH_AND_ENCODING_FOR_FILE);
                statement.clearParameters();
                statement.setLong(1, objId);
                rsFilePath = connection.executeQuery(statement);
                if (rsFilePath.next()) {
                    localPath = rsFilePath.getString("path");
                    encodingType = TskData.EncodingType.valueOf(rsFilePath.getInt("encoding_type"));
                }
                SleuthkitCase.closeResultSet(rsFilePath);
                this.releaseSingleUserCaseReadLock();
            }
            catch (SQLException ex) {
                logger.log(Level.SEVERE, "Error getting encoding type for file " + objId, ex);
            }
            finally {
                SleuthkitCase.closeResultSet(rsFilePath);
                this.releaseSingleUserCaseReadLock();
            }
        }
        if (null == (parentPath = rs.getString("parent_path"))) {
            parentPath = "";
        }
        Long osAccountObjId = rs.getLong("os_account_obj_id");
        if (rs.wasNull()) {
            osAccountObjId = null;
        }
        LocalFile file = new LocalFile(this, objId, rs.getString("name"), TskData.TSK_DB_FILES_TYPE_ENUM.valueOf(rs.getShort("type")), TskData.TSK_FS_NAME_TYPE_ENUM.valueOf(rs.getShort("dir_type")), TskData.TSK_FS_META_TYPE_ENUM.valueOf(rs.getShort("meta_type")), TskData.TSK_FS_NAME_FLAG_ENUM.valueOf(rs.getShort("dir_flags")), rs.getShort("meta_flags"), rs.getLong("size"), rs.getLong("ctime"), rs.getLong("crtime"), rs.getLong("atime"), rs.getLong("mtime"), rs.getString("mime_type"), rs.getString("md5"), rs.getString("sha256"), rs.getString("sha1"), TskData.FileKnown.valueOf(rs.getByte("known")), parentId, parentPath, rs.getLong("data_source_obj_id"), localPath, encodingType, rs.getString("extension"), rs.getString("owner_uid"), osAccountObjId);
        return file;
    }

    SlackFile slackFile(ResultSet rs, FileSystem fs) throws SQLException {
        Long osAccountObjId = rs.getLong("os_account_obj_id");
        if (rs.wasNull()) {
            osAccountObjId = null;
        }
        SlackFile f = new SlackFile(this, rs.getLong("obj_id"), rs.getLong("data_source_obj_id"), rs.getLong("fs_obj_id"), TskData.TSK_FS_ATTR_TYPE_ENUM.valueOf(rs.getShort("attr_type")), rs.getInt("attr_id"), rs.getString("name"), rs.getLong("meta_addr"), rs.getInt("meta_seq"), TskData.TSK_FS_NAME_TYPE_ENUM.valueOf(rs.getShort("dir_type")), TskData.TSK_FS_META_TYPE_ENUM.valueOf(rs.getShort("meta_type")), TskData.TSK_FS_NAME_FLAG_ENUM.valueOf(rs.getShort("dir_flags")), rs.getShort("meta_flags"), rs.getLong("size"), rs.getLong("ctime"), rs.getLong("crtime"), rs.getLong("atime"), rs.getLong("mtime"), (short)rs.getInt("mode"), rs.getInt("uid"), rs.getInt("gid"), rs.getString("md5"), rs.getString("sha256"), rs.getString("sha1"), TskData.FileKnown.valueOf(rs.getByte("known")), rs.getString("parent_path"), rs.getString("mime_type"), rs.getString("extension"), rs.getString("owner_uid"), osAccountObjId);
        f.setFileSystem(fs);
        return f;
    }

    List<Content> fileChildren(ResultSet rs, CaseDbConnection connection, long parentId) throws SQLException {
        ArrayList<Content> children = new ArrayList<Content>();
        while (rs.next()) {
            TskData.TSK_DB_FILES_TYPE_ENUM type = TskData.TSK_DB_FILES_TYPE_ENUM.valueOf(rs.getShort("type"));
            if (null == type) continue;
            switch (type) {
                case FS: {
                    if (rs.getShort("meta_type") != TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_VIRT_DIR.getValue()) {
                        FsContent result = rs.getShort("meta_type") == TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_DIR.getValue() ? this.directory(rs, null) : this.file(rs, null);
                        children.add(result);
                        break;
                    }
                    VirtualDirectory virtDir = this.virtualDirectory(rs, connection);
                    children.add(virtDir);
                    break;
                }
                case VIRTUAL_DIR: {
                    VirtualDirectory virtDir = this.virtualDirectory(rs, connection);
                    children.add(virtDir);
                    break;
                }
                case LOCAL_DIR: {
                    LocalDirectory localDir = this.localDirectory(rs);
                    children.add(localDir);
                    break;
                }
                case UNALLOC_BLOCKS: 
                case UNUSED_BLOCKS: 
                case CARVED: 
                case LAYOUT_FILE: {
                    String parentPath = rs.getString("parent_path");
                    if (parentPath == null) {
                        parentPath = "";
                    }
                    Long osAccountObjId = rs.getLong("os_account_obj_id");
                    if (rs.wasNull()) {
                        osAccountObjId = null;
                    }
                    LayoutFile lf = new LayoutFile(this, rs.getLong("obj_id"), rs.getLong("data_source_obj_id"), rs.getLong("fs_obj_id"), rs.getString("name"), type, TskData.TSK_FS_NAME_TYPE_ENUM.valueOf(rs.getShort("dir_type")), TskData.TSK_FS_META_TYPE_ENUM.valueOf(rs.getShort("meta_type")), TskData.TSK_FS_NAME_FLAG_ENUM.valueOf(rs.getShort("dir_flags")), rs.getShort("meta_flags"), rs.getLong("size"), rs.getLong("ctime"), rs.getLong("crtime"), rs.getLong("atime"), rs.getLong("mtime"), rs.getString("md5"), rs.getString("sha256"), rs.getString("sha1"), TskData.FileKnown.valueOf(rs.getByte("known")), parentPath, rs.getString("mime_type"), rs.getString("owner_uid"), osAccountObjId);
                    children.add(lf);
                    break;
                }
                case DERIVED: {
                    DerivedFile df = this.derivedFile(rs, connection, parentId);
                    children.add(df);
                    break;
                }
                case LOCAL: {
                    LocalFile lf = this.localFile(rs, connection, parentId);
                    children.add(lf);
                    break;
                }
                case SLACK: {
                    SlackFile sf = this.slackFile(rs, null);
                    children.add(sf);
                    break;
                }
            }
        }
        return children;
    }

    public CaseDbQuery executeQuery(String query) throws TskCoreException {
        return new CaseDbQuery(query);
    }

    public CaseDbQuery executeInsertOrUpdate(String query) throws TskCoreException {
        return new CaseDbQuery(query, true);
    }

    CaseDbConnection getConnection() throws TskCoreException {
        return this.connections.getConnection();
    }

    String getCaseHandleIdentifier() {
        return this.caseHandleIdentifier;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public synchronized void close() {
        this.acquireSingleUserCaseWriteLock();
        try {
            this.connections.close();
        }
        catch (TskCoreException ex) {
            logger.log(Level.SEVERE, "Error closing database connection pool.", ex);
        }
        this.fileSystemIdMap.clear();
        try {
            if (this.caseHandle != null) {
                this.caseHandle.free();
                this.caseHandle = null;
            }
        }
        catch (TskCoreException ex) {
            logger.log(Level.SEVERE, "Error freeing case handle.", ex);
        }
        finally {
            this.releaseSingleUserCaseWriteLock();
        }
        if (this.lockResources != null) {
            try {
                this.lockResources.close();
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Error closing lock resources.", ex);
            }
        }
    }

    public boolean setKnown(AbstractFile file, TskData.FileKnown fileKnown) throws TskCoreException {
        long id = file.getId();
        TskData.FileKnown currentKnown = file.getKnown();
        if (currentKnown.compareTo(fileKnown) > 0) {
            return false;
        }
        this.acquireSingleUserCaseWriteLock();
        try (CaseDbConnection connection = this.connections.getConnection();
             Statement statement = connection.createStatement();){
            connection.executeUpdate(statement, "UPDATE tsk_files SET known='" + fileKnown.getFileKnownValue() + "' WHERE obj_id=" + id);
            file.setKnown(fileKnown);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error setting Known status.", ex);
        }
        finally {
            this.releaseSingleUserCaseWriteLock();
        }
        return true;
    }

    void setFileName(String name, long objId) throws TskCoreException {
        this.acquireSingleUserCaseWriteLock();
        try (CaseDbConnection connection = this.connections.getConnection();){
            PreparedStatement preparedStatement = connection.getPreparedStatement(PREPARED_STATEMENT.UPDATE_FILE_NAME);
            preparedStatement.clearParameters();
            preparedStatement.setString(1, name);
            preparedStatement.setLong(2, objId);
            connection.executeUpdate(preparedStatement);
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error updating while the name for object ID %d to %s", objId, name), ex);
        }
        finally {
            this.releaseSingleUserCaseWriteLock();
        }
    }

    void setImageName(String name, long objId) throws TskCoreException {
        this.acquireSingleUserCaseWriteLock();
        try (CaseDbConnection connection = this.connections.getConnection();){
            PreparedStatement preparedStatement = connection.getPreparedStatement(PREPARED_STATEMENT.UPDATE_IMAGE_NAME);
            preparedStatement.clearParameters();
            preparedStatement.setString(1, name);
            preparedStatement.setLong(2, objId);
            connection.executeUpdate(preparedStatement);
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error updating while the name for object ID %d to %s", objId, name), ex);
        }
        finally {
            this.releaseSingleUserCaseWriteLock();
        }
    }

    void setImageSizes(Image image, long totalSize, long sectorSize) throws TskCoreException {
        this.acquireSingleUserCaseWriteLock();
        try (CaseDbConnection connection = this.connections.getConnection();){
            PreparedStatement preparedStatement = connection.getPreparedStatement(PREPARED_STATEMENT.UPDATE_IMAGE_SIZES);
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, totalSize);
            preparedStatement.setLong(2, sectorSize);
            preparedStatement.setLong(3, image.getId());
            connection.executeUpdate(preparedStatement);
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error updating image sizes to %d and sector size to %d for object ID %d ", totalSize, sectorSize, image.getId()), ex);
        }
        finally {
            this.releaseSingleUserCaseWriteLock();
        }
    }

    @Beta
    public void updateFile(long fileObjId, long size, long mtime, long atime, long ctime, long crtime, String userSid, Long osAcctObjId) throws TskCoreException {
        String updateString = "UPDATE tsk_files SET size = ?, mtime = ?, atime = ?, ctime = ?, crtime = ?,  owner_uid = ?, os_account_obj_id = ? WHERE obj_id = ?";
        this.acquireSingleUserCaseWriteLock();
        try (CaseDbConnection connection = this.connections.getConnection();
             PreparedStatement preparedStatement = connection.getPreparedStatement(updateString, 2);){
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, size);
            preparedStatement.setLong(2, mtime);
            preparedStatement.setLong(3, atime);
            preparedStatement.setLong(4, ctime);
            preparedStatement.setLong(5, crtime);
            preparedStatement.setString(6, userSid);
            if (osAcctObjId != null) {
                preparedStatement.setLong(7, osAcctObjId);
            } else {
                preparedStatement.setNull(7, -5);
            }
            preparedStatement.setLong(8, fileObjId);
            connection.executeUpdate(preparedStatement);
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error updating file (obj_id = %s)", fileObjId), ex);
        }
        finally {
            this.releaseSingleUserCaseWriteLock();
        }
    }

    public void setFileMIMEType(AbstractFile file, String mimeType) throws TskCoreException {
        this.acquireSingleUserCaseWriteLock();
        try (CaseDbConnection connection = this.connections.getConnection();
             Statement statement = connection.createStatement();){
            connection.executeUpdate(statement, String.format("UPDATE tsk_files SET mime_type = '%s' WHERE obj_id = %d", mimeType, file.getId()));
            file.setMIMEType(mimeType);
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error setting MIME type for file (obj_id = %s)", file.getId()), ex);
        }
        finally {
            this.releaseSingleUserCaseWriteLock();
        }
    }

    public void setFileUnalloc(AbstractFile file) throws TskCoreException {
        short metaFlag = file.getMetaFlagsAsInt();
        Set<TskData.TSK_FS_META_FLAG_ENUM> metaFlagAsSet = TskData.TSK_FS_META_FLAG_ENUM.valuesOf(metaFlag);
        metaFlagAsSet.remove((Object)TskData.TSK_FS_META_FLAG_ENUM.ALLOC);
        metaFlagAsSet.add(TskData.TSK_FS_META_FLAG_ENUM.UNALLOC);
        short newMetaFlgs = TskData.TSK_FS_META_FLAG_ENUM.toInt(metaFlagAsSet);
        short newDirFlags = TskData.TSK_FS_NAME_FLAG_ENUM.UNALLOC.getValue();
        this.acquireSingleUserCaseWriteLock();
        try (CaseDbConnection connection = this.connections.getConnection();
             Statement statement = connection.createStatement();){
            connection.executeUpdate(statement, String.format("UPDATE tsk_files SET meta_flags = '%d', dir_flags = '%d'  WHERE obj_id = %d", newMetaFlgs, newDirFlags, file.getId()));
            file.removeMetaFlag(TskData.TSK_FS_META_FLAG_ENUM.ALLOC);
            file.setMetaFlag(TskData.TSK_FS_META_FLAG_ENUM.UNALLOC);
            file.setDirFlag(TskData.TSK_FS_NAME_FLAG_ENUM.UNALLOC);
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error setting unalloc meta flag for file (obj_id = %s)", file.getId()), ex);
        }
        finally {
            this.releaseSingleUserCaseWriteLock();
        }
    }

    void setMd5Hash(AbstractFile file, String md5Hash) throws TskCoreException {
        if (md5Hash == null) {
            return;
        }
        long id = file.getId();
        this.acquireSingleUserCaseWriteLock();
        try (CaseDbConnection connection = this.connections.getConnection();){
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.UPDATE_FILE_MD5);
            statement.clearParameters();
            statement.setString(1, md5Hash.toLowerCase());
            statement.setLong(2, id);
            connection.executeUpdate(statement);
            file.setMd5Hash(md5Hash.toLowerCase());
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error setting MD5 hash", ex);
        }
        finally {
            this.releaseSingleUserCaseWriteLock();
        }
    }

    void setMd5ImageHash(Image img, String md5Hash) throws TskCoreException {
        if (md5Hash == null) {
            return;
        }
        long id = img.getId();
        this.acquireSingleUserCaseWriteLock();
        try (CaseDbConnection connection = this.connections.getConnection();){
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.UPDATE_IMAGE_MD5);
            statement.clearParameters();
            statement.setString(1, md5Hash.toLowerCase());
            statement.setLong(2, id);
            connection.executeUpdate(statement);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error setting MD5 hash", ex);
        }
        finally {
            this.releaseSingleUserCaseWriteLock();
        }
    }

    String getMd5ImageHash(Image img) throws TskCoreException {
        String string;
        long id = img.getId();
        CaseDbConnection connection = null;
        ResultSet rs = null;
        String hash = "";
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_IMAGE_MD5);
            statement.clearParameters();
            statement.setLong(1, id);
            rs = connection.executeQuery(statement);
            if (rs.next()) {
                hash = rs.getString("md5");
            }
            string = hash;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting MD5 hash", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return string;
    }

    void setSha1ImageHash(Image img, String sha1Hash) throws TskCoreException {
        if (sha1Hash == null) {
            return;
        }
        long id = img.getId();
        this.acquireSingleUserCaseWriteLock();
        try (CaseDbConnection connection = this.connections.getConnection();){
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.UPDATE_IMAGE_SHA1);
            statement.clearParameters();
            statement.setString(1, sha1Hash.toLowerCase());
            statement.setLong(2, id);
            connection.executeUpdate(statement);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error setting SHA1 hash", ex);
        }
        finally {
            this.releaseSingleUserCaseWriteLock();
        }
    }

    String getSha1ImageHash(Image img) throws TskCoreException {
        String string;
        long id = img.getId();
        CaseDbConnection connection = null;
        ResultSet rs = null;
        String hash = "";
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_IMAGE_SHA1);
            statement.clearParameters();
            statement.setLong(1, id);
            rs = connection.executeQuery(statement);
            if (rs.next()) {
                hash = rs.getString("sha1");
            }
            string = hash;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting SHA1 hash", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return string;
    }

    void setSha256ImageHash(Image img, String sha256Hash) throws TskCoreException {
        if (sha256Hash == null) {
            return;
        }
        long id = img.getId();
        this.acquireSingleUserCaseWriteLock();
        try (CaseDbConnection connection = this.connections.getConnection();){
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.UPDATE_IMAGE_SHA256);
            statement.clearParameters();
            statement.setString(1, sha256Hash.toLowerCase());
            statement.setLong(2, id);
            connection.executeUpdate(statement);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error setting SHA256 hash", ex);
        }
        finally {
            this.releaseSingleUserCaseWriteLock();
        }
    }

    String getSha256ImageHash(Image img) throws TskCoreException {
        String string;
        long id = img.getId();
        CaseDbConnection connection = null;
        ResultSet rs = null;
        String hash = "";
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_IMAGE_SHA256);
            statement.clearParameters();
            statement.setLong(1, id);
            rs = connection.executeQuery(statement);
            if (rs.next()) {
                hash = rs.getString("sha256");
            }
            string = hash;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error setting SHA256 hash", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return string;
    }

    void setAcquisitionDetails(DataSource datasource, String details) throws TskCoreException {
        long id = datasource.getId();
        this.acquireSingleUserCaseWriteLock();
        try (CaseDbConnection connection = this.connections.getConnection();){
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.UPDATE_ACQUISITION_DETAILS);
            statement.clearParameters();
            statement.setString(1, details);
            statement.setLong(2, id);
            connection.executeUpdate(statement);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error setting acquisition details", ex);
        }
        finally {
            this.releaseSingleUserCaseWriteLock();
        }
    }

    void setAcquisitionToolDetails(DataSource datasource, String name, String version, String settings) throws TskCoreException {
        long id = datasource.getId();
        this.acquireSingleUserCaseWriteLock();
        try (CaseDbConnection connection = this.connections.getConnection();){
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.UPDATE_ACQUISITION_TOOL_SETTINGS);
            statement.clearParameters();
            statement.setString(1, settings);
            statement.setString(2, name);
            statement.setString(3, version);
            statement.setLong(4, id);
            connection.executeUpdate(statement);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error setting acquisition details", ex);
        }
        finally {
            this.releaseSingleUserCaseWriteLock();
        }
    }

    void setAcquisitionDetails(long dataSourceId, String details, CaseDbTransaction trans) throws TskCoreException {
        try {
            CaseDbConnection connection = trans.getConnection();
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.UPDATE_ACQUISITION_DETAILS);
            statement.clearParameters();
            statement.setString(1, details);
            statement.setLong(2, dataSourceId);
            connection.executeUpdate(statement);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error setting acquisition details", ex);
        }
    }

    String getAcquisitionDetails(DataSource datasource) throws TskCoreException {
        String string;
        long id = datasource.getId();
        CaseDbConnection connection = null;
        ResultSet rs = null;
        String hash = "";
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_ACQUISITION_DETAILS);
            statement.clearParameters();
            statement.setLong(1, id);
            rs = connection.executeQuery(statement);
            if (rs.next()) {
                hash = rs.getString("acquisition_details");
            }
            string = hash;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error setting acquisition details", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return string;
    }

    String getDataSourceInfoString(DataSource datasource, String columnName) throws TskCoreException {
        String string;
        long id = datasource.getId();
        CaseDbConnection connection = null;
        ResultSet rs = null;
        String returnValue = "";
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_ACQUISITION_TOOL_SETTINGS);
            statement.clearParameters();
            statement.setLong(1, id);
            rs = connection.executeQuery(statement);
            if (rs.next()) {
                returnValue = rs.getString(columnName);
            }
            string = returnValue;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error setting acquisition details", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return string;
    }

    Long getDataSourceInfoLong(DataSource datasource, String columnName) throws TskCoreException {
        Long l;
        long id = datasource.getId();
        CaseDbConnection connection = null;
        ResultSet rs = null;
        Long returnValue = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_ACQUISITION_TOOL_SETTINGS);
            statement.clearParameters();
            statement.setLong(1, id);
            rs = connection.executeQuery(statement);
            if (rs.next()) {
                returnValue = rs.getLong(columnName);
            }
            l = returnValue;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error setting acquisition details", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return l;
    }

    public void setReviewStatus(BlackboardArtifact artifact, BlackboardArtifact.ReviewStatus newStatus) throws TskCoreException {
        if (newStatus == null) {
            return;
        }
        this.acquireSingleUserCaseWriteLock();
        try (CaseDbConnection connection = this.connections.getConnection();
             Statement statement = connection.createStatement();){
            connection.executeUpdate(statement, "UPDATE blackboard_artifacts  SET review_status_id=" + newStatus.getID() + " WHERE blackboard_artifacts.artifact_id = " + artifact.getArtifactID());
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error setting review status", ex);
        }
        finally {
            this.releaseSingleUserCaseWriteLock();
        }
    }

    public int countFsContentType(TskData.TSK_FS_META_TYPE_ENUM contentType) throws TskCoreException {
        int n;
        CaseDbConnection connection = null;
        Statement s = null;
        ResultSet rs = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            s = connection.createStatement();
            Short contentShort = contentType.getValue();
            rs = connection.executeQuery(s, "SELECT COUNT(*) AS count FROM tsk_files WHERE meta_type = '" + contentShort.toString() + "'");
            int count = 0;
            if (rs.next()) {
                count = rs.getInt("count");
            }
            n = count;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting number of objects.", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return n;
    }

    public static String escapeSingleQuotes(String text) {
        String escapedText = null;
        if (text != null) {
            escapedText = text.replaceAll("'", "''");
        }
        return escapedText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<AbstractFile> findFilesByMd5(String md5Hash) {
        List<AbstractFile> list;
        if (md5Hash == null) {
            return Collections.emptyList();
        }
        CaseDbConnection connection = null;
        Statement s = null;
        ResultSet rs = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT * FROM tsk_files WHERE  md5 = '" + md5Hash.toLowerCase() + "' AND size > 0");
            list = this.resultSetToAbstractFiles(rs, connection);
        }
        catch (SQLException | TskCoreException ex) {
            try {
                logger.log(Level.WARNING, "Error querying database.", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
            SleuthkitCase.closeResultSet(rs);
            SleuthkitCase.closeStatement(s);
            SleuthkitCase.closeConnection(connection);
            this.releaseSingleUserCaseReadLock();
            return Collections.emptyList();
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allFilesMd5Hashed() {
        ResultSet rs;
        Statement s;
        CaseDbConnection connection;
        boolean allFilesAreHashed;
        block4: {
            allFilesAreHashed = false;
            connection = null;
            s = null;
            rs = null;
            this.acquireSingleUserCaseReadLock();
            try {
                connection = this.connections.getConnection();
                s = connection.createStatement();
                rs = connection.executeQuery(s, "SELECT COUNT(*) AS count FROM tsk_files WHERE dir_type = '" + TskData.TSK_FS_NAME_TYPE_ENUM.REG.getValue() + "' AND md5 IS NULL AND size > '0'");
                if (!rs.next() || rs.getInt("count") != 0) break block4;
                allFilesAreHashed = true;
            }
            catch (SQLException | TskCoreException ex) {
                try {
                    logger.log(Level.WARNING, "Failed to query whether all files have MD5 hashes", ex);
                }
                catch (Throwable throwable) {
                    SleuthkitCase.closeResultSet(rs);
                    SleuthkitCase.closeStatement(s);
                    SleuthkitCase.closeConnection(connection);
                    this.releaseSingleUserCaseReadLock();
                    throw throwable;
                }
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return allFilesAreHashed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countFilesMd5Hashed() {
        ResultSet rs;
        Statement s;
        CaseDbConnection connection;
        int count;
        block4: {
            count = 0;
            this.acquireSingleUserCaseReadLock();
            connection = null;
            s = null;
            rs = null;
            try {
                connection = this.connections.getConnection();
                s = connection.createStatement();
                rs = connection.executeQuery(s, "SELECT COUNT(*) AS count FROM tsk_files WHERE md5 IS NOT NULL AND size > '0'");
                if (!rs.next()) break block4;
                count = rs.getInt("count");
            }
            catch (SQLException | TskCoreException ex) {
                try {
                    logger.log(Level.WARNING, "Failed to query for all the files.", ex);
                }
                catch (Throwable throwable) {
                    SleuthkitCase.closeResultSet(rs);
                    SleuthkitCase.closeStatement(s);
                    SleuthkitCase.closeConnection(connection);
                    this.releaseSingleUserCaseReadLock();
                    throw throwable;
                }
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return count;
    }

    public List<TagName> getAllTagNames() throws TskCoreException {
        ArrayList<TagName> arrayList;
        CaseDbConnection connection = null;
        ResultSet resultSet = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_TAG_NAMES);
            resultSet = connection.executeQuery(statement);
            ArrayList<TagName> tagNames = new ArrayList<TagName>();
            while (resultSet.next()) {
                tagNames.add(new TagName(resultSet.getLong("tag_name_id"), resultSet.getString("display_name"), resultSet.getString("description"), TagName.HTML_COLOR.getColorByName(resultSet.getString("color")), TskData.TagType.valueOf(resultSet.getByte("knownStatus")), resultSet.getLong("tag_set_id"), resultSet.getInt("rank")));
            }
            arrayList = tagNames;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error selecting rows from tag_names table", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public List<TagName> getTagNamesInUse() throws TskCoreException {
        ArrayList<TagName> arrayList;
        CaseDbConnection connection = null;
        ResultSet resultSet = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_TAG_NAMES_IN_USE);
            resultSet = connection.executeQuery(statement);
            ArrayList<TagName> tagNames = new ArrayList<TagName>();
            while (resultSet.next()) {
                tagNames.add(new TagName(resultSet.getLong("tag_name_id"), resultSet.getString("display_name"), resultSet.getString("description"), TagName.HTML_COLOR.getColorByName(resultSet.getString("color")), TskData.TagType.valueOf(resultSet.getByte("knownStatus")), resultSet.getLong("tag_set_id"), resultSet.getInt("rank")));
            }
            arrayList = tagNames;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error selecting rows from tag_names table", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public List<TagName> getTagNamesInUse(long dsObjId) throws TskCoreException {
        ArrayList<TagName> arrayList;
        ArrayList<TagName> tagNames = new ArrayList<TagName>();
        CaseDbConnection connection = null;
        ResultSet resultSet = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_TAG_NAMES_IN_USE_BY_DATASOURCE);
            statement.setLong(1, dsObjId);
            statement.setLong(2, dsObjId);
            resultSet = connection.executeQuery(statement);
            while (resultSet.next()) {
                tagNames.add(new TagName(resultSet.getLong("tag_name_id"), resultSet.getString("display_name"), resultSet.getString("description"), TagName.HTML_COLOR.getColorByName(resultSet.getString("color")), TskData.TagType.valueOf(resultSet.getByte("knownStatus")), resultSet.getLong("tag_set_id"), resultSet.getInt("rank")));
            }
            arrayList = tagNames;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Failed to get tag names in use for data source objID : " + dsObjId, ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    @Deprecated
    public TagName addTagName(String displayName, String description, TagName.HTML_COLOR color) throws TskCoreException {
        return this.addOrUpdateTagName(displayName, description, color, TskData.FileKnown.UNKNOWN);
    }

    @Deprecated
    public TagName addOrUpdateTagName(String displayName, String description, TagName.HTML_COLOR color, TskData.FileKnown knownStatus) throws TskCoreException {
        return this.getTaggingManager().addOrUpdateTagName(displayName, description, color, knownStatus);
    }

    @Deprecated
    public ContentTag addContentTag(Content content, TagName tagName, String comment, long beginByteOffset, long endByteOffset) throws TskCoreException {
        return this.taggingMgr.addContentTag(content, tagName, comment, beginByteOffset, endByteOffset).getAddedTag();
    }

    public void deleteContentTag(ContentTag tag) throws TskCoreException {
        CaseDbTransaction trans = this.beginTransaction();
        try {
            PreparedStatement statement = trans.getConnection().getPreparedStatement(PREPARED_STATEMENT.DELETE_CONTENT_TAG);
            statement.clearParameters();
            statement.setLong(1, tag.getId());
            trans.getConnection().executeUpdate(statement);
            Long contentId = tag.getContent() != null ? Long.valueOf(tag.getContent().getId()) : null;
            Long dataSourceId = tag.getContent() != null && tag.getContent().getDataSource() != null ? Long.valueOf(tag.getContent().getDataSource().getId()) : null;
            this.getScoringManager().updateAggregateScoreAfterDeletion(contentId, dataSourceId, trans);
            trans.commit();
            trans = null;
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error deleting row from content_tags table (id = " + tag.getId() + ")", ex);
        }
        finally {
            if (trans != null) {
                trans.rollback();
            }
        }
    }

    public List<ContentTag> getAllContentTags() throws TskCoreException {
        ArrayList<ContentTag> arrayList;
        CaseDbConnection connection = null;
        ResultSet resultSet = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_CONTENT_TAGS);
            resultSet = connection.executeQuery(statement);
            ArrayList<ContentTag> tags = new ArrayList<ContentTag>();
            while (resultSet.next()) {
                TagName tagName = new TagName(resultSet.getLong("tag_name_id"), resultSet.getString("display_name"), resultSet.getString("description"), TagName.HTML_COLOR.getColorByName(resultSet.getString("color")), TskData.TagType.valueOf(resultSet.getByte("knownStatus")), resultSet.getLong("tag_set_id"), resultSet.getInt("rank"));
                Content content = this.getContentById(resultSet.getLong("obj_id"));
                tags.add(new ContentTag(resultSet.getLong("tag_id"), content, tagName, resultSet.getString("comment"), resultSet.getLong("begin_byte_offset"), resultSet.getLong("end_byte_offset"), resultSet.getString("login_name")));
            }
            arrayList = tags;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error selecting rows from content_tags table", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public long getContentTagsCountByTagName(TagName tagName) throws TskCoreException {
        ResultSet resultSet;
        CaseDbConnection connection;
        block6: {
            if (tagName.getId() == Tag.ID_NOT_SET) {
                throw new TskCoreException("TagName object is invalid, id not set");
            }
            connection = null;
            resultSet = null;
            this.acquireSingleUserCaseReadLock();
            connection = this.connections.getConnection();
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.COUNT_CONTENT_TAGS_BY_TAG_NAME);
            statement.clearParameters();
            statement.setLong(1, tagName.getId());
            resultSet = connection.executeQuery(statement);
            if (!resultSet.next()) break block6;
            long l = resultSet.getLong("count");
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeConnection(connection);
            this.releaseSingleUserCaseReadLock();
            return l;
        }
        try {
            try {
                throw new TskCoreException("Error getting content_tags row count for tag name (tag_name_id = " + tagName.getId() + ")");
            }
            catch (SQLException ex) {
                throw new TskCoreException("Error getting content_tags row count for tag name (tag_name_id = " + tagName.getId() + ")", ex);
            }
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeConnection(connection);
            this.releaseSingleUserCaseReadLock();
            throw throwable;
        }
    }

    public long getContentTagsCountByTagName(TagName tagName, long dsObjId) throws TskCoreException {
        ResultSet resultSet;
        CaseDbConnection connection;
        block6: {
            if (tagName.getId() == Tag.ID_NOT_SET) {
                throw new TskCoreException("TagName object is invalid, id not set");
            }
            connection = null;
            resultSet = null;
            this.acquireSingleUserCaseReadLock();
            connection = this.connections.getConnection();
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.COUNT_CONTENT_TAGS_BY_TAG_NAME_BY_DATASOURCE);
            statement.clearParameters();
            statement.setLong(1, tagName.getId());
            statement.setLong(2, dsObjId);
            resultSet = connection.executeQuery(statement);
            if (!resultSet.next()) break block6;
            long l = resultSet.getLong("count");
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeConnection(connection);
            this.releaseSingleUserCaseReadLock();
            return l;
        }
        try {
            try {
                throw new TskCoreException("Error getting content_tags row count for tag name (tag_name_id = " + tagName.getId() + ") for dsObjId = " + dsObjId);
            }
            catch (SQLException ex) {
                throw new TskCoreException("Failed to get content_tags row count for  tag_name_id = " + tagName.getId() + "data source objID : " + dsObjId, ex);
            }
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeConnection(connection);
            this.releaseSingleUserCaseReadLock();
            throw throwable;
        }
    }

    public ContentTag getContentTagByID(long contentTagID) throws TskCoreException {
        CaseDbConnection connection = null;
        ResultSet resultSet = null;
        ContentTag tag = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_CONTENT_TAG_BY_ID);
            statement.clearParameters();
            statement.setLong(1, contentTagID);
            resultSet = connection.executeQuery(statement);
            while (resultSet.next()) {
                TagName tagName = new TagName(resultSet.getLong("tag_name_id"), resultSet.getString("display_name"), resultSet.getString("description"), TagName.HTML_COLOR.getColorByName(resultSet.getString("color")), TskData.TagType.valueOf(resultSet.getByte("knownStatus")), resultSet.getLong("tag_set_id"), resultSet.getInt("rank"));
                tag = new ContentTag(resultSet.getLong("tag_id"), this.getContentById(resultSet.getLong("obj_id")), tagName, resultSet.getString("comment"), resultSet.getLong("begin_byte_offset"), resultSet.getLong("end_byte_offset"), resultSet.getString("login_name"));
            }
            resultSet.close();
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting content tag with id = " + contentTagID, ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return tag;
    }

    public List<ContentTag> getContentTagsByTagName(TagName tagName) throws TskCoreException {
        ArrayList<ContentTag> arrayList;
        if (tagName.getId() == Tag.ID_NOT_SET) {
            throw new TskCoreException("TagName object is invalid, id not set");
        }
        CaseDbConnection connection = null;
        ResultSet resultSet = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_CONTENT_TAGS_BY_TAG_NAME);
            statement.clearParameters();
            statement.setLong(1, tagName.getId());
            resultSet = connection.executeQuery(statement);
            ArrayList<ContentTag> tags = new ArrayList<ContentTag>();
            while (resultSet.next()) {
                ContentTag tag = new ContentTag(resultSet.getLong("tag_id"), this.getContentById(resultSet.getLong("obj_id")), tagName, resultSet.getString("comment"), resultSet.getLong("begin_byte_offset"), resultSet.getLong("end_byte_offset"), resultSet.getString("login_name"));
                tags.add(tag);
            }
            resultSet.close();
            arrayList = tags;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting content_tags rows (tag_name_id = " + tagName.getId() + ")", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public List<ContentTag> getContentTagsByTagName(TagName tagName, long dsObjId) throws TskCoreException {
        ArrayList<ContentTag> arrayList;
        CaseDbConnection connection = null;
        ResultSet resultSet = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_CONTENT_TAGS_BY_TAG_NAME_BY_DATASOURCE);
            statement.clearParameters();
            statement.setLong(1, tagName.getId());
            statement.setLong(2, dsObjId);
            statement.setLong(3, tagName.getId());
            statement.setLong(4, dsObjId);
            resultSet = connection.executeQuery(statement);
            ArrayList<ContentTag> tags = new ArrayList<ContentTag>();
            while (resultSet.next()) {
                ContentTag tag = new ContentTag(resultSet.getLong("tag_id"), this.getContentById(resultSet.getLong("obj_id")), tagName, resultSet.getString("comment"), resultSet.getLong("begin_byte_offset"), resultSet.getLong("end_byte_offset"), resultSet.getString("login_name"));
                tags.add(tag);
            }
            resultSet.close();
            arrayList = tags;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Failed to get content_tags row count for  tag_name_id = " + tagName.getId() + " data source objID : " + dsObjId, ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public List<ContentTag> getContentTagsByContent(Content content) throws TskCoreException {
        ArrayList<ContentTag> arrayList;
        CaseDbConnection connection = null;
        ResultSet resultSet = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_CONTENT_TAGS_BY_CONTENT);
            statement.clearParameters();
            statement.setLong(1, content.getId());
            resultSet = connection.executeQuery(statement);
            ArrayList<ContentTag> tags = new ArrayList<ContentTag>();
            while (resultSet.next()) {
                TagName tagName = new TagName(resultSet.getLong("tag_name_id"), resultSet.getString("display_name"), resultSet.getString("description"), TagName.HTML_COLOR.getColorByName(resultSet.getString("color")), TskData.TagType.valueOf(resultSet.getByte("knownStatus")), resultSet.getLong("tag_set_id"), resultSet.getInt("rank"));
                ContentTag tag = new ContentTag(resultSet.getLong("tag_id"), content, tagName, resultSet.getString("comment"), resultSet.getLong("begin_byte_offset"), resultSet.getLong("end_byte_offset"), resultSet.getString("login_name"));
                tags.add(tag);
            }
            arrayList = tags;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting content tags data for content (obj_id = " + content.getId() + ")", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    @Deprecated
    public BlackboardArtifactTag addBlackboardArtifactTag(BlackboardArtifact artifact, TagName tagName, String comment) throws TskCoreException {
        return this.taggingMgr.addArtifactTag(artifact, tagName, comment).getAddedTag();
    }

    public void deleteBlackboardArtifactTag(BlackboardArtifactTag tag) throws TskCoreException {
        CaseDbTransaction trans = this.beginTransaction();
        try {
            PreparedStatement statement = trans.getConnection().getPreparedStatement(PREPARED_STATEMENT.DELETE_ARTIFACT_TAG);
            statement.clearParameters();
            statement.setLong(1, tag.getId());
            trans.getConnection().executeUpdate(statement);
            Long artifactObjId = tag.getArtifact().getId();
            Long dataSourceId = tag.getContent() != null && tag.getContent().getDataSource() != null ? Long.valueOf(tag.getContent().getDataSource().getId()) : null;
            this.getScoringManager().updateAggregateScoreAfterDeletion(artifactObjId, dataSourceId, trans);
            trans.commit();
            trans = null;
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error deleting row from blackboard_artifact_tags table (id = " + tag.getId() + ")", ex);
        }
        finally {
            if (trans != null) {
                trans.rollback();
            }
        }
    }

    public List<BlackboardArtifactTag> getAllBlackboardArtifactTags() throws TskCoreException {
        ArrayList<BlackboardArtifactTag> arrayList;
        CaseDbConnection connection = null;
        ResultSet resultSet = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_ARTIFACT_TAGS);
            resultSet = connection.executeQuery(statement);
            ArrayList<BlackboardArtifactTag> tags = new ArrayList<BlackboardArtifactTag>();
            while (resultSet.next()) {
                TagName tagName = new TagName(resultSet.getLong("tag_name_id"), resultSet.getString("display_name"), resultSet.getString("description"), TagName.HTML_COLOR.getColorByName(resultSet.getString("color")), TskData.TagType.valueOf(resultSet.getByte("knownStatus")), resultSet.getLong("tag_set_id"), resultSet.getInt("rank"));
                BlackboardArtifact artifact = this.getBlackboardArtifact(resultSet.getLong("artifact_id"));
                Content content = this.getContentById(artifact.getObjectID());
                BlackboardArtifactTag tag = new BlackboardArtifactTag(resultSet.getLong("tag_id"), artifact, content, tagName, resultSet.getString("comment"), resultSet.getString("login_name"));
                tags.add(tag);
            }
            arrayList = tags;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error selecting rows from blackboard_artifact_tags table", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public long getBlackboardArtifactTagsCountByTagName(TagName tagName) throws TskCoreException {
        ResultSet resultSet;
        CaseDbConnection connection;
        block6: {
            if (tagName.getId() == Tag.ID_NOT_SET) {
                throw new TskCoreException("TagName object is invalid, id not set");
            }
            connection = null;
            resultSet = null;
            this.acquireSingleUserCaseReadLock();
            connection = this.connections.getConnection();
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.COUNT_ARTIFACTS_BY_TAG_NAME);
            statement.clearParameters();
            statement.setLong(1, tagName.getId());
            resultSet = connection.executeQuery(statement);
            if (!resultSet.next()) break block6;
            long l = resultSet.getLong("count");
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeConnection(connection);
            this.releaseSingleUserCaseReadLock();
            return l;
        }
        try {
            try {
                throw new TskCoreException("Error getting blackboard_artifact_tags row count for tag name (tag_name_id = " + tagName.getId() + ")");
            }
            catch (SQLException ex) {
                throw new TskCoreException("Error getting blackboard artifact_content_tags row count for tag name (tag_name_id = " + tagName.getId() + ")", ex);
            }
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeConnection(connection);
            this.releaseSingleUserCaseReadLock();
            throw throwable;
        }
    }

    public long getBlackboardArtifactTagsCountByTagName(TagName tagName, long dsObjId) throws TskCoreException {
        ResultSet resultSet;
        CaseDbConnection connection;
        block6: {
            if (tagName.getId() == Tag.ID_NOT_SET) {
                throw new TskCoreException("TagName object is invalid, id not set");
            }
            connection = null;
            resultSet = null;
            this.acquireSingleUserCaseReadLock();
            connection = this.connections.getConnection();
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.COUNT_ARTIFACTS_BY_TAG_NAME_BY_DATASOURCE);
            statement.clearParameters();
            statement.setLong(1, tagName.getId());
            statement.setLong(2, dsObjId);
            resultSet = connection.executeQuery(statement);
            if (!resultSet.next()) break block6;
            long l = resultSet.getLong("count");
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeConnection(connection);
            this.releaseSingleUserCaseReadLock();
            return l;
        }
        try {
            try {
                throw new TskCoreException("Error getting blackboard_artifact_tags row count for tag name (tag_name_id = " + tagName.getId() + ") for dsObjId = " + dsObjId);
            }
            catch (SQLException ex) {
                throw new TskCoreException("Failed to get blackboard_artifact_tags row count for  tag_name_id = " + tagName.getId() + "data source objID : " + dsObjId, ex);
            }
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeConnection(connection);
            this.releaseSingleUserCaseReadLock();
            throw throwable;
        }
    }

    public List<BlackboardArtifactTag> getBlackboardArtifactTagsByTagName(TagName tagName) throws TskCoreException {
        ArrayList<BlackboardArtifactTag> arrayList;
        if (tagName.getId() == Tag.ID_NOT_SET) {
            throw new TskCoreException("TagName object is invalid, id not set");
        }
        CaseDbConnection connection = null;
        ResultSet resultSet = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_ARTIFACT_TAGS_BY_TAG_NAME);
            statement.clearParameters();
            statement.setLong(1, tagName.getId());
            resultSet = connection.executeQuery(statement);
            ArrayList<BlackboardArtifactTag> tags = new ArrayList<BlackboardArtifactTag>();
            while (resultSet.next()) {
                BlackboardArtifact artifact = this.getBlackboardArtifact(resultSet.getLong("artifact_id"));
                Content content = this.getContentById(artifact.getObjectID());
                BlackboardArtifactTag tag = new BlackboardArtifactTag(resultSet.getLong("tag_id"), artifact, content, tagName, resultSet.getString("comment"), resultSet.getString("login_name"));
                tags.add(tag);
            }
            arrayList = tags;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting blackboard artifact tags data (tag_name_id = " + tagName.getId() + ")", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public List<BlackboardArtifactTag> getBlackboardArtifactTagsByTagName(TagName tagName, long dsObjId) throws TskCoreException {
        ArrayList<BlackboardArtifactTag> arrayList;
        if (tagName.getId() == Tag.ID_NOT_SET) {
            throw new TskCoreException("TagName object is invalid, id not set");
        }
        CaseDbConnection connection = null;
        ResultSet resultSet = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_ARTIFACT_TAGS_BY_TAG_NAME_BY_DATASOURCE);
            statement.clearParameters();
            statement.setLong(1, tagName.getId());
            statement.setLong(2, dsObjId);
            resultSet = connection.executeQuery(statement);
            ArrayList<BlackboardArtifactTag> tags = new ArrayList<BlackboardArtifactTag>();
            while (resultSet.next()) {
                BlackboardArtifact artifact = this.getBlackboardArtifact(resultSet.getLong("artifact_id"));
                Content content = this.getContentById(artifact.getObjectID());
                BlackboardArtifactTag tag = new BlackboardArtifactTag(resultSet.getLong("tag_id"), artifact, content, tagName, resultSet.getString("comment"), resultSet.getString("login_name"));
                tags.add(tag);
            }
            arrayList = tags;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Failed to get blackboard_artifact_tags row count for  tag_name_id = " + tagName.getId() + "data source objID : " + dsObjId, ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public BlackboardArtifactTag getBlackboardArtifactTagByID(long artifactTagID) throws TskCoreException {
        CaseDbConnection connection = null;
        ResultSet resultSet = null;
        BlackboardArtifactTag tag = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_ARTIFACT_TAG_BY_ID);
            statement.clearParameters();
            statement.setLong(1, artifactTagID);
            resultSet = connection.executeQuery(statement);
            while (resultSet.next()) {
                TagName tagName = new TagName(resultSet.getLong("tag_name_id"), resultSet.getString("display_name"), resultSet.getString("description"), TagName.HTML_COLOR.getColorByName(resultSet.getString("color")), TskData.TagType.valueOf(resultSet.getByte("knownStatus")), resultSet.getLong("tag_set_id"), resultSet.getInt("rank"));
                BlackboardArtifact artifact = this.getBlackboardArtifact(resultSet.getLong("artifact_id"));
                Content content = this.getContentById(artifact.getObjectID());
                tag = new BlackboardArtifactTag(resultSet.getLong("tag_id"), artifact, content, tagName, resultSet.getString("comment"), resultSet.getString("login_name"));
            }
            resultSet.close();
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting blackboard artifact tag with id = " + artifactTagID, ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return tag;
    }

    public List<BlackboardArtifactTag> getBlackboardArtifactTagsByArtifact(BlackboardArtifact artifact) throws TskCoreException {
        ArrayList<BlackboardArtifactTag> arrayList;
        CaseDbConnection connection = null;
        ResultSet resultSet = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_ARTIFACT_TAGS_BY_ARTIFACT);
            statement.clearParameters();
            statement.setLong(1, artifact.getArtifactID());
            resultSet = connection.executeQuery(statement);
            ArrayList<BlackboardArtifactTag> tags = new ArrayList<BlackboardArtifactTag>();
            while (resultSet.next()) {
                TagName tagName = new TagName(resultSet.getLong("tag_name_id"), resultSet.getString("display_name"), resultSet.getString("description"), TagName.HTML_COLOR.getColorByName(resultSet.getString("color")), TskData.TagType.valueOf(resultSet.getByte("knownStatus")), resultSet.getLong("tag_set_id"), resultSet.getInt("rank"));
                Content content = this.getContentById(artifact.getObjectID());
                BlackboardArtifactTag tag = new BlackboardArtifactTag(resultSet.getLong("tag_id"), artifact, content, tagName, resultSet.getString("comment"), resultSet.getString("login_name"));
                tags.add(tag);
            }
            arrayList = tags;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting blackboard artifact tags data (artifact_id = " + artifact.getArtifactID() + ")", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public void updateImagePath(String newPath, long objectId) throws TskCoreException {
        this.acquireSingleUserCaseWriteLock();
        try (CaseDbConnection connection = this.connections.getConnection();){
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.UPDATE_IMAGE_PATH);
            statement.clearParameters();
            statement.setString(1, newPath);
            statement.setLong(2, objectId);
            connection.executeUpdate(statement);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error updating image path in database for object " + objectId, ex);
        }
        finally {
            this.releaseSingleUserCaseWriteLock();
        }
    }

    public Report addReport(String localPath, String sourceModuleName, String reportName) throws TskCoreException {
        return this.addReport(localPath, sourceModuleName, reportName, null);
    }

    public Report addReport(String localPath, String sourceModuleName, String reportName, Content parent) throws TskCoreException {
        String relativePath = "";
        long createTime = 0L;
        String localPathLower = localPath.toLowerCase();
        if (localPathLower.startsWith("http")) {
            relativePath = localPathLower;
            createTime = System.currentTimeMillis() / 1000L;
        } else {
            try {
                String casePathLower = this.getDbDirPath().toLowerCase();
                int length = new java.io.File(casePathLower).toURI().relativize(new java.io.File(localPathLower).toURI()).getPath().length();
                relativePath = new java.io.File(localPath.substring(localPathLower.length() - length)).getPath();
            }
            catch (IllegalArgumentException ex) {
                String errorMessage = String.format("Local path %s not in the database directory or one of its subdirectories", localPath);
                throw new TskCoreException(errorMessage, ex);
            }
            try {
                java.io.File tempFile = new java.io.File(localPath);
                createTime = tempFile.lastModified() / 1000L;
            }
            catch (Exception ex) {
                throw new TskCoreException("Could not get create time for report at " + localPath, ex);
            }
        }
        this.acquireSingleUserCaseWriteLock();
        try {
            CaseDbConnection connection = this.connections.getConnection();
            try {
                long parentObjId = 0L;
                if (parent != null) {
                    parentObjId = parent.getId();
                }
                long objectId = this.addObject(parentObjId, TskData.ObjectType.REPORT.getObjectType(), connection);
                PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_REPORT);
                statement.clearParameters();
                statement.setLong(1, objectId);
                statement.setString(2, relativePath);
                statement.setLong(3, createTime);
                statement.setString(4, sourceModuleName);
                statement.setString(5, reportName);
                connection.executeUpdate(statement);
                Report report = new Report(this, objectId, localPath, createTime, sourceModuleName, reportName, parent);
                if (connection != null) {
                    connection.close();
                }
                return report;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new TskCoreException("Error adding report " + localPath + " to reports table", ex);
                }
            }
        }
        finally {
            this.releaseSingleUserCaseWriteLock();
        }
    }

    public List<Report> getAllReports() throws TskCoreException {
        ArrayList<Report> arrayList;
        CaseDbConnection connection = null;
        ResultSet resultSet = null;
        ResultSet parentResultSet = null;
        PreparedStatement statement = null;
        Statement parentStatement = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_REPORTS);
            parentStatement = connection.createStatement();
            resultSet = connection.executeQuery(statement);
            ArrayList<Report> reports = new ArrayList<Report>();
            while (resultSet.next()) {
                String localpath = resultSet.getString("path");
                if (!localpath.toLowerCase().startsWith("http")) {
                    localpath = Paths.get(this.getDbDirPath(), localpath).normalize().toString();
                }
                Content parent = null;
                long reportId = resultSet.getLong("obj_id");
                String parentQuery = String.format("SELECT * FROM tsk_objects WHERE obj_id = %s;", reportId);
                parentResultSet = parentStatement.executeQuery(parentQuery);
                if (parentResultSet.next()) {
                    long parentId = parentResultSet.getLong("par_obj_id");
                    parent = this.getContentById(parentId);
                }
                parentResultSet.close();
                reports.add(new Report(this, reportId, localpath, resultSet.getLong("crtime"), resultSet.getString("src_module_name"), resultSet.getString("report_name"), parent));
            }
            arrayList = reports;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error querying reports table", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeResultSet(parentResultSet);
                SleuthkitCase.closeStatement(statement);
                SleuthkitCase.closeStatement(parentStatement);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeResultSet(parentResultSet);
        SleuthkitCase.closeStatement(statement);
        SleuthkitCase.closeStatement(parentStatement);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    public Report getReportById(long id) throws TskCoreException {
        CaseDbConnection connection = null;
        PreparedStatement statement = null;
        Statement parentStatement = null;
        ResultSet resultSet = null;
        ResultSet parentResultSet = null;
        Report report = null;
        this.acquireSingleUserCaseReadLock();
        try {
            Content parent;
            connection = this.connections.getConnection();
            statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_REPORT_BY_ID);
            parentStatement = connection.createStatement();
            statement.clearParameters();
            statement.setLong(1, id);
            resultSet = connection.executeQuery(statement);
            if (resultSet.next()) {
                parent = null;
                String parentQuery = String.format("SELECT * FROM tsk_objects WHERE obj_id = %s;", id);
                parentResultSet = parentStatement.executeQuery(parentQuery);
                if (parentResultSet.next()) {
                    long parentId = parentResultSet.getLong("par_obj_id");
                    parent = this.getContentById(parentId);
                }
            } else {
                throw new TskCoreException("No report found for id: " + id);
            }
            report = new Report(this, resultSet.getLong("obj_id"), Paths.get(this.getDbDirPath(), resultSet.getString("path")).normalize().toString(), resultSet.getLong("crtime"), resultSet.getString("src_module_name"), resultSet.getString("report_name"), parent);
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error querying reports table for id: " + id, ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeResultSet(parentResultSet);
                SleuthkitCase.closeStatement(statement);
                SleuthkitCase.closeStatement(parentStatement);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeResultSet(parentResultSet);
        SleuthkitCase.closeStatement(statement);
        SleuthkitCase.closeStatement(parentStatement);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return report;
    }

    public void deleteReport(Report report) throws TskCoreException {
        this.acquireSingleUserCaseWriteLock();
        try (CaseDbConnection connection = this.connections.getConnection();){
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.DELETE_REPORT);
            statement.setLong(1, report.getId());
            connection.executeUpdate(statement);
            statement = connection.getPreparedStatement(PREPARED_STATEMENT.DELETE_REPORT_TSK_OBJECT);
            statement.setLong(1, report.getId());
            statement.setLong(2, TskData.ObjectType.REPORT.getObjectType());
            connection.executeUpdate(statement);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error querying reports table", ex);
        }
        finally {
            this.releaseSingleUserCaseWriteLock();
        }
    }

    static void closeResultSet(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException ex) {
                logger.log(Level.SEVERE, "Error closing ResultSet", ex);
            }
        }
    }

    static void closeStatement(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException ex) {
                logger.log(Level.SEVERE, "Error closing Statement", ex);
            }
        }
    }

    static void closeConnection(CaseDbConnection connection) {
        if (connection != null) {
            connection.close();
        }
    }

    private static void rollbackTransaction(CaseDbConnection connection) {
        if (connection != null) {
            connection.rollbackTransaction();
        }
    }

    void setIngestJobEndDateTime(long ingestJobId, long endDateTime) throws TskCoreException {
        this.acquireSingleUserCaseWriteLock();
        try (CaseDbConnection connection = this.connections.getConnection();){
            Statement statement = connection.createStatement();
            statement.executeUpdate("UPDATE ingest_jobs SET end_date_time=" + endDateTime + " WHERE ingest_job_id=" + ingestJobId + ";");
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error updating the end date (ingest_job_id = " + ingestJobId + ".", ex);
        }
        finally {
            this.releaseSingleUserCaseWriteLock();
        }
    }

    void setIngestJobStatus(long ingestJobId, IngestJobInfo.IngestJobStatusType status) throws TskCoreException {
        this.acquireSingleUserCaseWriteLock();
        try (CaseDbConnection connection = this.connections.getConnection();
             Statement statement = connection.createStatement();){
            statement.executeUpdate("UPDATE ingest_jobs SET status_id=" + status.ordinal() + " WHERE ingest_job_id=" + ingestJobId + ";");
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error ingest job status (ingest_job_id = " + ingestJobId + ".", ex);
        }
        finally {
            this.releaseSingleUserCaseWriteLock();
        }
    }

    public final IngestJobInfo addIngestJob(Content dataSource, String hostName, List<IngestModuleInfo> ingestModules, Date jobStart, Date jobEnd, IngestJobInfo.IngestJobStatusType status, String settingsDir) throws TskCoreException {
        IngestJobInfo ingestJobInfo;
        CaseDbConnection connection = null;
        this.acquireSingleUserCaseWriteLock();
        ResultSet resultSet = null;
        try {
            connection = this.connections.getConnection();
            connection.beginTransaction();
            Statement statement = connection.createStatement();
            PreparedStatement insertStatement = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_INGEST_JOB, 1);
            insertStatement.setLong(1, dataSource.getId());
            insertStatement.setString(2, hostName);
            insertStatement.setLong(3, jobStart.getTime());
            insertStatement.setLong(4, jobEnd.getTime());
            insertStatement.setInt(5, status.ordinal());
            insertStatement.setString(6, settingsDir);
            connection.executeUpdate(insertStatement);
            resultSet = insertStatement.getGeneratedKeys();
            resultSet.next();
            long id = resultSet.getLong(1);
            for (int i = 0; i < ingestModules.size(); ++i) {
                IngestModuleInfo ingestModule = ingestModules.get(i);
                statement.executeUpdate("INSERT INTO ingest_job_modules (ingest_job_id, ingest_module_id, pipeline_position) VALUES (" + id + ", " + ingestModule.getIngestModuleId() + ", " + i + ");");
            }
            resultSet.close();
            resultSet = null;
            connection.commitTransaction();
            ingestJobInfo = new IngestJobInfo(id, dataSource.getId(), hostName, jobStart, "", ingestModules, this);
        }
        catch (SQLException ex) {
            try {
                SleuthkitCase.rollbackTransaction(connection);
                throw new TskCoreException("Error adding the ingest job.", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseWriteLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseWriteLock();
        return ingestJobInfo;
    }

    /*
     * Loose catch block
     */
    public final IngestModuleInfo addIngestModule(String displayName, String factoryClassName, IngestModuleInfo.IngestModuleType type, String version) throws TskCoreException {
        IngestModuleInfo insertStatement2222222222;
        String uniqueName;
        Statement statement;
        ResultSet resultSet;
        CaseDbConnection connection;
        block9: {
            connection = null;
            resultSet = null;
            statement = null;
            uniqueName = factoryClassName + "-" + displayName + "-" + version;
            this.acquireSingleUserCaseWriteLock();
            connection = this.connections.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT * FROM ingest_modules WHERE unique_name = '" + uniqueName + "'");
            if (resultSet.next()) break block9;
            resultSet.close();
            resultSet = null;
            PreparedStatement insertStatement2222222222 = connection.getPreparedStatement(PREPARED_STATEMENT.INSERT_INGEST_MODULE, 1);
            insertStatement2222222222.setString(1, displayName);
            insertStatement2222222222.setString(2, uniqueName);
            insertStatement2222222222.setInt(3, type.ordinal());
            insertStatement2222222222.setString(4, version);
            connection.executeUpdate(insertStatement2222222222);
            resultSet = insertStatement2222222222.getGeneratedKeys();
            resultSet.next();
            long id = resultSet.getLong(1);
            resultSet.close();
            resultSet = null;
            IngestModuleInfo ingestModuleInfo = new IngestModuleInfo(id, displayName, uniqueName, type, version);
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeStatement(statement);
            SleuthkitCase.closeConnection(connection);
            this.releaseSingleUserCaseWriteLock();
            return ingestModuleInfo;
        }
        try {
            insertStatement2222222222 = new IngestModuleInfo(resultSet.getInt("ingest_module_id"), resultSet.getString("display_name"), resultSet.getString("unique_name"), IngestModuleInfo.IngestModuleType.fromID(resultSet.getInt("type_id")), resultSet.getString("version"));
        }
        catch (SQLException ex) {
            block10: {
                SleuthkitCase.closeStatement(statement);
                if (connection == null || !(resultSet = (statement = connection.createStatement()).executeQuery("SELECT * FROM ingest_modules WHERE unique_name = '" + uniqueName + "'")).next()) break block10;
                IngestModuleInfo id = new IngestModuleInfo(resultSet.getInt("ingest_module_id"), resultSet.getString("display_name"), uniqueName, IngestModuleInfo.IngestModuleType.fromID(resultSet.getInt("type_id")), resultSet.getString("version"));
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeStatement(statement);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseWriteLock();
                return id;
            }
            try {
                throw new TskCoreException("Couldn't add new module to database.", ex);
                {
                    catch (SQLException ex1) {
                        throw new TskCoreException("Couldn't add new module to database.", ex1);
                    }
                }
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeStatement(statement);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseWriteLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeStatement(statement);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseWriteLock();
        return insertStatement2222222222;
    }

    public final List<IngestJobInfo> getIngestJobs() throws TskCoreException {
        ArrayList<IngestJobInfo> arrayList;
        CaseDbConnection connection = null;
        ResultSet resultSet = null;
        Statement statement = null;
        ArrayList<IngestJobInfo> ingestJobs = new ArrayList<IngestJobInfo>();
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT * FROM ingest_jobs");
            while (resultSet.next()) {
                ingestJobs.add(new IngestJobInfo(resultSet.getInt("ingest_job_id"), resultSet.getLong("obj_id"), resultSet.getString("host_name"), new Date(resultSet.getLong("start_date_time")), new Date(resultSet.getLong("end_date_time")), IngestJobInfo.IngestJobStatusType.fromID(resultSet.getInt("status_id")), resultSet.getString("settings_dir"), this.getIngestModules(resultSet.getInt("ingest_job_id"), connection), this));
            }
            arrayList = ingestJobs;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Couldn't get the ingest jobs.", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(resultSet);
                SleuthkitCase.closeStatement(statement);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeStatement(statement);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IngestModuleInfo> getIngestModules(int ingestJobId, CaseDbConnection connection) throws SQLException {
        ArrayList<IngestModuleInfo> arrayList;
        ResultSet resultSet = null;
        Statement statement = null;
        ArrayList<IngestModuleInfo> ingestModules = new ArrayList<IngestModuleInfo>();
        this.acquireSingleUserCaseReadLock();
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT ingest_job_modules.ingest_module_id AS ingest_module_id, ingest_job_modules.pipeline_position AS pipeline_position, ingest_modules.display_name AS display_name, ingest_modules.unique_name AS unique_name, ingest_modules.type_id AS type_id, ingest_modules.version AS version FROM ingest_job_modules, ingest_modules WHERE ingest_job_modules.ingest_job_id = " + ingestJobId + " AND ingest_modules.ingest_module_id = ingest_job_modules.ingest_module_id ORDER BY (ingest_job_modules.pipeline_position);");
            while (resultSet.next()) {
                ingestModules.add(new IngestModuleInfo(resultSet.getInt("ingest_module_id"), resultSet.getString("display_name"), resultSet.getString("unique_name"), IngestModuleInfo.IngestModuleType.fromID(resultSet.getInt("type_id")), resultSet.getString("version")));
            }
            arrayList = ingestModules;
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(resultSet);
            SleuthkitCase.closeStatement(statement);
            this.releaseSingleUserCaseReadLock();
            throw throwable;
        }
        SleuthkitCase.closeResultSet(resultSet);
        SleuthkitCase.closeStatement(statement);
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    String getInsertOrIgnoreSQL(String sql) {
        switch (this.getDatabaseType()) {
            case POSTGRESQL: {
                return " INSERT " + sql + " ON CONFLICT DO NOTHING ";
            }
            case SQLITE: {
                return " INSERT OR IGNORE " + sql;
            }
        }
        throw new UnsupportedOperationException("Unsupported DB type: " + this.getDatabaseType().name());
    }

    private List<? extends BlackboardArtifact> getArtifactsForValues(BlackboardArtifact.Category category, String dbColumn, List<? extends Number> values, CaseDbConnection connection) throws TskCoreException {
        Object where = "";
        for (Number number : values) {
            if (!((String)where).isEmpty()) {
                where = (String)where + " OR ";
            }
            where = (String)where + dbColumn + " = " + String.valueOf(number);
        }
        if (category == BlackboardArtifact.Category.DATA_ARTIFACT) {
            return this.blackboard.getDataArtifactsWhere((String)where, connection);
        }
        return this.blackboard.getAnalysisResultsWhere((String)where, connection);
    }

    @Deprecated
    public void addErrorObserver(ErrorObserver observer) {
        this.sleuthkitCaseErrorObservers.add(observer);
    }

    @Deprecated
    public void removeErrorObserver(ErrorObserver observer) {
        int i = this.sleuthkitCaseErrorObservers.indexOf(observer);
        if (i >= 0) {
            this.sleuthkitCaseErrorObservers.remove(i);
        }
    }

    @Deprecated
    public void submitError(String context, String errorMessage) {
        for (ErrorObserver observer : this.sleuthkitCaseErrorObservers) {
            if (observer == null) continue;
            try {
                observer.receiveError(context, errorMessage);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Observer client unable to receive message: {0}, {1}", new Object[]{context, errorMessage, ex});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    long getDataSourceObjectId(long objectId) {
        long l;
        CaseDbConnection connection = this.connections.getConnection();
        try {
            l = this.getDataSourceObjectId(connection, objectId);
        }
        catch (Throwable throwable) {
            try {
                SleuthkitCase.closeConnection(connection);
                throw throwable;
            }
            catch (TskCoreException ex) {
                logger.log(Level.SEVERE, "Error getting data source object id for a file", ex);
                return 0L;
            }
        }
        SleuthkitCase.closeConnection(connection);
        return l;
    }

    @Deprecated
    public long getLastObjectId() throws TskCoreException {
        long l;
        CaseDbConnection connection = null;
        ResultSet rs = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            PreparedStatement statement = connection.getPreparedStatement(PREPARED_STATEMENT.SELECT_MAX_OBJECT_ID);
            rs = connection.executeQuery(statement);
            long id = -1L;
            if (rs.next()) {
                id = rs.getLong("max_obj_id");
            }
            l = id;
        }
        catch (SQLException e) {
            try {
                throw new TskCoreException("Error getting last object id", e);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return l;
    }

    @Deprecated
    public List<FsContent> findFilesWhere(String sqlWhereClause) throws TskCoreException {
        ArrayList<FsContent> arrayList;
        CaseDbConnection connection = null;
        Statement s = null;
        ResultSet rs = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT * FROM tsk_files WHERE " + sqlWhereClause);
            ArrayList<FsContent> results = new ArrayList<FsContent>();
            List<AbstractFile> temp = this.resultSetToAbstractFiles(rs, connection);
            for (AbstractFile f : temp) {
                TskData.TSK_DB_FILES_TYPE_ENUM type = f.getType();
                if (!type.equals((Object)TskData.TSK_DB_FILES_TYPE_ENUM.FS)) continue;
                results.add((FsContent)f);
            }
            arrayList = results;
        }
        catch (SQLException e) {
            try {
                throw new TskCoreException("SQLException thrown when calling 'SleuthkitCase.findFilesWhere().", e);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return arrayList;
    }

    /*
     * Exception decompiling
     */
    @Deprecated
    public int getArtifactTypeID(String artifactTypeName) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Deprecated
    public ArrayList<BlackboardArtifact.ARTIFACT_TYPE> getBlackboardArtifactTypes() throws TskCoreException {
        return new ArrayList<BlackboardArtifact.ARTIFACT_TYPE>(Arrays.asList(BlackboardArtifact.ARTIFACT_TYPE.values()));
    }

    @Deprecated
    public int addArtifactType(String artifactTypeName, String displayName) throws TskCoreException {
        try {
            return this.addBlackboardArtifactType(artifactTypeName, displayName).getTypeID();
        }
        catch (TskDataException ex) {
            throw new TskCoreException("Failed to add artifact type.", ex);
        }
    }

    @Deprecated
    public int addAttrType(String attrTypeString, String displayName) throws TskCoreException {
        try {
            return this.addArtifactAttributeType(attrTypeString, BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.STRING, displayName).getTypeID();
        }
        catch (TskDataException ex) {
            throw new TskCoreException("Couldn't add new attribute type");
        }
    }

    @Deprecated
    public int getAttrTypeID(String attrTypeName) throws TskCoreException {
        int n;
        CaseDbConnection connection = null;
        Statement s = null;
        ResultSet rs = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT attribute_type_id FROM blackboard_attribute_types WHERE type_name = '" + attrTypeName + "'");
            int typeId = -1;
            if (rs.next()) {
                typeId = rs.getInt("attribute_type_id");
            }
            n = typeId;
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException("Error getting attribute type id", ex);
            }
            catch (Throwable throwable) {
                SleuthkitCase.closeResultSet(rs);
                SleuthkitCase.closeStatement(s);
                SleuthkitCase.closeConnection(connection);
                this.releaseSingleUserCaseReadLock();
                throw throwable;
            }
        }
        SleuthkitCase.closeResultSet(rs);
        SleuthkitCase.closeStatement(s);
        SleuthkitCase.closeConnection(connection);
        this.releaseSingleUserCaseReadLock();
        return n;
    }

    @Deprecated
    public String getAttrTypeString(int attrTypeID) throws TskCoreException {
        ResultSet rs;
        Statement s;
        CaseDbConnection connection;
        block5: {
            connection = null;
            s = null;
            rs = null;
            this.acquireSingleUserCaseReadLock();
            connection = this.connections.getConnection();
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT type_name FROM blackboard_attribute_types WHERE attribute_type_id = " + attrTypeID);
            if (!rs.next()) break block5;
            String string = rs.getString("type_name");
            SleuthkitCase.closeResultSet(rs);
            SleuthkitCase.closeStatement(s);
            SleuthkitCase.closeConnection(connection);
            this.releaseSingleUserCaseReadLock();
            return string;
        }
        try {
            try {
                throw new TskCoreException("No type with that id");
            }
            catch (SQLException ex) {
                throw new TskCoreException("Error getting or creating a attribute type name", ex);
            }
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(rs);
            SleuthkitCase.closeStatement(s);
            SleuthkitCase.closeConnection(connection);
            this.releaseSingleUserCaseReadLock();
            throw throwable;
        }
    }

    @Deprecated
    public String getAttrTypeDisplayName(int attrTypeID) throws TskCoreException {
        ResultSet rs;
        Statement s;
        CaseDbConnection connection;
        block5: {
            connection = null;
            s = null;
            rs = null;
            this.acquireSingleUserCaseReadLock();
            connection = this.connections.getConnection();
            s = connection.createStatement();
            rs = connection.executeQuery(s, "SELECT display_name FROM blackboard_attribute_types WHERE attribute_type_id = " + attrTypeID);
            if (!rs.next()) break block5;
            String string = rs.getString("display_name");
            SleuthkitCase.closeResultSet(rs);
            SleuthkitCase.closeStatement(s);
            SleuthkitCase.closeConnection(connection);
            this.releaseSingleUserCaseReadLock();
            return string;
        }
        try {
            try {
                throw new TskCoreException("No type with that id");
            }
            catch (SQLException ex) {
                throw new TskCoreException("Error getting or creating a attribute type name", ex);
            }
        }
        catch (Throwable throwable) {
            SleuthkitCase.closeResultSet(rs);
            SleuthkitCase.closeStatement(s);
            SleuthkitCase.closeConnection(connection);
            this.releaseSingleUserCaseReadLock();
            throw throwable;
        }
    }

    @Deprecated
    public ArrayList<BlackboardAttribute.ATTRIBUTE_TYPE> getBlackboardAttributeTypes() throws TskCoreException {
        return new ArrayList<BlackboardAttribute.ATTRIBUTE_TYPE>(Arrays.asList(BlackboardAttribute.ATTRIBUTE_TYPE.values()));
    }

    @Deprecated
    public ResultSet runQuery(String query) throws SQLException {
        CaseDbConnection connection = null;
        this.acquireSingleUserCaseReadLock();
        try {
            connection = this.connections.getConnection();
            ResultSet resultSet = connection.executeQuery(connection.createStatement(), query);
            return resultSet;
        }
        catch (TskCoreException ex) {
            throw new SQLException("Error getting connection for ad hoc query", ex);
        }
        finally {
            SleuthkitCase.closeConnection(connection);
            this.releaseSingleUserCaseReadLock();
        }
    }

    @Deprecated
    public void closeRunQuery(ResultSet resultSet) throws SQLException {
        Statement statement = resultSet.getStatement();
        resultSet.close();
        if (statement != null) {
            statement.close();
        }
    }

    @Deprecated
    public LayoutFile addCarvedFile(String carvedFileName, long carvedFileSize, long containerId, List<TskFileRange> data) throws TskCoreException {
        CarvingResult.CarvedFile carvedFile = new CarvingResult.CarvedFile(carvedFileName, carvedFileSize, data);
        ArrayList<CarvingResult.CarvedFile> files = new ArrayList<CarvingResult.CarvedFile>();
        files.add(carvedFile);
        Content parent = this.getContentById(containerId);
        if (!(parent instanceof FileSystem || parent instanceof Volume || parent instanceof Image)) {
            throw new TskCoreException(String.format("Parent (id =%d) is not an file system, volume or image", containerId));
        }
        CarvingResult carvingResult = new CarvingResult(parent, files);
        return this.addCarvedFiles(carvingResult).get(0);
    }

    @Deprecated
    public List<LayoutFile> addCarvedFiles(List<CarvedFileContainer> filesToAdd) throws TskCoreException {
        ArrayList<CarvingResult.CarvedFile> carvedFiles = new ArrayList<CarvingResult.CarvedFile>();
        for (CarvedFileContainer container : filesToAdd) {
            CarvingResult.CarvedFile carvedFile = new CarvingResult.CarvedFile(container.getName(), container.getSize(), container.getRanges());
            carvedFiles.add(carvedFile);
        }
        Content parent = this.getContentById(filesToAdd.get(0).getId());
        if (!(parent instanceof FileSystem || parent instanceof Volume || parent instanceof Image)) {
            throw new TskCoreException(String.format("Parent (id =%d) is not an file system, volume or image", parent.getId()));
        }
        CarvingResult carvingResult = new CarvingResult(parent, carvedFiles);
        return this.addCarvedFiles(carvingResult);
    }

    @Deprecated
    public DerivedFile addDerivedFile(String fileName, String localPath, long size, long ctime, long crtime, long atime, long mtime, boolean isFile, AbstractFile parentFile, String rederiveDetails, String toolName, String toolVersion, String otherDetails) throws TskCoreException {
        return this.addDerivedFile(fileName, localPath, size, ctime, crtime, atime, mtime, isFile, parentFile, rederiveDetails, toolName, toolVersion, otherDetails, TskData.EncodingType.NONE);
    }

    @Deprecated
    public LocalFile addLocalFile(String fileName, String localPath, long size, long ctime, long crtime, long atime, long mtime, String md5, TskData.FileKnown known, String mimeType, boolean isFile, TskData.EncodingType encodingType, Content parent, CaseDbTransaction transaction) throws TskCoreException {
        return this.addLocalFile(fileName, localPath, size, ctime, crtime, atime, mtime, md5, null, known, mimeType, isFile, encodingType, parent, transaction);
    }

    @Deprecated
    public LocalFile addLocalFile(String fileName, String localPath, long size, long ctime, long crtime, long atime, long mtime, boolean isFile, AbstractFile parent, CaseDbTransaction transaction) throws TskCoreException {
        return this.addLocalFile(fileName, localPath, size, ctime, crtime, atime, mtime, isFile, TskData.EncodingType.NONE, parent, transaction);
    }

    @Deprecated
    public LocalFile addLocalFile(String fileName, String localPath, long size, long ctime, long crtime, long atime, long mtime, boolean isFile, AbstractFile parent) throws TskCoreException {
        return this.addLocalFile(fileName, localPath, size, ctime, crtime, atime, mtime, isFile, TskData.EncodingType.NONE, parent);
    }

    @Deprecated
    public SleuthkitJNI.CaseDbHandle.AddImageProcess makeAddImageProcess(String timezone, boolean addUnallocSpace, boolean noFatFsOrphans) {
        return this.caseHandle.initAddImageProcess(timezone, addUnallocSpace, noFatFsOrphans, "", null, this);
    }

    @Deprecated
    public Collection<FileSystem> getFileSystems(Image image) {
        try {
            return this.getImageFileSystems(image);
        }
        catch (TskCoreException ex) {
            logger.log(Level.SEVERE, "Error loading all file systems for image with ID {0}", image.getId());
            return new ArrayList<FileSystem>();
        }
    }

    @Deprecated
    public List<AbstractFile> findFiles(Content dataSource, String fileName, AbstractFile parentFile) throws TskCoreException {
        return this.findFilesInFolder(fileName, parentFile);
    }

    @Deprecated
    public void acquireExclusiveLock() {
        this.acquireSingleUserCaseWriteLock();
    }

    @Deprecated
    public void releaseExclusiveLock() {
        this.releaseSingleUserCaseWriteLock();
    }

    @Deprecated
    public void acquireSharedLock() {
        this.acquireSingleUserCaseReadLock();
    }

    @Deprecated
    public void releaseSharedLock() {
        this.releaseSingleUserCaseReadLock();
    }

    static {
        Properties p = new Properties(System.getProperties());
        p.put("com.mchange.v2.log.MLog", "com.mchange.v2.log.FallbackMLog");
        p.put("com.mchange.v2.log.FallbackMLog.DEFAULT_CUTOFF_LEVEL", "SEVERE");
        System.setProperties(p);
    }

    private final class SQLiteConnections
    extends ConnectionPool {
        private final Map<String, String> configurationOverrides;

        SQLiteConnections(String dbPath, boolean useWAL) throws SQLException {
            super(SleuthkitCase.this);
            this.configurationOverrides = new HashMap<String, String>();
            this.configurationOverrides.put("acquireIncrement", "2");
            this.configurationOverrides.put("initialPoolSize", "5");
            this.configurationOverrides.put("minPoolSize", "5");
            this.configurationOverrides.put("maxPoolSize", "20");
            this.configurationOverrides.put("maxStatements", "200");
            this.configurationOverrides.put("maxStatementsPerConnection", "20");
            SQLiteConfig config = new SQLiteConfig();
            config.setSynchronous(SQLiteConfig.SynchronousMode.OFF);
            config.setReadUncommitted(true);
            config.enforceForeignKeys(true);
            if (useWAL) {
                config.setJournalMode(SQLiteConfig.JournalMode.WAL);
            }
            SQLiteDataSource unpooled = new SQLiteDataSource(config);
            unpooled.setUrl("jdbc:sqlite:" + dbPath);
            this.setPooledDataSource((PooledDataSource)DataSources.pooledDataSource((javax.sql.DataSource)unpooled, this.configurationOverrides));
        }

        @Override
        public CaseDbConnection getPooledConnection() throws SQLException {
            if (CaseDbTransaction.hasOpenTransaction(Thread.currentThread().getId()) && !Thread.currentThread().getName().contains("ImageGallery")) {
                logger.log(Level.WARNING, String.format("Thread %s (ID = %d) already has an open transaction.  New connection may encounter SQLITE_BUSY error. ", Thread.currentThread().getName(), Thread.currentThread().getId()), new Throwable());
            }
            Connection conn = this.getPooledDataSource().getConnection();
            SQLiteConnection caseDbConn = new SQLiteConnection(SleuthkitCase.this, conn);
            return caseDbConn;
        }
    }

    private abstract class ConnectionPool {
        private PooledDataSource pooledDataSource = null;

        public ConnectionPool(SleuthkitCase sleuthkitCase) {
        }

        CaseDbConnection getConnection() throws TskCoreException {
            if (this.pooledDataSource == null) {
                throw new TskCoreException("Error getting case database connection - case is closed");
            }
            try {
                return this.getPooledConnection();
            }
            catch (SQLException exp) {
                throw new TskCoreException(exp.getMessage());
            }
        }

        void close() throws TskCoreException {
            if (this.pooledDataSource != null) {
                try {
                    this.pooledDataSource.close();
                }
                catch (SQLException exp) {
                    throw new TskCoreException(exp.getMessage());
                }
                finally {
                    this.pooledDataSource = null;
                }
            }
        }

        abstract CaseDbConnection getPooledConnection() throws SQLException;

        public PooledDataSource getPooledDataSource() {
            return this.pooledDataSource;
        }

        public void setPooledDataSource(PooledDataSource pooledDataSource) {
            this.pooledDataSource = pooledDataSource;
        }
    }

    private final class PostgreSQLConnections
    extends ConnectionPool {
        PostgreSQLConnections(CaseDbConnectionInfo info, String dbName) throws PropertyVetoException, UnsupportedEncodingException {
            super(SleuthkitCase.this);
            ComboPooledDataSource comboPooledDataSource = new ComboPooledDataSource();
            comboPooledDataSource.setDriverClass("org.postgresql.Driver");
            String connectionURL = "jdbc:postgresql://" + info.getHost() + ":" + Integer.valueOf(info.getPort()) + "/" + URLEncoder.encode(dbName, StandardCharsets.UTF_8.toString());
            if (info.isSslEnabled()) {
                connectionURL = info.isSslVerify() ? (info.getCustomSslValidationClassName().isBlank() ? connectionURL + "?ssl=true&sslfactory=org.postgresql.ssl.DefaultJavaSSLFactory&sslmode=verify-ca" : connectionURL + CaseDatabaseFactory.getCustomPostrgesSslVerificationUrl(info.getCustomSslValidationClassName())) : connectionURL + "?ssl=true&sslfactory=org.postgresql.ssl.NonValidatingFactory&sslmode=require";
            }
            comboPooledDataSource.setJdbcUrl(connectionURL);
            comboPooledDataSource.setUser(info.getUserName());
            comboPooledDataSource.setPassword(info.getPassword());
            comboPooledDataSource.setAcquireIncrement(2);
            comboPooledDataSource.setInitialPoolSize(5);
            comboPooledDataSource.setMinPoolSize(5);
            comboPooledDataSource.setMaxPoolSize(20);
            comboPooledDataSource.setMaxStatements(200);
            comboPooledDataSource.setMaxStatementsPerConnection(20);
            this.setPooledDataSource((PooledDataSource)comboPooledDataSource);
        }

        @Override
        public CaseDbConnection getPooledConnection() throws SQLException {
            return new PostgreSQLConnection(SleuthkitCase.this, this.getPooledDataSource().getConnection());
        }
    }

    abstract class CaseDbConnection
    implements AutoCloseable {
        static final int SLEEP_LENGTH_IN_MILLISECONDS = 5000;
        static final int MAX_RETRIES = 20;
        private final Connection connection;
        private final Map<PREPARED_STATEMENT, PreparedStatement> preparedStatements;
        private final Map<String, PreparedStatement> adHocPreparedStatements;

        abstract void executeCommand(DbCommand var1) throws SQLException;

        CaseDbConnection(Connection connection) {
            this.connection = connection;
            this.preparedStatements = new EnumMap<PREPARED_STATEMENT, PreparedStatement>(PREPARED_STATEMENT.class);
            this.adHocPreparedStatements = new HashMap<String, PreparedStatement>();
        }

        boolean isOpen() {
            return this.connection != null;
        }

        PreparedStatement getPreparedStatement(PREPARED_STATEMENT statementKey) throws SQLException {
            return this.getPreparedStatement(statementKey, 2);
        }

        PreparedStatement getPreparedStatement(PREPARED_STATEMENT statementKey, int generateKeys) throws SQLException {
            PreparedStatement statement;
            if (this.preparedStatements.containsKey((Object)statementKey)) {
                statement = this.preparedStatements.get((Object)statementKey);
            } else {
                statement = this.prepareStatement(statementKey.getSQL(), generateKeys);
                this.preparedStatements.put(statementKey, statement);
            }
            return statement;
        }

        PreparedStatement getPreparedStatement(String sqlStatement, int generateKeys) throws SQLException {
            PreparedStatement statement;
            String statementKey = "SQL:" + sqlStatement + " Key:" + generateKeys;
            if (this.adHocPreparedStatements.containsKey(statementKey) && !this.adHocPreparedStatements.get(statementKey).isClosed()) {
                statement = this.adHocPreparedStatements.get(statementKey);
            } else {
                statement = this.prepareStatement(sqlStatement, generateKeys);
                this.adHocPreparedStatements.put(statementKey, statement);
            }
            return statement;
        }

        PreparedStatement prepareStatement(String sqlStatement, int generateKeys) throws SQLException {
            PrepareStatement prepareStatement = new PrepareStatement(this, this.getConnection(), sqlStatement);
            this.executeCommand(prepareStatement);
            return prepareStatement.getPreparedStatement();
        }

        Statement createStatement() throws SQLException {
            CreateStatement createStatement = new CreateStatement(this, this.connection);
            this.executeCommand(createStatement);
            return createStatement.getStatement();
        }

        void beginTransaction() throws SQLException {
            SetAutoCommit setAutoCommit = new SetAutoCommit(this, this.connection, false);
            this.executeCommand(setAutoCommit);
        }

        void commitTransaction() throws SQLException {
            Commit commit = new Commit(this, this.connection);
            this.executeCommand(commit);
            SetAutoCommit setAutoCommit = new SetAutoCommit(this, this.connection, true);
            this.executeCommand(setAutoCommit);
        }

        void rollbackTransaction() {
            try {
                this.connection.rollback();
            }
            catch (SQLException e) {
                logger.log(Level.SEVERE, "Error rolling back transaction", e);
            }
            try {
                this.connection.setAutoCommit(true);
            }
            catch (SQLException e) {
                logger.log(Level.SEVERE, "Error restoring auto-commit", e);
            }
        }

        void rollbackTransactionWithThrow() throws SQLException {
            try {
                this.connection.rollback();
            }
            finally {
                this.connection.setAutoCommit(true);
            }
        }

        void getAggregateScoreTableWriteLock() throws SQLException, TskCoreException {
            switch (SleuthkitCase.this.getDatabaseType()) {
                case POSTGRESQL: {
                    AggregateScoreTablePostgreSQLWriteLock tableWriteLock = new AggregateScoreTablePostgreSQLWriteLock(this, this.connection);
                    this.executeCommand(tableWriteLock);
                    break;
                }
                case SQLITE: {
                    break;
                }
                default: {
                    throw new TskCoreException("Unknown DB Type: " + SleuthkitCase.this.getDatabaseType().name());
                }
            }
        }

        ResultSet executeQuery(Statement statement, String query) throws SQLException {
            ExecuteQuery queryCommand = new ExecuteQuery(this, statement, query);
            this.executeCommand(queryCommand);
            return queryCommand.getResultSet();
        }

        ResultSet executeQuery(PreparedStatement statement) throws SQLException {
            ExecutePreparedStatementQuery executePreparedStatementQuery = new ExecutePreparedStatementQuery(this, statement);
            this.executeCommand(executePreparedStatementQuery);
            return executePreparedStatementQuery.getResultSet();
        }

        void executeUpdate(Statement statement, String update) throws SQLException {
            this.executeUpdate(statement, update, 2);
        }

        void executeUpdate(Statement statement, String update, int generateKeys) throws SQLException {
            ExecuteStatementUpdate executeStatementUpdate = new ExecuteStatementUpdate(this, statement, update);
            this.executeCommand(executeStatementUpdate);
        }

        void executeUpdate(PreparedStatement statement) throws SQLException {
            ExecutePreparedStatementUpdate executePreparedStatementUpdate = new ExecutePreparedStatementUpdate(this, statement);
            this.executeCommand(executePreparedStatementUpdate);
        }

        @Override
        public void close() {
            try {
                for (PreparedStatement stmt : this.preparedStatements.values()) {
                    SleuthkitCase.closeStatement(stmt);
                }
                for (PreparedStatement stmt : this.adHocPreparedStatements.values()) {
                    SleuthkitCase.closeStatement(stmt);
                }
                this.connection.close();
            }
            catch (SQLException ex) {
                logger.log(Level.SEVERE, "Unable to close connection to case database", ex);
            }
        }

        Connection getConnection() {
            return this.connection;
        }

        private class PrepareStatement
        implements DbCommand {
            private final Connection connection;
            private final String input;
            private PreparedStatement preparedStatement = null;

            PrepareStatement(CaseDbConnection caseDbConnection, Connection connection, String input) {
                this.connection = connection;
                this.input = input;
            }

            PreparedStatement getPreparedStatement() {
                return this.preparedStatement;
            }

            @Override
            public void execute() throws SQLException {
                this.preparedStatement = this.connection.prepareStatement(this.input);
            }
        }

        private class CreateStatement
        implements DbCommand {
            private final Connection connection;
            private Statement statement = null;

            CreateStatement(CaseDbConnection caseDbConnection, Connection connection) {
                this.connection = connection;
            }

            Statement getStatement() {
                return this.statement;
            }

            @Override
            public void execute() throws SQLException {
                this.statement = this.connection.createStatement();
            }
        }

        private class SetAutoCommit
        implements DbCommand {
            private final Connection connection;
            private final boolean mode;

            SetAutoCommit(CaseDbConnection caseDbConnection, Connection connection, boolean mode) {
                this.connection = connection;
                this.mode = mode;
            }

            @Override
            public void execute() throws SQLException {
                this.connection.setAutoCommit(this.mode);
            }
        }

        private class Commit
        implements DbCommand {
            private final Connection connection;

            Commit(CaseDbConnection caseDbConnection, Connection connection) {
                this.connection = connection;
            }

            @Override
            public void execute() throws SQLException {
                this.connection.commit();
            }
        }

        private class AggregateScoreTablePostgreSQLWriteLock
        implements DbCommand {
            private final Connection connection;

            AggregateScoreTablePostgreSQLWriteLock(CaseDbConnection caseDbConnection, Connection connection) {
                this.connection = connection;
            }

            @Override
            public void execute() throws SQLException {
                PreparedStatement preparedStatement = this.connection.prepareStatement("LOCK TABLE ONLY tsk_aggregate_score in SHARE ROW EXCLUSIVE MODE");
                preparedStatement.execute();
            }
        }

        private class ExecuteQuery
        implements DbCommand {
            private final Statement statement;
            private final String query;
            private ResultSet resultSet;

            ExecuteQuery(CaseDbConnection caseDbConnection, Statement statement, String query) {
                this.statement = statement;
                this.query = query;
            }

            ResultSet getResultSet() {
                return this.resultSet;
            }

            @Override
            public void execute() throws SQLException {
                this.resultSet = this.statement.executeQuery(this.query);
            }
        }

        private class ExecutePreparedStatementQuery
        implements DbCommand {
            private final PreparedStatement preparedStatement;
            private ResultSet resultSet;

            ExecutePreparedStatementQuery(CaseDbConnection caseDbConnection, PreparedStatement preparedStatement) {
                this.preparedStatement = preparedStatement;
            }

            ResultSet getResultSet() {
                return this.resultSet;
            }

            @Override
            public void execute() throws SQLException {
                this.resultSet = this.preparedStatement.executeQuery();
            }
        }

        private class ExecuteStatementUpdate
        implements DbCommand {
            private final Statement statement;
            private final String updateCommand;

            ExecuteStatementUpdate(CaseDbConnection caseDbConnection, Statement statement, String updateCommand) {
                this.statement = statement;
                this.updateCommand = updateCommand;
            }

            @Override
            public void execute() throws SQLException {
                this.statement.executeUpdate(this.updateCommand);
            }
        }

        private class ExecutePreparedStatementUpdate
        implements DbCommand {
            private final PreparedStatement preparedStatement;

            ExecutePreparedStatementUpdate(CaseDbConnection caseDbConnection, PreparedStatement preparedStatement) {
                this.preparedStatement = preparedStatement;
            }

            @Override
            public void execute() throws SQLException {
                this.preparedStatement.executeUpdate();
            }
        }

        private class PrepareStatementGenerateKeys
        implements DbCommand {
            private final Connection connection;
            private final String input;
            private final int generateKeys;
            private PreparedStatement preparedStatement = null;

            PrepareStatementGenerateKeys(CaseDbConnection caseDbConnection, Connection connection, String input, int generateKeysInput) {
                this.connection = connection;
                this.input = input;
                this.generateKeys = generateKeysInput;
            }

            PreparedStatement getPreparedStatement() {
                return this.preparedStatement;
            }

            @Override
            public void execute() throws SQLException {
                this.preparedStatement = this.connection.prepareStatement(this.input, this.generateKeys);
            }
        }

        private class ExecuteStatementUpdateGenerateKeys
        implements DbCommand {
            private final Statement statement;
            private final int generateKeys;
            private final String updateCommand;

            ExecuteStatementUpdateGenerateKeys(CaseDbConnection caseDbConnection, Statement statement, String updateCommand, int generateKeys) {
                this.statement = statement;
                this.generateKeys = generateKeys;
                this.updateCommand = updateCommand;
            }

            @Override
            public void execute() throws SQLException {
                this.statement.executeUpdate(this.updateCommand, this.generateKeys);
            }
        }
    }

    private static enum PREPARED_STATEMENT {
        SELECT_ARTIFACTS_BY_TYPE("SELECT artifact_id, obj_id FROM blackboard_artifacts WHERE artifact_type_id = ?"),
        COUNT_ARTIFACTS_OF_TYPE("SELECT COUNT(*) AS count FROM blackboard_artifacts WHERE artifact_type_id = ? AND review_status_id != " + BlackboardArtifact.ReviewStatus.REJECTED.getID()),
        COUNT_ARTIFACTS_OF_TYPE_BY_DATA_SOURCE("SELECT COUNT(*) AS count FROM blackboard_artifacts WHERE data_source_obj_id = ? AND artifact_type_id = ? AND review_status_id != " + BlackboardArtifact.ReviewStatus.REJECTED.getID()),
        COUNT_ARTIFACTS_FROM_SOURCE("SELECT COUNT(*) AS count FROM blackboard_artifacts WHERE obj_id = ? AND review_status_id != " + BlackboardArtifact.ReviewStatus.REJECTED.getID()),
        COUNT_ARTIFACTS_BY_SOURCE_AND_TYPE("SELECT COUNT(*) AS count FROM blackboard_artifacts WHERE obj_id = ? AND artifact_type_id = ? AND review_status_id != " + BlackboardArtifact.ReviewStatus.REJECTED.getID()),
        SELECT_FILES_BY_PARENT("SELECT tsk_files.* FROM tsk_objects INNER JOIN tsk_files ON tsk_objects.obj_id=tsk_files.obj_id WHERE (tsk_objects.par_obj_id = ? ) ORDER BY tsk_files.meta_type DESC, LOWER(tsk_files.name)"),
        SELECT_FILES_BY_PARENT_AND_TYPE("SELECT tsk_files.* FROM tsk_objects INNER JOIN tsk_files ON tsk_objects.obj_id=tsk_files.obj_id WHERE (tsk_objects.par_obj_id = ? AND tsk_files.type = ? ) ORDER BY tsk_files.dir_type, LOWER(tsk_files.name)"),
        SELECT_FILES_BY_PARENT_AND_NAME("SELECT tsk_files.* FROM tsk_objects INNER JOIN tsk_files ON tsk_objects.obj_id=tsk_files.obj_id WHERE (tsk_objects.par_obj_id = ? AND LOWER(tsk_files.name) LIKE LOWER(?) AND LOWER(tsk_files.name) NOT LIKE LOWER('%journal%')) ORDER BY tsk_files.dir_type, LOWER(tsk_files.name)"),
        SELECT_FILES_BY_EXTENSION_AND_PARENT_AND_NAME("SELECT tsk_files.* FROM tsk_objects INNER JOIN tsk_files ON tsk_objects.obj_id=tsk_files.obj_id WHERE tsk_files.extension = ? AND (tsk_objects.par_obj_id = ? AND LOWER(tsk_files.name) LIKE LOWER(?) AND LOWER(tsk_files.name) NOT LIKE LOWER('%journal%')) ORDER BY tsk_files.dir_type, LOWER(tsk_files.name)"),
        SELECT_FILE_IDS_BY_PARENT("SELECT tsk_files.obj_id AS obj_id FROM tsk_objects INNER JOIN tsk_files ON tsk_objects.obj_id=tsk_files.obj_id WHERE (tsk_objects.par_obj_id = ?)"),
        SELECT_FILE_IDS_BY_PARENT_AND_TYPE("SELECT tsk_files.obj_id AS obj_id FROM tsk_objects INNER JOIN tsk_files ON tsk_objects.obj_id=tsk_files.obj_id WHERE (tsk_objects.par_obj_id = ? AND tsk_files.type = ? )"),
        SELECT_FILE_BY_ID("SELECT * FROM tsk_files WHERE obj_id = ? LIMIT 1"),
        SELECT_ARTIFACT_BY_ARTIFACT_OBJ_ID("SELECT * FROM blackboard_artifacts WHERE artifact_obj_id = ? LIMIT 1"),
        SELECT_ARTIFACT_TYPE_BY_ARTIFACT_OBJ_ID("SELECT artifact_type_id FROM blackboard_artifacts WHERE artifact_obj_id = ? LIMIT 1"),
        SELECT_ARTIFACT_BY_ARTIFACT_ID("SELECT * FROM blackboard_artifacts WHERE artifact_id = ? LIMIT 1"),
        INSERT_ARTIFACT("INSERT INTO blackboard_artifacts (artifact_id, obj_id, artifact_obj_id, data_source_obj_id, artifact_type_id, review_status_id) VALUES (?, ?, ?, ?, ?," + BlackboardArtifact.ReviewStatus.UNDECIDED.getID() + ")"),
        POSTGRESQL_INSERT_ARTIFACT("INSERT INTO blackboard_artifacts (artifact_id, obj_id, artifact_obj_id, data_source_obj_id, artifact_type_id, review_status_id) VALUES (DEFAULT, ?, ?, ?, ?," + BlackboardArtifact.ReviewStatus.UNDECIDED.getID() + ")"),
        INSERT_ANALYSIS_RESULT("INSERT INTO tsk_analysis_results (artifact_obj_id, conclusion, significance, priority, configuration, justification) VALUES (?, ?, ?, ?, ?, ?)"),
        INSERT_STRING_ATTRIBUTE("INSERT INTO blackboard_attributes (artifact_id, artifact_type_id, source, context, attribute_type_id, value_type, value_text) VALUES (?,?,?,?,?,?,?)"),
        INSERT_BYTE_ATTRIBUTE("INSERT INTO blackboard_attributes (artifact_id, artifact_type_id, source, context, attribute_type_id, value_type, value_byte) VALUES (?,?,?,?,?,?,?)"),
        INSERT_INT_ATTRIBUTE("INSERT INTO blackboard_attributes (artifact_id, artifact_type_id, source, context, attribute_type_id, value_type, value_int32) VALUES (?,?,?,?,?,?,?)"),
        INSERT_LONG_ATTRIBUTE("INSERT INTO blackboard_attributes (artifact_id, artifact_type_id, source, context, attribute_type_id, value_type, value_int64) VALUES (?,?,?,?,?,?,?)"),
        INSERT_DOUBLE_ATTRIBUTE("INSERT INTO blackboard_attributes (artifact_id, artifact_type_id, source, context, attribute_type_id, value_type, value_double) VALUES (?,?,?,?,?,?,?)"),
        INSERT_FILE_ATTRIBUTE("INSERT INTO tsk_file_attributes (obj_id, attribute_type_id, value_type, value_byte, value_text, value_int32, value_int64, value_double) VALUES (?,?,?,?,?,?,?,?)"),
        SELECT_FILES_BY_DATA_SOURCE_AND_NAME("SELECT * FROM tsk_files WHERE LOWER(name) LIKE LOWER(?) AND LOWER(name) NOT LIKE LOWER('%journal%') AND data_source_obj_id = ?"),
        SELECT_FILES_BY_EXTENSION_AND_DATA_SOURCE_AND_NAME("SELECT * FROM tsk_files WHERE extension = ? AND LOWER(name) LIKE LOWER(?) AND LOWER(name) NOT LIKE LOWER('%journal%') AND data_source_obj_id = ?"),
        SELECT_FILES_BY_DATA_SOURCE_AND_PARENT_PATH_AND_NAME("SELECT * FROM tsk_files WHERE LOWER(name) LIKE LOWER(?) AND LOWER(name) NOT LIKE LOWER('%journal%') AND LOWER(parent_path) LIKE LOWER(?) AND data_source_obj_id = ?"),
        SELECT_FILES_BY_EXTENSION_AND_DATA_SOURCE_AND_PARENT_PATH_AND_NAME("SELECT * FROM tsk_files WHERE extension = ? AND LOWER(name) LIKE LOWER(?) AND LOWER(name) NOT LIKE LOWER('%journal%') AND LOWER(parent_path) LIKE LOWER(?) AND data_source_obj_id = ?"),
        UPDATE_FILE_MD5("UPDATE tsk_files SET md5 = ? WHERE obj_id = ?"),
        UPDATE_IMAGE_MD5("UPDATE tsk_image_info SET md5 = ? WHERE obj_id = ?"),
        UPDATE_IMAGE_SHA1("UPDATE tsk_image_info SET sha1 = ? WHERE obj_id = ?"),
        UPDATE_IMAGE_SHA256("UPDATE tsk_image_info SET sha256 = ? WHERE obj_id = ?"),
        SELECT_IMAGE_MD5("SELECT md5 FROM tsk_image_info WHERE obj_id = ?"),
        SELECT_IMAGE_SHA1("SELECT sha1 FROM tsk_image_info WHERE obj_id = ?"),
        SELECT_IMAGE_SHA256("SELECT sha256 FROM tsk_image_info WHERE obj_id = ?"),
        UPDATE_ACQUISITION_DETAILS("UPDATE data_source_info SET acquisition_details = ? WHERE obj_id = ?"),
        UPDATE_ACQUISITION_TOOL_SETTINGS("UPDATE data_source_info SET acquisition_tool_settings = ?, acquisition_tool_name = ?, acquisition_tool_version = ? WHERE obj_id = ?"),
        SELECT_ACQUISITION_DETAILS("SELECT acquisition_details FROM data_source_info WHERE obj_id = ?"),
        SELECT_ACQUISITION_TOOL_SETTINGS("SELECT acquisition_tool_settings, acquisition_tool_name, acquisition_tool_version, added_date_time FROM data_source_info WHERE obj_id = ?"),
        SELECT_LOCAL_PATH_FOR_FILE("SELECT path FROM tsk_files_path WHERE obj_id = ?"),
        SELECT_ENCODING_FOR_FILE("SELECT encoding_type FROM tsk_files_path WHERE obj_id = ?"),
        SELECT_LOCAL_PATH_AND_ENCODING_FOR_FILE("SELECT path, encoding_type FROM tsk_files_path WHERE obj_id = ?"),
        SELECT_PATH_FOR_FILE("SELECT parent_path FROM tsk_files WHERE obj_id = ?"),
        SELECT_FILE_NAME("SELECT name FROM tsk_files WHERE obj_id = ?"),
        SELECT_DERIVED_FILE("SELECT derived_id, rederive FROM tsk_files_derived WHERE obj_id = ?"),
        SELECT_FILE_DERIVATION_METHOD("SELECT tool_name, tool_version, other FROM tsk_files_derived_method WHERE derived_id = ?"),
        SELECT_MAX_OBJECT_ID("SELECT MAX(obj_id) AS max_obj_id FROM tsk_objects"),
        INSERT_OBJECT("INSERT INTO tsk_objects (par_obj_id, type) VALUES (?, ?)"),
        INSERT_FILE("INSERT INTO tsk_files (obj_id, fs_obj_id, name, type, has_path, dir_type, meta_type, dir_flags, meta_flags, size, ctime, crtime, atime, mtime, md5, sha256, sha1, known, mime_type, parent_path, data_source_obj_id, extension, owner_uid, os_account_obj_id, collected) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"),
        INSERT_FILE_SYSTEM_FILE("INSERT INTO tsk_files(obj_id, fs_obj_id, data_source_obj_id, attr_type, attr_id, name, meta_addr, meta_seq, type, has_path, dir_type, meta_type, dir_flags, meta_flags, size, ctime, crtime, atime, mtime, md5, sha256, sha1, mime_type, parent_path, extension, owner_uid, os_account_obj_id, collected) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"),
        UPDATE_DERIVED_FILE("UPDATE tsk_files SET type = ?, dir_type = ?, meta_type = ?, dir_flags = ?,  meta_flags = ?, size= ?, ctime= ?, crtime= ?, atime= ?, mtime= ?, mime_type = ?  WHERE obj_id = ?"),
        INSERT_LAYOUT_FILE("INSERT INTO tsk_file_layout (obj_id, byte_start, byte_len, sequence) VALUES (?, ?, ?, ?)"),
        INSERT_LOCAL_PATH("INSERT INTO tsk_files_path (obj_id, path, encoding_type) VALUES (?, ?, ?)"),
        UPDATE_LOCAL_PATH("UPDATE tsk_files_path SET path = ?, encoding_type = ? WHERE obj_id = ?"),
        COUNT_CHILD_OBJECTS_BY_PARENT("SELECT COUNT(obj_id) AS count FROM tsk_objects WHERE par_obj_id = ?"),
        SELECT_FILE_SYSTEM_BY_OBJECT("SELECT fs_obj_id from tsk_files WHERE obj_id=?"),
        SELECT_TAG_NAMES("SELECT * FROM tag_names"),
        SELECT_TAG_NAMES_IN_USE("SELECT * FROM tag_names WHERE tag_name_id IN (SELECT tag_name_id from content_tags UNION SELECT tag_name_id FROM blackboard_artifact_tags)"),
        SELECT_TAG_NAMES_IN_USE_BY_DATASOURCE("SELECT * FROM tag_names WHERE tag_name_id IN ( SELECT content_tags.tag_name_id as tag_name_id FROM content_tags as content_tags, tsk_files as tsk_files WHERE content_tags.obj_id = tsk_files.obj_id AND tsk_files.data_source_obj_id =  ? UNION SELECT artifact_tags.tag_name_id as tag_name_id  FROM blackboard_artifact_tags as artifact_tags, blackboard_artifacts AS arts  WHERE artifact_tags.artifact_id = arts.artifact_id AND arts.data_source_obj_id =  ? )"),
        INSERT_TAG_NAME("INSERT INTO tag_names (display_name, description, color, knownStatus) VALUES (?, ?, ?, ?)"),
        INSERT_CONTENT_TAG("INSERT INTO content_tags (obj_id, tag_name_id, comment, begin_byte_offset, end_byte_offset, examiner_id) VALUES (?, ?, ?, ?, ?, ?)"),
        DELETE_CONTENT_TAG("DELETE FROM content_tags WHERE tag_id = ?"),
        COUNT_CONTENT_TAGS_BY_TAG_NAME("SELECT COUNT(*) AS count FROM content_tags WHERE tag_name_id = ?"),
        COUNT_CONTENT_TAGS_BY_TAG_NAME_BY_DATASOURCE("SELECT COUNT(*) AS count FROM content_tags as content_tags, tsk_files as tsk_files WHERE content_tags.obj_id = tsk_files.obj_id AND content_tags.tag_name_id = ?  AND tsk_files.data_source_obj_id = ? "),
        SELECT_CONTENT_TAGS("SELECT content_tags.tag_id, content_tags.obj_id, content_tags.tag_name_id, content_tags.comment, content_tags.begin_byte_offset, content_tags.end_byte_offset, tag_names.display_name, tag_names.description, tag_names.color, tag_names.knownStatus, tsk_examiners.login_name, tag_names.tag_set_id, tag_names.rank FROM content_tags INNER JOIN tag_names ON content_tags.tag_name_id = tag_names.tag_name_id LEFT OUTER JOIN tsk_examiners ON content_tags.examiner_id = tsk_examiners.examiner_id"),
        SELECT_CONTENT_TAGS_BY_TAG_NAME("SELECT content_tags.tag_id, content_tags.obj_id, content_tags.tag_name_id, content_tags.comment, content_tags.begin_byte_offset, content_tags.end_byte_offset, tsk_examiners.login_name FROM content_tags LEFT OUTER JOIN tsk_examiners ON content_tags.examiner_id = tsk_examiners.examiner_id WHERE tag_name_id = ?"),
        SELECT_CONTENT_TAGS_BY_TAG_NAME_BY_DATASOURCE("SELECT content_tags.tag_id, content_tags.obj_id, content_tags.tag_name_id, content_tags.comment, content_tags.begin_byte_offset, content_tags.end_byte_offset, tag_names.display_name, tag_names.description, tag_names.color, tag_names.knownStatus, tag_names.tag_set_id, tsk_examiners.login_name FROM content_tags JOIN tsk_os_accounts acc ON content_tags.obj_id = acc.os_account_obj_id JOIN tag_names ON content_tags.tag_name_id = tag_names.tag_name_id JOIN tsk_examiners ON content_tags.examiner_id = tsk_examiners.examiner_id WHERE content_tags.tag_name_id = ? AND acc.os_account_obj_id IN (SELECT os_account_obj_id FROM tsk_os_account_instances WHERE data_source_obj_id = ?) AND acc.db_status = " + OsAccount.OsAccountDbStatus.ACTIVE.getId() + " UNION SELECT content_tags.tag_id, content_tags.obj_id, content_tags.tag_name_id, content_tags.comment, content_tags.begin_byte_offset, content_tags.end_byte_offset, tag_names.display_name, tag_names.description, tag_names.color, tag_names.knownStatus, tag_names.tag_set_id, tsk_examiners.login_name FROM content_tags as content_tags, tsk_files as tsk_files, tag_names as tag_names, tsk_examiners as tsk_examiners WHERE content_tags.examiner_id = tsk_examiners.examiner_id AND content_tags.obj_id = tsk_files.obj_id AND content_tags.tag_name_id = tag_names.tag_name_id AND content_tags.tag_name_id = ? AND tsk_files.data_source_obj_id = ? "),
        SELECT_CONTENT_TAG_BY_ID("SELECT content_tags.tag_id, content_tags.obj_id, content_tags.tag_name_id, content_tags.comment, content_tags.begin_byte_offset, content_tags.end_byte_offset, tag_names.display_name, tag_names.description, tag_names.color, tag_names.knownStatus, tsk_examiners.login_name, tag_names.tag_set_id, tag_names.rank FROM content_tags INNER JOIN tag_names ON content_tags.tag_name_id = tag_names.tag_name_id LEFT OUTER JOIN tsk_examiners ON content_tags.examiner_id = tsk_examiners.examiner_id WHERE tag_id = ?"),
        SELECT_CONTENT_TAGS_BY_CONTENT("SELECT content_tags.tag_id, content_tags.obj_id, content_tags.tag_name_id, content_tags.comment, content_tags.begin_byte_offset, content_tags.end_byte_offset, tag_names.display_name, tag_names.description, tag_names.color, tag_names.knownStatus, tsk_examiners.login_name, tag_names.tag_set_id, tag_names.rank FROM content_tags INNER JOIN tag_names ON content_tags.tag_name_id = tag_names.tag_name_id LEFT OUTER JOIN tsk_examiners ON content_tags.examiner_id = tsk_examiners.examiner_id WHERE content_tags.obj_id = ?"),
        INSERT_ARTIFACT_TAG("INSERT INTO blackboard_artifact_tags (artifact_id, tag_name_id, comment, examiner_id) VALUES (?, ?, ?, ?)"),
        DELETE_ARTIFACT_TAG("DELETE FROM blackboard_artifact_tags WHERE tag_id = ?"),
        SELECT_ARTIFACT_TAGS("SELECT blackboard_artifact_tags.tag_id, blackboard_artifact_tags.artifact_id, blackboard_artifact_tags.tag_name_id, blackboard_artifact_tags.comment, tag_names.display_name, tag_names.description, tag_names.color, tag_names.knownStatus, tag_names.tag_set_id, tsk_examiners.login_name, tag_names.rank FROM blackboard_artifact_tags INNER JOIN tag_names ON blackboard_artifact_tags.tag_name_id = tag_names.tag_name_id LEFT OUTER JOIN tsk_examiners ON blackboard_artifact_tags.examiner_id = tsk_examiners.examiner_id"),
        COUNT_ARTIFACTS_BY_TAG_NAME("SELECT COUNT(*) AS count FROM blackboard_artifact_tags WHERE tag_name_id = ?"),
        COUNT_ARTIFACTS_BY_TAG_NAME_BY_DATASOURCE("SELECT COUNT(*) AS count FROM blackboard_artifact_tags as artifact_tags, blackboard_artifacts AS arts WHERE artifact_tags.artifact_id = arts.artifact_id AND artifact_tags.tag_name_id = ? AND arts.data_source_obj_id =  ? "),
        SELECT_ARTIFACT_TAGS_BY_TAG_NAME("SELECT blackboard_artifact_tags.tag_id, blackboard_artifact_tags.artifact_id, blackboard_artifact_tags.tag_name_id, blackboard_artifact_tags.comment, tsk_examiners.login_name FROM blackboard_artifact_tags LEFT OUTER JOIN tsk_examiners ON blackboard_artifact_tags.examiner_id = tsk_examiners.examiner_id WHERE tag_name_id = ?"),
        SELECT_ARTIFACT_TAGS_BY_TAG_NAME_BY_DATASOURCE("SELECT artifact_tags.tag_id, artifact_tags.artifact_id, artifact_tags.tag_name_id, artifact_tags.comment, arts.obj_id, arts.artifact_obj_id, arts.data_source_obj_id, arts.artifact_type_id, arts.review_status_id, tsk_examiners.login_name FROM blackboard_artifact_tags as artifact_tags, blackboard_artifacts AS arts, tsk_examiners AS tsk_examiners WHERE artifact_tags.examiner_id = tsk_examiners.examiner_id AND artifact_tags.artifact_id = arts.artifact_id AND artifact_tags.tag_name_id = ?  AND arts.data_source_obj_id =  ? "),
        SELECT_ARTIFACT_TAG_BY_ID("SELECT blackboard_artifact_tags.tag_id, blackboard_artifact_tags.artifact_id, blackboard_artifact_tags.tag_name_id, blackboard_artifact_tags.comment, tag_names.display_name, tag_names.description, tag_names.color, tag_names.knownStatus, tsk_examiners.login_name, tag_names.tag_set_id, tag_names.rank FROM blackboard_artifact_tags INNER JOIN tag_names ON blackboard_artifact_tags.tag_name_id = tag_names.tag_name_id  LEFT OUTER JOIN tsk_examiners ON blackboard_artifact_tags.examiner_id = tsk_examiners.examiner_id WHERE blackboard_artifact_tags.tag_id = ?"),
        SELECT_ARTIFACT_TAGS_BY_ARTIFACT("SELECT blackboard_artifact_tags.tag_id, blackboard_artifact_tags.artifact_id, blackboard_artifact_tags.tag_name_id, blackboard_artifact_tags.comment, tag_names.display_name, tag_names.description, tag_names.color, tag_names.knownStatus, tsk_examiners.login_name, tag_names.tag_set_id, tag_names.rank FROM blackboard_artifact_tags INNER JOIN tag_names ON blackboard_artifact_tags.tag_name_id = tag_names.tag_name_id LEFT OUTER JOIN tsk_examiners ON blackboard_artifact_tags.examiner_id = tsk_examiners.examiner_id WHERE blackboard_artifact_tags.artifact_id = ?"),
        SELECT_REPORTS("SELECT * FROM reports"),
        SELECT_REPORT_BY_ID("SELECT * FROM reports WHERE obj_id = ?"),
        INSERT_REPORT("INSERT INTO reports (obj_id, path, crtime, src_module_name, report_name) VALUES (?, ?, ?, ?, ?)"),
        DELETE_REPORT("DELETE FROM reports WHERE reports.obj_id = ?"),
        DELETE_REPORT_TSK_OBJECT("DELETE FROM tsk_objects where tsk_objects.obj_id = ? and tsk_objects.type = ?"),
        INSERT_INGEST_JOB("INSERT INTO ingest_jobs (obj_id, host_name, start_date_time, end_date_time, status_id, settings_dir) VALUES (?, ?, ?, ?, ?, ?)"),
        INSERT_INGEST_MODULE("INSERT INTO ingest_modules (display_name, unique_name, type_id, version) VALUES(?, ?, ?, ?)"),
        SELECT_ATTR_BY_VALUE_BYTE("SELECT source FROM blackboard_attributes WHERE artifact_id = ? AND attribute_type_id = ? AND value_type = 4 AND value_byte = ?"),
        UPDATE_ATTR_BY_VALUE_BYTE("UPDATE blackboard_attributes SET source = ? WHERE artifact_id = ? AND attribute_type_id = ? AND value_type = 4 AND value_byte = ?"),
        UPDATE_IMAGE_PATH("UPDATE tsk_image_names SET name = ? WHERE obj_id = ?"),
        SELECT_ARTIFACT_OBJECTIDS_BY_PARENT("SELECT blackboard_artifacts.artifact_obj_id AS artifact_obj_id FROM tsk_objects INNER JOIN blackboard_artifacts ON tsk_objects.obj_id=blackboard_artifacts.obj_id WHERE (tsk_objects.par_obj_id = ?)"),
        SELECT_EXAMINER_BY_ID("SELECT * FROM tsk_examiners WHERE examiner_id = ?"),
        SELECT_EXAMINER_BY_LOGIN_NAME("SELECT * FROM tsk_examiners WHERE login_name = ?"),
        INSERT_EXAMINER_POSTGRESQL("INSERT INTO tsk_examiners (login_name) VALUES (?) ON CONFLICT DO NOTHING"),
        INSERT_EXAMINER_SQLITE("INSERT OR IGNORE INTO tsk_examiners (login_name) VALUES (?)"),
        UPDATE_FILE_NAME("UPDATE tsk_files SET name = ? WHERE obj_id = ?"),
        UPDATE_IMAGE_NAME("UPDATE tsk_image_info SET display_name = ? WHERE obj_id = ?"),
        UPDATE_IMAGE_SIZES("UPDATE tsk_image_info SET size = ?, ssize = ? WHERE obj_id = ?"),
        DELETE_IMAGE_NAME("DELETE FROM tsk_image_names WHERE obj_id = ?"),
        INSERT_IMAGE_NAME("INSERT INTO tsk_image_names (obj_id, name, sequence) VALUES (?, ?, ?)"),
        INSERT_IMAGE_INFO("INSERT INTO tsk_image_info (obj_id, type, ssize, tzone, size, md5, sha1, sha256, display_name) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)"),
        INSERT_DATA_SOURCE_INFO("INSERT INTO data_source_info (obj_id, device_id, time_zone, added_date_time, host_id, acquisition_tool_settings) VALUES (?, ?, ?, ?, ?, ?)"),
        INSERT_VS_INFO("INSERT INTO tsk_vs_info (obj_id, vs_type, img_offset, block_size) VALUES (?, ?, ?, ?)"),
        INSERT_VS_PART_SQLITE("INSERT INTO tsk_vs_parts (obj_id, addr, start, length, desc, flags) VALUES (?, ?, ?, ?, ?, ?)"),
        INSERT_VS_PART_POSTGRESQL("INSERT INTO tsk_vs_parts (obj_id, addr, start, length, descr, flags) VALUES (?, ?, ?, ?, ?, ?)"),
        INSERT_POOL_INFO("INSERT INTO tsk_pool_info (obj_id, pool_type) VALUES (?, ?)"),
        INSERT_FS_INFO("INSERT INTO tsk_fs_info (obj_id, data_source_obj_id, img_offset, fs_type, block_size, block_count, root_inum, first_inum, last_inum, display_name)VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"),
        SELECT_TAG_NAME_BY_ID("SELECT * FROM tag_names where tag_name_id = ?");

        private final String sql;

        private PREPARED_STATEMENT(String sql) {
            this.sql = sql;
        }

        String getSQL() {
            return this.sql;
        }
    }

    public static final class CaseDbTransaction {
        private final CaseDbConnection connection;
        private SleuthkitCase sleuthkitCase;
        private Map<Long, ScoreChange> scoreChangeMap = new HashMap<Long, ScoreChange>();
        private List<Host> hostsAdded = new ArrayList<Host>();
        private List<TimelineManager.TimelineEventAddedEvent> timelineEvents = new ArrayList<TimelineManager.TimelineEventAddedEvent>();
        private List<OsAccount> accountsChanged = new ArrayList<OsAccount>();
        private List<OsAccount> accountsAdded = new ArrayList<OsAccount>();
        private List<TskEvent.MergedAccountsPair> accountsMerged = new ArrayList<TskEvent.MergedAccountsPair>();
        private List<Long> deletedOsAccountObjectIds = new ArrayList<Long>();
        private List<Long> deletedResultObjectIds = new ArrayList<Long>();
        private static Set<Long> threadsWithOpenTransaction = new HashSet<Long>();
        private static final Object threadsWithOpenTransactionLock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CaseDbTransaction(SleuthkitCase sleuthkitCase) throws TskCoreException {
            this.sleuthkitCase = sleuthkitCase;
            sleuthkitCase.acquireSingleUserCaseWriteLock();
            this.connection = sleuthkitCase.getConnection();
            try {
                Object object = threadsWithOpenTransactionLock;
                synchronized (object) {
                    this.connection.beginTransaction();
                    threadsWithOpenTransaction.add(Thread.currentThread().getId());
                }
            }
            catch (SQLException ex) {
                sleuthkitCase.releaseSingleUserCaseWriteLock();
                throw new TskCoreException("Failed to create transaction on case database", ex);
            }
        }

        CaseDbConnection getConnection() {
            return this.connection;
        }

        void registerScoreChange(ScoreChange scoreChange) {
            this.scoreChangeMap.put(scoreChange.getObjectId(), scoreChange);
        }

        void registerTimelineEvent(TimelineManager.TimelineEventAddedEvent timelineEvent) {
            if (timelineEvent != null) {
                this.timelineEvents.add(timelineEvent);
            }
        }

        void registerAddedHost(Host host) {
            if (host != null) {
                this.hostsAdded.add(host);
            }
        }

        void registerChangedOsAccount(OsAccount account) {
            if (account != null) {
                this.accountsChanged.add(account);
            }
        }

        void registerDeletedOsAccount(long osAccountObjId) {
            this.deletedOsAccountObjectIds.add(osAccountObjId);
        }

        void registerAddedOsAccount(OsAccount account) {
            if (account != null) {
                this.accountsAdded.add(account);
            }
        }

        void registerMergedOsAccount(long sourceOsAccountObjId, long destinationOsAccountObjId) {
            this.accountsMerged.add(new TskEvent.MergedAccountsPair(sourceOsAccountObjId, destinationOsAccountObjId));
        }

        void registerDeletedAnalysisResult(long analysisResultObjId) {
            this.deletedResultObjectIds.add(analysisResultObjId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static boolean hasOpenTransaction(long threadId) {
            Object object = threadsWithOpenTransactionLock;
            synchronized (object) {
                return threadsWithOpenTransaction.contains(threadId);
            }
        }

        public void commit() throws TskCoreException {
            block23: {
                Map<Long, List<ScoreChange>> changesByDataSource;
                try {
                    this.connection.commitTransaction();
                    this.close();
                    if (this.scoreChangeMap.isEmpty()) break block23;
                    changesByDataSource = this.scoreChangeMap.values().stream().collect(Collectors.groupingBy(ScoreChange::getDataSourceObjectId));
                }
                catch (SQLException ex) {
                    try {
                        throw new TskCoreException("Failed to commit transaction on case database", ex);
                    }
                    catch (Throwable throwable) {
                        this.close();
                        if (!this.scoreChangeMap.isEmpty()) {
                            Map<Long, List<ScoreChange>> changesByDataSource2 = this.scoreChangeMap.values().stream().collect(Collectors.groupingBy(ScoreChange::getDataSourceObjectId));
                            for (Map.Entry<Long, List<ScoreChange>> entry : changesByDataSource2.entrySet()) {
                                this.sleuthkitCase.fireTSKEvent(new TskEvent.AggregateScoresChangedEvent(entry.getKey(), (ImmutableSet<ScoreChange>)ImmutableSet.copyOf((Collection)entry.getValue())));
                            }
                        }
                        if (!this.timelineEvents.isEmpty()) {
                            for (TimelineManager.TimelineEventAddedEvent evt : this.timelineEvents) {
                                this.sleuthkitCase.fireTSKEvent(evt);
                            }
                        }
                        if (!this.hostsAdded.isEmpty()) {
                            this.sleuthkitCase.fireTSKEvent(new TskEvent.HostsAddedTskEvent(this.hostsAdded));
                        }
                        if (!this.accountsAdded.isEmpty()) {
                            this.sleuthkitCase.fireTSKEvent(new TskEvent.OsAccountsAddedTskEvent(this.accountsAdded));
                        }
                        if (!this.accountsChanged.isEmpty()) {
                            this.sleuthkitCase.fireTSKEvent(new TskEvent.OsAccountsUpdatedTskEvent(this.accountsChanged));
                        }
                        if (!this.accountsMerged.isEmpty()) {
                            this.sleuthkitCase.fireTSKEvent(new TskEvent.OsAccountsMergedTskEvent(this.accountsMerged));
                        }
                        if (!this.deletedOsAccountObjectIds.isEmpty()) {
                            this.sleuthkitCase.fireTSKEvent(new TskEvent.OsAccountsDeletedTskEvent(this.deletedOsAccountObjectIds));
                        }
                        if (!this.deletedResultObjectIds.isEmpty()) {
                            this.sleuthkitCase.fireTSKEvent(new TskEvent.AnalysisResultsDeletedTskEvent(this.deletedResultObjectIds));
                        }
                        throw throwable;
                    }
                }
                for (Map.Entry entry : changesByDataSource.entrySet()) {
                    this.sleuthkitCase.fireTSKEvent(new TskEvent.AggregateScoresChangedEvent((Long)entry.getKey(), (ImmutableSet<ScoreChange>)ImmutableSet.copyOf((Collection)((Collection)entry.getValue()))));
                }
            }
            if (!this.timelineEvents.isEmpty()) {
                for (TimelineManager.TimelineEventAddedEvent evt : this.timelineEvents) {
                    this.sleuthkitCase.fireTSKEvent(evt);
                }
            }
            if (!this.hostsAdded.isEmpty()) {
                this.sleuthkitCase.fireTSKEvent(new TskEvent.HostsAddedTskEvent(this.hostsAdded));
            }
            if (!this.accountsAdded.isEmpty()) {
                this.sleuthkitCase.fireTSKEvent(new TskEvent.OsAccountsAddedTskEvent(this.accountsAdded));
            }
            if (!this.accountsChanged.isEmpty()) {
                this.sleuthkitCase.fireTSKEvent(new TskEvent.OsAccountsUpdatedTskEvent(this.accountsChanged));
            }
            if (!this.accountsMerged.isEmpty()) {
                this.sleuthkitCase.fireTSKEvent(new TskEvent.OsAccountsMergedTskEvent(this.accountsMerged));
            }
            if (!this.deletedOsAccountObjectIds.isEmpty()) {
                this.sleuthkitCase.fireTSKEvent(new TskEvent.OsAccountsDeletedTskEvent(this.deletedOsAccountObjectIds));
            }
            if (!this.deletedResultObjectIds.isEmpty()) {
                this.sleuthkitCase.fireTSKEvent(new TskEvent.AnalysisResultsDeletedTskEvent(this.deletedResultObjectIds));
            }
        }

        public void rollback() throws TskCoreException {
            try {
                this.connection.rollbackTransactionWithThrow();
            }
            catch (SQLException ex) {
                throw new TskCoreException("Case database transaction rollback failed", ex);
            }
            finally {
                this.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            this.connection.close();
            this.sleuthkitCase.releaseSingleUserCaseWriteLock();
            Object object = threadsWithOpenTransactionLock;
            synchronized (object) {
                threadsWithOpenTransaction.remove(Thread.currentThread().getId());
            }
        }
    }

    static class ObjectInfo {
        private long id;
        private TskData.ObjectType type;

        ObjectInfo(long id, TskData.ObjectType type) {
            this.id = id;
            this.type = type;
        }

        long getId() {
            return this.id;
        }

        TskData.ObjectType getType() {
            return this.type;
        }
    }

    private class CarvedFileDirInfo {
        final VirtualDirectory currentFolder;
        AtomicInteger count;

        CarvedFileDirInfo(SleuthkitCase sleuthkitCase, VirtualDirectory currentFolder) {
            this.currentFolder = currentFolder;
            this.count = new AtomicInteger(0);
        }

        CarvedFileDirInfo(SleuthkitCase sleuthkitCase, VirtualDirectory currentFolder, int count) {
            this.currentFolder = currentFolder;
            this.count = new AtomicInteger(count);
        }

        boolean isFull() {
            return this.count.get() >= 2000;
        }

        void incrementFileCounter() {
            this.count.incrementAndGet();
        }
    }

    private class RootDirectoryKey {
        private long dataSourceId;
        private Long fileSystemId;

        RootDirectoryKey(SleuthkitCase sleuthkitCase, long dataSourceId, Long fileSystemId) {
            this.dataSourceId = dataSourceId;
            this.fileSystemId = fileSystemId;
        }

        public int hashCode() {
            int hash = 7;
            hash = 41 * hash + Objects.hashCode(this.dataSourceId);
            hash = 41 * hash + Objects.hashCode(this.fileSystemId);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RootDirectoryKey otherKey = (RootDirectoryKey)obj;
            if (this.dataSourceId != otherKey.dataSourceId) {
                return false;
            }
            if (this.fileSystemId != null) {
                return this.fileSystemId.equals(otherKey.fileSystemId);
            }
            return otherKey.fileSystemId == null;
        }
    }

    public final class CaseDbQuery
    implements AutoCloseable {
        private ResultSet resultSet;
        private CaseDbConnection connection;

        private CaseDbQuery(String query) throws TskCoreException {
            this(query, false);
        }

        private CaseDbQuery(String query, boolean allowWriteQuery) throws TskCoreException {
            if (!allowWriteQuery && !query.regionMatches(true, 0, "SELECT", 0, "SELECT".length())) {
                throw new TskCoreException("Unsupported query: Only SELECT queries are supported.");
            }
            SleuthkitCase.this.acquireSingleUserCaseReadLock();
            try {
                this.connection = SleuthkitCase.this.connections.getConnection();
                this.resultSet = this.connection.executeQuery(this.connection.createStatement(), query);
            }
            catch (SQLException ex) {
                SleuthkitCase.this.releaseSingleUserCaseReadLock();
                throw new TskCoreException("Error executing query: ", ex);
            }
            catch (TskCoreException ex) {
                SleuthkitCase.this.releaseSingleUserCaseReadLock();
                throw ex;
            }
        }

        public ResultSet getResultSet() {
            return this.resultSet;
        }

        @Override
        public void close() throws TskCoreException {
            try {
                if (this.resultSet != null) {
                    Statement statement = this.resultSet.getStatement();
                    if (statement != null) {
                        statement.close();
                    }
                    this.resultSet.close();
                }
                SleuthkitCase.closeConnection(this.connection);
            }
            catch (SQLException ex) {
                throw new TskCoreException("Error closing query: ", ex);
            }
            finally {
                SleuthkitCase.this.releaseSingleUserCaseReadLock();
            }
        }
    }

    @Deprecated
    public static interface ErrorObserver {
        public void receiveError(String var1, String var2);

        public static enum Context {
            IMAGE_READ_ERROR("Image File Read Error"),
            DATABASE_READ_ERROR("Database Read Error");

            private final String contextString;

            private Context(String context) {
                this.contextString = context;
            }

            public String getContextString() {
                return this.contextString;
            }
        }
    }

    private final class PostgreSQLConnection
    extends CaseDbConnection {
        private final String COMMUNICATION_ERROR = PSQLState.COMMUNICATION_ERROR.getState();
        private final String SYSTEM_ERROR = PSQLState.SYSTEM_ERROR.getState();
        private final String UNKNOWN_STATE = PSQLState.UNKNOWN_STATE.getState();
        private static final int MAX_RETRIES = 3;

        PostgreSQLConnection(SleuthkitCase sleuthkitCase, Connection conn) {
            super(conn);
        }

        @Override
        void executeUpdate(Statement statement, String update, int generateKeys) throws SQLException {
            CaseDbConnection.ExecuteStatementUpdateGenerateKeys executeStatementUpdateGenerateKeys = new CaseDbConnection.ExecuteStatementUpdateGenerateKeys(this, statement, update, generateKeys);
            this.executeCommand(executeStatementUpdateGenerateKeys);
        }

        @Override
        PreparedStatement prepareStatement(String sqlStatement, int generateKeys) throws SQLException {
            CaseDbConnection.PrepareStatementGenerateKeys prepareStatementGenerateKeys = new CaseDbConnection.PrepareStatementGenerateKeys(this, this.getConnection(), sqlStatement, generateKeys);
            this.executeCommand(prepareStatementGenerateKeys);
            return prepareStatementGenerateKeys.getPreparedStatement();
        }

        @Override
        void executeCommand(DbCommand command) throws SQLException {
            SQLException lastException = null;
            for (int retries = 0; retries < 3; ++retries) {
                try {
                    command.execute();
                    lastException = null;
                    break;
                }
                catch (SQLException ex) {
                    lastException = ex;
                    String sqlState = ex.getSQLState();
                    if (sqlState == null || sqlState.equals(this.COMMUNICATION_ERROR) || sqlState.equals(this.SYSTEM_ERROR) || sqlState.equals(this.UNKNOWN_STATE)) {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException exp) {
                            Logger.getLogger(SleuthkitCase.class.getName()).log(Level.WARNING, "Unexpectedly unable to wait for database.", exp);
                        }
                        continue;
                    }
                    throw ex;
                }
            }
            if (lastException != null) {
                throw lastException;
            }
        }
    }

    private final class SQLiteConnection
    extends CaseDbConnection {
        private static final int DATABASE_LOCKED_ERROR = 0;
        private static final int SQLITE_BUSY_ERROR = 5;

        SQLiteConnection(SleuthkitCase sleuthkitCase, Connection conn) {
            super(conn);
        }

        @Override
        void executeCommand(DbCommand command) throws SQLException {
            int retryCounter = 0;
            while (true) {
                try {
                    command.execute();
                }
                catch (SQLException ex) {
                    if ((ex.getErrorCode() == 5 || ex.getErrorCode() == 0) && retryCounter < 20) {
                        try {
                            ++retryCounter;
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException exp) {
                            Logger.getLogger(SleuthkitCase.class.getName()).log(Level.WARNING, "Unexpectedly unable to wait for database.", exp);
                        }
                        continue;
                    }
                    throw ex;
                }
                break;
            }
        }
    }

    private static interface DbCommand {
        public void execute() throws SQLException;
    }
}

