/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import com.google.common.collect.ImmutableSortedSet;
import java.util.Optional;
import java.util.SortedSet;
import org.apache.commons.lang3.ObjectUtils;
import org.sleuthkit.datamodel.TimelineEventDescription;
import org.sleuthkit.datamodel.TimelineEventType;

class TimelineEventTypeImpl
implements TimelineEventType {
    private final long typeID;
    private final String displayName;
    private final TimelineEventType superType;
    private final TimelineEventType.HierarchyLevel eventTypeZoomLevel;

    TimelineEventTypeImpl(long typeID, String displayName, TimelineEventType.HierarchyLevel eventTypeZoomLevel, TimelineEventType superType) {
        this.superType = superType;
        this.typeID = typeID;
        this.displayName = displayName;
        this.eventTypeZoomLevel = eventTypeZoomLevel;
    }

    TimelineEventDescription parseDescription(String fullDescriptionRaw, String medDescriptionRaw, String shortDescriptionRaw) {
        return new TimelineEventDescription(fullDescriptionRaw, medDescriptionRaw, shortDescriptionRaw);
    }

    @Override
    public SortedSet<? extends TimelineEventType> getChildren() {
        return ImmutableSortedSet.of();
    }

    @Override
    public Optional<? extends TimelineEventType> getChild(String string) {
        return this.getChildren().stream().filter(type -> type.getDisplayName().equalsIgnoreCase(this.displayName)).findFirst();
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public TimelineEventType getParent() {
        return (TimelineEventType)ObjectUtils.defaultIfNull((Object)this.superType, (Object)ROOT_EVENT_TYPE);
    }

    @Override
    public TimelineEventType.HierarchyLevel getTypeHierarchyLevel() {
        return this.eventTypeZoomLevel;
    }

    @Override
    public long getTypeID() {
        return this.typeID;
    }

    public int hashCode() {
        int hash = 5;
        hash = 17 * hash + (int)(this.typeID ^ this.typeID >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimelineEventType other = (TimelineEventType)obj;
        return this.getTypeID() == other.getTypeID();
    }

    public String toString() {
        return "StandardEventType{id=" + this.getTypeID() + ", displayName=" + this.getDisplayName() + "}";
    }
}

