/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import com.google.common.net.InternetDomainName;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.sleuthkit.datamodel.BlackboardArtifact;
import org.sleuthkit.datamodel.BlackboardAttribute;
import org.sleuthkit.datamodel.TimelineEventArtifactTypeImpl;
import org.sleuthkit.datamodel.TimelineEventArtifactTypeSingleDescription;
import org.sleuthkit.datamodel.TimelineEventDescription;
import org.sleuthkit.datamodel.TimelineEventDescriptionWithTime;
import org.sleuthkit.datamodel.TimelineEventType;
import org.sleuthkit.datamodel.TimelineEventTypeImpl;
import org.sleuthkit.datamodel.TskCoreException;
import org.sleuthkit.datamodel.blackboardutils.attributes.BlackboardJsonAttrUtil;
import org.sleuthkit.datamodel.blackboardutils.attributes.GeoTrackPoints;

class TimelineEventTypes {
    private TimelineEventTypes() {
    }

    static TimelineEventDescription parseFilePathDescription(String fullDescription) {
        String[] split = fullDescription.split("/");
        String mediumDescription = Stream.of(split).filter(StringUtils::isNotBlank).limit(Math.max(1, split.length - 2)).collect(Collectors.joining("/", "/", "")).replaceAll("//", "/");
        String shortDescription = Stream.of(split).filter(StringUtils::isNotBlank).limit(1L).collect(Collectors.joining("/", "/", "")).replaceAll("//", "/");
        return new TimelineEventDescription(fullDescription, mediumDescription, shortDescription);
    }

    static class GPSTrackArtifactEventType
    extends TimelineEventArtifactTypeSingleDescription {
        GPSTrackArtifactEventType(int typeID, String displayName, TimelineEventType superType, BlackboardArtifact.Type artifactType, BlackboardAttribute.Type descriptionAttribute) {
            super(typeID, displayName, superType, artifactType, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_GEO_TRACKPOINTS), descriptionAttribute);
        }

        @Override
        public TimelineEventDescriptionWithTime makeEventDescription(BlackboardArtifact artifact) throws TskCoreException {
            GeoTrackPoints pointsList;
            BlackboardAttribute attribute = artifact.getAttribute(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_GEO_TRACKPOINTS));
            if (attribute == null) {
                return null;
            }
            try {
                pointsList = BlackboardJsonAttrUtil.fromAttribute(attribute, GeoTrackPoints.class);
            }
            catch (BlackboardJsonAttrUtil.InvalidJsonException ex) {
                throw new TskCoreException("Unable to parse track points in TSK_GEO_TRACKPOINTS attribute", ex);
            }
            Long startTime = pointsList.getStartTime();
            if (startTime == null) {
                return null;
            }
            return new TimelineEventDescriptionWithTime(startTime, null, null, this.extractFullDescription(artifact));
        }
    }

    static class FilePathArtifactEventType
    extends TimelineEventArtifactTypeSingleDescription {
        FilePathArtifactEventType(int typeID, String displayName, TimelineEventType superType, BlackboardArtifact.Type artifactType, BlackboardAttribute.Type timeAttribute, BlackboardAttribute.Type descriptionAttribute) {
            super(typeID, displayName, superType, artifactType, timeAttribute, descriptionAttribute);
        }

        @Override
        TimelineEventDescription parseDescription(String fullDescriptionRaw, String medDescriptionRaw, String shortDescriptionRaw) {
            return TimelineEventTypes.parseFilePathDescription(fullDescriptionRaw);
        }
    }

    static class FilePathEventType
    extends TimelineEventTypeImpl {
        FilePathEventType(long typeID, String displayName, TimelineEventType.HierarchyLevel eventTypeZoomLevel, TimelineEventType superType) {
            super(typeID, displayName, eventTypeZoomLevel, superType);
        }

        @Override
        TimelineEventDescription parseDescription(String fullDescription, String medDescription, String shortDescription) {
            return TimelineEventTypes.parseFilePathDescription(fullDescription);
        }
    }

    static class URLArtifactEventType
    extends TimelineEventArtifactTypeSingleDescription {
        URLArtifactEventType(int typeID, String displayName, TimelineEventType superType, BlackboardArtifact.Type artifactType, BlackboardAttribute.Type timeAttribute, BlackboardAttribute.Type descriptionAttribute) {
            super(typeID, displayName, superType, artifactType, timeAttribute, descriptionAttribute);
        }

        @Override
        TimelineEventDescription parseDescription(String fullDescriptionRaw, String medDescriptionRaw, String shortDescriptionRaw) {
            String fullDescription = fullDescriptionRaw;
            try {
                InternetDomainName domain;
                URI uri = new URI(fullDescription);
                String host = uri.getHost();
                if (host == null) {
                    host = StringUtils.strip((String)fullDescription, (String)"./");
                }
                String shortDescription = InternetDomainName.isValid((String)host) ? ((domain = InternetDomainName.from((String)host)).isUnderPublicSuffix() ? domain.topPrivateDomain().toString() : domain.toString()) : host;
                String mediumDescription = new URI(uri.getScheme(), uri.getUserInfo(), host, uri.getPort(), uri.getPath(), null, null).toString();
                return new TimelineEventDescription(fullDescription, mediumDescription, shortDescription);
            }
            catch (URISyntaxException ex) {
                return new TimelineEventDescription(fullDescription);
            }
        }
    }

    static final class EmptyExtractor
    implements TimelineEventArtifactTypeImpl.TSKCoreCheckedFunction<BlackboardArtifact, String> {
        EmptyExtractor() {
        }

        @Override
        public String apply(BlackboardArtifact ignored) throws TskCoreException {
            return "";
        }
    }
}

