/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sleuthkit.datamodel.Host;
import org.sleuthkit.datamodel.OsAccount;
import org.sleuthkit.datamodel.OsAccountInstance;
import org.sleuthkit.datamodel.Person;
import org.sleuthkit.datamodel.ScoreChange;
import org.sleuthkit.datamodel.TagName;
import org.sleuthkit.datamodel.TagSet;

public interface TskEvent {
    default public Optional<Long> getDataSourceId() {
        return Optional.ofNullable(null);
    }

    public static final class TagSetsDeletedTskEvent
    extends TskObjectsEvent<Long> {
        public TagSetsDeletedTskEvent(List<Long> tagSetIds) {
            super(tagSetIds);
        }

        public List<Long> getTagSetIds() {
            return this.getDataModelObjects();
        }
    }

    public static final class TagSetsAddedTskEvent
    extends TskObjectsEvent<TagSet> {
        public TagSetsAddedTskEvent(List<TagSet> tagSets) {
            super(tagSets);
        }

        public List<TagSet> getTagSets() {
            return this.getDataModelObjects();
        }
    }

    public static final class TagNamesDeletedTskEvent
    extends TskObjectsEvent<Long> {
        public TagNamesDeletedTskEvent(List<Long> tagNameIds) {
            super(tagNameIds);
        }

        public List<Long> getTagNameIds() {
            return this.getDataModelObjects();
        }
    }

    public static final class TagNamesUpdatedTskEvent
    extends TagNamesTskEvent {
        public TagNamesUpdatedTskEvent(List<TagName> tagNames) {
            super(tagNames);
        }
    }

    public static final class TagNamesAddedTskEvent
    extends TagNamesTskEvent {
        public TagNamesAddedTskEvent(List<TagName> tagNames) {
            super(tagNames);
        }
    }

    public static abstract class TagNamesTskEvent
    extends TskObjectsEvent<TagName> {
        public TagNamesTskEvent(List<TagName> tagNames) {
            super(tagNames);
        }

        public List<TagName> getTagNames() {
            return this.getDataModelObjects();
        }
    }

    public static final class HostsRemovedFromPersonTskEvent
    extends TskObjectsEvent<Long> {
        private final Person person;

        HostsRemovedFromPersonTskEvent(Person person, List<Long> hostIds) {
            super(hostIds);
            this.person = person;
        }

        public Person getPerson() {
            return this.person;
        }

        public List<Long> getHostIds() {
            return this.getDataModelObjects();
        }
    }

    public static final class HostsAddedToPersonTskEvent
    extends TskObjectsEvent<Host> {
        private final Person person;

        HostsAddedToPersonTskEvent(Person person, List<Host> hosts) {
            super(hosts);
            this.person = person;
        }

        public Person getPerson() {
            return this.person;
        }

        public List<Host> getHosts() {
            return this.getDataModelObjects();
        }
    }

    public static final class PersonsDeletedTskEvent
    extends TskObjectsEvent<Long> {
        PersonsDeletedTskEvent(List<Long> personObjectIDs) {
            super(personObjectIDs);
        }

        public List<Long> getPersonIds() {
            return this.getDataModelObjects();
        }
    }

    public static final class PersonsUpdatedTskEvent
    extends PersonsTskEvent {
        PersonsUpdatedTskEvent(List<Person> persons) {
            super(persons);
        }
    }

    public static final class PersonsAddedTskEvent
    extends PersonsTskEvent {
        PersonsAddedTskEvent(List<Person> persons) {
            super(persons);
        }
    }

    public static abstract class PersonsTskEvent
    extends TskObjectsEvent<Person> {
        PersonsTskEvent(List<Person> persons) {
            super(persons);
        }

        public List<Person> getPersons() {
            return this.getDataModelObjects();
        }
    }

    public static final class OsAcctInstancesAddedTskEvent
    extends TskObjectsEvent<OsAccountInstance> {
        OsAcctInstancesAddedTskEvent(List<OsAccountInstance> osAcctInstances) {
            super(osAcctInstances);
        }

        public List<OsAccountInstance> getOsAccountInstances() {
            return this.getDataModelObjects();
        }
    }

    public static final class MergedAccountsPair {
        private final Long sourceOsAccountId;
        private final Long destinationOsAccountId;

        public MergedAccountsPair(Long sourceOsAccountId, Long destinationOsAccountId) {
            this.sourceOsAccountId = sourceOsAccountId;
            this.destinationOsAccountId = destinationOsAccountId;
        }

        public Long getSourceOsAccountId() {
            return this.sourceOsAccountId;
        }

        public Long getDestinationOsAccountId() {
            return this.destinationOsAccountId;
        }
    }

    public static final class OsAccountsMergedTskEvent
    extends TskObjectsEvent<MergedAccountsPair> {
        OsAccountsMergedTskEvent(List<MergedAccountsPair> mergedAccounts) {
            super(mergedAccounts);
        }

        public List<MergedAccountsPair> getMergedAccountPairs() {
            return this.getDataModelObjects();
        }
    }

    public static final class OsAccountsDeletedTskEvent
    extends TskObjectsEvent<Long> {
        OsAccountsDeletedTskEvent(List<Long> accountObjectIds) {
            super(accountObjectIds);
        }

        public List<Long> getOsAccountObjectIds() {
            return this.getDataModelObjects();
        }
    }

    public static final class OsAccountsUpdatedTskEvent
    extends OsAccountsTskEvent {
        OsAccountsUpdatedTskEvent(List<OsAccount> osAccounts) {
            super(osAccounts);
        }
    }

    public static final class OsAccountsAddedTskEvent
    extends OsAccountsTskEvent {
        OsAccountsAddedTskEvent(List<OsAccount> osAccounts) {
            super(osAccounts);
        }
    }

    public static abstract class OsAccountsTskEvent
    extends TskObjectsEvent<OsAccount> {
        OsAccountsTskEvent(List<OsAccount> osAccounts) {
            super(osAccounts);
        }

        public List<OsAccount> getOsAcounts() {
            return this.getDataModelObjects();
        }
    }

    public static final class HostsDeletedTskEvent
    extends TskObjectsEvent<Long> {
        HostsDeletedTskEvent(List<Long> hostIds) {
            super(hostIds);
        }

        public List<Long> getHostIds() {
            return this.getDataModelObjects();
        }
    }

    public static final class HostsUpdatedTskEvent
    extends HostsTskEvent {
        HostsUpdatedTskEvent(List<Host> hosts) {
            super(hosts);
        }
    }

    public static final class HostsAddedTskEvent
    extends HostsTskEvent {
        HostsAddedTskEvent(List<Host> hosts) {
            super(hosts);
        }
    }

    public static abstract class HostsTskEvent
    extends TskObjectsEvent<Host> {
        HostsTskEvent(List<Host> hosts) {
            super(hosts);
        }

        public List<Host> getHosts() {
            return this.getDataModelObjects();
        }
    }

    public static final class AnalysisResultsDeletedTskEvent
    extends TskObjectsEvent<Long> {
        AnalysisResultsDeletedTskEvent(List<Long> deletedResultObjIds) {
            super(deletedResultObjIds);
        }

        public List<Long> getAnalysisResultObjectIds() {
            return this.getDataModelObjects();
        }
    }

    public static final class AggregateScoresChangedEvent
    extends TskObjectsEvent<ScoreChange> {
        private final Long dataSourceObjectId;

        AggregateScoresChangedEvent(Long dataSourceObjectId, ImmutableSet<ScoreChange> scoreChanges) {
            super(scoreChanges.asList());
            this.dataSourceObjectId = dataSourceObjectId;
            scoreChanges.stream().forEach(chg -> {
                if (!chg.getDataSourceObjectId().equals(dataSourceObjectId)) {
                    throw new IllegalArgumentException("All data source object IDs in List<ScoreChange> must match dataSourceObjectId");
                }
            });
        }

        @Override
        public Optional<Long> getDataSourceId() {
            return Optional.ofNullable(this.dataSourceObjectId);
        }

        public List<ScoreChange> getScoreChanges() {
            return this.getDataModelObjects();
        }
    }

    public static abstract class TskObjectsEvent<T>
    implements TskEvent {
        private final List<T> dataModelObjects = new ArrayList<T>();

        TskObjectsEvent(List<T> dataModelObjects) {
            this.dataModelObjects.addAll(dataModelObjects);
        }

        List<T> getDataModelObjects() {
            return Collections.unmodifiableList(this.dataModelObjects);
        }
    }
}

