/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel.blackboardutils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.sleuthkit.datamodel.Blackboard;
import org.sleuthkit.datamodel.BlackboardArtifact;
import org.sleuthkit.datamodel.BlackboardAttribute;
import org.sleuthkit.datamodel.Content;
import org.sleuthkit.datamodel.DataArtifact;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.TskCoreException;
import org.sleuthkit.datamodel.blackboardutils.ArtifactHelperBase;

public final class ArtifactsHelper
extends ArtifactHelperBase {
    private static final BlackboardArtifact.Type INSTALLED_PROG_TYPE = new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_INSTALLED_PROG);

    public ArtifactsHelper(SleuthkitCase caseDb, String moduleName, Content srcContent, Long ingestJobId) {
        super(caseDb, moduleName, srcContent, ingestJobId);
    }

    @Deprecated
    public ArtifactsHelper(SleuthkitCase caseDb, String moduleName, Content srcContent) {
        this(caseDb, moduleName, srcContent, null);
    }

    public BlackboardArtifact addInstalledProgram(String programName, long dateInstalled) throws TskCoreException, Blackboard.BlackboardException {
        return this.addInstalledProgram(programName, dateInstalled, Collections.emptyList());
    }

    public BlackboardArtifact addInstalledProgram(String programName, long dateInstalled, Collection<BlackboardAttribute> otherAttributesList) throws TskCoreException, Blackboard.BlackboardException {
        ArrayList<BlackboardAttribute> attributes = new ArrayList<BlackboardAttribute>();
        attributes.add(new BlackboardAttribute(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PROG_NAME, this.getModuleName(), programName));
        this.addAttributeIfNotZero(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME, dateInstalled, attributes);
        attributes.addAll(otherAttributesList);
        Content content = this.getContent();
        DataArtifact installedProgramArtifact = content.newDataArtifact(INSTALLED_PROG_TYPE, attributes);
        Optional<Long> ingestJobId = this.getIngestJobId();
        this.getSleuthkitCase().getBlackboard().postArtifact(installedProgramArtifact, this.getModuleName(), ingestJobId.orElse(null));
        return installedProgramArtifact;
    }
}

