/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel.blackboardutils.attributes;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import org.sleuthkit.datamodel.BlackboardAttribute;

public final class BlackboardJsonAttrUtil {
    public static <T> BlackboardAttribute toAttribute(BlackboardAttribute.Type attrType, String moduleName, T attrValue) {
        if (attrType.getValueType() != BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.JSON) {
            throw new IllegalArgumentException(String.format("Attribute type %s does not have value type BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.JSON", attrType.getTypeName()));
        }
        return new BlackboardAttribute(attrType, moduleName, new Gson().toJson(attrValue));
    }

    public static <T> T fromAttribute(BlackboardAttribute attr, Class<T> clazz) throws InvalidJsonException {
        BlackboardAttribute.Type attrType = attr.getAttributeType();
        if (attrType.getValueType() != BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.JSON) {
            throw new IllegalArgumentException(String.format("Attribute type %s does not have value type BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.JSON", attrType.getTypeName()));
        }
        String json = attr.getValueString();
        if (json == null || json.isEmpty()) {
            throw new InvalidJsonException("The string value (JSON) of the attribute is null or empty");
        }
        try {
            return (T)new Gson().fromJson(json, clazz);
        }
        catch (JsonSyntaxException ex) {
            throw new InvalidJsonException(String.format("The string value (JSON) could not be deserialized as a %s", clazz.getName()), ex);
        }
    }

    private BlackboardJsonAttrUtil() {
    }

    public static class InvalidJsonException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public InvalidJsonException(String message) {
            super(message);
        }

        public InvalidJsonException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

