/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel.blackboardutils.attributes;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GeoAreaPoints
implements Iterable<AreaPoint> {
    private final List<AreaPoint> points = new ArrayList<AreaPoint>();

    public void addPoint(AreaPoint areaPoint) {
        if (areaPoint == null) {
            throw new IllegalArgumentException("addPoint was passed a null waypoint");
        }
        this.points.add(areaPoint);
    }

    public boolean isEmpty() {
        return this.points.isEmpty();
    }

    @Override
    public Iterator<AreaPoint> iterator() {
        return this.points.iterator();
    }

    public static class AreaPoint {
        @SerializedName(value="TSK_GEO_LATITUDE")
        private final Double latitude;
        @SerializedName(value="TSK_GEO_LONGITUDE")
        private final Double longitude;

        public AreaPoint(Double latitude, Double longitude) {
            if (latitude == null) {
                throw new IllegalArgumentException("Constructor was passed null latitude");
            }
            if (longitude == null) {
                throw new IllegalArgumentException("Constructor was passed null longitude");
            }
            this.latitude = latitude;
            this.longitude = longitude;
        }

        public Double getLatitude() {
            return this.latitude;
        }

        public Double getLongitude() {
            return this.longitude;
        }
    }
}

