/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel.blackboardutils.attributes;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.sleuthkit.datamodel.blackboardutils.attributes.GeoWaypoints;

public class GeoTrackPoints
implements Iterable<TrackPoint> {
    private final List<TrackPoint> pointList = new ArrayList<TrackPoint>();

    public void addPoint(TrackPoint trackPoint) {
        if (trackPoint == null) {
            throw new IllegalArgumentException("addPoint was passed a null track point");
        }
        this.pointList.add(trackPoint);
    }

    @Override
    public Iterator<TrackPoint> iterator() {
        return this.pointList.iterator();
    }

    public boolean isEmpty() {
        return this.pointList.isEmpty();
    }

    public Long getStartTime() {
        List<TrackPoint> orderedPoints = this.getTimeOrderedPoints();
        if (orderedPoints != null) {
            for (TrackPoint point : orderedPoints) {
                if (point.getTimeStamp() == null) continue;
                return point.getTimeStamp();
            }
        }
        return null;
    }

    public Long getEndTime() {
        List<TrackPoint> orderedPoints = this.getTimeOrderedPoints();
        if (orderedPoints != null) {
            for (int index = orderedPoints.size() - 1; index >= 0; --index) {
                TrackPoint point = orderedPoints.get(index);
                if (point.getTimeStamp() == null) continue;
                return point.getTimeStamp();
            }
        }
        return null;
    }

    private List<TrackPoint> getTimeOrderedPoints() {
        return this.pointList.stream().sorted().collect(Collectors.toCollection(ArrayList::new));
    }

    public static final class TrackPoint
    extends GeoWaypoints.Waypoint
    implements Comparable<TrackPoint> {
        @SerializedName(value="TSK_GEO_VELOCITY")
        private final Double velocity;
        @SerializedName(value="TSK_DISTANCE_FROM_HOMEPOINT")
        private final Double distanceFromHomePoint;
        @SerializedName(value="TSK_DISTANCE_TRAVELED")
        private final Double distanceTraveled;
        @SerializedName(value="TSK_DATETIME")
        private final Long timestamp;

        public TrackPoint(Double latitude, Double longitude, Double altitude, String name, Double velocity, Double distanceFromHomePoint, Double distanceTraveled, Long timestamp) {
            super(latitude, longitude, altitude, name);
            this.velocity = velocity;
            this.distanceFromHomePoint = distanceFromHomePoint;
            this.distanceTraveled = distanceTraveled;
            this.timestamp = timestamp;
        }

        public Double getVelocity() {
            return this.velocity;
        }

        public Double getDistanceFromHomePoint() {
            return this.distanceFromHomePoint;
        }

        public Double getDistanceTraveled() {
            return this.distanceTraveled;
        }

        public Long getTimeStamp() {
            return this.timestamp;
        }

        @Override
        public int compareTo(TrackPoint otherTP) {
            Long otherTimeStamp = otherTP.getTimeStamp();
            if (this.timestamp == null) {
                if (otherTimeStamp != null) {
                    return -1;
                }
                return 0;
            }
            if (this.timestamp != null && otherTimeStamp == null) {
                return 1;
            }
            return this.timestamp.compareTo(otherTP.getTimeStamp());
        }
    }
}

