/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.caseuco;

import java.time.Instant;
import java.time.ZoneOffset;
import org.sleuthkit.caseuco.CyberItem;
import org.sleuthkit.caseuco.Facet;

class BrowserCookie
extends Facet {
    private String cookieName;
    private String accessedTime;
    private String expirationTime;
    private String cookieDomain;
    private String application;
    private String cookiePath;

    BrowserCookie() {
        super(BrowserCookie.class.getSimpleName());
    }

    BrowserCookie setCookieName(String cookieName) {
        this.cookieName = cookieName;
        return this;
    }

    BrowserCookie setAccessedTime(Long accessedTime) {
        if (accessedTime != null) {
            this.accessedTime = Instant.ofEpochSecond(accessedTime).atOffset(ZoneOffset.UTC).toString();
        }
        return this;
    }

    BrowserCookie setExpirationTime(Long expirationTime) {
        if (expirationTime != null) {
            this.expirationTime = Instant.ofEpochSecond(expirationTime).atOffset(ZoneOffset.UTC).toString();
        }
        return this;
    }

    BrowserCookie setCookieDomain(CyberItem cookieDomain) {
        this.cookieDomain = cookieDomain.getId();
        return this;
    }

    BrowserCookie setApplication(CyberItem application) {
        this.application = application.getId();
        return this;
    }

    BrowserCookie setCookiePath(String cookiePath) {
        this.cookiePath = cookiePath;
        return this;
    }

    String getCookieName() {
        return this.cookieName;
    }

    String getAccessedTime() {
        return this.accessedTime;
    }

    String getExpirationTime() {
        return this.expirationTime;
    }

    String getCookieDomain() {
        return this.cookieDomain;
    }

    String getApplication() {
        return this.application;
    }

    String getCookiePath() {
        return this.cookiePath;
    }
}

