/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.caseuco;

import java.time.Instant;
import java.time.ZoneOffset;
import org.sleuthkit.caseuco.CyberItem;
import org.sleuthkit.caseuco.Facet;

class EmailMessage
extends Facet {
    private String receivedTime;
    private String sentTime;
    private String bcc;
    private String cc;
    private String from;
    private String headerRaw;
    private String messageID;
    private String subject;
    private String sender;
    private String inReplyTo;
    private String body;
    private String contentType;

    EmailMessage() {
        super(EmailMessage.class.getSimpleName());
    }

    EmailMessage setBody(String body) {
        this.body = body;
        return this;
    }

    EmailMessage setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    EmailMessage setReceivedTime(Long receivedTime) {
        if (receivedTime != null) {
            this.receivedTime = Instant.ofEpochSecond(receivedTime).atOffset(ZoneOffset.UTC).toString();
        }
        return this;
    }

    EmailMessage setSentTime(Long sentTime) {
        if (sentTime != null) {
            this.sentTime = Instant.ofEpochSecond(sentTime).atOffset(ZoneOffset.UTC).toString();
        }
        return this;
    }

    EmailMessage setBcc(CyberItem bcc) {
        this.bcc = bcc.getId();
        return this;
    }

    EmailMessage setCc(CyberItem cc) {
        this.cc = cc.getId();
        return this;
    }

    EmailMessage setFrom(CyberItem from) {
        this.from = from.getId();
        return this;
    }

    EmailMessage setHeaderRaw(CyberItem headerRaw) {
        this.headerRaw = headerRaw.getId();
        return this;
    }

    EmailMessage setMessageID(String messageID) {
        this.messageID = messageID;
        return this;
    }

    EmailMessage setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    EmailMessage setSender(CyberItem sender) {
        this.sender = sender.getId();
        return this;
    }

    EmailMessage setInReplyTo(CyberItem replyTo) {
        this.inReplyTo = replyTo.getId();
        return this;
    }

    String getReceivedTime() {
        return this.receivedTime;
    }

    String getSentTime() {
        return this.sentTime;
    }

    String getBcc() {
        return this.bcc;
    }

    String getCc() {
        return this.cc;
    }

    String getFrom() {
        return this.from;
    }

    String getHeaderRaw() {
        return this.headerRaw;
    }

    String getMessageID() {
        return this.messageID;
    }

    String getSubject() {
        return this.subject;
    }

    String getSender() {
        return this.sender;
    }

    String getInReplyTo() {
        return this.inReplyTo;
    }

    String getBody() {
        return this.body;
    }

    String getContentType() {
        return this.contentType;
    }
}

