/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.caseuco;

import java.time.Instant;
import java.time.ZoneOffset;
import org.sleuthkit.caseuco.Facet;

class File
extends Facet {
    private String accessedTime;
    private String extension;
    private String fileName;
    private String filePath;
    private Boolean isDirectory;
    private Long sizeInBytes;

    File() {
        super(File.class.getSimpleName());
    }

    File setAccessedTime(Long accessedTime) {
        if (accessedTime != null) {
            this.accessedTime = Instant.ofEpochSecond(accessedTime).atOffset(ZoneOffset.UTC).toString();
        }
        return this;
    }

    File setExtension(String extension) {
        this.extension = extension;
        return this;
    }

    File setFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    File setFilePath(String filePath) {
        this.filePath = filePath;
        return this;
    }

    File setIsDirectory(boolean isDirectory) {
        this.isDirectory = isDirectory;
        return this;
    }

    File setSizeInBytes(long sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
        return this;
    }

    String getAccessedTime() {
        return this.accessedTime;
    }

    String getExtension() {
        return this.extension;
    }

    String getFileName() {
        return this.fileName;
    }

    String getFilePath() {
        return this.filePath;
    }

    Boolean getIsDirectory() {
        return this.isDirectory;
    }

    Long getSizeInBytes() {
        return this.sizeInBytes;
    }
}

