/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.caseuco;

import org.sleuthkit.caseuco.Facet;
import org.sleuthkit.datamodel.TskData;

class FileSystem
extends Facet {
    private FileSystemType fileSystemType;
    private Long cluserSize;

    FileSystem() {
        super(FileSystem.class.getSimpleName());
    }

    FileSystem setFileSystemType(TskData.TSK_FS_TYPE_ENUM fileSystemType) {
        this.fileSystemType = FileSystemType.from(fileSystemType);
        return this;
    }

    FileSystem setCluserSize(long cluserSize) {
        this.cluserSize = cluserSize;
        return this;
    }

    FileSystemType getFileSystemType() {
        return this.fileSystemType;
    }

    Long getCluserSize() {
        return this.cluserSize;
    }

    static enum FileSystemType {
        BDE(null),
        CPIO(null),
        EXT4(TskData.TSK_FS_TYPE_ENUM.TSK_FS_TYPE_EXT4),
        F2FS(null),
        HFS(TskData.TSK_FS_TYPE_ENUM.TSK_FS_TYPE_HFS),
        LVM(null),
        NTFS(TskData.TSK_FS_TYPE_ENUM.TSK_FS_TYPE_NTFS),
        SevenZ(null),
        TAR(null),
        VSSVolume(null),
        ZIP(null);

        private final TskData.TSK_FS_TYPE_ENUM tskType;

        private FileSystemType(TskData.TSK_FS_TYPE_ENUM tskType) {
            this.tskType = tskType;
        }

        static FileSystemType from(TskData.TSK_FS_TYPE_ENUM typeToConvert) {
            for (FileSystemType type : FileSystemType.values()) {
                if (type.tskType != typeToConvert) continue;
                return type;
            }
            return null;
        }

        TskData.TSK_FS_TYPE_ENUM getTskType() {
            return this.tskType;
        }
    }
}

