/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.caseuco;

import java.time.Instant;
import java.time.ZoneOffset;
import org.sleuthkit.caseuco.Facet;

class OperatingSystem
extends Facet {
    private String installDate;
    private String version;

    OperatingSystem() {
        super(OperatingSystem.class.getSimpleName());
    }

    OperatingSystem setInstallDate(Long installDate) {
        if (installDate != null) {
            this.installDate = Instant.ofEpochSecond(installDate).atOffset(ZoneOffset.UTC).toString();
        }
        return this;
    }

    OperatingSystem setVersion(String version) {
        this.version = version;
        return this;
    }

    String getInstallDate() {
        return this.installDate;
    }

    String getVersion() {
        return this.version;
    }
}

