#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# -:-:-:-:-:-:-:-:-:-:-:-:#
#    TIDoS Framework     #
# -:-:-:-:-:-:-:-:-:-:-:-:#

# Author: @_tID (Modified version from wascan)
# This module requires TIDoS Framework
# https://github.com/0xInfection/TIDoS-Framework

from re import search, I


def modsecurity(headers, content):
    detect = False
    for header in headers.items():
        detect |= search(r'Mod_Security|NOYB', header[1], I) is not None
        if detect: break
    detect |= search(r'This error was generated by Mod_Security', content) is not None
    if detect:
        return "ModSecurity: Open Source Web Application Firewall (Trustwave)"
