#pragma warning(disable:4067)

#if not (defined REG_SPEC || defined REG_SPEC_NO_CAPSTONE)
#error REG_SPEC have to be specified before including specs
#endif

#define TT_MUTABLE_REG    true
#define TT_IMMUTABLE_REG  false

// REG_SPEC(UPPER_NAME, LOWER_NAME, AARCH64_UPPER, AARCH64_LOWER, AARCH64_PARENT, MUTABLE)

// Thirty-one 64-bit general-purpose registers 
REG_SPEC(X0,  x0,  triton::bitsize::qword-1, 0, X0,  TT_MUTABLE_REG) // x0
REG_SPEC(X1,  x1,  triton::bitsize::qword-1, 0, X1,  TT_MUTABLE_REG) // x1
REG_SPEC(X2,  x2,  triton::bitsize::qword-1, 0, X2,  TT_MUTABLE_REG) // x2
REG_SPEC(X3,  x3,  triton::bitsize::qword-1, 0, X3,  TT_MUTABLE_REG) // x3
REG_SPEC(X4,  x4,  triton::bitsize::qword-1, 0, X4,  TT_MUTABLE_REG) // x4
REG_SPEC(X5,  x5,  triton::bitsize::qword-1, 0, X5,  TT_MUTABLE_REG) // x5
REG_SPEC(X6,  x6,  triton::bitsize::qword-1, 0, X6,  TT_MUTABLE_REG) // x6
REG_SPEC(X7,  x7,  triton::bitsize::qword-1, 0, X7,  TT_MUTABLE_REG) // x7
REG_SPEC(X8,  x8,  triton::bitsize::qword-1, 0, X8,  TT_MUTABLE_REG) // x8
REG_SPEC(X9,  x9,  triton::bitsize::qword-1, 0, X9,  TT_MUTABLE_REG) // x9
REG_SPEC(X10, x10, triton::bitsize::qword-1, 0, X10, TT_MUTABLE_REG) // x10
REG_SPEC(X11, x11, triton::bitsize::qword-1, 0, X11, TT_MUTABLE_REG) // x11
REG_SPEC(X12, x12, triton::bitsize::qword-1, 0, X12, TT_MUTABLE_REG) // x12
REG_SPEC(X13, x13, triton::bitsize::qword-1, 0, X13, TT_MUTABLE_REG) // x13
REG_SPEC(X14, x14, triton::bitsize::qword-1, 0, X14, TT_MUTABLE_REG) // x14
REG_SPEC(X15, x15, triton::bitsize::qword-1, 0, X15, TT_MUTABLE_REG) // x15
REG_SPEC(X16, x16, triton::bitsize::qword-1, 0, X16, TT_MUTABLE_REG) // x16
REG_SPEC(X17, x17, triton::bitsize::qword-1, 0, X17, TT_MUTABLE_REG) // x17
REG_SPEC(X18, x18, triton::bitsize::qword-1, 0, X18, TT_MUTABLE_REG) // x18
REG_SPEC(X19, x19, triton::bitsize::qword-1, 0, X19, TT_MUTABLE_REG) // x19
REG_SPEC(X20, x20, triton::bitsize::qword-1, 0, X20, TT_MUTABLE_REG) // x20
REG_SPEC(X21, x21, triton::bitsize::qword-1, 0, X21, TT_MUTABLE_REG) // x21
REG_SPEC(X22, x22, triton::bitsize::qword-1, 0, X22, TT_MUTABLE_REG) // x22
REG_SPEC(X23, x23, triton::bitsize::qword-1, 0, X23, TT_MUTABLE_REG) // x23
REG_SPEC(X24, x24, triton::bitsize::qword-1, 0, X24, TT_MUTABLE_REG) // x24
REG_SPEC(X25, x25, triton::bitsize::qword-1, 0, X25, TT_MUTABLE_REG) // x25
REG_SPEC(X26, x26, triton::bitsize::qword-1, 0, X26, TT_MUTABLE_REG) // x26
REG_SPEC(X27, x27, triton::bitsize::qword-1, 0, X27, TT_MUTABLE_REG) // x27
REG_SPEC(X28, x28, triton::bitsize::qword-1, 0, X28, TT_MUTABLE_REG) // x28
REG_SPEC(X29, x29, triton::bitsize::qword-1, 0, X29, TT_MUTABLE_REG) // x29
REG_SPEC(X30, x30, triton::bitsize::qword-1, 0, X30, TT_MUTABLE_REG) // x30 (LR register)
REG_SPEC(W0,  w0,  triton::bitsize::dword-1, 0, X0,  TT_MUTABLE_REG)  // w0
REG_SPEC(W1,  w1,  triton::bitsize::dword-1, 0, X1,  TT_MUTABLE_REG)  // w1
REG_SPEC(W2,  w2,  triton::bitsize::dword-1, 0, X2,  TT_MUTABLE_REG)  // w2
REG_SPEC(W3,  w3,  triton::bitsize::dword-1, 0, X3,  TT_MUTABLE_REG)  // w3
REG_SPEC(W4,  w4,  triton::bitsize::dword-1, 0, X4,  TT_MUTABLE_REG)  // w4
REG_SPEC(W5,  w5,  triton::bitsize::dword-1, 0, X5,  TT_MUTABLE_REG)  // w5
REG_SPEC(W6,  w6,  triton::bitsize::dword-1, 0, X6,  TT_MUTABLE_REG)  // w6
REG_SPEC(W7,  w7,  triton::bitsize::dword-1, 0, X7,  TT_MUTABLE_REG)  // w7
REG_SPEC(W8,  w8,  triton::bitsize::dword-1, 0, X8,  TT_MUTABLE_REG)  // w8
REG_SPEC(W9,  w9,  triton::bitsize::dword-1, 0, X9,  TT_MUTABLE_REG)  // w9
REG_SPEC(W10, w10, triton::bitsize::dword-1, 0, X10, TT_MUTABLE_REG) // w10
REG_SPEC(W11, w11, triton::bitsize::dword-1, 0, X11, TT_MUTABLE_REG) // w11
REG_SPEC(W12, w12, triton::bitsize::dword-1, 0, X12, TT_MUTABLE_REG) // w12
REG_SPEC(W13, w13, triton::bitsize::dword-1, 0, X13, TT_MUTABLE_REG) // w13
REG_SPEC(W14, w14, triton::bitsize::dword-1, 0, X14, TT_MUTABLE_REG) // w14
REG_SPEC(W15, w15, triton::bitsize::dword-1, 0, X15, TT_MUTABLE_REG) // w15
REG_SPEC(W16, w16, triton::bitsize::dword-1, 0, X16, TT_MUTABLE_REG) // w16
REG_SPEC(W17, w17, triton::bitsize::dword-1, 0, X17, TT_MUTABLE_REG) // w17
REG_SPEC(W18, w18, triton::bitsize::dword-1, 0, X18, TT_MUTABLE_REG) // w18
REG_SPEC(W19, w19, triton::bitsize::dword-1, 0, X19, TT_MUTABLE_REG) // w19
REG_SPEC(W20, w20, triton::bitsize::dword-1, 0, X20, TT_MUTABLE_REG) // w20
REG_SPEC(W21, w21, triton::bitsize::dword-1, 0, X21, TT_MUTABLE_REG) // w21
REG_SPEC(W22, w22, triton::bitsize::dword-1, 0, X22, TT_MUTABLE_REG) // w22
REG_SPEC(W23, w23, triton::bitsize::dword-1, 0, X23, TT_MUTABLE_REG) // w23
REG_SPEC(W24, w24, triton::bitsize::dword-1, 0, X24, TT_MUTABLE_REG) // w24
REG_SPEC(W25, w25, triton::bitsize::dword-1, 0, X25, TT_MUTABLE_REG) // w25
REG_SPEC(W26, w26, triton::bitsize::dword-1, 0, X26, TT_MUTABLE_REG) // w26
REG_SPEC(W27, w27, triton::bitsize::dword-1, 0, X27, TT_MUTABLE_REG) // w27
REG_SPEC(W28, w28, triton::bitsize::dword-1, 0, X28, TT_MUTABLE_REG) // w28
REG_SPEC(W29, w29, triton::bitsize::dword-1, 0, X29, TT_MUTABLE_REG) // w29
REG_SPEC(W30, w30, triton::bitsize::dword-1, 0, X30, TT_MUTABLE_REG) // w30

// Flag register
REG_SPEC_NO_CAPSTONE(SPSR, spsr, 31, 0, SPSR, TT_MUTABLE_REG) // SPSR

// Stack pointer registers
REG_SPEC(SP,  sp,  triton::bitsize::qword-1, 0, SP, TT_MUTABLE_REG) // SP
REG_SPEC(WSP, wsp, triton::bitsize::dword-1, 0, SP, TT_MUTABLE_REG) // WSP

// Program counter register
REG_SPEC_NO_CAPSTONE(PC, pc, triton::bitsize::qword-1, 0, PC, TT_MUTABLE_REG) // PC

// Zero registers
REG_SPEC(XZR, xzr, triton::bitsize::qword-1, 0, XZR, TT_IMMUTABLE_REG) // XZR
REG_SPEC(WZR, wzr, triton::bitsize::dword-1, 0, XZR, TT_IMMUTABLE_REG) // WZR

// Unique flag registers
REG_SPEC_NO_CAPSTONE(C, c, 0, 0, C, TT_MUTABLE_REG) // C (Carry)
REG_SPEC_NO_CAPSTONE(N, n, 0, 0, N, TT_MUTABLE_REG) // N (Negative)
REG_SPEC_NO_CAPSTONE(V, v, 0, 0, V, TT_MUTABLE_REG) // V (Overflow)
REG_SPEC_NO_CAPSTONE(Z, z, 0, 0, Z, TT_MUTABLE_REG) // Z (Zero)

// Scalar Register
REG_SPEC(Q0,  q0,  triton::bitsize::dqword-1, 0, Q0,  TT_MUTABLE_REG) // q0
REG_SPEC(Q1,  q1,  triton::bitsize::dqword-1, 0, Q1,  TT_MUTABLE_REG) // q1
REG_SPEC(Q2,  q2,  triton::bitsize::dqword-1, 0, Q2,  TT_MUTABLE_REG) // q2
REG_SPEC(Q3,  q3,  triton::bitsize::dqword-1, 0, Q3,  TT_MUTABLE_REG) // q3
REG_SPEC(Q4,  q4,  triton::bitsize::dqword-1, 0, Q4,  TT_MUTABLE_REG) // q4
REG_SPEC(Q5,  q5,  triton::bitsize::dqword-1, 0, Q5,  TT_MUTABLE_REG) // q5
REG_SPEC(Q6,  q6,  triton::bitsize::dqword-1, 0, Q6,  TT_MUTABLE_REG) // q6
REG_SPEC(Q7,  q7,  triton::bitsize::dqword-1, 0, Q7,  TT_MUTABLE_REG) // q7
REG_SPEC(Q8,  q8,  triton::bitsize::dqword-1, 0, Q8,  TT_MUTABLE_REG) // q8
REG_SPEC(Q9,  q9,  triton::bitsize::dqword-1, 0, Q9,  TT_MUTABLE_REG) // q9
REG_SPEC(Q10, q10, triton::bitsize::dqword-1, 0, Q10, TT_MUTABLE_REG) // q10
REG_SPEC(Q11, q11, triton::bitsize::dqword-1, 0, Q11, TT_MUTABLE_REG) // q11
REG_SPEC(Q12, q12, triton::bitsize::dqword-1, 0, Q12, TT_MUTABLE_REG) // q12
REG_SPEC(Q13, q13, triton::bitsize::dqword-1, 0, Q13, TT_MUTABLE_REG) // q13
REG_SPEC(Q14, q14, triton::bitsize::dqword-1, 0, Q14, TT_MUTABLE_REG) // q14
REG_SPEC(Q15, q15, triton::bitsize::dqword-1, 0, Q15, TT_MUTABLE_REG) // q15
REG_SPEC(Q16, q16, triton::bitsize::dqword-1, 0, Q16, TT_MUTABLE_REG) // q16
REG_SPEC(Q17, q17, triton::bitsize::dqword-1, 0, Q17, TT_MUTABLE_REG) // q17
REG_SPEC(Q18, q18, triton::bitsize::dqword-1, 0, Q18, TT_MUTABLE_REG) // q18
REG_SPEC(Q19, q19, triton::bitsize::dqword-1, 0, Q19, TT_MUTABLE_REG) // q19
REG_SPEC(Q20, q20, triton::bitsize::dqword-1, 0, Q20, TT_MUTABLE_REG) // q20
REG_SPEC(Q21, q21, triton::bitsize::dqword-1, 0, Q21, TT_MUTABLE_REG) // q21
REG_SPEC(Q22, q22, triton::bitsize::dqword-1, 0, Q22, TT_MUTABLE_REG) // q22
REG_SPEC(Q23, q23, triton::bitsize::dqword-1, 0, Q23, TT_MUTABLE_REG) // q23
REG_SPEC(Q24, q24, triton::bitsize::dqword-1, 0, Q24, TT_MUTABLE_REG) // q24
REG_SPEC(Q25, q25, triton::bitsize::dqword-1, 0, Q25, TT_MUTABLE_REG) // q25
REG_SPEC(Q26, q26, triton::bitsize::dqword-1, 0, Q26, TT_MUTABLE_REG) // q26
REG_SPEC(Q27, q27, triton::bitsize::dqword-1, 0, Q27, TT_MUTABLE_REG) // q27
REG_SPEC(Q28, q28, triton::bitsize::dqword-1, 0, Q28, TT_MUTABLE_REG) // q28
REG_SPEC(Q29, q29, triton::bitsize::dqword-1, 0, Q29, TT_MUTABLE_REG) // q29
REG_SPEC(Q30, q30, triton::bitsize::dqword-1, 0, Q30, TT_MUTABLE_REG) // q30
REG_SPEC(Q31, q31, triton::bitsize::dqword-1, 0, Q31, TT_MUTABLE_REG) // q31

REG_SPEC(D0,  d0,  triton::bitsize::qword-1, 0, Q0,  TT_MUTABLE_REG) // d0
REG_SPEC(D1,  d1,  triton::bitsize::qword-1, 0, Q1,  TT_MUTABLE_REG) // d1
REG_SPEC(D2,  d2,  triton::bitsize::qword-1, 0, Q2,  TT_MUTABLE_REG) // d2
REG_SPEC(D3,  d3,  triton::bitsize::qword-1, 0, Q3,  TT_MUTABLE_REG) // d3
REG_SPEC(D4,  d4,  triton::bitsize::qword-1, 0, Q4,  TT_MUTABLE_REG) // d4
REG_SPEC(D5,  d5,  triton::bitsize::qword-1, 0, Q5,  TT_MUTABLE_REG) // d5
REG_SPEC(D6,  d6,  triton::bitsize::qword-1, 0, Q6,  TT_MUTABLE_REG) // d6
REG_SPEC(D7,  d7,  triton::bitsize::qword-1, 0, Q7,  TT_MUTABLE_REG) // d7
REG_SPEC(D8,  d8,  triton::bitsize::qword-1, 0, Q8,  TT_MUTABLE_REG) // d8
REG_SPEC(D9,  d9,  triton::bitsize::qword-1, 0, Q9,  TT_MUTABLE_REG) // d9
REG_SPEC(D10, d10, triton::bitsize::qword-1, 0, Q10, TT_MUTABLE_REG) // d10
REG_SPEC(D11, d11, triton::bitsize::qword-1, 0, Q11, TT_MUTABLE_REG) // d11
REG_SPEC(D12, d12, triton::bitsize::qword-1, 0, Q12, TT_MUTABLE_REG) // d12
REG_SPEC(D13, d13, triton::bitsize::qword-1, 0, Q13, TT_MUTABLE_REG) // d13
REG_SPEC(D14, d14, triton::bitsize::qword-1, 0, Q14, TT_MUTABLE_REG) // d14
REG_SPEC(D15, d15, triton::bitsize::qword-1, 0, Q15, TT_MUTABLE_REG) // d15
REG_SPEC(D16, d16, triton::bitsize::qword-1, 0, Q16, TT_MUTABLE_REG) // d16
REG_SPEC(D17, d17, triton::bitsize::qword-1, 0, Q17, TT_MUTABLE_REG) // d17
REG_SPEC(D18, d18, triton::bitsize::qword-1, 0, Q18, TT_MUTABLE_REG) // d18
REG_SPEC(D19, d19, triton::bitsize::qword-1, 0, Q19, TT_MUTABLE_REG) // d19
REG_SPEC(D20, d20, triton::bitsize::qword-1, 0, Q20, TT_MUTABLE_REG) // d20
REG_SPEC(D21, d21, triton::bitsize::qword-1, 0, Q21, TT_MUTABLE_REG) // d21
REG_SPEC(D22, d22, triton::bitsize::qword-1, 0, Q22, TT_MUTABLE_REG) // d22
REG_SPEC(D23, d23, triton::bitsize::qword-1, 0, Q23, TT_MUTABLE_REG) // d23
REG_SPEC(D24, d24, triton::bitsize::qword-1, 0, Q24, TT_MUTABLE_REG) // d24
REG_SPEC(D25, d25, triton::bitsize::qword-1, 0, Q25, TT_MUTABLE_REG) // d25
REG_SPEC(D26, d26, triton::bitsize::qword-1, 0, Q26, TT_MUTABLE_REG) // d26
REG_SPEC(D27, d27, triton::bitsize::qword-1, 0, Q27, TT_MUTABLE_REG) // d27
REG_SPEC(D28, d28, triton::bitsize::qword-1, 0, Q28, TT_MUTABLE_REG) // d28
REG_SPEC(D29, d29, triton::bitsize::qword-1, 0, Q29, TT_MUTABLE_REG) // d29
REG_SPEC(D30, d30, triton::bitsize::qword-1, 0, Q30, TT_MUTABLE_REG) // d30
REG_SPEC(D31, d31, triton::bitsize::qword-1, 0, Q31, TT_MUTABLE_REG) // d31

REG_SPEC(S0,  s0,  triton::bitsize::dword-1, 0, Q0,  TT_MUTABLE_REG) // s0
REG_SPEC(S1,  s1,  triton::bitsize::dword-1, 0, Q1,  TT_MUTABLE_REG) // s1
REG_SPEC(S2,  s2,  triton::bitsize::dword-1, 0, Q2,  TT_MUTABLE_REG) // s2
REG_SPEC(S3,  s3,  triton::bitsize::dword-1, 0, Q3,  TT_MUTABLE_REG) // s3
REG_SPEC(S4,  s4,  triton::bitsize::dword-1, 0, Q4,  TT_MUTABLE_REG) // s4
REG_SPEC(S5,  s5,  triton::bitsize::dword-1, 0, Q5,  TT_MUTABLE_REG) // s5
REG_SPEC(S6,  s6,  triton::bitsize::dword-1, 0, Q6,  TT_MUTABLE_REG) // s6
REG_SPEC(S7,  s7,  triton::bitsize::dword-1, 0, Q7,  TT_MUTABLE_REG) // s7
REG_SPEC(S8,  s8,  triton::bitsize::dword-1, 0, Q8,  TT_MUTABLE_REG) // s8
REG_SPEC(S9,  s9,  triton::bitsize::dword-1, 0, Q9,  TT_MUTABLE_REG) // s9
REG_SPEC(S10, s10, triton::bitsize::dword-1, 0, Q10, TT_MUTABLE_REG) // s10
REG_SPEC(S11, s11, triton::bitsize::dword-1, 0, Q11, TT_MUTABLE_REG) // s11
REG_SPEC(S12, s12, triton::bitsize::dword-1, 0, Q12, TT_MUTABLE_REG) // s12
REG_SPEC(S13, s13, triton::bitsize::dword-1, 0, Q13, TT_MUTABLE_REG) // s13
REG_SPEC(S14, s14, triton::bitsize::dword-1, 0, Q14, TT_MUTABLE_REG) // s14
REG_SPEC(S15, s15, triton::bitsize::dword-1, 0, Q15, TT_MUTABLE_REG) // s15
REG_SPEC(S16, s16, triton::bitsize::dword-1, 0, Q16, TT_MUTABLE_REG) // s16
REG_SPEC(S17, s17, triton::bitsize::dword-1, 0, Q17, TT_MUTABLE_REG) // s17
REG_SPEC(S18, s18, triton::bitsize::dword-1, 0, Q18, TT_MUTABLE_REG) // s18
REG_SPEC(S19, s19, triton::bitsize::dword-1, 0, Q19, TT_MUTABLE_REG) // s19
REG_SPEC(S20, s20, triton::bitsize::dword-1, 0, Q20, TT_MUTABLE_REG) // s20
REG_SPEC(S21, s21, triton::bitsize::dword-1, 0, Q21, TT_MUTABLE_REG) // s21
REG_SPEC(S22, s22, triton::bitsize::dword-1, 0, Q22, TT_MUTABLE_REG) // s22
REG_SPEC(S23, s23, triton::bitsize::dword-1, 0, Q23, TT_MUTABLE_REG) // s23
REG_SPEC(S24, s24, triton::bitsize::dword-1, 0, Q24, TT_MUTABLE_REG) // s24
REG_SPEC(S25, s25, triton::bitsize::dword-1, 0, Q25, TT_MUTABLE_REG) // s25
REG_SPEC(S26, s26, triton::bitsize::dword-1, 0, Q26, TT_MUTABLE_REG) // s26
REG_SPEC(S27, s27, triton::bitsize::dword-1, 0, Q27, TT_MUTABLE_REG) // s27
REG_SPEC(S28, s28, triton::bitsize::dword-1, 0, Q28, TT_MUTABLE_REG) // s28
REG_SPEC(S29, s29, triton::bitsize::dword-1, 0, Q29, TT_MUTABLE_REG) // s29
REG_SPEC(S30, s30, triton::bitsize::dword-1, 0, Q30, TT_MUTABLE_REG) // s30
REG_SPEC(S31, s31, triton::bitsize::dword-1, 0, Q31, TT_MUTABLE_REG) // s31

REG_SPEC(H0,  h0,  triton::bitsize::word-1, 0, Q0,  TT_MUTABLE_REG) // h0
REG_SPEC(H1,  h1,  triton::bitsize::word-1, 0, Q1,  TT_MUTABLE_REG) // h1
REG_SPEC(H2,  h2,  triton::bitsize::word-1, 0, Q2,  TT_MUTABLE_REG) // h2
REG_SPEC(H3,  h3,  triton::bitsize::word-1, 0, Q3,  TT_MUTABLE_REG) // h3
REG_SPEC(H4,  h4,  triton::bitsize::word-1, 0, Q4,  TT_MUTABLE_REG) // h4
REG_SPEC(H5,  h5,  triton::bitsize::word-1, 0, Q5,  TT_MUTABLE_REG) // h5
REG_SPEC(H6,  h6,  triton::bitsize::word-1, 0, Q6,  TT_MUTABLE_REG) // h6
REG_SPEC(H7,  h7,  triton::bitsize::word-1, 0, Q7,  TT_MUTABLE_REG) // h7
REG_SPEC(H8,  h8,  triton::bitsize::word-1, 0, Q8,  TT_MUTABLE_REG) // h8
REG_SPEC(H9,  h9,  triton::bitsize::word-1, 0, Q9,  TT_MUTABLE_REG) // h9
REG_SPEC(H10, h10, triton::bitsize::word-1, 0, Q10, TT_MUTABLE_REG) // h10
REG_SPEC(H11, h11, triton::bitsize::word-1, 0, Q11, TT_MUTABLE_REG) // h11
REG_SPEC(H12, h12, triton::bitsize::word-1, 0, Q12, TT_MUTABLE_REG) // h12
REG_SPEC(H13, h13, triton::bitsize::word-1, 0, Q13, TT_MUTABLE_REG) // h13
REG_SPEC(H14, h14, triton::bitsize::word-1, 0, Q14, TT_MUTABLE_REG) // h14
REG_SPEC(H15, h15, triton::bitsize::word-1, 0, Q15, TT_MUTABLE_REG) // h15
REG_SPEC(H16, h16, triton::bitsize::word-1, 0, Q16, TT_MUTABLE_REG) // h16
REG_SPEC(H17, h17, triton::bitsize::word-1, 0, Q17, TT_MUTABLE_REG) // h17
REG_SPEC(H18, h18, triton::bitsize::word-1, 0, Q18, TT_MUTABLE_REG) // h18
REG_SPEC(H19, h19, triton::bitsize::word-1, 0, Q19, TT_MUTABLE_REG) // h19
REG_SPEC(H20, h20, triton::bitsize::word-1, 0, Q20, TT_MUTABLE_REG) // h20
REG_SPEC(H21, h21, triton::bitsize::word-1, 0, Q21, TT_MUTABLE_REG) // h21
REG_SPEC(H22, h22, triton::bitsize::word-1, 0, Q22, TT_MUTABLE_REG) // h22
REG_SPEC(H23, h23, triton::bitsize::word-1, 0, Q23, TT_MUTABLE_REG) // h23
REG_SPEC(H24, h24, triton::bitsize::word-1, 0, Q24, TT_MUTABLE_REG) // h24
REG_SPEC(H25, h25, triton::bitsize::word-1, 0, Q25, TT_MUTABLE_REG) // h25
REG_SPEC(H26, h26, triton::bitsize::word-1, 0, Q26, TT_MUTABLE_REG) // h26
REG_SPEC(H27, h27, triton::bitsize::word-1, 0, Q27, TT_MUTABLE_REG) // h27
REG_SPEC(H28, h28, triton::bitsize::word-1, 0, Q28, TT_MUTABLE_REG) // h28
REG_SPEC(H29, h29, triton::bitsize::word-1, 0, Q29, TT_MUTABLE_REG) // h29
REG_SPEC(H30, h30, triton::bitsize::word-1, 0, Q30, TT_MUTABLE_REG) // h30
REG_SPEC(H31, h31, triton::bitsize::word-1, 0, Q31, TT_MUTABLE_REG) // h31

REG_SPEC(B0,  b0,  triton::bitsize::byte-1, 0, Q0,  TT_MUTABLE_REG) // b0
REG_SPEC(B1,  b1,  triton::bitsize::byte-1, 0, Q1,  TT_MUTABLE_REG) // b1
REG_SPEC(B2,  b2,  triton::bitsize::byte-1, 0, Q2,  TT_MUTABLE_REG) // b2
REG_SPEC(B3,  b3,  triton::bitsize::byte-1, 0, Q3,  TT_MUTABLE_REG) // b3
REG_SPEC(B4,  b4,  triton::bitsize::byte-1, 0, Q4,  TT_MUTABLE_REG) // b4
REG_SPEC(B5,  b5,  triton::bitsize::byte-1, 0, Q5,  TT_MUTABLE_REG) // b5
REG_SPEC(B6,  b6,  triton::bitsize::byte-1, 0, Q6,  TT_MUTABLE_REG) // b6
REG_SPEC(B7,  b7,  triton::bitsize::byte-1, 0, Q7,  TT_MUTABLE_REG) // b7
REG_SPEC(B8,  b8,  triton::bitsize::byte-1, 0, Q8,  TT_MUTABLE_REG) // b8
REG_SPEC(B9,  b9,  triton::bitsize::byte-1, 0, Q9,  TT_MUTABLE_REG) // b9
REG_SPEC(B10, b10, triton::bitsize::byte-1, 0, Q10, TT_MUTABLE_REG) // b10
REG_SPEC(B11, b11, triton::bitsize::byte-1, 0, Q11, TT_MUTABLE_REG) // b11
REG_SPEC(B12, b12, triton::bitsize::byte-1, 0, Q12, TT_MUTABLE_REG) // b12
REG_SPEC(B13, b13, triton::bitsize::byte-1, 0, Q13, TT_MUTABLE_REG) // b13
REG_SPEC(B14, b14, triton::bitsize::byte-1, 0, Q14, TT_MUTABLE_REG) // b14
REG_SPEC(B15, b15, triton::bitsize::byte-1, 0, Q15, TT_MUTABLE_REG) // b15
REG_SPEC(B16, b16, triton::bitsize::byte-1, 0, Q16, TT_MUTABLE_REG) // b16
REG_SPEC(B17, b17, triton::bitsize::byte-1, 0, Q17, TT_MUTABLE_REG) // b17
REG_SPEC(B18, b18, triton::bitsize::byte-1, 0, Q18, TT_MUTABLE_REG) // b18
REG_SPEC(B19, b19, triton::bitsize::byte-1, 0, Q19, TT_MUTABLE_REG) // b19
REG_SPEC(B20, b20, triton::bitsize::byte-1, 0, Q20, TT_MUTABLE_REG) // b20
REG_SPEC(B21, b21, triton::bitsize::byte-1, 0, Q21, TT_MUTABLE_REG) // b21
REG_SPEC(B22, b22, triton::bitsize::byte-1, 0, Q22, TT_MUTABLE_REG) // b22
REG_SPEC(B23, b23, triton::bitsize::byte-1, 0, Q23, TT_MUTABLE_REG) // b23
REG_SPEC(B24, b24, triton::bitsize::byte-1, 0, Q24, TT_MUTABLE_REG) // b24
REG_SPEC(B25, b25, triton::bitsize::byte-1, 0, Q25, TT_MUTABLE_REG) // b25
REG_SPEC(B26, b26, triton::bitsize::byte-1, 0, Q26, TT_MUTABLE_REG) // b26
REG_SPEC(B27, b27, triton::bitsize::byte-1, 0, Q27, TT_MUTABLE_REG) // b27
REG_SPEC(B28, b28, triton::bitsize::byte-1, 0, Q28, TT_MUTABLE_REG) // b28
REG_SPEC(B29, b29, triton::bitsize::byte-1, 0, Q29, TT_MUTABLE_REG) // b29
REG_SPEC(B30, b30, triton::bitsize::byte-1, 0, Q30, TT_MUTABLE_REG) // b30
REG_SPEC(B31, b31, triton::bitsize::byte-1, 0, Q31, TT_MUTABLE_REG) // b31

// Vector Register
REG_SPEC(V0,  v0,  triton::bitsize::dqword-1, 0, Q0,  TT_MUTABLE_REG) // v0
REG_SPEC(V1,  v1,  triton::bitsize::dqword-1, 0, Q1,  TT_MUTABLE_REG) // v1
REG_SPEC(V2,  v2,  triton::bitsize::dqword-1, 0, Q2,  TT_MUTABLE_REG) // v2
REG_SPEC(V3,  v3,  triton::bitsize::dqword-1, 0, Q3,  TT_MUTABLE_REG) // v3
REG_SPEC(V4,  v4,  triton::bitsize::dqword-1, 0, Q4,  TT_MUTABLE_REG) // v4
REG_SPEC(V5,  v5,  triton::bitsize::dqword-1, 0, Q5,  TT_MUTABLE_REG) // v5
REG_SPEC(V6,  v6,  triton::bitsize::dqword-1, 0, Q6,  TT_MUTABLE_REG) // v6
REG_SPEC(V7,  v7,  triton::bitsize::dqword-1, 0, Q7,  TT_MUTABLE_REG) // v7
REG_SPEC(V8,  v8,  triton::bitsize::dqword-1, 0, Q8,  TT_MUTABLE_REG) // v8
REG_SPEC(V9,  v9,  triton::bitsize::dqword-1, 0, Q9,  TT_MUTABLE_REG) // v9
REG_SPEC(V10, v10, triton::bitsize::dqword-1, 0, Q10, TT_MUTABLE_REG) // v10
REG_SPEC(V11, v11, triton::bitsize::dqword-1, 0, Q11, TT_MUTABLE_REG) // v11
REG_SPEC(V12, v12, triton::bitsize::dqword-1, 0, Q12, TT_MUTABLE_REG) // v12
REG_SPEC(V13, v13, triton::bitsize::dqword-1, 0, Q13, TT_MUTABLE_REG) // v13
REG_SPEC(V14, v14, triton::bitsize::dqword-1, 0, Q14, TT_MUTABLE_REG) // v14
REG_SPEC(V15, v15, triton::bitsize::dqword-1, 0, Q15, TT_MUTABLE_REG) // v15
REG_SPEC(V16, v16, triton::bitsize::dqword-1, 0, Q16, TT_MUTABLE_REG) // v16
REG_SPEC(V17, v17, triton::bitsize::dqword-1, 0, Q17, TT_MUTABLE_REG) // v17
REG_SPEC(V18, v18, triton::bitsize::dqword-1, 0, Q18, TT_MUTABLE_REG) // v18
REG_SPEC(V19, v19, triton::bitsize::dqword-1, 0, Q19, TT_MUTABLE_REG) // v19
REG_SPEC(V20, v20, triton::bitsize::dqword-1, 0, Q20, TT_MUTABLE_REG) // v20
REG_SPEC(V21, v21, triton::bitsize::dqword-1, 0, Q21, TT_MUTABLE_REG) // v21
REG_SPEC(V22, v22, triton::bitsize::dqword-1, 0, Q22, TT_MUTABLE_REG) // v22
REG_SPEC(V23, v23, triton::bitsize::dqword-1, 0, Q23, TT_MUTABLE_REG) // v23
REG_SPEC(V24, v24, triton::bitsize::dqword-1, 0, Q24, TT_MUTABLE_REG) // v24
REG_SPEC(V25, v25, triton::bitsize::dqword-1, 0, Q25, TT_MUTABLE_REG) // v25
REG_SPEC(V26, v26, triton::bitsize::dqword-1, 0, Q26, TT_MUTABLE_REG) // v26
REG_SPEC(V27, v27, triton::bitsize::dqword-1, 0, Q27, TT_MUTABLE_REG) // v27
REG_SPEC(V28, v28, triton::bitsize::dqword-1, 0, Q28, TT_MUTABLE_REG) // v28
REG_SPEC(V29, v29, triton::bitsize::dqword-1, 0, Q29, TT_MUTABLE_REG) // v29
REG_SPEC(V30, v30, triton::bitsize::dqword-1, 0, Q30, TT_MUTABLE_REG) // v30
REG_SPEC(V31, v31, triton::bitsize::dqword-1, 0, Q31, TT_MUTABLE_REG) // v31

// System register
SYS_REG_SPEC(ACTLR_EL1,             actlr_el1,          triton::bitsize::qword-1, 0, ACTLR_EL1,         TT_MUTABLE_REG) // actlr_el1
SYS_REG_SPEC(ACTLR_EL2,             actlr_el2,          triton::bitsize::qword-1, 0, ACTLR_EL2,         TT_MUTABLE_REG) // actlr_el2
SYS_REG_SPEC(ACTLR_EL3,             actlr_el3,          triton::bitsize::qword-1, 0, ACTLR_EL3,         TT_MUTABLE_REG) // actlr_el3
SYS_REG_SPEC(AFSR0_EL1,             afsr0_el1,          triton::bitsize::qword-1, 0, AFSR0_EL1,         TT_MUTABLE_REG) // afsr0_el1
SYS_REG_SPEC(AFSR0_EL12,            afsr0_el12,         triton::bitsize::qword-1, 0, AFSR0_EL12,        TT_MUTABLE_REG) // afsr0_el12
SYS_REG_SPEC(AFSR0_EL2,             afsr0_el2,          triton::bitsize::qword-1, 0, AFSR0_EL2,         TT_MUTABLE_REG) // afsr0_el2
SYS_REG_SPEC(AFSR0_EL3,             afsr0_el3,          triton::bitsize::qword-1, 0, AFSR0_EL3,         TT_MUTABLE_REG) // afsr0_el3
SYS_REG_SPEC(AFSR1_EL1,             afsr1_el1,          triton::bitsize::qword-1, 0, AFSR1_EL1,         TT_MUTABLE_REG) // afsr1_el1
SYS_REG_SPEC(AFSR1_EL12,            afsr1_el12,         triton::bitsize::qword-1, 0, AFSR1_EL12,        TT_MUTABLE_REG) // afsr1_el12
SYS_REG_SPEC(AFSR1_EL2,             afsr1_el2,          triton::bitsize::qword-1, 0, AFSR1_EL2,         TT_MUTABLE_REG) // afsr1_el2
SYS_REG_SPEC(AFSR1_EL3,             afsr1_el3,          triton::bitsize::qword-1, 0, AFSR1_EL3,         TT_MUTABLE_REG) // afsr1_el3
SYS_REG_SPEC(AIDR_EL1,              aidr_el1,           triton::bitsize::qword-1, 0, AIDR_EL1,          TT_MUTABLE_REG) // aidr_el1
SYS_REG_SPEC(AMAIR_EL1,             amair_el1,          triton::bitsize::qword-1, 0, AMAIR_EL1,         TT_MUTABLE_REG) // amair_el1
SYS_REG_SPEC(AMAIR_EL12,            amair_el12,         triton::bitsize::qword-1, 0, AMAIR_EL12,        TT_MUTABLE_REG) // amair_el12
SYS_REG_SPEC(AMAIR_EL2,             amair_el2,          triton::bitsize::qword-1, 0, AMAIR_EL2,         TT_MUTABLE_REG) // amair_el2
SYS_REG_SPEC(AMAIR_EL3,             amair_el3,          triton::bitsize::qword-1, 0, AMAIR_EL3,         TT_MUTABLE_REG) // amair_el3
SYS_REG_SPEC(AMCFGR_EL0,            amcfgr_el0,         triton::bitsize::qword-1, 0, AMCFGR_EL0,        TT_MUTABLE_REG) // amcfgr_el0
SYS_REG_SPEC(AMCGCR_EL0,            amcgcr_el0,         triton::bitsize::qword-1, 0, AMCGCR_EL0,        TT_MUTABLE_REG) // amcgcr_el0
SYS_REG_SPEC(AMCNTENCLR0_EL0,       amcntenclr0_el0,    triton::bitsize::qword-1, 0, AMCNTENCLR0_EL0,   TT_MUTABLE_REG) // amcntenclr0_el0
SYS_REG_SPEC(AMCNTENCLR1_EL0,       amcntenclr1_el0,    triton::bitsize::qword-1, 0, AMCNTENCLR1_EL0,   TT_MUTABLE_REG) // amcntenclr1_el0
SYS_REG_SPEC(AMCNTENSET0_EL0,       amcntenset0_el0,    triton::bitsize::qword-1, 0, AMCNTENSET0_EL0,   TT_MUTABLE_REG) // amcntenset0_el0
SYS_REG_SPEC(AMCNTENSET1_EL0,       amcntenset1_el0,    triton::bitsize::qword-1, 0, AMCNTENSET1_EL0,   TT_MUTABLE_REG) // amcntenset1_el0
SYS_REG_SPEC(AMCR_EL0,              amcr_el0,           triton::bitsize::qword-1, 0, AMCR_EL0,          TT_MUTABLE_REG) // amcr_el0
SYS_REG_SPEC(AMEVCNTR00_EL0,        amevcntr00_el0,     triton::bitsize::qword-1, 0, AMEVCNTR00_EL0,    TT_MUTABLE_REG) // amevcntr00_el0
SYS_REG_SPEC(AMEVCNTR01_EL0,        amevcntr01_el0,     triton::bitsize::qword-1, 0, AMEVCNTR01_EL0,    TT_MUTABLE_REG) // amevcntr01_el0
SYS_REG_SPEC(AMEVCNTR02_EL0,        amevcntr02_el0,     triton::bitsize::qword-1, 0, AMEVCNTR02_EL0,    TT_MUTABLE_REG) // amevcntr02_el0
SYS_REG_SPEC(AMEVCNTR03_EL0,        amevcntr03_el0,     triton::bitsize::qword-1, 0, AMEVCNTR03_EL0,    TT_MUTABLE_REG) // amevcntr03_el0
SYS_REG_SPEC(AMEVCNTR10_EL0,        amevcntr10_el0,     triton::bitsize::qword-1, 0, AMEVCNTR10_EL0,    TT_MUTABLE_REG) // amevcntr10_el0
SYS_REG_SPEC(AMEVCNTR110_EL0,       amevcntr110_el0,    triton::bitsize::qword-1, 0, AMEVCNTR110_EL0,   TT_MUTABLE_REG) // amevcntr110_el0
SYS_REG_SPEC(AMEVCNTR111_EL0,       amevcntr111_el0,    triton::bitsize::qword-1, 0, AMEVCNTR111_EL0,   TT_MUTABLE_REG) // amevcntr111_el0
SYS_REG_SPEC(AMEVCNTR112_EL0,       amevcntr112_el0,    triton::bitsize::qword-1, 0, AMEVCNTR112_EL0,   TT_MUTABLE_REG) // amevcntr112_el0
SYS_REG_SPEC(AMEVCNTR113_EL0,       amevcntr113_el0,    triton::bitsize::qword-1, 0, AMEVCNTR113_EL0,   TT_MUTABLE_REG) // amevcntr113_el0
SYS_REG_SPEC(AMEVCNTR114_EL0,       amevcntr114_el0,    triton::bitsize::qword-1, 0, AMEVCNTR114_EL0,   TT_MUTABLE_REG) // amevcntr114_el0
SYS_REG_SPEC(AMEVCNTR115_EL0,       amevcntr115_el0,    triton::bitsize::qword-1, 0, AMEVCNTR115_EL0,   TT_MUTABLE_REG) // amevcntr115_el0
SYS_REG_SPEC(AMEVCNTR11_EL0,        amevcntr11_el0,     triton::bitsize::qword-1, 0, AMEVCNTR11_EL0,    TT_MUTABLE_REG) // amevcntr11_el0
SYS_REG_SPEC(AMEVCNTR12_EL0,        amevcntr12_el0,     triton::bitsize::qword-1, 0, AMEVCNTR12_EL0,    TT_MUTABLE_REG) // amevcntr12_el0
SYS_REG_SPEC(AMEVCNTR13_EL0,        amevcntr13_el0,     triton::bitsize::qword-1, 0, AMEVCNTR13_EL0,    TT_MUTABLE_REG) // amevcntr13_el0
SYS_REG_SPEC(AMEVCNTR14_EL0,        amevcntr14_el0,     triton::bitsize::qword-1, 0, AMEVCNTR14_EL0,    TT_MUTABLE_REG) // amevcntr14_el0
SYS_REG_SPEC(AMEVCNTR15_EL0,        amevcntr15_el0,     triton::bitsize::qword-1, 0, AMEVCNTR15_EL0,    TT_MUTABLE_REG) // amevcntr15_el0
SYS_REG_SPEC(AMEVCNTR16_EL0,        amevcntr16_el0,     triton::bitsize::qword-1, 0, AMEVCNTR16_EL0,    TT_MUTABLE_REG) // amevcntr16_el0
SYS_REG_SPEC(AMEVCNTR17_EL0,        amevcntr17_el0,     triton::bitsize::qword-1, 0, AMEVCNTR17_EL0,    TT_MUTABLE_REG) // amevcntr17_el0
SYS_REG_SPEC(AMEVCNTR18_EL0,        amevcntr18_el0,     triton::bitsize::qword-1, 0, AMEVCNTR18_EL0,    TT_MUTABLE_REG) // amevcntr18_el0
SYS_REG_SPEC(AMEVCNTR19_EL0,        amevcntr19_el0,     triton::bitsize::qword-1, 0, AMEVCNTR19_EL0,    TT_MUTABLE_REG) // amevcntr19_el0
SYS_REG_SPEC(AMEVTYPER00_EL0,       amevtyper00_el0,    triton::bitsize::qword-1, 0, AMEVTYPER00_EL0,   TT_MUTABLE_REG) // amevtyper00_el0
SYS_REG_SPEC(AMEVTYPER01_EL0,       amevtyper01_el0,    triton::bitsize::qword-1, 0, AMEVTYPER01_EL0,   TT_MUTABLE_REG) // amevtyper01_el0
SYS_REG_SPEC(AMEVTYPER02_EL0,       amevtyper02_el0,    triton::bitsize::qword-1, 0, AMEVTYPER02_EL0,   TT_MUTABLE_REG) // amevtyper02_el0
SYS_REG_SPEC(AMEVTYPER03_EL0,       amevtyper03_el0,    triton::bitsize::qword-1, 0, AMEVTYPER03_EL0,   TT_MUTABLE_REG) // amevtyper03_el0
SYS_REG_SPEC(AMEVTYPER10_EL0,       amevtyper10_el0,    triton::bitsize::qword-1, 0, AMEVTYPER10_EL0,   TT_MUTABLE_REG) // amevtyper10_el0
SYS_REG_SPEC(AMEVTYPER110_EL0,      amevtyper110_el0,   triton::bitsize::qword-1, 0, AMEVTYPER110_EL0,  TT_MUTABLE_REG) // amevtyper110_el0
SYS_REG_SPEC(AMEVTYPER111_EL0,      amevtyper111_el0,   triton::bitsize::qword-1, 0, AMEVTYPER111_EL0,  TT_MUTABLE_REG) // amevtyper111_el0
SYS_REG_SPEC(AMEVTYPER112_EL0,      amevtyper112_el0,   triton::bitsize::qword-1, 0, AMEVTYPER112_EL0,  TT_MUTABLE_REG) // amevtyper112_el0
SYS_REG_SPEC(AMEVTYPER113_EL0,      amevtyper113_el0,   triton::bitsize::qword-1, 0, AMEVTYPER113_EL0,  TT_MUTABLE_REG) // amevtyper113_el0
SYS_REG_SPEC(AMEVTYPER114_EL0,      amevtyper114_el0,   triton::bitsize::qword-1, 0, AMEVTYPER114_EL0,  TT_MUTABLE_REG) // amevtyper114_el0
SYS_REG_SPEC(AMEVTYPER115_EL0,      amevtyper115_el0,   triton::bitsize::qword-1, 0, AMEVTYPER115_EL0,  TT_MUTABLE_REG) // amevtyper115_el0
SYS_REG_SPEC(AMEVTYPER11_EL0,       amevtyper11_el0,    triton::bitsize::qword-1, 0, AMEVTYPER11_EL0,   TT_MUTABLE_REG) // amevtyper11_el0
SYS_REG_SPEC(AMEVTYPER12_EL0,       amevtyper12_el0,    triton::bitsize::qword-1, 0, AMEVTYPER12_EL0,   TT_MUTABLE_REG) // amevtyper12_el0
SYS_REG_SPEC(AMEVTYPER13_EL0,       amevtyper13_el0,    triton::bitsize::qword-1, 0, AMEVTYPER13_EL0,   TT_MUTABLE_REG) // amevtyper13_el0
SYS_REG_SPEC(AMEVTYPER14_EL0,       amevtyper14_el0,    triton::bitsize::qword-1, 0, AMEVTYPER14_EL0,   TT_MUTABLE_REG) // amevtyper14_el0
SYS_REG_SPEC(AMEVTYPER15_EL0,       amevtyper15_el0,    triton::bitsize::qword-1, 0, AMEVTYPER15_EL0,   TT_MUTABLE_REG) // amevtyper15_el0
SYS_REG_SPEC(AMEVTYPER16_EL0,       amevtyper16_el0,    triton::bitsize::qword-1, 0, AMEVTYPER16_EL0,   TT_MUTABLE_REG) // amevtyper16_el0
SYS_REG_SPEC(AMEVTYPER17_EL0,       amevtyper17_el0,    triton::bitsize::qword-1, 0, AMEVTYPER17_EL0,   TT_MUTABLE_REG) // amevtyper17_el0
SYS_REG_SPEC(AMEVTYPER18_EL0,       amevtyper18_el0,    triton::bitsize::qword-1, 0, AMEVTYPER18_EL0,   TT_MUTABLE_REG) // amevtyper18_el0
SYS_REG_SPEC(AMEVTYPER19_EL0,       amevtyper19_el0,    triton::bitsize::qword-1, 0, AMEVTYPER19_EL0,   TT_MUTABLE_REG) // amevtyper19_el0
SYS_REG_SPEC(AMUSERENR_EL0,         amuserenr_el0,      triton::bitsize::qword-1, 0, AMUSERENR_EL0,     TT_MUTABLE_REG) // amuserenr_el0
SYS_REG_SPEC(APDAKEYHI_EL1,         apdakeyhi_el1,      triton::bitsize::qword-1, 0, APDAKEYHI_EL1,     TT_MUTABLE_REG) // apdakeyhi_el1
SYS_REG_SPEC(APDAKEYLO_EL1,         apdakeylo_el1,      triton::bitsize::qword-1, 0, APDAKEYLO_EL1,     TT_MUTABLE_REG) // apdakeylo_el1
SYS_REG_SPEC(APDBKEYHI_EL1,         apdbkeyhi_el1,      triton::bitsize::qword-1, 0, APDBKEYHI_EL1,     TT_MUTABLE_REG) // apdbkeyhi_el1
SYS_REG_SPEC(APDBKEYLO_EL1,         apdbkeylo_el1,      triton::bitsize::qword-1, 0, APDBKEYLO_EL1,     TT_MUTABLE_REG) // apdbkeylo_el1
SYS_REG_SPEC(APGAKEYHI_EL1,         apgakeyhi_el1,      triton::bitsize::qword-1, 0, APGAKEYHI_EL1,     TT_MUTABLE_REG) // apgakeyhi_el1
SYS_REG_SPEC(APGAKEYLO_EL1,         apgakeylo_el1,      triton::bitsize::qword-1, 0, APGAKEYLO_EL1,     TT_MUTABLE_REG) // apgakeylo_el1
SYS_REG_SPEC(APIAKEYHI_EL1,         apiakeyhi_el1,      triton::bitsize::qword-1, 0, APIAKEYHI_EL1,     TT_MUTABLE_REG) // apiakeyhi_el1
SYS_REG_SPEC(APIAKEYLO_EL1,         apiakeylo_el1,      triton::bitsize::qword-1, 0, APIAKEYLO_EL1,     TT_MUTABLE_REG) // apiakeylo_el1
SYS_REG_SPEC(APIBKEYHI_EL1,         apibkeyhi_el1,      triton::bitsize::qword-1, 0, APIBKEYHI_EL1,     TT_MUTABLE_REG) // apibkeyhi_el1
SYS_REG_SPEC(APIBKEYLO_EL1,         apibkeylo_el1,      triton::bitsize::qword-1, 0, APIBKEYLO_EL1,     TT_MUTABLE_REG) // apibkeylo_el1
SYS_REG_SPEC(CCSIDR2_EL1,           ccsidr2_el1,        triton::bitsize::qword-1, 0, CCSIDR2_EL1,       TT_MUTABLE_REG) // ccsidr2_el1
SYS_REG_SPEC(CCSIDR_EL1,            ccsidr_el1,         triton::bitsize::qword-1, 0, CCSIDR_EL1,        TT_MUTABLE_REG) // ccsidr_el1
SYS_REG_SPEC(CLIDR_EL1,             clidr_el1,          triton::bitsize::qword-1, 0, CLIDR_EL1,         TT_MUTABLE_REG) // clidr_el1
SYS_REG_SPEC(CNTFRQ_EL0,            cntfrq_el0,         triton::bitsize::qword-1, 0, CNTFRQ_EL0,        TT_MUTABLE_REG) // cntfrq_el0
SYS_REG_SPEC(CNTHCTL_EL2,           cnthctl_el2,        triton::bitsize::qword-1, 0, CNTHCTL_EL2,       TT_MUTABLE_REG) // cnthctl_el2
SYS_REG_SPEC(CNTHPS_CTL_EL2,        cnthps_ctl_el2,     triton::bitsize::qword-1, 0, CNTHPS_CTL_EL2,    TT_MUTABLE_REG) // cnthps_ctl_el2
SYS_REG_SPEC(CNTHPS_CVAL_EL2,       cnthps_cval_el2,    triton::bitsize::qword-1, 0, CNTHPS_CVAL_EL2,   TT_MUTABLE_REG) // cnthps_cval_el2
SYS_REG_SPEC(CNTHPS_TVAL_EL2,       cnthps_tval_el2,    triton::bitsize::qword-1, 0, CNTHPS_TVAL_EL2,   TT_MUTABLE_REG) // cnthps_tval_el2
SYS_REG_SPEC(CNTHP_CTL_EL2,         cnthp_ctl_el2,      triton::bitsize::qword-1, 0, CNTHP_CTL_EL2,     TT_MUTABLE_REG) // cnthp_ctl_el2
SYS_REG_SPEC(CNTHP_CVAL_EL2,        cnthp_cval_el2,     triton::bitsize::qword-1, 0, CNTHP_CVAL_EL2,    TT_MUTABLE_REG) // cnthp_cval_el2
SYS_REG_SPEC(CNTHP_TVAL_EL2,        cnthp_tval_el2,     triton::bitsize::qword-1, 0, CNTHP_TVAL_EL2,    TT_MUTABLE_REG) // cnthp_tval_el2
SYS_REG_SPEC(CNTHVS_CTL_EL2,        cnthvs_ctl_el2,     triton::bitsize::qword-1, 0, CNTHVS_CTL_EL2,    TT_MUTABLE_REG) // cnthvs_ctl_el2
SYS_REG_SPEC(CNTHVS_CVAL_EL2,       cnthvs_cval_el2,    triton::bitsize::qword-1, 0, CNTHVS_CVAL_EL2,   TT_MUTABLE_REG) // cnthvs_cval_el2
SYS_REG_SPEC(CNTHVS_TVAL_EL2,       cnthvs_tval_el2,    triton::bitsize::qword-1, 0, CNTHVS_TVAL_EL2,   TT_MUTABLE_REG) // cnthvs_tval_el2
SYS_REG_SPEC(CNTHV_CTL_EL2,         cnthv_ctl_el2,      triton::bitsize::qword-1, 0, CNTHV_CTL_EL2,     TT_MUTABLE_REG) // cnthv_ctl_el2
SYS_REG_SPEC(CNTHV_CVAL_EL2,        cnthv_cval_el2,     triton::bitsize::qword-1, 0, CNTHV_CVAL_EL2,    TT_MUTABLE_REG) // cnthv_cval_el2
SYS_REG_SPEC(CNTHV_TVAL_EL2,        cnthv_tval_el2,     triton::bitsize::qword-1, 0, CNTHV_TVAL_EL2,    TT_MUTABLE_REG) // cnthv_tval_el2
SYS_REG_SPEC(CNTKCTL_EL1,           cntkctl_el1,        triton::bitsize::qword-1, 0, CNTKCTL_EL1,       TT_MUTABLE_REG) // cntkctl_el1
SYS_REG_SPEC(CNTKCTL_EL12,          cntkctl_el12,       triton::bitsize::qword-1, 0, CNTKCTL_EL12,      TT_MUTABLE_REG) // cntkctl_el12
SYS_REG_SPEC(CNTPCT_EL0,            cntpct_el0,         triton::bitsize::qword-1, 0, CNTPCT_EL0,        TT_MUTABLE_REG) // cntpct_el0
SYS_REG_SPEC(CNTPS_CTL_EL1,         cntps_ctl_el1,      triton::bitsize::qword-1, 0, CNTPS_CTL_EL1,     TT_MUTABLE_REG) // cntps_ctl_el1
SYS_REG_SPEC(CNTPS_CVAL_EL1,        cntps_cval_el1,     triton::bitsize::qword-1, 0, CNTPS_CVAL_EL1,    TT_MUTABLE_REG) // cntps_cval_el1
SYS_REG_SPEC(CNTPS_TVAL_EL1,        cntps_tval_el1,     triton::bitsize::qword-1, 0, CNTPS_TVAL_EL1,    TT_MUTABLE_REG) // cntps_tval_el1
SYS_REG_SPEC(CNTP_CTL_EL0,          cntp_ctl_el0,       triton::bitsize::qword-1, 0, CNTP_CTL_EL0,      TT_MUTABLE_REG) // cntp_ctl_el0
SYS_REG_SPEC(CNTP_CTL_EL02,         cntp_ctl_el02,      triton::bitsize::qword-1, 0, CNTP_CTL_EL02,     TT_MUTABLE_REG) // cntp_ctl_el02
SYS_REG_SPEC(CNTP_CVAL_EL0,         cntp_cval_el0,      triton::bitsize::qword-1, 0, CNTP_CVAL_EL0,     TT_MUTABLE_REG) // cntp_cval_el0
SYS_REG_SPEC(CNTP_CVAL_EL02,        cntp_cval_el02,     triton::bitsize::qword-1, 0, CNTP_CVAL_EL02,    TT_MUTABLE_REG) // cntp_cval_el02
SYS_REG_SPEC(CNTP_TVAL_EL0,         cntp_tval_el0,      triton::bitsize::qword-1, 0, CNTP_TVAL_EL0,     TT_MUTABLE_REG) // cntp_tval_el0
SYS_REG_SPEC(CNTP_TVAL_EL02,        cntp_tval_el02,     triton::bitsize::qword-1, 0, CNTP_TVAL_EL02,    TT_MUTABLE_REG) // cntp_tval_el02
SYS_REG_SPEC(CNTVCT_EL0,            cntvct_el0,         triton::bitsize::qword-1, 0, CNTVCT_EL0,        TT_MUTABLE_REG) // cntvct_el0
SYS_REG_SPEC(CNTVOFF_EL2,           cntvoff_el2,        triton::bitsize::qword-1, 0, CNTVOFF_EL2,       TT_MUTABLE_REG) // cntvoff_el2
SYS_REG_SPEC(CNTV_CTL_EL0,          cntv_ctl_el0,       triton::bitsize::qword-1, 0, CNTV_CTL_EL0,      TT_MUTABLE_REG) // cntv_ctl_el0
SYS_REG_SPEC(CNTV_CTL_EL02,         cntv_ctl_el02,      triton::bitsize::qword-1, 0, CNTV_CTL_EL02,     TT_MUTABLE_REG) // cntv_ctl_el02
SYS_REG_SPEC(CNTV_CVAL_EL0,         cntv_cval_el0,      triton::bitsize::qword-1, 0, CNTV_CVAL_EL0,     TT_MUTABLE_REG) // cntv_cval_el0
SYS_REG_SPEC(CNTV_CVAL_EL02,        cntv_cval_el02,     triton::bitsize::qword-1, 0, CNTV_CVAL_EL02,    TT_MUTABLE_REG) // cntv_cval_el02
SYS_REG_SPEC(CNTV_TVAL_EL0,         cntv_tval_el0,      triton::bitsize::qword-1, 0, CNTV_TVAL_EL0,     TT_MUTABLE_REG) // cntv_tval_el0
SYS_REG_SPEC(CNTV_TVAL_EL02,        cntv_tval_el02,     triton::bitsize::qword-1, 0, CNTV_TVAL_EL02,    TT_MUTABLE_REG) // cntv_tval_el02
SYS_REG_SPEC(CONTEXTIDR_EL1,        contextidr_el1,     triton::bitsize::qword-1, 0, CONTEXTIDR_EL1,    TT_MUTABLE_REG) // contextidr_el1
SYS_REG_SPEC(CONTEXTIDR_EL12,       contextidr_el12,    triton::bitsize::qword-1, 0, CONTEXTIDR_EL12,   TT_MUTABLE_REG) // contextidr_el12
SYS_REG_SPEC(CONTEXTIDR_EL2,        contextidr_el2,     triton::bitsize::qword-1, 0, CONTEXTIDR_EL2,    TT_MUTABLE_REG) // contextidr_el2
SYS_REG_SPEC(CPACR_EL1,             cpacr_el1,          triton::bitsize::qword-1, 0, CPACR_EL1,         TT_MUTABLE_REG) // cpacr_el1
SYS_REG_SPEC(CPACR_EL12,            cpacr_el12,         triton::bitsize::qword-1, 0, CPACR_EL12,        TT_MUTABLE_REG) // cpacr_el12
SYS_REG_SPEC(CPM_IOACC_CTL_EL3,     cpm_ioacc_ctl_el3,  triton::bitsize::qword-1, 0, CPM_IOACC_CTL_EL3, TT_MUTABLE_REG) // cpm_ioacc_ctl_el3
SYS_REG_SPEC(CPTR_EL2,              cptr_el2,           triton::bitsize::qword-1, 0, CPTR_EL2,          TT_MUTABLE_REG) // cptr_el2
SYS_REG_SPEC(CPTR_EL3,              cptr_el3,           triton::bitsize::qword-1, 0, CPTR_EL3,          TT_MUTABLE_REG) // cptr_el3
SYS_REG_SPEC(CSSELR_EL1,            csselr_el1,         triton::bitsize::qword-1, 0, CSSELR_EL1,        TT_MUTABLE_REG) // csselr_el1
SYS_REG_SPEC(CTR_EL0,               ctr_el0,            triton::bitsize::qword-1, 0, CTR_EL0,           TT_MUTABLE_REG) // ctr_el0
SYS_REG_SPEC(CURRENTEL,             currentel,          triton::bitsize::qword-1, 0, CURRENTEL,         TT_MUTABLE_REG) // currentel
SYS_REG_SPEC(DACR32_EL2,            dacr32_el2,         triton::bitsize::qword-1, 0, DACR32_EL2,        TT_MUTABLE_REG) // dacr32_el2
SYS_REG_SPEC(DAIF,                  daif,               triton::bitsize::qword-1, 0, DAIF,              TT_MUTABLE_REG) // daif
SYS_REG_SPEC(DBGAUTHSTATUS_EL1,     dbgauthstatus_el1,  triton::bitsize::qword-1, 0, DBGAUTHSTATUS_EL1, TT_MUTABLE_REG) // dbgauthstatus_el1
SYS_REG_SPEC(DBGBCR0_EL1,           dbgbcr0_el1,        triton::bitsize::qword-1, 0, DBGBCR0_EL1,       TT_MUTABLE_REG) // dbgbcr0_el1
SYS_REG_SPEC(DBGBCR10_EL1,          dbgbcr10_el1,       triton::bitsize::qword-1, 0, DBGBCR10_EL1,      TT_MUTABLE_REG) // dbgbcr10_el1
SYS_REG_SPEC(DBGBCR11_EL1,          dbgbcr11_el1,       triton::bitsize::qword-1, 0, DBGBCR11_EL1,      TT_MUTABLE_REG) // dbgbcr11_el1
SYS_REG_SPEC(DBGBCR12_EL1,          dbgbcr12_el1,       triton::bitsize::qword-1, 0, DBGBCR12_EL1,      TT_MUTABLE_REG) // dbgbcr12_el1
SYS_REG_SPEC(DBGBCR13_EL1,          dbgbcr13_el1,       triton::bitsize::qword-1, 0, DBGBCR13_EL1,      TT_MUTABLE_REG) // dbgbcr13_el1
SYS_REG_SPEC(DBGBCR14_EL1,          dbgbcr14_el1,       triton::bitsize::qword-1, 0, DBGBCR14_EL1,      TT_MUTABLE_REG) // dbgbcr14_el1
SYS_REG_SPEC(DBGBCR15_EL1,          dbgbcr15_el1,       triton::bitsize::qword-1, 0, DBGBCR15_EL1,      TT_MUTABLE_REG) // dbgbcr15_el1
SYS_REG_SPEC(DBGBCR1_EL1,           dbgbcr1_el1,        triton::bitsize::qword-1, 0, DBGBCR1_EL1,       TT_MUTABLE_REG) // dbgbcr1_el1
SYS_REG_SPEC(DBGBCR2_EL1,           dbgbcr2_el1,        triton::bitsize::qword-1, 0, DBGBCR2_EL1,       TT_MUTABLE_REG) // dbgbcr2_el1
SYS_REG_SPEC(DBGBCR3_EL1,           dbgbcr3_el1,        triton::bitsize::qword-1, 0, DBGBCR3_EL1,       TT_MUTABLE_REG) // dbgbcr3_el1
SYS_REG_SPEC(DBGBCR4_EL1,           dbgbcr4_el1,        triton::bitsize::qword-1, 0, DBGBCR4_EL1,       TT_MUTABLE_REG) // dbgbcr4_el1
SYS_REG_SPEC(DBGBCR5_EL1,           dbgbcr5_el1,        triton::bitsize::qword-1, 0, DBGBCR5_EL1,       TT_MUTABLE_REG) // dbgbcr5_el1
SYS_REG_SPEC(DBGBCR6_EL1,           dbgbcr6_el1,        triton::bitsize::qword-1, 0, DBGBCR6_EL1,       TT_MUTABLE_REG) // dbgbcr6_el1
SYS_REG_SPEC(DBGBCR7_EL1,           dbgbcr7_el1,        triton::bitsize::qword-1, 0, DBGBCR7_EL1,       TT_MUTABLE_REG) // dbgbcr7_el1
SYS_REG_SPEC(DBGBCR8_EL1,           dbgbcr8_el1,        triton::bitsize::qword-1, 0, DBGBCR8_EL1,       TT_MUTABLE_REG) // dbgbcr8_el1
SYS_REG_SPEC(DBGBCR9_EL1,           dbgbcr9_el1,        triton::bitsize::qword-1, 0, DBGBCR9_EL1,       TT_MUTABLE_REG) // dbgbcr9_el1
SYS_REG_SPEC(DBGBVR0_EL1,           dbgbvr0_el1,        triton::bitsize::qword-1, 0, DBGBVR0_EL1,       TT_MUTABLE_REG) // dbgbvr0_el1
SYS_REG_SPEC(DBGBVR10_EL1,          dbgbvr10_el1,       triton::bitsize::qword-1, 0, DBGBVR10_EL1,      TT_MUTABLE_REG) // dbgbvr10_el1
SYS_REG_SPEC(DBGBVR11_EL1,          dbgbvr11_el1,       triton::bitsize::qword-1, 0, DBGBVR11_EL1,      TT_MUTABLE_REG) // dbgbvr11_el1
SYS_REG_SPEC(DBGBVR12_EL1,          dbgbvr12_el1,       triton::bitsize::qword-1, 0, DBGBVR12_EL1,      TT_MUTABLE_REG) // dbgbvr12_el1
SYS_REG_SPEC(DBGBVR13_EL1,          dbgbvr13_el1,       triton::bitsize::qword-1, 0, DBGBVR13_EL1,      TT_MUTABLE_REG) // dbgbvr13_el1
SYS_REG_SPEC(DBGBVR14_EL1,          dbgbvr14_el1,       triton::bitsize::qword-1, 0, DBGBVR14_EL1,      TT_MUTABLE_REG) // dbgbvr14_el1
SYS_REG_SPEC(DBGBVR15_EL1,          dbgbvr15_el1,       triton::bitsize::qword-1, 0, DBGBVR15_EL1,      TT_MUTABLE_REG) // dbgbvr15_el1
SYS_REG_SPEC(DBGBVR1_EL1,           dbgbvr1_el1,        triton::bitsize::qword-1, 0, DBGBVR1_EL1,       TT_MUTABLE_REG) // dbgbvr1_el1
SYS_REG_SPEC(DBGBVR2_EL1,           dbgbvr2_el1,        triton::bitsize::qword-1, 0, DBGBVR2_EL1,       TT_MUTABLE_REG) // dbgbvr2_el1
SYS_REG_SPEC(DBGBVR3_EL1,           dbgbvr3_el1,        triton::bitsize::qword-1, 0, DBGBVR3_EL1,       TT_MUTABLE_REG) // dbgbvr3_el1
SYS_REG_SPEC(DBGBVR4_EL1,           dbgbvr4_el1,        triton::bitsize::qword-1, 0, DBGBVR4_EL1,       TT_MUTABLE_REG) // dbgbvr4_el1
SYS_REG_SPEC(DBGBVR5_EL1,           dbgbvr5_el1,        triton::bitsize::qword-1, 0, DBGBVR5_EL1,       TT_MUTABLE_REG) // dbgbvr5_el1
SYS_REG_SPEC(DBGBVR6_EL1,           dbgbvr6_el1,        triton::bitsize::qword-1, 0, DBGBVR6_EL1,       TT_MUTABLE_REG) // dbgbvr6_el1
SYS_REG_SPEC(DBGBVR7_EL1,           dbgbvr7_el1,        triton::bitsize::qword-1, 0, DBGBVR7_EL1,       TT_MUTABLE_REG) // dbgbvr7_el1
SYS_REG_SPEC(DBGBVR8_EL1,           dbgbvr8_el1,        triton::bitsize::qword-1, 0, DBGBVR8_EL1,       TT_MUTABLE_REG) // dbgbvr8_el1
SYS_REG_SPEC(DBGBVR9_EL1,           dbgbvr9_el1,        triton::bitsize::qword-1, 0, DBGBVR9_EL1,       TT_MUTABLE_REG) // dbgbvr9_el1
SYS_REG_SPEC(DBGCLAIMCLR_EL1,       dbgclaimclr_el1,    triton::bitsize::qword-1, 0, DBGCLAIMCLR_EL1,   TT_MUTABLE_REG) // dbgclaimclr_el1
SYS_REG_SPEC(DBGCLAIMSET_EL1,       dbgclaimset_el1,    triton::bitsize::qword-1, 0, DBGCLAIMSET_EL1,   TT_MUTABLE_REG) // dbgclaimset_el1
SYS_REG_SPEC(DBGDTRRX_EL0,          dbgdtrrx_el0,       triton::bitsize::qword-1, 0, DBGDTRRX_EL0,      TT_MUTABLE_REG) // dbgdtrrx_el0
SYS_REG_SPEC(DBGDTR_EL0,            dbgdtr_el0,         triton::bitsize::qword-1, 0, DBGDTR_EL0,        TT_MUTABLE_REG) // dbgdtr_el0
SYS_REG_SPEC(DBGPRCR_EL1,           dbgprcr_el1,        triton::bitsize::qword-1, 0, DBGPRCR_EL1,       TT_MUTABLE_REG) // dbgprcr_el1
SYS_REG_SPEC(DBGVCR32_EL2,          dbgvcr32_el2,       triton::bitsize::qword-1, 0, DBGVCR32_EL2,      TT_MUTABLE_REG) // dbgvcr32_el2
SYS_REG_SPEC(DBGWCR0_EL1,           dbgwcr0_el1,        triton::bitsize::qword-1, 0, DBGWCR0_EL1,       TT_MUTABLE_REG) // dbgwcr0_el1
SYS_REG_SPEC(DBGWCR10_EL1,          dbgwcr10_el1,       triton::bitsize::qword-1, 0, DBGWCR10_EL1,      TT_MUTABLE_REG) // dbgwcr10_el1
SYS_REG_SPEC(DBGWCR11_EL1,          dbgwcr11_el1,       triton::bitsize::qword-1, 0, DBGWCR11_EL1,      TT_MUTABLE_REG) // dbgwcr11_el1
SYS_REG_SPEC(DBGWCR12_EL1,          dbgwcr12_el1,       triton::bitsize::qword-1, 0, DBGWCR12_EL1,      TT_MUTABLE_REG) // dbgwcr12_el1
SYS_REG_SPEC(DBGWCR13_EL1,          dbgwcr13_el1,       triton::bitsize::qword-1, 0, DBGWCR13_EL1,      TT_MUTABLE_REG) // dbgwcr13_el1
SYS_REG_SPEC(DBGWCR14_EL1,          dbgwcr14_el1,       triton::bitsize::qword-1, 0, DBGWCR14_EL1,      TT_MUTABLE_REG) // dbgwcr14_el1
SYS_REG_SPEC(DBGWCR15_EL1,          dbgwcr15_el1,       triton::bitsize::qword-1, 0, DBGWCR15_EL1,      TT_MUTABLE_REG) // dbgwcr15_el1
SYS_REG_SPEC(DBGWCR1_EL1,           dbgwcr1_el1,        triton::bitsize::qword-1, 0, DBGWCR1_EL1,       TT_MUTABLE_REG) // dbgwcr1_el1
SYS_REG_SPEC(DBGWCR2_EL1,           dbgwcr2_el1,        triton::bitsize::qword-1, 0, DBGWCR2_EL1,       TT_MUTABLE_REG) // dbgwcr2_el1
SYS_REG_SPEC(DBGWCR3_EL1,           dbgwcr3_el1,        triton::bitsize::qword-1, 0, DBGWCR3_EL1,       TT_MUTABLE_REG) // dbgwcr3_el1
SYS_REG_SPEC(DBGWCR4_EL1,           dbgwcr4_el1,        triton::bitsize::qword-1, 0, DBGWCR4_EL1,       TT_MUTABLE_REG) // dbgwcr4_el1
SYS_REG_SPEC(DBGWCR5_EL1,           dbgwcr5_el1,        triton::bitsize::qword-1, 0, DBGWCR5_EL1,       TT_MUTABLE_REG) // dbgwcr5_el1
SYS_REG_SPEC(DBGWCR6_EL1,           dbgwcr6_el1,        triton::bitsize::qword-1, 0, DBGWCR6_EL1,       TT_MUTABLE_REG) // dbgwcr6_el1
SYS_REG_SPEC(DBGWCR7_EL1,           dbgwcr7_el1,        triton::bitsize::qword-1, 0, DBGWCR7_EL1,       TT_MUTABLE_REG) // dbgwcr7_el1
SYS_REG_SPEC(DBGWCR8_EL1,           dbgwcr8_el1,        triton::bitsize::qword-1, 0, DBGWCR8_EL1,       TT_MUTABLE_REG) // dbgwcr8_el1
SYS_REG_SPEC(DBGWCR9_EL1,           dbgwcr9_el1,        triton::bitsize::qword-1, 0, DBGWCR9_EL1,       TT_MUTABLE_REG) // dbgwcr9_el1
SYS_REG_SPEC(DBGWVR0_EL1,           dbgwvr0_el1,        triton::bitsize::qword-1, 0, DBGWVR0_EL1,       TT_MUTABLE_REG) // dbgwvr0_el1
SYS_REG_SPEC(DBGWVR10_EL1,          dbgwvr10_el1,       triton::bitsize::qword-1, 0, DBGWVR10_EL1,      TT_MUTABLE_REG) // dbgwvr10_el1
SYS_REG_SPEC(DBGWVR11_EL1,          dbgwvr11_el1,       triton::bitsize::qword-1, 0, DBGWVR11_EL1,      TT_MUTABLE_REG) // dbgwvr11_el1
SYS_REG_SPEC(DBGWVR12_EL1,          dbgwvr12_el1,       triton::bitsize::qword-1, 0, DBGWVR12_EL1,      TT_MUTABLE_REG) // dbgwvr12_el1
SYS_REG_SPEC(DBGWVR13_EL1,          dbgwvr13_el1,       triton::bitsize::qword-1, 0, DBGWVR13_EL1,      TT_MUTABLE_REG) // dbgwvr13_el1
SYS_REG_SPEC(DBGWVR14_EL1,          dbgwvr14_el1,       triton::bitsize::qword-1, 0, DBGWVR14_EL1,      TT_MUTABLE_REG) // dbgwvr14_el1
SYS_REG_SPEC(DBGWVR15_EL1,          dbgwvr15_el1,       triton::bitsize::qword-1, 0, DBGWVR15_EL1,      TT_MUTABLE_REG) // dbgwvr15_el1
SYS_REG_SPEC(DBGWVR1_EL1,           dbgwvr1_el1,        triton::bitsize::qword-1, 0, DBGWVR1_EL1,       TT_MUTABLE_REG) // dbgwvr1_el1
SYS_REG_SPEC(DBGWVR2_EL1,           dbgwvr2_el1,        triton::bitsize::qword-1, 0, DBGWVR2_EL1,       TT_MUTABLE_REG) // dbgwvr2_el1
SYS_REG_SPEC(DBGWVR3_EL1,           dbgwvr3_el1,        triton::bitsize::qword-1, 0, DBGWVR3_EL1,       TT_MUTABLE_REG) // dbgwvr3_el1
SYS_REG_SPEC(DBGWVR4_EL1,           dbgwvr4_el1,        triton::bitsize::qword-1, 0, DBGWVR4_EL1,       TT_MUTABLE_REG) // dbgwvr4_el1
SYS_REG_SPEC(DBGWVR5_EL1,           dbgwvr5_el1,        triton::bitsize::qword-1, 0, DBGWVR5_EL1,       TT_MUTABLE_REG) // dbgwvr5_el1
SYS_REG_SPEC(DBGWVR6_EL1,           dbgwvr6_el1,        triton::bitsize::qword-1, 0, DBGWVR6_EL1,       TT_MUTABLE_REG) // dbgwvr6_el1
SYS_REG_SPEC(DBGWVR7_EL1,           dbgwvr7_el1,        triton::bitsize::qword-1, 0, DBGWVR7_EL1,       TT_MUTABLE_REG) // dbgwvr7_el1
SYS_REG_SPEC(DBGWVR8_EL1,           dbgwvr8_el1,        triton::bitsize::qword-1, 0, DBGWVR8_EL1,       TT_MUTABLE_REG) // dbgwvr8_el1
SYS_REG_SPEC(DBGWVR9_EL1,           dbgwvr9_el1,        triton::bitsize::qword-1, 0, DBGWVR9_EL1,       TT_MUTABLE_REG) // dbgwvr9_el1
SYS_REG_SPEC(DCZID_EL0,             dczid_el0,          triton::bitsize::qword-1, 0, DCZID_EL0,         TT_MUTABLE_REG) // dczid_el0
SYS_REG_SPEC(DISR_EL1,              disr_el1,           triton::bitsize::qword-1, 0, DISR_EL1,          TT_MUTABLE_REG) // disr_el1
SYS_REG_SPEC(DIT,                   dit,                triton::bitsize::qword-1, 0, DIT,               TT_MUTABLE_REG) // dit
SYS_REG_SPEC(DLR_EL0,               dlr_el0,            triton::bitsize::qword-1, 0, DLR_EL0,           TT_MUTABLE_REG) // dlr_el0
SYS_REG_SPEC(DSPSR_EL0,             dspsr_el0,          triton::bitsize::qword-1, 0, DSPSR_EL0,         TT_MUTABLE_REG) // dspsr_el0
SYS_REG_SPEC(ELR_EL1,               elr_el1,            triton::bitsize::qword-1, 0, ELR_EL1,           TT_MUTABLE_REG) // elr_el1
SYS_REG_SPEC(ELR_EL12,              elr_el12,           triton::bitsize::qword-1, 0, ELR_EL12,          TT_MUTABLE_REG) // elr_el12
SYS_REG_SPEC(ELR_EL2,               elr_el2,            triton::bitsize::qword-1, 0, ELR_EL2,           TT_MUTABLE_REG) // elr_el2
SYS_REG_SPEC(ELR_EL3,               elr_el3,            triton::bitsize::qword-1, 0, ELR_EL3,           TT_MUTABLE_REG) // elr_el3
SYS_REG_SPEC(ERRIDR_EL1,            erridr_el1,         triton::bitsize::qword-1, 0, ERRIDR_EL1,        TT_MUTABLE_REG) // erridr_el1
SYS_REG_SPEC(ERRSELR_EL1,           errselr_el1,        triton::bitsize::qword-1, 0, ERRSELR_EL1,       TT_MUTABLE_REG) // errselr_el1
SYS_REG_SPEC(ERXADDR_EL1,           erxaddr_el1,        triton::bitsize::qword-1, 0, ERXADDR_EL1,       TT_MUTABLE_REG) // erxaddr_el1
SYS_REG_SPEC(ERXCTLR_EL1,           erxctlr_el1,        triton::bitsize::qword-1, 0, ERXCTLR_EL1,       TT_MUTABLE_REG) // erxctlr_el1
SYS_REG_SPEC(ERXFR_EL1,             erxfr_el1,          triton::bitsize::qword-1, 0, ERXFR_EL1,         TT_MUTABLE_REG) // erxfr_el1
SYS_REG_SPEC(ERXMISC0_EL1,          erxmisc0_el1,       triton::bitsize::qword-1, 0, ERXMISC0_EL1,      TT_MUTABLE_REG) // erxmisc0_el1
SYS_REG_SPEC(ERXMISC1_EL1,          erxmisc1_el1,       triton::bitsize::qword-1, 0, ERXMISC1_EL1,      TT_MUTABLE_REG) // erxmisc1_el1
SYS_REG_SPEC(ERXMISC2_EL1,          erxmisc2_el1,       triton::bitsize::qword-1, 0, ERXMISC2_EL1,      TT_MUTABLE_REG) // erxmisc2_el1
SYS_REG_SPEC(ERXMISC3_EL1,          erxmisc3_el1,       triton::bitsize::qword-1, 0, ERXMISC3_EL1,      TT_MUTABLE_REG) // erxmisc3_el1
SYS_REG_SPEC(ERXPFGCDN_EL1,         erxpfgcdn_el1,      triton::bitsize::qword-1, 0, ERXPFGCDN_EL1,     TT_MUTABLE_REG) // erxpfgcdn_el1
SYS_REG_SPEC(ERXPFGCTL_EL1,         erxpfgctl_el1,      triton::bitsize::qword-1, 0, ERXPFGCTL_EL1,     TT_MUTABLE_REG) // erxpfgctl_el1
SYS_REG_SPEC(ERXPFGF_EL1,           erxpfgf_el1,        triton::bitsize::qword-1, 0, ERXPFGF_EL1,       TT_MUTABLE_REG) // erxpfgf_el1
SYS_REG_SPEC(ERXSTATUS_EL1,         erxstatus_el1,      triton::bitsize::qword-1, 0, ERXSTATUS_EL1,     TT_MUTABLE_REG) // erxstatus_el1
SYS_REG_SPEC(ESR_EL1,               esr_el1,            triton::bitsize::qword-1, 0, ESR_EL1,           TT_MUTABLE_REG) // esr_el1
SYS_REG_SPEC(ESR_EL12,              esr_el12,           triton::bitsize::qword-1, 0, ESR_EL12,          TT_MUTABLE_REG) // esr_el12
SYS_REG_SPEC(ESR_EL2,               esr_el2,            triton::bitsize::qword-1, 0, ESR_EL2,           TT_MUTABLE_REG) // esr_el2
SYS_REG_SPEC(ESR_EL3,               esr_el3,            triton::bitsize::qword-1, 0, ESR_EL3,           TT_MUTABLE_REG) // esr_el3
SYS_REG_SPEC(FAR_EL1,               far_el1,            triton::bitsize::qword-1, 0, FAR_EL1,           TT_MUTABLE_REG) // far_el1
SYS_REG_SPEC(FAR_EL12,              far_el12,           triton::bitsize::qword-1, 0, FAR_EL12,          TT_MUTABLE_REG) // far_el12
SYS_REG_SPEC(FAR_EL2,               far_el2,            triton::bitsize::qword-1, 0, FAR_EL2,           TT_MUTABLE_REG) // far_el2
SYS_REG_SPEC(FAR_EL3,               far_el3,            triton::bitsize::qword-1, 0, FAR_EL3,           TT_MUTABLE_REG) // far_el3
SYS_REG_SPEC(FPCR,                  fpcr,               triton::bitsize::qword-1, 0, FPCR,              TT_MUTABLE_REG) // fpcr
SYS_REG_SPEC(FPEXC32_EL2,           fpexc32_el2,        triton::bitsize::qword-1, 0, FPEXC32_EL2,       TT_MUTABLE_REG) // fpexc32_el2
SYS_REG_SPEC(FPSR,                  fpsr,               triton::bitsize::qword-1, 0, FPSR,              TT_MUTABLE_REG) // fpsr
SYS_REG_SPEC(HACR_EL2,              hacr_el2,           triton::bitsize::qword-1, 0, HACR_EL2,          TT_MUTABLE_REG) // hacr_el2
SYS_REG_SPEC(HCR_EL2,               hcr_el2,            triton::bitsize::qword-1, 0, HCR_EL2,           TT_MUTABLE_REG) // hcr_el2
SYS_REG_SPEC(HPFAR_EL2,             hpfar_el2,          triton::bitsize::qword-1, 0, HPFAR_EL2,         TT_MUTABLE_REG) // hpfar_el2
SYS_REG_SPEC(HSTR_EL2,              hstr_el2,           triton::bitsize::qword-1, 0, HSTR_EL2,          TT_MUTABLE_REG) // hstr_el2
SYS_REG_SPEC(ICC_AP0R0_EL1,         icc_ap0r0_el1,      triton::bitsize::qword-1, 0, ICC_AP0R0_EL1,     TT_MUTABLE_REG) // icc_ap0r0_el1
SYS_REG_SPEC(ICC_AP0R1_EL1,         icc_ap0r1_el1,      triton::bitsize::qword-1, 0, ICC_AP0R1_EL1,     TT_MUTABLE_REG) // icc_ap0r1_el1
SYS_REG_SPEC(ICC_AP0R2_EL1,         icc_ap0r2_el1,      triton::bitsize::qword-1, 0, ICC_AP0R2_EL1,     TT_MUTABLE_REG) // icc_ap0r2_el1
SYS_REG_SPEC(ICC_AP0R3_EL1,         icc_ap0r3_el1,      triton::bitsize::qword-1, 0, ICC_AP0R3_EL1,     TT_MUTABLE_REG) // icc_ap0r3_el1
SYS_REG_SPEC(ICC_AP1R0_EL1,         icc_ap1r0_el1,      triton::bitsize::qword-1, 0, ICC_AP1R0_EL1,     TT_MUTABLE_REG) // icc_ap1r0_el1
SYS_REG_SPEC(ICC_AP1R1_EL1,         icc_ap1r1_el1,      triton::bitsize::qword-1, 0, ICC_AP1R1_EL1,     TT_MUTABLE_REG) // icc_ap1r1_el1
SYS_REG_SPEC(ICC_AP1R2_EL1,         icc_ap1r2_el1,      triton::bitsize::qword-1, 0, ICC_AP1R2_EL1,     TT_MUTABLE_REG) // icc_ap1r2_el1
SYS_REG_SPEC(ICC_AP1R3_EL1,         icc_ap1r3_el1,      triton::bitsize::qword-1, 0, ICC_AP1R3_EL1,     TT_MUTABLE_REG) // icc_ap1r3_el1
SYS_REG_SPEC(ICC_ASGI1R_EL1,        icc_asgi1r_el1,     triton::bitsize::qword-1, 0, ICC_ASGI1R_EL1,    TT_MUTABLE_REG) // icc_asgi1r_el1
SYS_REG_SPEC(ICC_BPR0_EL1,          icc_bpr0_el1,       triton::bitsize::qword-1, 0, ICC_BPR0_EL1,      TT_MUTABLE_REG) // icc_bpr0_el1
SYS_REG_SPEC(ICC_BPR1_EL1,          icc_bpr1_el1,       triton::bitsize::qword-1, 0, ICC_BPR1_EL1,      TT_MUTABLE_REG) // icc_bpr1_el1
SYS_REG_SPEC(ICC_CTLR_EL1,          icc_ctlr_el1,       triton::bitsize::qword-1, 0, ICC_CTLR_EL1,      TT_MUTABLE_REG) // icc_ctlr_el1
SYS_REG_SPEC(ICC_CTLR_EL3,          icc_ctlr_el3,       triton::bitsize::qword-1, 0, ICC_CTLR_EL3,      TT_MUTABLE_REG) // icc_ctlr_el3
SYS_REG_SPEC(ICC_DIR_EL1,           icc_dir_el1,        triton::bitsize::qword-1, 0, ICC_DIR_EL1,       TT_MUTABLE_REG) // icc_dir_el1
SYS_REG_SPEC(ICC_EOIR0_EL1,         icc_eoir0_el1,      triton::bitsize::qword-1, 0, ICC_EOIR0_EL1,     TT_MUTABLE_REG) // icc_eoir0_el1
SYS_REG_SPEC(ICC_EOIR1_EL1,         icc_eoir1_el1,      triton::bitsize::qword-1, 0, ICC_EOIR1_EL1,     TT_MUTABLE_REG) // icc_eoir1_el1
SYS_REG_SPEC(ICC_HPPIR0_EL1,        icc_hppir0_el1,     triton::bitsize::qword-1, 0, ICC_HPPIR0_EL1,    TT_MUTABLE_REG) // icc_hppir0_el1
SYS_REG_SPEC(ICC_HPPIR1_EL1,        icc_hppir1_el1,     triton::bitsize::qword-1, 0, ICC_HPPIR1_EL1,    TT_MUTABLE_REG) // icc_hppir1_el1
SYS_REG_SPEC(ICC_IAR0_EL1,          icc_iar0_el1,       triton::bitsize::qword-1, 0, ICC_IAR0_EL1,      TT_MUTABLE_REG) // icc_iar0_el1
SYS_REG_SPEC(ICC_IAR1_EL1,          icc_iar1_el1,       triton::bitsize::qword-1, 0, ICC_IAR1_EL1,      TT_MUTABLE_REG) // icc_iar1_el1
SYS_REG_SPEC(ICC_IGRPEN0_EL1,       icc_igrpen0_el1,    triton::bitsize::qword-1, 0, ICC_IGRPEN0_EL1,   TT_MUTABLE_REG) // icc_igrpen0_el1
SYS_REG_SPEC(ICC_IGRPEN1_EL1,       icc_igrpen1_el1,    triton::bitsize::qword-1, 0, ICC_IGRPEN1_EL1,   TT_MUTABLE_REG) // icc_igrpen1_el1
SYS_REG_SPEC(ICC_IGRPEN1_EL3,       icc_igrpen1_el3,    triton::bitsize::qword-1, 0, ICC_IGRPEN1_EL3,   TT_MUTABLE_REG) // icc_igrpen1_el3
SYS_REG_SPEC(ICC_PMR_EL1,           icc_pmr_el1,        triton::bitsize::qword-1, 0, ICC_PMR_EL1,       TT_MUTABLE_REG) // icc_pmr_el1
SYS_REG_SPEC(ICC_RPR_EL1,           icc_rpr_el1,        triton::bitsize::qword-1, 0, ICC_RPR_EL1,       TT_MUTABLE_REG) // icc_rpr_el1
SYS_REG_SPEC(ICC_SGI0R_EL1,         icc_sgi0r_el1,      triton::bitsize::qword-1, 0, ICC_SGI0R_EL1,     TT_MUTABLE_REG) // icc_sgi0r_el1
SYS_REG_SPEC(ICC_SGI1R_EL1,         icc_sgi1r_el1,      triton::bitsize::qword-1, 0, ICC_SGI1R_EL1,     TT_MUTABLE_REG) // icc_sgi1r_el1
SYS_REG_SPEC(ICC_SRE_EL1,           icc_sre_el1,        triton::bitsize::qword-1, 0, ICC_SRE_EL1,       TT_MUTABLE_REG) // icc_sre_el1
SYS_REG_SPEC(ICC_SRE_EL2,           icc_sre_el2,        triton::bitsize::qword-1, 0, ICC_SRE_EL2,       TT_MUTABLE_REG) // icc_sre_el2
SYS_REG_SPEC(ICC_SRE_EL3,           icc_sre_el3,        triton::bitsize::qword-1, 0, ICC_SRE_EL3,       TT_MUTABLE_REG) // icc_sre_el3
SYS_REG_SPEC(ICH_AP0R0_EL2,         ich_ap0r0_el2,      triton::bitsize::qword-1, 0, ICH_AP0R0_EL2,     TT_MUTABLE_REG) // ich_ap0r0_el2
SYS_REG_SPEC(ICH_AP0R1_EL2,         ich_ap0r1_el2,      triton::bitsize::qword-1, 0, ICH_AP0R1_EL2,     TT_MUTABLE_REG) // ich_ap0r1_el2
SYS_REG_SPEC(ICH_AP0R2_EL2,         ich_ap0r2_el2,      triton::bitsize::qword-1, 0, ICH_AP0R2_EL2,     TT_MUTABLE_REG) // ich_ap0r2_el2
SYS_REG_SPEC(ICH_AP0R3_EL2,         ich_ap0r3_el2,      triton::bitsize::qword-1, 0, ICH_AP0R3_EL2,     TT_MUTABLE_REG) // ich_ap0r3_el2
SYS_REG_SPEC(ICH_AP1R0_EL2,         ich_ap1r0_el2,      triton::bitsize::qword-1, 0, ICH_AP1R0_EL2,     TT_MUTABLE_REG) // ich_ap1r0_el2
SYS_REG_SPEC(ICH_AP1R1_EL2,         ich_ap1r1_el2,      triton::bitsize::qword-1, 0, ICH_AP1R1_EL2,     TT_MUTABLE_REG) // ich_ap1r1_el2
SYS_REG_SPEC(ICH_AP1R2_EL2,         ich_ap1r2_el2,      triton::bitsize::qword-1, 0, ICH_AP1R2_EL2,     TT_MUTABLE_REG) // ich_ap1r2_el2
SYS_REG_SPEC(ICH_AP1R3_EL2,         ich_ap1r3_el2,      triton::bitsize::qword-1, 0, ICH_AP1R3_EL2,     TT_MUTABLE_REG) // ich_ap1r3_el2
SYS_REG_SPEC(ICH_EISR_EL2,          ich_eisr_el2,       triton::bitsize::qword-1, 0, ICH_EISR_EL2,      TT_MUTABLE_REG) // ich_eisr_el2
SYS_REG_SPEC(ICH_ELRSR_EL2,         ich_elrsr_el2,      triton::bitsize::qword-1, 0, ICH_ELRSR_EL2,     TT_MUTABLE_REG) // ich_elrsr_el2
SYS_REG_SPEC(ICH_HCR_EL2,           ich_hcr_el2,        triton::bitsize::qword-1, 0, ICH_HCR_EL2,       TT_MUTABLE_REG) // ich_hcr_el2
SYS_REG_SPEC(ICH_LR0_EL2,           ich_lr0_el2,        triton::bitsize::qword-1, 0, ICH_LR0_EL2,       TT_MUTABLE_REG) // ich_lr0_el2
SYS_REG_SPEC(ICH_LR10_EL2,          ich_lr10_el2,       triton::bitsize::qword-1, 0, ICH_LR10_EL2,      TT_MUTABLE_REG) // ich_lr10_el2
SYS_REG_SPEC(ICH_LR11_EL2,          ich_lr11_el2,       triton::bitsize::qword-1, 0, ICH_LR11_EL2,      TT_MUTABLE_REG) // ich_lr11_el2
SYS_REG_SPEC(ICH_LR12_EL2,          ich_lr12_el2,       triton::bitsize::qword-1, 0, ICH_LR12_EL2,      TT_MUTABLE_REG) // ich_lr12_el2
SYS_REG_SPEC(ICH_LR13_EL2,          ich_lr13_el2,       triton::bitsize::qword-1, 0, ICH_LR13_EL2,      TT_MUTABLE_REG) // ich_lr13_el2
SYS_REG_SPEC(ICH_LR14_EL2,          ich_lr14_el2,       triton::bitsize::qword-1, 0, ICH_LR14_EL2,      TT_MUTABLE_REG) // ich_lr14_el2
SYS_REG_SPEC(ICH_LR15_EL2,          ich_lr15_el2,       triton::bitsize::qword-1, 0, ICH_LR15_EL2,      TT_MUTABLE_REG) // ich_lr15_el2
SYS_REG_SPEC(ICH_LR1_EL2,           ich_lr1_el2,        triton::bitsize::qword-1, 0, ICH_LR1_EL2,       TT_MUTABLE_REG) // ich_lr1_el2
SYS_REG_SPEC(ICH_LR2_EL2,           ich_lr2_el2,        triton::bitsize::qword-1, 0, ICH_LR2_EL2,       TT_MUTABLE_REG) // ich_lr2_el2
SYS_REG_SPEC(ICH_LR3_EL2,           ich_lr3_el2,        triton::bitsize::qword-1, 0, ICH_LR3_EL2,       TT_MUTABLE_REG) // ich_lr3_el2
SYS_REG_SPEC(ICH_LR4_EL2,           ich_lr4_el2,        triton::bitsize::qword-1, 0, ICH_LR4_EL2,       TT_MUTABLE_REG) // ich_lr4_el2
SYS_REG_SPEC(ICH_LR5_EL2,           ich_lr5_el2,        triton::bitsize::qword-1, 0, ICH_LR5_EL2,       TT_MUTABLE_REG) // ich_lr5_el2
SYS_REG_SPEC(ICH_LR6_EL2,           ich_lr6_el2,        triton::bitsize::qword-1, 0, ICH_LR6_EL2,       TT_MUTABLE_REG) // ich_lr6_el2
SYS_REG_SPEC(ICH_LR7_EL2,           ich_lr7_el2,        triton::bitsize::qword-1, 0, ICH_LR7_EL2,       TT_MUTABLE_REG) // ich_lr7_el2
SYS_REG_SPEC(ICH_LR8_EL2,           ich_lr8_el2,        triton::bitsize::qword-1, 0, ICH_LR8_EL2,       TT_MUTABLE_REG) // ich_lr8_el2
SYS_REG_SPEC(ICH_LR9_EL2,           ich_lr9_el2,        triton::bitsize::qword-1, 0, ICH_LR9_EL2,       TT_MUTABLE_REG) // ich_lr9_el2
SYS_REG_SPEC(ICH_MISR_EL2,          ich_misr_el2,       triton::bitsize::qword-1, 0, ICH_MISR_EL2,      TT_MUTABLE_REG) // ich_misr_el2
SYS_REG_SPEC(ICH_VMCR_EL2,          ich_vmcr_el2,       triton::bitsize::qword-1, 0, ICH_VMCR_EL2,      TT_MUTABLE_REG) // ich_vmcr_el2
SYS_REG_SPEC(ICH_VTR_EL2,           ich_vtr_el2,        triton::bitsize::qword-1, 0, ICH_VTR_EL2,       TT_MUTABLE_REG) // ich_vtr_el2
SYS_REG_SPEC(ID_AA64AFR0_EL1,       id_aa64afr0_el1,    triton::bitsize::qword-1, 0, ID_AA64AFR0_EL1,   TT_MUTABLE_REG) // id_aa64afr0_el1
SYS_REG_SPEC(ID_AA64AFR1_EL1,       id_aa64afr1_el1,    triton::bitsize::qword-1, 0, ID_AA64AFR1_EL1,   TT_MUTABLE_REG) // id_aa64afr1_el1
SYS_REG_SPEC(ID_AA64DFR0_EL1,       id_aa64dfr0_el1,    triton::bitsize::qword-1, 0, ID_AA64DFR0_EL1,   TT_MUTABLE_REG) // id_aa64dfr0_el1
SYS_REG_SPEC(ID_AA64DFR1_EL1,       id_aa64dfr1_el1,    triton::bitsize::qword-1, 0, ID_AA64DFR1_EL1,   TT_MUTABLE_REG) // id_aa64dfr1_el1
SYS_REG_SPEC(ID_AA64ISAR0_EL1,      id_aa64isar0_el1,   triton::bitsize::qword-1, 0, ID_AA64ISAR0_EL1,  TT_MUTABLE_REG) // id_aa64isar0_el1
SYS_REG_SPEC(ID_AA64ISAR1_EL1,      id_aa64isar1_el1,   triton::bitsize::qword-1, 0, ID_AA64ISAR1_EL1,  TT_MUTABLE_REG) // id_aa64isar1_el1
SYS_REG_SPEC(ID_AA64MMFR0_EL1,      id_aa64mmfr0_el1,   triton::bitsize::qword-1, 0, ID_AA64MMFR0_EL1,  TT_MUTABLE_REG) // id_aa64mmfr0_el1
SYS_REG_SPEC(ID_AA64MMFR1_EL1,      id_aa64mmfr1_el1,   triton::bitsize::qword-1, 0, ID_AA64MMFR1_EL1,  TT_MUTABLE_REG) // id_aa64mmfr1_el1
SYS_REG_SPEC(ID_AA64MMFR2_EL1,      id_aa64mmfr2_el1,   triton::bitsize::qword-1, 0, ID_AA64MMFR2_EL1,  TT_MUTABLE_REG) // id_aa64mmfr2_el1
SYS_REG_SPEC(ID_AA64PFR0_EL1,       id_aa64pfr0_el1,    triton::bitsize::qword-1, 0, ID_AA64PFR0_EL1,   TT_MUTABLE_REG) // id_aa64pfr0_el1
SYS_REG_SPEC(ID_AA64PFR1_EL1,       id_aa64pfr1_el1,    triton::bitsize::qword-1, 0, ID_AA64PFR1_EL1,   TT_MUTABLE_REG) // id_aa64pfr1_el1
SYS_REG_SPEC(ID_AA64ZFR0_EL1,       id_aa64zfr0_el1,    triton::bitsize::qword-1, 0, ID_AA64ZFR0_EL1,   TT_MUTABLE_REG) // id_aa64zfr0_el1
SYS_REG_SPEC(ID_AFR0_EL1,           id_afr0_el1,        triton::bitsize::qword-1, 0, ID_AFR0_EL1,       TT_MUTABLE_REG) // id_afr0_el1
SYS_REG_SPEC(ID_DFR0_EL1,           id_dfr0_el1,        triton::bitsize::qword-1, 0, ID_DFR0_EL1,       TT_MUTABLE_REG) // id_dfr0_el1
SYS_REG_SPEC(ID_ISAR0_EL1,          id_isar0_el1,       triton::bitsize::qword-1, 0, ID_ISAR0_EL1,      TT_MUTABLE_REG) // id_isar0_el1
SYS_REG_SPEC(ID_ISAR1_EL1,          id_isar1_el1,       triton::bitsize::qword-1, 0, ID_ISAR1_EL1,      TT_MUTABLE_REG) // id_isar1_el1
SYS_REG_SPEC(ID_ISAR2_EL1,          id_isar2_el1,       triton::bitsize::qword-1, 0, ID_ISAR2_EL1,      TT_MUTABLE_REG) // id_isar2_el1
SYS_REG_SPEC(ID_ISAR3_EL1,          id_isar3_el1,       triton::bitsize::qword-1, 0, ID_ISAR3_EL1,      TT_MUTABLE_REG) // id_isar3_el1
SYS_REG_SPEC(ID_ISAR4_EL1,          id_isar4_el1,       triton::bitsize::qword-1, 0, ID_ISAR4_EL1,      TT_MUTABLE_REG) // id_isar4_el1
SYS_REG_SPEC(ID_ISAR5_EL1,          id_isar5_el1,       triton::bitsize::qword-1, 0, ID_ISAR5_EL1,      TT_MUTABLE_REG) // id_isar5_el1
SYS_REG_SPEC(ID_ISAR6_EL1,          id_isar6_el1,       triton::bitsize::qword-1, 0, ID_ISAR6_EL1,      TT_MUTABLE_REG) // id_isar6_el1
SYS_REG_SPEC(ID_MMFR0_EL1,          id_mmfr0_el1,       triton::bitsize::qword-1, 0, ID_MMFR0_EL1,      TT_MUTABLE_REG) // id_mmfr0_el1
SYS_REG_SPEC(ID_MMFR1_EL1,          id_mmfr1_el1,       triton::bitsize::qword-1, 0, ID_MMFR1_EL1,      TT_MUTABLE_REG) // id_mmfr1_el1
SYS_REG_SPEC(ID_MMFR2_EL1,          id_mmfr2_el1,       triton::bitsize::qword-1, 0, ID_MMFR2_EL1,      TT_MUTABLE_REG) // id_mmfr2_el1
SYS_REG_SPEC(ID_MMFR3_EL1,          id_mmfr3_el1,       triton::bitsize::qword-1, 0, ID_MMFR3_EL1,      TT_MUTABLE_REG) // id_mmfr3_el1
SYS_REG_SPEC(ID_MMFR4_EL1,          id_mmfr4_el1,       triton::bitsize::qword-1, 0, ID_MMFR4_EL1,      TT_MUTABLE_REG) // id_mmfr4_el1
SYS_REG_SPEC(ID_PFR0_EL1,           id_pfr0_el1,        triton::bitsize::qword-1, 0, ID_PFR0_EL1,       TT_MUTABLE_REG) // id_pfr0_el1
SYS_REG_SPEC(ID_PFR1_EL1,           id_pfr1_el1,        triton::bitsize::qword-1, 0, ID_PFR1_EL1,       TT_MUTABLE_REG) // id_pfr1_el1
SYS_REG_SPEC(IFSR32_EL2,            ifsr32_el2,         triton::bitsize::qword-1, 0, IFSR32_EL2,        TT_MUTABLE_REG) // ifsr32_el2
SYS_REG_SPEC(ISR_EL1,               isr_el1,            triton::bitsize::qword-1, 0, ISR_EL1,           TT_MUTABLE_REG) // isr_el1
SYS_REG_SPEC(LORC_EL1,              lorc_el1,           triton::bitsize::qword-1, 0, LORC_EL1,          TT_MUTABLE_REG) // lorc_el1
SYS_REG_SPEC(LOREA_EL1,             lorea_el1,          triton::bitsize::qword-1, 0, LOREA_EL1,         TT_MUTABLE_REG) // lorea_el1
SYS_REG_SPEC(LORID_EL1,             lorid_el1,          triton::bitsize::qword-1, 0, LORID_EL1,         TT_MUTABLE_REG) // lorid_el1
SYS_REG_SPEC(LORN_EL1,              lorn_el1,           triton::bitsize::qword-1, 0, LORN_EL1,          TT_MUTABLE_REG) // lorn_el1
SYS_REG_SPEC(LORSA_EL1,             lorsa_el1,          triton::bitsize::qword-1, 0, LORSA_EL1,         TT_MUTABLE_REG) // lorsa_el1
SYS_REG_SPEC(MAIR_EL1,              mair_el1,           triton::bitsize::qword-1, 0, MAIR_EL1,          TT_MUTABLE_REG) // mair_el1
SYS_REG_SPEC(MAIR_EL12,             mair_el12,          triton::bitsize::qword-1, 0, MAIR_EL12,         TT_MUTABLE_REG) // mair_el12
SYS_REG_SPEC(MAIR_EL2,              mair_el2,           triton::bitsize::qword-1, 0, MAIR_EL2,          TT_MUTABLE_REG) // mair_el2
SYS_REG_SPEC(MAIR_EL3,              mair_el3,           triton::bitsize::qword-1, 0, MAIR_EL3,          TT_MUTABLE_REG) // mair_el3
SYS_REG_SPEC(MDCCINT_EL1,           mdccint_el1,        triton::bitsize::qword-1, 0, MDCCINT_EL1,       TT_MUTABLE_REG) // mdccint_el1
SYS_REG_SPEC(MDCCSR_EL0,            mdccsr_el0,         triton::bitsize::qword-1, 0, MDCCSR_EL0,        TT_MUTABLE_REG) // mdccsr_el0
SYS_REG_SPEC(MDCR_EL2,              mdcr_el2,           triton::bitsize::qword-1, 0, MDCR_EL2,          TT_MUTABLE_REG) // mdcr_el2
SYS_REG_SPEC(MDCR_EL3,              mdcr_el3,           triton::bitsize::qword-1, 0, MDCR_EL3,          TT_MUTABLE_REG) // mdcr_el3
SYS_REG_SPEC(MDRAR_EL1,             mdrar_el1,          triton::bitsize::qword-1, 0, MDRAR_EL1,         TT_MUTABLE_REG) // mdrar_el1
SYS_REG_SPEC(MDSCR_EL1,             mdscr_el1,          triton::bitsize::qword-1, 0, MDSCR_EL1,         TT_MUTABLE_REG) // mdscr_el1
SYS_REG_SPEC(MIDR_EL1,              midr_el1,           triton::bitsize::qword-1, 0, MIDR_EL1,          TT_MUTABLE_REG) // midr_el1
SYS_REG_SPEC(MPAM0_EL1,             mpam0_el1,          triton::bitsize::qword-1, 0, MPAM0_EL1,         TT_MUTABLE_REG) // mpam0_el1
SYS_REG_SPEC(MPAM1_EL1,             mpam1_el1,          triton::bitsize::qword-1, 0, MPAM1_EL1,         TT_MUTABLE_REG) // mpam1_el1
SYS_REG_SPEC(MPAM1_EL12,            mpam1_el12,         triton::bitsize::qword-1, 0, MPAM1_EL12,        TT_MUTABLE_REG) // mpam1_el12
SYS_REG_SPEC(MPAM2_EL2,             mpam2_el2,          triton::bitsize::qword-1, 0, MPAM2_EL2,         TT_MUTABLE_REG) // mpam2_el2
SYS_REG_SPEC(MPAM3_EL3,             mpam3_el3,          triton::bitsize::qword-1, 0, MPAM3_EL3,         TT_MUTABLE_REG) // mpam3_el3
SYS_REG_SPEC(MPAMHCR_EL2,           mpamhcr_el2,        triton::bitsize::qword-1, 0, MPAMHCR_EL2,       TT_MUTABLE_REG) // mpamhcr_el2
SYS_REG_SPEC(MPAMIDR_EL1,           mpamidr_el1,        triton::bitsize::qword-1, 0, MPAMIDR_EL1,       TT_MUTABLE_REG) // mpamidr_el1
SYS_REG_SPEC(MPAMVPM0_EL2,          mpamvpm0_el2,       triton::bitsize::qword-1, 0, MPAMVPM0_EL2,      TT_MUTABLE_REG) // mpamvpm0_el2
SYS_REG_SPEC(MPAMVPM1_EL2,          mpamvpm1_el2,       triton::bitsize::qword-1, 0, MPAMVPM1_EL2,      TT_MUTABLE_REG) // mpamvpm1_el2
SYS_REG_SPEC(MPAMVPM2_EL2,          mpamvpm2_el2,       triton::bitsize::qword-1, 0, MPAMVPM2_EL2,      TT_MUTABLE_REG) // mpamvpm2_el2
SYS_REG_SPEC(MPAMVPM3_EL2,          mpamvpm3_el2,       triton::bitsize::qword-1, 0, MPAMVPM3_EL2,      TT_MUTABLE_REG) // mpamvpm3_el2
SYS_REG_SPEC(MPAMVPM4_EL2,          mpamvpm4_el2,       triton::bitsize::qword-1, 0, MPAMVPM4_EL2,      TT_MUTABLE_REG) // mpamvpm4_el2
SYS_REG_SPEC(MPAMVPM5_EL2,          mpamvpm5_el2,       triton::bitsize::qword-1, 0, MPAMVPM5_EL2,      TT_MUTABLE_REG) // mpamvpm5_el2
SYS_REG_SPEC(MPAMVPM6_EL2,          mpamvpm6_el2,       triton::bitsize::qword-1, 0, MPAMVPM6_EL2,      TT_MUTABLE_REG) // mpamvpm6_el2
SYS_REG_SPEC(MPAMVPM7_EL2,          mpamvpm7_el2,       triton::bitsize::qword-1, 0, MPAMVPM7_EL2,      TT_MUTABLE_REG) // mpamvpm7_el2
SYS_REG_SPEC(MPAMVPMV_EL2,          mpamvpmv_el2,       triton::bitsize::qword-1, 0, MPAMVPMV_EL2,      TT_MUTABLE_REG) // mpamvpmv_el2
SYS_REG_SPEC(MPIDR_EL1,             mpidr_el1,          triton::bitsize::qword-1, 0, MPIDR_EL1,         TT_MUTABLE_REG) // mpidr_el1
SYS_REG_SPEC(MVFR0_EL1,             mvfr0_el1,          triton::bitsize::qword-1, 0, MVFR0_EL1,         TT_MUTABLE_REG) // mvfr0_el1
SYS_REG_SPEC(MVFR1_EL1,             mvfr1_el1,          triton::bitsize::qword-1, 0, MVFR1_EL1,         TT_MUTABLE_REG) // mvfr1_el1
SYS_REG_SPEC(MVFR2_EL1,             mvfr2_el1,          triton::bitsize::qword-1, 0, MVFR2_EL1,         TT_MUTABLE_REG) // mvfr2_el1
SYS_REG_SPEC(NZCV,                  nzcv,               triton::bitsize::qword-1, 0, NZCV,              TT_MUTABLE_REG) // nzcv
SYS_REG_SPEC(OSDLR_EL1,             osdlr_el1,          triton::bitsize::qword-1, 0, OSDLR_EL1,         TT_MUTABLE_REG) // osdlr_el1
SYS_REG_SPEC(OSDTRRX_EL1,           osdtrrx_el1,        triton::bitsize::qword-1, 0, OSDTRRX_EL1,       TT_MUTABLE_REG) // osdtrrx_el1
SYS_REG_SPEC(OSDTRTX_EL1,           osdtrtx_el1,        triton::bitsize::qword-1, 0, OSDTRTX_EL1,       TT_MUTABLE_REG) // osdtrtx_el1
SYS_REG_SPEC(OSECCR_EL1,            oseccr_el1,         triton::bitsize::qword-1, 0, OSECCR_EL1,        TT_MUTABLE_REG) // oseccr_el1
SYS_REG_SPEC(OSLAR_EL1,             oslar_el1,          triton::bitsize::qword-1, 0, OSLAR_EL1,         TT_MUTABLE_REG) // oslar_el1
SYS_REG_SPEC(OSLSR_EL1,             oslsr_el1,          triton::bitsize::qword-1, 0, OSLSR_EL1,         TT_MUTABLE_REG) // oslsr_el1
SYS_REG_SPEC(PAN,                   pan,                triton::bitsize::qword-1, 0, PAN,               TT_MUTABLE_REG) // pan
SYS_REG_SPEC(PAR_EL1,               par_el1,            triton::bitsize::qword-1, 0, PAR_EL1,           TT_MUTABLE_REG) // par_el1
SYS_REG_SPEC(PMBIDR_EL1,            pmbidr_el1,         triton::bitsize::qword-1, 0, PMBIDR_EL1,        TT_MUTABLE_REG) // pmbidr_el1
SYS_REG_SPEC(PMBLIMITR_EL1,         pmblimitr_el1,      triton::bitsize::qword-1, 0, PMBLIMITR_EL1,     TT_MUTABLE_REG) // pmblimitr_el1
SYS_REG_SPEC(PMBPTR_EL1,            pmbptr_el1,         triton::bitsize::qword-1, 0, PMBPTR_EL1,        TT_MUTABLE_REG) // pmbptr_el1
SYS_REG_SPEC(PMBSR_EL1,             pmbsr_el1,          triton::bitsize::qword-1, 0, PMBSR_EL1,         TT_MUTABLE_REG) // pmbsr_el1
SYS_REG_SPEC(PMCCFILTR_EL0,         pmccfiltr_el0,      triton::bitsize::qword-1, 0, PMCCFILTR_EL0,     TT_MUTABLE_REG) // pmccfiltr_el0
SYS_REG_SPEC(PMCCNTR_EL0,           pmccntr_el0,        triton::bitsize::qword-1, 0, PMCCNTR_EL0,       TT_MUTABLE_REG) // pmccntr_el0
SYS_REG_SPEC(PMCEID0_EL0,           pmceid0_el0,        triton::bitsize::qword-1, 0, PMCEID0_EL0,       TT_MUTABLE_REG) // pmceid0_el0
SYS_REG_SPEC(PMCEID1_EL0,           pmceid1_el0,        triton::bitsize::qword-1, 0, PMCEID1_EL0,       TT_MUTABLE_REG) // pmceid1_el0
SYS_REG_SPEC(PMCNTENCLR_EL0,        pmcntenclr_el0,     triton::bitsize::qword-1, 0, PMCNTENCLR_EL0,    TT_MUTABLE_REG) // pmcntenclr_el0
SYS_REG_SPEC(PMCNTENSET_EL0,        pmcntenset_el0,     triton::bitsize::qword-1, 0, PMCNTENSET_EL0,    TT_MUTABLE_REG) // pmcntenset_el0
SYS_REG_SPEC(PMCR_EL0,              pmcr_el0,           triton::bitsize::qword-1, 0, PMCR_EL0,          TT_MUTABLE_REG) // pmcr_el0
SYS_REG_SPEC(PMEVCNTR0_EL0,         pmevcntr0_el0,      triton::bitsize::qword-1, 0, PMEVCNTR0_EL0,     TT_MUTABLE_REG) // pmevcntr0_el0
SYS_REG_SPEC(PMEVCNTR10_EL0,        pmevcntr10_el0,     triton::bitsize::qword-1, 0, PMEVCNTR10_EL0,    TT_MUTABLE_REG) // pmevcntr10_el0
SYS_REG_SPEC(PMEVCNTR11_EL0,        pmevcntr11_el0,     triton::bitsize::qword-1, 0, PMEVCNTR11_EL0,    TT_MUTABLE_REG) // pmevcntr11_el0
SYS_REG_SPEC(PMEVCNTR12_EL0,        pmevcntr12_el0,     triton::bitsize::qword-1, 0, PMEVCNTR12_EL0,    TT_MUTABLE_REG) // pmevcntr12_el0
SYS_REG_SPEC(PMEVCNTR13_EL0,        pmevcntr13_el0,     triton::bitsize::qword-1, 0, PMEVCNTR13_EL0,    TT_MUTABLE_REG) // pmevcntr13_el0
SYS_REG_SPEC(PMEVCNTR14_EL0,        pmevcntr14_el0,     triton::bitsize::qword-1, 0, PMEVCNTR14_EL0,    TT_MUTABLE_REG) // pmevcntr14_el0
SYS_REG_SPEC(PMEVCNTR15_EL0,        pmevcntr15_el0,     triton::bitsize::qword-1, 0, PMEVCNTR15_EL0,    TT_MUTABLE_REG) // pmevcntr15_el0
SYS_REG_SPEC(PMEVCNTR16_EL0,        pmevcntr16_el0,     triton::bitsize::qword-1, 0, PMEVCNTR16_EL0,    TT_MUTABLE_REG) // pmevcntr16_el0
SYS_REG_SPEC(PMEVCNTR17_EL0,        pmevcntr17_el0,     triton::bitsize::qword-1, 0, PMEVCNTR17_EL0,    TT_MUTABLE_REG) // pmevcntr17_el0
SYS_REG_SPEC(PMEVCNTR18_EL0,        pmevcntr18_el0,     triton::bitsize::qword-1, 0, PMEVCNTR18_EL0,    TT_MUTABLE_REG) // pmevcntr18_el0
SYS_REG_SPEC(PMEVCNTR19_EL0,        pmevcntr19_el0,     triton::bitsize::qword-1, 0, PMEVCNTR19_EL0,    TT_MUTABLE_REG) // pmevcntr19_el0
SYS_REG_SPEC(PMEVCNTR1_EL0,         pmevcntr1_el0,      triton::bitsize::qword-1, 0, PMEVCNTR1_EL0,     TT_MUTABLE_REG) // pmevcntr1_el0
SYS_REG_SPEC(PMEVCNTR20_EL0,        pmevcntr20_el0,     triton::bitsize::qword-1, 0, PMEVCNTR20_EL0,    TT_MUTABLE_REG) // pmevcntr20_el0
SYS_REG_SPEC(PMEVCNTR21_EL0,        pmevcntr21_el0,     triton::bitsize::qword-1, 0, PMEVCNTR21_EL0,    TT_MUTABLE_REG) // pmevcntr21_el0
SYS_REG_SPEC(PMEVCNTR22_EL0,        pmevcntr22_el0,     triton::bitsize::qword-1, 0, PMEVCNTR22_EL0,    TT_MUTABLE_REG) // pmevcntr22_el0
SYS_REG_SPEC(PMEVCNTR23_EL0,        pmevcntr23_el0,     triton::bitsize::qword-1, 0, PMEVCNTR23_EL0,    TT_MUTABLE_REG) // pmevcntr23_el0
SYS_REG_SPEC(PMEVCNTR24_EL0,        pmevcntr24_el0,     triton::bitsize::qword-1, 0, PMEVCNTR24_EL0,    TT_MUTABLE_REG) // pmevcntr24_el0
SYS_REG_SPEC(PMEVCNTR25_EL0,        pmevcntr25_el0,     triton::bitsize::qword-1, 0, PMEVCNTR25_EL0,    TT_MUTABLE_REG) // pmevcntr25_el0
SYS_REG_SPEC(PMEVCNTR26_EL0,        pmevcntr26_el0,     triton::bitsize::qword-1, 0, PMEVCNTR26_EL0,    TT_MUTABLE_REG) // pmevcntr26_el0
SYS_REG_SPEC(PMEVCNTR27_EL0,        pmevcntr27_el0,     triton::bitsize::qword-1, 0, PMEVCNTR27_EL0,    TT_MUTABLE_REG) // pmevcntr27_el0
SYS_REG_SPEC(PMEVCNTR28_EL0,        pmevcntr28_el0,     triton::bitsize::qword-1, 0, PMEVCNTR28_EL0,    TT_MUTABLE_REG) // pmevcntr28_el0
SYS_REG_SPEC(PMEVCNTR29_EL0,        pmevcntr29_el0,     triton::bitsize::qword-1, 0, PMEVCNTR29_EL0,    TT_MUTABLE_REG) // pmevcntr29_el0
SYS_REG_SPEC(PMEVCNTR2_EL0,         pmevcntr2_el0,      triton::bitsize::qword-1, 0, PMEVCNTR2_EL0,     TT_MUTABLE_REG) // pmevcntr2_el0
SYS_REG_SPEC(PMEVCNTR30_EL0,        pmevcntr30_el0,     triton::bitsize::qword-1, 0, PMEVCNTR30_EL0,    TT_MUTABLE_REG) // pmevcntr30_el0
SYS_REG_SPEC(PMEVCNTR3_EL0,         pmevcntr3_el0,      triton::bitsize::qword-1, 0, PMEVCNTR3_EL0,     TT_MUTABLE_REG) // pmevcntr3_el0
SYS_REG_SPEC(PMEVCNTR4_EL0,         pmevcntr4_el0,      triton::bitsize::qword-1, 0, PMEVCNTR4_EL0,     TT_MUTABLE_REG) // pmevcntr4_el0
SYS_REG_SPEC(PMEVCNTR5_EL0,         pmevcntr5_el0,      triton::bitsize::qword-1, 0, PMEVCNTR5_EL0,     TT_MUTABLE_REG) // pmevcntr5_el0
SYS_REG_SPEC(PMEVCNTR6_EL0,         pmevcntr6_el0,      triton::bitsize::qword-1, 0, PMEVCNTR6_EL0,     TT_MUTABLE_REG) // pmevcntr6_el0
SYS_REG_SPEC(PMEVCNTR7_EL0,         pmevcntr7_el0,      triton::bitsize::qword-1, 0, PMEVCNTR7_EL0,     TT_MUTABLE_REG) // pmevcntr7_el0
SYS_REG_SPEC(PMEVCNTR8_EL0,         pmevcntr8_el0,      triton::bitsize::qword-1, 0, PMEVCNTR8_EL0,     TT_MUTABLE_REG) // pmevcntr8_el0
SYS_REG_SPEC(PMEVCNTR9_EL0,         pmevcntr9_el0,      triton::bitsize::qword-1, 0, PMEVCNTR9_EL0,     TT_MUTABLE_REG) // pmevcntr9_el0
SYS_REG_SPEC(PMEVTYPER0_EL0,        pmevtyper0_el0,     triton::bitsize::qword-1, 0, PMEVTYPER0_EL0,    TT_MUTABLE_REG) // pmevtyper0_el0
SYS_REG_SPEC(PMEVTYPER10_EL0,       pmevtyper10_el0,    triton::bitsize::qword-1, 0, PMEVTYPER10_EL0,   TT_MUTABLE_REG) // pmevtyper10_el0
SYS_REG_SPEC(PMEVTYPER11_EL0,       pmevtyper11_el0,    triton::bitsize::qword-1, 0, PMEVTYPER11_EL0,   TT_MUTABLE_REG) // pmevtyper11_el0
SYS_REG_SPEC(PMEVTYPER12_EL0,       pmevtyper12_el0,    triton::bitsize::qword-1, 0, PMEVTYPER12_EL0,   TT_MUTABLE_REG) // pmevtyper12_el0
SYS_REG_SPEC(PMEVTYPER13_EL0,       pmevtyper13_el0,    triton::bitsize::qword-1, 0, PMEVTYPER13_EL0,   TT_MUTABLE_REG) // pmevtyper13_el0
SYS_REG_SPEC(PMEVTYPER14_EL0,       pmevtyper14_el0,    triton::bitsize::qword-1, 0, PMEVTYPER14_EL0,   TT_MUTABLE_REG) // pmevtyper14_el0
SYS_REG_SPEC(PMEVTYPER15_EL0,       pmevtyper15_el0,    triton::bitsize::qword-1, 0, PMEVTYPER15_EL0,   TT_MUTABLE_REG) // pmevtyper15_el0
SYS_REG_SPEC(PMEVTYPER16_EL0,       pmevtyper16_el0,    triton::bitsize::qword-1, 0, PMEVTYPER16_EL0,   TT_MUTABLE_REG) // pmevtyper16_el0
SYS_REG_SPEC(PMEVTYPER17_EL0,       pmevtyper17_el0,    triton::bitsize::qword-1, 0, PMEVTYPER17_EL0,   TT_MUTABLE_REG) // pmevtyper17_el0
SYS_REG_SPEC(PMEVTYPER18_EL0,       pmevtyper18_el0,    triton::bitsize::qword-1, 0, PMEVTYPER18_EL0,   TT_MUTABLE_REG) // pmevtyper18_el0
SYS_REG_SPEC(PMEVTYPER19_EL0,       pmevtyper19_el0,    triton::bitsize::qword-1, 0, PMEVTYPER19_EL0,   TT_MUTABLE_REG) // pmevtyper19_el0
SYS_REG_SPEC(PMEVTYPER1_EL0,        pmevtyper1_el0,     triton::bitsize::qword-1, 0, PMEVTYPER1_EL0,    TT_MUTABLE_REG) // pmevtyper1_el0
SYS_REG_SPEC(PMEVTYPER20_EL0,       pmevtyper20_el0,    triton::bitsize::qword-1, 0, PMEVTYPER20_EL0,   TT_MUTABLE_REG) // pmevtyper20_el0
SYS_REG_SPEC(PMEVTYPER21_EL0,       pmevtyper21_el0,    triton::bitsize::qword-1, 0, PMEVTYPER21_EL0,   TT_MUTABLE_REG) // pmevtyper21_el0
SYS_REG_SPEC(PMEVTYPER22_EL0,       pmevtyper22_el0,    triton::bitsize::qword-1, 0, PMEVTYPER22_EL0,   TT_MUTABLE_REG) // pmevtyper22_el0
SYS_REG_SPEC(PMEVTYPER23_EL0,       pmevtyper23_el0,    triton::bitsize::qword-1, 0, PMEVTYPER23_EL0,   TT_MUTABLE_REG) // pmevtyper23_el0
SYS_REG_SPEC(PMEVTYPER24_EL0,       pmevtyper24_el0,    triton::bitsize::qword-1, 0, PMEVTYPER24_EL0,   TT_MUTABLE_REG) // pmevtyper24_el0
SYS_REG_SPEC(PMEVTYPER25_EL0,       pmevtyper25_el0,    triton::bitsize::qword-1, 0, PMEVTYPER25_EL0,   TT_MUTABLE_REG) // pmevtyper25_el0
SYS_REG_SPEC(PMEVTYPER26_EL0,       pmevtyper26_el0,    triton::bitsize::qword-1, 0, PMEVTYPER26_EL0,   TT_MUTABLE_REG) // pmevtyper26_el0
SYS_REG_SPEC(PMEVTYPER27_EL0,       pmevtyper27_el0,    triton::bitsize::qword-1, 0, PMEVTYPER27_EL0,   TT_MUTABLE_REG) // pmevtyper27_el0
SYS_REG_SPEC(PMEVTYPER28_EL0,       pmevtyper28_el0,    triton::bitsize::qword-1, 0, PMEVTYPER28_EL0,   TT_MUTABLE_REG) // pmevtyper28_el0
SYS_REG_SPEC(PMEVTYPER29_EL0,       pmevtyper29_el0,    triton::bitsize::qword-1, 0, PMEVTYPER29_EL0,   TT_MUTABLE_REG) // pmevtyper29_el0
SYS_REG_SPEC(PMEVTYPER2_EL0,        pmevtyper2_el0,     triton::bitsize::qword-1, 0, PMEVTYPER2_EL0,    TT_MUTABLE_REG) // pmevtyper2_el0
SYS_REG_SPEC(PMEVTYPER30_EL0,       pmevtyper30_el0,    triton::bitsize::qword-1, 0, PMEVTYPER30_EL0,   TT_MUTABLE_REG) // pmevtyper30_el0
SYS_REG_SPEC(PMEVTYPER3_EL0,        pmevtyper3_el0,     triton::bitsize::qword-1, 0, PMEVTYPER3_EL0,    TT_MUTABLE_REG) // pmevtyper3_el0
SYS_REG_SPEC(PMEVTYPER4_EL0,        pmevtyper4_el0,     triton::bitsize::qword-1, 0, PMEVTYPER4_EL0,    TT_MUTABLE_REG) // pmevtyper4_el0
SYS_REG_SPEC(PMEVTYPER5_EL0,        pmevtyper5_el0,     triton::bitsize::qword-1, 0, PMEVTYPER5_EL0,    TT_MUTABLE_REG) // pmevtyper5_el0
SYS_REG_SPEC(PMEVTYPER6_EL0,        pmevtyper6_el0,     triton::bitsize::qword-1, 0, PMEVTYPER6_EL0,    TT_MUTABLE_REG) // pmevtyper6_el0
SYS_REG_SPEC(PMEVTYPER7_EL0,        pmevtyper7_el0,     triton::bitsize::qword-1, 0, PMEVTYPER7_EL0,    TT_MUTABLE_REG) // pmevtyper7_el0
SYS_REG_SPEC(PMEVTYPER8_EL0,        pmevtyper8_el0,     triton::bitsize::qword-1, 0, PMEVTYPER8_EL0,    TT_MUTABLE_REG) // pmevtyper8_el0
SYS_REG_SPEC(PMEVTYPER9_EL0,        pmevtyper9_el0,     triton::bitsize::qword-1, 0, PMEVTYPER9_EL0,    TT_MUTABLE_REG) // pmevtyper9_el0
SYS_REG_SPEC(PMINTENCLR_EL1,        pmintenclr_el1,     triton::bitsize::qword-1, 0, PMINTENCLR_EL1,    TT_MUTABLE_REG) // pmintenclr_el1
SYS_REG_SPEC(PMINTENSET_EL1,        pmintenset_el1,     triton::bitsize::qword-1, 0, PMINTENSET_EL1,    TT_MUTABLE_REG) // pmintenset_el1
SYS_REG_SPEC(PMOVSCLR_EL0,          pmovsclr_el0,       triton::bitsize::qword-1, 0, PMOVSCLR_EL0,      TT_MUTABLE_REG) // pmovsclr_el0
SYS_REG_SPEC(PMOVSSET_EL0,          pmovsset_el0,       triton::bitsize::qword-1, 0, PMOVSSET_EL0,      TT_MUTABLE_REG) // pmovsset_el0
SYS_REG_SPEC(PMSCR_EL1,             pmscr_el1,          triton::bitsize::qword-1, 0, PMSCR_EL1,         TT_MUTABLE_REG) // pmscr_el1
SYS_REG_SPEC(PMSCR_EL12,            pmscr_el12,         triton::bitsize::qword-1, 0, PMSCR_EL12,        TT_MUTABLE_REG) // pmscr_el12
SYS_REG_SPEC(PMSCR_EL2,             pmscr_el2,          triton::bitsize::qword-1, 0, PMSCR_EL2,         TT_MUTABLE_REG) // pmscr_el2
SYS_REG_SPEC(PMSELR_EL0,            pmselr_el0,         triton::bitsize::qword-1, 0, PMSELR_EL0,        TT_MUTABLE_REG) // pmselr_el0
SYS_REG_SPEC(PMSEVFR_EL1,           pmsevfr_el1,        triton::bitsize::qword-1, 0, PMSEVFR_EL1,       TT_MUTABLE_REG) // pmsevfr_el1
SYS_REG_SPEC(PMSFCR_EL1,            pmsfcr_el1,         triton::bitsize::qword-1, 0, PMSFCR_EL1,        TT_MUTABLE_REG) // pmsfcr_el1
SYS_REG_SPEC(PMSICR_EL1,            pmsicr_el1,         triton::bitsize::qword-1, 0, PMSICR_EL1,        TT_MUTABLE_REG) // pmsicr_el1
SYS_REG_SPEC(PMSIDR_EL1,            pmsidr_el1,         triton::bitsize::qword-1, 0, PMSIDR_EL1,        TT_MUTABLE_REG) // pmsidr_el1
SYS_REG_SPEC(PMSIRR_EL1,            pmsirr_el1,         triton::bitsize::qword-1, 0, PMSIRR_EL1,        TT_MUTABLE_REG) // pmsirr_el1
SYS_REG_SPEC(PMSLATFR_EL1,          pmslatfr_el1,       triton::bitsize::qword-1, 0, PMSLATFR_EL1,      TT_MUTABLE_REG) // pmslatfr_el1
SYS_REG_SPEC(PMSWINC_EL0,           pmswinc_el0,        triton::bitsize::qword-1, 0, PMSWINC_EL0,       TT_MUTABLE_REG) // pmswinc_el0
SYS_REG_SPEC(PMUSERENR_EL0,         pmuserenr_el0,      triton::bitsize::qword-1, 0, PMUSERENR_EL0,     TT_MUTABLE_REG) // pmuserenr_el0
SYS_REG_SPEC(PMXEVCNTR_EL0,         pmxevcntr_el0,      triton::bitsize::qword-1, 0, PMXEVCNTR_EL0,     TT_MUTABLE_REG) // pmxevcntr_el0
SYS_REG_SPEC(PMXEVTYPER_EL0,        pmxevtyper_el0,     triton::bitsize::qword-1, 0, PMXEVTYPER_EL0,    TT_MUTABLE_REG) // pmxevtyper_el0
SYS_REG_SPEC(REVIDR_EL1,            revidr_el1,         triton::bitsize::qword-1, 0, REVIDR_EL1,        TT_MUTABLE_REG) // revidr_el1
SYS_REG_SPEC(RMR_EL1,               rmr_el1,            triton::bitsize::qword-1, 0, RMR_EL1,           TT_MUTABLE_REG) // rmr_el1
SYS_REG_SPEC(RMR_EL2,               rmr_el2,            triton::bitsize::qword-1, 0, RMR_EL2,           TT_MUTABLE_REG) // rmr_el2
SYS_REG_SPEC(RMR_EL3,               rmr_el3,            triton::bitsize::qword-1, 0, RMR_EL3,           TT_MUTABLE_REG) // rmr_el3
SYS_REG_SPEC(RVBAR_EL1,             rvbar_el1,          triton::bitsize::qword-1, 0, RVBAR_EL1,         TT_MUTABLE_REG) // rvbar_el1
SYS_REG_SPEC(RVBAR_EL2,             rvbar_el2,          triton::bitsize::qword-1, 0, RVBAR_EL2,         TT_MUTABLE_REG) // rvbar_el2
SYS_REG_SPEC(RVBAR_EL3,             rvbar_el3,          triton::bitsize::qword-1, 0, RVBAR_EL3,         TT_MUTABLE_REG) // rvbar_el3
SYS_REG_SPEC(SCR_EL3,               scr_el3,            triton::bitsize::qword-1, 0, SCR_EL3,           TT_MUTABLE_REG) // scr_el3
SYS_REG_SPEC(SCTLR_EL1,             sctlr_el1,          triton::bitsize::qword-1, 0, SCTLR_EL1,         TT_MUTABLE_REG) // sctlr_el1
SYS_REG_SPEC(SCTLR_EL12,            sctlr_el12,         triton::bitsize::qword-1, 0, SCTLR_EL12,        TT_MUTABLE_REG) // sctlr_el12
SYS_REG_SPEC(SCTLR_EL2,             sctlr_el2,          triton::bitsize::qword-1, 0, SCTLR_EL2,         TT_MUTABLE_REG) // sctlr_el2
SYS_REG_SPEC(SCTLR_EL3,             sctlr_el3,          triton::bitsize::qword-1, 0, SCTLR_EL3,         TT_MUTABLE_REG) // sctlr_el3
SYS_REG_SPEC(SDER32_EL2,            sder32_el2,         triton::bitsize::qword-1, 0, SDER32_EL2,        TT_MUTABLE_REG) // sder32_el2
SYS_REG_SPEC(SDER32_EL3,            sder32_el3,         triton::bitsize::qword-1, 0, SDER32_EL3,        TT_MUTABLE_REG) // sder32_el3
SYS_REG_SPEC(SPSEL,                 spsel,              triton::bitsize::qword-1, 0, SPSEL,             TT_MUTABLE_REG) // spsel
SYS_REG_SPEC(SPSR_ABT,              spsr_abt,           triton::bitsize::qword-1, 0, SPSR_ABT,          TT_MUTABLE_REG) // spsr_abt
SYS_REG_SPEC(SPSR_EL1,              spsr_el1,           triton::bitsize::qword-1, 0, SPSR_EL1,          TT_MUTABLE_REG) // spsr_el1
SYS_REG_SPEC(SPSR_EL12,             spsr_el12,          triton::bitsize::qword-1, 0, SPSR_EL12,         TT_MUTABLE_REG) // spsr_el12
SYS_REG_SPEC(SPSR_EL2,              spsr_el2,           triton::bitsize::qword-1, 0, SPSR_EL2,          TT_MUTABLE_REG) // spsr_el2
SYS_REG_SPEC(SPSR_EL3,              spsr_el3,           triton::bitsize::qword-1, 0, SPSR_EL3,          TT_MUTABLE_REG) // spsr_el3
SYS_REG_SPEC(SPSR_FIQ,              spsr_fiq,           triton::bitsize::qword-1, 0, SPSR_FIQ,          TT_MUTABLE_REG) // spsr_fiq
SYS_REG_SPEC(SPSR_IRQ,              spsr_irq,           triton::bitsize::qword-1, 0, SPSR_IRQ,          TT_MUTABLE_REG) // spsr_irq
SYS_REG_SPEC(SPSR_UND,              spsr_und,           triton::bitsize::qword-1, 0, SPSR_UND,          TT_MUTABLE_REG) // spsr_und
SYS_REG_SPEC(SP_EL0,                sp_el0,             triton::bitsize::qword-1, 0, SP_EL0,            TT_MUTABLE_REG) // sp_el0
SYS_REG_SPEC(SP_EL1,                sp_el1,             triton::bitsize::qword-1, 0, SP_EL1,            TT_MUTABLE_REG) // sp_el1
SYS_REG_SPEC(SP_EL2,                sp_el2,             triton::bitsize::qword-1, 0, SP_EL2,            TT_MUTABLE_REG) // sp_el2
SYS_REG_SPEC(TCR_EL1,               tcr_el1,            triton::bitsize::qword-1, 0, TCR_EL1,           TT_MUTABLE_REG) // tcr_el1
SYS_REG_SPEC(TCR_EL12,              tcr_el12,           triton::bitsize::qword-1, 0, TCR_EL12,          TT_MUTABLE_REG) // tcr_el12
SYS_REG_SPEC(TCR_EL2,               tcr_el2,            triton::bitsize::qword-1, 0, TCR_EL2,           TT_MUTABLE_REG) // tcr_el2
SYS_REG_SPEC(TCR_EL3,               tcr_el3,            triton::bitsize::qword-1, 0, TCR_EL3,           TT_MUTABLE_REG) // tcr_el3
SYS_REG_SPEC(TEECR32_EL1,           teecr32_el1,        triton::bitsize::qword-1, 0, TEECR32_EL1,       TT_MUTABLE_REG) // teecr32_el1
SYS_REG_SPEC(TEEHBR32_EL1,          teehbr32_el1,       triton::bitsize::qword-1, 0, TEEHBR32_EL1,      TT_MUTABLE_REG) // teehbr32_el1
SYS_REG_SPEC(TPIDRRO_EL0,           tpidrro_el0,        triton::bitsize::qword-1, 0, TPIDRRO_EL0,       TT_MUTABLE_REG) // tpidrro_el0
SYS_REG_SPEC(TPIDR_EL0,             tpidr_el0,          triton::bitsize::qword-1, 0, TPIDR_EL0,         TT_MUTABLE_REG) // tpidr_el0
SYS_REG_SPEC(TPIDR_EL1,             tpidr_el1,          triton::bitsize::qword-1, 0, TPIDR_EL1,         TT_MUTABLE_REG) // tpidr_el1
SYS_REG_SPEC(TPIDR_EL2,             tpidr_el2,          triton::bitsize::qword-1, 0, TPIDR_EL2,         TT_MUTABLE_REG) // tpidr_el2
SYS_REG_SPEC(TPIDR_EL3,             tpidr_el3,          triton::bitsize::qword-1, 0, TPIDR_EL3,         TT_MUTABLE_REG) // tpidr_el3
SYS_REG_SPEC(TRCACATR0,             trcacatr0,          triton::bitsize::qword-1, 0, TRCACATR0,         TT_MUTABLE_REG) // trcacatr0
SYS_REG_SPEC(TRCACATR1,             trcacatr1,          triton::bitsize::qword-1, 0, TRCACATR1,         TT_MUTABLE_REG) // trcacatr1
SYS_REG_SPEC(TRCACATR10,            trcacatr10,         triton::bitsize::qword-1, 0, TRCACATR10,        TT_MUTABLE_REG) // trcacatr10
SYS_REG_SPEC(TRCACATR11,            trcacatr11,         triton::bitsize::qword-1, 0, TRCACATR11,        TT_MUTABLE_REG) // trcacatr11
SYS_REG_SPEC(TRCACATR12,            trcacatr12,         triton::bitsize::qword-1, 0, TRCACATR12,        TT_MUTABLE_REG) // trcacatr12
SYS_REG_SPEC(TRCACATR13,            trcacatr13,         triton::bitsize::qword-1, 0, TRCACATR13,        TT_MUTABLE_REG) // trcacatr13
SYS_REG_SPEC(TRCACATR14,            trcacatr14,         triton::bitsize::qword-1, 0, TRCACATR14,        TT_MUTABLE_REG) // trcacatr14
SYS_REG_SPEC(TRCACATR15,            trcacatr15,         triton::bitsize::qword-1, 0, TRCACATR15,        TT_MUTABLE_REG) // trcacatr15
SYS_REG_SPEC(TRCACATR2,             trcacatr2,          triton::bitsize::qword-1, 0, TRCACATR2,         TT_MUTABLE_REG) // trcacatr2
SYS_REG_SPEC(TRCACATR3,             trcacatr3,          triton::bitsize::qword-1, 0, TRCACATR3,         TT_MUTABLE_REG) // trcacatr3
SYS_REG_SPEC(TRCACATR4,             trcacatr4,          triton::bitsize::qword-1, 0, TRCACATR4,         TT_MUTABLE_REG) // trcacatr4
SYS_REG_SPEC(TRCACATR5,             trcacatr5,          triton::bitsize::qword-1, 0, TRCACATR5,         TT_MUTABLE_REG) // trcacatr5
SYS_REG_SPEC(TRCACATR6,             trcacatr6,          triton::bitsize::qword-1, 0, TRCACATR6,         TT_MUTABLE_REG) // trcacatr6
SYS_REG_SPEC(TRCACATR7,             trcacatr7,          triton::bitsize::qword-1, 0, TRCACATR7,         TT_MUTABLE_REG) // trcacatr7
SYS_REG_SPEC(TRCACATR8,             trcacatr8,          triton::bitsize::qword-1, 0, TRCACATR8,         TT_MUTABLE_REG) // trcacatr8
SYS_REG_SPEC(TRCACATR9,             trcacatr9,          triton::bitsize::qword-1, 0, TRCACATR9,         TT_MUTABLE_REG) // trcacatr9
SYS_REG_SPEC(TRCACVR0,              trcacvr0,           triton::bitsize::qword-1, 0, TRCACVR0,          TT_MUTABLE_REG) // trcacvr0
SYS_REG_SPEC(TRCACVR1,              trcacvr1,           triton::bitsize::qword-1, 0, TRCACVR1,          TT_MUTABLE_REG) // trcacvr1
SYS_REG_SPEC(TRCACVR10,             trcacvr10,          triton::bitsize::qword-1, 0, TRCACVR10,         TT_MUTABLE_REG) // trcacvr10
SYS_REG_SPEC(TRCACVR11,             trcacvr11,          triton::bitsize::qword-1, 0, TRCACVR11,         TT_MUTABLE_REG) // trcacvr11
SYS_REG_SPEC(TRCACVR12,             trcacvr12,          triton::bitsize::qword-1, 0, TRCACVR12,         TT_MUTABLE_REG) // trcacvr12
SYS_REG_SPEC(TRCACVR13,             trcacvr13,          triton::bitsize::qword-1, 0, TRCACVR13,         TT_MUTABLE_REG) // trcacvr13
SYS_REG_SPEC(TRCACVR14,             trcacvr14,          triton::bitsize::qword-1, 0, TRCACVR14,         TT_MUTABLE_REG) // trcacvr14
SYS_REG_SPEC(TRCACVR15,             trcacvr15,          triton::bitsize::qword-1, 0, TRCACVR15,         TT_MUTABLE_REG) // trcacvr15
SYS_REG_SPEC(TRCACVR2,              trcacvr2,           triton::bitsize::qword-1, 0, TRCACVR2,          TT_MUTABLE_REG) // trcacvr2
SYS_REG_SPEC(TRCACVR3,              trcacvr3,           triton::bitsize::qword-1, 0, TRCACVR3,          TT_MUTABLE_REG) // trcacvr3
SYS_REG_SPEC(TRCACVR4,              trcacvr4,           triton::bitsize::qword-1, 0, TRCACVR4,          TT_MUTABLE_REG) // trcacvr4
SYS_REG_SPEC(TRCACVR5,              trcacvr5,           triton::bitsize::qword-1, 0, TRCACVR5,          TT_MUTABLE_REG) // trcacvr5
SYS_REG_SPEC(TRCACVR6,              trcacvr6,           triton::bitsize::qword-1, 0, TRCACVR6,          TT_MUTABLE_REG) // trcacvr6
SYS_REG_SPEC(TRCACVR7,              trcacvr7,           triton::bitsize::qword-1, 0, TRCACVR7,          TT_MUTABLE_REG) // trcacvr7
SYS_REG_SPEC(TRCACVR8,              trcacvr8,           triton::bitsize::qword-1, 0, TRCACVR8,          TT_MUTABLE_REG) // trcacvr8
SYS_REG_SPEC(TRCACVR9,              trcacvr9,           triton::bitsize::qword-1, 0, TRCACVR9,          TT_MUTABLE_REG) // trcacvr9
SYS_REG_SPEC(TRCAUTHSTATUS,         trcauthstatus,      triton::bitsize::qword-1, 0, TRCAUTHSTATUS,     TT_MUTABLE_REG) // trcauthstatus
SYS_REG_SPEC(TRCAUXCTLR,            trcauxctlr,         triton::bitsize::qword-1, 0, TRCAUXCTLR,        TT_MUTABLE_REG) // trcauxctlr
SYS_REG_SPEC(TRCBBCTLR,             trcbbctlr,          triton::bitsize::qword-1, 0, TRCBBCTLR,         TT_MUTABLE_REG) // trcbbctlr
SYS_REG_SPEC(TRCCCCTLR,             trcccctlr,          triton::bitsize::qword-1, 0, TRCCCCTLR,         TT_MUTABLE_REG) // trcccctlr
SYS_REG_SPEC(TRCCIDCCTLR0,          trccidcctlr0,       triton::bitsize::qword-1, 0, TRCCIDCCTLR0,      TT_MUTABLE_REG) // trccidcctlr0
SYS_REG_SPEC(TRCCIDCCTLR1,          trccidcctlr1,       triton::bitsize::qword-1, 0, TRCCIDCCTLR1,      TT_MUTABLE_REG) // trccidcctlr1
SYS_REG_SPEC(TRCCIDCVR0,            trccidcvr0,         triton::bitsize::qword-1, 0, TRCCIDCVR0,        TT_MUTABLE_REG) // trccidcvr0
SYS_REG_SPEC(TRCCIDCVR1,            trccidcvr1,         triton::bitsize::qword-1, 0, TRCCIDCVR1,        TT_MUTABLE_REG) // trccidcvr1
SYS_REG_SPEC(TRCCIDCVR2,            trccidcvr2,         triton::bitsize::qword-1, 0, TRCCIDCVR2,        TT_MUTABLE_REG) // trccidcvr2
SYS_REG_SPEC(TRCCIDCVR3,            trccidcvr3,         triton::bitsize::qword-1, 0, TRCCIDCVR3,        TT_MUTABLE_REG) // trccidcvr3
SYS_REG_SPEC(TRCCIDCVR4,            trccidcvr4,         triton::bitsize::qword-1, 0, TRCCIDCVR4,        TT_MUTABLE_REG) // trccidcvr4
SYS_REG_SPEC(TRCCIDCVR5,            trccidcvr5,         triton::bitsize::qword-1, 0, TRCCIDCVR5,        TT_MUTABLE_REG) // trccidcvr5
SYS_REG_SPEC(TRCCIDCVR6,            trccidcvr6,         triton::bitsize::qword-1, 0, TRCCIDCVR6,        TT_MUTABLE_REG) // trccidcvr6
SYS_REG_SPEC(TRCCIDCVR7,            trccidcvr7,         triton::bitsize::qword-1, 0, TRCCIDCVR7,        TT_MUTABLE_REG) // trccidcvr7
SYS_REG_SPEC(TRCCIDR0,              trccidr0,           triton::bitsize::qword-1, 0, TRCCIDR0,          TT_MUTABLE_REG) // trccidr0
SYS_REG_SPEC(TRCCIDR1,              trccidr1,           triton::bitsize::qword-1, 0, TRCCIDR1,          TT_MUTABLE_REG) // trccidr1
SYS_REG_SPEC(TRCCIDR2,              trccidr2,           triton::bitsize::qword-1, 0, TRCCIDR2,          TT_MUTABLE_REG) // trccidr2
SYS_REG_SPEC(TRCCIDR3,              trccidr3,           triton::bitsize::qword-1, 0, TRCCIDR3,          TT_MUTABLE_REG) // trccidr3
SYS_REG_SPEC(TRCCLAIMCLR,           trcclaimclr,        triton::bitsize::qword-1, 0, TRCCLAIMCLR,       TT_MUTABLE_REG) // trcclaimclr
SYS_REG_SPEC(TRCCLAIMSET,           trcclaimset,        triton::bitsize::qword-1, 0, TRCCLAIMSET,       TT_MUTABLE_REG) // trcclaimset
SYS_REG_SPEC(TRCCNTCTLR0,           trccntctlr0,        triton::bitsize::qword-1, 0, TRCCNTCTLR0,       TT_MUTABLE_REG) // trccntctlr0
SYS_REG_SPEC(TRCCNTCTLR1,           trccntctlr1,        triton::bitsize::qword-1, 0, TRCCNTCTLR1,       TT_MUTABLE_REG) // trccntctlr1
SYS_REG_SPEC(TRCCNTCTLR2,           trccntctlr2,        triton::bitsize::qword-1, 0, TRCCNTCTLR2,       TT_MUTABLE_REG) // trccntctlr2
SYS_REG_SPEC(TRCCNTCTLR3,           trccntctlr3,        triton::bitsize::qword-1, 0, TRCCNTCTLR3,       TT_MUTABLE_REG) // trccntctlr3
SYS_REG_SPEC(TRCCNTRLDVR0,          trccntrldvr0,       triton::bitsize::qword-1, 0, TRCCNTRLDVR0,      TT_MUTABLE_REG) // trccntrldvr0
SYS_REG_SPEC(TRCCNTRLDVR1,          trccntrldvr1,       triton::bitsize::qword-1, 0, TRCCNTRLDVR1,      TT_MUTABLE_REG) // trccntrldvr1
SYS_REG_SPEC(TRCCNTRLDVR2,          trccntrldvr2,       triton::bitsize::qword-1, 0, TRCCNTRLDVR2,      TT_MUTABLE_REG) // trccntrldvr2
SYS_REG_SPEC(TRCCNTRLDVR3,          trccntrldvr3,       triton::bitsize::qword-1, 0, TRCCNTRLDVR3,      TT_MUTABLE_REG) // trccntrldvr3
SYS_REG_SPEC(TRCCNTVR0,             trccntvr0,          triton::bitsize::qword-1, 0, TRCCNTVR0,         TT_MUTABLE_REG) // trccntvr0
SYS_REG_SPEC(TRCCNTVR1,             trccntvr1,          triton::bitsize::qword-1, 0, TRCCNTVR1,         TT_MUTABLE_REG) // trccntvr1
SYS_REG_SPEC(TRCCNTVR2,             trccntvr2,          triton::bitsize::qword-1, 0, TRCCNTVR2,         TT_MUTABLE_REG) // trccntvr2
SYS_REG_SPEC(TRCCNTVR3,             trccntvr3,          triton::bitsize::qword-1, 0, TRCCNTVR3,         TT_MUTABLE_REG) // trccntvr3
SYS_REG_SPEC(TRCCONFIGR,            trcconfigr,         triton::bitsize::qword-1, 0, TRCCONFIGR,        TT_MUTABLE_REG) // trcconfigr
SYS_REG_SPEC(TRCDEVAFF0,            trcdevaff0,         triton::bitsize::qword-1, 0, TRCDEVAFF0,        TT_MUTABLE_REG) // trcdevaff0
SYS_REG_SPEC(TRCDEVAFF1,            trcdevaff1,         triton::bitsize::qword-1, 0, TRCDEVAFF1,        TT_MUTABLE_REG) // trcdevaff1
SYS_REG_SPEC(TRCDEVARCH,            trcdevarch,         triton::bitsize::qword-1, 0, TRCDEVARCH,        TT_MUTABLE_REG) // trcdevarch
SYS_REG_SPEC(TRCDEVID,              trcdevid,           triton::bitsize::qword-1, 0, TRCDEVID,          TT_MUTABLE_REG) // trcdevid
SYS_REG_SPEC(TRCDEVTYPE,            trcdevtype,         triton::bitsize::qword-1, 0, TRCDEVTYPE,        TT_MUTABLE_REG) // trcdevtype
SYS_REG_SPEC(TRCDVCMR0,             trcdvcmr0,          triton::bitsize::qword-1, 0, TRCDVCMR0,         TT_MUTABLE_REG) // trcdvcmr0
SYS_REG_SPEC(TRCDVCMR1,             trcdvcmr1,          triton::bitsize::qword-1, 0, TRCDVCMR1,         TT_MUTABLE_REG) // trcdvcmr1
SYS_REG_SPEC(TRCDVCMR2,             trcdvcmr2,          triton::bitsize::qword-1, 0, TRCDVCMR2,         TT_MUTABLE_REG) // trcdvcmr2
SYS_REG_SPEC(TRCDVCMR3,             trcdvcmr3,          triton::bitsize::qword-1, 0, TRCDVCMR3,         TT_MUTABLE_REG) // trcdvcmr3
SYS_REG_SPEC(TRCDVCMR4,             trcdvcmr4,          triton::bitsize::qword-1, 0, TRCDVCMR4,         TT_MUTABLE_REG) // trcdvcmr4
SYS_REG_SPEC(TRCDVCMR5,             trcdvcmr5,          triton::bitsize::qword-1, 0, TRCDVCMR5,         TT_MUTABLE_REG) // trcdvcmr5
SYS_REG_SPEC(TRCDVCMR6,             trcdvcmr6,          triton::bitsize::qword-1, 0, TRCDVCMR6,         TT_MUTABLE_REG) // trcdvcmr6
SYS_REG_SPEC(TRCDVCMR7,             trcdvcmr7,          triton::bitsize::qword-1, 0, TRCDVCMR7,         TT_MUTABLE_REG) // trcdvcmr7
SYS_REG_SPEC(TRCDVCVR0,             trcdvcvr0,          triton::bitsize::qword-1, 0, TRCDVCVR0,         TT_MUTABLE_REG) // trcdvcvr0
SYS_REG_SPEC(TRCDVCVR1,             trcdvcvr1,          triton::bitsize::qword-1, 0, TRCDVCVR1,         TT_MUTABLE_REG) // trcdvcvr1
SYS_REG_SPEC(TRCDVCVR2,             trcdvcvr2,          triton::bitsize::qword-1, 0, TRCDVCVR2,         TT_MUTABLE_REG) // trcdvcvr2
SYS_REG_SPEC(TRCDVCVR3,             trcdvcvr3,          triton::bitsize::qword-1, 0, TRCDVCVR3,         TT_MUTABLE_REG) // trcdvcvr3
SYS_REG_SPEC(TRCDVCVR4,             trcdvcvr4,          triton::bitsize::qword-1, 0, TRCDVCVR4,         TT_MUTABLE_REG) // trcdvcvr4
SYS_REG_SPEC(TRCDVCVR5,             trcdvcvr5,          triton::bitsize::qword-1, 0, TRCDVCVR5,         TT_MUTABLE_REG) // trcdvcvr5
SYS_REG_SPEC(TRCDVCVR6,             trcdvcvr6,          triton::bitsize::qword-1, 0, TRCDVCVR6,         TT_MUTABLE_REG) // trcdvcvr6
SYS_REG_SPEC(TRCDVCVR7,             trcdvcvr7,          triton::bitsize::qword-1, 0, TRCDVCVR7,         TT_MUTABLE_REG) // trcdvcvr7
SYS_REG_SPEC(TRCEVENTCTL0R,         trceventctl0r,      triton::bitsize::qword-1, 0, TRCEVENTCTL0R,     TT_MUTABLE_REG) // trceventctl0r
SYS_REG_SPEC(TRCEVENTCTL1R,         trceventctl1r,      triton::bitsize::qword-1, 0, TRCEVENTCTL1R,     TT_MUTABLE_REG) // trceventctl1r
SYS_REG_SPEC(TRCEXTINSELR,          trcextinselr,       triton::bitsize::qword-1, 0, TRCEXTINSELR,      TT_MUTABLE_REG) // trcextinselr
SYS_REG_SPEC(TRCIDR0,               trcidr0,            triton::bitsize::qword-1, 0, TRCIDR0,           TT_MUTABLE_REG) // trcidr0
SYS_REG_SPEC(TRCIDR1,               trcidr1,            triton::bitsize::qword-1, 0, TRCIDR1,           TT_MUTABLE_REG) // trcidr1
SYS_REG_SPEC(TRCIDR10,              trcidr10,           triton::bitsize::qword-1, 0, TRCIDR10,          TT_MUTABLE_REG) // trcidr10
SYS_REG_SPEC(TRCIDR11,              trcidr11,           triton::bitsize::qword-1, 0, TRCIDR11,          TT_MUTABLE_REG) // trcidr11
SYS_REG_SPEC(TRCIDR12,              trcidr12,           triton::bitsize::qword-1, 0, TRCIDR12,          TT_MUTABLE_REG) // trcidr12
SYS_REG_SPEC(TRCIDR13,              trcidr13,           triton::bitsize::qword-1, 0, TRCIDR13,          TT_MUTABLE_REG) // trcidr13
SYS_REG_SPEC(TRCIDR2,               trcidr2,            triton::bitsize::qword-1, 0, TRCIDR2,           TT_MUTABLE_REG) // trcidr2
SYS_REG_SPEC(TRCIDR3,               trcidr3,            triton::bitsize::qword-1, 0, TRCIDR3,           TT_MUTABLE_REG) // trcidr3
SYS_REG_SPEC(TRCIDR4,               trcidr4,            triton::bitsize::qword-1, 0, TRCIDR4,           TT_MUTABLE_REG) // trcidr4
SYS_REG_SPEC(TRCIDR5,               trcidr5,            triton::bitsize::qword-1, 0, TRCIDR5,           TT_MUTABLE_REG) // trcidr5
SYS_REG_SPEC(TRCIDR6,               trcidr6,            triton::bitsize::qword-1, 0, TRCIDR6,           TT_MUTABLE_REG) // trcidr6
SYS_REG_SPEC(TRCIDR7,               trcidr7,            triton::bitsize::qword-1, 0, TRCIDR7,           TT_MUTABLE_REG) // trcidr7
SYS_REG_SPEC(TRCIDR8,               trcidr8,            triton::bitsize::qword-1, 0, TRCIDR8,           TT_MUTABLE_REG) // trcidr8
SYS_REG_SPEC(TRCIDR9,               trcidr9,            triton::bitsize::qword-1, 0, TRCIDR9,           TT_MUTABLE_REG) // trcidr9
SYS_REG_SPEC(TRCIMSPEC0,            trcimspec0,         triton::bitsize::qword-1, 0, TRCIMSPEC0,        TT_MUTABLE_REG) // trcimspec0
SYS_REG_SPEC(TRCIMSPEC1,            trcimspec1,         triton::bitsize::qword-1, 0, TRCIMSPEC1,        TT_MUTABLE_REG) // trcimspec1
SYS_REG_SPEC(TRCIMSPEC2,            trcimspec2,         triton::bitsize::qword-1, 0, TRCIMSPEC2,        TT_MUTABLE_REG) // trcimspec2
SYS_REG_SPEC(TRCIMSPEC3,            trcimspec3,         triton::bitsize::qword-1, 0, TRCIMSPEC3,        TT_MUTABLE_REG) // trcimspec3
SYS_REG_SPEC(TRCIMSPEC4,            trcimspec4,         triton::bitsize::qword-1, 0, TRCIMSPEC4,        TT_MUTABLE_REG) // trcimspec4
SYS_REG_SPEC(TRCIMSPEC5,            trcimspec5,         triton::bitsize::qword-1, 0, TRCIMSPEC5,        TT_MUTABLE_REG) // trcimspec5
SYS_REG_SPEC(TRCIMSPEC6,            trcimspec6,         triton::bitsize::qword-1, 0, TRCIMSPEC6,        TT_MUTABLE_REG) // trcimspec6
SYS_REG_SPEC(TRCIMSPEC7,            trcimspec7,         triton::bitsize::qword-1, 0, TRCIMSPEC7,        TT_MUTABLE_REG) // trcimspec7
SYS_REG_SPEC(TRCITCTRL,             trcitctrl,          triton::bitsize::qword-1, 0, TRCITCTRL,         TT_MUTABLE_REG) // trcitctrl
SYS_REG_SPEC(TRCLAR,                trclar,             triton::bitsize::qword-1, 0, TRCLAR,            TT_MUTABLE_REG) // trclar
SYS_REG_SPEC(TRCLSR,                trclsr,             triton::bitsize::qword-1, 0, TRCLSR,            TT_MUTABLE_REG) // trclsr
SYS_REG_SPEC(TRCOSLAR,              trcoslar,           triton::bitsize::qword-1, 0, TRCOSLAR,          TT_MUTABLE_REG) // trcoslar
SYS_REG_SPEC(TRCOSLSR,              trcoslsr,           triton::bitsize::qword-1, 0, TRCOSLSR,          TT_MUTABLE_REG) // trcoslsr
SYS_REG_SPEC(TRCPDCR,               trcpdcr,            triton::bitsize::qword-1, 0, TRCPDCR,           TT_MUTABLE_REG) // trcpdcr
SYS_REG_SPEC(TRCPDSR,               trcpdsr,            triton::bitsize::qword-1, 0, TRCPDSR,           TT_MUTABLE_REG) // trcpdsr
SYS_REG_SPEC(TRCPIDR0,              trcpidr0,           triton::bitsize::qword-1, 0, TRCPIDR0,          TT_MUTABLE_REG) // trcpidr0
SYS_REG_SPEC(TRCPIDR1,              trcpidr1,           triton::bitsize::qword-1, 0, TRCPIDR1,          TT_MUTABLE_REG) // trcpidr1
SYS_REG_SPEC(TRCPIDR2,              trcpidr2,           triton::bitsize::qword-1, 0, TRCPIDR2,          TT_MUTABLE_REG) // trcpidr2
SYS_REG_SPEC(TRCPIDR3,              trcpidr3,           triton::bitsize::qword-1, 0, TRCPIDR3,          TT_MUTABLE_REG) // trcpidr3
SYS_REG_SPEC(TRCPIDR4,              trcpidr4,           triton::bitsize::qword-1, 0, TRCPIDR4,          TT_MUTABLE_REG) // trcpidr4
SYS_REG_SPEC(TRCPIDR5,              trcpidr5,           triton::bitsize::qword-1, 0, TRCPIDR5,          TT_MUTABLE_REG) // trcpidr5
SYS_REG_SPEC(TRCPIDR6,              trcpidr6,           triton::bitsize::qword-1, 0, TRCPIDR6,          TT_MUTABLE_REG) // trcpidr6
SYS_REG_SPEC(TRCPIDR7,              trcpidr7,           triton::bitsize::qword-1, 0, TRCPIDR7,          TT_MUTABLE_REG) // trcpidr7
SYS_REG_SPEC(TRCPRGCTLR,            trcprgctlr,         triton::bitsize::qword-1, 0, TRCPRGCTLR,        TT_MUTABLE_REG) // trcprgctlr
SYS_REG_SPEC(TRCPROCSELR,           trcprocselr,        triton::bitsize::qword-1, 0, TRCPROCSELR,       TT_MUTABLE_REG) // trcprocselr
SYS_REG_SPEC(TRCQCTLR,              trcqctlr,           triton::bitsize::qword-1, 0, TRCQCTLR,          TT_MUTABLE_REG) // trcqctlr
SYS_REG_SPEC(TRCRSCTLR10,           trcrsctlr10,        triton::bitsize::qword-1, 0, TRCRSCTLR10,       TT_MUTABLE_REG) // trcrsctlr10
SYS_REG_SPEC(TRCRSCTLR11,           trcrsctlr11,        triton::bitsize::qword-1, 0, TRCRSCTLR11,       TT_MUTABLE_REG) // trcrsctlr11
SYS_REG_SPEC(TRCRSCTLR12,           trcrsctlr12,        triton::bitsize::qword-1, 0, TRCRSCTLR12,       TT_MUTABLE_REG) // trcrsctlr12
SYS_REG_SPEC(TRCRSCTLR13,           trcrsctlr13,        triton::bitsize::qword-1, 0, TRCRSCTLR13,       TT_MUTABLE_REG) // trcrsctlr13
SYS_REG_SPEC(TRCRSCTLR14,           trcrsctlr14,        triton::bitsize::qword-1, 0, TRCRSCTLR14,       TT_MUTABLE_REG) // trcrsctlr14
SYS_REG_SPEC(TRCRSCTLR15,           trcrsctlr15,        triton::bitsize::qword-1, 0, TRCRSCTLR15,       TT_MUTABLE_REG) // trcrsctlr15
SYS_REG_SPEC(TRCRSCTLR16,           trcrsctlr16,        triton::bitsize::qword-1, 0, TRCRSCTLR16,       TT_MUTABLE_REG) // trcrsctlr16
SYS_REG_SPEC(TRCRSCTLR17,           trcrsctlr17,        triton::bitsize::qword-1, 0, TRCRSCTLR17,       TT_MUTABLE_REG) // trcrsctlr17
SYS_REG_SPEC(TRCRSCTLR18,           trcrsctlr18,        triton::bitsize::qword-1, 0, TRCRSCTLR18,       TT_MUTABLE_REG) // trcrsctlr18
SYS_REG_SPEC(TRCRSCTLR19,           trcrsctlr19,        triton::bitsize::qword-1, 0, TRCRSCTLR19,       TT_MUTABLE_REG) // trcrsctlr19
SYS_REG_SPEC(TRCRSCTLR2,            trcrsctlr2,         triton::bitsize::qword-1, 0, TRCRSCTLR2,        TT_MUTABLE_REG) // trcrsctlr2
SYS_REG_SPEC(TRCRSCTLR20,           trcrsctlr20,        triton::bitsize::qword-1, 0, TRCRSCTLR20,       TT_MUTABLE_REG) // trcrsctlr20
SYS_REG_SPEC(TRCRSCTLR21,           trcrsctlr21,        triton::bitsize::qword-1, 0, TRCRSCTLR21,       TT_MUTABLE_REG) // trcrsctlr21
SYS_REG_SPEC(TRCRSCTLR22,           trcrsctlr22,        triton::bitsize::qword-1, 0, TRCRSCTLR22,       TT_MUTABLE_REG) // trcrsctlr22
SYS_REG_SPEC(TRCRSCTLR23,           trcrsctlr23,        triton::bitsize::qword-1, 0, TRCRSCTLR23,       TT_MUTABLE_REG) // trcrsctlr23
SYS_REG_SPEC(TRCRSCTLR24,           trcrsctlr24,        triton::bitsize::qword-1, 0, TRCRSCTLR24,       TT_MUTABLE_REG) // trcrsctlr24
SYS_REG_SPEC(TRCRSCTLR25,           trcrsctlr25,        triton::bitsize::qword-1, 0, TRCRSCTLR25,       TT_MUTABLE_REG) // trcrsctlr25
SYS_REG_SPEC(TRCRSCTLR26,           trcrsctlr26,        triton::bitsize::qword-1, 0, TRCRSCTLR26,       TT_MUTABLE_REG) // trcrsctlr26
SYS_REG_SPEC(TRCRSCTLR27,           trcrsctlr27,        triton::bitsize::qword-1, 0, TRCRSCTLR27,       TT_MUTABLE_REG) // trcrsctlr27
SYS_REG_SPEC(TRCRSCTLR28,           trcrsctlr28,        triton::bitsize::qword-1, 0, TRCRSCTLR28,       TT_MUTABLE_REG) // trcrsctlr28
SYS_REG_SPEC(TRCRSCTLR29,           trcrsctlr29,        triton::bitsize::qword-1, 0, TRCRSCTLR29,       TT_MUTABLE_REG) // trcrsctlr29
SYS_REG_SPEC(TRCRSCTLR3,            trcrsctlr3,         triton::bitsize::qword-1, 0, TRCRSCTLR3,        TT_MUTABLE_REG) // trcrsctlr3
SYS_REG_SPEC(TRCRSCTLR30,           trcrsctlr30,        triton::bitsize::qword-1, 0, TRCRSCTLR30,       TT_MUTABLE_REG) // trcrsctlr30
SYS_REG_SPEC(TRCRSCTLR31,           trcrsctlr31,        triton::bitsize::qword-1, 0, TRCRSCTLR31,       TT_MUTABLE_REG) // trcrsctlr31
SYS_REG_SPEC(TRCRSCTLR4,            trcrsctlr4,         triton::bitsize::qword-1, 0, TRCRSCTLR4,        TT_MUTABLE_REG) // trcrsctlr4
SYS_REG_SPEC(TRCRSCTLR5,            trcrsctlr5,         triton::bitsize::qword-1, 0, TRCRSCTLR5,        TT_MUTABLE_REG) // trcrsctlr5
SYS_REG_SPEC(TRCRSCTLR6,            trcrsctlr6,         triton::bitsize::qword-1, 0, TRCRSCTLR6,        TT_MUTABLE_REG) // trcrsctlr6
SYS_REG_SPEC(TRCRSCTLR7,            trcrsctlr7,         triton::bitsize::qword-1, 0, TRCRSCTLR7,        TT_MUTABLE_REG) // trcrsctlr7
SYS_REG_SPEC(TRCRSCTLR8,            trcrsctlr8,         triton::bitsize::qword-1, 0, TRCRSCTLR8,        TT_MUTABLE_REG) // trcrsctlr8
SYS_REG_SPEC(TRCRSCTLR9,            trcrsctlr9,         triton::bitsize::qword-1, 0, TRCRSCTLR9,        TT_MUTABLE_REG) // trcrsctlr9
SYS_REG_SPEC(TRCSEQEVR0,            trcseqevr0,         triton::bitsize::qword-1, 0, TRCSEQEVR0,        TT_MUTABLE_REG) // trcseqevr0
SYS_REG_SPEC(TRCSEQEVR1,            trcseqevr1,         triton::bitsize::qword-1, 0, TRCSEQEVR1,        TT_MUTABLE_REG) // trcseqevr1
SYS_REG_SPEC(TRCSEQEVR2,            trcseqevr2,         triton::bitsize::qword-1, 0, TRCSEQEVR2,        TT_MUTABLE_REG) // trcseqevr2
SYS_REG_SPEC(TRCSEQRSTEVR,          trcseqrstevr,       triton::bitsize::qword-1, 0, TRCSEQRSTEVR,      TT_MUTABLE_REG) // trcseqrstevr
SYS_REG_SPEC(TRCSEQSTR,             trcseqstr,          triton::bitsize::qword-1, 0, TRCSEQSTR,         TT_MUTABLE_REG) // trcseqstr
SYS_REG_SPEC(TRCSSCCR0,             trcssccr0,          triton::bitsize::qword-1, 0, TRCSSCCR0,         TT_MUTABLE_REG) // trcssccr0
SYS_REG_SPEC(TRCSSCCR1,             trcssccr1,          triton::bitsize::qword-1, 0, TRCSSCCR1,         TT_MUTABLE_REG) // trcssccr1
SYS_REG_SPEC(TRCSSCCR2,             trcssccr2,          triton::bitsize::qword-1, 0, TRCSSCCR2,         TT_MUTABLE_REG) // trcssccr2
SYS_REG_SPEC(TRCSSCCR3,             trcssccr3,          triton::bitsize::qword-1, 0, TRCSSCCR3,         TT_MUTABLE_REG) // trcssccr3
SYS_REG_SPEC(TRCSSCCR4,             trcssccr4,          triton::bitsize::qword-1, 0, TRCSSCCR4,         TT_MUTABLE_REG) // trcssccr4
SYS_REG_SPEC(TRCSSCCR5,             trcssccr5,          triton::bitsize::qword-1, 0, TRCSSCCR5,         TT_MUTABLE_REG) // trcssccr5
SYS_REG_SPEC(TRCSSCCR6,             trcssccr6,          triton::bitsize::qword-1, 0, TRCSSCCR6,         TT_MUTABLE_REG) // trcssccr6
SYS_REG_SPEC(TRCSSCCR7,             trcssccr7,          triton::bitsize::qword-1, 0, TRCSSCCR7,         TT_MUTABLE_REG) // trcssccr7
SYS_REG_SPEC(TRCSSCSR0,             trcsscsr0,          triton::bitsize::qword-1, 0, TRCSSCSR0,         TT_MUTABLE_REG) // trcsscsr0
SYS_REG_SPEC(TRCSSCSR1,             trcsscsr1,          triton::bitsize::qword-1, 0, TRCSSCSR1,         TT_MUTABLE_REG) // trcsscsr1
SYS_REG_SPEC(TRCSSCSR2,             trcsscsr2,          triton::bitsize::qword-1, 0, TRCSSCSR2,         TT_MUTABLE_REG) // trcsscsr2
SYS_REG_SPEC(TRCSSCSR3,             trcsscsr3,          triton::bitsize::qword-1, 0, TRCSSCSR3,         TT_MUTABLE_REG) // trcsscsr3
SYS_REG_SPEC(TRCSSCSR4,             trcsscsr4,          triton::bitsize::qword-1, 0, TRCSSCSR4,         TT_MUTABLE_REG) // trcsscsr4
SYS_REG_SPEC(TRCSSCSR5,             trcsscsr5,          triton::bitsize::qword-1, 0, TRCSSCSR5,         TT_MUTABLE_REG) // trcsscsr5
SYS_REG_SPEC(TRCSSCSR6,             trcsscsr6,          triton::bitsize::qword-1, 0, TRCSSCSR6,         TT_MUTABLE_REG) // trcsscsr6
SYS_REG_SPEC(TRCSSCSR7,             trcsscsr7,          triton::bitsize::qword-1, 0, TRCSSCSR7,         TT_MUTABLE_REG) // trcsscsr7
SYS_REG_SPEC(TRCSSPCICR0,           trcsspcicr0,        triton::bitsize::qword-1, 0, TRCSSPCICR0,       TT_MUTABLE_REG) // trcsspcicr0
SYS_REG_SPEC(TRCSSPCICR1,           trcsspcicr1,        triton::bitsize::qword-1, 0, TRCSSPCICR1,       TT_MUTABLE_REG) // trcsspcicr1
SYS_REG_SPEC(TRCSSPCICR2,           trcsspcicr2,        triton::bitsize::qword-1, 0, TRCSSPCICR2,       TT_MUTABLE_REG) // trcsspcicr2
SYS_REG_SPEC(TRCSSPCICR3,           trcsspcicr3,        triton::bitsize::qword-1, 0, TRCSSPCICR3,       TT_MUTABLE_REG) // trcsspcicr3
SYS_REG_SPEC(TRCSSPCICR4,           trcsspcicr4,        triton::bitsize::qword-1, 0, TRCSSPCICR4,       TT_MUTABLE_REG) // trcsspcicr4
SYS_REG_SPEC(TRCSSPCICR5,           trcsspcicr5,        triton::bitsize::qword-1, 0, TRCSSPCICR5,       TT_MUTABLE_REG) // trcsspcicr5
SYS_REG_SPEC(TRCSSPCICR6,           trcsspcicr6,        triton::bitsize::qword-1, 0, TRCSSPCICR6,       TT_MUTABLE_REG) // trcsspcicr6
SYS_REG_SPEC(TRCSSPCICR7,           trcsspcicr7,        triton::bitsize::qword-1, 0, TRCSSPCICR7,       TT_MUTABLE_REG) // trcsspcicr7
SYS_REG_SPEC(TRCSTALLCTLR,          trcstallctlr,       triton::bitsize::qword-1, 0, TRCSTALLCTLR,      TT_MUTABLE_REG) // trcstallctlr
SYS_REG_SPEC(TRCSTATR,              trcstatr,           triton::bitsize::qword-1, 0, TRCSTATR,          TT_MUTABLE_REG) // trcstatr
SYS_REG_SPEC(TRCSYNCPR,             trcsyncpr,          triton::bitsize::qword-1, 0, TRCSYNCPR,         TT_MUTABLE_REG) // trcsyncpr
SYS_REG_SPEC(TRCTRACEIDR,           trctraceidr,        triton::bitsize::qword-1, 0, TRCTRACEIDR,       TT_MUTABLE_REG) // trctraceidr
SYS_REG_SPEC(TRCTSCTLR,             trctsctlr,          triton::bitsize::qword-1, 0, TRCTSCTLR,         TT_MUTABLE_REG) // trctsctlr
SYS_REG_SPEC(TRCVDARCCTLR,          trcvdarcctlr,       triton::bitsize::qword-1, 0, TRCVDARCCTLR,      TT_MUTABLE_REG) // trcvdarcctlr
SYS_REG_SPEC(TRCVDCTLR,             trcvdctlr,          triton::bitsize::qword-1, 0, TRCVDCTLR,         TT_MUTABLE_REG) // trcvdctlr
SYS_REG_SPEC(TRCVDSACCTLR,          trcvdsacctlr,       triton::bitsize::qword-1, 0, TRCVDSACCTLR,      TT_MUTABLE_REG) // trcvdsacctlr
SYS_REG_SPEC(TRCVICTLR,             trcvictlr,          triton::bitsize::qword-1, 0, TRCVICTLR,         TT_MUTABLE_REG) // trcvictlr
SYS_REG_SPEC(TRCVIIECTLR,           trcviiectlr,        triton::bitsize::qword-1, 0, TRCVIIECTLR,       TT_MUTABLE_REG) // trcviiectlr
SYS_REG_SPEC(TRCVIPCSSCTLR,         trcvipcssctlr,      triton::bitsize::qword-1, 0, TRCVIPCSSCTLR,     TT_MUTABLE_REG) // trcvipcssctlr
SYS_REG_SPEC(TRCVISSCTLR,           trcvissctlr,        triton::bitsize::qword-1, 0, TRCVISSCTLR,       TT_MUTABLE_REG) // trcvissctlr
SYS_REG_SPEC(TRCVMIDCCTLR0,         trcvmidcctlr0,      triton::bitsize::qword-1, 0, TRCVMIDCCTLR0,     TT_MUTABLE_REG) // trcvmidcctlr0
SYS_REG_SPEC(TRCVMIDCCTLR1,         trcvmidcctlr1,      triton::bitsize::qword-1, 0, TRCVMIDCCTLR1,     TT_MUTABLE_REG) // trcvmidcctlr1
SYS_REG_SPEC(TRCVMIDCVR0,           trcvmidcvr0,        triton::bitsize::qword-1, 0, TRCVMIDCVR0,       TT_MUTABLE_REG) // trcvmidcvr0
SYS_REG_SPEC(TRCVMIDCVR1,           trcvmidcvr1,        triton::bitsize::qword-1, 0, TRCVMIDCVR1,       TT_MUTABLE_REG) // trcvmidcvr1
SYS_REG_SPEC(TRCVMIDCVR2,           trcvmidcvr2,        triton::bitsize::qword-1, 0, TRCVMIDCVR2,       TT_MUTABLE_REG) // trcvmidcvr2
SYS_REG_SPEC(TRCVMIDCVR3,           trcvmidcvr3,        triton::bitsize::qword-1, 0, TRCVMIDCVR3,       TT_MUTABLE_REG) // trcvmidcvr3
SYS_REG_SPEC(TRCVMIDCVR4,           trcvmidcvr4,        triton::bitsize::qword-1, 0, TRCVMIDCVR4,       TT_MUTABLE_REG) // trcvmidcvr4
SYS_REG_SPEC(TRCVMIDCVR5,           trcvmidcvr5,        triton::bitsize::qword-1, 0, TRCVMIDCVR5,       TT_MUTABLE_REG) // trcvmidcvr5
SYS_REG_SPEC(TRCVMIDCVR6,           trcvmidcvr6,        triton::bitsize::qword-1, 0, TRCVMIDCVR6,       TT_MUTABLE_REG) // trcvmidcvr6
SYS_REG_SPEC(TRCVMIDCVR7,           trcvmidcvr7,        triton::bitsize::qword-1, 0, TRCVMIDCVR7,       TT_MUTABLE_REG) // trcvmidcvr7
SYS_REG_SPEC(TRFCR_EL1,             trfcr_el1,          triton::bitsize::qword-1, 0, TRFCR_EL1,         TT_MUTABLE_REG) // trfcr_el1
SYS_REG_SPEC(TRFCR_EL12,            trfcr_el12,         triton::bitsize::qword-1, 0, TRFCR_EL12,        TT_MUTABLE_REG) // trfcr_el12
SYS_REG_SPEC(TRFCR_EL2,             trfcr_el2,          triton::bitsize::qword-1, 0, TRFCR_EL2,         TT_MUTABLE_REG) // trfcr_el2
SYS_REG_SPEC(TTBR0_EL1,             ttbr0_el1,          triton::bitsize::qword-1, 0, TTBR0_EL1,         TT_MUTABLE_REG) // ttbr0_el1
SYS_REG_SPEC(TTBR0_EL12,            ttbr0_el12,         triton::bitsize::qword-1, 0, TTBR0_EL12,        TT_MUTABLE_REG) // ttbr0_el12
SYS_REG_SPEC(TTBR0_EL2,             ttbr0_el2,          triton::bitsize::qword-1, 0, TTBR0_EL2,         TT_MUTABLE_REG) // ttbr0_el2
SYS_REG_SPEC(TTBR0_EL3,             ttbr0_el3,          triton::bitsize::qword-1, 0, TTBR0_EL3,         TT_MUTABLE_REG) // ttbr0_el3
SYS_REG_SPEC(TTBR1_EL1,             ttbr1_el1,          triton::bitsize::qword-1, 0, TTBR1_EL1,         TT_MUTABLE_REG) // ttbr1_el1
SYS_REG_SPEC(TTBR1_EL12,            ttbr1_el12,         triton::bitsize::qword-1, 0, TTBR1_EL12,        TT_MUTABLE_REG) // ttbr1_el12
SYS_REG_SPEC(TTBR1_EL2,             ttbr1_el2,          triton::bitsize::qword-1, 0, TTBR1_EL2,         TT_MUTABLE_REG) // ttbr1_el2
SYS_REG_SPEC(UAO,                   uao,                triton::bitsize::qword-1, 0, UAO,               TT_MUTABLE_REG) // uao
SYS_REG_SPEC(VBAR_EL1,              vbar_el1,           triton::bitsize::qword-1, 0, VBAR_EL1,          TT_MUTABLE_REG) // vbar_el1
SYS_REG_SPEC(VBAR_EL12,             vbar_el12,          triton::bitsize::qword-1, 0, VBAR_EL12,         TT_MUTABLE_REG) // vbar_el12
SYS_REG_SPEC(VBAR_EL2,              vbar_el2,           triton::bitsize::qword-1, 0, VBAR_EL2,          TT_MUTABLE_REG) // vbar_el2
SYS_REG_SPEC(VBAR_EL3,              vbar_el3,           triton::bitsize::qword-1, 0, VBAR_EL3,          TT_MUTABLE_REG) // vbar_el3
SYS_REG_SPEC(VDISR_EL2,             vdisr_el2,          triton::bitsize::qword-1, 0, VDISR_EL2,         TT_MUTABLE_REG) // vdisr_el2
SYS_REG_SPEC(VMPIDR_EL2,            vmpidr_el2,         triton::bitsize::qword-1, 0, VMPIDR_EL2,        TT_MUTABLE_REG) // vmpidr_el2
SYS_REG_SPEC(VNCR_EL2,              vncr_el2,           triton::bitsize::qword-1, 0, VNCR_EL2,          TT_MUTABLE_REG) // vncr_el2
SYS_REG_SPEC(VPIDR_EL2,             vpidr_el2,          triton::bitsize::qword-1, 0, VPIDR_EL2,         TT_MUTABLE_REG) // vpidr_el2
SYS_REG_SPEC(VSESR_EL2,             vsesr_el2,          triton::bitsize::qword-1, 0, VSESR_EL2,         TT_MUTABLE_REG) // vsesr_el2
SYS_REG_SPEC(VSTCR_EL2,             vstcr_el2,          triton::bitsize::qword-1, 0, VSTCR_EL2,         TT_MUTABLE_REG) // vstcr_el2
SYS_REG_SPEC(VSTTBR_EL2,            vsttbr_el2,         triton::bitsize::qword-1, 0, VSTTBR_EL2,        TT_MUTABLE_REG) // vsttbr_el2
SYS_REG_SPEC(VTCR_EL2,              vtcr_el2,           triton::bitsize::qword-1, 0, VTCR_EL2,          TT_MUTABLE_REG) // vtcr_el2
SYS_REG_SPEC(VTTBR_EL2,             vttbr_el2,          triton::bitsize::qword-1, 0, VTTBR_EL2,         TT_MUTABLE_REG) // vttbr_el2
SYS_REG_SPEC(ZCR_EL1,               zcr_el1,            triton::bitsize::qword-1, 0, ZCR_EL1,           TT_MUTABLE_REG) // zcr_el1
SYS_REG_SPEC(ZCR_EL12,              zcr_el12,           triton::bitsize::qword-1, 0, ZCR_EL12,          TT_MUTABLE_REG) // zcr_el12
SYS_REG_SPEC(ZCR_EL2,               zcr_el2,            triton::bitsize::qword-1, 0, ZCR_EL2,           TT_MUTABLE_REG) // zcr_el2
SYS_REG_SPEC(ZCR_EL3,               zcr_el3,            triton::bitsize::qword-1, 0, ZCR_EL3,           TT_MUTABLE_REG) // zcr_el3

#undef REG_SPEC
#undef REG_SPEC_NO_CAPSTONE
#undef SYS_REG_SPEC
#undef TT_IMMUTABLE_REG
#undef TT_MUTABLE_REG

#pragma warning(default:4067)
