"""
efiguids_ami.py

GUIDs found in the AMI source

See the following URL for more info and the latest version:
https://github.com/snarez/ida-efiutils

"""

GUIDs = {
    'ACOUSTIC_SETUP_PROTOCOL_GUID': [0xc1d7859d, 0x5719, 0x46c3, 0xa2, 0x98, 0xd0, 0x71, 0xe3, 0x2, 0x64, 0xd1],
    'ADD_BOOT_OPTION_GUID': [0x19d96d3f, 0x6a6a, 0x47d2, 0xb1, 0x95, 0x7b, 0x24, 0x32, 0xda, 0x3b, 0xe2],
    'ADVANCED_FORM_SET_GUID': [0xe14f04fa, 0x8706, 0x4353, 0x92, 0xf2, 0x9c, 0x24, 0x24, 0x74, 0x6f, 0x9f],
    'AHCI_BUS_INIT_PROTOCOL_GUID': [0xB2FA4764, 0x3B6E, 0x43D3, 0x91, 0xDF, 0x87, 0xD1, 0x5A, 0x3E, 0x56, 0x68],
    'AHCI_SMM_PROTOCOL_GUID': [0xB2FA5764, 0x3B6E, 0x43D3, 0x91, 0xDF, 0x87, 0xD1, 0x5A, 0x3E, 0x56, 0x68],
    'AMICSM_PCIBUSNUM_XLAT_PROTOCOL_GUID': [0xcb5c54c0, 0x230d, 0x43db, 0x92, 0x2c, 0x24, 0xd3, 0x4f, 0x8c, 0x91, 0x5c],
    'AMITSESETUP_GUID': [0xc811fa38, 0x42c8, 0x4579, 0xa9, 0xbb, 0x60, 0xe9, 0x4e, 0xdd, 0xfb, 0x34],
    'AMITSE_ADMIN_PASSWORD_VALID_GUID': [0x541d5a75, 0x95ee, 0x43c7, 0x9e, 0x5d, 0x23, 0x94, 0xdc, 0x48, 0x62, 0x49],
    'AMITSE_AFTER_FIRST_BOOT_OPTION_GUID': [0xC48D651C, 0x9D0E, 0x4ce7, 0xAD, 0x39, 0xED, 0xD1, 0xAB, 0x83, 0x6B, 0x30],
    'AMITSE_BOOT_ORDER_CHANGE_GUID': [0x1b6bc809, 0xc986, 0x4937, 0x93, 0x4f, 0x1e, 0xa5, 0x86, 0x22, 0xfe, 0x50],
    'AMITSE_DRIVER_HEALTH_CTRL_GUID': [0x58279c2d, 0xfb19, 0x466e, 0xb4, 0x2e, 0xcd, 0x43, 0x70, 0x16, 0xdc, 0x25],
    'AMITSE_DRIVER_HEALTH_ENB_GUID': [0x885f288, 0x418c, 0x4be1, 0xa6, 0xaf, 0x8b, 0xad, 0x61, 0xda, 0x8, 0xfe],
    'AMITSE_DRIVER_HEALTH_GUID': [0x7459a7d4, 0x6533, 0x4480, 0xbb, 0xa7, 0x79, 0xe2, 0x5a, 0x44, 0x43, 0xc9],
    'AMITSE_EVENT_BEFORE_BOOT_GUID': [0x3677770f, 0xefb2, 0x43b2, 0xb8, 0xae, 0xb3, 0x2, 0xe9, 0x60, 0x48, 0x82],
    'AMITSE_INVALID_PASSWORD_GUID': [0xd69240c0, 0xdd40, 0x4f2d, 0x98, 0x63, 0x48, 0x48, 0xda, 0x6e, 0x61, 0x5f],
    'AMITSE_NVRAM_UPDATE_GUID': [0xd84beff0, 0x159a, 0x4b60, 0x9a, 0xb9, 0xac, 0x5c, 0x47, 0x4b, 0xd3, 0xb1],
    'AMITSE_PASSWORD_PROMPT_ENTER_GUID': [0x73e7e01, 0x2611, 0x4e85, 0xb8, 0x96, 0xa3, 0xb6, 0x76, 0x7c, 0xba, 0x0],
    'AMITSE_PASSWORD_PROMPT_EXIT_GUID': [0xb9b038b0, 0xe2b6, 0x4aab, 0x94, 0x35, 0x41, 0x65, 0xec, 0xfe, 0xd0, 0x32],
    'AMITSE_SETUP_ENTER_GUID': [0x71202EEE, 0x5F53, 0x40d9, 0xAB, 0x3D, 0x9E, 0x0C, 0x26, 0xD9, 0x66, 0x57],
    'AMITSE_USER_PASSWORD_VALID_GUID': [0xab1404ca, 0x4801, 0x4208, 0x98, 0xbf, 0x30, 0xd5, 0x21, 0xda, 0xd4, 0xd3],
    'AMI_APTIO_SIG_OWNER_GUID': [0x26DC4851, 0x195F, 0x4AE1, 0x9A, 0x19, 0xFB, 0xF8, 0x83, 0xBB, 0xB3, 0x5E],
    'AMI_BBS_DEVICE_PATH_GUID': [0x1db184ae, 0x81f5, 0x4e72, 0x85, 0x44, 0x2b, 0xab, 0xc, 0x2c, 0xac, 0x5c],
    'AMI_BEFORE_CPU_RC_PROTOCOL_GUID': [0x1d26adc3, 0xb011, 0xee2c, 0x21, 0x77, 0x89, 0xbb, 0xaa, 0xcc, 0x33, 0x92],
    'AMI_BIOSPPI_FLAGS_MANAGEMENT_GUID': [0xe9008d70, 0x2a4e, 0x47ea, 0x8e, 0xc4, 0x72, 0xe2, 0x57, 0x67, 0xe5, 0xef],
    'AMI_BOARD_INFO_PROTOCOL_GUID': [0x0273146c, 0x96c4, 0x45a1, 0xa7, 0xaf, 0x78, 0xe0, 0x52, 0x4a, 0x0a, 0xe2],
    'AMI_BOARD_INFO_SECTION_GUID': [0xE6F4F8F7, 0x4992, 0x47b2, 0x83, 0x02, 0x85, 0x08, 0x74, 0x5E, 0x4A, 0x23],
    'AMI_CALLBACK_GUID': [0x9CF0F18E, 0x7C7D, 0x49DE, 0xB5, 0xAA, 0xBB, 0xBA, 0xD6, 0xB2, 0x10, 0x07],
    'AMI_CAPSULE_HOB_GUID': [0xbf66fdf7, 0xf64c, 0x4b11, 0x8a, 0xb7, 0xf8, 0x43, 0xaa, 0x2a, 0x8b, 0xea],
    'AMI_CCID_IO_PROTOCOL_GUID': [0xB167C2F5, 0xE26A, 0x4DFF, 0x8E, 0x1C, 0x08, 0x07, 0xC7, 0xF0, 0x2A, 0x88],
    'AMI_CCID_PRESENCE_GUID': [0x5FDEE00D, 0xDA40, 0x405A, 0xB9, 0x2E, 0xCF, 0x4A, 0x80, 0xEA, 0x8F, 0x76],
    'AMI_CMOS_BAD_FLAG_HOB_GUID': [0xb098f766, 0xb17a, 0x4005, 0x83, 0x9, 0xeb, 0x23, 0xf1, 0x44, 0x8c, 0x15],
    'AMI_CPUID_CKSUM_HOB_GUID': [0xd4ca32b1, 0xb1f2, 0x4ff3, 0xb4, 0x75, 0x66, 0xe7, 0xb8, 0x19, 0x2a, 0x3b],
    'AMI_CPU_INFO_2_PROTOCOL_GUID': [0xac9cf0a8, 0xe551, 0x4be2, 0xad, 0xa, 0xe1, 0xb5, 0x64, 0xee, 0xa2, 0x73],
    'AMI_CSM_DRIVER_STARTED_GUID': [0x3EA824D1, 0x81E3, 0x4FF5, 0xBD, 0x43, 0xBB, 0x9C, 0x65, 0xDF, 0x7C, 0x46],
    'AMI_CSM_THUNK_PROTOCOL_GUID': [0x2362ea9c, 0x84e5, 0x4dff, 0x83, 0xbc, 0xb5, 0xac, 0xec, 0xb5, 0x7c, 0xbb],
    'AMI_DDDT_PRESENT_FLAG_HOB_GUID': [0x4e7af417, 0xc200, 0x400a, 0x9d, 0x18, 0x86, 0x5a, 0xda, 0xd3, 0x8, 0x96],
    'AMI_DEBUGGER_CPU_PROTOCOL_GUID': [0xab21acc3, 0xba33, 0xee2c, 0x66, 0xbc, 0x12, 0x56, 0x77, 0x11, 0x1a, 0xb2],
    'AMI_DEBUGPORT_HOB_GUID': [0xe894b313, 0x54ca, 0x4bb2, 0x8c, 0xdd, 0x85, 0x1e, 0x8a, 0xc9, 0x2, 0x7c],
    'AMI_DEVICE_NAME_DEVICE_PATH_GUID': [0x2d6447ef, 0x3bc9, 0x41a0, 0xac, 0x19, 0x4d, 0x51, 0xd0, 0x1b, 0x4c, 0xe6],
    'AMI_DIGITAL_SIGNATURE_PROTOCOL_GUID': [0x5f87ba17, 0x957d, 0x433d, 0x9e, 0x15, 0xc0, 0xe7, 0xc8, 0x79, 0x88, 0x99],
    'AMI_DIMM_SPD_DATA_HOB_GUID': [0xd4ca32b3, 0xb1fe, 0x4ff7, 0xb0, 0x73, 0x60, 0xed, 0xbb, 0x16, 0x22, 0x33],
    'AMI_EARLY_BIST_PPI_GUID': [0xa7e2ce72, 0xdc32, 0x4bc0, 0x9e, 0x35, 0xfe, 0xb3, 0xa, 0xe5, 0xcc, 0x47],
    'AMI_EFIKEYCODE_PROTOCOL_GUID': [0x0adfb62d, 0xff74, 0x484c, 0x89, 0x44, 0xf8, 0x5c, 0x4b, 0xea, 0x87, 0xa8],
    'AMI_FAST_BOOT_PROTOCOL_GUID': [0x3496a19a, 0x2e99, 0x41ba, 0x83, 0x3e, 0xf, 0xde, 0x2e, 0xbf, 0x2a, 0x55],
    'AMI_FW_RECOVERY_CAPSULE_GUID': [0x5e794317, 0xa07e, 0x45df, 0x94, 0xbb, 0x1c, 0x99, 0x7d, 0x62, 0x32, 0xca],
    'AMI_HECI_SMM_GUID': [0xFC9A50C1, 0x8B3D, 0x40D0, 0x99, 0x12, 0x6E, 0x26, 0xD7, 0x89, 0x6C, 0xBA],
    'AMI_INTERNAL_FACTORY_TDC_TDP_HOB_GUID': [0x982d8c6f, 0xf6f6, 0x4135, 0xa3, 0x9, 0xa4, 0x59, 0x3e, 0xa5, 0x64, 0x17],
    'AMI_INTERNAL_UCODE_HOB_GUID': [0x94567c6f, 0xf7a9, 0x4229, 0x13, 0x30, 0xfe, 0x11, 0xcc, 0xab, 0x3a, 0x11],
    'AMI_INT_SMM_COMM_PROTOCOL_GUID': [0xb27dab38, 0x9814, 0x4e06, 0xa5, 0xa2, 0x65, 0xae, 0x9a, 0x14, 0x25, 0x8f],
    'AMI_IRQ_DMA_MASK_VARIABLE_GUID': [0xfc8be767, 0x89f1, 0x4d6e, 0x80, 0x99, 0x6f, 0x2, 0x1e, 0xbc, 0x87, 0xcc],
    'AMI_ISO9660_MEDIA_GUID': [0xba7c46d1, 0x9c5e, 0x4fc8, 0x94, 0x3d, 0x1a, 0x49, 0x1f, 0x23, 0xfe, 0x1],
    'AMI_LOAD_CSM_GUID': [0x16287ba4, 0x5b9d, 0x4d98, 0x91, 0x9f, 0x7b, 0x7b, 0x78, 0xcb, 0x2b, 0xe0],
    'AMI_MASKED_DEVICE_PATH_GUID': [0x99e275e7, 0x75a0, 0x4b37, 0xa2, 0xe6, 0xc5, 0x38, 0x5e, 0x6c, 0x0, 0xcb],
    'AMI_MEASURE_PCIOPROM_GUID': [0xb3dae700, 0x2a77, 0x4ea4, 0xaf, 0x79, 0x32, 0x97, 0xb4, 0x84, 0xbe, 0x61],
    'AMI_MEDIA_DEVICE_PATH_GUID': [0x5023b95c, 0xdb26, 0x429b, 0xa6, 0x48, 0xbd, 0x47, 0x66, 0x4c, 0x80, 0x12],
    'AMI_MEMORY_ERROR_REPORT_PPI_GUID': [0x85226559, 0x0def, 0x48d8, 0xa8, 0xc9, 0xb7, 0x46, 0xd6, 0xa4, 0xdf, 0x01],
    'AMI_MRC_INFO_HOB_GUID': [0xa6351a87, 0x2965, 0x4718, 0x88, 0xc7, 0x0b, 0x5b, 0x5a, 0xc0, 0xb5, 0xe4],
    'AMI_NB_MRC_INFO_GUID': [0x6737934b, 0xa27e, 0x4c05, 0xad, 0x5b, 0x6a, 0xb8, 0x62, 0x73, 0x68, 0x0b],
    'AMI_NVRAM_SPD_MAP_GUID': [0x717fc150, 0xabd9, 0x4614, 0x80, 0x15, 0xb, 0x33, 0x23, 0xea, 0xb9, 0x5c],
    'AMI_OPROM_POLICY_PROTOCOL_GUID': [0x542d6248, 0x4198, 0x4960, 0x9f, 0x59, 0x23, 0x84, 0x64, 0x6d, 0x63, 0xb4],
    'AMI_OS_PPI_CONFIRMATION_OVERRIDE_GUID': [0x5f171f5f, 0x8385, 0x4086, 0xa6, 0x9b, 0x1f, 0xcf, 0x6, 0xae, 0x4a, 0x3d],
    'AMI_PB_KEY_RSA2048_GUID': [0x04627B9B, 0x385E, 0x4744, 0x90, 0x21, 0xE6, 0x63, 0x19, 0xF2, 0x03, 0x94],
    'AMI_PCI_BUS_EXT_PROTOCOL_GUID': [0xf42a009d, 0x977f, 0x4f08, 0x94, 0x40, 0xbc, 0xa5, 0xa3, 0xbe, 0xd9, 0xaf],
    'AMI_PEIM_HOB_GUID': [0xf4491ba4, 0x7672, 0x486f, 0xb4, 0xd7, 0x99, 0x89, 0x9d, 0x22, 0xda, 0x57],
    'AMI_PEIM_LOAD_HOB_GUID': [0xec9c36fd, 0x1642, 0x4b84, 0x91, 0xfa, 0x91, 0x9c, 0x2d, 0x6, 0x6f, 0xb4],
    'AMI_PEI_AFTER_MRC_GUID': [0x64c96700, 0x6b4c, 0x480c, 0xa3, 0xe1, 0xb8, 0xbd, 0xe8, 0xf6, 0x2, 0xb2],
    'AMI_PEI_CPUINIT_POLICY_PPI_GUID': [0xf824ccbb, 0xd8e0, 0x4522, 0x8a, 0xa8, 0x65, 0xf0, 0x4b, 0x46, 0x3d, 0xb5],
    'AMI_PEI_END_MEMORY_DETECT_GUID': [0x9f58e424, 0xb96b, 0x45a5, 0xad, 0xdc, 0xd2, 0xfe, 0x39, 0x4a, 0x99, 0xd9],
    'AMI_PEI_END_OF_MRC_GUID': [0x633194be, 0x1697, 0x11e1, 0xb5, 0xf0, 0x2c, 0xb2, 0x48, 0x24, 0x01, 0x9b],
    'AMI_PEI_MRC_DEFAULT_GUID': [0xe813e116, 0xc099, 0x4d21, 0x9c, 0x34, 0xa5, 0x52, 0xd5, 0xe9, 0xa5, 0xd0],
    'AMI_PEI_NBINIT_POLICY_PPI_GUID': [0x9ce4d938, 0x9c87, 0x41d0, 0x9e, 0x55, 0x34, 0x92, 0x3f, 0xaf, 0x8b, 0x4f],
    'AMI_PEI_NB_CPU_ONLY_RESET_PPI_GUID': [0x1f0f049e, 0x3a68, 0x4c97, 0x86, 0x5a, 0xbc, 0x5e, 0xed, 0x79, 0x20, 0xe7],
    'AMI_PEI_NB_CUSTOM_PPI_GUID': [0x584cc99f, 0x4be8, 0x43d1, 0xa4, 0x5a, 0x93, 0x3d, 0xc3, 0x94, 0x79, 0xfc],
    'AMI_PEI_PCI_TABLE_INIT_PPI_GUID': [0x97f91e78, 0xea12, 0x4ea6, 0xb7, 0xb3, 0x7b, 0x6, 0x78, 0xc2, 0x86, 0x73],
    'AMI_PEI_SBINIT_POLICY_PPI_GUID': [0x95e8152b, 0x1b98, 0x4f11, 0x8a, 0x77, 0xdb, 0x26, 0x58, 0x3e, 0xbc, 0x42],
    'AMI_PEI_SB_CUSTOM_PPI_GUID': [0x38965bb5, 0x8097, 0x40f5, 0xb7, 0x42, 0x8c, 0xc1, 0x4a, 0x64, 0x9b, 0x64],
    'AMI_PEI_SB_OEM_PLATFORM_POLICY_OVERRIDE_PPI_GUID': [0x61187967, 0x9a77, 0x419d, 0xaa, 0xea, 0x64, 0xdd, 0x56, 0x19, 0x08, 0x15],
    'AMI_PEI_SET_NB_SUBID_PPI_GUID': [0x584cc99f, 0x4be8, 0x43d1, 0xa4, 0x5a, 0x93, 0x3d, 0xc3, 0x94, 0x79, 0xfc],
    'AMI_PERF_TUNE_DATA_HOB_GUID': [0x4d6c0496, 0x8de4, 0x4af2, 0x9a, 0x2e, 0x9b, 0xe5, 0xb9, 0x15, 0x6a, 0xc5],
    'AMI_PLL_OVER_VOTAGE_FLAG_HOB_GUID': [0x181e874d, 0xc089, 0x4c99, 0x8e, 0xc2, 0x6d, 0x67, 0x61, 0x34, 0x82, 0x20],
    'AMI_POST_MANAGER_PROTOCOL_GUID': [0x8A91B1E1, 0x56C7, 0x4ADC, 0xAB, 0xEB, 0x1C, 0x2C, 0xA1, 0x72, 0x9E, 0xFF],
    'AMI_RECOVERY_IMAGE_HOB_GUID': [0xdac3cb98, 0x2295, 0x412e, 0x82, 0x6d, 0xfd, 0xee, 0xa3, 0x20, 0xcf, 0x31],
    'AMI_RESET_TYPE_HOB_GUID': [0x39e8cda1, 0x6a35, 0x4cdd, 0xa9, 0x2, 0xd1, 0xa7, 0x95, 0xf7, 0x3, 0x80],
    'AMI_RESET_TYPE_VARIABLE_GUID': [0x308DD02C, 0x092B, 0x4123, 0xA2, 0xAF, 0x3E, 0xF4, 0x44, 0x0A, 0x6B, 0x4A],
    'AMI_ROM_LAYOUT_HOB_GUID': [0xd7642443, 0x87b7, 0x4832, 0x96, 0x7, 0xe, 0x1e, 0xa8, 0x1c, 0x1d, 0x86],
    'AMI_SB_SMI_PROTOCOL_GUID': [0x589bc616, 0xbb4f, 0x47ed, 0x92, 0xf7, 0x93, 0x39, 0x3c, 0x69, 0x7e, 0x25],
    'AMI_SETUP_NVRAM_UPDATE_GUID': [0xd84beff0, 0x159a, 0x4b60, 0x9a, 0xb9, 0xac, 0x5c, 0x47, 0x4b, 0xd3, 0xb1],
    'AMI_SMBIOS_CPU_INFO_PROTOCOL_GUID': [0x3d6cdb0a, 0x5b1f, 0x43a3, 0xa4, 0x3b, 0x44, 0x12, 0x67, 0xf9, 0xda, 0xb5],
    'AMI_SMBIOS_MEMORY_INFO_HOB_GUID': [0x7d6b8734, 0xb754, 0x443f, 0xb5, 0x88, 0x77, 0x43, 0x84, 0x3a, 0xd3, 0xf1],
    'AMI_SMBUS_HOB_GUID': [0x17cb4b7, 0xb80c, 0x4040, 0xb6, 0xc8, 0xea, 0x98, 0x2b, 0xbb, 0x25, 0xb7],
    'AMI_SMBUS_SMM_PROTOCOL_GUID': [0x72e40094, 0x2ee1, 0x497a, 0x8f, 0x33, 0x4c, 0x93, 0x4a, 0x9e, 0x9c, 0xc],
    'AMI_SMM_DIGITAL_SIGNATURE_PROTOCOL_GUID': [0x91ABC830, 0x16FC, 0x4D9E, 0xA1, 0x89, 0x5F, 0xC8, 0xBB, 0x41, 0x14, 0x02],
    'AMI_SMM_INFO_PROTOCOL_GUID': [0xeb5198eb, 0xe7f5, 0x45a1, 0x9c, 0xcb, 0xe5, 0x33, 0x64, 0xbb, 0x49, 0x92],
    'AMI_STANDARD_DEFAULTS_VARIABLE_GUID': [0x4599d26f, 0x1a11, 0x49b8, 0xb9, 0x1f, 0x85, 0x87, 0x45, 0xcf, 0xf8, 0x24],
    'AMI_STATUS_CODE_CPU_BIST_DATA_GUID': [0xcd541d77, 0x6699, 0x4b36, 0xa3, 0x1e, 0x1a, 0xa4, 0xc5, 0xd5, 0xb9, 0x46],
    'AMI_TCG_CONFIRMATION_FLAGS_GUID': [0x7d3dceee, 0xcbce, 0x4ea7, 0x87, 0x09, 0x6e, 0x55, 0x2f, 0x1e, 0xdb, 0xde],
    'AMI_TCG_EFI_OS_VARIABLE_GUID': [0xa8a2093b, 0xfefa, 0x43c1, 0x8e, 0x62, 0xce, 0x52, 0x68, 0x47, 0x26, 0x5e],
    'AMI_TCG_PERM_FLAGS_GUID': [0x2325f2fc, 0x5683, 0x4648, 0x97, 0xc4, 0x9a, 0x52, 0x0d, 0xfb, 0xe3, 0x25],
    'AMI_TCG_PLATFORM_PPI_AFTER_MEM_GUID': [0x890c2cef, 0x43c8, 0x4209, 0xa7, 0x8d, 0xae, 0x14, 0xaa, 0x17, 0x98, 0xb4],
    'AMI_TCG_PLATFORM_PPI_BEFORE_MEM_GUID': [0xc1e6791d, 0xf35b, 0x43ef, 0x92, 0xa, 0xbe, 0x6, 0xba, 0x7f, 0x86, 0xa1],
    'AMI_TCG_PLATFORM_PPI_GUID': [0x5687f4a, 0x3ca7, 0x4d19, 0x9b, 0xc5, 0xe1, 0x80, 0xce, 0xa3, 0x56, 0x9f],
    'AMI_TCG_PLATFORM_PROTOCOL_GUID': [0x320bdc39, 0x3fa0, 0x4ba9, 0xbf, 0x2d, 0xb3, 0x3f, 0x72, 0xba, 0x9c, 0xa1],
    'AMI_TCG_RESETVAR_HOB_GUID': [0xa8a2093b, 0xfefa, 0x43c1, 0x8e, 0x62, 0xce, 0x52, 0x68, 0x47, 0x26, 0x5e],
    'AMI_USB_SMM_PROTOCOL_GUID': [0x3ef7500e, 0xcf55, 0x474f, 0x8e, 0x7e, 0x0, 0x9e, 0xe, 0xac, 0xec, 0xd2],
    'AMT_FORCE_PUSH_PET_HOB_GUID': [0x4efa0db6, 0x26dc, 0x4bb1, 0xa7, 0x6f, 0x14, 0xbc, 0x63, 0x0c, 0x7b, 0x3c],
    'AMT_FORCE_PUSH_PET_POLICY_GUID': [0xacc8e1e4, 0x9f9f, 0x4e40, 0xa5, 0x7e, 0xf9, 0x9e, 0x52, 0xf3, 0x4c, 0xa5],
    'AMT_FORCE_PUSH_PET_VARIABLE_GUID': [0xd7ac94af, 0xa498, 0x45ec, 0xbf, 0xa2, 0xa5, 0x6e, 0x95, 0x34, 0x61, 0x8b],
    'AMT_INT16_CSM_GUID': [0x6046e678, 0x24ef, 0x4005, 0xba, 0x39, 0xbd, 0xa1, 0x1f, 0x6d, 0x55, 0x5d],
    'AMT_READY_TO_BOOT_PROTOCOL_GUID': [0x40b09b5a, 0xf0ef, 0x4627, 0x93, 0xd5, 0x27, 0xf0, 0x4b, 0x75, 0x4d, 0x5],
    'AOAC_EC_WAKEUP_CUSTOM_PPI_GUID': [0x82627acf, 0xd92d, 0x416d, 0x8a, 0x6f, 0x78, 0x3c, 0xac, 0xd9, 0x12, 0x23],
    'AOAC_FFS_TABLE_STORAGE_GUID': [0xfb045db2, 0x598e, 0x485a, 0xba, 0x30, 0x5d, 0x7b, 0x1b, 0x1b, 0xd5, 0x4d],
    'APTIO_FW_CAPSULE_GUID': [0x4A3CA68B, 0x7723, 0x48FB, 0x80, 0x3d, 0x57, 0x8c, 0xc1, 0xfe, 0xc4, 0x4d],
    'APTIO_HII_PROTOCOL_GUID': [0xea816d2c, 0xcee5, 0x4f02, 0x99, 0xb5, 0xd3, 0x90, 0x5c, 0xbb, 0xd0, 0x77],
    'AUTHVAR_MAILBOX_VARIABLE_GUID': [0x532B6532, 0x6499, 0x428D, 0xAC, 0xB1, 0xF6, 0xF7, 0x79, 0xC9, 0x4D, 0xF9],
    'BDS_ALL_DRIVERS_CONNECTED_PROTOCOL_GUID': [0xdbc9fd21, 0xfad8, 0x45b0, 0x9e, 0x78, 0x27, 0x15, 0x88, 0x67, 0xcc, 0x93],
    'BDS_CONNECT_DRIVERS_PROTOCOL_GUID': [0x3aa83745, 0x9454, 0x4f7a, 0xa7, 0xc0, 0x90, 0xdb, 0xd0, 0x2f, 0xab, 0x8e],
    'BLOCK_DEVICE_RECOVERY_CAPSULE_GUID': [0xba8263c, 0xa8bd, 0x4aad, 0xb4, 0x2, 0x6a, 0x6a, 0xf2, 0xf7, 0xe7, 0x7d],
    'BOOT_FLOW_VARIABLE_GUID': [0xEF152FB4, 0x7B2F, 0x427D, 0xBD, 0xB4, 0x7E, 0x0A, 0x05, 0x82, 0x6E, 0x64],
    'BOOT_FORM_SET_GUID': [0x8b33ffe0, 0xd71c, 0x4f82, 0x9c, 0xeb, 0xc9, 0x70, 0x58, 0xc1, 0x3f, 0x8e],
    'BOOT_MANAGER_GUID': [0xB4909CF3, 0x7B93, 0x4751, 0x9B, 0xD8, 0x5B, 0xA8, 0x22, 0x0B, 0x9B, 0xB2],
    'BOOT_NOW_COUNT_GUID': [0x052e6eb0, 0xf240, 0x42c5, 0x83, 0x09, 0x45, 0x87, 0x45, 0x45, 0xc6, 0xb4],
    'CHIPSET_FORM_SET_GUID': [0xadfe34c8, 0x9ae1, 0x4f8f, 0xbe, 0x13, 0xcf, 0x96, 0xa2, 0xcb, 0x2c, 0x5b],
    'CMOS_MANAGER_HOB_GUID': [0xd5367802, 0xb873, 0x4c0f, 0xb5, 0x44, 0x31, 0xb7, 0xcc, 0xf5, 0xc5, 0x55],
    'CONSOLE_IN_DEVICES_STARTED_PROTOCOL_GUID': [0x2df1e051, 0x906d, 0x4eff, 0x86, 0x9d, 0x24, 0xe6, 0x53, 0x78, 0xfb, 0x9e],
    'CONSOLE_OUT_DEVICES_STARTED_PROTOCOL_GUID': [0xef9a3971, 0xc1a0, 0x4a93, 0xbd, 0x40, 0x5a, 0xa1, 0x65, 0xf2, 0xdc, 0x3a],
    'CPU_MICROCODE_FILE_GUID': [0x17088572, 0x377F, 0x44ef, 0x8F, 0x4E, 0xB0, 0x9F, 0xFF, 0x46, 0xA0, 0x70],
    'CPU_WAKE_UP_BUFFER_VARIABLE_GUID': [0xdf665292, 0x79d7, 0x40e2, 0xba, 0x51, 0xf7, 0xd4, 0x94, 0x62, 0x81, 0x85],
    'CSM_VIDEO_POLICY_PROTOCOL_GUID': [0x3a4e4376, 0x4871, 0x4b0e, 0xa0, 0x2f, 0xed, 0x36, 0xf2, 0xae, 0xcd, 0x0],
    'DCA_HOB_GUID': [0x6865c455, 0x8626, 0x40d8, 0x90, 0xf4, 0xa6, 0x94, 0x60, 0xa4, 0xab, 0x5a],
    'DEBUGGER_TERMINAL_VAR_GUID': [0x97ca1a5b, 0xb760, 0x4d1f, 0xa5, 0x4b, 0xd1, 0x90, 0x92, 0x3, 0x2c, 0x90],
    'DEFINE_GUID_CRBDXEBin_GUID': [0x16271fca, 0x55d9, 0x4a33, 0x93, 0xfc, 0x5a, 0x3e, 0xb1, 0x28, 0xde, 0xb6],
    'DEFINE_GUID_CRBSMIBin_GUID': [0x221f1d4f, 0x034c, 0x4bea, 0xb2, 0xbb, 0xb7, 0xa9, 0x67, 0x2b, 0x06, 0xd7],
    'DEFINE_GUID_AcpiPlatformPeiBin_GUID': [0x333bb2a3, 0x4f20, 0x4c8b, 0xac, 0x38, 0x6, 0x72, 0xd7, 0x43, 0x15, 0xf8],
    'DEFINE_GUID_OEMPEIBin_GUID': [0x6e59df06, 0x62d3, 0x40b0, 0x82, 0xb5, 0x17, 0x5c, 0xf8, 0x4a, 0x94, 0xe4],
    'DEFINE_GUID_SBDXEBin_GUID': [0xb7d19491, 0xe55a, 0x470d, 0x85, 0x8, 0x85, 0xa5, 0xdf, 0xa4, 0x19, 0x74],
    'DEFINE_GUID_OEMDXEBin_GUID': [0xbfe205c9, 0x5b17, 0x4f8f, 0x93, 0x75, 0x89, 0x61, 0x4a, 0xf8, 0xe1, 0x99],
    'DEFINE_GUID_SBPEIBin_GUID': [0xc1fbd624, 0x27ea, 0x40d1, 0xaa, 0x48, 0x94, 0xc3, 0xdc, 0x5c, 0x7e, 0xd],
    'DEFINE_GUID_CRBPEIBin_GUID': [0xd1ed2f7, 0xe92b, 0x4562, 0x92, 0xdd, 0x5c, 0x82, 0xec, 0x91, 0x7e, 0xae],
    'DEFINE_GUID_AcpiPlatformSmiBin_GUID': [0xdfd8d5cc, 0x5aed, 0x4820, 0xa2, 0xb6, 0x5c, 0x55, 0xe4, 0xe6, 0x40, 0xef],
    'DEFINE_GUID_NBPEIBin_GUID': [0x79aa6086, 0x035a, 0x4ad9, 0xa8, 0x9a, 0xa6, 0xd5, 0xaa, 0x27, 0xf0, 0xe2],
    'DEFINE_GUID_NBDXEBin_GUID': [0xe4ecd0b2, 0xe277, 0x4f2b, 0xbe, 0xcb, 0xe4, 0xd7, 0x5c, 0x9a, 0x81, 0x2e],
    'DEFINE_GUID_SBRunBin_GUID': [0xe23f86e1, 0x056e, 0x4888, 0xb6, 0x85, 0xcf, 0xcd, 0x67, 0xc1, 0x79, 0xd4],
    'DEL_BOOT_OPTION_GUID': [0xF6C73719, 0xF34C, 0x479C, 0xB3, 0x2F, 0x27, 0x7F, 0xCB, 0xBC, 0xFE, 0x4F],
    'DIMM_TS_INFO_GUID': [0xce673a28, 0x800d, 0x4b4a, 0x83, 0x16, 0x26, 0x61, 0xf9, 0xb3, 0xd9, 0xc6],
    'DXE_CPU_CACHE_PROTOCOL_GUID': [0x5c6fa2c9, 0x9768, 0x45f6, 0x8e, 0x64, 0x5a, 0xec, 0xca, 0xda, 0xb4, 0x81],
    'DXE_CPU_INFO_PROTOCOL_GUID': [0xe223cf65, 0xf6ce, 0x4122, 0xb3, 0xaf, 0x4b, 0xd1, 0x8a, 0xff, 0x40, 0xa1],
    'DXE_CPU_PLATFORM_POLICY_PROTOCOL_GUID': [0xbd26cdc9, 0xa092, 0x462a, 0x87, 0x7a, 0x5a, 0xb6, 0xad, 0xce, 0x48, 0x12],
    'DXE_ENHANCED_SPEEDSTEP_PROTOCOL_GUID': [0xe98021, 0xf4fe, 0x46cc, 0xab, 0x2d, 0x89, 0x4c, 0x37, 0x3a, 0xfa, 0x1],
    'DXE_PCH_PLATFORM_POLICY_PROTOCOL_GUID': [0xe0a31dbe, 0xf20e, 0x4e2a, 0x9f, 0x2b, 0x9f, 0x2, 0xa2, 0x7d, 0x3d, 0x69],
    'DXE_PLATFORM_AMT_POLICY_GUID': [0xb2ab115e, 0xc8b6, 0x4036, 0xbf, 0x31, 0xe7, 0x4b, 0xd8, 0x92, 0x6c, 0xce],
    'DXE_PLATFORM_ME_POLICY_GUID': [0xf8bff014, 0x18fb, 0x4ef9, 0xb1, 0xc, 0xae, 0x22, 0x73, 0x8d, 0xbe, 0xed],
    'DXE_PLATFORM_SA_POLICY_GUID': [0xCD2333D7, 0x6A0A, 0x4C76, 0x83, 0x50, 0x24, 0xA, 0xDA, 0x36, 0xA2, 0xC7],
    'DXE_PLATFORM_SG_POLICY_GUID': [0x6199dc36, 0xe114, 0x4e0d, 0x80, 0x99, 0x99, 0xa0, 0xbd, 0x80, 0xa9, 0x71],
    'DXE_PLATFORM_TDT_POLICY_GUID': [0x20daf0fc, 0x5548, 0x44dc, 0xa4, 0x2a, 0x60, 0xea, 0xf0, 0xa2, 0x2e, 0x47],
    'DXE_TXT_POLICY_PROTOCOL_GUID': [0x43F66FFD, 0xB288, 0x4139, 0xBA, 0xD5, 0xB8, 0x98, 0x3, 0xE7, 0x30, 0xA2],
    'DYNAMIC_PAGE_COUNT_GUID': [0xb63bf800, 0xf267, 0x4f55, 0x92, 0x17, 0xe9, 0x7f, 0xb3, 0xb6, 0x98, 0x46],
    'EFI_ABSOLUTE_POINTER_PROTOCOL_GUID': [0x8D59D32B, 0xC655, 0x4AE9, 0x9B, 0x15, 0xF2, 0x59, 0x04, 0x99, 0x2A, 0x43],
    'EFI_ACPI_20_TABLE_GUID': [0x8868e871, 0xe4f1, 0x11d3, 0xbc, 0x22, 0x0, 0x80, 0xc7, 0x3c, 0x88, 0x81],
    'EFI_ACPI_20_TABLE_GUID': [0x8868e871, 0xe4f1, 0x11d3, 0xbc, 0x22, 0x0, 0x80, 0xc7, 0x3c, 0x88, 0x81],
    'EFI_ACPI_S3_SAVE_GUID': [0x125f2de1, 0xfb85, 0x440c, 0xa5, 0x4c, 0x4d, 0x99, 0x35, 0x8a, 0x8d, 0x38],
    'EFI_ACPI_SDT_PROTOCOL_GUID': [0xeb97088e, 0xcfdf, 0x49c6, 0xbe, 0x4b, 0xd9, 0x6, 0xa5, 0xb2, 0xe, 0x86],
    'EFI_ACPI_SUPPORT_GUID': [0xdbff9d55, 0x89b7, 0x46da, 0xbd, 0xdf, 0x67, 0x7d, 0x3d, 0xc0, 0x24, 0x1d],
    'EFI_ACPI_TABLE_GUID': [0xeb9d2d30, 0x2d88, 0x11d3, 0x9a, 0x16, 0x0, 0x90, 0x27, 0x3f, 0xc1, 0x4d],
    'EFI_ACPI_TABLE_PROTOCOL_GUID': [0xffe06bdd, 0x6107, 0x46a6, 0x7b, 0xb2, 0x5a, 0x9c, 0x7e, 0xc5, 0x27, 0x5c],
    'EFI_ACPI_TABLE_STORAGE_GUID': [0x7e374e25, 0x8e01, 0x4fee, 0x87, 0xf2, 0x39, 0xc, 0x23, 0xc6, 0x6, 0xcd],
    'EFI_ACPI_VARIABLE_GUID': [0xaf9ffd67, 0xec10, 0x488a, 0x9d, 0xfc, 0x6c, 0xbf, 0x5e, 0xe2, 0x2c, 0x2e],
    'EFI_ACTIVE_BIOS_PROTOCOL_GUID': [0xebbe2d1b, 0x1647, 0x4bda, 0xab, 0x9a, 0x78, 0x63, 0xe3, 0x96, 0xd4, 0x1a],
    'EFI_ACTIVE_MANAGEMENT_PROTOCOL_GUID': [0x8555fd40, 0x140b, 0x4f3c, 0x90, 0x5e, 0x3b, 0xf3, 0x78, 0xa0, 0x99, 0xfa],
    'EFI_AHCI_INT13_INIT_PROTOCOL_GUID': [0x67820532, 0x7613, 0x4dd3, 0x9e, 0xd7, 0x3d, 0x9b, 0xe3, 0xa7, 0xda, 0x63],
    'EFI_ALERT_STANDARD_FORMAT_PROTOCOL_GUID': [0xcc93a70b, 0xec27, 0x49c5, 0x8b, 0x34, 0x13, 0x93, 0x1e, 0xfe, 0xd6, 0xe2],
    'EFI_ALTERNATE_FV_BLOCK_GUID': [0xf496922d, 0x172f, 0x4bbc, 0xa1, 0xeb, 0xe, 0xeb, 0x94, 0x9c, 0x34, 0x86],
    'EFI_AMI_LEGACYBOOT_PROTOCOL_GUID': [0x120d28aa, 0x6630, 0x46f0, 0x81, 0x57, 0xc0, 0xad, 0xc2, 0x38, 0x3b, 0xf5],
    'EFI_APRIORI_GUID': [0xfc510ee7, 0xffdc, 0x11d4, 0xbd, 0x41, 0x0, 0x80, 0xc7, 0x3c, 0x88, 0x81],
    'EFI_ARP_PROTOCOL_GUID': [0xf4b427bb, 0xba21, 0x4f16, 0xbc, 0x4e, 0x43, 0xe4, 0x16, 0xab, 0x61, 0x9c],
    'EFI_ARP_SERVICE_BINDING_PROTOCOL_GUID': [0xf44c00ee, 0x1f2c, 0x4a00, 0xaa, 0x9, 0x1c, 0x9f, 0x3e, 0x8, 0x0, 0xa3],
    'EFI_AUTHENTICATION_INFO_PROTOCOL_GUID': [0x7671d9d0, 0x53db, 0x4173, 0xaa, 0x69, 0x23, 0x27, 0xf2, 0x1f, 0x0b, 0xc7],
    'EFI_AUTHENTICATION_INFO_PROTOCOL_GUID': [0x7671d9d0, 0x53db, 0x4173, 0xaa, 0x69, 0x23, 0x27, 0xf2, 0x1f, 0xb, 0xc7],
    'EFI_AUTHORIZATION_PROTOCOL_GUID': [0x995188b1, 0x9f96, 0x11d4, 0x87, 0xae, 0x00, 0x06, 0x29, 0x2e, 0x8a, 0x3b],
    'EFI_BDAT_ACCESS_GUID': [0xb979746a, 0x8c1f, 0x4a2b, 0x97, 0xe4, 0x78, 0xe9, 0x3a, 0x71, 0xa7, 0xa],
    'EFI_BDS_ARCH_PROTOCOL_GUID': [0x665E3FF6, 0x46CC, 0x11d4, 0x9A, 0x38, 0x00, 0x90, 0x27, 0x3F, 0xC1, 0x4D],
    'EFI_BIS_PROTOCOL_GUID': [0x0b64aab0, 0x5429, 0x11d4, 0x98, 0x16, 0x00, 0xa0, 0xc9, 0x1f, 0xad, 0xcf],
    'EFI_BLOCK_IO_PROTOCOL_GUID': [0x964e5b21, 0x6459, 0x11d2, 0x8e, 0x39, 0x0, 0xa0, 0xc9, 0x69, 0x72, 0x3b],
    'EFI_BOOT_SCRIPT_SAVE_PROTOCOL_GUID': [0x470e1529, 0xb79e, 0x4e32, 0xa0, 0xfe, 0x6a, 0x15, 0x6d, 0x29, 0xf9, 0xb2],
    'EFI_BUS_SPECIFIC_DRIVER_OVERRIDE_PROTOCOL_GUID': [0x3bc1b285, 0x8a15, 0x4a82, 0xaa, 0xbf, 0x4d, 0x7d, 0x13, 0xfb, 0x32, 0x65],
    'EFI_CACHE_INSTALL_PPI_GUID': [0xbb628ae0, 0xcd4f, 0x49fe, 0x8d, 0x60, 0x63, 0x18, 0x6f, 0xd1, 0xe0, 0x5b],
    'EFI_CACHE_SUBCLASS_GUID': [0x7f0013a7, 0xdc79, 0x4b22, 0x80, 0x99, 0x11, 0xf7, 0x5f, 0xdc, 0x82, 0x9d],
    'EFI_CAPSULE_AMI_GUID': [0xfac2efad, 0x8511, 0x4e34, 0x9c, 0xae, 0x16, 0xa2, 0x57, 0xba, 0x94, 0x88],
    'EFI_CAPSULE_ARCH_PROTOCOL_GUID': [0x5053697e, 0x2cbc, 0x4819, 0x90, 0xd9, 0x5, 0x80, 0xde, 0xee, 0x57, 0x54],
    'EFI_CAPSULE_GUID': [0x3B6686BD, 0x0D76, 0x4030, 0xB7, 0x0E, 0xB5, 0x51, 0x9E, 0x2F, 0xC5, 0xA0],
    'EFI_CAPSULE_INFO_GUID': [0x8B34EAC7, 0x2690, 0x460B, 0x8B, 0xA5, 0xD5, 0xCF, 0x32, 0x83, 0x17, 0x35],
    'EFI_CAPSULE_VENDOR_GUID': [0x711C703F, 0xC285, 0x4B10, 0xA3, 0xB0, 0x36, 0xEC, 0xBD, 0x3C, 0x8B, 0xE2],
    'EFI_CERT_RSA2048_GUID': [0x3c5766e8, 0x269c, 0x4e34, 0xaa, 0x14, 0xed, 0x77, 0x6e, 0x85, 0xb3, 0xb6],
    'EFI_CERT_RSA2048_SHA1_GUID': [0x67f8444f, 0x8743, 0x48f1, 0xa3, 0x28, 0x1e, 0xaa, 0xb8, 0x73, 0x60, 0x80],
    'EFI_CERT_RSA2048_SHA256_GUID': [0xe2b36190, 0x879b, 0x4a3d, 0xad, 0x8d, 0xf2, 0xe7, 0xbb, 0xa3, 0x27, 0x84],
    'EFI_CERT_SHA1_GUID': [0x826ca512, 0xcf10, 0x4ac9, 0xb1, 0x87, 0xbe, 0x01, 0x49, 0x66, 0x31, 0xbd],
    'EFI_CERT_SHA256_GUID': [0xc1c41626, 0x504c, 0x4092, 0xac, 0xa9, 0x41, 0xf9, 0x36, 0x93, 0x43, 0x28],
    'EFI_CERT_TYPE_PKCS7_GUID': [0x4aafd29d, 0x68df, 0x49ee, 0x8a, 0xa9, 0x34, 0x7d, 0x37, 0x56, 0x65, 0xa7],
    'EFI_CERT_TYPE_RSA2048_SHA256_GUID': [0xa7717414, 0xc616, 0x4977, 0x94, 0x20, 0x84, 0x47, 0x12, 0xa7, 0x35, 0xbf],
    'EFI_CLP_PROTOCOL_GUID': [0xcbbee336, 0x2682, 0x4cd6, 0x81, 0x8b, 0xa, 0xd, 0x96, 0x7e, 0x5a, 0x67],
    'EFI_CMOS_DATA_HOB_INSTALLED_GUID': [0x5a6a93f4, 0x2907, 0x4a34, 0xbd, 0x11, 0x6c, 0xa8, 0xa0, 0x95, 0x9e, 0x9],
    'EFI_COMPATIBLE_MEMORY_TESTED_PROTOCOL_GUID': [0x64c475ef, 0x344b, 0x492c, 0x93, 0xad, 0xab, 0x9e, 0xb4, 0x39, 0x50, 0x4],
    'EFI_COMPONENT_NAME2_PROTOCOL_GUID': [0x6a7a5cff, 0xe8d9, 0x4f70, 0xba, 0xda, 0x75, 0xab, 0x30, 0x25, 0xce, 0x14],
    'EFI_COMPONENT_NAME_PROTOCOL_GUID': [0x107a772c, 0xd5e1, 0x11d4, 0x9a, 0x46, 0x0, 0x90, 0x27, 0x3f, 0xc1, 0x4d],
    'EFI_CONFIG_FILE_NAME_GUID': [0x98B8D59B, 0xE8BA, 0x48EE, 0x98, 0xDD, 0xC2, 0x95, 0x39, 0x2F, 0x1E, 0xDB],
    'EFI_CONSOLE_IN_DEVICE_GUID': [0xd3b36f2b, 0xd551, 0x11d4, 0x9a, 0x46, 0x0, 0x90, 0x27, 0x3f, 0xc1, 0x4d],
    'EFI_CONSOLE_LOCK_GUID': [0x368cda0d, 0xcf31, 0x4b9b, 0x8c, 0xf6, 0xe7, 0xd1, 0xbf, 0xff, 0x15, 0x7e],
    'EFI_CONSOLE_OUT_DEVICE_GUID': [0xd3b36f2c, 0xd551, 0x11d4, 0x9a, 0x46, 0x0, 0x90, 0x27, 0x3f, 0xc1, 0x4d],
    'EFI_CPU_ARCH_PROTOCOL_GUID': [0x26baccb1, 0x6f42, 0x11d4, 0xbc, 0xe7, 0x0, 0x80, 0xc7, 0x3c, 0x88, 0x81],
    'EFI_CPU_IO2_PROTOCOL_GUID': [0xB0732526, 0x38C8, 0x4b40, 0x88, 0x77, 0x61, 0xC7, 0xB0, 0x6A, 0xAC, 0x45],
    'EFI_CPU_IO2_PROTOCOL_GUID': [0xad61f191, 0xae5f, 0x4c0e, 0xb9, 0xfa, 0xe8, 0x69, 0xd2, 0x88, 0xc6, 0x4f],
    'EFI_CPU_IO_PROTOCOL_GUID': [0xB0732526, 0x38C8, 0x4b40, 0x88, 0x77, 0x61, 0xC7, 0xB0, 0x6A, 0xAC, 0x45],
    'EFI_CPU_TYPE_FRU_GUID': [0xf064c91f, 0x188c, 0x4f56, 0xb7, 0xfd, 0x30, 0xa9, 0xb8, 0x6a, 0x29, 0xf3],
    'EFI_CRC32_GUIDED_SECTION_EXTRACTION_PROTOCOL_GUID': [0xFC1BCDB0, 0x7D31, 0x49aa, 0x93, 0x6A, 0xA4, 0x60, 0x0D, 0x9D, 0xD0, 0x83],
    'EFI_CUSTOMIZED_DECOMPRESS_PROTOCOL_GUID': [0x9a44198e, 0xa4a2, 0x44e6, 0x8a, 0x1f, 0x39, 0xbe, 0xfd, 0xac, 0x89, 0x6f],
    'EFI_DATA_HUB_PROTOCOL_GUID': [0xae80d021, 0x618e, 0x11d4, 0xbc, 0xd7, 0x0, 0x80, 0xc7, 0x3c, 0x88, 0x81],
    'EFI_DEBUGPORT_PROTOCOL_GUID': [0xEBA4E8D2, 0x3858, 0x41EC, 0xA2, 0x81, 0x26, 0x47, 0xBA, 0x96, 0x60, 0xD0],
    'EFI_DEBUG_ASSERT_PROTOCOL_GUID': [0xbe499c92, 0x7d4b, 0x11d4, 0xbc, 0xee, 0x0, 0x80, 0xc7, 0x3c, 0x88, 0x81],
    'EFI_DEBUG_IMAGE_INFO_TABLE_GUID': [0x49152e77, 0x1ada, 0x4764, 0xb7, 0xa2, 0x7a, 0xfe, 0xfe, 0xd9, 0x5e, 0x8b],
    'EFI_DEBUG_MASK_PPI_GUID': [0x3bd930fd, 0xf823, 0x4948, 0x86, 0x91, 0x98, 0xe6, 0xfe, 0x36, 0xac, 0xe2],
    'EFI_DEBUG_MASK_PROTOCOL_GUID': [0x4c8a2451, 0xc207, 0x405b, 0x96, 0x94, 0x99, 0xea, 0x13, 0x25, 0x13, 0x41],
    'EFI_DEBUG_SUPPORT_PROTOCOL_GUID': [0x2755590C, 0x6F3C, 0x42FA, 0x9E, 0xA4, 0xA3, 0xBA, 0x54, 0x3C, 0xDA, 0x25],
    'EFI_DECOMPRESS_PROTOCOL_GUID': [0xd8117cfe, 0x94a6, 0x11d4, 0x9a, 0x3a, 0x0, 0x90, 0x27, 0x3f, 0xc1, 0x4d],
    'EFI_DEFERRED_IMAGE_LOAD_PROTOCOL_GUID': [0x15853d7c, 0x3ddf, 0x43e0, 0xa1, 0xcb, 0xeb, 0xf8, 0x5b, 0x8f, 0x87, 0x2c],
    'EFI_DEVICE_IO_PROTOCOL_GUID': [0xaf6ac311, 0x84c3, 0x11d2, 0x8e, 0x3c, 0x00, 0xa0, 0xc9, 0x69, 0x72, 0x3b],
    'EFI_DEVICE_PATH_FROM_TEXT_PROTOCOL_GUID': [0x5c99a21, 0xc70f, 0x4ad2, 0x8a, 0x5f, 0x35, 0xdf, 0x33, 0x43, 0xf5, 0x1e],
    'EFI_DEVICE_PATH_PROTOCOL_GUID': [0x09576e91, 0x6d3f, 0x11d2, 0x8e, 0x39, 0x00, 0xa0, 0xc9, 0x69, 0x72, 0x3b],
    'EFI_DEVICE_PATH_PROTOCOL_GUID': [0x9576e91, 0x6d3f, 0x11d2, 0x8e, 0x39, 0x0, 0xa0, 0xc9, 0x69, 0x72, 0x3b],
    'EFI_DEVICE_PATH_TO_TEXT_PROTOCOL_GUID': [0x8b843e20, 0x8132, 0x4852, 0x90, 0xcc, 0x55, 0x1a, 0x4e, 0x4a, 0x7f, 0x1c],
    'EFI_DEVICE_PATH_UTILITIES_PROTOCOL_GUID': [0x379be4e, 0xd706, 0x437d, 0xb0, 0x37, 0xed, 0xb8, 0x2f, 0xb7, 0x72, 0xa4],
    'EFI_DHCP4_PROTOCOL_GUID': [0x8a219718, 0x4ef5, 0x4761, 0x91, 0xc8, 0xc0, 0xf0, 0x4b, 0xda, 0x9e, 0x56],
    'EFI_DHCP4_SERVICE_BINDING_PROTOCOL_GUID': [0x9d9a39d8, 0xbd42, 0x4a73, 0xa4, 0xd5, 0x8e, 0xe9, 0x4b, 0xe1, 0x13, 0x80],
    'EFI_DISK_INFO_AHCI_INTERFACE_GUID': [0x9e498932, 0x4abc, 0x45af, 0xa3, 0x4d, 0x2, 0x47, 0x78, 0x7b, 0xe7, 0xc6],
    'EFI_DISK_INFO_IDE_INTERFACE_GUID': [0x5e948fe3, 0x26d3, 0x42b5, 0xaf, 0x17, 0x61, 0x2, 0x87, 0x18, 0x8d, 0xec],
    'EFI_DISK_INFO_PROTOCOL_GUID': [0xd432a67f, 0x14dc, 0x484b, 0xb3, 0xbb, 0x3f, 0x2, 0x91, 0x84, 0x93, 0x27],
    'EFI_DISK_INFO_SCSI_INTERFACE_GUID': [0x8f74baa, 0xea36, 0x41d9, 0x95, 0x21, 0x21, 0xa7, 0xf, 0x87, 0x80, 0xbc],
    'EFI_DISK_INFO_USB_INTERFACE_GUID': [0xcb871572, 0xc11a, 0x47b5, 0xb4, 0x92, 0x67, 0x5e, 0xaf, 0xa7, 0x77, 0x27],
    'EFI_DISK_IO_PROTOCOL_GUID': [0xCE345171, 0xBA0B, 0x11d2, 0x8e, 0x4F, 0x00, 0xa0, 0xc9, 0x69, 0x72, 0x3b],
    'EFI_DISK_IO_PROTOCOL_GUID': [0xce345171, 0xba0b, 0x11d2, 0x8e, 0x4f, 0x0, 0xa0, 0xc9, 0x69, 0x72, 0x3b],
    'EFI_DMI_FORMAT_FRU_GUID': [0x67ef7a73, 0x2594, 0x4a5e, 0x93, 0xa, 0xe1, 0x66, 0xfa, 0xbc, 0xd2, 0xc8],
    'EFI_DRIVER_BINDING_PROTOCOL_GUID': [0x18a031ab, 0xb443, 0x4d1a, 0xa5, 0xc0, 0xc, 0x9, 0x26, 0x1e, 0x9f, 0x71],
    'EFI_DRIVER_CONFIGURATION2_PROTOCOL_GUID': [0xbfd7dc1d, 0x24f1, 0x40d9, 0x82, 0xe7, 0x2e, 0x09, 0xbb, 0x6b, 0x4e, 0xbe],
    'EFI_DRIVER_CONFIGURATION_PROTOCOL_GUID': [0x107a772b, 0xd5e1, 0x11d4, 0x9a, 0x46, 0x0, 0x90, 0x27, 0x3f, 0xc1, 0x4d],
    'EFI_DRIVER_DIAGNOSTICS2_PROTOCOL_GUID': [0x4d330321, 0x025f, 0x4aac, 0x90, 0xd8, 0x5e, 0xd9, 0x0, 0x17, 0x3b, 0x63],
    'EFI_DRIVER_DIAGNOSTICS_PROTOCOL_GUID': [0x0784924f, 0xe296, 0x11d4, 0x9a, 0x49, 0x0, 0x90, 0x27, 0x3f, 0xc1, 0x4d],
    'EFI_DRIVER_DIAGNOSTICS_PROTOCOL_GUID': [0x4d330321, 0x025f, 0x4aac, 0x90, 0xd8, 0x5e, 0xd9, 0x00, 0x17, 0x3b, 0x63],
    'EFI_DRIVER_FAMILY_OVERRIDE_PROTOCOL_GUID': [0xb1ee129e, 0xda36, 0x4181, 0x91, 0xf8, 0x4, 0xa4, 0x92, 0x37, 0x66, 0xa7],
    'EFI_DRIVER_HEALTH_PROTOCOL_GUID': [0x2a534210, 0x9280, 0x41d8, 0xae, 0x79, 0xca, 0xda, 0x1, 0xa2, 0xb1, 0x27],
    'EFI_DRIVER_SUPPORTED_EFI_VERSION_PROTOCOL_GUID': [0x5c198761, 0x16a8, 0x4e69, 0x97, 0x2c, 0x89, 0xd6, 0x79, 0x54, 0xf8, 0x1d],
    'EFI_DXE_CMOS_ACCESS_GUID': [0x9851740c, 0x22e0, 0x440d, 0x90, 0x90, 0xef, 0x2d, 0x71, 0xc2, 0x51, 0xc9],
    'EFI_DXE_IPL_PPI_GUID': [0xae8ce5d, 0xe448, 0x4437, 0xa8, 0xd7, 0xeb, 0xf5, 0xf1, 0x94, 0xf7, 0x31],
    'EFI_DXE_SERVICES_TABLE_GUID': [0x5ad34ba, 0x6f02, 0x4214, 0x95, 0x2e, 0x4d, 0xa0, 0x39, 0x8e, 0x2b, 0xb9],
    'EFI_DXE_SMM_READY_TO_LOCK_PROTOCOL_GUID': [0x60ff8964, 0xe906, 0x41d0, 0xaf, 0xed, 0xf2, 0x41, 0xe9, 0x74, 0xe0, 0x8e],
    'EFI_EBC_INTERPRETER_PROTOCOL_GUID': [0x13AC6DD1, 0x73D0, 0x11D4, 0xB0, 0x6B, 0x00, 0xAA, 0x00, 0xBD, 0x6D, 0xE7],
    'EFI_EDID_ACTIVE_PROTOCOL_GUID': [0xbd8c1056, 0x9f36, 0x44ec, 0x92, 0xa8, 0xa6, 0x33, 0x7f, 0x81, 0x79, 0x86],
    'EFI_EDID_DISCOVERED_PROTOCOL_GUID': [0x1c0c34f6, 0xd380, 0x41fa, 0xa0, 0x49, 0x8a, 0xd0, 0x6c, 0x1a, 0x66, 0xaa],
    'EFI_EDID_OVERRIDE_PROTOCOL_GUID': [0x48ecb431, 0xfb72, 0x45c0, 0xa9, 0x22, 0xf4, 0x58, 0xfe, 0x4, 0xb, 0xd5],
    'EFI_EMUL6064KBDINPUT_PROTOCOL_GUID': [0x62ceef5a, 0x1d7c, 0x4943, 0x9b, 0x3a, 0x95, 0xe2, 0x49, 0x4c, 0x89, 0x90],
    'EFI_EMUL6064MSINPUT_PROTOCOL_GUID': [0x7578b307, 0xb25b, 0x44f9, 0x89, 0x2e, 0x20, 0x9b, 0x0e, 0x39, 0x93, 0xc6],
    'EFI_EMUL6064TRAP_PROTOCOL_GUID': [0x6ea0f71c, 0x614a, 0x437e, 0x8f, 0x49, 0x24, 0x3a, 0xd4, 0xe8, 0x32, 0x68],
    'EFI_EVENT_LEGACY_BOOT_GUID': [0x2a571201, 0x4966, 0x47f6, 0x8b, 0x86, 0xf3, 0x1e, 0x41, 0xf3, 0x2f, 0x10],
    'EFI_EXTENDED_SAL_BASE_IO_SERVICES_PROTOCOL_GUID': [0x5aea42b5, 0x31e1, 0x4515, 0xbc, 0x31, 0xb8, 0xd5, 0x25, 0x75, 0x65, 0xa6],
    'EFI_EXTENDED_SAL_BASE_SERVICES_PROTOCOL_GUID': [0xd9e9fa06, 0x0fe0, 0x41c3, 0x96, 0xfb, 0x83, 0x42, 0x5a, 0x33, 0x94, 0xf8],
    'EFI_EXTENDED_SAL_CACHE_SERVICES_PROTOCOL_GUID': [0xedc9494, 0x2743, 0x4ba5, 0x88, 0x18, 0x0a, 0xef, 0x52, 0x13, 0xf1, 0x88],
    'EFI_EXTENDED_SAL_ELOG_SERVICES_PROTOCOL_GUID': [0xd5e4ee5f, 0x3e0a, 0x453c, 0xa7, 0x25, 0xb6, 0x92, 0xbb, 0x6, 0x36, 0x5a],
    'EFI_EXTENDED_SAL_FV_BLOCK_SERVICES_PROTOCOL_GUID': [0xa2271df1, 0xbcbb, 0x4f1d, 0x98, 0xa9, 0x06, 0xbc, 0x17, 0x2f, 0x07, 0x1a],
    'EFI_EXTENDED_SAL_LOCK_SERVICES_PROTOCOL_GUID': [0x76b75c23, 0xfe4f, 0x4e17, 0xa2, 0xad, 0x1a, 0x65, 0x3d, 0xbb, 0x49, 0x4a],
    'EFI_EXTENDED_SAL_MCA_LOG_SERVICES_PROTOCOL_GUID': [0xcb3fd86e, 0x38a3, 0x4c03, 0x9a, 0x5c, 0x90, 0xcf, 0xa3, 0xa2, 0xab, 0x7a],
    'EFI_EXTENDED_SAL_MCA_SERVICES_PROTOCOL_GUID': [0x2a591128, 0x6cc7, 0x42b1, 0x8a, 0xf0, 0x58, 0x93, 0x3b, 0x68, 0x2d, 0xbb],
    'EFI_EXTENDED_SAL_MP_SERVICES_PROTOCOL_GUID': [0x697d81a2, 0xcf18, 0x4dc0, 0x9e, 0x0d, 0x06, 0x11, 0x3b, 0x61, 0x8a, 0x3f],
    'EFI_EXTENDED_SAL_MTC_SERVICES_PROTOCOL_GUID': [0x899afd18, 0x75e8, 0x408b, 0xa4, 0x1a, 0x6e, 0x2e, 0x7e, 0xcd, 0xf4, 0x54],
    'EFI_EXTENDED_SAL_PAL_SERVICES_PROTOCOL_GUID': [0xe1cd9d21, 0x0fc2, 0x438d, 0x97, 0x03, 0x04, 0xe6, 0x6d, 0x96, 0x1e, 0x57],
    'EFI_EXTENDED_SAL_PCI_SERVICES_PROTOCOL_GUID': [0xa46b1a31, 0xad66, 0x4905, 0x92, 0xf6, 0x2b, 0x46, 0x59, 0xdc, 0x30, 0x63],
    'EFI_EXTENDED_SAL_RESET_SERVICES_PROTOCOL_GUID': [0x7d019990, 0x8ce1, 0x46f5, 0xa7, 0x76, 0x3c, 0x51, 0x98, 0x67, 0x6a, 0xa0],
    'EFI_EXTENDED_SAL_RTC_SERVICES_PROTOCOL_GUID': [0x7e97a470, 0xefdb, 0x4d02, 0x8f, 0xce, 0x61, 0x90, 0xd2, 0x7b, 0xa2, 0x96],
    'EFI_EXTENDED_SAL_SENSOR_SERVICES_PROTOCOL_GUID': [0x4a153b6e, 0x85a1, 0x4982, 0x98, 0xf4, 0x6a, 0x8c, 0xfc, 0xa4, 0xab, 0xa1],
    'EFI_EXTENDED_SAL_SM_COM_LAYER_SERVICES_PROTOCOL_GUID': [0x4356799, 0x81b7, 0x4e08, 0xa3, 0x8d, 0xd9, 0x78, 0xfa, 0x47, 0xba, 0x42],
    'EFI_EXTENDED_SAL_SST_GUID': [0x38802700, 0x868a, 0x4b4e, 0x81, 0xd4, 0x4f, 0x1b, 0xdc, 0xcf, 0xb4, 0x6f],
    'EFI_EXTENDED_SAL_STALL_SERVICES_PROTOCOL_GUID': [0x53a58d06, 0xac27, 0x4d8c, 0xb5, 0xe9, 0xf0, 0x8a, 0x80, 0x65, 0x41, 0x70],
    'EFI_EXTENDED_SAL_STATUS_CODE_SERVICES_PROTOCOL_GUID': [0xdbd91d, 0x55e9, 0x420f, 0x96, 0x39, 0x5e, 0x9f, 0x84, 0x37, 0xb4, 0x4f],
    'EFI_EXTENDED_SAL_VARIABLE_SERVICES_PROTOCOL_GUID': [0x4ecb6c53, 0xc641, 0x4370, 0x8c, 0xb2, 0x3b, 0x0e, 0x49, 0x6e, 0x83, 0x78],
    'EFI_EXTENDED_SAL_VIRTUAL_SERVICES_PROTOCOL_GUID': [0xc1a74056, 0x260e, 0x4871, 0xa0, 0x31, 0xe6, 0x45, 0xa6, 0x5b, 0x6e, 0x11],
    'EFI_EXT_SCSI_PASS_THRU_PROTOCOL_GUID': [0x143b7632, 0xb81b, 0x4cb7, 0xab, 0xd3, 0xb6, 0x25, 0xa5, 0xb9, 0xbf, 0xfe],
    'EFI_FAULT_TOLERANT_WRITE_PROTOCOL_GUID': [0x3ebd9e82, 0x2c78, 0x4de6, 0x97, 0x86, 0x8d, 0x4b, 0xfc, 0xb7, 0xc8, 0x81],
    'EFI_FFS_VOLUME_TOP_FILE_GUID': [0x1BA0062E, 0xC779, 0x4582, 0x85, 0x66, 0x33, 0x6A, 0xE8, 0xF7, 0x8F, 0x9],
    'EFI_FILE_SYSTEM_INFO_ID_GUID': [0x9576e93, 0x6d3f, 0x11d2, 0x8e, 0x39, 0x0, 0xa0, 0xc9, 0x69, 0x72, 0x3b],
    'EFI_FILE_SYSTEM_VOLUME_LABEL_INFO_ID_GUID': [0xDB47D7D3, 0xFE81, 0x11d3, 0x9A, 0x35, 0x00, 0x90, 0x27, 0x3F, 0xC1, 0x4D],
    'EFI_FIND_FV_PPI_GUID': [0x36164812, 0xa023, 0x44e5, 0xbd, 0x85, 0x5, 0xbf, 0x3c, 0x77, 0x0, 0xaa],
    'EFI_FIRMWARE_FILE_SYSTEM2_GUID': [0x8c8ce578, 0x8a3d, 0x4f1c, 0x99, 0x35, 0x89, 0x61, 0x85, 0xc3, 0x2d, 0xd3],
    'EFI_FIRMWARE_FILE_SYSTEM_GUID': [0x7A9354D9, 0x0468, 0x444a, 0x81, 0xCE, 0x0B, 0xF6, 0x17, 0xD8, 0x90, 0xDF],
    'EFI_FIRMWARE_VOLUME2_PROTOCOL_GUID': [0x220e73b6, 0x6bdb, 0x4413, 0x84, 0x5, 0xb9, 0x74, 0xb1, 0x8, 0x61, 0x9a],
    'EFI_FIRMWARE_VOLUME_BLOCK2_PROTOCOL_GUID': [0x8f644fa9, 0xe850, 0x4db1, 0x9c, 0xe2, 0xb, 0x44, 0x69, 0x8e, 0x8d, 0xa4],
    'EFI_FIRMWARE_VOLUME_BLOCK_PROTOCOL_GUID': [0x8f644fa9, 0xe850, 0x4db1, 0x9c, 0xe2, 0xb, 0x44, 0x69, 0x8e, 0x8d, 0xa4],
    'EFI_FIRMWARE_VOLUME_DISPATCH_PROTOCOL_GUID': [0x7aa35a69, 0x506c, 0x444f, 0xa7, 0xaf, 0x69, 0x4b, 0xf5, 0x6f, 0x71, 0xc8],
    'EFI_FIRMWARE_VOLUME_PROTOCOL_GUID': [0x389F751F, 0x1838, 0x4388, 0x83, 0x90, 0xCD, 0x81, 0x54, 0xBD, 0x27, 0xF8],
    'EFI_FORM_BROWSER2_PROTOCOL_GUID': [0xb9d4c360, 0xbcfb, 0x4f9b, 0x92, 0x98, 0x53, 0xc1, 0x36, 0x98, 0x22, 0x58],
    'EFI_FORM_BROWSER_PROTOCOL_GUID': [0xe5a1333e, 0xe1b4, 0x4d55, 0xce, 0xeb, 0x35, 0xc3, 0xef, 0x13, 0x34, 0x43],
    'EFI_FORM_CALLBACK_PROTOCOL_GUID': [0xf3e4543d, 0xcf35, 0x6cef, 0x35, 0xc4, 0x4f, 0xe6, 0x34, 0x4d, 0xfc, 0x54],
    'EFI_FRAMEWORK_DEVICE_PATH_GUID': [0xb7084e63, 0x46b7, 0x4d1a, 0x86, 0x77, 0xe3, 0x0b, 0x53, 0xdb, 0xf0, 0x50],
    'EFI_FTW_LITE_PROTOCOL_GUID': [0x3f557189, 0x8dae, 0x45ae, 0xa0, 0xb3, 0x2b, 0x99, 0xca, 0x7a, 0xa7, 0xa0],
    'EFI_FVB_EXTENSION_PROTOCOL_GUID': [0x53a4c71b, 0xb581, 0x4170, 0x91, 0xb3, 0x8d, 0xb8, 0x7a, 0x4b, 0x5c, 0x46],
    'EFI_GENERIC_MEMORY_TEST_PROTOCOL_GUID': [0x309de7f1, 0x7f5e, 0x4ace, 0xb4, 0x9c, 0x53, 0x1b, 0xe5, 0xaa, 0x95, 0xef],
    'EFI_GENERIC_VARIABLE_GUID': [0x59d1c24f, 0x50f1, 0x401a, 0xb1, 0x01, 0xf3, 0x3e, 0x0d, 0xae, 0xd4, 0x43],
    'EFI_GLOBAL_NVS_AREA_PROTOCOL_GUID': [0x74e1e48, 0x8132, 0x47a1, 0x8c, 0x2c, 0x3f, 0x14, 0xad, 0x9a, 0x66, 0xdc],
    'EFI_GLOBAL_VARIABLE_GUID': [0x8BE4DF61, 0x93CA, 0x11D2, 0xAA, 0x0D, 0x00, 0xE0, 0x98, 0x03, 0x2B, 0x8C],
    'EFI_GLOBAL_VARIABLE_GUID': [0x8BE4DF61, 0x93CA, 0x11d2, 0xAA, 0x0D, 0x00, 0xE0, 0x98, 0x03, 0x2B, 0x8C],
    'EFI_GPIO_PROTOCOL_GUID': [0xb5d09084, 0x80ad, 0x4759, 0xb5, 0x1c, 0x27, 0x54, 0x8a, 0xfb, 0x8b, 0x8d],
    'EFI_GRAPHICS_OUTPUT_PROTOCOL_GUID': [0x9042a9de, 0x23dc, 0x4a38, 0x96, 0xfb, 0x7a, 0xde, 0xd0, 0x80, 0x51, 0x6a],
    'EFI_GUID': [0x00720665, 0x67EB, 0x4a99, 0xBA, 0xF7, 0xD3, 0xC3, 0x3A, 0x1C, 0x7C, 0xC9],
    'EFI_GUID': [0x0f729f33, 0x25c1, 0x41a7, 0x86, 0xb2, 0x23, 0xa7, 0x37, 0xa9, 0x18, 0x23],
    'EFI_GUID': [0x142204e2, 0xc7b1, 0x4af9, 0xa7, 0x29, 0x92, 0x37, 0x58, 0xd9, 0x6d, 0x3],
    'EFI_GUID': [0x17088572, 0x377F, 0x44ef, 0x8F, 0x4E, 0xB0, 0x9F, 0xFF, 0x46, 0xA0, 0x70],
    'EFI_GUID': [0x17088572, 0x377F, 0x44ef, 0x8F, 0x4E, 0xB0, 0x9F, 0xFF, 0x46, 0xA0, 0x70],
    'EFI_GUID': [0x1E753E16, 0xDCEF, 0x47d0, 0x9A, 0x38, 0x7A, 0xDE, 0xCD, 0xB9, 0x83, 0xED],
    'EFI_GUID': [0x1d3de7f0, 0x0807, 0x424f, 0xaa, 0x69, 0x11, 0xa5, 0x4e, 0x19, 0xa4, 0x6f],
    'EFI_GUID': [0x1e93e633, 0xd65a, 0x459e, 0xab, 0x84, 0x93, 0xd9, 0xec, 0x26, 0x6d, 0x18],
    'EFI_GUID': [0x220ac432, 0x1d43, 0x49e5, 0xa7, 0x4f, 0x4c, 0x9d, 0xa6, 0x7a, 0xd2, 0x3b],
    'EFI_GUID': [0x2362ea9c, 0x84e5, 0x4dff, 0x83, 0xbc, 0xb5, 0xac, 0xec, 0xb5, 0x7c, 0xbb],
    'EFI_GUID': [0x2FE800BE, 0x8F01, 0x4aa6, 0x94, 0x6B, 0xD7, 0x13, 0x88, 0xE1, 0x83, 0x3F],
    'EFI_GUID': [0x2ae9d80f, 0x3fb2, 0x4095, 0xb7, 0xb1, 0xe9, 0x31, 0x57, 0xb9, 0x46, 0xb6],
    'EFI_GUID': [0x379be4e, 0xd706, 0x437d, 0xb0, 0x37, 0xed, 0xb8, 0x2f, 0xb7, 0x72, 0xa4],
    'EFI_GUID': [0x3B6686BD, 0x0D76, 0x4030, 0xB7, 0x0E, 0xB5, 0x51, 0x9E, 0x2F, 0xC5, 0xA0],
    'EFI_GUID': [0x3ad9df29, 0x4501, 0x478d, 0xb1, 0xf8, 0x7f, 0x7f, 0xe7, 0x0e, 0x50, 0xf3],
    'EFI_GUID': [0x3b95aa31, 0x3793, 0x434b, 0x86, 0x67, 0xc8, 0x07, 0x08, 0x92, 0xe0, 0x5e],
    'EFI_GUID': [0x3e745226, 0x9818, 0x45b6, 0xa2, 0xac, 0xd7, 0xcd, 0x0e, 0x8b, 0xa2, 0xbc],
    'EFI_GUID': [0x41d94cd2, 0x35b6, 0x455a, 0x82, 0x58, 0xd4, 0xe5, 0x13, 0x34, 0xaa, 0xdd],
    'EFI_GUID': [0x42881c98, 0xa4f3, 0x44b0, 0xa3, 0x9d, 0xdf, 0xa1, 0x86, 0x67, 0xd8, 0xcd],
    'EFI_GUID': [0x4599d26f, 0x1a11, 0x49b8, 0xb9, 0x1f, 0x85, 0x87, 0x45, 0xcf, 0xf8, 0x24],
    'EFI_GUID': [0x45d68db9, 0x8b4e, 0x48c0, 0x99, 0xe9, 0xf2, 0x1f, 0x26, 0x2d, 0xb6, 0x53],
    'EFI_GUID': [0x4d330321, 0x025f, 0x4aac, 0x90, 0xd8, 0x5e, 0xd9, 0x00, 0x17, 0x3b, 0x63],
    'EFI_GUID': [0x4eaaaa1, 0x29a1, 0x11d7, 0x88, 0x38, 0x0, 0x50, 0x4, 0x73, 0xd4, 0xeb],
    'EFI_GUID': [0x4ed4bf27, 0x4092, 0x42e9, 0x80, 0x7d, 0x52, 0x7b, 0x1d, 0x00, 0xc9, 0xbd],
    'EFI_GUID': [0x51aa59de, 0xfdf2, 0x4ea3, 0xbc, 0x63, 0x87, 0x5f, 0xb7, 0x84, 0x2e, 0xe9],
    'EFI_GUID': [0x560bf58a, 0x1e0d, 0x4d7e, 0x95, 0x3f, 0x29, 0x80, 0xa2, 0x61, 0xe0, 0x31],
    'EFI_GUID': [0x564b33cd, 0xc92a, 0x4593, 0x90, 0xbf, 0x24, 0x73, 0xe4, 0x3c, 0x63, 0x22],
    'EFI_GUID': [0x5c99a21, 0xc70f, 0x4ad2, 0x8a, 0x5f, 0x35, 0xdf, 0x33, 0x43, 0xf5, 0x1e],
    'EFI_GUID': [0x6298fe18, 0xd5ef, 0x42b7, 0xbb, 0xc, 0x29, 0x53, 0x28, 0x3f, 0x57, 0x4],
    'EFI_GUID': [0x65530BC7, 0xA359, 0x410f, 0xB0, 0x10, 0x5A, 0xAD, 0xC7, 0xEC, 0x2B, 0x62],
    'EFI_GUID': [0x7671d9d0, 0x53db, 0x4173, 0xaa, 0x69, 0x23, 0x27, 0xf2, 0x1f, 0x0b, 0xc7],
    'EFI_GUID': [0x7d113aa9, 0x6280, 0x48c6, 0xba, 0xce, 0xdf, 0xe7, 0x66, 0x8e, 0x83, 0x7],
    'EFI_GUID': [0x83f01464, 0x99bd, 0x45e5, 0xb3, 0x83, 0xaf, 0x63, 0x05, 0xd8, 0xe9, 0xe6],
    'EFI_GUID': [0x878AC2CC, 0x5343, 0x46F2, 0xB5, 0x63, 0x51, 0xF8, 0x9D, 0xAF, 0x56, 0xBA],
    'EFI_GUID': [0x8983fd2d, 0x113c, 0x4e2b, 0x8f, 0x47, 0xa, 0xbf, 0xeb, 0x20, 0xa4, 0x1a],
    'EFI_GUID': [0x8a219718, 0x4ef5, 0x4761, 0x91, 0xc8, 0xc0, 0xf0, 0x4b, 0xda, 0x9e, 0x56],
    'EFI_GUID': [0x8b843e20, 0x8132, 0x4852, 0x90, 0xcc, 0x55, 0x1a, 0x4e, 0x4a, 0x7f, 0x1c],
    'EFI_GUID': [0x8df01a06, 0x9bd5, 0x4bf7, 0xb0, 0x21, 0xdb, 0x4f, 0xd9, 0xcc, 0xf4, 0x5b],
    'EFI_GUID': [0x8ff925f1, 0x8624, 0x4d38, 0x9e, 0xd2, 0xf8, 0xf5, 0xaa, 0x94, 0xf8, 0x4a],
    'EFI_GUID': [0x97e409e6, 0x4cc1, 0x11d9, 0x81, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
    'EFI_GUID': [0x98B8D59B, 0xE8BA, 0x48EE, 0x98, 0xDD, 0xC2, 0x95, 0x39, 0x2F, 0x1E, 0xDB],
    'EFI_GUID': [0x9cc55d7d, 0xfbff, 0x431c, 0xbc, 0x14, 0x33, 0x4e, 0xae, 0xa6, 0x5, 0x2b],
    'EFI_GUID': [0x9d7a05e9, 0xf740, 0x44c3, 0x85, 0x8b, 0x75, 0x58, 0x6a, 0x8f, 0x9c, 0x8e],
    'EFI_GUID': [0x9d9a39d8, 0xbd42, 0x4a73, 0xa4, 0xd5, 0x8e, 0xe9, 0x4b, 0xe1, 0x13, 0x80],
    'EFI_GUID': [0x9fe7de69, 0xaea, 0x470a, 0xb5, 0xa, 0x13, 0x98, 0x13, 0x64, 0x91, 0x89],
    'EFI_GUID': [0xCC0F8A3F, 0x3DEA, 0x4376, 0x96, 0x79, 0x54, 0x26, 0xba, 0x0a, 0x90, 0x7e],
    'EFI_GUID': [0xa6a72875, 0x2962, 0x4c18, 0x9f, 0x46, 0x8d, 0xa6, 0x44, 0xcc, 0xfe, 0x00],
    'EFI_GUID': [0xaa31bc6, 0x3379, 0x41e8, 0x82, 0x5a, 0x53, 0xf8, 0x2c, 0xc0, 0xf2, 0x54],
    'EFI_GUID': [0xabb74f50, 0xfd2d, 0x4072, 0xa3, 0x21, 0xca, 0xfc, 0x72, 0x97, 0x7e, 0xfa],
    'EFI_GUID': [0xaf7c79c, 0x65b5, 0x4319, 0xb0, 0xae, 0x44, 0xec, 0x48, 0x4e, 0x4a, 0xd7],
    'EFI_GUID': [0xbb2f3c9d, 0xc7a1, 0x4283, 0x8a, 0xe2, 0x4f, 0x43, 0x62, 0x99, 0x0e, 0x2e],
    'EFI_GUID': [0xbfd7dc1d, 0x24f1, 0x40d9, 0x82, 0xe7, 0x2e, 0x09, 0xbb, 0x6b, 0x4e, 0xbe],
    'EFI_GUID': [0xc1bdd34e, 0x9ec0, 0x48aa, 0x80, 0x6a, 0x6c, 0x2e, 0xba, 0x0d, 0xc4, 0x45],
    'EFI_GUID': [0xc280c73e, 0x15ca, 0x11da, 0xb0, 0xca, 0x00, 0x10, 0x83, 0xff, 0xca, 0x4d],
    'EFI_GUID': [0xc51711e7, 0xb4bf, 0x404a, 0xbf, 0xb8, 0x0a, 0x04, 0x8e, 0xf1, 0xff, 0xe4],
    'EFI_GUID': [0xc5184932, 0xdba5, 0x46db, 0xa5, 0xba, 0xcc, 0x0b, 0xda, 0x9c, 0x14, 0x35],
    'EFI_GUID': [0xcaa4381e, 0x750c, 0x4770, 0xb8, 0x70, 0x7a, 0x23, 0xb4, 0xe4, 0x21, 0x30],
    'EFI_GUID': [0xd6062b50, 0x15ca, 0x11da, 0x92, 0x19, 0x00, 0x10, 0x83, 0xff, 0xca, 0x4d],
    'EFI_GUID': [0xd84beff0, 0x159a, 0x4b60, 0x9a, 0xb9, 0xac, 0x5c, 0x47, 0x4b, 0xd3, 0xb1],
    'EFI_GUID': [0xdbc9fd21, 0xfad8, 0x45b0, 0x9e, 0x78, 0x27, 0x15, 0x88, 0x67, 0xcc, 0x93],
    'EFI_GUID': [0xe6f4f8f7, 0x4992, 0x47b2, 0x83, 0x2, 0x85, 0x8, 0x74, 0x5e, 0x4a, 0x23],
    'EFI_GUID': [0xedd35e31, 0x7b9, 0x11d2, 0x83, 0xa3, 0x00, 0xa0, 0xc9, 0x1f, 0xad, 0xcf],
    'EFI_GUID': [0xefa96432, 0xde33, 0x4dd2, 0xae, 0xe6, 0x32, 0x8c, 0x33, 0xdf, 0x77, 0x7a],
    'EFI_GUID': [0xf328e36c, 0x23b6, 0x4a95, 0x85, 0x4b, 0x32, 0xe1, 0x95, 0x34, 0xcd, 0x75],
    'EFI_GUID': [0xf36ff770, 0xa7e1, 0x42cf, 0x9e, 0xd2, 0x56, 0xf0, 0xf2, 0x71, 0xf4, 0x4c],
    'EFI_GUID': [0xf44c00ee, 0x1f2c, 0x4a00, 0xaa, 0x09, 0x1c, 0x9f, 0x3e, 0x08, 0x00, 0xa3],
    'EFI_GUID': [0xf4b427bb, 0xba21, 0x4f16, 0xbc, 0x4e, 0x43, 0xe4, 0x16, 0xab, 0x61, 0x9c],
    'EFI_GUID': [0xf8e21975, 0x0899, 0x4f58, 0xa4, 0xbe, 0x55, 0x25, 0xa9, 0xc6, 0xd7, 0x7a],
    'EFI_GUID': [0xfbf95065, 0x427f, 0x47b3, 0x80, 0x77, 0xd1, 0x3c, 0x60, 0x71, 0x9, 0x98],
    'EFI_GUID': [0xfd44820b, 0xf1ab, 0x41c0, 0xae, 0x4e, 0x0c, 0x55, 0x55, 0x6e, 0xb9, 0xbd],
    'EFI_HARDWARE_ERROR_VARIABLE_GUID': [0x414E6BDD, 0xE47B, 0x47cc, 0xB2, 0x44, 0xBB, 0x61, 0x02, 0x0C, 0xF5, 0x16],
    'EFI_HASH_ALGORITHM_SHA1_GUID': [0x2ae9d80f, 0x3fb2, 0x4095, 0xb7, 0xb1, 0xe9, 0x31, 0x57, 0xb9, 0x46, 0xb6],
    'EFI_HASH_ALGORITHM_SHA224_GUID': [0x8df01a06, 0x9bd5, 0x4bf7, 0xb0, 0x21, 0xdb, 0x4f, 0xd9, 0xcc, 0xf4, 0x5b],
    'EFI_HASH_ALGORITHM_SHA256_GUID': [0x51aa59de, 0xfdf2, 0x4ea3, 0xbc, 0x63, 0x87, 0x5f, 0xb7, 0x84, 0x2e, 0xe9],
    'EFI_HASH_ALGORITHM_SHA384_GUID': [0xefa96432, 0xde33, 0x4dd2, 0xae, 0xe6, 0x32, 0x8c, 0x33, 0xdf, 0x77, 0x7a],
    'EFI_HASH_ALGORITHM_SHA512_GUID': [0xcaa4381e, 0x750c, 0x4770, 0xb8, 0x70, 0x7a, 0x23, 0xb4, 0xe4, 0x21, 0x30],
    'EFI_HASH_ALGORTIHM_MD5_GUID': [0xaf7c79c, 0x65b5, 0x4319, 0xb0, 0xae, 0x44, 0xec, 0x48, 0x4e, 0x4a, 0xd7],
    'EFI_HASH_PROTOCOL_GUID': [0xc5184932, 0xdba5, 0x46db, 0xa5, 0xba, 0xcc, 0x0b, 0xda, 0x9c, 0x14, 0x35],
    'EFI_HASH_SERVICE_BINDING_PROTOCOL_GUID': [0x42881c98, 0xa4f3, 0x44b0, 0xa3, 0x9d, 0xdf, 0xa1, 0x86, 0x67, 0xd8, 0xcd],
    'EFI_HII_CONFIG_ACCESS_PROTOCOL_GUID': [0x330d4706, 0xf2a0, 0x4e4f, 0xa3, 0x69, 0xb6, 0x6f, 0xa8, 0xd5, 0x43, 0x85],
    'EFI_HII_CONFIG_ROUTING_PROTOCOL_GUID': [0x587e72d7, 0xcc50, 0x4f79, 0x82, 0x09, 0xca, 0x29, 0x1f, 0xc1, 0xa1, 0x0f],
    'EFI_HII_DATABASE_PROTOCOL_GUID': [0xef9fc172, 0xa1b2, 0x4693, 0xb3, 0x27, 0x6d, 0x32, 0xfc, 0x41, 0x60, 0x42],
    'EFI_HII_DRIVER_HEALTH_FORMSET_GUID': [0xf22fc20c, 0x8cf4, 0x45eb, 0x8e, 0x6, 0xad, 0x4e, 0x50, 0xb9, 0x5d, 0xd3],
    'EFI_HII_EXT_PROTOCOL_GUID': [0x2a57ae75, 0x8b7a, 0x4c64, 0x86, 0x56, 0xdb, 0x51, 0xdd, 0xc3, 0x6f, 0x7b],
    'EFI_HII_FONT_PROTOCOL_GUID': [0xe9ca4775, 0x8657, 0x47fc, 0x97, 0xe7, 0x7e, 0xd6, 0x5a, 0x8, 0x43, 0x24],
    'EFI_HII_FRONT_PAGE_CLASS_GUID': [0x94d411b7, 0x7669, 0x45c3, 0xba, 0x3b, 0xf3, 0xa5, 0x8a, 0x71, 0x56, 0x81],
    'EFI_HII_IMAGE_PROTOCOL_GUID': [0x31a6406a, 0x6bdf, 0x4e46, 0xb2, 0xa2, 0xeb, 0xaa, 0x89, 0xc4, 0x9, 0x20],
    'EFI_HII_NEW_PROTOCOL_GUID': [0xea816d2c, 0xcee5, 0x4f02, 0x99, 0xb5, 0xd3, 0x90, 0x5c, 0xbb, 0xd0, 0x77],
    'EFI_HII_OLD_PROTOCOL_GUID': [0xcd361957, 0xafbe, 0x425e, 0xa3, 0x58, 0x5f, 0x58, 0x89, 0xcf, 0xfe, 0x7b],
    'EFI_HII_PACKAGE_LIST_PROTOCOL_GUID': [0x6a1ee763, 0xd47a, 0x43b4, 0xaa, 0xbe, 0xef, 0x1d, 0xe2, 0xab, 0x56, 0xfc],
    'EFI_HII_PLATFORM_SETUP_FORMSET_GUID': [0x93039971, 0x8545, 0x4b04, 0xb4, 0x5e, 0x32, 0xeb, 0x83, 0x26, 0x4, 0xe],
    'EFI_HII_PLATFORM_SETUP_FORMSET_GUID': [0x93039971, 0x8545, 0x4b04, 0xb4, 0x5e, 0x32, 0xeb, 0x83, 0x26, 0x4, 0xe],
    'EFI_HII_PROTOCOL_GUID': [0xd7ad636e, 0xb997, 0x459b, 0xbf, 0x3f, 0x88, 0x46, 0x89, 0x79, 0x80, 0xe1],
    'EFI_HII_SET_KEYBOARD_LAYOUT_EVENT_GUID': [0x14982a4f, 0xb0ed, 0x45b8, 0xa8, 0x11, 0x5a, 0x7a, 0x9b, 0xc2, 0x32, 0xdf],
    'EFI_HII_STRING_PROTOCOL_GUID': [0xfd96974, 0x23aa, 0x4cdc, 0xb9, 0xcb, 0x98, 0xd1, 0x77, 0x50, 0x32, 0x2a],
    'EFI_HII_USER_CREDENTIAL_FORMSET_GUID': [0x337f4407, 0x5aee, 0x4b83, 0xb2, 0xa7, 0x4e, 0xad, 0xca, 0x30, 0x88, 0xcd],
    'EFI_HOB_LIST_GUID': [0x7739f24c, 0x93d7, 0x11d4, 0x9a, 0x3a, 0x0, 0x90, 0x27, 0x3f, 0xc1, 0x4d],
    'EFI_HOB_MEMORY_ALLOC_BSP_STORE_GUID': [0x564b33cd, 0xc92a, 0x4593, 0x90, 0xbf, 0x24, 0x73, 0xe4, 0x3c, 0x63, 0x22],
    'EFI_HOB_MEMORY_ALLOC_BSP_STORE_GUID': [0x564b33cd, 0xc92a, 0x4593, 0x90, 0xbf, 0x24, 0x73, 0xe4, 0x3c, 0x63, 0x22],
    'EFI_HOB_MEMORY_ALLOC_STACK_GUID': [0x4ed4bf27, 0x4092, 0x42e9, 0x80, 0x7d, 0x52, 0x7b, 0x1d, 0x0, 0xc9, 0xbd],
    'EFI_HOB_MEMORY_ALLOC_STACK_GUID': [0x4ed4bf27, 0x4092, 0x42e9, 0x80, 0x7d, 0x52, 0x7b, 0x1d, 0x0, 0xc9, 0xbd],
    'EFI_HOT_KEYS_PROTOCOL_GUID': [0xf1e48287, 0x3fe1, 0x4535, 0x89, 0xab, 0x48, 0xd6, 0xc3, 0xda, 0x27, 0x59],
    'EFI_HT_BIST_HOB_GUID': [0xbe644001, 0xe7d4, 0x48b1, 0xb0, 0x96, 0x8b, 0xa0, 0x47, 0xbc, 0x7a, 0xe7],
    'EFI_IDER_CONTROLLER_DRIVER_PROTOCOL_GUID': [0x956a2ed0, 0xa6cf, 0x409a, 0xb8, 0xf5, 0x35, 0xf1, 0x4c, 0x3e, 0x3c, 0x2],
    'EFI_IDE_CONTROLLER_INIT_PROTOCOL_GUID': [0xa1e37052, 0x80d9, 0x4e65, 0xa3, 0x17, 0x3e, 0x9a, 0x55, 0xc4, 0x3e, 0xc9],
    'EFI_IFR_TIANO_GUID': [0xf0b1735, 0x87a0, 0x4193, 0xb2, 0x66, 0x53, 0x8c, 0x38, 0xaf, 0x48, 0xce],
    'EFI_IMAGE_SECURITY_DATABASE_GUID': [0xd719b2cb, 0x3d3a, 0x4596, 0xa3, 0xbc, 0xda, 0xd0, 0xe, 0x67, 0x65, 0x6f],
    'EFI_INCOMPATIBLE_PCI_DEVICE_SUPPORT_PROTOCOL_GUID': [0xeb23f55a, 0x7863, 0x4ac2, 0x8d, 0x3d, 0x95, 0x65, 0x35, 0xde, 0x03, 0x75],
    'EFI_INTEL_MFG_FORMAT_FRU_GUID': [0x79e8c9c7, 0x1152, 0x4f00, 0xb8, 0x31, 0x14, 0xf1, 0xc4, 0x4, 0x1a, 0xe0],
    'EFI_IOBASE_HOB_GUID': [0xd4a28a3e, 0xdcf2, 0x43cf, 0xa2, 0xb7, 0xf3, 0x57, 0x2a, 0x7c, 0xab, 0x9],
    'EFI_IP4_CONFIG_PROTOCOL_GUID': [0x3b95aa31, 0x3793, 0x434b, 0x86, 0x67, 0xc8, 0x07, 0x08, 0x92, 0xe0, 0x5e],
    'EFI_IP4_PROTOCOL_GUID': [0x41d94cd2, 0x35b6, 0x455a, 0x82, 0x58, 0xd4, 0xe5, 0x13, 0x34, 0xaa, 0xdd],
    'EFI_IP4_SERVICE_BINDING_PROTOCOL_GUID': [0xc51711e7, 0xb4bf, 0x404a, 0xbf, 0xb8, 0x0a, 0x04, 0x8e, 0xf1, 0xff, 0xe4],
    'EFI_IP_PROTOCOL_GUID': [0x89DEEF37, 0x31D8, 0x469C, 0x95, 0xB6, 0x01, 0x69, 0xBC, 0x86, 0x6C, 0xFB],
    'EFI_ISA_ACPI_PROTOCOL_GUID': [0x64a892dc, 0x5561, 0x4536, 0x92, 0xc7, 0x79, 0x9b, 0xfc, 0x18, 0x33, 0x55],
    'EFI_ISA_IO_PROTOCOL_GUID': [0x7ee2bd44, 0x3da0, 0x11d4, 0x9a, 0x38, 0x0, 0x90, 0x27, 0x3f, 0xc1, 0x4d],
    'EFI_ISCSI_INITIATOR_NAME_PROTOCOL_GUID': [0x59324945, 0xec44, 0x4c0d, 0xb1, 0xcd, 0x9d, 0xb1, 0x39, 0xdf, 0x7, 0xc],
    'EFI_LEGACY_8259_PROTOCOL_GUID': [0x38321dba, 0x4fe0, 0x4e17, 0x8a, 0xec, 0x41, 0x30, 0x55, 0xea, 0xed, 0xc1],
    'EFI_LEGACY_BIOS_EXT_PROTOCOL_GUID': [0x8e008510, 0x9bb1, 0x457d, 0x9f, 0x70, 0x89, 0x7a, 0xba, 0x86, 0x5d, 0xb9],
    'EFI_LEGACY_BIOS_GUID': [0x2e3044ac, 0x879f, 0x490f, 0x97, 0x60, 0xbb, 0xdf, 0xaf, 0x69, 0x5f, 0x50],
    'EFI_LEGACY_BIOS_PLATFORM_PROTOCOL_GUID': [0x783658a3, 0x4172, 0x4421, 0xa2, 0x99, 0xe0, 0x9, 0x7, 0x9c, 0xc, 0xb4],
    'EFI_LEGACY_BIOS_PROTOCOL_GUID': [0xdb9a1e3d, 0x45cb, 0x4abb, 0x85, 0x3b, 0xe5, 0x38, 0x7f, 0xdb, 0x2e, 0x2d],
    'EFI_LEGACY_BIOS_THUNK_PROTOCOL_GUID': [0x4c51a7ba, 0x7195, 0x442d, 0x87, 0x92, 0xbe, 0xea, 0x6e, 0x2f, 0xf6, 0xec],
    'EFI_LEGACY_INTERRUPT_PROTOCOL_GUID': [0x31ce593d, 0x108a, 0x485d, 0xad, 0xb2, 0x78, 0xf2, 0x1f, 0x29, 0x66, 0xbe],
    'EFI_LEGACY_SREDIR_PROTOCOL_GUID': [0xA062CF1F, 0x8473, 0x4aa3, 0x87, 0x93, 0x60, 0x0B, 0xC4, 0xFF, 0xA9, 0xA9],
    'EFI_LIGHT_ISA_IO_PROTOCOL_GUID': [0x7cc7ed80, 0x9a68, 0x4781, 0x80, 0xe4, 0xda, 0x16, 0x99, 0x10, 0x5a, 0xfe],
    'EFI_LOADED_IMAGE_DEVICE_PATH_PROTOCOL_GUID': [0xbc62157e, 0x3e33, 0x4fec, 0x99, 0x20, 0x2d, 0x3b, 0x36, 0xd7, 0x50, 0xdf],
    'EFI_LOADED_IMAGE_PROTOCOL_GUID': [0x5B1B31A1, 0x9562, 0x11d2, 0x8E, 0x3F, 0x00, 0xA0, 0xC9, 0x69, 0x72, 0x3B],
    'EFI_LOAD_FILE2_PROTOCOL_GUID': [0x4006c0c1, 0xfcb3, 0x403e, 0x99, 0x6d, 0x4a, 0x6c, 0x87, 0x24, 0xe0, 0x6d],
    'EFI_MANAGED_NETWORK_PROTOCOL_GUID': [0x7ab33a91, 0xace5, 0x4326, 0xb5, 0x72, 0xe7, 0xee, 0x33, 0xd3, 0x9f, 0x16],
    'EFI_MANAGED_NETWORK_SERVICE_BINDING_PROTOCOL_GUID': [0xf36ff770, 0xa7e1, 0x42cf, 0x9e, 0xd2, 0x56, 0xf0, 0xf2, 0x71, 0xf4, 0x4c],
    'EFI_MEMORY_CONFIG_DATA_GUID': [0x80dbd530, 0xb74c, 0x4f11, 0x8c, 0x03, 0x41, 0x86, 0x65, 0x53, 0x28, 0x31],
    'EFI_MEMORY_PRODUCER_GUID': [0x1d7add6e, 0xb2da, 0x4b0b, 0xb2, 0x9f, 0x49, 0xcb, 0x42, 0xf4, 0x63, 0x56],
    'EFI_MEMORY_SUBCLASS_DRIVER_GUID': [0x1767CEED, 0xDB82, 0x47cd, 0xBF, 0x2B, 0x68, 0x45, 0x8A, 0x8C, 0xCF, 0xFF],
    'EFI_MEMORY_SUBCLASS_GUID': [0x4E8F4EBB, 0x64B9, 0x4e05, 0x9B, 0x18, 0x4C, 0xFE, 0x49, 0x23, 0x50, 0x97],
    'EFI_MEMORY_TYPE_FRU_GUID': [0xd50234f4, 0x6f4b, 0x43e8, 0xa0, 0x13, 0x3c, 0x1e, 0x33, 0xd9, 0xb9, 0xb1],
    'EFI_METRONOME_ARCH_PROTOCOL_GUID': [0x26baccb2, 0x6f42, 0x11d4, 0xbc, 0xe7, 0x0, 0x80, 0xc7, 0x3c, 0x88, 0x81],
    'EFI_ME_BIOS_EXTENSION_SETUP_GUID': [0x1bad711c, 0xd451, 0x4241, 0xb1, 0xf3, 0x85, 0x37, 0x81, 0x2e, 0xc, 0x70],
    'EFI_ME_FW_SKU_VARIABLE_GUID': [0xe1a21d94, 0x4a20, 0x4e0e, 0xae, 0x9, 0xa9, 0xa2, 0x1f, 0x24, 0xbb, 0x9e],
    'EFI_ME_RC_INFO_PROTOCOL_GUID': [0x11fbfdfb, 0x10d2, 0x43e6, 0xb5, 0xb1, 0xb4, 0x38, 0x6e, 0xdc, 0xcb, 0x9a],
    'EFI_MINI_SHELL_FILE_GUID': [0x86ad232b, 0xd33a, 0x465c, 0xbf, 0x5f, 0x41, 0x37, 0xb, 0xa9, 0x2f, 0xe2],
    'EFI_MISC_PRODUCER_GUID': [0x62512c92, 0x63c4, 0x4d80, 0x82, 0xb1, 0xc1, 0xa4, 0xdc, 0x44, 0x80, 0xe5],
    'EFI_MISC_SUBCLASS_DRIVER_GUID': [0xF50E702C, 0x8653, 0x4CDE, 0xBB, 0xCE, 0x43, 0xB4, 0xD5, 0x5B, 0x34, 0xB8],
    'EFI_MISC_SUBCLASS_GUID': [0x772484B2, 0x7482, 0x4b91, 0x9F, 0x9A, 0xAD, 0x43, 0xF8, 0x1C, 0x58, 0x81],
    'EFI_MONTONIC_COUNTER_ARCH_PROTOCOL_GUID': [0x1da97072, 0xbddc, 0x4b30, 0x99, 0xf1, 0x72, 0xa0, 0xb5, 0x6f, 0xff, 0x2a],
    'EFI_MPS_TABLE_GUID': [0xeb9d2d2f, 0x2d88, 0x11d3, 0x9a, 0x16, 0x0, 0x90, 0x27, 0x3f, 0xc1, 0x4d],
    'EFI_MP_SERVICES_PROTOCOL_GUID': [0x3fdda605, 0xa76e, 0x4f46, 0xad, 0x29, 0x12, 0xf4, 0x53, 0x1b, 0x3d, 0x08],
    'EFI_MP_SERVICES_PROTOCOL_GUID': [0xf33261e7, 0x23cb, 0x11d5, 0xbd, 0x5c, 0x0, 0x80, 0xc7, 0x3c, 0x88, 0x81],
    'EFI_MTFTP4_PROTOCOL_GUID': [0x78247c57, 0x63db, 0x4708, 0x99, 0xc2, 0xa8, 0xb4, 0xa9, 0xa6, 0x1f, 0x6b],
    'EFI_MTFTP4_SERVICE_BINDING_PROTOCOL_GUID': [0x2FE800BE, 0x8F01, 0x4aa6, 0x94, 0x6B, 0xD7, 0x13, 0x88, 0xE1, 0x83, 0x3F],
    'EFI_NB_ERROR_LOG_DISPATCH_PROTOCOL_GUID': [0xff2d54d4, 0x5c55, 0x4c06, 0x85, 0x49, 0xc3, 0x62, 0x7c, 0xb8, 0xb9, 0x95],
    'EFI_NB_MRC_INFO_GUID': [0xd7bd52b0, 0xb2dc, 0x4f08, 0xb4, 0x67, 0xde, 0x50, 0xd7, 0x28, 0xf6, 0xbd],
    'EFI_NETWORK_INTERFACE_IDENTIFIER_PROTOCOL_GUID': [0x1ACED566, 0x76ED, 0x4218, 0xBC, 0x81, 0x76, 0x7F, 0x1F, 0x97, 0x7A, 0x89],
    'EFI_NETWORK_INTERFACE_IDENTIFIER_PROTOCOL_GUID': [0xE18541CD, 0xF755, 0x4f73, 0x92, 0x8D, 0x64, 0x3C, 0x8A, 0x79, 0xB2, 0x29],
    'EFI_NIC_IP4_CONFIG_PROTOCOL_GUID': [0xdca3d4d, 0x12da, 0x4728, 0xbf, 0x7e, 0x86, 0xce, 0xb9, 0x28, 0xd0, 0x67],
    'EFI_NIC_IP4_CONFIG_VARIABLE_GUID': [0xd8944553, 0xc4dd, 0x41f4, 0x9b, 0x30, 0xe1, 0x39, 0x7c, 0xfb, 0x26, 0x7b],
    'EFI_NONSMMEMUL6064TRAP_PROTOCOL_GUID': [0x68b81e51, 0x2583, 0x4582, 0x95, 0xdb, 0xc5, 0x72, 0x32, 0x36, 0xc4, 0xf1],
    'EFI_OEM_BADGING_PROTOCOL_GUID': [0x170e13c0, 0xbf1b, 0x4218, 0x87, 0x1d, 0x2a, 0xbd, 0xc6, 0xf8, 0x87, 0xbc],
    'EFI_PART_TYPE_EFI_SYSTEM_PART_GUID': [0xc12a7328, 0xf81f, 0x11d2, 0xba, 0x4b, 0x00, 0xa0, 0xc9, 0x3e, 0xc9, 0x3b],
    'EFI_PART_TYPE_LEGACY_MBR_GUID': [0x024dee41, 0x33e7, 0x11d3, 0x9d, 0x69, 0x00, 0x08, 0xc7, 0x81, 0xf3, 0x9f],
    'EFI_PATH_FILE_NAME_GUID': [0x7644C181, 0xFA6E, 0x46DA, 0x80, 0xCB, 0x04, 0xB9, 0x90, 0x40, 0x62, 0xE8],
    'EFI_PCCARD_CS_PROTOCOL_GUID': [0xca54f443, 0x1ef2, 0x4dab, 0x9e, 0x7e, 0x6d, 0xb7, 0xb7, 0x20, 0xb5, 0x87],
    'EFI_PCCARD_SS_PROTOCOL_GUID': [0xc38e6d34, 0x5a7f, 0x4bf9, 0xbe, 0x57, 0x94, 0xdd, 0x30, 0x38, 0x02, 0x76],
    'EFI_PCH_INFO_PROTOCOL_GUID': [0x984eb4e9, 0x5a95, 0x41de, 0xaa, 0xd0, 0x53, 0x66, 0x8c, 0xa5, 0x13, 0xc0],
    'EFI_PCH_S3_IMAGE_GUID': [0x271dd6f2, 0x54cb, 0x45e6, 0x85, 0x85, 0x8c, 0x92, 0x3c, 0x1a, 0xc7, 0x6],
    'EFI_PCH_S3_SUPPORT_PROTOCOL_GUID': [0xe287d20b, 0xd897, 0x4e1e, 0xa5, 0xd9, 0x97, 0x77, 0x63, 0x93, 0x6a, 0x4],
    'EFI_PCI_EXPRESS_BASE_ADDRESS_GUID': [0x3677d529, 0x326f, 0x4603, 0xa9, 0x26, 0xea, 0xac, 0xe0, 0x1d, 0xcb, 0xb0],
    'EFI_PCI_HOTPLUG_DEVICE_GUID': [0x0b280816, 0x52e7, 0x4e51, 0xaa, 0x57, 0x11, 0xbd, 0x41, 0xcb, 0xef, 0xc3],
    'EFI_PCI_HOT_PLUG_INIT_PROTOCOL_GUID': [0xaa0e8bc1, 0xdabc, 0x46b0, 0xa8, 0x44, 0x37, 0xb8, 0x16, 0x9b, 0x2b, 0xea],
    'EFI_PCI_IO_PROTOCOL_GUID': [0x4cf5b200, 0x68b8, 0x4ca5, 0x9e, 0xec, 0xb2, 0x3e, 0x3f, 0x50, 0x2, 0x9a],
    'EFI_PCI_OPTION_ROM_TABLE_GUID': [0x7462660f, 0x1cbd, 0x48da, 0xad, 0x11, 0x91, 0x71, 0x79, 0x13, 0x83, 0x1c],
    'EFI_PCI_PLATFORM_PROTOCOL_GUID': [0x7d75280, 0x27d4, 0x4d69, 0x90, 0xd0, 0x56, 0x43, 0xe2, 0x38, 0xb3, 0x41],
    'EFI_PCI_ROOT_BRIDGE_IO_PROTOCOL_GUID': [0x2f707ebb, 0x4a1a, 0x11d4, 0x9a, 0x38, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d],
    'EFI_PCMCIA_REQUEST_PROTOCOL_GUID': [0xf238f47c, 0x1de9, 0x4e8b, 0x81, 0xb9, 0xcc, 0x92, 0x4e, 0x6b, 0x5b, 0xe5],
    'EFI_PC_ANSI_GUID': [0xe0c14753, 0xf9be, 0x11d2, 0x9a, 0x0c, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d],
    'EFI_PEI_AMI_KEYCODE_PPI_GUID': [0x20b0f1c2, 0xb0d8, 0x4c5d, 0xaa, 0xd9, 0xf4, 0x45, 0x80, 0xdf, 0xdf, 0x8b],
    'EFI_PEI_APRIORI_FILE_NAME_GUID': [0x1b45cc0a, 0x156a, 0x428a, 0xaf, 0x62, 0x49, 0x86, 0x4d, 0xa0, 0xe6, 0xe6],
    'EFI_PEI_CAPSULE_PPI_GUID': [0x66785b1, 0xedb8, 0x46dc, 0x84, 0x2f, 0x57, 0x44, 0x4, 0xb8, 0x69, 0x2f],
    'EFI_PEI_CMOS_ACCESS_GUID': [0xccbf2786, 0xcd6c, 0x4308, 0xbd, 0xfa, 0x62, 0x58, 0x70, 0xce, 0xbf, 0x81],
    'EFI_PEI_CONSPLIT_AMI_KEYCODE_PPI_GUID': [0x73ddb5e1, 0x5fb4, 0x4751, 0xaf, 0x1e, 0x83, 0xcf, 0x75, 0xbe, 0xcb, 0xb6],
    'EFI_PEI_CORE_PRIVATE_GUID': [0xd641a0f5, 0xcb7c, 0x4846, 0xa3, 0x80, 0x1d, 0x01, 0xb4, 0xd9, 0xe3, 0xb9],
    'EFI_PEI_CPU_IO_PPI_INSTALLED_GUID': [0xe6af1f7b, 0xfc3f, 0x46da, 0xa8, 0x28, 0xa3, 0xb4, 0x57, 0xa4, 0x42, 0x82],
    'EFI_PEI_DECOMPRESS_PPI_GUID': [0x1a36e4e7, 0xfab6, 0x476a, 0x8e, 0x75, 0x69, 0x5a, 0x5, 0x76, 0xfd, 0xd7],
    'EFI_PEI_DEVICE_RECOVERY_MODULE_PPI_GUID': [0x0DE2CE25, 0x446A, 0x45a7, 0xBF, 0xC9, 0x37, 0xDA, 0x26, 0x34, 0x4B, 0x37],
    'EFI_PEI_END_OF_PEI_PHASE_PPI_GUID': [0x605EA650, 0xC65C, 0x42e1, 0xBA, 0x80, 0x91, 0xA5, 0x2A, 0xB6, 0x18, 0xC6],
    'EFI_PEI_FIRMWARE_VOLUME_INFO_PPI_GUID': [0x49edb1c1, 0xbf21, 0x4761, 0xbb, 0x12, 0xeb, 0x0, 0x31, 0xaa, 0xbb, 0x39],
    'EFI_PEI_FLUSH_INSTRUCTION_CACHE_GUID': [0xd8117cfc, 0x94a6, 0x11d4, 0x9a, 0x3a, 0x0, 0x90, 0x27, 0x3f, 0xc1, 0x4d],
    'EFI_PEI_LOADED_IMAGE_PPI_GUID': [0xa62a3fff, 0x97f0, 0x4332, 0x8c, 0xfd, 0x1e, 0x34, 0x3d, 0x36, 0x31, 0xf2],
    'EFI_PEI_LOADED_IMAGE_PPI_GUID': [0xc1fcd448, 0x6300, 0x4458, 0xb8, 0x64, 0x28, 0xdf, 0x01, 0x53, 0x64, 0xbc],
    'EFI_PEI_LOAD_FILE_GUID': [0xb9e0abfe, 0x5979, 0x4914, 0x97, 0x7f, 0x6d, 0xee, 0x78, 0xc2, 0x78, 0xa6],
    'EFI_PEI_LOAD_FILE_PPI_GUID': [0xb9e0abfe, 0x5979, 0x4914, 0x97, 0x7f, 0x6d, 0xee, 0x78, 0xc2, 0x78, 0xa6],
    'EFI_PEI_PCI_CFG2_PPI_GUID': [0x57a449a, 0x1fdc, 0x4c06, 0xbf, 0xc9, 0xf5, 0x3f, 0x6a, 0x99, 0xbb, 0x92],
    'EFI_PEI_PCI_CFG2_PPI_GUID': [0xe1f2eba0, 0xf7b9, 0x4a26, 0x86, 0x20, 0x13, 0x12, 0x21, 0x64, 0x2a, 0x90],
    'EFI_PEI_PCI_CFG_PPI_INSTALLED_GUID': [0xe1f2eba0, 0xf7b9, 0x4a26, 0x86, 0x20, 0x13, 0x12, 0x21, 0x64, 0x2a, 0x90],
    'EFI_PEI_PERFORMANCE_HOB_GUID': [0x10f432de, 0xdeec, 0x4631, 0x80, 0xcd, 0x47, 0xf6, 0x5d, 0x8f, 0x80, 0xbb],
    'EFI_PEI_PE_COFF_LOADER_GUID': [0xd8117cff, 0x94a6, 0x11d4, 0x9a, 0x3a, 0x0, 0x90, 0x27, 0x3f, 0xc1, 0x4d],
    'EFI_PEI_PLATFORMPEI_EXECUTED_PPI_GUID': [0x8C72C36E, 0xDACC, 0x4E81, 0x8D, 0x60, 0xFF, 0xA6, 0x1D, 0x88, 0xFF, 0x54],
    'EFI_PEI_READ_ONLY_VARIABLE2_PPI_GUID': [0x2ab86ef5, 0xecb5, 0x4134, 0xb5, 0x56, 0x38, 0x54, 0xca, 0x1f, 0xe1, 0xb4],
    'EFI_PEI_READ_ONLY_VARIABLE_PPI_GUID': [0x3cdc90c6, 0x13fb, 0x4a75, 0x9e, 0x79, 0x59, 0xe9, 0xdd, 0x78, 0xb9, 0xfa],
    'EFI_PEI_RECOVERY_MODULE_PPI_GUID': [0xFB6D9542, 0x612D, 0x4f45, 0x87, 0x2F, 0x5C, 0xFF, 0x52, 0xE9, 0x3D, 0xCF],
    'EFI_PEI_REPORT_PROGRESS_CODE_PPI_GUID': [0x229832d3, 0x7a30, 0x4b36, 0xb8, 0x27, 0xf4, 0xc, 0xb7, 0xd4, 0x54, 0x36],
    'EFI_PEI_RESET_PPI_GUID': [0xef398d58, 0x9dfd, 0x4103, 0xbf, 0x94, 0x78, 0xc6, 0xf4, 0xfe, 0x71, 0x2f],
    'EFI_PEI_RSC_HANDLER_PPI_GUID': [0x65d394, 0x9951, 0x4144, 0x82, 0xa3, 0xa, 0xfc, 0x85, 0x79, 0xc2, 0x51],
    'EFI_PEI_S3_RESUME2_PPI_GUID': [0x6D582DBC, 0xDB85, 0x4514, 0x8F, 0xCC, 0x5A, 0xDF, 0x62, 0x27, 0xB1, 0x47],
    'EFI_PEI_SECTION_EXTRACTION_PPI_GUID': [0x4F89E208, 0xE144, 0x4804, 0x9E, 0xC8, 0x0F, 0x89, 0x4F, 0x7E, 0x36, 0xD7],
    'EFI_PEI_SECURITY2_PPI_GUID': [0xdcd0be23, 0x9586, 0x40f4, 0xb6, 0x43, 0x6, 0x52, 0x2c, 0xed, 0x4e, 0xde],
    'EFI_PEI_STALL_PPI_GUID': [0x1f4c6f90, 0xb06b, 0x48d8, 0xa2, 0x01, 0xba, 0xe5, 0xf1, 0xcd, 0x7d, 0x56],
    'EFI_PEI_TEMPORARY_RAM_SUPPORT_PPI_GUID': [0xdbe23aa9, 0xa345, 0x4b97, 0x85, 0xb6, 0xb2, 0x26, 0xf1, 0x61, 0x73, 0x89],
    'EFI_PEI_TRANSFER_CONTROL_GUID': [0xd8117d02, 0x94a6, 0x11d4, 0x9a, 0x3a, 0x0, 0x90, 0x27, 0x3f, 0xc1, 0x4d],
    'EFI_PERFORMANCE_PROTOCOL_GUID': [0xFFECFFFF, 0x923C, 0x14d2, 0x9E, 0x3F, 0x22, 0xA0, 0xC9, 0x69, 0x56, 0x3B],
    'EFI_PI_MP_SERVICES_PROTOCOL_GUID': [0x3fdda605, 0xa76e, 0x4f46, 0xad, 0x29, 0x12, 0xf4, 0x53, 0x1b, 0x3d, 0x08],
    'EFI_PLATFORM_DRIVER_OVERRIDE_PROTOCOL_GUID': [0x6b30c738, 0xa391, 0x11d4, 0x9a, 0x3b, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d],
    'EFI_PLATFORM_GOP_POLICY_PROTOCOL_GUID': [0xec2e931b, 0x3281, 0x48a5, 0x81, 0x7, 0xdf, 0x8a, 0x8b, 0xed, 0x3c, 0x5d],
    'EFI_PLATFORM_INFO_PROTOCOL_GUID': [0xd9035175, 0x8ce2, 0x47de, 0xa8, 0xb8, 0xcc, 0x98, 0xe5, 0xe2, 0xa8, 0x85],
    'EFI_PLATFORM_MEMTEST_PROTOCOL_GUID': [0x859ba18, 0x7dd7, 0x4ed7, 0xa8, 0x8e, 0x10, 0x9c, 0x63, 0x91, 0x7b, 0xdd],
    'EFI_PLATFORM_TO_DRIVER_CONFIGURATION_CLP_GUID': [0x345ecc0e, 0x0cb6, 0x4b75, 0xbb, 0x57, 0x1b, 0x12, 0x9c, 0x47, 0x33, 0x3e],
    'EFI_PLATFORM_TO_DRIVER_CONFIGURATION_PROTOCOL_GUID': [0x642cd590, 0x8059, 0x4c0a, 0xa9, 0x58, 0xc5, 0xec, 0x07, 0xd2, 0x3c, 0x4b],
    'EFI_PLATFORM_TO_DRIVER_CONFIGURATION_PROTOCOL_GUID': [0x642cd590, 0x8059, 0x4c0a, 0xa9, 0x58, 0xc5, 0xec, 0x7, 0xd2, 0x3c, 0x4b],
    'EFI_POWER_ON_HOB_GUID': [0x468a601, 0xc535, 0x46fd, 0xa9, 0x5d, 0xbb, 0xab, 0x99, 0x1b, 0x17, 0x8c],
    'EFI_PPM_GLOBAL_NVS_AREA_PROTOCOL_GUID': [0x6c50cdcb, 0x7f46, 0x4dcc, 0x8d, 0xdd, 0xd9, 0xf0, 0xa3, 0xc6, 0x11, 0x28],
    'EFI_PPM_INFO_PROTOCOL_GUID': [0xd71db106, 0xe32d, 0x4225, 0xbf, 0xf4, 0xde, 0x6d, 0x77, 0x87, 0x17, 0x61],
    'EFI_PRIMARY_CONSOLE_IN_DEVICE_GUID': [0xe451dcbe, 0x96a1, 0x4729, 0xa5, 0xcf, 0x6b, 0x9c, 0x2c, 0xff, 0x47, 0xfd],
    'EFI_PRIMARY_CONSOLE_OUT_DEVICE_GUID': [0x62bdf38a, 0xe3d5, 0x492c, 0x95, 0xc, 0x23, 0xa7, 0xf6, 0x6e, 0x67, 0x2e],
    'EFI_PRIMARY_STANDARD_ERROR_DEVICE_GUID': [0x5a68191b, 0x9b97, 0x4752, 0x99, 0x46, 0xe3, 0x6a, 0x5d, 0xa9, 0x42, 0xb1],
    'EFI_PRINT_PROTOCOL_GUID': [0xdf2d868e, 0x32fc, 0x4cf0, 0x8e, 0x6b, 0xff, 0xd9, 0x5d, 0x13, 0x43, 0xd0],
    'EFI_PROCESSOR_PRODUCER_GUID': [0x1bf06aea, 0x5bec, 0x4a8d, 0x95, 0x76, 0x74, 0x9b, 0x09, 0x56, 0x2d, 0x30],
    'EFI_PROCESSOR_SUBCLASS_GUID': [0x26fdeb7e, 0xb8af, 0x4ccf, 0xaa, 0x97, 0x02, 0x63, 0x3c, 0xe4, 0x8c, 0xa7],
    'EFI_PS2_POLICY_PROTOCOL_GUID': [0x4df19259, 0xdc71, 0x4d46, 0xbe, 0xf1, 0x35, 0x7b, 0xb5, 0x78, 0xc4, 0x18],
    'EFI_PXE_BASE_CODE_CALLBACK_PROTOCOL_GUID': [0x245dca21, 0xfb7b, 0x11d3, 0x8f, 0x01, 0x00, 0xa0, 0xc9, 0x69, 0x72, 0x3b],
    'EFI_PXE_BASE_CODE_PROTOCOL_GUID': [0x03c4e603, 0xac28, 0x11d3, 0x9a, 0x2d, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d],
    'EFI_PXE_DHCP4_CALLBACK_PROTOCOL_GUID': [0xc1544c01, 0x92a4, 0x4198, 0x8a, 0x84, 0x77, 0x85, 0x83, 0xc2, 0x36, 0x21],
    'EFI_PXE_DHCP4_PROTOCOL_GUID': [0x03c4e624, 0xac28, 0x11d3, 0x9a, 0x2d, 0x00, 0x90, 0x29, 0x3f, 0xc1, 0x4d],
    'EFI_REAL_TIME_CLOCK_ARCH_PROTOCOL_GUID': [0x27CFAC87, 0x46CC, 0x11d4, 0x9A, 0x38, 0x00, 0x90, 0x27, 0x3F, 0xC1, 0x4D],
    'EFI_RESET_ARCH_PROTOCOL_GUID': [0x27CFAC88, 0x46CC, 0x11D4, 0x9A, 0x38, 0x00, 0x90, 0x27, 0x3F, 0xC1, 0x4D],
    'EFI_RESET_ARCH_PROTOCOL_GUID': [0x27CFAC88, 0x46CC, 0x11d4, 0x9A, 0x38, 0x00, 0x90, 0x27, 0x3F, 0xC1, 0x4D],
    'EFI_S3_SAVE_STATE_PROTOCOL_GUID': [0xe857caf6, 0xc046, 0x45dc, 0xbe, 0x3f, 0xee, 0x7, 0x65, 0xfb, 0xa8, 0x87],
    'EFI_S3_SMM_SAVE_STATE_PROTOCOL_GUID': [0x320afe62, 0xe593, 0x49cb, 0xa9, 0xf1, 0xd4, 0xc2, 0xf4, 0xaf, 0x1, 0x4c],
    'EFI_SAL_SYSTEM_TABLE_GUID': [0xeb9d2d32, 0x2d88, 0x11d3, 0x9a, 0x16, 0x0, 0x90, 0x27, 0x3f, 0xc1, 0x4d],
    'EFI_SA_INFO_PROTOCOL_GUID': [0x493b5bac, 0xbb9e, 0x4bf5, 0x83, 0x79, 0x20, 0xe2, 0xac, 0xa9, 0x85, 0x41],
    'EFI_SB_PCIE_ERROR_LOG_DISPATCH_PROTOCOL_GUID': [0xf281fc6e, 0xf4c4, 0x431c, 0x96, 0x2b, 0x2f, 0x13, 0xae, 0x79, 0x84, 0xec],
    'EFI_SCSI_IO_PROTOCOL_GUID': [0x932f47e6, 0x2362, 0x4002, 0x80, 0x3e, 0x3c, 0xd5, 0x4b, 0x13, 0x8f, 0x85],
    'EFI_SCSI_PASS_THRU_PROTOCOL_GUID': [0xa59e8fcf, 0xbda0, 0x43bb, 0x90, 0xb1, 0xd3, 0x73, 0x2e, 0xca, 0xa8, 0x77],
    'EFI_SECTION_EXTRACTION_PROTOCOL_GUID': [0x448F5DA4, 0x6DD7, 0x4FE1, 0x93, 0x07, 0x69, 0x22, 0x41, 0x92, 0x21, 0x5D],
    'EFI_SECURITY_ARCH_PROTOCOL_GUID': [0xA46423E3, 0x4617, 0x49f1, 0xB9, 0xFF, 0xD1, 0xBF, 0xA9, 0x11, 0x58, 0x39],
    'EFI_SECURITY_POLICY_PROTOCOL_GUID': [0x78E4D245, 0xCD4D, 0x4a05, 0xA2, 0xBA, 0x47, 0x43, 0xE8, 0x6C, 0xFC, 0xAB],
    'EFI_SEC_PLATFORM_INFORMATION_GUID': [0x6f8c2b35, 0xfef4, 0x448d, 0x82, 0x56, 0xe1, 0x1b, 0x19, 0xd6, 0x10, 0x77],
    'EFI_SEC_SMI_FLASH_GUID': [0x3bf4af16, 0xab7c, 0x4b43, 0x89, 0x8d, 0xab, 0x26, 0xac, 0x5d, 0xdc, 0x6c],
    'EFI_SERIAL_GPIO_PROTOCOL_GUID': [0xf52c3858, 0x5ef8, 0x4d41, 0x83, 0x4e, 0xc3, 0x9e, 0xef, 0x8a, 0x45, 0xa3],
    'EFI_SERIAL_IO_PROTOCOL_GUID': [0xBB25CF6F, 0xF1D4, 0x11D2, 0x9A, 0x0C, 0x00, 0x90, 0x27, 0x3F, 0xC1, 0xFD],
    'EFI_SHELL_FILE_GUID': [0xc57ad6b7, 0x0515, 0x40a8, 0x9d, 0x21, 0x55, 0x16, 0x52, 0x85, 0x4e, 0x37],
    'EFI_SIMPLE_AUDIO_OUT_PROTOCOL_GUID': [0xc723f288, 0x52f9, 0x4d80, 0xb6, 0x33, 0xe1, 0x52, 0xf9, 0x30, 0xa0, 0xdc],
    'EFI_SIMPLE_FILE_SYSTEM_PROTOCOL_GUID': [0x964e5b22, 0x6459, 0x11d2, 0x8e, 0x39, 0x0, 0xa0, 0xc9, 0x69, 0x72, 0x3b],
    'EFI_SIMPLE_NETWORK_PROTOCOL_GUID': [0xA19832B9, 0xAC25, 0x11D3, 0x9A, 0x2D, 0x00, 0x90, 0x27, 0x3F, 0xC1, 0x4D],
    'EFI_SIMPLE_TEXT_INPUT_EX_PROTOCOL_GUID': [0xdd9e7534, 0x7762, 0x4698, 0x8c, 0x14, 0xf5, 0x85, 0x17, 0xa6, 0x25, 0xaa],
    'EFI_SIMPLE_TEXT_INPUT_PROTOCOL_GUID': [0x387477c1, 0x69c7, 0x11d2, 0x8e, 0x39, 0x0, 0xa0, 0xc9, 0x69, 0x72, 0x3b],
    'EFI_SIMPLE_TEXT_IN_PROTOCOL_GUID': [0x387477c1, 0x69c7, 0x11d2, 0x8e, 0x39, 0x0, 0xa0, 0xc9, 0x69, 0x72, 0x3b],
    'EFI_SIMPLE_TEXT_OUT_PROTOCOL_GUID': [0x387477c2, 0x69c7, 0x11d2, 0x8e, 0x39, 0x0, 0xa0, 0xc9, 0x69, 0x72, 0x3b],
    'EFI_SIO_PROTOCOL_GUID': [0x215fdd18, 0xbd50, 0x4feb, 0x89, 0xb, 0x58, 0xca, 0xb, 0x47, 0x39, 0xe9],
    'EFI_SMBIOS_BOARD_PROTOCOL_GUID': [0x903dd14, 0x2ca0, 0x458a, 0xb5, 0xeb, 0xc, 0xc, 0xa3, 0xd, 0x78, 0x5c],
    'EFI_SMBIOS_DYNAMIC_DATA_GUID': [0xe380280c, 0x4c35, 0x4aa3, 0xb9, 0x61, 0x7a, 0xe4, 0x89, 0xa2, 0xb9, 0x26],
    'EFI_SMBIOS_NVRAM_DATA_GUID': [0x4b3082a3, 0x80c6, 0x4d7e, 0x9c, 0xd0, 0x58, 0x39, 0x17, 0x26, 0x5d, 0xf1],
    'EFI_SMBIOS_PROTOCOL_GUID': [0x03583ff6, 0xcb36, 0x4940, 0x94, 0x7e, 0xb9, 0xb3, 0x9f, 0x4a, 0xfa, 0xf7],
    'EFI_SMBIOS_PROTOCOL_GUID': [0x5e90a50d, 0x6955, 0x4a49, 0x90, 0x32, 0xda, 0x38, 0x12, 0xf8, 0xe8, 0xe5],
    'EFI_SMBIOS_STATIC_DATA_GUID': [0xdaf4bf89, 0xce71, 0x4917, 0xb5, 0x22, 0xc8, 0x9d, 0x32, 0xfb, 0xc5, 0x9f],
    'EFI_SMBIOS_TABLE_GUID': [0xeb9d2d31, 0x2d88, 0x11d3, 0x9a, 0x16, 0x0, 0x90, 0x27, 0x3f, 0xc1, 0x4d],
    'EFI_SMBUS_ARP_MAP_GUID': [0x707be83e, 0x0bf6, 0x40a5, 0xbe, 0x64, 0x34, 0xc0, 0x3a, 0xa0, 0xb8, 0xe2],
    'EFI_SMBUS_HC_PROTOCOL_GUID': [0xe49d33ed, 0x513d, 0x4634, 0xb6, 0x98, 0x6f, 0x55, 0xaa, 0x75, 0x1c, 0x1b],
    'EFI_SMM_ACCESS_PROTOCOL_GUID': [0x3792095a, 0xe309, 0x4c1e, 0xaa, 0x01, 0x85, 0xf5, 0x65, 0x5a, 0x17, 0xf1],
    'EFI_SMM_BASE_PROTOCOL_GUID': [0x1390954D, 0xda95, 0x4227, 0x93, 0x28, 0x72, 0x82, 0xc2, 0x17, 0xda, 0xa8],
    'EFI_SMM_BIOS_WRITE_DISPATCH_PROTOCOL_GUID': [0xe512dfe4, 0xbf44, 0x480d, 0x9b, 0x7a, 0x77, 0x7b, 0xb, 0xe3, 0x27, 0x75],
    'EFI_SMM_CMOS_ACCESS_GUID': [0xe5d3026a, 0x1ca5, 0x40f0, 0x8f, 0xb6, 0x4b, 0x1a, 0xfa, 0x3c, 0x6e, 0xaa],
    'EFI_SMM_COMMUNICATION_PROTOCOL_GUID': [0xc68ed8e2, 0x9dc6, 0x4cbd, 0x9d, 0x94, 0xdb, 0x65, 0xac, 0xc5, 0xc3, 0x32],
    'EFI_SMM_CONTROL_PROTOCOL_GUID': [0x8d12e231, 0xc667, 0x4fd1, 0x98, 0xf2, 0x24, 0x49, 0xa7, 0xe7, 0xb2, 0xe5],
    'EFI_SMM_CPU_IO2_PROTOCOL_GUID': [0x3242A9D8, 0xCE70, 0x4AA0, 0x95, 0x5D, 0x5E, 0x7B, 0x14, 0x0D, 0xE4, 0xD2],
    'EFI_SMM_CPU_IO_GUID': [0x5f439a0b, 0x45d8, 0x4682, 0xa4, 0xf4, 0xf0, 0x57, 0x6b, 0x51, 0x34, 0x41],
    'EFI_SMM_CPU_PROTOCOL_GUID': [0xeb346b97, 0x975f, 0x4a9f, 0x8b, 0x22, 0xf8, 0xe9, 0x2b, 0xb3, 0xd5, 0x69],
    'EFI_SMM_CPU_SAVE_STATE_PROTOCOL_GUID': [0x21f302ad, 0x6e94, 0x471b, 0x84, 0xbc, 0xb1, 0x48, 0x0, 0x40, 0x3a, 0x1d],
    'EFI_SMM_GPI_DISPATCH2_PROTOCOL_GUID': [0x25566b03, 0xb577, 0x4cbf, 0x95, 0x8c, 0xed, 0x66, 0x3e, 0xa2, 0x43, 0x80],
    'EFI_SMM_GPI_DISPATCH_PROTOCOL_GUID': [0xe0744b81, 0x9513, 0x49cd, 0x8c, 0xea, 0xe9, 0x24, 0x5e, 0x70, 0x39, 0xda],
    'EFI_SMM_ICHN_DISPATCH_EX_PROTOCOL_GUID': [0x3920405b, 0xc897, 0x44da, 0x88, 0xf3, 0x4c, 0x49, 0x8a, 0x6f, 0xf7, 0x36],
    'EFI_SMM_ICHN_DISPATCH_PROTOCOL_GUID': [0xc50b323e, 0x9075, 0x4f2a, 0xac, 0x8e, 0xd2, 0x59, 0x6a, 0x10, 0x85, 0xcc],
    'EFI_SMM_IO_TRAP_DISPATCH2_PROTOCOL_GUID': [0x58dc368d, 0x7bfa, 0x4e77, 0xab, 0xbc, 0x0e, 0x29, 0x41, 0x8d, 0xf9, 0x30],
    'EFI_SMM_IO_TRAP_DISPATCH2_PROTOCOL_GUID': [0x58dc368d, 0x7bfa, 0x4e77, 0xab, 0xbc, 0xe, 0x29, 0x41, 0x8d, 0xf9, 0x30],
    'EFI_SMM_IO_TRAP_DISPATCH2_PROTOCOL_GUID': [0xf1507845, 0x6494, 0x4377, 0xa1, 0x15, 0x45, 0xdf, 0xe6, 0x5f, 0x5d, 0x71],
    'EFI_SMM_IO_TRAP_DISPATCH_PROTOCOL_GUID': [0x58dc368d, 0x7bfa, 0x4e77, 0xab, 0xbc, 0xe, 0x29, 0x41, 0x8d, 0xf9, 0x30],
    'EFI_SMM_IO_TRAP_DISPATCH_PROTOCOL_GUID': [0xbd18369d, 0xc242, 0x45ca, 0x82, 0xad, 0x13, 0x8a, 0xc2, 0xe2, 0x9b, 0xab],
    'EFI_SMM_IO_TRAP_DISPATCH_PROTOCOL_GUID': [0xdb7f536b, 0xede4, 0x4714, 0xa5, 0xc8, 0xe3, 0x46, 0xeb, 0xaa, 0x20, 0x1d],
    'EFI_SMM_PCI_ROOT_BRIDGE_IO_PROTOCOL_GUID': [0x8bc1714d, 0xffcb, 0x41c3, 0x89, 0xdc, 0x6c, 0x74, 0xd0, 0x6d, 0x98, 0xea],
    'EFI_SMM_PERIODIC_TIMER_DISPATCH2_PROTOCOL_GUID': [0x4cec368e, 0x8e8e, 0x4d71, 0x8b, 0xe1, 0x95, 0x8c, 0x45, 0xfc, 0x8a, 0x53],
    'EFI_SMM_PERIODIC_TIMER_DISPATCH_PROTOCOL_GUID': [0x9cca03fc, 0x4c9e, 0x4a19, 0x9b, 0x6, 0xed, 0x7b, 0x47, 0x9b, 0xde, 0x55],
    'EFI_SMM_POWER_BUTTON_DISPATCH2_PROTOCOL_GUID': [0x1b1183fa, 0x1823, 0x46a7, 0x88, 0x72, 0x9c, 0x57, 0x87, 0x55, 0x40, 0x9d],
    'EFI_SMM_POWER_BUTTON_DISPATCH_PROTOCOL_GUID': [0xb709efa0, 0x47a6, 0x4b41, 0xb9, 0x31, 0x12, 0xec, 0xe7, 0xa8, 0xee, 0x56],
    'EFI_SMM_RC_TO_APTIO_BRIDGE_GUID': [0xfcdf7788, 0x7878, 0x11ff, 0xcc, 0x77, 0x88, 0xcc, 0xcc, 0x77, 0x88, 0xcc],
    'EFI_SMM_READY_TO_LOCK_PROTOCOL_GUID': [0x47b7fa8c, 0xf4bd, 0x4af6, 0x82, 0x00, 0x33, 0x30, 0x86, 0xf0, 0xd2, 0xc8],
    'EFI_SMM_RSC_HANDLER_PROTOCOL_GUID': [0x2ff29fa7, 0x5e80, 0x4ed9, 0xb3, 0x80, 0x1, 0x7d, 0x3c, 0x55, 0x4f, 0xf4],
    'EFI_SMM_RUNTIME_PROTOCOL_GUID': [0xa56897a1, 0xa77f, 0x4600, 0x84, 0xdb, 0x22, 0xb0, 0xa8, 0x1, 0xfa, 0x9a],
    'EFI_SMM_RUNTIME_SERVICES_TABLE_GUID': [0x395c33fe, 0x287f, 0x413e, 0xa0, 0x55, 0x80, 0x88, 0xc0, 0xe1, 0xd4, 0x3e],
    'EFI_SMM_SMBUS_PROTOCOL_GUID': [0x72e40094, 0x2ee1, 0x497a, 0x8f, 0x33, 0x4c, 0x93, 0x4a, 0x9e, 0x9c, 0xc],
    'EFI_SMM_SPI_PROTOCOL_GUID': [0xD9072C35, 0xEB8F, 0x43ad, 0xA2, 0x20, 0x34, 0xD4, 0x0E, 0x2A, 0x82, 0x85],
    'EFI_SMM_SPI_PROTOCOL_GUID': [0xaff3be49, 0x6d71, 0x421c, 0x92, 0x77, 0xa0, 0xb1, 0x50, 0x8e, 0x84, 0x7d],
    'EFI_SMM_STANDBY_BUTTON_DISPATCH2_PROTOCOL_GUID': [0x7300c4a1, 0x43f2, 0x4017, 0xa5, 0x1b, 0xc8, 0x1a, 0x7f, 0x40, 0x58, 0x5b],
    'EFI_SMM_STANDBY_BUTTON_DISPATCH_PROTOCOL_GUID': [0x78965b98, 0xb0bf, 0x449e, 0x8b, 0x22, 0xd2, 0x91, 0x4e, 0x49, 0x8a, 0x98],
    'EFI_SMM_STATUS_CODE_PROTOCOL_GUID': [0x6afd2b77, 0x98c1, 0x4acd, 0xa6, 0xf9, 0x8a, 0x94, 0x39, 0xde, 0xf, 0xb1],
    'EFI_SMM_SW_DISPATCH2_PROTOCOL_GUID': [0x18a3c6dc, 0x5eea, 0x48c8, 0xa1, 0xc1, 0xb5, 0x33, 0x89, 0xf9, 0x89, 0x99],
    'EFI_SMM_SW_DISPATCH_PROTOCOL_GUID': [0xe541b773, 0xdd11, 0x420c, 0xb0, 0x26, 0xdf, 0x99, 0x36, 0x53, 0xf8, 0xbf],
    'EFI_SMM_SX_DISPATCH2_PROTOCOL_GUID': [0x456d2859, 0xa84b, 0x4e47, 0xa2, 0xee, 0x32, 0x76, 0xd8, 0x86, 0x99, 0x7d],
    'EFI_SMM_TCO_DISPATCH_PROTOCOL_GUID': [0xe2d6bb1, 0xc624, 0x446d, 0x99, 0x82, 0x69, 0x3c, 0xd1, 0x81, 0xa6, 0x7],
    'EFI_SMM_THUNK_PROTOCOL_GUID': [0x2a82fce6, 0x8bb6, 0x413e, 0xb9, 0xeb, 0x45, 0xdf, 0xc0, 0x52, 0x2d, 0xf3],
    'EFI_SMM_USB_DISPATCH2_PROTOCOL_GUID': [0xee9b8d90, 0xc5a6, 0x40a2, 0xbd, 0xe2, 0x52, 0x55, 0x8d, 0x33, 0xcc, 0xa1],
    'EFI_SMM_USB_DISPATCH_PROTOCOL_GUID': [0xa05b6ffd, 0x87af, 0x4e42, 0x95, 0xc9, 0x62, 0x28, 0xb6, 0x3c, 0xf3, 0xf3],
    'EFI_SMM_VARIABLE_PROTOCOL_GUID': [0x3025da01, 0xdc5f, 0x4f59, 0xbc, 0xc3, 0xb3, 0x77, 0xc8, 0x32, 0x5a, 0x4a],
    'EFI_SMRAM_NVS_HEADER_GUID': [0xec7f4fa1, 0xb217, 0x42fc, 0xa7, 0xf7, 0x2, 0xc, 0x43, 0x5, 0xd5, 0xba],
    'EFI_SMTP_PROTOCOL_GUID': [0x5f67d40c, 0x1d06, 0x4e3e, 0x8b, 0x4a, 0xd2, 0x71, 0x3f, 0x46, 0xe1, 0xdc],
    'EFI_SPEAKER_INTERFACE_PROTOCOL_GUID': [0x400b4476, 0x3081, 0x11d6, 0x87, 0xed, 0x00, 0x06, 0x29, 0x45, 0xc3, 0xb9],
    'EFI_SPI_PROTOCOL_GUID': [0x1156efc6, 0xea32, 0x4396, 0xb5, 0xd5, 0x26, 0x93, 0x2e, 0x83, 0xc3, 0x13],
    'EFI_SPI_PROTOCOL_GUID': [0x1a660d9, 0x8009, 0x4330, 0xba, 0x89, 0x71, 0xb0, 0x76, 0xcd, 0x5d, 0xa],
    'EFI_STANDARD_CALLER_ID_GUID': [0xC9DCF469, 0xA7C4, 0x11D5, 0x87, 0xDA, 0x00, 0x06, 0x29, 0x45, 0xC3, 0xB9],
    'EFI_STANDARD_ERROR_DEVICE_GUID': [0xd3b36f2d, 0xd551, 0x11d4, 0x9a, 0x46, 0x0, 0x90, 0x27, 0x3f, 0xc1, 0x4d],
    'EFI_STATUS_CODE_ARCH_PROTOCOL_GUID': [0xd98e3ea3, 0x6f39, 0x4be4, 0x82, 0xce, 0x5a, 0x89, 0x0c, 0xcb, 0x2c, 0x95],
    'EFI_STATUS_CODE_DATA_TYPE_ASSERT_GUID': [0xDA571595, 0x4D99, 0x487C, 0x82, 0x7C, 0x26, 0x22, 0x67, 0x7D, 0x33, 0x07],
    'EFI_STATUS_CODE_DATA_TYPE_DEBUG_GUID': [0x9A4E9246, 0xD553, 0x11D5, 0x87, 0xE2, 0x00, 0x06, 0x29, 0x45, 0xC3, 0xb9],
    'EFI_STATUS_CODE_DATA_TYPE_ERROR_GUID': [0xAB359CE3, 0x99B3, 0xAE18, 0xC8, 0x9D, 0x95, 0xD3, 0xB0, 0x72, 0xE1, 0x9B],
    'EFI_STATUS_CODE_DATA_TYPE_EXCEPTION_HANDLER_GUID': [0x3BC2BD12, 0xAD2E, 0x11D5, 0x87, 0xDD, 0x00, 0x06, 0x29, 0x45, 0xC3, 0xB9],
    'EFI_STATUS_CODE_DATA_TYPE_PROGRESS_CODE_GUID': [0xA356AB39, 0x35C4, 0x35DA, 0xB3, 0x7A, 0xF8, 0xEA, 0x9E, 0x8B, 0x36, 0xA3],
    'EFI_STATUS_CODE_DATA_TYPE_STRING_GUID': [0x92D11080, 0x496F, 0x4D95, 0xBE, 0x7E, 0x03, 0x74, 0x88, 0x38, 0x2B, 0x0A],
    'EFI_STATUS_CODE_GUID': [0xd083e94c, 0x6560, 0x42e4, 0xb6, 0xd4, 0x2d, 0xf7, 0x5a, 0xdf, 0x6a, 0x2a],
    'EFI_STATUS_CODE_SPECIFIC_DATA_GUID': [0x335984bd, 0xe805, 0x409a, 0xb8, 0xf8, 0xd2, 0x7e, 0xce, 0x5f, 0xf7, 0xa6],
    'EFI_STORAGE_SECURITY_COMMAND_PROTOCOL_GUID': [0xc88b0b6d, 0x0dfc, 0x49a7, 0x9c, 0xb4, 0x49, 0x7, 0x4b, 0x4c, 0x3a, 0x78],
    'EFI_SWAP_ADDRESS_RANGE_PROTOCOL_GUID': [0x1259f60d, 0xb754, 0x468e, 0xa7, 0x89, 0x4d, 0xb8, 0x5d, 0x55, 0xe8, 0x7e],
    'EFI_SYSTEM_NV_DATA_FV_GUID': [0xfff12b8d, 0x7696, 0x4c8b, 0xa9, 0x85, 0x27, 0x47, 0x7, 0x5b, 0x4f, 0x50],
    'EFI_SYSTEM_NV_DATA_HOB_GUID': [0xd6e5092d, 0xc7b2, 0x4872, 0xaf, 0x66, 0xfd, 0xc0, 0xe6, 0xf9, 0x5e, 0x78],
    'EFI_SYSTEM_TYPE_FRU_GUID': [0xaab16018, 0x679d, 0x4461, 0xba, 0x20, 0xe7, 0xc, 0xf7, 0x86, 0x6a, 0x9b],
    'EFI_TAPE_IO_PROTOCOL_GUID': [0x1e93e633, 0xd65a, 0x459e, 0xab, 0x84, 0x93, 0xd9, 0xec, 0x26, 0x6d, 0x18],
    'EFI_TCG_LOG_HOB_GUID': [0x5f7d4e0e, 0x3d6d, 0x42bc, 0xa9, 0x42, 0xe, 0x91, 0xe8, 0x3e, 0x3c, 0x31],
    'EFI_TCG_PEI_READ_ONLY_VARIABLE_PPI_GUID': [0x3cdc90c6, 0x13fb, 0x4a75, 0x9e, 0x79, 0x59, 0xe9, 0xdd, 0x78, 0xb9, 0xfa],
    'EFI_TCG_PLATFORM_PROTOCOL_GUID': [0x8c4c9a41, 0xbf56, 0x4627, 0x9e, 0xa, 0xc8, 0x38, 0x6d, 0x66, 0x11, 0x5c],
    'EFI_TCG_PRIVATE_INTERFACE_GUID': [0x8c4c9a41, 0xbf56, 0x4627, 0x9e, 0xa, 0xc8, 0x38, 0x6d, 0x66, 0x11, 0x5c],
    'EFI_TCG_PROTOCOL_GUID': [0xf541796d, 0xa62e, 0x4954, 0xa7, 0x75, 0x95, 0x84, 0xf6, 0x1b, 0x9c, 0xdd],
    'EFI_TCG_WAKE_EVENT_DATA_HOB_GUID': [0xBBB810BB, 0x5EF0, 0x4E8F, 0xB2, 0x98, 0xAD, 0x74, 0xAA, 0x50, 0xEF, 0x0A],
    'EFI_TCP4_PROTOCOL_GUID': [0x65530BC7, 0xA359, 0x410f, 0xB0, 0x10, 0x5A, 0xAD, 0xC7, 0xEC, 0x2B, 0x62],
    'EFI_TCP4_SERVICE_BINDING_PROTOCOL_GUID': [0x00720665, 0x67EB, 0x4a99, 0xBA, 0xF7, 0xD3, 0xC3, 0x3A, 0x1C, 0x7C, 0xC9],
    'EFI_TCP_PROTOCOL_GUID': [0x02b3d5f2, 0xac28, 0x11d3, 0x9a, 0x2d, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d],
    'EFI_TCP_SOCK_PROTOCOL_GUID': [0x5187359b, 0x790d, 0x425b, 0xa5, 0x93, 0xca, 0x1c, 0xdb, 0x3c, 0xeb, 0xad],
    'EFI_TDT_PROTOCOL_GUID': [0xbf70067, 0xd53b, 0x42df, 0xb7, 0x70, 0xe9, 0x2c, 0x91, 0xc6, 0x14, 0x11],
    'EFI_TELNET_SERVER_PROTOCOL_GUID': [0x6d3569d4, 0x85e5, 0x4943, 0xae, 0x46, 0xee, 0x67, 0xa6, 0xe1, 0xab, 0x5a],
    'EFI_TIANO_DECOMPRESS_PROTOCOL_GUID': [0xe84cf29c, 0x191f, 0x4eae, 0x96, 0xe1, 0xf4, 0x6a, 0xec, 0xea, 0xea, 0x0b],
    'EFI_TIMER_ARCH_PROTOCOL_GUID': [0x26baccb3, 0x6f42, 0x11d4, 0xbc, 0xe7, 0x0, 0x80, 0xc7, 0x3c, 0x88, 0x81],
    'EFI_TIMER_ARCH_PROTOCOL_GUID': [0x26baccb3, 0x6f42, 0x11d4, 0xbc, 0xe7, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81],
    'EFI_TIME_VARIABLE_GUID': [0x9d0da369, 0x540b, 0x46f8, 0x85, 0xa0, 0x2b, 0x5f, 0x2c, 0x30, 0x1e, 0x15],
    'EFI_TPM_DEVICE_PROTOCOL_GUID': [0xde161cfe, 0x1e60, 0x42a1, 0x8c, 0xc3, 0xee, 0x7e, 0xf0, 0x73, 0x52, 0x12],
    'EFI_TPM_STATE_INIT_HUB_GUID': [0xA0C6D918, 0x8DEE, 0x41BB, 0x9D, 0x92, 0x67, 0x53, 0xA5, 0x72, 0xB6, 0x52],
    'EFI_TXT_INFO_PROTOCOL_GUID': [0x601211DC, 0x0B12, 0x4C09, 0xAE, 0x27, 0xAB, 0xE, 0xC9, 0x69, 0x24, 0x68],
    'EFI_UDP4_PROTOCOL_GUID': [0x3ad9df29, 0x4501, 0x478d, 0xb1, 0xf8, 0x7f, 0x7f, 0xe7, 0x0e, 0x50, 0xf3],
    'EFI_UDP4_SERVICE_BINDING_PROTOCOL_GUID': [0x83f01464, 0x99bd, 0x45e5, 0xb3, 0x83, 0xaf, 0x63, 0x05, 0xd8, 0xe9, 0xe6],
    'EFI_UDP_PROTOCOL_GUID': [0xc56fb1b2, 0x017b, 0x4984, 0xa3, 0xf6, 0x3f, 0x73, 0x4f, 0xfa, 0x9e, 0x33],
    'EFI_UGA_DRAW_PROTOCOL_GUID': [0x982c298b, 0xf4fa, 0x41cb, 0xb8, 0x38, 0x77, 0xaa, 0x68, 0x8f, 0xb8, 0x39],
    'EFI_UGA_IO_PROTOCOL_GUID': [0x61a4d49e, 0x6f68, 0x4f1b, 0xb9, 0x22, 0xa8, 0x6e, 0xed, 0xb, 0x7, 0xa2],
    'EFI_UGA_SPLASH_PROTOCOL_GUID': [0xa45b3a0d, 0x2e55, 0x4c03, 0xad, 0x9c, 0x27, 0xd4, 0x82, 0xb, 0x50, 0x7e],
    'EFI_UNICODE_COLLATION2_PROTOCOL_GUID': [0xa4c751fc, 0x23ae, 0x4c3e, 0x92, 0xe9, 0x49, 0x64, 0xcf, 0x63, 0xf3, 0x49],
    'EFI_UNICODE_COLLATION_PROTOCOL2_GUID': [0xa4c751fc, 0x23ae, 0x4c3e, 0x92, 0xe9, 0x49, 0x64, 0xcf, 0x63, 0xf3, 0x49],
    'EFI_UNICODE_COLLATION_PROTOCOL_GUID': [0x1d85cd7f, 0xf43d, 0x11d2, 0x9a, 0x0c, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d],
    'EFI_UNICODE_COLLATION_PROTOCOL_GUID': [0x1d85cd7f, 0xf43d, 0x11d2, 0x9a, 0xc, 0x0, 0x90, 0x27, 0x3f, 0xc1, 0x4d],
    'EFI_USB2_HC_PROTOCOL_GUID': [0x3e745226, 0x9818, 0x45b6, 0xa2, 0xac, 0xd7, 0xcd, 0xe, 0x8b, 0xa2, 0xbc],
    'EFI_USB_ATAPI_PROTOCOL_GUID': [0x2B2F68DA, 0x0CD2, 0x44cf, 0x8E, 0x8B, 0xBB, 0xA2, 0x0B, 0x1B, 0x5B, 0x75],
    'EFI_USB_HC_PROTOCOL_GUID': [0xf5089266, 0x1aa0, 0x4953, 0x97, 0xd8, 0x56, 0x2f, 0x8a, 0x73, 0xb5, 0x19],
    'EFI_USB_IO_PROTOCOL_GUID': [0x2B2F68D6, 0x0CD2, 0x44cf, 0x8E, 0x8B, 0xBB, 0xA2, 0x0B, 0x1B, 0x5B, 0x75],
    'EFI_USB_POLICY_PROTOCOL_GUID': [0x5859cb76, 0x6bef, 0x468a, 0xbe, 0x2d, 0xb3, 0xdd, 0x1a, 0x27, 0xf0, 0x12],
    'EFI_USB_PROTOCOL_GUID': [0x2ad8e2d2, 0x2e91, 0x4cd1, 0x95, 0xf5, 0xe7, 0x8f, 0xe5, 0xeb, 0xe3, 0x16],
    'EFI_USER_CREDENTIAL_PROTOCOL_GUID': [0x71ee5e94, 0x65b9, 0x45d5, 0x82, 0x1a, 0x3a, 0x4d, 0x86, 0xcf, 0xe6, 0xbe],
    'EFI_USER_INFO_ACCESS_SETUP_ADMIN_GUID': [0x85b75607, 0xf7ce, 0x471e, 0xb7, 0xe4, 0x2a, 0xea, 0x5f, 0x72, 0x32, 0xee],
    'EFI_USER_INFO_ACCESS_SETUP_NORMAL_GUID': [0x1db29ae0, 0x9dcb, 0x43bc, 0x8d, 0x87, 0x5d, 0xa1, 0x49, 0x64, 0xdd, 0xe2],
    'EFI_USER_INFO_ACCESS_SETUP_RESTRICTED_GUID': [0xbdb38125, 0x4d63, 0x49f4, 0x82, 0x12, 0x61, 0xcf, 0x5a, 0x19, 0x0a, 0xf8],
    'EFI_USER_MANAGER_PROTOCOL_GUID': [0x6fd5b00c, 0xd426, 0x4283, 0x98, 0x87, 0x6c, 0xf5, 0xcf, 0x1c, 0xb1, 0xfe],
    'EFI_VARIABLE_ARCH_PROTOCOL_GUID': [0x1e5668e2, 0x8481, 0x11d4, 0xbc, 0xf1, 0x0, 0x80, 0xc7, 0x3c, 0x88, 0x81],
    'EFI_VARIABLE_STORE_PROTOCOL_GUID': [0xf088cd91, 0xa046, 0x11d2, 0x8e, 0x42, 0x0, 0xa0, 0xc9, 0x69, 0x72, 0x3b],
    'EFI_VARIABLE_WRITE_ARCH_PROTOCOL_GUID': [0x6441f818, 0x6362, 0x4e44, 0xb5, 0x70, 0x7d, 0xba, 0x31, 0xdd, 0x24, 0x53],
    'EFI_VGA_MINI_PORT_PROTOCOL_GUID': [0xc7735a2f, 0x88f5, 0x4882, 0xae, 0x63, 0xfa, 0xac, 0x8c, 0x8b, 0x86, 0xb3],
    'EFI_VIRTUAL_MEMORY_ACCESS_PROTOCOL_GUID': [0x745d377a, 0xb988, 0x47b2, 0xb1, 0x8f, 0xbb, 0xc8, 0xd, 0xc5, 0x66, 0x98],
    'EFI_VT_100_GUID': [0xdfa66065, 0xb419, 0x11d3, 0x9a, 0x2d, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d],
    'EFI_VT_100_PLUS_GUID': [0x7baec70b, 0x57e0, 0x4c76, 0x8e, 0x87, 0x2f, 0x9e, 0x28, 0x08, 0x83, 0x43],
    'EFI_VT_UTF8_GUID': [0xad15a0d6, 0x8bec, 0x4acf, 0xa0, 0x73, 0xd0, 0x1d, 0xe7, 0x7e, 0x2d, 0x88],
    'EFI_WATCHDOG_TIMER_ARCH_PROTOCOL_GUID': [0x665E3FF5, 0x46CC, 0x11D4, 0x9A, 0x38, 0x00, 0x90, 0x27, 0x3F, 0xC1, 0x4D],
    'EFI_WATCHDOG_TIMER_ARCH_PROTOCOL_GUID': [0x665E3FF5, 0x46CC, 0x11d4, 0x9A, 0x38, 0x00, 0x90, 0x27, 0x3F, 0xC1, 0x4D],
    'EFI_WIN_NT_BUS_DRIVER_IO_PROTOCOL_GUID': [0x96eb4ad6, 0xa32a, 0x11d4, 0xbc, 0xfd, 0x0, 0x80, 0xc7, 0x3c, 0x88, 0x81],
    'EFI_WIN_NT_SERIAL_PORT_GUID': [0xc95a93d, 0xa006, 0x11d4, 0xbc, 0xfa, 0x0, 0x80, 0xc7, 0x3c, 0x88, 0x81],
    'EFI_WIN_NT_THUNK_PROTOCOL_GUID': [0x58c518b1, 0x76f3, 0x11d4, 0xbc, 0xea, 0x0, 0x80, 0xc7, 0x3c, 0x88, 0x81],
    'ERROR_MANAGER_GUID': [0xADDEBF82, 0xA560, 0x46B9, 0xA2, 0x80, 0x78, 0xC6, 0xAB, 0x61, 0xAE, 0xDA],
    'EXIT_FORM_SET_GUID': [0xa43b03dc, 0xc18a, 0x41b1, 0x91, 0xc8, 0x3f, 0xf9, 0xaa, 0xa2, 0x57, 0x13],
    'EXIT_PAGE_GUID': [0xEC87D643, 0xEBA4, 0x4BB5, 0xA1, 0xE5, 0x3F, 0x3E, 0x36, 0xB2, 0x0D, 0xA9],
    'FAST_BOOT_TSE_PROTOCOL_GUID': [0x0fba43b8, 0xacdb, 0x4ee2, 0xab, 0x31, 0x0f, 0xa4, 0xd5, 0xb6, 0xc3, 0xc5],
    'FAST_BOOT_VARIABLE_GUID': [0xb540a530, 0x6978, 0x4da7, 0x91, 0xcb, 0x72, 0x7, 0xd7, 0x64, 0xd2, 0x62],
    'FID_FFS_SECTION_GUID': [0x2EBE0275, 0x6458, 0x4AF9, 0x91, 0xed, 0xD3, 0xF4, 0xED, 0xB1, 0x00, 0xAA],
    'FID_TABLE_GUID': [0x3fd1d3a2, 0x99f7, 0x420b, 0xbc, 0x69, 0x8b, 0xb1, 0xd4, 0x92, 0xa3, 0x32],
    'FID_TABLE_SECTION_GUID': [0x2ebe0275, 0x6458, 0x4af9, 0x91, 0xed, 0xd3, 0xf4, 0xed, 0xb1, 0x00, 0xaa],
    'FIRMWARE_PERFORMANCE_PROTOCOL_GUID': [0xbc412d75, 0x2729, 0x4c3a, 0xb1, 0x93, 0x5b, 0x9a, 0x58, 0x8f, 0xf6, 0x6f],
    'FLASH_PROTOCOL_GUID': [0x755b6596, 0x6896, 0x4ba3, 0xb3, 0xdd, 0x1c, 0x62, 0x9f, 0xd1, 0xea, 0x88],
    'FLASH_SMM_PROTOCOL_GUID': [0xecb867ab, 0x8df4, 0x492d, 0x81, 0x50, 0xa7, 0xfd, 0x1b, 0x9b, 0x5a, 0x75],
    'FLASH_UPDATE_GUID': [0x974231d5, 0xed4b, 0x44d1, 0x88, 0x70, 0xce, 0x51, 0x5c, 0xc1, 0x4d, 0x68],
    'FONT_FFS_FILE_GUID': [0xdac2b117, 0xb5fb, 0x4964, 0xa3, 0x12, 0xd, 0xcc, 0x77, 0x6, 0x1b, 0x9b],
    'FPDT_PERFORMANCE_PROTOCOL_GUID': [0x444c3203, 0xf8b1, 0x42a7, 0xab, 0xe9, 0x2e, 0x58, 0x2, 0x5b, 0xe1, 0x2a],
    'FRAMEWORK_EFI_FIRMWARE_VOLUME_BLOCK_PROTOCOL_GUID': [0xDE28BC59, 0x6228, 0x41BD, 0xBD, 0xF6, 0xA3, 0xB9, 0xAD, 0xB5, 0x8D, 0xA1],
    'FW_VERSION_GUID': [0xb5c59087, 0xfeac, 0x4b41, 0x9d, 0x80, 0x79, 0xb, 0xa5, 0xaa, 0x7, 0xf],
    'FW_VOLUME_BLOCK_PROTOCOL_GUID': [0xDE28BC59, 0x6228, 0x41BD, 0xBD, 0xF6, 0xA3, 0xB9, 0xAD, 0xB5, 0x8D, 0xA1],
    'HDD_SECURITY_END_PROTOCOL_GUID': [0xad77ae29, 0x4c20, 0x4fdd, 0x85, 0x04, 0x81, 0x76, 0x61, 0x9b, 0x67, 0x6a],
    'HDD_SECURITY_INIT_PROTOCOL_GUID': [0xce6f86bb, 0xb800, 0x4c71, 0xb2, 0xd1, 0x38, 0x97, 0xa3, 0xbc, 0x1d, 0xae],
    'HDD_SMART_INIT_PROTOCOL_GUID': [0x9401bd4f, 0x1a00, 0x4990, 0xab, 0x56, 0xda, 0xf0, 0xe4, 0xe3, 0x48, 0xde],
    'HDD_UNLOCKED_GUID': [0x1fd29be6, 0x70d0, 0x42a4, 0xa6, 0xe7, 0xe5, 0xd1, 0xe, 0x6a, 0xc3, 0x76],
    'HECI_PROTOCOL_GUID': [0xcfb33810, 0x6e87, 0x4284, 0xb2, 0x3, 0xa6, 0x6a, 0xbe, 0x7, 0xf6, 0xe8],
    'HII_RESOURCES_FFS_SECTION_GUID': [0x97e409e6, 0x4cc1, 0x11d9, 0x81, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
    'HOT_PLUG_DEVICE_GUID': [0x220ac432, 0x1d43, 0x49e5, 0xa7, 0x4f, 0x4c, 0x9d, 0xa6, 0x7a, 0xd2, 0x3b],
    'ICC_OVERCLOCKING_PROTOCOL_GUID': [0x8e8cbc58, 0x834c, 0x41e3, 0xb8, 0xca, 0xf0, 0x0c, 0xcf, 0x5a, 0x71, 0x7c],
    'ICC_PERSISTENT_DATA_GUID': [0x64192dca, 0xd034, 0x49d2, 0xa6, 0xde, 0x65, 0xa8, 0x29, 0xeb, 0x4c, 0x74],
    'ICC_VOLATILE_SETUP_DATA_GUID': [0x7b77fb8b, 0x1e0d, 0x4d7e, 0x95, 0x3f, 0x39, 0x80, 0xa2, 0x61, 0xe0, 0x77],
    'IDE_BUS_DRIVER_BINDING_PROTOCOL_GUID': [0x8AA67071, 0x8BEC, 0x47AB, 0x83, 0xC8, 0xCD, 0x0E, 0xB7, 0x23, 0xD0, 0x72],
    'IDE_BUS_INIT_PROTOCOL_GUID': [0xE159A956, 0x3299, 0x4EE9, 0x91, 0x76, 0x65, 0x18, 0x1A, 0x4E, 0x5E, 0x9F],
    'IDE_CONTROLLER_PROTOCOL_GUID': [0x20E28787, 0xDF32, 0x4BDA, 0xB7, 0xE7, 0xCB, 0xBD, 0xA3, 0x37, 0x1E, 0xF8],
    'IDE_HPA_INTERFACE_GUID': [0x51AA65FC, 0x82B6, 0x49E6, 0x95, 0xE2, 0xE6, 0x82, 0x7A, 0x8D, 0x7D, 0xB4],
    'IDE_POWER_MGMT_INTERFACE_GUID': [0x67BC3883, 0x7E79, 0x4BC1, 0xA3, 0x3E, 0x3A, 0xF7, 0xD1, 0x75, 0x89, 0xBA],
    'IDE_SECURITY_INTERFACE_GUID': [0xF4F63529, 0x281E, 0x4040, 0xA3, 0x13, 0xC1, 0xD6, 0x76, 0x63, 0x84, 0xBE],
    'IDE_SECURITY_PWNV_GUID': [0x69967a8c, 0x1159, 0x4522, 0xaa, 0x89, 0x74, 0xcd, 0xc6, 0xe5, 0x99, 0xa0],
    'IDE_SETUP_PROTOCOL_GUID': [0x5578ae16, 0xf1c9, 0x4e8f, 0xb1, 0x29, 0xba, 0x7, 0xf8, 0xfc, 0xf8, 0x4a],
    'IDE_SMART_INTERFACE_GUID': [0xFFBD9AD2, 0xF1DB, 0x4F92, 0xA6, 0x49, 0xEB, 0x9E, 0xED, 0xEA, 0x86, 0xB5],
    'IFFS_ACPI_TABLE_STORAGE_GUID': [0x60ac3a8f, 0x4d66, 0x4cd4, 0x89, 0x5a, 0xc3, 0xf0, 0x6e, 0x66, 0x65, 0xee],
    'IFFS_GLOBAL_NVS_AREA_PROTOCOL_GUID': [0xa5559f06, 0x6415, 0x4759, 0x88, 0x69, 0xde, 0x15, 0xf9, 0xcd, 0x9c, 0x9b],
    'IFFS_GPT_GUID': [0xD3BFE2DE, 0x3DAF, 0x11DF, 0xba, 0x40, 0xe3, 0xa5, 0x56, 0xd8, 0x95, 0x93],
    'IFFS_INFO_PROTOCOL_GUID': [0xd231db5b, 0x4a9c, 0x4092, 0xa8, 0xc5, 0x9c, 0xa0, 0xbc, 0x7d, 0x6a, 0xa6],
    'IFFS_PARTITION_STATUS_PROTOCOL_GUID': [0x65639144, 0xd492, 0x4328, 0xa4, 0x98, 0xf4, 0xb5, 0x54, 0x5e, 0x4a, 0x30],
    'IFFS_PERSISTENT_DATA_GUID': [0xf9f0b131, 0xf346, 0x4f16, 0x80, 0xdd, 0xf9, 0x41, 0x07, 0x2b, 0x3a, 0x7d],
    'IFFS_PLATFORM_POLICY_PROTOCOL_GUID': [0x42bbaca3, 0x7161, 0x4891, 0xac, 0x10, 0xc7, 0x5e, 0x2e, 0x4d, 0xf6, 0x14],
    'IFFS_PPI_GUID': [0x3d0e663a, 0xdc72, 0x4489, 0x87, 0xc5, 0xe4, 0x9e, 0xe7, 0x73, 0xa4, 0x52],
    'IGD_OPREGION_PROTOCOL_GUID': [0xcdc5dddf, 0xe79d, 0x41ec, 0xa9, 0xb0, 0x65, 0x65, 0x49, 0xd, 0xb9, 0xd3],
    'INTEL_MEBX_PROTOCOL_GUID': [0x01ab1829, 0xcecd, 0x4cfa, 0xa1, 0x8c, 0xea, 0x75, 0xd6, 0x6f, 0x3e, 0x74],
    'LEGACY_DEV_ORDER_GUID': [0xA56074DB, 0x65FE, 0x45F7, 0xBD, 0x21, 0x2D, 0x2B, 0xDD, 0x8E, 0x96, 0x52],
    'LOAD_FILE_PROTOCOL_GUID': [0x56EC3091, 0x954C, 0x11d2, 0x8E, 0x3F, 0x00, 0xA0, 0xC9, 0x69, 0x72, 0x3B],
    'MAIN_FORM_SET_GUID': [0x985eee91, 0xbcac, 0x4238, 0x87, 0x78, 0x57, 0xef, 0xdc, 0x93, 0xf2, 0x4e],
    'MDES_STATUS_CODE_PROTOCOL_GUID': [0xe5d0875a, 0xf647, 0x4e16, 0xbe, 0x4d, 0x95, 0x02, 0x40, 0x29, 0xcc, 0x44],
    'MEBX_FILE_GUID': [0x7c81c66a, 0x4f11, 0x47ab, 0x82, 0xd3, 0x67, 0xc4, 0xd6, 0x35, 0xae, 0xd1],
    'MEMORY_ONLY_RESET_CONTROL_GUID': [0xe20939be, 0x32d4, 0x41be, 0xa1, 0x50, 0x89, 0x7f, 0x85, 0xd4, 0x98, 0x29],
    'MEM_INFO_PROTOCOL_GUID': [0x6f20f7c8, 0xe5ef, 0x4f21, 0x8d, 0x19, 0xed, 0xc5, 0xf0, 0xc4, 0x96, 0xae],
    'MEUD_ERROR_GUID': [0x732BD39, 0xD6B0, 0x4039, 0xB6, 0xC2, 0x96, 0x54, 0x46, 0x6D, 0xE5, 0x25],
    'MEUD_FILE_GUID': [0xfeaaa7a6, 0xcb95, 0x4670, 0xb4, 0x99, 0x87, 0x7f, 0xa6, 0xca, 0x6b, 0xae],
    'ME_ALERT_AT_HANDLER_GUID': [0xb441df87, 0x8d94, 0x4811, 0x85, 0xf7, 0xf, 0x9a, 0x7b, 0xf8, 0x9d, 0x2a],
    'ME_BIOS_PAYLOAD_DATA_PROTOCOL_GUID': [0x71a19494, 0x2ab6, 0x4e96, 0x85, 0x81, 0xcf, 0x34, 0x25, 0x42, 0x73, 0xfe],
    'ME_INFO_SETUP_GUID': [0x78259433, 0x7B6D, 0x4DB3, 0x9A, 0xE8, 0x36, 0xC4, 0xC2, 0xC3, 0xA1, 0x7D],
    'ME_PLATFORM_GET_RESET_TYPE_GUID': [0xb8cdced7, 0xbdc4, 0x4464, 0x9a, 0x1a, 0xff, 0x3f, 0xbd, 0xf7, 0x48, 0x69],
    'MICROCODE_LOADER_PPI_GUID': [0x9B6EECF6, 0xFBDC, 0x4db6, 0x95, 0x62, 0xD2, 0x5F, 0x40, 0xD5, 0x76, 0x61],
    'MINI_SETUP_RESOURCE_SECTION_GUID': [0x97e409e6, 0x4cc1, 0x11d9, 0x81, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
    'MXM30_PEI_GUID': [0x2ef1ba1a, 0xc836, 0x4a50, 0xbf, 0x89, 0x52, 0x5f, 0xf2, 0x9f, 0xf7, 0x87],
    'MXM3_EFI_GUID': [0x4EA9D4FE, 0xE6F6, 0x410B, 0x90, 0x37, 0x0f, 0x98, 0xB5, 0x96, 0x8B, 0x65],
    'MXMOEM1_GUID': [0x6707536e, 0x46af, 0x42d3, 0x8f, 0x6c, 0x15, 0xf2, 0xf2, 0x2, 0xc2, 0x34],
    'NBCI_EFI_GUID': [0x4EA9D4FE, 0xE6F6, 0x410B, 0x80, 0x37, 0x0F, 0x98, 0xB5, 0x96, 0x8B, 0x65],
    'NETWORK_STACK_GUID': [0xD1405D16, 0x7AFC, 0x4695, 0xBB, 0x12, 0x41, 0x45, 0x9D, 0x36, 0x95, 0xA2],
    'NVRAM_HOB_GUID': [0xc0ec00fd, 0xc2f8, 0x4e47, 0x90, 0xef, 0x9c, 0x81, 0x55, 0x28, 0x5b, 0xec],
    'NVRAM_MAILBOX_ADDRESS_VARIABLE_GUID': [0x54913a6d, 0xf4ee, 0x4cdb, 0x84, 0x75, 0x74, 0x6, 0x2b, 0xfc, 0xec, 0xf5],
    'OEM_RECOVERY_CAPSULE_GUID': [0x595a6edc, 0x6d2c, 0x474a, 0x90, 0x82, 0x3b, 0x99, 0x28, 0x51, 0xdf, 0xfe],
    'OEM_ROM_HOLE_0_GUID': [0x05ca01fc, 0x0fc1, 0x11dc, 0x90, 0x11, 0x00, 0x17, 0x31, 0x53, 0xeb, 0xa8],
    'OEM_ROM_HOLE_1_GUID': [0x05ca01fd, 0x0fc1, 0x11dc, 0x90, 0x11, 0x00, 0x17, 0x31, 0x53, 0xeb, 0xa8],
    'OEM_TSE_VAR_GUID': [0xF4B2C007, 0x94A1, 0x4cd5, 0xA7, 0x10, 0xf4, 0x14, 0x1f, 0xce, 0xbc, 0xA0],
    'ONBOARD_RAID_GUID': [0x5d206dd3, 0x516a, 0x47dc, 0xa1, 0xbc, 0x6d, 0xa2, 0x4, 0xaa, 0xbe, 0x8],
    'OPAL_SEC_INIT_PROTOCOL_GUID': [0x59af16b0, 0x661d, 0x4865, 0xa3, 0x81, 0x38, 0xde, 0x68, 0x38, 0x5d, 0x8d],
    'OPROM_START_END_PROTOCOL_GUID': [0xf2a128ff, 0x257b, 0x456e, 0x9d, 0xe8, 0x63, 0xe7, 0xc7, 0xdc, 0xdf, 0xac],
    'PARTITION_VARIABLE_GUID': [0x8db699cc, 0xbc81, 0x41e2, 0xaa, 0xc6, 0xd8, 0x1d, 0x53, 0x0, 0xd7, 0x59],
    'PASSWORD_HOB_GUID': [0x79ce097a, 0x91aa, 0x41ff, 0xb3, 0xa8, 0x53, 0x45, 0x59, 0xb3, 0x0d, 0xb1],
    'PCH_DMI_TC_VC_PPI_GUID': [0xed097352, 0x9041, 0x445a, 0x80, 0xb6, 0xb2, 0x9d, 0x50, 0x9e, 0x88, 0x45],
    'PCH_EFI_RAID_DRIVER_EXECUTION_GUID': [0x99D5757C, 0xD906, 0x11E0, 0x8D, 0x78, 0x8D, 0xE4, 0x48, 0x24, 0x01, 0x9B],
    'PCH_INIT_PPI_GUID': [0xe8c7ce14, 0x1eed, 0x48fd, 0x83, 0x47, 0x8e, 0x55, 0x41, 0x10, 0xc0, 0xd9],
    'PCH_INIT_VARIABLE_GUID': [0xe6c2f70a, 0xb604, 0x4877, 0x85, 0xba, 0xde, 0xec, 0x89, 0xe1, 0x17, 0xeb],
    'PCH_ME_UMA_PPI_GUID': [0x8c376010, 0x2400, 0x4d7d, 0xb4, 0x7b, 0x9d, 0x85, 0x1d, 0xf3, 0xc9, 0xd1],
    'PCH_PLATFORM_POLICY_PPI_GUID': [0x22074e71, 0xbccc, 0x4517, 0x87, 0x57, 0x79, 0x95, 0xed, 0xfd, 0x80, 0x32],
    'PCH_RESET_CALLBACK_PROTOCOL_GUID': [0x3a3300ab, 0xc929, 0x487d, 0xab, 0x34, 0x15, 0x9b, 0xc1, 0x35, 0x62, 0xc0],
    'PCH_RESET_PROTOCOL_GUID': [0xdb63592c, 0xb8cc, 0x44c8, 0x91, 0x8c, 0x51, 0xf5, 0x34, 0x59, 0x8a, 0x5a],
    'PCH_SATA_CONTROLLER_DRIVER_GUID': [0xbb929da9, 0x68f7, 0x4035, 0xb2, 0x2c, 0xa3, 0xbb, 0x3f, 0x23, 0xda, 0x55],
    'PCH_USB_POLICY_PPI_GUID': [0xc02b0573, 0x2b4e, 0x4a31, 0xa3, 0x1a, 0x94, 0x56, 0x7b, 0x50, 0x44, 0x2c],
    'PEI_AMT_PLATFORM_POLICY_PPI_GUID': [0xb4a1208e, 0x4d9a, 0x4ea2, 0x9d, 0x6b, 0xe4, 0x1a, 0x61, 0xe6, 0xc5, 0xac],
    'PEI_AMT_STATUS_CODE_PPI_GUID': [0x881807d2, 0x98d1, 0x4ec9, 0xaf, 0xa0, 0x77, 0x46, 0xc4, 0x2f, 0x24, 0x49],
    'PEI_AP_STARTUP_FILE_GUID': [0xD1E59F50, 0xE8C3, 0x4545, 0xBF, 0x61, 0x11, 0xF0, 0x02, 0x23, 0x3C, 0x97],
    'PEI_ATA_CONTROLLER_PPI_GUID': [0xa1e2176f, 0xcbda, 0x4f32, 0x87, 0x56, 0x7d, 0x7a, 0xe5, 0x22, 0xd6, 0x93],
    'PEI_ATA_POLICY_PPI_GUID': [0x1b8ddea4, 0xdeb2, 0x4152, 0x91, 0xc2, 0xb7, 0x3c, 0xb1, 0x6c, 0xe4, 0x64],
    'PEI_BASE_MEMORY_TEST_GUID': [0xb6ec423c, 0x21d2, 0x490d, 0x85, 0xc6, 0xdd, 0x58, 0x64, 0xea, 0xa6, 0x74],
    'PEI_BIOS_ACM_FILE_GUID': [0x2D27C618, 0x7DCD, 0x41F5, 0xBB, 0x10, 0x21, 0x16, 0x6B, 0xE7, 0xE1, 0x43],
    'PEI_BLOCK_IO_PPI_GUID': [0x695d8aa1, 0x42ee, 0x4c46, 0x80, 0x5c, 0x6e, 0xa6, 0xbc, 0xe7, 0x99, 0xe3],
    'PEI_BOOT_SCRIPT_DONE_PPI_GUID': [0xFD7C4665, 0x34BE, 0x426b, 0xB1, 0xF8, 0x3A, 0xB7, 0x53, 0xCE, 0x44, 0xB0],
    'PEI_BOOT_SCRIPT_EXECUTER_PPI_GUID': [0xabd42895, 0x78cf, 0x4872, 0x84, 0x44, 0x1b, 0x5c, 0x18, 0x0b, 0xfb, 0xff],
    'PEI_CACHE_PPI_GUID': [0x9be4bc2, 0x790e, 0x4dea, 0x8b, 0xdc, 0x38, 0x5, 0x16, 0x98, 0x39, 0x44],
    'PEI_CACHE_PPI_GUID': [0xc153205a, 0xe898, 0x4c24, 0x86, 0x89, 0xa4, 0xb4, 0xbc, 0xc5, 0xc8, 0xa2],
    'PEI_CAPSULE_PPI_GUID': [0x3acf33ee, 0xd892, 0x40f4, 0xa2, 0xfc, 0x38, 0x54, 0xd2, 0xe1, 0x32, 0x3d],
    'PEI_CPU_IO_PPI_GUID': [0xe6af1f7b, 0xfc3f, 0x46da, 0xa8, 0x28, 0xa3, 0xb4, 0x57, 0xa4, 0x42, 0x82],
    'PEI_CPU_PLATFORM_POLICY_PPI_GUID': [0x7b8ee7a1, 0x4e35, 0x4556, 0xbb, 0x56, 0x67, 0x97, 0xe2, 0x44, 0x45, 0xc2],
    'PEI_END_OF_PEI_PHASE_PPI_GUID': [0x605EA650, 0xC65C, 0x42e1, 0xBA, 0x80, 0x91, 0xA5, 0x2A, 0xB6, 0x18, 0xC6],
    'PEI_FLASH_MAP_PPI_GUID': [0xf34c2fa0, 0xde88, 0x4270, 0x84, 0x14, 0x96, 0x12, 0x22, 0xf4, 0x52, 0x1c],
    'PEI_HECI_PPI_GUID': [0xEE0EA811, 0xFBD9, 0x4777, 0xB9, 0x5A, 0xBA, 0x4F, 0x71, 0x10, 0x1F, 0x74],
    'PEI_IDE_RECOVERY_NATIVE_MODE_PPI_GUID': [0x7e13637a, 0xc3f8, 0x43d1, 0xb0, 0x51, 0xed, 0x19, 0xd7, 0x8, 0xec, 0x7a],
    'PEI_IFFS_TRANSITION_START_PPI_GUID': [0xde8f2878, 0x36d5, 0x498e, 0xba, 0x59, 0x16, 0x8c, 0x26, 0x47, 0xb3, 0x35],
    'PEI_IN_MEMORY_GUID': [0x643b8786, 0xb417, 0x48d2, 0x8f, 0x5e, 0x78, 0x19, 0x93, 0x1c, 0xae, 0xd8],
    'PEI_ME_PLATFORM_POLICY_PPI_GUID': [0x7ae3ceb7, 0x2ee2, 0x48fa, 0xaa, 0x49, 0x35, 0x10, 0xbc, 0x83, 0xca, 0xbf],
    'PEI_PCI_CFG_PPI_GUID': [0xe1f2eba0, 0xf7b9, 0x4a26, 0x86, 0x20, 0x13, 0x12, 0x21, 0x64, 0x2a, 0x90],
    'PEI_PERMANENT_MEMORY_INSTALLED_PPI_GUID': [0xf894643d, 0xc449, 0x42d1, 0x8e, 0xa8, 0x85, 0xbd, 0xd8, 0xc6, 0x5b, 0xde],
    'PEI_PLATFORM_MEMORY_RANGE_PPI_GUID': [0x30eb2979, 0xb0f7, 0x4d60, 0xb2, 0xdc, 0x1a, 0x2c, 0x96, 0xce, 0xb1, 0xf4],
    'PEI_PLATFORM_MEMORY_SIZE_PPI_GUID': [0x9a7ef41e, 0xc140, 0x4bd1, 0xb8, 0x84, 0x1e, 0x11, 0x24, 0xb, 0x4c, 0xe6],
    'PEI_READ_ONLY_VARIABLE_ACCESS_PPI_GUID': [0x3cdc90c6, 0x13fb, 0x4a75, 0x9e, 0x79, 0x59, 0xe9, 0xdd, 0x78, 0xb9, 0xfa],
    'PEI_RESET_PPI_GUID': [0xef398d58, 0x9dfd, 0x4103, 0xbf, 0x94, 0x78, 0xc6, 0xf4, 0xfe, 0x71, 0x2f],
    'PEI_S3_RESUME_PPI_GUID': [0x4426CCB2, 0xE684, 0x4a8a, 0xAE, 0x40, 0x20, 0xD4, 0xB0, 0x25, 0xB7, 0x10],
    'PEI_SECURITY_PPI_GUID': [0x1388066e, 0x3a57, 0x4efa, 0x98, 0xf3, 0xc1, 0x2f, 0x3a, 0x95, 0x8a, 0x29],
    'PEI_SMBUS2_PPI_GUID': [0x9ca93627, 0xb65b, 0x4324, 0xa2, 0x2, 0xc0, 0xb4, 0x61, 0x76, 0x45, 0x43],
    'PEI_SMBUS_POLICY_PPI_GUID': [0x63b6e435, 0x32bc, 0x49c6, 0x81, 0xbd, 0xb7, 0xa1, 0xa0, 0xfe, 0x1a, 0x6c],
    'PEI_SMBUS_PPI_GUID': [0xabd42895, 0x78cf, 0x4872, 0x84, 0x44, 0x1b, 0x5c, 0x18, 0xb, 0xfb, 0xda],
    'PEI_SMM_ACCESS_PPI_GUID': [0x268f33a9, 0xcccd, 0x48be, 0x88, 0x17, 0x86, 0x5, 0x3a, 0xc3, 0x2e, 0xd6],
    'PEI_SMM_CONTROL_PPI_GUID': [0x61c68702, 0x4d7e, 0x4f43, 0x8d, 0xef, 0xa7, 0x43, 0x5, 0xce, 0x74, 0xc5],
    'PEI_SPI_PPI_GUID': [0x64e42e92, 0xe958, 0x4e99, 0x90, 0xe2, 0xf7, 0xfd, 0x90, 0xa7, 0x6c, 0x59],
    'PEI_STALL_PPI_GUID': [0x1f4c6f90, 0xb06b, 0x48d8, 0xa2, 0x01, 0xba, 0xe5, 0xf1, 0xcd, 0x7d, 0x56],
    'PEI_STATUS_CODE_MEMORY_PPI_GUID': [0x26f8ab01, 0xd3cd, 0x489c, 0x98, 0x4f, 0xdf, 0xde, 0xf7, 0x68, 0x39, 0x5b],
    'PEI_STATUS_CODE_PPI_GUID': [0x229832d3, 0x7a30, 0x4b36, 0xb8, 0x27, 0xf4, 0xc, 0xb7, 0xd4, 0x54, 0x36],
    'PEI_TCG_INTERNAL_FLAGS_GUID': [0x70fff0ff, 0xa543, 0x45b9, 0x8b, 0xe3, 0x1b, 0xdb, 0x90, 0x41, 0x20, 0x80],
    'PEI_TCG_PPI_GUID': [0x177d39d2, 0x43b8, 0x40c8, 0x9a, 0xe1, 0x3c, 0x51, 0x98, 0xd6, 0x94, 0x1e],
    'PEI_TPM_INITIALIZED_PPI_GUID': [0xe9db0d58, 0xd48d, 0x47f6, 0x9c, 0x6e, 0x6f, 0x40, 0xe8, 0x6c, 0x7b, 0x41],
    'PEI_TPM_PPI_2_GUID': [0xca4853f4, 0xe94b, 0x42b4, 0x86, 0x42, 0xcd, 0xe2, 0x8a, 0x7f, 0xac, 0x2d],
    'PEI_TPM_PPI_GUID': [0xca4853f4, 0xe94b, 0x42b4, 0x86, 0x42, 0xcd, 0xe2, 0x8a, 0x7f, 0xac, 0x2d],
    'PEI_TPM_PPI_GUID': [0xe9db0d58, 0xd48d, 0x47f6, 0x9c, 0x6e, 0x6f, 0x40, 0xe8, 0x6c, 0x7b, 0x41],
    'PEI_TXT_MEMORY_UNLOCKED_PPI_GUID': [0x38cdd10b, 0x767d, 0x4f6e, 0xa7, 0x44, 0x67, 0xee, 0x1d, 0xfe, 0x2f, 0xa5],
    'PEI_USB_CONTROLLER_PPI_GUID': [0x3bc1f6de, 0x693e, 0x4547, 0xa3, 0x0, 0x21, 0x82, 0x3c, 0xa4, 0x20, 0xb2],
    'PERF_TUNE_PPI_GUID': [0xc49189f3, 0x1d4c, 0x4ad7, 0xa4, 0x39, 0xd0, 0x13, 0xab, 0x72, 0x09, 0x31],
    'PERF_TUNE_PROTOCOL_GUID': [0xdd6c613a, 0x5a77, 0x4b4f, 0xa6, 0x1e, 0x3b, 0xdd, 0x2a, 0xe2, 0x1d, 0x81],
    'PERF_TUNE_WDT_PPI_GUID': [0xa7c88fae, 0xebec, 0x45ed, 0xa7, 0xc5, 0x5f, 0xa7, 0x55, 0x17, 0x73, 0x06],
    'PERF_TUNE_WDT_PROTOCOL_GUID': [0xc0557eed, 0x9a89, 0x4770, 0x96, 0x26, 0xfc, 0xa0, 0x51, 0xf2, 0xba, 0x09],
    'PKPUB_KEY_GUID': [0xa6c0e11e, 0x929e, 0x42b3, 0x90, 0xcc, 0x4f, 0x77, 0x8e, 0x3, 0xff, 0x57],
    'PK_PUB_FFS_FILE_EFI_AUTH_VAR_GUID': [0x9E625A27, 0x4840, 0x47CC, 0xA6, 0xB5, 0x1E, 0x93, 0x11, 0xCF, 0xC6, 0x0E],
    'PLATFORM_IDE_PROTOCOL_GUID': [0x6737f69b, 0xb8cc, 0x45bc, 0x93, 0x27, 0xcc, 0xf5, 0xee, 0xf7, 0xc, 0xde],
    'PLATFORM_ME_HOOK_PPI_GUID': [0xe806424f, 0xd425, 0x4b1a, 0xbc, 0x26, 0x5f, 0x69, 0x03, 0x89, 0xa1, 0x5a],
    'PLATFORM_ME_HOOK_PROTOCOL_GUID': [0xbc52476e, 0xf67e, 0x4301, 0xb2, 0x62, 0x36, 0x9c, 0x48, 0x78, 0xaa, 0xc2],
    'POWER_MANAGEMENT_ACPI_TABLE_STORAGE_GUID': [0x299141bb, 0x211a, 0x48a5, 0x92, 0xc0, 0x6f, 0x9a, 0xa, 0x3a, 0x0, 0x6e],
    'PPM_PLATFORM_POLICY_PROTOCOL_GUID': [0x6f27e990, 0x7bc8, 0x42c9, 0x8f, 0x71, 0x99, 0x80, 0x6, 0x36, 0x93, 0xe9],
    'PPM_PROCESSOR_SUPPORT_PROTOCOL_3_GUID': [0xa60c7dcd, 0x512f, 0x4f02, 0xb1, 0x80, 0x52, 0x2e, 0x1, 0x5e, 0x6, 0xb7],
    'PR_KEY_FFS_FILE_RAW_GUID': [0x3FEEC852, 0xF14C, 0x4E7F, 0x97, 0xFD, 0x4C, 0x3A, 0x8C, 0x5B, 0xBE, 0xCC],
    'PR_KEY_GUID': [0x4E0F9BD4, 0xE338, 0x4B26, 0x84, 0x3E, 0xBD, 0x3A, 0xD9, 0xB2, 0x83, 0x7B],
    'PTID_FFS_TABLE_STORAGE_GUID': [0x95DFCAE5, 0xBB28, 0x4d6b, 0xB1, 0xE2, 0x3A, 0xF3, 0xA6, 0xBF, 0x43, 0x4F],
    'RECOVERY_FORM_SET_GUID': [0x80e1202e, 0x2697, 0x4264, 0x9c, 0xc9, 0x80, 0x76, 0x2c, 0x3e, 0x58, 0x63],
    'ROM_CACHE_ENABLE_PPI_GUID': [0x36E835BB, 0x661D, 0x4D37, 0x8D, 0xE5, 0x88, 0x53, 0x25, 0xDA, 0xE9, 0x10],
    'ROM_IMAGE_ADDRESS_GUID': [0xDDE1BC72, 0xD45E, 0x4209, 0xAB, 0x85, 0x14, 0x46, 0x2D, 0x2F, 0x50, 0x74],
    'ROM_IMAGE_MEMORY_HOB_GUID': [0xee2f45d2, 0x5ba4, 0x441e, 0x8a, 0x1d, 0xaa, 0x22, 0xdf, 0xa3, 0xb6, 0xc5],
    'ROM_LAYOUT_FFS_GUID': [0x0DCA793A, 0xEA96, 0x42d8, 0xBD, 0x7B, 0xDC, 0x7F, 0x68, 0x4E, 0x38, 0xC1],
    'ROM_LAYOUT_SECTION_GUID': [0x88A15A4F, 0x977D, 0x4682, 0xB1, 0x7C, 0xDA, 0x1F, 0x31, 0x6C, 0x1F, 0x32],
    'RSDP_PLUS_PROTOCOL_GUID': [0xa33319b5, 0x8ee1, 0x45e0, 0x8c, 0x9f, 0x80, 0x9f, 0x5b, 0x9, 0x2, 0xcc],
    'SATA_CONTROLLER_PROTOCOL_GUID': [0x2acb6627, 0xdf02, 0x4e23, 0xb4, 0xf9, 0x6a, 0x93, 0xfa, 0x6e, 0x9d, 0xa6],
    'SA_PEG_DATA_HOB_GUID': [0x5f5d3502, 0x8a4b, 0x40ca, 0x88, 0xa2, 0x23, 0x05, 0x42, 0x7a, 0x13, 0x1a],
    'SA_PEG_DATA_VARIABLE_GUID': [0xc4975200, 0x64f1, 0x4fb6, 0x97, 0x73, 0xf6, 0xa9, 0xf8, 0x9d, 0x98, 0x5e],
    'SA_PEI_INIT_PPI_GUID': [0x9ea8911, 0xbe0d, 0x4230, 0xa0, 0x3, 0xed, 0xc6, 0x93, 0xb4, 0x8e, 0x11],
    'SA_PLATFORM_POLICY_PPI_GUID': [0x150ce416, 0xee63, 0x46b6, 0x8B, 0xA3, 0x73, 0x22, 0xBB, 0xE0, 0x46, 0x37],
    'SECURITY_FORM_SET_GUID': [0x981ceaee, 0x931c, 0x4a17, 0xb9, 0xc8, 0x66, 0xc7, 0xbc, 0xfd, 0x77, 0xe1],
    'SERIAL_RECOVERY_CAPSULE_GUID': [0x699add70, 0x8554, 0x4993, 0x83, 0xf6, 0xd2, 0xcd, 0xc0, 0x81, 0xdd, 0x85],
    'SETUP_DEFAULTS_FFS_GUID': [0x9221315b, 0x30bb, 0x46b5, 0x81, 0x3e, 0x1b, 0x1b, 0xf4, 0x71, 0x2b, 0xd3],
    'SETUP_GUID': [0xEC87D643, 0xEBA4, 0x4BB5, 0xA1, 0xE5, 0x3F, 0x3E, 0x36, 0xB2, 0x0D, 0xA9],
    'SGOEM_ACPI_SSDT_GUID': [0x5B232086, 0x350A, 0x42c7, 0xA7, 0x0E, 0x34, 0x97, 0xB5, 0x76, 0x5D, 0x85],
    'SGTPV_ACPI_SSDT_GUID': [0x6A061113, 0xFE54, 0x4A07, 0xA2, 0x8E, 0x0A, 0x69, 0x35, 0x9E, 0xB0, 0x69],
    'SG_ACPI_TABLE_STORAGE_GUID': [0xcacb3817, 0x81e6, 0x497e, 0x87, 0xff, 0xc8, 0xfa, 0x8f, 0x24, 0xec, 0x28],
    'SG_INFO_HOB_GUID': [0x648ce07b, 0xae5d, 0x4973, 0xbd, 0x3c, 0x8c, 0x91, 0x53, 0xc0, 0x5d, 0xc5],
    'SG_PEI_INIT_PPI_GUID': [0xaa40d00e, 0x5b9b, 0x4dad, 0xa4, 0x87, 0xfc, 0x1b, 0xcb, 0xef, 0x81, 0x70],
    'SG_PLATFORM_POLICY_PPI_GUID': [0xa391e822, 0x7044, 0x4cf4, 0xbe, 0x5b, 0x34, 0x5e, 0x44, 0xb8, 0x62, 0x7c],
    'SIO_DEV_STATUS_VAR_GUID': [0x5820de98, 0xfc8e, 0x4b0b, 0xa4, 0xb9, 0xa, 0x94, 0xd, 0x16, 0x2a, 0x7e],
    'SIO_IO_PROTOCOL_GUID': [0x964e5b21, 0x6000, 0x23d2, 0x9e, 0x39, 0x1, 0xa0, 0xc9, 0x69, 0x72, 0x3b],
    'SMBIOS_FLASH_DATA_FFS_GUID': [0xFD44820B, 0xF1AB, 0x41C0, 0xAE, 0x4E, 0x0C, 0x55, 0x55, 0x6E, 0xB9, 0xBD],
    'SMM_CHILD_DISPATCHER2_GUID': [0x950c3a26, 0xe0c2, 0x491c, 0xb6, 0xb2, 0x3, 0x74, 0xf5, 0xc7, 0x3b, 0x96],
    'SMM_COMMUNICATE_HEADER_GUID': [0xF328E36C, 0x23B6, 0x4a95, 0x85, 0x4B, 0x32, 0xE1, 0x95, 0x34, 0xCD, 0x75],
    'SMM_HECI_PROTOCOL_GUID': [0xFC9A50C1, 0x8B3D, 0x40D0, 0x99, 0x12, 0x6E, 0x26, 0xD7, 0x89, 0x6C, 0xBA],
    'SMRAM_CPU_DATA_HEADER_GUID': [0x5848fd2d, 0xd6af, 0x474b, 0x82, 0x75, 0x95, 0xdd, 0xe7, 0x0a, 0xe8, 0x23],
    'SMRAM_CPU_DATA_VARIABLE_GUID': [0x429501d9, 0xe447, 0x40f4, 0x86, 0x7b, 0x75, 0xc9, 0x3a, 0x1d, 0xb5, 0x4e],
    'SM_BUS_CONTROLLER_IDENTIFIER_GUID': [0x882f2546, 0xef1f, 0x4090, 0x9f, 0x9c, 0x93, 0x84, 0x5a, 0xd7, 0x84, 0x1c],
    'SYSTEM_ACCESS_GUID': [0xE770BB69, 0xBCB4, 0x4D04, 0x9E, 0x97, 0x23, 0xFF, 0x94, 0x56, 0xFE, 0xAC],
    'TCG_EFI_ACPI_TABLE_GUID': [0xeb9d2d30, 0x2d88, 0x11d3, 0x9a, 0x16, 0x0, 0x90, 0x27, 0x3f, 0xc1, 0x4d],
    'TCG_EFI_HOB_LIST_GUID': [0x7739f24c, 0x93d7, 0x11d4, 0x9a, 0x3a, 0x0, 0x90, 0x27, 0x3f, 0xc1, 0x4d],
    'TCG_INTERNAL_FLAGS_GUID': [0x70fff0ff, 0xa543, 0x45b9, 0x8b, 0xe3, 0x1b, 0xdb, 0x90, 0x41, 0x20, 0x80],
    'TCG_LOCK_DOWN_VAR_GUID': [0x6e605536, 0xa30a, 0x4d56, 0x93, 0x9e, 0x1c, 0x37, 0x3f, 0x79, 0x8d, 0x7b],
    'TCG_PLATFORM_SETUP_PEI_POLICY_GUID': [0xa76b4e22, 0xb50a, 0x401d, 0x8b, 0x35, 0x51, 0x24, 0xb0, 0xba, 0x41, 0x4],
    'TCG_PLATFORM_SETUP_POLICY_GUID': [0xbb6cbeff, 0xe072, 0x40d2, 0xa6, 0xeb, 0xba, 0xb7, 0x5b, 0xde, 0x87, 0xe7],
    'TCG_PPI_SYNC_FLAG_GUID': [0xf3ed95df, 0x828e, 0x41c7, 0xbc, 0xa0, 0x16, 0xc4, 0x19, 0x65, 0xa6, 0x34],
    'TDTHI_PROTOCOL_FIXED_GUID': [0xfa8f55e8, 0xab22, 0x42dd, 0xb9, 0x16, 0x7d, 0xce, 0x39, 0x00, 0x25, 0x74],
    'TDTHI_PROTOCOL_GUID': [0x3C4852D6, 0xD47B, 0x4f46, 0xB0, 0x5E, 0xB5, 0xED, 0xC1, 0xAA, 0x43, 0x0A],
    'TDT_VOLATILE_SETUP_DATA_GUID': [0x7b77fb8b, 0x1e0d, 0x4d7e, 0x95, 0x3f, 0x39, 0x80, 0xa2, 0x61, 0xe0, 0x76],
    'TEMPORARY_RAM_SUPPORT_PPI_GUID': [0xdbe23aa9, 0xa345, 0x4b97, 0x85, 0xb6, 0xb2, 0x26, 0xf1, 0x61, 0x73, 0x89],
    'TERMINAL_VAR_GUID': [0x560bf58a, 0x1e0d, 0x4d7e, 0x95, 0x3f, 0x29, 0x80, 0xa2, 0x61, 0xe0, 0x31],
    'TPM_BOOT_FLOW_VARIABLE_GUID': [0xb6460a49, 0x0ac1, 0x484f, 0xae, 0x58, 0xf1, 0x6e, 0xb2, 0x39, 0xdb, 0x3d],
    'TXT_INFO_HOB_GUID': [0x2986883F, 0x88E0, 0x48d0, 0x4B, 0x82, 0x20, 0xC2, 0x69, 0x48, 0xDD, 0xAC],
    'TXT_ONE_TOUCH_GUID': [0x3D989471, 0xCFAC, 0x46B7, 0x9B, 0x1C, 0x8, 0x43, 0x1, 0x9, 0x40, 0x2D],
    'TXT_ONE_TOUCH_OP_PROTOCOL_GUID': [0xFA2338AD, 0x80DF, 0x49D0, 0x93, 0x96, 0xCF, 0x71, 0x45, 0xD0, 0x3A, 0x76],
    'UNKNOWN_DEVICE_GUID': [0xcf31fac5, 0xc24e, 0x11d2, 0x85, 0xf3, 0x0, 0xa0, 0xc9, 0x3e, 0xc9, 0x3b],
    'USB_TIMING_POLICY_PROTOCOL_GUID': [0x89e3c1dc, 0xb5e3, 0x4d34, 0xae, 0xad, 0xdd, 0x7e, 0xb2, 0x82, 0x8c, 0x18],
    'USER_DEFAULTS_GUID': [0xC4CC0DE8, 0x0687, 0x4422, 0x99, 0xC1, 0x65, 0x35, 0x1A, 0x5D, 0x5F, 0x95],
    'WDT_APP_PROTOCOL_GUID': [0x92c7d0bb, 0x679e, 0x479d, 0x87, 0x8d, 0xd4, 0xb8, 0x29, 0x68, 0x57, 0x8b],
    'WDT_HOB_GUID': [0x65675786, 0xacca, 0x4b11, 0x8a, 0xb7, 0xf8, 0x43, 0xaa, 0x2a, 0x8b, 0xea],
    'WDT_PERSISTENT_DATA_GUID': [0x78ce2354, 0xcfbc, 0x4643, 0xae, 0xba, 0x7, 0xa2, 0x7f, 0xa8, 0x92, 0xbf],
    'WDT_PPI_GUID': [0xF38D1338, 0xAF7A, 0x4FB6, 0x91, 0xDB, 0x1A, 0x9C, 0x21, 0x83, 0x57, 0x0D],
    'WDT_PROTOCOL_GUID': [0xB42B8D12, 0x2ACB, 0x499a, 0xA9, 0x20, 0xDD, 0x5B, 0xE6, 0xCF, 0x09, 0xB1],
}
