# Tests

Voltron has a bunch of test suites built for various parts of the codebase. To run them, you'll need to install the `nose` module.

    $ pip install nose

Change into the repo directory and run the tests:

    $ nosetests -sv

Some of the tests are quite dependent on timing as there's a lot of restarting of the debugger hosts and rebinding of sockets going on, so sometimes tests will fail for no apparent reason with a "Connection failed" error or similar. This usually isn't really indicative of a problem, just run them again and they'll probably work OK. That's what happens when you stick random `time.sleep()` calls in there to wait for GDB to start up.

You can also try running just that suite on its own, e.g.:

    $ nosetests -sv tests/gdb_cli_tests.py

That will have a much better chance of success.