/* This file is part of the Chakra project

   Copyright (C) 2010 Dario Freddi <drf@chakra-project.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
*/

#ifndef AKABEICORE_GLOBAL_H
#define AKABEICORE_GLOBAL_H

#include <qglobal.h>
#include <QUrl>
#include <QString>

#if defined(AKABEICORE_LIBRARY)
#  define AKABEICORESHARED_EXPORT Q_DECL_EXPORT
#else
#  define AKABEICORESHARED_EXPORT Q_DECL_IMPORT
#endif

// Define column numbers

namespace Akabei {

/*
 * I don't think this namespace is necessary anymore
 * (now you can provide the column name to retrieve data)
 */
namespace Tables {

namespace Packages {
    enum Columns {
        ID,
        NAME,
        VERSION,
        FILENAME,
        DESCRIPTION,
        GROUPS,
        SIZE,
        INSTALLEDSIZE,
        MD5SUM,
        URL,
        BUILDDATE,
        ARCH,
        PACKAGER,
        BACKUP,
        LICENSE,
        PROVIDESMIMETYPE,
        FLAGS,
        SCREENSHOTURL,
        INSTALLREASON,
        INSTALLDATE
    };
}

namespace Depends {
    enum Columns {
        PACKAGE,
        DEPENDENCY
    };
}

namespace Conflicts {
    enum Columns {
        PACKAGE,
        CONFLICT
    };
}

namespace Provides {
    enum Columns {
        PACKAGE,
        PROVIDES
    };
}

namespace Optional {
    enum Columns {
        PACKAGE,
        DEPENDENCY
    };
}

namespace Replaces {
    enum Columns {
        PACKAGE,
        REPLACES
    };
}

namespace Belongs {
    enum Columns {
        PACKAGE,
        GROUP
    };
}

namespace Deltas {
    enum Columns {
        ID,
        PACKAGE,
        FILENAME,
        VERSIONFROM,
        VERSIONTO,
        MD5SUM
    };
}

namespace Groups {
    enum Columns {
        ID,
        NAME,
        DESCRIPTION,
        ICONNAME
    };
}

namespace Hooks {
    const int NAME = 0;
    const int HOOK = 1;
    const int PACKAGES = 2;
}

}

const QUrl DEFAULT_DATABASE_DIR(QLatin1String("/var/lib/akabei"));
const QUrl DEFAULT_CACHE_DIR(QLatin1String("/var/cache/akabei/pkg"));

const QString errorPrefix = QLatin1String(":: ");
const QString packageExtension = QLatin1String(".tar.xz");
const QString signatureExtension = QLatin1String(".sig");

enum ProcessingOption
{
    NoProcessingOption = 0x000,
    InstallOptionalDependencies = 0x001,
    SkipDependencies = 0x002,
    Force = 0x004,
    DownloadOnly = 0x008,
    InstallAsDependencies = 0x010,
    InstallAsExplicit = 0x020,
    RemoveConfigs = 0x040,
    DatabaseOnly = 0x080,
    Recursive = 0x100
};
Q_DECLARE_FLAGS(ProcessingOptions, ProcessingOption)

/**
 * \enum SearchType
 * Describes the type of search the backend is going to do
 */
enum SearchType {
    SearchNameLike = 0,
    SearchNameEqual = 1,
    SearchDescriptionLike = 2,
    SearchDescriptionEqual = 3,
    SearchNameAndDescriptionLike = 4,
    SearchNameAndDescriptionEqual = 5
};

}

Q_DECLARE_OPERATORS_FOR_FLAGS(Akabei::ProcessingOptions)

#endif // AKABEICORE_GLOBAL_H
