/* This file is part of the Chakra project

   Copyright (C) 2012 Lukas Appelhans <l.appelhans@gmx.de>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
*/
#ifndef AKABEIDEBUG_H
#define AKABEIDEBUG_H

#include <QDebug>
#include <QMessageLogContext>
#include <akabeicore_global.h>

/**
 * Akabei Qt message handler (for qDebug(), qWarning(), ...)
 */
void akabeiDebug(QtMsgType, const QMessageLogContext &, const QString &);

/*
 * This is a workaround to avoid changing all the akabeiDebug() calls back into qDebug() calls
 */
QDebug akabeiDebug();

#endif
