/* This file is part of the Chakra project

   Copyright (C) 2010 Dario Freddi <drf@chakra-project.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
*/

#ifndef AKABEI_AKABEIGROUP_H
#define AKABEI_AKABEIGROUP_H

#include <QObject>

#include <akabeicore_global.h>

namespace Akabei {

class Database;
class Package;

class GroupPrivate;
/**
 * \class Group  akabeigroup.h "akabeigroup.h"
 *
 * \brief This class describes a group of packages.
 *
 * Groups are usually loaded from a Database or from a \link Akabei::Backend .group-file \endlink.
 *
 * This class is thread-safe.
 */
class AKABEICORESHARED_EXPORT Group
{
    Q_DISABLE_COPY(Group)
    Q_DECLARE_PRIVATE(Group)

public:
    typedef QList<Group *> List;
    virtual ~Group();

    /**
     * @returns the name of the group
     */
    QString name() const;
    /**
      * @returns a brief description of the group
      */
    QString description() const;
    /**
      * @returns the icon name of the group (see: http://standards.freedesktop.org/icon-naming-spec/icon-naming-spec-latest.html)
      */
    QString iconName() const;

    /**
      * @returns a list of packages which are in this group
      */
    QList<Package*> packages() const;
    /**
      * @returns a list of packages which match the given token in either the name or the description
      */
    QList<Package*> search(const QString &token) const;

private:
    Group(const QString &name);

    GroupPrivate * const d_ptr;

    friend class GroupPool;
    friend class DatabasePrivate;
    friend class Backend;
};

}

#endif // AKABEI_AKABEIGROUP_H
