/*
 * Libarchive interface: entry wrapper

   Copyright (C) 2011 Lisa Vitolo <shainer@chakra-project.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
*/

#ifndef ARCHIVEENTRY_H
#define ARCHIVEENTRY_H

#include <archive_entry.h>

/**
 * \class ArchiveEntry
 * \brief Describes an archive file.
 */
class ArchiveEntry {
    struct archive_entry* entry;
    mode_t fileMode;
    size_t fileSize;
    QString fileName;

    ArchiveEntry& operator=(ArchiveEntry const& other);

public:
    /**
     * Creates a new ArchiveEntry object from the archive_entry read.
     * @param ptr The struct to read data from.
     * @throw ArchiveException If something unexpected happened.
     * @author jmc
     */
    ArchiveEntry(archive_entry *);

    /**
     * Creates a new ArchiveEntry's data with another one's data.
     * @param other The other ArchiveEntry from which to copy data from.
     * @throw ArchiveException If the copying has no success.
     * @author jmc
     */
    ArchiveEntry(ArchiveEntry const& other);

    virtual ~ArchiveEntry();

    /**
     * Returns the wrapped struct archive_entry*.
     * @return The pointer to the wrapped struct archive_entry*.
     * @author jmc
     */
    struct archive_entry* getEntry() const;

    /**
     * Returns the entry file name.
     * @return The file name associated with this entry.
     * @author jmc
     */
    QString getFileName() const;

    /**
     * Returns the entry file size.
     * @return The file size associated with this entry.
     * @author jmc
     */
    size_t getFileSize() const;

    /**
     * Tells if the entry is a symlink.
     * @return A boolean indicating if it is a symlink or not.
     * @author shainer
     */
    bool isSymlink() const;

    /**
     * Tells if the entry is a directory.
     * @return A boolean indicating if it is a directory or not.
     * @author shainer
     */
    bool isDirectory() const;
};

#endif