/*
 * Contains methods useful for some operations

   Copyright (C) 2011 Lisa Vitolo <shainer@chakra-project.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
*/

#ifndef AKABEIOPERATIONUTILS_H
#define AKABEIOPERATIONUTILS_H

#include <QString>
#include <QStringList>

#include <akabeipackage.h>
#include <akabeiconfig.h>

class OperationUtils
{
public:
    OperationUtils();
    
    bool validatePackage(Akabei::Package *);
    bool isFileToExtract(QString &);
    QString getExtractionPath(QString &);
    
    QString errorMessage();
    QStringList messages();
    
private:
    QString m_errorMessage;
    QStringList m_noupgrade; /* takes the NoUpgrade list from configuration */
    QStringList m_noextract; /* takes the NoExtract list from configuration */
    QStringList m_messages;
};

#endif