/* This file is part of the Chakra project

   Copyright (C) 2011 Lukas Appelhans

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
*/
#ifndef AKABEIPLAINHOOKOPERATION_H
#define AKABEIPLAINHOOKOPERATION_H

#include <akabeioperation.h>
#include <QStringList>
#include <akabeihook.h>

namespace Akabei {
class Database;
class AKABEICORESHARED_EXPORT PlainHookOperation : public Operation
{
    Q_OBJECT
    public:
        virtual ~PlainHookOperation();

        static PlainHookOperation * instance();

        void add(Hook* hook, const QString &arg);
        void add(const QList<Hook*> &hooks, const QString &arg);

    protected:
        virtual void run() override;
        virtual void validate() override;

    private:
        PlainHookOperation();
        class Private;
        Private * const d;

        friend class ChrootedProcess;

        Q_PRIVATE_SLOT(d, void slotErrors(Akabei::Error::List))
        Q_PRIVATE_SLOT(d, void slotFinished(bool))
        Q_PRIVATE_SLOT(d, void slotMessage(QString))
};
}

#endif // AKABEIPLAINHOOKOPERATION_H
