/* This file is part of the Chakra project

   Copyright (C) 2010 Dario Freddi <drf@chakra-project.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
*/

#ifndef AKABEIPLAININSTALLOPERATION_H
#define AKABEIPLAININSTALLOPERATION_H

#include <akabeicore_global.h>
#include <akabeioperation.h>
#include <akabeipackage.h>

namespace Akabei {

class Package;

//TODO: We need error handling (existing files etc) and also custom InstallReasons
class AKABEICORESHARED_EXPORT PlainInstallOperation : public Operation
{
    Q_DISABLE_COPY(PlainInstallOperation)
public:
    explicit PlainInstallOperation(Package *package, Akabei::Package::InstallReason installReason);
    virtual ~PlainInstallOperation();

protected:
    void validate() override;
    void run() override;

private:
    class Private;
    Private * const d;

};

}

#endif // AKABEIPLAININSTALLOPERATION_H
