/* This file is part of the Chakra project

   Copyright (C) 2010 Dario Freddi <drf@chakra-project.org>
   Copyright (C) 2011 Lukas Appelhans <l.appelhans@gmx.de>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
*/


#ifndef AKABEIPLAINREINSTALLOPERATION_H
#define AKABEIPLAINREINSTALLOPERATION_H

#include <akabeioperation.h>
#include <akabeicore_global.h>

namespace Akabei {
class Package;
class AKABEICORESHARED_EXPORT PlainReInstallOperation : public Operation
{
    Q_DISABLE_COPY(PlainReInstallOperation)
public:
    PlainReInstallOperation(Package * package, Package * localPackage);
    virtual ~PlainReInstallOperation();

protected:
    virtual void run() override;
    virtual void validate() override;

private:
    class Private;
    Private * const d;
};
}

#endif // AKABEIPLAINREINSTALLOPERATION_H
