/* This file is part of the Chakra project

   Copyright (C) 2015 Lukas Appelhans <l.appelhans@gmx.de>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
*/

#ifndef AKABEIPLAINREPLACEOPERATION_H
#define AKABEIPLAINREPLACEOPERATION_H

#include <akabeicore_global.h>
#include <akabeioperation.h>
#include <akabeipackage.h>

namespace Akabei {

class Package;

//TODO: We need error handling (existing files etc) and also custom InstallReasons
class AKABEICORESHARED_EXPORT PlainReplaceOperation : public Operation
{
    Q_DISABLE_COPY(PlainReplaceOperation)
public:
    explicit PlainReplaceOperation(Package *package, const QList<Package*> &replaces);
    virtual ~PlainReplaceOperation();

protected:
    void validate();
    void run();

private:
    class Private;
    Private * const d;
};

}

#endif // AKABEIPLAININSTALLOPERATION_H
