/* This file is part of the Chakra project

   Copyright (C) 2010 Dario Freddi <drf@chakra-project.org>
   Copyright (C) 2013 Lukas Appelhans <boom1992@chakra-project.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
*/

#ifndef AKABEIPOLKITINSTALLOPERATION_H
#define AKABEIPOLKITINSTALLOPERATION_H

#include <akabeicore_global.h>
#include <akabeioperation.h>
#include <akabeipackage.h>

namespace Akabei {

class Package;

/**
 * @class PolkitInstakkOperation
 * @brief Operation to install a package from the system using polkit.
 */
class AKABEICORESHARED_EXPORT PolkitInstallOperation : public Operation
{
    Q_OBJECT
    Q_DISABLE_COPY(PolkitInstallOperation)
public:
    explicit PolkitInstallOperation(Package *package, Akabei::Package::InstallReason installReason);
    virtual ~PolkitInstallOperation();

protected:
    void validate() override;
    void run() override;

private:
    class Private;
    Private * const d;

    Q_PRIVATE_SLOT(d, void __k__installFinished(QString, bool))
    Q_PRIVATE_SLOT(d, void __k__installProgress(QString, int))
    Q_PRIVATE_SLOT(d, void __k__installMessage(QString, QString))
    Q_PRIVATE_SLOT(d, void __k__error(QString, int, QString))
};

}

#endif // AKABEIPOLKITINSTALLOPERATION_H
