/* This file is part of the Chakra project

   Copyright (C) 2010 Dario Freddi <drf@chakra-project.org>
   Copyright (C) 2013 Lukas Appelhans <boom1992@chakra-project.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
*/

#ifndef AKABEIPOLKITREMOVEOPERATION_H
#define AKABEIPOLKITREMOVEOPERATION_H

#include <akabeicore_global.h>
#include <akabeioperation.h>
#include <akabeipackage.h>

namespace Akabei {

class Package;

/**
 * @class PolkitRemoveOperation
 * @brief Operation to remove a package from the system using polkit.
 */
class AKABEICORESHARED_EXPORT PolkitRemoveOperation : public Operation
{
    Q_OBJECT
    Q_DISABLE_COPY(PolkitRemoveOperation)
public:
    explicit PolkitRemoveOperation(Package *package);
    virtual ~PolkitRemoveOperation();

protected:
    void validate() override;
    void run() override;

private:
    class Private;
    Private * const d;
    
    Q_PRIVATE_SLOT(d, void __k__removalFinished())
    Q_PRIVATE_SLOT(d, void __k__removalProgress(int))
    Q_PRIVATE_SLOT(d, void __k__removalErrors(QStringList))
};

}

#endif // AKABEIPOLKITREMOVEOPERATION_H
