/* This file is part of the Chakra project

   Copyright (C) 2010 Dario Freddi <drf@chakra-project.org>
   Copyright (C) 2013 Lukas Appelhans <boom1992@chakra-project.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
*/

#ifndef AKABEIPOLKITREPLACEOPERATION_H
#define AKABEIPOLKITREPLACEOPERATION_H

#include <akabeicore_global.h>
#include <akabeioperation.h>
#include <akabeipackage.h>

namespace Akabei {

class Package;

/**
 * @class PolkitReplaceOperation
 * @brief Operation to replace a package from the system using polkit.
 */
class AKABEICORESHARED_EXPORT PolkitReplaceOperation : public Operation
{
    Q_OBJECT
    Q_DISABLE_COPY(PolkitReplaceOperation)
public:
    explicit PolkitReplaceOperation(Package *package, const QList<Package*> &replaces);
    virtual ~PolkitReplaceOperation();

protected:
    void run();
    void validate();

private:
    class Private;
    Private * const d;

    Q_PRIVATE_SLOT(d, void __k__polkitFinished(QString, bool))
    Q_PRIVATE_SLOT(d, void __k__progressUpdated(QString, int))
    Q_PRIVATE_SLOT(d, void __k__newMessage(QString, QString))
    Q_PRIVATE_SLOT(d, void __k__error(QString, int, QString))
    Q_PRIVATE_SLOT(d, void __k__removeFileProgress(int))
    Q_PRIVATE_SLOT(d, void __k__removeFileFinished())
    Q_PRIVATE_SLOT(d, void __k__removeFileErrors(QStringList))
};

}

#endif // AKABEIPOLKITREPLACEOPERATION_H
