// This file is generated by kconfig_compiler_kf5 from kalarmconfig.kcfg.
// All changes you do to this file will be lost.

#include "kalarmconfig.h"

#include <kalarmcal/identities.h>

#include <klocalizedstring.h>

#include <qglobal.h>
#include <QFile>

class PreferencesBaseHelper
{
  public:
    PreferencesBaseHelper() : q(nullptr) {}
    ~PreferencesBaseHelper() { delete q; }
    PreferencesBaseHelper(const PreferencesBaseHelper&) = delete;
    PreferencesBaseHelper& operator=(const PreferencesBaseHelper&) = delete;
    PreferencesBase *q;
};
Q_GLOBAL_STATIC(PreferencesBaseHelper, s_globalPreferencesBase)
PreferencesBase *PreferencesBase::self()
{
  if (!s_globalPreferencesBase()->q) {
    new PreferencesBase;
    s_globalPreferencesBase()->q->read();
  }

  return s_globalPreferencesBase()->q;
}

PreferencesBase::PreferencesBase( )
  : KConfigSkeleton( QStringLiteral( "kalarmrc" ) )
  , mSettingsChanged(0)
{
  Q_ASSERT(!s_globalPreferencesBase()->q);
  s_globalPreferencesBase()->q = this;
  KConfigCompilerSignallingItem::NotifyFunction notifyFunction = static_cast<KConfigCompilerSignallingItem::NotifyFunction>(&PreferencesBase::itemChanged);

  setCurrentGroup( QStringLiteral( "General" ) );

  KConfigSkeleton::ItemString  *itemVersion;
  itemVersion = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "Version" ), mVersion );
  itemVersion->setLabel( i18nc("@label", "KAlarm version") );
  itemVersion->setWhatsThis( i18nc("@info:whatsthis", "KAlarm version which wrote this file.") );
  addItem( itemVersion, QStringLiteral( "Version" ) );
  QList<KConfigSkeleton::ItemEnum::Choice> valuesBackend;
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Kresources");
    choice.label = i18nc("@option", "KResources");
    valuesBackend.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Akonadi");
    choice.label = i18nc("@option", "Akonadi");
    valuesBackend.append( choice );
  }
  KConfigSkeleton::ItemEnum  *itemBackend;
  itemBackend = new KConfigSkeleton::ItemEnum( currentGroup(), QStringLiteral( "Backend" ), mBackend, valuesBackend );
  itemBackend->setLabel( i18nc("@label", "Data storage backend") );
  itemBackend->setWhatsThis( i18nc("@info:whatsthis", "Data storage backend currently used by KAlarm.") );
  addItem( itemBackend, QStringLiteral( "Backend" ) );
  KConfigCompilerSignallingItem  *itemBase_TimeZone;
  itemBase_TimeZone = new KConfigCompilerSignallingItem(new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "TimeZone" ), mBase_TimeZone ), this, notifyFunction, signalBase_TimeZoneChanged);
  itemBase_TimeZone->setLabel( i18nc("@label", "Time zone") );
  itemBase_TimeZone->setWhatsThis( i18nc("@info:whatsthis", "Select the time zone which KAlarm should use as its default for displaying and entering dates and times.") );
  addItem( itemBase_TimeZone, QStringLiteral( "Base_TimeZone" ) );
  KConfigCompilerSignallingItem  *itemBase_HolidayRegion;
  itemBase_HolidayRegion = new KConfigCompilerSignallingItem(new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "HolidayRegion" ), mBase_HolidayRegion ), this, notifyFunction, signalBase_HolidayRegionChanged);
  itemBase_HolidayRegion->setLabel( i18nc("@label", "Holiday region") );
  itemBase_HolidayRegion->setWhatsThis( i18nc("@info:whatsthis", "Select the holiday region to use.") );
  addItem( itemBase_HolidayRegion, QStringLiteral( "Base_HolidayRegion" ) );
  KConfigSkeleton::ItemColor  *itemDefaultFgColour;
  itemDefaultFgColour = new KConfigSkeleton::ItemColor( currentGroup(), QStringLiteral( "MessageForegroundColour" ), mDefaultFgColour, KColorScheme(QPalette::Active).foreground().color() );
  itemDefaultFgColour->setLabel( i18nc("@label", "Foreground color") );
  itemDefaultFgColour->setWhatsThis( i18nc("@info:whatsthis", "Default foreground color for alarm message windows.") );
  addItem( itemDefaultFgColour, QStringLiteral( "DefaultFgColour" ) );
  KConfigSkeleton::ItemColor  *itemDefaultBgColour;
  itemDefaultBgColour = new KConfigSkeleton::ItemColor( currentGroup(), QStringLiteral( "MessageBackgroundColour" ), mDefaultBgColour, KColorScheme(QPalette::Active).background(KColorScheme::NegativeBackground).color() );
  itemDefaultBgColour->setLabel( i18nc("@label", "Background color") );
  itemDefaultBgColour->setWhatsThis( i18nc("@info:whatsthis", "Default background color for alarm message windows.") );
  addItem( itemDefaultBgColour, QStringLiteral( "DefaultBgColour" ) );
  KConfigCompilerSignallingItem  *itemMessageFont;
  itemMessageFont = new KConfigCompilerSignallingItem(new KConfigSkeleton::ItemFont( currentGroup(), QStringLiteral( "MessageFont" ), mMessageFont, QFont(QFontDatabase::systemFont(QFontDatabase::GeneralFont).family(), 16, QFont::Bold) ), this, notifyFunction, signalMessageFontChanged);
  itemMessageFont->setLabel( i18nc("@label", "Message font") );
  itemMessageFont->setWhatsThis( i18nc("@info:whatsthis", "Default font for displaying alarm messages.") );
  addItem( itemMessageFont, QStringLiteral( "MessageFont" ) );
  KConfigCompilerSignallingItem  *itemShowInSystemTray;
  itemShowInSystemTray = new KConfigCompilerSignallingItem(new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "ShowInSystemTray" ), mShowInSystemTray, true ), this, notifyFunction, signalShowInSystemTrayChanged);
  itemShowInSystemTray->setLabel( i18nc("@label", "Show in system tray") );
  itemShowInSystemTray->setWhatsThis( i18nc("@info:whatsthis", "<p>Check to show KAlarm's icon in the system tray. Showing it in the system tray provides easy access and a status indication.</p>") );
  addItem( itemShowInSystemTray, QStringLiteral( "ShowInSystemTray" ) );
  KConfigCompilerSignallingItem  *itemBase_AutoHideSystemTray;
  itemBase_AutoHideSystemTray = new KConfigCompilerSignallingItem(new KConfigSkeleton::ItemInt( currentGroup(), QStringLiteral( "AutoHideSystemTray" ), mBase_AutoHideSystemTray, 1440 ), this, notifyFunction, signalAutoHideSystemTrayChanged);
  itemBase_AutoHideSystemTray->setLabel( i18nc("@label", "Auto-hide in system tray if no alarms due within period") );
  itemBase_AutoHideSystemTray->setWhatsThis( i18nc("@info:whatsthis", "<p>Enter -1 to auto-hide KAlarm's icon in the system tray when there are no active alarms.</p><p>To auto-hide the system tray icon when there are no alarms due within a set period of time, enter the time period in minutes.</p><p>Enter 0 to always show the system tray icon.</p>") );
  addItem( itemBase_AutoHideSystemTray, QStringLiteral( "Base_AutoHideSystemTray" ) );
  QStringList defaultNoAutoHideSystemTrayDesktops;
  defaultNoAutoHideSystemTrayDesktops.append( QString::fromUtf8( "Unity" ) );

  KConfigSkeleton::ItemStringList  *itemNoAutoHideSystemTrayDesktops;
  itemNoAutoHideSystemTrayDesktops = new KConfigSkeleton::ItemStringList( currentGroup(), QStringLiteral( "NoAutoHideSystemTrayDesktops" ), mNoAutoHideSystemTrayDesktops, defaultNoAutoHideSystemTrayDesktops );
  itemNoAutoHideSystemTrayDesktops->setLabel( i18nc("@label", "Desktops without auto-hide in system tray") );
  itemNoAutoHideSystemTrayDesktops->setWhatsThis( i18nc("@info:whatsthis", "Desktops for which the auto-hide in system tray option is not available.") );
  addItem( itemNoAutoHideSystemTrayDesktops, QStringLiteral( "NoAutoHideSystemTrayDesktops" ) );
  KConfigSkeleton::ItemBool  *itemAutoStart;
  itemAutoStart = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "AutoStart" ), mAutoStart, false );
  itemAutoStart->setLabel( i18nc("@label", "Start at login") );
  itemAutoStart->setWhatsThis( i18nc("@info:whatsthis", "<p>Automatically start KAlarm whenever you start KDE.</p><p>This option should always be checked unless you intend to discontinue use of KAlarm.</p>") );
  addItem( itemAutoStart, QStringLiteral( "AutoStart" ) );
  KConfigSkeleton::ItemBool  *itemBase_NoAutoStart;
  itemBase_NoAutoStart = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "NoAutoStart" ), mBase_NoAutoStart, false );
  itemBase_NoAutoStart->setLabel( i18nc("@label", "Suppress autostart at login") );
  addItem( itemBase_NoAutoStart, QStringLiteral( "Base_NoAutoStart" ) );
  KConfigSkeleton::ItemInt  *itemDefaultDeferTime;
  itemDefaultDeferTime = new KConfigSkeleton::ItemInt( currentGroup(), QStringLiteral( "DeferTime" ), mDefaultDeferTime, 5 );
  itemDefaultDeferTime->setLabel( i18nc("@label", "Default defer time interval") );
  itemDefaultDeferTime->setWhatsThis( i18nc("@info:whatsthis", "Enter the default time interval (in minutes) to defer alarms, used by the Defer Alarm dialog.") );
  addItem( itemDefaultDeferTime, QStringLiteral( "DefaultDeferTime" ) );
  KConfigSkeleton::ItemBool  *itemAskResource;
  itemAskResource = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "AskResource" ), mAskResource, true );
  itemAskResource->setLabel( i18nc("@label", "Prompt for which calendar to store in") );
  itemAskResource->setWhatsThis( i18nc("@info:whatsthis", "<p>When saving a new alarm or alarm template, prompt for which calendar to store it in, if there is more than one active calendar.</p><p>Note that archived alarms are always stored in the default archived alarm calendar.</p>") );
  addItem( itemAskResource, QStringLiteral( "AskResource" ) );
  KConfigSkeleton::ItemBool  *itemModalMessages;
  itemModalMessages = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "ModalMessages" ), mModalMessages, true );
  itemModalMessages->setLabel( i18nc("@label", "Message windows have a title bar and take keyboard focus") );
  itemModalMessages->setWhatsThis( i18nc("@info:whatsthis", "<p>Specify the characteristics of alarm message windows:<ul><li>If checked, the window is a normal window with a title bar, which grabs keyboard input when it is displayed.</li><li>If unchecked, the window does not interfere with your typing when it is displayed, but it has no title bar and cannot be moved or resized.</li></ul></p>") );
  addItem( itemModalMessages, QStringLiteral( "ModalMessages" ) );
  KConfigSkeleton::ItemInt  *itemMessageButtonDelay;
  itemMessageButtonDelay = new KConfigSkeleton::ItemInt( currentGroup(), QStringLiteral( "MessageButtonDelay" ), mMessageButtonDelay, 0 );
  itemMessageButtonDelay->setMinValue(-1);
  itemMessageButtonDelay->setMaxValue(10);
  itemMessageButtonDelay->setLabel( i18nc("@label", "Delay before message window buttons are enabled") );
  itemMessageButtonDelay->setWhatsThis( i18nc("@info:whatsthis", "<p>Specify the positioning of alarm message windows, and the delay in seconds after a window shows until its buttons are enabled.\n"
"        <ul><li>0 to position message windows as far from the cursor as possible with no enable delay.</li>\n"
"        <li>> 0 to position in center of screen and specify delay before enabling buttons.</li>\n"
"        <li>-1 for no special positioning and no enable delay.</li></ul></p>\n"
"      ") );
  addItem( itemMessageButtonDelay, QStringLiteral( "MessageButtonDelay" ) );
  KConfigCompilerSignallingItem  *itemTooltipAlarmCount;
  itemTooltipAlarmCount = new KConfigCompilerSignallingItem(new KConfigSkeleton::ItemInt( currentGroup(), QStringLiteral( "TooltipAlarmCount" ), mTooltipAlarmCount, 5 ), this, notifyFunction, signalTooltipPreferencesChanged);
  itemTooltipAlarmCount->setLabel( i18nc("@label", "Number of alarms to show in system tray tooltip") );
  itemTooltipAlarmCount->setWhatsThis( i18nc("@info:whatsthis", "<p>How many alarms due in the next 24 hours to show in the system tray tooltip:\n"
"        <ul><li>0 to display none</li>\n"
"        <li>-1 to display all</li>\n"
"        <li>>0 to set a limit.</li></ul></p>\n"
"      ") );
  addItem( itemTooltipAlarmCount, QStringLiteral( "TooltipAlarmCount" ) );
  KConfigCompilerSignallingItem  *itemShowTooltipAlarmTime;
  itemShowTooltipAlarmTime = new KConfigCompilerSignallingItem(new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "ShowTooltipAlarmTime" ), mShowTooltipAlarmTime, true ), this, notifyFunction, signalTooltipPreferencesChanged);
  itemShowTooltipAlarmTime->setLabel( i18nc("@label", "Show alarm times in system tray tooltip") );
  itemShowTooltipAlarmTime->setWhatsThis( i18nc("@info:whatsthis", "Specify whether to show in the system tray tooltip, the time at which each alarm is due.") );
  addItem( itemShowTooltipAlarmTime, QStringLiteral( "ShowTooltipAlarmTime" ) );
  KConfigCompilerSignallingItem  *itemShowTooltipTimeToAlarm;
  itemShowTooltipTimeToAlarm = new KConfigCompilerSignallingItem(new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "ShowTooltipTimeToAlarm" ), mShowTooltipTimeToAlarm, true ), this, notifyFunction, signalTooltipPreferencesChanged);
  itemShowTooltipTimeToAlarm->setLabel( i18nc("@label", "Show time to alarms in system tray tooltip") );
  itemShowTooltipTimeToAlarm->setWhatsThis( i18nc("@info:whatsthis", "Specify whether to show in the system tray tooltip, how long until each alarm is due.") );
  addItem( itemShowTooltipTimeToAlarm, QStringLiteral( "ShowTooltipTimeToAlarm" ) );
  KConfigCompilerSignallingItem  *itemTooltipTimeToPrefix;
  itemTooltipTimeToPrefix = new KConfigCompilerSignallingItem(new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "TooltipTimeToPrefix" ), mTooltipTimeToPrefix, QLatin1String("+") ), this, notifyFunction, signalTooltipPreferencesChanged);
  itemTooltipTimeToPrefix->setLabel( i18nc("@label", "Time-to-alarm prefix in system tray tooltip") );
  itemTooltipTimeToPrefix->setWhatsThis( i18nc("@info:whatsthis", "Enter the text to be displayed in front of the time until the alarm, in the system tray tooltip.") );
  addItem( itemTooltipTimeToPrefix, QStringLiteral( "TooltipTimeToPrefix" ) );
  QList<KConfigSkeleton::ItemEnum::Choice> valuesEmailClient;
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("sendmail");
    choice.label = i18nc("@option", "Sendmail");
    valuesEmailClient.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("kmail");
    choice.label = i18nc("@option", "KMail");
    valuesEmailClient.append( choice );
  }
  KConfigSkeleton::ItemEnum  *itemEmailClient;
  itemEmailClient = new KConfigSkeleton::ItemEnum( currentGroup(), QStringLiteral( "EmailClient" ), mEmailClient, valuesEmailClient, kmail );
  itemEmailClient->setLabel( i18nc("@label", "Email client") );
  itemEmailClient->setWhatsThis( i18nc("@info:whatsthis", "<p>How to send email when an email alarm is triggered.<ul><li>KMail: The email is sent automatically via KMail. KMail is started first if necessary.</li><li>Sendmail: The email is sent automatically. This option will only work if your system is configured to use sendmail or a sendmail compatible mail transport agent.</li></ul></p>") );
  addItem( itemEmailClient, QStringLiteral( "EmailClient" ) );
  KConfigSkeleton::ItemBool  *itemBase_EmailCopyToKMail;
  itemBase_EmailCopyToKMail = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "EmailCopyToKMail" ), mBase_EmailCopyToKMail, false );
  itemBase_EmailCopyToKMail->setLabel( i18nc("@label", "Whether to copy sent emails into KMail's Sent folder.") );
  itemBase_EmailCopyToKMail->setWhatsThis( i18nc("@info:whatsthis", "Whether after sending an email to store a copy in KMail's sent-mail folder. Only applies when sendmail is selected as the email client.") );
  addItem( itemBase_EmailCopyToKMail, QStringLiteral( "Base_EmailCopyToKMail" ) );
  KConfigSkeleton::ItemString  *itemBase_EmailFrom;
  itemBase_EmailFrom = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "EmailFrom" ), mBase_EmailFrom, KAlarmCal::Identities::identitiesExist() ? QLatin1String("@KMail") : QLatin1String("@SystemSettings") );
  itemBase_EmailFrom->setLabel( i18nc("@label", "'From' email address") );
  itemBase_EmailFrom->setWhatsThis( i18nc("@info:whatsthis", "Your email address, used to identify you as the sender when sending email alarms. Enter \"@SystemSettings\" to use the default email address set in KMail or System Settings, \"@KMail\" to allow choice of KMail identities, or enter the actual email address otherwise.") );
  addItem( itemBase_EmailFrom, QStringLiteral( "Base_EmailFrom" ) );
  KConfigSkeleton::ItemString  *itemBase_EmailBccAddress;
  itemBase_EmailBccAddress = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "EmailBccAddress" ), mBase_EmailBccAddress, QLatin1String("@SystemSettings") );
  itemBase_EmailBccAddress->setLabel( i18nc("@label", "'Bcc' email address") );
  itemBase_EmailBccAddress->setWhatsThis( i18nc("@info:whatsthis", "Your email address, used for blind copying email alarms to yourself. If you want blind copies to be sent to your account on the computer which KAlarm runs on, you can simply enter your user login name. Enter \"@SystemSettings\" to use the default email address set in KMail or System Settings, or enter the actual email address otherwise.") );
  addItem( itemBase_EmailBccAddress, QStringLiteral( "Base_EmailBccAddress" ) );
  KConfigSkeleton::ItemString  *itemBase_CmdXTermCommand;
  itemBase_CmdXTermCommand = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "CmdXTerm" ), mBase_CmdXTermCommand );
  itemBase_CmdXTermCommand->setLabel( i18nc("@label", "Terminal for command alarms") );
  itemBase_CmdXTermCommand->setWhatsThis( i18nc("@info:whatsthis", "Command line to execute command alarms in a terminal window, including special codes described in the KAlarm handbook.") );
  addItem( itemBase_CmdXTermCommand, QStringLiteral( "Base_CmdXTermCommand" ) );
  KConfigCompilerSignallingItem  *itemBase_StartOfDay;
  itemBase_StartOfDay = new KConfigCompilerSignallingItem(new KConfigSkeleton::ItemDateTime( currentGroup(), QStringLiteral( "StartOfDay" ), mBase_StartOfDay, QDateTime(QDate(1900,1,1),QTime(0,0)) ), this, notifyFunction, signalBase_StartOfDayChanged);
  itemBase_StartOfDay->setLabel( i18nc("@label", "Start of day for date-only alarms") );
  itemBase_StartOfDay->setWhatsThis( i18nc("@info:whatsthis", "The earliest time of day at which a date-only alarm will be triggered.") );
  addItem( itemBase_StartOfDay, QStringLiteral( "Base_StartOfDay" ) );
  KConfigCompilerSignallingItem  *itemBase_WorkDayStart;
  itemBase_WorkDayStart = new KConfigCompilerSignallingItem(new KConfigSkeleton::ItemDateTime( currentGroup(), QStringLiteral( "WorkDayStart" ), mBase_WorkDayStart, QDateTime(QDate(1900,1,1),QTime(8,0)) ), this, notifyFunction, signalBase_WorkTimeChanged);
  itemBase_WorkDayStart->setLabel( i18nc("@label", "Start time of working day") );
  itemBase_WorkDayStart->setWhatsThis( i18nc("@info:whatsthis", "The start time of the working day.") );
  addItem( itemBase_WorkDayStart, QStringLiteral( "Base_WorkDayStart" ) );
  KConfigCompilerSignallingItem  *itemBase_WorkDayEnd;
  itemBase_WorkDayEnd = new KConfigCompilerSignallingItem(new KConfigSkeleton::ItemDateTime( currentGroup(), QStringLiteral( "WorkDayEnd" ), mBase_WorkDayEnd, QDateTime(QDate(1900,1,1),QTime(17,0)) ), this, notifyFunction, signalBase_WorkTimeChanged);
  itemBase_WorkDayEnd->setLabel( i18nc("@label", "End time of working day") );
  itemBase_WorkDayEnd->setWhatsThis( i18nc("@info:whatsthis", "The end time of the working day.") );
  addItem( itemBase_WorkDayEnd, QStringLiteral( "Base_WorkDayEnd" ) );
  KConfigCompilerSignallingItem  *itemBase_WorkDays;
  itemBase_WorkDays = new KConfigCompilerSignallingItem(new KConfigSkeleton::ItemUInt( currentGroup(), QStringLiteral( "WorkDays" ), mBase_WorkDays, KAlarm::defaultWorkDays() ), this, notifyFunction, signalBase_WorkTimeChanged);
  itemBase_WorkDays->setLabel( i18nc("@label", "Working days") );
  itemBase_WorkDays->setWhatsThis( i18nc("@info:whatsthis", "OR'ed bits indicating which days of the week are work days, 1 = Monday ... 64 = Sunday.") );
  addItem( itemBase_WorkDays, QStringLiteral( "Base_WorkDays" ) );
  KConfigCompilerSignallingItem  *itemDisabledColour;
  itemDisabledColour = new KConfigCompilerSignallingItem(new KConfigSkeleton::ItemColor( currentGroup(), QStringLiteral( "DisabledColour" ), mDisabledColour, KColorScheme(QPalette::Disabled).foreground(KColorScheme::InactiveText).color() ), this, notifyFunction, signalDisabledColourChanged);
  itemDisabledColour->setLabel( i18nc("@label", "Disabled alarm color") );
  itemDisabledColour->setWhatsThis( i18nc("@info:whatsthis", "Choose the text color in the alarm list for disabled alarms.") );
  addItem( itemDisabledColour, QStringLiteral( "DisabledColour" ) );
  KConfigCompilerSignallingItem  *itemArchivedColour;
  itemArchivedColour = new KConfigCompilerSignallingItem(new KConfigSkeleton::ItemColor( currentGroup(), QStringLiteral( "ExpiredColour" ), mArchivedColour, KColorScheme(QPalette::Active).foreground(KColorScheme::VisitedText).color() ), this, notifyFunction, signalArchivedColourChanged);
  itemArchivedColour->setLabel( i18nc("@label", "Archived alarm color") );
  itemArchivedColour->setWhatsThis( i18nc("@info:whatsthis", "Choose the text color in the alarm list for archived alarms.") );
  addItem( itemArchivedColour, QStringLiteral( "ArchivedColour" ) );
  KConfigCompilerSignallingItem  *itemArchivedKeepDays;
  itemArchivedKeepDays = new KConfigCompilerSignallingItem(new KConfigSkeleton::ItemInt( currentGroup(), QStringLiteral( "ExpiredKeepDays" ), mArchivedKeepDays, 7 ), this, notifyFunction, signalArchivedKeepDaysChanged);
  itemArchivedKeepDays->setLabel( i18nc("@label", "Days to keep expired alarms") );
  itemArchivedKeepDays->setWhatsThis( i18nc("@info:whatsthis", "<p>Specify how many days to keep alarms after they expire or are deleted (except deleted alarms which were never triggered):\n"
"        <ul><li>0 to not keep</li>\n"
"        <li>-1 to keep indefinitely</li>\n"
"        <li>>0 number of days to keep.</li></ul></p>\n"
"      ") );
  addItem( itemArchivedKeepDays, QStringLiteral( "ArchivedKeepDays" ) );
  KConfigSkeleton::ItemInt  *itemKOrgEventDuration;
  itemKOrgEventDuration = new KConfigSkeleton::ItemInt( currentGroup(), QStringLiteral( "KOrgEventDuration" ), mKOrgEventDuration, 0 );
  itemKOrgEventDuration->setLabel( i18nc("@label", "KOrganizer event duration") );
  itemKOrgEventDuration->setWhatsThis( i18nc("@info:whatsthis", "Enter the event duration in minutes, for alarms which are copied to KOrganizer.") );
  addItem( itemKOrgEventDuration, QStringLiteral( "KOrgEventDuration" ) );
  KConfigSkeleton::ItemInt  *itemWakeFromSuspendAdvance;
  itemWakeFromSuspendAdvance = new KConfigSkeleton::ItemInt( currentGroup(), QStringLiteral( "WakeFromSuspendAdvance" ), mWakeFromSuspendAdvance, 2 );
  itemWakeFromSuspendAdvance->setLabel( i18nc("@label", "Number of minutes before alarm to wake from suspend") );
  itemWakeFromSuspendAdvance->setWhatsThis( i18nc("@info:whatsthis", "Enter how many minutes before the alarm trigger time to wake the system from suspend. This can be used to ensure that the system is fully restored by the time the alarm triggers.") );
  addItem( itemWakeFromSuspendAdvance, QStringLiteral( "WakeFromSuspendAdvance" ) );

  setCurrentGroup( QStringLiteral( "Defaults" ) );

  KConfigSkeleton::ItemInt  *itemDefaultLateCancel;
  itemDefaultLateCancel = new KConfigSkeleton::ItemInt( currentGroup(), QStringLiteral( "LateCancel" ), mDefaultLateCancel, 0 );
  itemDefaultLateCancel->setMinValue(0);
  itemDefaultLateCancel->setLabel( i18nc("@label", "Cancel if late (minutes)") );
  itemDefaultLateCancel->setWhatsThis( i18nc("@info:whatsthis", "Default value in the alarm edit dialog for late cancellation time (in minutes). 0 for no late cancellation, >0 how many minutes before cancelling.") );
  addItem( itemDefaultLateCancel, QStringLiteral( "DefaultLateCancel" ) );
  KConfigSkeleton::ItemBool  *itemDefaultAutoClose;
  itemDefaultAutoClose = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "AutoClose" ), mDefaultAutoClose, false );
  itemDefaultAutoClose->setLabel( i18nc("@label", "Auto-close window after late-cancellation time") );
  itemDefaultAutoClose->setWhatsThis( i18nc("@info:whatsthis", "Default setting in the alarm edit dialog for \"auto close if late\".") );
  addItem( itemDefaultAutoClose, QStringLiteral( "DefaultAutoClose" ) );
  KConfigSkeleton::ItemBool  *itemDefaultConfirmAck;
  itemDefaultConfirmAck = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "ConfirmAck" ), mDefaultConfirmAck, false );
  itemDefaultConfirmAck->setLabel( i18nc("@label", "Confirm acknowledgement") );
  itemDefaultConfirmAck->setWhatsThis( i18nc("@info:whatsthis", "Default setting in the alarm edit dialog for \"confirm alarm acknowledgement\".") );
  addItem( itemDefaultConfirmAck, QStringLiteral( "DefaultConfirmAck" ) );
  KConfigSkeleton::ItemBool  *itemDefaultCopyToKOrganizer;
  itemDefaultCopyToKOrganizer = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "CopyKOrg" ), mDefaultCopyToKOrganizer, false );
  itemDefaultCopyToKOrganizer->setLabel( i18nc("@label", "Show in KOrganizer") );
  itemDefaultCopyToKOrganizer->setWhatsThis( i18nc("@info:whatsthis", "Default setting in the alarm edit dialog for \"show in KOrganizer\".") );
  addItem( itemDefaultCopyToKOrganizer, QStringLiteral( "DefaultCopyToKOrganizer" ) );
  QList<KConfigSkeleton::ItemEnum::Choice> valuesDefaultSoundType;
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("None");
    valuesDefaultSoundType.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Beep");
    valuesDefaultSoundType.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("File");
    choice.label = i18nc("@option", "Play File");
    valuesDefaultSoundType.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Speak");
    valuesDefaultSoundType.append( choice );
  }
  KConfigSkeleton::ItemEnum  *itemDefaultSoundType;
  itemDefaultSoundType = new KConfigSkeleton::ItemEnum( currentGroup(), QStringLiteral( "SoundType" ), mDefaultSoundType, valuesDefaultSoundType, Sound_None );
  itemDefaultSoundType->setLabel( i18nc("@label Label for audio options", "Sound") );
  itemDefaultSoundType->setWhatsThis( i18nc("@info:whatsthis", "Default sound type in the alarm edit dialog.") );
  addItem( itemDefaultSoundType, QStringLiteral( "DefaultSoundType" ) );
  KConfigSkeleton::ItemPath  *itemDefaultSoundFile;
  itemDefaultSoundFile = new KConfigSkeleton::ItemPath( currentGroup(), QStringLiteral( "SoundFile" ), mDefaultSoundFile );
  itemDefaultSoundFile->setLabel( i18nc("@label", "Sound file") );
  itemDefaultSoundFile->setWhatsThis( i18nc("@info:whatsthis", "Default sound file path in the alarm edit dialog.") );
  addItem( itemDefaultSoundFile, QStringLiteral( "DefaultSoundFile" ) );
  KConfigSkeleton::ItemInt  *itemBase_DefaultSoundVolume;
  itemBase_DefaultSoundVolume = new KConfigSkeleton::ItemInt( currentGroup(), QStringLiteral( "SoundVolume" ), mBase_DefaultSoundVolume, -1 );
  itemBase_DefaultSoundVolume->setMinValue(-1);
  itemBase_DefaultSoundVolume->setMaxValue(100);
  itemBase_DefaultSoundVolume->setLabel( i18nc("@label", "Sound volume") );
  itemBase_DefaultSoundVolume->setWhatsThis( i18nc("@info:whatsthis", "Default sound volume in the alarm edit dialog. -1 to deselect volume, or 0 - 100 %") );
  addItem( itemBase_DefaultSoundVolume, QStringLiteral( "Base_DefaultSoundVolume" ) );
  KConfigSkeleton::ItemBool  *itemDefaultSoundRepeat;
  itemDefaultSoundRepeat = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "SoundRepeat" ), mDefaultSoundRepeat, false );
  itemDefaultSoundRepeat->setLabel( i18nc("@label", "Repeat sound file") );
  itemDefaultSoundRepeat->setWhatsThis( i18nc("@info:whatsthis", "Default setting in the alarm edit dialog for sound repetition.") );
  addItem( itemDefaultSoundRepeat, QStringLiteral( "DefaultSoundRepeat" ) );
  KConfigSkeleton::ItemBool  *itemDefaultCmdScript;
  itemDefaultCmdScript = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "CmdScript" ), mDefaultCmdScript, false );
  itemDefaultCmdScript->setLabel( i18nc("@label", "Enter script") );
  itemDefaultCmdScript->setWhatsThis( i18nc("@info:whatsthis", "Default setting in the alarm edit dialog for command script entry.") );
  addItem( itemDefaultCmdScript, QStringLiteral( "DefaultCmdScript" ) );
  QList<KConfigSkeleton::ItemEnum::Choice> valuesDefaultCmdLogType;
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Discard");
    choice.label = i18nc("@option", "Discard Output");
    valuesDefaultCmdLogType.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("File");
    choice.label = i18nc("@option", "Log To File");
    valuesDefaultCmdLogType.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Terminal");
    choice.label = i18nc("@option", "Execute in terminal window");
    valuesDefaultCmdLogType.append( choice );
  }
  KConfigSkeleton::ItemEnum  *itemDefaultCmdLogType;
  itemDefaultCmdLogType = new KConfigSkeleton::ItemEnum( currentGroup(), QStringLiteral( "CmdLogType" ), mDefaultCmdLogType, valuesDefaultCmdLogType, Log_Discard );
  itemDefaultCmdLogType->setLabel( i18nc("@label", "Command output") );
  itemDefaultCmdLogType->setWhatsThis( i18nc("@info:whatsthis", "Default setting in the alarm edit dialog for where to send command alarm output.") );
  addItem( itemDefaultCmdLogType, QStringLiteral( "DefaultCmdLogType" ) );
  KConfigSkeleton::ItemPath  *itemDefaultCmdLogFile;
  itemDefaultCmdLogFile = new KConfigSkeleton::ItemPath( currentGroup(), QStringLiteral( "LogFile" ), mDefaultCmdLogFile );
  itemDefaultCmdLogFile->setLabel( i18nc("@label", "Log file") );
  itemDefaultCmdLogFile->setWhatsThis( i18nc("@info:whatsthis", "Default log file path for command alarms in the alarm edit dialog.") );
  addItem( itemDefaultCmdLogFile, QStringLiteral( "DefaultCmdLogFile" ) );
  KConfigSkeleton::ItemBool  *itemDefaultEmailBcc;
  itemDefaultEmailBcc = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "EmailBcc" ), mDefaultEmailBcc, false );
  itemDefaultEmailBcc->setLabel( i18nc("@label", "Copy email to self") );
  itemDefaultEmailBcc->setWhatsThis( i18nc("@info:whatsthis", "Default setting in the alarm edit dialog for blind copying emails to self.") );
  addItem( itemDefaultEmailBcc, QStringLiteral( "DefaultEmailBcc" ) );
  QList<KConfigSkeleton::ItemEnum::Choice> valuesDefaultRecurPeriod;
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("None");
    choice.label = i18nc("@option", "No recurrence");
    valuesDefaultRecurPeriod.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Login");
    choice.label = i18nc("@option", "At login");
    valuesDefaultRecurPeriod.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("SubDaily");
    choice.label = i18nc("@option", "Hourly/minutely");
    valuesDefaultRecurPeriod.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Daily");
    valuesDefaultRecurPeriod.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Weekly");
    valuesDefaultRecurPeriod.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Monthly");
    valuesDefaultRecurPeriod.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Yearly");
    valuesDefaultRecurPeriod.append( choice );
  }
  KConfigSkeleton::ItemEnum  *itemDefaultRecurPeriod;
  itemDefaultRecurPeriod = new KConfigSkeleton::ItemEnum( currentGroup(), QStringLiteral( "RecurPeriod" ), mDefaultRecurPeriod, valuesDefaultRecurPeriod, Recur_None );
  itemDefaultRecurPeriod->setLabel( i18nc("@label", "Recurrence period") );
  itemDefaultRecurPeriod->setWhatsThis( i18nc("@info:whatsthis", "The default setting for the recurrence rule in the alarm edit dialog.") );
  addItem( itemDefaultRecurPeriod, QStringLiteral( "DefaultRecurPeriod" ) );
  QList<KConfigSkeleton::ItemEnum::Choice> valuesDefaultFeb29Type;
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Feb28");
    choice.label = i18nc("@option", "February 28th");
    valuesDefaultFeb29Type.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Mar1");
    choice.label = i18nc("@option", "March 1st");
    valuesDefaultFeb29Type.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("None");
    choice.label = i18nc("@option", "Do not repeat");
    valuesDefaultFeb29Type.append( choice );
  }
  KConfigCompilerSignallingItem  *itemDefaultFeb29Type;
  itemDefaultFeb29Type = new KConfigCompilerSignallingItem(new KConfigSkeleton::ItemEnum( currentGroup(), QStringLiteral( "Feb29Recur" ), mDefaultFeb29Type, valuesDefaultFeb29Type, Feb29_Mar1 ), this, notifyFunction, signalFeb29TypeChanged);
  itemDefaultFeb29Type->setLabel( i18nc("@label", "In non-leap years, repeat yearly February 29th alarms on:") );
  itemDefaultFeb29Type->setWhatsThis( i18nc("@info:whatsthis", "For yearly recurrences, choose what date, if any, alarms due on February 29th should occur in non-leap years.<i>Note</i>: The next scheduled occurrence of existing alarms is not re-evaluated when you change this setting.") );
  addItem( itemDefaultFeb29Type, QStringLiteral( "DefaultFeb29Type" ) );
  QList<KConfigSkeleton::ItemEnum::Choice> valuesDefaultReminderUnits;
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Minutes");
    valuesDefaultReminderUnits.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("HoursMinutes");
    choice.label = i18nc("@option", "Hours/Minutes");
    valuesDefaultReminderUnits.append( choice );
  }
  KConfigSkeleton::ItemEnum  *itemDefaultReminderUnits;
  itemDefaultReminderUnits = new KConfigSkeleton::ItemEnum( currentGroup(), QStringLiteral( "RemindUnits" ), mDefaultReminderUnits, valuesDefaultReminderUnits, TimePeriod::HoursMinutes );
  itemDefaultReminderUnits->setLabel( i18nc("@label", "Reminder units") );
  itemDefaultReminderUnits->setWhatsThis( i18nc("@info:whatsthis", "Default reminder time units in the alarm edit dialog.") );
  addItem( itemDefaultReminderUnits, QStringLiteral( "DefaultReminderUnits" ) );
  KConfigSkeleton::ItemString  *itemDefaultPreAction;
  itemDefaultPreAction = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "PreAction" ), mDefaultPreAction );
  itemDefaultPreAction->setLabel( i18nc("@label", "Pre-alarm action") );
  itemDefaultPreAction->setWhatsThis( i18nc("@info:whatsthis", "Default command to execute before displaying alarms.") );
  addItem( itemDefaultPreAction, QStringLiteral( "DefaultPreAction" ) );
  KConfigSkeleton::ItemBool  *itemDefaultExecPreActionOnDeferral;
  itemDefaultExecPreActionOnDeferral = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "PreActionExecDefer" ), mDefaultExecPreActionOnDeferral, false );
  itemDefaultExecPreActionOnDeferral->setLabel( i18nc("@label", "Execute pre-alarm action for deferred alarms") );
  itemDefaultExecPreActionOnDeferral->setWhatsThis( i18nc("@info:whatsthis", "Default setting for whether to execute the pre-alarm action before deferred alarms trigger.") );
  addItem( itemDefaultExecPreActionOnDeferral, QStringLiteral( "DefaultExecPreActionOnDeferral" ) );
  KConfigSkeleton::ItemBool  *itemDefaultCancelOnPreActionError;
  itemDefaultCancelOnPreActionError = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "PreActionErrCancel" ), mDefaultCancelOnPreActionError, false );
  itemDefaultCancelOnPreActionError->setLabel( i18nc("@label", "Cancel alarm on pre-alarm action error") );
  itemDefaultCancelOnPreActionError->setWhatsThis( i18nc("@info:whatsthis", "Default setting for whether to cancel the alarm if the pre-alarm action command fails.") );
  addItem( itemDefaultCancelOnPreActionError, QStringLiteral( "DefaultCancelOnPreActionError" ) );
  KConfigSkeleton::ItemBool  *itemDefaultDontShowPreActionError;
  itemDefaultDontShowPreActionError = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "PreActionErrDontShow" ), mDefaultDontShowPreActionError, false );
  itemDefaultDontShowPreActionError->setLabel( i18nc("@label", "Do not notify pre-alarm action errors") );
  itemDefaultDontShowPreActionError->setWhatsThis( i18nc("@info:whatsthis", "Default setting for whether to show no error status or error message if the pre-alarm action command fails.") );
  addItem( itemDefaultDontShowPreActionError, QStringLiteral( "DefaultDontShowPreActionError" ) );
  KConfigSkeleton::ItemString  *itemDefaultPostAction;
  itemDefaultPostAction = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "PostAction" ), mDefaultPostAction );
  itemDefaultPostAction->setLabel( i18nc("@label", "Post-alarm action") );
  itemDefaultPostAction->setWhatsThis( i18nc("@info:whatsthis", "Default command to execute after alarm message windows are closed.") );
  addItem( itemDefaultPostAction, QStringLiteral( "DefaultPostAction" ) );

  setCurrentGroup( QStringLiteral( "Notification Messages" ) );

  KConfigSkeleton::ItemBool  *itemBase_QuitWarn;
  itemBase_QuitWarn = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "QuitWarn" ), mBase_QuitWarn, true );
  itemBase_QuitWarn->setLabel( i18nc("@label", "Warn before quitting") );
  itemBase_QuitWarn->setWhatsThis( i18nc("@info:whatsthis", "Whether to suppress a warning prompt before quitting KAlarm.") );
  addItem( itemBase_QuitWarn, QStringLiteral( "Base_QuitWarn" ) );
  KConfigSkeleton::ItemBool  *itemBase_ConfirmAlarmDeletion;
  itemBase_ConfirmAlarmDeletion = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "ConfirmAlarmDeletion" ), mBase_ConfirmAlarmDeletion, true );
  itemBase_ConfirmAlarmDeletion->setLabel( i18nc("@label", "Confirm alarm deletions") );
  itemBase_ConfirmAlarmDeletion->setWhatsThis( i18nc("@info:whatsthis", "Check to be prompted for confirmation each time you delete an alarm.") );
  addItem( itemBase_ConfirmAlarmDeletion, QStringLiteral( "Base_ConfirmAlarmDeletion" ) );
  KConfigSkeleton::ItemBool  *itemBase_EmailQueuedNotify;
  itemBase_EmailQueuedNotify = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "EmailQueuedNotify" ), mBase_EmailQueuedNotify, false );
  itemBase_EmailQueuedNotify->setLabel( i18nc("@label", "Notify when remote emails are queued") );
  itemBase_EmailQueuedNotify->setWhatsThis( i18nc("@info:whatsthis", "Display a notification message whenever an email alarm has queued an email for sending to a remote system. This could be useful if, for example, you have a dial-up connection, so that you can then ensure that the email is actually transmitted.") );
  addItem( itemBase_EmailQueuedNotify, QStringLiteral( "Base_EmailQueuedNotify" ) );
}

PreferencesBase::~PreferencesBase()
{
  s_globalPreferencesBase()->q = nullptr;
}

bool PreferencesBase::usrSave()
{
  const bool res = KConfigSkeleton::usrSave();
  if (!res) return false;

  if ( mSettingsChanged & signalShowInSystemTrayChanged )
    Q_EMIT showInSystemTrayChanged(mShowInSystemTray);
  if ( mSettingsChanged & signalAutoHideSystemTrayChanged )
    Q_EMIT autoHideSystemTrayChanged(mBase_AutoHideSystemTray);
  if ( mSettingsChanged & signalBase_TimeZoneChanged )
    Q_EMIT base_TimeZoneChanged(mBase_TimeZone);
  if ( mSettingsChanged & signalBase_HolidayRegionChanged )
    Q_EMIT base_HolidayRegionChanged(mBase_HolidayRegion);
  if ( mSettingsChanged & signalBase_StartOfDayChanged )
    Q_EMIT base_StartOfDayChanged(mBase_StartOfDay);
  if ( mSettingsChanged & signalBase_WorkTimeChanged )
    Q_EMIT base_WorkTimeChanged(mBase_WorkDayStart, mBase_WorkDayEnd, mBase_WorkDays);
  if ( mSettingsChanged & signalMessageFontChanged )
    Q_EMIT messageFontChanged(mMessageFont);
  if ( mSettingsChanged & signalDisabledColourChanged )
    Q_EMIT disabledColourChanged(mDisabledColour);
  if ( mSettingsChanged & signalArchivedColourChanged )
    Q_EMIT archivedColourChanged(mArchivedColour);
  if ( mSettingsChanged & signalArchivedKeepDaysChanged )
    Q_EMIT archivedKeepDaysChanged(mArchivedKeepDays);
  if ( mSettingsChanged & signalFeb29TypeChanged )
    Q_EMIT feb29TypeChanged(static_cast<Feb29Type>(mDefaultFeb29Type));
  if ( mSettingsChanged & signalTooltipPreferencesChanged )
    Q_EMIT tooltipPreferencesChanged();
  mSettingsChanged = 0;
  return true;
}

void PreferencesBase::itemChanged(quint64 flags) {
  mSettingsChanged |= flags;

}

#include "kalarmconfig.moc"

