// This file is generated by kconfig_compiler_kf5 from tomboynotesresource.kcfg.
// All changes you do to this file will be lost.

#include "settings.h"

#include <klocalizedstring.h>

#include <qglobal.h>
#include <QFile>

#include <QDebug>

class SettingsHelper
{
  public:
    SettingsHelper() : q(nullptr) {}
    ~SettingsHelper() { delete q; }
    SettingsHelper(const SettingsHelper&) = delete;
    SettingsHelper& operator=(const SettingsHelper&) = delete;
    Settings *q;
};
Q_GLOBAL_STATIC(SettingsHelper, s_globalSettings)
Settings *Settings::self()
{
  if (!s_globalSettings()->q)
     qFatal("you need to call Settings::instance before using");
  return s_globalSettings()->q;
}

void Settings::instance(const QString& cfgfilename)
{
  if (s_globalSettings()->q) {
     qDebug() << "Settings::instance called after the first use - ignoring";
     return;
  }
  new Settings(KSharedConfig::openConfig(cfgfilename));
  s_globalSettings()->q->read();
}

void Settings::instance(KSharedConfig::Ptr config)
{
  if (s_globalSettings()->q) {
     qDebug() << "Settings::instance called after the first use - ignoring";
     return;
  }
  new Settings(std::move(config));
  s_globalSettings()->q->read();
}

Settings::Settings( KSharedConfig::Ptr config )
  : KConfigSkeleton( std::move( config ) )
{
  Q_ASSERT(!s_globalSettings()->q);
  s_globalSettings()->q = this;
  setCurrentGroup( QStringLiteral( "General" ) );

  mCollectionNameItem = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "collectionName" ), mCollectionName );
  mCollectionNameItem->setLabel( i18n("The display name of this resource") );
  addItem( mCollectionNameItem, QStringLiteral( "collectionName" ) );
  mServerURLItem = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "ServerURL" ), mServerURL, QStringLiteral( "http://localhost/owncloud/index.php/apps/grauphel" ) );
  mServerURLItem->setLabel( i18n("The URL to the Tomboy sync server") );
  addItem( mServerURLItem, QStringLiteral( "ServerURL" ) );
  mContentURLItem = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "contentURL" ), mContentURL );
  mContentURLItem->setLabel( i18n("The URL to the notes on the Tomboy sync server") );
  addItem( mContentURLItem, QStringLiteral( "contentURL" ) );
  mUserURLItem = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "userURL" ), mUserURL );
  mUserURLItem->setLabel( i18n("The URL to the user data on the Tomboy sync server") );
  addItem( mUserURLItem, QStringLiteral( "userURL" ) );
  mRequestTokenItem = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "requestToken" ), mRequestToken );
  mRequestTokenItem->setLabel( i18n("The request token to the Tomboy sync server") );
  addItem( mRequestTokenItem, QStringLiteral( "requestToken" ) );
  mRequestTokenSecretItem = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "requestTokenSecret" ), mRequestTokenSecret );
  mRequestTokenSecretItem->setLabel( i18n("The request token secret to the Tomboy sync server") );
  addItem( mRequestTokenSecretItem, QStringLiteral( "requestTokenSecret" ) );
  mConflictHandlingItem = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "ConflictHandling" ), mConflictHandling );
  mConflictHandlingItem->setLabel( i18n("The way how conflicts should be handled") );
  addItem( mConflictHandlingItem, QStringLiteral( "ConflictHandling" ) );
  mReadOnlyItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "ReadOnly" ), mReadOnly, false );
  mReadOnlyItem->setLabel( i18n("Do not change the actual backend data.") );
  addItem( mReadOnlyItem, QStringLiteral( "ReadOnly" ) );
  mIgnoreSslErrorsItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "ignoreSslErrors" ), mIgnoreSslErrors, false );
  mIgnoreSslErrorsItem->setLabel( i18n("Ignore SSL errors.") );
  addItem( mIgnoreSslErrorsItem, QStringLiteral( "ignoreSslErrors" ) );
  mRefreshIntervalItem = new KConfigSkeleton::ItemInt( currentGroup(), QStringLiteral( "refreshInterval" ), mRefreshInterval, 5 );
  mRefreshIntervalItem->setLabel( i18n("Refresh every") );
  addItem( mRefreshIntervalItem, QStringLiteral( "refreshInterval" ) );
}

Settings::~Settings()
{
  s_globalSettings()->q = nullptr;
}

