// This file is generated by kconfig_compiler_kf5 from mailtransport.kcfg.
// All changes you do to this file will be lost.

#include "transportbase.h"

#include <klocalizedstring.h>

using namespace MailTransport;

TransportBase::TransportBase( const QString & transportId )
  : KConfigSkeleton( QStringLiteral( "mailtransports" ) )
  , mParamtransportId(transportId)
{
  setCurrentGroup( QStringLiteral( "Transport %1" ).arg( mParamtransportId ) );

  mIdItem = new KConfigSkeleton::ItemInt( currentGroup(), QStringLiteral( "id" ), mId, 0 );
  mIdItem->setLabel( i18nd("libmailtransport5", "Unique identifier") );
  addItem( mIdItem, QStringLiteral( "id" ) );
  mNameItem = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "name" ), mName, i18n("Unnamed") );
  mNameItem->setLabel( i18nd("libmailtransport5", "User-visible transport name") );
  mNameItem->setWhatsThis( i18nd("libmailtransport5", "The name that will be used when referring to this server.") );
  addItem( mNameItem, QStringLiteral( "name" ) );
  mIdentifierItem = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "identifier" ), mIdentifier, QStringLiteral( "SMTP" ) );
  mIdentifierItem->setLabel( i18nd("libmailtransport5", "identifier") );
  addItem( mIdentifierItem, QStringLiteral( "identifier" ) );
  mHostItem = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "host" ), mHost );
  mHostItem->setLabel( i18nd("libmailtransport5", "Host name of the server") );
  mHostItem->setWhatsThis( i18nd("libmailtransport5", "The domain name or numerical address of the SMTP server.") );
  addItem( mHostItem, QStringLiteral( "host" ) );
  mPortItem = new KConfigSkeleton::ItemUInt( currentGroup(), QStringLiteral( "port" ), mPort, 25 );
  mPortItem->setLabel( i18nd("libmailtransport5", "Port number of the server") );
  mPortItem->setWhatsThis( i18nd("libmailtransport5", "The port number that the SMTP server is listening on. The default port is 25.") );
  addItem( mPortItem, QStringLiteral( "port" ) );
  mUserNameItem = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "user" ), mUserName );
  mUserNameItem->setLabel( i18nd("libmailtransport5", "User name needed for login") );
  mUserNameItem->setWhatsThis( i18nd("libmailtransport5", "The user name to send to the server for authorization.") );
  addItem( mUserNameItem, QStringLiteral( "userName" ) );
  mPrecommandItem = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "precommand" ), mPrecommand );
  mPrecommandItem->setLabel( i18nd("libmailtransport5", "Command to execute before sending a mail") );
  mPrecommandItem->setWhatsThis( i18nd("libmailtransport5", "A command to run locally, prior to sending email. This can be used to set up SSH tunnels, for example. Leave it empty if no command should be run.") );
  addItem( mPrecommandItem, QStringLiteral( "precommand" ) );
  mOptionsItem = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "options" ), mOptions );
  mOptionsItem->setLabel( i18nd("libmailtransport5", "Options added to mailtransport method") );
  addItem( mOptionsItem, QStringLiteral( "options" ) );
  mRequiresAuthenticationItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "auth" ), mRequiresAuthentication, false );
  mRequiresAuthenticationItem->setLabel( i18nd("libmailtransport5", "Server requires authentication") );
  mRequiresAuthenticationItem->setWhatsThis( i18nd("libmailtransport5", "Check this option if your SMTP server requires authentication before accepting mail. This is known as 'Authenticated SMTP' or simply ASMTP.") );
  addItem( mRequiresAuthenticationItem, QStringLiteral( "requiresAuthentication" ) );
  mStorePasswordItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "storepass" ), mStorePassword, false );
  mStorePasswordItem->setLabel( i18nd("libmailtransport5", "Store password") );
  mStorePasswordItem->setWhatsThis( i18nd("libmailtransport5", "Check this option to have your password stored.\n"
"If KWallet is available the password will be stored there, which is considered safe.\n"
"However, if KWallet is not available, the password will be stored in the configuration file. The password is stored in an obfuscated format, but should not be considered secure from decryption efforts if access to the configuration file is obtained.") );
  addItem( mStorePasswordItem, QStringLiteral( "storePassword" ) );
  QList<KConfigSkeleton::ItemEnum::Choice> valuesencryption;
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("None");
    choice.label = i18nd("libmailtransport5", "No encryption");
    valuesencryption.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("SSL");
    choice.label = i18nd("libmailtransport5", "SSL encryption");
    valuesencryption.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("TLS");
    choice.label = i18nd("libmailtransport5", "TLS encryption");
    valuesencryption.append( choice );
  }
  mEncryptionItem = new KConfigSkeleton::ItemEnum( currentGroup(), QStringLiteral( "encryption" ), mEncryption, valuesencryption );
  mEncryptionItem->setLabel( i18nd("libmailtransport5", "Encryption method used for communication") );
  addItem( mEncryptionItem, QStringLiteral( "encryption" ) );
  QList<KConfigSkeleton::ItemEnum::Choice> valuesauthenticationType;
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("LOGIN");
    valuesauthenticationType.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("PLAIN");
    valuesauthenticationType.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("CRAM_MD5");
    valuesauthenticationType.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("DIGEST_MD5");
    valuesauthenticationType.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("GSSAPI");
    valuesauthenticationType.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("NTLM");
    valuesauthenticationType.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("APOP");
    valuesauthenticationType.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("CLEAR");
    valuesauthenticationType.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("ANONYMOUS");
    valuesauthenticationType.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("XOAUTH2");
    valuesauthenticationType.append( choice );
  }
  mAuthenticationTypeItem = new KConfigSkeleton::ItemEnum( currentGroup(), QStringLiteral( "authtype" ), mAuthenticationType, valuesauthenticationType, EnumAuthenticationType::PLAIN );
  mAuthenticationTypeItem->setLabel( i18nd("libmailtransport5", "Authentication method") );
  addItem( mAuthenticationTypeItem, QStringLiteral( "authenticationType" ) );
  mSpecifyHostnameItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "specifyHostname" ), mSpecifyHostname, false );
  mSpecifyHostnameItem->setLabel( i18nd("libmailtransport5", "specifyHostname") );
  mSpecifyHostnameItem->setWhatsThis( i18nd("libmailtransport5", "Check this option to use a custom hostname when identifying to the mail server. This is useful when your system's hostname may not be set correctly or to mask your system's true hostname.") );
  addItem( mSpecifyHostnameItem, QStringLiteral( "specifyHostname" ) );
  mLocalHostnameItem = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "localHostname" ), mLocalHostname );
  mLocalHostnameItem->setLabel( i18nd("libmailtransport5", "localHostname") );
  mLocalHostnameItem->setWhatsThis( i18nd("libmailtransport5", "Enter the hostname that should be used when identifying to the server.") );
  addItem( mLocalHostnameItem, QStringLiteral( "localHostname" ) );
  mSpecifySenderOverwriteAddressItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "specifySenderOverwriteAddress" ), mSpecifySenderOverwriteAddress, false );
  mSpecifySenderOverwriteAddressItem->setLabel( i18nd("libmailtransport5", "specifySenderOverwriteAddress") );
  mSpecifySenderOverwriteAddressItem->setWhatsThis( i18nd("libmailtransport5", "Check this option to use a custom sender address when identifying to the mail server. If not checked, the address from the identity is used.") );
  addItem( mSpecifySenderOverwriteAddressItem, QStringLiteral( "specifySenderOverwriteAddress" ) );
  mSenderOverwriteAddressItem = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "senderOverwriteAddress" ), mSenderOverwriteAddress );
  mSenderOverwriteAddressItem->setLabel( i18nd("libmailtransport5", "senderOverwriteAddress") );
  mSenderOverwriteAddressItem->setWhatsThis( i18nd("libmailtransport5", "Enter the address that should be used to overwrite the default sender address.") );
  addItem( mSenderOverwriteAddressItem, QStringLiteral( "senderOverwriteAddress" ) );
  mUseProxyItem = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "useProxy" ), mUseProxy, false );
  mUseProxyItem->setLabel( i18nd("libmailtransport5", "Connect using the system proxy settings") );
  mUseProxyItem->setWhatsThis( i18nd("libmailtransport5", "If checked, the system proxy settings will be used to connect to the mail server.") );
  addItem( mUseProxyItem, QStringLiteral( "useProxy" ) );
}

TransportBase::~TransportBase()
{
}

