// This file is generated by kconfig_compiler_kf5 from colorcorrect_settings.kcfg.
// All changes you do to this file will be lost.

#include "colorcorrect_settings.h"

#include <qglobal.h>
#include <QFile>

#include <QDebug>

using namespace KWin::ColorCorrect;

namespace KWin {
namespace ColorCorrect {

class SettingsHelper
{
  public:
    SettingsHelper() : q(nullptr) {}
    ~SettingsHelper() { delete q; }
    SettingsHelper(const SettingsHelper&) = delete;
    SettingsHelper& operator=(const SettingsHelper&) = delete;
    Settings *q;
};
}
}

Q_GLOBAL_STATIC(SettingsHelper, s_globalSettings)
Settings *Settings::self()
{
  if (!s_globalSettings()->q)
     qFatal("you need to call Settings::instance before using");
  return s_globalSettings()->q;
}

void Settings::instance(const QString& cfgfilename)
{
  if (s_globalSettings()->q) {
     qDebug() << "Settings::instance called after the first use - ignoring";
     return;
  }
  new Settings(KSharedConfig::openConfig(cfgfilename));
  s_globalSettings()->q->read();
}

void Settings::instance(KSharedConfig::Ptr config)
{
  if (s_globalSettings()->q) {
     qDebug() << "Settings::instance called after the first use - ignoring";
     return;
  }
  new Settings(std::move(config));
  s_globalSettings()->q->read();
}

Settings::Settings( KSharedConfig::Ptr config )
  : KConfigSkeleton( std::move( config ) )
{
  Q_ASSERT(!s_globalSettings()->q);
  s_globalSettings()->q = this;
  setCurrentGroup( QStringLiteral( "NightColor" ) );

  KConfigSkeleton::ItemBool  *itemActiveEnabled;
  itemActiveEnabled = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "ActiveEnabled" ), mActiveEnabled, true );
  addItem( itemActiveEnabled, QStringLiteral( "ActiveEnabled" ) );
  KConfigSkeleton::ItemBool  *itemActive;
  itemActive = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "Active" ), mActive, false );
  addItem( itemActive, QStringLiteral( "Active" ) );
  KConfigSkeleton::ItemBool  *itemModeEnabled;
  itemModeEnabled = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "ModeEnabled" ), mModeEnabled, true );
  addItem( itemModeEnabled, QStringLiteral( "ModeEnabled" ) );
  QList<KConfigSkeleton::ItemEnum::Choice> valuesMode;
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Automatic");
    valuesMode.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Location");
    valuesMode.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Times");
    valuesMode.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Constant");
    valuesMode.append( choice );
  }
  KConfigSkeleton::ItemEnum  *itemMode;
  itemMode = new KConfigSkeleton::ItemEnum( currentGroup(), QStringLiteral( "Mode" ), mMode, valuesMode, NightColorMode::Automatic );
  addItem( itemMode, QStringLiteral( "Mode" ) );
  KConfigSkeleton::ItemBool  *itemNightTemperatureEnabled;
  itemNightTemperatureEnabled = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "NightTemperatureEnabled" ), mNightTemperatureEnabled, true );
  addItem( itemNightTemperatureEnabled, QStringLiteral( "NightTemperatureEnabled" ) );
  KConfigSkeleton::ItemInt  *itemNightTemperature;
  itemNightTemperature = new KConfigSkeleton::ItemInt( currentGroup(), QStringLiteral( "NightTemperature" ), mNightTemperature, 4500 );
  addItem( itemNightTemperature, QStringLiteral( "NightTemperature" ) );
  KConfigSkeleton::ItemDouble  *itemLatitudeAuto;
  itemLatitudeAuto = new KConfigSkeleton::ItemDouble( currentGroup(), QStringLiteral( "LatitudeAuto" ), mLatitudeAuto, 0. );
  addItem( itemLatitudeAuto, QStringLiteral( "LatitudeAuto" ) );
  KConfigSkeleton::ItemDouble  *itemLongitudeAuto;
  itemLongitudeAuto = new KConfigSkeleton::ItemDouble( currentGroup(), QStringLiteral( "LongitudeAuto" ), mLongitudeAuto, 0. );
  addItem( itemLongitudeAuto, QStringLiteral( "LongitudeAuto" ) );
  KConfigSkeleton::ItemBool  *itemLocationEnabled;
  itemLocationEnabled = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "LocationEnabled" ), mLocationEnabled, true );
  addItem( itemLocationEnabled, QStringLiteral( "LocationEnabled" ) );
  KConfigSkeleton::ItemDouble  *itemLatitudeFixed;
  itemLatitudeFixed = new KConfigSkeleton::ItemDouble( currentGroup(), QStringLiteral( "LatitudeFixed" ), mLatitudeFixed, 0. );
  addItem( itemLatitudeFixed, QStringLiteral( "LatitudeFixed" ) );
  KConfigSkeleton::ItemDouble  *itemLongitudeFixed;
  itemLongitudeFixed = new KConfigSkeleton::ItemDouble( currentGroup(), QStringLiteral( "LongitudeFixed" ), mLongitudeFixed, 0. );
  addItem( itemLongitudeFixed, QStringLiteral( "LongitudeFixed" ) );
  KConfigSkeleton::ItemString  *itemMorningBeginFixed;
  itemMorningBeginFixed = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "MorningBeginFixed" ), mMorningBeginFixed, QStringLiteral( "\"0600\"" ) );
  addItem( itemMorningBeginFixed, QStringLiteral( "MorningBeginFixed" ) );
  KConfigSkeleton::ItemString  *itemEveningBeginFixed;
  itemEveningBeginFixed = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "EveningBeginFixed" ), mEveningBeginFixed, QStringLiteral( "\"1800\"" ) );
  addItem( itemEveningBeginFixed, QStringLiteral( "EveningBeginFixed" ) );
  KConfigSkeleton::ItemInt  *itemTransitionTime;
  itemTransitionTime = new KConfigSkeleton::ItemInt( currentGroup(), QStringLiteral( "TransitionTime" ), mTransitionTime, 30 );
  addItem( itemTransitionTime, QStringLiteral( "TransitionTime" ) );
}

Settings::~Settings()
{
  s_globalSettings()->q = nullptr;
}

