#!/usr/bin/python
# -*- coding: utf8 -*-

# This file is part of the Chakra Project
#   Tool to read and modify the Akabei configuration file
#
#   Copyright (C) 2011 Lisa Vitolo <shainer@chakra-project.org>

#   This program is free software; you can redistribute it and/or
#   modify it under the terms of the GNU General Public
#   License as published by the Free Software Foundation; either
#   version 2 of the License, or (at your option) any later version.

import sys
from akabeigetopt import *
from configmanager import *

def performConfigOperation(operation, args):
    manager = ConfigManager("Akabei.conf")
    writeOp = True
    
    if operation == "--list":
        for item in manager.items():
            if len(item) == 1:
                print "[" + item[0] + "]"
            else:
                print "   " + item[0],
                if len(item[1]) > 0:
                    print "= " + item[1]
        writeOp = False
        
    elif operation == "--get":
        for value in manager.get(args[0], args[1]):
            print value
        writeOp = False
        
    elif operation == "--get-all":
        for opt in manager.sectionEntries(args[0]):
            print opt[0],
            if len(opt[1]) > 0:
                print "= " + opt[1]
        writeOp = False
        
    elif operation == "--add":
        manager.addOption(args[0], args[1], args[2])
    elif operation == "--replace":
        manager.replace(args[0], args[1], args[2], args[3])
    elif operation == "--replace-all":
        manager.replaceAll(args[0], args[1], args[2])
    elif operation == "--unset":
        manager.unset(args[0], args[1], args[2])
    elif operation == "--unset-all":
        manager.unsetAll(args[0], args[1])
    elif operation == "--add-section":
        manager.addSection(args[0])
    elif operation == "--remove-section":
        manager.removeSection(args[0])
    elif operation == "--rename-section":
        manager.renameSection(args[0], args[1])
    else:
        print "Operation not supported"
        
    if writeOp:
        manager.write()
        
def version():
    print ":: Akabei-config is part of the Akabei project. ::"
    print "Version: 0.0.1"
    
def usage():
    print "usage: " + sys.argv[0] + " <option> <parameters>"
    print
    
    print "Options:"
    print "    --help                                prints this message"
    print "    --version                             prints version information"
    print "    --list                                list all options"
    print "    --add <section> <key> <value>         adds a new option"
    print "    --get <section> <key>                 gets value associated with option"
    print "    --get-all <section>                   gets all options in <section>"
    print "    --replace <section> <key> <old> <new> replaces section.key=old with section.key=new"
    print "    --replace-all <section> <key> <new>   replaces all values of section.key with <new>"
    print "    --add-section <name>                  add a new section"
    print "    --remove-section <name>               deletes section and all its content"
    print "    --rename-section <old> <new>          changes name"
    print "    --unset <section> <key> <value>       deletes option"
    print "    --unset-all <section> <key>           deletes all occurrences"

if __name__ == "__main__":
    operation = None
    arguments = None
    
    optlist = {"--help":0, "--version":0, "--list":0, "--add":3, "--get":2, "--get-all":1, "--replace":4, "--replace-all":3, "--add-section":1, "--remove-section":1, "--rename-section":2, "--unset":3, "--unset-all":2}
    
    try:
        cmdLineParser = AkabeiGetopt(sys.argv, optlist)
        (operation, arguments) = cmdLineParser.parse()
    except CommandLineError as err:
        print err
        exit(-1)
    
    if operation == "--help":
        usage()
    elif operation == "--version":
        version()
    else:
        try:
            performConfigOperation(operation, arguments)
        except Exception as err:
            print str(err)
            
        