#!/usr/bin/python
# -*- coding: utf8 -*-

# This file is part of the Chakra Project
#   Parses a command line in the format "--operation <argument list>"
#
#   Copyright (C) 2011 Lisa Vitolo <shainer@chakra-project.org>

#   This program is free software; you can redistribute it and/or
#   modify it under the terms of the GNU General Public
#   License as published by the Free Software Foundation; either
#   version 2 of the License, or (at your option) any later version.

class CommandLineError(Exception):
    def __init__(self, value):
        self.value = value

    def __str__(self):
        return self.value

class AkabeiGetopt:
    
    def __init__(self, argv, optlist):
        self.argv = argv[1:]
        self.options = optlist

    def parse(self):
        # No option specified on command line
        if len(self.argv) == 0:
            return ("--help", self.argv)
        
        operation = self.argv[0]
        del self.argv[0]
        
        if operation not in self.options:
            raise CommandLineError("Unknown command: " + operation)
        
        if len(self.argv) != self.options[operation]:
            raise CommandLineError("Wrong number of arguments: expected " + str(self.options[operation]))
            
        return (operation, self.argv)
        
        