#!/usr/bin/python

# Classes representing objects that will go in the Akabei database
#
#   Copyright (C) 2011 Lisa Vitolo <shainer@chakra-project.org>

#   This program is free software; you can redistribute it and/or
#   modify it under the terms of the GNU General Public
#   License as published by the Free Software Foundation; either
#   version 2 of the License, or (at your option) any later version.
        
class AkabeiFile(object):
    def __init__(self, name, backup="", prefix=""):
        self.name = name
        self.backup = backup
        self.prefix = prefix
    
    def __str__(self):
        return self.name
        
class AkabeiPackage(object):
    def __init__(self):
        self.name = ""
        self.version = ""
        self.filename = ""
        self.description = ""
        self.size = 0
        self.installedsize = 0
        self.md5sum = ""
        self.url = ""
        self.builddate = 0
        self.arch = ""
        self.packager = ""
        self.flags = ""
        self.screenshoturl = ""
        self.installreason = 1 # by default, Explicitly Installed, as pacman doesn't specify anything in this case
        self.installdate = 0
        
        self.scriptlets = []
        self.dependencies = []
        self.conflicts = []
        self.provides = []
        self.optionals = []
        self.replaces = []
        self.mimetypes = []
        self.groups = []
        self.licenses = []
        
        self.files = []
        
    def addScriptlet(self, scriptlet):
        self.scriptlets.append(scriptlet)
    
    def addDependency(self, dep):
        self.dependencies.append(dep)
        
    def addConflict(self, c):
        self.conflicts.append(c)
        
    def addProvide(self, p):
        self.provides.append(p)
        
    def addOptional(self, opt):
        self.optionals.append(opt)
        
    def addReplace(self, rep):
        self.replaces.append(rep)
        
    def addMimeType(self, mime):
        self.mimetypes.append(mime)
        
    def addGroup(self, groupname):
        self.groups.append(groupname)
        
    def addLicense(self, license):
        self.licenses.append(license)
    
    def addFile(self, filename, backup=""):
        f = AkabeiFile(filename, backup)
        self.files.append(f)
   
    def __str__(self):
        return self.name + "-" + self.version
    